(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    101664,       2842]
NotebookOptionsPosition[     90080,       2437]
NotebookOutlinePosition[     91582,       2480]
CellTagsIndexPosition[     91446,       2474]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FresnelS" :> Documentation`HelpLookup["paclet:ref/FresnelS"], 
          "Erf" :> Documentation`HelpLookup["paclet:ref/Erf"], "CosIntegral" :> 
          Documentation`HelpLookup["paclet:ref/CosIntegral"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FresnelS\"\>", 2->"\<\"Erf\"\>", 
       3->"\<\"CosIntegral\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Functions Used in Optics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInOptics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Functions Used in Optics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FresnelC", "ObjectName",
 CellID->9873],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FresnelC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FresnelC"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Fresnel integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"C", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20835]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FresnelC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelC"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "z"], 
    RowBox[{
     RowBox[{"cos", "(", 
      RowBox[{"\[Pi]", 
       RowBox[{
        SuperscriptBox["t", "2"], "/", "2"}]}], ")"}], "d", 
     "\[InvisibleSpace]", "t"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->2356],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FresnelC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelC"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is an entire function of ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " with no branch cut discontinuities. "
}], "Notes",
 CellID->6874],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->422750854],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->315771875],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->587646390],

Cell["Evaluate numerically:", "ExampleText",
 CellID->12278145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", "1.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->935572671],

Cell[BoxData["0.3336329272215569`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160255262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->765524416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"FresnelC", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536484687],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNm0uoZkcRx0++13VeuU5ANBsNuhgQh8xExIWGEHyRxBhHmIgJGidjwsRk
MjGOG93oRhF0oxsDYhY+wMciIkSECGJADIgBMSAakBEkLgyCwUVAOP66f32q
+zvf+b4xwYCXO+d21+murvp3dVV195lbz1w8d8/5MxfvO3vmmvc9fOahc/ed
/fQ1773wMKT5FV3XXeLfl1/XUe4p5X+X+p6/D/OcUT0ftW6e3uaf7oFMvTdT
n3/+Xx8+/b1Hv/Wb7sD2VosvffEXP338D2fv/tGf/vj3V022uyc9ly+++O9b
bnqU58+fePYLn3+i29X2yV/++XOf/RnFF154kU672q6+/rVf/fAHv/OFUuzt
aH3hwZ88/du/+sKeu1ozNhL4QpmmW39iwOvUbd9OxdmovlrD3NZP/fovn7n4
eC7mR4zVLXeMgcCIXXvBAkaX6/XVrzz548eeqb0Csy297sjUZ37/N6YrFfdG
Y8kFljDezuUjmXrp0j9Qrc44JvXcc/+sXBjlvnOPXYbLAnEZSwNajdBd5Dov
3vOub27n86EB9aJT7rVgSplYrWI1KU+VdzHJ99Sg5Q3XPwKu9lp89M7vQ3rk
G0999ztPy1ezr3wrmos167glv0UcWCBqxRpRUVgplqE9a48V2DkGgzFkHaPO
87TsN2Yq6rFqqt0yEIxqHf4gi/zKskANKgyPEJmyDMwsFGmq1S1H9jItzdvS
8yBM++GHYZwtnswRUmaJ9pCAabGNLiIhI1LAxihpJpRWn+AMK62QRdci7Xgl
1fU5Le0b86twD4CYZTsU7oVhfMsUSOSZ0MntDiInrpUi0mE6ImUZ+VObWRLu
kHjQFRXEXDyYEolFT/2HmCfKDO7OX/QqmmibVVMqkLZrejC/chHQlrFnVLrj
DMfagciIEAEM8RnJSVZrqojIW6qaP1WsSwWYXxqgsVhREBJ0EXtYQZQtBY2M
4egbo3SzBOq+wqFITKS+kpdYZbxFckzHOairyKYiuTKiCYG9xYlBi+/QYhCo
4DSfxC1HzferKRIZS1lcIMB4EJ1tMMRGkZpBVRb1aWZVm3FoqjSzF+LCMwo0
oAv6UFAlejEiCAcHiHgHmgkjHZGHsShr7LFg9RtRjaUQCMSCNyqKWxtb9auD
Z2vx4dkl2mYkmMYv1OUJV6YQ/TAljYUn1oRcMEM5qgjOk2ZUoVOlvTPAEzq4
8tQMBR4t0YayaqklvTAE2uguFJZxZRgqurh0beF+fRXVcHyx8iIYoB3jil/g
4UTR3ZUNLsWvdl3kH2uReIxcjrQrhnL9MAI68Zzxp3stnJh13QlPhg1oNQ6q
SEeB7vSgDeKAE2UKgtHNeNm9BaaQ+IWjStEN2aiqtYpoGi4m4dUtS7FNYCIx
qr4NVCkEsDrw+Wg1JsBmQ6Fkmw1yTSaUqi1iNNbL8ERknrOk6pXiYxrjK8jo
gVWCIa+oUkCoGSB2R4BI9KDT2JUMgIhPL/1Lcu4zenRvgil/AUR/rpo20roE
RAfvW0NwrEJf2b0FKuK/S7l4vcg0iy8UvxrvAjtxbrEr2cUOq7sZoWIV0hwN
YItErkUjnTEOuu7PlsKOEmIVi9uJgI6siI7VRAHM6AVDFBU5VdK44KAPQK52
4YqKoGpBEQeiIIeIDBQMKyIYMaWNwE0cDQQL7l2OtHq92NvsXLsmPEZPBMEa
ZinUHUOPMAUUxUREzvgIb4SFbtChrEXTRU+gAbkChZ+CRk0bA6vqUnAUhuhm
wNEdGcUPkYnkggLD1/zG3mFrobY+UBw14z6yWBGx2xqOgl9wzJTwndM5y6vT
86TBSgEicYqEyhVgAfFoxlu1N3eXruvGmFxcgISqNDYwmSkghwmpRB2X2Nsd
dFE8r/ksL7x4kTyTdRigYMpiRUbd+iHkllY1n0/ZnZrX7G5WbGwvbE0YA8kN
lN7cT+awR/UefY78KogMyK/R0wy9nDizNma2SsigOSvry17ClV7mUsN0lZqN
R3DUGEoOGrlE4VNzL3eRdbc8rdk78ipyCfvDfMLR1vocJrn0xssAY2SAKTNB
rCT1aH+jW1DGtTzRtZ8z5Xl4hy2yvTs991rZ3CMnzvMBNbghVRk/3FKxBseP
wNgPKZrjx6raMv5NfVlla7aBKnBPmCwGhMErLfy85lYRj/th6TtaSLFltNsy
NRKbrNEsGczcTdhAy7OlzfeDjz44SGbTsHB3yqebuQTwImd4jz7vNdBBLhEd
t8h5e198eKFmbsvIyTQ490Jz7Xc7r4+lZzlbsO3hzC1ylNyq6x5sWhts1fXw
+tgTrcVKC7R1m33X1nclxJJTnrt8EjHrsGytd9QeRZOzrzvIsX657SLmZW1W
8rtloL3G3XeB3tq7C5lnzeLW6XWvsE6vfmKdHtqt0ZNGGptbkfO1R2tloYu8
quWsj1GtYKA/lDmpQzeiGvfG1AhshZp897zkr0mOa0v9RG4d6USuJ/rJUXuV
yz5yUWet27DTa0f1430f50eJ/1un2m9wTAfNV6S/kgqyww5vflkpjvFIDcYx
XGkidX9Z0rxMDBax1eLnuldk3ONlrpxTfXtX5nI2jPo/GaWtO1raAGr7J0bv
T/4Xow6Zxbz8HSSWV9r6yLult+01kE/1xfLXVqHUtKncpKZIuElN2UJLTVb0
bJG327gzuFx9fLL/Sr/fG2a/6PD/Jt/4feNZdrS66jL1WFElezv2EqW4HH+l
vH7bqOWc+97JXnEXZvpbYl1QS+Y9opbbmBG17PBGVLObhjpxD1fyjM2eKTvc
HAVRJyRK+fem9Cm/fWBD05SKjagmFyM5293EJ2v74jEU+/4NuoJv0s1RN+lm
k5t0dwmbdPPeTbr5+P0jDeodUaPBMuzAJCNvdNv8+I6ptiYeXc69Um7p+Vd3
51Rbk5HS1oPHFGKato0tphzlUO6PBEQGjyKTn5iUo+yc7TE6AZruUQKcPeJ4
Q+CrVyrSfHCKQwlZcohT4hKuPRv3kDDtVU5VDqvg0A9bGXPROG0plicPWiBo
Qnk5kuqmtXk18tVbjXxuvIwdY7nl8eRA5dXarAO4i6Q3b5HUqT4wyLB2x1t3
32Y72qlWKX+PBtJsuLcD6HIPKAdGLpntDVvG13wcv95O2rvuNR3fxd/srxdK
XM+T863SKqzbI5x0p5PHpV1sTOlJs7dXqRatVMlOlane6ylT3X+6e43jyPYs
YyFGGo0U16xoe8/nYX976hAnJkfQ3PPKfjjd6/MxBQrF6WbymcpUN1LHtqDs
QjowzFGzp42zlrojK8n8rJlzTbfVTS6e5yB6bEmSLeRz4oUSMyH8zhI0+57T
99mxxekSvJx0j41Rj8HzWVFyC0foIMn9C4LEOEpb4lm+tVuIjNMbFliwyR6q
u7vffmuz2sBNizwwmnk51zvv+YCCncq2R7TEyWWaKfuuz7AroY1TfwvyyrOQ
sLyOEu0o6uE90rG/F0D9cJ2IeXkGjXgezXtZ4+UbAhvomGzaex7tDTJSU/X8
Cp3pAh+PaWnsYS1weOzKK9TIXqc7s756um4jz5lv4Oq6FdfxidLIC6zaHbX+
ONNfEysvjst8G2f9xv84m/WtVp6tFPIsFU54xwGZJpTp7Xy5ELwQAUuP/1gv
FkAIm9SOPd73fJTZ9C4AnLy8t+oZFMw9knaWfHqV4NAM+pJwbaNrXyLL2pct
9XRh/OWO+AbeYX3iG3ErChp23ARoyHGw5Vs9XD4j5WU+17+Sgi95QvCslTGd
HU2RYek6ywflAOQRcjdLFxBXe5NLNztTdga8mfO63Psr70q95qSrF8deuXhv
2qUI8VLwnUcMDhhKBK8n+Z5YBu79kNHlfleHAbamGsYr18jdDHExRVqgxJTh
ZjyPUtKtaNLe7dJfLy/Rhe9Za77lSGnRYZAECi/rKXgNrEl6a5rWRPL0Cap9
P8oRRwpxtepkeOHsBCSxtqE63A6tJq01gCjvw5zKN0yR+fTNmV29QSj5T6Ze
FZEtYDaDGcVonauIDj7gKAUdfOuAAQp8GBWiUDqwXrKbpTB1xK+ZdL1mdXTw
Npmm3hXzNvubbj+uD5kmXbe3/94IxpcAjJymYLUD0xbLcV1sa6QX23o7p8XG
xyT9kIeJblh2yVjbTKCJZIf13K2fcDmH702WlNKUk+aJYAbAfruhwwABRvWD
K91ufOJhwYUBFN4BOkX6Vu/6vKNBU6EzkQJhuMXldHyKAkMNP3L5yAeG059p
JOv5qUjWLxVFMvYJ/ZBRt98tCUabPen/MuVKdQqTpeqa7IeNnq9SFpsOuF7f
57REp6bH8IpAhBTLaNLnzw1shlRqoD+IqB53gOkWNiUc+5oMOHkN6EeF2omr
yE8nQTrt5UVxY5/Xr0dyURt9sbcKFPtheypq2pVv2+zZWYhbLcpxpzg3hGYf
2RdvHFmDN+lm1objfkjt9NggYIhkIoavBdMCT8agnrqa7g07tF3/Irb1bObX
sfq06eLfnP36ZVs+ifBzmy7u8/xmqtRNnnMGs2F7fqY23hWcmJR6+svcGuWU
Ojxt8QVKrZNsLH3uFzeR9869wq87w3p9884d0tTRlWb0dd8y4mQ521EaK2oi
HyAtUcR63QXcGKOn1e4utmb2469t80yWGMSKiHtpHVUKqR/Yqk2KVsupdbCI
rJTnckCn5Gi37kCn7jgWo7p8248WTu/gsx5jk5xxMlIs7fYdveNb9w309gZd
ikVNyxAnB2Wm5Vp3AXft6DXafTfWu6tX9dZhmyVz+/iOXqNvhppZrL1qxBh9
19GMOT2G97ntLajr+MyO1u2tpja5o/XGl8B372g7/v8L0221MqUwd9jRrvwP
i5TFn51stfOkeK1Nd8V/ADq5SjQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28400647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->796775053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"FresnelC", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48207159],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "4"], " ", 
     SuperscriptBox["x", "9"]}], "3456"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "6"], " ", 
     SuperscriptBox["x", "13"]}], "599040"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "8"], " ", 
     SuperscriptBox["x", "17"]}], "175472640"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "21"],
    SeriesData[$CellContext`x, 0, {}, 1, 21, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, 0, 0, Rational[-1, 40] Pi^2, 0, 0, 0, Rational[1, 3456] Pi^4, 0, 0, 
    0, Rational[-1, 599040] Pi^6, 0, 0, 0, Rational[1, 175472640] Pi^8}, 1, 
   21, 1],
  Editable->False]], "Output",
 ImageSize->{299, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169246609]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12711],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->31201039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->603935662],

Cell[BoxData[
 RowBox[{"116.64806138055191`", "\[InvisibleSpace]", "-", 
  RowBox[{"105.22873567055956`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->879902827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59279681],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->74928546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"FresnelC", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->913938607],

Cell[BoxData["0.\
4882534060753407545002235033572610376883671545092153831501366430016`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598143714]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10376565],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->11294894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", "2.0000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133681800],

Cell[BoxData["0.48825340607534075450022349822378901492`21.865027532877104"], \
"Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30856479]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353839069],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->63722940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131227650],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->760102494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->592277009],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->277138917]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16883179],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->49190353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->604106045],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"FresnelC", "[", "x", "]"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472889988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240258647],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->150069123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", 
  RowBox[{"{", 
   RowBox[{"1.5", ",", "2.5", ",", "3.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347938929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4452611760398217`", ",", "0.457413009641777`", ",", 
   "0.5325724350280007`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202011975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->449388290],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->787098452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FresnelC", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411261881],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["C",
    FresnelC], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->116353585]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->418],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->324086099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37002436],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 2], 
    Rational[1, 9]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{116, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->302452541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105456625],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->240933630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"FresnelC", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211138692],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["x", "2"]}], "2"], "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["1", "x"], ")"}], "3"]}], 
          SuperscriptBox["\[Pi]", "2"]]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 3, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {(-2) Pi^(-2)}, 3, 4, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox["2", 
         RowBox[{"\[Pi]", " ", "x"}]], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 1, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {2/Pi}, 1, 4, 1],
       Editable->False], ")"}], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["x", "2"]}], "2"], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{398, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265210526]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1707],

Cell["\<\
Intensity of a wave diffracted by a half\[Hyphen]plane:\
\>", "ExampleText",
 CellID->90945511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"FresnelS", "[", "d", "]"}], "+", 
       RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"FresnelC", "[", "d", "]"}], "+", 
       RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15661468],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137123550]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35275606],

Cell["Plot a Cornu spiral:", "ExampleText",
 CellID->1120003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FresnelC", "[", "x", "]"}], ",", 
     RowBox[{"FresnelS", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370981878],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22064023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91091274],

Cell["\<\
A solution of the time\[Hyphen]dependent 1D Schr\[ODoubleDot]dinger equation \
for a sudden opening of a shutter: \
\>", "ExampleText",
 CellID->724306501],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{"x_", ",", "t_"}], "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", 
      RowBox[{"(", 
       RowBox[{"t", "-", 
        RowBox[{"2", " ", "x"}]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"FresnelS", "[", 
        FractionBox[
         RowBox[{" ", 
          RowBox[{"t", "-", "x"}]}], 
         RowBox[{
          SqrtBox["\[Pi]"], " ", 
          SqrtBox["t"]}]], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"FresnelC", "[", 
        FractionBox[
         RowBox[{" ", 
          RowBox[{"t", "-", "x"}]}], 
         RowBox[{
          SqrtBox["\[Pi]"], " ", 
          SqrtBox["t"]}]], "]"}]}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347292373],

Cell["\<\
Check the Schr\[ODoubleDot]dinger equation: \
\>", "ExampleText",
 CellID->166675350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"I", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "==", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}]}], "//", 
  "Expand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171626692],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15329380]
}, Open  ]],

Cell["\<\
Plot the time\[Hyphen]dependent solution: \
\>", "ExampleText",
 CellID->28055406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->267368978],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->240167382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->395103876],

Cell[TextData[{
 "Plot of ",
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " along a circle in the complex plane:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->60806666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "#", "]"}], ",", 
       RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "@", 
    RowBox[{"FresnelC", "[", 
     RowBox[{"2", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8793162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->821893728]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22855],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing Fresnel integrals:"
}], "ExampleText",
 CellID->335706385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FresnelC", "[", "z", "]"}], "-", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", "4"], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["5", "4"]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["z", "4"]}], "16"]}]}], "]"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486404805],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
   RowBox[{"FresnelC", "[", "z", "]"}]}], "z"]], "Output",
 ImageSize->{137, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->642055701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42723560],

Cell["Find a numerical root:", "ExampleText",
 CellID->982939488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FresnelC", "[", "z", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "Pi"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221740352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.3191255916655199`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79864854]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65039457],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " from integrals and sums:"
}], "ExampleText",
 CellID->148659088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "2"}], " ", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379613708],

Cell[BoxData[
 RowBox[{"FresnelC", "[", "z", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->754798097]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "k"}], "-", "1"}]], " ", 
      SuperscriptBox["\[Pi]", 
       RowBox[{
        RowBox[{"2", " ", "k"}], "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         SuperscriptBox["z", "4"]}], ")"}], "k"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "k"}], "+", "1"}], ")"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "k"}], "+", "1"}], ")"}], "!"}]}]]}], "//", 
   "FunctionExpand"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62479455],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[Pi]", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"FresnelC", "[", "z", "]"}]}], "z"], "-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["z", "2"]}], "2"], "]"}]}], 
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["z", "2"]}]]}], ")"}]}]], "Output",
 ImageSize->{219, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->309848475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24526459],

Cell["Solve a differential equation:", "ExampleText",
 CellID->305241292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       RowBox[{"w", "'''"}], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{"w", "''"}], "[", "z", "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{
       RowBox[{"w", "'"}], "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",", "w", 
   ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235302344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "3", "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"FresnelC", "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"FresnelS", "[", "z", "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240878098]
}, Open  ]],

Cell["Calculate the Wronskian:", "ExampleText",
 CellID->49045743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"#1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"FresnelC", "[", "x", "]"}], ",", 
      RowBox[{"FresnelS", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->201947920],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox["x", "2"]}], "2"], "]"}], "2"]}], "+", 
  RowBox[{"\[Pi]", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox["x", "2"]}], "2"], "]"}], "2"]}]}]], "Output",
 ImageSize->{195, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149022713]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->564962411],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", "x"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->243709376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281677184],

Cell["Integrals:", "ExampleText",
 CellID->119454445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["z", "\[Alpha]"], 
   RowBox[{"FresnelC", "[", 
    SuperscriptBox["z", "\[Beta]"], "]"}], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366365202],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]], 
  RowBox[{
   SuperscriptBox["\[Pi]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
      RowBox[{"2", " ", "\[Beta]"}]]}]], " ", 
   SuperscriptBox["z", 
    RowBox[{"1", "+", "\[Alpha]"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox["z", 
      RowBox[{"4", " ", "\[Beta]"}]], ")"}], 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
      RowBox[{"2", " ", "\[Beta]"}]]}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["\[Pi]", 
       FractionBox[
        RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
        RowBox[{"2", " ", "\[Beta]"}]]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["z", 
         RowBox[{"4", " ", "\[Beta]"}]], ")"}], 
       FractionBox[
        RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
        RowBox[{"2", " ", "\[Beta]"}]]], " ", 
      RowBox[{"FresnelC", "[", 
       SuperscriptBox["z", "\[Beta]"], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["2", 
       FractionBox[
        RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
        RowBox[{"2", " ", "\[Beta]"}]]], " ", 
      SuperscriptBox["z", "\[Beta]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"\[ImaginaryI]", " ", 
            SuperscriptBox["z", 
             RowBox[{"2", " ", "\[Beta]"}]]}], ")"}], 
          FractionBox[
           RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
           RowBox[{"2", " ", "\[Beta]"}]]], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
            RowBox[{"2", " ", "\[Beta]"}]], ",", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ",
             
            SuperscriptBox["z", 
             RowBox[{"2", " ", "\[Beta]"}]]}]}], "]"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SuperscriptBox["z", 
             RowBox[{"2", " ", "\[Beta]"}]]}], ")"}], 
          FractionBox[
           RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
           RowBox[{"2", " ", "\[Beta]"}]]], " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "+", "\[Alpha]", "+", "\[Beta]"}], 
            RowBox[{"2", " ", "\[Beta]"}]], ",", 
           RowBox[{
            FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
            SuperscriptBox["z", 
             RowBox[{"2", " ", "\[Beta]"}]]}]}], "]"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{573, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298284403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->614546650],

Cell["Integral transforms:", "ExampleText",
 CellID->588402994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"FresnelC", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->71974209],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox[
       SuperscriptBox["s", "2"], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}], "+", 
     RowBox[{"Sin", "[", 
      FractionBox[
       SuperscriptBox["s", "2"], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "s"}]]], "Output",
 ImageSize->{150, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->302414286]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"FresnelC", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->160274003],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"3", " ", 
    RowBox[{"Cos", "[", 
     FractionBox[
      SuperscriptBox["s", "2"], 
      RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["s", "3"], " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["5", "4"], ",", 
         FractionBox["7", "4"]}], "}"}], ",", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["s", "4"], 
         RowBox[{"16", " ", 
          SuperscriptBox["\[Pi]", "2"]}]]}]}], "]"}]}], 
    SuperscriptBox["\[Pi]", "2"]], "-", 
   RowBox[{"3", " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      SuperscriptBox["s", "2"], 
      RowBox[{"2", " ", "\[Pi]"}]], "]"}]}]}], 
  RowBox[{"6", " ", "s"}]]], "Output",
 ImageSize->{364, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46220219]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelC"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->609476226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelC", "[", 
  RowBox[{"1000.", 
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77612080],

Cell[BoxData[
 RowBox[{"1.797347476926630275378688869`15.954589770191005*^1364372", "+", 
  RowBox[{
  "1.797347476926630275378688869`15.954589770191005*^1364372", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{394, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->735802793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87499180],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->588218341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FresnelC", "[", 
     RowBox[{"10", "^", "20"}], "]"}], "-", 
    RowBox[{"1", "/", "2"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437692997],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-\\(\\(1\\/2\\)\\)\\)\\) + \
\\(\\(FresnelC[100000000000000000000]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->59319879],

Cell[BoxData["0``50."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149112281]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"FresnelC", "[", 
       RowBox[{"10", "^", "20"}], " ", "]"}], "-", 
      RowBox[{"1", "/", "2"}]}], ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532610049],

Cell[BoxData[
 RowBox[{"-", 
  "1.01321183642337771443879463209727639`20.000000000000007*^-61"}]], "Output",\

 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126868987]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16522],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FresnelS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CosIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CosIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22774],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->30763]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->13792],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/FresnelIntegrals.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/FresnelC/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FresnelC"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->343628501],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->799556813],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "MoreAbout",
 CellID->409941879]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FresnelC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 25.7206376}", "context" -> "System`", 
    "keywords" -> {
     "Cornu spiral", "Fresnel functions", "Fresnel diffraction", 
      "Fresnel integral", "Fresnel integral C"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FresnelC[z] gives the Fresnel integral C(z). ", 
    "synonyms" -> {"Fresnel C"}, "title" -> "FresnelC", "type" -> "Symbol", 
    "uri" -> "ref/FresnelC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5621, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->315771875]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[60021, 1492, 271, 9, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->60806666]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 91149, 2463},
 {"XRef-2005-4-26-23-37-1.8558342", 91306, 2467}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2136, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2759, 78, 45, 1, 70, "ObjectName",
 CellID->9873],
Cell[2807, 81, 585, 19, 70, "Usage",
 CellID->20835]
}, Open  ]],
Cell[CellGroupData[{
Cell[3429, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3907, 122, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4030, 128, 533, 20, 70, "Notes",
 CellID->2356],
Cell[4566, 150, 342, 12, 70, "Notes",
 CellID->6874],
Cell[4911, 164, 248, 8, 70, "Notes",
 CellID->422750854],
Cell[5162, 174, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5383, 183, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5621, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->315771875],
Cell[CellGroupData[{
Cell[6006, 209, 148, 5, 70, "ExampleSection",
 CellID->587646390],
Cell[6157, 216, 63, 1, 70, "ExampleText",
 CellID->12278145],
Cell[CellGroupData[{
Cell[6245, 221, 106, 3, 28, "Input",
 CellID->935572671],
Cell[6354, 226, 176, 5, 36, "Output",
 CellID->160255262]
}, Open  ]],
Cell[6545, 234, 125, 3, 70, "ExampleDelimiter",
 CellID->765524416],
Cell[CellGroupData[{
Cell[6695, 241, 241, 8, 28, "Input",
 CellID->536484687],
Cell[6939, 251, 5120, 88, 158, "Output",
 Evaluatable->False,
 CellID->28400647]
}, Open  ]],
Cell[12074, 342, 125, 3, 70, "ExampleDelimiter",
 CellID->796775053],
Cell[CellGroupData[{
Cell[12224, 349, 220, 7, 70, "Input",
 CellID->48207159],
Cell[12447, 358, 1052, 33, 54, "Output",
 CellID->169246609]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13548, 397, 216, 7, 70, "ExampleSection",
 CellID->12711],
Cell[13767, 406, 73, 1, 70, "ExampleText",
 CellID->31201039],
Cell[CellGroupData[{
Cell[13865, 411, 129, 4, 70, "Input",
 CellID->603935662],
Cell[13997, 417, 273, 7, 36, "Output",
 CellID->879902827]
}, Open  ]],
Cell[14285, 427, 124, 3, 70, "ExampleDelimiter",
 CellID->59279681],
Cell[14412, 432, 69, 1, 70, "ExampleText",
 CellID->74928546],
Cell[CellGroupData[{
Cell[14506, 437, 157, 5, 70, "Input",
 CellID->913938607],
Cell[14666, 444, 235, 7, 36, "Output",
 CellID->598143714]
}, Open  ]],
Cell[14916, 454, 124, 3, 70, "ExampleDelimiter",
 CellID->10376565],
Cell[15043, 459, 112, 3, 70, "ExampleText",
 CellID->11294894],
Cell[CellGroupData[{
Cell[15180, 466, 127, 3, 70, "Input",
 CellID->133681800],
Cell[15310, 471, 218, 6, 36, "Output",
 CellID->30856479]
}, Open  ]],
Cell[15543, 480, 125, 3, 70, "ExampleDelimiter",
 CellID->353839069],
Cell[15671, 485, 90, 1, 70, "ExampleText",
 CellID->63722940],
Cell[CellGroupData[{
Cell[15786, 490, 104, 3, 70, "Input",
 CellID->131227650],
Cell[15893, 495, 158, 5, 36, "Output",
 CellID->760102494]
}, Open  ]],
Cell[CellGroupData[{
Cell[16088, 505, 111, 3, 70, "Input",
 CellID->592277009],
Cell[16202, 510, 178, 6, 51, "Output",
 CellID->277138917]
}, Open  ]],
Cell[16395, 519, 124, 3, 70, "ExampleDelimiter",
 CellID->16883179],
Cell[16522, 524, 89, 1, 70, "ExampleText",
 CellID->49190353],
Cell[CellGroupData[{
Cell[16636, 529, 122, 4, 70, "Input",
 CellID->604106045],
Cell[16761, 535, 210, 7, 36, "Output",
 CellID->472889988]
}, Open  ]],
Cell[16986, 545, 125, 3, 70, "ExampleDelimiter",
 CellID->240258647],
Cell[17114, 550, 210, 7, 70, "ExampleText",
 CellID->150069123],
Cell[CellGroupData[{
Cell[17349, 561, 167, 5, 70, "Input",
 CellID->347938929],
Cell[17519, 568, 274, 9, 36, "Output",
 CellID->202011975]
}, Open  ]],
Cell[17808, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->449388290],
Cell[17936, 585, 203, 7, 70, "ExampleText",
 CellID->787098452],
Cell[CellGroupData[{
Cell[18164, 596, 142, 4, 70, "Input",
 CellID->411261881],
Cell[18309, 602, 257, 9, 50, "Output",
 CellID->116353585]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18615, 617, 237, 7, 70, "ExampleSection",
 CellID->418],
Cell[18855, 626, 209, 7, 70, "ExampleText",
 CellID->324086099],
Cell[CellGroupData[{
Cell[19089, 637, 297, 10, 70, "Input",
 CellID->37002436],
Cell[19389, 649, 576, 20, 54, "Output",
 CellID->302452541]
}, Open  ]],
Cell[19980, 672, 125, 3, 70, "ExampleDelimiter",
 CellID->105456625],
Cell[20108, 677, 78, 1, 70, "ExampleText",
 CellID->240933630],
Cell[CellGroupData[{
Cell[20211, 682, 227, 7, 70, "Input",
 CellID->211138692],
Cell[20441, 691, 1673, 54, 67, "Output",
 CellID->265210526]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22163, 751, 222, 7, 70, "ExampleSection",
 CellID->1707],
Cell[22388, 760, 105, 3, 70, "ExampleText",
 CellID->90945511],
Cell[CellGroupData[{
Cell[22518, 767, 528, 18, 70, "Input",
 CellID->15661468],
Cell[23049, 787, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->137123550]
}, Open  ]],
Cell[26144, 845, 124, 3, 70, "ExampleDelimiter",
 CellID->35275606],
Cell[26271, 850, 61, 1, 70, "ExampleText",
 CellID->1120003],
Cell[CellGroupData[{
Cell[26357, 855, 338, 11, 70, "Input",
 CellID->370981878],
Cell[26698, 868, 6295, 107, 70, "Output",
 Evaluatable->False,
 CellID->22064023]
}, Open  ]],
Cell[33008, 978, 124, 3, 70, "ExampleDelimiter",
 CellID->91091274],
Cell[33135, 983, 165, 4, 70, "ExampleText",
 CellID->724306501],
Cell[33303, 989, 1090, 37, 70, "Input",
 CellID->347292373],
Cell[34396, 1028, 95, 3, 70, "ExampleText",
 CellID->166675350],
Cell[CellGroupData[{
Cell[34516, 1035, 464, 17, 70, "Input",
 CellID->171626692],
Cell[34983, 1054, 160, 5, 36, "Output",
 CellID->15329380]
}, Open  ]],
Cell[35158, 1062, 92, 3, 70, "ExampleText",
 CellID->28055406],
Cell[CellGroupData[{
Cell[35275, 1069, 366, 12, 70, "Input",
 CellID->267368978],
Cell[35644, 1083, 24234, 401, 70, "Output",
 Evaluatable->False,
 CellID->240167382]
}, Open  ]],
Cell[59893, 1487, 125, 3, 70, "ExampleDelimiter",
 CellID->395103876],
Cell[60021, 1492, 271, 9, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->60806666],
Cell[CellGroupData[{
Cell[60317, 1505, 522, 17, 70, "Input",
 CellID->8793162],
Cell[60842, 1524, 9741, 164, 70, "Output",
 Evaluatable->False,
 CellID->821893728]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70632, 1694, 233, 7, 70, "ExampleSection",
 CellID->22855],
Cell[70868, 1703, 248, 8, 70, "ExampleText",
 CellID->335706385],
Cell[CellGroupData[{
Cell[71141, 1715, 541, 19, 70, "Input",
 CellID->486404805],
Cell[71685, 1736, 308, 11, 51, "Output",
 CellID->642055701]
}, Open  ]],
Cell[72008, 1750, 124, 3, 70, "ExampleDelimiter",
 CellID->42723560],
Cell[72135, 1755, 65, 1, 70, "ExampleText",
 CellID->982939488],
Cell[CellGroupData[{
Cell[72225, 1760, 270, 9, 70, "Input",
 CellID->221740352],
Cell[72498, 1771, 226, 7, 36, "Output",
 CellID->79864854]
}, Open  ]],
Cell[72739, 1781, 124, 3, 70, "ExampleDelimiter",
 CellID->65039457],
Cell[72866, 1786, 214, 8, 70, "ExampleText",
 CellID->148659088],
Cell[CellGroupData[{
Cell[73105, 1798, 296, 10, 70, "Input",
 CellID->379613708],
Cell[73404, 1810, 192, 6, 36, "Output",
 CellID->754798097]
}, Open  ]],
Cell[CellGroupData[{
Cell[73633, 1821, 810, 29, 70, "Input",
 CellID->62479455],
Cell[74446, 1852, 582, 20, 72, "Output",
 CellID->309848475]
}, Open  ]],
Cell[75043, 1875, 124, 3, 70, "ExampleDelimiter",
 CellID->24526459],
Cell[75170, 1880, 73, 1, 70, "ExampleText",
 CellID->305241292],
Cell[CellGroupData[{
Cell[75268, 1885, 493, 17, 70, "Input",
 CellID->235302344],
Cell[75764, 1904, 603, 20, 36, "Output",
 CellID->240878098]
}, Open  ]],
Cell[76382, 1927, 66, 1, 70, "ExampleText",
 CellID->49045743],
Cell[CellGroupData[{
Cell[76473, 1932, 502, 16, 70, "Input",
 CellID->201947920],
Cell[76978, 1950, 537, 18, 55, "Output",
 CellID->149022713]
}, Open  ]],
Cell[CellGroupData[{
Cell[77552, 1973, 104, 3, 70, "Input",
 CellID->564962411],
Cell[77659, 1978, 184, 6, 36, "Output",
 CellID->243709376]
}, Open  ]],
Cell[77858, 1987, 125, 3, 70, "ExampleDelimiter",
 CellID->281677184],
Cell[77986, 1992, 53, 1, 70, "ExampleText",
 CellID->119454445],
Cell[CellGroupData[{
Cell[78064, 1997, 254, 8, 70, "Input",
 CellID->366365202],
Cell[78321, 2007, 3060, 90, 89, "Output",
 CellID->298284403]
}, Open  ]],
Cell[81396, 2100, 125, 3, 70, "ExampleDelimiter",
 CellID->614546650],
Cell[81524, 2105, 63, 1, 70, "ExampleText",
 CellID->588402994],
Cell[CellGroupData[{
Cell[81612, 2110, 182, 6, 70, "Input",
 CellID->71974209],
Cell[81797, 2118, 566, 20, 67, "Output",
 CellID->302414286]
}, Open  ]],
Cell[CellGroupData[{
Cell[82400, 2143, 183, 6, 70, "Input",
 CellID->160274003],
Cell[82586, 2151, 999, 34, 77, "Output",
 CellID->46220219]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83634, 2191, 226, 7, 70, "ExampleSection",
 CellID->10693],
Cell[83863, 2200, 236, 7, 70, "ExampleText",
 CellID->609476226],
Cell[CellGroupData[{
Cell[84124, 2211, 174, 6, 70, "Input",
 CellID->77612080],
Cell[84301, 2219, 335, 9, 36, "Output",
 CellID->735802793]
}, Open  ]],
Cell[84651, 2231, 124, 3, 70, "ExampleDelimiter",
 CellID->87499180],
Cell[84778, 2236, 246, 8, 70, "ExampleText",
 CellID->588218341],
Cell[CellGroupData[{
Cell[85049, 2248, 235, 8, 70, "Input",
 CellID->437692997],
Cell[85287, 2258, 492, 9, 70, "Message",
 CellID->59319879],
Cell[85782, 2269, 163, 5, 36, "Output",
 CellID->149112281]
}, Open  ]],
Cell[CellGroupData[{
Cell[85982, 2279, 374, 12, 70, "Input",
 CellID->532610049],
Cell[86359, 2293, 241, 8, 36, "Output",
 CellID->126868987]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86661, 2308, 311, 9, 70, "SeeAlsoSection",
 CellID->16522],
Cell[86975, 2319, 692, 26, 70, "SeeAlso",
 CellID->21241]
}, Open  ]],
Cell[CellGroupData[{
Cell[87704, 2350, 314, 9, 70, "TutorialsSection",
 CellID->22774],
Cell[88021, 2361, 144, 3, 70, "Tutorials",
 CellID->30763]
}, Open  ]],
Cell[CellGroupData[{
Cell[88202, 2369, 321, 9, 70, "RelatedLinksSection",
 CellID->13792],
Cell[88526, 2380, 187, 4, 70, "RelatedLinks"],
Cell[88716, 2386, 193, 4, 70, "RelatedLinks"],
Cell[88912, 2392, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89335, 2410, 319, 9, 70, "MoreAboutSection",
 CellID->343628501],
Cell[89657, 2421, 191, 4, 70, "MoreAbout",
 CellID->799556813],
Cell[89851, 2427, 157, 3, 70, "MoreAbout",
 CellID->409941879]
}, Open  ]],
Cell[90023, 2433, 27, 0, 70, "History"],
Cell[90053, 2435, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

