(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106254,       2999]
NotebookOptionsPosition[     94572,       2590]
NotebookOutlinePosition[     96074,       2633]
CellTagsIndexPosition[     95938,       2627]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FresnelC" :> Documentation`HelpLookup["paclet:ref/FresnelC"], 
          "Erf" :> Documentation`HelpLookup["paclet:ref/Erf"], "SinIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinIntegral"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FresnelC\"\>", 2->"\<\"Erf\"\>", 
       3->"\<\"SinIntegral\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Functions Used in Optics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInOptics"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Functions Used in Optics\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FresnelS", "ObjectName",
 CellID->2121],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FresnelS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FresnelS"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Fresnel integral ",
     Cell[BoxData[
      FormBox[
       RowBox[{"S", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28179]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FresnelS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelS"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", "0", "z"], 
    RowBox[{
     RowBox[{"sin", "(", 
      RowBox[{"\[Pi]", 
       RowBox[{
        SuperscriptBox["t", "2"], "/", "2"}]}], ")"}], "d", 
     "\[InvisibleSpace]", "t"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30295],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FresnelS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelS"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is an entire function of ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " with no branch cut discontinuities. "
}], "Notes",
 CellID->1128],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->276248868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->600916390],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->139906071],

Cell["Evaluate numerically:", "ExampleText",
 CellID->12278145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", "1.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->935572671],

Cell[BoxData["0.4509387692675823`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79338142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->765524416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536484687],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166423148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->796775053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48207159],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["x", "3"]}], "6"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "3"], " ", 
     SuperscriptBox["x", "7"]}], "336"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "5"], " ", 
     SuperscriptBox["x", "11"]}], "42240"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "7"], " ", 
     SuperscriptBox["x", "15"]}], "9676800"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "9"], " ", 
     SuperscriptBox["x", "19"]}], "3530096640"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "21"],
    SeriesData[$CellContext`x, 0, {}, 3, 21, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Rational[1, 6] Pi, 0, 0, 0, Rational[-1, 336] Pi^3, 0, 0, 0, 
    Rational[1, 42240] Pi^5, 0, 0, 0, Rational[-1, 9676800] Pi^7, 0, 0, 0, 
    Rational[1, 3530096640] Pi^9}, 3, 21, 1],
  Editable->False]], "Output",
 ImageSize->{346, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77823337]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1791],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->31201039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->603935662],

Cell[BoxData[
 RowBox[{"105.72873498286873`", "\[InvisibleSpace]", "+", 
  RowBox[{"116.14801684869198`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162805283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59279681],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->74928546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->913938607],

Cell[BoxData["0.\
3434156783636982421953008159580684568865418122025247676119246161507`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173117539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10376565],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->11294894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", "2.0000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133681800],

Cell[BoxData["0.34341567836369824219530077372217344307`21.762179001718966"], \
"Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152538893]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353839069],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->63722940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131227650],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465650703]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->592277009],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->79617184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16883179],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->49190353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->604106045],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"FresnelS", "[", "x", "]"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54388772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240258647],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->150069123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", 
  RowBox[{"{", 
   RowBox[{"1.5", ",", "2.5", ",", "3.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347938929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6975049600820931`", ",", "0.6191817558195929`", ",", 
   "0.4152480119724375`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385745389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26236470],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->229760727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FresnelS", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181589125],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["S",
    FresnelS], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->637659039]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28395],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->324086099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37002436],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["x", "3"]}], "6"], "+", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["x", "4"]}], "4"], "+", 
   FractionBox[
    RowBox[{"13", " ", "\[Pi]", " ", 
     SuperscriptBox["x", "5"]}], "72"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 3, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Rational[1, 6] Pi, Rational[1, 4] Pi, Rational[13, 72] Pi}, 3, 6, 1],
  Editable->False]], "Output",
 ImageSize->{176, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->622341135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105456625],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->240933630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211138692],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["x", "2"]}], "2"], "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox["2", 
          RowBox[{"\[Pi]", " ", "x"}]]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 1, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {(-2)/Pi}, 1, 4, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["1", "x"], ")"}], "3"]}], 
          SuperscriptBox["\[Pi]", "2"]]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 3, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {(-2) Pi^(-2)}, 3, 4, 1],
       Editable->False], ")"}], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["x", "2"]}], "2"], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{406, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72527695]
}, Open  ]],

Cell[TextData[{
 "Give the result for an arbitrary symbolic direction ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->520422507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"DirectedInfinity", "[", "z", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36219345],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
      RowBox[{"Floor", "[", 
       FractionBox[
        RowBox[{"\[Pi]", "-", 
         RowBox[{"4", " ", 
          RowBox[{"Arg", "[", "z", "]"}]}]}], 
        RowBox[{"2", " ", "\[Pi]"}]], "]"}]}]], "+", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["x", "2"]}], "2"], "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox["2", 
          RowBox[{"\[Pi]", " ", "x"}]]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "2"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[$CellContext`z], {}, 1, 2, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[$CellContext`z], {(-2)/Pi}, 1, 2, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"-", 
         FractionBox[
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             FractionBox["1", "x"], ")"}], "3"]}], 
          SuperscriptBox["\[Pi]", "2"]]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[$CellContext`z], {}, 3, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[$CellContext`z], {(-2) Pi^(-2)}, 3, 4, 1],
       Editable->False], ")"}], " ", 
     RowBox[{"Sin", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["x", "2"]}], "2"], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{517, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->396615003]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15030],

Cell["\<\
Intensity of a wave diffracted by a half\[Hyphen]plane:\
\>", "ExampleText",
 CellID->90945511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"FresnelS", "[", "d", "]"}], "+", 
       RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"FresnelC", "[", "d", "]"}], "+", 
       RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15661468],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63946327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35275606],

Cell["Plot a Cornu spiral:", "ExampleText",
 CellID->1120003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FresnelC", "[", "x", "]"}], ",", 
     RowBox[{"FresnelS", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->370981878],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87032461]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91091274],

Cell["\<\
A solution of the time\[Hyphen]dependent 1D Schr\[ODoubleDot]dinger equation \
for a sudden opening of a shutter: \
\>", "ExampleText",
 CellID->724306501],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{"x_", ",", "t_"}], "]"}], "=", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], " ", "\[ImaginaryI]", 
      RowBox[{"(", 
       RowBox[{"t", "-", 
        RowBox[{"2", " ", "x"}]}], ")"}]}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"FresnelS", "[", 
        FractionBox[
         RowBox[{" ", 
          RowBox[{"t", "-", "x"}]}], 
         SqrtBox[
          RowBox[{"\[Pi]", " ", "t"}]]], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[ImaginaryI]"}], ")"}], " ", 
       RowBox[{"FresnelC", "[", 
        FractionBox[
         RowBox[{" ", 
          RowBox[{"t", "-", "x"}]}], 
         SqrtBox[
          RowBox[{"\[Pi]", " ", "t"}]]], "]"}]}]}], ")"}]}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->347292373],

Cell["\<\
Check the Schr\[ODoubleDot]dinger equation: \
\>", "ExampleText",
 CellID->166675350],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"I", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], "==", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}]}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171626692],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->197798655]
}, Open  ]],

Cell["\<\
Plot the time\[Hyphen]dependent solution: \
\>", "ExampleText",
 CellID->28055406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->267368978],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->784388065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->395103876],

Cell[TextData[{
 "Plot of ",
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " along a circle in the complex plane:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->60806666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Re", "[", "#", "]"}], ",", 
       RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "@", 
    RowBox[{"FresnelS", "[", 
     RowBox[{"2", " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", "\[CurlyPhi]"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[CurlyPhi]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8793162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273631039]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12115],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing Fresnel integrals:"
}], "ExampleText",
 CellID->335706385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FresnelS", "[", "z", "]"}], "-", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["3", "4"], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox["7", "4"]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["z", "4"]}], "16"]}]}], "]"}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->486404805],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "-", 
    FractionBox["6", 
     RowBox[{"\[Pi]", " ", 
      SuperscriptBox["z", "3"]}]]}], ")"}], " ", 
  RowBox[{"FresnelS", "[", "z", "]"}]}]], "Output",
 ImageSize->{146, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->761109485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42723560],

Cell["Find a numerical root:", "ExampleText",
 CellID->982939488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"FresnelS", "[", "z", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "Pi"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221740352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.8773033165215581`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->850910674]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65039457],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " from integrals and sums:"
}], "ExampleText",
 CellID->148659088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "2"}], " ", 
     RowBox[{"t", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379613708],

Cell[BoxData[
 RowBox[{"FresnelS", "[", "z", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70065549]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["z", "3"], " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]"], 
    FractionBox[
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "k"}], "-", "1"}]], " ", 
      SuperscriptBox["\[Pi]", 
       RowBox[{
        RowBox[{"2", " ", "k"}], "+", "1"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         SuperscriptBox["z", "4"]}], ")"}], "k"]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "k"}], "+", "3"}], ")"}], " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "k"}], "+", "1"}], ")"}], "!"}]}]]}]}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62479455],

Cell[BoxData[
 RowBox[{"FresnelS", "[", "z", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->313374041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24526459],

Cell["Solve a differential equation:", "ExampleText",
 CellID->305241292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["w", 
        TagBox[
         RowBox[{"(", "3", ")"}],
         Derivative],
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{
      SuperscriptBox["w", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "z", "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["z", "3"], " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",",
    "w", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235302344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "3", "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"FresnelC", "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"FresnelS", "[", "z", "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127772534]
}, Open  ]],

Cell["Calculate the Wronskian:", "ExampleText",
 CellID->49045743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"#1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", " ", 
      RowBox[{"FresnelC", "[", "x", "]"}], ",", 
      RowBox[{"FresnelS", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->201947920],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Pi]", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox["x", "2"]}], "2"], "]"}], "2"]}], "+", 
  RowBox[{"\[Pi]", " ", "x", " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"\[Pi]", " ", 
       SuperscriptBox["x", "2"]}], "2"], "]"}], "2"]}]}]], "Output",
 ImageSize->{195, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104900026]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->564962411],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", "x"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->361046663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281677184],

Cell["Integrals:", "ExampleText",
 CellID->119454445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", 
    SuperscriptBox["z", "\[Beta]"], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366365202],

Cell[BoxData[
 RowBox[{"z", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"FresnelS", "[", 
     SuperscriptBox["z", "\[Beta]"], "]"}], "+", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         FractionBox["1", "\[Beta]"]}], ")"}]}]], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"1", "+", "\[Beta]"}], 
        RowBox[{"2", " ", "\[Beta]"}]]}]], " ", 
     SuperscriptBox["z", 
      RowBox[{"-", "\[Beta]"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox["z", 
         RowBox[{"2", " ", "\[Beta]"}]]}], ")"}], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Beta]"}], 
       RowBox[{"2", " ", "\[Beta]"}]]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"1", "+", "\[Beta]"}], 
        RowBox[{"2", " ", "\[Beta]"}]], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        SuperscriptBox["z", 
         RowBox[{"2", " ", "\[Beta]"}]]}]}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         FractionBox["1", "\[Beta]"]}], ")"}]}]], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"1", "+", "\[Beta]"}], 
        RowBox[{"2", " ", "\[Beta]"}]]}]], " ", 
     SuperscriptBox["z", 
      RowBox[{"-", "\[Beta]"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["z", 
         RowBox[{"2", " ", "\[Beta]"}]]}], ")"}], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "\[Beta]"}], 
       RowBox[{"2", " ", "\[Beta]"}]]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"1", "+", "\[Beta]"}], 
        RowBox[{"2", " ", "\[Beta]"}]], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        SuperscriptBox["z", 
         RowBox[{"2", " ", "\[Beta]"}]]}]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{468, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218369657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->614546650],

Cell["Integral transforms:", "ExampleText",
 CellID->588402994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->71974209],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Cos", "[", 
      FractionBox[
       SuperscriptBox["s", "2"], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}], "-", 
     RowBox[{"Sin", "[", 
      FractionBox[
       SuperscriptBox["s", "2"], 
       RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "s"}]]], "Output",
 ImageSize->{150, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456778306]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"FresnelS", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->160274003],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "s", " ", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["3", "4"], ",", 
        FractionBox["5", "4"]}], "}"}], ",", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["s", "4"], 
        RowBox[{"16", " ", 
         SuperscriptBox["\[Pi]", "2"]}]]}]}], "]"}]}], "+", 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cos", "[", 
       FractionBox[
        SuperscriptBox["s", "2"], 
        RowBox[{"2", " ", "\[Pi]"}]], "]"}], "+", 
      RowBox[{"Sin", "[", 
       FractionBox[
        SuperscriptBox["s", "2"], 
        RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], ")"}]}]}], 
  RowBox[{"2", " ", "\[Pi]", " ", "s"}]]], "Output",
 ImageSize->{448, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59965000]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FresnelS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FresnelS"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->609476226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FresnelS", "[", 
  RowBox[{"1000.", 
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77612080],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.797347476926630275378688869`15.954589770191005*^1364372"}], 
  "+", 
  RowBox[{
  "1.797347476926630275378688869`15.954589770191005*^1364372", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263998153]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9260],

Cell["Nested integrals:", "ExampleText",
 CellID->352016453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"FresnelS", "[", "x", "]"}], ",", "4"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353471694],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     TagBox["S",
      FresnelS], "(", "x", ")"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"cos", "(", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["x", "2"]}], "2"], ")"}], "\[Pi]"], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       TagBox["S",
        FresnelS], "(", "x", ")"}]}]}], ",", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{
       TagBox["S",
        FresnelS], "(", "x", ")"}], " ", 
      SuperscriptBox["x", "2"]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"cos", "(", 
        FractionBox[
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["x", "2"]}], "2"], ")"}], " ", "x"}], 
      RowBox[{"2", " ", "\[Pi]"}]], "+", 
     FractionBox[
      RowBox[{
       TagBox["C",
        FresnelC], "(", "x", ")"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], ",", 
    FractionBox[
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], " ", "\[Pi]", " ", 
       RowBox[{
        TagBox["S",
         FresnelS], "(", "x", ")"}], " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"cos", "(", 
        FractionBox[
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["x", "2"]}], "2"], ")"}], " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{
       RowBox[{
        TagBox["C",
         FresnelC], "(", "x", ")"}], " ", "x"}], "-", 
      FractionBox[
       RowBox[{"2", " ", 
        RowBox[{"sin", "(", 
         FractionBox[
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox["x", "2"]}], "2"], ")"}]}], 
       RowBox[{"3", " ", "\[Pi]"}]]}], 
     RowBox[{"2", " ", "\[Pi]"}]], ",", 
    FractionBox[
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       RowBox[{
        TagBox["S",
         FresnelS], "(", "x", ")"}], " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[Pi]", " ", 
       RowBox[{"cos", "(", 
        FractionBox[
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["x", "2"]}], "2"], ")"}], " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{
       FractionBox["3", "2"], " ", "\[Pi]", " ", 
       RowBox[{
        TagBox["C",
         FresnelC], "(", "x", ")"}], " ", 
       SuperscriptBox["x", "2"]}], "-", 
      RowBox[{
       FractionBox["5", "4"], " ", 
       RowBox[{"sin", "(", 
        FractionBox[
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox["x", "2"]}], "2"], ")"}], " ", "x"}], "-", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{
         TagBox["S",
          FresnelS], "(", "x", ")"}]}], "4"]}], 
     RowBox[{"6", " ", 
      SuperscriptBox["\[Pi]", "2"]}]]}], "}"}], TraditionalForm]], "Output",
 ImageSize->{544, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->83143361]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16427],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FresnelC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SinIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11009]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26280],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->22590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16749],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/FresnelIntegrals.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/FresnelS/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FresnelS"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->186100482],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->208323814],

Cell[TextData[ButtonBox["Functions Used in Optics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInOptics"]], "MoreAbout",
 CellID->201658525],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->350727216]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FresnelS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 26.6112854}", "context" -> "System`", 
    "keywords" -> {
     "Cornu spiral", "Fresnel functions", "Fresnel diffraction", 
      "Fresnel integral", "Fresnel integral S"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FresnelS[z] gives the Fresnel integral S(z). ", 
    "synonyms" -> {"Fresnel S"}, "title" -> "FresnelS", "type" -> "Symbol", 
    "uri" -> "ref/FresnelS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5765, 198, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->600916390]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[63451, 1598, 271, 9, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->60806666]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 95641, 2616},
 {"XRef-2005-4-26-23-37-1.8558342", 95798, 2620}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2279, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2902, 81, 45, 1, 70, "ObjectName",
 CellID->2121],
Cell[2950, 84, 585, 19, 70, "Usage",
 CellID->28179]
}, Open  ]],
Cell[CellGroupData[{
Cell[3572, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4050, 125, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4173, 131, 534, 20, 70, "Notes",
 CellID->30295],
Cell[4710, 153, 342, 12, 70, "Notes",
 CellID->1128],
Cell[5055, 167, 248, 8, 70, "Notes",
 CellID->276248868],
Cell[5306, 177, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5527, 186, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5765, 198, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->600916390],
Cell[CellGroupData[{
Cell[6150, 212, 148, 5, 70, "ExampleSection",
 CellID->139906071],
Cell[6301, 219, 63, 1, 70, "ExampleText",
 CellID->12278145],
Cell[CellGroupData[{
Cell[6389, 224, 106, 3, 28, "Input",
 CellID->935572671],
Cell[6498, 229, 175, 5, 36, "Output",
 CellID->79338142]
}, Open  ]],
Cell[6688, 237, 125, 3, 70, "ExampleDelimiter",
 CellID->765524416],
Cell[CellGroupData[{
Cell[6838, 244, 241, 8, 28, "Input",
 CellID->536484687],
Cell[7082, 254, 5385, 92, 158, "Output",
 Evaluatable->False,
 CellID->166423148]
}, Open  ]],
Cell[12482, 349, 125, 3, 70, "ExampleDelimiter",
 CellID->796775053],
Cell[CellGroupData[{
Cell[12632, 356, 220, 7, 70, "Input",
 CellID->48207159],
Cell[12855, 365, 1155, 36, 54, "Output",
 CellID->77823337]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14059, 407, 215, 7, 70, "ExampleSection",
 CellID->1791],
Cell[14277, 416, 73, 1, 70, "ExampleText",
 CellID->31201039],
Cell[CellGroupData[{
Cell[14375, 421, 129, 4, 70, "Input",
 CellID->603935662],
Cell[14507, 427, 273, 7, 36, "Output",
 CellID->162805283]
}, Open  ]],
Cell[14795, 437, 124, 3, 70, "ExampleDelimiter",
 CellID->59279681],
Cell[14922, 442, 69, 1, 70, "ExampleText",
 CellID->74928546],
Cell[CellGroupData[{
Cell[15016, 447, 157, 5, 70, "Input",
 CellID->913938607],
Cell[15176, 454, 235, 7, 36, "Output",
 CellID->173117539]
}, Open  ]],
Cell[15426, 464, 124, 3, 70, "ExampleDelimiter",
 CellID->10376565],
Cell[15553, 469, 112, 3, 70, "ExampleText",
 CellID->11294894],
Cell[CellGroupData[{
Cell[15690, 476, 127, 3, 70, "Input",
 CellID->133681800],
Cell[15820, 481, 219, 6, 36, "Output",
 CellID->152538893]
}, Open  ]],
Cell[16054, 490, 125, 3, 70, "ExampleDelimiter",
 CellID->353839069],
Cell[16182, 495, 90, 1, 70, "ExampleText",
 CellID->63722940],
Cell[CellGroupData[{
Cell[16297, 500, 104, 3, 70, "Input",
 CellID->131227650],
Cell[16404, 505, 158, 5, 36, "Output",
 CellID->465650703]
}, Open  ]],
Cell[CellGroupData[{
Cell[16599, 515, 111, 3, 70, "Input",
 CellID->592277009],
Cell[16713, 520, 177, 6, 51, "Output",
 CellID->79617184]
}, Open  ]],
Cell[16905, 529, 124, 3, 70, "ExampleDelimiter",
 CellID->16883179],
Cell[17032, 534, 89, 1, 70, "ExampleText",
 CellID->49190353],
Cell[CellGroupData[{
Cell[17146, 539, 122, 4, 70, "Input",
 CellID->604106045],
Cell[17271, 545, 209, 7, 36, "Output",
 CellID->54388772]
}, Open  ]],
Cell[17495, 555, 125, 3, 70, "ExampleDelimiter",
 CellID->240258647],
Cell[17623, 560, 210, 7, 70, "ExampleText",
 CellID->150069123],
Cell[CellGroupData[{
Cell[17858, 571, 167, 5, 70, "Input",
 CellID->347938929],
Cell[18028, 578, 275, 9, 36, "Output",
 CellID->385745389]
}, Open  ]],
Cell[18318, 590, 124, 3, 70, "ExampleDelimiter",
 CellID->26236470],
Cell[18445, 595, 203, 7, 70, "ExampleText",
 CellID->229760727],
Cell[CellGroupData[{
Cell[18673, 606, 142, 4, 70, "Input",
 CellID->181589125],
Cell[18818, 612, 257, 9, 50, "Output",
 CellID->637659039]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19124, 627, 239, 7, 70, "ExampleSection",
 CellID->28395],
Cell[19366, 636, 209, 7, 70, "ExampleText",
 CellID->324086099],
Cell[CellGroupData[{
Cell[19600, 647, 297, 10, 70, "Input",
 CellID->37002436],
Cell[19900, 659, 744, 24, 54, "Output",
 CellID->622341135]
}, Open  ]],
Cell[20659, 686, 125, 3, 70, "ExampleDelimiter",
 CellID->105456625],
Cell[20787, 691, 78, 1, 70, "ExampleText",
 CellID->240933630],
Cell[CellGroupData[{
Cell[20890, 696, 227, 7, 70, "Input",
 CellID->211138692],
Cell[21120, 705, 1701, 55, 67, "Output",
 CellID->72527695]
}, Open  ]],
Cell[22836, 763, 180, 6, 70, "ExampleText",
 CellID->520422507],
Cell[CellGroupData[{
Cell[23041, 773, 268, 9, 70, "Input",
 CellID->36219345],
Cell[23312, 784, 2077, 64, 67, "Output",
 CellID->396615003]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25438, 854, 223, 7, 70, "ExampleSection",
 CellID->15030],
Cell[25664, 863, 105, 3, 70, "ExampleText",
 CellID->90945511],
Cell[CellGroupData[{
Cell[25794, 870, 518, 18, 70, "Input",
 CellID->15661468],
Cell[26315, 890, 3079, 55, 70, "Output",
 Evaluatable->False,
 CellID->63946327]
}, Open  ]],
Cell[29409, 948, 124, 3, 70, "ExampleDelimiter",
 CellID->35275606],
Cell[29536, 953, 61, 1, 70, "ExampleText",
 CellID->1120003],
Cell[CellGroupData[{
Cell[29622, 958, 338, 11, 70, "Input",
 CellID->370981878],
Cell[29963, 971, 6295, 107, 70, "Output",
 Evaluatable->False,
 CellID->87032461]
}, Open  ]],
Cell[36273, 1081, 124, 3, 70, "ExampleDelimiter",
 CellID->91091274],
Cell[36400, 1086, 165, 4, 70, "ExampleText",
 CellID->724306501],
Cell[36568, 1092, 1052, 36, 70, "Input",
 CellID->347292373],
Cell[37623, 1130, 95, 3, 70, "ExampleText",
 CellID->166675350],
Cell[CellGroupData[{
Cell[37743, 1137, 466, 17, 70, "Input",
 CellID->171626692],
Cell[38212, 1156, 161, 5, 36, "Output",
 CellID->197798655]
}, Open  ]],
Cell[38388, 1164, 92, 3, 70, "ExampleText",
 CellID->28055406],
Cell[CellGroupData[{
Cell[38505, 1171, 366, 12, 70, "Input",
 CellID->267368978],
Cell[38874, 1185, 24434, 405, 70, "Output",
 Evaluatable->False,
 CellID->784388065]
}, Open  ]],
Cell[63323, 1593, 125, 3, 70, "ExampleDelimiter",
 CellID->395103876],
Cell[63451, 1598, 271, 9, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->60806666],
Cell[CellGroupData[{
Cell[63747, 1611, 522, 17, 70, "Input",
 CellID->8793162],
Cell[64272, 1630, 9729, 164, 70, "Output",
 Evaluatable->False,
 CellID->273631039]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74050, 1800, 233, 7, 70, "ExampleSection",
 CellID->12115],
Cell[74286, 1809, 248, 8, 70, "ExampleText",
 CellID->335706385],
Cell[CellGroupData[{
Cell[74559, 1821, 541, 19, 70, "Input",
 CellID->486404805],
Cell[75103, 1842, 344, 12, 53, "Output",
 CellID->761109485]
}, Open  ]],
Cell[75462, 1857, 124, 3, 70, "ExampleDelimiter",
 CellID->42723560],
Cell[75589, 1862, 65, 1, 70, "ExampleText",
 CellID->982939488],
Cell[CellGroupData[{
Cell[75679, 1867, 275, 9, 70, "Input",
 CellID->221740352],
Cell[75957, 1878, 227, 7, 36, "Output",
 CellID->850910674]
}, Open  ]],
Cell[76199, 1888, 124, 3, 70, "ExampleDelimiter",
 CellID->65039457],
Cell[76326, 1893, 214, 8, 70, "ExampleText",
 CellID->148659088],
Cell[CellGroupData[{
Cell[76565, 1905, 296, 10, 70, "Input",
 CellID->379613708],
Cell[76864, 1917, 191, 6, 36, "Output",
 CellID->70065549]
}, Open  ]],
Cell[CellGroupData[{
Cell[77092, 1928, 839, 30, 70, "Input",
 CellID->62479455],
Cell[77934, 1960, 192, 6, 36, "Output",
 CellID->313374041]
}, Open  ]],
Cell[78141, 1969, 124, 3, 70, "ExampleDelimiter",
 CellID->24526459],
Cell[78268, 1974, 73, 1, 70, "ExampleText",
 CellID->305241292],
Cell[CellGroupData[{
Cell[78366, 1979, 696, 23, 70, "Input",
 CellID->235302344],
Cell[79065, 2004, 603, 20, 36, "Output",
 CellID->127772534]
}, Open  ]],
Cell[79683, 2027, 66, 1, 70, "ExampleText",
 CellID->49045743],
Cell[CellGroupData[{
Cell[79774, 2032, 507, 16, 70, "Input",
 CellID->201947920],
Cell[80284, 2050, 537, 18, 55, "Output",
 CellID->104900026]
}, Open  ]],
Cell[CellGroupData[{
Cell[80858, 2073, 104, 3, 70, "Input",
 CellID->564962411],
Cell[80965, 2078, 184, 6, 36, "Output",
 CellID->361046663]
}, Open  ]],
Cell[81164, 2087, 125, 3, 70, "ExampleDelimiter",
 CellID->281677184],
Cell[81292, 2092, 53, 1, 70, "ExampleText",
 CellID->119454445],
Cell[CellGroupData[{
Cell[81370, 2097, 196, 6, 70, "Input",
 CellID->366365202],
Cell[81569, 2105, 2451, 78, 89, "Output",
 CellID->218369657]
}, Open  ]],
Cell[84035, 2186, 125, 3, 70, "ExampleDelimiter",
 CellID->614546650],
Cell[84163, 2191, 63, 1, 70, "ExampleText",
 CellID->588402994],
Cell[CellGroupData[{
Cell[84251, 2196, 182, 6, 70, "Input",
 CellID->71974209],
Cell[84436, 2204, 566, 20, 67, "Output",
 CellID->456778306]
}, Open  ]],
Cell[CellGroupData[{
Cell[85039, 2229, 183, 6, 70, "Input",
 CellID->160274003],
Cell[85225, 2237, 978, 33, 65, "Output",
 CellID->59965000]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86252, 2276, 226, 7, 70, "ExampleSection",
 CellID->22365],
Cell[86481, 2285, 236, 7, 70, "ExampleText",
 CellID->609476226],
Cell[CellGroupData[{
Cell[86742, 2296, 174, 6, 70, "Input",
 CellID->77612080],
Cell[86919, 2304, 356, 11, 36, "Output",
 CellID->263998153]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[87324, 2321, 223, 7, 70, "ExampleSection",
 CellID->9260],
Cell[87550, 2330, 60, 1, 70, "ExampleText",
 CellID->352016453],
Cell[CellGroupData[{
Cell[87635, 2335, 302, 10, 70, "Input",
 CellID->353471694],
Cell[87940, 2347, 3004, 102, 153, "Output",
 CellID->83143361]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91005, 2456, 311, 9, 70, "SeeAlsoSection",
 CellID->16427],
Cell[91319, 2467, 692, 26, 70, "SeeAlso",
 CellID->11009]
}, Open  ]],
Cell[CellGroupData[{
Cell[92048, 2498, 314, 9, 70, "TutorialsSection",
 CellID->26280],
Cell[92365, 2509, 144, 3, 70, "Tutorials",
 CellID->22590]
}, Open  ]],
Cell[CellGroupData[{
Cell[92546, 2517, 321, 9, 70, "RelatedLinksSection",
 CellID->16749],
Cell[92870, 2528, 187, 4, 70, "RelatedLinks"],
Cell[93060, 2534, 193, 4, 70, "RelatedLinks"],
Cell[93256, 2540, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93679, 2558, 319, 9, 70, "MoreAboutSection",
 CellID->186100482],
Cell[94001, 2569, 191, 4, 70, "MoreAbout",
 CellID->208323814],
Cell[94195, 2575, 157, 3, 70, "MoreAbout",
 CellID->201658525],
Cell[94355, 2580, 145, 3, 70, "MoreAbout",
 CellID->350727216]
}, Open  ]],
Cell[94515, 2586, 27, 0, 70, "History"],
Cell[94545, 2588, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

