(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24304,        810]
NotebookOptionsPosition[     20262,        673]
NotebookOutlinePosition[     21627,        711]
CellTagsIndexPosition[     21542,        706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Frobenius Equations and Computing Frobenius Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/Frobenius"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Solving Frobenius Equations and Computing Frobenius \
Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrobeniusNumber" :> 
          Documentation`HelpLookup["paclet:ref/FrobeniusNumber"], 
          "IntegerPartitions" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPartitions"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "ExtendedGCD" :> 
          Documentation`HelpLookup["paclet:ref/ExtendedGCD"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FrobeniusNumber\"\>", 
       2->"\<\"IntegerPartitions\"\>", 3->"\<\"Reduce\"\>", 
       4->"\<\"FindInstance\"\>", 
       5->"\<\"ExtendedGCD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Diophantine Equations\"\>", 
       2->"\<\"Integer Functions\"\>", 
       3->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       4->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FrobeniusSolve", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrobeniusSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrobeniusSolve"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of all solutions of the Frobenius \
equation ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{
          SubscriptBox["a", "1"], 
          SubscriptBox["x", "1"]}], "+", "\[Ellipsis]", "+", 
         RowBox[{
          SubscriptBox["a", "n"], 
          SubscriptBox["x", "n"]}]}], "=", "b"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrobeniusSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrobeniusSolve"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["n", "TI"]]}], "}"}], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives at most ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " solutions."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14079]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Frobenius equation is the Diophantine equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["a", "1"], 
      SubscriptBox["x", "1"]}], "+", "\[Ellipsis]", "+", 
     RowBox[{
      SubscriptBox["a", "n"], 
      SubscriptBox["x", "n"]}]}], "=", "b"}], TraditionalForm]], 
  "InlineMath"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are positive integers, ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " is an integer, and a solution ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["x", "n"]}], TraditionalForm]], "InlineMath"],
 " must consist of non-negative integers. For negative ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " there are no solutions."
}], "Notes",
 CellID->315]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313292417],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->384964384],

Cell[TextData[{
 "All solutions of the Frobenius equation",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"12", "x"}], "+", 
     RowBox[{"16", "y"}], "+", 
     RowBox[{"20", "z"}], "+", 
     RowBox[{"27", "t"}]}], "=", "123"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->30704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1240841197]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->23184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", 
  RowBox[{"{", 
   RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "123", ",", "123", ",", "123", ",", "123", ",", "123", ",", "123", ",", 
   "123", ",", "123"}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->604301962]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5101],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " may also be used to find the solutions to the Frobenius equation:"
}], "ExampleText",
 CellID->6888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"12", 
        SubscriptBox["x", "1"]}], "+", 
       RowBox[{"16", 
        SubscriptBox["x", "2"]}], "+", 
       RowBox[{"20", 
        SubscriptBox["x", "3"]}], "+", 
       RowBox[{"27", 
        SubscriptBox["x", "4"]}]}], "==", "123"}], ",", 
     RowBox[{
      SubscriptBox["x", "1"], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      SubscriptBox["x", "2"], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      SubscriptBox["x", "3"], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      SubscriptBox["x", "4"], "\[GreaterEqual]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "1"], ",", 
     SubscriptBox["x", "2"], ",", 
     SubscriptBox["x", "3"], ",", 
     SubscriptBox["x", "4"]}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21919],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm8lu2zAQQBVrcbdT7KTZmuUb6iz3Au2pH2EEBZJD0SLNF7cfoooiGdOj
kYaURhTlKIBDcdFwOENR5MPo+/r54cfP9fPj/fry29P698Pj/Z/Lr7+eiqJ4
L4r2/kZR9OUoKq7z4qr8ib9/xU9eyqsP4n+sa/MoK/6lRXZVpKL4ukhnRXqr
8seg/VuQT4h6Sv4JaH9QavmekLoC+VuQvwZ5OIo3xChgfdf+4SiX5SjflV2/
lCrLzFQag3sWymJzVS8blNUv95hlMSFvX3kmC0SeSIUxtBzokznhs7mTNZfK
mlyj70uerbdnOW7NRY01F5sZaJTOtm2I3JcqvWSF/svKKtP2ojStSIsrJVnL
HuET2q6vFEhJeuzL9LC2Gd1Xq6eAwaNz1KNJjx7l7NHOr3iPNt6taUN6l3p7
4k+lXivgqA6Rdno8G01maKlep0wNRPkB4qsQZKYqhbK6Ph91tl2gcyNhsMbS
s2QXa2sr6xTOMLf5mqhU2Lz6LMC7oGzMc5in7N4PWRDSsXb9vwPs/NGwGrLZ
bbg+KA/pZ8rOQ+3W8eq7+CTf7PIo7bbvPMVaDCyBf69ymm921W66lScu55lm
K4fSp7o/OCPuMGZM7RkGO8Waq3UK2sNT57zn9rwntuNayzfpxHkXHH8C7qLm
v/QpZBkXIH8D8pAdwDw8KbqyjAt0rJ8dSimNJN2ApOk8lyfSlbLeDUgpkkTV
i3HFSjuYYvIlaRKXkJG5X4VO1Sj55cq789SN6l9aYVgqF5o8v1TuUGmrV9rX
RuUoaxoztHHfFCq14+zRjvFw9jguggdX86qcid25+JV6h7Z7dn2yPZxpcRC+
jwzaDkH4Mu39juM/wnw9OprXbQYPSfvwVZ6X+bUdwWtnfvA9BPdU46d9XLu2
U8NXlPbbd9ZTDzc57TXwwwLpnUKzlmd5vd+b7/TFAR3mUu2pCvYB3wOQfh2h
Y6Pon2sv/dJCc/5pzzRp8wnpzT8htPM2XEHPUV04CZ4rqbkC1vepi7QRRhvj
yJ4GuhK4KyVnxSRfjkJcTjRyopEbK7jRSO6YvgPlwZRJ3rhiBDWl4xp9X/Js
rRk2jeSJsrPrCzvDTtGDU/Sgi193nUAuEbtzEMhMl7/CqMI+bOojYjNzkBkS
dew3CtAHddzFSEO4jvHyRr/Sx0saXUeB8LDqe9RJxhgiEDFO5KYjvwRqRg9D
HbtED0YRzRvDik505Ydd28N2fkjjJcibTEP4bPyxiu3porD6Xb6hgCIdKpbR
J12Eq8/Y6GJZT/a663RRWgGcTXOaN8VRuF8gd6WV0xfImLyhYh2NGdq4Q7Pj
Q7v9hTIPz5wYo78ed5Ux4k9tHQ/brx9fgFSsC70cIrpx+n65K3tsns3NlCtk
OuiDb4ZMIKdvnf0xSdt9HGcMo8sz4Ydt8u+SOL9wTlqNMZSYSJuzbLsYR99M
k/fE2eFbaKMP6ivzYSIjcYqDR0Y2UUqsvh9qCYnOykpXV12kXeAqYEZDYtyS
i1feqBSyulbyy4wNkYz2/gO1RjMv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{482, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63697906]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrobeniusSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFormula"],
 " returns the same solution set:"
}], "ExampleText",
 CellID->15156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"12", ",", "16", ",", "20", ",", "27"}], "}"}], ",", "123"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->970782217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51078507],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrobeniusSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFormula"],
 " gives coefficient lists for ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->536202180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "20"}], "}"}], ",", "24"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32961858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1503454860]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"24", ",", "All", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527297470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1273241418]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32218],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrobeniusNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrobeniusNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExtendedGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtendedGCD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28694]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4405],

Cell[TextData[ButtonBox["Solving Frobenius Equations and Computing Frobenius \
Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Frobenius"]], "Tutorials",
 CellID->13674]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->463818319],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->288131385],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->428592081],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->79214377],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->66814900]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrobeniusSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 27.6894380}", "context" -> "System`", 
    "keywords" -> {"coin problem"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrobeniusSolve[{a_1, ..., a_n}, b] gives a list of all solutions of the \
Frobenius equation a_1 x_1 + ... + a_n x_n = b. FrobeniusSolve[{a_1, ..., \
a_n}, b, m] gives at most m solutions.", "synonyms" -> {"frobenius solve"}, 
    "title" -> "FrobeniusSolve", "type" -> "Symbol", "uri" -> 
    "ref/FrobeniusSolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8408, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->313292417]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21399, 699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2866, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3489, 92, 1579, 37, 70, "ObjectNameGrid"],
Cell[5071, 131, 1867, 61, 70, "Usage",
 CellID->14079]
}, Open  ]],
Cell[CellGroupData[{
Cell[6975, 197, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7453, 214, 918, 32, 70, "Notes",
 CellID->315]
}, Closed]],
Cell[CellGroupData[{
Cell[8408, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313292417],
Cell[CellGroupData[{
Cell[8793, 265, 148, 5, 70, "ExampleSection",
 CellID->384964384],
Cell[8944, 272, 328, 13, 70, "ExampleText",
 CellID->30704],
Cell[CellGroupData[{
Cell[9297, 289, 207, 7, 28, "Input",
 CellID->29200],
Cell[9507, 298, 817, 23, 54, "Output",
 CellID->1240841197]
}, Open  ]],
Cell[10339, 324, 45, 1, 70, "ExampleText",
 CellID->23184],
Cell[CellGroupData[{
Cell[10409, 329, 159, 5, 28, "Input",
 CellID->22054],
Cell[10571, 336, 287, 9, 36, "Output",
 CellID->604301962]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10907, 351, 232, 7, 70, "ExampleSection",
 CellID->5101],
Cell[11142, 360, 234, 7, 70, "ExampleText",
 CellID->6888],
Cell[CellGroupData[{
Cell[11401, 371, 934, 30, 70, "Input",
 CellID->21919],
Cell[12338, 403, 1764, 33, 70, "Output",
 Evaluatable->False,
 CellID->63697906]
}, Open  ]],
Cell[14117, 439, 216, 7, 70, "ExampleText",
 CellID->15156],
Cell[CellGroupData[{
Cell[14358, 450, 206, 7, 70, "Input",
 CellID->8993],
Cell[14567, 459, 816, 23, 54, "Output",
 CellID->970782217]
}, Open  ]],
Cell[15398, 485, 124, 3, 70, "ExampleDelimiter",
 CellID->51078507],
Cell[15525, 490, 361, 12, 70, "ExampleText",
 CellID->536202180],
Cell[CellGroupData[{
Cell[15911, 506, 193, 6, 70, "Input",
 CellID->32961858],
Cell[16107, 514, 323, 11, 36, "Output",
 CellID->1503454860]
}, Open  ]],
Cell[CellGroupData[{
Cell[16467, 530, 209, 6, 70, "Input",
 CellID->527297470],
Cell[16679, 538, 333, 11, 36, "Output",
 CellID->1273241418]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17073, 556, 311, 9, 70, "SeeAlsoSection",
 CellID->32218],
Cell[17387, 567, 1228, 44, 70, "SeeAlso",
 CellID->28694]
}, Open  ]],
Cell[CellGroupData[{
Cell[18652, 616, 313, 9, 70, "TutorialsSection",
 CellID->4405],
Cell[18968, 627, 181, 4, 70, "Tutorials",
 CellID->13674]
}, Open  ]],
Cell[CellGroupData[{
Cell[19186, 636, 319, 9, 70, "MoreAboutSection",
 CellID->463818319],
Cell[19508, 647, 153, 3, 70, "MoreAbout",
 CellID->288131385],
Cell[19664, 652, 145, 3, 70, "MoreAbout",
 CellID->428592081],
Cell[19812, 657, 178, 3, 70, "MoreAbout",
 CellID->79214377],
Cell[19993, 662, 197, 4, 70, "MoreAbout",
 CellID->66814900]
}, Open  ]],
Cell[20205, 669, 27, 0, 70, "History"],
Cell[20235, 671, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

