(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23186,        804]
NotebookOptionsPosition[     18066,        637]
NotebookOutlinePosition[     19715,        679]
CellTagsIndexPosition[     19630,        674]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Codes" :> 
          Documentation`HelpLookup["paclet:tutorial/CharacterCodes"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Character Codes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], 
          "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], 
          "$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/CharacterEncoding"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ToCharacterCode\"\>", 
       2->"\<\"CharacterRange\"\>", 3->"\<\"$CharacterEncoding\"\>", 
       4->"\<\"CharacterEncoding\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Special Characters" :> 
          Documentation`HelpLookup["paclet:guide/SpecialCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Character Operations\"\>", 
       3->"\<\"Locale & Internationalization\"\>", 
       4->"\<\"Special Characters\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromCharacterCode", "ObjectName",
 CellID->29018],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromCharacterCode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromCharacterCode"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a string consisting of the character with integer \
code ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromCharacterCode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromCharacterCode"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a string consisting of the sequence of characters \
with codes ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromCharacterCode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromCharacterCode"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["n", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["n", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["n", "TI"], 
            StyleBox["21", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of strings. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromCharacterCode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromCharacterCode"], "[", 
       RowBox[{
        StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"encoding\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the specified character encoding. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " must lie between 0 and 65535, as returned by ",
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7834],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " between 0 and 127, ",
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " returns ASCII characters. "
}], "Notes",
 CellID->1036],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " between 129 and 255, it returns ISO Latin\[Hyphen]1 characters. "
}], "Notes",
 CellID->27972],

Cell[TextData[{
 "For other ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " it returns characters specified by the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " encoding based on Unicode. "
}], "Notes",
 CellID->10082],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"], "[", 
   RowBox[{"FromCharacterCode", "[", 
    StyleBox["n", "TI"], "]"}], "]"}]], "InlineFormula"],
 " gives the full name assigned to a special character with character code ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4196],

Cell[TextData[{
 "Whether a particular character generated by ",
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " can be rendered on your output device will depend on what fonts and \
drivers you are using. "
}], "Notes",
 CellID->25913],

Cell[TextData[{
 "Encodings supported in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromCharacterCode"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"encoding\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " are listed in the notes for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30045]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->709680479],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->28564421],

Cell[TextData[{
 "Give a string consisting of the sequence of characters with codes ",
 Cell[BoxData[
  RowBox[{"97", ",", "98", ",", "99"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->92635835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"{", 
   RowBox[{"97", ",", "98", ",", "99"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4834770],

Cell[BoxData["\<\"abc\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235821416]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->655591241],

Cell["Obtain character codes:", "ExampleText",
 CellID->1647492422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", "\"\<ABCD abcd\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1898475783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "65", ",", "66", ",", "67", ",", "68", ",", "32", ",", "97", ",", "98", ",",
    "99", ",", "100"}], "}"}]], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362566932]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " reconstructs the original string:"
}], "ExampleText",
 CellID->1930878377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1665296780],

Cell[BoxData["\<\"ABCD abcd\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172999700]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64498788],

Cell["A list of strings will produce a list of encoding lists: ", \
"ExampleText",
 CellID->123306293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<ABCD\>\"", ",", "\"\<abcd\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266129759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"65", ",", "66", ",", "67", ",", "68"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"97", ",", "98", ",", "99", ",", "100"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510138168]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 " reproduces the list of strings: "
}], "ExampleText",
 CellID->606119694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115247569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ABCD\"\>", ",", "\<\"abcd\"\>"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59264807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1488599124],

Cell["All printable ASCII characters:", "ExampleText",
 CellID->700989518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"32", ",", "126"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435541584],

Cell[BoxData["\<\" \
!\\\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\\\]^_`\
abcdefghijklmnopqrstuvwxyz{|}~\"\>"], "Output",
 ImageSize->{445, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451969857]
}, Open  ]],

Cell["Some ISO Latin-1 letters:", "ExampleText",
 CellID->1296502544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"192", ",", "255"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1949174546],

Cell[BoxData["\<\"\[CapitalAGrave]\[CapitalAAcute]\[CapitalAHat]\
\[CapitalATilde]\[CapitalADoubleDot]\[CapitalARing]\[CapitalAE]\
\[CapitalCCedilla]\[CapitalEGrave]\[CapitalEAcute]\[CapitalEHat]\
\[CapitalEDoubleDot]\[CapitalIGrave]\[CapitalIAcute]\[CapitalIHat]\
\[CapitalIDoubleDot]\[CapitalEth]\[CapitalNTilde]\[CapitalOGrave]\
\[CapitalOAcute]\[CapitalOHat]\[CapitalOTilde]\[CapitalODoubleDot]\[Times]\
\[CapitalOSlash]\[CapitalUGrave]\[CapitalUAcute]\[CapitalUHat]\
\[CapitalUDoubleDot]\[CapitalYAcute]\[CapitalThorn]\[SZ]\[AGrave]\[AAcute]\
\[AHat]\[ATilde]\[ADoubleDot]\[ARing]\[AE]\[CCedilla]\[EGrave]\[EAcute]\[EHat]\
\[EDoubleDot]\[IGrave]\[IAcute]\[IHat]\[IDoubleDot]\[Eth]\[NTilde]\[OGrave]\
\[OAcute]\[OHat]\[OTilde]\[ODoubleDot]\[Divide]\[OSlash]\[UGrave]\[UAcute]\
\[UHat]\[UDoubleDot]\[YAcute]\[Thorn]\[YDoubleDot]\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->521932670]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->492],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7800],

Cell[TextData[ButtonBox["Character Codes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharacterCodes"]], "Tutorials",
 CellID->17984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with FromCharacterCode",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
FromCharacterCode"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->10052203],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->171513514],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->181540301],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->54180924],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "MoreAbout",
 CellID->695408612]
}, Open  ]],

Cell["New in 2  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromCharacterCode - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 28.1582000}", "context" -> "System`", 
    "keywords" -> {
     "\\char (TeX)", "conversion", "FromASCII (Version 1 function)", 
      "character encoding", "font encoding"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FromCharacterCode[n] gives a string consisting of the character with \
integer code n. FromCharacterCode[{n_1, n_2, ...}] gives a string consisting \
of the sequence of characters with codes n_i. FromCharacterCode[{{n_11, n_12, \
...}, {n_21, ...}, ...}] gives a list of strings. FromCharacterCode[..., \" \
encoding\"] uses the specified character encoding. ", 
    "synonyms" -> {"from character code"}, "title" -> "FromCharacterCode", 
    "type" -> "Symbol", "uri" -> "ref/FromCharacterCode"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8721, 286, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->709680479]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19487, 667}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2607, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3230, 89, 55, 1, 70, "ObjectName",
 CellID->29018],
Cell[3288, 92, 2574, 79, 70, "Usage",
 CellID->17241]
}, Open  ]],
Cell[CellGroupData[{
Cell[5899, 176, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6377, 193, 307, 11, 70, "Notes",
 CellID->7834],
Cell[6687, 206, 302, 11, 70, "Notes",
 CellID->1036],
Cell[6992, 219, 179, 6, 70, "Notes",
 CellID->27972],
Cell[7174, 227, 251, 9, 70, "Notes",
 CellID->10082],
Cell[7428, 238, 402, 13, 70, "Notes",
 CellID->4196],
Cell[7833, 253, 328, 9, 70, "Notes",
 CellID->25913],
Cell[8164, 264, 520, 17, 70, "Notes",
 CellID->30045]
}, Closed]],
Cell[CellGroupData[{
Cell[8721, 286, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->709680479],
Cell[CellGroupData[{
Cell[9106, 300, 147, 5, 70, "ExampleSection",
 CellID->28564421],
Cell[9256, 307, 203, 6, 70, "ExampleText",
 CellID->92635835],
Cell[CellGroupData[{
Cell[9484, 317, 171, 5, 28, "Input",
 CellID->4834770],
Cell[9658, 324, 168, 5, 36, "Output",
 CellID->235821416]
}, Open  ]],
Cell[9841, 332, 125, 3, 70, "ExampleDelimiter",
 CellID->655591241],
Cell[9969, 337, 67, 1, 70, "ExampleText",
 CellID->1647492422],
Cell[CellGroupData[{
Cell[10061, 342, 128, 3, 70, "Input",
 CellID->1898475783],
Cell[10192, 347, 291, 9, 36, "Output",
 CellID->362566932]
}, Open  ]],
Cell[10498, 359, 230, 7, 70, "ExampleText",
 CellID->1930878377],
Cell[CellGroupData[{
Cell[10753, 370, 114, 3, 70, "Input",
 CellID->1665296780],
Cell[10870, 375, 174, 5, 36, "Output",
 CellID->172999700]
}, Open  ]],
Cell[11059, 383, 124, 3, 70, "ExampleDelimiter",
 CellID->64498788],
Cell[11186, 388, 102, 2, 70, "ExampleText",
 CellID->123306293],
Cell[CellGroupData[{
Cell[11313, 394, 180, 5, 70, "Input",
 CellID->266129759],
Cell[11496, 401, 354, 12, 36, "Output",
 CellID->510138168]
}, Open  ]],
Cell[11865, 416, 228, 7, 70, "ExampleText",
 CellID->606119694],
Cell[CellGroupData[{
Cell[12118, 427, 113, 3, 70, "Input",
 CellID->115247569],
Cell[12234, 432, 224, 7, 36, "Output",
 CellID->59264807]
}, Open  ]],
Cell[12473, 442, 126, 3, 70, "ExampleDelimiter",
 CellID->1488599124],
Cell[12602, 447, 74, 1, 70, "ExampleText",
 CellID->700989518],
Cell[CellGroupData[{
Cell[12701, 452, 172, 5, 70, "Input",
 CellID->435541584],
Cell[12876, 459, 271, 7, 54, "Output",
 CellID->451969857]
}, Open  ]],
Cell[13162, 469, 69, 1, 70, "ExampleText",
 CellID->1296502544],
Cell[CellGroupData[{
Cell[13256, 474, 174, 5, 70, "Input",
 CellID->1949174546],
Cell[13433, 481, 979, 16, 36, "Output",
 CellID->521932670]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14473, 504, 309, 9, 70, "SeeAlsoSection",
 CellID->492],
Cell[14785, 515, 1005, 35, 70, "SeeAlso",
 CellID->25796]
}, Open  ]],
Cell[CellGroupData[{
Cell[15827, 555, 313, 9, 70, "TutorialsSection",
 CellID->7800],
Cell[16143, 566, 140, 3, 70, "Tutorials",
 CellID->17984]
}, Open  ]],
Cell[CellGroupData[{
Cell[16320, 574, 305, 8, 70, "RelatedLinksSection"],
Cell[16628, 584, 376, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17041, 601, 318, 9, 70, "MoreAboutSection",
 CellID->10052203],
Cell[17362, 612, 133, 3, 70, "MoreAbout",
 CellID->171513514],
Cell[17498, 617, 151, 3, 70, "MoreAbout",
 CellID->181540301],
Cell[17652, 622, 169, 3, 70, "MoreAbout",
 CellID->54180924],
Cell[17824, 627, 147, 3, 70, "MoreAbout",
 CellID->695408612]
}, Open  ]],
Cell[17986, 633, 50, 0, 70, "History"],
Cell[18039, 635, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

