(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25469,        989]
NotebookOptionsPosition[     19737,        780]
NotebookOutlinePosition[     21063,        817]
CellTagsIndexPosition[     20978,        812]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], 
          "Convergents" :> Documentation`HelpLookup["paclet:ref/Convergents"],
           "Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"], "FromDigits" :> 
          Documentation`HelpLookup["paclet:ref/FromDigits"], "Fold" :> 
          Documentation`HelpLookup["paclet:ref/Fold"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ContinuedFraction\"\>", 2->"\<\"Convergents\"\>",
        3->"\<\"Rationalize\"\>", 4->"\<\"FromDigits\"\>", 
       5->"\<\"Fold\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continued Fractions & Rational Approximations" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuedFractionsAndRationalApproximations"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continued Fractions & Rational Approximations\"\>", 
       2->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FromContinuedFraction", "ObjectName",
 CellID->2798],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FromContinuedFraction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FromContinuedFraction"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]reconstructs a number from the list of its continued \
fraction terms. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3603]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromContinuedFraction"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["3", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "1"], "+", "1", "/", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["a", "2"], "+", "1", "/", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["a", "3"], "+", "..."}], ")"}]}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->25202],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox["a", "i"]], "InlineFormula"],
 " can be symbolic. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16478,
  ButtonNote->"16478"]
}], "Notes",
 CellID->19738],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FromContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromContinuedFraction"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], "]"}]], 
  "InlineFormula"],
 " returns the exact number whose continued fraction terms start with the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", then consist of cyclic repetitions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["b", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4679],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromContinuedFraction"]], "InlineFormula"],
 " acts as the inverse of ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15878]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->607719097],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->159269477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"47", "/", "17"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19166],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14418]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23962],

Cell[BoxData[
 FractionBox["47", "17"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "+", 
  FractionBox["1", 
   RowBox[{"1", "+", 
    FractionBox["1", 
     RowBox[{"3", "+", 
      FractionBox["1", "4"]}]]}]]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25184],

Cell[BoxData[
 FractionBox["47", "17"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13734]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23509],

Cell["Quadratic irrationals (recurring continued fractions):", "ExampleText",
 CellID->15854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Sqrt", "[", "71", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8", ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "2", ",", "1", ",", "7", ",", "1", ",", "2", ",", "2", ",", 
     "16"}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21924],

Cell[BoxData[
 SqrtBox["71"]], "Output",
 ImageSize->{35, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32327],

Cell["Symbolic form:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->16478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25686],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"a", " ", "b"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"a", " ", "b"}]}], ")"}], " ", "c"}]}], ")"}], " ", "d"}]}], 
  
  RowBox[{"b", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"b", " ", "c"}]}], ")"}], " ", "d"}]}]]], "Output",
 ImageSize->{162, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17384]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25654],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"a", " ", "b"}], "+", 
   RowBox[{"a", " ", "d"}], "+", 
   RowBox[{"c", " ", "d"}], "+", 
   RowBox[{"a", " ", "b", " ", "c", " ", "d"}]}], 
  RowBox[{"b", "+", "d", "+", 
   RowBox[{"b", " ", "c", " ", "d"}]}]]], "Output",
 ImageSize->{154, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8690]
}, Open  ]],

Cell["Compare with the division-based form:", "ExampleText",
 CellID->14778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{"a", "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"b", "+", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"c", "+", 
         RowBox[{"1", "/", "d"}]}], ")"}]}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14492],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"a", " ", "b"}], "+", 
   RowBox[{"a", " ", "d"}], "+", 
   RowBox[{"c", " ", "d"}], "+", 
   RowBox[{"a", " ", "b", " ", "c", " ", "d"}]}], 
  RowBox[{"b", "+", "d", "+", 
   RowBox[{"b", " ", "c", " ", "d"}]}]]], "Output",
 ImageSize->{154, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32183]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6742],

Cell["Rational approximation to \[Pi]:", "ExampleText",
 CellID->23199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", 
  RowBox[{"ContinuedFraction", "[", 
   RowBox[{"Pi", ",", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28692],

Cell[BoxData[
 FractionBox["333", "106"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10242],

Cell[BoxData["3.141509433962264`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21500]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8734],

Cell["Numbers with simple recurring continued fractions:", "ExampleText",
 CellID->24442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", 
  RowBox[{"{", 
   RowBox[{"{", "1", "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5707],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SqrtBox["5"]}], ")"}]}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13079],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SqrtBox["3"]}], ")"}]}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10836]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12209],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "7"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    SqrtBox["37"]}], ")"}]}]], "Output",
 ImageSize->{83, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7884]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->21147],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "15"], " ", 
  RowBox[{"(", 
   RowBox[{"9", "+", 
    RowBox[{"2", " ", 
     SqrtBox["39"]}]}], ")"}]}]], "Output",
 ImageSize->{100, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->30652]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromContinuedFraction", "[", 
  RowBox[{"{", "x", "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15720],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26547]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->269],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Convergents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Convergents"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fold"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1746]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26851],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->15919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->23576],

Cell[TextData[{
 ButtonBox["Demonstrations with FromContinuedFraction",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
FromContinuedFraction"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#19968"], None}]], "RelatedLinks",
 CellID->2726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->674782836],

Cell[TextData[ButtonBox["Continued Fractions & Rational Approximations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], "MoreAbout",
 CellID->502696747],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->37902989]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FromContinuedFraction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 28.4707080}", "context" -> "System`", 
    "keywords" -> {"continued fraction", "convergents"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FromContinuedFraction[list] reconstructs a number from the list of its \
continued fraction terms. ", "synonyms" -> {"from continued fraction"}, 
    "title" -> "FromContinuedFraction", "type" -> "Symbol", "uri" -> 
    "ref/FromContinuedFraction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6773, 228, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->607719097]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20835, 805}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2485, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3108, 85, 58, 1, 70, "ObjectName",
 CellID->2798],
Cell[3169, 88, 541, 16, 70, "Usage",
 CellID->3603]
}, Open  ]],
Cell[CellGroupData[{
Cell[3747, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4225, 126, 852, 32, 70, "Notes",
 CellID->25202],
Cell[5080, 160, 241, 10, 70, "Notes",
 CellID->19738],
Cell[5324, 172, 1048, 37, 70, "Notes",
 CellID->4679],
Cell[6375, 211, 361, 12, 70, "Notes",
 CellID->15878]
}, Closed]],
Cell[CellGroupData[{
Cell[6773, 228, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->607719097],
Cell[CellGroupData[{
Cell[7158, 242, 148, 5, 70, "ExampleSection",
 CellID->159269477],
Cell[CellGroupData[{
Cell[7331, 251, 134, 4, 28, "Input",
 CellID->19166],
Cell[7468, 257, 219, 7, 36, "Output",
 CellID->14418]
}, Open  ]],
Cell[CellGroupData[{
Cell[7724, 269, 113, 3, 28, "Input",
 CellID->23962],
Cell[7840, 274, 175, 6, 51, "Output",
 CellID->1479]
}, Open  ]],
Cell[CellGroupData[{
Cell[8052, 285, 207, 8, 58, "Input",
 CellID->25184],
Cell[8262, 295, 176, 6, 51, "Output",
 CellID->13734]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8487, 307, 216, 7, 70, "ExampleSection",
 CellID->23509],
Cell[8706, 316, 93, 1, 70, "ExampleText",
 CellID->15854],
Cell[CellGroupData[{
Cell[8824, 321, 140, 4, 70, "Input",
 CellID->1039],
Cell[8967, 327, 320, 11, 36, "Output",
 CellID->2586]
}, Open  ]],
Cell[CellGroupData[{
Cell[9324, 343, 113, 3, 70, "Input",
 CellID->21924],
Cell[9440, 348, 166, 6, 38, "Output",
 CellID->25915]
}, Open  ]],
Cell[9621, 357, 121, 3, 70, "ExampleDelimiter",
 CellID->32327],
Cell[9745, 362, 101, 2, 70, "ExampleText",
 CellID->16478],
Cell[CellGroupData[{
Cell[9871, 368, 180, 5, 70, "Input",
 CellID->25686],
Cell[10054, 375, 549, 21, 53, "Output",
 CellID->17384]
}, Open  ]],
Cell[CellGroupData[{
Cell[10640, 401, 100, 3, 70, "Input",
 CellID->25654],
Cell[10743, 406, 410, 13, 52, "Output",
 CellID->8690]
}, Open  ]],
Cell[11168, 422, 76, 1, 70, "ExampleText",
 CellID->14778],
Cell[CellGroupData[{
Cell[11269, 427, 312, 11, 70, "Input",
 CellID->14492],
Cell[11584, 440, 411, 13, 52, "Output",
 CellID->32183]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12044, 459, 222, 7, 70, "ExampleSection",
 CellID->6742],
Cell[12269, 468, 71, 1, 70, "ExampleText",
 CellID->23199],
Cell[CellGroupData[{
Cell[12365, 473, 182, 5, 70, "Input",
 CellID->28692],
Cell[12550, 480, 178, 6, 51, "Output",
 CellID->24501]
}, Open  ]],
Cell[CellGroupData[{
Cell[12765, 491, 93, 3, 70, "Input",
 CellID->10242],
Cell[12861, 496, 171, 5, 36, "Output",
 CellID->21500]
}, Open  ]],
Cell[13047, 504, 120, 3, 70, "ExampleDelimiter",
 CellID->8734],
Cell[13170, 509, 89, 1, 70, "ExampleText",
 CellID->24442],
Cell[CellGroupData[{
Cell[13284, 514, 159, 5, 70, "Input",
 CellID->5707],
Cell[13446, 521, 258, 10, 51, "Output",
 CellID->12954]
}, Open  ]],
Cell[CellGroupData[{
Cell[13741, 536, 185, 6, 70, "Input",
 CellID->13079],
Cell[13929, 544, 258, 10, 51, "Output",
 CellID->10836]
}, Open  ]],
Cell[CellGroupData[{
Cell[14224, 559, 195, 6, 70, "Input",
 CellID->12209],
Cell[14422, 567, 258, 10, 51, "Output",
 CellID->7884]
}, Open  ]],
Cell[CellGroupData[{
Cell[14717, 582, 207, 7, 70, "Input",
 CellID->21147],
Cell[14927, 591, 287, 11, 51, "Output",
 CellID->30652]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15263, 608, 233, 7, 70, "ExampleSection",
 CellID->15067],
Cell[CellGroupData[{
Cell[15521, 619, 136, 4, 70, "Input",
 CellID->15720],
Cell[15660, 625, 154, 5, 36, "Output",
 CellID->26547]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15875, 637, 309, 9, 70, "SeeAlsoSection",
 CellID->269],
Cell[16187, 648, 1211, 44, 70, "SeeAlso",
 CellID->1746]
}, Open  ]],
Cell[CellGroupData[{
Cell[17435, 697, 314, 9, 70, "TutorialsSection",
 CellID->26851],
Cell[17752, 708, 198, 4, 70, "Tutorials",
 CellID->15919]
}, Open  ]],
Cell[CellGroupData[{
Cell[17987, 717, 321, 9, 70, "RelatedLinksSection",
 CellID->23576],
Cell[18311, 728, 384, 12, 70, "RelatedLinks"],
Cell[18698, 742, 266, 6, 70, "RelatedLinks",
 CellID->2726]
}, Open  ]],
Cell[CellGroupData[{
Cell[19001, 753, 319, 9, 70, "MoreAboutSection",
 CellID->674782836],
Cell[19323, 764, 203, 4, 70, "MoreAbout",
 CellID->502696747],
Cell[19529, 770, 136, 3, 70, "MoreAbout",
 CellID->37902989]
}, Open  ]],
Cell[19680, 776, 27, 0, 70, "History"],
Cell[19710, 778, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

