(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39828,       1065]
NotebookOptionsPosition[     34903,        898]
NotebookOutlinePosition[     36239,        936]
CellTagsIndexPosition[     36154,        931]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Executing Notebook Commands Directly in the Front End" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExecutingNotebookCommandsDirectlyInTheFrontEnd"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Executing Notebook Commands Directly in the Front End\"\>"}, "\
\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FrontEndTokenExecute" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndTokenExecute"], 
          "Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "Evaluator" :> Documentation`HelpLookup["paclet:ref/Evaluator"], 
          "SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FrontEndTokenExecute\"\>", 
       2->"\<\"Button\"\>", 3->"\<\"Evaluator\"\>", 
       4->"\<\"SystemDialogInput\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookAndInterfaceCustomization"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Low-Level Interface Control\"\>", 
       3->"\<\"Low-Level Notebook Programming\"\>", 
       4->"\<\"Notebook & Interface Customization\"\>", 
       5->"\<\"Programmatic Notebook & Interface Customization\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FrontEndExecute", "ObjectName",
 CellID->21320],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrontEndExecute",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrontEndExecute"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]sends ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be executed by the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " sends ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["$FrontEnd",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$FrontEnd"]], "InlineFormula"],
 " via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["LinkWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkWrite"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10346],

Cell[TextData[{
 "The standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end can handle only specific notebook manipulation commands such as \
",
 Cell[BoxData[
  ButtonBox["NotebookApply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookApply"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NotebookLocate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookLocate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SelectedNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectedNotebook"]], "InlineFormula"],
 ". It uses the versions of these commands in the ",
 Cell[BoxData["FrontEnd`"], "InlineFormula"],
 " context. "
}], "Notes",
 CellID->24221],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   RowBox[{
    ButtonBox["FrontEndToken",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrontEndToken"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}], "]"}]], "InlineFormula"],
 " executes named commands in the front end, typically corresponding to menu \
items. "
}], "Notes",
 CellID->15420]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->232521960],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->610966864],

Cell[TextData[{
 "This calls the front end's ",
 Cell[BoxData[
  ButtonBox["CellPrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellPrint"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->89901759],

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEnd`CellPrint", "[", 
   RowBox[{"Cell", "[", 
    RowBox[{"\"\<A\>\"", ",", "\"\<Text\>\""}], "]"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->142373729],

Cell["A", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellID->94088400],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->546583491],

Cell["Create a notebook with two cells:", "ExampleText",
 CellID->239290059],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<line1\>\"", ",", "\"\<line2\>\""}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773708822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145785313],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1vFFUcxvE1JtxoDAn/gIRrr0yMMVyplwQT4o1vSEEKaNToH+AFob5Q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   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellID->531477209]
}, Open  ]],

Cell[TextData[{
 "Merge the cells by using a ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25884281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<CellMerge\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->42677359],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtvlEUcxvEaE280xsR/QOK1VybGGK/USwIJ8cYzRSmiUaN/gBeGg1I1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   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellID->2178838]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->190290824],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FrontEndExecute",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndExecute"]], "InlineFormula"],
 " to do a sequence of front end functions:"
}], "ExampleText",
 CellID->175998085],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"FrontEndExecute", "[", 
    RowBox[{"FrontEnd`NotebookCreateReturnObject", "[", "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362323806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEnd`NotebookWrite", "[", 
   RowBox[{"nb", ",", "\"\<text\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243333339],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnO1PU2cYxln2ffFf2Pf9Ecu2zzNZ/LQlE8wA3bKYLfu2ZEvM0E3mIr6A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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellID->183668666]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEnd`SelectionMove", "[", 
   RowBox[{"nb", ",", "All", ",", "Cell"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->534664815],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnEtMXFUYxzEmbnykiYlubVy40ZUb48bGGt2YmjTdqNFCY2mrqY2mLnRh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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellID->362072077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEnd`NotebookDelete", "[", "nb", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->81339397],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmltPXFUYhjHem/4F/4lRr21ieqWJhUag1TRGf4AXjW21WCM9QGkBWwRa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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellID->584641697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177143674],

Cell["Carry out the same steps by kernel functions:", "ExampleText",
 CellID->4950190],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookCreate", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144183537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", "\"\<text\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49065271],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnOtPk2cYxln2ffFf2Pf9Ezt8nsnipy2ZYAbolsVs2bclW2KGbjIX8QCi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   "], {{0, 0}, {458, 65}}, {0, 255}],
  ImageSize->{458 0.75, 65 0.75},
  PlotRange->{{0, 458}, {0, 65}}]], "NotebookImage",
 CellID->14910769]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126396834],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnEtslFUYhmtM3HgJiYluJS7c6MqNceMFoxsDCWGjRmmJFNAg0eBCF8YY
LkrFcG0plwq1LfdLixQo9kIv0+m0TEunpdOhU7QdiOVOYwnY1uP558ycOf8/
0xba+SPS58nL5Hu/831nZvXm79B05oJlcxc8mpGR8Yb853skI8Oqs7O/QQgh
5IaGR0YRQgilUTpd9+w9hRBCKC1ypOt//giNEEIPgVKmqwAAgCmQHf+ulXQF
AEgjpCsAgBuQrgAAbkC6AgC4AekKAOAGpCsAgBuQrgAAbkC6AgC4AekKAOAG
pCsAgBuQrgAAbkC6AgC4AekKAOAGpCsAwKTJsGMeka4AAJNDxunc2S99+N7L
Ws/PfFqfkq4AAJNDpuurrzynozVnxbvyVZ+SrgAAk8PxtYDKWH1KugIATA7S
FQDADUjXjBfrlJI7umnacY4AADTTPF0dOeno6KbZT45WxyQAgCBdkx47x3kQ
Hesp192PCAD/T0jXlOma/OWAIF0B4H4gXcd5dk1ZjzUAAGAyndN1wmfU8f9X
a6x1AAAxvdNVTPnhk1wFgLFwpGveurlfLntdn5Kurq4DwEOMGa3LP3vt26/f
mVbPrgAALmFG69uzXphu3wwAALiEGa3T8HtXAACXMKOVdAUASBcyWr9aPou/
QAgAkF6efeZJ8++7Sj3x+GP6lHQFAJg05q8NOI5IVwAANyBdAQDcgHQFAHAD
0hUAwA1IVwAANzDT9dOlOeGe30uPetfkFCGEEJqihv8e9ni7Pv9iffbStTJd
pbq7exFCCE1RZrp2B/uFGB0dHUEIITQV/TM6Yqbruc6+4eGRodt3pG5HFauH
5OtdbYeGYgOyqYd1beo2FovFPqD2vjNty/a9O+a9WTJnVvGct5Il+/JUzqjF
O3fuDg3d1enafvbCrcGhq9duXb12M/p6K17fdNbXzQE9r5uD9lMsFot9oOxk
Mq1s3uyRjZvEzkJRUJBCOwvlqZxRi9euWys6XVtbey79ea0vcqWvf+CpGTNM
9UUG+iKXY3W/WV+WMsauxIvLulY20TfmUw4nbo4Oq9PkrcRM9NQxjMVisWNa
K8QGok3VGYj344odDVhb8RvOL8oS5cfE4X1jqvyYnFG7/Rev9Eeu6nRtbgn1
XLjUfb5fZZcslOI2kuiHEjPxoi86HJsJ2S7pM63jcseptPYB69T8GKHEou0U
i8Vi79HGi0iiGbJbq+4zZqwbQtlZoqxU7N8d+6UrWShpW1YqZ6IrkVBP5Hz4
kk5Xb1Mw0HnhbCCsckwWbYGwaXWRqtmbst9mv6TNfnnyaZu9Vqd6OOUuFovF
TsKetddJ6jW3ZOFMV8kBo46nq9pq7wh3nPtDp6ssmv1B35kuFWJNLUFvc7Cp
JWHjRZdZx4ozwabmroRt1ltdPjlv2OQf8B3DqvbaJ73Wm9pO9c2ywGKx2Hu3
vpagVFP8tcnqB61+NPHUsM40fUMoO1OUHRb7ii05KPlZFBeIQ3tlujapO88E
/W09Ol0bPJ31nkCdJ6ASTBZ1DYFaT3vMNtj6jmZttFnXoIfbE31PwLR6sXaM
4Vjd0K531XDyVcmnE+5isVisCivr1RNIdGL9mHSm6Ru6P55v5WrhNlG4VezK
T0RrQa7YsUls2yADtnvh/PhKu9cXrD59VqVrvaezqqZVSmVU5WmrrjrtV1b3
tczheMfvKBy2sqa10r5SaV3iT3W5Xw2rU4d17Kr79c3aptzFYrHT3sY6lbG+
Tca87QYrXYt2iPz1Yst657PrxrViw49iR75MV31Pvafj13KvSte6ho4TFU0n
T/lURslCSdkTp5pPWvKdrPDJ2rIVzcZw9Mjq+6KTeiu1dQybVl/oODU/lfGR
ErtmON/LG2Gx2OlpTyT6KTJNnSZnWvfCTFGQP7IuR2fq3Z8S9e0fVou8zaGF
mdFd34kKX01t2559VbF0re84Wu45dtyrAkoWSg7rkP20UVuj35hsDTmt48Lk
90p5VbRje/cJ3wiLxWInUqN+tb53zds8uHqVitO/vl81GJWyN1auFJs3yRm9
W1nt315wNJ6unYdLG0uPet2Qyr30TqZ3FyGExlF4cZbIzb363Xc3Vq5IluyL
vNzwokw1fKTMW/Fb6/qN+2LpWnfuwP76Qwc9CCGEHPIveV9szRN5UrkplJsr
tm5v+eQjNXzwgOd4uX9NTpFK15qaQOGuypKiaoQQQg5t2b63deEHvUsW9CzK
Slbv4iz/oiw5o4aLf6k6cthLuiKEUHpFuiKEkBsiXRFCyA050rW2LlBUWLm7
pBohhNBUVFJcVVaaSNf+yPVw7+Vw7wBCCKEp6uLFmzpdEUIIpVcyXf8FR7JQ
Ig==
   "], {{0, 0}, {458, 65}}, {0, 255}],
  ImageSize->{458 0.75, 65 0.75},
  PlotRange->{{0, 458}, {0, 65}}]], "NotebookImage",
 CellID->117332436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookDelete", "[", "nb", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2646895],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmltPlEcch2l63/gV+lF6uK5J41WbVDAFtI1p2g/QC1O1ldoUDyAKVCmg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   "], {{0, 0}, {458, 65}}, {0, 255}],
  ImageSize->{458 0.75, 65 0.75},
  PlotRange->{{0, 458}, {0, 65}}]], "NotebookImage",
 CellID->195595438]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10071],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndTokenExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndTokenExecute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Evaluator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2668],

Cell[TextData[ButtonBox["Executing Notebook Commands Directly in the Front \
End",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExecutingNotebookCommandsDirectlyInTheFrontEnd"]], \
"Tutorials",
 CellID->29603]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->116725782],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->369072472],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->788231517],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->404873359],

Cell[TextData[ButtonBox["Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookAndInterfaceCustomization"]], "MoreAbout",
 CellID->23893440],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->564129723]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrontEndExecute - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 29.7832416}", "context" -> "System`", 
    "keywords" -> {
     "evaluating in front end", "scripting menu commands", 
      "scripting user interface"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FrontEndExecute[expr] sends expr to be executed by the Mathematica front \
end. ", "synonyms" -> {"front end execute"}, "title" -> "FrontEndExecute", 
    "type" -> "Symbol", "uri" -> "ref/FrontEndExecute"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6752, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->232521960]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36011, 924}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3062, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3685, 97, 53, 1, 70, "ObjectName",
 CellID->21320],
Cell[3741, 100, 643, 21, 70, "Usage",
 CellID->10499]
}, Open  ]],
Cell[CellGroupData[{
Cell[4421, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4899, 143, 628, 25, 70, "Notes",
 CellID->10346],
Cell[5530, 170, 718, 24, 70, "Notes",
 CellID->24221],
Cell[6251, 196, 464, 14, 70, "Notes",
 CellID->15420]
}, Closed]],
Cell[CellGroupData[{
Cell[6752, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->232521960],
Cell[CellGroupData[{
Cell[7137, 229, 148, 5, 70, "ExampleSection",
 CellID->610966864],
Cell[7288, 236, 220, 8, 70, "ExampleText",
 CellID->89901759],
Cell[7511, 246, 234, 7, 70, "Input",
 CellID->142373729],
Cell[7748, 255, 84, 3, 70, "Text",
 CellID->94088400],
Cell[7835, 260, 125, 3, 70, "ExampleDelimiter",
 CellID->546583491],
Cell[7963, 265, 76, 1, 70, "ExampleText",
 CellID->239290059],
Cell[8042, 268, 231, 8, 70, "Input",
 CellID->773708822],
Cell[CellGroupData[{
Cell[8298, 280, 152, 4, 70, "Input",
 CellID->145785313],
Cell[8453, 286, 2890, 50, 70, "NotebookImage",
 CellID->531477209]
}, Open  ]],
Cell[11358, 339, 219, 8, 70, "ExampleText",
 CellID->25884281],
Cell[CellGroupData[{
Cell[11602, 351, 191, 5, 70, "Input",
 CellID->42677359],
Cell[11796, 358, 2794, 48, 70, "NotebookImage",
 CellID->2178838]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14639, 412, 237, 7, 70, "ExampleSection",
 CellID->190290824],
Cell[14879, 421, 241, 8, 70, "ExampleText",
 CellID->175998085],
Cell[15123, 431, 216, 7, 70, "Input",
 CellID->362323806],
Cell[CellGroupData[{
Cell[15364, 442, 196, 5, 70, "Input",
 CellID->243333339],
Cell[15563, 449, 2495, 43, 70, "NotebookImage",
 CellID->183668666]
}, Open  ]],
Cell[CellGroupData[{
Cell[18095, 497, 200, 5, 70, "Input",
 CellID->534664815],
Cell[18298, 504, 2548, 44, 70, "NotebookImage",
 CellID->362072077]
}, Open  ]],
Cell[CellGroupData[{
Cell[20883, 553, 161, 4, 70, "Input",
 CellID->81339397],
Cell[21047, 559, 2284, 40, 70, "NotebookImage",
 CellID->584641697]
}, Open  ]],
Cell[23346, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->177143674],
Cell[23474, 607, 86, 1, 70, "ExampleText",
 CellID->4950190],
Cell[23563, 610, 148, 5, 70, "Input",
 CellID->144183537],
Cell[CellGroupData[{
Cell[23736, 619, 143, 4, 70, "Input",
 CellID->49065271],
Cell[23882, 625, 2527, 44, 70, "NotebookImage",
 CellID->14910769]
}, Open  ]],
Cell[CellGroupData[{
Cell[26446, 674, 148, 4, 70, "Input",
 CellID->126396834],
Cell[26597, 680, 2585, 45, 70, "NotebookImage",
 CellID->117332436]
}, Open  ]],
Cell[CellGroupData[{
Cell[29219, 730, 109, 3, 70, "Input",
 CellID->2646895],
Cell[29331, 735, 2316, 40, 70, "NotebookImage",
 CellID->195595438]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31708, 782, 311, 9, 70, "SeeAlsoSection",
 CellID->10071],
Cell[32022, 793, 981, 35, 70, "SeeAlso",
 CellID->16775]
}, Open  ]],
Cell[CellGroupData[{
Cell[33040, 833, 313, 9, 70, "TutorialsSection",
 CellID->2668],
Cell[33356, 844, 217, 6, 70, "Tutorials",
 CellID->29603]
}, Open  ]],
Cell[CellGroupData[{
Cell[33610, 855, 319, 9, 70, "MoreAboutSection",
 CellID->116725782],
Cell[33932, 866, 168, 3, 70, "MoreAbout",
 CellID->369072472],
Cell[34103, 871, 163, 3, 70, "MoreAbout",
 CellID->788231517],
Cell[34269, 876, 169, 3, 70, "MoreAbout",
 CellID->404873359],
Cell[34441, 881, 178, 3, 70, "MoreAbout",
 CellID->23893440],
Cell[34622, 886, 209, 5, 70, "MoreAbout",
 CellID->564129723]
}, Open  ]],
Cell[34846, 894, 27, 0, 70, "History"],
Cell[34876, 896, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

