(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24431,        680]
NotebookOptionsPosition[     20250,        546]
NotebookOutlinePosition[     21870,        591]
CellTagsIndexPosition[     21752,        585]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"], 
          "FrontEndToken" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndToken"], 
          "FrontEndExecute" :> 
          Documentation`HelpLookup["paclet:ref/FrontEndExecute"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SystemDialogInput\"\>", 
       2->"\<\"FrontEndToken\"\>", 
       3->"\<\"FrontEndExecute\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tokens Related to the Cell Menu" :> 
          Documentation`HelpLookup["paclet:guide/CellTokens"], 
          "Tokens Related to the Edit Menu" :> 
          Documentation`HelpLookup["paclet:guide/EditTokens"], 
          "Tokens Related to the Evaluation Menu" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationTokens"], 
          "Tokens Related to the File Menu" :> 
          Documentation`HelpLookup["paclet:guide/FileTokens"], 
          "Tokens Related to the Format Menu" :> 
          Documentation`HelpLookup["paclet:guide/FormatTokens"], 
          "Front End Tokens" :> 
          Documentation`HelpLookup["paclet:guide/FrontEndTokens"], 
          "Tokens Related to the Graphics Menu" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTokens"], 
          "Tokens Related to the Insert Menu" :> 
          Documentation`HelpLookup["paclet:guide/InsertTokens"], 
          "Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Tokens Related to the Palettes Menu" :> 
          Documentation`HelpLookup["paclet:guide/PalettesTokens"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Tokens Related to the Window Menu" :> 
          Documentation`HelpLookup["paclet:guide/WindowTokens"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Tokens Related to the Cell Menu\"\>", 
       2->"\<\"Tokens Related to the Edit Menu\"\>", 
       3->"\<\"Tokens Related to the Evaluation Menu\"\>", 
       4->"\<\"Tokens Related to the File Menu\"\>", 
       5->"\<\"Tokens Related to the Format Menu\"\>", 
       6->"\<\"Front End Tokens\"\>", 
       7->"\<\"Tokens Related to the Graphics Menu\"\>", 
       8->"\<\"Tokens Related to the Insert Menu\"\>", 
       9->"\<\"Low-Level Notebook Programming\"\>", 
       10->"\<\"Tokens Related to the Palettes Menu\"\>", 
       11->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       12->"\<\"Tokens Related to the Window Menu\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FrontEndTokenExecute", "ObjectName",
 CellID->26063],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FrontEndTokenExecute",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FrontEndTokenExecute"], "[", "\"\<\!\(\*
StyleBox[\"cmd\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]executes the specified front end command token, \
typically corresponding to a front end menu item. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32756]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndTokenExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndTokenExecute"], "[", 
   RowBox[{
    StyleBox["nb", "TI"], ",", "\"\<\!\(\*
StyleBox[\"cmd\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " executes a command targeting a specific notebook. "
}], "Notes",
 CellID->20807],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndTokenExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndTokenExecute"], "[", 
   RowBox[{
    StyleBox["nb", "TI"], ",", "\"\<\!\(\*
StyleBox[\"cmd\", \"TI\"]\)\>\"", ",", 
    StyleBox["param", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " executes a command with a parameter. "
}], "Notes",
 CellID->659730657],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndTokenExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndTokenExecute"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   RowBox[{
    ButtonBox["FrontEndToken",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrontEndToken"], "[", 
    StyleBox["args", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->106071301]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->992117545],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->650470837],

Cell["Create a new notebook by using a front end token command:", \
"ExampleText",
 CellID->25884281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndTokenExecute", "[", "\"\<New\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42677359],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2ltPXFUYxnGM96Zfwa+iXtvENF5oYqERaDWN0Q/gRWNbLWqkBygtYItA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   "], {{0, 0}, {458, 86}}, {0, 255}],
  ImageSize->{458 0.75, 86 0.75},
  PlotRange->{{0, 458}, {0, 86}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->192338901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->604894126],

Cell["Create a notebook with two cells:", "ExampleText",
 CellID->239290059],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<line1\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<line2\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773708822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Notebook"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145785313],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1vFFUcxvE1JtxoDAn/gIRrr0yMMVyplwQT4o1vSEEKaNToH+AFob5Q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   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellID->531477209]
}, Open  ]],

Cell[TextData[{
 "Merge the cells by using a ",
 Cell[BoxData[
  ButtonBox["FrontEndToken",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrontEndToken"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->687379172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndTokenExecute", "[", 
  RowBox[{"nb", ",", "\"\<CellMerge\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->185737173],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3dtvlEUcxvEaE280xsR/QOK1VybGGK/USwIJ8cYzRSmiUaN/gBeGg1I1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   "], {{0, 0}, {458, 92}}, {0, 255}],
  ImageSize->{458 0.75, 92 0.75},
  PlotRange->{{0, 458}, {0, 92}}]], "NotebookImage",
 CellID->2178838]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32075],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndToken",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndToken"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Tokens Related to the Cell Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellTokens"]], "MoreAbout",
 CellID->330667622],

Cell[TextData[ButtonBox["Tokens Related to the Edit Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EditTokens"]], "MoreAbout",
 CellID->443075740],

Cell[TextData[ButtonBox["Tokens Related to the Evaluation Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationTokens"]], "MoreAbout",
 CellID->40556556],

Cell[TextData[ButtonBox["Tokens Related to the File Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileTokens"]], "MoreAbout",
 CellID->501825024],

Cell[TextData[ButtonBox["Tokens Related to the Format Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormatTokens"]], "MoreAbout",
 CellID->379930007],

Cell[TextData[ButtonBox["Front End Tokens",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FrontEndTokens"]], "MoreAbout",
 CellID->3505787],

Cell[TextData[ButtonBox["Tokens Related to the Graphics Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTokens"]], "MoreAbout",
 CellID->56794635],

Cell[TextData[ButtonBox["Tokens Related to the Insert Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InsertTokens"]], "MoreAbout",
 CellID->171318734],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->474817041],

Cell[TextData[ButtonBox["Tokens Related to the Palettes Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PalettesTokens"]], "MoreAbout",
 CellID->696922285],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->102772447],

Cell[TextData[ButtonBox["Tokens Related to the Window Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowTokens"]], "MoreAbout",
 CellID->105113472]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FrontEndTokenExecute - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 35.9865254}", "context" -> "System`", 
    "keywords" -> {
     "commands", "menus", "scripts", "scriptable user interface", 
      "scriptable editor", "menu commands", "menu actions", "frontend"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FrontEndTokenExecute[\"cmd\"] executes the specified front end command \
token, typically corresponding to a front end menu item. ", 
    "synonyms" -> {"front end token execute"}, "title" -> 
    "FrontEndTokenExecute", "type" -> "Symbol", "uri" -> 
    "ref/FrontEndTokenExecute"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6640, 193, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->992117545]},
 "Notebook Image"->{
  Cell[7430, 225, 2435, 43, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->192338901]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21484, 574},
 {"Notebook Image", 21625, 578}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3436, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4059, 99, 58, 1, 70, "ObjectName",
 CellID->26063],
Cell[4120, 102, 583, 16, 70, "Usage",
 CellID->32756]
}, Open  ]],
Cell[CellGroupData[{
Cell[4740, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5218, 140, 384, 12, 70, "Notes",
 CellID->20807],
Cell[5605, 154, 407, 12, 70, "Notes",
 CellID->659730657],
Cell[6015, 168, 588, 20, 70, "Notes",
 CellID->106071301]
}, Closed]],
Cell[CellGroupData[{
Cell[6640, 193, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->992117545],
Cell[CellGroupData[{
Cell[7025, 207, 148, 5, 70, "ExampleSection",
 CellID->650470837],
Cell[7176, 214, 101, 2, 70, "ExampleText",
 CellID->25884281],
Cell[CellGroupData[{
Cell[7302, 220, 125, 3, 70, "Input",
 CellID->42677359],
Cell[7430, 225, 2435, 43, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->192338901]
}, Open  ]],
Cell[9880, 271, 125, 3, 70, "ExampleDelimiter",
 CellID->604894126],
Cell[10008, 276, 76, 1, 70, "ExampleText",
 CellID->239290059],
Cell[10087, 279, 389, 12, 70, "Input",
 CellID->773708822],
Cell[CellGroupData[{
Cell[10501, 295, 152, 4, 70, "Input",
 CellID->145785313],
Cell[10656, 301, 2890, 50, 70, "NotebookImage",
 CellID->531477209]
}, Open  ]],
Cell[13561, 354, 220, 8, 70, "ExampleText",
 CellID->687379172],
Cell[CellGroupData[{
Cell[13806, 366, 156, 4, 70, "Input",
 CellID->185737173],
Cell[13965, 372, 2794, 48, 70, "NotebookImage",
 CellID->2178838]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16820, 427, 311, 9, 70, "SeeAlsoSection",
 CellID->32075],
Cell[17134, 438, 737, 26, 70, "SeeAlso",
 CellID->7586]
}, Open  ]],
Cell[CellGroupData[{
Cell[17908, 469, 299, 8, 70, "MoreAboutSection"],
Cell[18210, 479, 153, 3, 70, "MoreAbout",
 CellID->330667622],
Cell[18366, 484, 153, 3, 70, "MoreAbout",
 CellID->443075740],
Cell[18522, 489, 164, 3, 70, "MoreAbout",
 CellID->40556556],
Cell[18689, 494, 153, 3, 70, "MoreAbout",
 CellID->501825024],
Cell[18845, 499, 157, 3, 70, "MoreAbout",
 CellID->379930007],
Cell[19005, 504, 140, 3, 70, "MoreAbout",
 CellID->3505787],
Cell[19148, 509, 160, 3, 70, "MoreAbout",
 CellID->56794635],
Cell[19311, 514, 157, 3, 70, "MoreAbout",
 CellID->171318734],
Cell[19471, 519, 169, 3, 70, "MoreAbout",
 CellID->474817041],
Cell[19643, 524, 161, 3, 70, "MoreAbout",
 CellID->696922285],
Cell[19807, 529, 209, 5, 70, "MoreAbout",
 CellID->102772447],
Cell[20019, 536, 157, 3, 70, "MoreAbout",
 CellID->105113472]
}, Open  ]],
Cell[20191, 542, 29, 0, 70, "History"],
Cell[20223, 544, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

