(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32616,       1144]
NotebookOptionsPosition[     26657,        935]
NotebookOutlinePosition[     28040,        974]
CellTagsIndexPosition[     27955,        969]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Definition" :> 
          Documentation`HelpLookup["paclet:ref/Definition"], "Save" :> 
          Documentation`HelpLookup["paclet:ref/Save"], "Information" :> 
          Documentation`HelpLookup["paclet:ref/Information"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Definition\"\>", 2->"\<\"Save\"\>", 
       3->"\<\"Information\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FullDefinition", "ObjectName",
 CellID->16955],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FullDefinition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FullDefinition"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as the definitions given for ",
     Cell[BoxData[
      StyleBox["symbol", "TI"]], "InlineFormula"],
     ", and all symbols on which these depend. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23183]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8394],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullDefinition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullDefinition"], "[", 
   StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
 " recursively prints as all definitions for the ",
 Cell[BoxData[
  StyleBox["symbol", "TI"]], "InlineFormula"],
 ", and for the symbols that appear in these definitions, unless those \
symbols have the attribute ",
 Cell[BoxData[
  ButtonBox["Protected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Protected"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " does not show rules associated with symbols that have attribute ",
 Cell[BoxData[
  ButtonBox["ReadProtected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadProtected"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16097]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77918436],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->41161551],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27225028],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", 
   RowBox[{"x", "^", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172481518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->60019099],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlVs1OwzAMzpq2qNuAaRcmuBQkxAvwAIDEduIhqglpOyDQ2HMj3qA4P249
N1nTdjcqtYmT2P5sJ1/6Vuw37x/Ffrsu8tWu+Nps19/58nMHQ3IkRPQqhHhc
COiX0NMvPit4a9FIEXwlLEqgjaCd2xZXPehValbIalhrUTmDTwqiZONo5b7y
FcNkrKSYIlMeI9tOmI3Ujl+wdaibadvGtR5toHPKtX/oTD0+FdIE2rShgd7H
nb1La/ucjS9YXJOTWZ7aKM7cHmIaEUbdL1+XLXnC2mFUVXfwbuC7Qu9YMWba
cybnTK4QVNr0TNx6VptgXo7aeiKzguA0yX8+ahkl1/n9z5LKuKrLrKxr/1u6
ajErm/n96biS74brsmbOcAshrHnDZH7O/R4OzlVvplX223k686LgeJ23R3f+
TSgSEcRTPOPhGH1cehWEBLV5hof7Ry4Py8hwHB25n2oOrNDp9nK3Gwf/iDj2
8Jy13TL85Pg9SYKFcs8d0+BZdP2HufmuvyaNwrX3DjVdNaJ3tuFtrIfhdzH6
A8tNOXU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->180830709]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->327383889],

Cell[TextData[{
 "For built-in symbols, ",
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " gives attributes, defaults, and options, just like ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " does:"
}], "ExampleText",
 CellID->26013284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "Information", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204249407],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Attributes", "[", "Information", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"HoldAll", ",", "Protected", ",", "ReadProtected"}], 
          "}"}]}]},
       {" "},
       {GridBox[{
          {
           RowBox[{
            RowBox[{"Options", "[", "Information", "]"}], "=", 
            RowBox[{"{", 
             RowBox[{"LongForm", "\[Rule]", "True"}], "}"}]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[Information],
  Editable->False]], "Output",
 ImageSize->{585, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190501634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "Information", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17595473],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Information", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected", ",", "ReadProtected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Information", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"LongForm", "\[Rule]", "True"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Information],
  Editable->False]], "Output",
 ImageSize->{585, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->470455024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96998467],

Cell[TextData[{
 "For user-defined symbols, ",
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " gives attributes, defaults, options, and definitions:"
}], "ExampleText",
 CellID->38391316],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111435805],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", 
   RowBox[{"x", "^", "2"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->68482110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->840306275],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWN1q1EAUnu4ku+62aq2oxd6sovQdxAtb0OKFlz7AUoT2QpTad7G+pPgG
cSaZk5x88yWTbIoUDGwmZ3L+/+ZkP22uL7583Vxfnm/WZ1eb7xeX5z/WH75d
uS27Y8zsvTHm86Fxz4V7Kn9ynblfA1bQzN2tQ8rdOnPrQVgF67jE8m+NrbdL
Kg0v3W3uQAv7wuV1LStzLzMPZVozL3EW1l3gMQ/7DwBPaJcl70p0uRtpR+FG
vnvY65DpNc3dOo8oRPpqtHQbeN+H/UOwa/fWOO8FKxZcQqYtEqu389fDhJ8k
dmJV/Tg5GzAryow1K6A+AHgNcK1BTa1r4kUHdmXMaS+vd+qtUXpWzj/p5SwQ
q9//GfIe93HZL5rY/ylYLPaL2L+/R2JiNjwvms45nMOQrnkEMNZ5t4RWXW3d
aT3/dJ9edmqB+tLTY3z/zbUmZlCfQo8P17Grlz4bpIlQo4eny5dePswj0/UY
2fs15cQI3V4ujztxZCJC3Yf7LHXKYOV0S7JKF917XgIFepHNYbzfbU+prWC5
16ZkMdJndtW3JR534XS5S9DHovGgX58UbU++KWLf/6op9RuMAebqW8LppuRk
6yDLpbPThsrJ1coqmNWiDWtmmm8E1odykmWoP+qg+YmcVVhzJZdlb2V3NIFH
XRf6Cd1ZED1jTtGEL7wWgBnwh58Cff0qD764x+haVtB+zv3RoXGHr1Jfa9DZ
+yMl+YacUXuE6dnHY8Rt7vE5+pZ9u/Xp8ojp3hsbnhv5CJtotBWMOe1vP0ta
jck4/etISKWzeX1SdSQmODZHeDgb5XPW9/ztZmtfz6R3kNM4ntEs1XRKJqV8
h109hT+iJqnGtd2pPpS0rDsukof6ZMLTsDV7Zg1t/D+HcNFZxs6xoecm85VU
S0bk2UjDrvzH/cZDqZ6JOmMPxC+Rxwl+Y7MM3+OsjBXEvrKaXPBRO1Jeqy6/
+yqsekapp7wWtiV1+zRgy7976BV/q2ZB4TJ2+jQ7fwH0rJDD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->58962766]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->66522135],

Cell[TextData[{
 "For a symbol whose definition does not depend on others, it is equivalent \
to ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->230273584],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->532346921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->327204605],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV81OwzAMDk3bsY0fMQSahISGBOLMFXGAAyAOPMSEkLYDAgHvwnjakrRx
63x1m5UBFyotrpP480/s1Lufvs8en6bv84fp5PZ1+jKbP7xNbp5fzZReUyq6
VkqdjZV5z8xb/qPn1vwqtuAGZozMppGjtHparipdTqu+GVLDapgnqZNcqlgu
HrsptmzMLbGaIkeHgJW6+S3YR7L9HDwCqQT4yNdpXjYa9FjrEkPTmgRpHCyl
UTu8TZgfg/3DldA2nLW9b6EuH5XtQDR+54wt1QwkXsqrEfCHwPto2umIMz/z
jxqkCkevWlcv2aqq2d8uS5xUnf+Zu8uq3LF0L/OjeJ7Vo/pZSvIVzD7MlwsB
aZEj2ckitenh2aNdxiaMSnUR4byTtTR2spZK1ZqQAS32ow0cj/QMHE2YXsSt
/CZrCV0lvLJLd7z7oT7TE+ysI2F1R4TVg51ufyqioC/4hcLYJi4W65Kc5wUi
t8SjweKGWCFmC58Cbwf/pCjfEBmtR178QshnJPvcEnOMLXoVOqMdyfbWs5Fz
I+ngk3jajMectsNHLst3Skh/fRJU6Vq4WVaqjkDXoht8jzvFXLr37LD4dqwj
ujtAE/UdQoX+aCaFYoe3emh/h5oULS79Dt1DQc+az4XykH+Z8GtIPR+v7moF
u0Oe1ZRVy+ZPKMK8WmJBn65Z2JT/OF9FKHRnos14B2K/vhvA65pluI7/ALGC
sLfyc8Ge2gGLWvHY2WNHeY9Sdnnebi3U7b7bTf+CMCp2KHpBQunafaq1L+cJ
c34=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38496473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->971508530],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{585, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->123443464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512748707],

Cell["For read-protected symbols, definitions are not given:", "ExampleText",
 CellID->166279895],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", "ReadProtected", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->4394155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318955566],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Attributes", "[", "f", "]"}], "=", 
         RowBox[{"{", "ReadProtected", "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->386636863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129927142],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " lists defaults, options, attributes, and values:"
}], "ExampleText",
 CellID->636827858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "Union", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9679424],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Attributes", "[", "Union", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]}]},
       {" "},
       {GridBox[{
          {
           RowBox[{
            RowBox[{"Options", "[", "Union", "]"}], "=", 
            RowBox[{"{", 
             RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[Union],
  Editable->False]], "Output",
 ImageSize->{585, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64302297]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefaultValues", "[", "Union", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300679346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"Options", "[", "Union", "]"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"{", 
    RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81769326]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Union", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86991958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5221296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71457300],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " writes the output of ",
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " to a file:"
}], "ExampleText",
 CellID->56842871],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482287711],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", 
   RowBox[{"x", "^", "2"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->148775406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<stdout\>\"", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25719132],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Attributes", "[", "f", "]"}], "=", 
         RowBox[{"{", "Listable", "}"}]}]},
       {" "},
       {GridBox[{
          {
           RowBox[{
            RowBox[{"f", "[", "x_", "]"}], ":=", 
            RowBox[{"g", "[", 
             SuperscriptBox["x", "2"], "]"}]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]},
    {" "},
    {GridBox[{
       {GridBox[{
          {
           RowBox[{
            RowBox[{"g", "[", "x_", "]"}], ":=", 
            SuperscriptBox["x", "3"]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[$CellContext`f],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->297911508]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->129537672],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " is an output form; it does not evaluate:"
}], "ExampleText",
 CellID->49887158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullDefinition", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145948613],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Attributes", "[", "Plus", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{
          "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity",
            ",", "Orderless", ",", "Protected"}], "}"}]}]},
       {" "},
       {GridBox[{
          {
           RowBox[{
            RowBox[{"Default", "[", "Plus", "]"}], ":=", "0"}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[Plus],
  Editable->False]], "Output",
 ImageSize->{592, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50554029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->460514176],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"FullDefinition", "[", "Plus", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->322823572]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12578],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Definition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Definition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3065],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->27065]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FullDefinition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 37.3459352}", "context" -> "System`", 
    "keywords" -> {
     "attributes", "definitions", "dependent definitions", 
      "saving definitions", "transitive definitions"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FullDefinition[symbol] prints as the definitions given for symbol, and \
all symbols on which these depend. ", "synonyms" -> {"full definition"}, 
    "title" -> "FullDefinition", "type" -> "Symbol", "uri" -> 
    "ref/FullDefinition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4542, 156, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->77918436]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27813, 962}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1419, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2042, 62, 52, 1, 70, "ObjectName",
 CellID->16955],
Cell[2097, 65, 615, 18, 70, "Usage",
 CellID->23183]
}, Open  ]],
Cell[CellGroupData[{
Cell[2749, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3227, 105, 317, 12, 70, "Notes",
 CellID->8394],
Cell[3547, 119, 575, 18, 70, "Notes",
 CellID->30180],
Cell[4125, 139, 380, 12, 70, "Notes",
 CellID->16097]
}, Closed]],
Cell[CellGroupData[{
Cell[4542, 156, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77918436],
Cell[CellGroupData[{
Cell[4926, 170, 147, 5, 70, "ExampleSection",
 CellID->41161551],
Cell[5076, 177, 144, 5, 70, "Input",
 CellID->27225028],
Cell[5223, 184, 174, 6, 70, "Input",
 CellID->172481518],
Cell[CellGroupData[{
Cell[5422, 194, 109, 3, 28, "Input",
 CellID->60019099],
Cell[5534, 199, 769, 17, 73, "Output",
 Evaluatable->False,
 CellID->180830709]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6352, 222, 220, 7, 70, "ExampleSection",
 CellID->327383889],
Cell[6575, 231, 401, 13, 70, "ExampleText",
 CellID->26013284],
Cell[CellGroupData[{
Cell[7001, 248, 120, 3, 70, "Input",
 CellID->204249407],
Cell[7124, 253, 1389, 40, 66, "Output",
 CellID->190501634]
}, Open  ]],
Cell[CellGroupData[{
Cell[8550, 298, 115, 3, 70, "Input",
 CellID->17595473],
Cell[8668, 303, 1110, 33, 66, "Output",
 CellID->470455024]
}, Open  ]],
Cell[9793, 339, 124, 3, 70, "ExampleDelimiter",
 CellID->96998467],
Cell[9920, 344, 273, 8, 70, "ExampleText",
 CellID->38391316],
Cell[10196, 354, 145, 5, 70, "Input",
 CellID->111435805],
Cell[10344, 361, 274, 9, 70, "Input",
 CellID->68482110],
Cell[CellGroupData[{
Cell[10643, 374, 110, 3, 70, "Input",
 CellID->840306275],
Cell[10756, 379, 1235, 24, 70, "Output",
 Evaluatable->False,
 CellID->58962766]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12040, 409, 236, 7, 70, "ExampleSection",
 CellID->66522135],
Cell[12279, 418, 266, 9, 70, "ExampleText",
 CellID->230273584],
Cell[12548, 429, 246, 8, 70, "Input",
 CellID->532346921],
Cell[CellGroupData[{
Cell[12819, 441, 110, 3, 70, "Input",
 CellID->327204605],
Cell[12932, 446, 1008, 21, 70, "Output",
 Evaluatable->False,
 CellID->38496473]
}, Open  ]],
Cell[CellGroupData[{
Cell[13977, 472, 106, 3, 70, "Input",
 CellID->971508530],
Cell[14086, 477, 986, 31, 70, "Output",
 CellID->123443464]
}, Open  ]],
Cell[15087, 511, 125, 3, 70, "ExampleDelimiter",
 CellID->512748707],
Cell[15215, 516, 97, 1, 70, "ExampleText",
 CellID->166279895],
Cell[15315, 519, 274, 9, 70, "Input",
 CellID->4394155],
Cell[CellGroupData[{
Cell[15614, 532, 110, 3, 70, "Input",
 CellID->318955566],
Cell[15727, 537, 744, 23, 36, "Output",
 CellID->386636863]
}, Open  ]],
Cell[16486, 563, 125, 3, 70, "ExampleDelimiter",
 CellID->129927142],
Cell[16614, 568, 238, 7, 70, "ExampleText",
 CellID->636827858],
Cell[CellGroupData[{
Cell[16877, 579, 112, 3, 70, "Input",
 CellID->9679424],
Cell[16992, 584, 1359, 39, 66, "Output",
 CellID->64302297]
}, Open  ]],
Cell[CellGroupData[{
Cell[18388, 628, 113, 3, 70, "Input",
 CellID->300679346],
Cell[18504, 633, 365, 11, 36, "Output",
 CellID->81769326]
}, Open  ]],
Cell[CellGroupData[{
Cell[18906, 649, 109, 3, 70, "Input",
 CellID->86991958],
Cell[19018, 654, 233, 7, 36, "Output",
 CellID->5221296]
}, Open  ]],
Cell[19266, 664, 124, 3, 70, "ExampleDelimiter",
 CellID->71457300],
Cell[19393, 669, 337, 12, 70, "ExampleText",
 CellID->56842871],
Cell[19733, 683, 145, 5, 70, "Input",
 CellID->482287711],
Cell[19881, 690, 275, 9, 70, "Input",
 CellID->148775406],
Cell[CellGroupData[{
Cell[20181, 703, 135, 4, 70, "Input",
 CellID->25719132],
Cell[20319, 709, 1929, 55, 70, "Print",
 CellID->297911508]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22297, 770, 230, 7, 70, "ExampleSection",
 CellID->129537672],
Cell[22530, 779, 229, 7, 70, "ExampleText",
 CellID->49887158],
Cell[CellGroupData[{
Cell[22784, 790, 113, 3, 70, "Input",
 CellID->145948613],
Cell[22900, 795, 1351, 39, 66, "Output",
 CellID->50554029]
}, Open  ]],
Cell[CellGroupData[{
Cell[24288, 839, 104, 3, 70, "Input",
 CellID->460514176],
Cell[24395, 844, 335, 12, 50, "Output",
 CellID->322823572]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24791, 863, 311, 9, 70, "SeeAlsoSection",
 CellID->12578],
Cell[25105, 874, 698, 26, 70, "SeeAlso",
 CellID->21078]
}, Open  ]],
Cell[CellGroupData[{
Cell[25840, 905, 313, 9, 70, "TutorialsSection",
 CellID->3065],
Cell[26156, 916, 429, 12, 70, "Tutorials",
 CellID->27065]
}, Open  ]],
Cell[26600, 931, 27, 0, 70, "History"],
Cell[26630, 933, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

