(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     80732,       3052]
NotebookOptionsPosition[     65999,       2531]
NotebookOutlinePosition[     67608,       2573]
CellTagsIndexPosition[     67522,       2568]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Everything Is an Expression" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EverythingIsAnExpression"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:tutorial/PartsOfExpressions"], 
          "Introduction to Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/Introduction-Patterns"], 
          "Patterns for Some Common Types of Expression" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"], 
          "Forms of Input and Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormsOfInputAndOutput"], 
          "The Interpretation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheInterpretationOfTextualForms"], 
          "The Representation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfTextualForms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Everything Is an Expression\"\>", 
       2->"\<\"Parts of Expressions\"\>", 
       3->"\<\"Introduction to Patterns\"\>", 
       4->"\<\"Patterns for Some Common Types of Expression\"\>", 
       5->"\<\"Forms of Input and Output\"\>", 
       6->"\<\"The Interpretation of Textual Forms\"\>", 
       7->"\<\"The Representation of Textual Forms\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InputForm" :> Documentation`HelpLookup["paclet:ref/InputForm"],
           "TreeForm" :> Documentation`HelpLookup["paclet:ref/TreeForm"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"InputForm\"\>", 
       2->"\<\"TreeForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Expressions\"\>", 
       2->"\<\"Expression Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FullForm", "ObjectName",
 CellID->4860],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FullForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FullForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as the full form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", with no special syntax. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29253]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects display, but not evaluation.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->45936541]
}], "Notes",
 CellID->11777],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " always effectively uses ",
 Cell[BoxData["\"\<PrintableASCII\>\""], "InlineFormula"],
 " as the setting for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31348],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberMarks"]], "InlineFormula"],
 " can be used to specify whether ",
 Cell[BoxData["`"], "InlineFormula"],
 " marks should be used to indicate type, precision or accuracy of \
approximate numbers. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->790786255]
}], "Notes",
 CellID->12503]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195153245],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->185299168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a typeset expression:"
}], "ExampleText",
 CellID->134753518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   FractionBox["x", 
    SqrtBox["5"]], "+", 
   SuperscriptBox["y", "2"], "+", 
   RowBox[{"1", "/", "z"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330426462],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{"5", ",", 
         RowBox[{"Rational", "[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "2"}], "]"}]}], "]"}], ",", "x"}], "]"}], 
     ",", 
     RowBox[{"Power", "[", 
      RowBox[{"y", ",", "2"}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"z", ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->227462836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->665522819],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a graphic:"
}], "ExampleText",
 CellID->241319587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  GraphicsBox[{
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
    {RGBColor[0, 0, 1], 
     RectangleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
      NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}}], "//", 
  "FullForm"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[1]:=",
 CellID->519156385],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Graphics", "[", 
    RowBox[{"List", "[", 
     RowBox[{
      RowBox[{"List", "[", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{"List", "[", 
          RowBox[{"0", ",", "0"}], "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"List", "[", 
       RowBox[{
        RowBox[{"RGBColor", "[", 
         RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{"List", "[", 
          RowBox[{
           RowBox[{"Rational", "[", 
            RowBox[{"1", ",", "2"}], "]"}], ",", 
           RowBox[{"Rational", "[", 
            RowBox[{"1", ",", "2"}], "]"}]}], "]"}], "]"}]}], "]"}]}], "]"}], 
    "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{520, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->374528508]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->97868907],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Objects",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->37950378],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers: "
}], "ExampleText",
 CellID->17800827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"FullForm", ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", 
     RowBox[{"1", "/", "23"}], ",", "1.23", ",", 
     RowBox[{"1", "+", 
      RowBox[{"23", "\[ImaginaryI]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540624369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox["123",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Rational", "[", 
      RowBox[{"1", ",", "23"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["1.23`",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Complex", "[", 
      RowBox[{"1", ",", "23"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327416114]
}, Open  ]],

Cell[TextData[{
 "Arbitrary precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->738802486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "/", "3"}], ",", 
      RowBox[{
       RowBox[{"10", "/", "3"}], "\[ImaginaryI]"}]}], "}"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55230342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox["3.33333333333333333333333333333333333333`20.",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Complex", "[", 
      RowBox[{"0", ",", "3.33333333333333333333333333333333333333`20."}], 
      "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{408, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->455906671]
}, Open  ]],

Cell["Special constants:", "ExampleText",
 CellID->282669548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{"\[ImaginaryI]", ",", "\[Pi]", ",", "\[ExponentialE]"}], 
   "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->70178760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1VttOwzAMdXNpuY2JabAheNjXwBMfUU2Ttgc0NPYl++HgBKcLrqOWqY2U
uMdxfTnNpR/1cbv5rI+7db16P9Rf2936e/W2P6BKFwBwwj5dAj47fAr95BxK
40ftcWjwiIOHrygVyls2PyW9ZfonwS7FOkTTTLtg+IXhG4r2IHjz+kVmXonR
NNVmSHqrCiUlF5oiaEkaPk8ROW/RN+elJF/cnuMyyU2y935LQS9XGrS2wZR+
t7YZM7ZidF6VOeM2H3m/ntXrDpai3ZXAjmRX9a+iVQvn1IzOnqWsy16c8R3G
vd93cDRhuGK4cNmVNTorcfcNy4a0P1MWIBdtcBYUtNebiGWfF+ywXqvlj19u
MSEGL2PIuvOZq5vPHqc9H+kpy2vSydsK8qfwULXHLNM3/7k6Wlk8M6vZSLnP
RT/ymSdpvbMl8TtPeI58xNtfETbC97pzv7eVdAPjz0hmhOIHeK10YA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->177226162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343597416],

Cell["Characters and strings of characters:", "ExampleText",
 CellID->380723012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<\[Alpha]\>\"", ",", "\"\<\[CirclePlus]\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48683404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox["\"\<a\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[Alpha]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[CirclePlus]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->789882111]
}, Open  ]],

Cell["Control characters for strings:", "ExampleText",
 CellID->372453673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "\"\<A first line\nA second line\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49753538],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<A first line\\nA second line\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->5328240]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Input Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2549874],

Cell[TextData[{
 "Different inputs interpreted as ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->388790367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "^", "x"}], ",", 
    SuperscriptBox["a", "x"], ",", 
    RowBox[{"Sqrt", "[", "a", "]"}], ",", 
    SqrtBox["a"], ",", 
    RadicalBox["a", "3"], ",", 
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"1", "/", "x"}], ",", 
    FractionBox["1", "x"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25296522],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWVlv2zAMVi07TTskTne02UOL9GV72fYf1ocN2PEjgmJA+zBs6Pr/Pcs2
Y5UmLcm2fKQJkDikKekTDx3kz+3j3a/f28f72+3m68P279397b/Nlz8PKUse
CRGcCCGu1yL9n6T/si98XqTfksypj+lvkApllNxJi88MPy74kfbU33+waGcj
f8HIc3jPGfkfu1nq3NNC+obhnyF+iGhZyHH94vYm+beM/CdGfm3A9z2b9Tz9
lYVO1FOXEgUdps8gfUboPaBQfIn40F+FX/Ck1qdOSxhUwAek8q7yD0aq/nII
j7UZ1ukD07Mmmgn1WJoRaCAmguLpH0XdaEtGZ3U67B7FwhJF7rEniJu5RaSP
BV4D3BJnQFijjg7IvsNiHsfGkUsujRJHB93WhWvSIUXzc7FtPR+XTUrPY+J+
EMwVVDa7CKDt3etJtCsLtGOM2EVlRnbxaNe7z/jE/oH1Qa3ovepao5V3KC+Z
DYgJTkUKi82eEg+ALbbEhtt/SyCadicrB6TcKQ0jDIt4CUW5r3cZF1Lr23ck
+NKTPrYovI3zfJ+2ou4FlIf7xmC6a9TsC09W5fbrKyDClqjZF1xOcI1iAM6+
xA7k4M+UXanbLLkj9KhlRcaVMTHKvlE9Hcvkr1X8faK7MKCzjSbzvVpquPT7
NXXLV+SSnRn0FGk9R9r41Agg4/085EkreBdYJubbdqdY2Bu2yYOq/u0Lybmj
fTlf3iC51wnliadI6tpxdHo/MLWq2hWjpVcErBtzP1cGJFW74h4uG9lD3ZVV
t0qfyqpK+2o6r5D0OinXOIgAOI1LjYb7ZIz6VXpSWbM3zPsr1H6F3l+i93Sm
F2xA5bq7obAW3yXdZLxd5bkM/Sqp15Nrf6aMf75c4BPPe0Q3zYy7ynMZ/ZeI
75rRb1spCEkt4d20ywy990z0xHBIii+GqFjY5Aeen2ZmDTWT7b8V/CR9yFrv
O+Y9qdjMG/d2sIkvm7SrouWLoulG27+l4F47ZF5/asimW3HCFRGr/OJB1410
jXVn0nWWFyHPLZKddTcVobpI2+exx1gJc63CP1c94ZXMJM9H1wiqVOOqpkwX
40SrfVSOy7izHLTdUNt4hTVp23bl6L4it0jqs2c+619jwjB8ZRJnj4esTI5H
K671WttI2iAJXNcy19LcW/ipOdI2al9zHFOFNLdqtVJM1e5wzY/ju9YglSdK
jeZqkF3VNttVEMXRfz7XSCI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{521, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128779148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39993914],

Cell["Special typeset expressions:", "ExampleText",
 CellID->47897797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Product]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{"x", "\[Element]", "Reals"}], ",", 
    RowBox[{
     RowBox[{"x", "\[And]", "y"}], "\[Or]", "z"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177296101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{
      RowBox[{
       RowBox[{"Derivative", "[", "1", "]"}], "[", "y", "]"}], "[", "x", 
      "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"y", "[", "k", "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"k", ",", "1", ",", "n"}], "]"}]}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Product", "[", 
      RowBox[{
       RowBox[{"y", "[", "k", "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"k", ",", "1", ",", "n"}], "]"}]}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Reals"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Or", "[", 
      RowBox[{
       RowBox[{"And", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{457, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16812784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->75489193],

Cell["Different list structures:", "ExampleText",
 CellID->59640089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287661578],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"1", ",", "2", ",", "3"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->82132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"a", "b", "c"},
       {"d", "e", "f"}
      }], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->250695724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"List", "[", 
      RowBox[{
       RowBox[{"List", "[", 
        RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"d", ",", "e", ",", "f"}], "]"}]}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"List", "[", 
      RowBox[{
       RowBox[{"List", "[", 
        RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", 
       RowBox[{"List", "[", 
        RowBox[{"d", ",", "e", ",", "f"}], "]"}]}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{478, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->667720853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64498634],

Cell["Input without special interpretation: ", "ExampleText",
 CellID->250099490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    OverscriptBox["x", "a"], ",", 
    UnderscriptBox["x", "a"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246234492],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"Subscript", "[", 
      RowBox[{"x", ",", "a"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Overscript", "[", 
      RowBox[{"x", ",", "a"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Underscript", "[", 
      RowBox[{"x", ",", "a"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->878930340]
}, Open  ]],

Cell["\<\
With special characters in the same positions there may be special \
interpretations:\
\>", "ExampleText",
 CellID->208413776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "-"], ",", 
    OverscriptBox["x", "_"], ",", 
    UnderscriptBox["x", "_"]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->447735933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"SubMinus", "[", "x", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"OverBar", "[", "x", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"UnderBar", "[", "x", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195030762]
}, Open  ]],

Cell[TextData[{
 "In the case of superscripts, most things get interpreted as ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->197260386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["x", "a"], ",", 
    SubsuperscriptBox["x", "b", "a"], ",", 
    SuperscriptBox["x", "\[Dagger]"]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48008657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "a"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Subscript", "[", 
        RowBox[{"x", ",", "b"}], "]"}], ",", "a"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"SuperDagger", "[", "x", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->49987960]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Output Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->61550611],

Cell["Some objects use a special output representation:", "ExampleText",
 CellID->483444329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270064825],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->793505636]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25363306],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SeriesData", "[", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", "0", ",", 
       RowBox[{"Rational", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "6"}], "]"}]}], "]"}], ",", "1", ",", "4", 
     ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->121297744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114163562],

Cell["Some objects use an elided output representation:", "ExampleText",
 CellID->44344902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3464128],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340967527]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298336904],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258364174]
}, Open  ]],

Cell[TextData[{
 "The elided parts are visible in the underlying ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->715801975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "i", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->400554568],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"List", "[", 
      RowBox[{"List", "[", 
       RowBox[{"1", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"List", "[", 
      RowBox[{"3", ",", "1", ",", "0", ",", 
       RowBox[{"List", "[", "4", "]"}], ",", 
       RowBox[{"List", "[", "4", "]"}], ",", "0", ",", "0", ",", "0", ",", 
       "0"}], "]"}], ",", 
     RowBox[{"List", "[", 
      RowBox[{"List", "[", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"List", "[", 
      RowBox[{
       RowBox[{"List", "[", "1", "]"}], ",", 
       RowBox[{"List", "[", "2", "]"}], ",", 
       RowBox[{"List", "[", "3", "]"}], ",", 
       RowBox[{"List", "[", "1", "]"}]}], "]"}], ",", 
     RowBox[{"List", "[", "Automatic", "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{564, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->656981312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->352112550],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SparseArray", "[", 
    RowBox[{"Automatic", ",", 
     RowBox[{"List", "[", 
      RowBox[{"5", ",", "5"}], "]"}], ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", 
       RowBox[{"List", "[", 
        RowBox[{
         RowBox[{"List", "[", 
          RowBox[{"0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
          "]"}], ",", 
         RowBox[{"List", "[", 
          RowBox[{"List", "[", "2", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"List", "[", "1", "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{423, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->90341674]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23608994],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "NumberMarks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->220286672],

Cell["Inexact numbers format without number marks by default:", "ExampleText",
 CellID->790786255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "4.567", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9253],

Cell[BoxData[
 TagBox[
  StyleBox["4.567`",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->441289714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"10", "/", "3"}], ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9775504],

Cell[BoxData[
 TagBox[
  StyleBox["3.33333333333333333333333333333333333333`20.",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->369374490]
}, Open  ]],

Cell["The same numbers without number marks:", "ExampleText",
 CellID->118644570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"4.567", ",", 
   RowBox[{"NumberMarks", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10635],

Cell[BoxData[
 TagBox[
  StyleBox["4.567`",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True],
  FullForm[#, NumberMarks -> False]& ]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->2400333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"10", "/", "3"}], ",", "20"}], "]"}], ",", 
   RowBox[{"NumberMarks", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9480521],

Cell[BoxData[
 TagBox[
  StyleBox["3.33333333333333333333333333333333333333`20.",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True],
  FullForm[#, NumberMarks -> False]& ]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->296392431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193140487],

Cell["A mixed symbolic and numeric expression:", "ExampleText",
 CellID->272574660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"10", ",", "4"}], "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{".25", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32636895],

Cell[BoxData[
 RowBox[{"10.`3.9999999999999996", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"0.25`", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39125948]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "expr", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114743573],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"10.`3.9999999999999996", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"Times", "[", 
       RowBox[{"0.25`", ",", "x"}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{356, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->274842218]
}, Open  ]],

Cell["Omit all number marks:", "ExampleText",
 CellID->526773851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"NumberMarks", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->463527511],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"10.`3.9999999999999996", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"Times", "[", 
       RowBox[{"0.25`", ",", "x"}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True],
  FullForm[#, NumberMarks -> False]& ]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->11651405]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->605093],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " will show the precedence of operators:"
}], "ExampleText",
 CellID->31203489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"a", " ", "b"}], "+", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348136607],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{"Times", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->13829637]
}, Open  ]],

Cell["Grouping with parentheses effects the precedence:", "ExampleText",
 CellID->456889126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->314599141],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Plus", "[", 
      RowBox[{"b", ",", "c"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->693616622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70706763],

Cell[TextData[{
 "See the underlying interpretation for a ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " output:"
}], "ExampleText",
 CellID->985401790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->595290287],

Cell[BoxData[
 FormBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"sinh", "(", 
    FractionBox["\[Pi]", "n"], ")"}]}], TraditionalForm]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->254857750]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118096096],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Complex", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", 
     RowBox[{"Sinh", "[", 
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"Power", "[", 
         RowBox[{"n", ",", 
          RowBox[{"-", "1"}]}], "]"}], ",", "Pi"}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{351, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->207401389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->874281701],

Cell["Perform replacements:", "ExampleText",
 CellID->13945527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", "b", ",", 
    RowBox[{"{", 
     RowBox[{"{", "c", "}"}], "}"}]}], "}"}], "//", "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50757811],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"List", "[", "a", "]"}], ",", "b", ",", 
     RowBox[{"List", "[", 
      RowBox[{"List", "[", "c", "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->148352998]
}, Open  ]],

Cell[TextData[{
 "Replace lists with a new wrapper ",
 Cell[BoxData[
  StyleBox["newhead", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->169565324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", "b", ",", 
    RowBox[{"{", 
     RowBox[{"{", "c", "}"}], "}"}]}], "}"}], "/.", 
  RowBox[{"List", "\[Rule]", "newhead"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->313189738],

Cell[BoxData[
 RowBox[{"newhead", "[", 
  RowBox[{
   RowBox[{"newhead", "[", "a", "]"}], ",", "b", ",", 
   RowBox[{"newhead", "[", 
    RowBox[{"newhead", "[", "c", "]"}], "]"}]}], "]"}]], "Output",
 ImageSize->{300, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490227013]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->767454738],

Cell[TextData[{
 "Multiplications have the head ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4909310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"a", "+", 
   RowBox[{"b", 
    RowBox[{"(", 
     RowBox[{"c", "-", "d"}], ")"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->803612336],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"c", "-", "d"}], ")"}]}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22361246]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "expr", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->966948151],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Times", "[", 
      RowBox[{"b", ",", 
       RowBox[{"Plus", "[", 
        RowBox[{"c", ",", 
         RowBox[{"Times", "[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "d"}], "]"}]}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{274, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->226952874]
}, Open  ]],

Cell[TextData[{
 "Find all multiplications in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9644941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{"expr", ",", "_Times", ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152566766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "d"}], ",", 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"c", "-", "d"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->91854150]
}, Open  ]],

Cell["See the underlying expressions:", "ExampleText",
 CellID->502183238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"FullForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->111822043],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "d"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Times", "[", 
      RowBox[{"b", ",", 
       RowBox[{"Plus", "[", 
        RowBox[{"c", ",", 
         RowBox[{"Times", "[", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "d"}], "]"}]}], "]"}]}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{321, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->117941603]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->689554430],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " effects display but not evaluation:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->45936541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"x", "^", "n"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145860351],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{"1", ",", "n"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Plus", "[", 
        RowBox[{"1", ",", "n"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{341, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->501637435]
}, Open  ]],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " to the evaluated integral:"
}], "ExampleText",
 CellID->72664848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->486321574],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45854595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->46625405],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{"1", ",", "n"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Plus", "[", 
        RowBox[{"1", ",", "n"}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{341, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->850568949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->579768991],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " has linear formatting without special syntax:"
}], "ExampleText",
 CellID->27134552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"1", "/", "a"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106470571],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->755756924]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " formats as linear input:"
}], "ExampleText",
 CellID->331187995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   RowBox[{"1", "/", "a"}], "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->210440999],

Cell["a^(-1) + x^2", "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->797545972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6950531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 " graphically displays an expression's tree structure:"
}], "ExampleText",
 CellID->36353769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609632377],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{"a", ",", "b"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{281, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->129583612]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1232133],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.6681153124565982`, 2.5021729686848975`}, {
    0.8340576562282991, 1.6681153124565984`}, {0.41702882811414954`, 
    0.8340576562282993}, {0., 0.}, {0.8340576562282991, 0.}, {
    1.2510864843424487`, 0.8340576562282993}, {2.5021729686848975`, 
    1.6681153124565984`}, {2.0851441405707476`, 0.8340576562282993}, {
    2.919201796799047, 0.8340576562282993}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 7}], 
      LineBox[{2, 3}], LineBox[{2, 6}], LineBox[{3, 4}], LineBox[{3, 5}], 
      LineBox[{7, 8}], LineBox[{7, 9}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         FractionBox[
          SuperscriptBox["x", "2"], 
          RowBox[{"a", "+", "b"}]], HoldForm]],
       Annotation[#, 
        HoldForm[($CellContext`a + $CellContext`b)^(-1) $CellContext`x^2], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         FractionBox["1", 
          RowBox[{"a", "+", "b"}]], HoldForm]],
       Annotation[#, 
        HoldForm[($CellContext`a + $CellContext`b)^(-1)], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"a", "+", "b"}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`a + $CellContext`b], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["a",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["a", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`a], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["b",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["b", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`b], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"-", "1"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         RowBox[{"-", "1"}], HoldForm]],
       Annotation[#, 
        HoldForm[-1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ]}},
    ContentSelectable->Automatic],
   Annotation[#, 
    VertexCoordinateRules -> {{1.6681153124565982`, 2.5021729686848975`}, {
     0.8340576562282991, 1.6681153124565984`}, {0.41702882811414954`, 
     0.8340576562282993}, {0., 0.}, {0.8340576562282991, 0.}, {
     1.2510864843424487`, 0.8340576562282993}, {2.5021729686848975`, 
     1.6681153124565984`}, {2.0851441405707476`, 0.8340576562282993}, {
     2.919201796799047, 0.8340576562282993}}]& ],
  AlignmentPoint->Center,
  AspectRatio->0.9258200997725515,
  Axes->False,
  AxesLabel->None,
  AxesOrigin->Automatic,
  AxesStyle->{},
  Background->None,
  BaseStyle->{},
  BaselinePosition->Automatic,
  ColorOutput->Automatic,
  ContentSelectable->Automatic,
  DefaultAxesStyle->"GraphicsAxes",
  DefaultBaseStyle->"Graphics",
  DefaultFrameStyle->"GraphicsFrame",
  DefaultLabelStyle->"GraphicsLabel",
  DisplayFunction:>$DisplayFunction,
  Epilog->{},
  FormatType:>TraditionalForm,
  Frame->False,
  FrameLabel->None,
  FrameStyle->{},
  FrameTicks->None,
  FrameTicksStyle->{},
  GridLines->None,
  GridLinesStyle->{},
  ImageMargins->0.,
  ImagePadding->All,
  ImageSize->Automatic,
  LabelStyle->{},
  PlotLabel->None,
  PlotRange->All,
  PlotRangeClipping->False,
  PlotRangePadding->Scaled[0.1],
  PlotRegion->Automatic,
  Prolog->{},
  RotateLabel->True,
  Ticks->Automatic,
  TicksStyle->{}]], "Output",
 ImageSize->{364, 333},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TreeForm=",
 CellID->13572665]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->115797493],

Cell["Pattern matching is based on the FullForm:", "ExampleText",
 CellID->53407022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "\[Rule]", "sq2"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150990736],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["2"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248410554]
}, Open  ]],

Cell[TextData[{
 "The previous fraction is represented as a single ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->138848745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258666764],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"2", ",", 
     RowBox[{"Rational", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->827599287]
}, Open  ]],

Cell["Perform the desired replacement:", "ExampleText",
 CellID->65852761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Sqrt", "[", "2", "]"}]}], "/.", 
  StyleBox[
   RowBox[{
    RowBox[{"Power", "[", 
     RowBox[{"2", ",", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}]}], "]"}], "->", 
    RowBox[{"1", "/", "sq2"}]}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->269888159],

Cell[BoxData[
 FractionBox["1", "sq2"]], "Output",
 ImageSize->{30, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->223024600]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26281],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreeForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreeForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10861],

Cell[TextData[ButtonBox["Everything Is an Expression",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EverythingIsAnExpression"]], "Tutorials",
 CellID->22431],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartsOfExpressions"]], "Tutorials",
 CellID->12455],

Cell[TextData[ButtonBox["Introduction to Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Introduction-Patterns"]], "Tutorials",
 CellID->14197],

Cell[TextData[ButtonBox["Patterns for Some Common Types of Expression",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"]], "Tutorials",
 CellID->22106],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->8752],

Cell[TextData[ButtonBox["The Interpretation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheInterpretationOfTextualForms"]], "Tutorials",\

 CellID->27366],

Cell[TextData[ButtonBox["The Representation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfTextualForms"]], "Tutorials",\

 CellID->157498705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->31669042],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->19963735],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->247597751]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FullForm"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FullForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 37.7365702}", "context" -> "System`", 
    "keywords" -> {
     "communicating expressions", "communicating language", 
      "expression serialization", "expression trees", "functional notation", 
      "internal form", "language representation", "object serialization", 
      "output of internal form", "output of internal representation", 
      "pattern matching", "prefix form", "serialization", 
      "transmitting expressions", "tree representation"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FullForm[expr] prints as the full form of expr, with no special syntax. \
", "synonyms" -> {"full form"}, "title" -> "FullForm", "type" -> "Symbol", 
    "uri" -> "ref/FullForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6148, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->195153245]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 67379, 2561}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3119, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3742, 97, 45, 1, 70, "ObjectName",
 CellID->4860],
Cell[3790, 100, 575, 18, 70, "Usage",
 CellID->29253]
}, Open  ]],
Cell[CellGroupData[{
Cell[4402, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4880, 140, 364, 11, 70, "Notes",
 CellID->11777],
Cell[5247, 153, 422, 14, 70, "Notes",
 CellID->31348],
Cell[5672, 169, 439, 14, 70, "Notes",
 CellID->12503]
}, Closed]],
Cell[CellGroupData[{
Cell[6148, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195153245],
Cell[CellGroupData[{
Cell[6533, 202, 148, 5, 70, "ExampleSection",
 CellID->185299168],
Cell[6684, 209, 202, 7, 70, "ExampleText",
 CellID->134753518],
Cell[CellGroupData[{
Cell[6911, 220, 222, 8, 46, "Input",
 CellID->330426462],
Cell[7136, 230, 738, 26, 50, "Output",
 CellID->227462836]
}, Open  ]],
Cell[7889, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->665522819],
Cell[8017, 264, 191, 7, 70, "ExampleText",
 CellID->241319587],
Cell[CellGroupData[{
Cell[8233, 275, 372, 10, 70, "Input",
 CellID->519156385],
Cell[8608, 287, 1049, 33, 68, "Output",
 CellID->374528508]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9706, 326, 219, 7, 70, "ExampleSection",
 CellID->97868907],
Cell[CellGroupData[{
Cell[9950, 337, 233, 7, 70, "ExampleSubsection",
 CellID->37950378],
Cell[10186, 346, 555, 22, 70, "ExampleText",
 CellID->17800827],
Cell[CellGroupData[{
Cell[10766, 372, 291, 9, 70, "Input",
 CellID->540624369],
Cell[11060, 383, 893, 35, 36, "Output",
 CellID->327416114]
}, Open  ]],
Cell[11968, 421, 330, 13, 70, "ExampleText",
 CellID->738802486],
Cell[CellGroupData[{
Cell[12323, 438, 298, 11, 70, "Input",
 CellID->55230342],
Cell[12624, 451, 627, 22, 54, "Output",
 CellID->455906671]
}, Open  ]],
Cell[13266, 476, 61, 1, 70, "ExampleText",
 CellID->282669548],
Cell[CellGroupData[{
Cell[13352, 481, 190, 6, 70, "Input",
 CellID->70178760],
Cell[13545, 489, 695, 15, 70, "Output",
 Evaluatable->False,
 CellID->177226162]
}, Open  ]],
Cell[14255, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->343597416],
Cell[14383, 512, 80, 1, 70, "ExampleText",
 CellID->380723012],
Cell[CellGroupData[{
Cell[14488, 517, 207, 7, 70, "Input",
 CellID->48683404],
Cell[14698, 526, 658, 25, 36, "Output",
 CellID->789882111]
}, Open  ]],
Cell[15371, 554, 74, 1, 70, "ExampleText",
 CellID->372453673],
Cell[CellGroupData[{
Cell[15470, 559, 140, 4, 70, "Input",
 CellID->49753538],
Cell[15613, 565, 323, 11, 50, "Output",
 CellID->5328240]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15985, 582, 238, 7, 70, "ExampleSubsection",
 CellID->2549874],
Cell[16226, 591, 221, 8, 70, "ExampleText",
 CellID->388790367],
Cell[CellGroupData[{
Cell[16472, 603, 406, 13, 70, "Input",
 CellID->25296522],
Cell[16881, 618, 1456, 28, 70, "Output",
 Evaluatable->False,
 CellID->128779148]
}, Open  ]],
Cell[18352, 649, 124, 3, 70, "ExampleDelimiter",
 CellID->39993914],
Cell[18479, 654, 70, 1, 70, "ExampleText",
 CellID->47897797],
Cell[CellGroupData[{
Cell[18574, 659, 696, 22, 70, "Input",
 CellID->177296101],
Cell[19273, 683, 1783, 66, 54, "Output",
 CellID->16812784]
}, Open  ]],
Cell[21071, 752, 124, 3, 70, "ExampleDelimiter",
 CellID->75489193],
Cell[21198, 757, 68, 1, 70, "ExampleText",
 CellID->59640089],
Cell[CellGroupData[{
Cell[21291, 762, 161, 5, 70, "Input",
 CellID->287661578],
Cell[21455, 769, 352, 13, 50, "Output",
 CellID->82132]
}, Open  ]],
Cell[CellGroupData[{
Cell[21844, 787, 417, 16, 70, "Input",
 CellID->250695724],
Cell[22264, 805, 892, 31, 36, "Output",
 CellID->667720853]
}, Open  ]],
Cell[23171, 839, 124, 3, 70, "ExampleDelimiter",
 CellID->64498634],
Cell[23298, 844, 81, 1, 70, "ExampleText",
 CellID->250099490],
Cell[CellGroupData[{
Cell[23404, 849, 232, 8, 70, "Input",
 CellID->246234492],
Cell[23639, 859, 814, 31, 36, "Output",
 CellID->878930340]
}, Open  ]],
Cell[24468, 893, 136, 4, 70, "ExampleText",
 CellID->208413776],
Cell[CellGroupData[{
Cell[24629, 901, 232, 8, 70, "Input",
 CellID->447735933],
Cell[24864, 911, 726, 28, 36, "Output",
 CellID->195030762]
}, Open  ]],
Cell[25605, 942, 238, 8, 70, "ExampleText",
 CellID->197260386],
Cell[CellGroupData[{
Cell[25868, 954, 250, 8, 70, "Input",
 CellID->48008657],
Cell[26121, 964, 847, 32, 36, "Output",
 CellID->49987960]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27017, 1002, 240, 7, 70, "ExampleSubsection",
 CellID->61550611],
Cell[27260, 1011, 92, 1, 70, "ExampleText",
 CellID->483444329],
Cell[CellGroupData[{
Cell[27377, 1016, 215, 7, 70, "Input",
 CellID->270064825],
Cell[27595, 1025, 500, 17, 54, "Output",
 CellID->793505636]
}, Open  ]],
Cell[CellGroupData[{
Cell[28132, 1047, 103, 3, 70, "Input",
 CellID->25363306],
Cell[28238, 1052, 564, 19, 50, "Output",
 CellID->121297744]
}, Open  ]],
Cell[28817, 1074, 125, 3, 70, "ExampleDelimiter",
 CellID->114163562],
Cell[28945, 1079, 91, 1, 70, "ExampleText",
 CellID->44344902],
Cell[CellGroupData[{
Cell[29061, 1084, 199, 6, 70, "Input",
 CellID->3464128],
Cell[29263, 1092, 356, 13, 36, "Output",
 CellID->340967527]
}, Open  ]],
Cell[CellGroupData[{
Cell[29656, 1110, 317, 11, 70, "Input",
 CellID->298336904],
Cell[29976, 1123, 479, 17, 36, "Output",
 CellID->258364174]
}, Open  ]],
Cell[30470, 1143, 230, 8, 70, "ExampleText",
 CellID->715801975],
Cell[CellGroupData[{
Cell[30725, 1155, 104, 3, 70, "Input",
 CellID->400554568],
Cell[30832, 1160, 1086, 31, 68, "Output",
 CellID->656981312]
}, Open  ]],
Cell[CellGroupData[{
Cell[31955, 1196, 104, 3, 70, "Input",
 CellID->352112550],
Cell[32062, 1201, 811, 25, 68, "Output",
 CellID->90341674]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[32934, 1233, 221, 7, 70, "ExampleSection",
 CellID->23608994],
Cell[CellGroupData[{
Cell[33180, 1244, 232, 7, 70, "ExampleSubsection",
 CellID->220286672],
Cell[33415, 1253, 98, 1, 70, "ExampleText",
 CellID->790786255],
Cell[CellGroupData[{
Cell[33538, 1258, 103, 3, 70, "Input",
 CellID->9253],
Cell[33644, 1263, 294, 11, 50, "Output",
 CellID->441289714]
}, Open  ]],
Cell[CellGroupData[{
Cell[33975, 1279, 181, 6, 70, "Input",
 CellID->9775504],
Cell[34159, 1287, 333, 11, 50, "Output",
 CellID->369374490]
}, Open  ]],
Cell[34507, 1301, 81, 1, 70, "ExampleText",
 CellID->118644570],
Cell[CellGroupData[{
Cell[34613, 1306, 166, 5, 70, "Input",
 CellID->10635],
Cell[34782, 1313, 297, 10, 50, "Output",
 CellID->2400333]
}, Open  ]],
Cell[CellGroupData[{
Cell[35116, 1328, 246, 8, 70, "Input",
 CellID->9480521],
Cell[35365, 1338, 338, 10, 50, "Output",
 CellID->296392431]
}, Open  ]],
Cell[35718, 1351, 125, 3, 70, "ExampleDelimiter",
 CellID->193140487],
Cell[35846, 1356, 83, 1, 70, "ExampleText",
 CellID->272574660],
Cell[CellGroupData[{
Cell[35954, 1361, 220, 8, 70, "Input",
 CellID->32636895],
Cell[36177, 1371, 259, 8, 36, "Output",
 CellID->39125948]
}, Open  ]],
Cell[CellGroupData[{
Cell[36473, 1384, 107, 3, 70, "Input",
 CellID->114743573],
Cell[36583, 1389, 470, 16, 50, "Output",
 CellID->274842218]
}, Open  ]],
Cell[37068, 1408, 65, 1, 70, "ExampleText",
 CellID->526773851],
Cell[CellGroupData[{
Cell[37158, 1413, 174, 5, 70, "Input",
 CellID->463527511],
Cell[37335, 1420, 474, 15, 50, "Output",
 CellID->11651405]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37870, 1442, 224, 7, 70, "ExampleSection",
 CellID->605093],
Cell[38097, 1451, 224, 8, 70, "ExampleText",
 CellID->31203489],
Cell[CellGroupData[{
Cell[38346, 1463, 151, 5, 70, "Input",
 CellID->348136607],
Cell[38500, 1470, 408, 15, 50, "Output",
 CellID->13829637]
}, Open  ]],
Cell[38923, 1488, 92, 1, 70, "ExampleText",
 CellID->456889126],
Cell[CellGroupData[{
Cell[39040, 1493, 176, 6, 70, "Input",
 CellID->314599141],
Cell[39219, 1501, 409, 15, 50, "Output",
 CellID->693616622]
}, Open  ]],
Cell[39643, 1519, 124, 3, 70, "ExampleDelimiter",
 CellID->70706763],
Cell[39770, 1524, 244, 8, 70, "ExampleText",
 CellID->985401790],
Cell[CellGroupData[{
Cell[40039, 1536, 191, 6, 70, "Input",
 CellID->595290287],
Cell[40233, 1544, 297, 9, 65, "Output",
 CellID->254857750]
}, Open  ]],
Cell[CellGroupData[{
Cell[40567, 1558, 104, 3, 70, "Input",
 CellID->118096096],
Cell[40674, 1563, 605, 21, 50, "Output",
 CellID->207401389]
}, Open  ]],
Cell[41294, 1587, 125, 3, 70, "ExampleDelimiter",
 CellID->874281701],
Cell[41422, 1592, 63, 1, 70, "ExampleText",
 CellID->13945527],
Cell[CellGroupData[{
Cell[41510, 1597, 232, 8, 70, "Input",
 CellID->50757811],
Cell[41745, 1607, 460, 16, 50, "Output",
 CellID->148352998]
}, Open  ]],
Cell[42220, 1626, 160, 6, 70, "ExampleText",
 CellID->169565324],
Cell[CellGroupData[{
Cell[42405, 1636, 264, 9, 70, "Input",
 CellID->313189738],
Cell[42672, 1647, 331, 10, 36, "Output",
 CellID->490227013]
}, Open  ]],
Cell[43018, 1660, 125, 3, 70, "ExampleDelimiter",
 CellID->767454738],
Cell[43146, 1665, 205, 8, 70, "ExampleText",
 CellID->4909310],
Cell[CellGroupData[{
Cell[43376, 1677, 188, 7, 70, "Input",
 CellID->803612336],
Cell[43567, 1686, 251, 9, 36, "Output",
 CellID->22361246]
}, Open  ]],
Cell[CellGroupData[{
Cell[43855, 1700, 107, 3, 70, "Input",
 CellID->966948151],
Cell[43965, 1705, 571, 20, 50, "Output",
 CellID->226952874]
}, Open  ]],
Cell[44551, 1728, 150, 6, 70, "ExampleText",
 CellID->9644941],
Cell[CellGroupData[{
Cell[44726, 1738, 149, 4, 70, "Input",
 CellID->152566766],
Cell[44878, 1744, 296, 11, 36, "Output",
 CellID->91854150]
}, Open  ]],
Cell[45189, 1758, 74, 1, 70, "ExampleText",
 CellID->502183238],
Cell[CellGroupData[{
Cell[45288, 1763, 129, 4, 70, "Input",
 CellID->111822043],
Cell[45420, 1769, 779, 29, 36, "Output",
 CellID->117941603]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46248, 1804, 237, 7, 70, "ExampleSection",
 CellID->689554430],
Cell[46488, 1813, 260, 8, 70, "ExampleText",
 CellID->45936541],
Cell[CellGroupData[{
Cell[46773, 1825, 189, 6, 70, "Input",
 CellID->145860351],
Cell[46965, 1833, 625, 22, 50, "Output",
 CellID->501637435]
}, Open  ]],
Cell[47605, 1858, 214, 8, 70, "ExampleText",
 CellID->72664848],
Cell[CellGroupData[{
Cell[47844, 1870, 152, 5, 70, "Input",
 CellID->486321574],
Cell[47999, 1877, 248, 9, 54, "Output",
 CellID->45854595]
}, Open  ]],
Cell[CellGroupData[{
Cell[48284, 1891, 103, 3, 70, "Input",
 CellID->46625405],
Cell[48390, 1896, 625, 22, 50, "Output",
 CellID->850568949]
}, Open  ]],
Cell[49030, 1921, 125, 3, 70, "ExampleDelimiter",
 CellID->579768991],
Cell[49158, 1926, 222, 7, 70, "ExampleText",
 CellID->27134552],
Cell[CellGroupData[{
Cell[49405, 1937, 175, 6, 70, "Input",
 CellID->106470571],
Cell[49583, 1945, 494, 18, 50, "Output",
 CellID->755756924]
}, Open  ]],
Cell[50092, 1966, 204, 7, 70, "ExampleText",
 CellID->331187995],
Cell[CellGroupData[{
Cell[50321, 1977, 176, 6, 70, "Input",
 CellID->210440999],
Cell[50500, 1985, 171, 5, 50, "Output",
 CellID->797545972]
}, Open  ]],
Cell[50686, 1993, 123, 3, 70, "ExampleDelimiter",
 CellID->6950531],
Cell[50812, 1998, 229, 7, 70, "ExampleText",
 CellID->36353769],
Cell[CellGroupData[{
Cell[51066, 2009, 221, 8, 70, "Input",
 CellID->609632377],
Cell[51290, 2019, 560, 20, 50, "Output",
 CellID->129583612]
}, Open  ]],
Cell[CellGroupData[{
Cell[51887, 2044, 219, 8, 70, "Input",
 CellID->1232133],
Cell[52109, 2054, 7641, 225, 70, "Output",
 CellID->13572665]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59799, 2285, 230, 7, 70, "ExampleSection",
 CellID->115797493],
Cell[60032, 2294, 84, 1, 70, "ExampleText",
 CellID->53407022],
Cell[CellGroupData[{
Cell[60141, 2299, 236, 8, 70, "Input",
 CellID->150990736],
Cell[60380, 2309, 190, 7, 55, "Output",
 CellID->248410554]
}, Open  ]],
Cell[60585, 2319, 237, 8, 70, "ExampleText",
 CellID->138848745],
Cell[CellGroupData[{
Cell[60847, 2331, 155, 5, 70, "Input",
 CellID->258666764],
Cell[61005, 2338, 436, 16, 50, "Output",
 CellID->827599287]
}, Open  ]],
Cell[61456, 2357, 74, 1, 70, "ExampleText",
 CellID->65852761],
Cell[CellGroupData[{
Cell[61555, 2362, 409, 15, 70, "Input",
 CellID->269888159],
Cell[61967, 2379, 180, 6, 53, "Output",
 CellID->223024600]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[62208, 2392, 311, 9, 70, "SeeAlsoSection",
 CellID->26281],
Cell[62522, 2403, 453, 17, 70, "SeeAlso",
 CellID->26021]
}, Open  ]],
Cell[CellGroupData[{
Cell[63012, 2425, 314, 9, 70, "TutorialsSection",
 CellID->10861],
Cell[63329, 2436, 162, 3, 70, "Tutorials",
 CellID->22431],
Cell[63494, 2441, 149, 3, 70, "Tutorials",
 CellID->12455],
Cell[63646, 2446, 156, 3, 70, "Tutorials",
 CellID->14197],
Cell[63805, 2451, 196, 4, 70, "Tutorials",
 CellID->22106],
Cell[64004, 2457, 156, 3, 70, "Tutorials",
 CellID->8752],
Cell[64163, 2462, 179, 4, 70, "Tutorials",
 CellID->27366],
Cell[64345, 2468, 183, 4, 70, "Tutorials",
 CellID->157498705]
}, Open  ]],
Cell[CellGroupData[{
Cell[64565, 2477, 318, 9, 70, "MoreAboutSection",
 CellID->31669042],
Cell[64886, 2488, 133, 3, 70, "MoreAbout",
 CellID->19963735],
Cell[65022, 2493, 151, 3, 70, "MoreAbout",
 CellID->247597751]
}, Open  ]],
Cell[CellGroupData[{
Cell[65210, 2501, 305, 8, 70, "RelatedLinksSection"],
Cell[65518, 2511, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[65919, 2527, 50, 0, 70, "History"],
Cell[65972, 2529, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

