(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    116551,       4330]
NotebookOptionsPosition[     94339,       3554]
NotebookOutlinePosition[     96531,       3604]
CellTagsIndexPosition[     96445,       3599]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplifying Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingAlgebraicExpressions"], 
          "Simplification" :> 
          Documentation`HelpLookup["paclet:tutorial/Simplification"], 
          "Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"], 
          "Working with Special Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithSpecialFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Simplifying Algebraic Expressions\"\>", 
       2->"\<\"Simplification\"\>", 3->"\<\"Using Assumptions\"\>", 
       4->"\<\"Working with Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "Factor" :> Documentation`HelpLookup["paclet:ref/Factor"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"], "PowerExpand" :> 
          Documentation`HelpLookup["paclet:ref/PowerExpand"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], "Assuming" :> 
          Documentation`HelpLookup["paclet:ref/Assuming"], "RootReduce" :> 
          Documentation`HelpLookup["paclet:ref/RootReduce"], "TrigFactor" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactor"], "TrigReduce" :> 
          Documentation`HelpLookup["paclet:ref/TrigReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Simplify\"\>", 2->"\<\"Factor\"\>", 
       3->"\<\"Expand\"\>", 4->"\<\"PowerExpand\"\>", 
       5->"\<\"ComplexExpand\"\>", 6->"\<\"TrigExpand\"\>", 
       7->"\<\"Element\"\>", 8->"\<\"FunctionExpand\"\>", 
       9->"\<\"Assuming\"\>", 10->"\<\"RootReduce\"\>", 
       11->"\<\"TrigFactor\"\>", 
       12->"\<\"TrigReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Algebraic Transformations\"\>", 
       3->"\<\"Assumptions and Domains\"\>", 
       4->"\<\"Formula Manipulation\"\>", 5->"\<\"Prime Numbers\"\>", 
       6->"\<\"Trigonometric Functions\"\>", 
       7->"\<\"New in 6.0: Symbolic Computation\"\>", 
       8->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FullSimplify", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FullSimplify",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FullSimplify"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]tries a wide range of transformations on ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " involving elementary and special functions, and returns the simplest \
form it finds. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FullSimplify",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FullSimplify"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does simplification using assumptions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " will always yield at least as simple a form as ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", but may take substantially longer. "
}], "Notes",
 CellID->8546],

Cell["The following options can be given: ", "Notes",
 CellID->20474],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[TextData[{
     "default assumptions to append to ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ComplexityFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ComplexityFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to assess the complexity of each form generated ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExcludedForms",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExcludedForms"], 
    RowBox[{"{", "}"}], Cell["\<\
patterns specifying forms of subexpression that should not be touched \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TimeConstraint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TimeConstraint"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell["\<\
for how many seconds to try doing any particular transformation \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TransformationFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TransformationFunctions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "functions to try in transforming the expression ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " on expressions that involve ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->19097],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " does transformations on most kinds of special functions. "
}], "Notes",
 CellID->8880],

Cell[TextData[{
 "With assumptions of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"], "[", 
   RowBox[{
    StyleBox["vars", "TI"], ",", " ", 
    StyleBox["axioms", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " can simplify expressions and equations involving symbolic functions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21,
  ButtonNote->"21"]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23335],

Cell[TextData[{
 "You can specify default assumptions for ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11072]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101133218],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->120692914],

Cell["Simplify an expression involving special functions:", "ExampleText",
 CellID->343544594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"x", " ", 
   RowBox[{"Gamma", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189277084],

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"1", "+", "x"}], "]"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421657449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241464685],

Cell["Simplify using assumptions:", "ExampleText",
 CellID->532738433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"x", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"x", ">", 
    RowBox[{"1", "/", "E"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157526334],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223052059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447032329],

Cell["Prove a simple theorem from the assumption of associativity:", \
"ExampleText",
 CellID->136891468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"u", ",", 
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "w"}], "]"}]}], "]"}], ",", "u"}], "]"}], "==", 
    RowBox[{"f", "[", 
     RowBox[{"u", ",", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"v", ",", "w"}], "]"}], ",", "u"}], "]"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"a", ",", 
        RowBox[{"f", "[", 
         RowBox[{"b", ",", "c"}], "]"}]}], "]"}], "\[Equal]", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"a", ",", "b"}], "]"}], ",", "c"}], "]"}]}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229369008],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273549589]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11455],

Cell["Simplify polynomials:", "ExampleText",
 CellID->47666565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], "-", 
   RowBox[{"6", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"11", "x"}], "-", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385932259],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{155, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "10"}], "-", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "10"}], "+", "1"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->265415389],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "20"]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110189607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->773918798],

Cell["Simplify a hyperbolic expression to an exponential form:", "ExampleText",
 CellID->542143176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Cosh", "[", "x", "]"}], "-", 
   RowBox[{"Sinh", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->545169819],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", "x"}]]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725096689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7943178],

Cell["Simplify an exponential expression to a trigonometric form:", \
"ExampleText",
 CellID->630386263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "I"}], ")"}], 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "I"}], " ", "x"}], ")"}]}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "I"}], ")"}], 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"I", " ", "x"}], ")"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23249648],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36119633],

Cell["Simplify an algebraic number:", "ExampleText",
 CellID->9222872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}], "-", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", 
      RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37431177],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110575955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63095593],

Cell["Simplify transcendental numbers:", "ExampleText",
 CellID->409259753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"-", "I"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", "I"}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414849766],

Cell[BoxData[
 RowBox[{"ArcTan", "[", "2", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310981641]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"16", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "/", "5"}], "]"}]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"1", "/", "239"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18762],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24335723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19414342],

Cell["Simplify expressions involving special functions:", "ExampleText",
 CellID->334900214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{
     RowBox[{"1", "-", "n"}], ",", "x"}], "]"}], 
   RowBox[{"x", "^", "n"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296353446],

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57105611]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"Pi", " ", "v"}], "]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"BesselI", "[", 
       RowBox[{
        RowBox[{"-", "v"}], ",", "z"}], "]"}], "-", 
      RowBox[{"BesselI", "[", 
       RowBox[{"v", ",", "z"}], "]"}]}], ")"}], "/", "2"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->127326563],

Cell[BoxData[
 FractionBox[
  RowBox[{"BesselK", "[", 
   RowBox[{"v", ",", "z"}], "]"}], "\[Pi]"]], "Output",
 ImageSize->{97, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->705492815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->695963771],

Cell["Simplify expressions using assumptions:", "ExampleText",
 CellID->228503082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"x", " ", 
     RowBox[{"E", "^", "x"}]}], "]"}], ",", 
   RowBox[{"x", "\[GreaterEqual]", 
    RowBox[{"-", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121327483],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358520630]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"EllipticF", "[", 
      RowBox[{"x", ",", "1"}], "]"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "Pi"}], "/", "2"}], "<", "x", "<", 
    RowBox[{"Pi", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45099113],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sec", "[", "x", "]"}], "+", 
  RowBox[{"Tan", "[", "x", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506256360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"EulerPhi", "[", 
     RowBox[{"p", "^", "2"}], "]"}], "+", "p"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"p", ",", "Primes"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21281300],

Cell[BoxData[
 SuperscriptBox["p", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->205769429]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44592381],

Cell["Prove theorems based on axiom systems: ", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->21],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"b", ",", "a"}], "]"}], ",", "a"}], "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", 
      RowBox[{"f", "[", 
       RowBox[{"b", ",", "a"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"a", ",", "b"}], "]"}], "==", 
      RowBox[{"f", "[", 
       RowBox[{"b", ",", "a"}], "]"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17922],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128875187]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "a"}], "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}], ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"a", ",", "a"}], "]"}], ",", "b"}], "]"}], "\[Equal]", 
      "a"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27368],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204184194]
}, Open  ]],

Cell["Any expression can be used as a variable:", "ExampleText",
 CellID->17650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["a", "1"], "\[CirclePlus]", 
     SubscriptBox["a", "1"]}], "==", 
    RowBox[{
     SubscriptBox["a", "1"], "\[CirclePlus]", 
     SubscriptBox["a", "2"]}]}], ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "\[CirclePlus]", "a"}], ")"}], "\[CirclePlus]", "b"}], "==",
       "a"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13290],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->58557087]
}, Open  ]],

Cell["\<\
Variables not quantified in the axioms are treated as constants:\
\>", "ExampleText",
 CellID->3169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "e"}], "]"}], ",", "e"}], "]"}], "==", "e"}], ",", 
   " ", 
   RowBox[{"ForAll", "[", 
    RowBox[{"a", ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"a", ",", "e"}], "]"}], "==", "a"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->21895],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->216050852]
}, Open  ]],

Cell["\<\
Prove existence of right inverses assuming left identity and left inverses \
exist:\
\>", "ExampleText",
 CellID->343591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Exists", "[", 
      RowBox[{"y", ",", 
       RowBox[{
        RowBox[{"g", "[", 
         RowBox[{"x", ",", "y"}], "]"}], "\[Equal]", "e"}]}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"x", ",", 
         RowBox[{"g", "[", 
          RowBox[{"y", ",", "z"}], "]"}]}], "]"}], "\[Equal]", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"g", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}]}], "&&", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"e", ",", "x"}], "]"}], "\[Equal]", "x"}], "&&", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"inv", "[", "x", "]"}], ",", "x"}], "]"}], "\[Equal]", 
       "e"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->377712542],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->158575513]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->252531498],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->500043515],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " can be given both as an argument and as an option value:"
}], "ExampleText",
 CellID->565056155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"a", "^", 
      RowBox[{"EulerPhi", "[", "m", "]"}]}], ",", "m"}], "]"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"a", "|", "m"}], ",", "Integers"}], "]"}], "&&", 
    RowBox[{"m", ">", "1"}]}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{"a", ",", "m"}], "]"}], "\[Equal]", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237031262],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442393523]
}, Open  ]],

Cell[TextData[{
 "The default value of the ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->279368443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "x", "]"}], ">", "0"}], ",", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{"E", "^", 
     RowBox[{"LogGamma", "[", "x", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359819269],

Cell[BoxData[
 RowBox[{"Gamma", "[", "x", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6602495]
}, Open  ]],

Cell[TextData[{
 "When assumptions are given as an argument, ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " are used as well:"
}], "ExampleText",
 CellID->373032043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"LogGamma", "[", "x", "]"}], "+", " ", 
        RowBox[{"LogGamma", "[", "y", "]"}]}], ")"}]}], ",", 
     RowBox[{"y", ">", "0"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->71170035],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", "x", "]"}], " ", 
  RowBox[{"Gamma", "[", "y", "]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->81520777]
}, Open  ]],

Cell[TextData[{
 "Specifying assumptions as an option value prevents ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " from using ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8600092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"FullSimplify", "[", 
    RowBox[{
     RowBox[{"E", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"LogGamma", "[", "x", "]"}], "+", " ", 
        RowBox[{"LogGamma", "[", "y", "]"}]}], ")"}]}], ",", 
     RowBox[{"Assumptions", "->", 
      RowBox[{"y", ">", "0"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->98179595],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", "x", "]"}], " ", 
  RowBox[{"Gamma", "[", "y", "]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->991815415]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ComplexityFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->771110230],

Cell["By default this expression is not simplified:", "ExampleText",
 CellID->70590592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ChebyshevT", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11623231],

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"n", ",", "x"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115051181]
}, Open  ]],

Cell[TextData[{
 "This complexity function makes ",
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " more expensive than other functions:"
}], "ExampleText",
 CellID->366508076],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "e_", "]"}], ":=", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{"Count", "[", 
     RowBox[{"e", ",", "_ChebyshevT", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]}], "+", 
   RowBox[{"LeafCount", "[", "e", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65307223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ChebyshevT", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"ComplexityFunction", "\[Rule]", "f"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73900076],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"n", " ", 
   RowBox[{"ArcCos", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->786038138]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ExcludedForms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13030654],

Cell[TextData[{
 "This gives a result in terms of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->146600868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{
     RowBox[{"Log", "[", "x", "]"}], "+", 
     RowBox[{"2", " ", "x"}], "-", 
     RowBox[{"3", "y"}]}], "]"}], "-", 
   RowBox[{"2", 
    RowBox[{"Im", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164581558],

Cell[BoxData[
 RowBox[{
  RowBox[{"Arg", "[", "x", "]"}], "-", 
  RowBox[{"3", " ", 
   RowBox[{"Im", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->471816265]
}, Open  ]],

Cell[TextData[{
 "This specifies that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", "x", "]"}]], "InlineFormula"],
 " should not be transformed:"
}], "ExampleText",
 CellID->1505484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Im", "[", 
     RowBox[{
      RowBox[{"Log", "[", "x", "]"}], "+", 
      RowBox[{"2", " ", "x"}], "-", 
      RowBox[{"3", "y"}]}], "]"}], "-", 
    RowBox[{"2", 
     RowBox[{"Im", "[", "x", "]"}]}]}], ",", 
   RowBox[{"ExcludedForms", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Log", "[", "_", "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->898901276],

Cell[BoxData[
 RowBox[{"Im", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", "y"}], "+", 
   RowBox[{"Log", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->799405545]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TimeConstraint",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->116906395],

Cell["\<\
This takes a long time due to expansion of trigonometric functions:\
\>", "ExampleText",
 CellID->150804670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{"2", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"12", "x"}], "+", 
      RowBox[{"15", "y"}]}], "]"}], 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"12", "x"}], "+", 
      RowBox[{"21", "y"}]}], "]"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21362199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"63.692000000000014`", ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      RowBox[{"6", " ", "y"}], "]"}]}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"24", " ", "x"}], "+", 
      RowBox[{"36", " ", "y"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43982546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->359074099],

Cell["\<\
The most time\[Hyphen]consuming transformation is not the one that does the \
simplification:\
\>", "ExampleText",
 CellID->327796752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"12", "x"}], "+", 
       RowBox[{"15", "y"}]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"12", "x"}], "+", 
       RowBox[{"21", "y"}]}], "]"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->741333612],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FullSimplify/time\\\", ButtonNote -> \
\\\"FullSimplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->776016362],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.394000000000002`", ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      RowBox[{"6", " ", "y"}], "]"}]}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"24", " ", "x"}], "+", 
      RowBox[{"36", " ", "y"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26769178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3965740],

Cell["\<\
With transformations restricted to 100 ms the simplification does not happen:\
\
\>", "ExampleText",
 CellID->74610349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"12", "x"}], "+", 
       RowBox[{"15", "y"}]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"12", "x"}], "+", 
       RowBox[{"21", "y"}]}], "]"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "0.1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->464074133],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \
\\!\\(0.09999999999999999`\\) seconds, and the transformation was aborted. \
Increasing the value of TimeConstraint option may improve the result of \
simplification. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FullSimplify/time\\\", ButtonNote -> \
\\\"FullSimplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->235391792],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \
\\!\\(0.09999999999999999`\\) seconds, and the transformation was aborted. \
Increasing the value of TimeConstraint option may improve the result of \
simplification. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FullSimplify/time\\\", ButtonNote -> \
\\\"FullSimplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->85342593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5999999999999919`", ",", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"12", " ", "x"}], "+", 
      RowBox[{"21", " ", "y"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"12", " ", "x"}], "+", 
      RowBox[{"15", " ", "y"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63924323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TransformationFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->486671241],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " does not use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->199486460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"E", "^", "x"}], "<", "7"}], "]"}], ",", 
   RowBox[{"x", "<", 
    RowBox[{"3", "/", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->588643665],

Cell[BoxData[
 RowBox[{"Boole", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], "<", "7"}], "]"}]], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149816276]
}, Open  ]],

Cell[TextData[{
 "This makes ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " over the real domain: "
}], "ExampleText",
 CellID->1308655],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "e_", "]"}], ":=", 
  RowBox[{"Reduce", "[", 
   RowBox[{"e", ",", "x", ",", "Reals"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69802723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{
     RowBox[{"E", "^", "x"}], "<", "7"}], "]"}], ",", 
   RowBox[{"x", "<", 
    RowBox[{"3", "/", "2"}]}], ",", 
   RowBox[{"TransformationFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "t"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->421149767],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5176303]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->682858894],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses trigonometric identities:"
}], "ExampleText",
 CellID->252019676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "+", 
   RowBox[{"4", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "x", "]"}]}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373232992],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}], "4"]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65934736]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trig"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " does not use trigonometric identities:"
}], "ExampleText",
 CellID->297327276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"4", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", "1"}], ",", 
   RowBox[{"Trig", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272783486],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], "2"]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132220153]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15987],

Cell["Prove that a solution satisfies its equations:", "ExampleText",
 CellID->449400639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"2", 
       RowBox[{"Exp", "[", "x", "]"}]}]}], "\[Equal]", "1"}], ",", "x"}], 
   "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328764958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"1", "-", 
     RowBox[{"ProductLog", "[", 
      RowBox[{"2", " ", "\[ExponentialE]"}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39863654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"x", "+", 
     RowBox[{"2", 
      RowBox[{"Exp", "[", "x", "]"}]}]}], "\[Equal]", "1"}], "/.", 
   RowBox[{"First", "[", "%", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->147423604],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1410529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->109236376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"BesselI", "[", 
         RowBox[{"0", ",", 
          RowBox[{"2", " ", 
           SqrtBox[
            SuperscriptBox["\[ExponentialE]", "x"]]}]}], "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"BesselK", "[", 
         RowBox[{"0", ",", 
          RowBox[{"2", " ", 
           SqrtBox[
            SuperscriptBox["\[ExponentialE]", "x"]]}]}], "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{487, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->461352001]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], "/.", 
   RowBox[{"First", "[", "%", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->314873340],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->15399643]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{"k", " ", 
     RowBox[{"y", "[", "k", "]"}]}]}], ",", "y", ",", "k"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->421530181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "k", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Pochhammer", "[", 
        RowBox[{"1", ",", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "k"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->131933619]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"k", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{"k", " ", 
     RowBox[{"y", "[", "k", "]"}]}]}], "/.", 
   RowBox[{"First", "[", "%", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->690670444],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->127688647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7042],

Cell[TextData[{
 "Simplify expressions involving ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Mod", "[", 
         RowBox[{
          RowBox[{"Total", "[", "#", "]"}], ",", " ", "2"}], "]"}], " ", 
        "&"}], ",", 
       RowBox[{"{", "}"}], ",", " ", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "a", "}"}], ",", " ", "0"}], "}"}], ",", " ", "4"}], 
    "]"}], ",", " ", 
   RowBox[{
    RowBox[{"0", "<=", "a", "<=", "1"}], "&&", 
    RowBox[{"a", " ", "\[Element]", " ", "Integers"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "0", ",", "a", ",", "0", ",", "0", ",", "0",
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "a", ",", "a", ",", "a", ",", "0", ",", "0",
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "a", ",", "0", ",", "a", ",", "0", ",", "a", ",", "0",
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "a", ",", "a", ",", "0", ",", "a", ",", "0", ",", "a", ",", "a",
      ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "0", ",", "0", ",", "0", ",", "a", ",", "0", ",", "0", ",", "0",
      ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{540, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357883137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15814],

Cell[TextData[{
 "Prove that an operation ",
 Cell[BoxData["g"], "InlineFormula"],
 " with associativity, left neutral element and left inverse defines a \
group:"
}], "ExampleText",
 CellID->32718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ForAll", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"x", ",", "e"}], "]"}], "\[Equal]", "x"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"a", ",", 
         RowBox[{"inv", "[", "a", "]"}]}], "]"}], "\[Equal]", "e"}]}]}], 
    "]"}], ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"x", ",", 
         RowBox[{"g", "[", 
          RowBox[{"y", ",", "z"}], "]"}]}], "]"}], "\[Equal]", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"g", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}]}], " ", "&&", " ",
       
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"e", ",", "x"}], "]"}], "\[Equal]", "x"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"inv", "[", "x", "]"}], ",", "x"}], "]"}], "\[Equal]", 
       "e"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12244],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->626126856]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7229],

Cell["\<\
Prove commutativity from Wolfram's minimal axiom for Boolean algebra:\
\>", "ExampleText",
 CellID->20652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"b", ",", "a"}], "]"}]}], ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"p", ",", "q"}], "]"}], ",", "r"}], "]"}], ",", 
        RowBox[{"f", "[", 
         RowBox[{"p", ",", 
          RowBox[{"f", "[", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"p", ",", "r"}], "]"}], ",", "p"}], "]"}]}], "]"}]}], 
       "]"}], "\[Equal]", "r"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18864],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56988308]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30470],

Cell["Prove that a fixed point combinator exists:", "ExampleText",
 CellID->15005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", "Y", "}"}], ",", 
     RowBox[{"Y", "\[Equal]", 
      RowBox[{"apply", "[", 
       RowBox[{"combinator", ",", "Y"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{"apply", "[", 
       RowBox[{
        RowBox[{"apply", "[", 
         RowBox[{"l", ",", "x"}], "]"}], ",", "y"}], "]"}], "\[Equal]", 
      RowBox[{"apply", "[", 
       RowBox[{"x", ",", 
        RowBox[{"apply", "[", 
         RowBox[{"y", ",", "y"}], "]"}]}], "]"}]}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->21047],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345808044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21487],

Cell[TextData[{
 "Prove a theorem about meet (",
 Cell[BoxData[
  StyleBox["\[Vee]", "TR"]], "InlineFormula"],
 ") and join (",
 Cell[BoxData[
  StyleBox["\[Wedge]", "TR"]], "InlineFormula"],
 "):"
}], "ExampleText",
 CellID->24326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "\[Vee]", 
     RowBox[{"(", 
      RowBox[{"a", "\[Wedge]", "b"}], ")"}]}], "\[Equal]", "a"}], ",", 
   RowBox[{
    SubscriptBox["\[ForAll]", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "\[Wedge]", 
        RowBox[{"(", 
         RowBox[{"y", "\[Vee]", 
          RowBox[{"(", 
           RowBox[{"x", "\[Vee]", "z"}], ")"}]}], ")"}]}], "\[Equal]", "x"}], 
      "&&", 
      RowBox[{
       RowBox[{"x", "\[Vee]", 
        RowBox[{"y", "\[Wedge]", 
         RowBox[{"(", 
          RowBox[{"x", "\[Wedge]", "z"}], ")"}]}]}], "\[Equal]", "x"}], "&&", 
      
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "\[Vee]", "y"}], ")"}], "\[Wedge]", 
          RowBox[{"(", 
           RowBox[{"y", "\[Vee]", "z"}], ")"}]}], ")"}], "\[Wedge]", "y"}], 
       "\[Equal]", "y"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", "\[Wedge]", "y"}], "\[Vee]", 
          RowBox[{"y", "\[Wedge]", "z"}]}], ")"}], "\[Vee]", "y"}], 
       "\[Equal]", "y"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3276],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192757996]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6540],

Cell["The output is generically equivalent to the input:", "ExampleText",
 CellID->87214902],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Log", "[", 
      RowBox[{"2", "+", 
       RowBox[{"2", "I"}]}], "]"}]}], "-", 
    RowBox[{"Log", "[", 
     RowBox[{"16", "I"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->603152484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FullSimplify", "[", "e", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25845060],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290727239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "\[Equal]", "f"}], "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4393830],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->793293459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7679],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses a wider range of transformations than ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->105093513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", " ", "-", " ", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23990],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "-", "x"}], "]"}], " ", 
  RowBox[{"Gamma", "[", "x", "]"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29437403]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24710],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"\[Pi]", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150740406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->496866849],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses several expansion transformations, including ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->453371435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "^", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->509996251],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "5"], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"], " ", "y"}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{"5", " ", "x", " ", 
   SuperscriptBox["y", "4"]}], "+", 
  SuperscriptBox["y", "5"]}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45772731]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->754320345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", "y"}], "]"}], 
   RowBox[{"Cosh", "[", 
    RowBox[{"x", "-", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->665712254],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   RowBox[{"Cosh", "[", "x", "]"}], " ", 
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cosh", "[", "x", "]"}], " ", 
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}], " ", 
   RowBox[{"Sinh", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{409, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->535284041]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PiecewiseExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PiecewiseExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9049940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Min", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->514285369],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFV81OAjEQrrtbdhERjInxiFd/nkE9iCcfwJ8LMSYSQyTKgRtnveCNR+DI
I/gIPAaPUdvdGSjT2aVgok3YtjOd/863y02r9/zUafXaj63G9Vur+9x+fG80
X980KdwSQnzp38mh0GulV+nvSyk928/QPKN+v/+djtls9rGgh4PBQKVDlPRD
ahVVPYci40uYAwELkY1ALyM93+ZqEkZU4TAyu+mpORWk8vcB2LFp96y9mJyq
+Vhy/POzlZBTXlGxtmRx/qKFDsFGZPIT5UfiUPNtSaY6AVjITKQDKMgxmozA
Hav3wImB5vclVy7Whzos9/NPqSY3JoQGzKfWvPpmHJH9GdmfeGmpkKzXCb9E
9glUJVbLXbtUU4tG5c1NM/dBwhyrBRpgDUej0Xg8NssyaKw61d4DTgJz2qPO
nZSOXOhQUEOd1VAm/hd0BHjP5xoRCn3FHNj8beDL/Fjk/LRt2aGWiGbsQq6a
+dmzo+p2u8PhcB7VUgaroGXP4cSF+qk3EdnHbNXtExL0lwv893t77Di2al4+
bxYZ70PN8cGnPjQ+k5NwGVmtu4U9WmVP8TFjFaU1u7Lmdss1O4b6fs6e5am8
hgvw7VLZuPK/OH+sMlx/YLmnJF/8dwHmHuvng9vY8evgdUj0FuP16i+LfOSu
EI/5LxkfBHet/h7LuW9AzEcRhuMbi+/wdTHctrQJdq+KwkVstJqwWn0Q20jv
E/rGOL3iLvF4hZnha+CFze5t2gyXo8lkMkjHdDqNVHEP85hMby3fJxxGc328
Tg9csbzzAomm4tA3+58otn4AZz9jjg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{144, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77511517]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->87658215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Beta", "[", 
   RowBox[{"x", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->15512595],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   RowBox[{"Gamma", "[", "z", "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"x", "+", "z"}], "]"}]]], "Output",
 ImageSize->{124, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->389936010]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->92768429],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{"1", "-", "x"}]]}], ")"}]}], "x"], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Log", "[", "2", "]"}]}], "+", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", 
        SqrtBox[
         RowBox[{"1", "-", "x"}]]}], "]"}]}], ")"}]}], "x"]}]], "Output",
 ImageSize->{297, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->102766520]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->316815888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Xor", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->43051369],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "&&", "y", "&&", "z"}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"x", "&&", 
    RowBox[{"!", "y"}], "&&", 
    RowBox[{"!", "z"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"y", "&&", 
    RowBox[{"!", "x"}], "&&", 
    RowBox[{"!", "z"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{"z", "&&", 
    RowBox[{"!", "x"}], "&&", 
    RowBox[{"!", "y"}]}], ")"}]}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->369845670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->598893853],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " makes special assumptions on input and is not used by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->384841845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", " ", "y"}], ")"}], "^", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56320887],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "z"], " ", 
  SuperscriptBox["y", "z"]}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264497265]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 " assumes variables to be real and is also not used by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->446586971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26130134],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51988188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39376163],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses several factoring transformations, including ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->513429908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "3"}], ")"}], "^", "3"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494266988],

Cell[BoxData[
 RowBox[{"108", "+", 
  RowBox[{"432", " ", "x"}], "+", 
  RowBox[{"711", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"625", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"318", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"94", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"15", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  SuperscriptBox["x", "7"]}]], "Output",
 ImageSize->{326, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->303605152]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "p", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->982054],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}], "2"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"]}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->332562371]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25389692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFree", "[", "p", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52566483],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}], "3"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", 
     RowBox[{"3", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}], "2"]}]], "Output",
 ImageSize->{135, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->89229737]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->40085400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "y", "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sin", "[", "y", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6359055],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"x", "+", "y"}], "]"}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->566486668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260316574],

Cell[TextData[{
 "For algebraic numbers, ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " are used:"
}], "ExampleText",
 CellID->144040243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->377876305],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{163, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45024128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->545133790],

Cell[BoxData[
 SqrtBox[
  RowBox[{"5", "+", 
   RowBox[{"2", " ", 
    SqrtBox["6"]}]}]]], "Output",
 ImageSize->{77, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74312026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267375168],

Cell[TextData[{
 "For rational functions, ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " are used:"
}], "ExampleText",
 CellID->109435148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "3"}], ")"}], "^", "3"}]}], ")"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->20585069],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "-", 
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], "2"]], "+", 
  FractionBox["2", 
   RowBox[{"2", "+", "x"}]], "-", 
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}], "3"]}]], "-", 
  FractionBox["5", 
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}], "2"]}]], "-", 
  FractionBox["17", 
   RowBox[{"8", " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]]}]], "Output",
 ImageSize->{379, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14633766]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->366931829],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}], "3"]}]]], "Output",
 ImageSize->{147, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83266198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15950921],

Cell[TextData[{
 "Some of transformations used by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " are only generically correct:"
}], "ExampleText",
 CellID->482986235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "x"}], "]"}], 
   RowBox[{"Gamma", "[", "x", "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196633860],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->516265000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "-", "x"}], "]"}], 
   RowBox[{"Gamma", "[", "x", "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}]}], "/.", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "\[Rule]", "i"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->67948915],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->413194754],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->6409861],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->789221],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], ":", 
  " ", "\<\"Further output of \\!\\(\[Infinity] :: \\\"indet\\\"\\) will be \
suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->373123736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Indeterminate", ",", "Indeterminate", ",", "Indeterminate", ",", 
   "Indeterminate", ",", "Indeterminate", ",", "Indeterminate", ",", 
   "Indeterminate"}], "}"}]], "Output",
 ImageSize->{416, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100358329]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->430914281],

Cell["\<\
Results of simplification of singular expressions are uncertain:\
\>", "ExampleText",
 CellID->128374341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "-", "x"}], "]"}], 
    RowBox[{"Gamma", "[", "x", "]"}], 
    RowBox[{"Sin", "[", 
     RowBox[{"Pi", " ", "x"}], "]"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->327242016],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178605612]
}, Open  ]],

Cell["This result is caused by automatic evaluation:", "ExampleText",
 CellID->351721158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "-", "x"}], "]"}], 
  RowBox[{"Gamma", "[", "x", "]"}], "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->312034815],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249441998]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24779],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " knows about Fermat's Last Theorem:"
}], "ExampleText",
 CellID->574558868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "n"}], "+", 
     RowBox[{"y", "^", "n"}]}], "\[Equal]", 
    RowBox[{"z", "^", "n"}]}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"x", "|", "y", "|", "z", "|", "n"}], ",", "Integers"}], "]"}], "&&",
     
    RowBox[{"n", ">", "2"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[NotEqual]", "0"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28514860],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->473294071]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23588],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23400],

Cell[TextData[ButtonBox["Simplifying Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingAlgebraicExpressions"]], "Tutorials",\

 CellID->707],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "Tutorials",
 CellID->22955],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->377],

Cell[TextData[ButtonBox["Working with Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithSpecialFunctions"]], "Tutorials",
 CellID->310680328]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20666],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#912"], None}]], "RelatedLinks",
 CellID->4141],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FullSimplify"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->760711569],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->703047593],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->194928452],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->289700968],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->25514548],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->2600751],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->824611267],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->291584225],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->187280547]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FullSimplify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 44.7992510}", "context" -> "System`", 
    "keywords" -> {
     "algebraic simplification", "artificial intelligence", "assertions", 
      "assumptions", "Bessel function simplification", 
      "cleaning up expressions", "combinatorial explosion", 
      "combinatorial simplification", "complete simplification", 
      "compress expression", "concise form", "constraints", "efficiency", 
      "expressions", "factorial simplification", "formulas", 
      "gamma function simplification", "heuristics", "number theory", 
      "predicates", "radical simplification", "reflection formula", 
      "relations", "roots", "shortest form", "simplest forms", 
      "simplification", "smallest form", "special function simplification", 
      "speed", "square roots", "squash expression", "theorem proving", 
      "transformations", "trigonometric simplification", "variables"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "FullSimplify[expr] tries a wide range of transformations on expr \
involving elementary and special functions, and returns the simplest form it \
finds. FullSimplify[expr, assum] does simplification using assumptions. ", 
    "synonyms" -> {"full simplify"}, "title" -> "FullSimplify", "type" -> 
    "Symbol", "uri" -> "ref/FullSimplify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15267, 400, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->101133218]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 96301, 3592}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4553, 92, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5176, 119, 4196, 83, 70, "ObjectNameGrid"],
Cell[9375, 204, 1023, 30, 70, "Usage",
 CellID->7740]
}, Open  ]],
Cell[CellGroupData[{
Cell[10435, 239, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10913, 256, 383, 12, 70, "Notes",
 CellID->8546],
Cell[11299, 270, 69, 1, 70, "Notes",
 CellID->20474],
Cell[11371, 273, 2057, 53, 70, "3ColumnTableMod",
 CellID->24773],
Cell[13431, 328, 464, 17, 70, "Notes",
 CellID->19097],
Cell[13898, 347, 232, 7, 70, "Notes",
 CellID->8880],
Cell[14133, 356, 741, 24, 70, "Notes",
 CellID->23335],
Cell[14877, 382, 353, 13, 70, "Notes",
 CellID->11072]
}, Closed]],
Cell[CellGroupData[{
Cell[15267, 400, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101133218],
Cell[CellGroupData[{
Cell[15652, 414, 148, 5, 70, "ExampleSection",
 CellID->120692914],
Cell[15803, 421, 94, 1, 70, "ExampleText",
 CellID->343544594],
Cell[CellGroupData[{
Cell[15922, 426, 164, 5, 28, "Input",
 CellID->189277084],
Cell[16089, 433, 212, 7, 36, "Output",
 CellID->421657449]
}, Open  ]],
Cell[16316, 443, 125, 3, 70, "ExampleDelimiter",
 CellID->241464685],
Cell[16444, 448, 70, 1, 70, "ExampleText",
 CellID->532738433],
Cell[CellGroupData[{
Cell[16539, 453, 276, 9, 70, "Input",
 CellID->157526334],
Cell[16818, 464, 187, 6, 36, "Output",
 CellID->223052059]
}, Open  ]],
Cell[17020, 473, 125, 3, 70, "ExampleDelimiter",
 CellID->447032329],
Cell[17148, 478, 105, 2, 70, "ExampleText",
 CellID->136891468],
Cell[CellGroupData[{
Cell[17278, 484, 949, 32, 70, "Input",
 CellID->229369008],
Cell[18230, 518, 161, 5, 36, "Output",
 CellID->273549589]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18440, 529, 216, 7, 70, "ExampleSection",
 CellID->11455],
Cell[18659, 538, 63, 1, 70, "ExampleText",
 CellID->47666565],
Cell[CellGroupData[{
Cell[18747, 543, 239, 8, 70, "Input",
 CellID->385932259],
Cell[18989, 553, 389, 15, 36, "Output",
 CellID->144986]
}, Open  ]],
Cell[CellGroupData[{
Cell[19415, 573, 278, 10, 70, "Input",
 CellID->265415389],
Cell[19696, 585, 223, 8, 36, "Output",
 CellID->110189607]
}, Open  ]],
Cell[19934, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->773918798],
Cell[20062, 601, 99, 1, 70, "ExampleText",
 CellID->542143176],
Cell[CellGroupData[{
Cell[20186, 606, 195, 6, 70, "Input",
 CellID->545169819],
Cell[20384, 614, 213, 7, 36, "Output",
 CellID->725096689]
}, Open  ]],
Cell[20612, 624, 123, 3, 70, "ExampleDelimiter",
 CellID->7943178],
Cell[20738, 629, 104, 2, 70, "ExampleText",
 CellID->630386263],
Cell[CellGroupData[{
Cell[20867, 635, 449, 17, 70, "Input",
 CellID->23249648],
Cell[21319, 654, 289, 10, 36, "Output",
 CellID->351987]
}, Open  ]],
Cell[21623, 667, 124, 3, 70, "ExampleDelimiter",
 CellID->36119633],
Cell[21750, 672, 70, 1, 70, "ExampleText",
 CellID->9222872],
Cell[CellGroupData[{
Cell[21845, 677, 317, 10, 70, "Input",
 CellID->37431177],
Cell[22165, 689, 158, 5, 36, "Output",
 CellID->110575955]
}, Open  ]],
Cell[22338, 697, 124, 3, 70, "ExampleDelimiter",
 CellID->63095593],
Cell[22465, 702, 75, 1, 70, "ExampleText",
 CellID->409259753],
Cell[CellGroupData[{
Cell[22565, 707, 316, 11, 70, "Input",
 CellID->414849766],
Cell[22884, 720, 190, 6, 36, "Output",
 CellID->310981641]
}, Open  ]],
Cell[CellGroupData[{
Cell[23111, 731, 300, 10, 70, "Input",
 CellID->18762],
Cell[23414, 743, 161, 5, 36, "Output",
 CellID->24335723]
}, Open  ]],
Cell[23590, 751, 124, 3, 70, "ExampleDelimiter",
 CellID->19414342],
Cell[23717, 756, 92, 1, 70, "ExampleText",
 CellID->334900214],
Cell[CellGroupData[{
Cell[23834, 761, 241, 8, 70, "Input",
 CellID->296353446],
Cell[24078, 771, 211, 7, 36, "Output",
 CellID->57105611]
}, Open  ]],
Cell[CellGroupData[{
Cell[24326, 783, 416, 15, 70, "Input",
 CellID->127326563],
Cell[24745, 800, 240, 8, 51, "Output",
 CellID->705492815]
}, Open  ]],
Cell[25000, 811, 125, 3, 70, "ExampleDelimiter",
 CellID->695963771],
Cell[25128, 816, 82, 1, 70, "ExampleText",
 CellID->228503082],
Cell[CellGroupData[{
Cell[25235, 821, 278, 9, 70, "Input",
 CellID->121327483],
Cell[25516, 832, 158, 5, 36, "Output",
 CellID->358520630]
}, Open  ]],
Cell[CellGroupData[{
Cell[25711, 842, 352, 12, 70, "Input",
 CellID->45099113],
Cell[26066, 856, 241, 8, 36, "Output",
 CellID->506256360]
}, Open  ]],
Cell[CellGroupData[{
Cell[26344, 869, 282, 9, 70, "Input",
 CellID->21281300],
Cell[26629, 880, 181, 6, 36, "Output",
 CellID->205769429]
}, Open  ]],
Cell[26825, 889, 124, 3, 70, "ExampleDelimiter",
 CellID->44592381],
Cell[26952, 894, 123, 2, 70, "ExampleText",
 CellID->21],
Cell[CellGroupData[{
Cell[27100, 900, 649, 22, 70, "Input",
 CellID->17922],
Cell[27752, 924, 161, 5, 36, "Output",
 CellID->128875187]
}, Open  ]],
Cell[CellGroupData[{
Cell[27950, 934, 546, 19, 70, "Input",
 CellID->27368],
Cell[28499, 955, 161, 5, 36, "Output",
 CellID->204184194]
}, Open  ]],
Cell[28675, 963, 80, 1, 70, "ExampleText",
 CellID->17650],
Cell[CellGroupData[{
Cell[28780, 968, 580, 20, 70, "Input",
 CellID->13290],
Cell[29363, 990, 160, 5, 36, "Output",
 CellID->58557087]
}, Open  ]],
Cell[29538, 998, 110, 3, 70, "ExampleText",
 CellID->3169],
Cell[CellGroupData[{
Cell[29673, 1005, 425, 16, 70, "Input",
 CellID->21895],
Cell[30101, 1023, 161, 5, 36, "Output",
 CellID->216050852]
}, Open  ]],
Cell[30277, 1031, 131, 4, 70, "ExampleText",
 CellID->343591],
Cell[CellGroupData[{
Cell[30433, 1039, 1043, 34, 70, "Input",
 CellID->377712542],
Cell[31479, 1075, 161, 5, 36, "Output",
 CellID->158575513]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31689, 1086, 222, 7, 70, "ExampleSection",
 CellID->252531498],
Cell[CellGroupData[{
Cell[31936, 1097, 232, 7, 70, "ExampleSubsection",
 CellID->500043515],
Cell[32171, 1106, 240, 7, 70, "ExampleText",
 CellID->565056155],
Cell[CellGroupData[{
Cell[32436, 1117, 540, 17, 70, "Input",
 CellID->237031262],
Cell[32979, 1136, 158, 5, 36, "Output",
 CellID->442393523]
}, Open  ]],
Cell[33152, 1144, 357, 13, 70, "ExampleText",
 CellID->279368443],
Cell[CellGroupData[{
Cell[33534, 1161, 285, 9, 70, "Input",
 CellID->359819269],
Cell[33822, 1172, 187, 6, 36, "Output",
 CellID->6602495]
}, Open  ]],
Cell[34024, 1181, 251, 8, 70, "ExampleText",
 CellID->373032043],
Cell[CellGroupData[{
Cell[34300, 1193, 409, 13, 70, "Input",
 CellID->71170035],
Cell[34712, 1208, 244, 8, 36, "Output",
 CellID->81520777]
}, Open  ]],
Cell[34971, 1219, 384, 13, 70, "ExampleText",
 CellID->8600092],
Cell[CellGroupData[{
Cell[35380, 1236, 447, 14, 70, "Input",
 CellID->98179595],
Cell[35830, 1252, 245, 8, 36, "Output",
 CellID->991815415]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36124, 1266, 239, 7, 70, "ExampleSubsection",
 CellID->771110230],
Cell[36366, 1275, 87, 1, 70, "ExampleText",
 CellID->70590592],
Cell[CellGroupData[{
Cell[36478, 1280, 168, 5, 70, "Input",
 CellID->11623231],
Cell[36649, 1287, 218, 7, 36, "Output",
 CellID->115051181]
}, Open  ]],
Cell[36882, 1297, 254, 8, 70, "ExampleText",
 CellID->366508076],
Cell[37139, 1307, 344, 11, 70, "Input",
 CellID->65307223],
Cell[CellGroupData[{
Cell[37508, 1322, 240, 7, 70, "Input",
 CellID->73900076],
Cell[37751, 1331, 245, 8, 36, "Output",
 CellID->786038138]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38045, 1345, 233, 7, 70, "ExampleSubsection",
 CellID->13030654],
Cell[38281, 1354, 256, 10, 70, "ExampleText",
 CellID->146600868],
Cell[CellGroupData[{
Cell[38562, 1368, 326, 11, 70, "Input",
 CellID->164581558],
Cell[38891, 1381, 264, 9, 36, "Output",
 CellID->471816265]
}, Open  ]],
Cell[39170, 1393, 248, 9, 70, "ExampleText",
 CellID->1505484],
Cell[CellGroupData[{
Cell[39443, 1406, 457, 15, 70, "Input",
 CellID->898901276],
Cell[39903, 1423, 285, 10, 36, "Output",
 CellID->799405545]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40237, 1439, 235, 7, 70, "ExampleSubsection",
 CellID->116906395],
Cell[40475, 1448, 118, 3, 70, "ExampleText",
 CellID->150804670],
Cell[CellGroupData[{
Cell[40618, 1455, 368, 13, 70, "Input",
 CellID->21362199],
Cell[40989, 1470, 439, 15, 36, "Output",
 CellID->43982546]
}, Open  ]],
Cell[41443, 1488, 125, 3, 70, "ExampleDelimiter",
 CellID->359074099],
Cell[41571, 1493, 144, 4, 70, "ExampleText",
 CellID->327796752],
Cell[CellGroupData[{
Cell[41740, 1501, 449, 16, 70, "Input",
 CellID->741333612],
Cell[42192, 1519, 526, 9, 70, "Message",
 CellID->776016362],
Cell[42721, 1530, 438, 15, 36, "Output",
 CellID->26769178]
}, Open  ]],
Cell[43174, 1548, 123, 3, 70, "ExampleDelimiter",
 CellID->3965740],
Cell[43300, 1553, 129, 4, 70, "ExampleText",
 CellID->74610349],
Cell[CellGroupData[{
Cell[43454, 1561, 451, 16, 70, "Input",
 CellID->464074133],
Cell[43908, 1579, 547, 10, 70, "Message",
 CellID->235391792],
Cell[44458, 1591, 546, 10, 70, "Message",
 CellID->85342593],
Cell[45007, 1603, 483, 16, 36, "Output",
 CellID->63924323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45539, 1625, 244, 7, 70, "ExampleSubsection",
 CellID->486671241],
Cell[45786, 1634, 336, 13, 70, "ExampleText",
 CellID->199486460],
Cell[CellGroupData[{
Cell[46147, 1651, 264, 9, 70, "Input",
 CellID->588643665],
Cell[46414, 1662, 251, 8, 36, "Output",
 CellID->149816276]
}, Open  ]],
Cell[46680, 1673, 426, 16, 70, "ExampleText",
 CellID->1308655],
Cell[47109, 1691, 192, 6, 70, "Input",
 CellID->69802723],
Cell[CellGroupData[{
Cell[47326, 1701, 385, 12, 70, "Input",
 CellID->421149767],
Cell[47714, 1715, 156, 5, 36, "Output",
 CellID->5176303]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47919, 1726, 225, 7, 70, "ExampleSubsection",
 CellID->682858894],
Cell[48147, 1735, 232, 8, 70, "ExampleText",
 CellID->252019676],
Cell[CellGroupData[{
Cell[48404, 1747, 369, 12, 70, "Input",
 CellID->373232992],
Cell[48776, 1761, 292, 10, 36, "Output",
 CellID->65934736]
}, Open  ]],
Cell[49083, 1774, 457, 17, 70, "ExampleText",
 CellID->297327276],
Cell[CellGroupData[{
Cell[49565, 1795, 438, 14, 70, "Input",
 CellID->272783486],
Cell[50006, 1811, 330, 11, 36, "Output",
 CellID->132220153]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[50397, 1829, 223, 7, 70, "ExampleSection",
 CellID->15987],
Cell[50623, 1838, 89, 1, 70, "ExampleText",
 CellID->449400639],
Cell[CellGroupData[{
Cell[50737, 1843, 272, 10, 70, "Input",
 CellID->328764958],
Cell[51012, 1855, 342, 12, 36, "Output",
 CellID->39863654]
}, Open  ]],
Cell[CellGroupData[{
Cell[51391, 1872, 272, 9, 70, "Input",
 CellID->147423604],
Cell[51666, 1883, 159, 5, 36, "Output",
 CellID->1410529]
}, Open  ]],
Cell[CellGroupData[{
Cell[51862, 1893, 329, 12, 70, "Input",
 CellID->109236376],
Cell[52194, 1907, 825, 26, 47, "Output",
 CellID->461352001]
}, Open  ]],
Cell[CellGroupData[{
Cell[53056, 1938, 352, 12, 70, "Input",
 CellID->314873340],
Cell[53411, 1952, 160, 5, 36, "Output",
 CellID->15399643]
}, Open  ]],
Cell[CellGroupData[{
Cell[53608, 1962, 278, 9, 70, "Input",
 CellID->421530181],
Cell[53889, 1973, 514, 18, 36, "Output",
 CellID->131933619]
}, Open  ]],
Cell[CellGroupData[{
Cell[54440, 1996, 304, 10, 70, "Input",
 CellID->690670444],
Cell[54747, 2008, 161, 5, 36, "Output",
 CellID->127688647]
}, Open  ]],
Cell[54923, 2016, 120, 3, 70, "ExampleDelimiter",
 CellID->7042],
Cell[55046, 2021, 200, 8, 70, "ExampleText",
 CellID->26253],
Cell[CellGroupData[{
Cell[55271, 2033, 665, 21, 70, "Input",
 CellID->20083],
Cell[55939, 2056, 884, 27, 54, "Output",
 CellID->357883137]
}, Open  ]],
Cell[56838, 2086, 121, 3, 70, "ExampleDelimiter",
 CellID->15814],
Cell[56962, 2091, 198, 6, 70, "ExampleText",
 CellID->32718],
Cell[CellGroupData[{
Cell[57185, 2101, 1171, 38, 70, "Input",
 CellID->12244],
Cell[58359, 2141, 161, 5, 36, "Output",
 CellID->626126856]
}, Open  ]],
Cell[58535, 2149, 120, 3, 70, "ExampleDelimiter",
 CellID->7229],
Cell[58658, 2154, 116, 3, 70, "ExampleText",
 CellID->20652],
Cell[CellGroupData[{
Cell[58799, 2161, 829, 27, 70, "Input",
 CellID->18864],
Cell[59631, 2190, 160, 5, 36, "Output",
 CellID->56988308]
}, Open  ]],
Cell[59806, 2198, 121, 3, 70, "ExampleDelimiter",
 CellID->30470],
Cell[59930, 2203, 82, 1, 70, "ExampleText",
 CellID->15005],
Cell[CellGroupData[{
Cell[60037, 2208, 729, 24, 70, "Input",
 CellID->21047],
Cell[60769, 2234, 161, 5, 36, "Output",
 CellID->345808044]
}, Open  ]],
Cell[60945, 2242, 121, 3, 70, "ExampleDelimiter",
 CellID->21487],
Cell[61069, 2247, 232, 9, 70, "ExampleText",
 CellID->24326],
Cell[CellGroupData[{
Cell[61326, 2260, 1315, 43, 70, "Input",
 CellID->3276],
Cell[62644, 2305, 161, 5, 36, "Output",
 CellID->192757996]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62854, 2316, 232, 7, 70, "ExampleSection",
 CellID->6540],
Cell[63089, 2325, 92, 1, 70, "ExampleText",
 CellID->87214902],
Cell[63184, 2328, 291, 11, 70, "Input",
 CellID->603152484],
Cell[CellGroupData[{
Cell[63500, 2343, 130, 4, 70, "Input",
 CellID->25845060],
Cell[63633, 2349, 205, 7, 36, "Output",
 CellID->290727239]
}, Open  ]],
Cell[CellGroupData[{
Cell[63875, 2361, 121, 4, 70, "Input",
 CellID->4393830],
Cell[63999, 2367, 161, 5, 36, "Output",
 CellID->793293459]
}, Open  ]],
Cell[64175, 2375, 120, 3, 70, "ExampleDelimiter",
 CellID->7679],
Cell[64298, 2380, 354, 12, 70, "ExampleText",
 CellID->105093513],
Cell[CellGroupData[{
Cell[64677, 2396, 224, 7, 70, "Input",
 CellID->23990],
Cell[64904, 2405, 268, 9, 36, "Output",
 CellID->29437403]
}, Open  ]],
Cell[CellGroupData[{
Cell[65209, 2419, 104, 3, 70, "Input",
 CellID->24710],
Cell[65316, 2424, 242, 8, 36, "Output",
 CellID->150740406]
}, Open  ]],
Cell[65573, 2435, 125, 3, 70, "ExampleDelimiter",
 CellID->496866849],
Cell[65701, 2440, 357, 12, 70, "ExampleText",
 CellID->453371435],
Cell[CellGroupData[{
Cell[66083, 2456, 174, 6, 70, "Input",
 CellID->509996251],
Cell[66260, 2464, 552, 18, 36, "Output",
 CellID->45772731]
}, Open  ]],
Cell[66827, 2485, 182, 7, 70, "ExampleText",
 CellID->754320345],
Cell[CellGroupData[{
Cell[67034, 2496, 237, 8, 70, "Input",
 CellID->665712254],
Cell[67274, 2506, 877, 26, 54, "Output",
 CellID->535284041]
}, Open  ]],
Cell[68166, 2535, 190, 7, 70, "ExampleText",
 CellID->9049940],
Cell[CellGroupData[{
Cell[68381, 2546, 175, 5, 70, "Input",
 CellID->514285369],
Cell[68559, 2553, 1036, 21, 70, "Output",
 Evaluatable->False,
 CellID->77511517]
}, Open  ]],
Cell[69610, 2577, 189, 7, 70, "ExampleText",
 CellID->87658215],
Cell[CellGroupData[{
Cell[69824, 2588, 164, 5, 70, "Input",
 CellID->15512595],
Cell[69991, 2595, 324, 11, 53, "Output",
 CellID->389936010]
}, Open  ]],
Cell[CellGroupData[{
Cell[70352, 2611, 326, 10, 70, "Input",
 CellID->92768429],
Cell[70681, 2623, 584, 22, 60, "Output",
 CellID->102766520]
}, Open  ]],
Cell[71280, 2648, 188, 7, 70, "ExampleText",
 CellID->316815888],
Cell[CellGroupData[{
Cell[71493, 2659, 172, 5, 70, "Input",
 CellID->43051369],
Cell[71668, 2666, 560, 20, 36, "Output",
 CellID->369845670]
}, Open  ]],
Cell[72243, 2689, 125, 3, 70, "ExampleDelimiter",
 CellID->598893853],
Cell[72371, 2694, 371, 12, 70, "ExampleText",
 CellID->384841845],
Cell[CellGroupData[{
Cell[72767, 2710, 178, 6, 70, "Input",
 CellID->56320887],
Cell[72948, 2718, 228, 8, 36, "Output",
 CellID->264497265]
}, Open  ]],
Cell[73191, 2729, 374, 12, 70, "ExampleText",
 CellID->446586971],
Cell[CellGroupData[{
Cell[73590, 2745, 187, 6, 70, "Input",
 CellID->26130134],
Cell[73780, 2753, 374, 12, 36, "Output",
 CellID->51988188]
}, Open  ]],
Cell[74169, 2768, 124, 3, 70, "ExampleDelimiter",
 CellID->39376163],
Cell[74296, 2773, 357, 12, 70, "ExampleText",
 CellID->513429908],
Cell[CellGroupData[{
Cell[74678, 2789, 383, 14, 70, "Input",
 CellID->494266988],
Cell[75064, 2805, 540, 18, 36, "Output",
 CellID->303605152]
}, Open  ]],
Cell[CellGroupData[{
Cell[75641, 2828, 99, 3, 70, "Input",
 CellID->982054],
Cell[75743, 2833, 410, 15, 36, "Output",
 CellID->332562371]
}, Open  ]],
Cell[76168, 2851, 193, 7, 70, "ExampleText",
 CellID->25389692],
Cell[CellGroupData[{
Cell[76386, 2862, 111, 3, 70, "Input",
 CellID->52566483],
Cell[76500, 2867, 389, 14, 41, "Output",
 CellID->89229737]
}, Open  ]],
Cell[76904, 2884, 181, 7, 70, "ExampleText",
 CellID->40085400],
Cell[CellGroupData[{
Cell[77110, 2895, 303, 10, 70, "Input",
 CellID->6359055],
Cell[77416, 2907, 210, 7, 36, "Output",
 CellID->566486668]
}, Open  ]],
Cell[77641, 2917, 125, 3, 70, "ExampleDelimiter",
 CellID->260316574],
Cell[77769, 2922, 352, 13, 70, "ExampleText",
 CellID->144040243],
Cell[CellGroupData[{
Cell[78146, 2939, 193, 6, 70, "Input",
 CellID->377876305],
Cell[78342, 2947, 349, 12, 39, "Output",
 CellID->45024128]
}, Open  ]],
Cell[CellGroupData[{
Cell[78728, 2964, 106, 3, 70, "Input",
 CellID->545133790],
Cell[78837, 2969, 229, 9, 44, "Output",
 CellID->74312026]
}, Open  ]],
Cell[79081, 2981, 125, 3, 70, "ExampleDelimiter",
 CellID->267375168],
Cell[79209, 2986, 339, 13, 70, "ExampleText",
 CellID->109435148],
Cell[CellGroupData[{
Cell[79573, 3003, 389, 15, 70, "Input",
 CellID->20585069],
Cell[79965, 3020, 803, 30, 54, "Output",
 CellID->14633766]
}, Open  ]],
Cell[CellGroupData[{
Cell[80805, 3055, 104, 3, 70, "Input",
 CellID->366931829],
Cell[80912, 3060, 412, 15, 54, "Output",
 CellID->83266198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81373, 3081, 229, 7, 70, "ExampleSection",
 CellID->15950921],
Cell[81605, 3090, 252, 8, 70, "ExampleText",
 CellID->482986235],
Cell[CellGroupData[{
Cell[81882, 3102, 279, 9, 70, "Input",
 CellID->196633860],
Cell[82164, 3113, 162, 5, 36, "Output",
 CellID->516265000]
}, Open  ]],
Cell[CellGroupData[{
Cell[82363, 3123, 459, 16, 70, "Input",
 CellID->67948915],
Cell[82825, 3141, 402, 8, 70, "Message",
 CellID->413194754],
Cell[83230, 3151, 400, 8, 70, "Message",
 CellID->6409861],
Cell[83633, 3161, 399, 8, 70, "Message",
 CellID->789221],
Cell[84035, 3171, 425, 8, 70, "Message",
 CellID->373123736],
Cell[84463, 3181, 349, 10, 54, "Output",
 CellID->100358329]
}, Open  ]],
Cell[84827, 3194, 125, 3, 70, "ExampleDelimiter",
 CellID->430914281],
Cell[84955, 3199, 115, 3, 70, "ExampleText",
 CellID->128374341],
Cell[CellGroupData[{
Cell[85095, 3206, 375, 12, 70, "Input",
 CellID->327242016],
Cell[85473, 3220, 158, 5, 36, "Output",
 CellID->178605612]
}, Open  ]],
Cell[85646, 3228, 89, 1, 70, "ExampleText",
 CellID->351721158],
Cell[CellGroupData[{
Cell[85760, 3233, 180, 6, 70, "Input",
 CellID->312034815],
Cell[85943, 3241, 158, 5, 36, "Output",
 CellID->249441998]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86150, 3252, 224, 7, 70, "ExampleSection",
 CellID->24779],
Cell[86377, 3261, 220, 7, 70, "ExampleText",
 CellID->574558868],
Cell[CellGroupData[{
Cell[86622, 3272, 519, 18, 70, "Input",
 CellID->28514860],
Cell[87144, 3292, 162, 5, 36, "Output",
 CellID->473294071]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87367, 3304, 311, 9, 70, "SeeAlsoSection",
 CellID->23588],
Cell[87681, 3315, 2935, 107, 70, "SeeAlso",
 CellID->12481]
}, Open  ]],
Cell[CellGroupData[{
Cell[90653, 3427, 314, 9, 70, "TutorialsSection",
 CellID->23400],
Cell[90970, 3438, 175, 4, 70, "Tutorials",
 CellID->707],
Cell[91148, 3444, 139, 3, 70, "Tutorials",
 CellID->22955],
Cell[91290, 3449, 142, 3, 70, "Tutorials",
 CellID->377],
Cell[91435, 3454, 172, 3, 70, "Tutorials",
 CellID->310680328]
}, Open  ]],
Cell[CellGroupData[{
Cell[91644, 3462, 321, 9, 70, "RelatedLinksSection",
 CellID->20666],
Cell[91968, 3473, 251, 5, 70, "RelatedLinks",
 CellID->4141],
Cell[92222, 3480, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92649, 3498, 319, 9, 70, "MoreAboutSection",
 CellID->760711569],
Cell[92971, 3509, 145, 3, 70, "MoreAbout",
 CellID->703047593],
Cell[93119, 3514, 161, 3, 70, "MoreAbout",
 CellID->194928452],
Cell[93283, 3519, 156, 3, 70, "MoreAbout",
 CellID->289700968],
Cell[93442, 3524, 150, 3, 70, "MoreAbout",
 CellID->25514548],
Cell[93595, 3529, 135, 3, 70, "MoreAbout",
 CellID->2600751],
Cell[93733, 3534, 157, 3, 70, "MoreAbout",
 CellID->824611267],
Cell[93893, 3539, 169, 3, 70, "MoreAbout",
 CellID->291584225],
Cell[94065, 3544, 179, 3, 70, "MoreAbout",
 CellID->187280547]
}, Open  ]],
Cell[94259, 3550, 50, 0, 70, "History"],
Cell[94312, 3552, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

