(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73125,       2756]
NotebookOptionsPosition[     59192,       2263]
NotebookOutlinePosition[     60812,       2305]
CellTagsIndexPosition[     60726,       2300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Working with Special Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithSpecialFunctions"], 
          "Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Working with Special Functions\"\>", 
       2->"\<\"Putting Expressions into Different Forms\"\>", 
       3->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], 
          "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TrigExpand\"\>", 
       2->"\<\"TrigToExp\"\>", 3->"\<\"ComplexExpand\"\>", 
       4->"\<\"FullSimplify\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Assumptions and Domains\"\>", 
       3->"\<\"Formula Manipulation\"\>", 4->"\<\"Number Recognition\"\>", 
       5->"\<\"Trigonometric Functions\"\>", 
       6->"\<\"New in 6.0: Symbolic Computation\"\>", 
       7->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["FunctionExpand", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FunctionExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FunctionExpand"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]tries to expand out special and certain other functions \
in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", when possible reducing compound arguments to simpler ones. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FunctionExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FunctionExpand"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands using assumptions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " uses a large collection of rules. "
}], "Notes",
 CellID->13490],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " applies to certain trigonometric functions as well as special functions. "
}], "Notes",
 CellID->7604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " is automatically called by ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31601],

Cell[TextData[{
 "Assumptions in ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " can be specified as in ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24227],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["x", "TI"], "\[Element]", 
     ButtonBox["Reals",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reals"]}]}], "]"}]], "InlineFormula"],
 " performs expansion assuming that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is real. "
}], "Notes",
 CellID->11197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " has the option ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 ", specifying default assumptions to be appended to ",
 Cell[BoxData[
  StyleBox["assum", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23692],

Cell[TextData[{
 "The default setting for the ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19771],

Cell[TextData[{
 "You can specify default assumptions for ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20363],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " automatically threads over lists in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", as well as equations, inequalities and logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20884698],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->719892550],

Cell["Expand constants:", "ExampleText",
 CellID->92848709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"24", "Degree"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9910007],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "8"]}], " ", 
   SqrtBox["3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     SqrtBox["5"]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       SqrtBox["5"]}], ")"}]}]]}]}]], "Output",
 ImageSize->{237, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->778256989]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{"ArcTan", "[", 
     FractionBox["1", "5"], "]"}]}], "-", 
   RowBox[{"ArcTan", "[", 
    FractionBox["1", "239"], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->308944030],

Cell[BoxData[
 FractionBox["\[Pi]", "4"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->675757713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->982409300],

Cell["Find expansion in terms of simpler functions:", "ExampleText",
 CellID->364642218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"ChebyshevT", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431085587],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"n", " ", 
   RowBox[{"ArcCos", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96180129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     FractionBox["1", "2"], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168211364],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"BesselI", "[", 
   RowBox[{"0", ",", 
    SqrtBox["z"]}], "]"}], "2"]], "Output",
 ImageSize->{115, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253153492]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31812],

Cell["Expansions of constants:", "ExampleText",
 CellID->153473755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"{", 
   RowBox[{"Degree", ",", "GoldenRatio"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384986574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["\[Pi]", "180"], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["5"]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{126, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216047621]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Log", "[", 
   FractionBox[
    RowBox[{"1", "+", 
     RowBox[{"I", 
      SqrtBox["3"]}]}], "2"], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122327091],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "3"]], "Output",
 ImageSize->{28, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->243418104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Zeta", "'"}], "[", 
   RowBox[{"-", "2"}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->715016091],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Zeta", "[", "3", "]"}], 
   RowBox[{"4", " ", 
    SuperscriptBox["\[Pi]", "2"]}]]}]], "Output",
 ImageSize->{65, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->550654210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyGamma", "[", 
   RowBox[{
    RowBox[{"-", "3"}], ",", "1"}], "]"}], "//", "FunctionExpand"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->32018902],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "Glaisher", "]"}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Log", "[", "2", "]"}], "+", 
     RowBox[{"Log", "[", "\[Pi]", "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{234, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->455917746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31445601],

Cell["Expansions of elementary functions and their compositions:", \
"ExampleText",
 CellID->64470104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    SqrtBox[
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}]], ",", 
    RowBox[{"Log", "[", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]], "]"}]}], "}"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263571013],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox[
     RowBox[{"-", "x"}]], " ", 
    SqrtBox["x"]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"1", "-", "x"}], "]"}], "+", 
      RowBox[{"Log", "[", 
       RowBox[{"1", "+", "x"}], "]"}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{252, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33058158]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", "x", "]"}]}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118184895],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "x"}], 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141767631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "[", 
   RowBox[{"2", " ", 
    RowBox[{"ArcTanh", "[", "x", "]"}]}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->481063231],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   RowBox[{"2", " ", "x"}], 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]], "+", 
  FractionBox[
   SuperscriptBox["x", "2"], 
   RowBox[{"1", "-", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 ImageSize->{138, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->272517022]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233993650],

Cell["Expansions of orthogonal polynomials and related functions:", \
"ExampleText",
 CellID->320528108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ChebyshevT", "[", 
     RowBox[{"n", ",", "x"}], "]"}], ",", 
    RowBox[{"ChebyshevU", "[", 
     RowBox[{"n", ",", "x"}], "]"}]}], "}"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186618236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"n", " ", 
     RowBox[{"ArcCos", "[", "x", "]"}]}], "]"}], ",", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "n"}], ")"}], " ", 
      RowBox[{"ArcCos", "[", "x", "]"}]}], "]"}], 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", "x"}]], " ", 
     SqrtBox[
      RowBox[{"1", "+", "x"}]]}]]}], "}"}]], "Output",
 ImageSize->{283, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100022309]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LegendreQ", "[", 
   RowBox[{
    FractionBox["3", "2"], ",", 
    FractionBox["1", "2"], ",", "x"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->240405362],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SqrtBox["\[Pi]"], " ", 
    SqrtBox[
     RowBox[{"1", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], ")"}]}]}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], 
     RowBox[{"1", "/", "4"}]], " ", "x"}], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], 
    RowBox[{"1", "/", "4"}]]]}]], "Output",
 ImageSize->{224, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->502370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10823258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " reduces compound arguments to simpler ones:"
}], "ExampleText",
 CellID->430402393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", " ", 
  RowBox[{"AiryAi", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"4", "/", "3"}]], "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86067388],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"AiryAi", "[", "x", "]"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"AiryBi", "[", "x", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{254, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29143923]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    SqrtBox[
     RowBox[{"x", "^", "2"}]], "]"}], "/", 
   SqrtBox[
    RowBox[{"x", "^", "2"}]]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75160396],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", "x", "]"}], "x"]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225969517]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BesselJ", "[", 
   RowBox[{"\[Nu]", ",", 
    RowBox[{"-", "x"}]}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->44746550],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "x"}], ")"}], "\[Nu]"], " ", 
  SuperscriptBox["x", 
   RowBox[{"-", "\[Nu]"}]], " ", 
  RowBox[{"BesselJ", "[", 
   RowBox[{"\[Nu]", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->594725322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->313162644],

Cell["Expansions of elliptic functions:", "ExampleText",
 CellID->246818724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"JacobiSN", "[", 
     RowBox[{"u", ",", "m"}], "]"}], 
    RowBox[{"JacobiND", "[", 
     RowBox[{"u", ",", "m"}], "]"}]}], "\[Equal]", 
   RowBox[{"JacobiSD", "[", 
    RowBox[{"u", ",", "m"}], "]"}]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237044975],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114092244]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"EllipticNomeQ", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->347106339],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"-", 
   FractionBox[
    RowBox[{"\[Pi]", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}], 
    RowBox[{"EllipticK", "[", "m", "]"}]]}]]], "Output",
 ImageSize->{99, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84320897]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2080253],

Cell["Expansions of number theoretic functions:", "ExampleText",
 CellID->311018514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"CatalanNumber", "[", "n", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63657671],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"2", " ", "n"}]], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["1", "2"], "+", "n"}], "]"}]}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"2", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{112, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287268483]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"n", "+", "3"}], "]"}], ",", 
   RowBox[{"n", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343963080],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
  RowBox[{"LucasL", "[", "n", "]"}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->313879300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->249764686],

Cell["Expansions of unevaluated derivatives:", "ExampleText",
 CellID->218974014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Derivative", "[", 
     RowBox[{"1", ",", "0"}], "]"}], "[", "BesselJ", "]"}], "[", 
   RowBox[{"1", ",", "x"}], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122277620],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "x"}], "]"}], "x"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Pi]", " ", 
   RowBox[{"BesselY", "[", 
    RowBox[{"1", ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{223, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367484424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->597695199],

Cell["Expansions of hypergeometric family functions:", "ExampleText",
 CellID->241192872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"HypergeometricU", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"-", 
     FractionBox["3", "2"]}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->960077036],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"5", "/", "2"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        RowBox[{"2", " ", "x"}]}], ")"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["x", 
       RowBox[{"5", "/", "2"}]]}]], "+", 
    FractionBox["3", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "2"]}]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", "x"}]}], ")"}], " ", 
      RowBox[{"Erf", "[", 
       SqrtBox["x"], "]"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["x", 
       RowBox[{"5", "/", "2"}]]}]]}], ")"}]}]], "Output",
 ImageSize->{362, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87236103]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"], ",", 
      FractionBox["1", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16931564],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox[
     RowBox[{"EllipticE", "[", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox[
        SqrtBox[
         RowBox[{"1", "-", "x"}]], "2"]}], "]"}], "2"]}], 
   SuperscriptBox["\[Pi]", "2"]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    RowBox[{"EllipticE", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", "x"}]], "2"]}], "]"}], " ", 
    RowBox[{"EllipticK", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", "x"}]], "2"]}], "]"}]}], 
   SuperscriptBox["\[Pi]", "2"]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"EllipticK", "[", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       FractionBox[
        SqrtBox[
         RowBox[{"1", "-", "x"}]], "2"]}], "]"}], "2"]}], 
   SuperscriptBox["\[Pi]", "2"]]}]], "Output",
 ImageSize->{463, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->624158778]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"MeijerG", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "a"}], "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", "}"}]}], "}"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->136802254],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    FractionBox["a", "2"]}]], " ", 
  RowBox[{"BesselK", "[", 
   RowBox[{"a", ",", 
    FractionBox["2", 
     SqrtBox["x"]]}], "]"}]}]], "Output",
 ImageSize->{157, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->525388053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->247037031],

Cell["Expansion of special functions:", "ExampleText",
 CellID->51905362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "-", "z"}]}], "]"}], "+", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->611722891],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "6"], "-", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "z"}], "]"}], " ", 
   RowBox[{"Log", "[", "z", "]"}]}]}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{141, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369284345]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyGamma", "[", 
    RowBox[{"3", ",", 
     RowBox[{"z", "-", "2"}]}], "]"}], "-", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"3", ",", "z"}], "]"}]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->277203072],

Cell[BoxData[
 RowBox[{"6", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "z"}], ")"}], "4"]], "+", 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}], "4"]]}], ")"}]}]], "Output",
 ImageSize->{157, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->521519373]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Zeta", "[", 
    RowBox[{"1", "-", "z"}], "]"}], "/", 
   RowBox[{"Zeta", "[", "z", "]"}]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->482856958],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{"1", "-", "z"}]], " ", 
  SuperscriptBox["\[Pi]", 
   RowBox[{"-", "z"}]], " ", 
  RowBox[{"Gamma", "[", "z", "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "z"}], ")"}]}], "]"}]}]], "Output",
 ImageSize->{211, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->280610408]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"z", "+", "3"}], "]"}], "-", 
   RowBox[{
    RowBox[{"Gamma", "[", "z", "]"}], "z"}]}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->90357175],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", "z"}], "+", 
    SuperscriptBox["z", "2"]}], ")"}], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "z"}], "]"}]}]], "Output",
 ImageSize->{159, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->185307036]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23015],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8055],

Cell["Some expansions are valid under additional assumptions:", "ExampleText",
 CellID->214093208],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"ProductLog", "[", 
    RowBox[{"x", " ", 
     RowBox[{"Log", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"x", ">", 
    RowBox[{"1", "/", "E"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128677679],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213611085]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->441360246],

Cell[TextData[{
 "Here ",
 Cell[BoxData["n"], "InlineFormula"],
 " is assumed to be a generic complex number:"
}], "ExampleText",
 CellID->72694567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Fibonacci", "[", 
   RowBox[{"n", "+", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655980773],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["2", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}]], ")"}], 
    RowBox[{
     RowBox[{"-", "3"}], "-", "n"}]], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         SqrtBox["5"]}], ")"}]}], ")"}], 
     RowBox[{
      RowBox[{"-", "3"}], "-", "n"}]], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", "n"}], ")"}], " ", "\[Pi]"}], "]"}]}]}], 
  SqrtBox["5"]]], "Output",
 ImageSize->{285, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443516945]
}, Open  ]],

Cell[TextData[{
 "Assume ",
 Cell[BoxData["n"], "InlineFormula"],
 " to be integer:"
}], "ExampleText",
 CellID->609067275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"Fibonacci", "[", 
    RowBox[{"n", "+", "3"}], "]"}], ",", 
   RowBox[{"n", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->738656610],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   RowBox[{"Fibonacci", "[", "n", "]"}]}], "+", 
  RowBox[{"LucasL", "[", "n", "]"}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3931886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204438094],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " applies transformations valid for generic index ",
 Cell[BoxData["\[Nu]"], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->408245932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"BesselK", "[", 
   RowBox[{"\[Nu]", ",", 
    RowBox[{"-", "x"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406474437],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "x"}], ")"}], 
    RowBox[{"-", "\[Nu]"}]], " ", 
   SuperscriptBox["x", "\[Nu]"], " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"\[Nu]", ",", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Pi]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "x"}], ")"}], 
    RowBox[{"-", "\[Nu]"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{"-", "\[Nu]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "x"}], ")"}], 
      RowBox[{"2", " ", "\[Nu]"}]], "-", 
     SuperscriptBox["x", 
      RowBox[{"2", " ", "\[Nu]"}]]}], ")"}], " ", 
   RowBox[{"BesselI", "[", 
    RowBox[{"\[Nu]", ",", "x"}], "]"}], " ", 
   RowBox[{"Csc", "[", 
    RowBox[{"\[Pi]", " ", "\[Nu]"}], "]"}]}]}]], "Output",
 ImageSize->{485, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124664936]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " to get a specific transformation:"
}], "ExampleText",
 CellID->7449303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"\[Nu]", ",", 
     RowBox[{"-", "x"}]}], "]"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"\[Nu]", "\[Element]", "Integers"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->349392720],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "\[Nu]"], " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"\[Nu]", ",", "x"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"BesselI", "[", 
    RowBox[{"\[Nu]", ",", "x"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Log", "[", 
       RowBox[{"-", "x"}], "]"}]}], "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{360, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->267910898]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3393],

Cell[TextData[{
 "Rewrite a solution returned by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148685315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       RowBox[{"w", "'''"}], "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       RowBox[{"w", "''"}], "[", "z", "]"}]}], "+", 
     RowBox[{"z", " ", 
      RowBox[{
       RowBox[{"w", "'"}], "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->576419854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "3", "]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"ExpIntegralEi", "[", 
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}], "]"}]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"ExpIntegralEi", "[", 
          RowBox[{"\[ImaginaryI]", " ", "z"}], "]"}]}]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{495, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26475174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"w", "[", "z", "]"}], "/.", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->274761695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"C", "[", "3", "]"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"CosIntegral", "[", "z", "]"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Log", "[", 
              FractionBox["\[ImaginaryI]", "z"], "]"}]}], "+", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}], "]"}]}], ")"}]}], 
         "-", 
         RowBox[{"Log", "[", "z", "]"}], "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"SinIntegral", "[", "z", "]"}]}]}], ")"}]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"CosIntegral", "[", "z", "]"}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"Log", "[", 
              RowBox[{"-", 
               FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "+", 
            RowBox[{"Log", "[", 
             RowBox[{"\[ImaginaryI]", " ", "z"}], "]"}]}], ")"}]}], "-", 
         RowBox[{"Log", "[", "z", "]"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{"SinIntegral", "[", "z", "]"}]}]}], ")"}]}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{581, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13714053]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8738],

Cell["The output is generically equivalent to the input:", "ExampleText",
 CellID->21038693],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", "/", "128"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256526912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FunctionExpand", "[", "e", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->569557691],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"2", "-", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox["2"]}]]}]]}]]}]]}]]}]], "Output",
 ImageSize->{234, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105143112]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "\[Equal]", "f"}], "//", "N"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->249105971],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->242565194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277074514],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " is used as a transformation function in ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103997376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "-", "z"}]}], "]"}], "+", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}], "-", 
   RowBox[{"Zeta", "[", "2", "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184986926],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "z"}], "]"}]}], " ", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368560828]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "-", "z"}]}], "]"}], "+", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}], "-", 
   RowBox[{"Zeta", "[", "2", "]"}]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3923118],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "z"}], "]"}]}], " ", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186383264]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " will produce the simplest form found: "
}], "ExampleText",
 CellID->240658712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "-", "z"}]}], "]"}], "+", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56517035],

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", 
    RowBox[{"1", "-", "z"}]}], "]"}], "+", 
  RowBox[{"PolyLog", "[", 
   RowBox[{"2", ",", "z"}], "]"}]}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->269441908]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "-", "z"}]}], "]"}], "+", 
   RowBox[{"PolyLog", "[", 
    RowBox[{"2", ",", "z"}], "]"}]}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->57554054],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[Pi]", "2"], "6"], "-", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "z"}], "]"}], " ", 
   RowBox[{"Log", "[", "z", "]"}]}]}]], "Output",
 ImageSize->{141, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->112795878]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15279],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " may not always expand expressions involving inexact numbers:"
}], "ExampleText",
 CellID->422495753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", "1.0"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59203149],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "n"}], ")"}], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1.`", "\[InvisibleSpace]", "+", "n"}], "]"}]}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77090494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"n", "+", "1"}], ")"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"n", "+", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->231965085],

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"2", "+", "n"}], "]"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81257008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21195829],

Cell[TextData[{
 "Some transformations used by ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " are only generically valid:"
}], "ExampleText",
 CellID->147930722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"GegenbauerC", "[", 
   RowBox[{"n", ",", 
    RowBox[{"-", "5"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199432256],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189342651]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GegenbauerC", "[", 
    RowBox[{"n", ",", 
     RowBox[{"-", "5"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9448400],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "10"}], " ", "x"}], ",", 
   RowBox[{"5", "+", 
    RowBox[{"40", " ", 
     SuperscriptBox["x", "2"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "40"}], " ", "x"}], "-", 
    RowBox[{"80", " ", 
     SuperscriptBox["x", "3"]}]}], ",", 
   RowBox[{"10", "+", 
    RowBox[{"120", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"80", " ", 
     SuperscriptBox["x", "4"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "60"}], " ", "x"}], "-", 
    RowBox[{"160", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"32", " ", 
     SuperscriptBox["x", "5"]}]}], ",", 
   RowBox[{"10", "+", 
    RowBox[{"120", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"80", " ", 
     SuperscriptBox["x", "4"]}]}]}], "}"}]], "Output",
 ImageSize->{562, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->532588125]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GegenbauerC", "[", 
    RowBox[{
     RowBox[{"n", "+", 
      RowBox[{"1", "/", "2"}]}], ",", 
     RowBox[{"-", "5"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112024112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79737600]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17421],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23445]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29301],

Cell[TextData[ButtonBox["Working with Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithSpecialFunctions"]], "Tutorials",
 CellID->22363],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->24630],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7721],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#1832"], None}]], "RelatedLinks",
 CellID->3565],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
FunctionExpand"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->81539887],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->271050542],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->47563382],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->342666838],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->622958214],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->153918456],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->138989396],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->762426722]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FunctionExpand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 45.8461528}", "context" -> "System`", 
    "keywords" -> {
     "compound arguments", "expanding", "expanding special constants", 
      "expanding special functions", "expanding special sequences", 
      "identities", "reduction formulas", "reflection formulas", 
      "special functions", "transformations"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FunctionExpand[expr] tries to expand out special and certain other \
functions in expr, when possible reducing compound arguments to simpler ones. \
FunctionExpand[expr, assum] expands using assumptions. ", 
    "synonyms" -> {"function expand"}, "title" -> "FunctionExpand", "type" -> 
    "Symbol", "uri" -> "ref/FunctionExpand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13206, 373, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20884698]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 60583, 2293}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3509, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4132, 104, 4198, 83, 70, "ObjectNameGrid"],
Cell[8333, 189, 1014, 30, 70, "Usage",
 CellID->14723]
}, Open  ]],
Cell[CellGroupData[{
Cell[9384, 224, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9862, 241, 214, 7, 70, "Notes",
 CellID->13490],
Cell[10079, 250, 252, 7, 70, "Notes",
 CellID->7604],
Cell[10334, 259, 341, 12, 70, "Notes",
 CellID->31601],
Cell[10678, 273, 349, 13, 70, "Notes",
 CellID->24227],
Cell[11030, 288, 504, 18, 70, "Notes",
 CellID->11197],
Cell[11537, 308, 444, 15, 70, "Notes",
 CellID->23692],
Cell[11984, 325, 351, 13, 70, "Notes",
 CellID->19771],
Cell[12338, 340, 357, 13, 70, "Notes",
 CellID->20363],
Cell[12698, 355, 471, 13, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[13206, 373, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20884698],
Cell[CellGroupData[{
Cell[13590, 387, 148, 5, 70, "ExampleSection",
 CellID->719892550],
Cell[13741, 394, 59, 1, 70, "ExampleText",
 CellID->92848709],
Cell[CellGroupData[{
Cell[13825, 399, 163, 5, 28, "Input",
 CellID->9910007],
Cell[13991, 406, 531, 22, 60, "Output",
 CellID->778256989]
}, Open  ]],
Cell[CellGroupData[{
Cell[14559, 433, 270, 9, 42, "Input",
 CellID->308944030],
Cell[14832, 444, 182, 6, 49, "Output",
 CellID->675757713]
}, Open  ]],
Cell[15029, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->982409300],
Cell[15157, 458, 88, 1, 70, "ExampleText",
 CellID->364642218],
Cell[CellGroupData[{
Cell[15270, 463, 171, 5, 70, "Input",
 CellID->431085587],
Cell[15444, 470, 244, 8, 36, "Output",
 CellID->96180129]
}, Open  ]],
Cell[CellGroupData[{
Cell[15725, 483, 288, 9, 70, "Input",
 CellID->168211364],
Cell[16016, 494, 254, 9, 44, "Output",
 CellID->253153492]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16319, 509, 216, 7, 70, "ExampleSection",
 CellID->31812],
Cell[16538, 518, 67, 1, 70, "ExampleText",
 CellID->153473755],
Cell[CellGroupData[{
Cell[16630, 523, 172, 5, 70, "Input",
 CellID->384986574],
Cell[16805, 530, 346, 13, 51, "Output",
 CellID->216047621]
}, Open  ]],
Cell[CellGroupData[{
Cell[17188, 548, 224, 8, 70, "Input",
 CellID->122327091],
Cell[17415, 558, 217, 7, 51, "Output",
 CellID->243418104]
}, Open  ]],
Cell[CellGroupData[{
Cell[17669, 570, 175, 6, 70, "Input",
 CellID->715016091],
Cell[17847, 578, 282, 10, 53, "Output",
 CellID->550654210]
}, Open  ]],
Cell[CellGroupData[{
Cell[18166, 593, 187, 7, 70, "Input",
 CellID->32018902],
Cell[18356, 602, 382, 13, 51, "Output",
 CellID->455917746]
}, Open  ]],
Cell[18753, 618, 124, 3, 70, "ExampleDelimiter",
 CellID->31445601],
Cell[18880, 623, 102, 2, 70, "ExampleText",
 CellID->64470104],
Cell[CellGroupData[{
Cell[19007, 629, 322, 13, 70, "Input",
 CellID->263571013],
Cell[19332, 644, 498, 19, 51, "Output",
 CellID->33058158]
}, Open  ]],
Cell[CellGroupData[{
Cell[19867, 668, 198, 7, 70, "Input",
 CellID->118184895],
Cell[20068, 677, 249, 9, 52, "Output",
 CellID->141767631]
}, Open  ]],
Cell[CellGroupData[{
Cell[20354, 691, 199, 7, 70, "Input",
 CellID->481063231],
Cell[20556, 700, 453, 17, 55, "Output",
 CellID->272517022]
}, Open  ]],
Cell[21024, 720, 125, 3, 70, "ExampleDelimiter",
 CellID->233993650],
Cell[21152, 725, 104, 2, 70, "ExampleText",
 CellID->320528108],
Cell[CellGroupData[{
Cell[21281, 731, 286, 10, 70, "Input",
 CellID->186618236],
Cell[21570, 743, 577, 21, 55, "Output",
 CellID->100022309]
}, Open  ]],
Cell[CellGroupData[{
Cell[22184, 769, 225, 8, 70, "Input",
 CellID->240405362],
Cell[22412, 779, 647, 24, 79, "Output",
 CellID->502370]
}, Open  ]],
Cell[23074, 806, 124, 3, 70, "ExampleDelimiter",
 CellID->10823258],
Cell[23201, 811, 233, 7, 70, "ExampleText",
 CellID->430402393],
Cell[CellGroupData[{
Cell[23459, 822, 266, 9, 70, "Input",
 CellID->86067388],
Cell[23728, 833, 465, 16, 51, "Output",
 CellID->29143923]
}, Open  ]],
Cell[CellGroupData[{
Cell[24230, 854, 241, 9, 70, "Input",
 CellID->75160396],
Cell[24474, 865, 208, 7, 51, "Output",
 CellID->225969517]
}, Open  ]],
Cell[CellGroupData[{
Cell[24719, 877, 187, 6, 70, "Input",
 CellID->44746550],
Cell[24909, 885, 372, 13, 36, "Output",
 CellID->594725322]
}, Open  ]],
Cell[25296, 901, 125, 3, 70, "ExampleDelimiter",
 CellID->313162644],
Cell[25424, 906, 76, 1, 70, "ExampleText",
 CellID->246818724],
Cell[CellGroupData[{
Cell[25525, 911, 342, 11, 70, "Input",
 CellID->237044975],
Cell[25870, 924, 161, 5, 36, "Output",
 CellID->114092244]
}, Open  ]],
Cell[CellGroupData[{
Cell[26068, 934, 150, 4, 70, "Input",
 CellID->347106339],
Cell[26221, 940, 367, 12, 46, "Output",
 CellID->84320897]
}, Open  ]],
Cell[26603, 955, 123, 3, 70, "ExampleDelimiter",
 CellID->2080253],
Cell[26729, 960, 84, 1, 70, "ExampleText",
 CellID->311018514],
Cell[CellGroupData[{
Cell[26838, 965, 149, 4, 70, "Input",
 CellID->63657671],
Cell[26990, 971, 432, 16, 64, "Output",
 CellID->287268483]
}, Open  ]],
Cell[CellGroupData[{
Cell[27459, 992, 235, 7, 70, "Input",
 CellID->343963080],
Cell[27697, 1001, 274, 9, 36, "Output",
 CellID->313879300]
}, Open  ]],
Cell[27986, 1013, 125, 3, 70, "ExampleDelimiter",
 CellID->249764686],
Cell[28114, 1018, 81, 1, 70, "ExampleText",
 CellID->218974014],
Cell[CellGroupData[{
Cell[28220, 1023, 258, 8, 70, "Input",
 CellID->122277620],
Cell[28481, 1033, 381, 13, 51, "Output",
 CellID->367484424]
}, Open  ]],
Cell[28877, 1049, 125, 3, 70, "ExampleDelimiter",
 CellID->597695199],
Cell[29005, 1054, 89, 1, 70, "ExampleText",
 CellID->241192872],
Cell[CellGroupData[{
Cell[29119, 1059, 274, 9, 70, "Input",
 CellID->960077036],
Cell[29396, 1070, 1021, 36, 68, "Output",
 CellID->87236103]
}, Open  ]],
Cell[CellGroupData[{
Cell[30454, 1111, 397, 13, 70, "Input",
 CellID->16931564],
Cell[30854, 1126, 1127, 41, 120, "Output",
 CellID->624158778]
}, Open  ]],
Cell[CellGroupData[{
Cell[32018, 1172, 401, 14, 70, "Input",
 CellID->136802254],
Cell[32422, 1188, 378, 14, 55, "Output",
 CellID->525388053]
}, Open  ]],
Cell[32815, 1205, 125, 3, 70, "ExampleDelimiter",
 CellID->247037031],
Cell[32943, 1210, 73, 1, 70, "ExampleText",
 CellID->51905362],
Cell[CellGroupData[{
Cell[33041, 1215, 275, 9, 70, "Input",
 CellID->611722891],
Cell[33319, 1226, 391, 14, 54, "Output",
 CellID->369284345]
}, Open  ]],
Cell[CellGroupData[{
Cell[33747, 1245, 279, 9, 70, "Input",
 CellID->277203072],
Cell[34029, 1256, 486, 18, 55, "Output",
 CellID->521519373]
}, Open  ]],
Cell[CellGroupData[{
Cell[34552, 1279, 218, 7, 70, "Input",
 CellID->482856958],
Cell[34773, 1288, 470, 16, 51, "Output",
 CellID->280610408]
}, Open  ]],
Cell[CellGroupData[{
Cell[35280, 1309, 242, 9, 70, "Input",
 CellID->90357175],
Cell[35525, 1320, 345, 12, 39, "Output",
 CellID->185307036]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35919, 1338, 218, 7, 70, "ExampleSection",
 CellID->23015],
Cell[CellGroupData[{
Cell[36162, 1349, 227, 7, 70, "ExampleSubsection",
 CellID->8055],
Cell[36392, 1358, 98, 1, 70, "ExampleText",
 CellID->214093208],
Cell[CellGroupData[{
Cell[36515, 1363, 278, 9, 70, "Input",
 CellID->128677679],
Cell[36796, 1374, 187, 6, 36, "Output",
 CellID->213611085]
}, Open  ]],
Cell[36998, 1383, 125, 3, 70, "ExampleDelimiter",
 CellID->441360246],
Cell[37126, 1388, 148, 5, 70, "ExampleText",
 CellID->72694567],
Cell[CellGroupData[{
Cell[37299, 1397, 170, 5, 70, "Input",
 CellID->655980773],
Cell[37472, 1404, 748, 29, 80, "Output",
 CellID->443516945]
}, Open  ]],
Cell[38235, 1436, 123, 5, 70, "ExampleText",
 CellID->609067275],
Cell[CellGroupData[{
Cell[38383, 1445, 235, 7, 70, "Input",
 CellID->738656610],
Cell[38621, 1454, 272, 9, 36, "Output",
 CellID->3931886]
}, Open  ]],
Cell[38908, 1466, 125, 3, 70, "ExampleDelimiter",
 CellID->204438094],
Cell[39036, 1471, 287, 9, 70, "ExampleText",
 CellID->408245932],
Cell[CellGroupData[{
Cell[39348, 1484, 192, 6, 70, "Input",
 CellID->406474437],
Cell[39543, 1492, 988, 34, 51, "Output",
 CellID->124664936]
}, Open  ]],
Cell[40546, 1529, 224, 8, 70, "ExampleText",
 CellID->7449303],
Cell[CellGroupData[{
Cell[40795, 1541, 298, 9, 70, "Input",
 CellID->349392720],
Cell[41096, 1552, 590, 21, 36, "Output",
 CellID->267910898]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[41747, 1580, 222, 7, 70, "ExampleSection",
 CellID->3393],
Cell[41972, 1589, 210, 8, 70, "ExampleText",
 CellID->148685315],
Cell[CellGroupData[{
Cell[42207, 1601, 476, 16, 70, "Input",
 CellID->576419854],
Cell[42686, 1619, 795, 25, 51, "Output",
 CellID->26475174]
}, Open  ]],
Cell[CellGroupData[{
Cell[43518, 1649, 163, 5, 70, "Input",
 CellID->274761695],
Cell[43684, 1656, 1694, 50, 81, "Output",
 CellID->13714053]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45427, 1712, 232, 7, 70, "ExampleSection",
 CellID->8738],
Cell[45662, 1721, 92, 1, 70, "ExampleText",
 CellID->21038693],
Cell[45757, 1724, 169, 6, 70, "Input",
 CellID->256526912],
Cell[CellGroupData[{
Cell[45951, 1734, 133, 4, 70, "Input",
 CellID->569557691],
Cell[46087, 1740, 444, 18, 83, "Output",
 CellID->105143112]
}, Open  ]],
Cell[CellGroupData[{
Cell[46568, 1763, 123, 4, 70, "Input",
 CellID->249105971],
Cell[46694, 1769, 161, 5, 36, "Output",
 CellID->242565194]
}, Open  ]],
Cell[46870, 1777, 125, 3, 70, "ExampleDelimiter",
 CellID->277074514],
Cell[46998, 1782, 363, 12, 70, "ExampleText",
 CellID->103997376],
Cell[CellGroupData[{
Cell[47386, 1798, 315, 10, 70, "Input",
 CellID->184986926],
Cell[47704, 1810, 285, 10, 36, "Output",
 CellID->368560828]
}, Open  ]],
Cell[CellGroupData[{
Cell[48026, 1825, 315, 10, 70, "Input",
 CellID->3923118],
Cell[48344, 1837, 285, 10, 36, "Output",
 CellID->186383264]
}, Open  ]],
Cell[48644, 1850, 224, 7, 70, "ExampleText",
 CellID->240658712],
Cell[CellGroupData[{
Cell[48893, 1861, 272, 9, 70, "Input",
 CellID->56517035],
Cell[49168, 1872, 322, 11, 36, "Output",
 CellID->269441908]
}, Open  ]],
Cell[CellGroupData[{
Cell[49527, 1888, 274, 9, 70, "Input",
 CellID->57554054],
Cell[49804, 1899, 341, 12, 54, "Output",
 CellID->112795878]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50194, 1917, 226, 7, 70, "ExampleSection",
 CellID->15279],
Cell[50423, 1926, 250, 7, 70, "ExampleText",
 CellID->422495753],
Cell[CellGroupData[{
Cell[50698, 1937, 241, 8, 70, "Input",
 CellID->59203149],
Cell[50942, 1947, 306, 10, 36, "Output",
 CellID->77090494]
}, Open  ]],
Cell[CellGroupData[{
Cell[51285, 1962, 240, 8, 70, "Input",
 CellID->231965085],
Cell[51528, 1972, 211, 7, 36, "Output",
 CellID->81257008]
}, Open  ]],
Cell[51754, 1982, 124, 3, 70, "ExampleDelimiter",
 CellID->21195829],
Cell[51881, 1987, 251, 8, 70, "ExampleText",
 CellID->147930722],
Cell[CellGroupData[{
Cell[52157, 1999, 202, 6, 70, "Input",
 CellID->199432256],
Cell[52362, 2007, 158, 5, 36, "Output",
 CellID->189342651]
}, Open  ]],
Cell[CellGroupData[{
Cell[52557, 2017, 266, 9, 70, "Input",
 CellID->9448400],
Cell[52826, 2028, 962, 34, 39, "Output",
 CellID->532588125]
}, Open  ]],
Cell[CellGroupData[{
Cell[53825, 2067, 321, 11, 70, "Input",
 CellID->112024112],
Cell[54149, 2080, 246, 8, 36, "Output",
 CellID->79737600]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54456, 2095, 311, 9, 70, "SeeAlsoSection",
 CellID->17421],
Cell[54770, 2106, 965, 35, 70, "SeeAlso",
 CellID->23445]
}, Open  ]],
Cell[CellGroupData[{
Cell[55772, 2146, 314, 9, 70, "TutorialsSection",
 CellID->29301],
Cell[56089, 2157, 168, 3, 70, "Tutorials",
 CellID->22363],
Cell[56260, 2162, 190, 4, 70, "Tutorials",
 CellID->24630],
Cell[56453, 2168, 142, 3, 70, "Tutorials",
 CellID->377]
}, Open  ]],
Cell[CellGroupData[{
Cell[56632, 2176, 320, 9, 70, "RelatedLinksSection",
 CellID->7721],
Cell[56955, 2187, 252, 5, 70, "RelatedLinks",
 CellID->3565],
Cell[57210, 2194, 392, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57639, 2212, 318, 9, 70, "MoreAboutSection",
 CellID->81539887],
Cell[57960, 2223, 161, 3, 70, "MoreAbout",
 CellID->271050542],
Cell[58124, 2228, 155, 3, 70, "MoreAbout",
 CellID->47563382],
Cell[58282, 2233, 151, 3, 70, "MoreAbout",
 CellID->342666838],
Cell[58436, 2238, 147, 3, 70, "MoreAbout",
 CellID->622958214],
Cell[58586, 2243, 157, 3, 70, "MoreAbout",
 CellID->153918456],
Cell[58746, 2248, 169, 3, 70, "MoreAbout",
 CellID->138989396],
Cell[58918, 2253, 179, 3, 70, "MoreAbout",
 CellID->762426722]
}, Open  ]],
Cell[59112, 2259, 50, 0, 70, "History"],
Cell[59165, 2261, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

