(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18660,        573]
NotebookOptionsPosition[     15516,        474]
NotebookOutlinePosition[     17103,        515]
CellTagsIndexPosition[     17018,        510]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Approximate Functions and Interpolation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApproximateFunctionsAndInterpolation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Approximate Functions and Interpolation\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], 
          "ListInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/ListInterpolation"], 
          "InterpolatingPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingPolynomial"], 
          "Table" :> Documentation`HelpLookup["paclet:ref/Table"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Interpolation\"\>", 
       2->"\<\"ListInterpolation\"\>", 3->"\<\"InterpolatingPolynomial\"\>", 
       4->"\<\"Table\"\>", 
       5->"\<\"InterpolatingFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Curve Fitting & Approximate Functions\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FunctionInterpolation", "ObjectName",
 CellID->28135],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FunctionInterpolation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FunctionInterpolation"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " running from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " and constructs an ",
     Cell[BoxData[
      ButtonBox["InterpolatingFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
     " object which represents an approximate function corresponding to the \
result. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["FunctionInterpolation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FunctionInterpolation"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an ",
     Cell[BoxData[
      ButtonBox["InterpolatingFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
     " object with several arguments. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14697]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["FunctionInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionInterpolation"]], "InlineFormula"],
 " to generate a single ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object from an expression containing several such objects. "
}], "Notes",
 CellID->32209]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->605806065],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->145025502],

Cell[TextData[{
 "Computes an InterpolatingFunction representation of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   RowBox[{"-", 
    RowBox[{
     RowBox[{
      ButtonBox["Sin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sin"], "[", 
      StyleBox["x", "TI"], "]"}], "^", "2"}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->348696962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FunctionInterpolation", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113022865],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "6.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97474963]
}, Open  ]],

Cell["Use the resulting function as any function:", "ExampleText",
 CellID->304774860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{"f", "'"}], "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10185695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69111421]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31920],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23224],

Cell[TextData[ButtonBox["Approximate Functions and Interpolation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApproximateFunctionsAndInterpolation"]], "Tutorials",
 CellID->1908]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->231115580],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CurveFittingAndApproximateFunctions"]], "MoreAbout",\

 CellID->683147726]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FunctionInterpolation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 46.6430482}", "context" -> "System`", 
    "keywords" -> {"reinterpolation", "resampling"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "FunctionInterpolation[expr, {x, x_min, x_max}] evaluates expr with x \
running from x_min to x_max and constructs an InterpolatingFunction object \
which represents an approximate function corresponding to the result. \
FunctionInterpolation[expr, {x, x_min, x_max}, {y, y_min, y_max}, ...] \
constructs an InterpolatingFunction object with several arguments. ", 
    "synonyms" -> {"function interpolation"}, "title" -> 
    "FunctionInterpolation", "type" -> "Symbol", "uri" -> 
    "ref/FunctionInterpolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6712, 210, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->605806065]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16875, 503}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2422, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3045, 86, 59, 1, 70, "ObjectName",
 CellID->28135],
Cell[3107, 89, 2611, 81, 70, "Usage",
 CellID->14697]
}, Open  ]],
Cell[CellGroupData[{
Cell[5755, 175, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6233, 192, 442, 13, 70, "Notes",
 CellID->32209]
}, Closed]],
Cell[CellGroupData[{
Cell[6712, 210, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->605806065],
Cell[CellGroupData[{
Cell[7097, 224, 148, 5, 70, "ExampleSection",
 CellID->145025502],
Cell[7248, 231, 437, 16, 70, "ExampleText",
 CellID->348696962],
Cell[CellGroupData[{
Cell[7710, 251, 340, 11, 28, "Input",
 CellID->113022865],
Cell[8053, 264, 359, 13, 36, "Output",
 CellID->97474963]
}, Open  ]],
Cell[8427, 280, 86, 1, 70, "ExampleText",
 CellID->304774860],
Cell[CellGroupData[{
Cell[8538, 285, 314, 11, 28, "Input",
 CellID->10185695],
Cell[8855, 298, 3863, 67, 124, "Output",
 Evaluatable->False,
 CellID->69111421]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12779, 372, 311, 9, 70, "SeeAlsoSection",
 CellID->31920],
Cell[13093, 383, 1264, 44, 70, "SeeAlso",
 CellID->27372]
}, Open  ]],
Cell[CellGroupData[{
Cell[14394, 432, 314, 9, 70, "TutorialsSection",
 CellID->23224],
Cell[14711, 443, 188, 4, 70, "Tutorials",
 CellID->1908]
}, Open  ]],
Cell[CellGroupData[{
Cell[14936, 452, 319, 9, 70, "MoreAboutSection",
 CellID->231115580],
Cell[15258, 463, 186, 4, 70, "MoreAbout",
 CellID->683147726]
}, Open  ]],
Cell[15459, 470, 27, 0, 70, "History"],
Cell[15489, 472, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

