(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83665,       2346]
NotebookOptionsPosition[     74097,       2029]
NotebookOutlinePosition[     75487,       2068]
CellTagsIndexPosition[     75401,       2063]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CoprimeQ" :> Documentation`HelpLookup["paclet:ref/CoprimeQ"], 
          "PrimeQ" :> Documentation`HelpLookup["paclet:ref/PrimeQ"], 
          "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], "Divisible" :> 
          Documentation`HelpLookup["paclet:ref/Divisible"], "Rational" :> 
          Documentation`HelpLookup["paclet:ref/Rational"], "LCM" :> 
          Documentation`HelpLookup["paclet:ref/LCM"], "ExtendedGCD" :> 
          Documentation`HelpLookup["paclet:ref/ExtendedGCD"], 
          "ChineseRemainder" :> 
          Documentation`HelpLookup["paclet:ref/ChineseRemainder"], "Cancel" :> 
          Documentation`HelpLookup["paclet:ref/Cancel"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"CoprimeQ\"\>", 2->"\<\"PrimeQ\"\>", 
       3->"\<\"PolynomialGCD\"\>", 4->"\<\"Divisible\"\>", 
       5->"\<\"Rational\"\>", 6->"\<\"LCM\"\>", 7->"\<\"ExtendedGCD\"\>", 
       8->"\<\"ChineseRemainder\"\>", 
       9->"\<\"Cancel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GCD", "ObjectName",
 CellID->28641],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GCD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GCD"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the greatest common divisor of the integers ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29986]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives the integer factors common to all the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21109],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " also works with rational numbers; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " gives the greatest rational number ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " for which all the ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["i", "TI"]], "/", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " are integers. "
}], "Notes",
 CellID->8187],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " has attributes ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53228419],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->175939110],

Cell["Greatest common divisor of three numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"2", ",", " ", "3", ",", " ", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176442268]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364612090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Use with rational arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"2", "/", "5"}], ",", 
   RowBox[{"3", "/", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox["1", "105"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183443827]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "/", "3"}], ",", 
    RowBox[{"2", "/", "5"}], ",", 
    RowBox[{"3", "/", "7"}]}], "}"}], "/", "%"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"35", ",", "42", ",", "45"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116786671]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Use with Gaussian integers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "10"}], "+", 
    RowBox[{"8", "I"}]}], ",", 
   RowBox[{"5", "-", 
    RowBox[{"4", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{"5", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->860469591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21214728],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->293716542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GCD", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24842365],

Cell[BoxData[
 FormBox[
  RowBox[{"gcd", "(", 
   RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->377744238]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"m", ",", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "60"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "60"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37344415],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJylV1li4yAMzXT2fTr72jZdk0li1wsGoznFHKEX6P3/RghsY8AEZ5QYnh76
CNJDOMu7+793R4vF4o95QLaCNyDaEm5B7gQ0sGol3HLk4QR5yZFvV8iLHfJQ
It9w5GEBB9sDADn9OY2swRE+0DrftcfA2mPgoRolCJCspjkDmpmk+QxoZoLm
DGhmFA+PKB6N01D0CIoeIewQFD2CxxpJzFgDsqIR8e+OWXpMH/PEMAfY0w7o
309PbmE4t7DMLQzPeuwkcOOmdONm+PmAsVZc1asco4sAR+iFxZGx5Oml7Snd
NlArDSPeKt0ivjT81vC14V+N4mfZ67EbVOtVWMNvHB/TxTFpFVep2yEgt+UI
lIurFblIvnWD+7oVQw2vh9oWQ13febHJduxTpEym9Zlp3d5o3WZavUxr+H0g
MtE+hEj83Vydz1Ltg6tzu1LnlKv9lOr8crW3j8E4S6u5rdvc1vCncJhXxbVf
188TUQn2ZWpB61NUWrcCu4TQGq6E0fDXyRhQjYfpPsR0R2LEIUnut+kQZx8b
d2ffIxF90oohk8WQ1R+xAK3R2sxbx/8ZXY/ar/gy6pMrxZZKvTul0lJplSvd
nuxZjdjpvkV9H+nzqO8cYe6cs71rJnWVB5b7l6zK5XYdzxNWYLjz7OEiZWHc
n2unP8f5oF2l0f0+imFH14ksZYzpvDGdxptUUvchYfqQMP0qjfNsnU5Nvm8k
MI5t5hDx8xv3zdXWdvfgHJcqxXS9spmeZflcx/Tetuu9c3BvxXwow+9XSWiy
OSSAcf3mzWTp73WjyWj1oBHCbSlpsN+Z5z7+v5L0r/92kf75D/sHO8kmXg==

   "], {{0, 0}, {60, 60}}, {0, 60}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{184., Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{188, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111856663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Find the fraction of pairs of the first 100 numbers that are relatively \
prime:\
\>", "ExampleText",
 CellID->14631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"Boole", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"GCD", "[", 
          RowBox[{"m", ",", "n"}], "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"m", ",", "100"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}], ",", "2"}], "]"}], 
   "/", 
   RowBox[{"10", "^", "4"}]}], "//", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13640],

Cell[BoxData["0.6087`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->544973367]
}, Open  ]],

Cell[TextData[{
 "The result is close to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    TagBox[
     RowBox[{"\[Zeta]", "(", 
      TagBox["2",
       Zeta,
       Editable->True,
       Selectable->True], ")"}],
     InterpretTemplate[
      Function[BoxForm`e$, 
       Zeta[BoxForm`e$]]],
     Editable->False,
     Selectable->False]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->18040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Zeta", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7986],

Cell[BoxData["0.6079271018540267`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->262549079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109570426],

Cell["\<\
Plot the means of the GCDs for successive \[OpenCurlyDoubleQuote]balls\
\[CloseCurlyDoubleQuote] of numbers:\
\>", "ExampleText",
 CellID->62980801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mean", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"GCD", "[", 
         RowBox[{"i", ",", "j"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"i", "-", "1"}]}], "}"}]}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204337047],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxVkX1Mk1cUh2sRIQqok8wtwSG6uirOgEiVifqzUAoCpS39moOKYPlQsHEU
sLCyLmwYlg2iickQkDkYKhJjQsaqRMIkZhmyKqKQrOgKBiRqAD+wCLLtLbvn
D04OefPkuc/tTQhKNyoNfB6Pl8H9ub//z+SehV8eFrI3LjW75wXjFThT7Z7n
jP2hnp8pxu/hVeTtl9wyDsBRR1ueo438WlQ+2sHta8brILTc/chy18X4Q2TO
D/kNMPVKVqea3jAWsvdNM94Ec5XreJWLeDP2N4RzO8N4C8LmZ5ZxCIaH3EP3
hcLnYNuyg23kt6Ll/JWzN4qpD4M+yuw7Ev6W8TZ4ypyLZU7icHCP4144x1gE
s9B2yvGS7tuOtMtrfjji9Q/jHeiaEqZU3aDzEWgvilWtHCb+BO8PF3Z9F0Tn
d2Jd/omeNVv/ZRyJmonywPsC8ruw8P+2G9MPSyauu8jvQV2+PeJxLfXAUNny
3dNOxlbAkRSUVeogvxfZMx9wy+6z7kWefTTXPkr3i3EtZlvLj0fIixG6pLfD
J4N8FM54/XS7xkw+CgbFu9wuYj4aP+cmdvc3ko/G4fSI+L8l5CUQbZltKhgg
LwE/JebyeCD5GJz4xaibLWdsjUFeiXSOZyIvxX3D8KElvuSlkFqyGjpaycci
w5Ldsvx78rHIX6qX/XaLfBzu5HjUie6Qj8PDLE9u+czvg6TI6F/dSH4fTH3j
9fZl5OOhkY+O1QUwtsbj0pcIVJSTT0DU2NJzwV+TT8CF4ti3v+aST4TAcGgC
75BPxJXMiucb+8jLEGBq18iOk5eheuWTgr508kkwN3WLzl4kn4TC1IGC1AHy
cniXOr1KnYwhR1HtV/xbOz3YeTlK9JM9L0aY75SjeCS0/4EX8zwFpn075f18
xlCgMWH9nH8m9QqIr4U8HVrFuFOByYEaT78G6pVYPfXZPaOCeiVqW3dV2CKo
V2L9k7+uzxylXgnjzZFjG76lPhljHcGbck5Sn4zHrpaKMgf1yTALTqubK6lP
hm3zybRzU9Sr2Hcx61WQjJ8+kD1KvQo+a8WreHXUq/CH6JuSagE7z1PDNijg
lno1QsRXLTU+jK1qfBwCO9+DcacazffiUsJAvQavPrUZrr6h92vw+X6JdNEX
1Gsw+LuFW+o1kPaGZw9WUq+FNvrAs+Ay+n0t/BrSZgIPU6+Fo0sYF51DvRZ/
9riHeh0SuwpbIyuo1+H1A1dTYz31OoSW+dXrb1Kvg16zvb3b2xP/AXEboEI=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 99.}, {1., 2.6292929292929292`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116935817]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Conditions for solvability of a linear congruence equation:", \
"ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"6", " ", "x"}], " ", "==", "11"}], ",", "x", ",", 
   RowBox[{"Modulus", "->", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->480054839]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"6", ",", "3"}], "]"}], ",", "3"}], "]"}], "==", "0"}]], "Input",\

 CellLabel->"In[2]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193621389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["GCDs of Fibonacci numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Mod", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{
        RowBox[{"Fibonacci", "[", "j", "]"}], ",", 
        RowBox[{"Fibonacci", "[", "k", "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "100"}], "}"}]}], "]"}], ",", 
    RowBox[{"Fibonacci", "[", "11", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdWruy4yAMtTOeSZMyP8BP8AMuaTzrAVHf2X7/v1sQ4mHAb7zFauIYpCNu
gsWRIJf9/Pn18+q67jddACBncwEzF8zmQpF9RYe4qaJDXF/RIY4BKHxx0L4B
SvsGgPYNBZoHsA5eFuDBOniZEQJY058W7jbu9+bDSOoxeFw4vis7x6Ny8zbZ
+TbtjvSc9CPpZYbnGX7K8CPqgb5/eOvnQtdDoetzN5j7Yig3X/O5b67OwafE
b/XFNq3ANq32Cyj6XLK8uopu/er2MX7egImkxyDpMUh6DJIeg6THksH8vArX
ns28cWZn74Mr1Fin2UbdF60SJ22iGbZWs5IVWjn6KlzTH7Ry9FWwGPnfiJ0v
E8ea7qav6W76OtiRFEivg91og58OdsQm464HxmcrbD5bEQVFt7l0pSpdnEO+
Vod8OQ+Zh3HJICofFHlGSOSZETnHxrvlnLfjHBuRRt8h/5jwRszb8VKHeMNO
iBGOo17FmM3lJD0lcvjJvVe8Y/5KGsMlk6iZXP4dKf96phwpJ0+Uk1+EmwhH
uc6uacSNhPuujNdQ+IpeIc/bd5a04ZW0YU7a6pW0gSVtmp9yNBRLjjrypw5K
ow0Uq4MSdGRhHZS+AqkNlnF9X/L/u8wJfZkj+PpYhoFtACAhf0K3X3ajta+A
scvWhzog4gjoewR0Tz6bVlcvcV8XSV8vcV9HfX29xH0dJX19xX0d9d4cp4kM
u4jZVwIj8hmWDrRWgdaVW8ng6wJc51hIoMdrb5RaIuvqCa6rZ71+b5Aspoc8
xnke80O+LrrdMW5LJbEW4llFR+bRkZF0ZCoduUhHLtIHRoCYdVmahFliAJZm
Z5Ym6+7YALGucpV22uc7djjmbx+9cLQsHD93jqiFiwrhGLtz1C0ch4tFRO25
b8pOqboTMS0K3f3V7UXJ2XIOs3/2IykezEM2/PO1nDMzihD5sR+NWV6aJcXP
Md/Lss20TUYZt4y5Z84zfck8fUlHFaJbd8ToEC6eRxfXwn3Kt/u0wsX76OJe
uGhiJ/1oNerQssvfr1Ad16qOi1ifdHMRwj3/SK8ZCk3AsJNeF+SCV+B5lnL+
K+V/luaC8bzPMhKGPDaGPFrEeRf/yNiy1Vd02JqueaSHCHu3+ZLD5vlVfh4l
L+FPyUl+24QfqQPOoF11zX2xzX3tzX3tzYFK8cvgEMM6xrOOca5j/Osb2H8g
llWE45bRMUznOGd0zCMmXzNcRh7/JHeA6X7aZze/P/f77tc9XCSWxSno4sxz
vgcrpLJFrJyBXEatyKE95ybInVlxxzOS9nGM9oO2/b2NAdpl4UbMJWHaZdFG
jDeBpFLUl0VivYAIT1/HkNAxJHQLwL39x1H7huxU94fNyp+ZT/7MXPkz828j
64Zs1tTnjJJqU0m1qaSa9t3O5p4+LxrXzkWrpuozAjoDaWYpfzQDYrNmhkW9
NGb1Uht9VVaqmdtq/WDTPn1/JqCSpN9QCfXfzxvrMqnkx9sqtbKza6jJpMgv
LRTb/N+oXz8kb9pFOf7/DFd7XthjHeVrJPZYO8iTXFLfbbdtrWW0ho1lPD91
hzPHBtduKv3t75l3qCfhxm/y+Us9//pP5C8V2scr
   "], {{0, 0}, {100, 100}}, {0, 88}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{201., Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{205, 201},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->706352741]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CoprimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoprimeQ"]], "InlineFormula"],
 " to check for trivial GCDs:"
}], "ExampleText",
 CellID->684328345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoprimeQ", "[", 
  RowBox[{"5", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285160152],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191355466]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GCD", "[", 
   RowBox[{"5", ",", "6"}], "]"}], "\[Equal]", "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6991385],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177615976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150122018],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " from ",
 Cell[BoxData[
  ButtonBox["Floor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Floor"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "=", "6"}], ",", 
     RowBox[{"n", "=", "21"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Floor", "[", 
        RowBox[{"k", " ", 
         RowBox[{"n", "/", "m"}]}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", 
         RowBox[{"m", "-", "1"}]}], "}"}]}], "]"}]}], "+", "m", "+", "n", "-",
     
    RowBox[{"m", " ", "n"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->695789057]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"6", ",", "21"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->756803693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Use in sums:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"GCD", "[", 
    RowBox[{"3", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1666"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117589166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 ": "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{"m", ",", "n"}], "]"}], ",", "p"}], "]"}], "-", 
    RowBox[{"GCD", "[", 
     RowBox[{"m", ",", 
      RowBox[{"GCD", "[", 
       RowBox[{"n", ",", "p"}], "]"}]}], "]"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", ",", "n", ",", "p"}], "}"}], ",", "Integers"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10740364]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LCM", "[", 
     RowBox[{"a", ",", " ", "b"}], "]"}], 
    RowBox[{"GCD", "[", 
     RowBox[{"a", ",", " ", "b"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", " ", "b"}], "}"}], ",", "Integers"}], "]"}], "&&", 
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"a", " ", "b"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->509534913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Reduce inequalities involving ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"GCD", "[", 
      RowBox[{"a", ",", "3"}], "]"}], "<", 
     RowBox[{"GCD", "[", 
      RowBox[{
       RowBox[{"a", "/", "2"}], ",", "6"}], "]"}]}], "&&", 
    RowBox[{
     RowBox[{"-", "10"}], "<", "a", "<", "10"}]}], ",", "a", ",", 
   "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", 
   RowBox[{"-", "8"}]}], "||", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{"-", "4"}]}], "||", 
  RowBox[{"a", "\[Equal]", "0"}], "||", 
  RowBox[{"a", "\[Equal]", "4"}], "||", 
  RowBox[{"a", "\[Equal]", "8"}]}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437570927]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " is very fast, even for many very large integers:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"GCD", "@@", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "100000"}], ",", 
       RowBox[{"10", "^", "100001"}]}], "}"}], ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7310000000000192`", ",", "1"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3728426]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Signs are discarded:", "ExampleText",
 CellID->712636638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{
   RowBox[{"-", "3"}], ",", " ", "9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609684990],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104303494]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["The arguments must be explicit integers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"2.", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"GCD", "::", "\<\"exact\"\>"}], ":", 
  " ", "\<\"Argument \\!\\(2.`\\) in \\!\\(GCD[\\(\\(2.`, 3\\)\\)]\\) is not \
an exact number. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/exact\\\", ButtonNote -> \
\\\"GCD::exact\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->63068552],

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"2.`", ",", "3"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152818141]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " sorts its arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"b", ",", " ", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"GCD", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12620531]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Plot the argument of the Fourier transform of the GCDs:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Arg", "[", 
   RowBox[{"Fourier", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"GCD", "[", 
       RowBox[{"m", ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "100"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325088434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Form GCDs of 1 with rational numbers:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"GCD", "[", 
       RowBox[{"1", ",", "#"}], "]"}]}], "}"}], "&"}], "/@", " ", 
   RowBox[{"Union", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"i", "/", "j"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "40"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{"2", "j"}]}], "}"}]}], "]"}], "]"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56962990]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["A GCD property of Fibonacci numbers:", "ExampleText",
 CellID->13098974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GCD", "[", 
    RowBox[{
     RowBox[{"Fibonacci", "[", "100", "]"}], ",", 
     RowBox[{"Fibonacci", "[", "1000", "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Fibonacci", "[", 
    RowBox[{"GCD", "[", 
     RowBox[{"100", ",", "1000"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"354224848179261915075", ",", "354224848179261915075"}], 
  "}"}]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211354261]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4755],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoprimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoprimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rational",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rational"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LCM",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LCM"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExtendedGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtendedGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChineseRemainder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChineseRemainder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11381]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21085],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->23390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31250],

Cell[TextData[{
 ButtonBox["Demonstrations with GCD",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=GCD"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/GreatestCommonDivisor.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/GCD/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
GCD"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->389988135],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->540507395],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->115911529],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->278607588],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->49788851]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GCD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 56.7370566}", "context" -> "System`", 
    "keywords" -> {
     "coprime", "Euclid's algorithm", "Eucledian algorithm", "GCF", 
      "greatest common divider", "greatest common divisor", 
      "highest common factor", "igcd", "lowest terms", "relative primality"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GCD[n_1, n_2, ...] gives the greatest common divisor of the integers \
n_i. ", "synonyms" -> {}, "title" -> "GCD", "type" -> "Symbol", "uri" -> 
    "ref/GCD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7200, 237, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53228419]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 75259, 2056}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3119, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3742, 95, 41, 1, 70, "ObjectName",
 CellID->28641],
Cell[3786, 98, 818, 27, 70, "Usage",
 CellID->29986]
}, Open  ]],
Cell[CellGroupData[{
Cell[4641, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5119, 147, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[5254, 153, 463, 18, 70, "Notes",
 CellID->21109],
Cell[5720, 173, 820, 31, 70, "Notes",
 CellID->8187],
Cell[6543, 206, 422, 17, 70, "Notes",
 CellID->20083],
Cell[6968, 225, 195, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[7200, 237, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53228419],
Cell[CellGroupData[{
Cell[7584, 251, 148, 5, 70, "ExampleSection",
 CellID->175939110],
Cell[7735, 258, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7824, 262, 122, 3, 28, "Input"],
Cell[7949, 267, 158, 5, 36, "Output",
 CellID->176442268]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8156, 278, 200, 6, 70, "ExampleSection"],
Cell[8359, 286, 180, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8564, 296, 161, 5, 70, "Input"],
Cell[8728, 303, 213, 7, 36, "Output",
 CellID->364612090]
}, Open  ]],
Cell[8956, 313, 105, 2, 70, "ExampleDelimiter"],
Cell[9064, 317, 51, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[9140, 321, 184, 6, 70, "Input"],
Cell[9327, 329, 180, 6, 51, "Output",
 CellID->183443827]
}, Open  ]],
Cell[CellGroupData[{
Cell[9544, 340, 204, 7, 70, "Input"],
Cell[9751, 349, 216, 7, 36, "Output",
 CellID->116786671]
}, Open  ]],
Cell[9982, 359, 105, 2, 70, "ExampleDelimiter"],
Cell[10090, 363, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10165, 367, 211, 8, 70, "Input"],
Cell[10379, 377, 215, 7, 36, "Output",
 CellID->860469591]
}, Open  ]],
Cell[10609, 387, 124, 3, 70, "ExampleDelimiter",
 CellID->21214728],
Cell[10736, 392, 203, 7, 70, "ExampleText",
 CellID->293716542],
Cell[CellGroupData[{
Cell[10964, 403, 160, 5, 70, "Input",
 CellID->24842365],
Cell[11127, 410, 257, 8, 50, "Output",
 CellID->377744238]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11433, 424, 207, 6, 70, "ExampleSection"],
Cell[CellGroupData[{
Cell[11665, 434, 332, 11, 70, "Input",
 CellID->37344415],
Cell[12000, 447, 1262, 28, 205, "Output",
 CellID->111856663]
}, Open  ]],
Cell[13277, 478, 105, 2, 70, "ExampleDelimiter"],
Cell[13385, 482, 127, 4, 70, "ExampleText",
 CellID->14631],
Cell[CellGroupData[{
Cell[13537, 490, 534, 18, 70, "Input",
 CellID->13640],
Cell[14074, 510, 164, 5, 36, "Output",
 CellID->544973367]
}, Open  ]],
Cell[14253, 518, 422, 18, 70, "ExampleText",
 CellID->18040],
Cell[CellGroupData[{
Cell[14700, 540, 147, 5, 70, "Input",
 CellID->7986],
Cell[14850, 547, 176, 5, 36, "Output",
 CellID->262549079]
}, Open  ]],
Cell[15041, 555, 125, 3, 70, "ExampleDelimiter",
 CellID->109570426],
Cell[15169, 560, 158, 4, 70, "ExampleText",
 CellID->62980801],
Cell[CellGroupData[{
Cell[15352, 568, 586, 18, 70, "Input",
 CellID->204337047],
Cell[15941, 588, 1764, 38, 134, "Output",
 CellID->116935817]
}, Open  ]],
Cell[17720, 629, 105, 2, 70, "ExampleDelimiter"],
Cell[17828, 633, 84, 1, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17937, 638, 202, 6, 70, "Input"],
Cell[18142, 646, 162, 5, 36, "Output",
 CellID->480054839]
}, Open  ]],
Cell[CellGroupData[{
Cell[18341, 656, 187, 7, 70, "Input"],
Cell[18531, 665, 161, 5, 36, "Output",
 CellID->193621389]
}, Open  ]],
Cell[18707, 673, 105, 2, 70, "ExampleDelimiter"],
Cell[18815, 677, 49, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[18889, 681, 508, 15, 70, "Input"],
Cell[19400, 698, 2036, 40, 222, "Output",
 CellID->706352741]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21485, 744, 217, 6, 70, "ExampleSection"],
Cell[21705, 752, 213, 8, 70, "ExampleText",
 CellID->684328345],
Cell[CellGroupData[{
Cell[21943, 764, 127, 4, 70, "Input",
 CellID->285160152],
Cell[22073, 770, 161, 5, 36, "Output",
 CellID->191355466]
}, Open  ]],
Cell[CellGroupData[{
Cell[22271, 780, 151, 5, 70, "Input",
 CellID->6991385],
Cell[22425, 787, 161, 5, 36, "Output",
 CellID->177615976]
}, Open  ]],
Cell[22601, 795, 125, 3, 70, "ExampleDelimiter",
 CellID->150122018],
Cell[22729, 800, 285, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[23039, 816, 557, 19, 70, "Input"],
Cell[23599, 837, 158, 5, 36, "Output",
 CellID->695789057]
}, Open  ]],
Cell[CellGroupData[{
Cell[23794, 847, 103, 3, 70, "Input"],
Cell[23900, 852, 158, 5, 36, "Output",
 CellID->756803693]
}, Open  ]],
Cell[24073, 860, 105, 2, 70, "ExampleDelimiter"],
Cell[24181, 864, 35, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24241, 868, 210, 7, 70, "Input"],
Cell[24454, 877, 161, 5, 36, "Output",
 CellID->117589166]
}, Open  ]],
Cell[24630, 885, 105, 2, 70, "ExampleDelimiter"],
Cell[24738, 889, 186, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[24949, 900, 508, 17, 70, "Input"],
Cell[25460, 919, 157, 5, 36, "Output",
 CellID->10740364]
}, Open  ]],
Cell[CellGroupData[{
Cell[25654, 929, 471, 15, 70, "Input"],
Cell[26128, 946, 180, 6, 36, "Output",
 CellID->509534913]
}, Open  ]],
Cell[26323, 955, 105, 2, 70, "ExampleDelimiter"],
Cell[26431, 959, 183, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[26639, 970, 382, 13, 70, "Input"],
Cell[27024, 985, 403, 13, 36, "Output",
 CellID->437570927]
}, Open  ]],
Cell[27442, 1001, 105, 2, 70, "ExampleDelimiter"],
Cell[27550, 1005, 196, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[27771, 1015, 324, 10, 70, "Input"],
Cell[28098, 1027, 219, 7, 36, "Output",
 CellID->3728426]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28366, 1040, 210, 6, 70, "ExampleSection"],
Cell[28579, 1048, 63, 1, 70, "ExampleText",
 CellID->712636638],
Cell[CellGroupData[{
Cell[28667, 1053, 146, 5, 70, "Input",
 CellID->609684990],
Cell[28816, 1060, 158, 5, 36, "Output",
 CellID->104303494]
}, Open  ]],
Cell[28989, 1068, 105, 2, 70, "ExampleDelimiter"],
Cell[29097, 1072, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[29185, 1076, 103, 3, 70, "Input"],
Cell[29291, 1081, 401, 8, 70, "Message",
 CellID->63068552],
Cell[29695, 1091, 212, 7, 36, "Output",
 CellID->152818141]
}, Open  ]],
Cell[29922, 1101, 105, 2, 70, "ExampleDelimiter"],
Cell[30030, 1105, 168, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30223, 1115, 107, 3, 70, "Input"],
Cell[30333, 1120, 209, 7, 36, "Output",
 CellID->12620531]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30591, 1133, 208, 6, 70, "ExampleSection"],
Cell[30802, 1141, 78, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[30905, 1145, 399, 13, 70, "Input"],
Cell[31307, 1160, 31046, 513, 70, "Output",
 Evaluatable->False,
 CellID->325088434]
}, Open  ]],
Cell[62368, 1676, 105, 2, 70, "ExampleDelimiter"],
Cell[62476, 1680, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[62561, 1684, 556, 19, 70, "Input"],
Cell[63120, 1705, 4501, 78, 70, "Output",
 Evaluatable->False,
 CellID->56962990]
}, Open  ]],
Cell[67636, 1786, 105, 2, 70, "ExampleDelimiter"],
Cell[67744, 1790, 78, 1, 70, "ExampleText",
 CellID->13098974],
Cell[CellGroupData[{
Cell[67847, 1795, 361, 11, 70, "Input"],
Cell[68211, 1808, 247, 8, 36, "Output",
 CellID->211354261]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68519, 1823, 310, 9, 70, "SeeAlsoSection",
 CellID->4755],
Cell[68832, 1834, 2182, 80, 70, "SeeAlso",
 CellID->11381]
}, Open  ]],
Cell[CellGroupData[{
Cell[71051, 1919, 314, 9, 70, "TutorialsSection",
 CellID->21085],
Cell[71368, 1930, 198, 4, 70, "Tutorials",
 CellID->23390]
}, Open  ]],
Cell[CellGroupData[{
Cell[71603, 1939, 321, 9, 70, "RelatedLinksSection",
 CellID->31250],
Cell[71927, 1950, 346, 11, 70, "RelatedLinks"],
Cell[72276, 1963, 192, 4, 70, "RelatedLinks"],
Cell[72471, 1969, 192, 4, 70, "RelatedLinks"],
Cell[72666, 1975, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73084, 1993, 319, 9, 70, "MoreAboutSection",
 CellID->389988135],
Cell[73406, 2004, 145, 3, 70, "MoreAbout",
 CellID->540507395],
Cell[73554, 2009, 155, 3, 70, "MoreAbout",
 CellID->115911529],
Cell[73712, 2014, 162, 3, 70, "MoreAbout",
 CellID->278607588],
Cell[73877, 2019, 148, 3, 70, "MoreAbout",
 CellID->49788851]
}, Open  ]],
Cell[74040, 2025, 27, 0, 70, "History"],
Cell[74070, 2027, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

