(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    151472,       3311]
NotebookOptionsPosition[    143770,       3039]
NotebookOutlinePosition[    145130,       3076]
CellTagsIndexPosition[    145043,       3071]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BetaDistribution" :> 
          Documentation`HelpLookup["paclet:ref/BetaDistribution"], 
          "ChiSquareDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ChiSquareDistribution"], 
          "ExponentialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ExponentialDistribution"], 
          "Gamma" :> Documentation`HelpLookup["paclet:ref/Gamma"], 
          "GammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/GammaRegularized"], 
          "InverseGammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseGammaRegularized"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"BetaDistribution\"\>", 
       2->"\<\"ChiSquareDistribution\"\>", 
       3->"\<\"ExponentialDistribution\"\>", 4->"\<\"Gamma\"\>", 
       5->"\<\"GammaRegularized\"\>", 
       6->"\<\"InverseGammaRegularized\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GammaDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GammaDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GammaDistribution"], "[", 
       RowBox[{
        StyleBox["\[Alpha]", "TR"], ",", 
        StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a gamma distribution with shape parameter ",
     
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a gamma distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "x"}], "/", "\[Beta]"}]], 
    SuperscriptBox["x", 
     RowBox[{"\[Alpha]", "-", "1"}]]}], TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", and is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "0"}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16626,
  ButtonNote->"16626"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " to be any positive real numbers."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->7997],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->13793,
  ButtonNote->"13793"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->254911283],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->69670291],

Cell["The mean and variance of a gamma distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28630],

Cell[BoxData[
 RowBox[{"\[Alpha]", " ", "\[Beta]"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117048625]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23043],

Cell[BoxData[
 RowBox[{"\[Alpha]", " ", 
  SuperscriptBox["\[Beta]", "2"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->210168656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25314],

Cell[TextData[{
 "The probability density function of the gamma distribution depends on the \
",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17117],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox["x", "\[Beta]"]}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[Alpha]"}]], " ", 
   SuperscriptBox["\[Beta]", 
    RowBox[{"-", "\[Alpha]"}]]}], 
  RowBox[{"Gamma", "[", "\[Alpha]", "]"}]]], "Output",
 ImageSize->{80, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182727746]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"GammaDistribution", "[", 
      RowBox[{"2", ",", "5"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20620],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23564491]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8964],

Cell["\<\
Generate a set of pseudorandom numbers that are gamma distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"2", ",", "5"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.0326869415057356`", ",", "11.887366334140914`", ",", 
   "21.57824334590193`", ",", "10.42091781999486`", ",", 
   "0.7322230028050687`"}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264417237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30664],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23775],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox["\[Alpha]"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226208801]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21100],

Cell[BoxData[
 RowBox[{"3", "+", 
  FractionBox["6", "\[Alpha]"]}]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49751496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25476],

Cell["Third moment of a gamma distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10943],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Beta]", "3"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"3", "+", "\[Alpha]"}], "]"}]}], 
  RowBox[{"Gamma", "[", "\[Alpha]", "]"}]]], "Output",
 ImageSize->{100, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->908079780]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3789],

Cell[TextData[{
 "The 0.75 quantile of a gamma distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", "=", "2"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Beta]", "=", "5"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"2", ",", "5"}], "]"}], ",", "0.75"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11385],

Cell[BoxData["13.46317264444848`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487270962]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29561],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->29591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"GammaDistribution", "[", 
      RowBox[{"2", ",", "5"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25867],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23732598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104454543],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->17591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"GammaDistribution", "[", 
      RowBox[{"\[Alpha]", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "0.1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3832],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxkXQVUVUsXvhcuKdK2Yhe2KAbqPnZ34bOwu7sTE1uxUAxEFAtUBESkQ+ku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   "], {{{}, 
     {RGBColor[0.3361147388090458, 0.13164597535394415`, 0.5894302427910566], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlktsVVUUhk9b7rm9955zSwJEdIKEODAFQrTBiY6wYBA1hYgYCJom0gcC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtIVVEUhvf1dr3nXM85CumgJiVRIVpIiE0aBKFCT1IKInNwyTJFozSD
QqSsIJr4QjLLorA0AikIJ400aGg+kIgaRGZSVlREUER9q3/ww9r7X4//rLX2
yU8fr2zKcM5VgWWgOXDuBNjBZUHCuUvYl0EJ9kHuVmQ5txI8xT4Qc64cuwJs
IriKu2P41oFV5FpLTBlcTuTczUznKuF7QueW++SEL+auA99zwIupRn3KufXw
9XCtcedaiG0GbfC/ubuDXeSrdkPSuXHPuWFylsENgim4k5F8C/HpgusGGzmf
oWZ2pBjzNU3Z1ItS4ibxL/RVw3KPcReiPwKjaN8DfwT+FHoL0boBzHB+gP/5
pDROwT0Hi8S2wFdT+5DVx07F9O238a9Lqgch9lHuiuFvoOcw9ulAuXdTcwJt
s9y1cn5GP3aivQAMcf4RV+1p+OyYNJjvZKDaFmNaa7krSkjzarTkh+qtfVM3
fFcgbVvgS+E2g864ZtxErRE0PIprxrfwHQy0C+X4r6P+RfJXYj9E/yyxM2CY
b6vj3INvb6DcaWJa8O3j/NJ2JUOzng7lazO33uT66rX16Be+MfheanPlXlj/
8cnn/Ir4vfD7bN/IX8H5C/ZXsD2hHbRe7Ud/dVw9yyNXbqhZ290A3PWUclkP
W4mdp0YyqZ79gfubUq+3wafhawLVWgO/y2qBHCcN89hP0PeT+Df4fKbWJzBG
bBw+DudFil0iZgSu3dOulvP9C8R/CNRby2lavnG+kpCmgVA7artZiv87uNe+
atkMOuH7Pb2t/zsfaKdsl2zHLviamc3Kcs7AzwV66/YG77PrQ1nS1kePa0K9
YXu73/Hp53wNlGRqxvb2Jjxptzd4lfM9T9rMp4HYLk+9sx6kscdT2mWbYQO1
GwP9K+yf049/D8iLaeZ34YYC7Y7NdCv6F6jRRu52sIj9Hsw53Y0S+zhL2i2H
7W6jJ+22wx0p5bBY23F7m1Gkt2dv1Gb3NtBu2gw/wi+Fmp296bP2f/P1r7Md
/gc77abm
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.42151221642713743`, 0.2801291260618325, 0.7094667283731697], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1tsVVUQPb2P03vuPedAbHkWBWICWiWlRh4fIjYqJCBQ/SAG0QSQZ6EP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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1l2lsVFUUx19nptP33rwZSNjKIkuixihQMbJ8EA1RwYCsiWWRgELYWugC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         "],
         VertexColors->None], 
        PolygonBox[{{3175, 2401, 1318, 3177, 3174}, {2400, 3180, 1319, 3179, 
         2399}, {2402, 3175, 3174, 3181, 1319}},
         VertexColors->None]}]}, 
     {RGBColor[0.506909694045229, 0.4286122767697207, 0.8295032139552828], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWGuMVVcVPnfuPfeeex4XE3kM7xT9AWjRKDL8qJ3Szgi1RaFCoSEWoVoS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2uwlWMUx9+z9373eW97Z4jKqVBfYtwlzaDkltSRolJnKuU2dLqKVCi5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         "],
         VertexColors->None], 
        PolygonBox[{{3229, 3615, 1351, 3233, 3228}, {3200, 2412, 1333, 3204, 
         3199}, {2413, 3200, 3199, 3210, 1334}},
         VertexColors->None]}]}, 
     {RGBColor[0.5847648903311937, 0.5612166535336561, 0.9099762005346564], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmHmMltUVxt+Zb5l3+6ZQSKklKAwQKI6tLaRoYYYZ6JqZRqVaLZsJ9Y82
cYEmVi12sIICDiQG4lbbKFhINEXkH7pLE7VUTErbMKxtWlFSkD0qMIOVPr88
5483937nnnvuuWd5zrnfuMX3zL27OUmS5U1JUtGYV5NkgeZvar6zSJJ9aZI8
J1qvaFvE2C/6U6I1ae0bog20iEdfby1J6nXP/9PscSDmZyV4rmR8rL17g/6l
Jq/xu1/zedo/W99Uza8W7xzN79R6n/a2aPwIuuYnRO/W7zXiWVW1HPYzn6Qx
0fh9fc9qulW8P6hY7yc0TtD4KX1d0nOLeEbqK1t1dkM6ineEfr+j8aj2vqw7
XlXYFq9r/WPND2v9Z6Iv1fx2zadUvS8TzwLRJhWW8Wf9HlmxfYblSTI892/W
ZursO0Q/rt874l6cPz906G4xDzps09pfxdOh8XtZkhwok+QV7btV47f1jRP/
BPHuFG2aeGbr/G597TrnssZnU/ttnuY/ymzPAe37rs46oPlQxfd4UGctEu8t
Ddt3ssaZ+v2q5vule1VfId6F+j6p77Um2/JpzQ8m9hV6IX+j9qWlffCMvg7R
Pi/+R5vst9FN1g/bYbeJkn1H6tiYpX3/09mfrpl2fWH6SdGP6VstekXn9DVb
HrGD3/F/DzEa8YBv57TYvzdJxlx9KyM25mp8KXG89gQ/OjJHz+t1zq9K07AP
9iPmV0ifxYV5Vmh8sXS8zZBd1+W2xRjNF2t+QvTxpWOI+CF/2uO+xHB36L9V
6+PEd2/Vecf4u8Q26Cxth3Oa9zQcl8Qx8fxv7b2o+YVmx8c08X5LZ5fi6ag7
ftaKpyH6ptR3PqH1D0vvw2Z7Iwdvrdlu3PezyoV+8e2o23azW2y3LTr/hYbz
ZiBynb0Pyg5LRV8evNicuL1WMu7NnbdLNX6u4TweJv5PFPbDddJrVG7bch9s
Rs6eFK1N/EfF/1Pp85C+VHL/VjhWiAdymPgj9h4Pm2LPk02WhZz/ar294vWj
gQGscdeJdet/SHr+Uzb5l9Zuk+zXGs6FU6I/o9+Doj8s2gp9V2rPauk8O3c+
doEdoo3RPMc3mgOk4ERSGisq4n0/dR4Pi7xZmNgHX63Yf9h3VZPz4sc6Z1nD
clLt7cnNP5A5b8lZzm2rO9/BSXKOuFqt9VGtvkuL5ldmtseemrFvV7NjkRFs
J7f7AoOID0by4jOSMbrV95mkcU3mfCM/sAHxf1jye8BG0c83206d2ju+bjxC
N3QcH3Pu0xa2ekh778q8F303hf2Jq71RL3bEXvZNKZ1jT4e9huLMdbLrN2Wf
LrBRunQWxhR8wT7OIp/SZufUNbLruYhJ7F2JmNmBnyX/h6J/gTH3nl6de4O+
sTXzYQNq0y8lZ7O+DsleJh0mt1oWv7sib85KRnvDGL9R4ybyWWvd4r8it51v
k+wbQ/4pjQ+EDtSDltB5vPadCTzBn7fn9inYejLifHVmP6Efed8R9YWYA7Ox
TxpykfluYdtBX6j5Aw1jxe6qsZ3aBZaPqDu2fiLe+xv+/Yr03JC5VoMl72WO
5Uzrqb4nRf+OZN6CPyTvYXC3MN68JzlvSv9Zkj2q5pGYOS45pwPb381dL6mV
+HZt6En9qUUNIp7IaXzRkTsnyUfu3Rl3Pyq93i+NAeTr6cw84MHVgQnUwEci
p8DyvtR4/uvcWE+cT9TakxXjzXrRH8v9e63utE3715MTmo8pjN9gS09g6XGd
2Zk7VsEeMAise7vqOVj0Ut33xu/XSd7XU+frGe3dl9uH9CBjow+5FHUCP94t
/uda3XO9qD1vV4xdLeLNCtctbHw+chO82VBz/syR7D2Za8dUnXlDat3o2ZAH
vpP303PH1UXZZ7D0/uH0OIUx4/Go61MD3xYGxl2uWw65PFMy9hbWZVXwg3Wc
/4fcOgxqvKjvnHhKndNKva/aJ/ML++UvGn/fcG2n38G3xAL9C/fn7gdE318x
Zg5lxnewpU3yJpS230HJmCb6Euk3XfvuqzkGyNuVodsMnXtj6jz9U9UyicOb
tG9j7vr9x9w1lfh/RLq9mronBfeHwhe9xGxu23Rhg8KYfZX89ovS/qcnJGa5
4/TQBWxsAhci9rDL2ciXrdq3LnPdBrPBGPRcEH0nPWdf4dpMXabGTg3/Up9n
R19EHUA+teB+6XOktN/I4XNxFrVmWvh3ZuhKfe+I3hlb0VeOzo0VJzU/X7oe
fFHzsaWxBxo1dTDq3lD0Lge172hh++6rOobRn3gBL4gZ4iCJfv7mwvjL+dSH
tqgRp6K+YasjkvlOblsMRW0iBybGOj3DodTYB+7tT90j4ntiipjmzl+jb0pt
nw+qtvNH0Y9fiJ78Md3pg9LxeCHOgU5PtCzsv0fj38EL/J65NoPd4D21h9x/
ih4w8/sHH20JO9PPZcRoYDmxSBwOSq8jkrkzMPut8P0/RDumte1Vx/elwArs
Cy95Ad4viruDJZfivQeuEXPYaIz0uSbzvekfh0e+d2rvLH0DNdcl+l1qE/Hb
HzG8ueq85zd5cDjejr9tNW6CmfgLGdgWDLurYbxYXLe/8TU+Pxb9enfYBJ2p
4fSX1MgryOXU77w15GXDvQ5xQezSA2BT5sQwfd+a6PnB8v7A88MaD+XGD2rX
862uXy9UXdvBLX53RMzXxVMrfL+3dGZbZt13xTsTG5KPu8Mv9PHUvLPxfnqj
apw8LRlnCvvvODFfeA2fEy/4/Zhol1Pz74j3MHH4aO4YxYat4BB5pD0vS5/d
qfeu1D3OpM65unw6OnP94Q1xInrltaL3l8YesGpDarzivb4+dOgv7D9+8xbp
jffI8nh74f9F2juhYdnzMvc39DZzQwZ9O+/RlqhNuzQuaThekLM5ZL0h+uuF
bb8tbIEf78zcO4KN0PKg04NvD19jpzy3rbbHfuiczxwdlkj2PYX9c1+8W8Hc
ybmxABwYGXgEFpU694L4B6ru3WZEXfhQ869kfoeAW/uDH5wkXonVn8tmM6Tz
iJr71+fjvXyzaPMzv99/kxtHwBDkDMR7/Mul97OX2O+Ot1VXw2dzLu9r1uk3
psR7m76F91J71EgwmL4WHL62cA3rjv9kiElw/v+U/ERY
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlndsllUUxt+Or3zv+OoABxBQVthqlMjQlhYlmFAjKSpCK6NCogmyIkJA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         "],
         VertexColors->None], 
        PolygonBox[{{2393, 3156, 1313, 3155, 2392}, {3145, 2394, 1312, 3151, 
         3144}, {2395, 3145, 3144, 3159, 1313}},
         VertexColors->None]}]}, 
     {RGBColor[0.6475517966641444, 0.6620977413681968, 0.9114075486127331], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl3+slmUZx5/3Pe+P53mf9z0OaGPCSvnN3MoIJH4aP0USOEwcoFAC5jLw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmuQjmUYx5993+dd73PawgcTowO7S2ZKRQenaqkoQjESimRG2Uq1OaRI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         "],
         VertexColors->None], 
        PolygonBox[{{2396, 3165, 3164, 3595, 1688}, {3165, 2398, 1316, 3173, 
         3164}, {2140, 3591, 1688, 3590, 2139}},
         VertexColors->None]}]}, 
     {RGBColor[0.7103387029970953, 0.7629788292027375, 0.9128388966908099], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mH2wVlUVxs99vzjvOe+5gzgQZabIp+iE0tAUoU1UM8BVdO7FqSm+P8zC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnlsVVUQxu/rey3v3fvuUyBiFTFAocgSQYiKCJigMRQUTOsWRVklIgQi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         "],
         VertexColors->None], 
        PolygonBox[{{2168, 3432, 1176, 2995, 2167}, {2980, 2254, 1175, 2990, 
         2979}, {2255, 2980, 2979, 3001, 1176}},
         VertexColors->None]}]}, 
     {RGBColor[0.7720558714587185, 0.8501409434968893, 0.9098086660324289], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuw1VUVx3/cex6/e875HbVRQhTlIahZUjAmIDrmNANqISKYg4khL5H3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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnlsVVUQxm/7Xh/vvdv7BBIa9qXIoqgIiFpAggQTFimLJZoooOwIbVkE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         "],
         VertexColors->None], PolygonBox[{{2077, 3328, 1428, 3327, 2076}},
         VertexColors->None]}]}, 
     {RGBColor[0.8284427747600598, 0.8689444732656415, 0.8845473838835719], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuMV9URx+/u/vbu77e//V3Y1RKxiNJY5dkKFe0rpSptRaqC5bFruzwF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVlUQhu/X5fNbei8UwYhBloRFhCqQsKpBEBVQoIWiLZEWKGWLtG6J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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8848296780614011, 0.8877480030343937, 0.8592861017347148], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFmQVdUVhs/ta997TtP3mhBjXhhbEEdGGRuEgGIkViIglUBRhTaoSR5i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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsVlUUhU//Wv572/9etBKNRpE6otiJVopUaQVaRI0yqjhEREX0QVDR
IKAxATGBQoHIUBkSBIQKCHRAoYIUBWKqqLz4omgZ9EXxSUWNw7eyHnZy9t3D
2Weftde5JVNnjH8uE0JYjlyANBSGMCoN4cs+IdyTH8LD6JVRCJtxehL9Nmy3
I8ewb8wLoZ51HbKddQ/f9uNbmguhoCCE+ST8Dn1QEXHEr8Ln+hgfpBN9Hvke
IX9f9G+wbeJbLbmGISOD93gU+xBy7MQ2Hf9btB/f7mD9KfaLiN2JbMH+NN9m
YHsAn9PY5qI3KBfyVsZnqmY9JHVsM9/2kfu+JIQfqXck3yZju4x8LxJ7Bn0m
+erx6cL3Vb7142xf4z8N2znONw/7XKQt2GcNsZXk6MZexbd+rC9G5nC+8+wx
ilxr0IdnQziEfTqxt/Ktg9iXyH8jvRqIXELuS5FZ7DUPewnxKTkXsv6dmF/x
HYd9MfZFyA3YBiLnWf+BnCZ3E/oJ/G8qcq570buJXY+0En8UWYXv6sRnmcQe
M/GfmrjWC9ErOW8L9dZTbwvyDOsezthDvWuJ34K+GTnBfnN0H6yLkd+IL8Nn
NLnuRDaybiTfHvL3os/GtxaZiH4Xei/+35PjbXIPT40lYUC91p3qLtXzTvS9
iXuhnh7E9wAygnX/rGsdTM19Clzzx4kxLSxPJuYVetHGnlPwX4H8wrqGmCPY
RuBzubCJvE+9s9AbU/vI9hU+W9HXYp9AbbPI38z6JPYq7G8QczbyHeluNuT5
bn7CpzDrO9oXewaEfd15O/l6qakd391Z320n9T9W4Dsek7hn6pV6NDQ1hoVd
1VyBbykxxdSTxf4f/pPI34h9JfaO2GfSWTRDwpZmVLMpjK0kV1fsu69h/1PE
/4BcmfEdaTbG6gwFnpEdsWdOsyZO0NlXoL+ZcQ/KqOfaIt+9OKCa2q6O3Ish
2Dey37+RsfAU+5VjHxC5d+X5ntXRqXutma2JPCOaDd3Jg9juR9oznvFxiTEu
bKvG1ws9Y5qtJcSs1vyj70avzbpXXXz7Oeue7RUXUP9h1sf5tox1Od8qiF3I
Hq3oS9Gvy5qj3kVvQh+A3oM+jdyjOHN/9j6HHImdU7nyiS+NzKHiTs1AK7Z3
8HmC/Wbjsw19gzBHrpfR29Vb/F/Afwf+wyJzkLhHnKm9B/Ht8eAaBkfmSHGj
OHBEzhgXtq8ocO0V+DwffIYpmqfIs60ZXcV+FfjUEL8oY+6bgH6yjzlwPusO
7ZdnDKv3D6XmRt3BGfKdTTz7xegfsv8HOXOfMHy33obY3D4t31g/lHgWhfk2
bONS27bjczN7LUG/JuuaO8i1OnZttfhUab5Tvz3i2BZsH+VsW4pPA+uROWNf
d3JVZIwJWwuwjyV2T+y91OO6yDMg7AsjXcTuyznXVOL/pNa/EnOpOKOSXE2J
uXZonnuzNfHboR6VRMa8sK6ZENcKI8KGOFfYKyt0LcLgZ/Tj28hvozBXR23N
heZWzaDeuv0516I3rzkyZ4grxHl/478gci16Y4/qbNhfyxrTnayzibHQzbdd
5FoeG9vV5CtHHxObO8SZX1DPKfKtyzMm9FZ9gr1vxm+Wch+LfdfaYyC+i1Nz
rzC5PjamhWVx5CTsu1K/HXqTxE2qSbWIow6gv6f3Mes3dFPsGdFsaCYmsh6f
ehaEyX8ic4i4QzOk2IOxZ005TmM/XuSz6QyfY3s2NRfozVoXm8PF3fpnEda2
xZ5lYe5wbM4QV+jM/wMGZysF
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1tslVUQhXfP4Zzzn9IWS4GKQBWU0pYWWhDagrdIQarRByMIGBNj5GJi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMlvTWEYxr+e2/aer+65MUSslLKQNNWJkLZaN1otCxaSrmyka2FhI243
Ioqg09USxUJjRySoKUjUnPgLLFhQdpY1JIbfk2fx5bzj886nYejwvkNJCGGA
V837mYWwyOtCeL6Wb10IDwohHKgJoTsXwr0YwkQxhKZ8CF+rQtiJro+Xg16N
zRl069IQ1oO1Cpt26HFkjdAnkN2FP7okhGMEG+Z9g29HP0+sHvCfgD8N34F9
Qg6noNdiswLf5chK5NOJ7C32vTnn+ps3WuuctxWNKax3yK6C14/PHvhp9N/R
bcfmPbq+nHO5g6xc7ZwaoE+jX5l3DaP4N+PfjG2FGu9T6xyvC/oseB3Ydhcd
axx+Df4j8EvzzvkP/CD++/F/XuVcZsCcSpzTWHSNqu0i+ins/6a2bQLzNfrj
+Ixi+yJxbpPRtspxE3wb71ziHj5FV8Z+RL1E9rDgnJWrZrgI9rXoXuzNOVfV
qNqU86/MM9Js1NNB6B+Zd2EZ/pPYz0XPvgX7hdQz16zVk9noGMKeIUYJXQ9v
InHPr0TPQL1XD1rIrZ2Xgt0K34nuAvabwZulfxXtArIKdBuyNmxvF52LfG5A
fya/enwPon8U7SPbRfLZgf1J+CzvGX/BthObMeKXyWdr6ppUi2Jot7ek3lXt
+Jiw4I/Ab8gbqx5eNyNM0Xkwp2os06xegj+feGaq5XF0LqpJsd9Ez1I5/MO3
t+DbEYZ25Xp077Qzl6JvULenGbdiuzu6V9rJV9CN2qGcY6oXC5lrU0/6M++U
dukj+BuhdyH7VOOabkbXqNo+kOPl6BvTbWlmwn4WvUuKMZAZU1jC6Cr6BrT7
ukndbin17HTDw3W+ad2ydlL/glvRsfRP+A8DNY1Q
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2753, 2717, 2150, 3140, 3141, 3139, 3583, 2389, 3765, 3335, 
         2078, 3717, 3138, 2937, 2226, 2936, 2227, 3577, 3578, 3574, 3576, 
         3575, 2133, 3759, 3121, 3737, 3122, 3119, 2377, 3120, 2605, 3771, 
         2606, 2446, 3718, 2079, 2607, 2080, 3719, 2447, 2270, 2450, 3720, 
         2081, 2612, 2082, 3721, 2277, 2182, 2806, 3253, 3254, 3256, 3255, 
         2619, 2456, 3633, 3635, 3634, 2279, 3644, 3645, 3641, 3643, 3642, 
         2624, 2458, 3646, 3648, 3647, 2286, 2460, 3751, 2459, 2630, 2461, 
         3752, 2462, 2294, 2467, 3753, 2466, 2645, 2301, 3745, 2302, 2197, 
         3398, 3399, 3400, 2093, 2651, 2097, 3727, 2476, 2321, 2477, 3728, 
         2098, 2653, 2102, 3729, 2484, 2330, 2485, 3730, 2103, 2664, 2105, 
         3731, 2489, 2342, 2490, 3732, 2106, 2672, 2112, 3734, 2492, 2684, 
         2683, 2493, 3754, 2494, 2346, 2501, 3766, 2500, 2689, 2502, 3755, 
         2503, 2362, 3556, 3557, 3555, 3749, 3748}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2122, 2132, 3402, 3401, 2225, 3553, 3554, 3552, 2367, 2703, 
         3689, 2507, 3688, 2508, 3690, 2361, 2688, 2116, 3736, 2499, 2360, 
         2498, 3735, 2115, 2682, 2111, 3733, 2491, 2214, 3478, 3479, 3093, 
         3092, 3537, 2671, 3671, 3672, 3670, 3674, 3673, 2329, 3667, 3668, 
         3666, 2483, 2663, 3664, 2481, 3663, 2482, 3665, 2320, 3659, 2475, 
         3658, 2474, 2652, 2319, 2473, 3726, 2096, 2649, 2092, 3725, 2472, 
         2313, 2470, 3724, 2091, 2643, 2088, 3723, 3774, 3773, 2192, 3471, 
         2191, 3763, 3041, 3520, 3519, 2629, 3652, 3653, 3651, 3655, 3654, 
         2285, 3639, 3640, 3636, 3638, 3637, 2623, 3258, 3259, 3257, 2457, 
         3260, 2278, 3252, 2455, 3251, 2454, 3632, 2613, 3021, 2274, 3020, 
         2275, 3022, 2271, 3247, 2449, 3246, 2448, 3631, 2608, 3017, 2268, 
         3018, 2269, 2859, 2860, 2555, 2180, 2609, 3468, 3467, 3466, 2535, 
         3715, 2228, 3495, 2233, 3407, 3408, 3409, 2258, 2858, 2857, 2856, 
         2234, 3117, 3118, 2852, 2853, 3601, 3602, 3423, 3424, 2159, 2730, 
         2160, 3426, 3425, 3604, 3603, 2552, 3509, 3510, 3443, 3444, 2172, 
         2601, 2604}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2709, 2708, 3693, 3694, 3692, 2510, 3695, 2366, 3687, 2506, 
         3686, 2505, 2702, 2365, 3685, 2504, 3385, 3386, 3387, 2686, 2114, 
         3381, 3380, 3684, 3683, 2218, 3485, 2217, 3764, 3100, 3544, 3543, 
         2681, 3678, 3679, 3677, 3681, 3680, 2341, 3275, 2488, 3274, 2487, 
         3669, 2669, 2670, 2486, 3365, 3366, 3367, 2661, 3359, 3358, 3357, 
         3662, 3661, 2205, 3476, 3477, 3075, 3074, 3530, 2650, 3526, 3527, 
         3525, 3529, 3528, 2314, 3267, 3268, 3266, 2471, 3657, 2644, 3059, 
         2310, 3058, 2311, 2641, 3758, 2640, 3346, 3345, 3262, 2465, 3263, 
         2299, 3656, 2463, 3343, 3344, 2087, 2628, 2084, 3341, 3340, 3650, 
         3649, 2187, 2811, 2186, 2922, 3037, 3036, 2618, 3030, 3031, 3029, 
         3033, 3032, 2276, 3250, 2453, 2767, 2452, 3249, 2611, 3019, 2272, 
         2764, 2273, 3580, 2384, 3579, 2383, 2763, 2762, 2918, 2181, 3469, 
         2919, 2861, 3136, 3582, 2388, 2869, 2870, 2871, 2610, 3214, 2414, 
         3213, 2415, 3215, 3235, 3616, 3617, 3456, 3457, 2178, 3618, 2177, 
         3454, 3455, 3507, 3506, 3427, 3605, 3606, 3429, 3430, 2162, 2733, 
         2161, 3428, 2888, 2409, 3196, 2854, 2588, 2237, 2731, 2732, 2592, 
         2591, 2151, 3508, 2259, 3002, 3004, 3003, 2253, 3505, 2252, 3504, 
         3328, 2077}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3397, 3396, 3562, 3561, 2224, 3486, 3487, 3113, 3112, 3551, 
         2687, 3548, 3549, 3547, 2364, 3550, 2359, 3277, 2497, 3276, 2496, 
         2685, 2357, 3682, 2495, 3377, 3378, 3379, 2678, 2110, 3371, 2839, 
         2838, 2837, 2213, 3535, 3536, 3532, 3534, 3533, 2662, 3088, 2339, 
         3087, 2340, 3089, 2328, 2659, 3356, 3270, 2480, 3271, 2326, 3660, 
         2478, 3354, 3355, 2101, 2582, 2095, 2126, 2820, 2819, 2200, 3061, 
         3062, 3060, 2312, 3521, 2642, 3057, 2307, 3056, 2308, 2638, 2637, 
         2784, 2783, 2782, 2464, 3261, 2293, 3046, 3047, 2780, 3342, 2085, 
         2567, 2083, 2123, 2812, 2810, 2185, 3035, 2284, 2772, 2283, 3034, 
         2616, 2617, 2281, 2768, 3132, 3133, 2386, 2766, 2765, 2920, 3470, 
         2921, 2863, 3741, 2862, 3742, 2141, 3499, 2249, 3498, 3501, 3500, 
         2239, 2737, 2738, 2595, 2594, 2556, 2593, 2951, 2952, 2950, 2245, 
         2953, 3433, 2598, 2247, 2734, 2246, 3568, 2379, 3567, 2378, 3608, 
         3609, 3445, 3446, 3447, 2428, 2945, 2235, 2944, 2236, 3627, 3628, 
         3626, 2444, 3412, 3411, 3410, 3573, 3572, 2251, 2875, 2876, 2149, 
         3197, 2711, 2589, 2590, 2397, 2725, 2549, 2550, 2254, 2980, 2255, 
         2996, 3432, 2168, 2968, 2974, 2962, 3334, 3327, 2076}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2376, 2707, 2374, 3691, 2509, 3394, 3395, 2121, 2700, 2120, 
         2131, 2851, 2850, 2223, 3110, 3111, 3109, 2358, 3546, 2679, 2680, 
         2355, 2802, 3375, 3376, 2675, 2109, 3370, 3369, 3676, 3675, 2212, 
         2834, 2211, 2933, 3091, 3090, 2660, 3082, 2336, 3081, 2337, 3083, 
         2327, 2656, 2795, 2794, 2479, 3269, 2204, 2824, 2931, 2930, 3073, 
         2578, 3066, 3067, 3065, 3069, 3068, 2309, 3265, 2469, 3264, 2468, 
         2639, 2300, 3052, 2306, 2785, 3347, 2090, 2572, 2086, 2781, 2545, 
         2544, 2634, 2190, 3039, 3040, 3038, 2292, 3518, 2561, 2562, 2290, 
         2773, 3338, 3339, 2560, 2771, 2770, 3027, 2769, 2867, 3760, 3762, 
         3761, 2144, 3137, 2143, 2866, 2865, 2241, 2558, 2557, 2596, 2240, 
         2954, 2248, 2872, 3008, 3009, 3011, 3010, 2147, 2551, 2419, 2894, 
         2895, 2896, 2736, 2170, 3240, 2432, 3239, 2433, 2435, 3750, 2434, 
         3462, 3461, 3460, 3517, 3516, 2260, 3005, 2261, 3006, 3436, 2169, 
         2735, 3435, 3434, 2892, 2416, 2546, 2134, 3512, 2265, 3511, 3514, 
         3513, 2230, 2890, 2229, 2938, 2264, 3014, 3431, 2889, 3294, 3293, 
         2427, 2913, 3452, 3453, 2741, 2176, 2911, 2912, 3585, 3586, 3584, 
         3415, 3416, 2723, 2724, 2398, 3165, 2396, 3591, 2140, 2985, 2990, 
         2979, 3001, 2995, 2167, 2967, 2973, 2961, 3333, 3326, 2075}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2375, 2701, 2363, 3114, 2372, 2805, 3392, 3393, 2697, 2119, 
         3384, 2849, 2848, 2847, 2222, 3107, 3108, 3106, 2356, 3545, 2676, 
         2677, 2352, 2801, 3373, 3374, 2673, 2108, 3368, 2836, 2835, 2833, 
         2210, 3085, 3086, 3084, 2338, 3531, 2657, 2658, 2333, 2799, 3363, 
         3364, 2654, 2100, 3353, 2826, 2825, 2823, 2203, 3071, 3072, 3070, 
         3524, 3523, 2648, 3063, 2316, 2791, 2317, 2577, 2576, 2788, 2787, 
         2786, 3055, 3054, 2196, 2647, 2195, 2571, 2636, 2635, 2568, 3042, 
         2297, 2776, 2298, 2565, 2564, 2775, 2774, 2543, 2542, 2626, 2184, 
         2621, 2622, 2537, 2761, 2282, 3028, 2620, 2387, 3134, 3581, 3135, 
         2874, 2873, 2148, 2597, 3024, 3025, 3023, 2280, 3026, 3442, 2905, 
         2421, 3223, 2451, 3248, 2614, 2615, 2441, 3623, 2440, 3624, 2171, 
         3012, 3013, 2899, 2898, 2897, 2263, 2600, 3738, 2599, 3404, 3403, 
         3569, 2855, 2908, 2907, 2174, 3241, 2947, 2948, 2946, 2238, 2949, 
         3465, 2917, 2445, 3245, 3244, 3129, 3131, 3740, 3130, 2256, 2877, 
         2881, 2882, 2262, 3007, 2586, 2587, 2422, 2906, 3448, 2173, 2727, 
         3282, 3211, 3212, 2891, 3291, 3292, 2522, 2554, 2553, 2742, 2425, 
         3309, 3310, 3305, 2530, 3152, 3160, 2394, 3145, 2395, 3156, 2393, 
         3169, 3173, 3164, 3595, 3590, 2139, 2984, 2989, 2978, 3000, 2994, 
         2166, 2966, 2972, 2960, 3332, 3325, 2074}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2373, 2706, 2698, 2699, 2370, 2804, 3390, 3391, 2694, 2118, 
         2130, 2846, 2845, 2221, 3105, 2354, 3104, 2353, 2674, 2345, 3101, 
         2349, 2800, 3372, 2113, 2585, 2107, 2128, 2832, 2831, 2209, 3080, 
         2335, 3079, 2334, 2655, 2325, 3078, 2331, 2796, 3362, 2104, 2583, 
         2099, 2127, 2822, 2821, 2202, 2929, 3350, 2792, 2318, 3064, 2199, 
         2817, 2928, 2927, 3053, 2573, 3049, 3050, 3048, 2303, 2570, 2569, 
         2779, 2778, 2777, 3045, 3044, 2189, 2633, 2188, 2563, 2291, 2627, 
         2511, 2748, 2749, 2539, 3317, 2538, 3716, 2287, 3320, 3321, 3319, 
         2540, 3318, 2541, 2713, 2712, 3337, 3336, 2809, 2808, 2807, 2183, 
         2955, 3769, 2956, 3503, 3502, 2250, 3124, 2381, 3123, 2380, 3610, 
         3611, 3450, 3451, 3625, 2443, 3463, 3464, 2744, 2442, 3316, 2533, 
         3315, 3713, 3712, 2603, 2602, 2142, 3413, 2864, 2385, 2721, 2720, 
         2902, 2901, 3744, 2900, 3492, 3493, 3494, 3491, 3016, 3515, 2266, 
         2909, 3449, 2910, 3488, 3489, 3490, 2941, 2942, 2940, 3441, 2939, 
         3015, 3440, 3439, 3704, 3298, 3438, 3743, 3437, 2431, 2916, 3458, 
         3459, 2743, 2179, 2914, 2915, 2878, 3596, 3418, 3419, 2726, 2880, 
         2879, 3224, 2403, 3288, 2517, 3285, 3417, 3205, 2412, 3200, 2413, 
         3208, 3607, 3234, 2426, 3615, 3229, 3308, 3304, 3710, 3148, 3151, 
         3144, 3159, 3155, 2392, 3168, 3172, 3163, 3594, 3589, 2138, 2983, 
         2988, 2977, 2999, 2993, 2165, 2965, 2971, 2959, 3331, 3324, 2073}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2371, 2705, 2695, 2696, 2369, 2803, 3388, 3389, 2692, 2117, 
         2129, 2844, 2843, 2220, 3103, 2351, 3102, 2350, 2935, 2216, 3484, 
         2934, 3099, 3098, 3542, 2584, 3095, 3096, 3094, 2344, 3097, 2332, 
         2667, 2798, 2797, 3273, 3272, 2208, 2828, 2207, 2932, 3077, 3076, 
         2580, 2581, 2322, 2793, 3351, 3352, 2579, 2094, 2125, 2818, 2816, 
         2198, 3051, 2305, 2789, 2304, 2926, 2194, 2814, 2925, 3722, 2924, 
         3043, 2566, 2631, 2295, 2710, 2296, 3127, 3128, 3125, 2382, 3126, 
         3278, 3696, 3697, 2747, 2746, 2289, 2714, 2288, 2625, 2536, 2548, 
         2547, 2740, 2424, 2752, 2512, 2758, 2759, 2751, 2750, 2745, 2559, 
         2145, 3414, 2868, 2244, 3405, 3739, 3406, 3571, 3570, 3225, 3226, 
         2423, 3612, 3614, 3613, 2232, 2903, 2231, 2943, 2267, 3707, 2529, 
         3706, 2528, 3714, 2534, 3629, 3630, 2757, 2527, 2760, 2526, 2756, 
         2722, 2718, 2719, 2439, 3242, 2438, 3243, 2155, 2728, 2156, 2884, 
         2883, 3193, 3192, 3289, 2518, 3221, 2418, 2893, 3295, 3757, 3768, 
         3767, 2523, 3702, 3703, 3297, 3770, 3296, 2430, 3620, 2429, 3619, 
         3312, 2531, 3178, 3182, 2401, 3175, 2402, 3180, 2400, 3186, 3188, 
         3184, 3287, 3284, 2153, 3202, 3204, 3199, 3210, 3207, 2411, 3231, 
         3233, 3228, 3307, 3303, 3709, 3147, 3150, 3143, 3158, 3154, 2391, 
         3167, 3171, 3162, 3593, 3588, 2137, 2982, 2987, 2976, 2998, 2992, 
         2164, 2964, 2970, 2958, 3330, 3323, 2072}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2071, 3322, 3329, 2957, 2969, 2963, 2163, 2991, 2997, 2975, 
         2986, 2981, 2136, 3587, 3592, 3161, 3170, 3166, 2390, 3153, 3157, 
         3142, 3149, 3146, 3708, 3302, 3306, 3227, 3232, 3230, 2410, 3206, 
         3209, 3198, 3203, 3201, 2152, 3283, 3286, 3183, 3187, 3185, 2399, 
         3179, 3181, 3174, 3177, 3176, 3711, 3311, 3313, 3236, 3238, 3237, 
         2417, 3219, 3220, 3216, 3218, 3217, 2154, 3420, 3421, 3598, 3597, 
         2407, 3194, 2404, 3191, 2406, 3189, 2405, 3190, 2532, 3314, 3621, 
         2436, 3622, 2437, 3301, 2525, 3705, 2524, 3300, 3772, 3299, 2904, 
         2420, 3222, 2519, 3195, 2408, 2886, 2887, 2158, 2729, 2157, 3422, 
         2885, 3600, 3599, 2242, 3496, 2243, 3497, 2175, 2739, 2513, 3698, 
         3700, 3699, 2257, 2515, 3756, 2514, 2715, 2716, 2521, 3290, 2520, 
         3701, 2146, 2754, 2755, 2516, 3279, 3281, 3280, 2135, 2632, 3563, 
         3564, 3115, 3566, 3565, 3116, 2923, 2193, 2813, 2815, 2124, 2089, 
         2646, 3349, 3348, 2790, 2315, 2575, 2574, 3522, 3473, 3474, 3472, 
         2201, 3475, 2323, 3746, 2324, 2206, 2827, 2829, 2830, 3360, 3361, 
         2665, 2666, 2343, 3538, 3540, 3539, 2668, 3541, 3481, 3482, 3480, 
         2215, 3483, 2347, 3747, 2348, 2219, 2840, 2841, 2842, 3382, 3383, 
         2690, 2691, 2368, 3558, 3560, 3559, 2693, 2704}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0, 5}, {0.1, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196182316]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6461],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->17369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"GammaDistribution", "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", ">", "0"}], ",", 
      RowBox[{"\[Beta]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17291],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527187683]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14179],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"ExpectedValue", "[", 
   RowBox[{
    RowBox[{"x", "^", "4"}], ",", 
    RowBox[{"GammaDistribution", "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2317],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Beta]", "4"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"4", "+", "\[Alpha]"}], "]"}]}], 
  RowBox[{"Gamma", "[", "\[Alpha]", "]"}]]], "Output",
 ImageSize->{100, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289371567]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"CharacteristicFunction", "[", 
     RowBox[{
      RowBox[{"GammaDistribution", "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "t"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "4"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"t", "->", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1595],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "-", "\[Alpha]"}], ")"}]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "-", "\[Alpha]"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Alpha]"}], ")"}], " ", "\[Alpha]", " ", 
  SuperscriptBox["\[Beta]", "4"]}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29135517]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ev", "\[Equal]", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5936],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->160285282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7028],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChiSquareDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChiSquareDistribution"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->31453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{
     RowBox[{"n", "/", "2"}], ",", "2"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27909],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "n"}], "/", "2"}]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "x"}], "/", "2"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["n", "2"]}]]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["n", "2"], "]"}]]], "Output",
 ImageSize->{100, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81882411]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "n", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17981],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "n"}], "/", "2"}]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "x"}], "/", "2"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["n", "2"]}]]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["n", "2"], "]"}]]], "Output",
 ImageSize->{100, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352992158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347572883],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->347616282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"1", ",", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352623190],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["x", "b"]}]], "b"]], "Output",
 ImageSize->{29, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->916722778]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExponentialDistribution", "[", 
    RowBox[{"1", "/", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->767474579],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox["x", "b"]}]], "b"]], "Output",
 ImageSize->{29, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29162966]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5385],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GammaDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GammaDistribution"]], "InlineFormula"],
 " is not defined when either ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->28402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5230],

Cell[BoxData[
 RowBox[{
  RowBox[{"GammaDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->16526764],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "5"}], "]"}], "]"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41847430]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "->", "1"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", 
     RowBox[{"3", "+", "I"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{"3", "+", "\[ImaginaryI]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259817266]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16320],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BetaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChiSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExponentialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExponentialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21267],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->36024699]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GammaDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 47.6743246}", "context" -> "System`", 
    "keywords" -> {"Erlang distribution", "waiting time distribution"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GammaDistribution[\\[Alpha], \\[Beta]] represents a gamma distribution \
with shape parameter \\[Alpha] and scale parameter \\[Beta].", 
    "synonyms" -> {"gamma distribution"}, "title" -> "GammaDistribution", 
    "type" -> "Symbol", "uri" -> "ref/GammaDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8028, 252, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->254911283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 144900, 3064}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2541, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3164, 88, 1582, 37, 70, "ObjectNameGrid"],
Cell[4749, 127, 770, 24, 70, "Usage",
 CellID->26919]
}, Open  ]],
Cell[CellGroupData[{
Cell[5556, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6034, 173, 749, 27, 70, "Notes",
 CellID->429991538],
Cell[6786, 202, 506, 17, 70, "Notes",
 CellID->7997],
Cell[7295, 221, 696, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[8028, 252, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->254911283],
Cell[CellGroupData[{
Cell[8413, 266, 147, 5, 70, "ExampleSection",
 CellID->69670291],
Cell[8563, 273, 270, 6, 70, "ExampleText",
 CellID->13793],
Cell[CellGroupData[{
Cell[8858, 283, 177, 5, 28, "Input",
 CellID->28630],
Cell[9038, 290, 193, 6, 36, "Output",
 CellID->117048625]
}, Open  ]],
Cell[CellGroupData[{
Cell[9268, 301, 181, 5, 28, "Input",
 CellID->23043],
Cell[9452, 308, 217, 7, 36, "Output",
 CellID->210168656]
}, Open  ]],
Cell[9684, 318, 121, 3, 70, "ExampleDelimiter",
 CellID->25314],
Cell[9808, 323, 451, 14, 70, "ExampleText",
 CellID->16626],
Cell[CellGroupData[{
Cell[10284, 341, 201, 6, 70, "Input",
 CellID->17117],
Cell[10488, 349, 475, 16, 61, "Output",
 CellID->182727746]
}, Open  ]],
Cell[CellGroupData[{
Cell[11000, 370, 309, 10, 28, "Input",
 CellID->20620],
Cell[11312, 382, 3253, 57, 162, "Output",
 Evaluatable->False,
 CellID->23564491]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14614, 445, 215, 7, 70, "ExampleSection",
 CellID->8964],
Cell[14832, 454, 250, 7, 70, "ExampleText",
 CellID->19154],
Cell[CellGroupData[{
Cell[15107, 465, 195, 6, 70, "Input",
 CellID->18866],
Cell[15305, 473, 333, 10, 36, "Output",
 CellID->264417237]
}, Open  ]],
Cell[15653, 486, 121, 3, 70, "ExampleDelimiter",
 CellID->30664],
Cell[15777, 491, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[15901, 498, 181, 5, 70, "Input",
 CellID->23775],
Cell[16085, 505, 197, 7, 55, "Output",
 CellID->226208801]
}, Open  ]],
Cell[CellGroupData[{
Cell[16319, 517, 181, 5, 70, "Input",
 CellID->21100],
Cell[16503, 524, 207, 7, 51, "Output",
 CellID->49751496]
}, Open  ]],
Cell[16725, 534, 121, 3, 70, "ExampleDelimiter",
 CellID->25476],
Cell[16849, 539, 212, 5, 70, "ExampleText",
 CellID->6379],
Cell[CellGroupData[{
Cell[17086, 548, 245, 7, 70, "Input",
 CellID->10943],
Cell[17334, 557, 337, 11, 56, "Output",
 CellID->908079780]
}, Open  ]],
Cell[17686, 571, 120, 3, 70, "ExampleDelimiter",
 CellID->3789],
Cell[17809, 576, 441, 15, 70, "ExampleText",
 CellID->361],
Cell[CellGroupData[{
Cell[18275, 595, 196, 6, 70, "Input",
 CellID->11385],
Cell[18474, 603, 175, 5, 36, "Output",
 CellID->487270962]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18698, 614, 223, 7, 70, "ExampleSection",
 CellID->29561],
Cell[18924, 623, 112, 3, 70, "ExampleText",
 CellID->29591],
Cell[CellGroupData[{
Cell[19061, 630, 309, 10, 70, "Input",
 CellID->25867],
Cell[19373, 642, 2749, 49, 70, "Output",
 Evaluatable->False,
 CellID->23732598]
}, Open  ]],
Cell[22137, 694, 125, 3, 70, "ExampleDelimiter",
 CellID->104454543],
Cell[22265, 699, 362, 13, 70, "ExampleText",
 CellID->17591],
Cell[CellGroupData[{
Cell[22652, 716, 399, 12, 70, "Input",
 CellID->3832],
Cell[23054, 730, 107883, 1798, 70, "Output",
 CellID->196182316]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[130986, 2534, 232, 7, 70, "ExampleSection",
 CellID->6461],
Cell[131221, 2543, 229, 5, 70, "ExampleText",
 CellID->17369],
Cell[CellGroupData[{
Cell[131475, 2552, 499, 15, 70, "Input",
 CellID->17291],
Cell[131977, 2569, 158, 5, 36, "Output",
 CellID->527187683]
}, Open  ]],
Cell[132150, 2577, 121, 3, 70, "ExampleDelimiter",
 CellID->14179],
Cell[132274, 2582, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[132533, 2592, 276, 9, 70, "Input",
 CellID->2317],
Cell[132812, 2603, 337, 11, 56, "Output",
 CellID->289371567]
}, Open  ]],
Cell[CellGroupData[{
Cell[133186, 2619, 405, 13, 70, "Input",
 CellID->1595],
Cell[133594, 2634, 490, 17, 36, "Output",
 CellID->29135517]
}, Open  ]],
Cell[CellGroupData[{
Cell[134121, 2656, 134, 4, 70, "Input",
 CellID->5936],
Cell[134258, 2662, 161, 5, 36, "Output",
 CellID->160285282]
}, Open  ]],
Cell[134434, 2670, 120, 3, 70, "ExampleDelimiter",
 CellID->7028],
Cell[134557, 2675, 501, 16, 70, "ExampleText",
 CellID->31453],
Cell[CellGroupData[{
Cell[135083, 2695, 214, 7, 70, "Input",
 CellID->27909],
Cell[135300, 2704, 516, 19, 67, "Output",
 CellID->81882411]
}, Open  ]],
Cell[CellGroupData[{
Cell[135853, 2728, 170, 6, 70, "Input",
 CellID->17981],
Cell[136026, 2736, 517, 19, 67, "Output",
 CellID->352992158]
}, Open  ]],
Cell[136558, 2758, 125, 3, 70, "ExampleDelimiter",
 CellID->347572883],
Cell[136686, 2763, 509, 16, 70, "ExampleText",
 CellID->347616282],
Cell[CellGroupData[{
Cell[137220, 2783, 192, 6, 70, "Input",
 CellID->352623190],
Cell[137415, 2791, 258, 9, 58, "Output",
 CellID->916722778]
}, Open  ]],
Cell[CellGroupData[{
Cell[137710, 2805, 198, 6, 70, "Input",
 CellID->767474579],
Cell[137911, 2813, 257, 9, 58, "Output",
 CellID->29162966]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[138217, 2828, 326, 9, 70, "ExampleSection",
 CellID->5385],
Cell[138546, 2839, 528, 17, 70, "ExampleText",
 CellID->28402],
Cell[CellGroupData[{
Cell[139099, 2860, 183, 6, 70, "Input",
 CellID->5230],
Cell[139285, 2868, 197, 5, 70, "Message",
 CellID->16526764],
Cell[139485, 2875, 276, 9, 36, "Output",
 CellID->41847430]
}, Open  ]],
Cell[139776, 2887, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[139900, 2892, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[140206, 2904, 346, 11, 70, "Input",
 CellID->25838],
Cell[140555, 2917, 192, 6, 36, "Output",
 CellID->259817266]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[140808, 2930, 311, 9, 70, "SeeAlsoSection",
 CellID->16320],
Cell[141122, 2941, 1543, 53, 70, "SeeAlso",
 CellID->13053]
}, Open  ]],
Cell[CellGroupData[{
Cell[142702, 2999, 314, 9, 70, "TutorialsSection",
 CellID->21267],
Cell[143019, 3010, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[143213, 3018, 299, 8, 70, "MoreAboutSection"],
Cell[143515, 3028, 183, 4, 70, "MoreAbout",
 CellID->36024699]
}, Open  ]],
Cell[143713, 3035, 27, 0, 70, "History"],
Cell[143743, 3037, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

