(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24464,        920]
NotebookOptionsPosition[     19106,        735]
NotebookOutlinePosition[     20461,        773]
CellTagsIndexPosition[     20376,        768]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"], 
          "Polynomials over Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>", 
       2->"\<\"Polynomials over Algebraic Number Fields\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Extension" :> Documentation`HelpLookup["paclet:ref/Extension"],
           "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "Modulus" :> 
          Documentation`HelpLookup["paclet:ref/Modulus"], "I" :> 
          Documentation`HelpLookup["paclet:ref/I"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Extension\"\>", 2->"\<\"ComplexExpand\"\>", 
       3->"\<\"Modulus\"\>", 4->"\<\"I\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Number Theory\"\>", 3->"\<\"Polynomial Algebra\"\>", 
       4->"\<\"Polynomial Factoring & Decomposition\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GaussianIntegers", "ObjectName",
 CellID->27633],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["GaussianIntegers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GaussianIntegers"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["FactorInteger",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["PrimeQ",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PrimeQ"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Factor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
     " and related functions which specifies whether factorization should be \
done over Gaussian integers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27037]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"GaussianIntegers", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", factorization is done over the ordinary ring of integers ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->23893],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"GaussianIntegers", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", factorization is done over the ring of integers with ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " adjoined ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalZ]", "[", "i", "]"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->22630],

Cell[TextData[{
 "The Gaussian primes used when ",
 Cell[BoxData[
  RowBox[{"GaussianIntegers", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " are chosen to have both real and imaginary parts positive. "
}], "Notes",
 CellID->12993],

Cell[TextData[{
 "The first entry in the list given by ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{"GaussianIntegers", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " may be ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28782]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8932076],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->421978589],

Cell[TextData[{
 "Factor a polynomial over ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[ImaginaryI]", "]"}], 
   TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->505966590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108096960],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107211303]
}, Open  ]],

Cell[TextData[{
 "Factor an integer over ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalZ]", "[", "\[ImaginaryI]", "]"}], 
   TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->37496090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"2", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150132890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "2"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171378223]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6640],

Cell["\<\
By default polynomial factorization is performed over the rationals:\
\>", "ExampleText",
 CellID->59877688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], "-", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51150283],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129420921]
}, Open  ]],

Cell[TextData[{
 "This specifies that the factorization should be done over ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[ImaginaryI]", "]"}], 
   TraditionalForm]], "InlineMath"],
 ": "
}], "ExampleText",
 CellID->503516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "16"}], ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->311382914],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272364039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39929232],

Cell["\<\
By default integer factorization is performed over the integers:\
\>", "ExampleText",
 CellID->518288578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "12", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488602540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124822083]
}, Open  ]],

Cell["\<\
This specifies that the factorization should be done over the Gaussian \
integers:\
\>", "ExampleText",
 CellID->26250851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", 
  RowBox[{"12", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->718419672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->416790755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220836130],

Cell["\<\
A number prime over the integers may not be prime over the Gaussian integers:\
\
\>", "ExampleText",
 CellID->873609538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", "17", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->572108626],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->435049512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrimeQ", "[", 
  RowBox[{"17", ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->634022118],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219612852]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23661],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"GaussianIntegers", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->172540017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", "1"}], ",", 
   RowBox[{"GaussianIntegers", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92661089],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{109, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42912388]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", "1"}], ",", 
   RowBox[{"Extension", "\[Rule]", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92016508],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{109, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234750477]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22307],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Modulus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Modulus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["I",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/I"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32203],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->17461],

Cell[TextData[ButtonBox["Polynomials over Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PolynomialsOverAlgebraicNumberFields"]], "Tutorials",
 CellID->6213]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with GaussianIntegers",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
GaussianIntegers"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->167983378],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->45450085],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->833074992],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->210933888],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->9328089]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GaussianIntegers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 56.4089232}", "context" -> "System`", 
    "keywords" -> {"Gaussian integers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GaussianIntegers is an option for FactorInteger, PrimeQ, Factor and \
related functions which specifies whether factorization should be done over \
Gaussian integers. ", "synonyms" -> {"gaussian integers"}, "title" -> 
    "GaussianIntegers", "type" -> "Symbol", "uri" -> 
    "ref/GaussianIntegers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6677, 216, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8932076]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20235, 761}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2767, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3390, 90, 54, 1, 70, "ObjectName",
 CellID->27633],
Cell[3447, 93, 956, 29, 70, "Usage",
 CellID->27037]
}, Open  ]],
Cell[CellGroupData[{
Cell[4440, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4918, 144, 365, 12, 70, "Notes",
 CellID->23893],
Cell[5286, 158, 463, 17, 70, "Notes",
 CellID->22630],
Cell[5752, 177, 296, 9, 70, "Notes",
 CellID->12993],
Cell[6051, 188, 589, 23, 70, "Notes",
 CellID->28782]
}, Closed]],
Cell[CellGroupData[{
Cell[6677, 216, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8932076],
Cell[CellGroupData[{
Cell[7060, 230, 148, 5, 70, "ExampleSection",
 CellID->421978589],
Cell[7211, 237, 221, 8, 70, "ExampleText",
 CellID->505966590],
Cell[CellGroupData[{
Cell[7457, 249, 222, 7, 28, "Input",
 CellID->108096960],
Cell[7682, 258, 318, 11, 36, "Output",
 CellID->107211303]
}, Open  ]],
Cell[8015, 272, 218, 8, 70, "ExampleText",
 CellID->37496090],
Cell[CellGroupData[{
Cell[8258, 284, 180, 5, 28, "Input",
 CellID->150132890],
Cell[8441, 291, 376, 14, 36, "Output",
 CellID->171378223]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8866, 311, 215, 7, 70, "ExampleSection",
 CellID->6640],
Cell[9084, 320, 118, 3, 70, "ExampleText",
 CellID->59877688],
Cell[CellGroupData[{
Cell[9227, 327, 149, 5, 70, "Input",
 CellID->51150283],
Cell[9379, 334, 378, 14, 39, "Output",
 CellID->129420921]
}, Open  ]],
Cell[9772, 351, 251, 8, 70, "ExampleText",
 CellID->503516],
Cell[CellGroupData[{
Cell[10048, 363, 223, 7, 70, "Input",
 CellID->311382914],
Cell[10274, 372, 504, 18, 36, "Output",
 CellID->272364039]
}, Open  ]],
Cell[10793, 393, 124, 3, 70, "ExampleDelimiter",
 CellID->39929232],
Cell[10920, 398, 115, 3, 70, "ExampleText",
 CellID->518288578],
Cell[CellGroupData[{
Cell[11060, 405, 110, 3, 70, "Input",
 CellID->488602540],
Cell[11173, 410, 302, 11, 36, "Output",
 CellID->124822083]
}, Open  ]],
Cell[11490, 424, 132, 4, 70, "ExampleText",
 CellID->26250851],
Cell[CellGroupData[{
Cell[11647, 432, 181, 5, 70, "Input",
 CellID->718419672],
Cell[11831, 439, 420, 15, 36, "Output",
 CellID->416790755]
}, Open  ]],
Cell[12266, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->220836130],
Cell[12394, 462, 130, 4, 70, "ExampleText",
 CellID->873609538],
Cell[CellGroupData[{
Cell[12549, 470, 103, 3, 70, "Input",
 CellID->572108626],
Cell[12655, 475, 161, 5, 36, "Output",
 CellID->435049512]
}, Open  ]],
Cell[CellGroupData[{
Cell[12853, 485, 174, 5, 70, "Input",
 CellID->634022118],
Cell[13030, 492, 162, 5, 36, "Output",
 CellID->219612852]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13241, 503, 233, 7, 70, "ExampleSection",
 CellID->23661],
Cell[13477, 512, 584, 23, 70, "ExampleText",
 CellID->172540017],
Cell[CellGroupData[{
Cell[14086, 539, 221, 7, 70, "Input",
 CellID->92661089],
Cell[14310, 548, 370, 13, 39, "Output",
 CellID->42912388]
}, Open  ]],
Cell[CellGroupData[{
Cell[14717, 566, 211, 7, 70, "Input",
 CellID->92016508],
Cell[14931, 575, 371, 13, 39, "Output",
 CellID->234750477]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15363, 595, 311, 9, 70, "SeeAlsoSection",
 CellID->22307],
Cell[15677, 606, 937, 35, 70, "SeeAlso",
 CellID->20997]
}, Open  ]],
Cell[CellGroupData[{
Cell[16651, 646, 314, 9, 70, "TutorialsSection",
 CellID->32203],
Cell[16968, 657, 198, 4, 70, "Tutorials",
 CellID->17461],
Cell[17169, 663, 189, 4, 70, "Tutorials",
 CellID->6213]
}, Open  ]],
Cell[CellGroupData[{
Cell[17395, 672, 305, 8, 70, "RelatedLinksSection"],
Cell[17703, 682, 374, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18114, 699, 319, 9, 70, "MoreAboutSection",
 CellID->167983378],
Cell[18436, 710, 140, 3, 70, "MoreAbout",
 CellID->45450085],
Cell[18579, 715, 137, 3, 70, "MoreAbout",
 CellID->833074992],
Cell[18719, 720, 147, 3, 70, "MoreAbout",
 CellID->210933888],
Cell[18869, 725, 165, 3, 70, "MoreAbout",
 CellID->9328089]
}, Open  ]],
Cell[19049, 731, 27, 0, 70, "History"],
Cell[19079, 733, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

