(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12929,        478]
NotebookOptionsPosition[      9628,        369]
NotebookOutlinePosition[     11074,        409]
CellTagsIndexPosition[     10989,        404]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Definite Integrals" :> 
          Documentation`HelpLookup["paclet:tutorial/DefiniteIntegrals"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Definite Integrals\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GenerateConditions", "ObjectName",
 CellID->14878],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["GenerateConditions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GenerateConditions"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Integrate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
     " that specifies whether explicit conditions on parameters should be \
generated in the results of definite integrals. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6923]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"GenerateConditions", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", which is equivalent to a setting of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for one\[Hyphen]dimensional integrals. "
}], "Notes",
 CellID->27085]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->718967224],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->597596523],

Cell[TextData[{
 "Obtain conditions for validity of the result in ",
 Cell[BoxData[
  ButtonBox["FourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierTransform"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->834520110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourierTransform", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a", " ", 
       RowBox[{"t", "^", "2"}]}], ")"}]}], ",", "t", ",", "\[Omega]", ",", 
    RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467359798],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], "<", "0"}], ",", 
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     FractionBox[
      SuperscriptBox["\[Omega]", "2"], 
      RowBox[{"4", " ", "a"}]]], 
    RowBox[{
     SqrtBox["2"], " ", 
     SqrtBox[
      RowBox[{"-", "a"}]]}]], ",", 
   RowBox[{"FourierTransform", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", " ", 
       SuperscriptBox["t", "2"]}]], ",", "t", ",", "\[Omega]", ",", 
     RowBox[{"GenerateConditions", "\[Rule]", "True"}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{542, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29451470]
}, Open  ]],

Cell[TextData[{
 "GenerateConditions is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " by default in this case:"
}], "ExampleText",
 CellID->163909754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourierTransform", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"a", " ", 
       RowBox[{"t", "^", "2"}]}], ")"}]}], ",", " ", "t", ",", "\[Omega]"}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->238489257],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    SuperscriptBox["\[Omega]", "2"], 
    RowBox[{"4", " ", "a"}]]], 
  RowBox[{
   SqrtBox["2"], " ", 
   SqrtBox[
    RowBox[{"-", "a"}]]}]]], "Output",
 ImageSize->{67, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->114342909]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266149633],

Cell[TextData[{
 "The result from ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " contains conditions for validity:"
}], "ExampleText",
 CellID->50157822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"a", " ", "x"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->666793404],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Re", "[", "a", "]"}], "<", "0"}], ",", 
   RowBox[{"-", 
    FractionBox["1", "a"]}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", " ", "x"}]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{
       RowBox[{"Re", "[", "a", "]"}], "\[GreaterEqual]", "0"}]}]}], "]"}]}], 
  "]"}]], "Output",
 ImageSize->{456, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364556355]
}, Open  ]],

Cell[TextData[{
 "Use GenerateConditions -> ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " to obtain result valid for a limited range of a:"
}], "ExampleText",
 CellID->2876065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"a", " ", "x"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"GenerateConditions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->302666854],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "a"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->674309760]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9412],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29400],

Cell[TextData[ButtonBox["Definite Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiniteIntegrals"]], "Tutorials",
 CellID->23024]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GenerateConditions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 58.0495902}", "context" -> "System`", 
    "keywords" -> {
     "conditional results", "conditions in integrals", 
      "results valid for specific conditions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GenerateConditions is an option for Integrate that specifies whether \
explicit conditions on parameters should be generated in the results of \
definite integrals. ", "synonyms" -> {"generate conditions"}, "title" -> 
    "GenerateConditions", "type" -> "Symbol", "uri" -> 
    "ref/GenerateConditions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3516, 121, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->718967224]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10846, 397}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1164, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1787, 58, 56, 1, 70, "ObjectName",
 CellID->14878],
Cell[1846, 61, 683, 19, 70, "Usage",
 CellID->6923]
}, Open  ]],
Cell[CellGroupData[{
Cell[2566, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3044, 102, 435, 14, 70, "Notes",
 CellID->27085]
}, Closed]],
Cell[CellGroupData[{
Cell[3516, 121, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->718967224],
Cell[CellGroupData[{
Cell[3901, 135, 148, 5, 70, "ExampleSection",
 CellID->597596523],
Cell[4052, 142, 247, 8, 70, "ExampleText",
 CellID->834520110],
Cell[CellGroupData[{
Cell[4324, 154, 341, 11, 28, "Input",
 CellID->467359798],
Cell[4668, 167, 747, 25, 69, "Output",
 CellID->29451470]
}, Open  ]],
Cell[5430, 195, 230, 8, 70, "ExampleText",
 CellID->163909754],
Cell[CellGroupData[{
Cell[5685, 207, 286, 10, 70, "Input",
 CellID->238489257],
Cell[5974, 219, 365, 14, 69, "Output",
 CellID->114342909]
}, Open  ]],
Cell[6354, 236, 125, 3, 70, "ExampleDelimiter",
 CellID->266149633],
Cell[6482, 241, 233, 8, 70, "ExampleText",
 CellID->50157822],
Cell[CellGroupData[{
Cell[6740, 253, 269, 9, 70, "Input",
 CellID->666793404],
Cell[7012, 264, 650, 21, 51, "Output",
 CellID->364556355]
}, Open  ]],
Cell[7677, 288, 249, 8, 70, "ExampleText",
 CellID->2876065],
Cell[CellGroupData[{
Cell[7951, 300, 330, 10, 70, "Input",
 CellID->302666854],
Cell[8284, 312, 196, 7, 51, "Output",
 CellID->674309760]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8541, 326, 310, 9, 70, "SeeAlsoSection",
 CellID->9412],
Cell[8854, 337, 202, 6, 70, "SeeAlso",
 CellID->15765]
}, Open  ]],
Cell[CellGroupData[{
Cell[9093, 348, 314, 9, 70, "TutorialsSection",
 CellID->29400],
Cell[9410, 359, 146, 3, 70, "Tutorials",
 CellID->23024]
}, Open  ]],
Cell[9571, 365, 27, 0, 70, "History"],
Cell[9601, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

