(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46460,       1325]
NotebookOptionsPosition[     40935,       1133]
NotebookOutlinePosition[     42269,       1171]
CellTagsIndexPosition[     42183,       1166]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Equations and Inequalities over Domains\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"C" :> Documentation`HelpLookup["paclet:ref/C"], "Unique" :> 
          Documentation`HelpLookup["paclet:ref/Unique"], "Module" :> 
          Documentation`HelpLookup["paclet:ref/Module"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"C\"\>", 2->"\<\"Unique\"\>", 
       3->"\<\"Module\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeneratedParameters", "ObjectName",
 CellID->1790],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["GeneratedParameters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
     "\[LineSeparator]is an option which specifies how parameters generated \
to represent the results of various symbolic operations should be named. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17013]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The typical default setting is ",
 Cell[BoxData[
  RowBox[{"GeneratedParameters", "->", 
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30412],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"GeneratedParameters", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that successive generated parameters should be named ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", "1", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", "2", "]"}]], "InlineFormula"],
 ", ",
 StyleBox["\[Ellipsis]", "TR"],
 " . "
}], "Notes",
 CellID->14855],

Cell[TextData[{
 "In typical cases, the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " are used to parameterize families of solutions to equations. "
}], "Notes",
 CellID->21060],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " usually correspond to free parameters, but are also sometimes used to \
represent arbitrary functions. "
}], "Notes",
 CellID->7093],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 " have indices that start at 1 for each invocation of a particular symbolic \
operation. "
}], "Notes",
 CellID->8472],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"GeneratedParameters", "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Module",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Module"], "[", 
      RowBox[{
       RowBox[{"{", 
        ButtonBox["C",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/C"], "}"}], ",", 
       ButtonBox["C",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/C"]}], "]"}], "&"}], ")"}]}]], 
  "InlineFormula"],
 " guarantees that parameters are unique, even across different invocations \
of a function. "
}], "Notes",
 CellID->25402],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " is an option to such functions as ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32676]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21626417],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->26428872],

Cell["General solution of algebraic equation:", "ExampleText",
 CellID->487618078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5424646],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["\[Pi]", "2"], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"C", "[", "1", "]"}]}]}]}]}]], "Output",
 ImageSize->{220, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257694501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->646560335],

Cell["General solution of differential equation:", "ExampleText",
 CellID->601107897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"4", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->516444048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{195, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->582791603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2117234],

Cell["General solution of difference equation:", "ExampleText",
 CellID->397729191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
    RowBox[{"4", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61363275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", "n"], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}], "n"], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214512068]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17107],

Cell["Special solutions: ", "ExampleText",
 CellID->15043967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "1"}], ",", "x"}], "]"}], 
  " ", "/.", " ", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Rule]", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->390139235],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  FractionBox[
   RowBox[{"5", " ", "\[Pi]"}], "2"]}]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->670141379]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
     RowBox[{"4", 
      RowBox[{"y", "[", "x", "]"}]}]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"C", "[", "2", "]"}], "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->568733883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "x"}]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{143, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111145934]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
     RowBox[{"4", 
      RowBox[{"a", "[", "n", "]"}]}]}], ",", 
    RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
    RowBox[{
     RowBox[{"C", "[", "2", "]"}], "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->92094074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["2", "n"], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"], " ", 
      SuperscriptBox["2", 
       RowBox[{"1", "+", "n"}]]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{161, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->118216122]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79093420],

Cell["Use a different symbol: ", "ExampleText",
 CellID->801901225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "1"}], ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", "\[Alpha]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13224093],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Alpha]", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["\[Pi]", "2"], "+", 
    RowBox[{"2", " ", "\[Pi]", " ", 
     RowBox[{"\[Alpha]", "[", "1", "]"}]}]}]}]}]], "Output",
 ImageSize->{220, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260952199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67989089],

Cell["Use a subscripted symbol:", "ExampleText",
 CellID->63692575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"4", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"c", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384060623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", "x"}]], " ", 
      SubscriptBox["c", "1"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]], " ", 
      SubscriptBox["c", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{164, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165022586]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375000173],

Cell["Start index at 0:", "ExampleText",
 CellID->282583409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", 
     RowBox[{"n", "+", "2"}], "]"}], "\[Equal]", 
    RowBox[{"4", 
     RowBox[{"a", "[", "n", "]"}]}]}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"C", "[", 
       RowBox[{"#", "-", "1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29680350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["2", "n"], " ", 
      RowBox[{"C", "[", "0", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}], "n"], " ", 
      RowBox[{"C", "[", "1", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328905795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->846971154],

Cell["General solution to partial differential equation:", "ExampleText",
 CellID->88568024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]}], "\[Equal]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", "x", " ", "y", " ", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}], ",", "u", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503076221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["x", "2"]}]], " ", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["x", "2"]}], "+", 
           SuperscriptBox["y", "2"]}], ")"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{324, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->667993718]
}, Open  ]],

Cell["Special solution:", "ExampleText",
 CellID->1609242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "/.", 
   RowBox[{"First", "[", "%", "]"}]}], "/.", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Rule]", 
   RowBox[{"Function", "[", 
    RowBox[{"z", ",", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "2"}], "z"}], "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86943006],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["x", "2"]}], "-", 
   SuperscriptBox["y", "2"]}]]], "Output",
 ImageSize->{43, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576221494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26426823],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->275680863]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21528],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->532]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13543],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "Tutorials",
 CellID->7373]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeneratedParameters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 44, 59.8465112}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GeneratedParameters is an option which specifies how parameters \
generated to represent the results of various symbolic operations should be \
named. ", "synonyms" -> {"generated parameters"}, "title" -> 
    "GeneratedParameters", "type" -> "Symbol", "uri" -> 
    "ref/GeneratedParameters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5815, 212, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21626417]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42041, 1159}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1378, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2001, 61, 56, 1, 70, "ObjectName",
 CellID->1790],
Cell[2060, 64, 534, 14, 70, "Usage",
 CellID->17013]
}, Open  ]],
Cell[CellGroupData[{
Cell[2631, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3109, 100, 236, 9, 70, "Notes",
 CellID->30412],
Cell[3348, 111, 455, 17, 70, "Notes",
 CellID->14855],
Cell[3806, 130, 243, 8, 70, "Notes",
 CellID->21060],
Cell[4052, 140, 266, 9, 70, "Notes",
 CellID->7093],
Cell[4321, 151, 250, 9, 70, "Notes",
 CellID->8472],
Cell[4574, 162, 608, 21, 70, "Notes",
 CellID->25402],
Cell[5185, 185, 593, 22, 70, "Notes",
 CellID->32676]
}, Closed]],
Cell[CellGroupData[{
Cell[5815, 212, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21626417],
Cell[CellGroupData[{
Cell[6199, 226, 147, 5, 70, "ExampleSection",
 CellID->26428872],
Cell[6349, 233, 82, 1, 70, "ExampleText",
 CellID->487618078],
Cell[CellGroupData[{
Cell[6456, 238, 189, 7, 28, "Input",
 CellID->5424646],
Cell[6648, 247, 401, 13, 49, "Output",
 CellID->257694501]
}, Open  ]],
Cell[7064, 263, 125, 3, 70, "ExampleDelimiter",
 CellID->646560335],
Cell[7192, 268, 85, 1, 70, "ExampleText",
 CellID->601107897],
Cell[CellGroupData[{
Cell[7302, 273, 298, 10, 70, "Input",
 CellID->516444048],
Cell[7603, 285, 569, 19, 39, "Output",
 CellID->582791603]
}, Open  ]],
Cell[8187, 307, 123, 3, 70, "ExampleDelimiter",
 CellID->2117234],
Cell[8313, 312, 83, 1, 70, "ExampleText",
 CellID->397729191],
Cell[CellGroupData[{
Cell[8421, 317, 301, 10, 70, "Input",
 CellID->61363275],
Cell[8725, 329, 513, 18, 36, "Output",
 CellID->214512068]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9287, 353, 216, 7, 70, "ExampleSection",
 CellID->17107],
Cell[9506, 362, 61, 1, 70, "ExampleText",
 CellID->15043967],
Cell[CellGroupData[{
Cell[9592, 367, 286, 10, 70, "Input",
 CellID->390139235],
Cell[9881, 379, 236, 8, 51, "Output",
 CellID->670141379]
}, Open  ]],
Cell[CellGroupData[{
Cell[10154, 392, 500, 17, 70, "Input",
 CellID->568733883],
Cell[10657, 411, 477, 16, 39, "Output",
 CellID->111145934]
}, Open  ]],
Cell[CellGroupData[{
Cell[11171, 432, 503, 17, 70, "Input",
 CellID->92094074],
Cell[11677, 451, 478, 17, 39, "Output",
 CellID->118216122]
}, Open  ]],
Cell[12170, 471, 124, 3, 70, "ExampleDelimiter",
 CellID->79093420],
Cell[12297, 476, 67, 1, 70, "ExampleText",
 CellID->801901225],
Cell[CellGroupData[{
Cell[12389, 481, 252, 7, 70, "Input",
 CellID->13224093],
Cell[12644, 490, 415, 13, 49, "Output",
 CellID->260952199]
}, Open  ]],
Cell[13074, 506, 124, 3, 70, "ExampleDelimiter",
 CellID->67989089],
Cell[13201, 511, 67, 1, 70, "ExampleText",
 CellID->63692575],
Cell[CellGroupData[{
Cell[13293, 516, 470, 15, 70, "Input",
 CellID->384060623],
Cell[13766, 533, 557, 19, 39, "Output",
 CellID->165022586]
}, Open  ]],
Cell[14338, 555, 125, 3, 70, "ExampleDelimiter",
 CellID->375000173],
Cell[14466, 560, 60, 1, 70, "ExampleText",
 CellID->282583409],
Cell[CellGroupData[{
Cell[14551, 565, 465, 15, 70, "Input",
 CellID->29680350],
Cell[15019, 582, 513, 18, 36, "Output",
 CellID->328905795]
}, Open  ]],
Cell[15547, 603, 125, 3, 70, "ExampleDelimiter",
 CellID->846971154],
Cell[15675, 608, 92, 1, 70, "ExampleText",
 CellID->88568024],
Cell[CellGroupData[{
Cell[15792, 613, 664, 22, 70, "Input",
 CellID->503076221],
Cell[16459, 637, 789, 27, 51, "Output",
 CellID->667993718]
}, Open  ]],
Cell[17263, 667, 58, 1, 70, "ExampleText",
 CellID->1609242],
Cell[CellGroupData[{
Cell[17346, 672, 400, 14, 70, "Input",
 CellID->86943006],
Cell[17749, 688, 288, 10, 40, "Output",
 CellID->576221494]
}, Open  ]],
Cell[CellGroupData[{
Cell[18074, 703, 294, 10, 70, "Input",
 CellID->26426823],
Cell[18371, 715, 20904, 347, 70, "Output",
 Evaluatable->False,
 CellID->275680863]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39336, 1069, 311, 9, 70, "SeeAlsoSection",
 CellID->21528],
Cell[39650, 1080, 672, 26, 70, "SeeAlso",
 CellID->532]
}, Open  ]],
Cell[CellGroupData[{
Cell[40359, 1111, 314, 9, 70, "TutorialsSection",
 CellID->13543],
Cell[40676, 1122, 187, 4, 70, "Tutorials",
 CellID->7373]
}, Open  ]],
Cell[40878, 1129, 27, 0, 70, "History"],
Cell[40908, 1131, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

