(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31642,       1166]
NotebookOptionsPosition[     25350,        945]
NotebookOutlinePosition[     26580,        981]
CellTagsIndexPosition[     26495,        976]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
          "HarmonicMean" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicMean"], 
          "ArithmeticGeometricMean" :> 
          Documentation`HelpLookup["paclet:ref/ArithmeticGeometricMean"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mean\"\>", 
       2->"\<\"HarmonicMean\"\>", 
       3->"\<\"ArithmeticGeometricMean\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GeometricMean", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GeometricMean",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GeometricMean"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the geometric mean of the values in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28664]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", the geometric mean is given by ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Product]", "i"], 
      SubscriptBox["x", "i"]}], ")"}], 
    RowBox[{"1", "/", "n"}]], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->26673],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricMean"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"GeometricMean", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"GeometricMean", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->26555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117780912],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->146096829],

Cell["Geometric mean of a list:", "ExampleText",
 CellID->104718352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148281672],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"a", " ", "b", " ", "c", " ", "d"}], ")"}], 
  RowBox[{"1", "/", "4"}]]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287814119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252483224],

Cell["Geometric mean of columns of a matrix:", "ExampleText",
 CellID->234915771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"12", ",", "15"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36247193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox["30", 
     RowBox[{"1", "/", "4"}]]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]], " ", 
    SqrtBox["15"]}]}], "}"}]], "Output",
 ImageSize->{126, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396930572]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21416],

Cell["Compute results at machine precision:", "ExampleText",
 CellID->379986608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216003675],

Cell[BoxData["0.2543150069556584`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498759435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "6", ",", "5", ",", "15", ",", "10", ",", "1"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["4.560793596570561879136508437780119857110176851458`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422488260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", 
    RowBox[{"10", "^", "7"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["3.67941072050215891053887235388`18.740434984137462"], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102774299]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.67650539374038551199664448701`18.94428981355119", ",", 
   "3.67914964816258802816112205884`18.94428981355119", ",", 
   "3.68663866063879342970640771568`18.94428981355119", ",", 
   "3.68040200724240074579505052274`18.94428981355119", ",", 
   "3.67705024193834178408782980519`18.94428981355119", ",", 
   "3.6767482754605968777177583853`18.94428981355119", ",", 
   "3.67459882373918524098031323703`18.94428981355119", ",", 
   "3.67855473692169126912449490762`18.94428981355119", ",", 
   "3.68082714592372019174521055504`18.94428981355119", ",", 
   "3.68068840519849487618019319466`18.94428981355119"}], "}"}]], "Output",
 ImageSize->{461, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356553394]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28649],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", "j"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->765704607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SuperscriptBox["2", 
    RowBox[{"1", "/", "50"}]], ",", 
   SuperscriptBox["3", 
    RowBox[{"1", "/", "50"}]], ",", 
   SuperscriptBox["2", 
    RowBox[{"1", "/", "25"}]], ",", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "50"}]], ",", 
   SuperscriptBox["6", 
    RowBox[{"1", "/", "50"}]], ",", 
   SuperscriptBox["7", 
    RowBox[{"1", "/", "50"}]], ",", 
   SuperscriptBox["2", 
    RowBox[{"3", "/", "50"}]], ",", 
   SuperscriptBox["3", 
    RowBox[{"1", "/", "25"}]], ",", 
   SuperscriptBox["10", 
    RowBox[{"1", "/", "50"}]]}], "}"}]], "Output",
 ImageSize->{381, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5122760]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20432],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 " is logarithmically related to ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " for positive values:"
}], "ExampleText",
 CellID->19367069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->48447845],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Log", "[", "a", "]"}], "+", 
    RowBox[{"Log", "[", "b", "]"}], "+", 
    RowBox[{"Log", "[", "c", "]"}], "+", 
    RowBox[{"Log", "[", "d", "]"}]}], ")"}]}]], "Output",
 ImageSize->{238, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328698682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{"GeometricMean", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "]"}], "//", 
  "PowerExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243865852],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Log", "[", "a", "]"}], "+", 
    RowBox[{"Log", "[", "b", "]"}], "+", 
    RowBox[{"Log", "[", "c", "]"}], "+", 
    RowBox[{"Log", "[", "d", "]"}]}], ")"}]}]], "Output",
 ImageSize->{238, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100461257]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->365076494],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 " is logarithmically related to ",
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 " for positive values:"
}], "ExampleText",
 CellID->372791912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Log", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215621454],

Cell[BoxData[
 FractionBox["4", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], "+", 
   RowBox[{"Log", "[", "b", "]"}], "+", 
   RowBox[{"Log", "[", "c", "]"}], "+", 
   RowBox[{"Log", "[", "d", "]"}]}]]], "Output",
 ImageSize->{214, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->838410591]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Log", "[", 
    RowBox[{"GeometricMean", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "]"}]}], "//",
   "PowerExpand"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->156298055],

Cell[BoxData[
 FractionBox["4", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], "+", 
   RowBox[{"Log", "[", "b", "]"}], "+", 
   RowBox[{"Log", "[", "c", "]"}], "+", 
   RowBox[{"Log", "[", "d", "]"}]}]]], "Output",
 ImageSize->{214, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181491996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267073164],

Cell[TextData[{
 "For positive data, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["HarmonicMean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HarmonicMean"], "[", 
    StyleBox["d", "TI"], "]"}], "\[LessEqual]", 
   RowBox[{"GeometricMean", "[", 
    StyleBox["d", "TI"], "]"}], "\[LessEqual]", 
   RowBox[{
    ButtonBox["Mean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mean"], "[", 
    StyleBox["d", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->906033058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535336088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.13931670478284341`", ",", "0.8813433702540712`", ",", 
   "0.6492053904937163`", ",", "0.2495668746599662`", ",", 
   "0.23115379519067591`", ",", "0.210475698322788`", ",", 
   "0.813689938009154`", ",", "0.07726876410118777`", ",", 
   "0.7202633811261014`", ",", "0.09535339431199819`"}], "}"}]], "Output",
 ImageSize->{417, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27319991]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HarmonicMean", "[", "data", "]"}], "\[LessEqual]", 
  RowBox[{"GeometricMean", "[", "data", "]"}], "\[LessEqual]", 
  RowBox[{"Mean", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->735737269],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->988758692]
}, Open  ]],

Cell["Prove the inequality symbolically:", "ExampleText",
 CellID->418828296],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28077115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HarmonicMean", "[", "data", "]"}], "\[LessEqual]", 
    RowBox[{"GeometricMean", "[", "data", "]"}], "\[LessEqual]", 
    RowBox[{"Mean", "[", "data", "]"}]}], ",", 
   RowBox[{
    RowBox[{"Min", "[", "data", "]"}], "\[GreaterEqual]", "0"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->289465582],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->87219188]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19764],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HarmonicMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicMean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArithmeticGeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArithmeticGeometricMean"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27048],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with GeometricMean",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=GeometricMean"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->371139285],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->482366018]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeometricMean - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 45, 13.7062410}", "context" -> "System`", 
    "keywords" -> {"GM"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GeometricMean[list] gives the geometric mean of the values in list.", 
    "synonyms" -> {"geometric mean"}, "title" -> "GeometricMean", "type" -> 
    "Symbol", "uri" -> "ref/GeometricMean"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8209, 269, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->117780912]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26352, 969}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2165, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2788, 80, 1578, 37, 70, "ObjectNameGrid"],
Cell[4369, 119, 575, 18, 70, "Usage",
 CellID->28664]
}, Open  ]],
Cell[CellGroupData[{
Cell[4981, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5459, 159, 666, 26, 70, "Notes",
 CellID->26673],
Cell[6128, 187, 220, 7, 70, "Notes",
 CellID->28487],
Cell[6351, 196, 1489, 54, 70, "Notes",
 CellID->26555],
Cell[7843, 252, 329, 12, 70, "Notes",
 CellID->22482]
}, Closed]],
Cell[CellGroupData[{
Cell[8209, 269, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117780912],
Cell[CellGroupData[{
Cell[8594, 283, 148, 5, 70, "ExampleSection",
 CellID->146096829],
Cell[8745, 290, 68, 1, 70, "ExampleText",
 CellID->104718352],
Cell[CellGroupData[{
Cell[8838, 295, 176, 5, 28, "Input",
 CellID->148281672],
Cell[9017, 302, 271, 9, 36, "Output",
 CellID->287814119]
}, Open  ]],
Cell[9303, 314, 125, 3, 70, "ExampleDelimiter",
 CellID->252483224],
Cell[9431, 319, 81, 1, 70, "ExampleText",
 CellID->234915771],
Cell[CellGroupData[{
Cell[9537, 324, 382, 13, 70, "Input",
 CellID->36247193],
Cell[9922, 339, 372, 14, 43, "Output",
 CellID->396930572]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10343, 359, 216, 7, 70, "ExampleSection",
 CellID->21416],
Cell[10562, 368, 80, 1, 70, "ExampleText",
 CellID->379986608],
Cell[CellGroupData[{
Cell[10667, 373, 171, 5, 70, "Input",
 CellID->216003675],
Cell[10841, 380, 176, 5, 36, "Output",
 CellID->498759435]
}, Open  ]],
Cell[11032, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[11160, 393, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[11261, 398, 260, 8, 70, "Input",
 CellID->190699768],
Cell[11524, 408, 214, 6, 36, "Output",
 CellID->422488260]
}, Open  ]],
Cell[11753, 417, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[11881, 422, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[11994, 427, 197, 6, 70, "Input",
 CellID->315224713],
Cell[12194, 435, 208, 5, 36, "Output",
 CellID->102774299]
}, Open  ]],
Cell[CellGroupData[{
Cell[12439, 445, 251, 8, 70, "Input",
 CellID->594479966],
Cell[12693, 455, 802, 17, 88, "Output",
 CellID->356553394]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13544, 478, 239, 7, 70, "ExampleSection",
 CellID->28649],
Cell[13786, 487, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[14022, 499, 552, 18, 70, "Input",
 CellID->19878761],
Cell[14577, 519, 494, 17, 36, "Output",
 CellID->765704607]
}, Open  ]],
Cell[CellGroupData[{
Cell[15108, 541, 110, 3, 70, "Input",
 CellID->235263230],
Cell[15221, 546, 742, 25, 39, "Output",
 CellID->5122760]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16012, 577, 233, 7, 70, "ExampleSection",
 CellID->20432],
Cell[16248, 586, 354, 12, 70, "ExampleText",
 CellID->19367069],
Cell[CellGroupData[{
Cell[16627, 602, 200, 7, 70, "Input",
 CellID->48447845],
Cell[16830, 611, 397, 13, 51, "Output",
 CellID->328698682]
}, Open  ]],
Cell[CellGroupData[{
Cell[17264, 629, 248, 8, 70, "Input",
 CellID->243865852],
Cell[17515, 639, 397, 13, 51, "Output",
 CellID->100461257]
}, Open  ]],
Cell[17927, 655, 125, 3, 70, "ExampleDelimiter",
 CellID->365076494],
Cell[18055, 660, 371, 12, 70, "ExampleText",
 CellID->372791912],
Cell[CellGroupData[{
Cell[18451, 676, 236, 8, 70, "Input",
 CellID->215621454],
Cell[18690, 686, 346, 11, 53, "Output",
 CellID->838410591]
}, Open  ]],
Cell[CellGroupData[{
Cell[19073, 702, 275, 9, 70, "Input",
 CellID->156298055],
Cell[19351, 713, 346, 11, 53, "Output",
 CellID->181491996]
}, Open  ]],
Cell[19712, 727, 125, 3, 70, "ExampleDelimiter",
 CellID->267073164],
Cell[19840, 732, 512, 18, 70, "ExampleText",
 CellID->906033058],
Cell[CellGroupData[{
Cell[20377, 754, 157, 5, 70, "Input",
 CellID->535336088],
Cell[20537, 761, 484, 12, 54, "Output",
 CellID->27319991]
}, Open  ]],
Cell[CellGroupData[{
Cell[21058, 778, 243, 6, 70, "Input",
 CellID->735737269],
Cell[21304, 786, 161, 5, 36, "Output",
 CellID->988758692]
}, Open  ]],
Cell[21480, 794, 77, 1, 70, "ExampleText",
 CellID->418828296],
Cell[21560, 797, 171, 6, 70, "Input",
 CellID->28077115],
Cell[CellGroupData[{
Cell[21756, 807, 384, 11, 70, "Input",
 CellID->289465582],
Cell[22143, 820, 160, 5, 36, "Output",
 CellID->87219188]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22364, 832, 311, 9, 70, "SeeAlsoSection",
 CellID->19764],
Cell[22678, 843, 726, 26, 70, "SeeAlso",
 CellID->23713]
}, Open  ]],
Cell[CellGroupData[{
Cell[23441, 874, 314, 9, 70, "TutorialsSection",
 CellID->27048],
Cell[23758, 885, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[23951, 893, 305, 8, 70, "RelatedLinksSection"],
Cell[24259, 903, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24667, 920, 299, 8, 70, "MoreAboutSection"],
Cell[24969, 930, 155, 3, 70, "MoreAbout",
 CellID->371139285],
Cell[25127, 935, 151, 3, 70, "MoreAbout",
 CellID->482366018]
}, Open  ]],
Cell[25293, 941, 27, 0, 70, "History"],
Cell[25323, 943, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

