(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    108598,       2535]
NotebookOptionsPosition[    101912,       2318]
NotebookOutlinePosition[    103567,       2361]
CellTagsIndexPosition[    103480,       2356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TransformationFunction" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunction"], 
          "Rotate" :> Documentation`HelpLookup["paclet:ref/Rotate"], 
          "Translate" :> Documentation`HelpLookup["paclet:ref/Translate"], 
          "Scale" :> Documentation`HelpLookup["paclet:ref/Scale"], 
          "TransformationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/TransformationMatrix"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"TransformationFunction\"\>", 
       2->"\<\"Rotate\"\>", 3->"\<\"Translate\"\>", 4->"\<\"Scale\"\>", 
       5->"\<\"TransformationMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "Graphics Transformations" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTransformations"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Geometric Transforms\"\>", 
       2->"\<\"Graphics Transformations\"\>", 
       3->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GeometricTransformation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GeometricTransformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GeometricTransformation"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["tfun", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents the result of applying the transformation \
function ",
     Cell[BoxData[
      StyleBox["tfun", "TI"]], "InlineFormula"],
     " to the geometric objects corresponding to the primitives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GeometricTransformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GeometricTransformation"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]transforms geometric objects in ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " by effectively replacing every point ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], ".", 
       StyleBox["r", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GeometricTransformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GeometricTransformation"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["v", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]effectively replaces every point ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["m", "TI"], ".", 
        StyleBox["r", "TI"]}], "+", 
       StyleBox["v", "TI"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " remains unchanged under evaluation, but affects how ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is rendered."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeometricTransformation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricTransformation"]], "InlineFormula"],
 " works on lists of graphics primitives and directives in 2D and 3D."
}], "Notes",
 CellID->459519859],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["v", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " effectively applies an affine transform to ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->176684710],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["xx", "TI"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["yx", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["xy", "TI"]], ",", 
        SubscriptBox[
         StyleBox["m", "TI"], 
         StyleBox["yy", "TI"]]}], "}"}]}], "}"}]}], "]"}]], "InlineFormula"],
 " transforms the unit vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 " respectively to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["xx", "TI"]], ",", 
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["xy", "TI"]]}], "}"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["yx", "TI"]], ",", 
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["yy", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->100498538],

Cell[TextData[{
 "For different ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["spec", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " leaves fixed the following special points on the bounding box of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->20193],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell["center", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[
    "midpoint of the left side", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell[
    "midpoint of the right side", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "midpoint of the top", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "midpoint of the bottom", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       ButtonBox["Left",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Left"], ",", 
       ButtonBox["Top",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Top"]}], "}"}], Cell[", etc.", "TableText"]}],
     Cell["corners", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->1620],

Cell[TextData[{
 "For objects specified with scaled coordinates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GeometricTransformation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricTransformation"]], "InlineFormula"],
 " effectively applies its transformation to the corresponding ordinary \
coordinates. "
}], "Notes",
 CellID->21497],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " if possible replaces all ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " constructs by versions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in which the coordinates have explicitly been transformed. "
}], "Notes",
 CellID->13826],

Cell["The following option can be given: ", "Notes",
 CellID->31276],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContentSelectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContentSelectable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to allow contents to be selected ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->19790],

Cell[TextData[{
 "For matrices ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"], "[", 
   RowBox[{
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["1", "TR"]]}], "]"}], ",", 
    SubscriptBox[
     StyleBox["m", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["m", "TI"], 
      StyleBox["2", "TR"]], " ", ".", " ", 
     FormBox[
      SubscriptBox[
       StyleBox["m", "TI"], "1"],
      TraditionalForm]}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->435469436]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13604953],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->14664985],

Cell["Transform a 2D object: ", "ExampleText",
 CellID->206537146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GeometricTransformation", "[", 
   RowBox[{
    RowBox[{"Circle", "[", "]"}], ",", 
    RowBox[{"ShearingTransform", "[", 
     RowBox[{
      RowBox[{"Pi", "/", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88512482],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   CircleBox[{0, 0}], {{{1, 1}, {0, 1}}, {0, 0}}]]], "Output",
 ImageSize->{184, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->863555126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127033112],

Cell["Transform a 3D object: ", "ExampleText",
 CellID->16503954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"GeometricTransformation", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"ShearingTransform", "[", 
     RowBox[{
      RowBox[{"Pi", "/", "4"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125824664],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nHlY19Xyx0lCMdSkuIprLK65XM1K0/CoqFlmqbigiAu4X72uaRZcEQHL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    "], 
    {EdgeForm[None], Polygon3DBox[CompressedData["
1:eJw12VW0lVUYRmH+n+6OI6BiUSrSjYBgYFCKgiihlBKiGDQYGLSBgkWXLYqC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      "]], 
     Polygon3DBox[{{721, 40, 39}, {721, 39, 38}, {721, 38, 37}, {721, 37, 
      36}, {721, 36, 35}, {721, 35, 34}, {721, 34, 33}, {721, 33, 32}, {721, 
      32, 31}, {721, 31, 30}, {721, 30, 29}, {721, 29, 28}, {721, 28, 27}, {
      721, 27, 26}, {721, 26, 25}, {721, 25, 24}, {721, 24, 23}, {721, 23, 
      22}, {721, 22, 21}, {721, 21, 20}, {721, 20, 19}, {721, 19, 18}, {721, 
      18, 17}, {721, 17, 16}, {721, 16, 15}, {721, 15, 14}, {721, 14, 13}, {
      721, 13, 12}, {721, 12, 11}, {721, 11, 10}, {721, 10, 9}, {721, 9, 8}, {
      721, 8, 7}, {721, 7, 6}, {721, 6, 5}, {721, 5, 4}, {721, 4, 3}, {721, 3,
       2}, {721, 2, 1}, {721, 1, 40}, {722, 681, 682}, {722, 682, 683}, {722, 
      683, 684}, {722, 684, 685}, {722, 685, 686}, {722, 686, 687}, {722, 687,
       688}, {722, 688, 689}, {722, 689, 690}, {722, 690, 691}, {722, 691, 
      692}, {722, 692, 693}, {722, 693, 694}, {722, 694, 695}, {722, 695, 
      696}, {722, 696, 697}, {722, 697, 698}, {722, 698, 699}, {722, 699, 
      700}, {722, 700, 701}, {722, 701, 702}, {722, 702, 703}, {722, 703, 
      704}, {722, 704, 705}, {722, 705, 706}, {722, 706, 707}, {722, 707, 
      708}, {722, 708, 709}, {722, 709, 710}, {722, 710, 711}, {722, 711, 
      712}, {722, 712, 713}, {722, 713, 714}, {722, 714, 715}, {722, 715, 
      716}, {722, 716, 717}, {722, 717, 718}, {722, 718, 719}, {722, 719, 
      720}, {722, 720, 681}}]},
    VertexColors->Automatic,
    VertexNormals->CompressedData["
1:eJx1nHdUldfSxolExS6Ray80e4lGExs49pioiYoFRSxgj8ZYYsWICFiCFcWa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     "]],
   GeometricTransformation[
    Sphere[{0, 0, 0}], {{{1, 0, 1}, {0, 1, 0}, {0, 0, 1}}, {0, 0, 
     0}}]]]], "Output",
 ImageSize->{184, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110160528,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->437597636],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->134375656],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147364059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{".8", ",", ".5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".8"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", "0"}], "}"}]}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100410208],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {{{0.8, 0.5}, {0, 0.8}}, {
     0.5, 0}}]}]], "Output",
 ImageSize->{184, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304622044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->346821823],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->44758480],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396728693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{".8", ",", ".5", ",", ".5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", ".8", ",", ".5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", ".8"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".5", ",", ".5", ",", "0"}], "}"}]}], "}"}]}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134864313],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     GraphicsComplex3DBox[{{0.5, 0.5, 0.}, {1., 1., 0.8}, {1., 1.3, 0.}, {1.5,
       1.8, 0.8}, {1.3, 0.5, 0.}, {1.8, 1., 0.8}, {1.8, 1.3, 0.}, {2.3, 1.8, 
      0.8}}, Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8,
        7}, {1, 2, 4, 3}, {5, 7, 8, 6}}],
      VertexColors->Automatic,
      VertexNormals->Automatic], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], Point3DBox[{0.5, 0.5, 0.}]}, 
      {RGBColor[0., 1., 0.], Point3DBox[{2.3, 1.8, 0.8}]}}},
    GeometricTransformation[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, {{{0.8, 0.5, 0.5}, {0, 0.8, 0.5}, {0, 0, 0.8}}, {
      0.5, 0.5, 0}}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127307014,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360527293],

Cell["Objects with scaled coordinates:", "ExampleText",
 CellID->121132598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"GeometricTransformation", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], "]"}], ",", 
     RowBox[{"ScalingTransform", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124550963],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   CircleBox[Scaled[{1, 0}]], {{{0.5, 0.}, {0., 0.5}}, {0, 0}}],
  Axes->True]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172633204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->687793207],

Cell["Keep the rightmost point of the circle fixed:", "ExampleText",
 CellID->547905771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ScalingMatrix", "[", 
          RowBox[{"{", 
           RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", "Right"}], "}"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305242705],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{0.5, 0.}, {0., 0.5}}, Right}]},
  Axes->True]], "Output",
 ImageSize->{184, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331324307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->689848008],

Cell["Create nested transformations:", "ExampleText",
 CellID->128265778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"GeometricTransformation", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"Cylinder", "[", "]"}], ",", 
       RowBox[{"ScalingMatrix", "[", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"ReflectionMatrix", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183769040],

Cell[BoxData[
 Graphics3DBox[Text3DBox[
   Graphics3DBox[
    InterpretationBox[GraphicsComplex3DBox[CompressedData["
1:eJztld9Lk1EcxjcjoR9kBNpFEloWFGmB5aCEY/aDMCpTsyYFFmYrxEU3RWRb
RWR6s3UhCCpv3VRQ0E1ZOvoW3QQ6ojID101Qo9ZFNab2Y2xF53lOvP0BXb2D
cXjhvN/3+Xyf73NO8SF/3eEcl8tl/f7PcPH3RenVqsSzLP2Uv7wjk1BVH3NT
ExWXVX967mD9zqR45/haOgvjqujO0MjivJvqZUn76+oVKXGFDyQ+nHqrrL6C
gmx8WN2L+nsXXZyUrdvzpx8cnFAtpVa4+MRTdeF6bu0O75Qc63SXP3n4Qvmw
jm4ItA5YU8J9fI/7b6Auv8P61LEPusagh7qXgIP6yZn98/usyBvEfv/sybbH
waQ682zL0NXehMxH/fofI9Hhrynlbb51sqf7nZAz6Hne1b1pWsVOr8tb8C1m
9JfdXn8+fOS7WnW0a3/d7lEhZ7xfle+q/cl+RzaDU9dPqyK933BW9AzMC23M
qHFd33AGVl6bdcmTVY1aj+EsTS6suRLNqg6tX9k5XVV8bgdnGfb36f6oPeBk
/Ve6n+osOD3Qc1f333A2QD/8Mpxco9pfw7ka73E/OdnPQdSnjgbogr+Gk37B
X8PpxlxzJecy9CmI/gRRvwl9bUI/qScHPrxB/8lZA9/Wwi9ytsFnLeN+5Rpw
+jAXhZiHc+DkXI9hfsjJuYa/chycnFPOJ+cX3I/4DH8F3ML5R31BX4X5Rd8F
3MJ8wV+8lxbmEbxmZX65j+9xP+vyO6xPHdTF/FI3/BV7fv9ycsU8CHIg7A/8
FfgrzC/1uLW/ErP1Py3btL/C/JIT5xbPkQjmWOCvML/khL8ybpufFM8tYX7J
CX+F+XXbOK0I81sCTpxzwvw2gpP1md+Z4AxBD/NLzmboZx7J2YqV+SUnzi2z
n5zZkP4O80sdOLfoL+fY+GXPrxXJaE5hfsnJuWZ+cT4LzmdhfnE+SwA+ML/k
5Hwyv+R8D5+Z32pw4twS5jcDTs4R87sXnJxr5rcYnJzTf/Lr3L/O/evcv879
69y/zv3r3L//8f79BRAQkMA=
      "], {
       {EdgeForm[None], 
        Polygon3DBox[{{41, 42, 2, 1}, {42, 43, 3, 2}, {43, 44, 4, 3}, {44, 45,
          5, 4}, {45, 46, 6, 5}, {46, 47, 7, 6}, {47, 48, 8, 7}, {48, 49, 9, 
         8}, {49, 50, 10, 9}, {50, 51, 11, 10}, {51, 52, 12, 11}, {52, 53, 13,
          12}, {53, 54, 14, 13}, {54, 55, 15, 14}, {55, 56, 16, 15}, {56, 57, 
         17, 16}, {57, 58, 18, 17}, {58, 59, 19, 18}, {59, 60, 20, 19}, {60, 
         61, 21, 20}, {61, 62, 22, 21}, {62, 63, 23, 22}, {63, 64, 24, 23}, {
         64, 65, 25, 24}, {65, 66, 26, 25}, {66, 67, 27, 26}, {67, 68, 28, 
         27}, {68, 69, 29, 28}, {69, 70, 30, 29}, {70, 71, 31, 30}, {71, 72, 
         32, 31}, {72, 73, 33, 32}, {73, 74, 34, 33}, {74, 75, 35, 34}, {75, 
         76, 36, 35}, {76, 77, 37, 36}, {77, 78, 38, 37}, {78, 79, 39, 38}, {
         79, 80, 40, 39}, {80, 41, 1, 40}}]}, 
       Polygon3DBox[{{81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
        95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
        110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120}, {160, 159, 
        158, 157, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 
        144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 
        130, 129, 128, 127, 126, 125, 124, 123, 122, 121}}]},
      VertexColors->Automatic,
      VertexNormals->CompressedData["
1:eJztkztLA0EQgE8FK0Gw1SKChYJFCq08GBAsFY1vsRBBwcaUggYjPhrtheCD
WNlYWIgRCewfiAjGEDCtINgoosFCEsV8s3ABewN7ED6Y25uZLzPbPh+NLNR7
npf8+TV4+rwKNOXf58XEbweuTxLPAs3hV1NqdOjNTM2drezvPQo0dx3L+f6u
d/Ow2tvc8lkQaC5voonWnQ/TubQ7GxnJCDSbp43Dg9NFU6mX9GE60xdfPE4W
9bz9Ts/nyQtF80/SB5Qs/azTNxTtX/2g9T7iPZQY39+TD1pvrQ+tt/YLpRsf
9YOi3luchxLCuzp/Du/qfibw/qN/qcMPSgnvDfygHPDdGH5Q68kTflAu6CuM
Xzg4L/zO09BXb/ULBffB+uWC+2P9oGG+1i8W3E/rB43ut77XPVBvzad7M0M9
ra9zKNCf9qtz7sFH/XTOlbpX/jbnoWnDO0V+aLJ46/+tcx7HW+eqc17D291f
d3/d/a3d+6t7XK7ydnEXd/GaiVuWgudc3MVd/B/HvwEPHcWz
       "]],
     GeometricTransformation[
      GeometricTransformation[
       Cylinder[{{0, 0, -1}, {0, 0, 1}}], {{
         Rational[4, 3], 
         Rational[1, 3], 
         Rational[1, 3]}, {
         Rational[1, 3], 
         Rational[4, 3], 
         Rational[1, 3]}, {
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[4, 3]}}], {{
        Rational[1, 3], 
        Rational[-2, 3], 
        Rational[-2, 3]}, {
        Rational[-2, 3], 
        Rational[1, 3], 
        Rational[-2, 3]}, {
        Rational[-2, 3], 
        Rational[-2, 3], 
        Rational[1, 3]}}]]], {{0., 0., 0.}}],
  Boxed->False]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68124256,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->257647671],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"m", ",", "v"}], "}"}], TraditionalForm]], "InlineMath"],
 " as the second argument is the same as using ",
 Cell[BoxData[
  ButtonBox["AffineTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AffineTransform"]], "InlineFormula"],
 "[",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"m", ",", "v"}], "}"}], TraditionalForm]], "InlineMath"],
 "]:"
}], "ExampleText",
 CellID->187950860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GeometricTransformation", "[", 
   RowBox[{"x", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], "]"}], "\[Equal]", 
  RowBox[{"GeometricTransformation", "[", 
   RowBox[{"x", ",", 
    RowBox[{"AffineTransform", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "}"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44494065],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12353146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188562752],

Cell[TextData[{
 "When possible, ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " will perform the transformations explicitly:"
}], "ExampleText",
 CellID->245810616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "@", 
  RowBox[{"GeometricTransformation", "[", 
   RowBox[{
    RowBox[{"Cylinder", "[", "]"}], ",", 
    RowBox[{"ScalingTransform", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675226235],

Cell[BoxData[
 RowBox[{"Cylinder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486106466]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->567654697],

Cell["Rotating and moving a cuboid along a space curve:", "ExampleText",
 CellID->96242850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"Cuboid", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "1.5", ",", ".2"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"RotationMatrix", "[", 
          RowBox[{"a", ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "a", "]"}], ",", 
           RowBox[{"Sin", "[", "a", "]"}], ",", "a"}], "}"}]}], "}"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", 
       RowBox[{"4", "Pi"}], ",", ".2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147804169],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{127, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61840269]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Translate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Translate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with GeometricTransformation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
GeometricTransformation"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->520244018],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->628339575],

Cell[TextData[ButtonBox["Graphics Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTransformations"]], "MoreAbout",
 CellID->632176612],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->219206104]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeometricTransformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 45, 14.2687554}", "context" -> "System`", 
    "keywords" -> {
     "affine transformation", "geometric transformation", 
      "linear transformation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GeometricTransformation[g, tfun] represents the result of applying the \
transformation function tfun to the geometric objects corresponding to the \
primitives g. GeometricTransformation[g, m] transforms geometric objects in g \
by effectively replacing every point r by m.r. GeometricTransformation[g, {m, \
v}] effectively replaces every point r by m.r + v.", 
    "synonyms" -> {"geometric transformation"}, "title" -> 
    "GeometricTransformation", "type" -> "Symbol", "uri" -> 
    "ref/GeometricTransformation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15065, 494, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13604953]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 103337, 2349}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2001, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2624, 71, 1588, 37, 70, "ObjectNameGrid"],
Cell[4215, 110, 2222, 70, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6474, 185, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6952, 202, 437, 14, 70, "Notes",
 CellID->1067943069],
Cell[7392, 218, 268, 7, 70, "Notes",
 CellID->459519859],
Cell[7663, 227, 481, 17, 70, "Notes",
 CellID->176684710],
Cell[8147, 246, 1511, 58, 70, "Notes",
 CellID->100498538],
Cell[9661, 306, 588, 21, 70, "Notes",
 CellID->20193],
Cell[10252, 329, 1499, 42, 70, "2ColumnTableMod",
 CellID->1620],
Cell[11754, 373, 579, 19, 70, "Notes",
 CellID->21497],
Cell[12336, 394, 747, 25, 70, "Notes",
 CellID->13826],
Cell[13086, 421, 68, 1, 70, "Notes",
 CellID->31276],
Cell[13157, 424, 691, 18, 70, "3ColumnTableMod",
 CellID->19790],
Cell[13851, 444, 1177, 45, 70, "Notes",
 CellID->435469436]
}, Closed]],
Cell[CellGroupData[{
Cell[15065, 494, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13604953],
Cell[CellGroupData[{
Cell[15449, 508, 147, 5, 70, "ExampleSection",
 CellID->14664985],
Cell[15599, 515, 66, 1, 70, "ExampleText",
 CellID->206537146],
Cell[CellGroupData[{
Cell[15690, 520, 427, 13, 28, "Input",
 CellID->88512482],
Cell[16120, 535, 252, 8, 150, "Output",
 CellID->863555126]
}, Open  ]],
Cell[16387, 546, 125, 3, 70, "ExampleDelimiter",
 CellID->127033112],
Cell[16515, 551, 65, 1, 70, "ExampleText",
 CellID->16503954],
Cell[CellGroupData[{
Cell[16605, 556, 453, 14, 70, "Input",
 CellID->125824664],
Cell[17061, 572, 47825, 791, 191, 23417, 386, "CachedBoxData", "BoxData", \
"Output",
 CellID->110160528]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64935, 1369, 220, 7, 70, "ExampleSection",
 CellID->437597636],
Cell[65158, 1378, 80, 1, 70, "ExampleText",
 CellID->134375656],
Cell[65241, 1381, 620, 20, 70, "Input",
 CellID->147364059],
Cell[CellGroupData[{
Cell[65886, 1405, 762, 26, 70, "Input",
 CellID->100410208],
Cell[66651, 1433, 634, 15, 126, "Output",
 CellID->304622044]
}, Open  ]],
Cell[67300, 1451, 125, 3, 70, "ExampleDelimiter",
 CellID->346821823],
Cell[67428, 1456, 79, 1, 70, "ExampleText",
 CellID->44758480],
Cell[67510, 1459, 637, 20, 70, "Input",
 CellID->396728693],
Cell[CellGroupData[{
Cell[68172, 1483, 968, 30, 70, "Input",
 CellID->134864313],
Cell[69143, 1515, 4343, 84, 166, 1180, 28, "CachedBoxData", "BoxData", \
"Output",
 CellID->127307014]
}, Open  ]],
Cell[73501, 1602, 125, 3, 70, "ExampleDelimiter",
 CellID->360527293],
Cell[73629, 1607, 75, 1, 70, "ExampleText",
 CellID->121132598],
Cell[CellGroupData[{
Cell[73729, 1612, 472, 14, 70, "Input",
 CellID->124550963],
Cell[74204, 1628, 280, 9, 197, "Output",
 CellID->172633204]
}, Open  ]],
Cell[74499, 1640, 125, 3, 70, "ExampleDelimiter",
 CellID->687793207],
Cell[74627, 1645, 88, 1, 70, "ExampleText",
 CellID->547905771],
Cell[CellGroupData[{
Cell[74740, 1650, 536, 17, 70, "Input",
 CellID->305242705],
Cell[75279, 1669, 294, 9, 164, "Output",
 CellID->331324307]
}, Open  ]],
Cell[75588, 1681, 125, 3, 70, "ExampleDelimiter",
 CellID->689848008],
Cell[75716, 1686, 73, 1, 70, "ExampleText",
 CellID->128265778],
Cell[CellGroupData[{
Cell[75814, 1691, 614, 17, 70, "Input",
 CellID->183769040],
Cell[76431, 1710, 13487, 238, 216, 3753, 74, "CachedBoxData", "BoxData", \
"Output",
 CellID->68124256]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89967, 1954, 237, 7, 70, "ExampleSection",
 CellID->257647671],
Cell[90207, 1963, 486, 18, 70, "ExampleText",
 CellID->187950860],
Cell[CellGroupData[{
Cell[90718, 1985, 858, 28, 70, "Input",
 CellID->44494065],
Cell[91579, 2015, 160, 5, 36, "Output",
 CellID->12353146]
}, Open  ]],
Cell[91754, 2023, 125, 3, 70, "ExampleDelimiter",
 CellID->188562752],
Cell[91882, 2028, 238, 8, 70, "ExampleText",
 CellID->245810616],
Cell[CellGroupData[{
Cell[92145, 2040, 311, 9, 70, "Input",
 CellID->675226235],
Cell[92459, 2051, 417, 15, 36, "Output",
 CellID->486106466]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[92925, 2072, 228, 7, 70, "ExampleSection",
 CellID->567654697],
Cell[93156, 2081, 91, 1, 70, "ExampleText",
 CellID->96242850],
Cell[CellGroupData[{
Cell[93272, 2086, 984, 29, 70, "Input",
 CellID->147804169],
Cell[94259, 2117, 4380, 76, 70, "Output",
 Evaluatable->False,
 CellID->61840269]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98700, 2200, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[99019, 2211, 1234, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[100290, 2260, 305, 8, 70, "RelatedLinksSection"],
Cell[100598, 2270, 388, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101023, 2287, 319, 9, 70, "MoreAboutSection",
 CellID->520244018],
Cell[101345, 2298, 151, 3, 70, "MoreAbout",
 CellID->628339575],
Cell[101499, 2303, 159, 3, 70, "MoreAbout",
 CellID->632176612],
Cell[101661, 2308, 179, 3, 70, "MoreAbout",
 CellID->219206104]
}, Open  ]],
Cell[101855, 2314, 27, 0, 70, "History"],
Cell[101885, 2316, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

