(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21671,        813]
NotebookOptionsPosition[     16694,        643]
NotebookOutlinePosition[     17915,        679]
CellTagsIndexPosition[     17830,        674]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Zeta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Glaisher", "ObjectName",
 CellID->26584],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Glaisher",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Glaisher"]], "InlineFormula"],
     "\[LineSeparator]is Glaisher's constant with numerical value ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[TildeEqual]", "1.28243"}], TraditionalForm]], "InlineMath"],
     
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Mathematical constant treated as numeric by ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and as a constant by ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3586],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Glaisher",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glaisher"]], "InlineFormula"],
 " can be evaluated to any numerical precision using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31269],

Cell[TextData[{
 "Glaisher's constant ",
 Cell[BoxData[
  StyleBox["A", "TI"]], "InlineFormula"],
 " satisfies ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"log", "(", "A", ")"}], "=", 
    RowBox[{
     FractionBox["1", "12"], "-", 
     RowBox[{
      SuperscriptBox["\[Zeta]", "\[Prime]"], "(", 
      RowBox[{"-", "1"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["\[Zeta]", TraditionalForm]], "InlineMath"],
 " is the Riemann zeta function. "
}], "Notes",
 CellID->26248]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130807083],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->615656890],

Cell["Evaluate to any precision:", "ExampleText",
 CellID->27669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Glaisher", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->893],

Cell[BoxData["1.\
282427129100622636875342568869791727767688927325001189441427082399`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24906441]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19104],

Cell["Do an exact numerical computation:", "ExampleText",
 CellID->484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"Glaisher", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2943],

Cell[BoxData["63572555914"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27335920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->505218738],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->416236161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Glaisher", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105539767],

Cell[BoxData[
 FormBox[
  TagBox["A",
   Function[{}, Glaisher]], TraditionalForm]], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->9746064]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Derivatives of zeta functions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Zeta", "'"}], "[", 
  RowBox[{"-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], "-", 
  RowBox[{"Log", "[", "Glaisher", "]"}]}]], "Output",
 ImageSize->{126, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95746309]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"1", ",", "0"}], "]"}], "[", "Zeta", "]"}], "[", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"1", "/", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "96"]}], "+", 
  FractionBox["Catalan", 
   RowBox[{"4", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{"Log", "[", "Glaisher", "]"}], "8"]}]], "Output",
 ImageSize->{204, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->375749837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integrals containing gamma functions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"LogGamma", "[", 
     RowBox[{"t", "+", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", 
      RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", "128", "]"}]}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"Log", "[", "Glaisher", "]"}]}], "+", 
       RowBox[{"Log", "[", "\[Pi]", "]"}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{324, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206135521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Get ",
 Cell[BoxData[
  ButtonBox["Glaisher",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glaisher"]], "InlineFormula"],
 " from an infinite product:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"k", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"k", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"EulerGamma", " ", 
      SuperscriptBox["\[Pi]", "2"]}], "6"]}]], " ", 
  SuperscriptBox["Glaisher", 
   RowBox[{"2", " ", 
    SuperscriptBox["\[Pi]", "2"]}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", " ", "\[Pi]"}], ")"}], 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["\[Pi]", "2"], "6"]}]]}]], "Output",
 ImageSize->{216, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288710645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Get ",
 Cell[BoxData[
  ButtonBox["Glaisher",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glaisher"]], "InlineFormula"],
 " from infinite sums:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", "k", "]"}], "/", 
    RowBox[{"k", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "EulerGamma"}], " ", 
     SuperscriptBox["\[Pi]", "2"]}], "-", 
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Log", "[", "2", "]"}]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Log", "[", "Glaisher", "]"}]}], "-", 
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Log", "[", "\[Pi]", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{407, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395125309]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Various symbolic relations are automatically used:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "<", "Glaisher", "<", "2"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149967731]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["Terms in the continued fraction:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{
   RowBox[{"ContinuedFraction", "[", 
    RowBox[{"Glaisher", ",", "200"}], "]"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd1klu1UAQxvESK5YsWLBgYSyEEEKIeYY0eQxhCMNjCBAgzksCYQVH6KP4
KL3kGD5CjgDoff9I9SGh0u9VtavbbrdzavFrvnckIv78+/8/Lv8drOQYZRmO
WiR/zHy85HjC8ifNnbm3PqcVzyqeKbkvvzP+3NIHv/X7ectfMF+UWeelkud5
2eqvLF0f6PeriqzzmtVfl3vFGzb/m9b/lo2/bb5j9Xctf8983+pXFLkPRVH3
u2LGs07N83DdXG9Vv88UV238zK4/s/zDfL1qjkeK2k8VM/6xjTfHk1xfMftr
zea3luvjqeVxr/jMro+1D+O55c3xwvKY+a0rsv51y7+08Zj1v7I85r16nfMF
cz+x1tMw78eb7ILpZ26Y82Ge+5V5rq/mhnkv39r8sd6binXONKuPdzbeXM3N
HO9tvLli+mOezwcbj3U+VMs3zPPfUOyXsWD1qxu5vmHm/9H6mytmPOa8+2Tj
zRXrnG6Wj8/5+sVcMfsPc35uZpfNXF+x7nez+viS8wUzf3Mzx9fsgrU/K1a/
Zo5vinofCqY/Zv7m2LL+5op5fpjxg+apc72Tuz3NR+Y7OWCubx7lYaF+lp/M
sS3reXXbOV/MA+b9wDrPRsz9wlr/ZPlY5Ot1WN/Vssj1g7li1m9uVj9ZPnby
/LqdnC/mAdMfa/+MVt+sfjLHbh7f7eZ8wfS3fMX6bo5W3zD33/KhfXa4/2T+
bihY+2PAOn8q7tUf8/wx+8/y8T3nO8z7aPkBcz5h7ZfR6pt5wvT/keffmQum
P9bfb9Xyo7lh7r/lYz/Pp8P6fpT9XD+Yq3nE+v42rOc3Yc6/n4p9+QvqdEHv

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224131295]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20027],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28148]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12137],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->2397]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->424],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Glaisher-KinkelinConstant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/Glaisher/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->549021524],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->74988039]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Glaisher - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 45, 16.1281780}", "context" -> "System`", 
    "keywords" -> {"Kinkelin constant"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Glaisher is Glaisher's constant with numerical value \\[TildeEqual] \
1.28243. ", "synonyms" -> {}, "title" -> "Glaisher", "type" -> "Symbol", 
    "uri" -> "ref/Glaisher"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4717, 168, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->130807083]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17687, 667}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1728, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2351, 72, 46, 1, 70, "ObjectName",
 CellID->26584],
Cell[2400, 75, 557, 18, 70, "Usage",
 CellID->27252]
}, Open  ]],
Cell[CellGroupData[{
Cell[2994, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3472, 115, 349, 13, 70, "Notes",
 CellID->3586],
Cell[3824, 130, 329, 12, 70, "Notes",
 CellID->31269],
Cell[4156, 144, 524, 19, 70, "Notes",
 CellID->26248]
}, Closed]],
Cell[CellGroupData[{
Cell[4717, 168, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130807083],
Cell[CellGroupData[{
Cell[5102, 182, 148, 5, 70, "ExampleSection",
 CellID->615656890],
Cell[5253, 189, 65, 1, 70, "ExampleText",
 CellID->27669],
Cell[CellGroupData[{
Cell[5343, 194, 122, 4, 28, "Input",
 CellID->893],
Cell[5468, 200, 233, 7, 36, "Output",
 CellID->24906441]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5750, 213, 216, 7, 70, "ExampleSection",
 CellID->19104],
Cell[5969, 222, 71, 1, 70, "ExampleText",
 CellID->484],
Cell[CellGroupData[{
Cell[6065, 227, 128, 4, 70, "Input",
 CellID->2943],
Cell[6196, 233, 167, 5, 36, "Output",
 CellID->27335920]
}, Open  ]],
Cell[6378, 241, 125, 3, 70, "ExampleDelimiter",
 CellID->505218738],
Cell[6506, 246, 203, 7, 70, "ExampleText",
 CellID->416236161],
Cell[CellGroupData[{
Cell[6734, 257, 114, 3, 70, "Input",
 CellID->105539767],
Cell[6851, 262, 239, 8, 50, "Output",
 CellID->9746064]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7139, 276, 207, 6, 70, "ExampleSection"],
Cell[7349, 284, 53, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7427, 288, 116, 4, 70, "Input"],
Cell[7546, 294, 239, 8, 51, "Output",
 CellID->95746309]
}, Open  ]],
Cell[CellGroupData[{
Cell[7822, 307, 237, 8, 70, "Input"],
Cell[8062, 317, 346, 12, 52, "Output",
 CellID->375749837]
}, Open  ]],
Cell[8423, 332, 105, 2, 70, "ExampleDelimiter"],
Cell[8531, 336, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8616, 340, 278, 9, 70, "Input"],
Cell[8897, 351, 526, 18, 51, "Output",
 CellID->206135521]
}, Open  ]],
Cell[9438, 372, 105, 2, 70, "ExampleDelimiter"],
Cell[9546, 376, 192, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[9763, 387, 274, 9, 70, "Input"],
Cell[10040, 398, 573, 20, 46, "Output",
 CellID->288710645]
}, Open  ]],
Cell[10628, 421, 105, 2, 70, "ExampleDelimiter"],
Cell[10736, 425, 186, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[10947, 436, 239, 8, 70, "Input"],
Cell[11189, 446, 644, 21, 51, "Output",
 CellID->395125309]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11882, 473, 217, 6, 70, "ExampleSection"],
Cell[12102, 481, 73, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12200, 485, 89, 2, 70, "Input"],
Cell[12292, 489, 161, 5, 36, "Output",
 CellID->149967731]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12502, 500, 208, 6, 70, "ExampleSection"],
Cell[12713, 508, 55, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12793, 512, 225, 6, 70, "Input"],
Cell[13021, 520, 1270, 28, 133, "Output",
 CellID->224131295]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14352, 555, 311, 9, 70, "SeeAlsoSection",
 CellID->20027],
Cell[14666, 566, 188, 6, 70, "SeeAlso",
 CellID->28148]
}, Open  ]],
Cell[CellGroupData[{
Cell[14891, 577, 314, 9, 70, "TutorialsSection",
 CellID->12137],
Cell[15208, 588, 153, 3, 70, "Tutorials",
 CellID->2397]
}, Open  ]],
Cell[CellGroupData[{
Cell[15398, 596, 319, 9, 70, "RelatedLinksSection",
 CellID->424],
Cell[15720, 607, 196, 4, 70, "RelatedLinks"],
Cell[15919, 613, 190, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16146, 622, 319, 9, 70, "MoreAboutSection",
 CellID->549021524],
Cell[16468, 633, 154, 3, 70, "MoreAbout",
 CellID->74988039]
}, Open  ]],
Cell[16637, 639, 27, 0, 70, "History"],
Cell[16667, 641, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

