(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     86823,       1913]
NotebookOptionsPosition[     81959,       1751]
NotebookOutlinePosition[     83294,       1788]
CellTagsIndexPosition[     83208,       1783]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"], "Specularity" :> 
          Documentation`HelpLookup["paclet:ref/Specularity"], "Lighting" :> 
          Documentation`HelpLookup["paclet:ref/Lighting"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RGBColor\"\>", 
       2->"\<\"ColorFunction\"\>", 3->"\<\"Specularity\"\>", 
       4->"\<\"Lighting\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Colors\"\>", 3->"\<\"Graphics Directives\"\>", 
       4->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Glow", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Glow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Glow"], "[", 
       StyleBox["col", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that surfaces \
of 3D graphics objects which follow are to be taken to glow with color ",
     Cell[BoxData[
      StyleBox["col", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Glow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Glow"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that there is no glow. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16769]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Glow is added to diffuse and specular reflection components to determine the \
final rendered color of a surface. \
\>", "Notes",
 CellID->14709],

Cell["\<\
Glow is a color component independent of simulated illumination. \
\>", "Notes",
 CellID->27956],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"], "[", 
   ButtonBox["Black",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Black"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22421],

Cell[TextData[{
 "A surface can be specified as having an absolute color ",
 Cell[BoxData[
  StyleBox["col", "TI"]], "InlineFormula"],
 " by giving the combination of directives ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"], "[", 
   StyleBox["col", "TI"], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Black",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Black"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"], "[", "0", "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->15945]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->646590555],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->282013339],

Cell["\<\
Cylinder that glows red, but has a black surface that reflects no light:\
\>", "ExampleText",
 CellID->275919926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Glow", "[", "Red", "]"}], ",", "Black", ",", 
    RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7628988],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    RGBColor[1, 0, 0]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->923289109,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzlmWtvEzkUhqfJTJp7Sim0pVACbCm0QMu9QrAsXWn5xI+o2Egg7QoE/H0L
fC7OeF6fIRP4hIiamXh83sf28XVO35x9eTf7/+zL+7dn09efzj6+e//28/Sf
D5/8o/ZKlmX/+u9/W5n//dX/4u+pcy5rz2Yzx5/sKl2yl/5a+IdTTr3w15ZP
tfUuT5/5KwmLiOCvSjhR266Z+0Rz+5TK56X7H7uc/1DZQ0oV83xlXGGb+8qY
fMfmSG3WTZvLbHNHy9oAT7Qgvc3WB0rcbGS9r+xtyG1Deout95Td8feJ75zV
RqobUe8UXjXxz3J/R+sc0tyCbKo1pPq3vWrLP6N7bFmA8iIrd+NRkVFaVf5W
r9rR8oJqSioeAZl+UHeBddtamuRSEfxX0ctfy2i7MDYjBlndCDVWVpsuhVS/
HCVS7w2tdwfKR0ZuMqT8dRfPiZLxBzAKBs0ZPkP0a6rvgX4P9J1Ez2M7G2kb
+qC/CfoueRE8eI4JA63BEAj7BkHypf3nWd1T9QjUt0DdAzXP3qyr6jGob5tq
kZY1x3UIW3CwoA4RpbJeDRZw+oYvxyUrWZOob+4ajLgua0mLnLEC4Ug9tKiV
UcIrabLq4LqBM/BHuTjP8wXcgUvn9dAkdyBNqnsGDVs2MGmYbv0UDUZQDQt9
0zdZPUhbJPQFa5KngzjtlTgCm5OG87Qo7xgk0ycJaVTjmx9XD+t6t7Ea51yn
1gdHjdXY11T2cc2YyMPu0VjF+7p/ZM7i5hSfNOdvYwKO1V9djf4cG2qrz5dT
Y9m5qaaa3/8N1Lj6j39p9bHOq4mhateqaGWW8/rism0K+fxQKZ0G410o1hnm
llL6QOkvRaHTL61rY6D0lqJc07qs/xRlVykXgdJdirKjlEtAWXWZ7OR4ajMp
m+oX6uluRm8g6Sm/OW0j9HhojY6ZmFjUEuPzNJ0+19jcf2fh43/7dzQ5+PUM
LnrP5o6cnh3nXO5Xbe3yTDp5DhLmvjJzYOaNmV3tG5qN8r5ZJbUbkwrtl/jk
e6xUnOMto39WTGprTqVMUT8OfhDajN7B63nV0RNWHKrVid6rb92LOWRBEt4C
5zr6PI96qClt1ZXRJ/FT6b/nIS28BrRcabJblz57CSTsUyVVzvOUjW+Ff8Uc
55JTgXAIM4IavGqkxP6Kyz41CCv+Nymro4c6p1YtJoYa9xds++l83PFnJifJ
KoP83zL89nei7SRaPH1jdKUJw37nA0YS1SkSTohRoD72ogt7B6wNVRKOWXw7
RiKerGJiGbcpgPIKKJxfxKOZ2imMkVGCOcZjH1ZiJcIZL+D8CZw05iKciSvj
j+bsV33sybI155KWZoZ2qGWIJsTvsMYnoBpXfJ/Elb3hU1CEyJwoLtSU8wBU
1KvkGDljJhHpaCcJa6+8O24ZPUBWB7ovUs+RayS6EiKvvEZmEq2UHVmYEhnb
ASZZ06S74sJeK0yJZF52ZSSUphWd2gq1IuYlttoFJs50qvdaVBP538FVV0bR
Y+vzWoPrbHUNcnFGTpS5z9bXjZJxzSPrQ7YOEXkrIkc1OGKrPRiXoe2POPem
v3Z86kRG5so3D25bLw==\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->163473823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " gives overall surface color that is independent of any ",
 Cell[BoxData[
  ButtonBox["Lighting",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighting"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->448356345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"Glow", "[", "Blue", "]"}], ",", 
       RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "c", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}], "}"}]}]}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"White", ",", "Yellow", ",", "Green"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14424688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[0], Glow[
      RGBColor[0, 0, 1]], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       GrayLevel[1], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVmFtP20AQhTexnTtJCLcEArgECAQo94CQqkp9aJ/6IyIaCaRWrSh/32p3
xuPEOZ4kLhJCRcHJes/5vN6dWa/36+D5Yfhj8Px4P/C/PA1+PTze//Y//3yy
p5yMMeab/f/eNPb3H/uL/z8FQWCc4XAY8J/ZpoP5aI+ePelz6YM9Zm3Jke/w
7J09ktGLEexRCLeiLai1faktUckdXd3+2OL6S2FXqOSN6oWxyZpzYdRmaE5F
01A1bdYcy7WWoSeyUG6xuifEtVTqrrBbUOtAucnqPWG3U6k7ot6CWhfK3FLj
S0t8qPWgvMrqLWF3Uqk3hL0HtTkor7C6JeyDVOo1UfegNg9lHj0+0sljqC1A
eYnVDWGfplLXRX0OtUUoc6yZBWnJJdSWoLzI6rKw+6nURVHfQm0ZynVWF0R9
N4c9Vsfzddd+l4wJkI3l2tg9kc+U7w3rx/GqQLk69ifylOKraRkY2TMYMzKT
YnbT0jitwtOhM6ZZYBK2Ga9PceEzCZxzSZhH1Pc7Ecl+a22qqCTMGnJ1YiT6
1LSxS5C0EdoFUtYe8A51Go4Cxew+0ByFVlJpmGNU3wWaq9DYl+gjjF0ajQOg
efaA8aXTUOUqtJxCK6g0vAOK3sMX0zCGekDKK6S8ShrFkDixTQWFlFNJFOtH
4C4qM0zo1jLlRLk23T9NPIXUrqLMKHQKM9tTKdQH7zWKLaoZnopAsyvOxbqb
RvP0jdwUl2fgLtsDZmboxv6svoobW+6+gpvu+xzcFaXlb+/GVWL1v3bTiNGq
paqMlDPVRTlOp7Ipxns6pSeUXIpsCSm4xqA87wqlpMwY6SkdmV+qypyXnuJL
WxovptAM2hbKqvIUSU9pCWU9xRM3O5WyIv2yBRT3nygNaQuumJyplPiqkdZ/
VSHgaiSbmlAWAj+b3TEhuZrR/QXx43NlvpvflqQfLyK3qOe3PXrXupnjzCSc
i+KUIOFPn/IdnLgiiEiT2Ro9v29fRKC4jdYNfZN8x8C4ThLy0gbq72tLwCcn
znlJQrQKoYi8Msl3JVxLC2H8nhWMdzAulFkWeaGf7LSTcKZkr+6In1kPwpWM
tnrM2CI5Jkd+KG9yx9aF69JcwoXzMu0aUIbU4byXcFJv0pODWkjr8AY43IQD
V6jUK/SusjTXif1EraT3uFU47ySc0Vs59ci2dTTBkU04cIzo/jasc2OGc7yz
MFJJvi3bA+/FefEoovrQh7MHt28i4uqW0Jk8O7oqji/ull1N8dUCfXftOlYe
t3ERVLiDF+0yhupotwdVNxP9hbV4DWqJM1KvCBNVtEfkyrxkEnePvXMSxN9d
MBIwww6DcG823A+IdtNQtSfMcMcIYwRnCF+Y4Z5bW5ioagtznVW476hlET+h
Wb0tTFQtyZV3WPUOanEWqAmzy+odqNVmf1IfsTraL0VVTlrAu4Dcb/FIc4XB
EWv27TE3lJ03YzJ/AVZo3po=\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[0], Glow[
      RGBColor[0, 0, 1]], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[1, 1, 0], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNWGlPGzEQdZLNfRAChIQzkAQo5aZAD1WV+qH91B8RoUggtWpF+fur1jOe
TZa3k8SRoCoKzo5n3vPEnrG9823weDf8MXi8vx10vj4Mft3d3/7ufPn5YLsy
KWPM0P5/bxn7/Mc+8f/nMAxNZjgchvxnOtSYT7bN2s4dlj7aNm2ljHy73g8i
ZWMMthWGt7alzjxJwYjfPmyz/lrQZUA77aWgqwn0FuvPBV0nKTvSC8cm25yK
TWOKzZGMswyzkAZ5ja0PhXHVy/pArNugzYDMetMXT9ZBG4DcYuuucG95WXeE
uwPaLMj8u8yWcHe9rDfEug/aHMhNtm6LJ/ugzYO8wtarwn3oZb0i1kegLYDM
a20a4skJaIsgL7F1XbjPvayrwv1mhjVHpikL942XdVGs34G2BPIiWxfE+j1o
yyDXR9bxXOzZ75IxIVpPQScyfcniMRYqIC+M8Yk8pXxoWw7MmikcUzKTonDT
snESum5TA5uayoTj00p3mAmQMZl3r0S0Yh7R7O1GTPbbnwnnlVBdYgock/sg
V0XlQpmsejGv6JO2TdWLDWePorMPbBmFrayyYSYQ+x6wBQpbSWXDTKFZ3Ae2
rG0wwhzbrFimHfgA2HIKW1Flw19A8fsK2PIKW0Flw5V/7eGXzrQQyYI89PAp
rzJRtB8BuqDsMTqa/DhW0OQ1d8Xy2jFo2YYMRdsEwoAnaE5lIT9OFBZe/mH0
p+arFxftulqcJtG0xqfPii7bBjPuJdAU62cKGj1nXOJmU3t2dEXx/P9D06yd
/yM0nnnk+YXHnAcvhCbP6TZTnQtF2c4HIh04MnRlLgba7agr55Fnk1n2haWk
7Bs6C95eaKfoCUtN2QX9WGgH3JY5aSj7uD/LhvjSVFhwP89MZGkLy5pyOvmz
NIVlC1gC5WSazNKQedkFlow3C927a+IL3irSE1ni5xbdLMvCgCc23g+SaHq7
yQsaTxU/dEbmIJ6rYajfTRS0fb6JkGKJvzmJXAxj57d461jGNrNZasJCuxeh
MQsxsiOGcU9ZGOg+cS23gvkY6Myn2SNvrywDnnq40yYZopsIzcmlZZh1txaG
8ZtXOK5pXCh7O+JTjCc4VQvOlKxDD1IJn6nicToHMoxuSfx+Rzs0Rhfe/BxS
q53Q7lyHfpx1+Y2hexsmb+mO3gArXG2HQk9oTHqXwZoR+ubQ+diYtKs0vVC4
ZjQm7dktBZ2yIqEcEiOUxl23SKwrpRPIqA4xspQ8XLYNV+Wy8QgjvYs8XDn2
8Uk01i1D92mvfXDomoyKv+wqJo/HwnVe8UItghWuXFSLdNYNkdDqRvrdbKEW
xyBPgpF1VJtCq3OxcvctrCvi+9uxWLt3x5ZwohXVHWmpXM1gDbSYoT3hdNUl
jBKMpo5Yu2peVPtDq3XxwNVBsUaJe8KqcLrK77ZwotWSWHEcmR3QYhYtiAdc
ZzS74bh+jXNBnFwx5Jl4GqFF0Z+xvh9DU2wFMgZX+cyebXNDqcsZk/oLtRju
cA==\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[0], Glow[
      RGBColor[0, 0, 1]], SphereBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       RGBColor[0, 1, 0], {0, 0, 3}}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFWGlPGzEQde4LNpAAIVAgEMKRQgOUq6oqVf3QfuqPiFAkkFq1ovz9Vetn
T8Lm7YQsl4rCJrN+73nWnrG9871/dz342b+7ueq3vt32f1/fXP1pff11a29l
UsaYgf3/sWzs77/2l/v/EoahyQwGg9D9mRYu5rO9Zu3NTWd9sldAMvY7bb89
5qNY+bG7l4ItRnTt1Wy41nPBVtTWU2mdhZUd+WR/rLv2Y9GuwsqN2kVjzWF6
olF7AHMomAV69jTZKw7dlV6XqDVDdtOh90S7mQjdEe1Vas2SvezQbdFeT4Te
jM5LpDVHdsOh18WTLWrNk+1GwbwR7U4idFO0d6m1QPaiQzdEu5sIvSjowylo
N9emJp70qLVIdt2h50T7JBE6EPQptZbIdpFpKuLJObWWyZ536JJof0iMjt69
JLtC9pxjccZu2++KMSH38QB7LGeR03XL55iYIbt6z4/lK/KiaTU4e2bJDmJP
ECr5jGhcs2ouGf1tz5yqxP1jxltOiZjsY0yJcxUztjlUst+TlTiieVzBakMp
65X8h7VmVC22gdqOeIVPWlGrqGr8zIigDqll7IVnUVfjaIb6DqllFbWyqsbR
jFHcS6BWUtU4FzC7+6SWsxeOea/GM8h9In67pJZX1IqqGs/VW1Iq2Av7rytV
IzaY7FNB8amgKmGtOCB2UfzA+ja5/0OFBbS7FclnvV9NoWQvWVHgrMxPHNF3
pFLG6mRNNTtje211goIWlS/Nhvc9YmN95/x6HJv7zr0CG3lxROwZxXPP5rkM
/jP7OMGYvwYbo3aSwPPsC7B5fwyezcZzY0UIHsVCjmP7SycYtckqXcnp/JNV
kKk7olJW1h2O+8kqbVEJJqyasVOKqtISlVqCPcCr8NkJK/cbGd0lZU9KrtIU
X1aepbIkKuvKbptMBSevmqhskUpG2dEmqwQyLnwqST9KpSK+uH167Ayna0R3
PbzdFIQfXWfDUD9VxNlZYZ88jW1/nw+ZgmSv40w89Wj/lqe9MOPn8+kqgahg
FQSb459zLa4wfBcrigKvhZzzQ4Xx0w7GAN6eWQXewaYrDE8iGJP3VmHaKTjl
Fe7fuISP2ThR1ik+k3s+6KgWHCtrEnvgGViT8VbWU+KSz0vCoLuoBmCd5sjS
2VrdBBlSpfs84vJ8oT9XopKDU36NUDzTnsWeoE+8v3C9COyUNcHyzEKkP6zc
Ws1onMHzhL42LHN5KrMsfWE2Vi2Da0jpGIPnK1qjQtot2IurxOWiUYUE9fHK
M8Y+AlW1Gm03OKP72I8df1ghYd5ZxL7vbY5Qi2QPa4kePS+Whopq+5GoE4rj
4kLUPHohjNQUSTszQvFcc4SieomB9Xt9g1r5bQ31LAyhf1NcFg8YtS8oXyFY
oVbeB7fFA18lWg3jtVj8bImmr92tUSuvI6ui6WulXJnkNaQh2r7euyEeMKou
KBdHro75UM4G4oGrLpot0WRUWTQPHAojEY/yomCOHKYjStGdIi19uRqf2RXL
VeWMSf0DD5Drrg==\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->272376523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177931040],

Cell[TextData[{
 "Other surface colors still interact with lighting even if ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 " is given:"
}], "ExampleText",
 CellID->953538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Glow", "[", "Red", "]"}], ",", "White", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181152110],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[1], Glow[
    RGBColor[1, 0, 0]], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2729546,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17377],

Cell["Use a pure color function with no lighting interaction:", "ExampleText",
 CellID->151414032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Glow", "[", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"z", ",", 
         RowBox[{"1", "-", "z"}], ",", "0"}], "]"}], "]"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357979125],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323349636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->641457372],

Cell["\<\
Use a color function based on the phase of a complex function:\
\>", "ExampleText",
 CellID->425301462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Zeta", "[", 
      RowBox[{"\[Sigma]", "+", 
       RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Sigma]", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Omega]", ",", "0", ",", "40"}], "}"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Sigma]", ",", "\[Omega]", ",", "z"}], "}"}], ",", 
       RowBox[{"Glow", "[", 
        RowBox[{"Hue", "[", 
         RowBox[{"Rescale", "[", 
          RowBox[{
           RowBox[{"Arg", "[", 
            RowBox[{"Zeta", "[", 
             RowBox[{"\[Sigma]", "+", 
              RowBox[{"\[ImaginaryI]", " ", "\[Omega]"}]}], "]"}], "]"}], ",",
            
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "]"}], "]"}]}], "]"}]}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->625786742],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421028010]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->40959776],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 ", objects can look flat if edges are not drawn:"
}], "ExampleText",
 CellID->40999356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Glow", "[", "Blue", "]"}], ",", "Black", ",", 
       RowBox[{"EdgeForm", "[", "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Glow", "[", "Green", "]"}], ",", "Black", ",", 
       RowBox[{"EdgeForm", "[", "]"}], ",", 
       RowBox[{"Cylinder", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->387198930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[0], EdgeForm[None], Glow[
      RGBColor[0, 0, 1]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy11GlLG1EUgOGxmRgTNRpN4lJT40JUFDcIoVoFS9HWfd/9EFRQUBT171/s
e8+9Oah0hIIG5mWeyZAJM3PPWvXp6vK2+nR9Xi0uPVTvr67PH4uLdw8citUF
QXDBdtMZsP/MnmwXxhi+eNEF21gQGPcJinJ0nsY52Cf6QROqGZpC7swKTaNe
UZm2qqZpFn0TTdIOVBCN0y7VKC2gHtEI7VWV6AD6KhqkJdQt6qfDKnvVMdQl
sr88gTpF9oxplW0ZdYjytKJqp7MoL8rQeZQTpemCqon+QllRii6h9gj9Rm0R
+oMyqmXUKkrSlVdaRS2qNZSO0DpqjtAGahI10C3UGKFtlIrQDkr+Qwm6+wna
Qw2ierr/CTpACVGcHn6wQnr0Sseo/gMVoyfv6BTF/1Nf6FnEd6G/QlzvoP0v
oT6xI1XS391Q3/J9VaN/tk7N/l0KdcVtq+w62FRlvGKiNv9eO2X9enDK+ZXj
lPfrz90XOwt+6nttZ8ecriM7cyq6Uu08mtI5UTBu2ri5ZGdPSSefnY1FNGhq
U6obDYsGaA6Nmdo8a0FTpjbrkqgsGqIh+m7eTu2g7i8/mxXS\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[0], EdgeForm[None], Glow[
      RGBColor[0, 1, 0]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyt1EtPwkAUhuFBN64UFQVEYVAMXiCEqFG5eUNc+SMa0gQSjQb5+xN8z1mY
zEKsMIt+6TM9aTvTznmNpqP4PZqOh5F9mUSfo/Hwyw4+JgytpowxMcdbznA+
40yP2DnHhaWzSa4ZZ2qqMzKDqirJAjpSVUiLyqpDsoJKKkueoAOVjJ2jgqpI
1tGeSioaKK/aJ5sop5L6C5RVSf0V2lVJ/TXaUUn9zRzdooxK7tWaozba/qfk
jTqJ1UVbASWz7C2oO7QZULKO94n1gNIBJWv8uKCe0EZAyRr3E+sZrQeUrPFg
af31vP4vc/e/iv+H+P+uv4/8fevvd78z+D1EOlD1p9tIXyojqzols+hYdUmu
oIZL2g9N6hvt29ze\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->35606368]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Glow", "[", "Blue", "]"}], ",", "Black", ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Glow", "[", "Green", "]"}], ",", "Black", ",", 
       RowBox[{"Cylinder", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26902418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {GrayLevel[0], Glow[
      RGBColor[0, 0, 1]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzlmAlPE0EYhofeBz1oSwsFSrkPCQRQqOIVYySCePyEBkwg0WiQv7/RmW/e
luHNl7BEiSaSdLo73/N8M7Pszs70pH91/vlr/+ritN89vOx/P784/dF98+3S
ViVHjDFn9vNlwtjjn/ZIPmdRFNlAUL60ZdKG5uTsGc4SxkTGHUTyZ2YlemBL
GzFpW+++u1Lbg5MdOO7b/nlnD07hRnSQ8SGio64qdR01piPxbeQuczzy8S34
Y64yHcbd4YwwG8hRpx7wGNtCryNjk2h7GE0LsQpiQiHCfJNCL6H1NtEpoieE
XkDuGaLdFff96yLfrEKE+VpCd5BvnuiMLXz/pkEsKkSYryn0JFpfJjpL9LjQ
LeReIzpnC9+/BvI9UIgwX0PoGvJt3ULXha6C3o5Fl9CTXaLzRNeELiL3HtHu
Lvd9LbgyiGhkmHcsllUkqxrLck+X73eeyH2FDPNXYlklssr3aJXJKsWyKraI
N5YK5R+NZVXJKoqVI6tHlpu1SrHJMH8hllUjK/8Hrce3WLlYlpuT/ViyRD5R
yDB/9p+zGrbI3wMZ9iTzG1aGrIP/xBq3Re6OZJrIpwoZ9iT91y03FnfajEX3
QCeoLb7Cuv0Idkaxs6qxA4NXgfWhkSLDvePdgq9MBs8zKdXeQHu85uN5VLfX
+FreyV6GzSs+fkfo9jzG3SGb30u6PYu2F8jmt6ZuT8NeUWz/rCXJaMNYj220
YGySwauBpGrXcXV2yOZ1i25X0Ta/vXlVpdsl2Dxr8EpOtwuwX5DN60tvJ8jO
YtyvlLbTqpFCe4dKe4FxY0/lsGPiebWcGLpO/UA07wMSat8+kcV7jYR6d3Jb
usUzD1u8T/KWu1fdev4j0bxL8zSvat4rln/CeN3IZHJIFok8IZJ3qyNijZL1
LpZVwmhPcEGu7wB36O/ACmU+xsCGLLiqxg3PB1SNqKOAur6udaLeqlQDvT9S
x9akHK/x5Ph+tCj6HFH/1p+kaA9RvwdoU3QXUb8Hm0KvNlHrd8Az5Kwg6vfe
HYoO5n6x/K8rQXTKPblm8EvNHEWbcJclOo/e1FC7LrWLypzkMm5KdImiabi7
El25ETVyuC+R1UEE/4fHUut/XTIjvwDQGAUX\
\>"]], ",", 
   Graphics3DBox[
    {GrayLevel[0], Glow[
      RGBColor[0, 1, 0]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVlttOwkAQhpeTQhAQFAE54yGgENQEUREETPTKhyCERBONBnn9Rmdmp7Wd
VG2QG0m72/n/b7Z0u93dh8nicfYyWTxNJ5X7+eTt8Wn6Xrl7nYMU8CmlZnA+
ZxVcf8AVnTPDMMD4c9mCMgENNiiqQxmCKKEMFYT6gFQsAxBlQcW6RuoelH6I
SqBiXSG1ymqN1RKp5GEqqHjss1sgt8Q5DbSQMuincuQWRe6RoLJEFQTV5Dto
Ny/ctmgjTdSuoE6hyJCTE86ZyN+2qHPhbJGTFfkdQaUs6sLVyYj8rjLvic6V
yEn+4uyI1i6V+T9X71x7jvrKfNrVRPhOB0tGN8rsq9VE+K6GnqMRRJsrjLCP
x0tG+HWH4d0WoU5YahqiCKhhdtMON8mzR47rpMONsVrl2STucKP83dbZjTrc
MKstpiKWm2LXPhJPmFp3UGusdrgOOdyQaKMrYr+DDnAbPRcqblF+4eK4py7g
+Ce2L+IvUuHN2RjaKLRidsrK9UaNxJyxQVRSUGNP1K2gov+Kcn9Gb/31bd8z
FbPGtJ0aCCpufc2uY8JBpQXVE5QetXK2luvN19qB47orXD1Duq2GSOtVNM+5
bVb1Clpk9ZhVvbaXDb2zOFD2/QDuL4I856BbJvXQ0HuTFKhrytyFNA2cb/TO
xduOR/k+AfFC0As=\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->709126862]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18335],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5190]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Glow",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Glow"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1024074881],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->817149272],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->380223643],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->820123734],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->12180844],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->421482204]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Glow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 45, 16.9406988}", "context" -> "System`", 
    "keywords" -> {"glow color", "light independent color"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Glow[col] is a graphics directive which specifies that surfaces of 3D \
graphics objects which follow are to be taken to glow with color col. Glow[] \
specifies that there is no glow. ", "synonyms" -> {}, "title" -> "Glow", 
    "type" -> "Symbol", "uri" -> "ref/Glow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7166, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->646590555]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 83065, 1776}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2156, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2779, 74, 1569, 37, 70, "ObjectNameGrid"],
Cell[4351, 113, 895, 27, 70, "Usage",
 CellID->16769]
}, Open  ]],
Cell[CellGroupData[{
Cell[5283, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5761, 162, 155, 4, 70, "Notes",
 CellID->14709],
Cell[5919, 168, 106, 3, 70, "Notes",
 CellID->27956],
Cell[6028, 173, 430, 17, 70, "Notes",
 CellID->22421],
Cell[6461, 192, 668, 25, 70, "Notes",
 CellID->15945]
}, Closed]],
Cell[CellGroupData[{
Cell[7166, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->646590555],
Cell[CellGroupData[{
Cell[7551, 236, 148, 5, 70, "ExampleSection",
 CellID->282013339],
Cell[7702, 243, 123, 3, 70, "ExampleText",
 CellID->275919926],
Cell[CellGroupData[{
Cell[7850, 250, 232, 7, 28, "Input",
 CellID->7628988],
Cell[8085, 259, 1978, 38, 129, 127, 3, "CachedBoxData", "BoxData", "Output",
 CellID->923289109]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10112, 303, 220, 7, 70, "ExampleSection",
 CellID->163473823],
Cell[10335, 312, 350, 12, 70, "ExampleText",
 CellID->448356345],
Cell[CellGroupData[{
Cell[10710, 328, 673, 22, 70, "Input",
 CellID->14424688],
Cell[11386, 352, 5470, 106, 131, "Output",
 CellID->272376523]
}, Open  ]],
Cell[16871, 461, 125, 3, 70, "ExampleDelimiter",
 CellID->177931040],
Cell[16999, 466, 239, 8, 70, "ExampleText",
 CellID->953538],
Cell[CellGroupData[{
Cell[17263, 478, 232, 7, 70, "Input",
 CellID->181152110],
Cell[17498, 487, 9642, 164, 129, 111, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->2729546]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27189, 657, 223, 7, 70, "ExampleSection",
 CellID->17377],
Cell[27415, 666, 98, 1, 70, "ExampleText",
 CellID->151414032],
Cell[CellGroupData[{
Cell[27538, 671, 704, 23, 70, "Input",
 CellID->357979125],
Cell[28245, 696, 16028, 267, 70, "Output",
 Evaluatable->False,
 CellID->323349636]
}, Open  ]],
Cell[44288, 966, 125, 3, 70, "ExampleDelimiter",
 CellID->641457372],
Cell[44416, 971, 113, 3, 70, "ExampleText",
 CellID->425301462],
Cell[CellGroupData[{
Cell[44554, 978, 1266, 36, 70, "Input",
 CellID->625786742],
Cell[45823, 1016, 26894, 445, 70, "Output",
 Evaluatable->False,
 CellID->421028010]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[72766, 1467, 229, 7, 70, "ExampleSection",
 CellID->40959776],
Cell[72998, 1476, 225, 8, 70, "ExampleText",
 CellID->40999356],
Cell[CellGroupData[{
Cell[73248, 1488, 719, 21, 70, "Input",
 CellID->387198930],
Cell[73970, 1511, 1623, 37, 131, "Output",
 CellID->35606368]
}, Open  ]],
Cell[CellGroupData[{
Cell[75630, 1553, 628, 19, 70, "Input",
 CellID->26902418],
Cell[76261, 1574, 2434, 51, 131, "Output",
 CellID->709126862]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78756, 1632, 311, 9, 70, "SeeAlsoSection",
 CellID->18335],
Cell[79070, 1643, 956, 35, 70, "SeeAlso",
 CellID->5190]
}, Open  ]],
Cell[CellGroupData[{
Cell[80063, 1683, 305, 8, 70, "RelatedLinksSection"],
Cell[80371, 1693, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80756, 1709, 320, 9, 70, "MoreAboutSection",
 CellID->1024074881],
Cell[81079, 1720, 148, 3, 70, "MoreAbout",
 CellID->817149272],
Cell[81230, 1725, 124, 3, 70, "MoreAbout",
 CellID->380223643],
Cell[81357, 1730, 149, 3, 70, "MoreAbout",
 CellID->820123734],
Cell[81509, 1735, 196, 4, 70, "MoreAbout",
 CellID->12180844],
Cell[81708, 1741, 179, 3, 70, "MoreAbout",
 CellID->421482204]
}, Open  ]],
Cell[81902, 1747, 27, 0, 70, "History"],
Cell[81932, 1749, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

