(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     90029,       2202]
NotebookOptionsPosition[     82261,       1927]
NotebookOutlinePosition[     83733,       1967]
CellTagsIndexPosition[     83647,       1962]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicalConstants"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fibonacci" :> Documentation`HelpLookup["paclet:ref/Fibonacci"],
           "ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], "LucasL" :> 
          Documentation`HelpLookup["paclet:ref/LucasL"], "AspectRatio" :> 
          Documentation`HelpLookup["paclet:ref/AspectRatio"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fibonacci\"\>", 
       2->"\<\"ContinuedFraction\"\>", 3->"\<\"LucasL\"\>", 
       4->"\<\"AspectRatio\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Constants" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalConstants"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematical Constants\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GoldenRatio", "ObjectName",
 CellID->11857],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["GoldenRatio",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
     " \[LineSeparator]is the golden ratio ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Phi]", "=", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SqrtBox["5"], "+", "1"}], ")"}]}]}], TraditionalForm]], 
      "InlineMath"],
     ", with numerical value ",
     Cell[BoxData[
      RowBox[{"\[TildeEqual]", "1.61803"}]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Mathematical constant treated as numeric by ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " and as a constant by ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1710],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GoldenRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
 " can be evaluated to any numerical precision using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21968]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184837614],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->383042961],

Cell["Numerical value:", "ExampleText",
 CellID->29256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "GoldenRatio", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19692],

Cell[BoxData["1.618033988749895`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3809735]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15012],

Cell["Evaluate to any precision:", "ExampleText",
 CellID->5820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"GoldenRatio", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14835],

Cell[BoxData["1.\
6180339887498948482045868343656381177203091798057628621354486227053`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396568110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10615],

Cell["Do exact computations:", "ExampleText",
 CellID->25897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPart", "[", 
  RowBox[{"GoldenRatio", "^", "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18677],

Cell[BoxData["792070839848372253126"], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498723101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10134],

Cell[TextData[{
 "Simplify ",
 Cell[BoxData[
  ButtonBox["GoldenRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->27553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"GoldenRatio", "^", "20"}], "+", 
   RowBox[{"1", "/", 
    RowBox[{"GoldenRatio", "^", "20"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19533],

Cell[BoxData["15127"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67209113]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"GoldenRatio", "^", "4"}], "-", "GoldenRatio"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2286],

Cell[BoxData[
 RowBox[{"3", "+", 
  SqrtBox["5"]}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193068408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2734],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->76334217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GoldenRatio", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18075],

Cell[BoxData[
 FormBox[
  TagBox["\[Phi]",
   Function[{}, GoldenRatio]], TraditionalForm]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->461430268]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30624],

Cell["Golden ratio rectangle:", "ExampleText",
 CellID->27792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Gray", ",", 
    RowBox[{"Rectangle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"GoldenRatio", ",", "1"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6504],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.5], 
   RectangleBox[{0, 0}, 
    NCache[{GoldenRatio, 1}, {1.618033988749895, 1}]]}]], "Output",
 ImageSize->{184, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112981108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4055],

Cell["\<\
Make a phyllotaxis pattern (\[OpenCurlyDoubleQuote]simulated sunflower head\
\[CloseCurlyDoubleQuote]):\
\>", "ExampleText",
 CellID->18913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", "n", "]"}], 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "Pi", " ", "n", " ", "GoldenRatio"}], "]"}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "Pi", " ", "n", " ", "GoldenRatio"}], "]"}]}], 
       "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1000"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202852035]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20084],

Cell["Compute the Fibonacci numbers:", "ExampleText",
 CellID->24160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Round", "[", 
    RowBox[{
     RowBox[{"GoldenRatio", "^", "n"}], "/", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610", ",", "987", ",", "1597", ",", "2584", ",", "4181", ",", "6765"}], 
  "}"}]], "Output",
 ImageSize->{560, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89873579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"FractionalPart", "[", 
     RowBox[{"n", " ", "GoldenRatio"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11822],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1lA1MzGEcx59hyDovTSsTzlusJSkVkfvpRXWVurp0XkYqb03erUJ5WMuI
yksbGi3mnTUvt47E5S1KXo5QUkTplJxl3pXHfJ/bbrfPfe9397/v8/n9h8et
jFzUjTGWIJ7/Xv8/LKoI83ivT3feqvAGcfXmy6leD8C9yVKSc6xK2wruj7we
PJD4uk0FsbbFYHt6nTwsJP9UM9iBYm8c7mH75ilYifl28Ah65F5kWdr5BjwK
31cOdiTes9+CwJ1m8FjiDWnOScdrwU7Ecj8+m3ekEOyM33sHdiEecyi5d8Rj
sCuxvM41HSvawBOI0l1ON3q8BrsR8+nok9N8HexOTJNtX3bzPXgiru852IP4
yPbMAs0nsCcxxdBr2fayTy9iNV7V39IqwZNw/R/Ak4nvnltuqK0De+P/nAdP
IZ6vMHn/agJPJW610Uab8QTsQ2xFEg3a/hE8Df9X9qki1t2jpH7uLTARc/rT
1Pyq5T9zIu44x/tscA3y6cSUKrvozzuQC27emXXJTfbpi34eIvclbmj7scco
/fAj5j85rke/BuSC5yT4Zq29gtwf/aFP7k/squ5cgaEaeQCxwDqF6ij84AHE
Xa0DXBIbkc8gttRiWX/rLnLB3ZdftP4u/QhE3y+RC9aVOlyYfxJ5ELHrv3S1
oeiTC9bEKPeOMSEPxnnADx5MbGNW54lC6Yca51OGXE08rHV55nj0yULEeXgG
tbbBDy5YGfIyoVT6EYrzgx88lNj9M46KcVXIw4jV1XI3G/TJBWfZrvK78Ar5
TGIp1anbmB654P2JjmyJ3LdwnDf2jYcTT6zYV/9F+hFBTPuzsqoEfpDgryet
v/S5g89HwAf0aRS5cuBbz+Fy3zTw4yDmNcQbzQ2ph+EHF/l+dxdTxSPMC9YH
z9Q5y32LhD/wgwRTaJP+cSnmBa+u6Ri9BX4YBettZjnlPsN8FPxCnyR43LID
HdXwg0fBtwrMRxHvutvLFC/3TUvM9DltazT2jQQrd8X1GlyEeS18hB9GweoB
94Z0ST+iiWUbBqfPQJ8kOKUlMkmBPrngjIVj12huYl6wOqgsJF/6MQv+vsC8
YN73qV3eOswL7vli8SAL/DAKvjosZUSdvB/HwG/4QYIzHto/2I77MY+B7wbM
C84r33DbJP3QEfvdHr/MHftGgpeMMR+Nlfumwz6gT6PgFof5Vlfk/Xg2sZHF
2av1ZtVfvya9eQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 100.}, {0., 0.9918693812442143}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117564892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21337],

Cell["Corners of an icosahedron:", "ExampleText",
 CellID->13917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"NestList", "[", 
         RowBox[{"RotateRight", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}], "^", "#1"}], " ", "GoldenRatio"}], 
            ",", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", "#2"}]}], "}"}], ",", "3"}], 
         "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "2"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4006],

Cell[BoxData[
 Graphics3DBox[{
   SphereBox[NCache[{0, -GoldenRatio, -1}, {0, -1.618033988749895, -1}], 1], 
   SphereBox[NCache[{-1, 0, -GoldenRatio}, {-1, 0, -1.618033988749895}], 1], 
   SphereBox[NCache[{-GoldenRatio, -1, 0}, {-1.618033988749895, -1, 0}], 1], 
   SphereBox[NCache[{0, -GoldenRatio, -1}, {0, -1.618033988749895, -1}], 1], 
   SphereBox[NCache[{0, -GoldenRatio, 1}, {0, -1.618033988749895, 1}], 1], 
   SphereBox[NCache[{1, 0, -GoldenRatio}, {1, 0, -1.618033988749895}], 1], 
   SphereBox[NCache[{-GoldenRatio, 1, 0}, {-1.618033988749895, 1, 0}], 1], 
   SphereBox[NCache[{0, -GoldenRatio, 1}, {0, -1.618033988749895, 1}], 1], 
   SphereBox[NCache[{0, GoldenRatio, -1}, {0, 1.618033988749895, -1}], 1], 
   SphereBox[NCache[{-1, 0, GoldenRatio}, {-1, 0, 1.618033988749895}], 1], 
   SphereBox[NCache[{GoldenRatio, -1, 0}, {1.618033988749895, -1, 0}], 1], 
   SphereBox[NCache[{0, GoldenRatio, -1}, {0, 1.618033988749895, -1}], 1], 
   SphereBox[NCache[{0, GoldenRatio, 1}, {0, 1.618033988749895, 1}], 1], 
   SphereBox[NCache[{1, 0, GoldenRatio}, {1, 0, 1.618033988749895}], 1], 
   SphereBox[NCache[{GoldenRatio, 1, 0}, {1.618033988749895, 1, 0}], 1], 
   SphereBox[NCache[{0, GoldenRatio, 1}, {0, 1.618033988749895, 1}], 1]},
  ImageSize->{180., 195.30372050906345`},
  ViewPoint->{0.17131572664917755`, -2.7702246071513668`, 
   1.9355894574355696`},
  ViewVertical->{-0.31151829738099607`, -0.3378500851824383, 
   0.8881518284274735}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45761608,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22197],

Cell[TextData[{
 "Position of 1s in a Fibonacci substitution system ",
 ButtonBox["[more info]",
  BaseStyle->"NKSLink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/page-889c-text"], None}],
 ":"
}], "ExampleText",
 CellID->27505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"2", "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Floor", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", "GoldenRatio"}], "]"}], "-", 
      RowBox[{"Floor", "[", 
       RowBox[{"n", " ", "GoldenRatio"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", 
   ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", 
   "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", 
   ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{553, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216344643]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Accumulate", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6599],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 0.}, {2., 1.}, {3., 1.}, {4., 1.}, {5., 2.}, {6., 2.}, {7.,
      3.}, {8., 3.}, {9., 3.}, {10., 4.}, {11., 4.}, {12., 4.}, {13., 5.}, {
     14., 5.}, {15., 6.}, {16., 6.}, {17., 6.}, {18., 7.}, {19., 7.}, {20., 
     8.}, {21., 8.}, {22., 8.}, {23., 9.}, {24., 9.}, {25., 9.}, {26., 10.}, {
     27., 10.}, {28., 11.}, {29., 11.}, {30., 11.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 30.}, {0., 11.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->41497592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1898],

Cell["Compute the effective \"inverse\" of the Fibonacci numbers:", \
"ExampleText",
 CellID->985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Round", "[", 
    RowBox[{"Log", "[", 
     RowBox[{"GoldenRatio", ",", 
      RowBox[{"n", " ", 
       RowBox[{"Sqrt", "[", "5", "]"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "4", ",", "5", ",", "5", ",", "5", ",", "6", ",", "6", 
   ",", "6", ",", "6", ",", "7", ",", "7", ",", "7", ",", "7", ",", "7", ",", 
   "7", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", ",", "8", 
   ",", "8", ",", "8"}], "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179109906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Fibonacci", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->592],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{1., 1.}, {2., 2.}, {3., 3.}, {4., 5.}, {5., 5.}, {6., 5.}, {7., 
     8.}, {8., 8.}, {9., 8.}, {10., 8.}, {11., 13.}, {12., 13.}, {13., 13.}, {
     14., 13.}, {15., 13.}, {16., 13.}, {17., 21.}, {18., 21.}, {19., 21.}, {
     20., 21.}, {21., 21.}, {22., 21.}, {23., 21.}, {24., 21.}, {25., 
     21.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 25.}, {0., 21.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->473297289]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GoldenRatio", "==", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], ")"}], "/", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24828],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315074038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "==", 
    RowBox[{"x", "+", "1"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{247, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59795410]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"GoldenRatio", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5506],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18044225]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", "GoldenRatio", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", "1", "}"}]}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->323775136]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3609],

Cell["Simulated palm tree trunk:", "ExampleText",
 CellID->19854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cylinder", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "4"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", " ", "Pi", " ", "n", " ", "GoldenRatio"}], "]"}], ",", 
         
         RowBox[{"Sin", "[", 
          RowBox[{"2", " ", "Pi", " ", "n", " ", "GoldenRatio"}], "]"}], ",", 
         
         RowBox[{"n", "/", "250"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1000"}], "}"}]}], "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29465],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{133, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191601011]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11684],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fibonacci",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fibonacci"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LucasL",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LucasL"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31708],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathematicalConstants"]], "Tutorials",
 CellID->2641]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->27732],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/GoldenRatio.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/GoldenRatio/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
GoldenRatio"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->5462615],

Cell[TextData[ButtonBox["Mathematical Constants",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalConstants"]], "MoreAbout",
 CellID->840695489]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GoldenRatio - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 45, 19.0345024}", "context" -> "System`", 
    "keywords" -> {
     "divine proportion", "divine section", "extreme and mean ratio", 
      "golden cut", "golden mean", "golden number", "golden proportion", 
      "golden section", "mean of Phidias", "medial section", "phi"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GoldenRatio is the golden ratio \\[Phi] = 1/2 (Sqrt[5] + 1), with \
numerical value \\[TildeEqual] 1.61803. ", "synonyms" -> {"golden ratio"}, 
    "title" -> "GoldenRatio", "type" -> "Symbol", "uri" -> 
    "ref/GoldenRatio"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4787, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->184837614]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 83504, 1955}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2091, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2714, 78, 49, 1, 70, "ObjectName",
 CellID->11857],
Cell[2766, 81, 782, 26, 70, "Usage",
 CellID->8968]
}, Open  ]],
Cell[CellGroupData[{
Cell[3585, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4063, 129, 349, 13, 70, "Notes",
 CellID->1710],
Cell[4415, 144, 335, 12, 70, "Notes",
 CellID->21968]
}, Closed]],
Cell[CellGroupData[{
Cell[4787, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->184837614],
Cell[CellGroupData[{
Cell[5172, 175, 148, 5, 70, "ExampleSection",
 CellID->383042961],
Cell[5323, 182, 55, 1, 70, "ExampleText",
 CellID->29256],
Cell[CellGroupData[{
Cell[5403, 187, 103, 3, 28, "Input",
 CellID->19692],
Cell[5509, 192, 173, 5, 36, "Output",
 CellID->3809735]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5731, 203, 216, 7, 70, "ExampleSection",
 CellID->15012],
Cell[5950, 212, 64, 1, 70, "ExampleText",
 CellID->5820],
Cell[CellGroupData[{
Cell[6039, 217, 127, 4, 70, "Input",
 CellID->14835],
Cell[6169, 223, 235, 7, 36, "Output",
 CellID->396568110]
}, Open  ]],
Cell[6419, 233, 121, 3, 70, "ExampleDelimiter",
 CellID->10615],
Cell[6543, 238, 61, 1, 70, "ExampleText",
 CellID->25897],
Cell[CellGroupData[{
Cell[6629, 243, 138, 4, 70, "Input",
 CellID->18677],
Cell[6770, 249, 179, 5, 36, "Output",
 CellID->498723101]
}, Open  ]],
Cell[6964, 257, 121, 3, 70, "ExampleDelimiter",
 CellID->10134],
Cell[7088, 262, 206, 8, 70, "ExampleText",
 CellID->27553],
Cell[CellGroupData[{
Cell[7319, 274, 222, 7, 70, "Input",
 CellID->19533],
Cell[7544, 283, 161, 5, 36, "Output",
 CellID->67209113]
}, Open  ]],
Cell[CellGroupData[{
Cell[7742, 293, 170, 5, 70, "Input",
 CellID->2286],
Cell[7915, 300, 192, 7, 38, "Output",
 CellID->193068408]
}, Open  ]],
Cell[8122, 310, 120, 3, 70, "ExampleDelimiter",
 CellID->2734],
Cell[8245, 315, 202, 7, 70, "ExampleText",
 CellID->76334217],
Cell[CellGroupData[{
Cell[8472, 326, 113, 3, 70, "Input",
 CellID->18075],
Cell[8588, 331, 249, 8, 50, "Output",
 CellID->461430268]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8886, 345, 223, 7, 70, "ExampleSection",
 CellID->30624],
Cell[9112, 354, 62, 1, 70, "ExampleText",
 CellID->27792],
Cell[CellGroupData[{
Cell[9199, 359, 336, 12, 70, "Input",
 CellID->6504],
Cell[9538, 373, 272, 9, 135, "Output",
 CellID->112981108]
}, Open  ]],
Cell[9825, 385, 120, 3, 70, "ExampleDelimiter",
 CellID->4055],
Cell[9948, 390, 150, 4, 70, "ExampleText",
 CellID->18913],
Cell[CellGroupData[{
Cell[10123, 398, 557, 17, 70, "Input",
 CellID->462],
Cell[10683, 417, 6435, 110, 70, "Output",
 Evaluatable->False,
 CellID->202852035]
}, Open  ]],
Cell[17133, 530, 121, 3, 70, "ExampleDelimiter",
 CellID->20084],
Cell[17257, 535, 69, 1, 70, "ExampleText",
 CellID->24160],
Cell[CellGroupData[{
Cell[17351, 540, 298, 10, 70, "Input",
 CellID->31122],
Cell[17652, 552, 424, 11, 36, "Output",
 CellID->89873579]
}, Open  ]],
Cell[18091, 566, 121, 3, 70, "ExampleDelimiter",
 CellID->19397],
Cell[CellGroupData[{
Cell[18237, 573, 292, 9, 70, "Input",
 CellID->11822],
Cell[18532, 584, 1696, 36, 140, "Output",
 CellID->117564892]
}, Open  ]],
Cell[20243, 623, 121, 3, 70, "ExampleDelimiter",
 CellID->21337],
Cell[20367, 628, 65, 1, 70, "ExampleText",
 CellID->13917],
Cell[CellGroupData[{
Cell[20457, 633, 839, 28, 70, "Input",
 CellID->4006],
Cell[21299, 663, 35836, 590, 216, 1470, 22, "CachedBoxData", "BoxData", \
"Output",
 CellID->45761608]
}, Open  ]],
Cell[57150, 1256, 121, 3, 70, "ExampleDelimiter",
 CellID->22197],
Cell[57274, 1261, 251, 8, 70, "ExampleText",
 CellID->27505],
Cell[CellGroupData[{
Cell[57550, 1273, 452, 15, 70, "Input",
 CellID->29236],
Cell[58005, 1290, 502, 12, 36, "Output",
 CellID->216344643]
}, Open  ]],
Cell[CellGroupData[{
Cell[58544, 1307, 136, 4, 70, "Input",
 CellID->6599],
Cell[58683, 1313, 772, 19, 139, "Output",
 CellID->41497592]
}, Open  ]],
Cell[59470, 1335, 120, 3, 70, "ExampleDelimiter",
 CellID->1898],
Cell[59593, 1340, 98, 2, 70, "ExampleText",
 CellID->985],
Cell[CellGroupData[{
Cell[59716, 1346, 334, 11, 70, "Input",
 CellID->21447],
Cell[60053, 1359, 449, 11, 36, "Output",
 CellID->179109906]
}, Open  ]],
Cell[CellGroupData[{
Cell[60539, 1375, 138, 4, 70, "Input",
 CellID->592],
Cell[60680, 1381, 727, 19, 139, "Output",
 CellID->473297289]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61456, 1406, 232, 7, 70, "ExampleSection",
 CellID->8996],
Cell[CellGroupData[{
Cell[61713, 1417, 205, 7, 70, "Input",
 CellID->24828],
Cell[61921, 1426, 161, 5, 36, "Output",
 CellID->315074038]
}, Open  ]],
Cell[62097, 1434, 121, 3, 70, "ExampleDelimiter",
 CellID->14428],
Cell[CellGroupData[{
Cell[62243, 1441, 195, 7, 70, "Input",
 CellID->29795],
Cell[62441, 1450, 561, 21, 51, "Output",
 CellID->59795410]
}, Open  ]],
Cell[63017, 1474, 121, 3, 70, "ExampleDelimiter",
 CellID->30037],
Cell[CellGroupData[{
Cell[63163, 1481, 142, 4, 70, "Input",
 CellID->5506],
Cell[63308, 1487, 394, 10, 36, "Output",
 CellID->18044225]
}, Open  ]],
Cell[CellGroupData[{
Cell[63739, 1502, 118, 3, 70, "Input",
 CellID->5053],
Cell[63860, 1507, 227, 8, 36, "Output",
 CellID->323775136]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64136, 1521, 223, 7, 70, "ExampleSection",
 CellID->3609],
Cell[64362, 1530, 65, 1, 70, "ExampleText",
 CellID->19854],
Cell[CellGroupData[{
Cell[64452, 1535, 849, 27, 70, "Input",
 CellID->29465],
Cell[65304, 1564, 13397, 224, 70, "Output",
 Evaluatable->False,
 CellID->191601011]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78762, 1795, 311, 9, 70, "SeeAlsoSection",
 CellID->11684],
Cell[79076, 1806, 963, 35, 70, "SeeAlso",
 CellID->32499]
}, Open  ]],
Cell[CellGroupData[{
Cell[80076, 1846, 314, 9, 70, "TutorialsSection",
 CellID->31708],
Cell[80393, 1857, 153, 3, 70, "Tutorials",
 CellID->2641]
}, Open  ]],
Cell[CellGroupData[{
Cell[80583, 1865, 321, 9, 70, "RelatedLinksSection",
 CellID->27732],
Cell[80907, 1876, 182, 4, 70, "RelatedLinks"],
Cell[81092, 1882, 193, 4, 70, "RelatedLinks"],
Cell[81288, 1888, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[81714, 1906, 317, 9, 70, "MoreAboutSection",
 CellID->5462615],
Cell[82034, 1917, 155, 3, 70, "MoreAbout",
 CellID->840695489]
}, Open  ]],
Cell[82204, 1923, 27, 0, 70, "History"],
Cell[82234, 1925, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

