(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11707,        411]
NotebookOptionsPosition[      9166,        325]
NotebookOutlinePosition[     10357,        361]
CellTagsIndexPosition[     10272,        356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Loops and Control Structures\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Throw" :> Documentation`HelpLookup["paclet:ref/Throw"], 
          "Switch" :> Documentation`HelpLookup["paclet:ref/Switch"], "Which" :> 
          Documentation`HelpLookup["paclet:ref/Which"], "Break" :> 
          Documentation`HelpLookup["paclet:ref/Break"], "Continue" :> 
          Documentation`HelpLookup["paclet:ref/Continue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Throw\"\>", 2->"\<\"Switch\"\>", 
       3->"\<\"Which\"\>", 4->"\<\"Break\"\>", 
       5->"\<\"Continue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Flow Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Goto", "ObjectName",
 CellID->10844],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Goto",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Goto"], "[", 
       StyleBox["tag", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]scans for ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Label",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Label"], "[", 
       StyleBox["tag", "TI"], "]"}]], "InlineFormula"],
     ", and transfers control to that point. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22777]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Goto",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
 " first scans any compound expression in which it appears directly, then \
scans compound expressions which enclose this one. "
}], "Notes",
 CellID->19285]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153162574],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->172737576],

Cell[TextData[{
 "Write a loop using ",
 Cell[BoxData[
  ButtonBox["Goto",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Goto"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Label",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Label"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->379349084],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a_", "]"}], " ", ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", " ", "=", " ", "1."}], ",", "xp"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Label", "[", "begin", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"xp", " ", "-", " ", "x"}], "]"}], " ", "<", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], ",", 
       RowBox[{"Goto", "[", "end", "]"}]}], "]"}], ";", "\[IndentingNewLine]",
      
     RowBox[{"xp", " ", "=", " ", "x"}], ";", "\[IndentingNewLine]", 
     RowBox[{"x", " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"a", "/", "x"}]}], ")"}], "/", "2"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Goto", "[", "begin", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Label", "[", "end", "]"}], ";", "\[IndentingNewLine]", "x"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106177899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->497843867],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->575187943]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25668],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Switch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Switch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Which",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Which"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Continue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Continue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10006]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26200],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->14590]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->214497452]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Goto - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 45, 20.0032772}", "context" -> "System`", 
    "keywords" -> {"jump"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Goto[tag] scans for Label[tag], and transfers control to that point. ", 
    "synonyms" -> {}, "title" -> "Goto", "type" -> "Symbol", "uri" -> 
    "ref/Goto"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4284, 138, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->153162574]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10129, 349}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2096, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2719, 78, 42, 1, 70, "ObjectName",
 CellID->10844],
Cell[2764, 81, 684, 22, 70, "Usage",
 CellID->22777]
}, Open  ]],
Cell[CellGroupData[{
Cell[3485, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3963, 125, 284, 8, 70, "Notes",
 CellID->19285]
}, Closed]],
Cell[CellGroupData[{
Cell[4284, 138, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153162574],
Cell[CellGroupData[{
Cell[4669, 152, 148, 5, 70, "ExampleSection",
 CellID->172737576],
Cell[4820, 159, 317, 13, 70, "ExampleText",
 CellID->379349084],
Cell[5140, 174, 1100, 31, 70, "Input",
 CellID->106177899],
Cell[CellGroupData[{
Cell[6265, 209, 97, 3, 28, "Input",
 CellID->497843867],
Cell[6365, 214, 175, 5, 36, "Output",
 CellID->575187943]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6601, 226, 311, 9, 70, "SeeAlsoSection",
 CellID->25668],
Cell[6915, 237, 1164, 44, 70, "SeeAlso",
 CellID->10006]
}, Open  ]],
Cell[CellGroupData[{
Cell[8116, 286, 314, 9, 70, "TutorialsSection",
 CellID->26200],
Cell[8433, 297, 164, 3, 70, "Tutorials",
 CellID->14590]
}, Open  ]],
Cell[CellGroupData[{
Cell[8634, 305, 299, 8, 70, "MoreAboutSection"],
Cell[8936, 315, 135, 3, 70, "MoreAbout",
 CellID->214497452]
}, Open  ]],
Cell[9086, 321, 50, 0, 70, "History"],
Cell[9139, 323, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

