(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52106,       1667]
NotebookOptionsPosition[     46358,       1480]
NotebookOutlinePosition[     47832,       1519]
CellTagsIndexPosition[     47746,       1514]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       2->"\<\"Redrawing and Combining Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Column" :> Documentation`HelpLookup["paclet:ref/Column"], 
          "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "GraphicsRow" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsRow"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Column\"\>", 2->"\<\"GraphicsGrid\"\>", 
       3->"\<\"GraphicsRow\"\>", 4->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Combining Graphics\"\>", 3->"\<\"Grids & Tables\"\>", 
       4->"\<\"Layout & Tables\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphicsColumn", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsColumn",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsColumn"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a graphic in which the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are laid out in a column, with ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " above ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", etc. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsColumn",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsColumn"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["alignment", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]aligns each element horizontally in the specified way. \
"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsColumn",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsColumn"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["alignment", "TI"], ",", 
        StyleBox["spacing", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]leaves the specified spacing between successive \
elements."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The output from ",
 Cell[BoxData[
  ButtonBox["GraphicsColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFormula"],
 " can be interactively resized, or edited as a graphic."
}], "Notes",
 CellID->153],

Cell["Possible alignments are: ", "Notes",
 CellID->31511],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell["centered ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell[
    "left justified (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell["right justified ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "stretched if possible to full width", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment points of successive items aligned ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->5521],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFormula"],
 " will by default make all items the same height, preserving individual \
aspect ratios for graphics, and leaving space if necessary."
}], "Notes",
 CellID->14604],

Cell["Possible overall spacings between items are:", "Notes",
 CellID->10543171],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["h", "TI"], Cell["\<\
an absolute number of printer\[CloseCurlyQuote]s points\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "a fraction ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " of the height of an item"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->419979668],

Cell[TextData[{
 "The default spacing used by ",
 Cell[BoxData[
  ButtonBox["GraphicsColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFormula"],
 " is effectively ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", "0.1", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->609767650],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be any expressions, not just graphics. "
}], "Notes",
 CellID->27440],

Cell["The following options can be given:", "Notes",
 CellID->17421],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"], ",", 
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]}], "}"}], Cell[
    "horizontal and vertical alignment of elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width for the whole column", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what background colors to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to align with a surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the column", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw divider lines in the column", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw frames in the column", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "style to use for frames ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the whole graphics column", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Spacings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Spacings"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", "0.1", "]"}], Cell[
    "horizontal and vertical spacings ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->333],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " include: "
}], "Notes",
 CellID->82840319],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "frame around the whole column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "frame around every item in the column", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->412715870],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphicsColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsColumn"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["alignment", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"Alignment", "->", 
     StyleBox["alignment", "TI"]}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8938],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphicsColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsColumn"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["alignment", "TI"], ",", 
    StyleBox["spacing", "TI"]}], "]"}]], "InlineFormula"],
 " corresponds to the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Spacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacings"], "->", 
   StyleBox["spacing", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->762899072],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " can be lists giving settings for each item in the column."
}], "Notes",
 CellID->181332697],

Cell[TextData[{
 "Settings for the options ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ItemStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemStyle"]], "InlineFormula"],
 " can be given as follows to apply separately to successive items in the \
column: "
}], "Notes",
 CellID->169430293],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " in all cases "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", then repeatedly use ",
     StyleBox["c", "TI"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", then repeatedly use ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     ", but use ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["{",
      GridElementStyleOptions -> {ColumnAlignments -> Left}], 
     RowBox[{
      StyleBox[
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["1", "TR"]],
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["2", "TR"]],
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox["\[Ellipsis]", "TR",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      RowBox[{
       StyleBox["{",
        GridElementStyleOptions -> {ColumnAlignments -> Left}], 
       RowBox[{
        StyleBox[
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]],
         GridElementStyleOptions -> {ColumnAlignments -> Left}], 
        StyleBox[",",
         GridElementStyleOptions -> {ColumnAlignments -> Left}], 
        RowBox[{Cell["", "TableText"], 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["2", "TR"]]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{Cell["", "TableText"], 
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["m", "TI"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{Cell["", "TableText"], 
       SubscriptBox[
        StyleBox["s", "TI"], 
        StyleBox["n", "TI"]], Cell["}", "TableText"], 
       StyleBox[" ", "TR"]}]}]}], "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], "", Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", then use the last sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     StyleBox["spec", "TI"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, False, True, True, True, 
      True}}}},
 CellID->144545615],

Cell[TextData[{
 "With settings of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"{", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["m", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", if there are more ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " specified than items in the column, ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " from the beginning are used for the first items, and ones from the end are \
used for the last items. "
}], "Notes",
 CellID->26373273],

Cell[TextData[{
 "Settings such as ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " can effectively be specified for individual items in the column using ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4827],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ItemSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ItemSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphicsColumn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsColumn"]], "InlineFormula"],
 " will keep each item a fixed multiple of its original height, rather than \
making all items the same height."
}], "Notes",
 CellID->8202],

Cell[TextData[{
 "For a column of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " elements, ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can specify settings for the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "+", "1"}]], "InlineFormula"],
 " gaps between elements, starting before the first element, and ending after \
the last element."
}], "Notes",
 CellID->49335815],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->103124118],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all gaps between items "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to successive horizontal and vertical gaps"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->934654743],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can have the same forms as for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and other item-oriented options."
}], "Notes",
 CellID->405888177],

Cell[TextData[{
 "The following settings can be used for ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->3429],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axis",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axis"], Cell[
    "axis of the middle row in the column (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "baseline of the middle row in the column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "bottom of the whole column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "halfway from top to bottom ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "top of the whole column ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["pos", "TI"]}], "}"}], Cell[TextData[{
     "position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in element ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->15885],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<GraphicsColumn\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118972557],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->71083772],

Cell["Display graphics in a column:", "ExampleText",
 CellID->1211463373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{"Disk", "[", "]"}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Disk", "[", "]"}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772452804],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -193.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -580.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -967.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{79, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->714826816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1075630713],

Cell["Put a frame around every element:", "ExampleText",
 CellID->608052945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1818654189],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -193.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -580.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -967.5}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -387.}}], 
      LineBox[{{0, -387.}, {0, -774.}}], LineBox[{{0, -774.}, {0, -1161.}}], 
      LineBox[{{378., 0}, {378., -387.}}], 
      LineBox[{{378., -387.}, {378., -774.}}], 
      LineBox[{{378., -774.}, {378., -1161.}}], LineBox[{{0, 0}, {378., 0}}], 
      LineBox[{{0, -387.}, {378., -387.}}], 
      LineBox[{{0, -774.}, {378., -774.}}], 
      LineBox[{{0, -1161.}, {378., -1161.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{76, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1070775194]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20648],

Cell["Set a background for each successive entry:", "ExampleText",
 CellID->986206772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue", ",", "Green"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->898429458],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0, 1, 0], RectangleBox[{0, -774.}, {378., -1161.}]}, 
    {RGBColor[0, 0, 1], RectangleBox[{0, -387.}, {378., -774.}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{0, 0}, {378., -387.}]}}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -193.5}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     Background->RGBColor[1, 0, 0]], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -580.5}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     Background->RGBColor[0, 0, 1]], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {189., -967.5}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     Background->RGBColor[0, 1, 0]]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{76, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605723698]
}, Open  ]],

Cell["Align contents to the left:", "ExampleText",
 CellID->602122135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"10", "i"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->689048489],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->10], {1.25, -27.083333333333332`}, 
     ImageScaled[{0, 0.5}], {10, 10.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->20], {1.25, -81.25}, ImageScaled[{0, 0.5}], {20, 20.}], 
    InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->30], {1.25, -135.41666666666666`}, 
     ImageScaled[{0, 0.5}], {30, 30.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->40], {1.25, -189.58333333333331`}, 
     ImageScaled[{0, 0.5}], {40, 40.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->50], {1.25, -243.75}, ImageScaled[{0, 0.5}], {50, 50.}]}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -54.166666666666664`}}], 
      LineBox[{{0, -54.166666666666664`}, {0, -108.33333333333333`}}], 
      LineBox[{{0, -108.33333333333333`}, {0, -162.5}}], 
      LineBox[{{0, -162.5}, {0, -216.66666666666666`}}], 
      LineBox[{{0, -216.66666666666666`}, {0, -270.8333333333333}}], 
      LineBox[{{52.5, 0}, {52.5, -54.166666666666664`}}], 
      LineBox[{{52.5, -54.166666666666664`}, {52.5, -108.33333333333333`}}], 
      LineBox[{{52.5, -108.33333333333333`}, {52.5, -162.5}}], 
      LineBox[{{52.5, -162.5}, {52.5, -216.66666666666666`}}], 
      LineBox[{{52.5, -216.66666666666666`}, {52.5, -270.8333333333333}}], 
      LineBox[{{0, 0}, {52.5, 0}}], 
      LineBox[{{0, -54.166666666666664`}, {52.5, -54.166666666666664`}}], 
      LineBox[{{0, -108.33333333333333`}, {52.5, -108.33333333333333`}}], 
      LineBox[{{0, -162.5}, {52.5, -162.5}}], 
      LineBox[{{0, -216.66666666666666`}, {52.5, -216.66666666666666`}}], 
      LineBox[{{0, -270.8333333333333}, {52.5, -270.8333333333333}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  ImageSize->{64.5, 282.8333333333333},
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{69, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->236602521]
}, Open  ]],

Cell["Align contents to the right:", "ExampleText",
 CellID->432210877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsColumn", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"10", "i"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16742919],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->10], {51.25, -27.083333333333332`}, 
     ImageScaled[{1, 0.5}], {10, 10.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->20], {51.25, -81.25}, ImageScaled[{1, 0.5}], {20, 20.}], 
    InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->30], {51.25, -135.41666666666666`}, 
     ImageScaled[{1, 0.5}], {30, 30.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->40], {51.25, -189.58333333333331`}, 
     ImageScaled[{1, 0.5}], {40, 40.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->50], {51.25, -243.75}, ImageScaled[{1, 0.5}], {50, 50.}]}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -54.166666666666664`}}], 
      LineBox[{{0, -54.166666666666664`}, {0, -108.33333333333333`}}], 
      LineBox[{{0, -108.33333333333333`}, {0, -162.5}}], 
      LineBox[{{0, -162.5}, {0, -216.66666666666666`}}], 
      LineBox[{{0, -216.66666666666666`}, {0, -270.8333333333333}}], 
      LineBox[{{52.5, 0}, {52.5, -54.166666666666664`}}], 
      LineBox[{{52.5, -54.166666666666664`}, {52.5, -108.33333333333333`}}], 
      LineBox[{{52.5, -108.33333333333333`}, {52.5, -162.5}}], 
      LineBox[{{52.5, -162.5}, {52.5, -216.66666666666666`}}], 
      LineBox[{{52.5, -216.66666666666666`}, {52.5, -270.8333333333333}}], 
      LineBox[{{0, 0}, {52.5, 0}}], 
      LineBox[{{0, -54.166666666666664`}, {52.5, -54.166666666666664`}}], 
      LineBox[{{0, -108.33333333333333`}, {52.5, -108.33333333333333`}}], 
      LineBox[{{0, -162.5}, {52.5, -162.5}}], 
      LineBox[{{0, -216.66666666666666`}, {52.5, -216.66666666666666`}}], 
      LineBox[{{0, -270.8333333333333}, {52.5, -270.8333333333333}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  ImageSize->{64.5, 282.8333333333333},
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{69, 283},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6481352]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30935],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsRow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsRow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24370]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18345],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->25408]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->37330176],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->301292036],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->308029303],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->608236830],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->248653047],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->904418490]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphicsColumn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 14.4577962}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GraphicsColumn[{g_1, g_2, ...}] generates a graphic in which the g_i are \
laid out in a column, with g_1 above g_2, etc. GraphicsColumn[list, \
alignment] aligns each element horizontally in the specified way. \
GraphicsColumn[list, alignment, spacing] leaves the specified spacing between \
successive elements.", "synonyms" -> {"graphics column"}, "title" -> 
    "GraphicsColumn", "type" -> "Symbol", "uri" -> "ref/GraphicsColumn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[32756, 1060, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118972557]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47601, 1507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2924, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3547, 93, 1579, 37, 70, "ObjectNameGrid"],
Cell[5129, 132, 1982, 63, 70, "Usage",
 CellID->12073]
}, Open  ]],
Cell[CellGroupData[{
Cell[7148, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7626, 217, 252, 8, 70, "Notes",
 CellID->153],
Cell[7881, 227, 58, 1, 70, "Notes",
 CellID->31511],
Cell[7942, 230, 1303, 33, 70, "2ColumnTableMod",
 CellID->5521],
Cell[9248, 265, 311, 8, 70, "Notes",
 CellID->14604],
Cell[9562, 275, 80, 1, 70, "Notes",
 CellID->10543171],
Cell[9645, 278, 747, 22, 70, "2ColumnTableMod",
 CellID->419979668],
Cell[10395, 302, 386, 14, 70, "Notes",
 CellID->609767650],
Cell[10784, 318, 201, 8, 70, "Notes",
 CellID->27440],
Cell[10988, 328, 68, 1, 70, "Notes",
 CellID->17421],
Cell[11059, 331, 3489, 97, 70, "3ColumnTableMod",
 CellID->333],
Cell[14551, 430, 199, 8, 70, "Notes",
 CellID->82840319],
Cell[14753, 440, 919, 24, 70, "2ColumnTableMod",
 CellID->412715870],
Cell[15675, 466, 569, 21, 70, "Notes",
 CellID->8938],
Cell[16247, 489, 534, 19, 70, "Notes",
 CellID->762899072],
Cell[16784, 510, 364, 12, 70, "Notes",
 CellID->181332697],
Cell[17151, 524, 792, 29, 70, "Notes",
 CellID->169430293],
Cell[17946, 555, 7778, 255, 70, "2ColumnTableMod",
 CellID->144545615],
Cell[25727, 812, 978, 34, 70, "Notes",
 CellID->26373273],
Cell[26708, 848, 632, 23, 70, "Notes",
 CellID->4827],
Cell[27343, 873, 548, 18, 70, "Notes",
 CellID->8202],
Cell[27894, 893, 604, 21, 70, "Notes",
 CellID->49335815],
Cell[28501, 916, 348, 13, 70, "Notes",
 CellID->103124118],
Cell[28852, 931, 1083, 33, 70, "2ColumnTableMod",
 CellID->934654743],
Cell[29938, 966, 485, 18, 70, "Notes",
 CellID->405888177],
Cell[30426, 986, 227, 8, 70, "Notes",
 CellID->3429],
Cell[30656, 996, 1709, 47, 70, "2ColumnTableMod",
 CellID->15885],
Cell[32368, 1045, 351, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[32756, 1060, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118972557],
Cell[CellGroupData[{
Cell[33141, 1074, 147, 5, 70, "ExampleSection",
 CellID->71083772],
Cell[33291, 1081, 73, 1, 70, "ExampleText",
 CellID->1211463373],
Cell[CellGroupData[{
Cell[33389, 1086, 365, 11, 28, "Input",
 CellID->772452804],
Cell[33757, 1099, 557, 14, 237, "Output",
 CellID->714826816]
}, Open  ]],
Cell[34329, 1116, 126, 3, 70, "ExampleDelimiter",
 CellID->1075630713],
Cell[34458, 1121, 76, 1, 70, "ExampleText",
 CellID->608052945],
Cell[CellGroupData[{
Cell[34559, 1126, 433, 13, 70, "Input",
 CellID->1818654189],
Cell[34995, 1141, 1018, 23, 237, "Output",
 CellID->1070775194]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36062, 1170, 216, 7, 70, "ExampleSection",
 CellID->20648],
Cell[36281, 1179, 86, 1, 70, "ExampleText",
 CellID->986206772],
Cell[CellGroupData[{
Cell[36392, 1184, 505, 15, 70, "Input",
 CellID->898429458],
Cell[36900, 1201, 861, 20, 237, "Output",
 CellID->605723698]
}, Open  ]],
Cell[37776, 1224, 70, 1, 70, "ExampleText",
 CellID->602122135],
Cell[CellGroupData[{
Cell[37871, 1229, 504, 15, 70, "Input",
 CellID->689048489],
Cell[38378, 1246, 1995, 40, 304, "Output",
 CellID->236602521]
}, Open  ]],
Cell[40388, 1289, 71, 1, 70, "ExampleText",
 CellID->432210877],
Cell[CellGroupData[{
Cell[40484, 1294, 504, 15, 70, "Input",
 CellID->16742919],
Cell[40991, 1311, 1998, 40, 304, "Output",
 CellID->6481352]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43050, 1358, 311, 9, 70, "SeeAlsoSection",
 CellID->30935],
Cell[43364, 1369, 945, 35, 70, "SeeAlso",
 CellID->24370]
}, Open  ]],
Cell[CellGroupData[{
Cell[44346, 1409, 314, 9, 70, "TutorialsSection",
 CellID->18345],
Cell[44663, 1420, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[44969, 1431, 166, 3, 70, "Tutorials",
 CellID->25408]
}, Open  ]],
Cell[CellGroupData[{
Cell[45172, 1439, 318, 9, 70, "MoreAboutSection",
 CellID->37330176],
Cell[45493, 1450, 173, 3, 70, "MoreAbout",
 CellID->301292036],
Cell[45669, 1455, 147, 3, 70, "MoreAbout",
 CellID->308029303],
Cell[45819, 1460, 140, 3, 70, "MoreAbout",
 CellID->608236830],
Cell[45962, 1465, 142, 3, 70, "MoreAbout",
 CellID->248653047],
Cell[46107, 1470, 179, 3, 70, "MoreAbout",
 CellID->904418490]
}, Open  ]],
Cell[46301, 1476, 27, 0, 70, "History"],
Cell[46331, 1478, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

