(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    390306,       9950]
NotebookOptionsPosition[    369048,       9207]
NotebookOutlinePosition[    370401,       9245]
CellTagsIndexPosition[    370314,       9240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"], "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       2->"\<\"Redrawing and Combining Plots\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsRow" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsRow"], 
          "GraphicsColumn" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsColumn"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"], "PackingMethod" :> 
          Documentation`HelpLookup["paclet:ref/PackingMethod"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GraphicsRow\"\>", 
       2->"\<\"GraphicsColumn\"\>", 3->"\<\"Grid\"\>", 4->"\<\"Inset\"\>", 
       5->"\<\"PackingMethod\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Combining Graphics\"\>", 3->"\<\"Data Visualization\"\>", 
       4->"\<\"Graphics Options & Styling\"\>", 5->"\<\"Grids & Tables\"\>", 
       6->"\<\"Layout & Tables\"\>", 7->"\<\"Symbolic Graphics Language\"\>", 
       8->"\<\"New in 6.0: Notebooks & Documents\"\>", 
       9->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphicsGrid", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsGrid",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsGrid"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["g", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["g", "TI"], 
            StyleBox["12", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a graphic in which the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["ij", "TI"]]], "InlineFormula"],
     " are laid out in a two-dimensional grid."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21228]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " are graphics with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " will if possible resize them to make them fit into the grid as well as \
possible, while preserving their individual aspect ratios. "
}], "Notes",
 CellID->14604],

Cell[TextData[{
 "The output from ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " can interactively be resized, or edited as a graphic."
}], "Notes",
 CellID->153],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["list", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " do not all need to be the same length; there will be empty space in the \
grid at the ends of shorter rows. "
}], "Notes",
 CellID->14640],

Cell[TextData[{
 "You can specify that an element ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " should span multiple positions in a grid using for example ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["e", "TI"], ",", "SpanFromLeft", ",", "SpanFromLeft"}], "}"}],
      ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6860],

Cell["\<\

The following specify that a particular position should be spanned: \
\>", "Notes",
 CellID->8046],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanFromLeft",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromLeft"], Cell[
    "span from left ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanFromAbove",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromAbove"], Cell[
    "span from above ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanFromBoth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanFromBoth"], Cell[
    "span from both left and above ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->28627],

Cell[TextData[{
 "A particular element can span both multiple rows and multiple columns, by \
having a rectangular section of the array with the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["e", "TI"], ",", 
      ButtonBox["SpanFromLeft",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromLeft"], ",", 
      ButtonBox["SpanFromLeft",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromLeft"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ","}]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      ButtonBox["SpanFromAbove",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromAbove"], ",", 
      ButtonBox["SpanFromBoth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromBoth"], ",", 
      ButtonBox["SpanFromBoth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SpanFromBoth"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5044],

Cell["The following options can be given:", "Notes",
 CellID->26500],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"], ",", 
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]}], "}"}], Cell[
    "horizontal and vertical alignment of elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width for the whole grid", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what background colors to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to align with the surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the grid", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw divider lines in the grid", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw frames in the grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "styles to use for frames ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the whole graphics grid", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ItemAspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ItemAspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width for each item", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Spacings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Spacings"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", "0.1", "]"}], Cell[
    "horizontal and vertical spacings ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->333],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AspectRatio",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AspectRatio"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the aspect ratio of the whole graphics grid will be chosen so as to best \
fit the individual objects in the grid."
}], "Notes",
 CellID->15724],

Cell[TextData[{
 "Settings for the options ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"], " "}]], "InlineFormula"],
 "can be given as follows to apply separately to different items: "
}], "Notes",
 CellID->8756],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all items "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     SubscriptBox[
      StyleBox["spec", "TI"], 
      StyleBox["x", "TI"]], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " at successive horizontal positions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " at successive horizontal and vertical positions"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    FormBox[
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["x", "TI"]], ",", 
       SubscriptBox[
        StyleBox["spec", "TI"], 
        StyleBox["y", "TI"]], ",", 
       StyleBox["rules", "TI"]}], "}"}],
     TraditionalForm], Cell[TextData[{
     "also allow explicit rules for individual ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"],
     " elements"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->11051],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->25391],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "1"], TraditionalForm]], "InlineMath"],
     " through ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "n"], TraditionalForm]], "InlineMath"],
     "; then use defaults "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      StyleBox["c", "TI"], "}"}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " in all cases "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]]}], "}"}], "}"}], Cell[TextData[{
     "alternate between ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "1"], TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "2"], TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}], Cell[TextData[{
     "cycle through all ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     ", then repeatedly use ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      RowBox[{"{", 
       StyleBox["c", "TI"], "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "1"], TraditionalForm]], "InlineMath"],
     ", then repeatedly use ",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     ", but use ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "n"], TraditionalForm]], "InlineMath"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["s", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]]}]}]}], Cell[", ", "TableText"], 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]], Cell[", \[Ellipsis] }, ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], Cell[", \[Ellipsis] , ", "TableText"], 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]], Cell["}", "TableText"], 
      StyleBox[" ", "TR"]}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     " at the beginning, then cyclically use the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
     ", then use the last sequence of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     " at the end "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      RowBox[{"{", "}"}], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["m", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], Cell[TextData[{
     "use the first sequence of ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
     " at the beginning and the last sequence at the end"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "specify what to use at positions ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["i", "k"], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["spec", "TI"], ",", 
      StyleBox["rules", "TI"]}], "}"}], Cell[TextData[{
     "use ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " to override specifications in ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->16534],

Cell[TextData[{
 "With settings of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["s", "1"], ",", 
     SubscriptBox["s", "2"], ",", "\[Ellipsis]", ",", 
     RowBox[{"{", "\[Ellipsis]", "}"}], ",", 
     SubscriptBox["s", "m"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["s", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 ", if there are more ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
 " specified than items across the grid, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["s", "i"], TraditionalForm]], "InlineMath"],
 " from the beginning are used for the first items, and ones from the end are \
\nused for the last items. "
}], "Notes",
 CellID->26373273],

Cell[TextData[{
 "Settings such as ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " can effectively be specified for individual items in the grid using ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4827],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " will not change the size of graphics or other objects that have explicit \n\
",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " settings, unless the ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " itself is resized or given an overall ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " setting."
}], "Notes",
 CellID->11176],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " include: "
}], "Notes",
 CellID->13269],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "frame around the whole grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "frame around every item in the grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"], ",", 
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]}], "}"}], Cell[
    "put a frame at every horizontal position (column lines) ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"], ",", 
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]}], "}"}], Cell[
    "put a frame at every vertical position (row lines)", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->5388],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can have the following forms:"
}], "Notes",
 CellID->103124118],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["spec", "TI"], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     " to all gaps between items "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to successive horizontal and vertical gaps"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->934654743],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can have the same forms as for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " and other item-oriented options."
}], "Notes",
 CellID->405888177],

Cell[TextData[{
 "For a grid with ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " items in a particular direction, ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Spacings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacings"]], "InlineFormula"],
 " can specify settings for the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", "+", "1"}], TraditionalForm]], "InlineMath"],
 " gaps between elements, starting before the first element, and ending after \
the last element."
}], "Notes",
 CellID->49335815],

Cell[TextData[{
 "The following settings can be used for ",
 Cell[BoxData[
  ButtonBox["BaselinePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaselinePosition"]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->3429],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axis",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axis"], Cell[
    "axis of the middle row in the grid (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "baseline of the middle row in the grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell[
    "bottom of the whole grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell[
    "halfway from top to bottom ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "top of the whole grid ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"]}], "}"}], ",", 
      StyleBox["pos", "TI"]}], "}"}], Cell[TextData[{
     "position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     " in element ",
     Cell[BoxData[
      FormBox[
       RowBox[{"i", ",", "j"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->15885],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<GraphicsGrid\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->218126754],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->227006904],

Cell["Display elements in a graphics grid:", "ExampleText",
 CellID->255138841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", "]"}], "]"}], ",", " ", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", " ", "\n", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"Disk", "[", "]"}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209490826],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[RectangleBox[{0, 0}]], {192., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[DiskBox[{0, 0}]], {576., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[DiskBox[{0, 0}]], {192., -576.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}]], {576., -576.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, {}},
  ContentSelectable->True,
  ImageSize->{99., Automatic},
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{103, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->856648832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344040015],

Cell["Put a frame around every element:", "ExampleText",
 CellID->20121397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{"Rectangle", "[", "]"}], "]"}], ",", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", " ", "\n", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{"Disk", "[", "]"}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Rectangle", "[", "]"}], "]"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236225215],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[RectangleBox[{0, 0}]], {192., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[DiskBox[{0, 0}]], {576., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[DiskBox[{0, 0}]], {192., -576.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[RectangleBox[{0, 0}]], {576., -576.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -384.}}], 
      LineBox[{{0, -384.}, {0, -768.}}], LineBox[{{384., 0}, {384., -384.}}], 
      LineBox[{{384., -384.}, {384., -768.}}], 
      LineBox[{{768., 0}, {768., -384.}}], 
      LineBox[{{768., -384.}, {768., -768.}}], LineBox[{{0, 0}, {384., 0}}], 
      LineBox[{{384., 0}, {768., 0}}], LineBox[{{0, -384.}, {384., -384.}}], 
      LineBox[{{384., -384.}, {768., -384.}}], 
      LineBox[{{0, -768.}, {384., -768.}}], 
      LineBox[{{384., -768.}, {768., -768.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  ImageMargins->0.,
  ImageSize->{99., Automatic},
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{103, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->966549936]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->371246094],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frames and Grid Lines",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->511949576],

Cell["Put a frame around the whole grid:", "ExampleText",
 CellID->61301763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62846654],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtMHDEQNWffh184PgrHQaRLR0lJSZXQRKKk5IQiHVKiIEJBR0lJSUlJ
SQokypSUlJSUlJSUl2fP7nrX58W3MXSz0q7sebOzz/b4s+9b/3jw/Wf/+GC/
3/t61D8cHOz/7n35dQSTnBBC3OD+0REoD1Ey981wOCQAl9QWc4k/eEyMWGf0
o/n4+PjXXKenp7e3tyg8PDyItVewT/+JvRZzzstwUj8U8JOTk/X19V6vV9va
2hJNvLq9vY0iGQeDwd3dnfhYyXv5Hb2rMZnxtr2pH/Wnp6e9vT24n52d6X4i
K/rw4uJic3MT0e7v78VCBd/Fd/KtwmHK2+KGfkg4omsuLy/FrKkjRzY2NtBz
oh3A5yPxUPxJL2tlHi8vLwNzoUBx8AYG+vn5mebZqx6zb+AR/kqznL/EwKDh
umjGUWJaJm9NB/CZSDwUv+FlLc3j8PDw/PxcF5fSsUKgbOV4BZ+KxEPx617W
NeOF3MIc0UW9TtQwQK0S+2RFe1mcHJtmxgYXZiumqu5ls75JJA0mqZ6hNBfL
8WYkHoqvLONGnjH1+Irxvr6+3tnZSXs7PxodB29E4qH40scWix4ahyZ1jQsW
ETTM5m4GCxdXkXgofs2yrWdsMfuwaohV44vFGzuXjUWgLnYdXEXiofherphj
mGkJV+wyaKeNRaCNZXEViYfie7m2Wi09BubsIzudDlI+9RWSQF1cdXAZiXvj
qwy3TBUxxRxst9vm9NbIMqVodzJISMJ0cW0cvCyuytuLrKhviVXW70V7bjxq
znisjYOXxVV5e5EV7U3ECgstllvyytllZk++SphlFcDL4qq8vcgK8x3nFmIF
d7xEXjm7zOzJVwmzrAJ4WVyVtxdZIf2QhMQKXYsOJq+cXWb25KuEWVYBvCyu
yttH5iVNhWTe4C3U9T5E88rOo66Dq0g8FN+7htCgJ1xtpkgnk7oOriLxUHwv
V9oUE652x6RYdsfsOriKxEPxc1ztDo1uRwpjJFbSUaBq8jVbd/F6JB6K7z1P
4EJj0CTyprIu1p16x6k3IvFQ/BzbwunSnubodGdPe420vSV4MxIPxc+dLkdO
5/DHW3rPNn/xEgmFtNLFZgBvReKh+H7WbubrPxF95p8qsU9XtJfF8f+XqTQ3
4K3bsJDOw+SPZDqAz0Tiofh+1vW0jUm+zKX5gpUOscSHAD4XiYfit7ysTZYr
+OMAhebB3bReIcNxesZSgqW6PYbP/Bv5jPMtv4ZiZkYd2wx2QVICcLqgUWkg
DIDd3V1g+C/AoC5W8l56R+9qTPyqF80vHDXxB4Q+EjWzjmLgcY5BCW+jL6+u
rnQ2L1fw7byTbxUOfmWTshvJkPyb9Jz650Dd9W97v+LXvFkJZyWclXBWwlkJ
ZyU8/6/CSjgr4ayEsxLOSvhIXFbCR3FWwlkJZyWclXCnzko4K+GshLMSzko4
K+GshLMSzkr4+L6shBc9WAlnJZyVcFbCWQlnJZyVcMFKOCvhrISzEs5KOCvh
rISzEs5KuJc1K+GshJf7shJurbpO1x/cE1Sd+AeWcnCW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227406638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->545138637],

Cell["Put a frame around every element:", "ExampleText",
 CellID->861064787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393168623],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWT1M3EgUHtY23uTys4qihGzupL2OkpKS6o4mEiUlKDppI10UlKSgo6Sk
pKSkJEUkypSUlJSUlJSUm2/mzY6f33jXNoupnqVd2fO+99434/n192H3+/i/
z7vfP33cHf37dXdv/Onjt9E/X76iKFkyxvzE7/8Vg/sJ7tzv52QyIQOuxJa4
y/xt/+Y8j2rs9nkpivrM/uXX19e/3HVwcHB+fo6bq6sr80JE+GMO9mULrIz7
kBziGj6xfyns+/v7q6uro9Got7GxYXK4bm5u4pYKx+PxxcUFxWfe/Vbezxby
lrkfm3ncdrn9y25ubnZ2dgA/PDy07UyleAfHx8fr6+uIdnl5SWyZ73IL36cL
+Mq8j8k5bjEXIQEQTXtycmKeu2f00bW1NbQ8vRWGz2rwkmEdXsbvgk9c69T9
3d3djd2Fm4Hzgwc62u3tredReCS1HnlrD5mjK1Yz6p+gY6Dh7O0r94xpyXtl
VXnm4Ct5tYjfBZ+41uS1t7d3dHRkb19P+woCFSwKfK8GL1nV4WX8LvjEtSYv
jA3MEfb2Df566CAu+nLA4SLMW2/PauzV7O6Xx7POOQqzGqY0+zbfusjo3JjM
7EyWlCMGoMSlDXEuXge5fa1Kdae3986hz87Otra2QttlAUcgI1FJI1Qvau9F
c0b1wNKCWqOyQwt5gqkWVfbdwGECwDhEEhClrAKViTi+RwlU62yefVFTzBmY
K817C+hjycR+g0cjs7MmwUpc0giRCX/PmRD2dtg6S8QXoxtj3PPF+o668khk
pkjBWuLLEJnw93wJUfBtkyXi2+/37bv40wLylZUVjJEQhtv6wSbMzppyT2JJ
Vnv7vi52ymN7hr41MFgHg8FfFrVc9BRjWHku+hiZjLDxcGZuvJTHK7OhtiTv
4i0Yw8rzUM5NRth4ODM3XsrjldnQCkremKIxUZM3K89DOTcZYePhzNx4KY9X
ZoNxjV0deQMOJ/Jm5Xko5yYjbDycmRsv5fHKbNC30MPIG02JBiVvVp6Hcm4y
wsbDmbnxUh4vGmfUxf28AC88o8+FBGSmERuspXmBITLh70dcMcKGrbNEfOlF
e77UA0JLBTNFCtYSX4bIhL/nW/SxYessEV9aBD3fsOsKkchMkYo9GefLEJnw
93yLdXbYOku0KqP50Y3xNt5N3wY9ltbcolSikkYosbt4gJxVuyRUE5UlNN2H
ti3eDxmMRCWNUPEuadGcVXvYYj9I+8NiXyn2kQEocWlDXLyHfZjcs84TgMPJ
rrdv3DM6KbpqaP8Sk9nYtAWWTkvd8Zh1XizGqD1vhZNRxCTGyVPxLFz16Xax
vLPO/OizQNs2oDMzOrA/r1WzmI2vPvM3j98Fn7jW2bSN/Fig777o45j57XlH
frVJa/Dy+1MdXsbvgs+Mr3op8Nh4onkAd19bU4xqnDQw+WLpq/ySVuNT+XWv
ZZ4uucUt4SJlWPKxM6HvRdjtUbxlhIFhe3sbNpzB0Kmqv8029ZZfhdt5y9yP
zTxuO6oPjgo4qdqdc8+tb+h4duNqDLzxLk5PT+1orNQCGvpKFaKNr8z7mJzj
FqPRic7oz6lSZXoh7IMau/S/T3xiqfqc6nOqz6k+p/pccw/V57rko/oc91J9
TvW5++ZUfU71OdXnVJ9TfU71OdXnppFUn3uYnKrPTVSfa4BVfU71OdXnVJ9T
fU71OdXnVJ9TfU71OdXnVJ8jD9XnVJ9TfU71OdXnJqrPqT6n+tw0q+pzqs+p
PleRRfU51eea5FR9bqL6XAOs6nOqz6k+p/qc6nOqz6k+11af60qZs890/cBv
iR6XfgOaAUA3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144558867]
}, Open  ]],

Cell["Draw all the frames in red:", "ExampleText",
 CellID->1058702674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1713826523],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXD1MHEcUHm532XPiOCiKbIwT6dJRUlJSJTSWKClBVqSzlCjIcUFHSUlJ
SUlJCiTKlJSUlJSUlJTnb+bNzbx9s3e7y7FU7yQvu/O+9943s/O7n+SP+1/H
f/69//Xzp/3RH1/2D8afP/07+v2fLyjKlowxl/j316rB/QR37t/lZIK/l/be
mAx/Ju5nfrOXOc+jBrt9XkqivraX8u7u7n/3Ozo6urq6ws3t7a15IyJ8Pwf7
YwesjPucHNIavrKXHPbDw8P19fXRaDTY2toyJVy3t7dxS4Xj8fj6+priM+9h
J+/XC3nL3C/NPG270l6K+/v7vb09wI+Pj207Uynewenp6ebmJqLd3NwQW+a7
3MH3uwV8Zd6X5Jy2mIuQAYimPTs7Mz+4Z/TRjY0NtDy9FYYvGvCSYRNexu+D
T1rr3F0eHx/H7oebFecHD3S0h4cHzyN6ZI0eZWcPmaMvVjPqn6FjoOHs7U/u
GdOS9yrq8szB1/LqEL8PPmmtyevg4ODk5MTe/jztKwgUWUT8oAEvWTXhZfw+
+KS1Ji+MDcwR9vYtLgN0EBd9OeDwI8w7by8a7PXsnpbHsy45CrMapjT7Nt+5
yOjcmMzsTJZVIwagxOUtcS5eD7l9rSp1p7f33qEvLi52dnZC2xUBRyAjUVkr
1CBp70VzJvXA0oJao7JrFvIKUy2q7JM5TAAYh8gCopJVoAoRx/cogeqczbOP
NcWcgbnSfLCAIZZM7Dd4NDI7axasxCVPEIXw95wJYW/XOmdJ+GJ0Y4x7vljf
UVceicwUKVgrfBmiEP6eLyEi3y5ZEr7D4dC+i18soFxdXcUYCWG4bRhtVbOz
5tyTWJLV3n5oip3z2J6hbw0M1pWVlV8tajn2JWNYeSn6GJmMtLFwZm68nMer
sqG2JO/wFmBi5WUsZyYjbSycmRsv5/GqbGgFJW9M0ZioyZuVl7GcmYy0sXBm
brycx6uywbjGro68AYcTebPyMpYzk5E2Fs7MjZfzeFU26FvoYeSNpkSDkjcr
L2M5MxlpY+HM3Hg5j5eMM+rifl6AF57R50ICMtOIDdbKvMAQhfD3Iy6MIj8v
dMmS8KUX7flSDwgtFcwUKVgrfBmiEP6eb+hLnm+XLAlfWgQ937DrCpHITJHi
nozzZYhC+Hu+cZ1d65wlWZXR/OjGeBvvp2+DHitrbiyVqKwVSuwuniFn3S4J
1URlCU33oW3j+yGDkaisFSrdJS2as24PG/eDtD+M+0qxjwxAictb4tI97PPk
nnWeABxOdr19657RSdFVQ/tXmMzG5h2wdFrqj8es82Ico/a8FU5GCZMUJ0/F
s3D1p9vF8s4686PPAm3bgM7M6MD+vFbPYja+/szfPn4ffNJaF9M28mOBvvui
j2Pmt+cd+dUmb8DL709NeBm/Dz4zvurlwGPjieYB3H1tzTGqcdLA5Iulr/ZL
WoNP7de9jnn65Ja2hItUYMnHzoS+F2G3R/GWEQaG3d1d2HAGQ6eq/zbb1lt+
Fe7mLXO/NPO07ag+OCrgpGp3zgO3vqHj2Y2rMfDGuzg/P7ejsVYLaOkrVYgu
vjLvS3JOW4xGJzqjP6dKlemNsK802KX/U+ITS9XnVJ9TfU71OdXn2nuoPtcn
H9XnuJfqc6rPPTWn6nOqz6k+p/qc6nOqz6k+N42k+tzz5FR9bqL6XAus6nOq
z6k+p/qc6nOqz6k+p/qc6nOqz6k+p/oceag+p/qc6nOqz6k+N1F9TvU51eem
WVWfU31O9bmaLKrPqT7XJqfqcxPV51pgVZ9TfU71OdXnVJ9TfU71ua76XG/K
nC1w/5Hmf7gsuSez9A0Wja3l\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3351436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88007557],

Cell["Put a frame around the first row and column:", "ExampleText",
 CellID->205713954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", 
      RowBox[{"{", "True", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123321595],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjFMIzkUNfHMJCFZCLurIxs4KVucRElJSXVHcxIlJWh1Ula606G9Lego
ae5ESUlJyUm3EuWVlJSUlJSUlLln/4nt8TjxzGajZA5HYtbj922///3t8bzZ
n48+D3757ejzxw9H/Z8+HR0PPn74o//j759QxZcYY1/w92uXoTxESf59GQ7x
7w8onssS46JW/th7cTHu/8pZtMWl/vDw8K/8nZ6e3tzcoHB/f89WrNatCbbf
fyW2OQHr5Ng2xSUCdnJysrW11e/3a7u7u6yOZnt7eyhS5WAwuL29Jb5G60ap
1usztP6ulPWrXBzq4hI/Pj4eHh7C9OzsTMSLahHLi4uLnZ0d9HR3d0cxM9om
Jdq+mZHt6xK2rZz30gMOI4To8vKS4sORN9vb24ggzbNhH3vs16bEOx58OedB
JC/Pz88D+UOB+oA1Jv/p6Sn1Ubfg3havvoFF22vRcPvCMVkIgCjKueVYwmmL
2OXJBPv2lHjLg9dzHhCj4+Pj83O5hb4dzR860R5q+5rHfnlKvOnBk5wHxAi5
h/UkimJ/qWHSJPNE2eFHNusp3hzTblx9Y0x9yqhujoTVjaUtIi73Ro5kwqIW
K5pnWSlD207OFB/fjw9PPHhMrDPxoai/k5bX19f7+/sqvrGyIyNmWyXWvHVL
4rEHj2y+2CrhGhzqybTBdgO30pSQNsqASQuuLNKc/nqcF8GZETOsRuwobEPU
N7Dh48lnMiVYolyhKQvCRLFXEudFcJMlVhjWWcoSzyR4Z7IkmFgqVO+AwPQo
xXFeBDdZNhoNEXM6O3W7XaS4omhiXGM0BoGiuFESrxXBGYuIBFZbp9OR575E
5wRjRr2RK9Q3YaK4WQRPzGyf0K/iRPEkTjrWjBn1xhzUrDnYLILrfrPj2e0U
J3oqESdsqdhYCTbqua6nMQnTnDy47jc7nt1OccKaxjmGOMEYTQg26rmupzEJ
05w8uO43O57dTnFC0iH1iBOCitASbNRzXU9jEqY5eXDdb3Y8u525Din9090C
bXCPTFRLkeCN0WiEpruBXjm9kjgvgpssaaJTlio7FEuCN6zciawc6ZXEeRHc
ZEmPuZSlegYqlgQTS/2EJBb6CdkrifMiuPnERZiRrIj8u1HU6TZzQtC1tlVs
3ZfFoyK4daKBK3CILKmscllHnwBmWyXWfbckHnvwlG/m3KjPZ3Re0+c369yo
DG27+igqY/rx4YkHT8+NufM3bNFCPH3l+z1HUiG1VB5lvBxv2/D05cPrHjzP
3l4F4n1DnOrtN7faGLtWyfrlMfX5N7NolC+wFL68Hq3P9P3D/W453r49Jd7y
4HkP4pGvaS6tjnIJ+6B4h6hbHkQe+9Up8RUP3sx5IFdDBFscrOAmTGUUIqwE
nKKx8WBTdyounjZr38imU8Amr8BIxjEeTnhqklaAcwjxTtAFgIODA2B4V8BE
2xpavVTrtzO0flPKOq+l0VrE4RRvSIgVqzGxHyMZcP5BCS0R06urK5Http7a
LNG2OyPb9RK2eR2Vsh8Jkr7VrFoerlj4e89937pfy43oV+SDZh80+6DZB80+
aPZBs6df0OyDZq9zOmj2Fsug2QfNPmj2QbMPmr2VI0GzHyVG0OyDZj8Mmv0w
aPZBsw+afdDsg2bv0+z/QYdLubFtbf5PXMR/y2eV0edXnYxfpkbfdsbiJen0
y84IVE2rbzq9qK5eXx/vT4U0+8TpRdV0+9jpxby1e4NVxfT7SDOvjIbPXZwX
WMevab4LruU7mS6knu9kuiiafqRwzXL+qn5k1mdZzVHXj8z6LKs5KvuRWZ9l
NUdtPzLrs6zmqO5HZn1uTS6kvu/cPRZS43cyXUid32BaGa3feZIYLrbeb3Cu
mOZvnDUrqvu7PVgU7d/9hlc1/d/tRdW+ATScXvwfvgO41Z2X+S3Arde9pO8B
bs121t8EOs5RJ30NEPf0+5upLwlL/wFvV1HR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101708494]
}, Open  ]],

Cell["Draw different frames with different styles:", "ExampleText",
 CellID->1196540285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Red", "}"}], ",", 
      RowBox[{"{", "Green", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1215699487],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96418279]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144232786],

Cell["Put dividers at all horizontal positions:", "ExampleText",
 CellID->324771918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"All", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->750408934],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXDtMHEkQbe/MMOvzb2VZNqx90l5GSEhIZJOcREgIsk5apDsZ2Q7ICAkJ
CQkJSSwROiQkJCQkJCTkXnc1PT3V8+tdZqNaifFM16vq1z3Vv3mS/979Of3n
v92fe193J1++7+5P977+mHz+9h1FyTOl1C/8/buscP+AO/P36+FB/5voe/NT
f+lLw/Okxa6fdWWLiPpSX/Kbm5vf5nd4eHhxcYGb6+tr9ZpFeNGAfROB5XGf
kkPYwuf6ksJ+cHCwuro6mUwGGxsbKofr5uYmbqlwOp1eXl5SfM97GOX9ci5v
XveimYd9l+tLdnt7u7OzA/jR0ZHuZyrFOzg5OVlfX0e0q6srYuv5LkX4/jGH
L693kZzDHjMREgDRtaenp+qVeUaOrq2toefprXj4rAXPGbbhefw++IStTs3l
/v5+an64GRk/eCDR7u7uLI/CI2n1yKM9eB19sappf4LEQMfp27fmGdOS9cqq
6mnAV/KKiN8Hn7DV5LW/v398fKxv3z3mCgIVLAr8oAXPWbXhefw++IStJi+M
DcwR+vY9LgMkiIm+5HD4EeaDtWct9mp2s9VjWec+CrMapjT9Nj+YyEhuTGZ6
JkvKER2Q49KOOBOvh7ptq0ptp7e3YtDn5+dbW1uu7zKHI5DiqKQTahD097x1
Bu3A0oJWo7FjDXmOqRZNtmlgMA6gDCJxiFKtDJWxODajGCq6Nsu+aCnmDMyV
6qMGDLFkYr/hRyOzsSbOSlzSAJExf8uZEPp2HF1LwBejG2Pc8sX6jrb6kchM
kZy1xNdDZMzf8iVEwTemloDvcDjU7+KTBuTLy8sYIy6Mbxs6GzMba+p7Ekuy
6tuPbbFTP7ZlaHsDg3U0Gv2pUUtFpijllecsx8ikmM0PpxrjpX68MhvqS/Iu
3oJSXnnuyn2TYjY/nGqMl/rxymxoBSVvTNGYqMnbK89duW9SzOaHU43xUj9e
mQ3GNXZ15A04nMjbK89duW9SzOaHU43xUj9emQ1yCxlG3uhKdCh5e+W5K/dN
itn8cKoxXurHC8YZpbidF+CFZ+Scq4DMNGKdtTQveIiM+dsRV4ywcXQtAV96
0ZYvZYDrKWemSM5a4ushMuZv+RY5No6uJeBLi6Dl63ZdLhKZKVKxJ/P5eoiM
+Vu+xTo7jq4lWJXR/UhjvI2Vx7dBj6U1tyjlqKQTiu0unqDOql0SmonGEpru
Xd8W74cMiqOSTqhwlzRvnVV72GI/SPvDYl/J9pEOyHFpR1y4h32auuvOE4DD
Sa+3780zkhSp6vq/xKQem0Zg6bTUH4+682IxRvV5y52MAiYhjp+K63DVp9v5
6q078yNngdZ9QGdmJLA9r1WzqMdXn/m7x++DT9jq7LGP7Fig777Iccz8+rzD
v9qkLXj+/akNz+P3wafmq14KPDae6B7AzdfWFKMaJw1Mvlj6Kr+ktfhUft2L
rKdPbmFPmEgZlnzsTOh7EXZ7FG8JYWDY3t6GDWcwJFX1t9mu3vyrcJw3r3vR
zMO+o/bgqICTqt45D8z6hsTTG1el4I13cXZ2pkdjpRbQ0ZerEDG+vN5Fcg57
jEYnktGeU7nK9JrZRy127j9L/EUpc6L3deEget/szEXvE71P9D7R+0TvE71P
9D7R+0TvE71P9D7R+0TvUw+i98XWInpfF5TofaL3aZTofZyJ6H1x8UXvE71P
9D7R+0Tvq7eL3id6n+h9ovfNyln0PvISvU+jRO+zuSJ6n/mJ3ve0dYveJ3qf
6H2i94ne1xBP9D7R+wxC9D7R+x5/oveJ3id6n+h9oveJ3hfDTfS+2ZmL3id6
Hz1PWuyFMmf/r9Bn/wMG6sOz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->657217616]
}, Open  ]],

Cell["Put dividers at all vertical positions:", "ExampleText",
 CellID->430163479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8273050],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD1MGzEUNrnL3UGghB+VlBYp3RgZGZlalkqMjESoUpBaNaIMbIyMjIyM
jHRAytiRkZGRkZGRMf38nhOj0yXvribbOykX2997z8/2e7bv+9Y56X7/2Tk5
Ouy0vx53et2jw9/tL7+O0RTNGGNu8fvRMigPUKLf7WBg/yP+s88f/Gaoytii
faePj49/6Tk7O+v3+yg8PDyYTxOwjf/EJtlskkfz9h2jfnp6urm52W63azs7
OyaF6O7uLorc2O127+7uzPtK0mtTlK7myQKNdc6+609PTwcHB4DPz8/tPKTU
ijm6vLzc3t6G9v39vVmuILsyJdkqPjRohLP2HQHA0K+urnjcEdZ8a2sLM8Nr
PgFfCsQl+7QCPIL45eWlSw8KrAcJLNzz87OLykkSC28gIfeSeX8jTDQGZou0
LhHSyEk1BHw+EJfsk38modZer3dxcWGLq8O5h6Itzgr4XCAu2Sf/TJ1aERuI
aVu0eVzDhGdj2mcrto+zw73HhCKjkE525mjPibDwSCSbRYmAp4G4ZL/+yks/
ky2q39zc7O3tUfILeD4SquKSffKPj7kI+xDGghGYdaoj0TEQKgp4HIiX6t9J
IXGQ4LbIUthKcW54K+PxOBAv1b+TQqIgXbwUdnuMzVsZj8eBeKn+nVSWZZhu
W/xI9VarhYC2xZqAS/qh9gl3UsiuZpO2c7oDJaO4wMPYRi5eCvUkvKxdp+1n
lLVHM46HsY3cShTqSXhZu06bTxKvja0TGyhrM8bao/ZiPQkva9dpI7Nxi/Da
EIcSazPG2qP2Yj0JL2vXaSP0EIBeG1OLCWZtxlh71F6sJ+Fl7bqc8TmwPrSG
JnvCSHgciJfq30n5dV7PxYeEx4F4qf6dlD/nWMqfgxIeB+Kl+ndSmGFEKibd
fMjVYwGvB+KSfb4dsBQch/u22MrV6wKeBOKS/dde+vsX38f8/SwR8DQQl+zz
fZDHAhxS9qZD374RggShYoupgGeBuGSfvUxy0Wvv//bmPTemvVGxfZwd/vpJ
h+sL1Pq4PMwd9x3QEPD5QFyyz15mwzG49V4crjf2IeiadwK+GIhL9umrit8x
cFxi4D5gGl2MiMStFWmOjbNZQmbpjWTK9MXMArXXscnj9OHvZZzoHJ8J1ADs
7+8Dw/0bi7RSSXp1itLVPGGuZ8St4MsCc2BqlnBMsZC4K6AEaczV9fW1jca1
CrKtKclW8YH5uhHP4e777Vz9s1DPy1OsKT+r/Kzys8rPKj+bw5WfVX5W+Vnl
Z5Wf9drKzxboKT+r/GwOV34276Xys2H2lZ9Vflb5WeVnlZ9Vfnag/Kzys8rP
Kj+r/KzysxNx5WeVn/VSys9Ws6/8rPKzys86a8rPKj+r/KzyswPlZ21R+Vnl
Z5WfVX52yMQWs7Rm5h+Heh7a\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4704801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1182797647],

Cell["\<\
Put dividers at the third horizontal and second vertical positions:\
\>", "ExampleText",
 CellID->23932850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"False", ",", "False", ",", "True"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659967961],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXDtM3EAQNWef7QMSLh+FC5dIl46SkpIqoYlESQmKIh1SoqAkBR0lJSUl
JSUpkChTUlJSUlJSUl7ezux5l8n5FmdDN5bOrHfe7Lxdz378FOXj9s/h56/b
P3c+bQ8+fN/eHe58+jF4/+07qtKZJEnO8PvSS1AeoUS/s9EIf9fNPTXPdCU7
U2oXzL24vr7+Tdf+/v75+TkKV1dXyZsptgXR2twU7Nt/jNElhvPmnuF5b29v
eXl5MBi01tbWkgLQ9fV1FLlyOBxeXFwkrxqh50Uvykbei4/I7An1fdbc2zc3
N1tbWzAfHByYcSmoFmN2dHS0uroK78vLy+R5A+ys6HfewPfFI3GiDEo6xAwG
DMXx8TGPQ4qcWFlZwUhxTkyxd0TP2gH8s8h4NJLco+zu7m5IFwrsBwRe7O3t
rc3iaYhCME+DHk/+Q9TS8U/xItBRU6T3lmIaWtRcwJ5P4j4FPx8Zj/jaqLu7
u4eHh6b4cvxu4GiKnYC9LVi3AvjZyHjE10ZFLmFOmKJZF1p4IWVNPeHziiUu
xixae6dhe8wiIytmJqalGVFay1IkCCakmY15wJ7dZ1UBJa6IjNP22LqR7dHz
6enpxsaGe5P1dsrHdsWWgclrgZL51DQKsbS5j9UNPUI/kiV6xnKB7ri5UW9v
eVzrUVlklNTjikmGxcEUGYVlGnuUa6XeTlwz5sqovkBkkRF8nphGmEwOhb0E
vXOt1Nt9nozqC0QWGcHnWZYlhtwUOUqv10OCVzykvazs1IbhyIg3wvufWpd2
i8Jc63ZpM6AoeZUZuNjGpza/HtzYxCc6mbMPbVP6WW83luxdjTUutjEjvx6M
2GQZuffTqE3pZ715v3HeWEixnLI325iRXw9GbLKMKluzNqWf9cZ8xjnEeQMO
J/ZmGzPy68GITZZRZWvWpvSz3kg1JJzzxpBiYNmbbczIrwcjNllGla1Zm9LP
zg+X70vj1lBl9paQ3V8lGNUXiCwygr9KuDe8JDIjZPd5MqovEFlkBJ+n298Y
5fa/kN3nyai+QGSREXyeGGXkKgbe7uvuOQvY/dNBPaodGYVPB4wCfXTCFHvi
uR2wi5MMG2wsh8ojo/hc3VmMz2burJYH7OKMWAElroiMw2dE7hPsQJkTD31v
p0gcpI8pFgE7sS38c3Y9toyMxYxzkd3me8Gc0Gdr6uVXVqsGN9ewXf6aKsY5
AKvh/Hw81+z3w1zAPvkbsB4/HxmPWZfjPtncWBjnBlYyc8Z/GrCXgnUWwC9E
xqOvNb5nsOMohO7ATL3NkM0492LBwFLcfQBmotoR8Hn2n2Kz8kH1bWwj2OH4
ex1nBuaRww2Gzc1N2HCix0t80QgtVaqikffLR2TGWlWlBeHbxZyvWqBKZy9z
tEkSoDF2JycnJnsXG2ClKtlp4Nt7JE6sR1Y6jP3CGIjnrmD+VNjfBfwpN1W/
Vv1a9Wt/RVf9WvXrCXbVr1W/Vv1a9WvHU/Vrc6l+rfr1X22qfq36NT2rfq36
terXcbFUv1b9WvVr1a9Vv77/zPq13dbp+oXfDD2qfq36terXql/fR6h+rfq1
6teqX6t+HRdB9WvVry0j1a9Vv1b9eqT69QS76teqX49UvzZF1a9Vv1b9WvXr
h/77a/6/RZKZPzhADAk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150321660]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spanning Elements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->240043264],

Cell["Make element 4 span the column to its right:", "ExampleText",
 CellID->578952123],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1854270016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromLeft", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->348140959],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {387., -580.5}, 
      ImageScaled[{0.5, 0.5}], {747., 360.}], {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -387.}}], 
      LineBox[{{0, -387.}, {0, -774.}}], LineBox[{{0, -774.}, {0, -1161.}}], 
      LineBox[{{387., 0}, {387., -387.}}], 
      LineBox[{{387., -774.}, {387., -1161.}}], 
      LineBox[{{774., 0}, {774., -387.}}], 
      LineBox[{{774., -387.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {774., -1161.}}], 
      LineBox[{{1161., 0}, {1161., -387.}}], 
      LineBox[{{1161., -387.}, {1161., -774.}}], 
      LineBox[{{1161., -774.}, {1161., -1161.}}], 
      LineBox[{{0, 0}, {387., 0}}], LineBox[{{387., 0}, {774., 0}}], 
      LineBox[{{774., 0}, {1161., 0}}], LineBox[{{0, -387.}, {387., -387.}}], 
      LineBox[{{387., -387.}, {774., -387.}}], 
      LineBox[{{774., -387.}, {1161., -387.}}], 
      LineBox[{{0, -774.}, {387., -774.}}], 
      LineBox[{{387., -774.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {1161., -774.}}], 
      LineBox[{{0, -1161.}, {387., -1161.}}], 
      LineBox[{{387., -1161.}, {774., -1161.}}], 
      LineBox[{{774., -1161.}, {1161., -1161.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->974293364]
}, Open  ]],

Cell["Make it span two columns:", "ExampleText",
 CellID->581884849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromLeft", ",", "SpanFromLeft"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74187149],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {1134., 360.}], {}, {}}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -387.}}], 
      LineBox[{{0, -387.}, {0, -774.}}], LineBox[{{0, -774.}, {0, -1161.}}], 
      LineBox[{{387., 0}, {387., -387.}}], 
      LineBox[{{387., -774.}, {387., -1161.}}], 
      LineBox[{{774., 0}, {774., -387.}}], 
      LineBox[{{774., -774.}, {774., -1161.}}], 
      LineBox[{{1161., 0}, {1161., -387.}}], 
      LineBox[{{1161., -387.}, {1161., -774.}}], 
      LineBox[{{1161., -774.}, {1161., -1161.}}], 
      LineBox[{{0, 0}, {387., 0}}], LineBox[{{387., 0}, {774., 0}}], 
      LineBox[{{774., 0}, {1161., 0}}], LineBox[{{0, -387.}, {387., -387.}}], 
      LineBox[{{387., -387.}, {774., -387.}}], 
      LineBox[{{774., -387.}, {1161., -387.}}], 
      LineBox[{{0, -774.}, {387., -774.}}], 
      LineBox[{{387., -774.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {1161., -774.}}], 
      LineBox[{{0, -1161.}, {387., -1161.}}], 
      LineBox[{{387., -1161.}, {774., -1161.}}], 
      LineBox[{{774., -1161.}, {1161., -1161.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->385760373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73873043],

Cell["Make element 2 span the row below it:", "ExampleText",
 CellID->547117279],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->988049539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromAbove", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75970249],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -387.}}], 
      LineBox[{{0, -387.}, {0, -774.}}], LineBox[{{0, -774.}, {0, -1161.}}], 
      LineBox[{{387., 0}, {387., -387.}}], 
      LineBox[{{387., -387.}, {387., -774.}}], 
      LineBox[{{387., -774.}, {387., -1161.}}], 
      LineBox[{{774., 0}, {774., -387.}}], 
      LineBox[{{774., -387.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {774., -1161.}}], 
      LineBox[{{1161., 0}, {1161., -387.}}], 
      LineBox[{{1161., -387.}, {1161., -774.}}], 
      LineBox[{{1161., -774.}, {1161., -1161.}}], 
      LineBox[{{0, 0}, {387., 0}}], LineBox[{{387., 0}, {774., 0}}], 
      LineBox[{{774., 0}, {1161., 0}}], LineBox[{{0, -387.}, {387., -387.}}], 
      LineBox[{{774., -387.}, {1161., -387.}}], 
      LineBox[{{0, -774.}, {387., -774.}}], 
      LineBox[{{387., -774.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {1161., -774.}}], 
      LineBox[{{0, -1161.}, {387., -1161.}}], 
      LineBox[{{387., -1161.}, {774., -1161.}}], 
      LineBox[{{774., -1161.}, {1161., -1161.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1998751499]
}, Open  ]],

Cell["Make it span two rows:", "ExampleText",
 CellID->122949571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromAbove", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromAbove", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->603613667],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 1134.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -387.}}], 
      LineBox[{{0, -387.}, {0, -774.}}], LineBox[{{0, -774.}, {0, -1161.}}], 
      LineBox[{{387., 0}, {387., -387.}}], 
      LineBox[{{387., -387.}, {387., -774.}}], 
      LineBox[{{387., -774.}, {387., -1161.}}], 
      LineBox[{{774., 0}, {774., -387.}}], 
      LineBox[{{774., -387.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {774., -1161.}}], 
      LineBox[{{1161., 0}, {1161., -387.}}], 
      LineBox[{{1161., -387.}, {1161., -774.}}], 
      LineBox[{{1161., -774.}, {1161., -1161.}}], 
      LineBox[{{0, 0}, {387., 0}}], LineBox[{{387., 0}, {774., 0}}], 
      LineBox[{{774., 0}, {1161., 0}}], LineBox[{{0, -387.}, {387., -387.}}], 
      LineBox[{{774., -387.}, {1161., -387.}}], 
      LineBox[{{0, -774.}, {387., -774.}}], 
      LineBox[{{774., -774.}, {1161., -774.}}], 
      LineBox[{{0, -1161.}, {387., -1161.}}], 
      LineBox[{{387., -1161.}, {774., -1161.}}], 
      LineBox[{{774., -1161.}, {1161., -1161.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2077237319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47616072],

Cell["Span throughout a 2x2 block:", "ExampleText",
 CellID->210615047],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1355537997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "SpanFromLeft", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->839795991],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {387., -387.}, 
      ImageScaled[{0.5, 0.5}], {747., 747.}], {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {{}, {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -387.}}], 
      LineBox[{{0, -387.}, {0, -774.}}], LineBox[{{0, -774.}, {0, -1161.}}], 
      LineBox[{{387., -774.}, {387., -1161.}}], 
      LineBox[{{774., 0}, {774., -387.}}], 
      LineBox[{{774., -387.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {774., -1161.}}], 
      LineBox[{{1161., 0}, {1161., -387.}}], 
      LineBox[{{1161., -387.}, {1161., -774.}}], 
      LineBox[{{1161., -774.}, {1161., -1161.}}], 
      LineBox[{{0, 0}, {387., 0}}], LineBox[{{387., 0}, {774., 0}}], 
      LineBox[{{774., 0}, {1161., 0}}], 
      LineBox[{{774., -387.}, {1161., -387.}}], 
      LineBox[{{0, -774.}, {387., -774.}}], 
      LineBox[{{387., -774.}, {774., -774.}}], 
      LineBox[{{774., -774.}, {1161., -774.}}], 
      LineBox[{{0, -1161.}, {387., -1161.}}], 
      LineBox[{{387., -1161.}, {774., -1161.}}], 
      LineBox[{{774., -1161.}, {1161., -1161.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->485971154]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->391029099],

Cell["Align contents to the left:", "ExampleText",
 CellID->1202194683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1"}], "}"}]}], "]"}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], "}"}]}], "}"}], ",",
    
   RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->799770335],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2TEKwjAYhuE/RsEjOPY06uIVhFCEdhCl9jpeQNChp/E26Ze4KDgoOFT6
BvIlf3jIGEiyCW2124e2LkOxasKxqstTsTw0WvLOzDr1+8I0j5rl3sWo8ZFe
edXiJFc5fTK52UWRNnFp/HMxVWxVrpFIJBKJRCKRSCQSiUT+RA7lzv9e3GwM
7x0IBGKcYqY4q5wjkUgk8is5lHMcgUAgPhWvv/nP//zmepaw37c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{178, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163577613]
}, Open  ]],

Cell["Align contents to the right:", "ExampleText",
 CellID->105324452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1"}], "}"}]}], "]"}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Graphics", "[", 
       RowBox[{"Rectangle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], "}"}]}], "}"}], ",",
    
   RowBox[{"Alignment", "\[Rule]", "Right"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173862713],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2TEKwjAYhuE/BtQjOPYy6uQVhFCEdhCl9jieQNChp/E26Ze4KDgoOFT6
BvIlf3jIGEiyCW2124e2LkOxbsKxqstTsTo0WvLOzDr1+8I0j5rl3sWo8ZFe
edXiJFc5fTK52UWRNnFp/HOxVGxVzpBIJBKJRCKRSCQSiUT+RA7lzv9e3GwM
7x0IBGKcYqo4q5wjkUgk8is5lHMcgUAgPhWvv/nP//zmelYv37c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{178, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76389899]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->173615003],

Cell["Draw the grid with a pink background:", "ExampleText",
 CellID->701515873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692055481],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnC1MHEEUx4ebuQ8+ehwf4gTiBAKBQCAQiBOkRdAEgUAguEDTI6HphZ5A
kBRXWYmsrGwFSWVlZWVlZWVl5fY/+5bd2bu97JHC7W7zT+5j7/3nPfbN7rx5
+xM87/S7L151+mcnndazi06ve3bypvX09QVMekopdYv3y6bCsYcj/33refZb
48u7vsZLfcbH1JC1Yj/078vLD/v7+2trSrdbLaV3V1dv9vZ+9fuqkaIv5Ny/
lph12X6Ydzs7zbm5442NT4eH+uvxsSp/OTrqbm7CeLm9/efqSj0Zc1z9P4lX
SZwt7Xv/OD/fWlmRgTXfjHgbzea301M1kzpitjAxyolzUPJHfTw4cONoiYNb
T9VS9Omc+5so62qYNV5YQ2vLy1hfcq9pTBg8vne7QeUYrVdT9Kz9dZRxxc0Y
tQPLYt4fjXEYbVeGXzG0aPawPqBXUvSs/UtRtuUwW1x4VAO/hpbettvG9xGj
PWwE9vII+2OPTzxnFKuo7iMz/LZX169RWsS7GK5uUvRM/E2oR5kayRTlGTvZ
kh1VwbRgciR9x65De1CdRLOHi1n4OXo8F1xKvPwYJrzKwTVeGrj2Jdf+mKMd
e/xsJQuZ+TDDuN3JvDSQ+WIWfo4ez+VwfR0lfzgXxz4UW7Tkc5qA38hc0Kig
p5NcUORQ6iS2Y9ehPYgtWnROE/Zz9Hgu6DbQfEgucICbxHbsOrQHsUWLzmnC
fo4ezwU9BHZYySXcf+J2Z1+S2KJF5zRhP0cf2l/QH9nuQPYXFOtWo2H3T6nv
InphfY90k6Jn4m9C3UvYSdEGojkIMo1WofwlEaO/FOkmRc/E34S6l9zV4VbG
DS1dHQZiuD2UzkM0e1gf0Cspetb+TocU69pxxYP7WLren70eftu+SSKO1qsp
etb+Ttc+9HSG8RiFqQqebrBFYtXbKLUUfTrn/iYxa3kux1zhBsFiwJLwZ88+
3aLAoUdAYzkzxpjZAsZJfkoXriO1AYWvt7Wl0e8pg0CYSbxQ9etjjJkvYJxq
4oxU79bP+91d62L7X39vx2RaaSFFX8y5fzLfS2ad97GSixaZY5KLPnwMclFy
UXJRe0guSi5KLkouSi5KLkouan+Ti5KL5smfXJRctFg8k1yUXDRfXJQEtMjE
kgT04WOQgJKAkoDaQxJQElASUBJQElASUBJQ+5sElAQ0T/4koCSgxSKXJKAk
oCSgJKB5jUcCSgJKAkoCSgJKAnpvPxLQaxLQf/YjASUBJQElASUBHcOfBJQE
tFjkkgSUBHSSBDT4H6FTfwHDgCA/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57949397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->928090012],

Cell["\<\
A pink background for the column at the first horizontal position:\
\>", "ExampleText",
 CellID->501317172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Pink", "}"}], ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83112486],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnC9sG0kUxvef15sm1zh2pRoUGBQYFBgUGBQYVFeDVjIoMChw1J7kSj2d
1QswqJSywMBIRwIDQyoFBgYGBgYGBga6v5m33tVmWzmud3t36pOcZGa+8Zv9
3r558+YDebW9M/7jz+2d92+3Wy8+bk/G79/+3fr9r48M+a7jOF/4GTcd2jNa
9ufLbGb++vyZff7Mx3nIr3/uOBqaX8H5eDzpdnutVhQEnmNm0GaEcSdiRmS+
F5yfn08mk16vF0VRPKvXY4RxZ6uAGbWfskqU80FgHXHz6dP02bNOs7nf75+O
RnQ9M16hzQjjo07nejq1HguNjfDm5mY6nXY6nf39/dPTU7qeGa/QZoTx0Wh0
fX3t/Fbi7I3/zJOEOb/69tfZu3c4b+/5c2fN9g8Hg/aDBydv3jgV+hXzLf/s
7AxDe3t7zDH9w8PDdrt9cnLirK+I3yvZfiXH2kaNT8h0Hz26+PABC6Z/tbPT
f/x4t9ez0RZYK7iv2+1eXFzEq1xdXfX7/d3d3XiVH8ejku0HwrqasOZDroAx
28a5bxlDl5c894hvLbD/sEgIMcf0MYcTbZitiFdKtu8J4zBhDFHoQnpz/n6J
apMfDFs728cO1kzO2Zz7j6gxe6WyIh6UbN/LRzWhu2WTJfuXTCjDZp5HQGzN
dwW5wCbgJcf9guy48tyBPDdvoxZFDZvdeTlsRvPUsxkMa7Vaw34XwgR48oZ9
wUyzfhc8TPBC7brALniWj3je8PHmiYRxYd+IPeLf8kh9wbi35PzvjWefdPz0
6cHLl+J5zk+KCXnW8Xh8cHAgHuL84FBOPSBY6qEFeJjghdp1gV3wLB/JZcLn
cjJp8aYsH8kPsu7l5WULnondNHfU74KHCV6oXRfYBc/yIXNxLOf5kA446r69
rmDfX/cWnuFTnN1v8xm028fDofBhm7PZhc9gMDg+PpZ12U7sqtSuYOm6C/Aw
wQu1a3e52e0ZPpTeFBDCh8Aj/IQPJSyHsqzLS+ZVp3YFS9ddgIcJXqhdF9gF
z/IRDsJHcoPwEVuNW/vQu7VO/S54mOCF2nWBXfCYT0X4cPg3NzbMaW/PxIg+
e4gaQGhxsDabTVK6nE90iVhOV8ef9wV2lsW9Fb+/CM+y5HP0+vXwyRNhGXA9
ooxPT37HPzo6Gg6HpmmPLp+LAkWyaQYr4n7J9mOmaT3HB6bw3ZzfWkiS2eoV
Uxg0TakOSUskJxt8K+KVku3H9VymXidauZeR/bnnGcZEM31zY/ETxsQE9x5S
rtwFTZVC39wIqiviYcn2fWGcu5dRjXA6UEnF9zIyU3wbTe9llABkZGqc+N5D
Rohve2sr4lHJ9oMca3sHD3i3VI6kYBrV7AhhkNzDA/xHXUf6o1HNjuDq9YLm
3PuJa+Xv54ats84b527AFqeSJhoIC7Y+bTzCuIkP4ydrbx3PUpuzlahz8Tru
Z5vRZgXGzXvYLHje/X9p3WrOWzZaqmRDfEPAUMmTJWmbHWP0HBuRVTINdnA6
lTNZiLaJxsYPYvUSbK7lmKlKqiqpqqSqkqpKqiqpqqSqkqpKqiqpqqSqkqpK
urxdVUlVJVWVVFVSVUlVJVWV9FdVSVU7Ve1UtVPVTlU7Ve1UtVPVTlU7Ve1U
tdN0XdVOVTvN46qdqnaq2qlqp6qdqnaq2umvqp2qSqoqqaqkqpIuh6tKqiqp
qqQzVUlVJVWVVFVSVUlVJVWVdKYqqaqkqpKqSqoqqaqk/yeVNP5Ppu5XS5I3
fw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19271567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306149779],

Cell["\<\
Alternating pink and yellow at successive vertical positions:\
\>", "ExampleText",
 CellID->851891726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "Yellow"}], "}"}], "}"}], ",", "None"}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207244729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnC9sG1kQxid+dp2o/1K10vlOBQYFAQUGBQYFBlXPoCcZFBgUJGpP50o9
1WoDDCqlLDAwMDAwpFJhYGBgYGBgYODeb96s36ZZB1ylONlqpM367e7MN2/n
zZuZ/UD+Wlsf/f3v2vr7t2vtPz+tjUfv335uv/z4iVthQUS+8fdPSxhnjOLf
tyzT38BP9vUrh/zG6Q9u/j7jd6EkfUtP4XQy2RkMBisrEnrttoT+kyfbr16d
rK/LIs8XVSmcnsrOjgwGDHs9Tv2+bG/LyYnIEs8XK4hT9kZDT/XNFy9ad+6s
djp7w2HYX12Vxvc3b0bPnnFz8vz52Zcv0WtNVa5vbkqrJcjs7UnY3xdkv8to
pDcnEzk7E1G55i+MW/ZiiNpHHz50Hz82QVsN8Dqt1sG7d9HPjTifoyPpdnPT
tq7MsNORgwMBPctXpKpYZd/UotTu69e51O14bTiEqtS5rkd7u7tTe7fjtc2I
kBedYb2COLk3mskbHOzFlUeP2KdyN2rgSDQOiUiNohAtsafZwex3ZPSaJcHy
4SHLxHWMtlAtnNwTt857gtzE9rofpZFDWndYLVklv7FVdXgvXmMPq7pjQ7Jq
GDq8VwGc3AuN5AUChWwjDxjWNno9lalFbKKM9KPDZU61jY1ow/aSKelw+Rr1
Su9CktQ68yDmCd6Ya6IhWSDfEkZTCzGGuKUxVUuWDGJq6eai5O9et3enUFBr
H8bmAkfhLnVIJhQb6vRDFW3iXFzMUI+pisxVJyQd+XH+LChHlKmntc6jIKI2
UnQYqtTmJX8u9n6cs72L+cJe0jDt/c0X5peEaioyV52QdC7Mf/j0KaWjjDsc
CmVnJq6pzJjLFepcOn+aIvpKwyXhkfYMl3RPT2q4JEtSZsI1FZmrTkg6F+ZP
10ITY7hIo2O49DxUMMPFAGYSrqnIXHVC0rkwf/oMqq3hppqDAD0KldpwU70y
XFORueqcq4elekHfpN2B1QtSbXt5mRybcjRlkQJb5GgSNplMq22Row2iyNE3
FaX07jSMtAX5u9uGswdmj56TzqKwZ7tVh4U9gyjs3VSUWZ0f8U2UW+eHIOJZ
/qVgnRZbgw2SpU4Lg5iNw2zaaRlGljqtm40z60uA2Mj3gHXMx+Mx19pDFZ03
MWbBl3fex8d6rd/8ReddLZzLvhCRRwoX5l9S1FDSiKIUX2TYxRpLkX+RUYLJ
Qjqb4ousWjiXcQn4kIBiU7G1jJsgrZJMaS5oQYuvdtaD4GSDsk2N7yAzk5Dp
T2hni+/26uNdxl1Z7iHVjrvdQN8odYDwMAeVR7HMruUx0vZ4LIHOE7mJrhYH
1UsZj+Yvglf2VHO6D7f6fVXR/joyNzhZHymTszTdz1tboua1O48cEAumj/T5
UgVxyt74f3zxVUo7F+1ctHPRzkU7F+1ctHPRzkX/DIpz0c5FOxftXPSV6zgX
nTkX7Vy0c9HXzyE7F+1ctHPRVcBzLvr6uGhnl51ddnbZ2WVnl51ddnbZ2eWf
QXF22dllZ5edXb5yHWeXM2eXnV12dvn6WWFnl51ddna5CnjOLju77OxyVXGd
XXZ22dllZ5edXXZ22dllZ5edXXZ22dnlmTrOLju77Oxy5uyys8vOLju77Oxy
Ndjl/H81L/wHfd6bbw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534245747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->212518288],

Cell["\<\
Alternating pink and yellow at successive horizontal positions:\
\>", "ExampleText",
 CellID->222607990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "Yellow"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34782048],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174434546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1720014653],

Cell["Embed styling options with a particular grid item:", "ExampleText",
 CellID->1115177304],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406578384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"x", ",", 
        RowBox[{"Background", "\[Rule]", "Red"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "x"}], "}"}], ",",
     
    RowBox[{"{", 
     RowBox[{"x", ",", "x"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->639873772],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{0, 0}, {384., -384.}]}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {192., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.},
      Background->RGBColor[1, 0, 0]], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {576., -192.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {192., -576.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {576., -576.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -384.}}], 
      LineBox[{{384., 0}, {384., -384.}}], LineBox[{{0, 0}, {384., 0}}], 
      LineBox[{{0, -384.}, {384., -384.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->926082854]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Spacing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->267316272],

Cell["Set the spacing between items:", "ExampleText",
 CellID->2609790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"Scaled", "[", ".5", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57263510],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDtMWzEUhm8Ij/AoTSkt6TtFoWJkTDemlqVSRkYiVCkMVSPKwMbIyJiR
kTEdkBg7MjIyMjIyMqaf7RtMjWPpCl8K4kTKxb75j8/Dr2P/Et+aW63vP5pb
G+vN6tfNZru1sf6r+uXnJq+KhSRJDtW3klDuUdLfw15P/S2aP+rzm2/hn7fq
+Vk9iqaiinVPvSCSD0bylXqMXF5e/ul/Li4ukjeOfOWWKL/uFxrf7XZbrVa1
WuVtqVRKisvLy8louVymXqlU1tbWDg4OaPSlo232jqX9Psyox+jZ2RlYWmg0
Gp1Oh+qYfn9+fr6/v7+6uspPPE9OTmYdO579B3m/J2UdEXpse3t7cXERORxP
ptXbYaKwtLSEChqccSx4egdyfot1C8PHx8d04O7uLuJGB03xhjZMdK7pnM5J
wm+fli3SH4wqNRP0eC/SBF3RbrdNxK/pepID3m+Zkhxi5Gt02pqZIXt7eysr
K1c9cU3bVI4yfiunNBJPCLwqvtb1o6MjJK3/VttkDni/ZZP9yOObKr7t+0Rj
1nKraSIHvN8yI8nSm0b3va4zIBiq1nKraTwHvN+y8f7oZN4wrZMPTt3VVMoB
H7LMRrfq1Ce8muLi/ZYZSazHBxXtj32f6vU6i/kNTWM54EOWsXSnc2de1xkE
DAUbU1dTXHzIMhxiF7SS+MS2rnz0a4qL91tmJE9PT9nuVLGm60wklhxrudU0
mgM+ZJkdkTWn7tcUFx+yzPpQc3z0a4qLD1lGmsJEsZLsw4yDwZri4kOWkb8y
sVVxQddJAc0mnP7uaoqL91tmJIEBVsVPuk6oCbhP00gO+JBlTGkmtpUksWKr
G6wpLj7Um7YlE227/vh7Jy4+ZJlFLjgt+TXFxYcsYxMjce9dzR2GK4O2N3Cu
xcWHLLP5kpGkGRobrCkuPmQZ5xqOXX3JoZ2dHXf/G42AC1lgo1hzouz3NS4+
lFNY5LzTkj9HiIsPWWZ30nmn7tcUFx+yjLWYLYzlN80t8YnlWJ1W/bloXHwo
3+92u41GQxVNPo5DuKWK/vw9Lj50erPjwJyu8A4fVW7pP43FxYcsI7oIsxwn
73SdOFNX0XdPsOM54ENncZIkkMoHc1a2GZ3/bB0XH7q/YBwAViPS3C9wpE/P
NP77iLj4wfc/WpIEREV7rh9tWmKQmps15x4nNj50Z0a0GZGkRumdlok+AR9w
BxYXH7ptxAd8wg0Gpb4rHGbMssOZRch/e5iPjN9Kg8UTVkHgFLTH6gbT3HSz
IT93NJZzlPFbqVsbA4KDHGdIVyjTHUgbWIkeoU4SQ+NsgvROp9Nh+rn33zP3
pKUQw0FfGiF6FCGtNBmhJ6kbNep+as6xZ/YOZe8PHyWS+UiqjzC6j0FSGF1h
dI0nwugKoyuMrjC6t8cLo5sdL4xudrwwutnxwuhmxwujmx0vjG52vDC62fHC
6GbHC6MrjK4wusLoCqMrjK4wujfxwugKoyuM7kNjskQyJKk+wug+BklhdIXR
NZ4IoyuMrjC6wujeHi+Mbna8MLrZ8cLoZscLo5sdL4xudrwwutnxwuhmxwuj
mx0vjK4wusLoCqMrjK4wusLo3sQLoyuMrjC6D43JEsmQpPpYRjf9j8yFv3pE
0ZM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433635187]
}, Open  ]],

Cell["Set the horizontal and vertical spacings separately:", "ExampleText",
 CellID->1695160959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "3", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Spacings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", ".5", "]"}], ",", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->427974663],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDtMWzEUhm8IhPBom1Ja0neKQsXIyMjUslTKyEiEKoWhakQZ2FgqMTJm
ZGRMByTGjoyMjIyMjIzpZ/teTB3H0hW+tMOJlIt98x+fh1/H/iW+tHc7X7+1
d7e32o3PO+1uZ3vrR+PT9x1elUtJkpzw/VlPKA8o6e/JYKD+ls0f9fnFt/TX
W/V8qR4TNzc3v7PP9fV18lq9LRuIKtbviSp5dT/X+H6/3+l0Go0Gb6vValJe
W1tLKrVajXq9Xt/c3Dw+PqbRF462+QeW9vswpx6Vy8tLsLTQarV6vR7VSf3+
6urq6OhoY2ODn3ien5/PO3Y8/Qfyfk9qOiL02N7e3vLyMnI4njxWb8eJwsrK
CipocM6x4MkDyPkt1i2Mn52d0YEHBweIGx00xRvaMNG5o/NxQRJ++7Rsmf5g
VKmZoMd7mSboim63ayJ+R9ejAvB+y5TkGCNfo9PWzAw5PDxcX1+/7Yk72mYL
lPFbOauReELgVfGVrp+eniJp/bfaZgrA+y2bySKPb6r4JvOJxqzlVtN0AXi/
ZUaSpTeN7jtdZ0AwVK3lVtNUAXi/ZVPZ6GTeMK2T907d1VQtAB+yzEa34dSn
vZri4v2WGUmsxwcV7Q+ZT6urqyzmQ5omC8CHLGPpTufOoq4zCBgKNqauprj4
kGU4xC5oJfGJbV356NcUF++3zEheXFyw3aliU9eZSCw51nKrqVIAPmSZHZFN
p+7XFBcfssz60HR89GuKiw9ZRprCRLGS7MOMg9Ga4uJDlpG/MrFVcUnXSQHN
Jpz+7mqKi/dbZiSBAVbFj7pOqAm4T9NEAfiQZUxpJraVJLFiqxutKS4+1Ju2
JRNtu/74eycuPmSZRS45Lfk1xcWHLGMTI3Ef3M4dhiuDdjByrsXFhyyz+ZKR
pBkaG60pLj5kGecajl2Z5Nj+/r67/1Ui4EIW2Cg2nSj7fY2LD+UUFrnotOTP
EeLiQ5bZnXTRqfs1xcWHLGMtZgtj+U1zS3xiOVanVX8uGhcfyvf7/X6r1VJF
k4/jEG6poj9/j4sPnd7sODCnK7zDR5Vb+k9jcfEhy4guwizHyVtdJ87UVfTd
E+xUAfjQWZwkCaTywZyVbUbnP1vHxYfuLxgHgNWINPcLHOnTM43/PiIufvT9
j5YkAVHRXsiiTUsMUnOz5tzjxMaH7syINiOS1Ci90zLRJ+Aj7sDi4kO3jfiA
T7jBoNR3heOMWXY4swj5bw+LkfFbabB4wioInIL2WN1gmptuNuRnjsZagTJ+
K3Vrk0BwkOMM6QplugNpA6vSI9RJYmicTZDe6fV6TD/3/nvuP2kpxHDQl0aI
HkVIK00m6EnqRo26n1pw7Jl/QNlh69VHGCNhjIQxKkZCGCNhjIQxyvDCGOXH
C2OUHy+MUX68MEb58cIY5ccLY5QfL4xRfrwwRvnxwhgJYySMkTBGwhgJYySM
0TBeGCNhjIQxEsbovtLCGAljJIyRMEZWUhgjYYxi4YUxyo8Xxig/Xhij/Hhh
jPLjhTHKjxfGKD9eGKP8eGGMhDESxkgYI2GMhDESxmgYL4yRMEbCGN1ljNL/
WFf6A99dFPg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36183810]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Irregular Shapes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23814162],

Cell["\<\
The overall aspect ratio is automatically adjusted for irregular shapes:\
\>", "ExampleText",
 CellID->98219478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"RandomReal", "[", "]"}]}]}], "]"}], ",", 
    RowBox[{"{", "3", "}"}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->472997163],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.32986001358341355`], {195., -102.42455831178435`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.9910194163800046], {585., -102.42455831178435`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.7984526745484157], {975., -102.42455831178435`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.9462383355139472], {1365., -102.42455831178435`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.2522184043841178], {1755., -102.42455831178435`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.6024112011401168], {195., -307.27367493535303`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.8366704218980874], {585., -307.27367493535303`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.24670498817428976`], {975., -307.27367493535303`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.30131455906631044`], {1365., -307.27367493535303`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.4695379085453608], {1755., -307.27367493535303`}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.18822582396465903`], {195., -512.1227915589218}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.7638994067854978], {585., -512.1227915589218}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.6573012511101151], {975., -512.1227915589218}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.25534698001819667`], {1365., -512.1227915589218}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}],
       AspectRatio->0.3006868561110605], {1755., -512.1227915589218}, 
      ImageScaled[{0.5, 0.5}], {360., 190.5573177893662}]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395643132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Nested Grids",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->359856620],

Cell["Grids can be nested:", "ExampleText",
 CellID->32743373],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383393917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"GraphicsGrid", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], "]"}], ",", 
       "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102307895],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138239839]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->274668873],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->663335023],

Cell[TextData[{
 "If possible ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " will choose an aspect ratio suitable to its elements:"
}], "ExampleText",
 CellID->1084119984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Rectangle", "[", "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{".2", ",", ".5"}], "}"}], "]"}]}]}], "]"}], ",", 
    RowBox[{"{", "5", "}"}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1668948648],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAFiJwkGIPs/kAXG
W/7/B9IQkhVIigMF+YC0GJDmAdLSQJoLSEsBaU2iVHEAaXkgzTSqmi6qNZFi
EFtsGgJpSah6aSSahQxVnEBaAerCUdXUC1/M2GOBxm4wlOYG0hJAmg1Flh3q
Uh2iVLFC0xXHqGoyVeMPZ+xxhRm3mlD5EKh6VrAoAzOEAgFZaCokXhUn1B/o
/hnZunSIUo0awthjBzMWi6DqeFBiWxUtXXFiVYXuEtZRXSTrIi6ksccSJAYZ
GAEKrJ98\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->765119335]
}, Open  ]],

Cell["\<\
When no reasonable choice can be made, a default aspect ratio of 1 is used:\
\>", "ExampleText",
 CellID->2124820117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Rectangle", "[", "]"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", "2"}], "}"}], "]"}]}]}], "]"}], ",", 
    RowBox[{"{", "5", "}"}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1346140456],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl8sKgkAYhacbJWZ3SIjITZuiaNMr1KpFjyAR1CKK6tF8v+nYTIsihcoJ
oyPMf8bf78xCmaMu/PNmvfPP25XvzY/+YbNdnbzZ/ohWLiOECMLhCswlZtcR
SAlVtYRaR7MBbUGr0LbWpu43oBZp0qRJk04VHUTUJWoNVEuvNo7p9lE9nJUT
vypySsKji1FIPe1Ae9AsXXTRlbjL/E43l2bxV59na1Q+q1qU95k+0ffUlir7
S39LlTVVIE2a9Et0Wvf0J1R8jg41W9dr3bQC7UDzf0M9vittuuii6yddac2Y
71NRuT+S6pt7CnWhA6Pdx6foGKBuf1XWW7Ql4/7J6KKLrk9cSe7dd1LDVLKp
NBWZC0LW1pI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221880901]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363002531],

Cell["Setting the aspect ratio of each item explicitly:", "ExampleText",
 CellID->1242667885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", 
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", "5", "}"}], ",", 
     RowBox[{"{", "5", "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1465545341],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt2L0OgjAUBeAS4y/+xURAooZX0Ddw0cnVnRATGIwGeTR8vnoKN6kLce1w
BnrI7cdlaynXtMrvj7QqsjS5lOkrL7J3cn6WKPU8pVSN6xMp3GvcNVetNbId
pxjHKIbIFTJCDpE7yQ1yiZxQU1NTUzul647xgHEEtZVut6ZqnplLj9/ZGOnL
O21vampqampXdNdqb2ZnUIHoSLqskYFq95QY2aempqamdkr/+4o/SR6b6ki3
J4NQqmbvWCi7h8Tybp+ampqa2indtdqbWfPNb84AA+Re2z8+ppvZO+xZgJqa
mpraFd2u4sr7AgHKDi0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230090500]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->221411408],

Cell["Draw the grid with a pink background:", "ExampleText",
 CellID->13842222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717991278],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnC1MHEEUx4ebuQ8+ehwf4gTiBAKBQCAQiBOkRdAEgUAguEDTI6HphZ5A
kBRXWYmsrGwFSWVlZWVlZWVl5fY/+5bd2bu97JHC7W7zT+5j7/3nPfbN7rx5
+xM87/S7L151+mcnndazi06ve3bypvX09QVMekopdYv3y6bCsYcj/33refZb
48u7vsZLfcbH1JC1Yj/078vLD/v7+2trSrdbLaV3V1dv9vZ+9fuqkaIv5Ny/
lph12X6Ydzs7zbm5442NT4eH+uvxsSp/OTrqbm7CeLm9/efqSj0Zc1z9P4lX
SZwt7Xv/OD/fWlmRgTXfjHgbzea301M1kzpitjAxyolzUPJHfTw4cONoiYNb
T9VS9Omc+5so62qYNV5YQ2vLy1hfcq9pTBg8vne7QeUYrVdT9Kz9dZRxxc0Y
tQPLYt4fjXEYbVeGXzG0aPawPqBXUvSs/UtRtuUwW1x4VAO/hpbettvG9xGj
PWwE9vII+2OPTzxnFKuo7iMz/LZX169RWsS7GK5uUvRM/E2oR5kayRTlGTvZ
kh1VwbRgciR9x65De1CdRLOHi1n4OXo8F1xKvPwYJrzKwTVeGrj2Jdf+mKMd
e/xsJQuZ+TDDuN3JvDSQ+WIWfo4ez+VwfR0lfzgXxz4UW7Tkc5qA38hc0Kig
p5NcUORQ6iS2Y9ehPYgtWnROE/Zz9Hgu6DbQfEgucICbxHbsOrQHsUWLzmnC
fo4ezwU9BHZYySXcf+J2Z1+S2KJF5zRhP0cf2l/QH9nuQPYXFOtWo2H3T6nv
InphfY90k6Jn4m9C3UvYSdEGojkIMo1WofwlEaO/FOkmRc/E34S6l9zV4VbG
DS1dHQZiuD2UzkM0e1gf0Cspetb+TocU69pxxYP7WLren70eftu+SSKO1qsp
etb+Ttc+9HSG8RiFqQqebrBFYtXbKLUUfTrn/iYxa3kux1zhBsFiwJLwZ88+
3aLAoUdAYzkzxpjZAsZJfkoXriO1AYWvt7Wl0e8pg0CYSbxQ9etjjJkvYJxq
4oxU79bP+91d62L7X39vx2RaaSFFX8y5fzLfS2ad97GSixaZY5KLPnwMclFy
UXJRe0guSi5KLkouSi5KLkouan+Ti5KL5smfXJRctFg8k1yUXDRfXJQEtMjE
kgT04WOQgJKAkoDaQxJQElASUBJQElASUBJQ+5sElAQ0T/4koCSgxSKXJKAk
oCSgJKB5jUcCSgJKAkoCSgJKAnpvPxLQaxLQf/YjASUBJQElASUBHcOfBJQE
tFjkkgSUBHSSBDT4H6FTfwHDgCA/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144696136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1166625332],

Cell["\<\
Pink and red backgrounds for the first and second horizontal positions:\
\>", "ExampleText",
 CellID->946257814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Red"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1855750711],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101037739]
}, Open  ]],

Cell["An equivalent syntax:", "ExampleText",
 CellID->1638673863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "\[Rule]", "Pink"}], ",", 
        RowBox[{"2", "\[Rule]", "Red"}]}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1538714088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->454462110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1861326313],

Cell["\<\
Pink and red backgrounds for the first and second vertical positions:\
\>", "ExampleText",
 CellID->482528275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Red"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554886156],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->427741064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21555281],

Cell["Alternating pink and red backgrounds:", "ExampleText",
 CellID->954466853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Pink", ",", "Red"}], "}"}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1930194792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXC1MI1EQHrpbCoHjSiC5vQuiAlGBqEBUICrIXQWXVCAqEG3gciXhcg1X
UUHCOSQSWVmJIUEikZWVSCSycu97M9u3LduKI+nPkkmW7Xu7M9+8N/vezLxP
8L3aqP34VW2cHlcz386r9drp8Z/M19/neOQsENEd/n56hLaPFv/d+b75dfDj
//2Liz7h9gXPPo/4XYhIL5qb89JstkqlUjZLTiGTIae4vX1zcPDcaNAS3i+x
zgtRi6hkmgVzKxLdED2juYz3SzHEiXojaW7u1f6+t7payeVuy2XnoVKh5P3R
UW13Fw+be3u9iwv2WsrouldEHlGF6BZAD3iSvCeq8cMmUQ8PjFzqHeNGveiw
dvfsLL+1JYLyNYCX87zHkxP2c5LH0yXK903Ld8UIc0SPaC6in4w1VtQ3CZZq
Hx4GUivcFxwsVXLRd1mnbe2tcF9G1DKfDH03hjiBN1LWG7iwF7Obm9in9IE1
4EhodGo1XkUOW8KezhJhv0PG9HtsuWM+k0+y2px44QSeWBz0BGITttdHloYc
pM0OS1iriG/3EvTXuN9hqz1eXn2rgmGaazHACbyQtF7AQkG0oXU0E5eFgpFJ
MHaLQ5ZppnFLXIoN2UuiZJrpGepF5oIgafLMOscJzBh9rAZrweNU1bfAa8iT
NZWwlgSib2l+UYK5uzJ3JArk2g0uLuAouMs4hAjJBnl6gyNAhQOHL1dfhaaq
41gdGh4/PigulnHttw5WAaMm7eoQVEpMS35g7Q2PWeYivpBJCqbMX3whfrGo
okJT1XGszqvxl3d2kDqiuGWi9hhcURkxlgnqjB0/iiLUlYKLgIewJ7g1rkkF
F8GyOIArKjRVHcfqvBo/qhYUMYILaegI7hWXQIJ7w2YsrqjQVHUcq/Nq/Kgz
kG0F1+YcvO9yphZcm68EV1RoqjoD+TCSL1A3mepA8gVCbSadRoy1MTrHBUYY
oxGwM5JtwxgtEGGMnleUyNxRMKIsCOYuG05eiL1HrixCe7Jb/SF7AhHam1eU
UZUf1jdWuVR+EIS4H5wUpNJq8gbxbaXV5oDlD1VaguHbSmu+cUadBLA2gj0g
FfNTvY6+qaHCyrvHZxBTaUvl/cT9ZxqsvOOFM+6ECHlIwYXBSQo5FGHEoIQn
sg5bw6cITmQtjkIdGjyRxQtnHJcAH2JBYVNhawk3gbCKYIriAiVoeGrvcR7J
8zFV+I4uZ8MKl7PhuT3+eOO4K4k9CLX1fN5B3UgugOBhXMg8BkvsShxD2K4D
5NI8afLXynL2MoxH6p3gRT2V6u/D62LRqJj6mpkbONm8MkzOcn8/XxMZ86Y6
Zw6oK5HOvF+OIU7UG//HF09SWrlo5aKVi1YuWrlo5aKVi1Yu+i0oykUrF61c
tHLRE9dRLpqUi1YuWrno2XPIykUrF61cdBzwlIueHRet7LKyy8ouK7us7LKy
y8ouK7v8FhRll5VdVnZZ2eWJ6yi7TMouK7us7PLsWWFll5VdVnY5DnjKLiu7
rOxyXHGVXVZ2WdllZZeVXSZll31ll5VdVnZZ2WVll5VdVnZZ2WVll5VdVnZZ
2WVll+cD5y18cfC/mhf+ActEj8E=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17044450]
}, Open  ]],

Cell["\<\
Alternating backgrounds with yellow superimposed in the first and last \
positions:\
\>", "ExampleText",
 CellID->1502355071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"Pink", ",", "Red"}], "}"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "Yellow"}], ",", 
          RowBox[{
           RowBox[{"-", "1"}], "\[Rule]", "Yellow"}]}], "}"}]}], "}"}], ",", 
      "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->448480217],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->301080929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->697401140],

Cell["Blending of colors:", "ExampleText",
 CellID->636484464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Yellow", ",", "None"}], "}"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Purple", ",", "None"}], "}"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->527153300],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->911115377]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96657118],

Cell["Set the background for specific items:", "ExampleText",
 CellID->1018545094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "Pink"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "Red"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1415183459],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64003698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->174397539],

Cell["Set the background for a subregion of the grid:", "ExampleText",
 CellID->1095244621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "Pink"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452610656],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->504065717]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->692489402],

Cell["\<\
Align the center of the grid with the baseline of surrounding text:\
\>", "ExampleText",
 CellID->30132536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{"Rectangle", "[", "]"}], "]"}], ",", 
       RowBox[{"{", "2", "}"}], ",", 
       RowBox[{"{", "2", "}"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "z"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30922498],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztms9OwkAQxre7rSgqEeNB44WTJ30NPanP0BATOBgN8lwmXny3nurM7oLL
dEhpognoR9LZznR+8+0/Cml6X84nT8/lfDouR3ez8nUyHb+Nbl9mFHKZMaai
4/Pc0HlNZ/6o6praYG/IflDw0nvXbB3n+I95F/7FTmVZMo/k9ql9oLYABQoU
KFCgQIECBQoUKFCgQP0qlZO1FLzqSJ9GzseNE1e7VjtT8lG1WbUv/B6Z3IRV
lPHU989liqXvaxu/hptp2tjzNO5ifF/TylMtzhqu12rk2tjKUUkleX1P64nU
FPmFohP6JrNFX+Macj8P6u/vArfq7Iv6y7zGqsidkYW4C82i38yfJJlMDlp0
j4TP+vwokhUydcx5qrQy9uMWLXldH5Xca7ahM1DnqE39UF2rrvuP54uRsEEW
HzmLmvb6XdV2n5DV/t497P9V/Znf2O3/LwEKFChQoECBAgUKFChQoEDtKrUt
79Ctvg9YJdZkX+tj/uY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{249, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353732184]
}, Open  ]],

Cell["Align the bottom of the grid with the baseline:", "ExampleText",
 CellID->1694006710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{"Rectangle", "[", "]"}], "]"}], ",", 
       RowBox[{"{", "2", "}"}], ",", 
       RowBox[{"{", "2", "}"}]}], "]"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Bottom"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", "z"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->881279972],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztms1Kw0AQxye7id+WKh4ULz150tfQk/oMoQjtQZTa5xK82zcS7zmtM9mN
XcctaUQk4D/Qncx2fvO1Ewqh1+V8cndfzqfjcnQ1Kx8n0/HT6PJhxls2I6KK
P4tj4nvHd/Wnco5lzqth9S3Iot61slqxqi96V7rpidWO0jd5yclXFe+/Kn24
tnfpiY5iw/4iyIPV3vLP3WBrgtQZbim9rYINXoqEHx/bJDKOcgnnLHlsu+W5
i5Q8Xmg5F9JRKuIqqJmSyH/m960XTX7Cx50WcqDIZ6XvJU5UBlgiZMna8jjS
lxr3W2Lp79NV6akw3+IMkj1qi76bPJOucyT9EsQPQnPpLqZir54eXfFZi7ej
H3kRq9vwdN0kqofXv/TaPEVdvR26+HfjvCN9AgoUKFCgQIECBQoUKFCgQIFa
k9LvY2D1G1b9P3dQoECBAgUKFChQoECBAgUK1P+h+vIG5cL5/46d1loVrZR9
APm1ILA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{249, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72533254]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Frame",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->484677263],

Cell["Frame the entire grid:", "ExampleText",
 CellID->1647424742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406535651],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWCtQ5EAQzTKzPzggt5iVK5FIJOoOc1VIJFvU1S3i6rY4BA6JRCKRSApx
hUQikUgkEolc3qRDMskmTMgEdS9VpGbf6+6hu3omM+/H+Gjy8/f46GB/PPp+
OJ5ODvb/jr79OQSkWkEQ/MPfr2GA8Qyj6M9AeJQZR09wjVdrDu2YV//x8fHs
7Gxra2tzcxPcxsYGxicnJw8PD0HotPjagEUTs7hj9Atr0DavL6enp+vr69Pp
9Pb29u7uDtj9/T3GcAW+t7f3/Py8XNly5RMsP2P26jG7hbVT5qXhA7vj4+OX
l5deBF9cXAC5ubkJFp0WSw1YNDGLO0ansAYLb1boONNl0Uzq6elpe3sbFQx6
Dr7vyfvGd/m306y7SdZ4YIvVhTIFUb8pmKNIyYpS5XzHk/eN7/JXacYdO2MU
CO2x+laf0WhkvCWacGa4kuM7nrxvfJe/lW07yRZbAtaA7Lrq/Px8Mpkk610J
aYZhjteevG98l//CXK6oQBiGpg4DY9BFUfAJkSLkOJVw8Zr/IO8T+z1fbXNx
dlqyQ0OjrdeiRYGSoDBiZeEqweOZhTPDQRW+btwyP23j2WyEkWySaFncmmUh
918MqvB145b5aRvPZrO7u3t5eSnZYGligYqVhasEj2cVLs3GwdeNW+anbTyb
DU5ZODFINmhGtKRYWbhK8HhW4dJsHHzduGV+2saz2eDMgw+iZANzOImVhasE
j2cVLs3GwdeNW+anbTybjeyHks3V1dXOzo5YWbhK8HjWdA8dVOHrxi3z0zae
zUZ6ULJJapPFrZrJrGm/D6rwdeOW+Wkbn/vW4nSZ3HAUjtroSbzjb5mQZhjm
eO3J+8Z3+c9/a/FIk8a5ptVUuc4Pc7z25H3ju/ytXDMnRhw7cPhYzXnLiUw4
M1zJ8R1P3je+y986MWZuBDiRxL28/NYL+I1dNp6xnO968r7xXf56Vn7zw10Z
9wjsXfHNCV/8+L7Yc/B9T943vsu/XZi13PlRK+zV2ODgHlVX40aBBYHDDgaL
FWyWGrJpaq4qcYoVgGi9LGG/Rx1FPMC9GcsFNcUA4HA4xEYh66iC3WrDdk3P
WzVer7BaUVW7WGVijj1FAqDg8V2nmFurydWN+Z7fYmFmxRrrR1DqsdRjqcdS
j6UeSz02oB5LPXZGPZZ6LPVY6rHUY6nH+vlTj6UeSz2Weiz1WOqx1GPzKJVX
Kq9UXqm8Unml8hpQeaXyOqPySuWVyiuVVyqvVF79/Km8Unml8krllcorlVcq
r3mUyiuVVyqvVF6pvFJ5Dai8UnmdUXml8krllcorlVcqr37+VF6pvFJ5pfJK
5ZXK6/+nvJrf8lzjryU/W68HXjHR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{181, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119905746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->322065365],

Cell["Frame all elements in the grid:", "ExampleText",
 CellID->760978023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717006499],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmb1P20AYxi+146SqKuiH1IwZGRkZmdoulRgZiVClMFSNKAP/AWNGRkZG
hg4ZGRkZGRkZGRndx/e65/PdpaR1nFylxxIovue5r/e+bP++jE7GX7+NTo4O
R8NPx6PJ+Ojwx/Dj92MkJR2l1Ax/RwOF3zl+6b9Znuci4EqKFH2pD8W/lu87
Xq2Zdt3c3Ewmk52dHS2pZHt7ezwez2Yz1XdKic3ffcb/cgV+P6qpzvr4+Hhw
cIBc0+kUJahEp97e3p6fn3/W18PDQ9nj/ztv8hd5e2vM64+U9iYYya2trYuL
i3L8q/tuqMaI/C+e8bsj1Ybfj6rkOjs7K2P/St/LOOGSuRabv2f8uOZ7uy16
y0hmdg7MaEztDe2GD0E3PVqXr2t8YlKuK1myy4vL09MTJuD9/f3G7yjitoiq
04/V+sq+GJNyXcmSXWVcqhjiVMKmp97oErBKMddEKGyyCsRS/NxctqvvuEyD
dHsSo0rutLmj7H/pQ5SGw+G7Quzt7u5eX1+bZoikGmmZrQXrsiW3PF9Lba3e
E3QXnZYSsGOcnp6aFomkGmmZrQXrsiW3PF9Lba3ek/39/cvLSylBFrhpkUiq
kZbZWrAuW3LL87XU1uo9QTJEKQHrbzAYmBaJpBppma0F67IltzxfS22t3hPM
QMzD93m1szVO75p0SVS22xb+mG6d2PUWy0qRPssSMo0QSTXSMlsL1mVLbnm+
ltpavSeyl0kJ1V5mSaqRltlasC5bcsvztdTW6j3BmsHKkRKw+LEFmBaJpBpp
ma0F67IltzxfS22tfm7iTMVKwUmr3hbOPg7Yu7s70yojN1Z7tjq3VkdeQE1t
1XsmwHNU8XwpzwTOLl6e42Ipfm4u29V3XKZBcp5XJ5F94jdxhJ6hMYUxkeUJ
CoHC63sRd/+Zd4W+anzEpFxXsmRXGZfa2wjOCDiK/fq1zgFveYbocmPwVvE0
RteXtuCb906LPR6LrYixvL/Bj0KKN+HwO+ea/bVIz/f676nL88755pJiC8Ns
xSLGD/1dJ8UIYB1jEDBxg99FIs3zYoE8we8qLeXxI65bnGJEcGjs7e1hwywm
jkqn0ykOSCQixf22FnOedIE87pfiNvPM+66Okbm6usLgqATPhyqZTCZ4JsHA
zfnuHY+/+4w//J18uX4/qqtjJOQz5DNxMRbymRh4C/kM+Qz5jOsinyGfIZ+x
JPIZ8hnymUoinyGfIZ8J9C0nn8nJZ8hnyGfIZ8hnYmQt5DMx+uPhM7GQEvKZ
f/GTz8SQl3yGfCY63kI+05aPfIZ8JuQinyGfIZ8hnyGfIZ8hn/FV8hndJvKZ
PCefWdBLPkM+E3ke8plV5yGfIZ9p956khKSEpCRm8kFSQlJCUuK6SEpISkhK
LImkhKSEpKSSSEpISkhKAn3LSUpykhKSEpISkhKSkhipB0lJjP54SMm6GElx
L9dP/HXktvMLZ9atww==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{183, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549429863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1031681727],

Cell["Frame specific elements:", "ExampleText",
 CellID->1356547037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "True"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "True"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1108049723],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26076089]
}, Open  ]],

Cell["Frame a region:", "ExampleText",
 CellID->1799654307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "3"}], "}"}]}], "}"}], "\[Rule]", "True"}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1630253401],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnCtQHEEQhmfZu9s7SHga5EkkEolKqKRShURyRZI6RCoUQeCQSCQSicRQ
hUQikUgkEonc/NO9j2FZ2Mfs7J3oreJurv/Z7unZee0n+DE6Gv/6Mzra3xsN
vx6ODsb7e/+GX/4ewuR7Sqlr/P1eVSiHKNHfdRjie6A/O/f39wcHB5ubm/1+
fwai8lGGBXa1WFhjqYEa7UTpU86B/uy9vLwcHx+vr6+fnZ3d3t7i54y2d1GG
Bfbd3d3n52f1qVLtzw5rT09LetSP9Onf3d1BOD095bHkX1xcrK2t3dzcqNkC
fc5Sd+2/S1nSp4/0NzY2Hh4eoruenp62trZOTk54TH2gDyx11/47lCV9+pgj
qIXHrubpN6qgI2gIFOg9S921fxrHyicrdNTS68FC3Bd44npcdwr0rqXu2n+a
5Qwe7VI8njFrqfiOvVPR3pQfj1pLbfbR+sVF2gSW6XEiIQzWkC7WVqheYs+/
r0h35NeD7EE3M0rzXI7yf8/uV7Q35cds7Xg8Pj8/T/sJKz62Te4n1rifEnv+
fUW6I78eZA+6mVE69zny4+PjcDjkyKxx5MSef1+R7sivB9mDbmaESY/NKj8y
a/mRM/cV6Y785mW0vb19dXWVRsYUwkziyKxx5MSef1+R7sgvzXg9842McNDE
VptGxiPFg+XIrHHkxJ5/X5HuyK8H2YNuZpTewZGTmYeLNY6czsjc+4p0R349
yB50MyPsn6urq3q/XIp/Y1xiFy3UfUvdtX/OkmtdXl7u7OzoIm1TPg72OORS
sUDvWOqu/XOWXAtVUFEX+cSHBQfLji52C/Sepe7a/4yRJZ4t3lGwgPJ7mj59
4Lc+zfcK9MBSd+2fxkrUl9jEsZrinBK9o2AmR29i/QJ9YKm79s/vWNSXHeSO
cxiWKBSC1xZ002yJOnMN1WkzFr9LUz/PoUdwdsYwxxkUvYVuwxRAGTVh1/03
X7LeQsP1JhWX+ot5RoAVABo6DudZrA4o6xG0/IG2UlNz4ZNmQrQF8fVdo8fI
qrkjXeobzZD09883NXi2uGaG/Uw72olallSaLaM1ZCpYYS/TZ9PTsjoU08zE
j/dgR8Sxm+k51/HKEU6zRXxCdUcjO5kecB2vHP1UQdIiXO4oJWXbUqxyRFT1
ktYkWLFpakmRWohTjo6+Gn116WY3sbNP8u2elaoOt90gl3WJZpDqhktl5bMS
JY1z4RxXwnpsM17CEkeqrqePKWncWoNZ1mWZQaobLpWVz0p8NM7FoJV1KWaQ
6oZLZeWzEhmNczE4ZV1+mc2F5ZxcXDHROBeDUNYll0GqGy6Vlc9KNDTOxWCT
dZllkOqGS2XlsxIHjXMxqGRdWhmkuuFSWfmsREBVlwM3zCgHiZ6kNmkKGmeK
i1FiVM+SU3YTnaNE2UyahhrnK1xMFfn80xyxzJzjnMUpR0Zfn6PdEUx6fi3F
KkdL374/uSOb+e9rkyapb96hWyKdue/vU0dZzRaSZQLkM8j01KTaUY3Ami0m
S8PkdJDpFRcxytDZKhy2iRrCcoXlCsu1iycsV1iusFxhuWEoLFdYrrBcYbkW
PoXlCssVlissV1iusFxhua3HFpYrLHc6Wa6QWiG1Qmrt4gmpFVIrpFZIbRgK
qRVSK6RWSK2FTyG1QmqF1AqpFVIrpFZIbeuxhdQKqW2P1PKXvoz/muD9BzAu
6B4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->703016934]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1487836305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " supports a variety of graphics directives:"
}], "ExampleText",
 CellID->1784441749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "True"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "True", "}"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", ".05", "]"}], ",", 
      RowBox[{"Thickness", "[", ".01", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2010859911],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXDFMGzEUPecuTgKFXnNLxoyMjIxMLUslRkYiVCkMVSPKwMbIyEg3RkaW
SoyMjIyMjIyMjNd39sW+mJA78J1a0WcpxPF7/1v/59tnP0V8HR2Ov30fHe7v
jYZfDkaT8f7ez+HnHwcYCkUQBL/xGg8C9FP01GsJr26aqvdfeA+C5yMt9Abo
tWZGOlmvd39/f3p6urm5ubGxAX/r6+voHx8f393dBd3cppwZlzI+1cCoY5au
iV9mvQ8nJydra2uTyeT6+vrm5gZjt7e36IOO8d3d3cfHR5nnobrFSmXmagPM
JmaXJm9R1ovAA3Z0dPT09KRyGp6fn2Pk6uoqaOf5KmculTKWa2DUMUvbxB9O
EVRXVlHKNnx4eNja2kLGgiiPvozXLcF7nriv/8hE3FIIOFhJSE2gqiYEDYnJ
uq084jJeuwSXnriv/5YTMRKjl0PORG6Gw2FmORvxy7x2CS49cV//NuIgK1ds
BKh+vYtGZ2dn4/E4VW0uIzSMQNe6BrNu7OCRJ+7rX+g41SjijuM4i76vPiMV
eGCY79/FOwZHe6Vtg74FYAG8GBnKGMWcdbUHJAMpsR4cXBocTWNJFbuG/ArA
AngxImvRdyzm4tLgaBpLqtg15FcAFsCLEe3s7FxcXNiZsTCxPK0HB5cGR9NY
UsWuIb8CsABejAhnK5wV7MwoStSm9eDg0uBoGkuq2DXkV62hbC0VIsKJB49F
OzPoMLIeHFwaHE1jSRW7hvwKwAJ4MSK7M+qZLy8vt7e3rQcHlwZPp1t+UsWu
Ib8CsABejMjWad/JwVxcGhxNY0kVu4b8CsACeB7R9OmKs6a5xUQ4dKMu8Tct
PH+LjNAw8uejBrNu7OCRJ+7r34lTF3AeZzGDcxmFXIZO/ccOHnnivv5tnPpb
x/EDh5Csu+pYzp4gX+a1S3Dpifv6d8/MOJ/kNboyrQF8xiarcluFJ0vwjifu
6z80EetqwV0Z9wnsWPkNCg/9/M44exN8mdctwXueuK9/exPUN3rkBrsztjOY
qGxFuFFgEeCog87s7X8xd6kCZ7kmTl1zWSVAVdIydnbkTQsHuDdjaSCH6GBw
MBhgY1AV9Rr+akXex5p5dc/bMZlSFdjBatIU7B3aCAlW1VfG6S/Akjdib/XZ
M1E911SpslJlpcpKlZUqK1VWqqxUWVOqrFRZqbJSZZ2HU2Vt2C9VVqqsVFmp
slJlLedQZaXKSpWVKitV1mxXpspKlXUxjyorVda/qrKqKBaomfNwqqxUWamy
TiOiyvocp8rasN/3rrL6apjUWKmxUmOlxkqNlRorNdZ/SWOl6krVlaorVVeq
rlRd/1vVVY3yt61UXam6UnWl6mo9UHXlb1upu/r7p+5K3ZW6K3VX6q7vXXet
8p9bA/EHCmZb9A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408040294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596672098],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " is applied to all sources of grid lines, including ",
 Cell[BoxData[
  ButtonBox["Dividers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dividers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Item",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Item"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1503345088],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1418344857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Frame", "\[Rule]", "Green"}]}], "]"}], ",", "x", ",", "x", 
       ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", 
      RowBox[{"2", "\[Rule]", "True"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "True"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", ".05", "]"}], ",", 
      RowBox[{"Thickness", "[", ".01", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->306806790],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXLtOG0EUHbzjXdskxsZFXLqkpKSkSmgiUVJioSimiGIRCjpKSkroKClp
IlFS8gmUlJSUlJuz87QH9uF9WFm4K1k7e8+5M547s/M4Gvv7+Hjy49f4+PBg
PPp2NJ5ODg/+jL7+PoLJW2GM/cXn55AhHSIlPh182mEYtnG/xJ2x15YGUkGU
8l5eXq6vr/f29pi3vb3NvN3d3aurq6enJ9YCnoXXqxjvF/TvmBr7UYrDPBwO
wQTfu7u7Y/zm5mZ/f380Gp2dnQWq1lm43SVy1krKp22iwQUbEdrZ2QH8/Pws
WpojkicnJ1tbWw8PD00VjSzczhI5qyXlE5hoeKIXIVwbGxu3t7dMlODd399v
bm5Gz1xFIo3XqhhvF/T3TY0bAkFYwIzek8/6PcLz4+Mj81SN03h+xXhQ0L/p
1Bh9Aa9IlOzq2KAzRMnGXI3jec2Kcb+gv3hbmeypaHP0/ygpx0l0fYwChpWA
p/kXxUspX7EwtqGpLQutjzEQfUKVEo+n+RfFSymfNZwWXhfPcozXPfcV7hsc
l8QGeex5y3H9lDeaD41oa3FxcTGZTGzuDu4bHJfEBnnsectx/ZS37YeyFnLx
YXN3cN/guCQ2yGPPW47rx9wxTtYC8wZWTzZ3B/cNjktigzz2vOW4fnLEPj09
lShoIGvU2Lmx57UulrPD1rG2/UjG+vz8fDqd2hg4uG9wXBIb5LHnLcf1U96Y
YTEy2VqgOdAoNncH9w2OS2KDPPa85bh+Yh0gBlVsELAulrsLjsEXQ7Bqx7cY
nmGoEVuCoRmxy8N5GfnLekZZAcBCCBOK4PHZOMVwZmLm6bwlzMrGeRn5z6zt
bJ/tOn19fm0Xz2tWjPsF/bmpsYwNJlsVi0/iGZsaFSu9fk/jBRXjrYL+zfka
R+8qyAgPlkdijxfN5NjdRGv9uV1aIrO1FEa7hDzsjs30DUQG87mMHJcrLsz1
CJber6czV5fC+FRCHnaPLjUZjO5YyfR6PbwRHuZcxhE3jH1wgNu8fpPM7S6R
s1ZSPla/ke8VOgwGh4gWrT9EJNVOQut3abx+xfh6QX+r3w1VjS4XspDOSTon
6Zwh6Zykc5LO+QZOOifpnKRzks5JOifpnKFRCBN0zrdw0jlJ5ySdk3RO0jlJ
5ySdc+k6Zyc6+pjAabOQVa2DlqtzdtQ3jr756RzSgOWLulskm8oZsjRekJFX
R7VTzUopXH8B7ntQPdVcm8LlC3Drrn7q9Vg8z8vIq5sKqncd8bxGRl7d1NDX
O/TuzAwdiiuWRZrogjhpoqSJRs+kiZImSppoDTRRYf0IZz/VtBKjiabhddJE
QUzURNMZdVNFdf9xeHx29I9l1Vgb1ZGM5zUy8uqnkao6JTK9zMz6aqUzvSqW
yTMz66yZamUnmesvwK23dtrIoI0GGXn/h4aqf+8eiF/Dy28d4K7tPXXvqwj1
HXsL9xUTQzpRSidK6USpy6ETpXSilE6UknpK6mmCndRTUk9JPSX1VFg/gnpK
J0rpROl7UU3pRCmdKKUTpR/1ROn7+eV8lv8DZSv/ADF7mso=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290415223]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147237284],

Cell[TextData[{
 "Directives given with ",
 Cell[BoxData[
  ButtonBox["FrameStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameStyle"]], "InlineFormula"],
 " are combined with those specified elsewhere:"
}], "ExampleText",
 CellID->1575787061],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1473278600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Item", "[", 
        RowBox[{"x", ",", 
         RowBox[{"Frame", "\[Rule]", "Green"}]}], "]"}], ",", "x", ",", "x", 
       ",", "x", ",", "x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "Red"}], ",", 
      RowBox[{"2", "\[Rule]", "Red"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "True"}], ",", "False"}], "}"}]}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"Dashing", "[", ".05", "]"}], ",", 
      RowBox[{"Thickness", "[", ".01", "]"}], ",", "Blue"}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1991996265],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL9P4zAUNo2btIUrLR2uY0dGRkamO5aTGBmp0OnKcLqKY2DryMgIGyMj
y0mMjPwJjIyMjIy5zz9it66apPnRu8CLFCV53/fsvmfHsT8Zvg3PRt9/Ds9O
joeDr6fD8ejk+Pfgy69TmLw1xtgfnD/6DPch7uTZwtkMw7CJ6zWujM1bargL
xJ339vZ2e3t7eHjIvL29PeYdHBzc3Ny8vLywBvAauEm8Tsl4N6d/y0TsizsO
c7/fBxN87+HhgfG7u7ujo6PBYHBxcRHoqNNw2yvkbBZUTtNkg0s2MrS/vw/4
9fVVtjRHJs/Pz3d3d5+enuo6G2m4rRVy1gsqJzDZ8GQvQrq2t7fv7++ZrMF7
fHzc2dkRz1xnIonXKBlv5vT3TcQ1iSAtYIr35FP0HuH5+flZRioiTuL5JeNB
Tv+6EzH6Al4RcduOcoPOIG5rMxEv5tVLxv2c/vJt1T0VbY7+L27VOImuj1HA
sGLwJP+8eCH1axbGNjS1ZaH1MQaiT+haFuNJ/nnxQurXPdK28JZ8VmN81HPn
cN/gOBTWy2LPWo/rp73RfGhEG8XV1dVoNLKlO7hvcBwK62WxZ63H9dPeth+q
KNTkw5bu4L7BcSisl8WetR7Xb26MU1Hgu4HZky3dwX2D41BYL4s9az2unxqx
J5OJQkEDOUKNnRt7VutyJTvsKNe2H6lcX15ejsdjmwMH9w2OQ2G9LPas9bh+
2htfWIxMNgo0BxrFlu7gvsFxKKyXxZ61HtdPzgPkoIoFAubFanXBMfhiCNbt
KFZRLsMzDD1iKzA0I3ZxOC+ifBWnKAoAJkL4oEgen86TjHSeM5UzLypbwaxo
nBdR/tTczvbZttPXZ+d2i3n1knE/pz83Eavc4GOrc7Ehn7Go0bmK5u9JvKBk
vJHTvz4bsXhXQUZ6MD2SazzxJcfqRsz1Z1ZpsczGShjNAsqwKzbTN5AZfM9V
5riaceFbj2RF6/Vk5vpKGBsFlGHX6EqTweiOmUyn08Eb4eGbyzjyhrEPDnCb
1W/iue0VcjYLKsfqN+q9QofB4CBoYv4hM6lXEpF+l8Trloxv5fS3+l1fR3S9
lIV0TtI5SeecnTWQzkk6J+mcpHOSzkk6J+mcpHOSzjkVhVQI43ROoQ+Szkk6
J+mcpHOSzkk6J+mc/1rnbImtjzGcJgtL10GL1Tlb+heLXz6ZQWqwfNZXi6RS
OeGRxAtS8iqodrIwldrpL8F9B6qnnj4lcfkS3IqrnyxMVD+9lLyKqaAsWnUs
5tVS8iqmhrL5FXp76gsdymMhizTRJXHSREkTFc+kiZImSppoBTRRaf0Aez9Z
GKuJJuEV0kRZmKCJJjMqpoqa2ZvD49Oj/0JWdbVRs05ZzKul5FVOI41iimV6
qZmV1UpZmEIr5amZFdZMjbITz/WX4FZbO62l0EaDlLz/Q0Nt4RQ5COTfvqtf
HbDQ2Dv62tW7Y7uOvYHrmskh7SilHaW0o9Tl0I5S2lFKO0pJPSX1NMZO6imp
p6SeknoqrR9APaUdpbSj9L2oprSjlHaU0o7SD7uj9P385Xya/wfK1v4CnQ+a
yg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->293275890]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1553309940],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " will display graphics at their specified sizes:"
}], "ExampleText",
 CellID->2017280280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"50", ",", "50"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], "}"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1925534591],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwXAXiTAkGIPs/kAXG
V///B9LkkSlAMgxoiPQoj2ieJJDUBvIURkVHRUdFB5XoYConhgqPvJqDgREA
LQYeZA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{213, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399843]
}, Open  ]],

Cell[TextData[{
 "Giving an ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " setting to the ",
 Cell[BoxData[
  ButtonBox["GraphicsGrid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsGrid"]], "InlineFormula"],
 " will scale the graphics appropriately:"
}], "ExampleText",
 CellID->2105330771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"50", ",", "50"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Rectangle", "[", "]"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"100", ",", "100"}], "}"}]}]}], "]"}]}], "}"}], "}"}], ",", 
   
   RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->206216578],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpACxgwQDkP0fyALj
lP//gTQxpB6QNAZqYR5SPBgFAuJALDIqOyo7bGUHU84jnkdM6cPACAC/Eslm
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64136224]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->107368884],

Cell["Make a picture of the first 64 elementary cellular automata:", \
"ExampleText",
 CellID->242310825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ArrayPlot", "[", 
       RowBox[{"CellularAutomaton", "[", 
        RowBox[{"n", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"30", ",", "All"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "0", ",", "63"}], "}"}]}], "]"}], ",", "8"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4084833],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnemfFdW19yt9hu6mu5mjiN7n5nn/5C/Im7wwxqg44IioTDLJPDklcUQR
FME4JGZQERQxYQg4AA6IIKAyOQVBFBFBI6IIzsZ4v2uvferUqVO7dp3ug8nn
PjmfD0XV6Tq71lq/Ne29au/dZ9DkEUPHDJo8csigH/184qDxI0YOmfSjE8ZN
5KvcD4LgB/8vCIK7ewWcf8eZ+SefH/OP85z+J5//w78ilz9K+L/g+L70f0NF
a3L8LznkSk/7LsjHro+r8e+52HW8/fjfa22/PX9HvMEP5P8q7o81d7/33nv3
339/YOVkfv3Xv/515syZQUEO3W6++eZly5YtWbKE4yOPPBKeLF68ePTo0Wed
dVb//v379et3zjnncHLuuedefPHFQVF+mUTX1VdffeONNwa9brjhhqBw3XXX
3XHHHRs3brTwFkp3zTSfoIdp5dprrz377LN//etfKz253//+9/H77VPa5NCV
Vv/yl79w/5///GfOFy5cWH3OY//whz9cccUVUa75Vch1cdasWVOmTBk8ePDd
d989cODA2267rVsST8dyfeaZZ8L2+eefr/y7TmBixIgRl19++bBhw2bMmIHI
Lr300qFDh8a+CRomTZoU5F599VXLZTEmld6Gjj/96U/279Va3duQt337dm46
fPhwtA3QA4KgKIf87373OySCOB5++OEG/guKnCAFEIQnkAXTBsgOcn379v3l
L38pPyrIIS6FPNeIF+qvueaao8wdnFx22WW7d+9W+pJs4GrzCbobWqZOnYqk
kDTt6DN++9vfpuKMXlxwwQVQzNX111+PkB966CE9D7/v06fPH//4xy+++CIq
A/4UyqDAU7jp1ltvveiii0Tw3Vz8nXrqqSeeeCLSaEAqQV6lw4cT8003/YYb
aAnVGTBgAALg+Ktf/Qr0Y9+MGzfunXfeqZJNPiab3oYaVNWDNUr66aef6rdR
rK+66qqgKIeu4IF4HjYfoF6wYIFijYZDOFTrEdwHDRrEzeZXSXLYu3fvvffe
CzuK85VXXvnSSy/JH504X2U+QXfT4sSJE5E3Oq90+VAuonYY6z/Nh4dyu3lO
U/R72vzqq69i3MNeyH0RnVDR33nnnWeccQaq09XF386dO/nzz3/+c6P5jYow
p9GToIHToA1JASWKN3nyZNpG/YE+/AbQJ0yYgB1Xef18TDK9DS1pKB8jh8KT
Tz6pKMc9g0W6UQ6d77rrLnANMdYTTBobDnngHOfXmCSDgl5/++23c+bMQeJB
zxLOmGgFrg6cu8khj8R5GvaMMDMhXeBGBHfhhRdCHHRruxXffv31126LsXgb
ngrAfMopp+AogQjtCBLRPja8JhoBuGKrphA7wSyGDBmC1kIImgdF+AogD7/B
jMR7xONv7Uj3Mr944okn8MxJVhW2SIwWYJrk0BYzbY4KuDLACdQjyaAxybsV
w2tsae7cuYBufHIOFUEyf//736v4ivtw9Zpq2xJV9TnElzTE88iNx/Er4lS+
6hun1cCdNG+eIZatIKD2WDbRo0sSj2Ws+UybNu2EE05wwc1RY0EUX0WcuAJt
xOw9e/a4sa7w3YQfJ9ZHm1+sWLGCVCrJshKxbsTtRe1bfbh6pJyaNraq96Zk
hqpXDzzwAGjLrV1KiJOeffDBB1WIxRHvGonaGBnKlQlzyeb4BRmk/TuhBsoR
gFueFm/DkVj2ySefTE6KRuNeg0S043w2kV0lIm6k1gL9iUbN93yzb9++Kl5q
x/oo84vHH38cX51EZ3htfXmzHFrmz58ftWs0D3jVHwE6sguakjxbFW4PPvig
xbmthPNNN9304YcflmNIHGfrsbrGonZT1qiNIpB3ffbZZ4QsktAG/gtyEIF9
p/Jv/bh5ThFtgVTMjtZOP/10rLtzFn6l+xHD20TzFpUbqQAWrpATqGkeTRo+
fDg9oSp51O7Bf2h+8eijj6LkcurUHYu04TQPLLfffrsadoOEv0IItgZr1YgU
zvUaLbFIt5SQnj59+oEDB4JGD9JdSnE7tGjF2mPRzdx43nnnIejTTjstTDCI
vkuXLnVL06JseCrg0bgfG6UfNH78+MCHsbnuRpfsZz/7WcymQ+dN5qGagzPk
HJj3799fJYNkdNPsuKf5hfaAjaq5WrQ+u1kOneh1hqYcJt3gSpRGfM0eH6Zy
RzEssno/1ojIPv7446DJhaz1Tuoj0XH6MEaTsnhqybAJDyS1cEpSq+eol1OG
1k+b1sVy1cDormO5qFVbFi4LGAGohg5a41oTCIIjGTXIgi/u6JJLLsF9xTmv
3S/3ML9AVx977DE5dXIXxbOI5/3Nb36j1gqkwNiAazFZsn2yL/6q3tACmhlm
M4LpLbfccvDgwaDZg2nnSPxFnUIt8qDaqKMp9CS44hybJSZVaVAc004m9oIN
doo7GTFiBB3YwIeo4bGNxCyKqKbSoW0Sb9Fq0eI4x7Vj2d38Are6fPlyo8Ip
WErs7FQKoIRHBRKfi7JyJNKYv6Zwp5pC5mIRLJQQvPXWWz/55JOgkwvBa8wn
6GzaR5WxSsnY9Hn05NPwk8iKRSEv3BmCg1mn3GAp5FLsESPGURO6YBHFac3C
XwsPO/7449XLAh1wwa662LFjx4qmxvnMx/jsbZ6TNl7Vzfxi0aJFK1eulFMn
R9YGTWQrzp49+y/mg/qT+SPCFo8+qj7QiEUsZw5kA7NmzZJxshaPzRl9txFS
O1SdsthcQSMkNNLJhEW3xKy1tZSsjZyLNA1Tw+CC1izcNSNn8NIgDFjYGWDh
uJP4q93Cun5nvZY6EDcn1sJajO6heEQ/mAMplVuLR/eMBjTilRUpPqAE4JJE
tnrsyui15FOkEmg6EmjJYlnS98QPoEakbk5JWZvSZ+A5+vXrB3fI12dNytG9
994LOpqFYkEgS4JcxVHtFtTlOxvFnnvuOWO2Hg0zupRH7fEfBC9k5NMug7SM
QMEufOMW/vGPf9g+ndti9DmQj/cAeU7URgmeaVjkcE+o8Lp169yyIR8p2woU
kQ5iYSi7wScTNzh8+pIkndz9z3/+s4qbuH1oqzfccIO9Vl6Ib05cOpsW6OE/
88wzcurkBlalCNMqh/w999zDTwgj8+bNM9+kcKJIo7KIVMa5O7sQud98gjbT
HjLCzOW0xVzbZNaJBzHfWryTg9WrV5fbRyY8IuTISz+dQszhq6++qqI/H6Nf
2xs1apS9VvrJYSowkON/B5UVQLludPwfv08hFAJ+7GwvqV3X33NVmvGfymOQ
I4EndAZBZCQbO8FPBwU5iBbhn+bMmRP0NNcJTyOW4CuCXnIoEJnJnp999tnv
Yrp8t/kEraYVHsnd5Ws70Jqg+6a2koMkssEKKrEF+WnR/P7mm2/GVOW0RxKV
ogZ4S9IuWqnLEfeAD1q/fr2SXYxx2dtQYYeZEr2S1ozIIQlHe/fujbZBEhbm
suK38UAYGCc9kjyq1EsImEROKDtKBphznJCWvvTSS966n/YeuL/Cm95xxx0O
NEwNJI+boTP99ttvR6l+6KGHKqgG4uHDh9N0ItX/xbVWYkmudCSsg8eRI0eu
Xbs2YzWvnC26kEHvgSWGrs19TdUyN23aNJDCKwdOXF555ZWZM2fCpNbpEJr1
4D5cjvXktIoD/ZZqGm12oTTOmDGDsEwCl0zjcWrt3EL2BD9QypE0rx1H/S0S
co6gZ85wtdL28ssv79mzxzYSOGqqeWSKBRG7aLV7Si3t0KFDpFoyeqq1NFIo
rKZC9nEs7HhUm2mVH9nrFs+InKkeFbDYZOqjNTLxrhiJGG0i7bZiQk8Wg8Kk
0XSAavfxkksuyVgdS0NHq2Nbt25F7km6HB9bVU7xljh59DGZ03L9i+4FaSQ6
1b2EE65t27Zt7vpXKk7uUXKt/MAERKXyUYEYYuQRUmdMQ0wVjljIjXgIDLAd
R+vROl7PVE43b9583333ffPNN94alxkHk54VUY7gg3omvpHRGF7zoQ9F9gts
WpWyuG3fvt1bxfL5Oq3a0PMir/jyyy/d1EdrVNayJGlIpL13lHb65agn3pQ0
AtHXdAQksoB61aY2btxIqiW9Oifq0TqktSoEk8xl5Fq1+/PPP7/99tsFJRm7
bACkILdjxw7Hb2pFSqsuaCJBT/oRmaqJEkfxbhKjMvHQEwfBTyZMmADbmFfG
I8nGCy+84KwUZMZJeaQpHPy3337rrSw1l6yTvrL0ihPfgqiSOb3IO++8U3DS
/i6mRKDbuXOnt4JUqxfUWgrpKtFR3u1w8hOtFuUgDoFK3MrET3f0Doc2fvx4
kMDOvEcaxxSyVYrSPJ9yt2HDBtyYjC448a9AC79t30P0cafXeCUELO8Ndiqh
xe/eeustd1WonWhppQTfhq8VT56ptideAqic7+DEr7uifXi2sWPHIgIwSzni
YkkEnGP8mXFSvtatW4eVyKmvAqRypkv34IMPio/3vYGgcsQnoeiCU1MJJ/6X
foyv0uPzfFL1aKDbFOTwCRXPdHs/5QFLIoRk5qEzukZPF2ywVzCoPvJXUKHn
Ua9aDjkIUpZTJ872jVbDUR5e4BBiQL2zhyfVX/wOUAouxRIuuEp5b9VZv8mI
i1Y1MBZMRry1kwP7PmqnUlSFCcnxfJgY+lvRq9mzZ48ZMwamx40bx3l45BvQ
eO2115yj9JnRUF6effZZfcU2tUITjvuLZ58/fz4ezda63LyozeFVIEKwyBuK
6CThO+RdK2dlxo6Qt5n2+ZG99o34ax0DMXGL+GZfDU3bw17oxmTmpxO6RcYz
evRoxYOuhWJDhHn99dedY/SZR/2VCzrRCxYsMA/02IgZYckjUriCGGzEV8FV
nSUnJBs376aXcEFHZeTIWYvJaCNat8CZ25f6nRxYG9ExoqlTp2r3JvDZuKG/
Cb1S6GAaSwEB7OKNN95wjmVntgulf/Xq1XYQ0YmpRUAzKmIs/MgUCJ/8tU5B
unf55ZeThN14443yNqav6qKtgrO9jtcp4ijomDvO2/aqnVygZ2UuCDmjRo0S
a8jGBRBjChgEQEjcy1ZtId2u4KI8+8NVbXnuuefs4KcT3+XLl8Nt0CqHHG7y
kUcega6gzVy7+VC5kM4Bnbw756y13Go+tn20G2spX9PJcuCgEkGu9h05J/1L
ly4tt0eEsaNL2ejHlMHh3XffdddaLP0tJfoHDx5cfp5Nk4K0Wkvp/+y1ESHg
x7Ez37wvkd//Deo672vLli3yLuox5oVUgtfzzz+Pfw2CqmzXWX9ZbD7aglgu
PXR0OBVxfDzqlIr4iy++aBqUQy/Um+7ZaaedRkf0/PPPJ9nHN2/btg0dePzx
xwnBqBDWjsOgk80Rw3n00Uf79+/PT4jhxBXpfEd4Onz4cBJP+RhPvQwJ6C88
2YGr2qRL3JF+2zFyyKNHSBtfGKXkqaeeSpXuteYT9JKDvPuNLycaLVq0SJ+e
LF/cvuUwrZosTRZM45greQFRWutEiFjLTGoJOEGy5ilTppAIc8QHIneCBHZF
WKGrSbgT3x7hCtFLLdspX8vV0YYrnq5chSWcGiSMZ5C04Wjz3gXUaTNcyRtG
lqK83kef6LPPPjvWJWmbhZiWGqGJwDl58mTUilCaqs103whSqdKmh2sINA/A
qSDPCy+8EE296aabhg4dihhWrFjBCck4CSff33fffYC4bNmyIUOG6JQ5VB/J
8yzp30U5g7zjjz8eO4hzFs+vjipxRlJGLoHNlPPFGiRuM16V+JNPPgmphGkM
TL6wdNk6wPbt2wlf8g5Lb4/UDW1N0Ian1h4EDYbktVvuNptVuSM4eL7gggsw
5XPPPffVV19Fsug3eoHqo8rAzbO54emnn8aFcImY8GV05vmtslfBHxkhoieY
VvEXl/0PDX/gjA1BBJjBX5jq1i59015B9X3Dhg1Yo8wXbUjK0suj/WSAiBTP
cIwHDdN6c4gGHV2F1/NGUa2ISJkMF0N6dN5555166qknnXQSUbpfv34DBw7U
fBc7Ofnkky+66CLEhsfq27cvwGE5Ni9XSAwglZy+9957J5xwArKKcxrHpafh
NMSFo3Ka1gtxYmNz3h/KoYAOkV2uWrUKExeTbfCO6r/55psIWN6k7OXCx2aG
pqomrhvRKT5S62nw9D0yY2T7HqYy0R29QjADBgzAxWOWuHtwATV44ul4qwcf
fJCAQUDGC0AG9IBdzsstRJx44ok4xipu43lxjxK3eGSyVjCSMfgGb1/FZ0M9
jCKSWAA5AZ6mYBF2c56+ro7u79q1C1HL+6BHe6xJn4M14b+VfvXiDVne0qvB
pprkIJO2sVoMCq/FA/W9Y9iDt5/85CcEWiDT+c7cRuOhIXk53r9//y9+8Quy
gSqO41bVvcSxWhW4EfNCjttlW3YsUnWB/idRh9QJ5yx+L+/pjykiu3fvBjF5
8/ooj32ZamgFYmgc9OfqZWEVM7xomHiAV0NIZ5xxRtCAKwya8XVkeSglgYm/
YVlwza3Z+T1w4AAeFfOs4jduYd1K/MKpDuAoXrkO2Vi5ZbUx+qmEWpwDLCTO
qq+6fueddxD2Rx99ZCtBbsS6RRDDA6Fxili+zoiZOQdttM0T+poP8YkoRXaG
NyNQrVmz5uyzzwYwGWUuZuISjTzllFPoAldxGcepaxJOSDPffpxsLcbMYS7Q
VyKpJ6cj9xc9S5wTH7lWaRKzEbCMD/R0oWRrE6YiUgzjFjJE8qINWeZdZYxc
YSWmjYYJWOQSBCbcBTzxTGSGS+TJeCEEmZ1L4jK9ScRTxWW8AtOlxCVP0Sfi
k0MuO2JNZoS8AP20tHbtWqxJOlDZZt7s27ePrqfMdO3hsSXzFOlrqveDfrWl
Yp1tyYz/t2jx66yzzkJaPIrnPP/88+SAXIKb6bJk4o+09vTTT0ckVfzFrahz
pRXBpXq7Yoe9neKDnyPzW7lyJY8QyH34aC3g/fffBx8Z7ezuwSekX30dR8Un
23zkGvERU8KK8Gz0R3F3eDlcOcpn7CwTZ3S6+aG8+BrnLI5MW4kzeqjKmSLT
2OFcz9RL8lCOweDl6JX6ZmRoJQBRQbjMk+3mQiVakSniZFBcRKVWD91Ndc7y
DN1N3I+M+vTpg+FwpCOLmBBccyauPv/8c4KUlFDjXMUzOTPLQ3wBfQy4ApFZ
s2aFXHUkk9O5RfRdsZXly5dfU5op4aZda1ZkodiJzFHv6rET84SChprQSLLN
Ba3BSsL5GBpr0C9ijemJd8rEz1dffUWfFtlW8ZNYHygoEHClfTDLT5ptdC5Z
oW3XydHChQvhO2iTQ37Lli30uOnuITdx0mmc6Dg7wZcgWX5iAjI3m0/QKocC
bdP9o+MIGNJ/7WSe4pspQ6r89ddfp/JBylt+CvcjpilTpiAv6Tdm44WUzs6P
ddYMLC+mvQL00y0mz8XQy7yU3y2pREU+HV/XTcj5N6ggvPnmm1hx0CaHHFrz
6quvymmruXbL2TnivcF8gh7m96TTW7dufeKJJ4KCuX7llVdStYN0li55qna8
8cYbIX35119/nZSOLjFU10pxPpHiZcuWQa5p3FyX1zWrQaYQJP2HNjnkXnrp
JVqS01ZznXA/bKTK9DrzCXqY3xNTSU6wM7Mgnal3pcoUC7KrTTllOmfOnJC+
PEaNBeLmcYROihGTjAs7ZWop7m5+r91eHKylGAdYu0yXLl0q2XKbmbVBDkA3
R05bzXUyT/Pnz/dWZrqb2o7O+IRhSDU1Fd+qfRmrBiGFeUQKEDwBV59Is9QC
dNmv3bt3O2sBUaplVhltmpUGzTWmcGTlKjR+8803ZMjEFmclpoJGtJMnyBqK
xX+NXO1Y/7p16whV8p6hc6zf0t2Ng77tC+32u3z75RvNYEW+eJcwM4vfXx4B
h1x9DdM31t/NZMZaeCIVQxmKdc5Yde4wgCNnjIoumod2vB2iJq74Ru8N7Tly
IS3+alWh3VlphZTRYqeUK8axIXbu3LnyTpVz1L6CWnIQq8+N9ZKzrS6qnEN9
dsm5gvoXXniB1IiQ6B6Ft9R3NW1deeWVaLbkUY316QFYjS6//+KOvzoKrW+D
y1v7znH36GhZHopVs6G73j1kne2NZqN/aDauKRsPGzduROoEbfdIenQsRmb4
kZBqUbQDfWFbK8+k41VyhWaUSuTuHD2v0JSy365bD7g2Pa+icPPmzUj9b3/7
m3s83HLQxbSn42yi6x3r7bZH5vkSxSiuvHvuHP+OUlz24tBd73GHjF686pr0
HanLqqDO0W3Lg3nHVAIluk7PCYf+/cu9UKKZUC0zNJwj2hWaUtb15n+51PWJ
L7/8MlKnt+QerY5KXdaEsbre/L379WKJYh4qc85849OdI34dmNCTeo/p1O7X
lQe0HKmjPd4x6LaSXx8xYgS6jl/3j+PUW9cbSzTzUJG7c9y5QlPoPfI80fVM
6zfVrOu1+HXlYNu2bUgdX+keX7YcqITILZG1DNB0qp9/ScvKI9c6/koMgrvP
P/8826iy9evQia4fGamHup5B6soD2QtSJyvINoYsfh1dx0ZDHtol91p78fa6
uUSzvgToHju2/TVtX3V92rRpQcsR6Xs+/PDDOq2KkJ2Ngx07dqC+5MDu0WLL
gbanK9Sbcc/290DRPbH3NjnICNyLL74op63m2k2xzm34+OOP7Wq/XVwyv9F8
tL38DTfcsHz5clL8qVOntpgn+ManUFzS0lSpo9jlJ9x+++3XX3+9rmKSjYdD
hw5xOxGqiod8Eg+5yZMnI2iZKaAcuMar5NPxUVoh5N9gHNhe//+wjg/+e8WK
FUFQuSKL+ImucigCOkqG68BxP/3005MmTSrK9/GnFtWf6avajzzyCG0YeRef
e+45/ELm75vC759//vlFixbt3LlTKQ7tZZr5BN3lkIc6Iix2JmOVhi6fheGe
uE/qGrKwtKnc6AoX8X1UuJYGW02r3DV37tyhQ4cGbUnci3pNmDABMx81ahQ3
XnjhhdgNMQJWdFn0gQMHLliwAOnNmzdvwIAB3Dx69GguV61axXH8+PEQMWzY
MF1OAIHzQwL7vn37lJlijPvehopyfcm1Gg2IERtjbdh4b/q28sLIo48+Om7c
OH2JhI5iMSlmCr4EPJ64cOFCZPjFF1+YhxWeeuopnBben2gk6xTqt6hU9Fb9
Nq/34sFxpM6VbGykNe/dyVoSpJQ6ZbyQKVtAdjprwr6RpnsQzJ8/3/4qut5N
OcuBc54DSDYLinEvqw6BTt++fXWHCBjhUtfIBU2YhMQxY8aAI1EKzjny4HPO
OYe/gvjKlSvPO+88MEVDkED//v3RExlnc64dYqXgn0eoOOvUzjScsQsIAecl
S5bo0jGJOLcFZkYJBBMl9u7d+8knnxw4cIBMgBNCB/EdnKXaYaTfKeU+vnSu
kBPFWOZwoXVmV5EaEdbxI11nXN45c0qzFqxlbSPSKjg444wzeNAFF1xAp0I3
ALr44ouRI8ari1RBs74Xw5c0peZDuo9p6x4ir732Gl8iLufaI5lx1rWNdP5W
CHUZa5tLdjGzUBDLY489NnbsWBSThtHTxqSMrDW8Rp9nz56NlJDimjVrUGCc
FdSQ1pt+SZPrhuTRqaCifhDIK31IXKerZ6t8lDEuljBG2IMGDXKv4hLNRmUl
hhLGSZyXV9uBpdNPP/0qsxgoTAIqnXG1aoDEaIlN6AF2gyxRAuSKVUMTqoCK
QBH3yPyc5BGjsiR6GzrSENbxU7wCdrp+/frU1XbCPqyYALkfSSFaGZp20Jik
2S3hNR8iA5b77rvvHjx4EEYgTPy0rnSa/Dcn1laHjZ8RrHVGI59sVYEy1roG
HEqiWK9duzZtzZ7MFl2xfwg5xWmnncaDwA275oheAiYMIzs4JxDTEgpKLMZy
EC6XQIJSYAI4dvHbTrQz2/NRJbTJM0h13C1G0RZjIFrjX/gV59DX5OnhmicX
nnnmGXwUUdquZ2LeDCmsW7cO4YMwGb6MmjhXXKpAWN8PQmooWq0I50sIX3bZ
ZYMHD4YAJ9+1IBzntydCO/XUU3kYxkqKpSsG4pDRKr7kHEcN9KQiuHdahCFy
NijClJ1ro2TGVkeH6ciBEh1M94oedpRR34LEbPAxZINqxjzF97aleWSP1atX
k8nu2bNn//79BN133nmHMPz+++9Xn3/wwQcEaWIIz5F1lpz7h0SrTrnQnO3b
n76xyTLauRLaWM2QIUM2bNjgW9ukteTtQRsX7J2drqsE4aMVbRw0hgukGqux
Vxwj5o7X5k/ACy+7du1CgyUmumix3PtXEOhZwplQsWnTptT9JMIRMJtxkwBi
iwgKSnxvOprrbrhD9FVnKREfYI5gzJMV/+j3NGxXbHOu+mR1uUvJonWNBQSf
rdZSxrihEmPU3SmFdlq0ue66fPnyPn36XGN2HMKiIRYXcu6556KNKArGi0PC
L0KCunfnii2ZrVjHvZEi1rJly5bUtYXK6N52222oDOnf4sWLtd/iQ9dIuAv9
XlDESD/88EOARG95Mn+p/l7qls71oaK4yhopCEmyk0y1nKYQVT66FixGhGKn
7RrSHkR1RaInnnjilFNOQUBnnnkmnYqLLroICDkibsRHzx5c9b1j5wovmbHU
0fSvv/6aSCfr2zq1w9aVwzXisVRUDcHLWzC+XSV0HrNOsKfHSYqsb91s3ryZ
jFkXvZbVhJyrRll+OkesEj8R6pAHv8YQPwVv6NChUklw8hqtQdeAnq5dRKZ0
8skncyvoYY86mkGQwEuFewfWa3cJYhU3SQXQt7uEiR9ig7pel9rgNf73l7WX
Q4CaPn3622+/Tbh88803d+7cSVQlgDbgUKMrdPn27NGVbTRbNLuDZImbRUUP
HNB+oNu6dWvaykbtiZa6shHxArtDKPRrEBMmDlrASTt0m+q1zwT5JDfRAc64
zwSPfvzxx0GLQKarFmaa1dBMwAEzchpkgqtC6IQ+LsMsN8XO2kp2dscdd6DA
orFZ7Ex29+Be9H3YsGGilU4O22lhuvIRnv+kk07iQX379iV/J3UlAOIW67Xj
BJ173K6skOvEPIqQrNAO4yTOdKFkReBMu2YUN27cCD5vvfUWWShmhCd1roAU
RUXqDFiPvHqYbQcQRKsbwaFymXYAqQEP5QS/rniQgeiosXMVJMuJPodf2OuW
jMhApq29pa3mVH5LGaVHQXRVQudbyvba6GoePBDowoULsTnnDAf73rI+Y+rU
qUhr3Lhx4iNK716nIWKzD5lv5NRY4mH5XXD625iu7IfZlomHHTt2kOmPHTuW
lN85syHKg0wNt9fKgWv8XD7/mlpWbbMm/lPLqqxlEbblNfegck8EM6nFzGHB
aukJypymnkkzZ36kHu+jjz7iihO6V3SXOScp5Eft+J5kCAJwgUppaCd2vs2x
hgr3mjz6dvaSJUvkvihXWL98dZyLC1IN3C1X5NKYrFJFUCSZbMf3RDF8C35V
ySzGuOhtqEhb201rFERKmpc3RarX5DfziWVw6K677oI5fEwP12rvxCDcxooV
K3BgpGdaTaRPBPLEF7qJuCm6S/o9fSgiTtX9hfB+woy8B+/b//xYz/q6uq8C
np3MX0bSqtftP87FDz3WMWPGcBe5z7vvvqv1M1oaP348qRCJYLjXfJGchohd
dXde76brhLN11kAq1tRNy98ULR4EIzHEo+u8yxw58iZprntS3imVJEhHzAQC
TvgOqWubX3zxBbLn17KSnY5NKyKuW+U9NGc1yWamvvUqdX8FsnhCmfatK2zK
5tTHJfHSxDWyRc79+/enZ/CdWbceVW6QYTSJI4QtWVNT1+5JuU8XTc+424h/
rwvCNwKyjTiRQtBwJ9vsJCJl60CIHNPDROnzzpkzZ+XKlTyfc7Qe1kzLzSn3
uOsDGfHR+gdPIBFI3S0+DalyTQsPPHLkSJwYaSEOmXP0iIQdHLW357rBOSKd
GRudf1DeRThtH3hJCc0oung/ZIskOemWlJGW6zcoMUJQY/n000/1jTfJtLTn
4Pqzr4JzrCfT1poF2KBK+CZ3hcrm2celc8EHz4yl0NHGTHDseDtZ1UGrUMl/
63jlRfWsvAtwWp0tfI8gp1vGig0l7jbQKcoVfprUGg/KE4iL+/fv13rL4sWL
77nnHnQNI5DVETq6w4XWGXAtdDFk2+m0WorTYiLXGhtRF6wA6dMllhWGlHbw
ptOnbzrI+ij12rmivHtvWgUsxEH27VErIfB0zVQfIQOjq0KkQXFxlocPH0Zi
+OTqc6IC52ousuO0rz7iw0frA8QxdFJWB/NVP3z4mOe3ESZ14VD4AYmDBw+C
EjYSOw8aZEGvPE/HeACUP9RrF4vyLr3ZdrHAEwGC2E6mfQS68WOEqtvHPfnk
k4DNz3VjRUJZ9HvOcVfCrW9/C18Gp6P9wM99PM27Q0JiPlfFCTeT3yHRSZMm
EQ/wYZBLAodKDxw4MPo93oIIJJDVa5/z8p68mfY5l3m/WBaCp/1Mewp0wXZn
zpyJZWE7pNn8NOz/xL6Xda98o6ZZ9koIcsQzXACEu+WU0ZqUB+yyX79+GmXw
8Xi3Q4cO8Zfq7+XttnrtWV7ehTfTnuUyu0KNiNwo094CBUIPHUvsg1BYfi+P
fFHHfXQf6g7vX6Hj87RPB5GI6t2L3IeJ0k6c1FcwJk6caBJn8y3tDx8+HNdM
r1Tee6/XPhWQZlcuzrTnuLUTqJN9Kjwjh7oPNxZ+yy23kERDtr4ox4nahl0l
07ffuC8z0zF3NFe3QPbuiZCYmVXRDdtqAxidvkqwb98+XKSuniM9+XpVePCT
q1atklMn5dF9EGTskWuJKJl2EWhG74mC6D1pDQ/SDhEuF4l5dw7Ptg8C1nTF
FVcQFr37IPhsQCnGfunQ62ZOxL2LL74YLzR27FgZXahXjYZMwm64mlajCaUu
c3fQfMSWYfcJzeGhHM0nEqDk5XdHfTtPaNs6nl3G3I2Ajv4SYy6//HLZo923
g3a8fd+MOOWFNBVr2L59O5aLMwYL6aXWax8KfN6mTZvkNFv1AgtARWQ2jK96
oTs4rF27FvcBnLY25qvChLULjLd87VvRSHec9O39XdG+rqOZjYs86koqSxaH
n3OO+VdwoAvvlasv/h2/sWG7E7uThxdeeEHWjm2Vg+wp8fTTT0uJuM1cu3lQ
ZAn8dhzUWXlZYD62fXpeeK3yNTaVigGaYX1p2o7l5fZwS7hHo0mZ6MfCyFrl
PQYnApb+lhL948ePLz/PJj4hAv/Z7/vfu7bi5B4g8YNBLzkUCKk6Z0VS8yAy
EmlXOHPKYLb5BMeYVm666SZ0ffr06d+laXiGuYk4a2mwVQ5SS6bHiL+3O43h
dUjiZJ26CJ22vuGUlaUz5FbnmH7n8iVOqZHESwfuaLOyKp5PYxJGLV6wcv6R
rAzolJvtDfYy7Vx33XUIjQTE7iblkhzdMt9uJZirNNlqepm4TJ2WHnQqrQ0F
RHIaofSnP/3prFmz3JKLUiqTeOjD2E1yapOcHVM4Sg6N5H5ITit68C24lmjK
c7Jx40byhYTVo+LyMzg06v4ApFow4t5rqda1e1WGkEYMlTcZVPumTZumm6NF
6V2zZg3pHn9yrnYVpVf0hv9nzJgRbo5Y+9oGZm3/JuIjabGujYgcrzUbT5Uo
s+tFHTx4EGHu2rXLvfeFzXbMfuVNUEd2hH3pZn5h4laXtQxEJ5GnWLP0jRvk
BSuZ7xHVAEs3MYp+pPQSnOtcRekWnaJxJALR7V2BWhoyK7vLts80hbljMdgd
J/LSQeLeCeX1ouiQkKYlrBcVl7RBrxm+dVu6kSNH8jy+q9+eCVFpi/aa8dci
4oYf1b+IppQ54DN48GD0yLnileXA7Pwgb1/hDzi99NJLO74PgplRJkUvaCSj
Rv5IHv02S5glZZgVK0iR2BPDklaQimfHZq+NAvoyYcIElPySSy6RIni9d0GI
5uCi71rNUwSw1Yx7HZAwI2Q59e11YLjK665tdKVwCh3Y5cDagqmWNEFAiAjy
gj+4oO3EvTWqOKDPCC6yJ7hvnSxjeXaNX8UFHym7NXh6kB21DTNLLa/IIDkg
83GmlGO2/EhOffsa6D4O6lM48hDdjKVjNiM/7lpCCLwBjfbxJ/Cp0SDb/gz6
LqGsApZpPwp5lzC0HJmGXe+9DeKRohDBhyifgS+9HjVqFLfLqW8/g+6l2E6y
hOQ46fhOBmb1/SYaBBldqIaYSn4G+LBWyFKBkB3BQUZWCnOuu2UzC903gRg1
ceJE3dcLYembOSl1k47mRMZOJCtUoenE6cDHm1JBkjF58mQ59e1jYHgTdHgk
0kOS+oS0vaV96HQuoYMCg47uyRCik20nhi+//BI5yIpimfabKOj2wrrRlKBT
PCLolP1aQyI6Pt60Z4Aa4YXl1LmCVJS3PPxgqtgo+UCx/ehEV+5q0oXAli5d
Cjo61VGtP9s+DDrvQNZKybTPhHg19LGMzhFZo7E59GpXmy2TK5Dx8aXVpilT
powZM0ZOfbsYmNH1gsaGX5qP7I7YsT0MQnQagWbZsmVIje70Aw88oNBk3GNC
5/LIe2GZ9pgo6JQYxUYWz8g2l7FGbJpCbKLA8GgfT1p5wnNAnZw616GyPLWV
cMH36DqmgktThyNOa6k3vGDBAlq888476akjN0kDmz1WrzzofDmZd+RcD8xa
fZvxaCAO7mgCnJtVB4+ER2sM4w2g8BSsNAtHWosCzREjRsipc50qy5F5VkEj
Ag/ihzKm09x+X2bHilRSzz77LHZy//33Wzw6eajXms68efO2bNkip841qyqo
v9psFol8R48ebVbGM0/x7Rta47iSLPSBluhGe7AjM28ycYM8wULqLs7Vq6Lc
5OFDd9/mh/qEtH1CdTwbf+9bI96OfLbJIb969WpNmwn/LWa80cfFt99+O2fO
HJmH6MTEjjaa8cs82Rh9WLjALPQJBLKO2kd0hLRAXol9ECF1uafAx4dWAq42
63qUJZdwv+XDtJcn3ycOc0SP9QkYaQUa/6v2o7ZVIq2qrF27tqLq4patc8TX
VlV6xKpOhUxVIX1NKlUj4lUh/kex3VUhx8h+vArUO7Hqk0mCdhxEa4OIUzfA
ds88Q6dldrRTgnaco0ekgornCgqZapsorN0TJnNtE5uSZcWctU2SRJlZ7pRg
xVsUaZXLuqxjK+PQ+oLQoUOHnOPmFf1dXc2TjAPfWjgifXikSJMIMnl2q9A8
f/58UggMzDl2bmn21+J9o1mZ5GhHn3ft2oUo5Y0+36i5vpWv77RIHle33eni
o1VpkrRU7969m4hJTPOOmXdAmu3bByLc9DTbPhBke+imvq1yRPaBEN2kSdlH
MdHCy5Tv2bMHoa5atcq3C4T/fam6WHrFqHd5Z1LfXs365nv4IuKR6d/6LL6C
9r1795JoP/XUU96dl+uorRnXpNax6/KOor69lcPVlVRrofeI7Koh857TtLaK
g/feew83L/tW+eoH35P2VsmwvB+ob/Q53IOChFeV+IiMA/h0uIpCGkfG8vag
rw7QMT1uj4z1urynp2//YpWxztPQt8n/1TLWa/SDkCBvx/rG8r+nPCFyXShp
ATKWeVzO0eCojCNzkuq2a0AtGUMV/Xg5YJf3wJ3j8XWRcDgmYiVcHrl2U6gj
uvv374cjmanpHNG14wem9pLTqUby/ssRGZeKSjgT/QcOHEBy0ivzjan3rs8I
eg063FjSAYQk83ozjctG5qZmWiXnCHoJpZ/0ElBkBpBvbPz798Q6wkqmBkcy
K9w5wlohYXRYNw49QhLO7iWUfjrRpCAyH843yl0vL7FmzRpytixeQkd86bOR
IdHdcO+tUDHKeLVZtwDDlrVRjpSfgKIsfkI5OHz4MLTInNBMY9Y57A8nJ6dK
v38PXl31IpUDu/aG2YM3t2nTpvXr14d72aZwoGOLJME46/LzEjCI7sCbmzFj
hs5Jt9e+EWv8js6cd9NvV9nQ9mbOnDl37lyZ9dyWiX7at/OLfbvuhu0DV7gL
r3M9DfnUYeWYH/wPqngTIg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->12426252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->676739662],

Cell["Show a collection of discrete mappings:", "ExampleText",
 CellID->552757752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"GraphPlot", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"i", "\[Rule]", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", "^", "p"}], ",", "m"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "m"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m", ",", "30", ",", "33"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", "2", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2014500830],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxdVnlcjVkfT4w26d7nLkrdShKhxW1B4ZwaLYQsRaUMWSJJaCJp0SZatImS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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
             45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 1}, {2, 3}, {3, 6}, {4, 
             5}, {5, 13}, {6, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 
             67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 6}, {7, 8}, {8, 78, 
             79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
             95, 96, 97, 98, 99, 100, 8}, {9, 101, 102, 103, 104, 105, 106, 
             107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 
             120, 121, 122, 123, 9}, {10, 11}, {11, 1}, {12, 3}, {13, 124, 
             125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 
             138, 139, 140, 141, 142, 143, 144, 145, 146, 13}, {14, 147, 148, 
             149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
             162, 163, 164, 165, 166, 167, 168, 169, 14}, {15, 1}, {16, 17}, {
             17, 9}, {18, 11}, {19, 6}, {20, 170, 171, 172, 173, 174, 175, 
             176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 
             189, 190, 191, 192, 20}, {21, 11}, {22, 17}, {23, 14}, {24, 3}, {
             25, 11}, {26, 6}, {27, 5}, {28, 3}, {29, 1}, {30, 31}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.4683690290139373`, -1.5597020013002099`}, {
          1.809228322153224, -3.656528124662311}, {
          2.2748507756308642`, -4.463009871341953}, {
          4.280817605737085, -3.656528124557788}, {
          5.14684300948411, -4.15652812462259}, {
          1.468369028930318, -4.9286323247833845`}, {
          1.9123609615271924`, -7.400695287678174}, {
          0.9123609615271924, -7.400695287588381}, {
          4.530817605737085, -0.9123609615271924}, {
          1.809228322008391, -2.8318062014824967`}, {
          2.2748507756308642`, -2.025324454886475}, {
          2.7404732290360876`, -5.2694916180634035`}, {
          5.14684300934942, -5.15652812462259}, {
          3.804104086491532, -7.400695287588381}, {
          1.3436058686755836`, -0.4123609615271926}, {
          5.39684300934942, -2.412360961591995}, {
          5.39684300948411, -1.412360961591995}, {
          2.7404732290360876`, -2.831806201607926}, {
          0.41236096152719237`, -4.463009871174713}, {
          5.695847211455871, -7.400695287588381}, {
          3.2060956826827, -2.025324455053714}, {
          6.262868413365824, -0.912360961760482}, {
          2.804104086491532, -7.400695287498588}, {
          3.2060956826827, -4.4630098715091915`}, {
          2.7404732293257545`, -1.2188427083322628`}, {
          1.3436058683859173`, -6.075973364533996}, {
          6.012868413365824, -3.6565281247910772`}, {
          2.7404732293257545`, -3.65652812478774}, {
          0.41236096152719237`, -2.025324454719236}, {
          8.08759033642021, -0.41236096161698554`}, {
          7.0875903364202095`, -0.41236096152719237`}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {194.4, -194.4}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.00000000000006`}], 
     InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxFWXlcjdkbv0Va7u2Wbt3urbTaG/taqvtWlEYxsoRso2zJ2EpECGUnoykZ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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
             45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 1}, {2, 55, 56, 57, 58, 
             59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 3}, {3, 71, 72, 
             73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 2}, {4, 
             87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
             102, 5}, {5, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
             113, 114, 115, 116, 117, 118, 4}, {6, 119, 120, 121, 122, 123, 
             124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
             137, 138, 139, 140, 141, 6}, {7, 142, 143, 144, 145, 146, 147, 
             148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 
             161, 162, 163, 164, 7}, {8, 165, 166, 167, 168, 169, 170, 171, 
             172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 
             185, 186, 187, 8}, {9, 188, 189, 190, 191, 192, 193, 194, 195, 
             196, 197, 198, 199, 200, 201, 202, 203, 10}, {10, 204, 205, 206, 
             207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 
             9}, {11, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 
             231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 
             11}, {12, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 
             254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 
             12}, {13, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 
             277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 
             13}, {14, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 
             300, 301, 302, 303, 304, 15}, {15, 305, 306, 307, 308, 309, 310, 
             311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 14}, {16, 321, 
             322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 
             335, 336, 337, 338, 339, 340, 341, 342, 343, 16}, {17, 344, 345, 
             346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 
             359, 360, 361, 362, 363, 364, 365, 366, 17}, {18, 367, 368, 369, 
             370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 
             383, 384, 385, 386, 387, 388, 389, 18}, {19, 390, 391, 392, 393, 
             394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 
             20}, {20, 406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 
             417, 418, 419, 420, 421, 19}, {21, 422, 423, 424, 425, 426, 427, 
             428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 
             441, 442, 443, 444, 21}, {22, 445, 446, 447, 448, 449, 450, 451, 
             452, 453, 454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 
             465, 466, 467, 22}, {23, 468, 469, 470, 471, 472, 473, 474, 475, 
             476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 
             489, 490, 23}, {24, 491, 492, 493, 494, 495, 496, 497, 498, 499, 
             500, 501, 502, 503, 504, 505, 506, 25}, {25, 507, 508, 509, 510, 
             511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 
             24}, {26, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 
             534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 
             26}, {27, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 
             557, 558, 559, 560, 561, 562, 563, 564, 565, 566, 567, 568, 
             27}, {28, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 
             580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 
             28}, {29, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 
             603, 604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 
             29}, {30, 31}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          0.7135516666699403, -0.7135516666699403}, {
          6.921965000029464, -0.2135516667597335}, {
          5.921965000029464, -0.21355166666994033`}, {
          4.067758333349702, -6.421965000074359}, {
          3.067758333349702, -6.421964999984566}, {
          3.5677583333497016`, -3.5677583333497016`}, {
          0.7135516666699403, -4.994861666689582}, {
          2.140655000009821, -4.994861666689582}, {
          6.921965000029464, -3.781310000109435}, {
          5.921965000029464, -3.781310000019642}, {
          3.5677583333497016`, -4.994861666689582}, {
          4.994861666689582, -0.7135516666699403}, {
          4.994861666689582, -2.140655000009821}, {
          6.921965000029464, -1.9974308334345843`}, {
          5.921965000029464, -1.997430833344791}, {
          4.994861666689582, -3.5677583333497016`}, {
          4.994861666689582, -4.994861666689582}, {
          0.7135516666699403, -6.421965000029463}, {
          6.921965000029464, -5.565189166784286}, {
          5.921965000029464, -5.565189166694493}, {
          0.7135516666699403, -2.140655000009821}, {
          2.140655000009821, -0.7135516666699403}, {
          2.140655000009821, -2.140655000009821}, {
          2.6406550000098212`, -6.421965000074359}, {
          1.6406550000098212`, -6.421964999984566}, {
          0.7135516666699403, -3.5677583333497016`}, {
          2.140655000009821, -3.5677583333497016`}, {
          3.5677583333497016`, -0.7135516666699403}, {
          3.5677583333497016`, -2.140655000009821}, {
          5.494861666689583, -6.421965000074359}, {
          4.494861666689583, -6.421964999984566}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {583.2, -194.4}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.00000000000006`}], 
     InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxdlnk8Vesax6Vhsw3bvNfmmMlYIiRHva+h4biKNKBMOTRIg0imhJA0GOIg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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
             45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 1}, {2, 3}, {3, 55, 56, 
             57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
             73, 74, 75, 76, 77, 3}, {4, 5}, {5, 78, 79, 80, 81, 82, 83, 84, 
             85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
             5}, {6, 3}, {7, 8}, {8, 101, 102, 103, 104, 105, 106, 107, 108, 
             109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
             122, 123, 8}, {9, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
             133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 
             146, 9}, {10, 1}, {11, 3}, {12, 5}, {13, 147, 148, 149, 150, 151,
              152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
              165, 166, 167, 168, 169, 13}, {14, 1}, {15, 9}, {16, 1}, {17, 
             3}, {18, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 
             181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
             18}, {19, 1}, {20, 9}, {21, 1}, {22, 13}, {23, 3}, {24, 1}, {25, 
             9}, {26, 3}, {27, 5}, {28, 3}, {29, 1}, {30, 31}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.321277771539907, -1.2473187273041018`}, {
          0.8873940324743567, -2.9400184460573753`}, {
          1.321277771539907, -3.84098731398484}, {
          2.9889054025163935`, -2.940018446057376}, {
          3.854930806263418, -3.4400184461221786`}, {
          0.3463498593766371, -3.618466379947237}, {
          1.846349859376637, -6.033687032827908}, {
          0.846349859376637, -6.033687032738115}, {
          3.854930806263418, -0.8463498594414396}, {
          0.8873940324743567, -0.346349859376637}, {
          0.5394462890038956, -4.464477115758327}, {
          3.8549308061287286`, -4.4400184461221786`}, {
          3.880002894137522, -6.033687032738115}, {
          0.3463498593766371, -1.0247977932664987`}, {
          2.9889054025163935`, -0.346349859376637}, {
          0.5394462890038956, -1.8708085290775889`}, {
          1.3212777714052182`, -4.84098731398484}, {
          5.913655928898407, -0.8463498593766371}, {
          1.3212777714052182`, -2.2473187273041018`}, {
          3.8549308061287286`, -1.8463498594414398`}, {
          2.1031092539079634`, -1.870808529288198}, {
          2.880002894137522, -6.033687032648322}, {
          2.1031092539079634`, -4.464477115968936}, {
          2.2962056837631195`, -1.024797793529123}, {
          4.720956210145133, -0.34634985960992637`}, {
          2.2962056837631195`, -3.6184663802098616`}, {
          4.720956210145133, -2.9400184462906656`}, {
          1.75516151084816, -2.9400184461742547`}, {
          1.75516151084816, -0.3463498594935164}, {
          6.413655928898407, -4.286368305478909}, {
          5.413655928898407, -4.286368305389116}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {972., -194.4}, 
      ImageScaled[{0.5, 0.5}], {360., 360.00000000000006`}], InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxN2nl81dWZx/GEiBRIQEhCSVJKoKJgBQIVZbOJItaiuLQiLrTQYSloAQMI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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 
             45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 1}, {2, 55, 56, 57, 58, 
             59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
             75, 76, 77, 2}, {3, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
             89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 3}, {4, 101, 
             102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
             115, 116, 117, 118, 119, 120, 121, 122, 123, 4}, {5, 124, 125, 
             126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 
             139, 140, 141, 142, 143, 144, 145, 146, 5}, {6, 147, 148, 149, 
             150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
             163, 164, 165, 166, 167, 168, 169, 6}, {7, 170, 171, 172, 173, 
             174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
             187, 188, 189, 190, 191, 192, 7}, {8, 193, 194, 195, 196, 197, 
             198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 
             211, 212, 213, 214, 215, 8}, {9, 216, 217, 218, 219, 220, 221, 
             222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
             235, 236, 237, 238, 9}, {10, 239, 240, 241, 242, 243, 244, 245, 
             246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
             259, 260, 261, 10}, {11, 262, 263, 264, 265, 266, 267, 268, 269, 
             270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 
             283, 284, 11}, {12, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
             294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 
             307, 12}, {13, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 
             318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 
             13}, {14, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 
             342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 
             14}, {15, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 
             365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 
             15}, {16, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 
             388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 
             16}, {17, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 
             411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 
             17}, {18, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 
             434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444, 445, 
             18}, {19, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 
             457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 
             19}, {20, 469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 
             480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 
             20}, {21, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 
             503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 
             21}, {22, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 
             526, 527, 528, 529, 530, 531, 532, 533, 534, 535, 536, 537, 
             22}, {23, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 
             549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 
             23}, {24, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 
             572, 573, 574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 
             24}, {25, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 
             595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 
             25}, {26, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 
             618, 619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 
             26}, {27, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639, 640, 
             641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 
             27}, {28, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 
             664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 
             28}, {29, 676, 677, 678, 679, 680, 681, 682, 683, 684, 685, 686, 
             687, 688, 689, 690, 691, 692, 693, 694, 695, 696, 697, 698, 
             29}, {30, 31}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          0.7458433333337074, -0.7458433333337074}, {
          0.7458433333337074, -2.2375300000011222`}, {
          2.2375300000011222`, -0.7458433333337074}, {
          2.2375300000011222`, -2.2375300000011222`}, {
          0.7458433333337074, -3.7292166666685373`}, {
          2.2375300000011222`, -3.7292166666685373`}, {
          3.7292166666685373`, -0.7458433333337074}, {
          3.7292166666685373`, -2.2375300000011222`}, {
          3.7292166666685373`, -3.7292166666685373`}, {
          0.7458433333337074, -5.220903333335952}, {
          2.2375300000011222`, -5.220903333335952}, {
          3.7292166666685373`, -5.220903333335952}, {
          5.220903333335952, -0.7458433333337074}, {
          5.220903333335952, -2.2375300000011222`}, {
          5.220903333335952, -3.7292166666685373`}, {
          5.220903333335952, -5.220903333335952}, {
          0.7458433333337074, -6.712590000003367}, {
          2.2375300000011222`, -6.712590000003367}, {
          3.7292166666685373`, -6.712590000003367}, {
          5.220903333335952, -6.712590000003367}, {
          6.712590000003367, -0.7458433333337074}, {
          6.712590000003367, -2.2375300000011222`}, {
          6.712590000003367, -3.7292166666685373`}, {
          6.712590000003367, -5.220903333335952}, {
          6.712590000003367, -6.712590000003367}, {
          0.7458433333337074, -8.204276666670783}, {
          2.2375300000011222`, -8.204276666670783}, {
          3.7292166666685373`, -8.204276666670783}, {
          5.220903333335952, -8.204276666670783}, {
          7.212590000003367, -8.20427666671568}, {
          6.212590000003367, -8.204276666625887}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {1360.8000000000002`, -194.4}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.00000000000006`}]}, {
     InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxNU3tMU2cUb5FV0D4utPfeyhS1whSVyAyIQ7Rn4AvxkUCDDwpFiorWQTRz
KFUomzI1oFMEp9sUVBQlODSCzjh7BEmHAbcqYcWOKpGHEguk004t0LHvqtkf
N19+3zn3nN8j3+TUzLgNHjweb/XI99/5Qn3ZqXXTQCVNOFa6UoILIi9XpC7i
w6ZgbxfPQWPvigO7a9P5YG6+t/KCxQcDmvb9tKdvHExrmmQSRnvi7LaX+/Vu
BrJjpojTQoeMlecf7wzUOZQa+4zufpMPcvMZ+EP4XYhfMP0O+0J33qH/YT84
pygiOIQS7OiZ7lCqpvG++GGLwxh26WJhmd6hlEhl9afS+RgWtt/+NsCh1K6Z
0Le6g0aePuT50CAD+TV7FEHLHEb/aTFzCmL48PVpr9KeqQ5j6MOG5maagupV
TQ1Xmq1G+1br4DYPKTjT48//HuMwXrO3rlpGUdA/9+UsA3hijKSjYzxPCjMP
X9mqCRkyqj9yOfYKR4N5c547r1qAyltl9/238yGnYKK8ZjEfB8z5z8c2WpVW
73ZNU4kcDdqGwtarAnh3b3xfN2RlPFmrthljl8b/c6133Ie6cFVro9cVAcxN
SzEUGOX44yZ1Y0C1TeknO9WZ7DkaLb+o7aZhEbicBcSfgaQA3iilTVnym9tW
5hSh5lHe5lH80aDI2RF+dqH4nZ8+ELnEj+T53n8Ppy/beVX+wX+5zofglpgw
xZcj+Yd/tre3eLEE68SZJyxjGFhuUlRor4txsnV556MgBpIWbO+PCxWjiuUv
Gl7LQNpLq6THJELH992fbzzOwLZvyjUPskWo6HP2BbYzoJxMV0THizC78ZpP
eSALzM+qkE0qEfL51z2kOhb2+HqXBOaI0D2njbZdYMF5I6cqsFmEup1TXwX+
yYJV1RPlM0+MxVEJdRNfsRDW1zqXNb7Xx8LrHn+iL2IsV+8yb+wPsknwEzH3
f55/pYP9lMKEMxYyf3CJ5ldROoVPVtSS/aoX4xoLD1MIAo5f9rO/XVvPUZg1
neOvz5Li8Ag+0NlF9JVQsWnhRygsN/CIfqyYJazaQmFUBufPmeS08VmhFGa2
ZBD/cj3lhvYuCd5czPnLz6udX5kgwdt3htr7ihnY6HXrq6wlNFZvqOs8uouB
i23FIq+VNLrqOw7zkhioiThaciKexqnPclsAGHh88G7c9DU0xlYN1qinMJBp
qnt4I5HGnLWTopMEDLTo5IPRyTTWli8sin1OAztw2n1PQ+MbWl8f0kTDwcY6
7YoUGtfv7gg6PlsGRTM47GVn1+2mZXB5HtefERF5actrKbhLWTLv+DNNuM4q
hcjuO2Tfruq/5N/elkJqUT3hM9OSnWQqk4Iw+AjhWxdx0its38j7qjlG9Nx9
mixpS5fCg/s3id6PX3M4Lj+195YvjUEqrl9csz9+ppBG2ytunoeq4N5JAY1X
zdw+y6h14jEeNB4SphA+S02JhfphGSamcHyfKgQbBlwynCKTEz2lp3LWb34r
wydnOb3BDYlD3W9kuHM+50eAVk2wuYnzyzs+l/Trcjk/b9i5eVFmzm99hZrs
S/E2kDwSXByfqg4ur8r1hYQvm8vlecdygOihW7m8u4xaovdfoXeCcg==
         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
             46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 1}, {2, 3}, {3, 6}, {4, 
             5}, {5, 13}, {6, 12}, {7, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
              66, 67, 68, 69, 70, 71, 8}, {8, 72, 73, 74, 75, 76, 77, 78, 79, 
             80, 81, 82, 83, 84, 85, 86, 87, 7}, {9, 7}, {10, 11}, {11, 20}, {
             12, 2}, {13, 18}, {14, 10}, {15, 16}, {16, 5}, {17, 18}, {18, 
             16}, {19, 20}, {20, 14}, {21, 12}, {22, 14}, {23, 10}, {24, 
             13}, {25, 2}, {26, 11}, {27, 8}, {28, 6}, {29, 3}, {30, 1}, {31, 
             32}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          5.4994047683642115`, -3.9133922168217694`}, {
          2.158879583184471, -5.486331865725652}, {
          2.1761293153192485`, -4.461575728538677}, {
          6.482901059428546, -2.532739215553665}, {
          5.749494686073648, -1.8252907325991985`}, {
          1.151158783114094, -4.44525107997046}, {
          5.7494047683642115`, -5.29404521826946}, {
          4.7494047683642115`, -5.294045218179667}, {
          6.7494047683642115`, -5.294045218449046}, {
          1.1354746409642864`, -1.151027131827978}, {
          1.1551833661748223`, -2.176084064531444}, {
          1.1340283659549872`, -5.4700619893465925`}, {
          5.747062343200696, -1.1431056353861506`}, {
          2.1609119645190864`, -1.1347423793140199`}, {
          4.021292891692429, -0.4344295913335783}, {
          4.752387953655881, -1.143020295820461}, {
          4.015908477299877, -2.5314944979100953`}, {
          4.750110177384905, -1.8243097539752382`}, {
          2.8811129553657064`, -2.836185451638109}, {
          2.180722822485705, -2.1595250973346642`}, {
          0.43414590649925255`, -6.147264001718635}, {
          2.8373232913840525`, -0.43414590649925255`}, {
          0.43414590649925255`, -0.4743866626466726}, {
          6.479205955942301, -0.43414590649925255`}, {
          2.836442543842969, -6.187059408076543}, {
          0.4795009581008516, -2.877134119104551}, {
          3.7494047683642115`, -5.294045218089873}, {
          0.4725959302317895, -3.745425932103056}, {
          2.875494789386081, -3.783514436028569}, {
          4.4994047683642115`, -3.9133922167319763`}, {
          5.7494047683642115`, -6.1746982198069436`}, {
          4.7494047683642115`, -6.1746982197171505`}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {194.4, -583.2}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.00000000000006`}], 
     InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxN039Qk2UcAHBwMbl3OB17N9gg1AoQJE/GIb+E93vn4SUiKQoJhAgbnCwL
CrCBgRh2bU4jECqkG8XhouI33MhT7n0O7OAiFFxKHLqFLFAhHMEEUbJ64On6
473nvvc8z/fH5553c1pWbPoaOzu7mH++f9fH/KOG/K0iqNtSc83uzgzbHhye
4jDCgSK3emV8gATxhO0XpYU2piXW2NMbIkGvHYjQ2P9wl+lYSDjSuY2LxquS
DG9n2RhH1HMtf4CDLDtre5/1c+BRy4Q4V0+jlfwCODhUjvOTOLLrp7QDPXxE
6kuMAzhWyCfy3A5zofflDO/lBndUvz2z76DcxgRtkPk3NtDI+/txZXmqlWnL
cKmqkQnQ4qL29kiiiTEn+lXKCqSotOJ681QAF3jJH+kvWygUk9T/3fwQB5Ys
t35cnuSgak02NXefAiudzePcsLIbn14KPzfNAfd5Q7Gq2sbmN2mKCuKtjN/h
5GjnLuq/ecUh0k+rTwjRQG5HXLXextw5wmoiMm0sRE6/H+hhZpwd1BPcQ1a2
JH2H/RaWAo/1KGcpQ4gsUZ/pfOqsTET7ROsTgzt6y1dftN9IgSb4yRtnlVJ0
U3G63DePC0fXm3XwwMSGRs0vd5utzGpdduNezZWxbgoab/OLB9/lrnpJYPdw
5/88JdD9lxH7heXm9H4TwoVmlfKFZB/B6nkXeKQKixqadF2NheAwE4JjJ3Wl
XaKJhnda4frHwhl2eOuHrto6GsI8Zz/ZG/wHq6XCR6tyaFDc3T7bOjPFPu24
ou6KoQG53nOVRz9kOa0V3mnBNEhL1ftGj99no2q/7X3uT4OyLVn/ZdYEKwj9
4Gf7nTRcntns9OIJC1vXP2hi42iotVyQX/j6HuvEe/2ZupAGmfPYaN+GMTa6
2XmKbaHhYsHJV72umtnnxV/I1k7T4FmYkioLM7FeQan4vRCfwXGf0GmlCOqF
CrzfUNV8OkAvgvcSz+D75YKcbOWICLzenMT5OS6z5wPsxTCsq8b1jYrIr2al
YvD/3Bf3d6rd5dLcK2Io6czA/W9K8oss8xCDW0IZnu+GwMES6CiGX4QP8fzo
VElZwrgI9pQEYZ++bRGHjrWJ4CXuY+xnbvM9XqUSwe6Tu7Av8Y4O3OEZUMZH
xJuJTRMpEvmIeO+BPxuX1/IR8d5UalrIrFmHiHenn6OD2nsdIt7avPCk4Hon
RLx1Z5pyf/VxQsRbskZLGTp4iHgX7tMdK9nPQ8R7lypu4RaHh4h35eJQYaeR
QsR75f+kEPFO197E+8Q7oiIe3yfeS+YanJ94663ncH3ifbWpBfdHvIcMDO6f
eAelUHg+4v37+d/w/MS7+8Ec9iHeqrNy7Ee8uydXfP8GBn1Fcw==
         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
             46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 1}, {2, 3}, {3, 11}, {4, 
             5}, {5, 15}, {6, 2}, {7, 1}, {8, 9}, {9, 56, 57, 58, 59, 60, 61, 
             62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
             78, 9}, {10, 2}, {11, 6}, {12, 11}, {13, 3}, {14, 15}, {15, 
             17}, {16, 17}, {17, 20}, {18, 5}, {19, 11}, {20, 5}, {21, 20}, {
             22, 6}, {23, 3}, {24, 2}, {25, 17}, {26, 20}, {27, 15}, {28, 
             1}, {29, 9}, {30, 6}, {31, 32}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{5.292456483471815, -0.9643558349864816}, {
          2.4809672775801004`, -6.300134340773068}, {
          1.3430429499578078`, -6.30642610528291}, {
          0.4643558349864816, -2.7728106852727823`}, {
          1.3397042392112943`, -2.4753299114454457`}, {
          2.4746032329927505`, -5.162552221136351}, {
          4.292456483471815, -0.9643558348966884}, {
          4.292456483471815, -3.8453700750466475`}, {
          5.292456483471815, -3.8453700751364406`}, {
          2.793021126836196, -7.168934455498806}, {
          1.3367498234320383`, -5.1686294256979215`}, {
          1.0238212752689806`, -4.2994369431050234`}, {
          0.4742951007064131, -6.619333582718098}, {
          2.7753518805425936`, -3.3616822251748366`}, {
          2.4775174468335655`, -2.4882770019436267`}, {
          3.3637448134988523`, -1.0505400130071472`}, {
          2.4905018631246914`, -1.3504567172924515`}, {
          1.0211129134067092`, -3.342320057486196}, {
          0.4643558349864816, -4.865827800369763}, {
          1.3531754825447024`, -1.338194406582196}, {
          0.48621880255912586`, -1.0205143933420158`}, {
          3.3433380217290405`, -4.850564774129252}, {
          1.0400787539298841`, -7.178686885553189}, {
          3.3531808752498384`, -6.604043364130242}, {
          2.8072101064432013`, -0.48298659815576706`}, {
          1.054629318245715, -0.4643558349864816}, {
          3.3451571131967195`, -2.805573463871801}, {
          6.292456483471815, -0.9643558351660679}, {
          6.292456483471815, -3.845370075316027}, {
          2.778152044497373, -4.2903938951478}, {
          5.792456483471815, -6.226384315376193}, {
          4.792456483471815, -6.2263843152864}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {583.2, -583.2}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.00000000000006`}], 
     InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxdVntcTWkX3qfUUc5J2zmd6KALMe5m+iRRe6fLdJWQpszQxZikERV1EpEP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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
             46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 1}, {2, 56, 57, 58, 59, 
             60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 3}, {3, 72, 73, 
             74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 2}, {4, 
             5}, {5, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
              102, 103, 19}, {6, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
             113, 114, 115, 116, 117, 118, 119, 7}, {7, 120, 121, 122, 123, 
             124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 6}, {
             8, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 
             148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 8}, {9, 
             10}, {10, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
             170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
             10}, {11, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
             193, 194, 195, 196, 197, 12}, {12, 198, 199, 200, 201, 202, 203, 
             204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 11}, {13, 214, 
             215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 
             228, 229, 14}, {14, 230, 231, 232, 233, 234, 235, 236, 237, 238, 
             239, 240, 241, 242, 243, 244, 245, 13}, {15, 246, 247, 248, 249, 
             250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 
             16}, {16, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 
             273, 274, 275, 276, 277, 15}, {17, 13}, {18, 19}, {19, 278, 279, 
             280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 
             293, 5}, {20, 15}, {21, 2}, {22, 11}, {23, 16}, {24, 14}, {25, 
             6}, {26, 12}, {27, 8}, {28, 7}, {29, 3}, {30, 1}, {31, 32}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.3312600000291828`, -0.8312600000291828}, {
          2.3312600000291828`, -4.981340001160578}, {
          1.3312600000291828`, -4.981340001070785}, {
          2.4937800000875483`, -2.106273333132047}, {
          3.4937800000875483`, -2.10627333322184}, {
          2.3312600000291828`, -3.6563000003255004`}, {
          1.3312600000291828`, -3.6563000002357073`}, {
          1.3312600000291828`, -2.4937800000875483`}, {
          4.743780000087549, -0.831260000118976}, {
          3.7437800000875483`, -0.8312600000291829}, {
          2.3312600000291828`, -5.643860001578116}, {
          1.3312600000291828`, -5.643860001488323}, {
          2.3312600000291828`, -4.318820000743039}, {
          1.3312600000291828`, -4.318820000653246}, {
          4.493780000087549, -2.8812866668634634`}, {
          3.4937800000875483`, -2.8812866667736703`}, {
          3.3312600000291828`, -4.318820000922625}, {
          5.493780000087549, -2.106273333581013}, {
          4.493780000087549, -2.1062733334014263`}, {
          5.493780000087549, -2.88128666704305}, {
          3.3312600000291828`, -4.981340001340164}, {
          3.3312600000291828`, -5.6438600017577025`}, {
          2.4937800000875483`, -2.8812866666838772`}, {
          0.33126000002918277`, -4.318820000563452}, {
          3.3312600000291828`, -3.656300000505087}, {
          0.33126000002918277`, -5.643860001398529}, {
          0.33126000002918277`, -2.4937799999977552`}, {
          0.33126000002918277`, -3.6563000001459143`}, {
          0.33126000002918277`, -4.981340000980991}, {
          0.33126000002918277`, -0.8312599999393896}, {
          5.243780000087549, -5.643860001623013}, {
          4.243780000087549, -5.64386000153322}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {972., -583.2}, 
      ImageScaled[{0.5, 0.5}], {360., 360.00000000000006`}], InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJw9lXlYU1caxpGlUhlJ7g0EiAilHURWoRWhdOQcUMEFkGVCBQEVRaC1oAxk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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 
             46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 1}, {2, 1}, {3, 4}, {4, 
             56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 
             8}, {5, 1}, {6, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
             84, 85, 86, 87, 7}, {7, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
             98, 99, 100, 101, 102, 103, 6}, {8, 104, 105, 106, 107, 108, 109,
              110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 4}, {9, 6}, {
             10, 1}, {11, 7}, {12, 7}, {13, 8}, {14, 4}, {15, 8}, {16, 6}, {
             17, 18}, {18, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 
             130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
             18}, {19, 1}, {20, 4}, {21, 7}, {22, 6}, {23, 7}, {24, 8}, {25, 
             8}, {26, 18}, {27, 4}, {28, 18}, {29, 6}, {30, 18}, {31, 
             32}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.1097087382210455`, -4.821627737462244}, {
          0.4026019570821181, -4.114520956228076}, {
          4.540199525257143, -0.40260195695513135`}, {
          4.841199727798482, -1.1292807283228294`}, {
          0.40260195695513135`, -5.528734518569425}, {
          1.8559594997175555`, -1.8559594996905278`}, {
          1.0694080654893834`, -1.8559594996199007`}, {
          4.285023874841311, -1.685456581155149}, {
          2.156959702193644, -2.5826382710852536`}, {
          1.81681551929648, -5.528734518759904}, {
          1.2539590946348769`, -0.40260195695513135`}, {
          0.4026019570632422, -1.2539590944120969`}, {
          3.3878421851441693`, -0.527280323044399}, {
          5.567878499098612, -1.4302809310272955`}, {
          3.3878421850360585`, -1.7312811333402571`}, {
          2.5826382710176845`, -2.156959702394994}, {
          3.3878421851630454`, -4.114520956228076}, {
          4.094948966301972, -4.821627737462244}, {
          1.8168155195504534`, -4.1145209564185565`}, {
          5.5678784992067225`, -0.8282805258793664}, {
          0.40260195695513135`, -2.4579599047079554`}, {
          2.5826382711257954`, -1.5549592972470647`}, {
          1.253959094373874, -3.3093170423178133`}, {
          4.239199322454801, -2.582638270950115}, {
          5.443200132750661, -2.582638271112281}, {
          3.3878421850360585`, -5.528734518569425}, {
          5.142199930535575, -0.40260195703621493`}, {
          4.802055747377407, -5.528734518759904}, {
          2.156959702454648, -1.1292807284039128`}, {
          4.80205574763138, -4.1145209564185565`}, {
          1.4026019569551313`, -6.33393843275996}, {
          0.40260195695513135`, -6.333938432670167}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {1360.8000000000002`, -583.2}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.00000000000006`}]}, {
     InsetBox[
      GraphicsBox[
       TagBox[
        GraphicsComplexBox[{{1.9909668830139267`, -1.677900235619055}, {
         1.8786172415519264`, -5.60353189028246}, {
         1.4995653711398953`, -7.157532948002028}, {
         0.7662841378301486, -1.975880777564548}, {
         1.6779002356197321`, -2.84628086946476}, {
         2.1969761683283706`, -6.998353484645117}, {
         2.8613669745764714`, -4.070963614781182}, {
         3.1593475167968856`, -2.8462808696642954`}, {
         1.3049542777343333`, -5.87979341336612}, {
         3.023422196351463, -1.8138255564048604`}, {
         2.41862387626591, -2.4186238762460324`}, {
         3.088998058821968, -8.116913556004212}, {
         2.841480657829929, -7.3087304886289735`}, {
         0.9079671892695143, -6.37759947679315}, {
         3.6282205160025613`, -3.6282205163628296`}, {
         2.8414806579414082`, -6.68797648089275}, {
         0.766284137750638, -2.861366974630779}, {
         0.7662841377506382, -6.998353484516651}, {
         1.975880777806979, -0.7662841377506382}, {
         0.9079671891580359, -7.619107492265597}, {
         1.209027236203419, -3.62822051603699}, {
         2.6429871137760483`, -6.439073449125765}, {
         4.070963614661916, -2.861366975075886}, {
         1.3049542775334553`, -8.116913555763919}, {
         2.6399954257179283`, -1.592454007057968}, {
         3.485985147331487, -7.619107492612829}, {
         1.8786172413014353`, -8.393175078950602}, {
         4.070963614820937, -1.9758807780096541`}, {
         2.3561556319044623`, -6.300942687506668}, {
         1.975880777510242, -4.070963614661917}, {
         2.5153350949795694`, -8.39317507903636}, {
         1.209027236420646, -1.2090272362378478`}, {
         3.627668198906103, -6.998353484902053}, {
         2.0249720907964512`, -1.805654617686879}, {
         2.0327418684472907`, -1.8604551665594946`}, {
         2.0273397629709726`, -1.9155395278420415`}, {
         2.0090718627194017`, -1.9677865700729855`}, {
         1.9789732440170331`, -2.014235926943591}, {
         1.938749322767645, -2.0522557344234613`}, {
         1.8906792239931967`, -2.0796917546395606`}, {
         1.837486644477144, -2.094989437010163}, {
         1.7821855255556884`, -2.0972820005356576`}, {
         1.7279092803810392`, -2.0864395464211705`}, {
         1.677733251799773, -2.0630764182638504`}, {
         1.6345004605490556`, -2.0285163927697147`}, {
         1.6006605170410046`, -1.9847176733266154`}, {
         1.5781308241442442`, -1.9341619363676799`}, {
         1.5681879353429498`, -1.8797137172621068`}, {
         1.5713952240217566`, -1.8244581030603426`}, {
         1.5875709622025498`, -1.771525928574593}, {
         1.6157986174217749`, -1.7239163803483395`}, {
         1.6544787843175697`, -1.684327059939966}, {
         1.7014198084343874`, -1.6550011352938825`}, {
         1.7539619674155296`, -1.6376002407455044`}, {
         1.809128173361006, -1.6331103272647478`}, {
         1.8637926574140862`, -1.6417857975513646`}}, {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
             47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 1}, {2, 3}, {3, 6}, {4, 
             5}, {5, 11}, {6, 13}, {7, 8}, {8, 11}, {9, 3}, {10, 11}, {11, 
             1}, {12, 13}, {14, 3}, {15, 8}, {16, 6}, {17, 5}, {18, 3}, {19, 
             1}, {20, 3}, {21, 5}, {22, 6}, {23, 8}, {24, 3}, {25, 11}, {26, 
             13}, {27, 3}, {28, 8}, {29, 6}, {30, 5}, {31, 3}, {32, 1}, {33, 
             13}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "0"],
            Annotation[#, 0, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "32"],
            Annotation[#, 32, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.9909668830139267`, -1.677900235619055}, {
          1.8786172415519264`, -5.60353189028246}, {
          1.4995653711398953`, -7.157532948002028}, {
          0.7662841378301486, -1.975880777564548}, {
          1.6779002356197321`, -2.84628086946476}, {
          2.1969761683283706`, -6.998353484645117}, {
          2.8613669745764714`, -4.070963614781182}, {
          3.1593475167968856`, -2.8462808696642954`}, {
          1.3049542777343333`, -5.87979341336612}, {
          3.023422196351463, -1.8138255564048604`}, {
          2.41862387626591, -2.4186238762460324`}, {
          3.088998058821968, -8.116913556004212}, {
          2.841480657829929, -7.3087304886289735`}, {
          0.9079671892695143, -6.37759947679315}, {
          3.6282205160025613`, -3.6282205163628296`}, {
          2.8414806579414082`, -6.68797648089275}, {
          0.766284137750638, -2.861366974630779}, {
          0.7662841377506382, -6.998353484516651}, {
          1.975880777806979, -0.7662841377506382}, {
          0.9079671891580359, -7.619107492265597}, {
          1.209027236203419, -3.62822051603699}, {
          2.6429871137760483`, -6.439073449125765}, {
          4.070963614661916, -2.861366975075886}, {
          1.3049542775334553`, -8.116913555763919}, {
          2.6399954257179283`, -1.592454007057968}, {
          3.485985147331487, -7.619107492612829}, {
          1.8786172413014353`, -8.393175078950602}, {
          4.070963614820937, -1.9758807780096541`}, {
          2.3561556319044623`, -6.300942687506668}, {
          1.975880777510242, -4.070963614661917}, {
          2.5153350949795694`, -8.39317507903636}, {
          1.209027236420646, -1.2090272362378478`}, {
          3.627668198906103, -6.998353484902053}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {194.4, -972.}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.}], InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJw9WHlcjNsbn2mamYamZaampMiSrSQ/KZLeI0TqJoVLLpfCr0tKkl8q2RJt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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
             47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 1}, {2, 3}, {3, 7}, {4, 
             57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 
             5}, {5, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
             87, 88, 4}, {6, 7}, {8, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 
             99, 100, 101, 102, 103, 104, 9}, {9, 105, 106, 107, 108, 109, 
             110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 8}, {10, 
             11}, {11, 7}, {12, 121, 122, 123, 124, 125, 126, 127, 128, 129, 
             130, 131, 132, 133, 134, 135, 136, 13}, {13, 137, 138, 139, 140, 
             141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 
             12}, {14, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 
             164, 165, 166, 167, 168, 15}, {15, 169, 170, 171, 172, 173, 174, 
             175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 14}, {16, 3}, {
             17, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
             197, 198, 199, 200, 18}, {18, 201, 202, 203, 204, 205, 206, 207, 
             208, 209, 210, 211, 212, 213, 214, 215, 216, 17}, {19, 7}, {20, 
             217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 
             230, 231, 232, 21}, {21, 233, 234, 235, 236, 237, 238, 239, 240, 
             241, 242, 243, 244, 245, 246, 247, 248, 20}, {22, 11}, {23, 249, 
             250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 
             263, 264, 265, 266, 267, 268, 269, 270, 271, 23}, {24, 7}, {25, 
             272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 
             285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 25}, {26, 3}, {
             27, 7}, {28, 11}, {29, 3}, {30, 7}, {31, 11}, {32, 295, 296, 297,
              298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310,
              311, 312, 313, 314, 315, 316, 317, 32}, {33, 7}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "0"],
            Annotation[#, 0, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "32"],
            Annotation[#, 32, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{4.107881110991507, -0.7319366856868749}, {
          1.6265092176389722`, -0.23193668568687498`}, {
          1.324457647335171, -1.421495159298488}, {
          4.458481883472463, -5.657160714499502}, {
          3.458481883472463, -5.657160714409709}, {
          1.2176086448188754`, -2.3698062846482704`}, {
          2.0256474012163004`, -1.9806753286566225`}, {
          6.071754482365257, -0.231936685776668}, {
          5.071754482365257, -0.23193668568687484`}, {
          0.9072870624370695, -3.3830548363686708`}, {
          2.0256474010955032`, -2.877530686421335}, {
          6.071754482365257, -3.176485385869857}, {
          5.071754482365257, -3.176485385780064}, {
          4.458481883472463, -4.693287343080856}, {
          3.458481883472463, -4.693287342991063}, {
          0.9072870626889176, -0.5782958207437319}, {
          1.2319366856868748`, -5.657160714499502}, {
          0.23193668568687476`, -5.657160714409709}, {
          2.8336861575089016`, -2.3698062848659394`}, {
          2.845209284579669, -5.657160714499502}, {
          1.8452092845796688`, -5.657160714409709}, {
          1.626509217324922, -3.72941397155469}, {
          4.107881110991507, -2.7126120143614174`}, {
          2.9225027589810133`, -1.9806753288176855`}, {
          0.7319366856868749, -4.693287343035959}, {
          0.4095698885612149, -1.202413416383103}, {
          2.833686157648667, -1.5915443727375327`}, {
          2.4247855846366044`, -3.72941397166221}, {
          0.23193668568687498`, -1.9806753284955596`}, {
          2.5848275706688786`, -1.2794855748508094`}, {
          3.144007739617758, -3.3830548366699356`}, {
          2.3452092845796693`, -4.693287343035959}, {
          2.2252164932405036`, -1.106306007225509}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {583.2, -972.}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.}], InsetBox[
      GraphicsBox[
       TagBox[
        GraphicsComplexBox[{{1.5279200875734777`, -2.1148417993106614`}, {
         5.949624434151126, -1.1844898184007442`}, {
         6.116399821824923, -1.9691063289671469`}, {
         2.1567501920857945`, -3.1156191778219045`}, {
         2.3427238291077237`, -2.3008154362960083`}, {
         5.173421454909246, -0.6712079531774187}, {
         5.3535142975717225`, -2.216982861684671}, {
         2.5286974659101613`, -3.115619177872002}, {
         6.442661712424703, -2.7019025334670066`}, {
         1.970776555356521, -0.6712079531774191}, {
         4.727043389661224, -1.1669610187184807`}, {
         1.3005507269040288`, -0.9939717009817275}, {
         6.712509958254774, -2.5058463068267502`}, {
         2.863810380150898, -2.954237303999939}, {
         4.520897673427714, -1.801412295655094}, {
         3.095715712256177, -2.663437215543077}, {
         6.879285346011352, -2.216982861890176}, {
         0.8367400627456949, -1.575571877937099}, {
         6.914150896046115, -1.8852593125260175`}, {
         3.178481767072876, -2.3008154364461006`}, {
         4.590628773318521, -2.464859394402195}, {
         3.095715712386421, -1.938193657319395}, {
         6.811078038014813, -1.5680336740299445`}, {
         0.6712079531774187, -2.3008154361459177`}, {
         4.924179548676047, -3.042586284365194}, {
         0.8367400626154518, -3.026058994384465}, {
         6.5878890054575745`, -1.3201571411992914`}, {
         2.8638103803855914`, -1.6473935687792394`}, {
         5.463876040230562, -3.43469873779109}, {
         2.528697466202818, -1.4860116947868116`}, {
         6.283175209710079, -1.1844898184456696`}, {
         1.3005507266693377`, -3.607659171423129}, {
         6.116399821608842, -3.573396949256555}, {
         1.773711450474377, -2.2113517016802575`}, {
         1.8053192056697436`, -2.227518134070586}, {
         1.8331457426415936`, -2.249565527677893}, {
         1.8561118409974529`, -2.2766387995715944`}, {
         1.8733267868944061`, -2.3076879438832534`}, {
         1.8841229183561847`, -2.3415087550825917`}, {
         1.8880815197788607`, -2.376789531710915}, {
         1.8850490613363784`, -2.412161949221115}, {
         1.8751431534591612`, -2.4462541288793496`}, {
         1.8587479854481586`, -2.477743844511795}, {
         1.8364994251324658`, -2.5054098035336736`}, {
         1.8092603574632424`, -2.5281790133845385`}, {
         1.7780872185083454`, -2.5451683963168277`}, {
         1.7441890227883958`, -2.555719038555728}, {
         1.7088804730321618`, -2.559421745515889}, {
         1.673530970935736, -2.5561329119451446`}, {
         1.63951150648486, -2.5459800914898785`}, {
         1.6081414856772545`, -2.52935704967282}, {
         1.5806375588708912`, -2.5069084921478595`}, {
         1.5580664343921629`, -2.479505060529045}, {
         1.5413035074741586`, -2.4482095655519256`}, {
         1.5309989090543272`, -2.4142357671754224`}, {
         1.5275522911900623`, -2.378901300290821}}, {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
             47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 1}, {2, 3}, {3, 7}, {4, 
             5}, {5, 1}, {6, 7}, {8, 5}, {9, 3}, {10, 1}, {11, 7}, {12, 1}, {
             13, 3}, {14, 5}, {15, 7}, {16, 5}, {17, 3}, {18, 1}, {19, 3}, {
             20, 5}, {21, 7}, {22, 5}, {23, 3}, {24, 1}, {25, 7}, {26, 1}, {
             27, 3}, {28, 5}, {29, 7}, {30, 5}, {31, 3}, {32, 1}, {33, 
             7}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "0"],
            Annotation[#, 0, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "32"],
            Annotation[#, 32, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.5279200875734777`, -2.1148417993106614`}, {
          5.949624434151126, -1.1844898184007442`}, {
          6.116399821824923, -1.9691063289671469`}, {
          2.1567501920857945`, -3.1156191778219045`}, {
          2.3427238291077237`, -2.3008154362960083`}, {
          5.173421454909246, -0.6712079531774187}, {
          5.3535142975717225`, -2.216982861684671}, {
          2.5286974659101613`, -3.115619177872002}, {
          6.442661712424703, -2.7019025334670066`}, {
          1.970776555356521, -0.6712079531774191}, {
          4.727043389661224, -1.1669610187184807`}, {
          1.3005507269040288`, -0.9939717009817275}, {
          6.712509958254774, -2.5058463068267502`}, {
          2.863810380150898, -2.954237303999939}, {
          4.520897673427714, -1.801412295655094}, {
          3.095715712256177, -2.663437215543077}, {
          6.879285346011352, -2.216982861890176}, {
          0.8367400627456949, -1.575571877937099}, {
          6.914150896046115, -1.8852593125260175`}, {
          3.178481767072876, -2.3008154364461006`}, {
          4.590628773318521, -2.464859394402195}, {
          3.095715712386421, -1.938193657319395}, {
          6.811078038014813, -1.5680336740299445`}, {
          0.6712079531774187, -2.3008154361459177`}, {
          4.924179548676047, -3.042586284365194}, {
          0.8367400626154518, -3.026058994384465}, {
          6.5878890054575745`, -1.3201571411992914`}, {
          2.8638103803855914`, -1.6473935687792394`}, {
          5.463876040230562, -3.43469873779109}, {
          2.528697466202818, -1.4860116947868116`}, {
          6.283175209710079, -1.1844898184456696`}, {
          1.3005507266693377`, -3.607659171423129}, {
          6.116399821608842, -3.573396949256555}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {972., -972.}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxFmHk4ldsXxw8Hx3QO5z2nozRJGmhAMkW9WyoNKrrNqUQpMnbVpVRUSqJo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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
             47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 1}, {2, 3}, {4, 57, 58, 
             59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 5}, {5, 
             73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
             4}, {6, 3}, {7, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 
             101, 102, 103, 104, 8}, {8, 105, 106, 107, 108, 109, 110, 111, 
             112, 113, 114, 115, 116, 117, 118, 119, 120, 7}, {9, 3}, {10, 
             121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 
             134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 10}, {11, 3}, {
             12, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
             156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 12}, {13, 
             3}, {14, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 
             178, 179, 180, 181, 182, 15}, {15, 183, 184, 185, 186, 187, 188, 
             189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 14}, {16, 3}, {
             17, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 
             211, 212, 213, 214, 18}, {18, 215, 216, 217, 218, 219, 220, 221, 
             222, 223, 224, 225, 226, 227, 228, 229, 230, 17}, {19, 3}, {20, 
             231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 
             244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 20}, {21, 3}, {
             22, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 
             266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 22}, {23, 
             3}, {24, 3}, {25, 3}, {26, 277, 278, 279, 280, 281, 282, 283, 
             284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 
             297, 298, 299, 26}, {27, 3}, {28, 300, 301, 302, 303, 304, 305, 
             306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 
             319, 320, 321, 322, 28}, {29, 3}, {30, 3}, {31, 3}, {32, 323, 
             324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 
             337, 338, 339, 340, 341, 342, 343, 344, 345, 32}, {33, 3}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "0"],
            Annotation[#, 0, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "32"],
            Annotation[#, 32, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          0.7300402030967699, -3.1516911701339962`}, {
          1.015735161552023, -0.2300402030967701}, {
          1.210825483518613, -1.2108254835098542`}, {
          5.1117715763450535`, -4.6351272707333955`}, {
          4.1117715763450535`, -4.635127270643602}, {
          0.6552552505503396, -0.3793558711730123}, {
          5.1117715763450535`, -5.103489626672133}, {
          4.1117715763450535`, -5.1034896265823395`}, {
          0.3793558712566003, -0.6552552504295908}, {
          4.6117715763450535`, -0.7300402030967699}, {
          0.2300402031318054, -1.0157351614111625`}, {
          4.6117715763450535`, -2.198402558945714}, {
          0.23004020309676987`, -1.4059158054324103`}, {
          1.2300402030967699`, -5.57185198261087}, {
          0.23004020309676987`, -5.571851982521077}, {
          0.37935587115682745`, -1.766395716440797}, {
          3.9009460928176813`, -5.57185198261087}, {
          2.9009460928176813`, -5.571851982521077}, {
          0.6552552504010186, -2.0422950957469235`}, {
          4.6117715763450535`, -3.666764914794658}, {
          1.0157351613758865`, -2.191610763887903}, {
          3.151691170151514, -0.7300402030967699}, {
          1.4059158053971343`, -2.1916107639404565`}, {
          1.7663957164122248`, -2.0422950958965833`}, {
          2.042295095730738, -1.7663957166647797`}, {
          3.151691170151514, -2.670905889712153}, {
          2.1916107638879025`, -1.4059158056966157`}, {
          0.7300402030967699, -4.611771576327536}, {
          2.191610763957974, -1.0157351616753678`}, {
          2.042295095930286, -0.6552552506535734}, {
          1.766395716710869, -0.37935587132267257`}, {
          2.6709058897209115`, -4.611771576327536}, {
          1.405915805749409, -0.23004020314932383`}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {1360.8000000000002`, -972.}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxNlHs0VXkUx9G9uA9ynXNctJCkt1RLciecXanRVaimNZVMKI9wF6sYRF7R
pBXyfhWJ9EB5RIU6v0VJizLNkDcTIaI8LlEeY86tWf1x1ll77bX3/n4/v9/+
aTt47HeUkZKScl74/vvHXUipssjF4YRFAdkhGqakykHfd5IBBdWWQWVtrZTw
V6eh1SIGZKc/D7qfK6aiFCPLBtWkQfv3+f6dfFW0ber4oLSONIS5LHK6PIsh
rrFrY2gpA2oORiYrujPQWTC4vEZPTEatvF0jVcxBinNrasLICfJQtXRQUSkD
BQzfEKokyYI3pHz4qU0dqVKuT/NXsiGwyoijFsNC9yU6yD35hcPH9MWUvHLA
AJErJtfpdJAG2yYoJ6Z4HnWNkpp5O6NuTmPook60U4ABD77VUVUFqQv++LDy
w/2UsQw2ksQYHGgs/CEmoK+2fNRwDEepvVfyNsSy4Npi7sZ9MT2UtUg3USeq
h7T7s72ndqyX4nU9zqirHSV9B3TSEjFVZMyceKnk00GOVJxZfPIm83+9J0xj
X957rY6Uu8fLpl6MkQU53S3+gR3Uifba86QtB+piz0i/fTn2TR8PZqCMnm9g
lESfR7Fuc8bH0jnKc81skXxWG5nubnr/swEPuSQI9dhFHNjLjAm7NMlAKwxZ
/l6fesllAbOPY1axUXCzodUfOUwwYzRNuRzloLudhq5f7siCUEk4iZE8NGOS
s3TJMlWY6Yv6gY8KKBhdS/SKV//GQxl08tPp+M5Yw14TNRziyl5gL/YNUBlk
8MjZaQyEynKH5g3eU5Pu0cuNuzFI9Hlr3tTfRxWAhVF8AwYM//Q4wZleanhL
7hK91xjUDI0Xpc32UBNSac4bmjHQf/IqZE1YN1UT52tvPoDBsWg37pDWW0pj
LYZlL8LhnnSeT3VVF2XdpbVTegUO7qp+lUFFHVRh/6ruckscyOFQTaFuO7Vp
pIvZ7Y/DrrXRJhr6bd/84PA80Y72Z+F2MKSkFYep5Fg6P2/PvdEmR8DD9Ai6
/uZeYnviBgI6y0Pp/vFt2l7j+wkw035Iz/9gVqFrJSJAO+4UrU+QnaLlHEjA
Krs3tP47hhFuruEE3K7/Svtrm3xvuSiUABfTHNp/SUK2g40XAXEV72k+nbHF
iWq2BDCDFWh+WaW/CY6YEHBapp7m21aFJW9duJ/rpoU7Zm+y0fBcy9KmDAz4
bnnh+ls4KGrTTGNDMAay4qOmUMZBNpM/exdaYzBnMq6Rt4KLHns5+O7GMBi9
u/oVOs1FkVr7ayNeKsNyXlm4VRoXbTaLv8UOV4Y9587Mrk3lorvc2AdXSGXo
1apOEnlyUcEbj+zXMsrg7mcdLNLmIrME7WcRf/PgfEf/YMjC/qrXjn2OLuHB
OrMpsb8+B32/vyeFBfQ+ecuM0/kAOxfTk0psFDEvqbeb8DU/fomFDrt50v1d
rysV+2iyUD0lmf/ocFqaT7088pRLoPWJ7Ps3P7ohj4x6JPrddtzKT8iWRytW
H6f9GfIEjsvr5BE70pz2/+4fD0KgxkKiDAkfLW/ZiexwFgJBK83vnd6D/BJ5
NpqolvB1KFQd6U9io9yr2p9sFvb/i+DTlY0fcZTiYOOESglghDzxT87B0dR6
QWFlIwGRxk5aSo44Wus2zOtjqkAMP02/dT2OXgz9pWi5QwX4XUFNVvI4mt7W
U64QoQJz+Q/8L4gxtE8js/PSaxUY9Goi1Scw1PxLVv0XFT5czSk8Nc3C0ZuL
z7qfHeBDi597oN9GHG2vwyoVzvGh7vnS3R4uOHJP3B4tl8kHv3hVs1N3cPT9
PbOJqaDfC94xSX7febuMrwICzdpL6ru2Hkqd8yeQ3uRTuv8RR66juIhADzKv
0/OLWc89vVoJxD9yjdbXwszMOvCJQJaB3bT+1njk3LsQ2xlJ/In1pjia7QQK
aBii/WtWtxfHlRBIrdKI5iMVwHtqG0SgXask/NK1Hjk3mhAoJlXCt8v2wi7j
SRz9C4/EHIA=
         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
             48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1}, {2, 3}, {3, 6}, {4, 
             5}, {5, 13}, {6, 8}, {7, 8}, {8, 12}, {9, 4}, {10, 6}, {11, 
             12}, {12, 3}, {13, 20}, {14, 1}, {15, 16}, {16, 58, 59, 60, 61, 
             62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
             78, 79, 80, 16}, {17, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
              92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 17}, {18, 
             3}, {19, 12}, {20, 4}, {21, 8}, {22, 20}, {23, 12}, {24, 3}, {25,
              17}, {26, 1}, {27, 13}, {28, 6}, {29, 8}, {30, 6}, {31, 5}, {32,
              1}, {33, 34}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "32"],
            Annotation[#, 32, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "33"],
            Annotation[#, 33, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[34],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{5.16728120445818, -0.9196611637038186}, {
          2.62034642139713, -0.41966116363901573`}, {
          2.5533026188594805`, -1.2919201842686698`}, {
          2.137654740743364, -6.022727608649377}, {
          2.142093497443995, -4.997621149023079}, {
          2.5891167328877653`, -2.5527622144825024`}, {
          1.2610269196484574`, -3.4624038387891636`}, {
          1.328007490068447, -2.5892076418320293`}, {
          2.823772986592017, -6.714091950634715}, {
          3.2693744034840044`, -3.1958485485742463`}, {
          0.41966116363901595`, -1.2615660939143991`}, {
          1.2917689438337465`, -1.3284189696007145`}, {
          1.1171274183437503`, -4.993803236963712}, {
          4.301255800711155, -0.41966116363901595`}, {
          5.917281204525525, -3.328099442323395}, {
          4.917281204525525, -3.328099442233602}, {
          5.417281204525525, -5.236537720763385}, {
          3.196381901300538, -0.6114889104796823}, {
          0.6111009533446268, -0.6858882379951972}, {
          1.1122556915196962`, -6.019129203860182}, {
          0.4603921901035226, -2.7067433556873013`}, {
          0.41966116363901595`, -6.704772197772034}, {
          1.1743094733084303`, -0.46084495809428017`}, {
          3.4205313235248003`, -1.1752634103551598`}, {
          4.417281204525525, -5.236537720673592}, {
          5.167281204323491, -1.9196611637038188`}, {
          0.4318258045138128, -4.301726166067196}, {
          3.461933473433124, -2.6203852040058906`}, {
          0.6854803469702275, -3.269809231088872}, {
          2.706312769757517, -3.420122093259609}, {
          2.833485441016669, -4.311599586744771}, {
          6.033306608339895, -0.41966116387230534`}, {
          5.667281204525525, -6.644975999382962}, {
          4.667281204525525, -6.644975999293169}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {194.4, -1360.8000000000002`}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 359.9999999999998}], 
     InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJw9lnlU01cWxwMhmRogBLOwWSioLQJaRKkoy+/J4kEEilRRqFVJHWsVD1Nb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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
             48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1}, {2, 3}, {3, 14}, {4, 
             5}, {5, 21}, {6, 7}, {7, 31}, {8, 9}, {9, 26}, {10, 11}, {11, 
             24}, {12, 13}, {13, 19}, {14, 23}, {15, 4}, {16, 58, 59, 60, 61, 
             62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
             78, 79, 80, 16}, {17, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
              92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 17}, {18, 
             104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
             117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 18}, {19, 
             25}, {20, 8}, {21, 15}, {22, 6}, {23, 2}, {24, 30}, {25, 12}, {
             26, 20}, {27, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
             137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
             27}, {28, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 
             161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
             28}, {29, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 
             184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 
             29}, {30, 10}, {31, 22}, {32, 196, 197, 198, 199, 200, 201, 202, 
             203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 
             216, 217, 218, 32}, {33, 34}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "32"],
            Annotation[#, 32, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "33"],
            Annotation[#, 33, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[34],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          3.7827889419919485`, -3.779896836091707}, {
          2.792326948641665, -4.2824335890938}, {
          1.7929338249954627`, -4.308496363878728}, {
          1.2745851368406746`, -1.244590745815662}, {
          0.2744943578020228, -1.2745308423509392`}, {
          1.2745851368406746`, -2.7636611442701344`}, {
          0.2744943578020228, -2.7936012408054114`}, {
          2.7937098297848824`, -1.244590745815662}, {
          1.7936190507462308`, -1.2745308423509392`}, {
          2.793018389213274, -2.765450828329905}, {
          1.7936252655670715`, -2.7915136031148333`}, {
          1.2732022556974574`, -4.2824335890938}, {
          0.2738091320512549, -4.308496363878728}, {
          1.7636642490477408`, -3.309111522028213}, {
          1.2434622106263193`, -0.24453955610353306`}, {
          5.271868054199015, -0.7445395561035331}, {
          5.271868054199015, -2.2622181960976198`}, {
          5.271868054199015, -3.779896836091707}, {
          0.24453955610353306`, -3.309111522028213}, {
          2.7625869035705275`, -0.24453955610353306`}, {
          0.24453955610353306`, -0.2754555461823611}, {
          1.2434622106263193`, -1.7636099545580053`}, {
          2.763602812271312, -3.282680353012478}, {
          1.7643556896193495`, -1.7921287612643182`}, {
          1.2444781193271046`, -3.282680353012478}, {
          1.763664249047741, -0.2754555461823611}, {
          0.7445395561035331, -5.297575476085793}, {
          2.7500087595377156`, -5.297575476085793}, {
          3.7827889419919485`, -0.7445395561035331}, {
          2.764294252842921, -1.7656975922485831`}, {
          0.24453955610353306`, -1.7945259446368333`}, {
          3.7827889419919485`, -2.2622181960976198`}, {
          5.255477962971899, -5.29757547613069}, {
          4.255477962971899, -5.297575476040897}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {583.2, -1360.8000000000002`}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 359.9999999999998}], 
     InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxVV3k01GsfJ4VKZvmNbUZmhJRSSrSonidC13KzdFWSwtWkhCSurIkWaXEL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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
             48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1}, {2, 3}, {3, 58, 59, 
             60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 9}, {4, 
             74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 
             5}, {5, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
             103, 104, 105, 4}, {6, 106, 107, 108, 109, 110, 111, 112, 113, 
             114, 115, 116, 117, 118, 119, 120, 121, 7}, {7, 122, 123, 124, 
             125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 
             6}, {8, 9}, {9, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147,
              148, 149, 150, 151, 152, 153, 3}, {10, 11}, {11, 154, 155, 156, 
             157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
             14}, {12, 7}, {13, 6}, {14, 170, 171, 172, 173, 174, 175, 176, 
             177, 178, 179, 180, 181, 182, 183, 184, 185, 11}, {15, 1}, {16, 
             17}, {17, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
             197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 
             17}, {18, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 
             220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 
             18}, {19, 3}, {20, 6}, {21, 9}, {22, 4}, {23, 6}, {24, 3}, {25, 
             18}, {26, 1}, {27, 14}, {28, 7}, {29, 9}, {30, 7}, {31, 5}, {32, 
             1}, {33, 34}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "32"],
            Annotation[#, 32, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "33"],
            Annotation[#, 33, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[34],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.2543844659038497`, -4.428474305344602}, {
          4.754835345024263, -0.3883590621568245}, {
          5.153697362595399, -1.0792083418949703`}, {
          2.388359062156825, -7.9819105541514865`}, {
          1.388359062156825, -7.9819105540616935`}, {
          1.1860830973818097`, -1.7700576215614867`}, {
          1.9838071326067948`, -1.770057621633117}, {
          3.5582492921454296`, -1.07920834175171}, {
          4.754835344900195, -1.770057621561486}, {
          2.8082492921454296`, -6.705192429433767}, {
          3.8082492921454296`, -6.70519242952356}, {
          2.382669150115898, -2.460906901407078}, {
          1.1860830974645213`, -0.3883590621568249}, {
          4.80824929214543, -6.705192429703147}, {
          0.3883590621568247, -3.928474305279799}, {
          5.1742746959598, -4.678474305401993}, {
          4.1742746959598, -4.6784743053122}, {
          1.3883590621568247`, -6.705192429658251}, {
          5.9514213978203845`, -1.0792083420382306`}, {
          0.3883590621568249, -1.7700576214898567`}, {
          4.355973327204992, -2.460906901228002}, {
          3.388359062156825, -7.981910554331073}, {
          1.186083097216387, -3.1517561809661485`}, {
          5.552559380352637, -0.38835906226426964`}, {
          0.3883590621568247, -6.7051924295684575`}, {
          1.2543844657691599`, -5.428474305344602}, {
          5.80824929214543, -6.705192429882733}, {
          2.78153116783178, -1.7700576217763773`}, {
          5.951421397613606, -2.4609069014428924`}, {
          2.3826691503640323`, -1.079208342002416}, {
          0.3883590621568249, -7.9819105539718995`}, {
          2.120409869785564, -3.928474305513088}, {
          5.55824929214543, -7.981910554196383}, {
          4.55824929214543, -7.98191055410659}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {972., -1360.8000000000002`}, 
      ImageScaled[{0.5, 0.5}], {360., 359.9999999999998}], InsetBox[
      GraphicsBox[
       TagBox[GraphicsComplexBox[CompressedData["
1:eJxdlntUVNUex8HLzDC8ZwYCRBJKIyH1MiCNKPdsioriTeqCSHIug1Lo9RFc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         "], {
          {RGBColor[0.5, 0., 0.], 
           LineBox[{{1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
             48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 1}, {2, 3}, {3, 58, 59, 
             60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
             76, 77, 78, 79, 80, 3}, {4, 5}, {5, 81, 82, 83, 84, 85, 86, 87, 
             88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
             103, 5}, {6, 1}, {7, 8}, {8, 104, 105, 106, 107, 108, 109, 110, 
             111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 
             124, 125, 126, 8}, {9, 10}, {10, 127, 128, 129, 130, 131, 132, 
             133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 
             146, 147, 148, 149, 10}, {11, 12}, {12, 150, 151, 152, 153, 154, 
             155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
             168, 169, 170, 171, 172, 12}, {13, 3}, {14, 5}, {15, 173, 174, 
             175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 
             188, 189, 190, 191, 192, 193, 194, 195, 15}, {16, 12}, {17, 8}, {
             18, 5}, {19, 1}, {20, 3}, {21, 10}, {22, 12}, {23, 8}, {24, 196, 
             197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
             210, 211, 212, 213, 214, 215, 216, 217, 218, 24}, {25, 10}, {26, 
             1}, {27, 8}, {28, 5}, {29, 12}, {30, 3}, {31, 10}, {32, 1}, {33, 
             34}}]}, 
          {RGBColor[0, 0, 0.7], 
           TagBox[
            TooltipBox[PointBox[1],
             "1"],
            Annotation[#, 1, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[2],
             "2"],
            Annotation[#, 2, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[3],
             "32"],
            Annotation[#, 32, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[4],
             "3"],
            Annotation[#, 3, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[5],
             "12"],
            Annotation[#, 12, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[6],
             "4"],
            Annotation[#, 4, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[7],
             "5"],
            Annotation[#, 5, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[8],
             "23"],
            Annotation[#, 23, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[9],
             "6"],
            Annotation[#, 6, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[10],
             "21"],
            Annotation[#, 21, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[11],
             "7"],
            Annotation[#, 7, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[12],
             "10"],
            Annotation[#, 10, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[13],
             "8"],
            Annotation[#, 8, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[14],
             "9"],
            Annotation[#, 9, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[15],
             "11"],
            Annotation[#, 11, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[16],
             "13"],
            Annotation[#, 13, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[17],
             "14"],
            Annotation[#, 14, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[18],
             "15"],
            Annotation[#, 15, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[19],
             "16"],
            Annotation[#, 16, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[20],
             "17"],
            Annotation[#, 17, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[21],
             "18"],
            Annotation[#, 18, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[22],
             "19"],
            Annotation[#, 19, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[23],
             "20"],
            Annotation[#, 20, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[24],
             "22"],
            Annotation[#, 22, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[25],
             "24"],
            Annotation[#, 24, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[26],
             "25"],
            Annotation[#, 25, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[27],
             "26"],
            Annotation[#, 26, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[28],
             "27"],
            Annotation[#, 27, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[29],
             "28"],
            Annotation[#, 28, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[30],
             "29"],
            Annotation[#, 29, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[31],
             "30"],
            Annotation[#, 30, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[32],
             "31"],
            Annotation[#, 31, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[33],
             "33"],
            Annotation[#, 33, "Tooltip"]& ], 
           TagBox[
            TooltipBox[PointBox[34],
             "0"],
            Annotation[#, 0, "Tooltip"]& ]}}],
        Annotation[#, 
         VertexCoordinateRules -> {{
          1.0122634861388682`, -1.0122634861071218`}, {
          0.30515670499994074`, -2.3296836771506904`}, {
          1.0122634861388682`, -3.036790458384858}, {
          2.3296836773411713`, -0.3051567048729542}, {
          3.0367904584800987`, -1.0122634861071218`}, {
          0.30515670499994074`, -0.3051567048729542}, {
          2.3296836773411713`, -2.3296836771506904`}, {
          3.0367904584800987`, -3.036790458384858}, {
          0.30515670499994074`, -4.354210649428427}, {
          1.0122634861388682`, -5.061317430662594}, {
          2.3296836773411713`, -4.354210649428427}, {
          3.0367904584800987`, -5.061317430662594}, {
          0.305156704872954, -3.743897239492039}, {
          2.3296836772141845`, -1.7193702672143027`}, {
          4.854210649555414, -0.8051567048729541}, {
          2.3296836772141845`, -5.7684242117697755`}, {
          2.3296836772141845`, -3.743897239492039}, {
          3.743897239555533, -1.7193702674047824`}, {
          0.305156704872954, -1.7193702672143027`}, {
          1.7193702672143027`, -3.7438972396825188`}, {
          0.305156704872954, -5.7684242117697755`}, {
          3.743897239555533, -5.768424211960255}, {
          3.743897239555533, -3.7438972396825188`}, {
          4.854210649555414, -3.1630170104540927`}, {
          1.7193702672143027`, -5.768424211960255}, {
          1.7193702672143027`, -1.7193702674047824`}, {
          3.7438972398095065`, -2.329683677341171}, {
          3.7438972398095065`, -0.3051567050634345}, {
          3.7438972398095065`, -4.354210649618907}, {
          1.719370267468276, -2.329683677341171}, {
          1.719370267468276, -4.354210649618907}, {
          1.719370267468276, -0.3051567050634345}, {
          5.354210649555414, -5.020877316125024}, {
          4.354210649555414, -5.020877316035231}}]& ],
       AspectRatio->Automatic,
       FrameTicks->None,
       PlotRange->All,
       PlotRangePadding->Scaled[0.1]], {1360.8000000000002`, -1360.8000000000002`},
       ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.9999999999998}]}}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -388.8}}], 
      LineBox[{{0, -388.8}, {0, -777.6}}], 
      LineBox[{{0, -777.6}, {0, -1166.4}}], 
      LineBox[{{0, -1166.4}, {0, -1555.2}}], 
      LineBox[{{388.8, 0}, {388.8, -388.8}}], 
      LineBox[{{388.8, -388.8}, {388.8, -777.6}}], 
      LineBox[{{388.8, -777.6}, {388.8, -1166.4}}], 
      LineBox[{{388.8, -1166.4}, {388.8, -1555.2}}], 
      LineBox[{{777.6, 0}, {777.6, -388.8}}], 
      LineBox[{{777.6, -388.8}, {777.6, -777.6}}], 
      LineBox[{{777.6, -777.6}, {777.6, -1166.4}}], 
      LineBox[{{777.6, -1166.4}, {777.6, -1555.2}}], 
      LineBox[{{1166.4, 0}, {1166.4, -388.8}}], 
      LineBox[{{1166.4, -388.8}, {1166.4, -777.6}}], 
      LineBox[{{1166.4, -777.6}, {1166.4, -1166.4}}], 
      LineBox[{{1166.4, -1166.4}, {1166.4, -1555.2}}], 
      LineBox[{{1555.2, 0}, {1555.2, -388.8}}], 
      LineBox[{{1555.2, -388.8}, {1555.2, -777.6}}], 
      LineBox[{{1555.2, -777.6}, {1555.2, -1166.4}}], 
      LineBox[{{1555.2, -1166.4}, {1555.2, -1555.2}}], 
      LineBox[{{0, 0}, {388.8, 0}}], LineBox[{{388.8, 0}, {777.6, 0}}], 
      LineBox[{{777.6, 0}, {1166.4, 0}}], LineBox[{{1166.4, 0}, {1555.2, 0}}],
       LineBox[{{0, -388.8}, {388.8, -388.8}}], 
      LineBox[{{388.8, -388.8}, {777.6, -388.8}}], 
      LineBox[{{777.6, -388.8}, {1166.4, -388.8}}], 
      LineBox[{{1166.4, -388.8}, {1555.2, -388.8}}], 
      LineBox[{{0, -777.6}, {388.8, -777.6}}], 
      LineBox[{{388.8, -777.6}, {777.6, -777.6}}], 
      LineBox[{{777.6, -777.6}, {1166.4, -777.6}}], 
      LineBox[{{1166.4, -777.6}, {1555.2, -777.6}}], 
      LineBox[{{0, -1166.4}, {388.8, -1166.4}}], 
      LineBox[{{388.8, -1166.4}, {777.6, -1166.4}}], 
      LineBox[{{777.6, -1166.4}, {1166.4, -1166.4}}], 
      LineBox[{{1166.4, -1166.4}, {1555.2, -1166.4}}], 
      LineBox[{{0, -1555.2}, {388.8, -1555.2}}], 
      LineBox[{{388.8, -1555.2}, {777.6, -1555.2}}], 
      LineBox[{{777.6, -1555.2}, {1166.4, -1555.2}}], 
      LineBox[{{1166.4, -1555.2}, {1555.2, -1555.2}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488271208]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->419208933]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->497586619],

Cell[TextData[{
 "To span across both rows and columns requires appropriate use of ",
 Cell[BoxData[
  ButtonBox["SpanFromBoth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanFromBoth"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1862285898],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311332533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "SpanFromLeft", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", "SpanFromAbove", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2012416308],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {387., -193.5}, 
      ImageScaled[{0.5, 0.5}], {747., 360.}], {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {{}, 
     InsetBox["\[SpanFromAbove]", {580.5, -580.5}, {
      Center, Center}, {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->315387712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "SpanFromLeft", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"SpanFromAbove", ",", "SpanFromBoth", ",", "x"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2099287209],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {387., -387.}, 
      ImageScaled[{0.5, 0.5}], {747., 747.}], {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -193.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {{}, {}, InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -580.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}, {InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {193.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {580.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
      GraphicsBox[CircleBox[{0, 0}]], {967.5, -967.5}, 
      ImageScaled[{0.5, 0.5}], {360., 360.}]}}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->731634788]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24815],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsRow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsRow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsColumn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PackingMethod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PackingMethod"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6064]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7210],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->25408],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->34733876]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->394867901],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->276655669],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->333469530],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->560977822],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->211718786],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->13754033],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->395960379],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->254732241],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->470764760],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->21960512]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphicsGrid - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 32.3332538}", "context" -> "System`", 
    "keywords" -> {
     "graphics array", "image array", "picture array", "tables of graphics"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GraphicsGrid[{{g_11, g_12, ...}, ...}] generates a graphic in which the \
g_ij are laid out in a two-dimensional grid.", 
    "synonyms" -> {"graphics grid"}, "title" -> "GraphicsGrid", "type" -> 
    "Symbol", "uri" -> "ref/GraphicsGrid"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[34688, 1102, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->218126754]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 370169, 9233}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3879, 84, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4502, 111, 1577, 37, 70, "ObjectNameGrid"],
Cell[6082, 150, 1007, 31, 70, "Usage",
 CellID->21228]
}, Open  ]],
Cell[CellGroupData[{
Cell[7126, 186, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7604, 203, 686, 23, 70, "Notes",
 CellID->14604],
Cell[8293, 228, 248, 8, 70, "Notes",
 CellID->153],
Cell[8544, 238, 675, 24, 70, "Notes",
 CellID->14640],
Cell[9222, 264, 562, 19, 70, "Notes",
 CellID->6860],
Cell[9787, 285, 109, 4, 70, "Notes",
 CellID->8046],
Cell[9899, 291, 957, 25, 70, "2ColumnTableMod",
 CellID->28627],
Cell[10859, 318, 1116, 35, 70, "Notes",
 CellID->5044],
Cell[11978, 355, 68, 1, 70, "Notes",
 CellID->26500],
Cell[12049, 358, 3810, 107, 70, "3ColumnTableMod",
 CellID->333],
Cell[15862, 467, 412, 13, 70, "Notes",
 CellID->15724],
Cell[16277, 482, 537, 19, 70, "Notes",
 CellID->8756],
Cell[16817, 503, 1985, 63, 70, "2ColumnTableMod",
 CellID->11051],
Cell[18805, 568, 190, 8, 70, "Notes",
 CellID->25391],
Cell[18998, 578, 6755, 220, 70, "2ColumnTableMod",
 CellID->16534],
Cell[25756, 800, 749, 22, 70, "Notes",
 CellID->26373273],
Cell[26508, 824, 630, 23, 70, "Notes",
 CellID->4827],
Cell[27141, 849, 707, 23, 70, "Notes",
 CellID->11176],
Cell[27851, 874, 196, 8, 70, "Notes",
 CellID->13269],
Cell[28050, 884, 1629, 45, 70, "2ColumnTableMod",
 CellID->5388],
Cell[29682, 931, 348, 13, 70, "Notes",
 CellID->103124118],
Cell[30033, 946, 1083, 33, 70, "2ColumnTableMod",
 CellID->934654743],
Cell[31119, 981, 485, 18, 70, "Notes",
 CellID->405888177],
Cell[31607, 1001, 641, 21, 70, "Notes",
 CellID->49335815],
Cell[32251, 1024, 227, 8, 70, "Notes",
 CellID->3429],
Cell[32481, 1034, 1818, 51, 70, "2ColumnTableMod",
 CellID->15885],
Cell[34302, 1087, 349, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[34688, 1102, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->218126754],
Cell[CellGroupData[{
Cell[35073, 1116, 148, 5, 70, "ExampleSection",
 CellID->227006904],
Cell[35224, 1123, 79, 1, 70, "ExampleText",
 CellID->255138841],
Cell[CellGroupData[{
Cell[35328, 1128, 571, 18, 47, "Input",
 CellID->209490826],
Cell[35902, 1148, 713, 17, 120, "Output",
 CellID->856648832]
}, Open  ]],
Cell[36630, 1168, 125, 3, 70, "ExampleDelimiter",
 CellID->344040015],
Cell[36758, 1173, 75, 1, 70, "ExampleText",
 CellID->20121397],
Cell[CellGroupData[{
Cell[36858, 1178, 641, 19, 70, "Input",
 CellID->236225215],
Cell[37502, 1199, 1275, 28, 120, "Output",
 CellID->966549936]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38826, 1233, 221, 7, 70, "ExampleSection",
 CellID->371246094],
Cell[CellGroupData[{
Cell[39072, 1244, 242, 7, 70, "ExampleSubsection",
 CellID->511949576],
Cell[39317, 1253, 76, 1, 70, "ExampleText",
 CellID->61301763],
Cell[CellGroupData[{
Cell[39418, 1258, 357, 11, 70, "Input",
 CellID->62846654],
Cell[39778, 1271, 1782, 33, 70, "Output",
 Evaluatable->False,
 CellID->227406638]
}, Open  ]],
Cell[41575, 1307, 125, 3, 70, "ExampleDelimiter",
 CellID->545138637],
Cell[41703, 1312, 76, 1, 70, "ExampleText",
 CellID->861064787],
Cell[CellGroupData[{
Cell[41804, 1317, 357, 11, 70, "Input",
 CellID->393168623],
Cell[42164, 1330, 2055, 38, 70, "Output",
 Evaluatable->False,
 CellID->144558867]
}, Open  ]],
Cell[44234, 1371, 71, 1, 70, "ExampleText",
 CellID->1058702674],
Cell[CellGroupData[{
Cell[44330, 1376, 409, 12, 70, "Input",
 CellID->1713826523],
Cell[44742, 1390, 2065, 38, 70, "Output",
 Evaluatable->False,
 CellID->3351436]
}, Open  ]],
Cell[46822, 1431, 124, 3, 70, "ExampleDelimiter",
 CellID->88007557],
Cell[46949, 1436, 87, 1, 70, "ExampleText",
 CellID->205713954],
Cell[CellGroupData[{
Cell[47061, 1441, 466, 15, 70, "Input",
 CellID->123321595],
Cell[47530, 1458, 2201, 40, 70, "Output",
 Evaluatable->False,
 CellID->101708494]
}, Open  ]],
Cell[49746, 1501, 88, 1, 70, "ExampleText",
 CellID->1196540285],
Cell[CellGroupData[{
Cell[49859, 1506, 467, 15, 70, "Input",
 CellID->1215699487],
Cell[50329, 1523, 2216, 40, 70, "Output",
 Evaluatable->False,
 CellID->96418279]
}, Open  ]],
Cell[52560, 1566, 125, 3, 70, "ExampleDelimiter",
 CellID->144232786],
Cell[52688, 1571, 84, 1, 70, "ExampleText",
 CellID->324771918],
Cell[CellGroupData[{
Cell[52797, 1576, 415, 13, 70, "Input",
 CellID->750408934],
Cell[53215, 1591, 2067, 38, 70, "Output",
 Evaluatable->False,
 CellID->657217616]
}, Open  ]],
Cell[55297, 1632, 82, 1, 70, "ExampleText",
 CellID->430163479],
Cell[CellGroupData[{
Cell[55404, 1637, 413, 13, 70, "Input",
 CellID->8273050],
Cell[55820, 1652, 1638, 31, 70, "Output",
 Evaluatable->False,
 CellID->4704801]
}, Open  ]],
Cell[57473, 1686, 126, 3, 70, "ExampleDelimiter",
 CellID->1182797647],
Cell[57602, 1691, 117, 3, 70, "ExampleText",
 CellID->23932850],
Cell[CellGroupData[{
Cell[57744, 1698, 547, 17, 70, "Input",
 CellID->659967961],
Cell[58294, 1717, 1880, 35, 70, "Output",
 Evaluatable->False,
 CellID->150321660]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60223, 1758, 238, 7, 70, "ExampleSubsection",
 CellID->240043264],
Cell[60464, 1767, 87, 1, 70, "ExampleText",
 CellID->578952123],
Cell[60554, 1770, 177, 6, 70, "Input",
 CellID->1854270016],
Cell[CellGroupData[{
Cell[60756, 1780, 426, 13, 70, "Input",
 CellID->348140959],
Cell[61185, 1795, 2211, 45, 201, "Output",
 CellID->974293364]
}, Open  ]],
Cell[63411, 1843, 68, 1, 70, "ExampleText",
 CellID->581884849],
Cell[CellGroupData[{
Cell[63504, 1848, 436, 13, 70, "Input",
 CellID->74187149],
Cell[63943, 1863, 2057, 42, 201, "Output",
 CellID->385760373]
}, Open  ]],
Cell[66015, 1908, 124, 3, 70, "ExampleDelimiter",
 CellID->73873043],
Cell[66142, 1913, 80, 1, 70, "ExampleText",
 CellID->547117279],
Cell[66225, 1916, 176, 6, 70, "Input",
 CellID->988049539],
Cell[CellGroupData[{
Cell[66426, 1926, 426, 13, 70, "Input",
 CellID->75970249],
Cell[66855, 1941, 2213, 45, 201, "Output",
 CellID->1998751499]
}, Open  ]],
Cell[69083, 1989, 65, 1, 70, "ExampleText",
 CellID->122949571],
Cell[CellGroupData[{
Cell[69173, 1994, 439, 13, 70, "Input",
 CellID->603613667],
Cell[69615, 2009, 2058, 42, 201, "Output",
 CellID->2077237319]
}, Open  ]],
Cell[71688, 2054, 124, 3, 70, "ExampleDelimiter",
 CellID->47616072],
Cell[71815, 2059, 71, 1, 70, "ExampleText",
 CellID->210615047],
Cell[71889, 2062, 177, 6, 70, "Input",
 CellID->1355537997],
Cell[CellGroupData[{
Cell[72091, 2072, 449, 13, 70, "Input",
 CellID->839795991],
Cell[72543, 2087, 1864, 39, 201, "Output",
 CellID->485971154]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74456, 2132, 230, 7, 70, "ExampleSubsection",
 CellID->391029099],
Cell[74689, 2141, 71, 1, 70, "ExampleText",
 CellID->1202194683],
Cell[CellGroupData[{
Cell[74785, 2146, 785, 25, 70, "Input",
 CellID->799770335],
Cell[75573, 2173, 448, 11, 70, "Output",
 Evaluatable->False,
 CellID->163577613]
}, Open  ]],
Cell[76036, 2187, 71, 1, 70, "ExampleText",
 CellID->105324452],
Cell[CellGroupData[{
Cell[76132, 2192, 786, 25, 70, "Input",
 CellID->173862713],
Cell[76921, 2219, 447, 11, 70, "Output",
 Evaluatable->False,
 CellID->76389899]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[77417, 2236, 228, 7, 70, "ExampleSubsection",
 CellID->173615003],
Cell[77648, 2245, 80, 1, 70, "ExampleText",
 CellID->701515873],
Cell[CellGroupData[{
Cell[77753, 2250, 363, 11, 70, "Input",
 CellID->692055481],
Cell[78119, 2263, 1521, 29, 70, "Output",
 Evaluatable->False,
 CellID->57949397]
}, Open  ]],
Cell[79655, 2295, 125, 3, 70, "ExampleDelimiter",
 CellID->928090012],
Cell[79783, 2300, 117, 3, 70, "ExampleText",
 CellID->501317172],
Cell[CellGroupData[{
Cell[79925, 2307, 443, 14, 70, "Input",
 CellID->83112486],
Cell[80371, 2323, 1985, 37, 70, "Output",
 Evaluatable->False,
 CellID->19271567]
}, Open  ]],
Cell[82371, 2363, 125, 3, 70, "ExampleDelimiter",
 CellID->306149779],
Cell[82499, 2368, 112, 3, 70, "ExampleText",
 CellID->851891726],
Cell[CellGroupData[{
Cell[82636, 2375, 512, 17, 70, "Input",
 CellID->207244729],
Cell[83151, 2394, 1880, 35, 70, "Output",
 Evaluatable->False,
 CellID->534245747]
}, Open  ]],
Cell[85046, 2432, 125, 3, 70, "ExampleDelimiter",
 CellID->212518288],
Cell[85174, 2437, 114, 3, 70, "ExampleText",
 CellID->222607990],
Cell[CellGroupData[{
Cell[85313, 2444, 508, 17, 70, "Input",
 CellID->34782048],
Cell[85824, 2463, 2331, 42, 70, "Output",
 Evaluatable->False,
 CellID->174434546]
}, Open  ]],
Cell[88170, 2508, 126, 3, 70, "ExampleDelimiter",
 CellID->1720014653],
Cell[88299, 2513, 94, 1, 70, "ExampleText",
 CellID->1115177304],
Cell[88396, 2516, 176, 6, 70, "Input",
 CellID->406578384],
Cell[CellGroupData[{
Cell[88597, 2526, 423, 14, 70, "Input",
 CellID->639873772],
Cell[89023, 2542, 969, 22, 201, "Output",
 CellID->926082854]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[90041, 2570, 228, 7, 70, "ExampleSubsection",
 CellID->267316272],
Cell[90272, 2579, 71, 1, 70, "ExampleText",
 CellID->2609790],
Cell[CellGroupData[{
Cell[90368, 2584, 439, 13, 70, "Input",
 CellID->57263510],
Cell[90810, 2599, 1864, 35, 70, "Output",
 Evaluatable->False,
 CellID->433635187]
}, Open  ]],
Cell[92689, 2637, 96, 1, 70, "ExampleText",
 CellID->1695160959],
Cell[CellGroupData[{
Cell[92810, 2642, 496, 16, 70, "Input",
 CellID->427974663],
Cell[93309, 2660, 1810, 34, 70, "Output",
 Evaluatable->False,
 CellID->36183810]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95168, 2700, 236, 7, 70, "ExampleSubsection",
 CellID->23814162],
Cell[95407, 2709, 122, 3, 70, "ExampleText",
 CellID->98219478],
Cell[CellGroupData[{
Cell[95554, 2716, 399, 12, 70, "Input",
 CellID->472997163],
Cell[95956, 2730, 2918, 53, 78, "Output",
 CellID->395643132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[98923, 2789, 233, 7, 70, "ExampleSubsection",
 CellID->359856620],
Cell[99159, 2798, 62, 1, 70, "ExampleText",
 CellID->32743373],
Cell[99224, 2801, 176, 6, 70, "Input",
 CellID->383393917],
Cell[CellGroupData[{
Cell[99425, 2811, 682, 21, 70, "Input",
 CellID->102307895],
Cell[100110, 2834, 2872, 51, 70, "Output",
 Evaluatable->False,
 CellID->138239839]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[103043, 2892, 223, 7, 70, "ExampleSection",
 CellID->274668873],
Cell[CellGroupData[{
Cell[103291, 2903, 232, 7, 70, "ExampleSubsection",
 CellID->663335023],
Cell[103526, 2912, 257, 8, 70, "ExampleText",
 CellID->1084119984],
Cell[CellGroupData[{
Cell[103808, 2924, 469, 14, 70, "Input",
 CellID->1668948648],
Cell[104280, 2940, 525, 13, 70, "Output",
 Evaluatable->False,
 CellID->765119335]
}, Open  ]],
Cell[104820, 2956, 127, 3, 70, "ExampleText",
 CellID->2124820117],
Cell[CellGroupData[{
Cell[104972, 2963, 468, 14, 70, "Input",
 CellID->1346140456],
Cell[105443, 2979, 591, 14, 70, "Output",
 Evaluatable->False,
 CellID->221880901]
}, Open  ]],
Cell[106049, 2996, 125, 3, 70, "ExampleDelimiter",
 CellID->363002531],
Cell[106177, 3001, 93, 1, 70, "ExampleText",
 CellID->1242667885],
Cell[CellGroupData[{
Cell[106295, 3006, 541, 16, 70, "Input",
 CellID->1465545341],
Cell[106839, 3024, 538, 13, 70, "Output",
 Evaluatable->False,
 CellID->230090500]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107426, 3043, 231, 7, 70, "ExampleSubsection",
 CellID->221411408],
Cell[107660, 3052, 79, 1, 70, "ExampleText",
 CellID->13842222],
Cell[CellGroupData[{
Cell[107764, 3057, 363, 11, 70, "Input",
 CellID->717991278],
Cell[108130, 3070, 1522, 29, 70, "Output",
 Evaluatable->False,
 CellID->144696136]
}, Open  ]],
Cell[109667, 3102, 126, 3, 70, "ExampleDelimiter",
 CellID->1166625332],
Cell[109796, 3107, 122, 3, 70, "ExampleText",
 CellID->946257814],
Cell[CellGroupData[{
Cell[109943, 3114, 478, 16, 70, "Input",
 CellID->1855750711],
Cell[110424, 3132, 2482, 45, 70, "Output",
 Evaluatable->False,
 CellID->101037739]
}, Open  ]],
Cell[112921, 3180, 65, 1, 70, "ExampleText",
 CellID->1638673863],
Cell[CellGroupData[{
Cell[113011, 3185, 548, 18, 70, "Input",
 CellID->1538714088],
Cell[113562, 3205, 2482, 45, 70, "Output",
 Evaluatable->False,
 CellID->454462110]
}, Open  ]],
Cell[116059, 3253, 126, 3, 70, "ExampleDelimiter",
 CellID->1861326313],
Cell[116188, 3258, 120, 3, 70, "ExampleText",
 CellID->482528275],
Cell[CellGroupData[{
Cell[116333, 3265, 474, 15, 70, "Input",
 CellID->554886156],
Cell[116810, 3282, 2892, 51, 70, "Output",
 Evaluatable->False,
 CellID->427741064]
}, Open  ]],
Cell[119717, 3336, 124, 3, 70, "ExampleDelimiter",
 CellID->21555281],
Cell[119844, 3341, 80, 1, 70, "ExampleText",
 CellID->954466853],
Cell[CellGroupData[{
Cell[119949, 3346, 507, 17, 70, "Input",
 CellID->1930194792],
Cell[120459, 3365, 1826, 34, 70, "Output",
 Evaluatable->False,
 CellID->17044450]
}, Open  ]],
Cell[122300, 3402, 135, 4, 70, "ExampleText",
 CellID->1502355071],
Cell[CellGroupData[{
Cell[122460, 3410, 741, 24, 70, "Input",
 CellID->448480217],
Cell[123204, 3436, 2388, 43, 70, "Output",
 Evaluatable->False,
 CellID->301080929]
}, Open  ]],
Cell[125607, 3482, 125, 3, 70, "ExampleDelimiter",
 CellID->697401140],
Cell[125735, 3487, 62, 1, 70, "ExampleText",
 CellID->636484464],
Cell[CellGroupData[{
Cell[125822, 3492, 598, 20, 70, "Input",
 CellID->527153300],
Cell[126423, 3514, 3063, 54, 70, "Output",
 Evaluatable->False,
 CellID->911115377]
}, Open  ]],
Cell[129501, 3571, 124, 3, 70, "ExampleDelimiter",
 CellID->96657118],
Cell[129628, 3576, 82, 1, 70, "ExampleText",
 CellID->1018545094],
Cell[CellGroupData[{
Cell[129735, 3581, 686, 22, 70, "Input",
 CellID->1415183459],
Cell[130424, 3605, 2822, 50, 70, "Output",
 Evaluatable->False,
 CellID->64003698]
}, Open  ]],
Cell[133261, 3658, 125, 3, 70, "ExampleDelimiter",
 CellID->174397539],
Cell[133389, 3663, 91, 1, 70, "ExampleText",
 CellID->1095244621],
Cell[CellGroupData[{
Cell[133505, 3668, 684, 22, 70, "Input",
 CellID->452610656],
Cell[134192, 3692, 2457, 44, 70, "Output",
 Evaluatable->False,
 CellID->504065717]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[136698, 3742, 237, 7, 70, "ExampleSubsection",
 CellID->692489402],
Cell[136938, 3751, 117, 3, 70, "ExampleText",
 CellID->30132536],
Cell[CellGroupData[{
Cell[137080, 3758, 446, 14, 70, "Input",
 CellID->30922498],
Cell[137529, 3774, 721, 16, 70, "Output",
 Evaluatable->False,
 CellID->353732184]
}, Open  ]],
Cell[138265, 3793, 91, 1, 70, "ExampleText",
 CellID->1694006710],
Cell[CellGroupData[{
Cell[138381, 3798, 509, 15, 70, "Input",
 CellID->881279972],
Cell[138893, 3815, 708, 16, 70, "Output",
 Evaluatable->False,
 CellID->72533254]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[139650, 3837, 226, 7, 70, "ExampleSubsection",
 CellID->484677263],
Cell[139879, 3846, 66, 1, 70, "ExampleText",
 CellID->1647424742],
Cell[CellGroupData[{
Cell[139970, 3851, 358, 11, 70, "Input",
 CellID->406535651],
Cell[140331, 3864, 1583, 30, 70, "Output",
 Evaluatable->False,
 CellID->119905746]
}, Open  ]],
Cell[141929, 3897, 125, 3, 70, "ExampleDelimiter",
 CellID->322065365],
Cell[142057, 3902, 74, 1, 70, "ExampleText",
 CellID->760978023],
Cell[CellGroupData[{
Cell[142156, 3907, 357, 11, 70, "Input",
 CellID->717006499],
Cell[142516, 3920, 1697, 32, 70, "Output",
 Evaluatable->False,
 CellID->549429863]
}, Open  ]],
Cell[144228, 3955, 126, 3, 70, "ExampleDelimiter",
 CellID->1031681727],
Cell[144357, 3960, 68, 1, 70, "ExampleText",
 CellID->1356547037],
Cell[CellGroupData[{
Cell[144450, 3965, 682, 22, 70, "Input",
 CellID->1108049723],
Cell[145135, 3989, 2241, 41, 70, "Output",
 Evaluatable->False,
 CellID->26076089]
}, Open  ]],
Cell[147391, 4033, 59, 1, 70, "ExampleText",
 CellID->1799654307],
Cell[CellGroupData[{
Cell[147475, 4038, 680, 22, 70, "Input",
 CellID->1630253401],
Cell[148158, 4062, 1925, 36, 70, "Output",
 Evaluatable->False,
 CellID->703016934]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150132, 4104, 232, 7, 70, "ExampleSubsection",
 CellID->1487836305],
Cell[150367, 4113, 225, 7, 70, "ExampleText",
 CellID->1784441749],
Cell[CellGroupData[{
Cell[150617, 4124, 790, 24, 70, "Input",
 CellID->2010859911],
Cell[151410, 4150, 1632, 31, 70, "Output",
 Evaluatable->False,
 CellID->408040294]
}, Open  ]],
Cell[153057, 4184, 125, 3, 70, "ExampleDelimiter",
 CellID->596672098],
Cell[153185, 4189, 480, 17, 70, "ExampleText",
 CellID->1503345088],
Cell[153668, 4208, 177, 6, 70, "Input",
 CellID->1418344857],
Cell[CellGroupData[{
Cell[153870, 4218, 1245, 38, 70, "Input",
 CellID->306806790],
Cell[155118, 4258, 1786, 33, 70, "Output",
 Evaluatable->False,
 CellID->290415223]
}, Open  ]],
Cell[156919, 4294, 125, 3, 70, "ExampleDelimiter",
 CellID->147237284],
Cell[157047, 4299, 254, 8, 70, "ExampleText",
 CellID->1575787061],
Cell[157304, 4309, 177, 6, 70, "Input",
 CellID->1473278600],
Cell[CellGroupData[{
Cell[157506, 4319, 1276, 39, 70, "Input",
 CellID->1991996265],
Cell[158785, 4360, 1803, 34, 70, "Output",
 Evaluatable->False,
 CellID->293275890]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[160637, 4400, 231, 7, 70, "ExampleSubsection",
 CellID->1553309940],
Cell[160871, 4409, 251, 8, 70, "ExampleText",
 CellID->2017280280],
Cell[CellGroupData[{
Cell[161147, 4421, 594, 19, 70, "Input",
 CellID->1925534591],
Cell[161744, 4442, 340, 10, 70, "Output",
 Evaluatable->False,
 CellID->399843]
}, Open  ]],
Cell[162099, 4455, 382, 13, 70, "ExampleText",
 CellID->2105330771],
Cell[CellGroupData[{
Cell[162506, 4472, 673, 21, 70, "Input",
 CellID->206216578],
Cell[163182, 4495, 333, 10, 70, "Output",
 Evaluatable->False,
 CellID->64136224]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[163576, 4512, 227, 7, 70, "ExampleSection",
 CellID->107368884],
Cell[163806, 4521, 105, 2, 70, "ExampleText",
 CellID->242310825],
Cell[CellGroupData[{
Cell[163936, 4527, 580, 18, 70, "Input",
 CellID->4084833],
Cell[164519, 4547, 16392, 273, 70, "Output",
 Evaluatable->False,
 CellID->12426252]
}, Open  ]],
Cell[180926, 4823, 125, 3, 70, "ExampleDelimiter",
 CellID->676739662],
Cell[181054, 4828, 82, 1, 70, "ExampleText",
 CellID->552757752],
Cell[CellGroupData[{
Cell[181161, 4833, 661, 20, 70, "Input",
 CellID->2014500830],
Cell[181825, 4855, 179177, 4076, 70, "Output",
 CellID->488271208]
}, Open  ]],
Cell[361017, 8934, 125, 3, 70, "ExampleDelimiter",
 CellID->419208933]
}, Closed]],
Cell[CellGroupData[{
Cell[361179, 8942, 230, 7, 70, "ExampleSection",
 CellID->497586619],
Cell[361412, 8951, 257, 8, 70, "ExampleText",
 CellID->1862285898],
Cell[361672, 8961, 176, 6, 70, "Input",
 CellID->311332533],
Cell[CellGroupData[{
Cell[361873, 8971, 384, 11, 70, "Input",
 CellID->2012416308],
Cell[362260, 8984, 1014, 22, 201, "Output",
 CellID->315387712]
}, Open  ]],
Cell[CellGroupData[{
Cell[363311, 9011, 383, 11, 70, "Input",
 CellID->2099287209],
Cell[363697, 9024, 925, 20, 201, "Output",
 CellID->731634788]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[364683, 9051, 311, 9, 70, "SeeAlsoSection",
 CellID->24815],
Cell[364997, 9062, 1199, 44, 70, "SeeAlso",
 CellID->6064]
}, Open  ]],
Cell[CellGroupData[{
Cell[366233, 9111, 313, 9, 70, "TutorialsSection",
 CellID->7210],
Cell[366549, 9122, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[366855, 9133, 166, 3, 70, "Tutorials",
 CellID->25408],
Cell[367024, 9138, 145, 3, 70, "Tutorials",
 CellID->34733876]
}, Open  ]],
Cell[CellGroupData[{
Cell[367206, 9146, 319, 9, 70, "MoreAboutSection",
 CellID->394867901],
Cell[367528, 9157, 173, 3, 70, "MoreAbout",
 CellID->276655669],
Cell[367704, 9162, 147, 3, 70, "MoreAbout",
 CellID->333469530],
Cell[367854, 9167, 147, 3, 70, "MoreAbout",
 CellID->560977822],
Cell[368004, 9172, 163, 3, 70, "MoreAbout",
 CellID->211718786],
Cell[368170, 9177, 139, 3, 70, "MoreAbout",
 CellID->13754033],
Cell[368312, 9182, 142, 3, 70, "MoreAbout",
 CellID->395960379],
Cell[368457, 9187, 162, 3, 70, "MoreAbout",
 CellID->254732241],
Cell[368622, 9192, 173, 3, 70, "MoreAbout",
 CellID->470764760],
Cell[368798, 9197, 178, 3, 70, "MoreAbout",
 CellID->21960512]
}, Open  ]],
Cell[368991, 9203, 27, 0, 70, "History"],
Cell[369021, 9205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

