(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34311,       1075]
NotebookOptionsPosition[     29231,        906]
NotebookOutlinePosition[     30555,        943]
CellTagsIndexPosition[     30470,        938]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       2->"\<\"Redrawing and Combining Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Row" :> Documentation`HelpLookup["paclet:ref/Row"], 
          "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], 
          "GraphicsColumn" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsColumn"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Row\"\>", 2->"\<\"GraphicsGrid\"\>", 
       3->"\<\"GraphicsColumn\"\>", 4->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Combining Graphics\"\>", 3->"\<\"Grids & Tables\"\>", 
       4->"\<\"Layout & Tables\"\>", 
       5->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GraphicsRow", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsRow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsRow"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a graphic in which the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
     " are laid out in a row."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GraphicsRow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GraphicsRow"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["spacing", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]leaves the specified spacing between successive \
elements."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29743]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["g", "i"], TraditionalForm]], "InlineMath"],
 " are graphics, ",
 Cell[BoxData[
  ButtonBox["GraphicsRow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsRow"]], "InlineFormula"],
 " will if possible make them all the same height, preserving their \
individual aspect ratios. "
}], "Notes",
 CellID->14604],

Cell[TextData[{
 "The output from ",
 Cell[BoxData[
  ButtonBox["GraphicsRow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsRow"]], "InlineFormula"],
 " can be interactively resized, or edited as a graphic."
}], "Notes",
 CellID->153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GraphicsRow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsRow"]], "InlineFormula"],
 " by default inserts the same fractional space between successive elements."
}], "Notes",
 CellID->3902],

Cell["Possible overall spacings between items are:", "Notes",
 CellID->10543171],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["h", "TI"], Cell["\<\
an absolute number of printer\[CloseCurlyQuote]s points\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "a fraction ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " of the height of an item"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->419979668],

Cell[TextData[{
 "The default spacing used by ",
 Cell[BoxData[
  ButtonBox["GraphicsRow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphicsRow"]], "InlineFormula"],
 " is effectively ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", "0.1", "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->609767650],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be any expressions, not just graphics. "
}], "Notes",
 CellID->27440],

Cell["The following options can be given:", "Notes",
 CellID->17421],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"], ",", 
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]}], "}"}], Cell[
    "horizontal and vertical alignment of elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width for the whole row", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "what background colors to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what to align with a surrounding text baseline", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the row", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Dividers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dividers"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw dividers in the row", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to draw frames ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "styles to use for frames ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall size of the whole graphics row", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Spacings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Spacings"], 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", "0.1", "]"}], Cell[
    "horizontal and vertical spacings ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->333],

Cell[TextData[{
 "Common settings for ",
 Cell[BoxData[
  ButtonBox["Frame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Frame"]], "InlineFormula"],
 " include: "
}], "Notes",
 CellID->13269],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "frame around the whole row ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "frame around every item in the row ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->5388],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<GraphicsRow\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197391093],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->767650681],

Cell["Display graphics in a row:", "ExampleText",
 CellID->1211463373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{"Disk", "[", "]"}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Disk", "[", "]"}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->772452804],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {13.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {400.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {787.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2050115786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1075630713],

Cell["Put a frame around every element:", "ExampleText",
 CellID->608052945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1818654189],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {13.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {400.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {787.5, -189.}, 
     ImageScaled[{0, 0.5}], {360., 360.}]}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -378.}}], 
      LineBox[{{387., 0}, {387., -378.}}], 
      LineBox[{{774., 0}, {774., -378.}}], 
      LineBox[{{1161., 0}, {1161., -378.}}], LineBox[{{0, 0}, {387., 0}}], 
      LineBox[{{387., 0}, {774., 0}}], LineBox[{{774., 0}, {1161., 0}}], 
      LineBox[{{0, -378.}, {387., -378.}}], 
      LineBox[{{387., -378.}, {774., -378.}}], 
      LineBox[{{774., -378.}, {1161., -378.}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2068382834]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1355764951],

Cell["Set a background for each successive entry:", "ExampleText",
 CellID->986206772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue", ",", "Green"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->898429458],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0, 1, 0], RectangleBox[{774., 0}, {1161., -378.}]}, 
    {RGBColor[0, 0, 1], RectangleBox[{387., 0}, {774., -378.}]}, 
    {RGBColor[1, 0, 0], RectangleBox[{0, 0}, {387., -378.}]}}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {13.5, -189.}, ImageScaled[{0, 0.5}], {360., 360.},
     
     Background->RGBColor[1, 0, 0]], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {400.5, -189.}, ImageScaled[{0, 0.5}], {360., 360.},
     
     Background->RGBColor[0, 0, 1]], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {787.5, -189.}, ImageScaled[{0, 0.5}], {360., 360.},
     
     Background->RGBColor[0, 1, 0]]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1992497049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->935471881],

Cell["Adjust the spacings between elements:", "ExampleText",
 CellID->748124280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}]}], "}"}], ",", "100"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1082133952],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {230, -189.}, 
     ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {690, -189.}, 
     ImageScaled[{0.5, 0.5}], {360, 360.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}]], {1150, -189.}, 
     ImageScaled[{0.5, 0.5}], {360, 360.}]}, {}},
  ContentSelectable->True,
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{184, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1348449601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->946378549],

Cell["Align contents to the bottom", "ExampleText",
 CellID->1520383361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"10", "i"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1942247126],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->10], {27.083333333333332`, -51.25}, 
     ImageScaled[{0.5, 0}], {10, 10.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->20], {81.25, -51.25}, ImageScaled[{0.5, 0}], {20, 20.}], 
    InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->30], {135.41666666666666`, -51.25}, 
     ImageScaled[{0.5, 0}], {30, 30.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->40], {189.58333333333331`, -51.25}, 
     ImageScaled[{0.5, 0}], {40, 40.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->50], {243.75, -51.25}, ImageScaled[{0.5, 0}], {50, 50.}]}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -52.5}}], 
      LineBox[{{54.166666666666664`, 0}, {54.166666666666664`, -52.5}}], 
      LineBox[{{108.33333333333333`, 0}, {108.33333333333333`, -52.5}}], 
      LineBox[{{162.5, 0}, {162.5, -52.5}}], 
      LineBox[{{216.66666666666666`, 0}, {216.66666666666666`, -52.5}}], 
      LineBox[{{270.8333333333333, 0}, {270.8333333333333, -52.5}}], 
      LineBox[{{0, 0}, {54.166666666666664`, 0}}], 
      LineBox[{{54.166666666666664`, 0}, {108.33333333333333`, 0}}], 
      LineBox[{{108.33333333333333`, 0}, {162.5, 0}}], 
      LineBox[{{162.5, 0}, {216.66666666666666`, 0}}], 
      LineBox[{{216.66666666666666`, 0}, {270.8333333333333, 0}}], 
      LineBox[{{0, -52.5}, {54.166666666666664`, -52.5}}], 
      LineBox[{{54.166666666666664`, -52.5}, {108.33333333333333`, -52.5}}], 
      LineBox[{{108.33333333333333`, -52.5}, {162.5, -52.5}}], 
      LineBox[{{162.5, -52.5}, {216.66666666666666`, -52.5}}], 
      LineBox[{{216.66666666666666`, -52.5}, {270.8333333333333, -52.5}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  ImageSize->{280.8333333333333, 62.5},
  PlotRangePadding->{5, 5}]], "Output",
 ImageSize->{285, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1790334604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->570129473],

Cell["Align contents to the top", "ExampleText",
 CellID->294810522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphicsRow", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"10", "i"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Top"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95008813],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->10], {27.083333333333332`, -1.25}, 
     ImageScaled[{0.5, 1}], {10, 10.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->20], {81.25, -1.25}, ImageScaled[{0.5, 1}], {20, 20.}], 
    InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->30], {135.41666666666666`, -1.25}, 
     ImageScaled[{0.5, 1}], {30, 30.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->40], {189.58333333333331`, -1.25}, 
     ImageScaled[{0.5, 1}], {40, 40.}], InsetBox[
     GraphicsBox[DiskBox[{0, 0}],
      ImageSize->50], {243.75, -1.25}, ImageScaled[{0.5, 1}], {50, 50.}]}, 
   StyleBox[{{}, {LineBox[{{0, 0}, {0, -52.5}}], 
      LineBox[{{54.166666666666664`, 0}, {54.166666666666664`, -52.5}}], 
      LineBox[{{108.33333333333333`, 0}, {108.33333333333333`, -52.5}}], 
      LineBox[{{162.5, 0}, {162.5, -52.5}}], 
      LineBox[{{216.66666666666666`, 0}, {216.66666666666666`, -52.5}}], 
      LineBox[{{270.8333333333333, 0}, {270.8333333333333, -52.5}}], 
      LineBox[{{0, 0}, {54.166666666666664`, 0}}], 
      LineBox[{{54.166666666666664`, 0}, {108.33333333333333`, 0}}], 
      LineBox[{{108.33333333333333`, 0}, {162.5, 0}}], 
      LineBox[{{162.5, 0}, {216.66666666666666`, 0}}], 
      LineBox[{{216.66666666666666`, 0}, {270.8333333333333, 0}}], 
      LineBox[{{0, -52.5}, {54.166666666666664`, -52.5}}], 
      LineBox[{{54.166666666666664`, -52.5}, {108.33333333333333`, -52.5}}], 
      LineBox[{{108.33333333333333`, -52.5}, {162.5, -52.5}}], 
      LineBox[{{162.5, -52.5}, {216.66666666666666`, -52.5}}], 
      LineBox[{{216.66666666666666`, -52.5}, {270.8333333333333, -52.5}}]}},
    Antialiasing->False]},
  ContentSelectable->True,
  ImageSize->{282.8333333333333, 64.5},
  PlotRangePadding->{6, 5}]], "Output",
 ImageSize->{287, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115828509]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30393],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsColumn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsColumn"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21033]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21301],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->25408]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->173995853],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->826219436],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->366794690],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->825327147],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->139759762],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->39823276]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GraphicsRow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 46, 45.5054660}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GraphicsRow[{g_1, g_2, ...}] generates a graphic in which the g_i are \
laid out in a row. GraphicsRow[list, spacing] leaves the specified spacing \
between successive elements.", "synonyms" -> {"graphics row"}, "title" -> 
    "GraphicsRow", "type" -> "Symbol", "uri" -> "ref/GraphicsRow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14233, 434, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->197391093]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30326, 931}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2935, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3558, 94, 1576, 37, 70, "ObjectNameGrid"],
Cell[5137, 133, 1244, 39, 70, "Usage",
 CellID->29743]
}, Open  ]],
Cell[CellGroupData[{
Cell[6418, 177, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6896, 194, 386, 13, 70, "Notes",
 CellID->14604],
Cell[7285, 209, 246, 8, 70, "Notes",
 CellID->153],
Cell[7534, 219, 246, 7, 70, "Notes",
 CellID->3902],
Cell[7783, 228, 80, 1, 70, "Notes",
 CellID->10543171],
Cell[7866, 231, 747, 22, 70, "2ColumnTableMod",
 CellID->419979668],
Cell[8616, 255, 380, 14, 70, "Notes",
 CellID->609767650],
Cell[8999, 271, 201, 8, 70, "Notes",
 CellID->27440],
Cell[9203, 281, 68, 1, 70, "Notes",
 CellID->17421],
Cell[9274, 284, 3460, 97, 70, "3ColumnTableMod",
 CellID->333],
Cell[12737, 383, 196, 8, 70, "Notes",
 CellID->13269],
Cell[12936, 393, 909, 24, 70, "2ColumnTableMod",
 CellID->5388],
Cell[13848, 419, 348, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[14233, 434, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197391093],
Cell[CellGroupData[{
Cell[14618, 448, 148, 5, 70, "ExampleSection",
 CellID->767650681],
Cell[14769, 455, 70, 1, 70, "ExampleText",
 CellID->1211463373],
Cell[CellGroupData[{
Cell[14864, 460, 362, 11, 28, "Input",
 CellID->772452804],
Cell[15229, 473, 551, 14, 83, "Output",
 CellID->2050115786]
}, Open  ]],
Cell[15795, 490, 126, 3, 70, "ExampleDelimiter",
 CellID->1075630713],
Cell[15924, 495, 76, 1, 70, "ExampleText",
 CellID->608052945],
Cell[CellGroupData[{
Cell[16025, 500, 430, 13, 70, "Input",
 CellID->1818654189],
Cell[16458, 515, 1005, 23, 81, "Output",
 CellID->2068382834]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17512, 544, 221, 7, 70, "ExampleSection",
 CellID->1355764951],
Cell[17736, 553, 86, 1, 70, "ExampleText",
 CellID->986206772],
Cell[CellGroupData[{
Cell[17847, 558, 502, 15, 70, "Input",
 CellID->898429458],
Cell[18352, 575, 853, 20, 81, "Output",
 CellID->1992497049]
}, Open  ]],
Cell[19220, 598, 125, 3, 70, "ExampleDelimiter",
 CellID->935471881],
Cell[19348, 603, 80, 1, 70, "ExampleText",
 CellID->748124280],
Cell[CellGroupData[{
Cell[19453, 608, 399, 13, 70, "Input",
 CellID->1082133952],
Cell[19855, 623, 550, 14, 76, "Output",
 CellID->1348449601]
}, Open  ]],
Cell[20420, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->946378549],
Cell[20548, 645, 72, 1, 70, "ExampleText",
 CellID->1520383361],
Cell[CellGroupData[{
Cell[20645, 650, 504, 15, 70, "Input",
 CellID->1942247126],
Cell[21152, 667, 1989, 40, 84, "Output",
 CellID->1790334604]
}, Open  ]],
Cell[23156, 710, 125, 3, 70, "ExampleDelimiter",
 CellID->570129473],
Cell[23284, 715, 68, 1, 70, "ExampleText",
 CellID->294810522],
Cell[CellGroupData[{
Cell[23377, 720, 499, 15, 70, "Input",
 CellID->95008813],
Cell[23879, 737, 1983, 40, 86, "Output",
 CellID->115828509]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25923, 784, 311, 9, 70, "SeeAlsoSection",
 CellID->30393],
Cell[26237, 795, 945, 35, 70, "SeeAlso",
 CellID->21033]
}, Open  ]],
Cell[CellGroupData[{
Cell[27219, 835, 314, 9, 70, "TutorialsSection",
 CellID->21301],
Cell[27536, 846, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[27842, 857, 166, 3, 70, "Tutorials",
 CellID->25408]
}, Open  ]],
Cell[CellGroupData[{
Cell[28045, 865, 319, 9, 70, "MoreAboutSection",
 CellID->173995853],
Cell[28367, 876, 173, 3, 70, "MoreAbout",
 CellID->826219436],
Cell[28543, 881, 147, 3, 70, "MoreAbout",
 CellID->366794690],
Cell[28693, 886, 140, 3, 70, "MoreAbout",
 CellID->825327147],
Cell[28836, 891, 142, 3, 70, "MoreAbout",
 CellID->139759762],
Cell[28981, 896, 178, 3, 70, "MoreAbout",
 CellID->39823276]
}, Open  ]],
Cell[29174, 902, 27, 0, 70, "History"],
Cell[29204, 904, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

