(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    221482,       4750]
NotebookOptionsPosition[    211049,       4381]
NotebookOutlinePosition[    212465,       4420]
CellTagsIndexPosition[    212378,       4415]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Labeling Two\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingTwoDimensionalGraphics"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Labeling Two\[Hyphen]Dimensional Graphics\"\>", 
       3->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ticks" :> Documentation`HelpLookup["paclet:ref/Ticks"], 
          "FrameTicks" :> Documentation`HelpLookup["paclet:ref/FrameTicks"], 
          "FaceGrids" :> Documentation`HelpLookup["paclet:ref/FaceGrids"], 
          "Frame" :> Documentation`HelpLookup["paclet:ref/Frame"], 
          "GridLinesStyle" :> 
          Documentation`HelpLookup["paclet:ref/GridLinesStyle"], "Axes" :> 
          Documentation`HelpLookup["paclet:ref/Axes"], "MeshFunctions" :> 
          Documentation`HelpLookup["paclet:ref/MeshFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Ticks\"\>", 2->"\<\"FrameTicks\"\>",
        3->"\<\"FaceGrids\"\>", 4->"\<\"Frame\"\>", 
       5->"\<\"GridLinesStyle\"\>", 6->"\<\"Axes\"\>", 
       7->"\<\"MeshFunctions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GridLines", "ObjectName",
 CellID->24336],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["GridLines",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
     "\[LineSeparator]is an option for two\[Hyphen]dimensional graphics \
functions that specifies grid lines. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18275]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->1221],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no grid lines drawn ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "grid lines placed automatically ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["xgrid", "TI"], ",", 
      StyleBox["ygrid", "TI"]}], "}"}], Cell[
    "grid lines specified separately in each direction ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->11576],

Cell[TextData[{
 "With the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting, grid lines are usually placed at points whose coordinates have \
the minimum number of digits in their decimal representation. "
}], "Notes",
 CellID->1799],

Cell["\<\
For each direction, the following grid line options can be given: \
\>", "Notes",
 CellID->24919],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no grid lines drawn ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "grid line positions chosen automatically ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], "1"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], "2"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "grid lines drawn at the specified positions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["style", "TI"], "1"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "grid lines with specified styles ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["func", "TI"], Cell[TextData[{
     "a function to be applied to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " to get the grid line option "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->14241],

Cell[TextData[{
 "Grid line styles can involve any graphics directives, such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28611],

Cell[TextData[{
 "The grid line function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["func", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["max", "TI"]]}], "]"}]], "InlineFormula"],
 " may return any other grid line option. "
}], "Notes",
 CellID->30209],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFormula"],
 " gives the explicit form of ",
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 " specifications when ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " settings are used. "
}], "Notes",
 CellID->23635],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GridLinesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
 " gives default styles to use for grid lines."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->643683418]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66729163],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->591440113],

Cell["Put grids across a 2D graphic:", "ExampleText",
 CellID->35703158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2133167],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  GridLines->Automatic]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->4407549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->926159991],

Cell["Draw grid lines at the specific positions:", "ExampleText",
 CellID->358495963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pi", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", ".5"}], ",", ".5", ",", "1"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259059667],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533110161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->343832599],

Cell["Specify grid styles:", "ExampleText",
 CellID->279859159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", "Thick"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "Orange"}], "}"}], ",", 
        RowBox[{"-", ".5"}], ",", ".5", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "Orange"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->678318124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62920626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49944586],

Cell[TextData[{
 "Specify overall grid lines style, using ",
 Cell[BoxData[
  ButtonBox["GridLinesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->438049882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369339684],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  GridLines->Automatic,
  GridLinesStyle->Directive[
    RGBColor[1, 0.5, 0], 
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->470399084]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9868],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GridLines Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->392030550],

Cell["Place the grids automatically:", "ExampleText",
 CellID->32797056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246336059],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  GridLines->Automatic]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->357151877]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->567223868],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339728586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "100"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82214486],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->109698609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->877194300],

Cell[TextData[{
 "Place the grids in the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->253308099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->668489835],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  GridLines->{Automatic, None}]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->58004902]
}, Open  ]],

Cell[TextData[{
 "Place the grids in the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->559576256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->624768882],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170910001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52069776],

Cell["Draw grid lines at specific positions:", "ExampleText",
 CellID->157686013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414252241],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  GridLines->{{-1, 1}, {-1, 1}}]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->553483546]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pi", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", ".5"}], ",", ".5", ",", "1"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20797537],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163559333]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GridLines Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->250144848],

Cell["Specify the style of each grid line:", "ExampleText",
 CellID->686813296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".5"}], ",", "Dotted"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", "Dotted"}], "}"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", ".5"}], ",", "Dotted"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", "Dotted"}], "}"}], ",", "1"}], "}"}]}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73856262],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  GridLines->{{-1, {-0.5, 
      Dashing[{0, Small}]}, {0.5, 
      Dashing[{0, Small}]}, 1}, {-1, {-0.5, 
      Dashing[{0, Small}]}, {0.5, 
      Dashing[{0, Small}]}, 1}}]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->214127189]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "Blue"}], "}"}], ",", 
        RowBox[{"-", ".5"}], ",", ".5", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "Blue"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168006648],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13137606]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->860833114],

Cell[TextData[{
 "Specify overall grid lines style, using ",
 Cell[BoxData[
  ButtonBox["GridLinesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->684274320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pi", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", ".5"}], ",", ".5", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523077197],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68540514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->236568718],

Cell[TextData[{
 "Individually styled grid lines can be used with ",
 Cell[BoxData[
  ButtonBox["GridLinesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->88564141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", "Red"}], "}"}]}], "}"}], ",", 
      "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1815006],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142814568]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28391],

Cell[TextData[{
 "Specify a grid function applied to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " values of each direction:"
}], "ExampleText",
 CellID->814353806],

Cell[BoxData[
 RowBox[{
  RowBox[{"grids", "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "Red"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "Blue"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Ceiling", "[", "min", "]"}], ",", 
      RowBox[{"Floor", "[", "max", "]"}], ",", "1"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->778149766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "grids"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->326320959],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, 3],
  Frame->True,
  GridLines->FrontEndValueCache[$CellContext`grids, {{{-3., 
       RGBColor[0., 0., 1.]}, {-2., 
       RGBColor[1., 0., 0.]}, {-1., 
       RGBColor[0., 0., 1.]}, {0., 
       RGBColor[1., 0., 0.]}, {1., 
       RGBColor[0., 0., 1.]}, {2., 
       RGBColor[1., 0., 0.]}, {3., 
       RGBColor[0., 0., 1.]}}, {{-3., 
       RGBColor[0., 0., 1.]}, {-2., 
       RGBColor[1., 0., 0.]}, {-1., 
       RGBColor[0., 0., 1.]}, {0., 
       RGBColor[1., 0., 0.]}, {1., 
       RGBColor[0., 0., 1.]}, {2., 
       RGBColor[1., 0., 0.]}, {3., 
       RGBColor[0., 0., 1.]}}}]]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->358795121]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4985],

Cell["\<\
Put a solid line at each integer, and a dashed line in between:\
\>", "ExampleText",
 CellID->349111521],

Cell[BoxData[
 RowBox[{
  RowBox[{"grids", "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"Ceiling", "[", "min", "]"}], ",", 
      RowBox[{"Floor", "[", "max", "]"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"j", "+", ".5"}], ",", "Dashed"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Round", "[", "min", "]"}], ",", 
        RowBox[{"Round", "[", 
         RowBox[{"max", "-", "1"}], "]"}], ",", "1"}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540529205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Circle", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "grids"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93362669],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, 2],
  Frame->True,
  GridLines->
   FrontEndValueCache[$CellContext`grids, {{-2., -1., 0., 1., 2., {-1.5, 
       Dashing[{Small, Small}]}, {-0.5, 
       Dashing[{Small, Small}]}, {0.5, 
       Dashing[{Small, Small}]}, {1.5, 
       Dashing[{Small, Small}]}}, {-2., -1., 0., 1., 2., {-1.5, 
       Dashing[{Small, Small}]}, {-0.5, 
       Dashing[{Small, Small}]}, {0.5, 
       Dashing[{Small, Small}]}, {1.5, 
       Dashing[{Small, Small}]}}}]]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->435915735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24279925],

Cell["Emulate graph paper: ", "ExampleText",
 CellID->580509667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Pi", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "grids"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Lighter", "[", "Yellow", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19468640],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126732108]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5537],

Cell["Grid lines are placed on the major ticks by default:", "ExampleText",
 CellID->213162192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->233133251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    Frame->True], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    Frame->True,
    GridLines->Automatic]}], "}"}]], "Output",
 ImageSize->{330, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->100027963]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->131884689],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->544326031]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139568862],

Cell["Grid lines are always drawn below all the graphics:", "ExampleText",
 CellID->41243122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->458891805],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
  Frame->True,
  GridLines->Automatic]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->148752209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119717961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MeshFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshFunctions"]], "InlineFormula"],
 " can be used to draw lines on top of a certain plot:"
}], "ExampleText",
 CellID->50572099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140106823],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylvQd8VNeZPjw7EthOYjv5J5uyTrLJfptNthiMa+KUzaZs6qUYg40rvYsi
hCQkgYR6n9416hK9d4MB03sHgZBQRdKojuqMNPf5fd/7njsj5EH4y+6f3+FO
veee8zxvP+eOpFkRC+eFzYpYNGfWD/4QPmvFwkVzVv3gv5eH01shf6dSqfbS
f+23VfT8/6Vn4v9eAPTBiGM0HUPoo5+JV7F85JcQ/1Svf8G7a+ioHj4zJug7
b3zBmYFrPu3vYbx4N5GPoY++q1KN+1+9H//Y++qgUfyHeDvOPwpV6Lx585QP
n/jdGP9I+VPuWhWifFs1PPoof2+hI66u9Puy+Hy1v4dnRP/0ib+DCeJxqr/f
FwJj8vfPx6dFj8oZyrsviYe3R4yUT/m2/9znnvD9aUEz+3v/iL7GL8YMf9/f
mzKr6UHnfM1/ja/zi7EjrzGSgeCznvdf6Zsj5s5PR8d66mP8Pee/6reDzg8J
Ov/fh3Hhqz3rf3wh6KzQoLP+TZw103+N7/1N3/7I/+1//IIRMYrKiN73f/uf
gr49JqjvfxXfnuEf94+Cvj026Ns/GcY6WGL+OejMp4LO/PEwzsMSO+LT/+dv
Ovtl/9nf9Y/2xVHO4veVUb4S1EdAVscHnfVM0Pd+NOrZ3/T3/UrQ2U//TWez
7LJ4vfr/c+1QjJCIx3r5mn8Mr47E36/WXx6lp5GvvztqjwEpfyXQ4xjjrBrj
rAeGmQ/oBduSL/uvGSwJ3x1mRO3XFnWQREwIvPe0aU6dcU6tcXYtdW6YWTPc
+bNBfQbrlnKN/wwao9o0t15tnFOnGks9GkSP+kCPzwX1EKztSo+/CJ71M+YF
jeb5jSZq8xqMc+uNc6jVGWbXGWbVqtT6mTWiDz/SwaMe/RpvjuBKQcGyqMm8
ULQFD03U5j80zms0zm1QG+bUq8bSxfSzavUza3Uza3Qf1/jnErD//Ph90e8b
wWhYFreozYuaVc+ZFzabFjaZFlB7aBSdG+Y2UN/62dTqdLOoZ+48gPvnrN0P
xcNro7D4UgCjUOvSVgu1JS5qavPiFlWoeVGLaRFdlJvauKBJ9Yxh/kPD3Eb9
nAb9nHrd7HrdLL6udmYtS9JXg3ASdkxohtov8aNZhn8fvr5tebt1Wbs1rM0S
1qamkdD1l7Sal7jMi12mxS61aVGL2riwWfUl44Jmw/wm/byH+rmNujkNyjC0
1GbW0TC+FtS/gur/eQyRf8AjfReYPGNb2Wlbwc26vMO6rMOyrN0SRq3NvLRN
paahqL5mWtJqEoMxLqLWYlzYYqC2oFlPw5n7UIylQTu7XjuLWp3iqFXB4/ne
E8bzLT8OARuo+op9ldsW7rat7KJm5VF1WpbTqHhg5rB2GpVpaZvatKRNNYbG
ZVws2iKXYZFLpaZhqUL185t185p0cx9q5zSEaGc3CLvkZz3gPf/xCaMJ+PHh
0TzjWN1LD/aIHtuqbhqWdSU1GlaXZUUXyejyTtUY87IOc1iHKazdtJRamyrE
SGN7mkZloLaImku/0KVf0KIT4wrVzmkcOaJgnL77hJH9nxE4KbzlRfc7ovod
kX32yD56beMh9lhXdVvDu2lkK92qp2iMZmrLO83LOk3LaIgdxrAOldq4tJ3s
4ZJ2GqeB2mJqrWQNFrWqQnQLXboFLdp5zapQ7dwmMU7N3Icq//VHjvOFJ4zz
+WA+Q/JiPI41A47oAZXaHtWveoqGa1vNI7ZG0HB7LOHdlpU0YjON+GnzCrd5
eZeJ2rJOIzUa8dIOw9IOtWFpu9qwpF2tX9xGDC9q0y1q1S1waee3qGmwag0N
WIyVHp841oBGBnzDhMAIn3euHcqLG8yL9TpivI41Hnv0gD1qwBbVb4ukpoy0
17Kq1xLeYw4XI+1Wm1a4Sf6Wu43Lu4zLuoxhnYawTlUIjVT1tH5ph35JO7fF
7brFNNI27cJW7QJXqGZ+izJKevSPUu33+irVD4JH9fX8BNkZLzvX+fLW+vLi
hhyxgzQ8+xqvLdpji6bhDVgjqfXTVy0RfZaIXvOqXnN4j2llD3kSAvQp04pu
4woaoJsGaKAW1qmnMar1Szvpf4dqrH5Jh44aD7Jdu6hNs7B1jGZB60jZ/HoQ
jt8RI/3+CB0RkvjNgiQ5P1HOXy87E+S8eDlvnUxDdsQN2WOpDdpivLY1Xmu0
xxpFbcASOWBZzaM2R/TRkE3h1HrUxpX0f0W3KtSwvNuw3G1Y5tYv61Lrw7qI
7bBO3VJ/U9OIVSHaxR3axe2ahWQC+CAwpUeV6gkjfuExxgtS5IJkOT9JdibK
zvVyXoLsiJcd62THWtm+1mePG7LFDtliBq08bi9pU5RHFUoDN0cO0NmmiH61
aVWf6hljeK9xJbUeA7UV1Gjo3frlNHS3KlRHYw/RLe2iUWuXEu7aJZ1i5JpF
7dRUoXwQI6dH+veNoJGL+FyMXz1y5F8uzEBBGgpS5fwUOT9ZdibJeYly3nrZ
IaZgXyeTlq2VVc/b4nw0B2vMkGXNoCXaa46i5jFHevxTWN1vjOg3ruozhFPr
Jcu5sjdEv6JHFaJf3q1bRs2tUuvC3DTiMLc2rEu7lKwdHdSaJZ0hmsWdIs0L
0dC8Pm9Xg2MGZRYBG/9SQGKeK8pGYRYKM1GQgfw05KfCmSI7k+U8MR3Hetme
INvjZds6WW2j2TxljZOtsT4Lz2bIHD1ojvaaoogXU6RHNZb6M64eMEYMGFb1
G8SMQvQre1VP0XR01JZT4ylpuSkTIrFZ6tYs7eK2hI8qNc1HrQlzqzX8FXqh
Xd6t+lz8t60uEDnwa0WunvbPK3jWar+/V858lJ/+R4DFrxZpUJSLwmwUZKEg
E/kZcKbBmYq8FGqyI0l2JMp2gYItXrYSClZGwRInWxgFnzlmyLxmyBQ9KFAw
RnrJnq/2UMcGQiFiQL+qn/Q8vE81RreyT7eyV7dCaWQZtMt71IQEIbCsWxNG
zS1at6L2IZrl3ZrlPRrxTTqEalf2MBjh7AO/wrN4SnpxLj3fUQ8CpOw28s6J
mQUjILLTx7KAkMe8RQhGRGZ+oP51OBIoNvB3irQo1KAwFwXZyM9CfiacGchL
Q14qHClQO5Ip+bMnyrb1si1Btgq4SGMJr7HmONkcS81nivGZ1gwZo4fUxqhB
ikkjvYbVXupaH+HRM1wDal14v5rAUo3VruzTrujltryXoVjWQ6D0hAj5YEQ0
K3u11ML7qKm1q+h/RP9Im/klnhGDxHK5pZoxcpyD/tBo9RCedKjfZz6qhwRn
C6Ojphoz/I4CnepfArh9s8SCEhOKjSjSo1DHZxRoUJCL/Gw4s+DMRF4GHGlw
pMKeAnsybEmwJYIAtCbIlnjZQvJmJvyeJfxMsdQYP+MaH+FniKI2qI+k5sdP
F+EhS0EIasMJB+3KfgFgH4kSHcZoVvTOC/zTELyhGpLKEO2qfkJNG0ERgXb1
gGqMNnJAF+nRRXl00V6eyTCGTzOGD1ByE/ZT0O5H2kbEO56E5MhawfP/Q/lT
zn+Uv/4wIJffKXWg1IYSK4otKDKhyIhCPQoEqPm5cObAmY28LORlwpEBexrs
qbClwJYMaxKsibCuh2W9bI6XzSyVJpZKU5xsjJWNMdR8hjU+Q7RPrY8aUo0h
VHXUhGAKVLWrPKHa8AG1Jrzfr52E26oBaqSYEXxYPaBd7dFGerRRHjVhpxqr
W+PVrRnUxQzqYof0cUN0lqg4PEtdEp5Ko+cEqO0UNPuQugHrbIjKDdg2Biu4
kvLc/xDL0CAsvxeQyxdKnSjNQ4kdxTYUW1FkRqEJBUYU6JGvg1PDveTlIC8b
jiw4MmFPhy0NtlRYU2BNhiUJlkSY18OcQE02MaJGQnSMMU42xMqGGGo+/Rof
2b5oH9m+qCFdJLVB7epBYaO0EV7CzcNDC9EwfpoID+MnIAzRkkR/RRvl1UZT
GxQoDhGKulifLs6nX+vTr5P18TKdO1wx8MMpJPUZjhJPIncvUsoQa0FEFsLi
sWD1qNYxOBd89n+A8OP9PEL6OwGk/6msGGWFKC1AiRPFeSiyo8iGQgsKzSgw
Id8Apx5OHfIE5I4c2LNhz4ItE7Z0WNNgTYUlBeZkmJNgToRpPUwJMMXDGC8T
4AZqcbI+VlbrYwh93RqfLpqbNoraEOEcOSTGrWXovZrVXh7iUxrCN4TxjRok
fOlbdAjRrhnUrhnSxtBZBLTqGV2crFsr6xhq6NfDkAhDMg+RxX8YtZG4f4nD
X4F7chlizFidIy9bL89fjVlL5CfZ0seQD9TOx35Ogh99a0wQzoGameoH5eUo
K0VZCUqLUVKI4nwUOVHkQKEdBVYUWJBvRr4JTgPy9HBo4RCA27JhE2hbM2BN
hyUNllSYU2BKhikJpkQY18OYAEM81IZ1dGX9WllPwMSSvOsI8RBCXEuNhDzE
fxgi4BkjtQBKQyK8hpsmejBUQx6P3hnU0JfWcFNrY3xqLaH9nJY6ZcChWwd9
AgOuJ8BTYEyFMR2mDJiy/OCzBI8N4J1DYJcjxoLwDDlsvW9BlG/mEvn92UNB
yI0m+Qrefx/07lNB+AZyXdV3yzehbANKy1FSipISFBehuBBF+Sh0osCBfBvy
rXCakWdCnhEOAxx62LWwa2DL4etbs2DJhCUD5nSY02BOhYkiBmMSXZJFiwSM
Zk2SRtMnENZS5EZ4UOgeK2upxXBTE9LkoWIYccWPiXkRmoRqzKA21quNHdTG
EM6ErCbGp/p7gpbPjhNNYKuLh06BN5nl2ZAKQxqMmTDlwJQLMzWd3wBz9wLn
r9Dr7D1IIqG2YkUGFq3FvMihmWGDM2YNvfvBwLTpPapHFbTAo6hEDVeLg31i
QLIDq0UjEQ/kxKp/3rAd5VtRthmlm1CyAcVlKC5FUTEKi1BYgIJ85Och3wGn
DXlWOMxwmGA3wq6HTQebFlYNrAJ6cxbMmUKGSJLShEilwJDEKk1CxlgkQE3A
qAkf1VOEk3ZtALNYWUONBV0UasULH3VJR03MkCZ2SLt2ULtuULt2SBvn05Ag
q+krag0xN4b7WQdtvB9y8gTMNcGup4tnMObGLJiyYdbSZxYjqbbFBKsNtryA
lRHoP0cv1pciyoTl6VgYh9nh+HCRb8Zs77T3Bt6e1jN1cucwrMESLuo5SlX5
c7ZbyPjnYjaG+8tBPHxp2IJv2I3yXSjbgbJtKN2Kks0o3ojichSVobAEBUXI
L0R+AZxOOPOQZ4fDBocFdjNsRtgMsOph1cGihYWkKwfmbL4csUF6bUwTEpjC
0ijwGUuE6KitFy0BWmKGICS7so5Z0az1M/F1gliz1ieazM9j2cRqiANiIn5I
mzCoTaAnPs06PkfhgfrSrme9SqT+dEl8TX0avTakk9AZiA5SAS03sx4KFVYH
bE7YC+EohWLs6dpjAjqxxorlGVgQh7kRgx8u8b4zyzt1xsDb0/vemtw1+c+t
o0QvXx3hOpV/wnKPUV4/YuKpzzPm16FgfgK6pfqnjQf4tPK9KNuN0p0o2Y7i
rSjegqJNKNqIwnIUlCK/BM4i5BUgLx8OJxwO2O2wk7RZYKW5GmExwKJjYTRr
2BKQPTAKi0uiSgARUGp9KuOWAl0yCD3CkQ6hBKY2kXGlpiaEQxSrv1bOFY3w
D9HEy6qv0hN6yRzRm/E+7XqfNnFImzSkTaTnMlOTyL1y3yQNqXQ1oubrerp4
FhNjzIWRxqWH2QSLGRbiJg+2AtiL4ChD3iY4tyF/1yOSVCEB3Vljw4psLFiH
meG+j5Z6Zsztf+u9vslTe4iltyZ1TP5Ty8TfNo7iZ7/6RbrzGDdfCeImJKA7
P9xwCOUHUbYfZfv49JJdKN6Bom0o3IrCzSjYhIINyC+HsxR5xXCQpNGcSORo
ciR7NEsrLBaWRrORxdKkY/kkJAgSQzZjI6SIYKKYPR26NOhSuWlTaJBa0ilt
UoCR9dAkIDceueugzqVw9V9z42VNgqxZL1qCTC+pK36T6EjyaZN9upQhOmqT
ZK0ghTqnS9Cl9JnQZ/G1DcSLlkkxGQQvNFZ7gJcSOMqRtxnOHcjfg4IDKDw8
GjvLs7EwAR+HYwbZtDn90z/omfRW98SJnZP/0jblz64pf2ye9Jt61aMKxpMs
2hiMHi2N5GVY33644SjKj6DsE5QeROkBlOxHyV6R3e9C4Q4UkCRtgZNEaiPy
aA5lcNBkitkM2PJhdbJVoHmSCJotMJthMvH8jXoYdDBoYMiFPoetPZm5MTpB
kC4TugzoyMyotWlMjCBIkwxNSoAdep4kWiKxQ0bqm7kJyCGyiBdqRFCirEni
Iz3nz0mPkqBNlrWpPl26T5vm06bK1LdOYSebqVHTYFQ/IoJoaCYjj9RMBDlg
zYetCHaaFs1vKxPk3Iv8Qyj4FEWfoegMii48YkrJ0ZZlYd46fLQK7y6Sp84c
nPJe/5S33ZLUIf2pdeLvmyf/tnHy7xon/bpWpXp8DfO5L2AseIXvc6ucP9lw
AuXHUXYMpZ+i5DCKD6H4IIr2o3AvCkmidou0dzucW1nMHJtg38CTspXCVgxr
EawFsOTDnAezAyYbTFYYLTCaYDDCYIBeD70Oei30GuhyocuBLhtawZZam8kc
ZUCbDg21NCgVF1KpEE0qc8ZP1bmUDITkJiE3ETnsVfjwZi4RlCTnJsuaFFmT
LJ4nCbJSwKSny7oMWZcpU+csE9ksKSwyOubIaBSiRDJFwpUHK4lbCezlPLW8
bXDuRv4+FBBNR1F4AkVnUXwRxddQfAtFFSM0S6VakCh/vBrvLMI7c7xT3++f
+FaP9NcO6Y+t0u+apF83TPxl7aRf1kz+1YMnchXwK4HH4KhiOC74UdkplJ5E
6WcoOYbioyg+gqJPUHiQtZ3G6tzDg3buRN4OkdlthX0zbBthLYe1DJYSWIph
LoSpACYnjHkw2mGwwWCFwQy9CXojdAbo9NDpoNNCp2HtyWVmcqDJhkbhSpOp
aFBIbhpyU7mpxtBBnUsUjSOKcqglISdRHJNBzOQSM6lybio/oW8SvdQPs51J
/Mu6bGosESQXJCAGQYvRzOJDokQCxZJFtGyEYwvytiNvF5z7kX9Y0HJS0HLp
ES2FlcivhP2uItFfpYHOXCO/u1SeOnvo7Q/635rWPYl06A8u6ffN0m8fSr+q
lX5aJb1ROfGNe5PeuDsKP0rG8g0/L4GKr+pfSs+h9AxKTqP4JKtw4XEUHkXB
ERQcZr12HkDefuTthWM37Ltg3wHbdpGQbIF1EywbYC6DqRSmYhiLYCyAIR8G
J/QO6O3Q26C3QmeBzgStEVoDtHpodFBrKGgdq9FAkwtNDnKzkavwwVyMyc1E
bga3nHTkcISVk4oQfjKGWKJHesmNtYg4UfOTN+kNpjBd5pYmFC9DMJMFIpxV
VMNiQHprEIQYrTDZhXoXMCEkUSRa9i1w7OCpMiefoOCY4OTcCE7uoOAOc5JX
CfMtzltW6LEghUsp7y6TJ8+WJ7/vmTKtZ8qkjolEy29JYRql3zRIv6qRfnZf
eu2u9ModacItv/Ua3pP1ufUS1YjMRvXD0osouYDicywYhad5NAUnkH8czqNw
foq8w3B8AsdB2PfDvg+2PbDugmUnLNth3gbzFhEnb4SxHMYyGEpgKIa+EPoC
6PKhy4POAa2dtcLKWYsFGjM0RmgMyNUjV4dcLRsoUpuxObkYrnxyLpdJmPN/
AjgkOx3ZadzoKVk6YkwVmiPeyE7lpmbe3qS3c9MFqZkysUvKpxFRPCmkVssa
qjew2hIppMUmQQqpNik480KmeZvgZQ/LIusK8XLKz0vRVRTdZF0pqkTBfTjv
yxbBy7pyrDRhQao8K1aesYIJkt4fkqb1TZzUNelPrdJvmqT/bJB+USf9okb6
1QPpZ5XSq3ekl29JL90IxGjBUcBwRSW47jJyhWR4DeBfiq+g+DKKLqLwAgrO
If8s8k/DeQp5J+D4DI5jsH8K2xHYPoH1IKwHYNkHy16Yd8O0E6YdMG6DcSsM
m2HYxDjpy6Erha4YuiJoC6EtgNYJTR40DuTakGtFroVslpm4yjUix4AcPbJ1
yNYiW+OPELJzkJ2NLKFlIVmZTFcmsjO4qUKz0jE2m5lj2tK5EbfMsepnpJek
naSjpKxElVZk9zojW1gD+UPyjflMlZnMcRmsGwRbW+HYKbRoBFuFZ1FEWnTd
r0WFd1FYxWzZK7jWojmChM2IsGFhBmav9X0YPjRtwRARxrRN6pb+1C79pln6
VYP0czJx1dIb91mdfnZPevW2NOGGNP6a9OIV1Si8iYxHiRQ+FzuEPvbOaJyq
flx4FQVXkH8Z+RfhvMDrQ46zsJ+G/SRsJ2D9DNZjsHwKyxGYP4HpEEwHYNwH
414YdsOwC/od0G+Hbit0W6DbBO1GIfFl0JRAU4zcQuQWIDcfuU7k5CHHjhwb
skkV1dlmZsKEbCOyDcjS+z1UlgZZudxU6iwKEEMyhQZlcrBBB3UWMZZJHIYQ
mfQ8i5WT38vm//Slf8rJQg7ZWbK2uSC1JitM5pjsss4sJIxcp53dqEkhk5zs
Rti2sK2374RjL/IEmfnHUCBUryigesUVKK5EURUKquC4OyCQ+7bhMyTvQHQB
FudgVrz8QcTQu4sHp3zklaYNSJN5GU76XQvz+cs66c0H0mv3pQl3pVcrpNfv
SK+SDl6Txl1RKA3eufelv5lRNR6tZ4oxfctxCfaLsJ+H7RysZ2A5DctJmE/A
dBymYzB+CuMRGD6B4RD0B6DfD91e6PZAuwvandBsh2Yrcrdw3EYK+XTuBuSW
82VySpBdhOxCZOcj20lI57E62ZFlQ6YFmWbixOTnL1OHDC0yyKCGZORCncEc
ZmQjQ8nBxmSwTmZkIFM0+jodniZis5SWxepLSky2OEdDuk7G+XUy0mSttSbh
YG3scg2i9kNOmLwxuWULRUsjKTwI5xF2HwXD+ii8mp/C+3LBfTn/Pqdx+x9i
wx1GiZ7HlCBMj1mJ+CDK987SwbdmeaXpHmJR+nMHE/mfjdLPBYs/r5Zer5Qm
3JHG35Reuim9Qop5VS29eDm4+jyc7/7NPD62TvADem0+D9NZGM/AeAqGkzCc
gP44dMeg+xTaI9B+As0haA4gdz8X1HP3IHc3cnYiZzuytyF7C7I3I2sjsjYg
qxxZZXylrGJkFiGzABnEYwbzmOFAhh0ZNmRYlBg+3UAWNl2PdB3StUjXIC0X
6cRleg5C0rOVcaZnIp11kg5qhdMsZIqmUpPKCt39RXYuG+ccnXC15HDJ7VKA
ZAa5Yh1FTU4YCjiaYv9dCvMGWDbDug02ir4UFgOKWHguwOJNlFSgpBLFVSiq
ZiLp3NOdONyC7VVswnKPcG8rrZibhg9jfDOWD749xzPp3QFpSq/0l07p9y7p
1w+Zzp89kN6okn5aKb1xT3r5tjTuhjROqOP4y8Tlpccr3Y9eP/M/4nR4v+o/
slE8De0paE5A8xlyjyP3KHI+Rc5hZH+C7EPIPoCs/cjai8w9yNyFzJ3I3IHM
bcjciozNyNiE9A1IL0d6GdJLkV7CV0gvRFoB0pyEeZqDOEuzP4pgUs1INUKd
SlyOSdUjVSeaFqmcIaQSm6mU+6YSU6lZyrjTsqC0kPQsv87mIJNz9Ewyxr/K
JLtMTcsel/xujhG5JpAv1lBEZeUIi0ItPcXEhRx/USBm2iCi5wCdFL7lHYGT
6DwplJKysqu8Suyn088on3LV7b3gxmft2NfAS/HGk0jeicgC/uiDtfKM8KHp
CzxT3idG+6S/dkn/3Sb9ukl6s0766QPm9dV7wsBWsIEdd10ad1UadzlUevHi
SAaD84VAFSrkf8yskI3vs1J9hqzjyDyGzE+RcQQZh5F+COkHkX4A6fuQthdp
u5G2C6k7kLodqduQuhWpm5G6CakbkVrOC5ApJUgpRopQhpQCpOQjJU+xqE8l
W5FsQbIZySYkG5FsQLKeWEmmGCU0WYtkjWjEaAr/Jx1NzVHmR+ym8VNxIOUl
HRZ2OZOs6o/JTmfp2O2S880xIcfM8ZXGxrGWNo9DZ/0wkxth3gzLNrEOthf2
AxyRE5P5FKZTvD7M5B2U3ENJFUqqUSyYzK/ouun2Xe3B6Q7W0K2VpE3sBL72
1scDE9/ukyS39AcR8vyiXnqDFZIZJMv60i2OUV+7KVzkZWncJSaQ9PICF8Qu
+hOIYJ/JvPFtP3/Hj5+LZJ8U0Qr2XmCcjiL1U6QcRsonSD6E5ANI3o/kvUja
g6TdSNqFpB1I2o6krUjcgsTNSNyExA1IKue1nsRSJBYjsQiJhUgsUKpnzNrT
iXYk2pBoRaIFiWYkmpBoRKIB6kQiLzRRhyRqWm7qJCaFCCQaU1g7+RBKZKaK
xj3SQwgZYWKRXKsOmXpmkTT7n7OMyKIQyowcCwdWuXYOl7X5HEDrKRMqg3ED
TFtg3s4Jk3UPk0f95R1F/gkUnOGovYgi+BsouY3SeyitFPw9EFW++0O32lpu
d/Xd6B681I0TbUp88ZT+MyRsQ7gDczIwYw3b36mzPSpl94/0mxbpl43SGzXS
a1XSa5XS6/eY0fHCuBKXE0gbL40RPD5iIZjH0Md4DN4hKM74Fr1O+AQJh5Bw
AAn7kbAP8XsRvxvxuxC/E+u2I34b4rcifgviNyF+I+I3IL4c8aWIL0F8MeKL
EF+gFD3FGk+8HfE2xFsRbyEGEjg2TTAhwYgEAxL0UK9nyIk6Io6aSp2o8KYm
BQxNIX3ifS9kWv1NizRynHpkGBBCkZHqBQqRsswc93IA7OBgWFPAKQ7lOnpK
Wil73QzTNj9JNspzPwGRxDpE6fB5FF3mnKLkFkorUHofZdX+2H1sSZW3+Hbj
7daGis6u290D13sUlr6y7T4cF9j8RJdggRbvrcP0cM5AprzXL03qkf7UKf3O
Jb75JenVKunVSumVCs7aX70tiplXKZ4hVyiNuzhWevH8F3nDgCUMGZUp4Su/
Tq9j9yN2H2L2IHY3YnchdididyBmG2K2ImYLYjYjdhNiNyK2HLFliC1FbAli
i/3sPB3nRFwe4sQuorV2rLVirQVrKeZcRyyNWWdCvBHxBtHYLiawfhFd63Wi
EU/ElSqUdU3HlpNaSIpOYSxF53eMaRTtGJFh4nBWnUnpybezrBzdUqDLuUsh
NJSRlkBXBv0GzleJK0pfLbth3Q/bITiOIO848k9xDkzdUqTi56pSqQ2W1ZDE
llZ2X6+/cael+m6H6273wO1eVp6T5OfqUXIdus9YXMOs+DgV70T53l7infIx
7/uU/tIl/b5V+s8m6Wd10qvVCu9PSRMoJ6To86Y04bqgTNhIMo/nydud+yL9
Co40/27Y6z1pBTqw501kJc/Tk9W7sXoXVu/E6u1YvQ2RWxG5BZGbEbkJkRsR
tQFR5YgqRVSJn8HnKUOKzscaJ9bkYY0DMdTs3H2slTfexJoRa0KcCWupGWmE
a8myha7VY50O6/RMquB0bEKAUGpsP4lH8oWqH6aIPYcpenAzcNSTZkK6hSPa
TEpRqDk4acmhNLSIs1JtOXQboN8Ew1YYd3AxwrKXyxP2w1ywcJ7kKgZ5NcUw
Us9l9/za9nR5LcpruJVV8nJyRdPde22N97u6xKdfv+jG8VaOQ/MusuZFlmC+
BjPWytNWDL1FQeg7vC2dHd5/NUs/r5deeyC9XCm9fFd6ucK/vskm8uVrgs2L
rHZkKc+R1zsbzGagEvN5K/l4lPLUY++IOtyX6cmK7VixDSu3YuUWrNyMlZuw
ciPCN2BVOVaV+Vl7ZlUhIgqxugCr8xHpRGQeIh2ItCPKRnhE25S+15ixxoQ1
FGnG8Np8rBFx1AyI0yOO7eRaOoQoLLJ2hiRw1EI0sik1IInOo5BG9T0m0Ail
UeSaZkG6jbOSzDxkOZGVz7lnTjE0pYK9TdBvgWEbjDth3gPLAa4v2Y9y0cl5
GgXD5vK2IsqqH22owYY6bKjFhgdDm+41XK29XPHwVmVrTVUnb+u/2zt0vRtn
O3BIpIOUZSVsR5gNH6TgncihqYu8kz/op0SQ2fuNS/pFo/R6jfSyyOUpVnlZ
6OG4a/wpWczxl0QZipgLDWJuJBvK8VHM+QTugio1Yock71FdsglLN2LpBiwt
R1iZEiV+Y3kxlhdhRSFW5GOFEyudCM/DKmoOrLJjlRWrLIiwYLWFu48y806J
KCOiDIimmGQNqVBIjAExesQwa7HMGvHHSsg2lan7YbyOKSRVXG/gWCbJJAJS
UVahJymUb1iRZkM6pZN5yMxHVgEXDXJKkFsGzQZoN0O/DYYdMO2GeT+sh7gw
6DjO1cL8c0Lhrvr1LLSsEhuqQaxtrFXuN/7+lZpLdxpvVLZUVrfzQmdVr+du
H664caodu6q5fJX5CSJLMZddnW/6isG3Zns4wvyLW/odbzGQflonvVwlTbgn
vSTCy5duiIoa+blLyhVJ34TinfPrHL1xJjgqUXbQY3jX85i/We+G7xiaX4rh
PV9PLyzCwkIsKsTiAizJx1JqTix1QB1GxvHLy2xYbsMKK1ZYsMKMlWaEm7DK
xN1FGLGaCFOvZk8XqUeUHtGiqdewdsVomUSikAhUE4NqpvAFps6A9UasN3E8
mqTwZkGKFal2UPqY7kRGPjILkVWMnDLkboBmM5f19Du4ymfaC/NBWA+znjlI
z874dWt86W2QgSy/j40PsKkOm+qxmVrt0JYH3fvu3rz84MKdhuv3m249aK2m
b9f09FT1DVb04XI3joqMwHIW63dhWR4+SpPfjfJNXeid/N6ANLFH+kOH9Gu+
NUh6pVp6iXirkF66zaEkkUZ28qWrwkheYDvJi3pnFfY4SzhL/8/Q/9Of33/A
WhK8KzD0CQyO9IYBzVOqWzMLMasAsylyVM/JJ22c68S8PMxzYL4DC+xYaId6
EUUPYxZbsMSCpWaEUSPS1MvIyoUsF55qJXMXTrysYi2L0GG1DpGsdVHEVzQv
RxCNCoMqNdlR1XdYDQ3cKNKhqHS9mZOKJKtwew6kOpGWj/RCrutklSCbuNsI
zRbotkO/C8Y9MO2H+RCsn8J+3M/ai0UiZSu7g/JKbKzGplpmbUs9tlKrG9z+
oP1Y1Y3LDy7dbrhx/+GNB667tR0N9e7Wmt7e6n7c6pEvdOGTRpTfhuYYYjZh
nh4frie1G5oy0yu91S/9uUv6rbCUr9UwOy/dZe5I7cZf5xrLOH9sydwN+zfB
39nH+RuuZwTvf/si7r4o3vmyn0theb9K77+fhw8c3D604yM7PrZhphWzrJht
wRwL5poxz4T5JiwwYiF5q0VE3jOL9Viix1I9wsQ6wTIdlmuxQouVvEctnA5P
rdIiQovVWkRqEaVFtA6smmqyr6pvxhrYQVKkw6GrGQkWrLdyrphk45yf+ksr
RHoRMkqQWcp1u5xNXJXV7oB+Nwz7YDqo2MRn8s+jUDg6UsHyu9hwH5tqsLmO
aVSptzVA9f0dtd27atqOVfNa3K2GG5WN12qab9W1sSY2dHfU9Xkre+WbvfKp
Vux5gPwrSDuAlUX4KAvvx/imLR6cNMPLmvjf7dKvmqQ36qQJ94WX49Knmrik
AIUL2BelcRek8RdE2Bmwmo/YVJikD06pHt1t8TiPAY0b3q0V6g9AxT9xd0Fg
Z/w/0BvTrXjHinctmGHBe2a8b8aHZnxkwscmzDRilgGzDZhrwDwDi+Z8PRbo
sFCHxTosoabljsO0WKbBcsrgmLR/INI+R5ke5BIpqqGgxh+bmkHpBiWHCVas
p7zejiQHV2moq/QSZJQhs5wrrdmbkbsVnFCqXrEdg+MknGdRIHxbyQ3Wtw1C
3zbXsqYRR9sbsbPBu6u+f2+t69iDCjrtZv21yoYrD5pu1Lv45UN3c2NvT12/
r7JfpuzuRCt2VMNyDgm7sMSG95IhrZAnz/JJUwdY6yg+ebNBsZiCqtuiCHaF
jSapnDCXzNNYwZMg6Qw/ZY7UTNFjeUMwT8H3vj7l1yZmSNR2fjzDgPcN+IAs
gg4f6fCxFrN0mENNy955noaD4oVaLBIsLNFgqQZhGuaC9UeHcB3ILPqNIjk1
IyjCjDFznhBn4dxvnZUT9QQ71juwPg9J+aJoJq79U90eGA7A9AkvV9k+g+MU
nOdQcAlFIh8jHdl4H5sfYEsdQ7+DoH+I3Y1Dext699e5jtVUUhc36q7eI/Qf
Xqtvvsnod9Y3dbsae/tq+jyV/b6r5LWasamCk7XoTVhixEfxmLIY0ntD0qRe
6fdt0i8fcnQ44T77q/G3BAfX/TWs8ZekcedFhCF0IjTAgfBfCgdCT/gxkG2N
ir/ab+X4QxHR8+QnaTBZgylavKXFVA3e1ii3kKieWSj2ry/WgLHOZazJVq3U
I5zjulUckkfoEWlQ9rby4efpYsknawuyt/JCgmYXrxEZDsJ0GJajvCToOA3n
eRQM25572FSFLTV8f5kf1Cbsfejb39hzqL71eC2bm+t1V+42XKluvKrg2tRe
3dLV2NzTUd/jru33VvbjYicOP+QSf+YRhJdgZhbejYI0R5amD3CZ979apJ/W
cwjHvoQM0A0BrSgPvniBsBt3Xhgfws4P42lhi57yb/5miE8LbM98MbZBETp9
RdyDLGVCPTELqucmZWFyFt7KwtvZmJ6Nd7Lxbhbey8YH2fgoBx/nYGYOZmVj
TjYE+mMiTYi2IMbG5Yu1DkJ8HVn438Q7kZCP9QVIKubab/pGZIpdDDk7kLsL
2r3QK2gfg+0kHGd4VbZQZKNsQO5hczW21mJ7QwDqJuxv8h182H+kwXW8nj3u
9fprAu0rdc03H7YwVi0dNa1uArytqb+vfsB3pwcXOrC/jo1+yn7OF8iSTFwO
6WMvl4coSSVBflVkqP7A6zpj6C/GCiked/ZpxWooKCtSK1A+qwRlj6Gs5DqB
avsX3YHJtv5bgc+lNEi874IPsyalY3I63srA2xmYloF3MjAjE+9n4sMsdlsf
Z2JWFoNPpy3IwcJcLMrB4ly2Mcu0WK4HhV7hBqwygELoSDOirVyIiMvDWifW
5XNBMKGAa7nJpXybVfpmXnvJFtuyNHuhOwjjYZgVTs7yYnmhEkRVYGMlmxUW
/wbsfoi9zdjfjIMt+KRp4OjD9hMN9YKTmxUNV6sbL9c133jYzHC62u+3dda0
dTe19rmbBzx1A6joxbl27LwH23kuYlIQOW0dpMVD0gd9ktQp/bqFvfArVdLL
9wLBMBsXwQx54XOKArAlOfUMPxkreDkleDnHevIkToL3gz7pPqbP37eksJME
KZnY48NMKQUTUzApFZNTMSUVb6Xi7TRMT8O76XgvHR9k4MMMwVEmdzkvG8xR
Dhblsm0KEwStIIKMWEUJjhmRVkTbuFgUR+wUIL4QCUVILOE7WVI3IX0LMrcj
W2xmZmqOwHw8mJryCmy6jy0PsL0OOxuxpwn7WgQvLfi02XO8qfNUI29qvt5w
u6LhelXjVaKmUaGm9U5b+/2Ozpr27hZXn7tlwFvvAaUtJ1uw7R5MpxG9hT3b
pDU+aS6ZqB7pT20c7r5RI70iajov3eSlp/FX/eywupxTbP6pp4WBUjRGGqeE
S/9bVka7m0xhhcSG76Xgw0xpPYiliUmYlIzJyZiSjKmpmJaK6al4Nw3vpeGD
dHyUgZmClTlZ8BOTC3IaSylMEqysNHLyudrC1Z9oB2KciCvAuiIklPBCSMom
pG1BxnZk7ULOXmgPclfEh/UU30obxMfWB9hR/0hPDrXgiAvHXEMnmrvPNDVf
ePjgemPFncabVQ9v1DZdJz6am6+1tlxva6vo6Ljf2VXb3uNq63O7PHJN/9Cd
XlDwuq2SV8RXl+H9LHlalHfS7H72xhQL/bxe+ukD6ZW7nHtMuCmNv8J6Mv6S
4nEDHuEks/KU0Bd6okSuHNKOu/h/wcwYf8T6D8OMrIEUy4yshepDhR7iZdJ6
TF6PKUl4KwVTU5iUd1IxI1UwIuiYLcwZMcJ0aLFUhzADlht509cqM1ZbEWVH
dB5i8hFXiHXFWF+GpI1I3YL07byITFxoDkB/mLd+UG/2s3AGuNhQgc33sa0G
O+ux56HfYB1uxaet8vFW+ZSr92xL68WmuutNlXce3q5quiW4uNHcfJX6aXfd
7Gyr6Oq439VV19XT0tnf29zvqffIN7pwvInjo+xPsawI75EVoJzwwz4RmrZI
b9ZKr9/n9VkyW5zDX2FXMu7csHdmvy3YCGU2nlFiIdHOMC2cZlAMJfZAPfO/
5CX4vjXxawe/4RFEQqKAIxpSDBNFNEnxmBiPSfEBhpLxdgqmp+DdVLw/TI9w
9fNyOKJdYkCYEctNolRj5V1ekQ5EOxFTgLgirCvB+g1I2syrvxk7eZk/9wBv
3zAcheUEiBjqbXRiWnDIhSOt8rE2+USbfLp14Lyrg41Wc/WdprtVzXdqmq43
CGKeEXlT/QBuuHHChbLryu7K5yZRgDrdI/2xQ/pts/RmDdun1yukCdfZl790
WVims2yJuASt4C8CKAH/KeFN+DcEzgjHfk4s6FECf/X/hoXg3EKw8GtmIVyW
IiCtBtNBXKzxczFx7SMipiZjWjLeSWGXMszC3BzMJ2+vw1KiwMJls3AbIuxc
tI7OR0wh4kqwrgzrNyJ5K9J2IGM3svfz3hnC33wCNhFjqcRt1uUB/HfVUxSL
A+QuFK1ok0+2y2fbBy+0ujlTaKmraL5f1XKvpvlmQ8vNpuaryhpBp+u6u+12
d8e93s77Pe6G7t5290Bvm2dQ+d3EEViJgFt6s176ZQ2vvr10Q3rluj9FG3/O
rxAcC0kvniBOTj7Fr58WTuOs4GyYimtPZCJQvwqsgAdbM+EvfiGF+aSVshQO
aRX8arCG1WBiLCatxWTKcNbjrSS8nSRAFxvBZ2Zjdg7m5mI+ZXIGLDVhOSFu
R0QeVjsRVYCYIkY8fgOvmKdsR/puZO1D7kHojsD4Gayn4TjPVVtlgWVzJbY9
8MOtGCGW9Xb5dId8rsN3qZ0XTm62Nla4HlS57te03CG4FfQ6W666W2/2tN/t
ba/o66zq7W7s623tGejr8IoAg4us8K94sOV5o4KXNsnscLXirBBpEvETghh6
ZOvDLkD1JcXmMMr0TTI7L14QWJPJujkK1iKSfezXGQW2f5AWDklLZYki6xVg
yR62MrGYGIdJ6/zwTk1kyzJDYPsxYZvL2C7QYbERYSTNdqxy8ipMVCHWFCOu
jNezE7cidScy9iL7IDSHoT8G8ynYz/EmqKLrvHFm0z1GlTrcJ1A9Qqi242SH
fKZDPt/hu9zBPz5yq62lorWuqrW6xnWXUOXIRxj4Ttc1t+tGT/ud3rbb/e13
+jurB9z1/b2unoFeATz8Waf02m1hxi9IL51/ZMNPCG2nR6UxrmMe4cpWRBp/
UdQAyZxfZmi/ANfvjPSkr3O/C33SElkKg7QSfmMRJcRV4KmYialJwlKPxFOL
BXosNmGZFSsdiCAwi7CmBHHliN+MpG1I3YWMfcg5BN1RmMgiCFdZdA1lt7Dx
HrZWY2cdCEnqkJA8LpA82ylf6JIvd/Gdrrfa2++2PaxqqxVW4Nmmlpuulhvt
Laybbte1nrZbvW23+ttuDbTf8XRWetx1A73iF6XEvQpcLpJevarUBhioUMYw
ZBhDYQMYRVFG+7ISOCp5Fgc0E65yOZxLPNf96e7oSAb/EqiQ2H/nq8wbZFDJ
TSwDmwEFVLIBcZg4jCiZXAEnZVqU487RcFltkQlLrVjuQDiJJ8lmKdZuRMJW
3rCVtgdZB5B7mLcrWgLqrni3rVXYWYu9jTjYzFKpWMIxF93yFTeviN/udN/t
cCkrQc81tN5tct1xuUhQOS53t1ztab3BULbe8LTe8Lbf8XZWet21KtXw7xn5
aygnBYTSi5/5ZfEzpQWQVPuRFErOZRmO9xjGCTeklyg6ufmFSH53NCRf5OvM
9kjzhqSFsrQErPQKmIq6B5CkKGKGuGfj41zM1mKuDgtNWGLFMgdW5iOiCNGl
iNvEm2xSdiN9P28N1B6F8QSsJJKXWLnLb4NM5o4H2NuAg00cPZM8nurEuS4Q
imLCqq9VdTTVtNc1tFU1td5ztVa0uW4IUbze47re23qzv/W6p/Wat/X6YPvt
wc7KITeXDR79LqIfP7XAT3rxuAKe4o0+C3gk1bOP7ORLor714iUWQ4q0J9wS
GxQq/CgG+3sFxe89UR4/7JVme6X5QiTDhOlc5VdyipwpKJucyKHyDOH8Z2ox
R4/5Rs6Ww4YhLBMQbkfybl6KzzkM3XGYT/OemIKrKL2FTXexrRq763DgIW9N
O96m4Cczfspq/p1uz70ud1VXa01HY0N7TVPbfVdbZVvr7c5WLuv1tFztbb3R
77rmcV31uq4Otl4farvl6+Cq66PfshPaqwD4uBSqGcHnlJqUX5fJIrIiX2FP
w5s7KqSXKzjXf716lPUPBcPv+61j4FfHyJvP9EhzB6VFkJYGRFBRZoqiEgRy
lPOJzdiz9ZhnxEILltqx3ImIYkSXI24L1u9Ayh5kHETOEd5vrIhd8XVeG99y
HztrsK8RnzTjWCvZQJa5S92stjd75Ds9vsru/mp3Z21XS0NnQ1PHA1dHdVvb
XT9krmt9rdf7XVc9LZe9LZeHXFd8rdd8bWz5v/EIsc8YLMLmGCvvceUtoceM
mep5IZinOUDiEEgkBBTIstLeYKEjvCgBf7VK+nndsPd/DLMfBL0rKk2/5Eu9
28XHWV6/Ai8LRETCFFLGRtHn9HShuqS3RiwwY7ENy5xYNQzdTqTuQ+YhaI7y
hm3beS6wld5kcdtejb31ONSET1040Y6zpKvdELihogeVPYPV3T217vaGrqam
znpXZy3XH9ruMG6t1/tc1/pdVzwtl7wtl4ZaLvlaLsuuq7KATvllDkW6SE2P
SS8eVdALvHNc0eKvCWE8FQhrLoqKkQDvldsB5O4xcj+tkX7VKP2hVWw9HRW/
H46mt29KU8XP+bE3GfLr7apAPrWWwaMU9x3F7ukw14SFNoQ5EV6MyHLEbkHC
TqTs41V8raKowveSodtSiV012N+IIy34rA1nOrmHK9240QNK/it75eqegdru
rgZ3W1PXQ1dXQ1tHdUf7XbdArs91tb9FwNZ8kWEjiSPkWtknC87HCoyOBtox
xXkcV31diOFJaZywbuSVKUuiKGfcFXYNL98We+UIq/tc7/nPRum3LdKfO/zx
ZjBiyt6c4F++Foj9QJrYLL3T7QdN0dfwgKxR7pnIxbN3habOMmC+hXcHrCS4
NiB2Ky//pOxH1mFeibAoCnoDGyt499HeOpayYy7//SCMVS/u9KGyD9V9g7W9
vQ09XU3dLpf7YVtnbUfHfXd7hcBKEbErQsQuC6wuyS2XIOBSRqzg9aloR8Xz
Y2rG6xtCtk6KxEQxZEKw2I/eYLxerWSwXn8g/aKBd/v+tUua0qMK/HhKUHYY
eEf8DnfAshEtf30oTeuSPhpQrPO3/WBF+2VrcjJXg+mDj3S8YrvYwXthVo9E
6gj0ZMrO+fVx8z3sfID9DQpG3z7bSUYM13pwuw/3CKZ+ubbP29Db29TT6epu
aXM3dHQ+cHfc43hYcZ2ua2z0FZhcl+XmC3ILF/pEjPqCQOYIoRQQr2NCnoT6
ET7jxYKponsvCz/5yl2BTzXXq0iY/tTONfgZ3rfm+PxS9SSMgn8j/VvDtmBq
p/RBvzR7UPldUsZpHdebpqRiupIykwI6EFbI273WbOFNs6kHuGpjOMlGi3wk
JRC8X1vg8w0SplPtuOAGCRPbq15U9aOm39fQ52nq7W7paW/rbu5w13d1PugR
LrC/7SZHZ603CCI1YaQKlVsuys3nIVB64ZEsDaN0TLHwp1mWzgSyg8tC3+6w
bSIReq2ad0D+VxNv+Z/SI73rmTxb/iBCHhYkjLwPO1gD/2U0pMQYJrdJ7/VJ
s4ekBZxTCLyelRLxVhpmiL3X8+1YWoDwMkRvxjoyUgpMlGpd8EeuL5DCHW7C
Z60gMbrcjes9QtsIoAHU9w8+7Ott6e1u62nr6G7uctd3d/JyGOVUnrZb3rZb
g63XhsiUt14jASIxQjMX6ZX4UuRXLx4OIHRckSBlx8Q3RLR6TaSkNxgikh+y
3W/USr96KP13qzTJzetmM+Xpy+SZa+UV+kcoqR6v5SsI/Xg0hHiPrDSxVXq3
dxghtuprlNWt71MsSjZnZzX21+PTZpxsw/kuXO3GLVKjflQPoG7A19jvaekf
aO3r7uht6+pu6nbX93ZW9Xfc81Ds3n5nsO2mf/6uK3LzRTSdUyD43qOIgC2N
yIBU3xIO7LxIey4o6bi4V0Coz2sPuAJPc/9zpzS9X/rY9/ZSzI7nNYXYEv9y
3khtemz+P/HbG2HpJvCVJRfPexbNW4QCESLJJB1KxwwNZor9U2HFiNiIuJ18
z0D2USEWFzlC3yRQOdiAYy043Y6LXSwVt3vZBtcOoHFAbh4Yau0f6Ojr6upt
c3c397rrqDdPxz1vx12KyIdar/tar7OPJxtMatN0ljH4xxFRkh+TU+yrzond
v0rofZtXR18me1vNlaX/Ys8kTeuVPhx8azFmrsXCLMQUc5JbfMWv22OGcfDL
h2JZ/m00aRgv/bVFmtErzRxUIJkYyYW5icl4O4sX/Km3xYW8izRmOxL3860w
eoEHeabNd7H7AQ414jMXznXgspv9990+FpF6j/zQ42sZ8LT193T1dbl723q6
+eerBzqrKLcb7LjLgTWBMawiJCIKHj8IaDyvQX5D4HCZCzzjrvPqGMXNr1A0
U8s7p8miksV43ztpAd6LYhBii5G5nyMMCv8vtPcIm/EYEkq08++jIfGi9Odm
NhuzBicuxMQVmBSNyeSF0vBOLu9BoUGtIIOxDQl7+XYg3Uk/DFvuYU8N75w6
4cL5TtaU24ql8KDBQzLhaR0Y6Ozvdfd19fTytsUBd423q2qw8/5Q+x1f2w2Z
ZeIKmVI0ncdDgYGILL4pZOKssntRCMMNadxN3qgzodKvF39o47ttZgxIc+R3
I7Aoi8t0lKIXXOa7rM53+ZR9VMOznKf8fpzy+7ePzf4/ePYz+lg1FsuTVmFy
rCiQZ+I9HeaIjd2R5FL2IP0wtCdgu8AaQRJAUz/8ECdbcaET17p5OW2Yfpdn
qH3A4x7o6+nr6ut1UQ9ed81gV/VQxz1f+22KdAX9l6DQ/5Br1eLvdPy9mPkF
0Yj769KLt6Txd3mfwM/qecXhL8IWzPRNX4m5KbyTMnknL0jtruZcj/F70ryD
/56HmPe/8bzZFHIBamIEJq/FlBRMI8otWCju/YndyTcQ5X4G6/lHkz4iJn2x
0y/zDwbQ4EWzF21eudPj7R7o6+3j3eTe7oZBd+1QZ5Wvo0LM+HrAJvrJFt7+
62LGNNcrzPKLd6TxlX6z/6cOvsnxw6G3w/DhOl6KSNzGlZcdVTjThTutDf77
3pQ5PZLvcSPt3k94hu/0SHN8UphMmc/keEzNwHt63uS4TNw+SoqdfQzmcyi8
xlaOtJqmd6oVl7o4MqDgqdaDRg9aPL42j9ft8fSKiqGnt2Wwu2HIXePrrJTb
76DtJsWVFA0IQnmzgPA+XxNzuyq9eFMaV8GC+2YDbz6TuikYmrIAM9bwHbqx
5bzYR7HJyXbc6uhQdsQP8/ZSEG8iO/oJ9/snQd1cWVomT1wjylk5+MjC228j
NotdXJTsnkb+VfZoNKvDjTjlwqVO3OrF/X4xqwFfi2eowzvY7eEfJ+Uqc2/L
UHeDz10jd96X2yv8s3JdGZ6V+OsvfMcE78TifKGWVyX/1ClN80yaJb+7Gouy
eX991iGU3eSI/YZ7UNTo/44m8Ghn/4TR5vQvYk5NrIbzZWmlPCmOU9P39ZhD
TJUjZifPSXsKeZc5i9pVjU8aeEKXu3CrhydU55GbvHKb19fl5fuC+gZ6PP2d
g70uX0+j7K6VO6vhp+m6oInXQv/Nb29VX2Zx+12bNKl34gdDM1bIHyfKy6xc
asm/gEP1yk6ix2bx8miz+BHPgkTu/X5OuSMwKQHvZAl1ovB9K9bv585Ilyhk
JzmmKZx04WIHbnZzAFrvYS1qH5TdXtblgYE+b3+Xr9cl8xTq5M4qdBAnt9B6
A2w6eAqKPfuSuGqXNN0zbdHQtGh5iV5euxmWM9hTG1idCh2OsV/xy9c3h+0N
OcEPPVyCjsKkJN5pNYvSjQ18a1P6p3w+Kf7WezhQixMtPFjGu48iIbR4/T73
K33eQa+nf6i/S+6j0TbJ7nqSIB4tYS4AVyl6KSp5oRFFj3ZCjvGPTeSZ4q+k
PIbpDyWplffxkALHyBSsvGfEAoFm4kFoT3JXm+5gXw2ON/MeIGV0BCW93+FF
96Cvz+PxDPQM9XfKfW1yT0tgcPfE4Ehpxfrry4FYxH9ltX9cym9RvD7auPgO
aHKY0gpZipffzuaNtss2IG4P3zZrFYtvZJaPNOBsK250s4jSOwRZ5yC6vUN9
nj4alK/fLfd1iEHVoasKNK7223CJDPVV/wiU35F+Y7QRiN9UJguwWpaS5Bk6
zC9AxDYkHYLuFJsz+vSTepxp9bP0PIFC1+8YlLu9g/1ez6Cn3zfQI/d1yj3N
6KbrP0BHJdoC13/Jf31xD5zqpyOl5kvSFH9tZGKa/KEFS8p42lnH4bgE4kL5
1aPLHbjbS0kVmjx0TfQMygPeoSGPxzfQx3PupWvWo6uGiWi77ZePkMA+KfE3
fkbOV6moSW93SouF8DwtrnGxHbe7Ud0n9MZL14Bn0DfkpUv1yf2d6G0R13gw
fI1/889J5LWqnwddQ8z0y3wP2jvdlBiQ7k7TY0Ex1uziuZHh2XIXh+r8aD5b
1UcWFK0enlk/zcw76Ht01Qblqiq/J+BrKn8N5xdB1xS11X/gJaM3K6X3e6eE
czn9PQvCNvB9oIazvMt2TzVONONqB0+8YYDcLLq8vn6vb9A7OMiCTWC60N0o
wKz0RxJ8RRFLqX7pZ05c6TnlytKva6SP+6as5sLpTCff9pZ+lCdIav5JHc65
cKfb/xdeurzoJ1S9noC0tqOnCSK6F/EqX0fkouJvSY2cmZDb7wy/ln5XL80Z
mBjDuQZhSsaFdJfM4L4HONWCax2o7Eaz0No+AtLrHfIMyAO96OtEjwvuBpU/
h+ILKH+z7ddB1xM7R782MuaV/tgkzfdOWscWY9kmJB/m0G3rXXzagAutuNdD
2SxcA4G8wcdi049+N0SoKmofPDsROan+K+hqzwa9Ft76OTali4cmJ2OWHat3
IOsYq+HeBzjTgptdqOqBywO3FwPewF8c6O/2Z3Lf9F9N+fuBv/FzFnwVYcGf
lya1Sct909IxtxBx+2A4g/KbOFwH0rjKHjT2o22ASJM9NCGvV8zu6/7ehX1V
/S6o11F3jz4vTe2QVvko/l9cxtCRdOyuwskm3HKjto/l3u0lnnyyV/yy+Vf9
V1D+euTvg3oMXnUS9zQ8K013S9HyTD0itiD7BO8I3V+Ni208CZIEkjzPoND1
Z/19/1L0/d9BfQXXxMcqWvyeW1ork0mO3g3jOcE6AeTioSuL6cP3TQhmVX8I
6iW47ilePyN9NCAlygvykLgPzivYU4XzLtzrViySf5QCXdUfMWKHf9BoFe4X
lSLtU9YAVWD/M5/9R3H2n0djZJTf6A3xn/VXcdZfRpOWEa+/4v/2ZPHtv44m
wUGc8UvxdylVEkZEpUFMcp/viG9NGvFpIPfmT98Xn/J1OSn9WLxS/d3/B31T
6J4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177658387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", " ", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "Thick"}], "}"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "Thick"}], "}"}], ",", "6"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158495665],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztvYd/XMeVLljTjSbtebve2feex+M0I5uE1jYlkZLnOckeh7E1Vo6WLcmK
VA4kxZxAgACInDOIwMucKeYMkAABkiCYkHPocFsehz/Bv93vVNWtWzd0k3J4
6w36tcDOdft8dUJVnfOdR19d+vYbH7y69J35r97xH4tfXfT2O/OX3PHAwsV4
Kvh3jLEa/G/8E8P9/xP3+P81f/zjH/GC9vfT+BvAS/+Cf1PkvyyIO3/k/7F/
lq/fIf9N4Z/6FP1Nsd/l/Bzz+Z4vez7xz55nggm++w7Xd31JXqv3G27/O7/i
+s4v+l2/5xcmk4D7G7+kSTbo+42Jrs3/dwV8JJHo9376j07U3J+zfovzN3ln
h/5XfjX/L4S7xfj378RTjitIcUnyU66xQ67HM/7Kr//PHk9/nd2mjNxzx609
yR4nG4Ow/Sp/76FDhxJ810/k+xJe5z+pZ66Nhm+MTveMTfWNTw6MTwxOTAxP
jo9Ojo1PjU5MjUxNj4SnhyPhoVh4yIwMxiMDH0cHfhPt/220/3cx3PoCv4/1
seAfYr1/MOmGu/iT+odY3+/5De/YuqnqP6P9v4nSJ+ORQXxLNDwUCQ9PTw9P
To9MTI2OTY6NTI4NT4xj7P7xyd6xqZtjU9dHp6+Ohq+MRC4PRy8OxzqGzPbB
+Pn+eGtP/Oz1+Jmr8VNd8RMX48cuxI+0xRn9VvbpA6fi+0/E9x2L7z0S33M4
vvtQfNfB+K6P4jsPxFlo5/44uxv38BjP4jW8A+/Du/EZfPLgmfihVvoyfOXx
i/GTl+Onr8bP3qABMWxutYFLwIXgcnBRV0fCuEBcJi4Wl0xCmxjHjxgjoY1C
aNNcaFEptEEutAGI4bdcaMySWp8mtQDA+LvbwwySkcOPT6rhR297eHt0DhsL
0J876YEvbBEbtrAF27gF29DE+MDERJ+EbZpgG7FgG4p1DJptA/FzffHWmwTb
6W6SK6R7FLCdj3PUPqVQ23OEYNltQRYgxII79sd37IvTXf74LoHgboGgBt9H
gK+FvhRffbwzfuISDYYhHfANEXxdI5FuCd90r5j2ExNDAr5Jkt+klN+wLb/I
reWXggcKL4mhy7reCkF+BaR4ya6AFK8vSFcQklcgb3JWzfodwde/tVnCB5XF
V8SSwDdO8MEA3BibhjGAbCChS8PRzqHYBcDXHz/XG2+5GT9zLX76CoevM360
PX74nNK6k/F9x+N7j7pVjuAKATtgtj/uVryj8f3H4/jkR6cJNnwZvvJYB2n0
qSvxM07YcCG4nK7haPdIhKzVmGWtLNiEtZqcIqGFudBifMLqQgtYuHml5tA7
7tk+b+PkVHRryHE1JBlIbci4NqTU9U9hVBqdffW3HBZYz48VLOFB6Cks7BRg
mSJY8MWwv9ISjk9iZFhnDktEwjIYax8wyRIClhvcEl6h6Q7pCViEVu3XUdEg
CQCR4I69/F8NGbxFwIIP7eewHDxLXybtYWf8ZBfNAMyDcxyWCxIWyx46nQhk
JJyIMkj4ibqMhBMRCkWymUEy8uLwBYUDZqUD+gRjRHzHsKCYYSExC4/xLAfD
tm8xcksCjBEbDD+3RGCQfYt2AIx+83yfdEvwGJCTAAOSO9xq6YhyS7qCCNPG
UrbvjbO5gAQPdjg1xeufDp+XmqL8E4wr4TFoKgOn+yfbqVvmRTNwyqlrDoLL
ipGUQrfGJKIHD/18nCEfMzbkUg8dlpmEx2zc+U/+5Jbm6o8T2CyKFKZGdZcj
bJbD5QxGLwzE2vpM22Z1azbrPBkbgYiuHEIzSPx749v3ALPtu+MpdGeOQAUv
7jrgpyIttooA9FPC4fTGc6oNBCu25RqJdo+4zX1yy2VN3wEWgFBYUMxfElXK
73xR+UeFiob+tG60hl1GyxUhRAYCGE6OxpGheUADs9TfRiU6eMfm5modHa/C
wDgKp+JjvYbIel3oJ4BIYW4QQMp6CYWB2ZE6Y9suC57tHJ5tu+FXtu1CNId7
eLw9AUakM2d5TMd15rhwLbBhPfENlQbCEmXDfFyL2744RJYAI4fUkmqOPaAr
8vYJIvmk0GASY0KFZtKos39jhdYcGBVdu9UmkSWzI7WBWHufeb5XAiMsGUVq
3KdAbTDfBS4iTCMTtl8qDHAAHlt3IlzbuiMepDv34AkBD95C2HzkCNiU2wfo
wrkIY5ZdYcCztQtjpjmXRLGSMmb4ua7prOQ0A3JK6uPdozg8vWXKXDMgPKgP
xEh3QhiL/mWzuEcZMJqrhVNRRmyK0FBq4rVjYWHHZOwl7FiPSXbsOhkXpSaY
0/AGmN9SU7xwbOVwbNkBTdmyPc7m4R4eb/XDhHzMcW0BdJ7HYdyaYVgAAlPa
1m/CwQhrZtmX8E13HOZYNXrnLumLBQuXlReTLypMLsk43a2VankqlESC71ZM
eywWIkRSP9bcPHABfJrtkpEXgn/HMlTgoszXcBSWgswXgq8+fy2BucHExvSW
uOziroUM1x6pIMABeGzeBlw2b4V/wT08FujgHQTNPh4BWHZM6IqIxYQRE7qS
VWZQiNxnIvzARTmMGLcpHl3xE1d4kAUgERa0ZzLJywcZe+XiiTEcs0DbO/CO
Rvio8eJcSegu8BHICK+yqalG1xiHCbN8i3vBMqwvWLjz79F8C19sChMGee49
ZuEjNIbURUPG2Bo3tgCfTZvhYXAPj3WUEBoo7SGIjtkQkeqIQOBKPLPUQHB+
7qbZ1mvC4XGIbndGT01r4QAXGvOTWlIP43JsSdYwUFc1ZiTswGomjTpbKAtu
zU01NipTHlSS7AIMmbRk6aPYiEzZFYcpI1RO8vX/Ybl22a5AASIcDmNzfJMR
n9m8CTqDO3iIJ/ES3kCas5uCAIWJ7mIoOIM5uxxfX2JgqdR63TxvYeKdyL0J
1hY6JpAPC0AYLCh8AIkoBX980PicQkMZT3sGaA7NtY51DcgCGJJGDMXEv2xW
hO+fNTXW6ljo0Ze+fNT9/KWhmFQSvikjLBiEo9aO5FZOWnsxBy09UWBAFzZx
JABEU3O8qQl60tgIb497eIxn8RreYXiQEYGZROYMBXpkzTrjGYXG6Svxs1dN
QqbHbO+jQAQLK+/M9XM00i1bVmZYl1SyGFlE5/oE8NpN3furkQIYigXVYGwG
/ZkNlPAUXmpsrFWh8Jjm5gUefT4eJWrj0Q+j9TGMFnmUTtujwDPTWuWIXKgI
RBBmkana4sACSDQ0AJGGjdAS3MNjHRfSmG1xfJIcjVAXy8sAc+liLsQzCgxa
WwpQbhAoF/pinQMxBO/u2esMlGx14aJiSlZSa0IRX1Rsz3J+IA4zgSU18HcA
M+bj0MRoIjIT6kLjzcRwbDZXC9KMhsbaCX8wXB4kora8Ogb5RvMAbNXHwlbp
7p32Ko/LdTy59r0SDwUGpA2xNzbEAcLG+vjGOuBRjz9zcQ+P8WyjAKbZhmTL
Dun7dQuGkcR+5rp8g3bFLsfPdMdbrpnnbphtPTFAcnEgenmIhNRtzV7f5aUQ
kjLyU3yeshmQU1L/QUFfL0e+P3ppkNRRGUrlvLQFP7eVlqrQYHy8mTQNZk9a
Fqq+sU7hMKzZKf+V/JC1509QcFPVLZ05lvEUafFtY0xeAQX5jF0SDVggUoom
C4e6eH1tvL4mXlcdZyl1VfEA3fkGnsDTAhe8EW8nPdks3YqMxgQiRwh14VDS
cg0ZH3fZiLT3xDo0RBLZE/xoZeUDEAgLqsnLQjSDk/mQlutxwv5m7EKvAiWi
1i0aKFYkps0AFrRGTJHg8Bt/ZpZQj7qG+hHuPvA54c3tGJgriY2MPI0hoyWR
uSr3WMihqzDLiQwtQwQ6QkUULnU18dqqeG1lvKYC68ea8ngAdwJ4zObgeSAF
nPBO0pzGeLNQG8u9iHgZhlFGymfia7INuaQUCAnHcjPW3hvr6I+6EdIMC36w
w7YIuQX85ZYMJ5oUV81z191QdTuh6uXzfsBSITE1WABDB8bo/6lRwoyljvGd
eqE0tQ31Ah18Bp90LVIUQLROGaIFW9ug7eXVJpiMuDSAdlgAUdwrMIL3gFa4
0Kkui1eV4h1VJfEA7gTwmM2pLo8DM7yK9xBYtZY6WQZOIUVRwCGO1Mn4mkxD
Lmg647a3SYCULTOn2ZEyC47SHwGYmuvJvD/NiyvmLUDi5tSlUgFInwX5sAIt
/Emh0Wcri1a9caMCp8+9g28rEHn9IYkPre+val6fL+4hI4HPLic+MFEcob8n
5eEWTcemsjheURSvKIwH8E8Aj9jdlSVx4IXXcMObCKgqH5Q2K5QO0KhwQKsy
DMey0xelQaAU0S2eEJquUsIUsQDkE4SYCK2k6JBpvZwQIDWWWnrKscYnghgs
KFGi0ViqrSwTE9X1GxUkPWIDbGT62sh093C4ayiCuYbf0sFX9yI2Fqic0mMx
HhtzVMydB8wde81tu8wt201ji9m8yWxsNKXu1FaZtZVmTblZXWZWlZiVxWZF
kVleYJbl4x1leTGWUpYfK8etgG6BisIY+1pFUayyyCSIyrkiWSZPOCUsdyhy
20mmFPMBAcLKdYYesyXCh2TG8em2ZKYrkpRZyhCf1VyfSGxJ98pogXsxCUAi
IIl4B+vnioshWQBozMC4bPaApSmV9Q0KFkwiigOGprsHprsGwpf6Ixf7ox19
UfwiRCTnejzItOrIwMqY2/dEt+6Mbt4W3bQ52tQcbWyIbqyLCmyqy6JVJdHK
4mhFYbS8IFqWFy3NjZZsiBZnR1igOCvCUnCvBLcNdAuU5kTYN0pzI3hfeWEM
+gSEpAbVODRIwQP1Wb7WoPjtlvD0RbUQzmF2dIkFSGRBoUokNEIsaRQtdyES
gEQaO6wPqSkt16UARg728/8nWKpQGaE1FfWNN/nqnpszHqkNhi/3hS/1hDt7
IhduRttvRs/fiGHN0HI9OUKwM+bWHVFjS2TTpkhTY6ShPlJfE6mtDEsNqiiK
lBdA6BGIHjAAkqLMSNH6cGH6NAsWpE+xYGH6VGEG3VigaP0U+0Zx1jRQA5ZQ
LZg+GD2ydZZHEoqkw7R0lSGsnA2TbeVMG6YeGyax+NEM3bSvzJLGBjRUYngs
g0pD6XYOagTBswDGC2BAFuy1UGE0Mkvt5fsuQn3K6xuFBl0b4R5nOHJ5IHKx
N9J5I3zhWqTtWvT81Wjr1djZbhOBihuiEzpEWCrCtkWbN4UbG6Y31k3XVU/X
VExXl05LlMpyp0tzpouzp4syp4vWTwOcgnVT+Wsn89ZMsFDe6nE2J2/NeP7a
8fy0yQKCa7o4KwxVgwUsLyA3Ja1dlVlfY26sN3WEliw3lB8ihM4kQOiGjdCl
IWV9LLGN4kpJcEEJFO6GCK1k+87i0CgRSNyqxpyjkRqpATlUHK0QBmWpUmH4
0qasrlFEad3DWPvD5cCwRUhzrkfauiPnuqItXdGzl2OnL5uIXeWiU4floIIF
ATBcDgxbeGPdVF3VZE35ZFXJZEXhpESmOGuyaP1kYcYkB2Qqb81k7qrxnJVj
G5aPstCGZSNsDu7hMZ4FWICsYB0QDBdnRUtzYmV5ZkWhWVlC7gt+rE4HZ2t8
8VJDBQl7E4HTbbZeU+DEOrm4bKvD8WEBSIQFbXkRSIRWUv0R62IB0FEPQJZd
lbsVl4cdGLEAhqVRQ8CJjz6L4BgNl9Q24R1QFLjKSyIO6IvCnEFXzl2JtlyK
nrkYPd0ZO9lhHte3yXxAiVMcQN4mXFc1VV02UVk8Xl4wXpY7LnEpTB8vSCOR
566eyFlBcGQvHclaMpT14SBLyVw0yO7O/HAQD7KWDOMFwmjFGN5KAKUTQCXZ
cFcUSiCmqCo1ayokOlgYAZ1Fiw09hJPbOi50uhzoiJ2diy5ZjdiySiElSsEd
If9EuKgtC4/LszVV7Frw3T3aCRWJWBiRBTAmC2LUqxwOlkLTI/WqUBX+luLa
ZlwdDCNCjM5BflSJYOBG7NzVWEtX7MzF2KkLsRPtseNt5tHzrkiNw7NbwYM1
pIlgoK4qXF0+VVk8UZ4/XpozWpw1KhHKWzOau2qMsFkGYIYBx/qF/RkL+jLe
72Up6e/1sLtxL+ODPjyFFwitxUPZS4dzVtDHgBO3ctAiCvYQ9SH8I5CqJUgL
FxpQIe9qyAaJr1sVSOc0qYlDHoUTl1qAoAoK+3PNmuHJYgMRPCaDSm4w0Ubs
hQFapmCxItEajgaAWBCDB2lsuohZXfylwtpmgHpxUByP8YyYHlLIFjiZy+ap
ThPgHDsXO9JqHm6xtpgdfkaBg7DXrKuKVpeHK4unyvMnSnPGizNHC9eNSHxy
VoxwZIYImQX9AGPduzfT3r6x9q3rLLj2zWvsXtxLexu3G+veuYnXgBngAlZZ
iwezlw3D6EH9SJsyoyVAids6DaX4Bx8YwtDdJkpi/4d2rntj4pzHnt4886OL
Jrcls2TYiOBRwuMNHmm3iUYTW7JtfeaFfrODHytwhGJBDBq8TBjhf/zLZuFJ
XEt+zSa87cIgncC0iVSlm/Q9sJqnLpknOsxjbSaAOXTGPHg6OTAIpmLV5Qie
w+X5U6U5E8WZ4wXrRvPWDEtsoAqZiwaASrpE5fraN66tnt+96rUrLLDq1S42
D/dW4za/e83r3WveuIqXARneh3dnfNCLDwtVIoTIISEwN2HvNITi771n0C6Q
QGiHH0KtOkK2zMRJXLuS2ZBHZsnWpCq233PIDx5rM/DsNcrIO9dDaRTt/Mg8
0DFkpmA8NuMiB0pgJTYA6DX2lTyeK4Q15/l+nifLN9Qc6c3W0eUBnkMm99Q4
OJsd4CCawhIFy5pwac5UcSZmOVwNXIiFj43MWxYyr3atfPnSihcvssDyX3ey
e3BvxUuX8NTKly+veuUyXhaIAau0d27gw+sXDkD34JjIK6VNF65HbB7TIXr3
bYOWRYkh0s9+xCYqpelejWPJgHkJuVGqwQCXG4PgCCtxC0CALCTkp5yRvybp
izEffVIDXyE56wNDRdoHzSDHjf8fY3eSv+HbArjh9dwqQwHV0hM/ezN++prn
QPOMdaCpsNrJsTIUVrQ9QFjlT5dsQKzGFWn1SM7yoawlAxyt+8movXltzetX
If+Vr1xe8dLF5S90LnvuwpJfti159jz+Lv0Vbu14ZtnzF5a90IFXgSEQxJsB
Lcwg16o+GErEEtzuTRamAy+zVBi9UvPtNw3MmuR4KZU61knzUSxjpdj4VIcl
EmJjDrmlQG6umCHFm8e+SWxs7LI3Nhy+yUoJVqNCwfiocZixtv54AJgF2ul/
zBjgw1LxoL2PrgmAbqigFAkB0hmVm3nRkw6g7VNznMxNBu3mwGUTThUUCpcX
REs3TAGn/LTh3FVDG5YNZC3uW7+gR2oWqdIrXStfugQEgAZgAUQfPtP64VMt
LLDoybPsvkVPteDBh0+3Ln7m3OJf4CYQbAdwgAyKBqCBOLwVd1WkYoRXBuEl
nNRbrxs1FXxjiOPlcFIH3E5KnHoLz+E0TfHzvVJ4Ltm5qw/EP9oDew+IFgMW
cDv8gLOThpWG8+Fbb9IVnOuNsyCugX39PIeqzQKMgoabJt6UXW6QEbzOdatb
ptjcArZt/PRNgw0GqbzQLM2JFGVOFazDWmd4w7L+zEUIBxAaXJPIwdZBcQRg
gAYwLXzizILHTi949BQLfvDISTbvg0dP4QGeWvj4aby26ElCEe/GZ5a/0IHP
Qz9hTRFtQNkQuyvk4LyA3JuvGmLPSCCn1lEO5Kx1lF1/4mOjKMUYouOSS7El
1+9Cjh7plUBBJ3a0FdIs4dsm4NNOHFUKmLSTuupdJ8fUchPY4UJSCMTUVr4Z
B2DxYmapccZC64RV43E4EWC7LMCa4g31kI0EDPMc3qQ4K1KQPpW3GgskLI36
Mz64CcDWvN4lMYOGQXmAwqInzgIXoPT+wyfef/D4ez8/xkLv/sdRdg/u4TGe
xWt4B94nMXvuAjQUBhLxB7RNWEcdsNdfNsTGhACsod65b6Ttjh84qVWcwJtZ
duqUU1iWrJwYBV0Y0av8t/33Q4cOvfeO8f57xgcLjIWLjA+XGIuXGUtXGMtW
G8vXGivTjVUZxupMY022sTbHSMs11uUb6QVGRqGxvtgIZJYYLAgcssroxkJQ
I5aKe5m4lRp49fn5C/E+vBufwSfT8uhb8F34RnzvijRj+Rpj6SpjyQoaFctJ
XAHiYVwN3DqcBUwQpjNk9NqvN736XPPLzza8+HT9C0/UPP9I1a8eKn/2gZJn
/r1IYPSpx+/f8Nh3sx/9duYj/5rx0DfXPXRv2oPz0h6cu3bmz+9Zw76BO3iI
Jx/6Zjre8Mi3Mh/7Ttbj38t+4vu5T/0w/+mfFD77s5Jf/rzsuYcrXni8+sWn
6jASxvvZjxdibFwBrgNXg2siOX1gYFWFa128lK4bV4/fsHKdJqcNlpzy6Zdn
FNlyyhRyCkJOgewKQ6/WSYyTtlckDlKERhmb5aHxjn3uLCRlE1XwgXkCLcFU
gWWEW2IhaA5LxT08xrN4DVdKnqqTF0q1eZIP1K6DMHybzabG6Ma6SF11pKY8
UlVCu6elueHirHBhehiTG+tZ+BSsWWGlEMvB3VC4J7SJ7N2jp95/6Dg0552f
HX773w+99eOP3vzRgTf+bT9LeeMH+9i9uPfGD/fjKbyAl9/56WG8FR/44JFT
Cx8/IzRr2fPcFM7vRmyJUB6jYcy8tVOvPt9MdpAWw1ytKmnj3LsdK1yIOMSV
XoSbQj0CcEgshSSWAg/hijF8quZsvKrL5NlXQ4M/ZPYFnLHzxsmRclOogGMh
XAhLxT08PsH36jC5RCUiWbxWT9qOAyyMbTbUR+uqw9VlU5VFk+X5k6UIAhGw
r5vIWz0Be0RgfWCB9cplgLX0l20Srw8ePgnz9s7PjgikgMzrP9g3//6987+3
m6W89t3d7N7539sz//49r39/L14AdgTcTw7iA/gYPgw3hkiEQ3YBEcvq+VeE
JRSQvfxsYyFfd0nIyug0yobM6fVF0LHvuG0Mdd9/3C0xV4Thro2zcaosFhvD
EqrmZnmMLKE6oGUtO8swCK0LNmAshAtgqbgQPMazeA2mAKiKMoOPzkiQ9viD
hB9t1tdEayrkXkRJ9lhRxmhB2kjuqpENy0eyFg9ykG4gdINLQRjBvVKLxAk6
8vZPgdDBN394gCO0B+C8+u2dr/yPHSzw8r9uZ9985X9sf+VbO1791k48++p3
dr323V3AEEgCM9I0oWYPnyAH9lQLIkaE+ite4jpmAQbzm792qkgDrFoAVusD
2E5RHXHEaZjULLfkdlzKLekueXlB3Aapjo7BbJBUfuxBH5UinM7bULEQBmWp
uIfHeBavwV4fapHp7VQ1xeHBd+3wwtOAH2rWVkarSsLlBbQjUbR+jMMziAA9
88MBCAmigq/HchaxGsHzVAvEKRD6N2iFsHOv379XYfPyN7e9eO+WF+dtfnHe
lpfu3fLSfVtf+uY2PAnEJF7f3ok3A9E3fwSMDnFTyDF68iwCexdGLzxeA6WS
GPFNwUoXRlospqewyvrIU5peaWIjqSXFh+8S81MwDtFGAdEmW49UapNLh6lg
poVmhRiRhai4OvUI31UFfHhtTZbxEd8o2m8VUOFbKMV9t9yRkFHdRvqFtVVm
dVm0ojBcmst3JGiVizB8MJOiul4HOM+exyyHJ3rvweMCn78nZL5Pdg3KIZAB
IL+eu/mFuze9cFdzAP+w+359j4FnXHDhzQTR9/cCXlhJCdGjpyREsHsvX8LA
UN3nHqnMWjKExbGCqBwQFcdtT6E5d5VvJCyQ1CSrVhKiUfObpJYUn+JsccwS
19cGclWn8gG904GPpVDCcCxEZbipAhlh0hD1HHCWfuqGDb8EmorJIHaMaHVb
HCnLny7JRgQ8ns+3i7KW0NbqunfJ+9iGjWsOvD4cidQf+BlC5lsCma0Cmefn
ND339cZffa3hOdy+3vjcNxrxzPNzmoEYXhVwASXo0mvf2UUQ/fDA2z85+O4D
RxCwE0TcNWE+wO1heISVWA9nL8Wie7xg3XRxFm02lRfSzK4ppx9AM7uRz2w9
aW+fs7TFI7YUkloKZrkrenDlQBaux5ogVqZmhKa0di7tbncuragOJNXlg86g
grZU2DPSmlN0MQhNFTyyQsSZ4EPZcfXkdTFidVmsojBSmjNF8UEaVrEj2Utp
mzX9/V6EWlh7iuAAURgcO6b5Ow8cgc+RPgi26uV/JWxe1LH5Pzb+8s56Fng2
tY5985epdXjwyzs34tlfccSe/0bT83c1AyiYQRg9IAzXRS4JMQRQeugEBRBP
t2JMjIxI8tn/KE1/rwdXBJco11FiclsBn72O2uyX7GrZH/ISJympk9TpDGY2
5JZUh/LTIBNIJqYsnZoPdrLzTssfaSU1pLXWeFRDFcKILFVgIzwO1g97nUVu
+JYtPtaNK1AJpkikOHuqMH0ib82YOzJ4+RJ8wuJnziFUhjPHRIcgKbYWCJG7
mbeFY9MssUmtf3Z27S++WsOCz3ylmt33i6/U4MEvZtXiWbwmcAKS+Aw+ic8D
ZGgivlKYOix5Fz5xFgMufa59xUsXf/Gz4rS3eUi+ZIgrEQmtRAhN2TnNPbgz
xJUeHbNBgqhIZknzh3NX01hYyZflxdyxvzMzcNtud4mgwAjDzaRSqtm4Q7XT
R+PL0wyFiSwR2SHDAZdRqyrD/IOtoL2f/LTxnJWjsCGwJOnv9qx985pY/8Co
wSFAXBSpcUwgRoEK/AnE+9w3miBtqAmEDwieuaP66X+pZClP/XMlm/f0P1fi
AZ7CC88Cm9Q6vBUf4KhsJlS+tROhHBwQ1lTvaaYN3gfrW0wM2FeuNPy0I50k
VZobg2mrKnFsPjR7p7KfpGZAUknxEMcqhRlTJRsi0sfpBtSVVusa6LAcayYG
Y7PJcnF+Fay0HWAoDyPOJKQJM6vLxRZqrGRDGBeQt2Ycvzrzw8EMmLC3ryNW
snSkFR4GssI8hleA9DCzBR4cDFKOZ2fXQR+euaMK8n/qyxVPfrGchZ78Yhmb
i3t4jGclJLMFHo2Ex9zNMILkbX6w7y1yNRRUCyOGKfDUj/JXvdbFV619VijA
xZQtZ64KBbw5rXrZkS4mNgNySmq7spfBo40VrJsszpqWZ5CaggiPJjPRdzjr
AhX1CSevYSEaLlXR3eC1ZasNR1mbKNoRVotrCGKymnLa/q8oMvETi7PCUFSY
BtIQuH1t0WlrCDmVj974wT6EVXz9wlF5nvSjgfTjqzVP/0sV9OKpLwGSsic+
X8pCj/9TCZuHe3iMZ58idakiYKAoMF9cURCvIXiA0lEM8NNDtDwl23UGMdqT
/5ZHMdobV6GwpCXLRkhcaQjwp0tzouWUnsK1RJ1eqPnrqdHTxUXSSqolsNw5
K0by147zgWSmhYqh7XxM3U56oJmJwdhsRfSwdJWhKkC36PZKUxHYKwyE4eDO
itaHEY3Slo1QEe7lV7x4celzFz5UKvLTw1xF9pCH/+Y2gQcECwfxi6/WPn1H
FSnHl8qf+ELZ458vffxzxSz02D8Ws7m4B0jwLF7DO6BHMG3kVMijNCMyE+4E
YRnglobrsVMI/Z78fi6uANfBfQlXlBXw9mPcnkRFroMeM8uYzOnwlZgEtwWb
QfV+ybSEIz+ct3q8MH2aArE8nlLBI2ZRE2CnXzrrzRQdgMCEhWi4VJ0FZelK
Q9bkWoVUzcqxCydSLg8QMCqi9YL0cO7qiexlI+sXDqjIeJlYtkBFHiYnAuPy
ulSR7QiepJYgvIKDgFni9oqUA6oBNB79bBELPfrfC9k83MNjPCvV5ctkxPAZ
fBIhAVkwKAri5e/uFmEYOfmHTy564uzj9+fQvhuPlEUMhtiQ25UpSkKxcxuk
oVf7btLQ68BoPDAkraRasn5BX7aMJqyQXFMUmgH12gzwgwZjzcRgbLZi3liy
wtBLPj0qAjvMVSTfxCKtKDOWnzYNWy02yrCOXD2fq8iv2mHVhYq8AxX5kVQR
rAl/PdcQeMA1IK6Cp4DLeIIrx2P/WAQcHvlvBSz0yH/NZ3NxD4/x7OOfE5CU
k1/5SrVwKgi98F0vibjr/j3k4X8qFOX049/LxhWQoshNtV5uT8Z4pEpJQdzx
mtXWppptuxKLic2AnJJqidq748PESlTuEaXvyUxyR6a/ZrkcI4WgMCx1p0a2
sWS5sdUyWrK8rUkW7vA4K255EbNkg1m4Por4X7h2rE4ccdZTLR9gZf/zY3Dt
mMPCi8D80xJeoCJdyJcrnvgCh+SzHJL/WvDw/57HQg//Qx6bh3t4TMB8tojs
2BfKyOFzpwILJhSFPApf+4tomDzKo6ce+272EmuxgovCpdmHPmLnzDoPFykm
pCgNlqI46/N0cZG0kuJiDyS36GIUUBTGMJAolUk0kKJokLxnoZ0cF42gZvFy
wy6OtmrdxJpE4sKP0hy4LBulVeN7PP59pUvtuIj4l9YkMF3f2YUVH61H7pK4
/D2iLcS55Eo+X0pGywLloX/Ifeh/yw0+9Jkcdi/u4KGNzz+Sk8FHpMefXffc
1xrwjfhey4rtk1bskZOPfSfLWu9b4JDRV4ffMC5cZlb+j9rZbDY8xsUts6R1
DHLNukysWaPFlFnpQKfeVX/hHIkom4hBi7MKpkpgnNiIWml7Oc/XizCRPBZ2
YOPvVhQ2Pya38iphg7XiZizO5f6LMmPkUD5bBLNlAZPz4GdyHvxfcdtAfz+T
g2ckQv+tgOzaP5U4jBq8/13N+GqC53sWPA8c+eDhE49+O5M2np93wIPLhS+E
RyQnk0s1LC54VPxqeIQmECKpJdWdde/2QCIYKG/1BM0DGijqRcdnoF2WAd0r
uLUInzt3aLqDlxcvMxz107qjERAV+0LEg2OxpHdD9BFiJhGLIYqCixDaI7w+
RWGfK3n0s5bqQF04PEHgw+7FnYcIIQkPggGCh1s3WsvMquU+xw2P2IoheJ45
5wPPqomCdSKdO+qGR4+XNWegKxBLgM8XNHxu8n05NREiCfFJPBJnopOMdGz2
dg0dh8dRK3sZBiREJ+2dG2vEYtIXnW/tfOm+rb++x8DiQ/gccjhfIofz2OeE
YcuHowEQUBgWIGzu+/n/soHr0IYHBUL/ABOXTyaO/E8pPiz9z52JEDr+SDKE
pvn+lT9Crvpwxdyz3ZYbS8Gd5DuYHKeB28LJQxGQAKcdyXGqvzVO6/4EnL78
J+Fkxwl33AKnpJqUDKfmBDjtuA2cnPZOeKPVwu/dwt5t1uzddt3eOfzRX8bY
ef2R29gx3drBdMGAPar8kbB2n7Gs3Wf8rN0XpbV71sfaWRvP0hklwCg9qbWz
fMQnsnZf9MQKVsiYHXVFcnasYHh4aaxhduyXI9GQs7Z74jg7VlB7y+VxtQTV
4rgRzBTMF/9YQSxBZRy3+QUrVvi0I1bAeoewkWoEHaIoTmiPUiC8/GiCYOGF
u9z4vPsArUgf/XYWBQvuWI778HQZyyUJFpJEWLcXZ+frcXaRJ872Em58sjhb
3yKo1dY/hZ71j4qzsf55oVPHh+8z21sE7vWPI862IGIhAmmewESuTfk+zlMq
xE6te+7rDfZGAYflbXeIra1/5L6zOqyJ6Sn2jhB7i+S+8obYCSJsz7p0Jdal
02pdWlkkysqsI88GeQJOyqnvSDjXpR9516XbvOvShsTr0rVT9rr0rev6unSB
z7p0q45L7TN3VFlBnL1VACjUujTfsWEgIze5s2atS7fSuvR79rp0gWtd+tZ1
fblor0uL/oR16S32C9Yv7OPbRHz3JlscqPJyv3JHtaza5tziAUVsrLEQba2l
qi01vLbUuYnjOAoQyx97n9MszorhCnJWjmctGc5YIDZxule8dGmpPC6Th81v
/ugjcRRAR2VzN0tfQwcBX7WXpmpLDTYLUXaINnPmOvbVtOWodDHabifGwEgY
D6PSJo6VxIFIBVdGmzgrtU2cAmsTJ+lelz6FLWkljakzP+S7nWvGCzOmxbGz
2O0Ux866sriG0ffuZtJO52zFMLx0lbE98UmAPCuz9wpihRlhRCCw2dKGvSH2
Cqw9HLcNI12Re8/8bMbeWLM2nqEULISlD5vL1aP4cWv7Wd9SE+c0QknoKPOH
9lHmoifPPvH9HHt/AJ74Q/h8vsuZPlVMntg6PbHSKBoSbArrJORshv8ep3ZC
Q2dBo/IkQGxwqjNmRRfkexbkPKRhoT1HoCXqeMZ1IGBvP+u+v9K0FSU3VpQZ
xuSTOZy028nPzF66tOx561z5QSgK7XZSXMb3CaT1gvWxt5/peKZc7UCzAJxI
kI4G5tk7z/ygRt98FvsC+vGZCJcXPEbHZ0/+IFdtdq5f0J8tTwXGxamArie3
f3gCQZHEkmoKjynE6VlYZRrI7IwGJ2WGNopgB1bndDPp5Gz2HuvkbNkaQ6fq
tA/77YNlnqMuHEt+rDhbHZvxYNk6WF7xIqVjODbW6GB59yvf2iFPzeY0WQc1
joNMqAUL0dHZXFIQ/TjTPqJpwrIIiyN+tqx2nmmPk2c2nX/y3/IREkJpuZoM
UkIGncJPFmVO880tW01uccioiYnN8D8zszUlZwXUhE7m6GSZq0lNuXYyd6sx
9lqn2Cy07zg0RRz173UeMDuOM13KUkUHzDxQjuEK1AGzSMJQKWZYNmDxQMry
kDwagLJgVjN1wqwfZ5Ihkyea/IS5nM3DPXGKiddcB5naziYslzyfoYPMZ1qX
/qr96R8X8IOzG3RswjOZ8tMmhbgwj1QapX0QvznZQbwSF0krKS503J8ODx9x
Z4Y2OI8cNFB2aykyIttj/0ngcgB/UumBlYixIs3Ycyius9vKs/8ttsOvq7Hs
WFGsLDdSnDlVkDaRu4oSMaRzUQebPLtMHRBQvuz9eyUuiGhpK0DoDEzZbErG
IHTuqGIplI5xLyFyBweFUmQom0mpisxgsg80j4hUTcp/RuT1Qscz/164Vhyd
fTjIpzGv3xYn/1ZuniNnRcdF8fQeskEReUVcYrdRlWNbNH6QFuGFlFYCSLVd
LuSiO3NT0Vs5OTMpj2k2pc3yPKaV6YZOcI8PqhwNlT+rBQGx8nwsBqYKMyiJ
CXY8a8mQngUo9ecJK2GG4yRzmP51+0scphfu4kokkEqtgxdhQUpk+iZBI9BJ
lQAJ30Lm7F4rF/D+vSoPwMrVPC9yNZ/9WYmIxFQioDvxS6mPX+KXS1h6ch5L
8eQx+SJlaxUf2XTkP9c6kmvlyPvc+dYHrGEP8kREFjrUQnmBZ+MqNXBVhrFf
79hhYbZlhxa4bVSRNM8LzJ0uzpyk6rbVIxuWDVHOMyXVWMehz7VTgPDEGXE+
jcDNygukhNrtL/HcM45b83McN8RiLEjJgffJdECZw9kk8s2s1E1ndi2t/U9w
a3dOnn6+duWXPy/LsJflsHYRK6L1JFIqP+3NGz/uFhrJzImWqinVEMtljLlr
DZjqqkW1BlwKWv3BBtfjW1YoONRUT0Hd4UgR3utMEXZlcVPqe+h4J+W/d1Cd
j0iBT8sxRAGJnWXtKU8w1Ok4j0soxbooXJY7VZwFkz+Wh7mwfChr8QAcDvSX
gni+4KXT8Wda4QLl+ZGjgOR7e14TubxQ5vu2Uir1vVtxh2e+b3uFkt93yOR3
lRAqUkRE1s7jZ6yikg44W5gMcULw6yeqc1YM8yh6qoR25zxlAyon3U9nZGZ1
qy22o1xsKSS1lOMdnuqfxIhV+WYM7yBL7siy9rZa0QojqJwkdOIyEBNVP6Ks
JC3PECVaMgfbr9pRj1tEDpYOGhTYDZoMJimlAYol9ZYX/hxGiIEFq8qOByCA
hQUpwqQ7816jWpLdvJZkD9Up/NCq/3nQgopnvsnq1fmX171zk0fvwy8+XZe3
ergwfRx+oCw/6rZwzQ6ovLUDqv7nqFNkQZIYlZScvGQDdnvW1g3ZFh5G7rYI
pb3q1WZXrup1dix0qhuoido6UbSVXmAI1muFXRJWTAKuQQNOFDS4gFvYJ9NL
ZbpWu1WxJcrrHjiKuNOuOeElQSwFisfunX//Xke51o95ZckDR7Gww4dhWy3E
rNrVt65mfHATiOWuHH/5lw0F60aLM8cxlSqKonqNm7twSiesd/ZGEcXiDokF
ILEA3Uk51XWL0wsJUYMDIsnLesQ5P/TRnCV9VNAXOnMdKFHTHqsUMqPIEKom
sfLUE3vpMRsb5LKgqlSvPBmz+BWI0Ufsz1L4+dJFidIiXuAAV0ZK9sCRt39K
eiZKIVkKjCS7D4qkiiDxMt5EdcYPW8U/z1g58QTRVQpY3r+RuehmzvJhrN5f
fb65OGuyNGe8omAK15WsDPGIVV6sOqNpJeEuiUFeASG4q0R14tYu17rZXQYk
9JiDpOouRQn6UX08azBR1DyTSsBni/J8PJlZYsia70vcHHpaLagCIYpkBEay
dIsnPgqMRHmDwGjFcLbCiC8RBD7EqPB0q1WtegLGjApWHzgCpWIhIMLmvsMx
wbPvPXhcFPyQ5vDSOSrW5xut5JneuUmbeh/2bVjWT+YuY3r+i0ZZHtauk1Ul
UzWVUb0yy13Te9ynOlQVfitMIB0W5KXyLTfiLddN3PxYNW1kfGFRrNM2qUKH
g1SBMOFV5q09REcyg9fkn+shrgA+LjUJEcokDJ8/R4kLH1n5aONj88kAH14g
BHwyF/WLChSpPXAm5Kl+ce5Di0FBleWzFCrMn8dBsWvy4YZ4VSNixjYiwXjp
Em2Dv3GN4oYFggFjKHfVUEHacHHW9BsvG5x7M1JTPl1fE7Xr5rY7OQyOO4qH
HTwK3bIsX7BQQGBBqso/12OylHM3TT/7ZrOUeD2fTgh++HwyohKLsSEouBpw
Y8RawlIF5QUuAG/KLjeAoqS8uOpDJ3PABRU3d5s0qGoAVYmCarLQov7JXjoo
ioUkTjBO8E2I0hRHyaInJWAsuOCxU2yuwIYzXZwVZBeIP+B8sBQjppJXurj/
uS6ZSpYMU533mjHMjaLMcSxH3nzNEBF+XXWkoT6qyn58uCY8HC86U0mrxhMS
UrKjO72+umSj5XZ53AN9dMrdHVSQaziYh/goKe0DZgrnkrnQTyROhFOfmVNJ
bZAE34V/2zI/kORSWyzbajSQsGzLIpCo4G6lrOiSCMFCweYRToJO5rkLcCuk
WM+0siDQYPMEhQyRAD3bJllknue8Fi9fxroPfk1wkUg6LV7bWEgFJlOYG+UF
02+/btgLsMZoMiaX8xZRk5v4h+bteQHKgBmExIIksZQL/W7OHxePlhcY1eYg
AV+NpNIibqFgx6DJvt5hEULRjbiZJLdZbrXR1m+TaLXc/FjQkVB3E083DQmS
IiLZrIhIxGZIVK6ts3hV5NqxXA6SREgyzhE5k2DQIpUiA0gRH9Bg9whSpuUa
KRPiDATbwgERzw9RafVLKq1VgkpL5BUQMXFVaeydNw131f3OBCRJTitHctMY
rZTcUjoGbbkl5Trb5pkKh87Gj5yThKjeeSAIoDqGzKBk6QpcHI6xr13ivIH8
RmxrnbydQ16NYTHREQsR0Wz3yOZmemPZhDgZTpxKaQ+kDDhlWzitGuEYfWb9
Qqr+hpFCHIYoQtBoCaWSaBDP2WWE05yZ7huKlo7UR/JmSfXJWzNZsC5MfIHa
kSxc43tvG258eFEjUcT5Um9ekfNais2iiOscMgO65IJKcsntHIG039xz0Nx3
1DxwwsRoR1rjx9riJzolKapg3oR34311iL9MEd/hy1Ms3jsiKEwVPI4CrYKa
TbwPCpGetXOzK3Cy+zcnwWmnjZNd3QKciiJleVRlXASc0sakJkHA8PQaVjcJ
KxjA+d0sAEjYPMkV+PrVtW9cBTSC3BHvI/fDT2Y3LMMiiDNvUgpQTHI6Whhh
/PffM9wY7eNSO2IeOG4ePE2UlIiwj3eQ1AQJpuJ0bONS6xj0l9otmTYxyGE+
yCnzSIt57Lx54gJxLgq+WqsTFbFGWqSoMYs1krNszrBYNr/axSk2iZt2SPKf
XlBkjr3OPnQi/k6Ki3bIaOHCOegkw+ZKIrcgXlpO54hQOf09SbLJghTwzbW5
Nd/tkfSaC/pJXcicUaFWfhrUMSxzC/J1NEyMTQybLp8jBHXMPHjSPHzWPHrO
PH7BPHnRPGMzcVPPG9EbSlGSCkFxbs2QP7embdPIlB3lUGCEM+axc+aJduIl
PdPlpA62CDwVzarOTUsMqzPoz2zFTcuJaal5gOAN7rR0RnRnVsDYpHO3Awxt
McQqiyOCHFCgAtuWtxpuyOIMXjykqGlZCAiwOcAAiqQYacmxCK7TdZPEHLwh
VppnMQeXKTCI13nhIsMGgxdkk2oAjBPm4dPm0VbzeJt5spOIXFs09nqLOdim
8mVuWYX82WhtVPYfi390wjwE7TgTO9YSO9EWO9URO3Mp1tIdO3c9ZtNtD0bF
IIqe2GInZkFBuY0bp5JmqYL6/Drvt1FS1yQI0CVECp8BGx830aaOj04tpwhH
6uJ1dOAo8bF4nTOIuyc/bYKonVeNa9TOwywEPNgcB6MzsW4TNTcpSVZEVrZp
lNv1tRIaDLtoseEOnU+QQcEsPtoSO34+dvJC7DREdoVEZs9ii3JbUCx3a4zO
bpklXZdS2HyGGy9ozHmiWT5zkY91LebqKOCmrNeo0GcSE/psxYRu06ALcIZk
W+AO0ddcNd9wdm88mBiZZv2IHsiURAQqJdkU9Batp+hXMdMLInQ2I2fFKLsH
tipP0GunET89VcZvEAzbgp+eCmWJn17gYVG1LF5mOJac8PSn42S3oCrAoz12
upNoqc9djblp/b2M8ZaMZvT4Mp/bukIxWCv3ITBcHRyGy9FzV6NtN6Kq+8Zl
5/eLJgXUNYAFRZ8C3NgM6hgwW3UMoHYBY1JhODU976U5xNtvcUDaXIBcTAyI
a5u7XuRMxGS3gPzp0lzYIfgFBFPhQt7NQcDCUgBMIH/tBLsbOgSDVZgB2Ogg
tjSHF5cWSq4CceBSX2fDIRYUS1cY3h2Ao+fN4+3myQ6C4+yl6LnuaNt1yCqq
T9luT5cF0SqABSCgUJ9vrwBnp432+IkO8xR81WWOuRikJ+psh+LuvSL6N1DH
CBYUTVGsvigsVbUO6uMdN/SeKKKjA1mzYYmP6uSYEJ9jEh8vxQg/o7d61sCc
IZT2NN0IAwaWAtVgd+Me9XnInOatNsKUvZAncnz4QTk/KHAUG2qbZ8tWGzY4
LXwxgTj1AvfAlyy5XSPOfe9EdiAjO14EPJLz7bvh7FqDsPgSd/jd3Hzd4DD1
3aKtkBwDwKRYnXJmi35ComtNn9Z5w+7yZCEkezsO0rK0tScpQh85DntVprFA
B1YNIUFVCbwO5Z2XF1DObmluDNaKBUqy4XWpX01OhNrVBABfACiyr5cXRDkF
vdVTyFlF4Np2Xp5mOFbjXoFd5/j0+ghMb2im9fhR/Zi8yNidA6xGeiLoFhaT
ZsHlweiVYZ8mNX1aZynG8fgvqnOR6Mo1bLWwwzuqN1LTJ9El5csCKL9eadSL
q/2ToKQzXcmMVOgSMStwugu78VOhbPwUwD8spbyQngEouAXwMvsa9/kJm3K5
tktWphsfadslzu4XMZ9OZombcqXofbJSILXkO6AOiGTbCNEDxdPsyaetHe/7
xfuk3ala2YlGgzUb6y1t8m8EqXqkdlgIuSydXIV6t7IthGS3NK2ZXU0laQQ1
TCuRDdN4p7S5eqe0qjJ6A/W203oIuYq1XVvPq9Ybdg/oi9asTtBkTnc57q52
XGpMySxlzB8dOzag3RgXNM5xvJ3sRJ/DgKtz3gzqODhbdRykdoOTdgc1N0Cj
DoBku0EFkLUcFe04fM4auKET9k1v00kd7ap4RzuOEaNOgyxF4VEt+kOyr8Gi
CY/jUxqlKKa0Taw1WYarGVfyBoCu5nJWb8hxt8xCt+o2KNuAJ4amV+sEbjee
BjqqS6jqPcmCk9MjLFU1fMatvqHe01FVNre9aeFkt6/X2kIKnFTbQVcjbh0n
GSM0N1up47yvrew+yJtDsiBhcg+URcAiGnfW1Uib1qB3V3Xy2+mNatZuMLwd
IZPj420HKRqekuyoZ+eoEh1JLmmMQB1v+3iv9oGEY2kTwdlbl7dxZYGp6ZHQ
9PQw/ctmib63GxvrxrUWnsNW806rV7qjP7fV9Nbqz31Tdu6kYwbfo28OkcRH
Viip7qr1doNVlkIdb+cSIFrTW6E21B9ar/zUOnaLg2HRsiEt17C7aliN1O0u
g6I/sLsVreoPLFqqjqpW2g5pJVuBQhB283TeE9wfEmcHYr3XcZi6QoeHeTfq
r+LZxsZaZ8N0Lya+jYhpadra9/HZG/xU4ZLnqPuoJIwDJgIPnQNAdOdWbaFZ
iBpDz3E0hG6y6xQd1R1WAuM+68DxSBvvCa13IOYbiWKrRGtpH9abAqt5q3c0
5xiQZGaQhJJpB36/o2O6H9LW94+6m9jbfexD0fAQ/ctmiZ7pqmG6wGPMg4ej
R/ews0e3aJiuenT70c0TpYnsmO4stGxutjFhIWqbfo+NQ7NPSaIrO00sM0Ug
llFoONtzy47piVoNJ2our0SlJJVs9QkhuBvYJ4ObVE4MIFrXB/D9LBgLD8Ui
g7jhLv6k4jGej/BbU1Mtb6ROn9TVRXmZ3uT97MnFfKx3Hnb3sz9kYeMoGtvC
EbLa2rMQhdh3iSb2eJYUZIunAkrLtrQPXrirzygyeIMZ2Tep3W5lH1Wt7L3A
jDoNybRChQUhHiE0loI/ST2/brUSjSTg0fHXsCFgTIw0g/7MJqA4PM1NNRGu
PTBwHJsRCxu7p7rtW1x2TNv8dJzmqCNsTrgscJG5/VappUIHYTULAQ82Z5OG
iKqAd9QT6AlgqjfTZcobEkdhAhRxAqLbFhEYqYBVA0V0TJeiYvo8JjGFTF9U
7BXnxeHbHUchH+FiJ8wDNEQwHhmMRwY+jgywFPqTigdxPjpum5qqhQaFufeZ
0nRHRGgYxxGe6fgM8sMD7VTUzgNpsfNAZI8FvV4JjpvUh2M0k9p4z5GAbHdX
WtkWTHWw4IlF5E+645llRovV1ueCjsmI0+lKWY0rRdGnL1cRf1kl9fWX5J6c
w5bBDfgPpcFi0hh8mOjAjN9EgQjufEygEC5GczXeo4MiDNqYBYoeM/tYswES
huw7bK08Xc5G2rHdWkUM2bRd3KxxaFgIaLB5uCcoCm2iCK2gQ2U9y7QisZC8
QsNmlxu4hDbrGNdrV2wvLEIhy3w5UNFFxaUVgrSSVhG5VcXPuXDr5R1FDvEb
uvWz0H9G+wOEzSyBDVAxyaDZwIhAQEUBSlX8Q7KBWDvPoGq5aakKT/SQ2Tjc
zUhUbJplC5htFjAsRNDcIyDZpkGi8wXvd6WVddBQGPDs9Xh2hQFtpfQHpzMW
utLr0BWHqdcVRUAihEUS4pL6o7N+4Y/OvHbbmnVZ7bZdCqPNAmnHnOPRYIxG
C2C00G8xIv5ls/AEXtjcXC3smfA3UDW30ig3w/vbX9eVZihK2PTHgE1rj9/h
NFcaiY2DZnlfXJEAQT1YCJiwe3TmG1l+/pG7tkLmyQrf0kUDYuW0oYISgi6I
uNWy+U43rAWtmrrAtwonrwOjS8qJjbfjiG3RtNkgvcyg03JiNghb5hpRKA0G
xHgzfhvrZ6m/5Q9xw0tbmqu5dRvU7ZqP+riNWhizRRy2YZlLRk3Pk1LJbDxK
k/jQZoATIkUsw0JQGDbHRQuhqIll1ZOeZ67M2XVycBuqjLbB+IUhYc5itjlz
Oplh2/I7FEeJSs1iFoSMICsSVxB/bomTHam5DOmAYzkzps0Mx8iucX8X62Mz
6M9sugiO1dbmKrwJ2mbaWLmjAj0k0HfWlJ2zEnA+PnvdR5ckTnrhGC/932Ep
FAsBHzZnu5OPQC+Kc7dv4cEARc03KFDM4Q0qxeJPeGh7SvtFzWJKSyWyXAEZ
fresQvhzK4z4r/sH3CmpbSqtayqrb6yob6ysb6jeuLFmY31tQ31dQ319Y93G
xjqsJJsaaxEab2quDsC5sBRYsS3NVYBg66aqwLZNlTO3b6pkM3AHj/Hs4gVv
QY82y3d/aVNTDT6Mr8AXNTTW4kvx1bUb6zFSVX0DRi2vbyyra8RFlNQ2F9U2
F9Y051dvyq02cqoMuAFqs1ViiO5a1ForlxpP8aufsSqDGlKJ7lrL1lArr8DS
VQYLLl1Jnb1ww138mUWPV9GNmn2toX5f+IxoZbVqvbEmi7pZpfGuX6KVFcZD
VLCh0njp7YV51UZ+jVFQu6mwtrm4trkEoqqzRFW/Eb+hlkurvoFExQL4jWwG
yaqpGj/e4GKAMAIQCwtCPBASCStEf7xdsbxeKIGRs2fElDJyfEYI5RHmjQUw
D4K/x/9/EP+yWXgCc4QrT//HTv1RvsgydAnWoiMRtRalfZteZ0qBtRyVkfR+
Z8MM4ojglCYziavpbp3UwaEzema+2FfuojFg2871xzEzlG1z+Z4kts0RPnEf
YOuLJSOWgjuuEwELJfobcu4T3CJ2S2DY/tMaNkCIpGDYP8R66Wb2BvAPPUu4
sa8AJeGUPvZDacLXHY3Z7uiye8eAMiQdC9PzFkp6zxnFrk0sRAAoSLtuROJ0
l4NM4oijc4ojWf+S9ESIUc5ztGwLl8AT6SHctDaf4875LGczSYkFIS4hN+at
Mg4wTz9U3/BERfNTXqyiXqxoitCwJsakP3fyC+j7Pb/hTVBvBZiI8lxuCYOJ
Tbhk4bc4jusj8dl5oZZbkniJBk5WBKEUi3PizZPOaL+bM2WvFjrYHRZFkvNl
7pU8mFnpAnbY7ZjnjtAu+TwPynluCuiS7u74BAxaVKdCFSuqI3UWEySgjdYr
kaLRWKo/TFEdpiELppFEkbgdPQzbp6YSpqtaL9U2K8ZTOKk2AtIAHpB8gneT
Th3QOCiOatGd3rX0ohV933BC5N1x0UyR7zLFd3oz9/z+a2D0m/8fo/8ZGCXy
T/+32rxbbDkMkZP6/6DN+39kLKEiPr4z9OfEEjZV0d9mLOE6qftzYvHfOSPN
243Gp24vGufZ1+L0oeXGXzQa3/+3FY279rXdO9oTrg26UdsROUfTQZlJWMwW
WPzW2llQfifm2QVy+B3rMMixSzcYE4cNyu+c6nLsAgnPo9yOriZiK4iFduyN
s7n6toLiQ/LZ/mknpCm14yqpJoJ9AsW5PSfsi98mjMMXxLy+wN6B+b17V8EV
E/yt7vUMRuVej7BcwsH8OXs9O/4Sez3df629HpeO/I3vlLpNlnendO//a3ZK
Xeelf6snDH23dcLwKVcjRzpI4AdAM+l04e4/7Wgh+y99tMD8zxZu8yzOc7z0
1zuLc6Xn6mdx53qcZ3Edf42zODfFg3UWd+YTnsV514C3exZ3+2fWw7d5Zh35
S59ZD2pn1pbR8iZISf1wnFlzLEQuwUw6r54rsmy2OtFIdFh9XGQ9/9UOq1mC
0+o/I7dj+vZzO2Ke3A4XJLdQEp7bQc79r5vbcThxbkfpJ8jt8Jm8f0JuR7Jc
qEQWbOJPyIXyy1P7ZLlQjmWiby7UXt7iXNHOf4JcqL0aX5laP/rmQt2kQv3b
yIWyHb2WCzV8u7lQ9npepNZ6cwh9l/f6aGFXDmGYvAeH6ZPlEE6KlaIjTX3o
k+QQHrydHMIZlEM45xYJhBqfnDuB8IpfAqHfVPbYGUcCIXNkEIYpgzDsh8+f
lnXrGfATZt26ige8iVBkwQasrFtV4WFBQk7luM2e58i6NT5R1q1/ArQr6/ZC
PKPgNrJuE6dcfqKsW9uOJcpH94Iy6hxJz7RmqcKBCNUQCenjlifxTUi3FyXK
mciDTTshPVECNK3UBRp6FyCBQ4NvRnqDnpHurA2wjZk3I/3iLTLSE5kXOwLQ
MtJZUKBC4greKjv9z6jd0KsRWHDKwoUF9DqOCXcdR4JSG/+aAWuJkqCOQ3JN
qjoOvWLAXccRojqOe+q8RRwa6b1eXqPY/YTLUUUcp7oEh48q4nCVDvgWcTim
tPAGENhIin8Nhx2VOSqgPmEhD+OVPEExIG4shSZJ6oRvBdREwgoo/bRFP2yW
K8dOKwzzZZbUK6AUJvW8I52sVquMs5SainiASqHmOIqfkhSnWcVP+13FT5fs
4qfzjuInXxdgx2tOmbkrxwJkg5JZNquK0AcovYpQryK1qwgDVK+GoUNWBeGo
qiCcSFxBOOJXQahXpln+xZ+t0FVBqFelVcoKwqqyOAtWlcYDVEo4h+o5y+mV
mkpZouZb2LlVFQ8eksG0LB7UqJzO3l7xoKuwj+mySvGvHLStmk/VrV8JaU+C
EtIRWUUaoorF2aoyWq+57bMCMHGM4q2KdpV0nlAlnQlqbg275vbT3npOAFHJ
a25ZwLfqVpbcVsTrvJ0QraBA5yYTJbd2prRdDZ0QmRtayaVeDavJi6puk2qK
u2bdU9qp8W84Cm8DVkW8VXl95wgvXB9S9er1G4WOKH4OCsNGuKZwUgEVHMtI
7LaLoTkwZlOTybH5L3XVvFq9gvfOKCXqmcoiu1q9PN9kVLEewDMBq1b9TtEP
gQrVa+weOI5CdasaemW6IZkeVDV0YmgSUS8Qp4NbXimQl99Zi72ikavdxPD4
DqeICyzeAoY/EhZGV8FmCV6OyvqGXhflw9B09+B010D48kDkYn+0oz+K0azc
WlttvOjsPGBu3xvbtiu2ZXvM2BJr3hRrbIxtrI9JX1NdHqsqjVWWxCqLOOdD
Pud8yFGcD4GSDZEAET7cVZobKcsl4o7yfCJ8oJYIZf516zpMy9ca9mba7cHk
JTLpU0hBbsSQEbgV34PYkBBlpGe7zdZr5vkbsXaHcZPcH25WlgTcH0H6M1tp
jQ9lymC4qy98qTd8sTfS0RNtvxmFV4Wbk1tjvugI5vY95tad0c1bI5uMSFNT
pGFjZGNtpK4q4mBMyeeMKTmcMSUrwoltOGPKVKBo/RSbU5Q5VZw5XazzpfBu
RZKSo0br6qbRpDr4Um4DHjdfyqhLZsQ0k3IrjhS5W9TpAEfqTwKGIaFCTtYc
xS/U4+IXGrH4hQYIjM4b4QvXI+3Xo+evRVuvxvCbznQnMGSKRn+nuXlrdNOm
cFPjdEP9dH3NdG3ldHXZtOQXypsuzZ0mfqEszi+UMV2QPl2QNkW0QopfaI6D
XyjLl1/IQb8lILH5hXRq1ASQdCTlF2LEx5SEXUjj3jots3aOa5CQSbse8w7k
0M5E3Fujftxb/ZHOngigaOuOnLsSbb0SPdsVO91l4ncl1gvOvbXV3GREGxvD
G+um6qonayomq0onK4smLe6tyeJM4t4qSJ/iIEzmrZbUaDr31jhAyU+bKkz3
cG9RP0LOvVXjAMPBvXUrMGz6OF/uLWvy3pJ7Sy2fFBgaucdfhaeuj7h22q5F
gUjLpejZi9HTF2MnO80TgmA9ISLk4hsboxvrwnXVUzXlE1UlExWF42V5406e
urVenrohwVN3N+7dmqeOuroR042OzaLFhj+HsLWPpmPj4KkbdkxhyR14a6Y6
T02Uxvao2LlbpUmTIYF3fE4m+aeyPQ6QFrbdIKa3li6iZDt1gejfjrebR9ss
6iB/lOCSzY310brqcE35VFXxRHnBeGnOWEnWmGCrcbA9LhkWTJzE9vhBX8b7
vUGi856HO8S8ubA/cxGnfFwyTOSbgvJR598UlI+lDrwk5aOLUfikA6+TFhuq
pHzsoZPwzkEH5aOa6BDRDA/bo0/FjcaPqpOot2rnFNY0kQQTFgNrp5MflXhR
g4RWSjeHRtzcbKmDFltqP20PQldbumNnLsdOdcZOAKZzsaOtpjqgFDDtcsOE
SNesq47WlIerSqbKCyZKc8aLs0YL0wXP8P05Kzhb6pJhoLB+QT9AIR5bzpaa
9tb1tbgJ0lrirb1BlKnEl9pLfKmLBjj987CAjDq1UQNr02r7qfDS+FI5Xjtv
Cy+iF1aCE3ypQnZMSS6oJOfulpQMNy//vYTuos2fSzvlnH26fUASHCv+3ACu
ggUFhpy9VWMfFgTEBbVO9uE+2kuE28OsOHXJPNFhHmsjpsXDZ8yDpx0Md5IS
0sYNvjxWUxGtKgmXF0yV5kwUZ40Vpo/mrxmWjF3ZSziJ6oJ+QROdxsEipuj5
3atfuxIkXuh7OC/0FeIffvMa3oC3EYIL+hTdLdwa70cm2KFjOnaSedhwYnco
EXa0pdBynVNDW5Lr4CkfFxNKLrlF5L/y838UjN5e2Kyg8qSVYSqSsrCqbBuI
t8vBJWU0v4QYCxEpdSoReluc3vkuQm+RJqORqh49Hz/cQgSZB054oBK8txIq
BF8xix1fNrLi7PgSrU8TTu/3Ep33m9cEQqte6Vr5MtF5s9DyX3eyebhHHOuv
dOG1NfM5kzeHi7MTD26gRvHj1IuamNZjdnNlweRt9dqzWaI5p0QirCixUBeX
DpclLi4tb1cxr3Zp/Y9+4nr801tpptbZ7Cuuz/7LJ3isXZ9rFhWrV2o8f9nf
/V876Dc7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->93168425]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "5"}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#3", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->80561626],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->94033834]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26320],

Cell["\<\
In some plots, grid lines can be completely occluded by the image:\
\>", "ExampleText",
 CellID->197794532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", " ", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "Red"}], "}"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "Red"}], "}"}], ",", "6"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355770928],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->87729533]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mesh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mesh"]], "InlineFormula"],
 " can be used instead, to place the lines above the graphic:"
}], "ExampleText",
 CellID->250395265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", " ", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "8"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "Red"}], "}"}], ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "Red"}], "}"}], ",", "6"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168775595],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztvYd/XMl1JlruRpPe33vP67e7sqxkjWzJzxJnCHBGq2xLsqWxJkeNNDMa
TuDkQHKYEwgQAJFzBgGClzlzmBMIkADBAIIJOQOd7h1Z4U/Qz/udqrp1696+
3eQo7Hrfe/w1gduxGuerE6rqnO889uqyt9/44NVl7yx49Z5/XfLq4rffWbD0
ngcXLcFDwT9jjNXjv/HXDNf/jiv+v/53v/sdntB+/if8DOCpL+J3mvzNgrj4
Hf/H/kY+f4/8ncbf9ef0M815lft9zOdzvpDwjr9JeCSY5LPv8XzW5+V3TfyE
u//ML3k+83N+3z/hL0wlAe8nfl6TbND3E5N9N/+/K+AjiWR/73/6nRs17/vs
v8X9NyXODv2n/Gj+L4TLMvz+M/GQ6xukeST5556xQ577s/7Ez//PHk9/nt2l
jLxzx6s9qe6nGoOw/Vv+2iNHjrje++/qlf8sX5f0e/61euTGeOTWeLhvYmZg
cnpocmp4amp0enJ8emJyZnxqZmwmPBYJj0YjI/HIiBkdtqJDH8eGfhkb/FVs
8Ndx3AYCv4kPsOBv4/2/NemGS/zI+G184Df8hlds31L7b7HBX8bonVZ0GJ8S
i4xEI6Ph8Oh0eGxqZnxiemJsemJ0ahJjD05O90/M3J6YuTkevj4euTYWvToa
uzwa7x4xu4atC4NWR5917qbVdt0602OdumyduGgd67SOdFj42w+dsQ6esg6c
sPYfs/YdtfYesfYctvZ8ZO0+ZIV2H7TYfbjAXTyIp/ACvAwvxlvwxsNt9CH4
KHzgycvW6avW2evWuVs0HAYtqDPwBfA18GXwla6PRfD18CXxVfGFSWRTk/gT
Jkhk4xBZmIssJkU2zEU2BCH8iouM2TIb0GQWABR/dneIQS5y+MlpNfz4XQ/v
jM5BYwGJWL8/aFEHtIgN2qQN2sjU5NDU1IAELUygjdmgjcS7h83OIev8gNVx
m0A720tyhXSPA7QL1pF2F2j7jhEse23EAoRYcNdBa9cBiy75/XsFgnsFghp8
H7XRx+FD8dEnL1mnrtBgGNIF3wjB1zMW7ZXwhfvFpJ+aGhHwTZP8pqX8Rh35
Re8svzTcUXhJDD229U4I8m9AapfqG5DaDQTpG4TkN5A3Oavm/prgG9zeKuGD
wuIj4ingmyT4oP63JsIwBZANJHRlNHZpJH4R8A1a5/ut9ttW2w3r7DUO3yXr
eJd19LwN32nrwElr/3GvwgGtEJADYgctr9odtw6etPDGj87Sh+Cj8IEnukmb
z1yz2tyg4Wvgy/SMxnrHomSpJmxLZYMmLNX0DIkswkUW59NVF1nARi1RZi6t
417tMw5KbjW3h5xUQ5Jx1Ia0tCGlpv85RqXR2b2/4qDAcn6sQIkMQ0thXWcA
ygyBgg+G7ZVWcHIaI8Myc1CiEpTheNeQSVYQoNziVvAaTXZIT4By+ByBclAH
RUMkAESCu/bz3xoyeImABW86yGHBx+DDpDW8ZJ3uIfwxC85zWC5KWGxr6HYg
kJFwIMoc4U/UZSQciFAnks0sklEiDp9VOGBOuqBPMkbUdwwbilk2EnNxH49y
MBzrFieXJMAYc8Dwc0kEBlm3WDfAGDQvDEiXBH8BOQkwILmjHTYYtkvS1UPY
tbSd+y2WDkBwvcutJ4m+6egFqSfKN8GwEhrDpjJuum9y3LltWjTjpty55hy4
pBjJKHRnRKJ62DDIxxnxMWEjHuXQQZlNaKTj4t/4g9ta6z5OYq8oRpgZ192N
sFcudzMcuzgU7xwwHXvVq9kr7m4wswGIrhpCL0j8+62d++Bldu4FKriYI1DB
k3sO+SlIu6MggPyMcDb9Vn6dgTDFsVtjsd4xr6lPbbfsyTvEAhAKC4rZS6JK
+7UvKn+lUNHQD+sma9RjsjzRQXQogOHkaBwZmgc0MMv4VUyig1dsba3T0UlU
F5hG4VB8bNcI2a6LgwQQqcstAkjZLqUumOwAyDFcNjo7OTo79lqhHXsQx+EC
d3cmQYg05hyP5rjGnBRuBfarz9pYYyAgUfbLx614bYtLYEkQcskspd44A3oi
bp/wkU8JDSQxJhRoNo2a/ks7pOawqKjaqzTJrJgTow3FuwbMC/0SFmHFKEaz
nTxmO8wQYBEBGtmvg1JdgAPw2L4bgdr2XVaQLubiAQEPXkLYfOQK1ZTLB+TC
sQhTlldtwKt1CVOmOZZkUZIyZfhzPZNZyWkW5JTSv3tHcXl525B5ZkBkWB+I
keaEMBb9ZnO5NxkyWuuEQ1EmbIbQUEqSaMUiworJqEtYsT6TrNhNMi1KSTCn
4QswvzHLAUgiGts5Gtt2WaFtOy2WgQvc3e6HCPmXk9rC5wKPwLglw6CAA2a0
c9CEcxGWzLYtkdveCMy1VkycuaQtNihcUomIfE4hckXG516dVItSoSISeq9a
OmOxEOGR8bHm4IEKwNPsloy5EPS7Fp8CFWW6RmOwE2S6EHYN+OsIjI3QEZgf
oLKHexUyWvukdgAGwLF1hxXauh2eBRe4K7DBCwiYA9z32zZM6ImIwYQBE3qS
W2lQaDxgIuzAV3IZMG5PEvTET1iRYRaAPFjQmcUkLR9cnPVKQnThmgPafkHi
aISOGs/iCkKXQEfgIvzJls31ura4zJftVbzLlFF9mcLdfp/mVewlpoTmBMkW
6AhtIVXRcDG2W8Y2K7RlK3wLLnBXxwghgdIcAuiEAxCpjQgArlk5FQZC8vO3
zc5+E46OA3S3s3kmrIUBXGTMT2YpfYvHpaVYuUBV1ZjRiAup2TTqXKEouLVu
rncwmUnAJMXKf8SkhcoAxURkxK65jBhhcpqv+Y/SrAcsOxUmAISjYWy1thjW
7NYt0Bhc4C4exFN4AenNXnL/ChPduVBQBlN21dpQbmCB1HHTvGBjkjiN+5Os
KHRMIB8WgDBYUFh/ElEafvig8WmFhjKczgzQXJln9eoZkAUwJI0YiovfbG6U
75htbmnQsdCjLn3RqHv4KyNxqSJ8I0ZYLwjHWTG20VJc7r8cJpECDoUFVGEL
BwI4bG61Nm+2Qi0t8PK4wF08iKfwAiMBFxGQSVzaKLwjS3bJyi4xzl6zzl03
CZc+s2uAAhAsphLnrZ+Lke7YtjCjupxSRcYiJtfhT7SZutdXIwUwFAuqwdgs
+pEOjPAQnmppaVAB8ITm3gUaAz6+JOagMQiD9TEMFvmSS44vEe59/zG5PIE4
AQjCK7JT21xQAInmZouFmjdBR3CF+zoupC87LLyTnIxQFtvDAHHpXi5a2cUG
rSgFKLcIlIsD8UtDcYTs3rnrDpAcZeGiYkpWUmdCUV9UHK9yYciCkcAyGvi7
gJnwcWZiNBGRCWWh8WZjOJbOlYL0ormlYcofDI/3iKpNru5hvrE8BEv1sbBU
umOn3cmTcvFOXn0/CRN4KDAgbYi9pdkCCJuarE2NwKMJP9Jxhft4tEUA0+pA
sm2X9Pu6/cJIYgdzfZFBO2FXrbZeq/2Gef6W2dkXBySXh2JXR0hIvfbs9V1U
CiEpEz/D5ymbBTml9B4U7vVz5AdjV4ZJHZWZVK5LW+ZzS2mrCg3Gx5tN0yB9
2rZPTS2NCodRzUr5r99H7D1+goIbql7pyLF4pxjrjIyxBBQ7ORSwOkADFoiU
YrONQ6PV1GA11VuNdRZLa6y1AnTxNTyAhwUueCFeTnqyVToVGYkJRI4R6sKd
ZBYYMjLucRDp6ot3a4gksyf4o5WND0AgLKgmLwvRDE7lQdpvWoT97fjFfgVK
VK1XNFDsKEybASxoj5gmweE3/shcoR6NzU1j3HngfcKXO9EvVxIHGXn6QkZL
InNd7qyQO293ol8PMpjtAEdoiIKlsd5qqLUaaqz6aitYX2UF8DuAu2wOHgZO
QAkvJL1psVqF0tjORUTKMIsyRm6z1uYZciEp8BFu5Xa8qz/ePRjz4qOZFfy5
LssipBbwl1oqlGhKXDfP3/QC1esGqp/P+iFbgcTEYAEMHZig/zPjhBjLmOA7
80JlGpqbBDZ4D97pWZwoeGh9MkILtc5hx8OrjS8ZbWnw7NLggQIAIbgOqIQH
m7pKq7bCCtSW4z9+4y6bU1dlATE8iZcQVA22KtnGTeFEEcARjtNpa22OIRcy
lyzH0yTByZGY2+RIiQXH6YeAS83zVJ6fZsU18w4QcVPqUacAZM+CfFiBFX6k
0egZyprVbdqkoBnw7tg7ykMef0SiQ2v665rH5wt6yEigsycBHSgBACLN4dZM
h6amzKoutapLrAB+BXCP3VdTbgEvPIcbXkRA1fqgtFWhdIhGhfNZnW24lpu+
KA0Dpahu7YTQdIUSZogFIJ8gxERopUSHzOrVpACpsdSSU441ORXEYEGJEo3G
MhxVmZqqa9qkIOkTm15j4Rtj4d7RSM9IFHMNf0s3X9OLqFigckaPw3hUzFEx
dx8yd+03d+wxt+00jW1m6xazpcXc1GQCmIZas6HGrK8y6yrN2nKzpsysLjWr
is3KIjNQWRhnaZVF8SrciukWqC6Js3+oLo3XlJoEUBVXI9vcCXeEZQ7FbLvJ
iGI2IDRYtd7Qo7Vk6JDEODq9tsR0NZISSxvhc5prEwkt5e4YLWwvp4BHhCLR
xMEGudpiSBYAFrMwLksfsvWkpqlZgYIpRBHASLh3KNwzFLkyGL08GOseiOEv
Qixyvi8Blw4dF9gYc+e+2Pbdsa07Ylu2xja3xlqaY5saY411MUBTVxmrLY/V
lMWqS2JVxbHKwlhFQax8Y6wsL8oCZblRloarctw20i1QkR9lX6soiOJ1VSVx
aBMQkvpT79IfBQ+UZ8U6gyK3O8IzENOCN5fR0SUWIJEFhSKR0AixlPGz3H1I
AhLp66g+pKayXJMCGDk4yP9PsQyhMEJnqptabvNVPTdmPEYbjlwdiFzpi1zq
i168Heu6HbtwK47VQvvN1AjBypjbd8WMbdEtW6KbW6LNTdGm+mhDTaSuMgKQ
qkujVcWQeRSSBwpApDQnWrohUpIVDhZnzbBgSdZMSTbdWKB0wwz7WlluGJgB
SSgWzB4MHtk52xsJNdJBWrbaEBbOAcmxcKYDUp8Dklj0aEYu7CuxlFEBDZUc
HNuY0lC6jYMSQewsgPECGJAF+21MGI3MMvr5botQnqqmFqE/N8a4txmNXh2K
Xu6PXroVuXgj2nkjduF6rON6/FyviRDFC9ApHSAsEWHXYq1bIi3N4U2N4ca6
cH11uK4iXFMaBkaVBeGK/HBZXrg0J1y6IQxoitfPFK2bLlw7FSpcM8nmFK6d
LFo3WZQ5XUxghctyI1AzWL+qYnJQ0tLVmk31ZDR1fJauMJQHInzakuBzy8Hn
yoiyPLbQxsMsQGILSphwGSKsUu0ziyOiZBBxixp3j0YqpAbkQHGsQhiUZUhl
4QuaysYWEZ31jmLFD2cDoxYlrbkZ7eyNnu+JtffEzl2Nn71qImaVS00dlMMK
FAS+cDYwapFNjTONtdP1VdO15dPVJdOVhdPApSx3unTDdEn2NIdjpnDtdMHq
yfxVExtXjIc2Lh9jc3CBu3gQSAGv4vWAL1KWG6vIj1cWmtUlZk05+S04sEYd
mu3WkmWGCg72J4Om1+y4oaCJX+LCcuwNR4cFIA8WdKRFEBFWKXVHrIUFPMcT
4LEtqtyhuDrqQogFMCyNGgJKfPS5BMZ4pLxhM14BJYGTvCL8/0AMhgx6cv5a
rP1KrO1y7Oyl+Olu86S+MeYDiUX+n/xMpLF2pq5yqqZssqp4srJgsjxvEqiU
ZE0WZ5LEC9ZM5a8kMPKWjeUuHcn9cDgtZ/Ewuy/nw2Fc5y4dxeOE0MoJvJLg
ySJ4yvPgpiiCQChRW2HWV0tsEAcCm8VLDD1wkxs5Hmx6XNiIvZzLHkmNOZJK
IwVKw4WQfjJU1CZFgqtztFTsU/D9PNr5FMlWGJEFMCYLYtTrHAyWRpMj47pQ
E/6SsoZWfDuYRIQWl4b5oSSCgFvx89fj7T3xtsvxMxfjp7riJzvN4xc88RkH
Z68Cx6LgDEFAbaSuaqambKqqaLIif7wsd7wkexz4FK4dL1g9QcgsByyjQGPD
osHshQPZ7/enZb3Xx+7DRfYHA3gEjxNWS0bylo3mr6R3ASVu36BBFOEh1EPM
RxDVSYgWLTKgPokrIAcivlJVEJ3XZCYOdBRKXGYBAiooLM8Ne3anighEyJgK
KLmhRBuvF4doaYIFisRqNBYAXkEMHqSx6UvM7eFPlTS0AtLLw+IgjGe99JEy
tsO5XDXPXDIBzYnz8WMd5tF2e0PZ5V8UNAh2zcbaWF1VpKZspqpoqiJ/sixn
vGT9WNHaMaCTv3KM4zJCuCwcBBbr372d+fatdW/dDK578wabh4vMt3G7tf6d
23gKiAEsIJW7ZDhv+SjMHTSPNCknVg6MuJXTMLI++MAQJu4uMRK7PbRP3R8X
ZzrO1ObZHT00sW2JpUJGBIwSnMSAkfaWaDSxAds5YF4cNLv5EQLHJx7EoMGr
hBD+4zebiwfxXYrqt+BlWPx3DdEhGB243KbPgb08c8U81W2e6DQBy5E28/DZ
1LAghIrXVSFgjlQVzVTkT5XlTBavHy9ci7k/AmSgBzmLh4BJlsTk5ro3bqxZ
0Lv6tWuB1a/2sAxcrMFtQe/a13vXvnEdzwIwvAwvzv6gH+8VakT4kCNCKG7C
0mn4WO+9Z9Cej8Bnlx8+HTo+jsTEmVuXkthIgsRSrUFVNL/viB849sbfuRuU
cXe+j1IluvjBeKB7xEzDeGzWZQ6TQEos+Ok5dm8hzwbCGvPCIM+C5ZtnrtRl
+4jyEE8Sk/tnHJqtLmgQQ2FRgoVMpCJ/piwHcxw+Bs5jNG/pMNBxcHnLxuXV
nlUvX1n50uXAil9cYnNxsXL+FTyy6uWrq1+5imcFXkAq851beO+GRUNQOzgk
8kaZ4ZINCMbjOkDvvm3QMig5QPopj9gupRTc6xaWCJiTkBqlEwxxqTGIjZAS
twDEx0JCesoJ+WuRvvjy0SU18DWSsj4w1KNr2Axy1Pj/OFtAfoZvAuCG5wtq
DQVTe5917rZ19kbCwWWbfXCpkNrNkTIUUrQbQEgVhcs3IkDjSrRmLH/FSO7S
oQ2LBgAW2bM3b6x9/Trkv+qVqyvnX17x4qXlz19c+rPOpc9dwM9lP8etC48s
f+Hi8he78SwwBIJ4MZCFCeQ6NQAbiRiC27zpkizgZVYIg1dhvv2mgTmTGi+l
UCcu0WwUy1YpNj7RYYWE2JhLbmmQmydWSEvMUd8iNjL2OBsZLq9kJ/yqUaFe
fFQLJqxz0AoAs0AX/ceMAT4sA3e6Bug7AdCN1ZQIIUBqU5mXlxMO/bUdaY6T
ucWQezeEUzUFwFXFsYqNM8CpKHO0YPXIxuVDuUsGNizsW//uLUBFivRKz6r5
VwAAwAAqQOjDZzs+fLo9sPipc+z+xU+34/rDZzqWPHt+yU9xE/h1ATYABjUD
zMAbfoo7KVIwQiub0BLu6a3Xjfpqvg3E0XK5p0Ne9yTOtoXPcJsl60K/FJ1H
ct66AvFLu+Ps+NACwIZtlx9sTkKw0m8+fMdt+gbn+y0WxHdgX7/Ageq04aJg
4baJF+VVGWQAb3LN6pVJNHcAbQc/ZdNAgzmqKjEr8qOlOTPF67G+Gd24fDBn
MQIBBAU31r1xHbjB0EFrBFxABigterJt4eNnFz52JvjBo6dZxgePncE1Hln0
xFk8tfgpwhAvxltWvNiNt0M3YUgRZUDREK8r3OC2gNubrxpif0jgplZOLtzs
lZNTV+Jjnyh5GILjcktz5DbowY3u6bVCQTdytPHRKsHbIcDTzhVVipe0kbra
3SSX1H4byOGLpBGEGR184w2w4smcCqPNxuqUXbtxNBlce2y4NlvNTZCNhAuz
HJ6kLDdanDVTuAZrIqyGBrM/uA241r7es/rVq0AM2gXNAQiLnzwHWADS+4+c
ev+hk+/95ETo3X89zubiAnfxIJ7CC/AyidjzF6GcMI2IO6Bpwi7qcL3+siG2
IQRczU3uPSJtF/zQaa2OBH7MtlBn3KKyJeVGKOhBiJ6lCiz2344cOfLeO8b7
7xkfLDQWLTY+XGosWW4sW2ksX2OsWGesyjJWZxtrcoy1eca6fCOzwFhfZGQV
G9klxoYyI5BTbrAgUMitpBsLQYVYOq5ycKsw8OwLCxbhdXg13oN3ZhbSp+Cz
8In43JWZxoq1xrLVxtKVNCoWkPgGiILxbeDQ4SZgfjCZIaPXfrHl1edbX36u
+aVnml58sv6FR2t//nDVcw+WP/svpU//oAgIPfHdjY9/O++xb+Y8+vXshx9Y
//C8zIcyMh9KX8dm/2TuWvY1XOE+Hn34gSy84tFv5Dz+rdwnvpP35PcKnv5+
0TP/XPLcj8t/9pPK5x+pfvGJupeebsRIGO/HP1yEsfEN8D3wbfCdSE4fGFhJ
4bsuWUbfG98ef8Oq9ZqcNtpyKqK/PLvUkVOOkFMQcgrkVRt6DU5ynLSdIXFg
IvTJ2CoPhncd8OYZKXuowg7ME+gIpgqsIhwSC0FvWAaucB+P4jl8U/JRl3j5
U2dCgoHaZRBGb6u5uSW2qTHaWBetr4rWltNGaUVBpCw3UpIVweTGEhb+BOtU
2ChEcXA1UAOYLyBFtu6xM+8/fBKK886Pj779L0fe+uFHb/7g0Bv/dDDtjX88
wObh4o3vH8QjeBzPvvOjo3glXv/Bo2cWPdEm9Gr5C9wMLuhFSIkAHmNhxMJ1
M6++0Eo2kJa/XKlqaIM8ceNVOA9xUCv9BzeDuud3ySuN5JUG3+CJLXwq4Ry0
6irlCVdzsz9gzhdoczLCyYVyM6hgYyF8EZaBK9w/xfflMLVEbSFZu46ExBwX
VBjbbG6KNdZF6ipnakqnq4qmKxD8IUxfP1W4ZgrWiKD6wIbqlasEFbd2QOuD
R07Dtr3z42MCJwDz+j8eWPDd/Qu+szfttW/vZfMWfGffgu/ue/17+/E4kCPY
/vkwXo934b1wYIhAOGAXEaisWXBNWEEB2MvPtZTwtZYErJLOnBzA3N5eBBsH
TjqGUPf5J73y8kQW3mo3B6WaMrEFLIFqbZVHxRKoQ1o+sru4grC66MDFQvgC
LANfBPfxKJ6DGQCmonjgIzs1ep8/RPijzab6WH213Hsoz5sozR4vzhwrWD22
ccVY7pJhDtEthGxwJ4gfuENqh7MBSlCQt38EfA6/+f1DHJ99wObVb+5+5b/v
Crz89Z3sgVf++85XvrHr1W/sxoOvfmvPa9/eAwABIxAjLRMq9sgpcl1PtyNO
RHi/cj7XLxsuGN6idTOlGlx1Aq4GH7h2i5qHY26TpGa4LbWTUmopd8Orii0H
okY66nIgUrmvh33UiVC64ADFQhiUvYEr3MejeA6W+ki7TFqnQigODj5rVyI4
zfhDzYaaWG15pKqYdiBKN0xwcIYRlOd8OAQhQVTw8ljCIkYjcJ4mcBAVAB+o
hLBwr393v0Lm5Qd2vDRv20sZW1/K2DZ/3rb592+f/8AOPAjAJFzf3I0XA883
fwCIjnAryCF66hyieQ9ELz5RD42SEPEdwBoPRFoIpmenyoLHM5pSeaWWEh++
I8zPujhEmwREWxwtUolLHg2mMph2mhViSBbCoGzeMb6DCvjw3Npc4yO+MXTQ
LorCp1Du+l65ByGjuU30JzbUmnWVseqSSEUB34OglS2C7+Eciub6XeA8dwGz
HE7ovYdOwgMBH0Lme2TToBsCGQDyi/StL9635cV7W1kAv9n9v5hr4CEPXng1
YfS9/cAXJlJi9NgZiRGs3stXMDAU9/lHa3KXjmBBrDCqAkZlluMlNLeu8omE
/ZGaZFc/QjRqfpPUUuJTlicOVCx9TSDXcirbL3E+8LEUShiOhTAge0MgIwwa
4p1D7mJO3azhL4GmYjKIPSJa0ZZFK4vC5XmIfSeL+AZR7lLaSV3/Lnkex6wJ
zXkY4ByDdQI+cDKEzDcEMtsFMi/M2fz8V1t+/g/Nz+P21Zbnv9aCR16Y0wrE
8KxACyBBl1771h5C6PuH3v7nw+8+eAw6SQhxv4TpAI+H0RFPYhGctwzr7Mni
9eGyXNpfqiqhiV1fRd+fJnYLn9h6Rt4Bd8VKotTSSGppmOWeyMGT4ViyAauB
eKWaEZrWOpmye72ZsqLij3SXjzoLw7IM2DPSmjP0bRCUKnhk6UdCCg/WHPC5
GLGuMl5dEq3In6HYIBNr17G8ZbSvmvV+P8IsrDlVYAC3jmn+zoOA5zBiNiAE
W/Xy1wmbl3Rs/p9NP/v7psBzX2lkD/zsK424/tnfb8KDP+eAvfC1zS/c2wqc
YAVh8wAw/BY5JMQPAOnhUxQ8PNOBETEuIsjn/rUi670+fB+4Q7l+ElPbDvWc
9dNWv0RW2/qQjzhNCZukTG2Y15BaSg0qyoREIJe4snNqOjiJzLttb6SVypDO
2uMBDxbCiCxDICP8DdYN+92Fa/iUbT62jatPOSZItCxvpiRrqnDthDcqePkK
XMKSZ88jSIYrxzyHICFOWDXgQ84mYxtHplUi85Wm577c8NO/rQ8++6U6dv9P
v1SP65/+XQMexFMCJcCIt+CNeDsQhhriA4WZw0J30ZPnMNyy57tWzr/80x+X
Zb7NQ/GlI1yDSGTlQmTKxmmuwZv7rZTohAMRBEUSS5kZXLCGxsLqvbIw7o35
3Xl/O/Z6i/4EQhhuNsZj6bigUujj1opMQyEiSz92yVDAY9BqKzH7YChot6co
czJ/1TgMCMxI1rt96968IVY9MGhwBhAXBWkSkX2IxAAKfAnE+/zXNkPaUBII
HxA8e0/dM1+sYWlP/00Ny3jmb2pwBw/hieeAzVca8VK8gaOylVD5xm6EcXA+
cGTvaXYNngerWkwL2FauMvxsI4skVVEQh12rLXdtObQmTmQ/Sc2CpFLiIQ5R
SrJnyjdGpX/TracnZdYz0FE51mwMxtLJanGqFKyvXWAo7yJOIKT5MuuqxJZp
vHxjBF+gcO0k/uqcD4ezYb7evolAydaQDngXyArzGC4B0iPb9cAO4MHBIN14
7suN0Idn76mF/J/+QvVTn6tioac+V8nScYX7eFRC8mWBRwvhkb4VFpBczT8e
eIv8DAXUwoRhCjz9g6LVr/Xw1eqAHQZwMeXJmavCgMSMVb2cSBcTmwU5pbRc
ecvhziaK10+X5YbleaOmIMKdyRzzXe5qP0VjwoloWIiGy1DMNXhu+RrDVa0m
qnGEzeIagnisvoq2+6tLTfyJZbkRKCpMA2kIXL622HQ0hBzKR3AoCKkQWCHI
AigvkHo0k3r8bf0zX6yFWjz9eSBS+eRnKkJP/HU5y8AF7uLBp0lZagkWqAmM
F1cTfAjiBqgcuf8fHaFlKVmuNkRnT/1TIUVnb1yHupKOLB8jYWUitA9X5Meq
KAWF64g6q1CzN6HyThcWySqljsBq568cK1o3yQeS+RQqenayLXUrmQDMbAzG
0hVrw7LVhirq3KZbK01BYK0wEIaDKyvdEEEcSts0QkG4f1/50uVlz1/8UCnI
j45yBdknFAThFOCAYOEefvq3Dc/cU0uq8fmqJz9b+cRnKp74dBkLPf5XZSwd
V4AEj+I5vAJaBMNGLoX8SSs+RTgTRGQAW5qtx88g6HvqewX4Bvge3JNwNVkJ
Tz/BrUlM5DTo0bIMx9zOXolJMFWwWZBTSh3hyI8WrpksyQpTCFbIUyd4rCyy
/Z3kSncdmSrvF5iwEA2XoTOaLFtlyDJbu0CqVTl14UKq5IEBRkWcXpwVKVgz
lbd8bMOiIRUTLxcLFijII+RCYFpelwqyE4ETZjhAQWQF7wCbxI0VqQY0A2A8
9qnS0GP/rYRl4AJ38aBUli+QAcNb8EZEA2S9oCYIlL+9VwRg5OAfOb34yXNP
fDef9tp4iCyiL8SE3KbMUKqJk8Mgjbzaa5NGXodFY3QhWaXUkQ0LB/JkJGHH
4pqaEP5NGv5+wGCs2RiMpSsWjaUrDb2MM0FBYIO5ghSZWJyV5sSLMsOw02Jz
DOvHNQu4gvy8CxZdKMg7UJAfSAWZTwpiIGACHHALiKngJeAunuSq8fhflQKH
R/9rMQs9+l+KWDqucB+PPvFpAUkV+ZQv1QmHgk/BZ80XMdd395F3/5FQk7NP
fCcP34DURG6l9XNrMsFjVEr94U7XrLO30hzLlVxMbBbklFJH1I4dHyZerjKM
KEFPZom7cvg1u+UaKQR1YRm7NeaMpSuM7bbJkkVrm2U9Do+xLNuDmOUbzZIN
MUT+wq1jVeKKsZ5u/wAr+p+cgFvHHFYehHz6V1sAinQfX6h+8rMckU9xRP5L
8SP/d2Hokb8sZBm4wF2C5VOlZMM+W0munjsUWC+hJuRN+IpfxMHkTR478/i3
85baixR8JXwx55BH7JfZJ98ilYTUpNlWE3fNnS4sklVKVJyB5MZcnEKJkjgG
EiUwyQZShAuSvSxE0MzTqWaWrDCccme7fk2sRSQq/ODMhcrycVorvscj31d6
1D6LiHxpLQKz9a09WOnRQuTeLVi1EypfAio15EU+U0EGy4bk4b8sePg/F7Dg
w3+Rz+bhCvcdfP6KHAzeI739lxvxWfhEfK5tww5IG/bo6ce/lWsv821wyOCr
g26YFi4zO89H7We2GgmmxSuzlBUKcq26XKxVY2WUO+lCp8lTWeEeiciXiAmL
cwO+IYFxYyPKn51FPF8nwkDyKNiFjb9LUdj8kFzKq4QNFolbsSj/OcdG2TBy
Jp8qhc2ygcl/6C/yH/q/cNtIP/8iH49IgP5rMRm1vy53WTQ4/ntb8cmEznds
dB489sEjpx77Zg7tNr/gQgffFm4QzpA8TAEVp3jQUYGrkSAzARAjqaXUnfXv
9kEiGKlwzRTNAxoploiOz0h7bPMpRkojfO7fpekOnl6y3HDVROtuRkBU5gsR
D4vFUt4L0UeIl1QcBgcBN0EQcZdPEdinyx/7lK07UBeOTxAAsXm4eJggkvgg
FCB8uHWjVczfNXCP48VHbMEQPs+e98Fn9VTxepGuHfPio8fKmivQFSgZPp/V
8LnNt+PUTIgmxSf5SJxRTjLLsfSdGjouf6PW9DIISIpO5ju31oplpC8639g9
//7tv5hrYOGBuArokL/5PPmbxz8tLFsRHA2AgMawAGFz/0/+z41ciTY+JBD6
S5i4IjJx5H8q8Gbpf/4+GUInH02FUJjvW/kj5Kn5Vjw8Ox25sTRcpN635DgN
3RVOCWX/SXDalRqnpjvjtP4T4LRJ4vSF3wsnJ0645w44pdSkVDi1JsFp113g
5LZ3whutEX7vDvZuq2bvdu71WFY2749q7BL9USpjB8sF+/WY8kfC2AEpae3+
ws/afU5au+d8rJ294Sy9URKMslJaO9tHfCJr97mEWMEOGfNinkjOiRWMBKYZ
e5hdB+VINOTcnQlxnBMrqD3lKkstP7U4bgwzBfPFP1YQy08Zx2190TdWwGKH
sJFaFCBw5gndUeqDZx9LEiu8eK8XnXcfpNXoY9/MpVjBG8lxD54lI7kUsUKK
+OruouwiPcouTYiyEyk0/KLsjKRRtr450KCtfUoS1j4qysba58VLOjp8f9m1
OfD8V5vV2scVZdsAhSjMzhCIyFUp3795WoXXX2nEhzhbBByUt73htbb2kbvN
6oAmrqfRu8LrbZLJKjG8ThJdJ6xIV2FFGlYr0ppSUTJmH3I2y0NvUkx9L8K9
Iv0ocUW6I3FF2px8RbpuxlmRvnVTX5Eu9FmRbtdWpA3P3lNrx2/OHgGQsFek
Ra6NAhmzyf00e0W6nVak33FWpAs9K9K3buoLRWdFWvp7rEjvsE+wYdEA3x7i
uzZ54gSVF/JVuWpg1ebmtgRIxHYaC9GG2jy1kYbnlrk3b1zb/2Lh4+xummW5
cXyD/FWTuUtHsxeKzZvelfOvLJMHZPJw+c0ffKS2/18iR9MqNm+4ushFqdpI
g7lCeM1CtImT7tpP0xai0rloe5wYAyNhPIxKmzd21gZiFHwz2rxZpW3eFNub
Nyn3uPQJbEsrZTSd8yHf41w7WZIdFsfMYo9THDPrquIZRt+zm037m+mKJHjZ
amNn8t1/eT7m7BLES7IjiD1gr6X9ekPsEth7N177JTWFdpz5eYyzoWZvN0Mp
WAiLHpbO1aPsCXvTWd9KE2czQkno+PL7zvHl4qfOPfm9fGdnAD74Q3h7vruZ
NVNGPtg+MbHTJpqTbAXrNOJslv/epnYqQ+c/43L/X2xsqlNlRf7je/7jPphh
oX3HYLvUkYznGMDZdNa9fo3pKEpBvDQngsknszVpl5Ofk82/svwF+ySZp8i8
+YNDFJHZOwQABcbH2XSmI5kqte8cgAMJ0nFAhrPfzA9n9C1nsSGgH5iJMHnh
43Rg9tQ/Fqgtzg0LB/PkScCkOAnQteTuD0wgJpJXSj3h0YQ4L4uozAKZi9Hs
JsHQRhEMv+pkbjadlaXvs8/Klq81dMZN53DfOUrmmejCqRTFy/LUQRkPku2j
5JUvUfKFa0ONH+6/8o1dWM7QQRniZHk44zq6hFKwEHBg6aQe+gGmcyyzGcsh
fAo/TVb7zbS3yfOYLjz1T0UIBaGyXEmGKQGDzt2nS3PCfFPLUZI7HCtqYmKz
/M/JHD3JXwklodM4OkvmSlJfpZ3G3WmM/fa5NQsdOAk9EYf7+91Hyq4DTI+q
1NKRMg+Q4/gG6khZJF2ohDIsF7BoIFV5WB4IQFVEgCyOlPUDTLJi8gyzKkTH
yhm4EOeWeMpzdKntZ8JqyTMZOrp8tmPZz7ue+WExPyq7RUclPG2pKHNaCAuz
SKVMOgfvW1MdvCthkaxSokLH+1nw7lFvFmiz+5hBg2SvlhAjsjsOngYqh/Aj
g+7YiRcrM419Ryydolae9W9znH1jvW3DSuOVBdGynJnizKmC1ZR4IR2LOsrk
mWTqUIBSY7mzp8SLedto/S8UBmbsy5R7QdjcU5tGyRfzCI97OCSUEEOZS0pN
ZLaSc4B5TGRlUp4zYq4Xu5/9l5J14rDsw2E+hXldtjjnt7PwXBkqOiqKa/eI
A4nIIeLyuou6G8ea8aOzKC+TtNM96pyCIA9xmZdI3s7AmU05S+mUIMtzllZl
GTo9Pd6oMjJUpqzm/uNVRVgEzJRkU8ISbHju0hE930/qzpN2eozMyNhHCUtf
3zmfo/TivVyDBFBfaYQHYUEoCnuAoBHofEUCJPwKmbJ5dtrfd/erc387K/OC
yMp87sflIgZTOX/eJC+lPH5JXh5h6Wl4LC0ha8kXKUen+MimK9O5wZVGK0c+
4M2sPmQPe5jnHLLQkXbKADxnqSTA1dnGQb3bho3Ztl1ayLZJxdA8A7AgXJYz
TdVra8Y2Lh+h7GZKobEPQJ/votDgyTZxHi1SmigDkFJnd87neWYcttbnOWwI
woKAh90vE/9ksuZmkVtm52i6s2hpvX+KW7rz8rTztWs/+0lltrMUh6WL2pFs
QsKk8tCJ+eEnvSIjibmxUvWijibpNSU+JQraSHJaaJ1/VCrobMoE/bpInj0s
kmfd3YV8szOFyePZf1FVtlu0bjx/1WjeMqKHkLE0AgReYfPhsx12AiDFCJQ8
6+Scu+CBVsm0WQHGva08z3munee8jdKbv7HLm4LOqwQ+fKZdP/L8+cPVMoFG
7AJ7Uo7rXOWjSVOONVREYjhlHHvrOFR5KK/j4N3GqM9g8CjvN0iXP/Tc/+K/
u+s/7lgR4jKXetbvLldS9n53UrYncZ6KDUInL1HFQTfVVImig8x8Q5TrOHnt
CeUghspL4LEhJbWXRioLZspy4XgnCqGTK0ZylwzB7cOOCuhXuKHHH+wq1/nO
vtdE9jRs6v3bKXd93nZc8FqDHa9QucEuWW6gcnBFZo5Ilnqiza7h6Ua8A8st
Dmd+8WRd/spRvoyZKaeN0YQ6DVUE4Ge6ZCp7hyO140JqaSS1tJPdCbVWyRGr
9U3S3kUe1TXJEhvWaKUoVL4TOnUV9lPUWIkynsxCQ5TDyax3v7pSl7422pUI
NmgwpF7QZEBPySRimQXEeJnVUcR5UDVVjwBAAEsQ6ATwm2W8RrU7e3ntzj7S
yu/b1VYP2UjxbENZJbzg6vp3bvP10+hLzzQWrhktyZqEN64sinn9TKsLqcRa
DVVtddwtsCDJi0p4Tl9x4Lo7n+cFbBs3DHttI5qoXJ1OhbBe0chCZ3qBmahi
FAVyWcWGYBBXyKVmGW1p1mATBSQe2BYNyJTe1xwXSNVxopDxweMI/J0aH16A
lQatY/Nge12lcT/kVvTB41hW473wcDZedo3wW9ezP7gNvApWTb78s+bi9eNl
OZOYRtWlMb2a0FukplP/u/vLiIJ8l7wCkFeALtLO9Nzh1EgC1OwCSLLcHnPP
Dn00d/EklU6G2m4CI2p7ZJecZpcaQs0kUglV2z50o81yWVZbodf5TNgMFrY3
fPMGLQDmX17+/EVgtJhXkyCeIAV78NjbPyIdEyWnabCP7H4okSo2xbN4DVVz
P2JXWj1rVyAQQNcpZHz/Vs7i2/krRosyqd60LHe6In+yungG3ypVuecxu4hb
9ZXTyu498oK0AkJs14lIxqtZnl0Lb8mV0GEOkapvFWX+x/Xx7MFE6fhsKrNP
FwQIeDCn3JB19Ve4IfRrWCGKsSiWFAjJMjmeaioQEqUkAiHOBiMREku0+VcA
D1FWPNNhFwWfgiGjuuAHj0GjWAiIsPR3OCZ49L2HToriKtIbXqZIhAg8BiGn
9M5t2lD9cGDj8kEyddnhBS8ZlYXRquLp2vKZ+pqYXgbnrZw+6VOFq8rrFSaQ
DgtyOoL2W1b7TRM3P5ZSBxlfWBR/t0Nb0e2irSBMeC1/Rx/RvczivAfn+4iP
gY9LrVaEKgmj588B48FH1pg6+DhsPcDHZuvJWTwoq30WXAM48CPkon56/kOb
o0JRH6RBSVgGh8ThPYAD4vWjiNo7iWRk/hWKD9+4QQHDQsEwMlKweqQ4c7Qs
N/zGywZnMo3WV4Wb6mNOieJON0vESVeJtoupoldSHwiWD4grSMwH5/tMlnb+
tuln2xwOmESfpxOrH72QigbG5sQICjYM3BhxwrAMQSmCL4AX5VUZwFBSilz3
Ies55AGKm7otGlD1AKpcATVdomiVlg2rsiygBMsEp4ToTDHALH5KwhVc+PgZ
li6Q4Uwi5wSZCNwX3A4WwsQD80oP9zw3JQ/M0lGqpV87gXlRmjOJxeCbrxli
hdVYF21uiql1jw+XRwJ/js4D06GxsISU5Oii31ePHKy8zo77no/sngQeciUX
qxMfJa1ryEzjPD0XB4kei1AaMPNrqI2U4BPxb/nmB5Hc6BCL5noNIiyacwki
KmxcJSvnsGAFPjBOMHeEkqDqef4iPAop1bMdQWDBMgQ9D9ErPdcpGXpe4Lwh
L1+FHsKfCaYXSVPGK0hLqJRnBvOiqjj89uuGs/xtiaViyblgU2B5KZVozl4Q
kAyZQcgrSPJKuzjoZVPy8JMlwqJaRSThApIUZcTaFOweNtnXu22qLboR65Vk
jCuoMzoHHXKy9tsfC7IX6g+T0JFEQqRoXrYqmhexERWT+xq5vPZ03USBgOjD
IeAjWfyI9Uowk5E6kel7visALNhcQXa1QiO7QnSBAFs4HmJQIoqyQUlRtlpQ
lIksDiJ4rq2Iv/Om4d002J2EfMpt30hqGlOYklpa97AjtZQMcjsSJsKRc9ax
85JcNnEWCGKt7hEzKNnPApdH4+xbVzgTI78Rh90l3hCjsN6w2f2I34nIyvtk
Wzi9GW9SlAw3ShW0+1QJlPJslFbTBhRRyC2iCnsYKMRfiB4EPZnQKIkG8cdd
RRDN+f6+psj+SHkkH5lUnsK108XrI8TBqB2DwyW+97bhxYeXjhLxni+V6TU5
q6XYbOK9SyNmQJdcUEkutY0jkA6a+w6bB46bh06ZGO1Yh3Wi0zp1SVLMCiZT
+DXemYh44RSdID48zWYTJNLHDMGMKdAqrt/CO8kQmVwXN7kCJ6fndQqcdjs4
OXVEwKk0WllIldylwImXCgMkyBcuXoPqNkEF47egNwBAWIbkX3z9+ro3rgMY
QZeJl5Hj4WfhG5dj4cOZTCndKi5ZMm2EMPr77xlehA5wmR0zD500D58lik/E
1Se7SWaCVFSxZHZymXUP+8vsjsylGOQoH+SMeazdPHHBPHWRWCwF96/dx4t4
OG2K2bjNw8lZS2fZrKX39XDKUuL5HZFsshcVPWa/u4OfiLpToqId69qoCGa/
zAmiLF1F5CFE8ssZMhEgZ70nWUtZEC6fpTtspe/2ScLShYOkLGTMqCCuKBPK
GJHZHEU6GibGJs5Sj78RgjphHj5tHj1nHj9vnrxonr5stjmM5tQzSPTWUhSv
QlCcrTTkz1bqWDQyZMc5FBihzTxx3jzVRTyvbT1uGmabElXR1upMv8RYO4t+
pCumX07zSw0YBAfzJVtjREdrBYxD5Xc3wNCmQrymzNm7BSqwbIVr4IJsAuYl
I4rpl4WAAJsDDKBHiuGX3Ipgj10/TTzMG+MVhTYPc6UCgziyFy02HDB40Tup
BsA4ZR49ax7vME92mqcvETFuu9YDwOZhdoiRmVdWIX92XweVgyesj06ZR6Ad
bfET7fFTnfEz3fG2K/H23vj5m3GHuHw4JgZRZM821zMLCvJy3DgtN8sQFPI3
ec+S8sbNgkheQqTwGXLw8ZKX6vjolH2K0qXRaqRDXolPRT4xl5dkEzFSUeYU
0WSvntRoskdDQIPNcbFjE385cZyTiuRGZf2gRl7e1CCBwaCLlxjekPkUmRPM
4ePt8ZMX4qcvxs9CYNdIYM4ctsnLBV11r8aO7ZVYyrUohctt3HRBXy4QZXXb
ZT7WjbinK4OX+F+jlJ9NjPLpilHeoZMX0IzIVsrdohO8al/i7nt5ODkurXpS
BHAhYjGi+S/Po3C3dAPFvYrgXzDKs1n5K8fZXFiqQkFVnkk8/8Q+sFGwlQue
fypGJp5/gYfNhbNkueFaaMLLn7XIakFRgEdX/Owlovg+fz3ubY6QyLxvy2hW
ny+HvKMpFH91cA8Cs9XNYbgaO3891nkrpjqYXHV/vmj1QL0XWFB0e8CNzaK+
C+mq7wI1XZiQ6sIp/nkX0hHevIwD0ukB5HJyQBIPoShLJV5bHqWmC9CVAlgh
eAUEUpES3hJDwMLSAEygaN0Uuw8qBHNVkg3Y6Pi7Ip+X8JZIPghxvNLU6MAh
lhLLVhqJ6/7jF8yTXebpboLj3JXY+d5Y503IKqZP2d6EXhWi5QILQEChAd+e
C+5uJV3WqW7zDDzVVY65GKQv5m4p4+1fI7pgUN8NFhSNZezeMixDNV8a4F1L
9L4yoi8G2bJRiY/qgpkUnxMSnySHhIQPwIEtQxSd0LgkAhTSoBjsPlxQs4yc
MG9XEqF8kUKRU8XP6/ixgKukU9suW77GcKBp58sIRKgXufe9YkvtBvUuSJzG
Llxk15BAgtx8e5e4+/4gIL7CnX0vN163OEgDd2jLJMcALGl2r6F00Y9J9P0Z
0LqXOF2ybHxkX8xhWo529KXE5yPXAbuT011PLZlg0xAO1JbD41B+f1Ux5UdX
FMRhq1igPA8elzr+5Eep4U8A6AUAIvtqVXGM0/nbXZnc1RqejeYVmYZrFZ4o
sJscn34fgent4LQuSaqfVSIyTg8GuwmhCLiFvaRZcHU4dm3Up83PgNaZi3E8
/g/V+0l0NRu12//hFXWbqGmW6DTzVQGUX6c56mXW9UlQ8vCIASIoElFXcD4R
p3FWiWycxQL4zdKqSughgIJbAM+zf+AeP2lTM882yaos4yNtm8TdRSTu0wku
eVOzNL3PWBqklnrX0wWRbMAhOskktMvyaQrI+6bxPnP3q0aAoklj/aYmW5v8
m2iq/rLdNkIeOyfXn4mb1xpC1G1O6wVYX0MaQQ3nymXDOd5pLl3vNFdbSS+g
3oBaHyZPSbxnu3n1BsPpnn3ZntVJmvTpDsfbFZBLjSmZpU34o+NEBrQP44HG
PU5iJ0DRJTLg6Tw4i/o1pqt+jdSscdrpQOcFaNwFkGzWqACyl6KisYnP6YKd
SQR09Ban1BGwlncE5Bgx6tTI0hQedaK7JvsHWDThcXxK0BSFl7Z9tTbX8LQz
S91A0dOcz+6sOemVWehO3RplA/Xk0PRrPdSdlt1AR3VYVZ07WXA6PMYyVKts
3JqamxK60crGwLdtnOxGza6mmgIn1bbR28LcrUgAqbXVztPnLYFl80beWjNI
iMyFqghQRNPTxnpp0Zr1vrRu7kC94c+6jUZiP83U6CQ20xStYkly1O90XAmO
5JYyQqBewQO8x/1Q0rG0aeDuSswb4LLATHgsFA6P0m82V3QM3tTSOKm1Px21
G5/aPeZdfc3tdsF2X/PbsuspHS34HnTbvgjoyEIw1Ze2yWlNm0adgtMJDq1Z
sFAZ6qutV9dqnc7FMbBogJFZYDgdSuz2806PRtFX2dvCV/VVFs1ox1ULcpes
Uq09IQan5Tzvpe4PiLtzs94jOkLdtCOjvIv3fXi0paXB3WY+ERHfBs60KO0Y
+PjcLX6ScCXhYPu4JOMTiAAOnWdBdDVX7bRZiBpqz3E10t7s1IK66mjshNED
9gHjsU7eS1vv3Mw3EMUWyVWnw3VEb6asZq3eCZ5jQJKZRRJKpRv4+12d5v2Q
tj9/XAdBIICPZ4FoZCQUi4zQbzZX9JpXjeYFHhMJeLh6m4+6e5uLRvOqt7kf
gb/QEGo0765lbW11IAlRs/m5DgqtPmWfniQ0sbwUIVh2ieFuai77zCdr0axU
QgdCF5SSU6pVJ0TggKGNkQRsUjgxQJQ3sQ/g81kwHhmJR4dxwyV+ZOA+Ho/y
2+bNDbz9PL1TVxblX/Smzb2eIECuRj/WOzbrpwSq8TyQcdXmbeP4GFxlWq0Q
4GD3buaA4EFSjm0JdWZaRqVz1MJdfHapwVv1yO5TXXZzvZ6xmPC9iZ3NVVtz
1/wVmLAghCNExtLwI6XH1y1WspEEODr6GjIEi4mRZtGPdIKJg9O6uT7KNQfG
jSMzZiPj9KF3vIrHhmkbnq7zG3VgbXOMAxZZRWGXsypwEK2xEPBgc7ZoiCiG
AVflhp7opXpcXaUMIXH4JUARpx66XREBkQpUNVBEl3kpKqbPYhJTyPRFxVlp
Xh6923EU8lEudsI8QEMEreiwFR36ODrE0uhHOu5YfHTctmyuE/oT4Z5nRtMc
EZlhHFdYpuMzzA8MtHNQJ+ejXcv5OEbg6GVh8NmkPBwiNhtwsDkSkJ3eijbH
fqmOIDyFiHxJr5VTabTbDZIu6piMuR2ulNWkUhR9+nIV8ZdVSj9/Re7EuSwZ
XID/UBosJo3Bh4kNzfplbIhl4OJjAoVwMVrr8BodFGHOJmxQ9FjZx5YNkTBk
x2Z7xelxNBAnENmrlR6RRdvDjRqHJgQsWAYuBPmjQ8Ohlc6oxGaZQCSWj9do
0LwqA1+g0z62TbQqjv8VQZBtvFyY6ILisgpBVimrtbyK4udYuO1KHEUO8Uu6
DbLQv8UGA4TMXIEMMDHJnDmwiBBA+X+lKP7B2FC8i+dKtd+2FYWndcjMG7v1
CDBxmKttWHbYsIQAB5srANmhAaJzMB/0pI9100AY7txNK6/agKZSsoPbDQs9
6XfpicvM60oiABGiIvlwOf3OXbPwO3feumPJeuwm5R5l0eaAtGHu8WgwRqMF
MFroVxgRv9lcPIAntrbWCVsmfA3UzKswysVMTgsX4yjMSIyQGYwDmY4+v8Po
drm4BDIu5uoDluJXgm6EgAibq3MKyfL+j7yVEzIXVniVHhoOq6WN1ZT6c1FE
q7a1dztgLVTVVAVeVbh3HRZdTm5kEru3OLZMmwvSvwy7bSbmgrBinhGFwmBA
jDfrV/FBlvErfhc3PLWttY7btWHdovmojtecRTBXxOEalrZkzvSMKJW0Zkdn
QEeVFSmAFGNPCMrC5ngoNxTZ84ET7rRh3ZDdJMe2sdboHLYujghDFncMmdu5
jDoW36U0SlBqBrMgJARJkbCC+HFHlJwIzWNCh1xLmAltXrhG9oz76/gAm0U/
0ulLcKS2t9biRdA000HKGw3ooYC+k6YsnJ1q8/G5m3561MZh0ovzOLHCLlub
WAj4sDk73WwPeuGhtxUODwIoWr5FAWI+b/ApFnzCMzsT2i9aFhNaqpDtBMjk
e2UVwo87YcS7i/0lLsobNlc0bq5saqluaqlpaq7btKl+U1NDc1Njc1NTS+Om
lkasHje3NCAk3tJaF4BbYWmwYNtaawHB9i21gR1bambv3FLDZuEC9/HokoVv
QYu2yld/ecvmerwZH4EPam5pwIfioxs2NWGk2qZmjFrV1FLZ2IIvUd7QWtrQ
WlLfWlS3paDOyK814AKoXVm5IbqUUYuyAmrgtTbXoMTabGrsJbqULV9LLdEC
y1YbLLhsFXVIww2X+PF3dH813ahp2lrqm4b3iJZgqzfQZ63NMzJ59zTREgzj
IR7YWGPMf3tRYZ1RVG8UN2wpaWgta2gth6gabVE1bcLf0MCl1dRMomIB/I1s
Fslqcx3+eIOLAcIIQCwsCPFASCSsEP1I7C6W6IGSmDhnRswoE8dnhFAeYdxY
APMg+Bv8/634ze7DA5gjXHkGP3brj/JDtplLsgIdi6oVKO3V9LsTCLRFKAA6
6O4+QgQcnC+GzSYOrPt0ygyXzui592IfuYfGgG07P2hhZijb5vE8KWybK3Di
HsDRF1tGLA0XnhMAGyX6GXLvDtwhakti2P7NHjZAiKRh2N/G++lm9gfwix4l
3NgcoCRc0sd+KE35OqMJxxld9e4TUC6ka0HKrRxQ0hv4KMJy4l4KAKAgkKLf
7F4XWccxVx8aV0L+FemJEJ9c4Gg5Fi6JJ9LDt7A2ny33fJazmaTEghCXkBtL
rOQOsISOsr7BiYrjZxKxiiViRVOEhjUxJv3I4F9g4Df8hhdBvRVgIsLzuCUM
JjbeUgXe4vhtgMTnZIBqbokAc9clK83iXIMZ0hkd9DLS7NdCB6dTpUhnvsq9
UgJmdnqAE3K75rkrsEs9z4NynpsCupS7Oj4BgxbTqVDFjulIncUECWij9Uuk
ghIpP5hiOkwjNkxjyaJwJ3oYdU5JJUzXtX60vH5Eh0n1ZZAG8JBgDb6PNOqQ
xvFxXIvt9M6vl+3I+5YboMR9Fs0Q+S5QfCc3887uPwVCv/z/EfrTI5TMN/0v
tXd32GgYIQf1/0F7979lHKGiPb4f9IfEEQ4N1H/MOMJzMveHxOG/dkeZdxuJ
z9xdJM6zrMWJQ/utP2okfvA/ViTu2cv27mJPeTbmxh035B5NB2U2YZEusPiV
vaugvE48Yf/H5XXsAyDX7txwXBwwKK9zpse7/0Nw2F5H1xOxC8RCu/YTy/YB
F2vhPrc9c1EIiESO66SaCPQJFPfGnLAvfhswLl8QT/QFzu7Lb7w7Cp6I4D/q
Ps9wTO7zCMslHMwfss+z64+xz9P7p9rn8ejIf/A9Uq/JStgj3f//lj1Szwnp
H/dc4b4/2rnCwCc/V+B47OSHPmw2nSrc9/sdKeT9sY8UmP+Zwl2evyUcKv3p
zt88ibj6+dv5Pvf5W7fr/O3AH+P8zUvfYJ+/tX3C87fE1d/dnr/d/Rn16F2e
UUfFGXX6H+2Melg7o7YNVmIylM8ZNUdC5A6w2XRCnS6yara70Uh2PH1SZDf/
yY6nWZLz6T8glyN897kc8YRcDg8kd1ARnstBjj11LsfRPzCX42jyXI6KT5DL
4TN5f49cjlS5T8ns19Tvkfvkl5X2yXKfXEtE39yn/bxRvKLy/wS5T/s1FjK1
dvTNfbpNpfh3kfvkuHkt92n0bnOfnLW8SKNNzBj0Xdrro0U8GYMR8h0cpk+W
MTgtVomudPSRT5IxePjOGYOzKGNwzh3SBTWOOG+64DW/dEG/iZxgZVzpgsyV
LxihfMGIHzq/X35twoCfML/WUyKQmPZE9mvIzq9VdRw2IORSTroY8VR+rfFJ
8mv9E509+bUXreziu8ivTZ5e+Ynyax0blizvPBGScfdIekY1yxDOQ6iFSDyf
tL2Ib+K5sxhRjkQeZjqJ5ykSnUXiud5QSaDQbCee63nnzXreubsCQGek9ead
X75D3nkyw+L4fi3vnAUFJiSs4J1y0P+A+gy95oAFZ2xUWECv1Zjy1mokKabx
rwywlyZJajUkdyQvpgFGelmAp1YjRLUacxsTCzW0JgIuJlxVqMFdjSrUONMj
2HlUoYanPMC3UMM1nYUXgLjG0vzrNJxozFXh9AlLdRiv1QmKAXFjaTRFMqZ8
K5ymklY46ecr+uGyXC9essMvX6ZIXokmKpwUIk28sZ8sRqux0uqrrUBDDfTH
VdyUovTMLm466CluuuIUN11wFTf5mn4nSnNLzFsXFiDrk8qm2TWCPjDpNYJ6
jahTIxigajQMHbLrA8dVfeBU8vrAMb/6QL3uzPYr/uyDnvpAveisRtYH1lZa
LFhbYQWoUHAOVWtW0TP1NbIEzbdsc7sqDTwiQ2hZGqhRNJ27u9JAT9ke02WV
5l8X6Fg0n5pavwLRviQFomOyRjRE9Yjpqu5Zr6gdsMMucXCSWPPsKdg8pQo2
k1TUGnpFbUK1JoCo4RW1LOBbUysLaqutxsR+knY4oHOOiYJaJyPaqXVOiswt
raBSr3XV5EU1tSk1xVuRnlC4qXFruMpqA3a9u11X/cAYL0sfUdXoTZuEjiju
DQq/xrimcMoAFRLLCOyuS505MObmzUSLQcXodbwYvZp3IqkgWpmaUqcYvUrW
owfwSMCuRP97QbpOZej1Tj8hVxm6Xeu8KsuQPA6q1jk5NMmIFYixwSuvNMjL
73TFWcfINW5yeHyHU7QENisBww8JC6NvweYKzo2apuZ+D6HDSLh3ONwzFLk6
FL08GOsejGE0O4/WUZtEdHYfMnfuj+/YE9+2M25si7duibe0xDc1xRvriW2j
ripeWxGvKY/XlHJChyJO6JBPhA7E5xAo3xgNEJnDvRUF0coC4uSoKiIyB2ox
Uelfk66DtGKd4Wyg3R1IiRQlAwonSI3YLwJ34nIQmxCiTPRcr9lxw7xwK97l
Mm2S18PLt5KE1yNIP9KVzviQoQxHegYiV/ojl/uj3X2xrtsx+FQ4Obkd5ouN
YGDfZ27fHdu6PbrFiG7eHG3eFN3UEG2sjdZXRR0ylCJOhpLPyVByo5yyJszS
SrJnAqUbZtic0pyZspxwmc6Fwls9SLqNeq0/nkZ86uJCuQt4vFwo4x6ZEYdM
2p34T+QO0SUXOFJ7knAHCQVy8+Eo5qA+D3PQmM0cNERgXLoVuXgz2nUzduFG
rON6HH9TW28SM6bo8HebW7fHtmyJbG4JNzeFm+rDDTXhuspwTRnxOFUWhisK
wsQclMuZg7LDxVnh4swZIgxSzEFzXMxBub7MQS5iLQGJwxyk050mgaQ7JXMQ
I6alFLxBGqvWWZmlc1KDhAzazXjiQC7tTMaqNe7HqjUYvdQXBRSdvdHz12Id
12LneuJne0z8Xcn1grNqbTe3GLGWlsimxpnGuun66unaiuma0umqomnOqjVd
lkOsWsVZMxyE6cI1kvNMZ9WaBChFmTMlWQmsWtTZkbNq1bvAcLFq3QkMhxbO
l1XLnrx3ZNVSSycFhkbc8SfhnxsgHp3OGzEg0n4ldu5y7Ozl+OlL5ilBl54U
EXLwLS2xTY2RxrqZ+qqp2vKp6pLJysLJ8o2TDv/cukT+uRHOP3cfLu7MP0f9
8YjERkdm8RLDnxXY3jvTkXHxz426JrBkBLwzA11C5ZPG4ai4tjukQZPhQOL4
nCIyNYdjRlIOxyHSwc5bxODW3kNUa2cuEq3byS7zeKdNCuSPERyyuakp1lgX
qa+aqS2bqiqerMifKM+dKM2e8HI4Lh0V/JrE4fjBQPb7/cGs9/tZBi6IT3PR
YM5iTuS4dJQoNQWRo86qKYgcK1x4SSJHD0vwaRdep22OU0nk2Efn3peGXUSO
appDRLMSOBx9ams01lOdEr1DO5mwp4mkj7B5VS+5WU+J7TRIaKX1cmjEjXOg
vuxwoA7bHKiDtCkITW3vjbddjZ+5FD8FmM7Hj3eYzoEkh2mPFyZEuWZjXay+
KlJbPlNVPFWRP1mWO16SNVa0jmhp81dyDtSlo0Bhw8JBgELktJwDNfOtm+tw
E1S0xEZ7i4hQiQW1n1hQFw9xSudRARl1vaMW4KbdPlXhpbGgcrx23xVeRBms
BCdYUIXsmJJcUEmOfQLcEtnsJXSXHVZc2h3njNJdQ5K0WLHiBvAtWFBgyDlZ
6cc8wSgsSIWLG9yMwgO0hwinh1lx5op5qts80UkMikfbzMNnXcx1kurRwQ2e
PF5fHastj1QVz1TkT5XlTpRkjRethciJ9jlvKWdGXTgomJ8zOVZE/ryglwiF
g8T1PJdzPV8jVuE3b+AVeB0huHBAkdjCqfHuboLxOa5jJ/mEDTd2R5JhR9sJ
7Tc53bMtuW6e4nE5qeRSW0ReJfWZ3wmW7kTY7JDytJ1PKlKwsKLsHLK65OCS
Bpp/hTgLEdF0BpF02zzdRR6SbpEUo1GlHr9gHW0n4stDpxKgEmy2EiqLM0AK
tnvZjoqz3VNDAiLpXkjNI4ih+80bAqHVr/SsepkYukMrfnGJZeCCWNNf6cFT
axdwbm4OFmccHqb2YdTEMkxd1kUHMRsp4ua2+xY6zM+cMyIZUpREqAtLB8sW
FpdVYmewRN3SuhgV3UkPtQ5lX/K894uf4D5LOmfK1DP1CT/Zn/0PNiKXEA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 160},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->52223510]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30997],

Cell["A random collection of grid lines: ", "ExampleText",
 CellID->714016095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RandomReal", "[", "]"}], ",", 
          RowBox[{"Hue", "[", 
           RowBox[{"RandomReal", "[", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", "30", "}"}]}], "]"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"RandomReal", "[", "]"}], ",", 
          RowBox[{"Hue", "[", 
           RowBox[{"RandomReal", "[", "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", "30", "}"}]}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319639890],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3T9rFEEcxvFn3SQam1wKiQTEewkp7bTS6kr7HJdoUviHJIL2gikU7IRU
YquBJUyRysZ3kCqFCApaBfISfpl/e5Im2eKU3eR7zA03szN7ux+eg2Vv924w
3FpbfTLcWh8N+w82hs/X1keb/fvPNnxXWUhy4XlT/rX5V/F53cxU2p4sPjSV
2nqR2zdCNa0PNsojbNFPnI9Djyz39XJPaV/q9UzHtr7nSboS26/s9HLTbG5f
TePtZ25fS8tvh/H7yvOnHtYboT82E3tUmbZDz6Ep7Yve1WPKtO2fbfyQ/dJM
WvTj1JbIfQsccUb5Oy3Sp9ze9u0INN7qs3Xm8qhF3TVvlPe9N973uY5bodRE
yd0RVk2t/LtgxacPJZRQ6qaSkz3GikShhBJKKKGEEkoooYRSm5Rcn/NyJAol
lFBCCaXLrpQG21Iola8K7EgYSii1UsnJ7mFFolBCCSWUULrcSs60gBWJmmii
eliRKJRQap+S09P6nJ1px5ew4h3O2ZEzlFBCqbtKbjlcl+Hech8euZporkxv
sCJRKKGEEkoooYTSeUruNcfhJAollNqo5Ha5h4NEoYQSSiihhBJKKKGEEkoo
oYQSSiih9J/uSFwJV1kUfF9ArlBCCSWUUEIJJZRQQgkllFBCCSWUUEIJJZRQ
QgkllFBCCSWUUEIJJZRQQgmllis5e6Rw3ddXxMgVSiihhBJKKKGEEkoooYQS
SiihdIZSHPxSoajyVfG3V3YrlMpX/LMBufsHuTtQKKoO6txh18QOJZRQQgkl
lFBCCSWUUEIJJZQunpKzj/ymE4lCCSWUOqrkNMCKRE30+4P3vrbjUCpfFaEp
NzCOFRoKprmJJK64kcp8HHpU71Uv93TYQcUJHEfHuQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166936190]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31032],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ticks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ticks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceGrids",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGrids"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Frame",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Frame"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLinesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLinesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshFunctions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24988]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23263],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Labeling Two\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingTwoDimensionalGraphics"]], "Tutorials",
 CellID->8514],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GridLines - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 9.9279662}", "context" -> "System`", 
    "keywords" -> {
     "drafting lines", "lines", "plots", "graph paper", "graph gridding", 
      "graph grid", "plot paper", "plot grid", "logarithmic grids", 
      "probability grids", "grid template"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GridLines is an option for two-dimensional graphics functions that \
specifies grid lines. ", "synonyms" -> {"grid lines"}, "title" -> "GridLines",
     "type" -> "Symbol", "uri" -> "ref/GridLines"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8962, 287, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66729163]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 212236, 4408}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2140, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2763, 73, 47, 1, 70, "ObjectName",
 CellID->24336],
Cell[2813, 76, 474, 14, 70, "Usage",
 CellID->18275]
}, Open  ]],
Cell[CellGroupData[{
Cell[3324, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3802, 112, 215, 8, 70, "Notes",
 CellID->1221],
Cell[4020, 122, 984, 26, 70, "2ColumnTableMod",
 CellID->11576],
Cell[5007, 150, 319, 9, 70, "Notes",
 CellID->1799],
Cell[5329, 161, 107, 3, 70, "Notes",
 CellID->24919],
Cell[5439, 166, 1879, 54, 70, "2ColumnTableMod",
 CellID->14241],
Cell[7321, 222, 367, 13, 70, "Notes",
 CellID->28611],
Cell[7691, 237, 369, 14, 70, "Notes",
 CellID->30209],
Cell[8063, 253, 502, 17, 70, "Notes",
 CellID->23635],
Cell[8568, 272, 357, 10, 70, "Notes",
 CellID->643683418]
}, Closed]],
Cell[CellGroupData[{
Cell[8962, 287, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66729163],
Cell[CellGroupData[{
Cell[9346, 301, 148, 5, 70, "ExampleSection",
 CellID->591440113],
Cell[9497, 308, 72, 1, 70, "ExampleText",
 CellID->35703158],
Cell[CellGroupData[{
Cell[9594, 313, 247, 7, 28, "Input",
 CellID->2133167],
Cell[9844, 322, 278, 9, 162, "Output",
 CellID->4407549]
}, Open  ]],
Cell[10137, 334, 125, 3, 70, "ExampleDelimiter",
 CellID->926159991],
Cell[10265, 339, 85, 1, 70, "ExampleText",
 CellID->358495963],
Cell[CellGroupData[{
Cell[10375, 344, 522, 18, 28, "Input",
 CellID->259059667],
Cell[10900, 364, 3401, 60, 127, "Output",
 Evaluatable->False,
 CellID->533110161]
}, Open  ]],
Cell[14316, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->343832599],
Cell[14444, 432, 63, 1, 70, "ExampleText",
 CellID->279859159],
Cell[CellGroupData[{
Cell[14532, 437, 781, 26, 47, "Input",
 CellID->678318124],
Cell[15316, 465, 3318, 58, 127, "Output",
 Evaluatable->False,
 CellID->62920626]
}, Open  ]],
Cell[18649, 526, 124, 3, 70, "ExampleDelimiter",
 CellID->49944586],
Cell[18776, 531, 235, 8, 70, "ExampleText",
 CellID->438049882],
Cell[CellGroupData[{
Cell[19036, 543, 376, 10, 70, "Input",
 CellID->369339684],
Cell[19415, 555, 365, 12, 162, "Output",
 CellID->470399084]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19829, 573, 215, 7, 70, "ExampleSection",
 CellID->9868],
Cell[CellGroupData[{
Cell[20069, 584, 240, 7, 70, "ExampleSubsection",
 CellID->392030550],
Cell[20312, 593, 72, 1, 70, "ExampleText",
 CellID->32797056],
Cell[CellGroupData[{
Cell[20409, 598, 248, 7, 70, "Input",
 CellID->246336059],
Cell[20660, 607, 279, 9, 167, "Output",
 CellID->357151877]
}, Open  ]],
Cell[CellGroupData[{
Cell[20976, 621, 270, 8, 70, "Input",
 CellID->567223868],
Cell[21249, 631, 3645, 64, 70, "Output",
 Evaluatable->False,
 CellID->339728586]
}, Open  ]],
Cell[CellGroupData[{
Cell[24931, 700, 316, 9, 70, "Input",
 CellID->82214486],
Cell[25250, 711, 3615, 63, 70, "Output",
 Evaluatable->False,
 CellID->109698609]
}, Open  ]],
Cell[28880, 777, 125, 3, 70, "ExampleDelimiter",
 CellID->877194300],
Cell[29008, 782, 161, 6, 70, "ExampleText",
 CellID->253308099],
Cell[CellGroupData[{
Cell[29194, 792, 303, 9, 70, "Input",
 CellID->668489835],
Cell[29500, 803, 287, 9, 162, "Output",
 CellID->58004902]
}, Open  ]],
Cell[29802, 815, 161, 6, 70, "ExampleText",
 CellID->559576256],
Cell[CellGroupData[{
Cell[29988, 825, 324, 10, 70, "Input",
 CellID->624768882],
Cell[30315, 837, 2986, 53, 70, "Output",
 Evaluatable->False,
 CellID->170910001]
}, Open  ]],
Cell[33316, 893, 124, 3, 70, "ExampleDelimiter",
 CellID->52069776],
Cell[33443, 898, 81, 1, 70, "ExampleText",
 CellID->157686013],
Cell[CellGroupData[{
Cell[33549, 903, 449, 15, 70, "Input",
 CellID->414252241],
Cell[34001, 920, 288, 9, 167, "Output",
 CellID->553483546]
}, Open  ]],
Cell[CellGroupData[{
Cell[34326, 934, 662, 22, 70, "Input",
 CellID->20797537],
Cell[34991, 958, 3067, 54, 70, "Output",
 Evaluatable->False,
 CellID->163559333]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38107, 1018, 238, 7, 70, "ExampleSubsection",
 CellID->250144848],
Cell[38348, 1027, 79, 1, 70, "ExampleText",
 CellID->686813296],
Cell[CellGroupData[{
Cell[38452, 1032, 803, 26, 70, "Input",
 CellID->73856262],
Cell[39258, 1060, 430, 13, 167, "Output",
 CellID->214127189]
}, Open  ]],
Cell[CellGroupData[{
Cell[39725, 1078, 996, 32, 70, "Input",
 CellID->168006648],
Cell[40724, 1112, 3119, 55, 70, "Output",
 Evaluatable->False,
 CellID->13137606]
}, Open  ]],
Cell[43858, 1170, 125, 3, 70, "ExampleDelimiter",
 CellID->860833114],
Cell[43986, 1175, 235, 8, 70, "ExampleText",
 CellID->684274320],
Cell[CellGroupData[{
Cell[44246, 1187, 787, 24, 70, "Input",
 CellID->523077197],
Cell[45036, 1213, 3013, 53, 70, "Output",
 Evaluatable->False,
 CellID->68540514]
}, Open  ]],
Cell[48064, 1269, 125, 3, 70, "ExampleDelimiter",
 CellID->236568718],
Cell[48192, 1274, 268, 8, 70, "ExampleText",
 CellID->88564141],
Cell[CellGroupData[{
Cell[48485, 1286, 1010, 31, 70, "Input",
 CellID->1815006],
Cell[49498, 1319, 3157, 56, 70, "Output",
 Evaluatable->False,
 CellID->142814568]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[52716, 1382, 239, 7, 70, "ExampleSection",
 CellID->28391],
Cell[52958, 1391, 338, 13, 70, "ExampleText",
 CellID->814353806],
Cell[53299, 1406, 582, 19, 70, "Input",
 CellID->778149766],
Cell[CellGroupData[{
Cell[53906, 1429, 356, 11, 70, "Input",
 CellID->326320959],
Cell[54265, 1442, 828, 23, 174, "Output",
 CellID->358795121]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55142, 1471, 222, 7, 70, "ExampleSection",
 CellID->4985],
Cell[55367, 1480, 114, 3, 70, "ExampleText",
 CellID->349111521],
Cell[55484, 1485, 687, 22, 70, "Input",
 CellID->540529205],
Cell[CellGroupData[{
Cell[56196, 1511, 355, 11, 70, "Input",
 CellID->93362669],
Cell[56554, 1524, 690, 18, 174, "Output",
 CellID->435915735]
}, Open  ]],
Cell[57259, 1545, 124, 3, 70, "ExampleDelimiter",
 CellID->24279925],
Cell[57386, 1550, 64, 1, 70, "ExampleText",
 CellID->580509667],
Cell[CellGroupData[{
Cell[57475, 1555, 380, 11, 70, "Input",
 CellID->19468640],
Cell[57858, 1568, 3665, 64, 70, "Output",
 Evaluatable->False,
 CellID->126732108]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[61572, 1638, 232, 7, 70, "ExampleSection",
 CellID->5537],
Cell[61807, 1647, 95, 1, 70, "ExampleText",
 CellID->213162192],
Cell[CellGroupData[{
Cell[61927, 1652, 437, 14, 70, "Input",
 CellID->233133251],
Cell[62367, 1668, 379, 13, 164, "Output",
 CellID->100027963]
}, Open  ]],
Cell[CellGroupData[{
Cell[62783, 1686, 529, 18, 70, "Input",
 CellID->131884689],
Cell[63315, 1706, 4493, 78, 70, "Output",
 Evaluatable->False,
 CellID->544326031]
}, Open  ]],
Cell[67823, 1787, 125, 3, 70, "ExampleDelimiter",
 CellID->139568862],
Cell[67951, 1792, 93, 1, 70, "ExampleText",
 CellID->41243122],
Cell[CellGroupData[{
Cell[68069, 1797, 301, 9, 70, "Input",
 CellID->458891805],
Cell[68373, 1808, 306, 10, 162, "Output",
 CellID->148752209]
}, Open  ]],
Cell[68694, 1821, 125, 3, 70, "ExampleDelimiter",
 CellID->119717961],
Cell[68822, 1826, 359, 12, 70, "ExampleText",
 CellID->50572099],
Cell[CellGroupData[{
Cell[69206, 1842, 403, 13, 70, "Input",
 CellID->140106823],
Cell[69612, 1857, 24129, 400, 70, "Output",
 Evaluatable->False,
 CellID->177658387]
}, Open  ]],
Cell[CellGroupData[{
Cell[93778, 2262, 704, 23, 70, "Input",
 CellID->158495665],
Cell[94485, 2287, 26929, 446, 70, "Output",
 Evaluatable->False,
 CellID->93168425]
}, Open  ]],
Cell[CellGroupData[{
Cell[121451, 2738, 435, 13, 70, "Input",
 CellID->80561626],
Cell[121889, 2753, 28414, 470, 70, "Output",
 Evaluatable->False,
 CellID->94033834]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150352, 3229, 226, 7, 70, "ExampleSection",
 CellID->26320],
Cell[150581, 3238, 117, 3, 70, "ExampleText",
 CellID->197794532],
Cell[CellGroupData[{
Cell[150723, 3245, 705, 23, 70, "Input",
 CellID->355770928],
Cell[151431, 3270, 25973, 430, 70, "Output",
 Evaluatable->False,
 CellID->87729533]
}, Open  ]],
Cell[177419, 3703, 228, 7, 70, "ExampleText",
 CellID->250395265],
Cell[CellGroupData[{
Cell[177672, 3714, 700, 23, 70, "Input",
 CellID->168775595],
Cell[178375, 3739, 27226, 451, 70, "Output",
 Evaluatable->False,
 CellID->52223510]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[205650, 4196, 224, 7, 70, "ExampleSection",
 CellID->30997],
Cell[205877, 4205, 78, 1, 70, "ExampleText",
 CellID->714016095],
Cell[CellGroupData[{
Cell[205980, 4210, 988, 31, 70, "Input",
 CellID->319639890],
Cell[206971, 4243, 1111, 22, 70, "Output",
 Evaluatable->False,
 CellID->166936190]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[208143, 4272, 311, 9, 70, "SeeAlsoSection",
 CellID->31032],
Cell[208457, 4283, 1684, 62, 70, "SeeAlso",
 CellID->24988]
}, Open  ]],
Cell[CellGroupData[{
Cell[210178, 4350, 314, 9, 70, "TutorialsSection",
 CellID->23263],
Cell[210495, 4361, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[210636, 4366, 181, 3, 70, "Tutorials",
 CellID->8514],
Cell[210820, 4371, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[210992, 4377, 27, 0, 70, "History"],
Cell[211022, 4379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

