(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24433,        751]
NotebookOptionsPosition[     20673,        628]
NotebookOutlinePosition[     22170,        668]
CellTagsIndexPosition[     22085,        663]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GridLines" :> Documentation`HelpLookup["paclet:ref/GridLines"],
           "FaceGridsStyle" :> 
          Documentation`HelpLookup["paclet:ref/FaceGridsStyle"], "MeshStyle" :> 
          Documentation`HelpLookup["paclet:ref/MeshStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GridLines\"\>", 
       2->"\<\"FaceGridsStyle\"\>", 
       3->"\<\"MeshStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GridLinesStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["GridLinesStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for 2D graphics functions that specifies \
how grid lines should be rendered."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"GridLinesStyle", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that all grid lines should be rendered by default with the \
specified style."
}], "Notes",
 CellID->6849],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"GridLinesStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["xstyle", "TI"], ",", 
     StyleBox["ystyle", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " grid lines should use different styles."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->24023],

Cell[TextData[{
 "Styles can be specified using graphics directives such as ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " as well as ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and combinations given by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15125],

Cell["\<\
Style specifications can refer to styles using style names from current \
stylesheets.\
\>", "Notes",
 CellID->797803519],

Cell[TextData[{
 "Any outside styles not explicitly overridden by settings in ",
 Cell[BoxData[
  ButtonBox["GridLinesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
 " will still be used."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3528],

Cell[TextData[{
 "Explicit styles specified in the setting for ",
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 " can override styles specified in ",
 Cell[BoxData[
  ButtonBox["GridLinesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->39190952]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505140515],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->449585718],

Cell["Specify overall grid lines style:", "ExampleText",
 CellID->196633049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14626167],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  GridLines->Automatic,
  GridLinesStyle->Directive[
    RGBColor[1, 0.5, 0], 
    Dashing[{Small, Small}]]]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->520854387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pi", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", ".5"}], ",", ".5", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166557916],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42567505]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " styles differently: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24023]
}], "ExampleText",
 CellID->94554572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Dashed", ",", "Blue"}], "]"}], ",", 
      RowBox[{"Directive", "[", 
       RowBox[{"Thick", ",", "Orange"}], "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328708268],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  GridLines->Automatic,
  GridLinesStyle->{
    Directive[
     Dashing[{Small, Small}], 
     RGBColor[0, 0, 1]], 
    Directive[
     Thickness[Large], 
     RGBColor[1, 0.5, 0]]}]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->998655180]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Individually styled grid lines can be used with ",
 Cell[BoxData[
  ButtonBox["GridLinesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLinesStyle"]], "InlineFormula"],
 ", and have higher priority: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->39190952]
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->88564141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", "}"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", "Red"}], "}"}]}], "}"}], ",", 
      "Automatic"}], "}"}]}], ",", 
   RowBox[{"GridLinesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "Dashed"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1815006],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230014561]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLines",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLines"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceGridsStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGridsStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->1025537455]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GridLinesStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 15.8343674}", "context" -> "System`", 
    "keywords" -> {
     "styling of grid lines", "dashed grid lines", "dotted grid lines", 
      "colored grid lines", "thick grid lines", "thin grid lines", 
      "graph grids", "graph paper", "graph gridding", "plot grids", 
      "graphing paper"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "GridLinesStyle is an option for 2D graphics functions that specifies how \
grid lines should be rendered.", "synonyms" -> {"grid lines style"}, "title" -> 
    "GridLinesStyle", "type" -> "Symbol", "uri" -> "ref/GridLinesStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7308, 241, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->505140515]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21942, 656}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1466, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2089, 63, 1579, 37, 70, "ObjectNameGrid"],
Cell[3671, 102, 490, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4198, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4676, 138, 234, 7, 70, "Notes",
 CellID->6849],
Cell[4913, 147, 459, 16, 70, "Notes",
 CellID->24023],
Cell[5375, 165, 1004, 38, 70, "Notes",
 CellID->15125],
Cell[6382, 205, 131, 4, 70, "Notes",
 CellID->797803519],
Cell[6516, 211, 311, 9, 70, "Notes",
 CellID->3528],
Cell[6830, 222, 441, 14, 70, "Notes",
 CellID->39190952]
}, Closed]],
Cell[CellGroupData[{
Cell[7308, 241, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->505140515],
Cell[CellGroupData[{
Cell[7693, 255, 148, 5, 70, "ExampleSection",
 CellID->449585718],
Cell[7844, 262, 76, 1, 70, "ExampleText",
 CellID->196633049],
Cell[CellGroupData[{
Cell[7945, 267, 374, 10, 47, "Input",
 CellID->14626167],
Cell[8322, 279, 364, 12, 167, "Output",
 CellID->520854387]
}, Open  ]],
Cell[CellGroupData[{
Cell[8723, 296, 785, 24, 65, "Input",
 CellID->166557916],
Cell[9511, 322, 3013, 53, 128, "Output",
 Evaluatable->False,
 CellID->42567505]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12573, 381, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[12797, 390, 312, 12, 70, "ExampleText",
 CellID->94554572],
Cell[CellGroupData[{
Cell[13134, 406, 505, 14, 70, "Input",
 CellID->328708268],
Cell[13642, 422, 438, 16, 167, "Output",
 CellID->998655180]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14129, 444, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[14370, 453, 403, 12, 70, "ExampleText",
 CellID->88564141],
Cell[CellGroupData[{
Cell[14798, 469, 1010, 31, 70, "Input",
 CellID->1815006],
Cell[15811, 502, 3157, 56, 70, "Output",
 Evaluatable->False,
 CellID->230014561]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19029, 565, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19348, 576, 716, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20101, 607, 299, 8, 70, "MoreAboutSection"],
Cell[20403, 617, 198, 4, 70, "MoreAbout",
 CellID->1025537455]
}, Open  ]],
Cell[20616, 624, 27, 0, 70, "History"],
Cell[20646, 626, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

