(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40253,        889]
NotebookOptionsPosition[     36527,        771]
NotebookOutlinePosition[     38398,        822]
CellTagsIndexPosition[     38280,        816]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PageBreakWithin" :> 
          Documentation`HelpLookup["paclet:ref/PageBreakWithin"], 
          "ShowPageBreaks" :> 
          Documentation`HelpLookup["paclet:ref/ShowPageBreaks"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PageBreakWithin\"\>", 
       2->"\<\"ShowPageBreaks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Page Layout & Printing Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PageLayoutAndPrintingControl"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Page Layout & Printing Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GroupPageBreakWithin", "ObjectName",
 CellID->6834],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["GroupPageBreakWithin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GroupPageBreakWithin"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether a page break should be allowed within the \
group of cells if the notebook that contains the group is printed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3849]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->415799303],

Cell["\<\
Create a notebook with several groups of cells, with page breaks allowed \
within a group:\
\>", "ExampleText",
 CellID->516311485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"TextCell", "[", 
          RowBox[{"\"\<section head\>\"", ",", "\"\<Section\>\"", ",", 
           RowBox[{"GroupPageBreakWithin", "\[Rule]", "True"}]}], "]"}], ",", 
         
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"ExpressionCell", "[", 
            RowBox[{"k", ",", "\"\<Output\>\"", ",", 
             RowBox[{"GroupPageBreakWithin", "\[Rule]", "True"}]}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "12"}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", "5", "}"}]}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71889078],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e1vZNd92HG2fV/kX+h/IrTNS5EgkTcsgcYyaplJERAs/IKAhb4I6qSJ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   "], {{0, 0}, {458, 649}}, {0, 255}],
  ImageSize->{458 0.75, 649 0.75},
  PlotRange->{{0, 458}, {0, 649}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->812398173]
}, Open  ]],

Cell["\<\
This shows that the first page break splits a group between pages:\
\>", "ExampleText",
 CellID->73640237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ShowPageBreaks", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183740784],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3duPXdV9B/DTVjwgRQhZyR/Q/8B/AA+jXpQnN1GUvrRSA1EBpxWq25e+
WE0UNUmTOFXJBYLDLRRw7gSnIQnpYMLFNobYA4ZgE4xr40Q1geCggpIC3V3j
NWfPPpc5M3PO/s3sxXw+Wjraa1/XvHy1zj579u8PP/x3H/jwH/R6vU//fq93
5Pd6vcXla675J03TNC2ivfnW25qmaVqLrU7Xr339x5qmaVorbShdN30KrWma
9g5oY9O12hC9Xm9jLgQwu2PHqrm56tVXq7HRNbTymv69VukKMEEdrdVIkGbS
FWC9mtFadT5dexdtwIUAZrRrV3XFFYv5mdv27WP26U66AryTSFeACNIVIIJ0
BYiwbdtAV7oCtMLcFSCCdAWIIF0BIkhXgAjSFSCCdAWYwtzc8n/CXn75mB2k
K8CMOv4WF4BCSVeACK2k6759+3bs2NHr9dJnWm4ee/LkyZ07d+ZNhw4dWmnT
/Px8vX5hYSGfbc+ePdXISwjPnz+/d+/evDItpG5j2MOvK1zpBYar7jlh2Pnq
+S9NV0/L9Z9cH5U+07LXJ8JWNnu61llXq9PmzJkzQ5tS5qy0qQ7YHK05PKvB
3EtpVm/NUvfChQv9YbeTrhOGnQJ/6OrpMw9g9CjpClvZ7OnazJ88l6sjJQdv
Dts8l0uTulU3DYVSs5v2r1N36CSjB45ds5Y9Vx1bnjCnOe1KR9VDla6wZbV1
3zUFTpp81t+a++dZMV7WvqnZbc4Vk7Qw+XLTpeuEseUv/vv3708z1Xz1yWOT
rrBlzZ6uKVdz5mQpZBYWFvrnWfGb8nTput5UnCVdxw47TWWHbk1McXVgK5g9
XevfcdKMrs7VbDSIppjWNrtrmbvWWydcZfKeE4adpYxNf+zu3btH09XcFcja
uu+aU2Xoh/J8oyB9ia76P/qMvWVa/x7UPGFjMMvdtdx3TSvzYObn5yenazpw
7J4Thp2Dd9WbzJX7rrDlzZ6uQz+j9yY+M5Aja+ym5hMCtWowXVMYrvrMwNjT
jvyBS5vWO+w6h2v5sbGxRzVHDmw1G/a8a34EdGhT/eU6ZVT+IX5yulZreN41
pVy9w9BghvZMC+kL/nqHnQK2+cxYcwCedwVqHfxfrQ0IpY3JPekKW1n30zUi
o6QrEK2D6Zq+2tc3MyvpCpSpg+kK8A4gXQEiSFeAFjXLE4ySrgAzkq4AbWlO
XLdvX1p5+nR14MBSW1e6zs3Njf0fJQAmM3cFiCBdASJIV4AI0hUggnQFiCBd
ASJIV4AI0hUggnQFiCBdASJIV4AI0hUggnQFiCBdASJIV4AI0hUggnQFiCBd
ASJIV4AI0hUggnQFiCBdASJIV4CpXXllNTe31N7//oFN0hVgLVJ+9npL7fLL
l1aePl0dOLDU0vom6QqwXkNBOnaldAVYL+kKEKHL6dobNLQm+uoAU2jeeh3V
kXTtD6Y3dhmgs44dKyxdR7sAXZOiNc9gR3U5XceuAeiIHK2vvlpYutbLAhbo
oDpaq27/qlX1f8aavAagC5rRWnU+XQFKsWtXdcUVyw8MbN8+Zh/pChBBugJE
kK4AES65ZKArXQFaYe4KEEG6AkSQrgARpCtABOkKEEG6AkxhbF2tJukKMCPv
GQCIIF0BInQ5XSfX1fIeQqCDCq2rtdIagE4psa7W2DUA3aGuFkDrCq2rtdIa
gC5QVwugdepqAURQVwtgs0hXgAjSFSDCpZcOdKUrQCvMXQEiSFeACNIVIIJ0
BYggXQEiSFeAKairBRDNewYAIkhXgAhdTtexVbS8gRDoskLrajUzdmOuDjCF
4upqSVeg+0qsqyVdgY4rtK6WdAW6TF0tgNapqwUQocW6Wrt27ZoDYM16vYHu
Sul6++23/yMAa/be9w50V0rXm2+++WMArNkHPjDQXSldr7vuuj8FYM3e856B
7krpevr06QMArFmvN9D1zABAKzyRBRBBugJEkK4AEaQrwBTU1QKI5j0DABGk
K0CELqfrUEUtgO4rtK4WQBG6X1fL9BUoTvfraqnzAhSniLpa0hUoS3F1taQr
0H3qagFEaLGu1sYMGOAdQ7oCRJCuABEuu2ygK10BWmHuChBBugJEkK4AEaQr
QATpCjAFlV8AovlPWIAI0hUggnQFiNDxdPX6QaAsRdTV8vZsoFAdr6slXYES
db+uVuXOAFAadbUAWldcXa0NuBDAjNTVAoigrhbAZpGuABGkK0CEbdsGutIV
oBXmrgARpCtABOkKEEG6AkSQrgBTUFcLIJr/hAWIIF0BIkhXgBYVUfmlPxhv
IAQK0/HKL/3BSFegJEVUfqmkK1CUIiq/NMYjYIEClFL5RV0toCAFVX7pNURf
C2BGKr8AbBbpChBBugJEkK4AEd797oGudAVohbkrQATpChBBugJEkK4AEaQr
wBTU1QKI1uX3DACUS7oCRJCuAC0qoq6W1w8Chep4XS1vzwZK1P26WtIVKE4R
dbXcGQDKUkpdrcqsFShHQXW1KtNXoBzqagFsFukKEEG6AkSQrgAR1NUCiGDu
ChBBugJEkK4AEaQrQATpCjAFdbUAonX8PQMAhZKuABGkK0CLiqirVfXfQLgB
FwJokbpaAK3rfl2txnikK1CGIupqVe4MAEVRVwugdepqAURQVwtgs0hXgAjS
FSCCdAWIsG3bQFe6ArTC3BUggnQFiCBdASJIV4AI0hVgCupqAUTr+HsGAAol
XQEiSFeAFpVSV6vyEkKgQB2vq9UYj2gFitH9ulq9QdGXA5hdEXW11IQFylJc
XS3pCnRfWXW1KmVhgUKoqwWwWaQrQATpChBBugJEuOyyga50BWiFuStABOkK
EEG6AkSQrgARpCvAFNTVAojW/fcMAJRIugJEkK4ALSqlrpbXDwIl6nhdLbUJ
gBJ1v65WfzCiFShGEXW1GuMRsEABSqmr5c4AUJCy6mr5VQsohbpaAJtFugJE
kK4AEaQrQIR3vWugK10BWmHuChBBugJEkK4AEaQrQATpCjAFdbUAonX8PQMA
hZKuABGkK0CLiqir1WuIvhZAi0qpqwVQkCLqaglYoCwF1dUSsEAp1NUCaJ26
WgAR1NUC2CzSFSCCdAWIIF0BIlx66UBXugK0wtwVIIJ0BYggXQEiSFeACNIV
YArqagFE6/h7BgAKJV0BInQ5XXuDoi8HMLsi6mr1ByNXgcJ0vK5WfzDSFShJ
EXW1KukKFEVdLYDWlVJXq1L5BShHWXW1AEqhrhbAZpGuABGkK0AE6QoQ4ZJL
BrrSFaAV5q4AEaQrQATpChBBugJEkK4AEaQrwBRULQSI5i0uABFaSdd9+/bt
2LGj1+ulz7TcPPbkyZM7d+7Mmw4dOrTSpvn5+Xr9wsJCPtuePXuqkZcQnj9/
fu/evXllWkjdxrCHX1e40gsMV91zwrDz1fNfmq6elus/uT4qfaZlr0+ErWz2
dK2zrlanzZkzZ4Y2pcxZaVMdsDlac3hWg7mX0qzemqXuhQsX+sNuJ10nDDsF
/tDV02cewOhR0hW2stnTtZk/eS5XR0oO3hy2eS6XJnWrbhoKpWY37V+n7tBJ
Rg8cu2Yte646tjxhTnPalY6qhypdYctq675rCpw0+ay/NffPs2K8rH1Ts9uc
KyZpYfLlpkvXCWPLX/z379+fZqr56pPHJl1hy5o9XVOu5szJUsgsLCz0z7Pi
N+Xp0nW9qThLuo4ddprKDt2amOLqwFYwe7rWv+OkGV2dq9loEE0xrW121zJ3
rbdOuMrkPScMO0sZm/7Y3bt3j6aruSuQtXXfNafK0A/l+UZB+hJd9X/0GXvL
tP49qHnCxmCWu2u575pW5sHMz89PTtd04Ng9Jww7B++qN5kr911hy5s9XYd+
Ru9NfGYgR9bYTc0nBGrVYLqmMFz1mYGxpx35A5c2rXfYdQ7X8mNjY49qjhzY
ajbsedf8COjQpvrLdcqo/EP85HSt1vC8a0q5eoehwQztmRbSF/z1DjsFbPOZ
seYAPO8K1Dr4v1obEEobk3vSFbay7qdrREZJVyBaB9M1fbWvb2ZW0hUoUwfT
FeAdQLoCRJCuABGkK0CLmuUJRklXgBlJV4C2NCeu27cvrbznnuqjH11q60rX
ubm5sf8BCsBk5q4AEaQrQATpChBBugJEkK4AEaQrQATpChBBugJEkK4AEaQr
QATpChBBugJEkK4AEaQrQATpChBBugJEkK4AEaQrQATpChBBugJEkK4AEaQr
QATpCrAWc3NVr7fULr980spMugKsV8rSVVdKV4D1kq4AEaQrQIQup2tv0NCa
6KsDTKH5G9aojqRrfzC9scsAnXXsWGHpOtoF6JoUrXkGO6rL6Tp2DUBH5Gh9
9dXC0rVeFrBAB9XRWnX7V62q/zPW5DUAXdCM1qrz6QpQil27qiuuWH5gYPv2
MftIV4AI0hUggnQFiLBt20BXugK0wtwVIIJ0BYggXQEiSFeACNIVYAoTSmhl
0hVgRv4TFiCCdAWIIF0BWlRE5ZfJdbW8hxDorBIrv4xdA9AdKr8AtK7Qyi8r
rQHogoIqv1TSFShEWZVf1NUCSqHyC8Bmka4AEaQrQATpChDh3e8e6EpXgFaY
uwJEkK4AEaQrQATpChBBugJMQV0tgGgdf88AQKGkK0AE6QrQokLralXeQAiU
oLi6Ws2M3ZirA6xXiXW1pCvQcYXW1ZKuQJeVW1dLugKdpa4WQAR1tQA2i3QF
iCBdASJIV4AI6moBRDB3BYggXQEiSFeACNIVIIJ0BZiCuloA0Tr+ngGAQklX
gAjSFaBFZdXVir4QQLuKq6sF0H1F1NUyfQXKUkRdLXVegLKUUldLugIFKbGu
lnQFuk9dLYDNIl0BIkhXgAjSFSDCtm0DXekK0ApzV4AI0hUggnQFiCBdASJI
V4ApqKsFEK3j7xkAKJR0BYggXQFaVERdrar/BsINuBBAizpeV8vbs4ESdb+u
lnQFilNEXa3KnQGgKOpqAbSuxLpaG3AhgBmpqwWwWaQrQATpChBBugJEuOyy
ga50BWiFuStABOkKEEG6AkSQrgARpCvAFNTVAojW8fcMABRKugJEkK4ALSql
rlbl5a5AgTpeV6s/GOkKlKT7dbX6g5GuQDFKqavVH4+ABQqgrhZA6wqqq9Vr
iL4WwIzU1QLYLNIVIIJ0BYggXQEivOtdA13pCtAKc1eACNIVIIJ0BYggXQEi
SFeAKairBRCty+8ZACiXdAWIIF0BWlREXS2vHwQK1fG6Wt6eDZSo+3W1pCtQ
nCLqarkzAJSllLpalVkrUI6C6mpVpq9AOdTVAtgs0hUggnQFiCBdASJceulA
V7oCtMLcFSCCdAWIIF0BIkhXgAjSFWAK6moBROv4ewYACiVdASJ0PF29IAso
Syl1tYYWAIrQ8bpajfFIV6AY3a+rVbkzAJSmiLpalVkrUJSy6mqZvgJFKKuu
FkAp1NUC2CzSFSCCdAWIIF0BIlxyyUBXugK0wtwVIIJ0BYggXQEiSFeACNIV
YArqagFE854BgAjSFSBC99PVSwiBghRRV6sxHtEKlKTjdbV6g6IvB9CK7tfV
UhMWKE5ZdbWkK1CEgupqVcrCAoVQVwsggrpaAJtFugJEkK4AEaQrQATpChBB
ugJEkK4AEaQrQATpChBBugJMQV0tgGjeMwAQQboCROh4unr9IFCWIupqqU0A
FKrjdbX6gxGtQEm6X1erMR4BC5ShiLpa7gwAZSmorpZftYBSqKsFEEFdLYDN
Il0BIkhXgAjSFSCCdAWIIF0BIkhXgAjSFSCCdAWIIF0BpqCuFkA07xkAiCBd
ASJ0OV17DdHXAmhFWXW1AMrS/bpaAhYoTil1tQQsUBB1tQBap64WQOvU1QKI
oK4WwGaRrgARpCtABOkKEEG6AkSQrgARpCtABOkKEEG6AkSQrgBTUFcLIJr3
DABEkK4AEbqcrr1B0ZcDmF0RdbX6g5GrQGG6X1erkq5AadTVAmhdEXW1+oOR
rkAZ1NUCaJ26WgAR1NUC2CzSFSCCdAWIIF0BIkhXgAjSFSCCdAWIIF0BIkhX
gAjSFSCCdAWYgqqFANG8xQUgQivpum/fvh07dvR6vfSZlpvHnjx5cufOnXnT
oUOHVto0Pz9fr19YWMhn27NnTzXyEsLz58/v3bs3r0wLqdsY9vDrCld6geGq
e04Ydr56/kvT1dNy/SfXR6XPtOz1ibCVzZ6uddbV6rQ5c+bM0KaUOSttqgM2
R2sOz2ow91Ka1Vuz1L1w4UJ/2O2k64Rhp8Afunr6zAMYPUq6wlY2e7o28yfP
5epIycGbwzbP5dKkbtVNQ6HU7Kb969QdOsnogWPXrGXPVceWJ8xpTrvSUfVQ
pStsWW3dd02Bkyaf9bfm/nlWjJe1b2p2m3PFJC1Mvtx06TphbPmL//79+9NM
NV998tikK2xZs6drytWcOVkKmYWFhf55VvymPF26rjcVZ0nXscNOU9mhWxNT
XB3YCmZP1/p3nDSjq3M1Gw2iKaa1ze5a5q711glXmbznhGFnKWPTH7t79+7R
dDV3BbK27rvmVBn6oTzfKEhfoqv+jz5jb5nWvwc1T9gYzHJ3Lfdd08o8mPn5
+cnpmg4cu+eEYefgXfUmc+W+K2x5s6fr0M/ovYnPDOTIGrup+YRArRpM1xSG
qz4zMPa0I3/g0qb1DrvO4Vp+bGzsUc2RA1vNhj3vmh8BHdpUf7lOGZV/iJ+c
rtUanndNKVfvMDSYoT3TQvqCv95hp4BtPjPWHIDnXYFaB/9XawNCaWNyT7rC
Vtb9dI3IKOkKROtguqav9vXNzEq6AmXqYLoCvANIV4AI0hUggnQFaFGzPMEo
6Qowo9nTdW5ubuz/KAEwmbkrwNSefbY6cGCpHTs2sEm6AkSQrgARpCtABOkK
EEG6AkSQrgARpCtABOkKEEG6AkSQrgARpCtABOkKEEG6AkSQrgARVkpXb3YF
mMVK6Xrbbbd9FIBprZSuH/vYx/4cgGk10/Vvr/vsqef/697vHf7MZ+/UNE3T
Zmxv/u+bBw8/+/f/cP01130upWtqJ0++oGmaps3Ymul68sSLVfX222+/pWma
ps3S/u/tt5rp+rNnzr755luvv/Hb1N642JaWX0+fv6u7r7++tENaWe9cLzfb
G7q6urod7a47075889dv+eAf3f2+P77rfX8y2tL6tDXtkw/87W9/9/rrv6vT
9aknT//mtddffuU3L79y4eLnb/rLF4aXf93cod6/Xvna4FZdXV3dTnWnybT9
H/yzt77wxer2O6pbbx3Tbr8jbU375ANf+fXiIXW6Hjv2/C//+5Wz53519sXz
l11+ebOdPXf+7LmXlpZfbC6/lFpjt1/1F16ql3N3eX1j/7E7L5/54s55a14Y
Pmpwq66uru6auoshdv7iyrzmfH99vy1tOr94VP8MP7/2quq+71f3fGPFdt/3
0z752Bd/8asXz71cp+vjTzz3/Olfnvz5izm+0kJu/e655fXPLe/TXzh7ceel
fZ4bOMnZZnfo5ENbU3dwh8WtzZ0nb9XV1dVdtdtfOLe88rnB7uLy2cY+i2d4
7pqrqv33Vt/ct/TvWGkht7q7/960z8VDzj33/Lmfn/plna6HHztx/JnTTx4/
lRMsLSwcP9Xs1gvjVr4wdv3C4EkWBk8+unVhcDlvbe48eauurq7uGrtPDi6P
tBeaR6WF4XRNvtVY7qdrPuqpp089/bMzdbqmhcePnjjy02dzgj32xInDj594
7Inlbn/h2eby0sJPTzz2+LPL3cfro549kvZvdIfuAIzunJcPD+55ePGiA1vr
M6cFXV1d3bV3jzxxIrXH+p+PLa4/sbj+YuLlnetMq8/w3DVXVvvvqb5x12Ib
cvdt1V23Vt/5ekrXx/I5f3ri6MLzdbo+evCZRw4ef/jg8ZxgaeHhR48/dPCp
pe6jA+uHVj50ceXDj9Y7P7W8/uDxZrc+8KEVdl5afvSp+ti88+xbdXV1dXOC
5TVpeXnN0vqlVmdafYaTf/2hxVy94yvVHXurr960HK233lDd8sXqK59PAXvy
6g/1D3nq8JETB37yZE7XRw4+88CDx1LLGTX/k8XlB35yNHfr9XVr7txfc3Ro
Yag7/+Cx+cFD5hdPcnTcyY/mnfPWurvS1nyq5uVGj9XV1dW92F1aM7+0fqA1
9h84w2K63nlLddP11ZevH567fuFz1ef3VLfclNK1Ps8jB5/+j/sO53R9+NGn
f3j/Yz/68ZGcUWkht9z94Y8f/9FiO/Kj+4+k5cXu/Y83dr64aXH9kYt71keN
7w7t3OzWJxzdWmfv5K1rvJCuru7W7P5wef2YTMtbRzPt5NVXVrfe9Na/fbbO
1N/96/LyG5/+VHXjl567+sqLxx754f1HHnxo4WvfeGApXR95+nv3Hfz+Dw7n
gEoLuQ11h9rg1kN1t7H+0Gi30Ya7Qydc49aLKweuvuqFdHV1dVdrh+rPxfuu
N37ptU99Msfp//zLJ1+72HL31U98ovrSF9M+9bHzB47efOv3+un6zD33Hrr3
e4cjWs69dvds91hN07QJ7dTOq6obbnj54x9/9RP/PNrS+urGG05de2Xe+bv7
D9//n8eu/8I3ltL14Z9965uPfOfbBzVN07ShdvQjf1HtvbG6MbUbxrQbbqj2
3vzE3/xV3vnb3zr4g/uOfuazd+Z0ffDB43d8df7uOw9omqZpQ+3LN3/92NV/
+cJHPvz8tVeNthd2XnX02qvSPnnnu/79ge/ec1i6apqmtdukq6ZpWkSTrpqm
aRFtKF0fevj4nXfM77v7gKZpmjZLu/uuB/bfu5yuL5779akXXjr1wnlN0zRt
xvaLX1yo01XTNE1rt6V0/X87jpfG
   "], {{0, 0}, {458, 649}}, {0, 255}],
  ImageSize->{458 0.75, 649 0.75},
  PlotRange->{{0, 458}, {0, 649}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->263970725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10199082],

Cell["\<\
Create a notebook of several cell groups, with page breaks not allowed within \
any group:\
\>", "ExampleText",
 CellID->363942613],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"TextCell", "[", 
          RowBox[{"\"\<section head\>\"", ",", "\"\<Section\>\"", ",", 
           RowBox[{"GroupPageBreakWithin", "\[Rule]", "False"}]}], "]"}], ",",
          
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"ExpressionCell", "[", 
            RowBox[{"k", ",", "\"\<Output\>\"", ",", 
             RowBox[{"GroupPageBreakWithin", "\[Rule]", "False"}]}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"k", ",", "12"}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", "5", "}"}]}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204405641],

Cell["Now the page breaks can only occur between groups:", "ExampleText",
 CellID->59323408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ShowPageBreaks", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70449562],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3V2PXVd5B/DTVrmIFEWRxRfoN/AHyMWoL5cuqKI3rdQ4qARDhZr2pjem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   "], {{0, 0}, {458, 649}}, {0, 255}],
  ImageSize->{458 0.75, 649 0.75},
  PlotRange->{{0, 458}, {0, 649}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->81587987]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27450],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageBreakWithin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageBreakWithin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowPageBreaks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowPageBreaks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9180]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32252],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->20912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->70481615],

Cell[TextData[ButtonBox["Page Layout & Printing Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PageLayoutAndPrintingControl"]], "MoreAbout",
 CellID->112767977]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GroupPageBreakWithin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 18.9750728}", "context" -> "System`", 
    "keywords" -> {
     "pagination control", "pagination", "page breaking algorithm", 
      "page breaking control", "page breaking", "page break", "new page"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GroupPageBreakWithin is an option for Cell which specifies whether a \
page break should be allowed within the group of cells if the notebook that \
contains the group is printed. ", "synonyms" -> {"group page break within"}, 
    "title" -> "GroupPageBreakWithin", "type" -> "Symbol", "uri" -> 
    "ref/GroupPageBreakWithin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3328, 103, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Notebook Image"->{
  Cell[4862, 157, 9603, 160, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->812398173],
  Cell[14800, 334, 9168, 153, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->263970725],
  Cell[25392, 538, 9187, 153, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->81587987]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37810, 799},
 {"Notebook Image", 37943, 803}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1913, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2536, 76, 57, 1, 70, "ObjectName",
 CellID->6834],
Cell[2596, 79, 695, 19, 70, "Usage",
 CellID->3849]
}, Open  ]],
Cell[CellGroupData[{
Cell[3328, 103, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3705, 117, 148, 5, 70, "ExampleSection",
 CellID->415799303],
Cell[3856, 124, 141, 4, 70, "ExampleText",
 CellID->516311485],
Cell[CellGroupData[{
Cell[4022, 132, 837, 23, 70, "Input",
 CellID->71889078],
Cell[4862, 157, 9603, 160, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->812398173]
}, Open  ]],
Cell[14480, 320, 116, 3, 70, "ExampleText",
 CellID->73640237],
Cell[CellGroupData[{
Cell[14621, 327, 176, 5, 70, "Input",
 CellID->183740784],
Cell[14800, 334, 9168, 153, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->263970725]
}, Open  ]],
Cell[23983, 490, 124, 3, 70, "ExampleDelimiter",
 CellID->10199082],
Cell[24110, 495, 141, 4, 70, "ExampleText",
 CellID->363942613],
Cell[24254, 501, 840, 23, 70, "Input",
 CellID->204405641],
Cell[25097, 526, 92, 1, 70, "ExampleText",
 CellID->59323408],
Cell[CellGroupData[{
Cell[25214, 531, 175, 5, 70, "Input",
 CellID->70449562],
Cell[25392, 538, 9187, 153, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->81587987]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34640, 698, 311, 9, 70, "SeeAlsoSection",
 CellID->27450],
Cell[34954, 709, 476, 17, 70, "SeeAlso",
 CellID->9180]
}, Open  ]],
Cell[CellGroupData[{
Cell[35467, 731, 314, 9, 70, "TutorialsSection",
 CellID->32252],
Cell[35784, 742, 143, 3, 70, "Tutorials",
 CellID->20912]
}, Open  ]],
Cell[CellGroupData[{
Cell[35964, 750, 318, 9, 70, "MoreAboutSection",
 CellID->70481615],
Cell[36285, 761, 170, 3, 70, "MoreAbout",
 CellID->112767977]
}, Open  ]],
Cell[36470, 767, 27, 0, 70, "History"],
Cell[36500, 769, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

