(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    133142,       3060]
NotebookOptionsPosition[    125065,       2775]
NotebookOutlinePosition[    126449,       2813]
CellTagsIndexPosition[    126362,       2808]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExtremeValueDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ExtremeValueDistribution"], 
          "WeibullDistribution" :> 
          Documentation`HelpLookup["paclet:ref/WeibullDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"ExtremeValueDistribution\"\>", 
       2->"\<\"WeibullDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["GumbelDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["GumbelDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/GumbelDistribution"], "[", 
       RowBox[{
        StyleBox["\[Alpha]", "TR"], ",", 
        StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Gumbel distribution with location \
parameter ",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26068]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The Gumbel distribution gives the asymptotic distribution of the minimum \
value in a sample from a distribution such as the normal distribution.\
\>", "Notes",
 CellID->53261241],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a Gumbel distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "\[Alpha]"}], ")"}], "/", "\[Beta]"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Alpha]"}], ")"}], "/", "\[Beta]"}]}]], 
   TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16321,
  ButtonNote->"16321"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " to be any real number and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->12600],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2554,
  ButtonNote->"2554"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->834895108],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->206691684],

Cell["The mean and variance of a Gumbel distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1988],

Cell[BoxData[
 RowBox[{"\[Alpha]", "-", 
  RowBox[{"EulerGamma", " ", "\[Beta]"}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198967047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16798],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Pi]", "2"], " ", 
   SuperscriptBox["\[Beta]", "2"]}], "6"]], "Output",
 ImageSize->{38, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->197393426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19002],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30104],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{"x", "-", "\[Alpha]"}], "\[Beta]"]]}], "+", 
    FractionBox[
     RowBox[{"x", "-", "\[Alpha]"}], "\[Beta]"]}]], "\[Beta]"]], "Output",
 ImageSize->{68, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69964001]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"GumbelDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7056],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151331119]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17708],

Cell["\<\
Generate a set of pseudorandom numbers that have the Gumbel distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.1798520503766943`"}], ",", "1.3305376257779087`", ",", 
   "0.49130781205429963`", ",", 
   RowBox[{"-", "0.9981911630761946`"}], ",", 
   RowBox[{"-", "0.5673982020906322`"}]}], "}"}]], "Output",
 ImageSize->{352, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38601368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14804],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26385],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"12", " ", 
    SqrtBox["6"], " ", 
    RowBox[{"Zeta", "[", "3", "]"}]}], 
   SuperscriptBox["\[Pi]", "3"]]}]], "Output",
 ImageSize->{109, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151751265]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17260],

Cell[BoxData[
 FractionBox["27", "5"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88209484]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31620],

Cell["Third moment of a Gumbel distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9578],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"\[Alpha]", "-", 
       RowBox[{"EulerGamma", " ", "\[Beta]"}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["\[Alpha]", "2"]}], "-", 
       RowBox[{"4", " ", "EulerGamma", " ", "\[Alpha]", " ", "\[Beta]"}], "+",
        
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["EulerGamma", "2"]}], "+", 
          SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
        SuperscriptBox["\[Beta]", "2"]}]}], ")"}]}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[Beta]", "3"], " ", 
     RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{539, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277907930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a Gumbel distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4591],

Cell[BoxData[
 RowBox[{"\[Alpha]", "+", 
  RowBox[{"\[Beta]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "q"}], "]"}]}], "]"}]}]}]], "Output",
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135375340]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29761],

Cell["\<\
Plot the cumulative distribution function of a Gumbel distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"GumbelDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491585774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8007],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->17584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"GumbelDistribution", "[", 
      RowBox[{"0", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", 
     RowBox[{"1", "/", "10"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10951],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsXQVYlU3TpsHuxAC7u2sOFnZid2ALJnahiB2YIBjYLaKACuwBpLu7u6S7
ft+D957/PHxeXpfv/c4+uzO7szOzNUdzs/4SXQU5ObnHTeTk/vu3/o+a2Mz0
vz8/aLZJr79/lTmWwNkKHNvsjf77t5YBz5IUqOA4SlKgiOMICc7muKLuvz/x
HF+Q1O/McZakvDcB35fQkzg+8F/zNrkc95UwXMzxPUn5So7/CSiSxWriCxPe
nJ/wJpjLCwx5gSEvMOQFhrzAkBcY8gJDXmDICwx5gSEvMOQFhrzAkFcWq4kX
qR7++zeBywsMeYEhLzDkBYa8wJAXGPICQ15gyAsMeYEhLzDkBYa8wJBXFquJ
1xe021DQLp3LCwx5gSEvMOQFhrzAkBcY8gJDXmDICwx5gSEvMOQFhrzAkFcW
q4n3/KsH8gJDXmDICwx5gSEvMOQFhrzAkBcY8gJDXmDICwx5gSEvMOSVxWpi
h6SBjkkDC7m8wJAXGPICQ15gyAsMeYEhLzDkBYa8wJAXGPICQ15gyAsMeWWx
mvj3ipOuK06WcHmBIS8w5AWGvMCQFxjyAkNeYMgLDHmBIS8w5AWGvMCQFxjy
ymI1sbfPf3/KubzAkBcY8gJDXmDICwx5gSEvMOQFhrzAkBcY8gJDXmDICwx5
ZbGaOEira4hW12ouLzDkBYa8wJAXGPICQ15gyAsMeYEhLzDkBYa8wJAXGPIC
Q15ZrCaOlLRTx+UFhrzAkBcY8gJDXmDICwx5gSEvMOQFhrzAkBcY8gJDXmDI
K4vVxPn/mesN8iLICwx5gSEvMOQFhrzAkBcY8gJDXmDICwx5gSEvMOQFhrzA
kFcWq4kPSRyyIpcXGPICQ15gyAsMeYEhLzDkBYa8wJAXGPICQ15gyAsMeYEh
ryxWE5df+fz3rxKXFxjyAkNeYMgLDHmBIS8w5AWGvMCQFxjyAkNeYMgLDHmB
Ia8sVhP/Z61dV6hweYEhLzDkBYa8wJAXGPICQ15gyAsMeYEhLzDkBYa8wJAX
GPLKYjXxv3+5vMCQFxjyAkNeYMgLDHmBIS8w5AWGvMCQFxjyAkNeYMgLDHmB
d0m+T2VZT5v//etF3STfh3DsI/nekoAXSeSLJGH5+n6J4uWFWOLuXZNJAk1U
xPge/Q18W1KglAkx6usp+T6f09GfwKCjPOQTrkdRHnSUhzzC9apQXqy3IJ9w
PSvsP5RH/6E8MNqfI/mPGpLtHzmRsH30J9oT9jfWR+hvR0l8qcr1GxjtCTH0
A9+DX4wH5EF/A6M/hfICo37UB3mE/Ar1Ffw1l0Dxv/kbQNaS+ZfEYiT94ELX
6vuBY0vJv+8bYHyfJMHBBDow6Gjv6n/msDyMf4/xkLVHAf/GQVUs5Afy4ntg
1I/yqE/ID8r3lvRPLaejvf+8ccE9VRHowNBf6Afal1RnGsvnH+q7KSn3h/eP
pqS+jAYY5TdKxtuXY4ynkC7sT8gDfRXKi/6GPLL7U6oN9APygi7cD0L9kFfY
X6hPSfJvBp9/sLfAjhJ9i+PjjfLoX+g75ie+F9Kh7xgPyIv5BP4xHsLxAT8Y
D2D0N74HFtpv8A950D7owKCjfWDoD+RHe/Ml36fy8qBj/oOO+kEX9hcw2guR
rCeSePwPeWol9ryA9w/6T9g++hvtoz58j/4ARv2YP6gP+ivc/8P4wr8Ag3+0
D3uF9jA+6E/UDyyprq6K23vYX2DICwz7C1wfn8iJdbf99yeL1weM+oBRHzDq
A8b8Bsb8BYb+AKP/gfUk9SmKJd13Pp/zBwz+gMEfMPgDBn/A4A8Y/AGDP2D4
G9F/6hBSxPkDBn/A4A8Y/AGDP2DwBwz+gMEf8D5J+QIS8lMfV5ZxfoDBDzD4
AQY/wOAHGPwAgx9g9BcwxhMY/C2Q6Hcl5wcY7QOjfWC0D4z2gdE+MNoHjpN0
SBnHGM/lEv2v4fwBo/+AwS8w+g8Y/AODf2DwDwx+gcEfMPj7JFlgyYnADzDa
B0Z7wGgPGO0BQ3+AIf+Ikf/9UeDtAUN+YLQPDPmBwQ8w+AEGP8DgBxjxHzD6
o54vRc4vMPgDBj/AaB8Y7QOjfWC0Vz//lUWy9kZZJGtflEWy9kRZJGs/lHl/
Ij5FfcCoDxj1AaM+YOgL8AdJBYYs+T/o6MbjSfhP+A9gxAPAsuvnAK6voMPf
wN8hHoF/QzwGf4T4VOiv4O9QHhj8CNcHwvgb9JMSuitJjjs2+NIgSUU/WL2/
FhP6Axh09A9wfTwXxDGvT8JPAIGO+oTxOeoHP0KM9rQk9X1rQBfGv8L4G3im
5D/SOb+FEv1x5+0Do73tkvoCOR39L+wftA/9wnihPmF8iO9VJfXFUBfJ/4jn
dIwP+hPfQ78R32B8heeB0DfsjyA+wXwRnr+BjvhKGO+gPNoDhn4Dw58Aoz+A
4U+E54OIVzC/hedlwvhJeH4mjKeE52nC+Ap08A8M/oHBPzD4RzxTr1cKPJ6C
PRWehwnjLdDBLzD4AwZ/wOAPGPwJ4xm0Byw8z0N5rM9k469aJozHhOdbwnhM
eN4ljM9AhzzC8y5hfAY6+ht0yCukA0NexEsYH2H8JDzPEsZ3oIN/4XmWML4D
HfwDg19g8AsM/4P6gEEHvzjfAX/A4A8Y/AjPn4TxH+jgDxj8CeMp4fmZML4S
nicJ4z/heZIw/gMd/AODX2DwC4zxRn3AoIN/xGfQd2E8iPMV8AMMfoDBDzD4
AUb7wIi/0B6w8HwK8RnGW3heI4wfhec1wvgRdPALDH6BwS8w+EP8hvEWxnM4
rwA/wGgfGO0Do31gWXulzPeXhO3hvADtAaM9YLQHLLv/osLjPbQHLDxPQTwI
/cB+FdoDRnvAaA8Y9QMjHkD8gf0lxAvYrwDG/IU/RnxQP49Suf0EHfEJ6IiX
EM/APiEeBEa8gHimuSRAjeDfA6M8+JON35IE8VESp4MfxNNoHxjxcKikXDiP
j9C/wvhMGK/ie9SH+ElWHwK4PMLzCWH/gn/UB/4hj+z9LlWxxD05qfD9UOgP
vkd/AaN+8Ac6+IN8wML4GRjjj/FDPKz2H3uLQjkWjifoqA/tAaM/8b2wPWDQ
0b+S6l+oiiXtbZSupxDfYnyF8TXaB0b90Ddh/I94G+sLyAMMeWHvwQ/WP+h/
zFdg0DHewBhv6Juw/4DBv1A+4X4x6MCQH/ulaB/7mcDYrxXSob9YT9TrYSKv
H/xjfgLD3wvjXeH9KsSTaF8YbwrvIwn3r4T3W4TxhfC+h9BfCv2V8HxduH8g
tHdC/W4vOZCIJtnz7wBuX4Tnf0J7gP4GRn9Cv6GfGI/69pI4HfwAC/e/hetb
2LN6f1jJ7RH8BzD8B3D9OMiJMyT15/zz68UMGN8D43vg+vmj+M//FvD2gVG/
oYS/Yl4/MOoHRn2S4Ssv4/UBo31g6O8tScGqf/Urix9K7GUtbx8Y7QOjveD/
+tMC+1+VDBj8AaN+yfjOwP0ROX5+hfkM+4LxwnhivDCe0DeMn6mkfBhB/zD+
0I/rEv17wlZKOtiJXCX8OBMw9JPbv3/2CBj2Ee1hvsOeQt+F/qjeXkRxfYU+
Q17wi/qBIa+QDnuP8x3MH+xPAWO8Zc+bapjE/Dhm8O+B8T0w+AeuH1/5f/F8
3j+7VsaA6/tJSVxfbyFvDxjtAaM9YPQnMNpTkdj/Ut4eMPgDRvzQVKIgFZyf
tpL+q+b8AIMfYMQXzf77XkNOhPYl6xZPeRHaBwb/wGhP0h37cf+rhiF+cbb9
D1+ljRKFduX6Bn2HPsDfgQ77CX0ERnnEJ9APzA+U5/td//w39AfloZ+go7yZ
RH8c2TMJg/bkKJHHmmPMJ2CUr19nedMzSb1+NFXSAUG8POzvJwn9J+F7yAN+
ML+BJ0r+w5XP37eS9ryY8HvwD34Rj0JfsD/2S/J9FkF/4e+hf4hPYF/vSr7P
J9hnxBOgz5PgIoI+1r9RKSXYW7QHfUN9sKc/JfRygv4hvgKu989VtPA/+1Ei
x8/7oW9oX1JdJ2UR2q8PC5RFsPfwr5gvwvUNMOQHhr5A/zA+QizURyGGfUR5
4KkS/mMb+G/Y10rJuITy8Yc+1Mcv/lwfoH+IL4TxL/hF/cDQR+gL7CfkB39C
/yKMvxEfvpa095HADzD4hX1H/2D+AY+UYI9/5yeB3F9hPtXzE8zlhX+RjacC
mGR7dpvHP/1K+KdvKZwfYX/je/Q3+IU9gn3CfBfe7wD/2D8BRn8Cw18K6fCP
qA/8oD6hf4N/Qn3A0F/MZ+x/YL4g/sD+AeqTvQ+RyMcX8Yjw/AF07G8J39Ng
fxzzD/Ef1nugY/4J6VgfyN4XK+DrBdBl7/MU8P7CegH9CXuE/sL+JeRHPIj+
wv4X7A3iOegP9Av6I9zPEGKMn+x6IUkQ/0jjeegb5rNwPSqMl/63/0ikG5J/
U7g9wf4jMNoTxmcYX7QPjPHA/IH9wHwBxvyFP4L9gv3FegoY9aE86gMd/MKf
on7wg/4BHfYBGOMFLLy/B35gb4TxCvob9lboj1Ee9gMY9gjyQH9Ax/oY6yvE
8+hvyA/50J6sfw/g8mK+AUP/oR/Qd2DIh/mN7yEv4j/wBzrsDfgDRn8K6Zjf
sE9CewU65jfsA+IN0LHfj/kve/9LOv9Bl73/WMDnP+iy+4cF3H4J7Q/iJdn7
pwXc/oCO+rGfgfoRL6F+0FEf6NjPAB3xknD9i3gL9cHeoT7YO9hT0NHfoKO/
QUd/C9fPWF+gPthP1Af7if7Hfgz6H/Ee7CnWD5iPmA/AmI+IP6D/1RJ6Jsew
X8J4AvqM+QR7DH7/t30WE9YriK+BMd/R3+AP8QDsCzDkgT0DXfZ9QBAvj/gG
WGg/MZ/BD+Y/7D34xfiDX3wP+WDfwA/sEb4HFu4XYD8A8Se+B4a88B/gD/Ea
6oe9Aoa/QHuYb8Cgg3/oB/jB+GK8wQ/qh30Dhv1EfbC/sLf1+hNFEnVqnMDt
HfQN+oz2gIX3J0DHehT6Biy8TwH7KvknurjBfhzicdg70IERf+E8CXTwJ8TC
+xfC8wjQMV+AYR9gv8GvEMvevyjm+yVoH/YcGOUhD8pDfmDYI5TH90I6MOwv
2gMGHfEN6JBfuD4GHfoCDH6xvw1+gNEe4nHUDwz7Dozy2P9G/wv9Bew/6MAY
H+H+EM7/UR72HPxifQ59h33C/MH6APEk4gP0nzA+EN7fAR3zG3TMb9gPYNgX
8I/5g/lfP98iub2SiOcTLrhfliTY70nk9hf8YD7Wz/80jrFehP3E/hL8EfoH
GP2D8QNddv89ifcn+JGNL5N4/AD+UD/4AwZ/2C/BfptE3BeqYom/KFXh+8uw
R+hf+BOMD/hFf8IfAcMfof9Bh39wk+hrCI8PMF5Yz2N80B7sKeqvP5cJ4/Uj
XgbG+gDy4TxUUl2QqliiLjOl54Owx7Ln6dL9A+F+AuSDf4X+gV9g0IXnh9Bf
jAf4QX9g/GXXb0mCeD+N04X6Ktx/EPYX+h/ygF9g6C/0AXT4Y+F5oWy+i2TO
H+SVzSeSyPsX/hX1A6N96LswfsB4AEMelBfmN4H9l7BvUinYr6/k9gf7E/ge
/kj2fKCowfyEvPXla/l6APsn8A/AwvuF4Ef2/k8ebx/l4a+F/g502ftCUv8G
OuypMH8H/BP8F+jYDxsgUfgc3p/wL+g/2fOISu7P0B4w6hfm78B6Av0DfwQM
/4b+kf2+mMmepxQ1wLLvKYq5PwRG/ehP4f1A1IfzZLQP/Qcd/QmM8UB9GA+0
D/sNDLrwvh/WR6DD/wLjfBv2C9/Dv8J/wz4AY30lfG+P+Yn+E8abmC/1463C
7zcCC8cL6z/oj+z7jUq+n4bzddCxvgXG+QDKw96ifyAfMOTHehLn+aDjvB8Y
5wsoj/mG+wDoD9n7e8UM5w3gB3TwAwx+hOWxf4jywCiP/UToH+jQN2DML5RH
/9fzKb3PB4z+x3kz9BV0rM+BZdYXf8uDf9DBP7DMecrf8uAfdPAPLHOf5G95
3M8AHfctgHGeg/Ky782U+f1B2fcbyuJ6tVIWyb4nUxbJ7gcpc3lRXvZ9mbJI
dv9Hen6E8rL3tZVFsvvRylxeYf2IV1A/MOrHfQDUDzrqB0b9KI/4CfEw7Ifs
+/pE7t9hD4QY62nEl8L9F9SH+AMY7Qvfz2N9gPHAehfvJRDPAAvPLxFPIb4U
xjvCeKI+XooSxPPS/VNgfF8/7+P4fi3kR3wHDPmE+w3gH+spYNV/dhb8AiP+
xfeI38EPykMfsF+B8Ud8Av+N+BEY+wPAiB+hL8D1/MaSxLxYS88HoA/QH/gL
0HFeqCGZgMk8XpbdD4/h/lO4nhfuxwr3X4XvPYX7rbLvI1T5/SB8L7zvL1xv
C/dThetp4f6ocD9U6A/hv2CPgHEfQngfA/4N9hl0+B98j/4CHRjfgz+h/0R5
2FPQcR4OOjDqw/xE/IHxEfpb0DG/QQc/oAMLz/dBhz2H/6wfTwWO6/tHvsF9
FPhX+GfQYd/xPfgHHRjfQx7QIQ++B/+gA+N72GeURzwDDP3C98DC9rH/jfkJ
jPrg//E96MDC+2c434V/A0Z7wGhPeH8CGP4U9ynqsZzA39Zy/4j7PigPDP8n
cx+9k9SfAsvkI/iLEd/A32F+AGM+YL8DGP4Q9YOO+oERj6I+zBdgzA+UB0b9
2F/A+vWrxDDcZfXj4M7tO/wR9A/+oV5f0xqsd4X5WPE95MP+DTDWs4hnQUd8
gf0XSfG6qgb7s8L3e7Lr1xome95W0+A9Hexzvdwl/+bfH37+g+/r7Usep8Of
AMN+o33YY2CcP8reD63gGHThezjhfirWd6gfGPNJdv2pzP0L6pN9r1bDz+uA
he/bhOtR4fs20KEfqA/9Bwy60F8J94eB4a+E6zWsH9FfON8Dhn+DfoEOLHy/
JjwfFPpPYf5F+CPwB38Eeyr0T/ge/hPrYfADDH06+F93Gkv3r4Xnk8J8hvBf
iCfgr4Bxfxz+HnSMB+ioHxj6JPu9PH8PJnteIbXnwvdiWL9jfGDvgYXv+VEe
9aM8sPA9GO67o3+x3gK2+bceQ3/B3qN/YN+B8d4J/QU65gfoGF9gjOe/djgd
GPGlMN6E/YR9wXoD+5uIr2Xvs0j3L0GXvV+cxuNxxOtYTyB+ln3/ncjLI56G
vRG+15BdXwXz81lgnEdiPYZ4X/b+nRTDfkvYf6EqlrB7TUWE/Xbh+Qj2U7G+
wf4//Bkw/NkXiYL4cPlwHvpF0v8RfH2G9Q3qx/61cL8b/grrR5TH/jPqw/wV
3p9Bf8Kfoz+wnpEUj0/g8TD8g2w+wQJOh7+APRK+P4H9QXwEe4d4ARh04fsU
zH+0B/sBfoBBF743xfxA/ZhPaB8YdMxP6CvmA/QVWPY9QIzgfnI03y8QvqcT
3k/D+KD/Je7MOInHH4g3sD6XhANZ0vza2H/E/TXMP9DxPej4HvZPuL8uu/9f
8i8ey+T+F+MPLJs/qORfPJovyJ9WwLFsvqI8Xl42H1QBxygP/4TyGF/EU9AH
YOgD4ifYa2H+Jdn82oqCeExFLCufilgY3yA+wn4c9B/6BQz9kn2PI8fXu1i/
AYMf+HPsz4KO/VlgrA9l18cqgvzJyvw9A+Ix2f3aWo5xvoD1F/RDtr5ivp5F
fILvYV+wXgP/su/Dq/j6DuMhm09Xkb+fQH/Bn6K/ZP2rIn8/gfGAv8Z4AGM8
hPvBmP+y+SGU+foQ6yvEC1jvIN4Ehr5j/QP+YY/Qv6DDXmB9g/mJ8Ud8Aww6
5EV8Aoz4A/xiPmF/Cvs72M+TzVeayP0b/AHiF5yHS4oFqYol9qyVqgj7ZfBX
9ffLUni8gfkI+wL/hPkGjPmE8RG+70G8D/0SYvQP4kn+nuWf/4T8sI/A8Dfg
r5+kfBq3l+hf4e8NwD6gv2XtoxzPZ4H4Ff4O8w3zF/Ed5i/mp2x+hhom+76u
gs9X6APmG+yDbP6pKr7/gfhkkGSAvATrbel+J/oDGOdbaA/jjfkDjHgA4yub
bzuP769i/Yr6MN6oT/ieS3jfBuOP+Sh834XyOP8Dhr2U3T+s4ftZ0D/0F+an
8PdTZM9Plfl6FfMJ9hLxA+wl7CHoGB/QsT7E+CO+B3+oH3TUL6TDnoIOeaDv
oGO8QMf3WA/he9gXfA86vhfaX9CxHgEd44X1k8x9wE7S8x7QZfK1dpKeH4GO
9oXfw97ie9hbfA86vhe+t0O8DvshfE+HeBznLSiP+QT6IYm84bw+2Xwl0vtz
0HfEN8CQB/qF+3PAiH+gj7C3oENe4ffQf/g3xEuwP8CYn0IMe1jPZynfj4K+
Cu/3oXy9nSvg5XF+BQx+hPtHwvfMsKewF8AYT9hTYGF8JTwfBcZ6CetLrD+B
oR/cv0gcxmaCPZXN/5bI28d6E/eBsH4GRjwP+4h4HvYI44XxFdor6K/s7yXk
8f1Q2f2/4n/7y/kk+3sKeSSbj76Avknay+HlZX9vIU/wXr+Ar39QHvLL/h5O
Mr8/A4zxh/+E/YD9F9oX2C/YF9gv6APsA/RVGL9h/sP+oP8wf3F+B8zPVyX8
hfD1OvQX8QTqB0Y8hPt46F/oI9qHvgILf99ENn9lMRPGr8AYD5RH/Ac6+AOG
f4a/h/4h/oF+IZ6B/sH/gC4b3xbz9Rr0Bxj6IVzPYX4AI95A/Av+ZPMF5XOM
9Rn0AfYT/hb2ERjywP9ifsGegh/Ii/kJfX31X/MTsknG/5jG8ngHWHY+x3N9
gT/BeQb0A+0J7w/CnsKeAyNexXwCP8Cy59dRnA6M+rG/gfogHzDakz0/l+br
UBQtfjVpSyhNyVjx7olcIveP38WHJn2obfj7Ymq+CiPmTE8ky9c7Vg/q50TC
3xcTFe7R9w1Ppz43vrwe08GN2w8VK7O6uwnS/ChYD/6wzJvbRZRPdz1H58RW
e3F92D1kncu2hYkN8u2l7X9avd1L+ntTKg6+11folJBr4LNVM7s2zK/X+3fh
Pr3IQuqQoaShl5DT4D5c6dGrpZeOF1LwhebTOuVL8688bT4xSGQu/f0mZe+2
ph/vVjS4z9ZXx97seWgJXe640LtiiPS+26BtMx/uee/C7cHla92Xn/TN4vFj
m6/k1vlgw3xwWzocXHBxeDXtCptskje6Yb43+c5NX+3/G2826treRE+jhMeb
Z07+DrWsdZXmf/Ptoqc7Vvp7PxW5tte8Fnnw/ffVK19dOucrzbeG9YfqDsOD
vy5If9+oh+Ukdx1HeZGzt7Xy5cfSfGqLxz/37WIi/f0bq8Gj83LTpL934x1H
2XMtvTiO3WS20W5mDI8v5zpO/nW8WyHH+duz95U71nHcaNW2k1o60t+nsdLu
0ayntzQ/mveHdmE7Vvzh2LJ0Wb+tRT4c35R3sevuEMfjTfMvps9XWBc1+L0Y
14F2p5YOVRSdmtFr7qBN0vxnqw+bvxo33Z/jQRs1aqIfJjTIbzane0V1twoV
0ZEJsTUa3aXvi2donTm+zyuA7+87LD2gcCsoke/vO424YjfHLIFNX7S5+RX1
BKK2w7pPbePO0tu9DjxxMZ7UH13YOtmogmmmj/7p9zKN1ox7bju9uo5N2G18
1Xd7Du3L6bS+Zm8ue2zh4mp/PYf0PK73N4hMYi+qDlb8bpFDw06+DMozc6X3
Hs6/reJyaOU5yw9GMyvZjlvnom3OF9DKML3mv4q9aPeja7O79iykid52NrdL
E+haur2atWcBXW8jbprxoI4tz313R6VFCTWS11V8dzCHNVtob7FxWAkdsuy0
aN0hBbFF3CDrt2bltHvOYv9VOyrYx7dnsk6+LKfNi0c9a+6RyOKrm3a7Oquc
ErxWzL96y4Wt1beZaqRcTQYRjikHg+qYvauJzb64WmpWXa0z4nkxa+Remj3m
Zy1NCl37ob2jK/s4wH3ajcF1xJZNtRvYp5LM1imO0ltVR71fdFrJCtyZ2G9f
iskAedHRJmVGFvsrmJdTnG15voLo9OlnW3X8s9n02Ycq+lUoiK5uijrefIAX
u7X++JmRjgoii4+9W28zrKPGvjqByUkKonLTw4M8tZTFaoXbxpo+VhLFRvXR
6BCQy96NlQtotEJJtHieyecqXR+Wa3zv0tfFSqIzES99Rq8pokorTzudZUqi
mXe9m/TYlkBtT4b3s2+lItqqPbxRv6g6Vqv8Q17TRlV0Y8Y2B2fXRFqRPrBj
UY6qyK6un9vjkc9pg86urs9yPKX59+/a6lTo+9DpA9OCqpbFNshndLJXUPXF
ed60yNBl7JsLTg3yK4Wa9pjtVhZM+8vmzt554w2/n1ZVpZC10F6aT+f8yDk7
V9eFUb+S52e+GEeTavSIkeNaenL/8lHj2JHDydL3Bn0zR95o3jOtQT7kg69X
Hxw3L5jW7Bl9Prp7GPcf55Mnha4Kc6TliZvE5oMCyMGyOnvOHEbj02YZdDsQ
QC/as9EaWh+Yda3/1BYLXeh7XWpYePIHllqrYFT6XPp7IvuTr0Z9/Fv+VnF8
l5KZ0t8r6XX1a/uycEt+fyCsvcky1T5iKt9Ut/bNChdyPts+tXyfmIbNTquY
9NmFzGxqw+fPcuH3C0ZmXtRZVfyCaVZUznNuFUfTDg09/XSnL9tyu7junJkL
LbEav2xnnPR+XIj6WUeNzgHs1Id5SlGT/ankutnFqGxzfj/Op7B2SVJOEOU5
7wst/RhGj6d2tVYTBVPa9GN9h7QJp+2rKvUexvo0yF98Sv6AXdqOn1SdS6oF
j2PJfe2WkGNOiXTDtdGWgN6/efve8plbXAf+5HhOuI/Z+ae50t8XGtfBZVGf
aI6fjD9zZa3HN3LwS9w4piKa9kwYbPI43oY6m7VrujEnjoZ9eGtdtLuUtTjb
VCs2N5lsEqwMs52qWe7d87kHjTKp4Ov42aXqwezH92vmERWZtKpw0eVV3SNp
9ipNx6StWVTx6fwtkWYkNXG3Dly7PYvyvSxDnr5Lo55DJmrrDsqmPqRUctui
jA0qPjxw98k8OthvlLtVVD7z1MmofLMqnzSTop1sbArYlM3KZdMGF9CZzJ2V
s5qmsT2ufVok7conZf+6eFejNNa14tCbtyyf1p6VM4gwCmfLdQsjOrXPp5OG
7q/vTYlkcZfcw7sNL6C6lrfumLWII+9Ot1OGm+VRkunF9XPzqpm+/OegJbOL
6Ezexcfr/+TT5S0XXurOKqaT0zbuH6YhL1bfHtPNP6SU2rsEzvGcXsau7Dw/
/bFJKZ0abz4iTTuVutQtd7FeXUrsxuMdagfSaGeI3PqqB2VkNnW87UkPRXEr
329pdzZWksLQl3fm6BUw9wXFiXtKKqjHapv1wf1DSNHEOCF2cBX56qiabszO
oIQrz9N+D6skJ6eru/ddKKVho2rkdaoryf72EZv9vqls/OTa43mONdTsVvjx
ndGpbLL5mcHtA2qoatOWwWKPUKK+rXz8Z9VQl6GB286tD6Mfu77X7B9US9s2
PljddFM5GRtt7Lp6XA25jDw1oLpSTnx6fqOh74/KiXbvMjg5d7W8uMPQrt7X
Q+RE3z7Kv6JhpUyU63BZfF5O1La59rmpPumsecv77k8ny4meDza333k+gmKM
au/NPiMn2nlxVqdo8wi6+qPDbf+7cqIv+9Kvnw6KotVbLUJU2yqIih6Pcy0Y
UkAVq5QaezZREN1Z+HSgzfYC6rZbvqzPHAXR5cFpqrZlNVRhsi29rEReVPQw
L6jRMCVx/Mf7P3rdUxT1vLnop36TWBpiZ+6ucOdv/NBIWUPtRSHV1C6If3lf
UZSrajfA5mU1G20c4WO6VFlkKj4Vuap7HtuzZZ3823HKIh+vgf0jM/LZNIV9
yz1aq4rurbFWe925gHXsd8pcb6mqaNQpnw6Olf7MYMyeg5FhKqKR/oN3XV5V
SjsqRf0rT6iK7vdJfFly6Qbz2G1z7sw8N5rTSf/nlvW32II8S8NZ091JJ3Cx
UmcjP3b5qVtRvH0YTQ7edle9dyabN+7LzA0LwmibxRhTsYIbXx84hUzd37nG
Tvr7O9M1vVYP9+Hriz3t1mz7WhDK7W3ZfJa22cadCsdbtd82xodaZ6g4pPXx
pjR9P51J0wLoz65xeSbDHNmQWwXd+s53oPg938ddrDNiDzzC75iXMFLtczGk
staeudoY5XZ56ko3trmqhXj+ZM+dvzVrNzmIKLXsm3zvn+zGxx/dA6MCqVE7
LZOnj7+xisydA2a18KHb364tX9fCnxp1Xz3zmVkQXX7wpOBq+jkmfG9t9GdH
pw6jflLrD145z7685uf3GQuPf/yR6kKNv2i/LfR2Jy3Nvm1PJNnR3fET3dr+
dCDrmi/Vwfu+0NvMsBPZC52oR2nPqeffSPM/VQS0fVy73ZLjU+8CZ/bp6MEa
pXxUF7UQ0+yldhoHXrmz1R5TUroUupF6Y4PKhV/cWMs2otqjVa40alhUh8KM
QPbx2/Q2C90YWVcry41eHcDSA1puftnKgcY9rTzoVyh9T20T7tsqYuJVbk8D
gja+9/sewccnatFTtxPWUdQpXaXdSvkEyr1qGvctWszvc58cEEWRn3L5fQTd
NvOPvdVp+B559myPNkHqaXRcr65gU1A6px/pM/WrrUpYg/ztuzw0yv32ZFPH
vVbfJ9k2vH8mv70y5WVpLuUp9XK+598wn3tm8NKRA22l+dwPyoVvrjTPotNr
gpf3Gi/N727UtrDDBnEix7MLwhZ5eIc2yOcep6V7b3vLHLI0+3Ai4W85++6H
L3+2zKM38Z7qT02l+dqdj6zKf3FUiZ+3Yn8u0+S1wygj6f21pu236PT+/Xf9
n3un+I57eYP7a1Yj7af4vC8k16NeDxfukr4n/t7etFBxqUqD/OpzXqclqd0v
psgl5xZZMul9tLw7WVpRBxreP/Mpfulr/ViaX13v1s1+HfcU09SE+Stbvcri
5VV+HftsdNiXnwerBa5RX/R33bnNjZn7/bXbWB/lrzOdK7+1nFqFP+oxY4N8
g/zot85MO75rjvS9kOKci4Vq28tpbt/Sk6dipPfPUs5P3V/6Jr/BfbMR03b1
0/5QTvcy/Cr1yxN4+SZLkteaWqQ3yIfevJuGVci4CtKza7pnsXwNE+Y7H7VX
a8qgv/6of6cf25TOSfOZ951q0cMoMYSvR7E/s+jk7I0bO1RTn0yPk57LVAS/
R1PLKpZ38fHNq6H78i6Ddn9tmK88uptb+vg1cqI/rQ9dWqdQLL1fff50YXXj
dL5ePZHp5LdrRThfryaY7r2VsaqMCe+HFbywOd3ugfT3YxQf9c9KypcTNVq6
W0H7svQ+WcfPvVp97lxNkdExg9tGyIkKzdRH/11jNMgn/sHrvEqHY/KikVfX
79jk2jB/+NZl+z+30JC+N4opud41w05BNOPykGbzDpXz/Tro09oT1VXPbRVE
69cVtzzyOYsJf0/m2rXt7MNjBf6eR8V7YXXP80qiYl3LRh5HlRr8fkxlvxEH
7kYoiZ6W1szp2kh63wz68a6d35licxVRO++mTYf1qOPn2QfHa49s+lB6v6zx
rYtdjkVI75cNf62SUK3hwVYUHa3WKw0kxfW7Jq1Z5MFunrz5Zn6HIPq2KevD
O9M8ttrs+/GJbWLI98th7bg6H27vjukdnKr1RppPbqmZy63c9v4styWrfjsh
lUa0+tnXNc+fNVdekjFKnEqLJyaciQkL4vtz28dFFLfyZ7RrYQu7AbtS6UtQ
2qzToYyqB7f08N6XSkuuZL27se07WW8sCDc/60a3Ne/YzR9gQ0qBvXqcGeVO
v718npivfcPXA9li+36P21nxfGpW67P8+rT6SqN+P+pXNC2CrLOWbY2e/pY9
rO26aGyjJEpQ7nXGYN9PKnvqWtnUJpGMLrs27zD6Ezuz/NWes8apdEilX6Sm
20e2tvH1ysIVqeSZuu15q9WRbH1t1FD9JOn9IL/bY55UrnWXrr8WOMT30XYm
lSUnCvYZfOfrL//GT6OdXD3ZtWsHG+dfSaSxxa0Oq7fyZtfaG6cbn0mivu08
X65sE8MmNXMLDc1Iob6TU9loXVXxnRQ5m2tWKiJ161FdV/+JYccvB98LbBlD
3Vlx8IDUYH7/+ZylyrykyWbs0aLYwx8fB1FAt2NyL+Kk+eZ+TLDQve/mQh0W
DCi/LA4ho1dNCiK7elDzd6Hjpy2NpB9NQvcMb+FOC7Yl3Wg+OYJsPO0tvl35
RLqXDny0vhpCEwOGtFup9YVanFhp8CE/lCy6mu7zOHGPrdGyydCY7kehdp89
ayvusDCnOSMU7/uQqFGBrc4gP74fbxmx7djBzRFsZL5J5ExLVxqqa71xx+Qg
FvmyMLfEKpByxW1U56Q95e/L6zSvpZtsDSTvzVsOnAoL4ft9N+e07vteW1Wk
1jVq0bxvgfSzhcet6RZJpGHgbqjkG0IzVyRaPAhOJRPLtusH9ndkY0bvEw+7
H0JvLON7rbYxZ+mLDKdFmYVQb1fRh/h1gSzjaN22rb3dqcrw4LlVc/34/j/2
gwf0VVbxzUulBysMR11LS+T7ySPED7Jn346hTwEvlil0T6TNGae+Xjawa5AP
2lRnvPcGzxxaqN+uVcidbL7/HW2+VlMlqWH+Z+2zsWfaUwl1GNOu2HuB9H7d
ht8959xemSP9Pa69Or+OWVbx+zs8X3TYoodHLJRFcs5vY6Ycl+ZzfthkgoVl
6Et+f4Lf12z83mSSSTK/32bhXqUyJ+g3/fG+Omn05zDWZ0aWdetJfnz/IeL2
NrWe4U6UcerRG38HMY//lnd1OOrr6szPW9yyz2yNmJPHvr/dM5IiUujCn3eL
kuJTmPvaw9cGTk0h/SHXzPqVFLPvizZ298jPppKzFYtOa5eyNmtCzQu+5ZK+
+YbgzeFJbEye98dZTXOoUuTf23SCoti2zcW+Pm0KaGpM0nljzRKmmt2z6PaZ
Yppxweli49IS9lBbO7jXvBJSmbn7TW+tRHberjN9O1dGB6ZecfUycma673+V
7jlWSUHPrWd03K8i/h562KY6u4aGGcobn9pQzJ7J7xDZLq6lw7Vj4jZ3UxR3
7+/VzvKqgigo8+StjscVxWvVfSxbpyiIrLw/zbywsI613TNS4/p8VdFeVvz5
6Dd/prsoaMGxa+H06Y6eeUpUAMsr9tc5rRFJ2x5cqdrn4cL1C/f7PPP1Bi5p
5EU/I5O6mN9+xPdXlORs171bFEFHk0/5WXWLJX2HN/IX4iJYxU77GbsvJlHF
4R93lMYZs0vJTRY2mium153NafKYK+zI02/h/Xq50KfvP9ZYab5h7bUz058/
EJPJmB/LjEdIf+9UuVF14Y/LHxrkP16Q0/qVho8z6c47pZI+82OD/Mcj0zp6
B4cFUI+YOzs6DHFqkA/5gcOGLd06xVOf+9+VSu7GNciPvKjVjP0G1yJpQ1v/
OexYNJ8vyGe5qbRPm1VeCfRFXNko73AQM8hUV7tmGE0mFcF9Bp0OZp1j1Bcc
qoiht9o1zyb++EZtD69Z9yM7mtr6FgaUGHrS0O9T+hqER1GPqLf3+7y1peMR
3VTOfYunxb1tn3xtVsTO0MXNO1ISaMGS5+NvVmayI6mnN82bl0gLtapmiw4k
sYu6ZW21EhKp6YPWfo4OSSx3xcARx4Yk0eztqdPXzi9k8x2r/uhtzaBTF/va
feybyTouU1G7uD2DvHbFP5ial8XkV7052bxrFuVt1fPXmxHP5hj7d206L52U
p/d/Ov+RvLjy1KxpA+bkUcx+3ZdflsiL11n8GHbV+w+5X5l93SFCSWxsanY+
8nwhDW7XJjurppBN3PB1wc89hdSq428jO8pkQ2ybDfnmW0jaFoUqgwdlMduA
9hRnUESVCZuf6Sp608EZaTUPRhbSgdR3uZZ34lnK2pYTml8roX4FOt4j1jkx
U0eP3PTYclqn2UTzcxdlceSjuKY7+lTT0Lpp4f0/17Ad7UuG7/SuptUR68RK
h2sZO6lxrv2Vv/HcoR/7rdWK2DkNx9kRK6rJNq9N50OuquIWhm8Cn1rVUXeH
Awstm/6NhxcvnzvEUF6k+Fp7uH14Gctd+Ov7IyYvOuRuP7aTUjkLPLy1/Eq8
vMhbr1M/f59MVj3e4vDlR/KiVa9eaBmfyWIXP6fZv22pIEr0umGYSrWs1YVV
QxMuqIiujQ9MrJ5uQdNav1eZXOJCjl4L9O+HPKX3hl6WfS650dmr/c71buXC
jkxSnN+rRRS1ffuFHm4MYXc1FSybugbz+7ibH80Od4wPpKx5tkGtq20b5FvO
iMz83WZYIOltHd7cO9mPr/dEj+MiJ296ztfzf7ZcX7cowZ7P191fYkZePuxH
GwfrB1xSSqBmp0Zn7zbyocfLNrayzYol56LH0Z8uWvP1Pu7fr08LqX5qG00f
Qg3av98hzceM+ytvGo+NXZMQTI46YasPH7ZnJi1arig2+kXn1xlOvLTbmmUN
X/LUK8Oefg1z6X95jzWr89ln7pBlTz3e7ki+1PoFW3MuItLu1y9qpW7STKvk
FSuobp/3+I8jNc557xjy3Yl5u7V2a7XViwbN9NXrTAH0eG2Xe1VHgmnphxK7
Kfcucvv+QnNzddl8G3pqqPkqz+wnv1+h0dnZr8fGKDI6ffmHygYXVjlhz88r
f+3HZbeAvuNX+bKxeYldx6r8pKCnkaMba0t/f7yJ/PlPftOt+P7C6TFpySGN
4vn6WLzRd+rHO5l0yr7n2pqnf6jl7A1nm59NJLvO7TeP3FZIR3rPTIzY4k9d
NlQZBI4oofUV/jeS3Xxpy/HQ5tZ1RdTSV+NoI80/9ODT0aIOzQoppuDSn8Ty
ZHru/GtXz7pi2tlMcXZzzWQqD15u+bN1MSk8Glw8SrOQ9l0+dkflZwmdGtYi
cuirYto0qS5Oy6mcvpe0cwnfmk0XR3w8aORZTT8/3Rj8IzSb/D+sKy8eX0Nj
NvuEbI7LJdpaMUG0uY7mDjb6+GVSJSVsiA/NO1TH45fqh3u0d8jJifzSmzqa
hFTT1M5tEpK0/86PTRaeAcF15GSz77tGW0VRwFy9uYcTiqjxkMHJXZKVRJqn
9o2/u7+Y3ro1aTfouLLoy557s8q6lNCKFbtjrw9V4e///J3Hr746N4XfL3vh
cF2l/5Nk0llj5DZ3i0ODfM+3l2+cz/alEJub+e55b8bj6TffX0boFd7n80P+
TseJazo+5fMhcZX4WG3Nd75fMkU3O9zR9oX0vV5o9gbttDhmEVgYtmeZN8n7
zbR52TeU3RBH6h8SO1PdkbYr2uX8Zl0sxvu16edPK4do3LH/+JvdzN0Yu8XZ
jzz/9EmWz/VmDtMcDwzpKM3vnLQ3XPnQUW96cNjAK6FtGPencad2q35ODGiQ
L93OrnrDs9GBNDXPu2TUzYgG+aAz1Qc46M/0p7lde1w5uiuFr2dw/6K75vDk
VvOTKGNnwpDyVTHsk7YqizkRTeP0fzyqexvKvh0z2JfZM4H0978wzFIPZ0nN
8uN2D08kOm/oIK8dzg7O6D52vU4ipW+4UtrjxnN6+XL1J/FkL2p9q4tV2tqX
tGph1eqYHB/qO6oDWd1+TVfvbVm2J9ufvkbb/9i17RWdTX91zL9MGi8E1h72
9AoKo+tpKumrBkt/b9y286l5Fxd7U+f3lrMLNwTQqh4rRi/r6kyXTFnp5CbB
NC+Yrug/cqJNhibVi44EkcrOllPfqISwzp+bVD384kXWNv3n3pws/b1qqyun
MrzaJlI3LcVhOkdT6PSA+DGfzyXS5GSNGaqVKaQ9O2h4o1UR/P4o+tPz2kHP
9/sT6fa3HlWvZnuzDfFmLhvXhpBp9833Ew1+8vm+Y/K6uSp6OUx7WeN3Qd0j
+X7MFtGuvYYbI8h+SY8pjXMzub61thdfCpNLYjdedRguKg2nHqvOZ/yem8jp
GmUpzi6WOWzI2vDLk1pLf39xS9vSuLg5SXSz3bzsIUOl+aQv7i/Z/WxCIhva
bmjzrM+ZdPeq7/T9lgn8PYVd+PdNCiN9SW+dYmeR9d843D79zzdbV67fX7w9
FT5+dmMl0xfsmJsQx/eX+sR9GHfKL5mO+vZboro5mO+v9e4zpunZq1853tll
0fiHxsHs0/v0qw7WWTRtqX/7Y9Yu/D3EoaeOQ99qSH+P2nZSx/ygib8p/vqs
9cf2Z5O4+mgZu+Ehfc9zP+bejB8epDaupCT6ez6tWzt6SZN78Zx+1GeBotO0
BEp3GzvEulMBaVlM3aermcf3kwr3Vaytep3HFmaHiApMyuj1u0j567uS+f7Q
6+En1jzyTGZfdVTGtlaqouujuyuWLEthpWu6G2fZVJHqhUfmrXVr+f1lC+eN
ZeGptdR/06ZTKkYKooHDWn77/CqCTd62qWxLdji9enZs/4QFX3m+tI7lhxyL
i35y/Wu32nHHyLVvWee89zYHhyXR1cDOE9/N/UUH4vfONjmURF7hbd2693Gg
x5OsIm7fSib9M+0eKp0PY0sKfjncjQilq0rDz3SRD+P38wN9/fJr5Xwo4cW+
Xcl6sZT9O+nz4tav2aTq80MMLBLI81uSVfttKWzVaS3HO5pBJN+8v5bLjBQW
tunc72zFIOpuoKVe3DKEBdguCTdPiZX+3lSPPkb7X8RREHX+NFA+lOfbWDHF
R6Gkkz1fb3WQO9K4t5897d210WjaPD/amjWqi7yJDfs56Ujk5BgxHSjfq6nv
8oW/96r5c7/9XtPv3L49vtY4ZUYXG2ZTtH75GJEf1U6v01vz3ZZVJNacutgj
gFpdm57YYqopz1/xvf/yuvjBD9ny0vMGBocC6fjUONGjuAcs2br/Tv2EABIt
c77ltvQ3z98xeFO3aXJHbrNbjTr2GnTIk3YEnFWqG+HC1+PjvPdvv2X/nePa
5YX7klWcqbCZvs7Y26602Nml0/ZHLmyQQY/qSe+jSN36ePzgJq7Mv3CnQaRP
DLk4vOpYudmT7X/0x7dXtpj6bG9nvFLsxVzyFz8YHupEL1PdJm9yDWPaT+4d
rBr2m5InD340faA/+5hx5ly7sX60SafnKJv0r9R3g+X33ZkutOKrm/xkvRC+
HvedMsmvaUQEfZjw6EyVayyln9/k0zvRgo//3tJpEzu38mMW7YYvdhzgy89f
rXZM2zgxzIcubst41f6hT4P80dbLWx7MyYoiPdctg2Jckhvkk17gf7OX5tBI
8ti1dI1xahlbG/tx6p2xqbQ3+ueGiNOBzH2XTvG8ynQqvnFWZXnxFzYuLt1J
zTCDTn4dkNvlhxUrJcfhd9Qy6ZWmUdv4zs60jL2sVNuXQR3d788ODHCmex9S
nn3pk0mbrB0DvMd9Y3/0GznuMM4hiyObN81Ut2Z3ek9ce+1dNpl76D6rfRJG
VcM2iOMC0in0p2LepZwCluCn9q7FlgKqCRka4/QinUV8UjR9bV5ARd2ObZ9+
I5LNc1u1MO5AAW03G3w+qJst349vY1c+u7uBGy172yR3kv4fMsmc+GzgQg+y
jhik5TI7n041tRsxWv3vetFt1rhTTgW08tH+qZ3O/I2nw0O611bn05LbUx/G
XI+lQMvB+atq/9AA0c/C5HaxfH/9hlPq1/Qt8ay4o7rxd90SCth8c9nqq7Fs
n9nZ59OHFtNis8eju4l/8fJa6yabbk53YGkGxb+OTCmhTs2qly4s+cW+7QvR
a9KrmG7eev27n28uWzB5ycmzg0rpgK/5lDct/rClurtdNDaV0o0Z6X4Hh4m5
vbtW23bB+aVO7IT76Yyan+VUtX1Iu40TxSy+VYXxlzlldMr7Tfqg4YF8/yXK
tB1p5QbSqvn9P+oNK6cjZ9TW1bwKJI8dtwaIbcrItzS1W79j6fQjuUTt68ty
WrTcpmKuaxJ7OmJw7WmzCto+ar7uAJ8kFvuxZPCKlxVkM7Ld4wlbQujb3mdt
HPdU0ahjds1HeaexqCmDs0y61tGcfulLeupcY8xI0yrTy4Vs4zoeSIm7ye2D
uHLmroXv41hhz8E9QvaGkPL4oVqKVtJ80PDHT9rlOa2xDyOTjaeuHOwZSn2n
Fm3QmhvJ4z/rsp4tvswPpxz5VTYZD0K4PS4Mm/e4qP9Dfl5W2kckP3/GZ44T
Xl3wPz/zLi1ebvXrXOkvkhs67Pn6jg9o5Ct1t5kzHamri8apzQnn2P7fYzKH
P/tBk7Z0a3PGwJwWt24yely4M23fYnql9vtDStz0UXdLhZjavtLaV3FC+nvR
z6bo1Hn9dOT4skErz/gWTixiwwz3Pys9yVXvyMGJ6mKmNOrxIWd5D1Kesazx
+NCfbPbHDalDsl1ooPFvNqTLV+ZksEI8y8ODkgoMNtrcsWJ6I4aczY9xpx1f
5Xr13/2T28u0j18HxmraM609GtFTxwcTW/Nw4Mke35jyzmp5fUNvaj7jhKZr
9zt8P7d85aaiMXShQf7pu7+DmokcnWnsplCvl23f8fvnwxvZq2///p2vp/D+
oMNh1XEPcuxJbcDAMUWN3pPRuQEa+j3taf5rj+evc97Tr7yJt/P0HKjFrDH9
3eKtaHjtrxlHXjqT1SelK5vGi/n9E3ufWf0PnHdlnyOXbM+K+83j32n3nzbe
eoyR15+0zNHaAazPyiaTrvyxp+O7m78teGlPcyeNzujQXpp/ekb5miWth7uQ
VdMNh9p6OjTIR7123OiMr1cYfZj5slB/vytLrFt/JeWWNN/0h++rI7TlxWTz
2arrUDtpPupZ+xq3uDXEo0H+6bW67zv49I2j1JXbIkzUo/h92+YlS58kF0bR
L4sVF6v7SPNRr/NTPunTK4xW/li29u5bH27fHRcuyx+xJJ0ZD7xwI61pPK2e
3HruJCtpfmrczz6m41iht1mar3pQTefrkypjKOVz25ysCWk8vtuQYnX8URMn
dmTCoE2uOuH8/K70dKfNm1amUeeh5WXRGuU8n+Cl0ZHJqjNK2dXkRoe0vJK5
/3icu6Pb75EplDe5+42dFflslOXLlEWP0/j7im/a+65oKWZQbmu13VvbS/NX
+3dxPX9OMZ11a3Pok/yyNM6/U5rT6wNR0vzVd1bHTUluk0qqvcu82qmnSfMR
DzY706P/F76efjjGMqLPxBRatr39L88xGeQzSKHIyz+FHjbuFbQiL4NcX37s
NfNZEYvK2jLhwQBp/uohtsmOIQHZpBFm6LpvbjYThTxbr308i950sn+w2ySP
tdhpHtL57/p8ZJ8DxWmXQxnr2HpzU/1c2mczaHngkDD2O1vJ79SQPzRrrWN2
q9vSfNPq7gUzJ8z5zlzGFIw/EfSHgrc6j/310Yat+bR++y+FfEo6+kX+151o
Wux3rFMvBenvKXp3KptSviuLHPyahjx3iOL3m1tsnilq61jIz4vRvy0Mun6/
bVDA+8/Mwsu639xCun72ruOfa9FsUK1bTtPAQsod4JBuvjKGabec+OXEvCL6
tdyz/LDdD2YWOaLk7q1CCu1wr9f887+Y4S7Vds3OFtHQE1Vn5mX/oRWF6oeW
GRWS0ZS2mr41ebT4esqJFgOLqOVd54W5Z+P5fWPFwNc62aMcmfNajzk7bEso
5dTMJyN7iVn3cRF5rtWlNKzg/Wm12QFk6tx5unt0Cc083HWxil8A9exo3jvK
qpRURc9NT/yNK0qPazatmFNKNp2/LbNY6cTPi9vuXGmoXhdE61dm6iTcqqC7
2Xdq+7YIpuQxG5o9/VRBV2ouWJ8Z5sHtXazRO++1h734fozq1bmNurxKYbvV
o74ZG0VTN7WhE08c8Of6tIkueNkVBnB9Wrht8uegINYgv3VvzR61D2+k0nrj
NZe/RNlSr1WGOpmdPWmLrfH+/qJnPD/P+k5Wfs+LnzHjDLthS00jyVV/sZ/u
h2fMMidaVL4skkxXqTf+sMaKXmueKi3VD6edXzs9u7niLV+/udtsaK3Z6gd1
0XyZ9a0kgbQKqvrV1Xzk/I7+dX/elLzP7IVbrycaOWkUeqdtszsf3zO5VIUy
H/dkcrPZpFreWZrfGvb4o1HJpW4XvejlpsnD3BRiWFjTzx3bvQki7xYtUk+f
lea7Rj6K9W3uWL3Ul+a/Xn7vcMLTy4HUb6DZksVq0by/nZMu9PV85MX5f6z6
+UFhG082b7tIV1Mz8e/6/4xx9xAf1iN6QuWjF8nklX7w6pPQGC5P6zbnXsvv
jmOeVtavTj9NI/3Nui2ffYpl+V5bv3t1SqPk2PuhPZyj2I53TRNNMpIp6+HO
1usNpL+nO/fHq8GhdqriwUeMgx8pqIo0h80f9OqtqnjUuP2nM4tURAs7D7+4
dM1P0jZUPn3PypvK3tkZLtzzk1I+Zms3d/Im/ZjBcllB7/h+v4FS0tD8th/I
QEUtdGdhEBV7lgxJCHlPb9rc/DTQ6u/66cCD7Sp93tKoL2Vje4cHUHWXiNgX
/m+pqe6Jnjp/1yMpLb60777fjFXrlN22Ug2mgC0nxlitdqEgm/O2+itCaKr/
npsTT7rzeGTqlffWbf+4UsiJnqut1cKpfIjaz9M/PvP1i/6s4Jq1n79Qb73V
ynt2hNHQrRt3DM69x0wvWm/XdvanMkMH+Qe37vL1lHzwAMPWf1TFcpHxL2eN
URUVtFBMNVN9zf3FYZ+fs/XvB/Hxs1HwVm4dEsz6vxq1Mv1vfNBi2IK5GxYG
s2XRY4bP+RVEDhqu2+YUP6WwiYpLHuZJfy/1x2PjRUHPPWj79fTlW7tJ82lj
//dJsVankc9d6eaGRi/z2knzab/qblj4tVaa33ttxrbsJ4+D6KDYV0HvcjId
+uS7ouWuULrUuudZI8M0Ov3aYe67XQGU1G9p79eTE0njzXT5tGMB9KEivO3Y
RYlU+yyq/dwFjPvLittT9YcdF7Py5RUxew+EkfoUh+dpbcTM5P6v+xuLQ2lP
s6JfN8zM2aRjh1cGrw0hr6SM/vO+BrHN+keHlGR5UOyt/pn514MF+eGD2bcl
cZtCL3ny+EPXLL/c95k7BXYo6Ph6URDPH/Zr61ET2wXJ/P7T0i0b004XJlHa
460xttZpdMcy+tuJd0nsmMhg7rVbAXS+i8HRGZ6eTDUiY+pOZU8yFj/drhAr
za+N/DitTRorjGkmzY9ZNrhJdad57rQhrOCQ9hBP3v4NOecm5RoefLxRvtWJ
vkHeGxLoygnd5sU9q9imzup7R7ST5tdesLFS7rxFOh3R+jr0zNtippb/+Obg
FUk0pnjyDP3t/y+/tmPiIX0fOfHlT/ZDX0TmUt7QrRM87KT5spFPYJ7HrjH3
raS/73PI4/bi8VmZNC7Ccfxak0K+H/XYfsN4o0vS3998fuTqjJxZpQ3yaTc1
m+4Z3DafHuhsfZw4WJpf22fhkT+PXkjzayM+OXT8jVh9izTf9ris6o7FA/9+
H6p572g7af7t2efOLoqoSObfY/175mvXB56tc0ir55JJp5fE8Pc9dUPUK3PN
qphRty4fz20rpBaqk0yWT6/i/hn9+dYg9UVLuwJqscV+cVsDOXGEYfXejIIS
3j83op8YH71YQsf3bu7wrEUxmxPTrPsogyI6QrYVyx5I82Nfyoucv3xkKXv0
4vLJmkslZLS+8WvNvqXc/x4w7/zKfpwPf18mnqnU6ZlDEn1LKp6/7GsRP+8/
7bZNM3JsEWUuvKG9v700//WRve+XqXgkMK3A6AO3skrps7jw6/C1Cfz9ep7y
+ztdLVL4fSv52rcuX086s8Oz6/bP2V/Jz8/36JS5Z/WppMhmT8ZY5Tgx2fe8
KmLvy42cT7YoprH9Etprza3i+28Oqk2fPL1axVK/rF900a6S8p/blTuPyeTv
Y+0snhtOeptJzm0cY1bmV5L13Ot9y/pmUbFpTubQU1X06fq72yNCf/P7V5ML
Hpw9reTKgtYYzx9WXkOnypZFyyWU8/sFLsbdkq8urKBlnw7sFi2vpTVrldV9
x5fy/AX+izQinSeXsp1/1rybceMvbn3ofUBfd06f4TdRY+Axd6Z7e4dLl19y
op4eSccfHfPk96HGX5v93CnNkz183dEi/piCKFZvut61xtF8/7CL9/XdnedE
U9/3pw0br1EQPTLMb1eTG03HmvbSfxCsIBrV3mDd1S+VPD/zjajNFeZNqtiY
/qk183ooiSzfvRjl+LaKjf06Q2R8X0n0VLHjczmNXF7e/pSt67y7uezoye8H
pw1UEq1ft10vycub05dEdbvdd6EPO5t3af6BcX/pvSerjDSM5fmalVXnk5Fq
HEVNHq/TfYySaI3noJlvB8TRivstes9foiRKmp7oODyrkJc/39NK6/3UIira
9yvNaZKS6EJvO53rQ1V4fjHjVtUO+5aqiJOGaJ1Vf6Ms0l7fPWf/9Tyez+Rr
XUZ4o4A8NuVOswC178oidaOz2y7p5LOwM/OLYmaoiD6re/UNVffj5Rccien3
0NyP/QiZlbo5VVk01vm1vpqjHytcl6+hVaYselt0SN2sLJ7fD3FSDXngMyyB
dvgMW7A3UFlkPj7cfNaYAH6frL1f89NBugGswN53z6pjqqK6m3/q8s0CWEzy
29FbbFRFr0Im67iOTuT5JJuqXTKonZdIJzRGGB5YpCqaTQkhQ499JY+mwQO8
/0TQlZDfpeZ7rKnp6iYHbnaLorYf8s9WNU9kYWfHt4ud4Efns2Z+tbyewP11
ypMQpxMfo5n3hGClmfs9ePw1elZY6IQ0T/5eJHyIne7PsBiK22Qz/pWFF3/v
eLb1UrVtF9NZ8rFpsyrjpO9/h9mauC+7HULFSbMeK7T7ws7Pf9N2S3M3uhDt
dLrj/d/0ZEHKxxEvQmliVWfxcJEJ9zfhZXtuv41/yfd7j865/6vLy5dsunlG
z5Nh0vzK3dotenz4ugu1P7H6155rX/l6Xbuv6uIvYYE8fllprPvl5JIgKuve
99HPv/53TVpPtYLBIfQyu0VG2ehU6td0wJFpJY/ZU4u35Wmdwyh1nsaCfjWP
2aO2E1cWDw6j2+qnPzlMl/6+VMoga5MjfRNokOn532xVMm0fqd3r+dmG+ZJf
L/hc2m9sCmXGZFp5xkp/737lNZXL907H0uB9lz0WfErk9n7q6YLDB5wDSOx8
KXi7lvT3Ffc3TdFbcCSZdVry6eKQuYG0SanErlnLtAa/Z9f29MLlj9dm0ufR
1tov1aT5kfNCH26KHJ7G8bOrz2zWTYjguIWyeLf7XlWx9w/vyh9BxZSz+mf1
lemq4s57Wp6/9bGYTC/obZl4Lb/B78d9mPjpop1xEfXVqlsZ1iiN7+e1Mqx4
GR6hyPM3JaxO7RdgrST2aLKq+2GzKloSaJJnfEBJ/D5o0sgb06rouNzHJadH
V7KC9uVTO+6uoM7umX17HK9kIb+Nh+X8XV99m93jyTqvAm6v+zdZs3GpXT5L
rrOpiEkqJ3f1Hk8aXS9ki19WhRT8rb/Lf5oysZDZfl+/XLdPFQ3wdO+08mVw
g9+Xu3vTqLbxoEp6tNx5nXXXUk4/3mrS3Uc+xTSkuPTg0z/ldOdQ6SCreyUU
3lT82iSugvvz92+bH5j2tIbSR1tYNhonzXd8eWPmoqKgVO4P1tg2/vHczYUt
EI3akTWumprOi+2479Vvdj19TCsz0xoa0NJ5ZGeNMO4fhl4JNfebGkraFw6v
Xf2xmu5ZZcw+3C+cptnMs2rUq442Ki76mX6kjLS7TKgY0LOanKu9Zg1vIc/z
HVv/7hMWfV5ePOD9XT3dGjnR62khR2P1S9hux4la9tl19HtW99/nZmRwf3L/
0rQ3bFc6O9fHeH/3nDr6maHseKkwg6VM3NK8WkFeNHxk5OQFfhlsYGHNhqU5
cqKL19s8iCM3Ni6kYsgs2zrSOzm1QCvcjUWZd+plvVFONFHjSG0jkwh+fy62
2/mL5ifDqc8Ac9Gw93U0z3LmqiKjPE5Xeim/YG1dLqncijd0MKyjpyExy+93
yqM+Cy53vrxCTrQyUWfFpb9xU/tq8V2Lv/LEXXP7ENs+n67rdnI6kCYnGsi+
atp88WDnPnzpaWQmL7od1OHz1mae7IvnsaztxfIi1rZlN9uUSNK92b6H0l55
kUNNfNB+nQLuD7UrvE3XeOZT0rb7KSXP5UUtVeX6fgyvYN3r1o3WmqgoGq33
PO71lEoW0G+z25PLiqL+LS0+aTTKYQOsI7dFdlUURe+dmbHbL4dFm4WOm/1G
USTuYLblvLo366uzsceQVYqiAbVDPz/W9mZvO835WWqsKLp7/2QHv3cxdMuC
Zf6YpSiqcjui8XpGIa0d0sr8xzBF0RqDr/syTJXFKXWxnUyLlES3b31Leeml
LD57pf3gZT2VRV2e5sslZlZzf7S1uO+J0SdqWOyL71+fFiiLLOy9xx85WMOG
jvaIa5KjLAruv3TZ0YA/7JhnP61KZWWRqX+foKBzvmzDvE8HPnZQFq2stTNq
YeTL5uwfaLNdXVk0su/KdvKz4umD7TX9n62URVrfOxbLbY+n2LXbutr9bT/n
9Q2nLjX53H/1Pr1GJ2RHAauhJzM9nFRFW3yGeNy29meHE+9M2/JZRXTg0E3d
k44J1FvpfZ+6WyqiHV9c3vu2T6R5HdX3HKlTEW1JGft+TKtS7t/yWmWqvb1c
QsWXG98xfKIi6vnJovfqXyWk5KF+yT5URTSn85MYy6elpHZrpZzxb1XRg7Co
5kkdbvP1x7ivGVUnTW+xDlUX0uVipPmTEw6fbun/U5o/2S28zvVEWChNmfQ9
x1dOmk/53BUSh6eksjGTfB4nHQgmz4oP49S0XPj5OvIrvz74cFfaWHtq3Vrv
neH+ArZHt1RxcEochSskpDa5WsjXPzy/bM08gwG18Xw90dY66cqWQ7HUcXWT
eRFvGuZbDuxjEzywNIK8g2OuPmjeMP9yia+p57WkDBoeP3RhUYQ0H/P4GJOF
tlTK71tgv9Ewu0LJ4HISDchvnbJoQy0rnK2asL40i+d7+uW45+jBv3Htr+u7
jZRnlzK1Kt0DdX/XG4/PrbZ0Kszh+4tn5KYP3ts/j9WsntWiYNwfGhY+QWnK
wRSm63n69/UDf2iyV8evOv9X1r3HQ5X+cQBvZjArobIqirVbo5tKVsUuvrMq
oURtyHaRbEnKIqOLdPGLSiUhSZIYt5JL2dw9x7CkhGFK47KYGbcxMYxrxsyv
1+v36pzX6+fvc/46r/Oc83ye5/u8v5kCtA5W6l6pHIRpL4X8/Pd5eL4JDyxs
XjAyieallhSOJIqhzSz5pzVKX2b5y6QHe8ikxCGIDzjCogVL8TyiGRvPlzJb
ZvXDCxH42PGHhsG2uPNh5F+F+HV157NOC5wGce9gZ4Hn94sDlLD+TS2bGkcl
ULSk+WrCVhkqu8oWrjYg/OUzmiodrk8If1keVfI+7cI4BNp3WteXzPaYi8wZ
fVlmo/BWc2ALlTKB55cmG/fkFS1C1NRdK+6TScD5gxOpopzwmMMZcRduzS/D
89S5BI5IIqrHvQTmNqMPuQzBLI/56q/21yO2jMOJkKhFQU6TyL6Nw9CKJ/zl
9UV5x71JE8DrUVbckPR1vK4P2h5dMQkJlV5FzksJbzm3ekpm6NWIn3f5U6B3
93l2L0SECS4uEUxC52OhHeU44SnPcWZorMgZxe8Ps7rrJNNUxH3F1YtU9qTz
R/C8diY5h3GvVoAEjBCfn92kUD0z//DRRd2ogjoR9YElhbaGnLc7llIxy9Lr
vbV1MkgYoXSxIwkv+X/zJirWKjbWX6JK+MlCh9To7Voy0OEzPd5KCE85x2Hz
XRfhZ/y8ywMXExPzfsJL/ubnDGWq8eJVSHSMb52bca5/lp/ca33HQrSMRGd8
oA/aMSeRRrZR2bH9ZPqLIXtkXCdEsQcO0PbZkuns5XdN+AUKGK00KZ6nRXjH
l4/6nB9uoNC5qy5a2LYpYTtDX//ONVDCfWM/5u3KRzGEbxxzI9RR6WueOOI4
meDziPCOOwdHU4YVZLiXUDBvrkHttjHcS8gxTte/WVCDevwmlp9f1QQnq+5U
T9qL0Rq1rr8weRs0FN2om3urATVb9LhWxfZAtEp1YfidUniedkWnd4QPG+S5
Mv/YRGQelWaEypvhZPjkRa28RMRQz/Br5TZDUwjlWOSGdNwnzivWMVSwSUe/
WKutdTjeBcyBvdZVKVyivkIk/vTlRhNy1tFTpewpB5vMrBq0shHfn/q2nnXR
SK/djFIOiYyBLHYWD1/fibNin9ga2ILO+h04LnnNh+ujDhj1Xgv+PfN8ko+E
u96AbOwJ0G5yIbmraiDAMQvCwp4pfPLhgL6GyyuvE1F4vUHEtQL/4pEohKYf
uHpcrgV3nRu761pTEcv0XESCbSeUdZP+OaWeiqZ8x0UBKR0QfD1NgU9nz/KG
ZZ0O04dPdoEyc8VM7YF6vL76X+z+PmgpRUW6L4xVnTlwxo/n6qbcgCpvP93R
50r4wzEGT//QbawAp4CSjQoZ9bh36/DE1aJzIRt/ft+8rcc3Pbxsiv7BvRr1
0sUzFVd4EPrZfN/axA6i31+EPnnASgT+GTXUg4Ni3Ou5ZKW3zZ09DDt3fHf0
5Jholle8jtf7p8pSMQzrxOa5FkqAdo580C2J8Ij3l5EOZj2bhFs0Xd/7pNk+
8d44ctah0XHwr0WUlEQRWFDeNK9ZRHjEfZzwe7+ayuFKjL7U90fCJ9472DhD
uzwKQZzgaeObivStNWqtUR2EPzxF+0W79W4y7gvbGWy/Fn+KiTxfmcc/XNwO
8tPaYektyShzXsG4JKgNrFd3s6JZSciuYjiLKmwBOfbH8uGNyShfWM4J398K
2pa7N5d68v7PF+pCcT8wWZe+1ME1wZ6WDAYX94h/OtQjOFJKeMRR81nP+Kf/
BfLUK0Ulcx40kPJ1sL25+P92zNaElUgqh7Pq2SYx4h7IKTBJSTjGwn0mI//N
Tl++joNUuekyiVUvFKZbbJXuEaNduS4RmRlDcOWQyYJP0I3WRq6j6DCHQPVl
7zPS7T4wftdnmXbsM1QXLxP/4EXGaLlJ42YHxdAfpHHqcpoipnlCesTcTAIR
vnNUrFuHoWp96aUtHmPA4TlGe+tSML+6VdL4oCkw7n8fvd53Aty1P45YLJWC
7zvHU91VilislHbUUHkGMBumpYbfHKzQzOe+qFcOQ0E1bg0fJOhOw96EpTdn
QCdfnKxfyIUOUeJuh30kOsdAfYe7wTRsenNAcaHNHHpgXfvTwPtk7PBQiKlI
iUxfnqomoqdRsE//cdl+aD6FHlRupz+jOAK7HNj5h8RkOk2P9FCDO41ylghT
OEUK9GC2t3T8hBhpfXmlX+6uRNd+SQt1VJWjhc/VWJ46VHr79vYRbkYnUvkx
KDD954/gZhTWUpRJ9CMtFEQJ295RsWL5y5IlmlQ6o3XsfdSLN3h9mLPtaECN
sgLGX5/Wk/1uGErNVmVbvyVhfhnxDkX5E7D5UeK13x9L0ccyQyqZNQ2n7x1e
+xmToYBbsiOtnBlwZzd/rzx3Ajnb28fSVpLobj0LQ62+m4GNg5ZJth4kuiws
OCiEFYlM3gvydMvfQu2YEbn/UyTa39CtVUZ+B27nf1Ocq9CMr/cGvD6T721O
9NN9Usx+bSYZRyuZWEnVw0GIC8/+W5PCAw+HlxouMd1gqOsIjGcC/H1SVd/5
9IJnL74/Wx9ZeX/wYS9MXHow1WQjAqbHeVNvbg+ciXtgUe0+AP8FM9F0WA==

   "], {{{}, 
     {RGBColor[0.33397672886240387`, 0.1279285534583946, 0.5864250111695534], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlktsVVUUhvd9nXt7bkJbsMrMtreNCkrbEQPaXietDPowNGDAEtA40IFg
KtWhj4gjHwPjQGcaJurMKcYwMHg7UqaViWhKelso2IqSaPH/un6CyV05++yz
1+tf/1r79r149siZYkrpD0lJsirhvVtypJDSnOSG1k/r451ySpf0Mauk9GOW
0rUUz8teP6KzQ5KyZLwQ+wN6TtRT2ldL6aL0JrXer/UiTjpSuqf186XQ7Zfo
l2bsd1qyV9/HpfOtdJf1flMxtPQcziKO3/Q+pveG41zFr2zP63mhFHob2h+R
9En6JcOSXr+PVFM6kKe0VAz7q7K7pOem5HQh9FIWOk3JuOSAZEiyT3r3JIuK
4TvFeUa2moWIAf8NnflFex/r27TWg8blptYva/+DPDBtZ4Ejfnm2vP5U+Pyg
czeUx3nZuAue0j2oZ015vaf938uBBThQI+pzzjVi/7jsrEvnXDnimdX7qLEi
v61C5LUgP4c7AjPiLVQjZnJDF79PKd4n89Ahl1sp6v6rznapRgvGDSyx/aHs
bGdhn7iWFFOnebFqbsy4znpNh/zOes5r4txbiJw6vTfr/VergXvTObF/yGcv
+Tx1etT1xg+c7qGkXmMHLFvm07Escj6pb3Xh8UY11tSMeB+2bsPrXYXAHhzQ
PZoFXnD9etkxFILfcBtuts0P/OKTGvUK18/yWMPR3ZI9jnktKLhTa3zdToE9
vvF7th766K6UY1+w7NR73vbABBw3U/QeXGGvYT8P2d6K7d/Jg3PUnVzHjMGo
1+AGv4gJv1d1drYauqcqwTlwptbjjrPtGcGMwc91++q0X2L+piNwB3Pi7XQu
zIgTpQf4s94wTkXPruPy/34eM+LZasSEfTAD52uudYd7hzpsFaPHl3X+BZ1/
xbyG39UUsQ86fjjbdm+2zeHL7t221xOSUhZzYs3163EM4Es8C6rXWC364U05
KdQjjlHzt+p6SCXpyM65i+6dK6XAAhzWS1HLTdewZJ0+z2+wGXNvUDvyrplv
L1XCJxjQG13WGfFcYN7drzfx0NNbnoktzx9w6NazXozex96mZ2bFc4c81s0J
uPSMcj0s+d5zmf0ecwx/5FXIog5gyFyZzcM+9blajW/nlexJ3wnwiTsHHryj
s+/mwa11x9FjP6cdA7jhH+zWfIY4mW1XqpEndR9wTGvOg1rsz2PuMyOKxrjb
3F41jiXXY7dnNbGC1b/S+ycP7Cvu6x7r93lGle3rvn6/v5WzwGDKPno915hh
mXMk9o9qET/9kXlGcY45yL3FbGJGNWxj+H/fwHvMM+r1cnBjl/uBHkyqxU/V
qPG860x82GP20bN95hB2uQePeh+8jnk23hUGf+ZRD3plyn6Jd8OYDBp7uMe5
U+bL3zr/RB7xUd+G8YIHLddsj/eJralZ8lwt7oOvtf5Ksi1sfq5GPuQy6b6F
V2/J9mv1mGtwaMUzPLmnh9wfTee46PuWHgTzC55Lc75f6H/4XLR91il7oM96
yM+CfcxXos9bviMOeuYUfaZpPoDdtOvGGgzhCP045bpQA7BoeXbAh7VS9AAx
M4/L7iF4ii9mI3hM2n7J+LCm7m3X/u088AKrLvMfLrc8E5m5A64Lfvkfg++m
+5eakdfjqsljHeEXjCaMwyd5/AdCj1m77PqSe8X98KXOfJHHHGIeMPs5d1t7
t/LAkv8FM56t23ncMXASG2XnBSfgPXjBzb/Mz4b7i/uu3/d4230E/5gnn+eR
A/FnnhcV41Y2v/8D+0I9vg==
         "],
         VertexColors->None], 
        PolygonBox[{{2694, 2693, 456, 1262}, {2713, 2715, 1289, 345}, {1840, 
         1784, 1139, 710}, {2700, 2367, 704, 1270}, {2878, 2808, 239, 1458}, {
         2721, 1794, 523, 1297}, {2802, 1881, 1262, 1373}, {1910, 2379, 489, 
         349}, {2473, 1840, 710, 1022}, {2012, 2959, 1606, 361}, {2815, 2814, 
         349, 1141}, {2807, 2806, 36, 1376}, {2812, 1911, 756, 1380}, {1882, 
         2802, 1373, 901}, {2091, 2269, 832, 629}, {2135, 2930, 1481, 704}, {
         2190, 2189, 63, 500}, {2452, 1987, 1004, 1003}, {2939, 2010, 361, 
         1538}, {2109, 2885, 1467, 1481}, {2959, 2011, 77, 1606}, {2817, 2000,
          499, 756}, {2888, 2886, 629, 1470}, {2600, 2813, 1380, 490}, {2928, 
         2927, 345, 1252}, {2302, 1906, 932, 858}, {2690, 1872, 241, 1255}, {
         1793, 2940, 1541, 77}, {2940, 2017, 370, 1541}, {2090, 2689, 1255, 
         1467}, {1988, 2452, 1003, 1005}, {2606, 2605, 500, 713}, {2639, 2722,
          1297, 370}, {1790, 2939, 1538, 63}, {2601, 2600, 490, 1139}, {1902, 
         2707, 1005, 319}, {2800, 1962, 977, 1372}, {1962, 2304, 859, 977}, {
         2343, 1882, 901, 900}, {2376, 2072, 1458, 932}, {1785, 2603, 1141, 
         36}, {2715, 2714, 900, 1289}, {2693, 2801, 1372, 456}, {1987, 2887, 
         1470, 1004}, {2808, 2809, 1376, 239}, {2303, 2302, 858, 859}, {2269, 
         1896, 1270, 832}, {1999, 1841, 713, 499}, {2379, 2474, 1022, 489}, {
         1871, 2688, 1252, 241}},
         VertexColors->None]}]}, 
     {RGBColor[0.41509818658728764`, 0.2689768603753158, 0.7004510335087669], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l0tsVVUUhs99nnvP0eAr0YIOSEQERAHjoIlUHIioiRgHvMQiYAFLAloQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF1olmUYx+/n2bv3fp/nVZIStFmQB2ptU1NPLNj0pDJPjA4yTbRNLBX8
YKKiHrgCh1ZrUBTMD9AoXfbhoYJFER2Vps4zP4ptzK9NcOHUV9PX359/B3+4
rvv6vK+vya0b3lyfhhDWgAJYXA7hbfBXbQhTkxDOxRAa8xC2IVzD255SCC/C
74Cfg/4k6DowAL2St2XIj2Uh1EAvx34Iehi8BN9GoJ3otoNB+JPwBemCFTUh
vAs6kC0hZsT2pnzgbwW4A98KvkH3azCFeBX0l5LrEnAwdc716L4C/xn8JvAR
vg4rR2STQA/0EbA9+O1jdFP8LcNXfTGEf9Av8/YA2xQ04O9V+J/RnUb8w+ge
yRz7X3w0IpsOvkTehfx5ZHvxH+HfQ+cQ9Fegh7+8g/4N5NfBhOCafAH9OfIq
dD/2i4k3j7d92F7HxwHoJtANPwr2Qf9KjpOhb4MGYteD3cE5PIOvZ3P3QjWZ
Bz0e+Q5kY+Gb8N9Wtm/VaC6+akAn+mfgW5BfgK+Sy2n4D7H/IHctr6HTjm0l
+q/jiu7dH9HDox6+DF0Cdej3gm+RHwU9yGaj9h30I/ytIn6Vt+Pwvao59jlY
hGwcMbbWumafljyDmr17+DsP3a16Fz0TM9Cfxdt8fG9H//vMM6jZU04nMs+Q
ZkcxArZn0V+Nv/fBKegf0EkKntkq/urBUOIcy5lzVq5rQaLcsGlJ7KMDegg8
TW5VcBk60/5AJ6CL2BdVH+j7YJdmGf8t2I7A/wS/DvmhGvdUvVXPR//nf8y8
c9q1lPwuQb8R3Ytm5Jeie6ZeKYZqMwv/ldQ12lj2zmnXrhLziegeqnfagWb8
by551zVje+H3Z56tPt76kPWD31Lv+KLoHBRbO3wL3yO5d/UX9P+DfgjaCq6R
avtndO6qsW7J9Ny90k05E90T9UI9zKH/jq6d/qBeNIAtBffkdu4cldtybO7C
j4IriWt6hdwGS741yvmpsnuk3mgHpFsBrbW2WYCvNuRvQa9E5xNkq6N3XTu4
EPnrmXddN6KK75D5r7J5Ev8D6I9JfTO2RM+MZkUzvwD5a+By4huyPrrn6q12
vpt4z4G1Bd+MZuim3LdHMzQz945oN3RzH9G3zpJ3QTvajO+JJeeuP/0efVN0
SxRzWuabpFukm1opegY1e6qpdq0Pmzz1zt2I3mHtrmZ6OPqG6nZqp5XrhrJn
STm/AH+v6N1Wz5Pomdesy+f83DdIt0c3pgNZbeZbrxveH32DdHtUwztF32Td
Yt3Ix3WX2jc=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121713, 0.41002516729223704`, 0.8144770558479805], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1uMVtUVx8/M+b7v3Ihjq63VAVOrPrTKDFitdoyKDMolwUAhHbnIJAXr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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsllUQhr//+/6/51uMBXdtMahw4VZaBVSQWhEokmhADLQYIEEFUYJI
1bi09UbBBSPGBURDFASEGLV4YzTcIIkJSCRgJBFXdkrxwi4oauLz5uVikpkz
c+acM/POe66Y9+g9i+Moil5CysjLaRS9gpwuRdFI7A70thBFM7G3IXERRTfk
rBP8cCWKvsyIw+7EXoTdSOwgpIGk+5GuzDmVq0LMTewfjL2F2M3IedjPE/8E
uZ/BHoWesfYY+lT2HMQejP009hzsVvZ+hQxNomgH+d/Ev43z6/CPQL7HTojf
FfsNa4i9BnsVvqrEe5cQczR2jg70tew/B3819/sV+1bs5ehtyolej/QT30++
ofh/xG7Gdzdrl2C/QP6aqih6h/vt4L1fI9PQt5K/hthLkQ+IfYCc+/HdiWzA
dzX2Mu7zIfYZ7D+J+QR9FzlPlc6eif46+aeQfzlr07GHEfMc8f2cMVb1QmqJ
3YfkxLZjLyJ2KXdcRf7VSD2+duJ78HUSU5BvGTEfk2snaz3o3xBzC74xhXvT
xdrb7B2OvRI70Z3Rr0dWqzbEf8H+vcG12Yl9LvHN2D+h34X8jJ4Sv6Tinj6L
v461BeTqjt37onCthYEqajUIuY/alLDfIP925Su5Z13os1L3/mJybMxcU9Xy
H+zfdD72evQm9jTmxpSw9CIxC4S11LnWEHMhZ8/DfpLYdu7wKnZL8NmjqNEW
9k/NXfshFfc6EP9+yT1vRE/x30vuGch6zt6U+S7HiBnAf1nu3k9LXBthSNhR
jQaIXUHOkeQaT8xo9OrUtcuJn4Teytoezp6O3YJ9ELkDfSYyjNzDkUfKrlEz
viZyvodvPmtX4bsydy0Uc1o4IqaX/HOIGcBeSvwe9NlITmyWG1t6k7A7BHmw
bAwfQF+cGxuaAXHDCfJNTswRmtVDwbOsmVXvfwnGojBwKhizwmpNbOxuzl1b
YVhY7wvGqjB/bWHMCWua4TPBHCNuEaYvx/dHcK6IO5R4S5z5LbpPdTCGhd06
Yj7DtzuYi8rIdeyfj/+H2Jiu11mFZ7leNr6+zL3Zjn07dz0cjJXXWEvxrw3u
1YTYtTyBjCm7phMz90S9WIf9bzBniavEkZqtTeSsrXjGNJup5jfyjG7IjClh
SRxRmxsTwoJ68h96V+pZaNWbC2Nc2P6uYmzfj1THxngf+3vVY/L3EnNjbg4U
94nDF6IfIn5CYgyN1vwgf5XMqd34V3LG5CrfcVLmN+ptmrkj+C8q3Aud+RC5
FqaujWbm5sI1VS31B2xl7+eZezEX/yz8M5B1sTFfJt/43LUWp4qrO4O5VZyt
v2huau7Rn6Re/h3ca/W0m9zHkadi9+Ro6hnS7ExM/LZy4b9LbxR3NrDWXjaH
ltlbyczN4shG9HHIgbN8tC/4T9RfqD2P42vL/FeKo3V2DzK27DucFFdx/m2J
13an/qP0N41I/Je9FYw9/Wnihv7MXCSOOB/7AmQFeztKznUk9VuU8zj6sdS1
1Ix/S65PM3O7/pQGfO2puVczOyXzzGhW9Cep9i2FsaMeNHGfJPjv1ZkfYW/M
/XcIs+JycYq4RJwubJwMvpsw8q64KDPWVLPDqTlTXCmM/Z6aI8WN4jT9veNy
c7X+4P8BlNwI1Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287682, 0.5435370519035337, 0.9097253540741589], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQlmUZxt/v9B6+b1j3wxSndFHUFWUSafPIFAkISHiAoklnmrFlmzIN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnlo13UYx7+/Y/seP9QtcS7Dmc2s9A+71DTC5kqZSbXlooOg1CjTzUZR
kekOSa1h2KZ22IGd6iychpDUbB3UHwa5UkpzCU3zILOaUtuCXm/e++OB5/k+
1+e5v2PnL62qTQdBsBHIApVhENREQfAEH3uhP46D4ADfhsIcApTBK0iCoAr8
FWTuhJ6TC4LP8oLgBPBDaB3JLoYugbeab/WpIFgFfR10ITrV6NYDw8EfAY6A
70ZmLfxz6JejXwlMg16Kvy7wNvQPwBuJfDv4ZXxbBv4M0Ij+eN77B762Iz8G
/hpgNPpnQvt+FrgQfBHyPyG/Bfn/oB+C/hG6Ff+3IP83Psqw3Yl8PfjnyJzK
oAMsAr+Rb28jfznys8BnAzMz/nYevDd2bIphBPZ6lD/o74DH4ZUCneh2ofN8
zjlQ7FfkB8Fy8NHwn4Z3GvmroE9GxhVjC/L92GtBfi7yTTnHoLePgD4GXk78
Lfhezvsnwx+G/vvg7wHn4FfCb4M/HntFkXOqXO6APwF8IlCB/5XwG5TbyPhx
8vU9uvOB7fibifxZ7I1RjcGfA6bCq+fbBdhrAL7C1ovoV6F7EXQp/LHAJ9hb
An0fvN+A2fj7hm8Pg4dAedo1ysPWAuUL/nrkZ8g2cE3aNVMstwPbso7pJvAF
kXPdCp1AR8B66GroLLrr4A9Ar4OeDm8a0Ec8+/j2GrzXgZvBN/HmAvDN6Mwh
tttUU/BRwCzwQ8A4dDuhT/K+GuwVg29SDBnH8CH8D4AV2CrBRiO5KkCmGXo4
9WqFDiL7uhV6LryJwIMZz8RedDfKZsoxX4l8B9+u11uxNwX8atUc/XrNS+ic
KVf7055N9bR6WTMq3Q3wX03Zxkhye3HOtWvgWx54fs61U05+Dz1Dmp1afEwF
n57zLGqG63h7Xc6z3wSdihyTYtGbF2K/KLZt1bAwdM+qV5WTNchXQO9Ff1na
vXFp4lyqR05ElhFPPTI0ck+rl3ejn4/tg9gsRP6BjGfjZWSyGc+Idk9RzrOg
HTQQugbKvXJQhq+ZiXtBMzqA7lvY/Af9HuUc3lPI/4t+DXQ/emFsX5MD78pf
gLKMd+YOeLuAfOydSXnWxyn+jGc+QnYV9kqw05Zy7TI570rVULOrHlbvaobr
4K9E/zD685DvC70DNPvqoQmhd4h2x9fQm5Hdqn2TcQzV0EdDz95H0N3YPpJY
tgKff8H/M3YsM5BpBX80tC/tPO3+Zt58Pu0bMAn8bGxZ7cidsWdYs6uYNest
uhFpz/yTkWOQvX0p1+r+yLOmmt3A2w/GzrV2+p7IO0e7pgT/x5EvzrmXZVO1
uJb3F2Rdkz3oZnPufX17AXptbF/F6L+Erd7Qu049oVnVTtcu18y2g38bulaK
8W7k74msrzdrV3yBzKisd8YW6MVAt96fca71TbhyrtmflPNsagdMAX8jdK21
g9+B/ylwyaD8LngNg+9RjbU73yS+IXneoZqN1ZFvm2akCdnG2LdZOu9G3uHa
3cOgt6G7NfGsaifKVkPo2sumbmktsD/rm5oPflfoW6ubrt3WlXi3a8fFkXee
dp12onbhz4l7RzvxMPihxLMom+pt3VjdVvV4s2JPvPt0k+fx9hWhZymDvW7s
t4V+u2boqHKT+DbopuoWPhb7VuomLoC3MPEu1g36MrZN2VKN7sXWaf2TILsK
uCN0zpVrzWA/eF/kXSUZ1SJOfBtUkx7oXyPfdt0M3Tb9U+hfQjfuVGQfsq0b
2QG9M3Kvlaqf4LVDHxvs9yXgHaF7WT3zP92VLSw=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084038911, 0.6393668249866237, 0.9110850317349507], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMldUVhr9z+c53OWisKLfYjKXEmWDQgibWaqMJJKVqothIDQrSAdtQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltsVVUQhtfhnN19OUIQgRbQBAxpa40QWhNBajCxiTceoAa8xAieUo0K
JVUimniheGnF4u1BxYAieOX2QEuNIqAQ0Qc1RhCrQmsCUu8FfDBSNH5/fh4m
mVkzs2b2WvP/a08qLW1sGRZCWIUUkNYshHuRG1nsyoUwMgmhoxjC5LIQtmNP
SUNYjRzLh9CJlBM7FvkZ30I2+C8O4WPsuiiENcgE7IPYV6Ffw55PY2/BvgC9
g5wR7LULGUtuc861JhHzfnDNZdTvxH+UWgfwf4L+I/4C+f8iRfwN2D+gX42M
wz8eqUZ/ivg38W/G/xF6ibX12DOpsYV+iuw5G9/drN2K7xA1n8Xuob8q/JX0
9Du+35CM/F3E9OLfyf6jC+55AL0DWY5vOnZKbB37ryd/E/t1Yu9BJlPrb2Ie
J/Z46tjDrLWjb8JfQWwf9lCZcxRbwp6GvxYZif4VPUzA14tdQ34XNbqwtyPj
cj6f/fg+RXYSfwN7VtLLVr5nIrHPK57+H8M/wP5fEn8F/vLEZ1Nd8NkvIn5f
wXcwgP1C4rNeQf5G9GbWTuEfnve398TuTWfQTO4dyH78W1k7jq+cGo+Q+yjy
Afm7WevF9wfx5bp75D72WoacVH1iDuJbRXwr+mlkPr6jmh9ib4s9e5qJHnyN
2L9Qbzz2RvRj1J9D7lxkFrW/I2eQet2R7+Ik9pUF30kd8QtZ+wd/A9+7A/tJ
/Efw9SNr8QWkntpJ3rNzhP2vjzxDNcRehLTrLJC5sXtSL/3kVBFbibyLfhdr
D5I/Hfs86p8h/35iF5AzWPCdXJY5Rr4WelqT+A51dxH5S1NjTNj6HHsRdhNy
e/AZ1hLflvhsG9gzI/Y69nwFvUTMO8QOYTdFxqzuciZrL+d9p0vQK1Jj5zPW
biH2ZqQH33vIN5nvWHcrTMv3IntMixyj2c+o/3pkDAib4gBhXxjtzowxYasS
fx+x/YnPShjV2XfHxoLuoB69iKwteCZmoFcUPUv65mszz4xmRd+oWWhjj+/z
nokD+L/OjMW9shNjSNi5lJhf0S9OfXfCeDuxU1NjQ3dyOvPMa9Z1ZlPR/8K/
m14eRk6hn0ita6ZeEteQUxuZA8Ulz8W+K3HKPuy9yLrgmOF8yzlFY7WHmG+J
/ZD9xrBXS+RZKcO/JPLM/IQ9mh62YTeKU4m/EJkzzJgT1oRZYVWY6yd+Q2wu
V8yr5L6WmCvVQxP+UuazEea3oW/OzM3ijD70w5m5XzMvbL0Ru7YwFlFvBmtt
Bfd4hr0PpeaSm/LGhmZSsyiMaDbWJcaSZmQoMceKW4XxZ1JzmrhMb4y4Vmei
sxDnivvOT4xlcWAV9auLniVx/gLxQ+pZFwfOJ7a1aO7QnU3BHkx99w9pHrF3
nK0nDl2Mfo84KmeO0iw8kZqrNRMpepYay2/pG9A3pP5W5ezhLEbR7+pgTIir
hHFhW5z1J7GXJK4tTjg3NsaF7Vq9T+SvjD0LI8h/OzEniYv0BtTEfsP0dunN
qk/dk3oRhtti76FczdDlmTlO3KY7moV+Z+Ja6rEBfUzmt/sLcpYnfuPVq3rO
JeYAYV8cqLdqXtGxerNmE/tA7LdbHDsqMQeLe/UPUYY/Tv2WiWNP4JtYNNfr
H2AevhWxuU5v+krZZ/EnDAv7i1NzkTjgf5tnHsM=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.693047450679014, 0.7351965980697136, 0.9124447093957426], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMVtUVhs/Md77vnH0+bSxqvWBabQJDtKJVRiMyvVhIpBEpBq2xDYPg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWtolmUYx5/5Pq/Pcz/vilIslVFZ5EZRaW4KulnZBq226SQlNCeunIKH
HZxRfQiKwpYd1emHcpaZGkRQrHTmOmhpi5xQW+WXLJr2ITQG0Ycs6ffnvw9/
uK77Ot33dbqnNbcu3jguiqLnQQwOp1HUAUY4LMlF0ZEkij6Cn5Izvy2LojPw
c4ui6DIGS0MUPYNOK3wem+PIPwdvwJfno6gY3T0gYLsPfjH6jaCGWOs4ewLd
J8FKbPuw+RTZZ+BQzjrlBfuQ7dtgJ3wD2I68cTx3w7YMfhuyHu4zhO5UsBp/
raAZX6vAI/jqx6YcehZ4Ffo1sB7bdWAasUfwMYi/FWA/fFXesRaCk3nHvBLb
4uC7rwdToCeDzdCPgeXQy8CDkd9wGF9LwE78leGjEV+LwFPc7S/uOxP6WOZc
7QYzsZ0BXsb2FVCK/AHke2K/8WtkA8FvUYxK6HngBvyv5ewiuhfADuhl6Ncj
68THH9Cz0f8K2XKwG/2KvGN9TP1+yTlmG7K98HXIhohZCf0o+byO+7ZjXwrf
gc4wsm/gv1dvjOW7BfyNfDX8MPR2fMTo/gR/NfEWYlMKfwc6pdi2wf8Kvwn0
Iq/P+64NY/nVnf9Bdgn8m/Mbf4ReA96HrkZ+Ct1BcCznGqu2s4hXG7vGqtXj
xHs3Z5/D2A6B95QLdFqQbc1cC/WAfK8FA7Fj6O4Vwb2iN3yYeEY0C5qJXuhm
zrrH+HZ0DybO/Wn4auRLeNNE6B71pHpP+pqPca7Fw+BI7JocSOxDtoPgAPb7
x/J3GpxH953Es/IQ9l3w3QXPwig+SpD9kDk3tcivhZ6UOfYq5HX4PgNujZ2T
Z6GfAy9BT8JnZ+qZ1/u0Azqx3Zw5lmp0DnqfcgDdxNl0bO8lfl/ePd2beSY1
i3rjLmRH0bkE3cUdV0CfBCXIJ2BzAl9twW8d1R3gT2Wevfn460k9I5oN7ZBi
5Icyz9ItyOsy95x67S18ToT+MnNvVyDfgf23+L8eWVHOs90E+mPP+AD612TO
zX/It6DbmzjXqtka+BbQEbnHtkK/GJybq9CpxfZ+8HrsGbkP25bMvfUJNlcU
vCO1Gzu50y7kX2SuvXbk04lzpNxoh2pXLAUfxN4ZI7pP8OzO5mxlcA6Vu6Pq
L/Vm5l38Jvyc4J5QL2gHnNC+Kji2cr4gcY6VW/XcTZr9zLPXyNlZ6BsT3107
oKvgmdesl3LH3/BXmvouFaA2sQ/ZambaM+8Q7Q7tiELqHa7drZmrSdyj6k3V
YFPqHhgd67d58HnsF8XeudXY3px6l6vHNsBvLHhXn9F8YtsfvIvVY3chK0m9
i9TjGyQL3l3a0QeDa65aa6e0ojuZeM3oHi9yrzQF51Y9cw/+FoAZsf+8uxP3
mHpLNdqivytxL2iGLmI7PfNuqwL1mXtUvbk39i6fGvxXaKdfgL4ttW4lOAv/
c/DbFDNL3MPqXfXYhHSsJuM9gzWpe0C11xv60H8heBd9V+RdmwX/Ddq5Zalr
qNrNAbenvoNizwe/Q58P3gX6E7R77gz+i7SD9LeeC7bVzr8cnEPlTju3KvGM
ajb1B+hv+DPYt/RV27mp/wLVuBu6IXNuNGP/A1qNDPc=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541368, 0.8310263711528033, 0.9138043870565346], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lsF1UUxqf/dWaKUVO3GFGruCIPUERFiKhg4tKiuFZc0Cg7pUpxoWWR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltsVFUUhg9zZphzzoA3jJcHqVVEqvCglKsSEK2JkilQjFg1phCpMmCp
lkql0AQ1JgUeLFqjvBBMDMYLECPCVIREKhZjxSjaSsNlKggvIC8Gowh+f/4+
rGT9+19r7b3PuuxTvnhFTUMqCIJ2JI10ZIOgmARBRSYI7kLeyQVBJ7IRo4Pg
9XAbkL8w7mDtB/ReZAu+e1nrQ/8V2Q7uAS+JsUHK0W/Afzbxn4Yvpu3zArH3
s1YWBsEf8DvgNoK/A5eDW/BtQ/rBvcOC4Bv4buTNwDGOwO1MbHsImxL6SeQr
+D748cRaDT6OPsDay+irkAHwLuJVwT+T+Ow6cx3xDiG3gK8nZr/uhs0ObB/l
vsfgZnPm3XDLwYfhN8Nvg58J3gPejawj1k5ifAa3Hp/BofO/B05Ftp1KjHfB
B7GfjD4FmQqXAufx7QYvxHc/ciP4GvC/6P8gfxP/YdZm4f944r30Td7Cfzhr
neDL7NEEfiny3ieQlXBHwfdznvPwr6PPQZZifwG8nLsVkC700+zXCfcT+42B
T+HzJXtdIcZmuLuRPLg6MVeBzwy4JZF1fYPb8P0FfBa9DZs2bD8FnwEPErMC
+zOsPUasWnzGgAcVE1wDPoDt18iz2I8C9xLvZs63LuOa6gFfBW7OOGdlqrXY
e61BWmPXkO7fBx6LniX+AmxfC117x1m7Jz1Ug3DjWPue/RZknItp7F+ddk6O
oN+K/VpsJyGjpSe+S6v2BO/BvxR6vwvY/4kUOHsRqcN2UeJaUs1sQu9QjYGn
Y381/tciDej18Nehj0IawY3gK8OdY+W2nT3r2WsAPCN0T16Cf0JnAL+adm4H
wZVp57iA/VbWRsBfBK9k76bEvdKPHMb2R6Q79Df/OXaPqbeaAtdCPXIgdE28
gm8LciztHssTfwJSx/lK4Cq4KHbuVJPb4Bpj1+JepAC/LHGu1WMNcBexeTvj
GTAn6xpRbahndddlOdem7qxabs66dlXTI/GvRj4a+n4hsW+XT8o5rEK/ibVS
yt+8EttJyDTs31D9Rc6pcnkv9iX0O1jrYr+J4H2qH/ZfkXFPXgL/F7sXleMH
4H6LnEvNiHHop2PXyovwj3DW5xPPRs0oxZoP/0nomGXYD4AnwH+R8bf9IOta
1DfOw32uM6R9R/XS9si9rJ46i30r0jXMPfV74pmnWaeemhe7xvRtPg7dm7M4
w66Me3QK3DnsazOe+S3w+ZxnkWbOfeC5Ob8FG+BHg4/iMz7tGOrFJ8HF0D2p
WfFt4tmmmbEKfm7svXXH83AfZl0L2lO9vQh+X+ge113WJK4l3Um10ZX4bVKN
aFY15Px2aGYp1ydj5045r43dQ+od9cRTsWeqZqnOeAr9zsi50Te9DJ4YuRZU
I5oV84jfk/HMmAmXY20hei2SRp8e+VuohkaCRyCnAtusjd1z6jW9Ye3g1bFn
g2ZEAX1p7N5SzxWzniHi9WaMjTzTNMvUwzWxa1z5U81UZt3z6nXNjHOqhciz
Rmd4iLM/mPOsUw2/H/kOOrtmgGaZaly1rZk2OesZo9mimaO3SW+W3iq9USdi
v4F6+zQzlXvVrGpVNaB/h01Zvw36h3gu9j+A3n7NjMWx31i9rcrx/Jz/KfQv
oW+s2duceBZpBv8PJlIlsg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8072672499999938, 0.861882999999998, 0.8940340000000028], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2uQlmMYx5999333ObxohDBMJOUUHwybWipMMrYwbZuMzDiMQ7GyjRC2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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsVVUUhve9517u2edaFaHihLFl0Ci+EG1REwVNhQg4UNAaIE5BKAio
AREVEmlNoFAVjNEgopBoomKpLz5oDIMpBkpo0QQnNLU+UBxonRE1+v3+fVjJ
+ve/1tr7rOlU3bt0xpJ8COFJpICMKYXQnYYwPgnhXYhnYgjPIkfAv8Ofif4Y
Nm3gxcjwLIT6cgidxRDmEKAOPAR+Frb3wSfEOszZRPityJ/4/4NMwfYp4h+A
vw35Gm4c9guIVQ/+BtyjmNg2Ee+hHH7I3+Bq+AmJY0wh9mSkjVhjOdsH14HM
Cz7rhBtf9t3bORsL10uMN+EeRG4An4VNSqwt4BruGga/NPE3tMJNAr8MPonN
GeDTkca8z7bjvw25lLc9z9kSbDcQYwP4MvB87r4feY5YR3lDNfov8E+jtyIL
sV+AjEDvIF4F3P7UuXgH/8eV7+jcqwYj4e/h/t28pZ2zAWxnSeCmIR+i92Fz
EfzF4L+ic65cT+asGX45/Oycc5AQ6yrOWtCvwT4HrgWvA08HX4leg/8m9Jvw
X4bvGs725RxDb+9WTQr+huHolcjDiWvWSLxX8KmD68RmZck9pN55G3mEfNwC
HoDvR5rAeeJvxXfEEH/bCWRq4m88H/4CZFTBNb6L+JuJeS2+uzirgmuMzuV6
zpaDv1SO+Z4TRb+9DalM/A0j0Y+krv18ZC+2u6N77VziXUHsoYPvvZH77kRv
iNbVI/u5/wByddE1Vu7T6N5XDW4GnwbfoG9XDkueMc1WF2efw70Kbue+qXn3
dn/qWqrHP0WfC79+EFcTuyq6d2vACzPnWLk9iHyL3ovs4i1fgFejr0IW5/3N
4/C9HGlBb+bsRWJ/BF+Td86HZs6JcjEX/88y95x6TTXsAx9DDoF79E3E+gD+
WOL+rEUPSEvBPXB35hqpNurZW6Nrrlorp6/BrdMb0M/hrB48M3Pvt/Keteg/
pe7FAfynY/tE5ru/4qpRxGot2VYzNQN8feq3ayct4r6f4ZcF3/E+vpvAL+T8
zSuwP0Wf1Qb34G/4/qp5gj8O/yP6G9oRiXtwC74VqWs1CftG/D8GdwfvLMVS
z6nXFPMl7VPuvK7oHdiFfjZn24J79kJ8J5ZdS/Xowcw7S7tKPfUd+vfI7UXf
MUG5wL4v75nVbCpHyo1mVHfpjXqb7jyEXh89a9pxqs2e1LtSNdoIfi/zrlJO
KtDLmXeZevZkdM+oV+oK3tXzyt5l2tmr4FYP/h+0A5vxbUI60PvxmZl6p2uX
9xZdC+1A7T7VZGP0jtVuVQ/p37Inevb0jzmcOoZ89U96FP1U9C5TDoZl/gfp
33MJ8brgziP+mqJ30g9wlfjsBDcgO8HtyJiCd3SNZk32iXfecbjXS7ZVzlUr
7STtItVsNHhR5lnTjK0tuYfVu9pJn0TvIO0e3XGH/FPnQnc8oFnMPPua+R1w
b6V+u3I2p+SZ16xrRjX7K1P3onbADvAf0bX4vyfBKzLPumZyNLY90btcMz8b
/G/07lZPq5e1k7SL5K9c7U39r1DOqtCPRnP6x/0HrZAKEA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8608307499999963, 0.8797449999999988, 0.8700376000000016], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1tsVUUUPb3n3ntevoWAolZAPkygCkYe6gdqIkQrYFstCgpYFI3vDxUw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtln9MlWUUx1/uey/3vvcdtQqnRavI2dYf2u/Q4o/UjaxIGVC0JBWjXNO0
1rKwrdbAaVuCLUMSBTetbIgYWq60BTZCgVHoZNlqa221Sc1SLG2V9fn25Y+z
Pd/3e87znOc853zvLVy6qnxlIgiC17EkNjMKgoPpIPgxDIJmbGEmCM5hZaz7
cHwB/nmsPycITvAtH98h+Bms98Evi4PgCayb9XepIJiF73Xik97vI/C2bBDE
cF3gl+FewXbhP4s9f2e9BtuQ8JkBvkXgUuIfwIbAR7B2fIvZ4yTra8ihG9cS
cCO4CfsL383sUU5sEruZvfaDq8ltE/x7rEfwryF2HH4BfBPfHgJ3YYPs/z34
C7j52Ci+N+KzgtjtaZ81zBn53Kce/Ancs6FzG8DuTjnHP4m9D3uHvSrhy+E2
4H89fCfxIdytse9yDz57085JuSiHYfgUtjPwHT4gvhF+Gv5TsRLwvViL7ovN
IZ+N4H9Yt+G/hb3nET+T+I5cfOSLpVKu+SD+O8GTwJ/hPwK+mph68GT4Taxz
iX+fXMqI34HvWs7vCR2js0bhi0KfeQj8JnwL/tOJX8X6PHx56DNXgFdH7p2/
8V8OPqsah36zK4iv5MwhfBeD52Z8J91lUdJ3v5D23qpBRdY1VS33YGOsi4nv
hKvCfgG/i/9B8qkhZnbaPate3Z/02y8BNybcA8r1OeLHUs65FW4k67fZleNc
dQflrpwvg5vDty0J1yAHfDt4XcI9q1yOgW8LndNR+Bl8a025RwoznhHNxk1J
z8ol+Dya9MzId5Bv00PHlHD2tdgOuBdDn3UGW5/wmRfY6zx2mFxfg++BO4n/
RXAH/OPstxRbTT98zX5l8DWx199g8zi7l28PB+6pxXCLsCrw8ZRnQT2nXtNM
bIMrzXjv0/RHA1w9+CL+P+PzIOvHYseewA6Au7Ar4QvI7ym4CvCBhGu0h1x/
ZY8fEtaYj+EO8W2U9Rq+3ZmxJkgLPlcNWfdw3ynghqRr8yU+t4SukXqpA5wf
uqcKwH0Zz7J6XLV9MrZWqcbSsslpa4U0rR98CjwF3IUNgI9iDYE1TmfdAF8b
+kz1zsLY2qIeeov8mrOefWlOa2wNlPYdo179xM4Ft4PPhr7r2+DfQt9Z2qEZ
1uxKQwo0n5HfXjMprazD8nKsmfcT/3TW2tRLjgORZ1yzrTeshb9rot+uyrG2
aMY129KYas1W5N7RnkXgSZG1TT2xXrON/0b818LXSW+wnybyLdZbpv22mqnd
4E7w8dBvsI7YvIxnqZA9usl1X9Zapp7U3tIgaY/OKFd/xNYCzZh6Z2/G2q4e
Uu3asD9C13Ca9Djr3nsVXB25R9Qb0uh28BFpUuiYZzJ+A9VePdfGWVuxc5w9
nuvfFuX8f66cNwy+PGstOsMdpsKNS88T1vTlql3atdG3Efb/KuO3UI9LOxdk
3EvS0Cb8K/k2lnQN3wB/OtHvzfgcBvdiy3Lc431wzeDToXukhfXmyG+pb/rt
Xpnxb5d+w+9g/W/k325phN5CNVJt9CZ14IrId9EZeeDKrLVUPX5KtcxaS6Wh
VawfyVo7pfG78f82snZJcy6Fmx05d2lYFXxp7FmVJkiLlsTWAmnSVvxfSrvW
+k+g2ktTpCV6gw8jz4xmRb9hmsXa2Fqlmdwe+T+E/jvoTf8D+lU1cw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9143942499999987, 0.8976069999999995, 0.8460412000000006], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl21ollUYx8+zZ8/93M+z2QcVszaL0KI5+9Qcywm2LWvPNJpCZO+ugqaF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         "],
         VertexColors->None], 
        PolygonBox[{{1857, 2648, 1203, 149}, {2485, 2590, 1127, 1033}, {2247, 
         1799, 103, 810}, {2915, 2913, 688, 1497}, {2450, 1891, 741, 1000}, {
         1806, 2943, 1550, 134}, {1949, 2054, 578, 973}, {2423, 2422, 299, 
         980}, {2464, 1992, 483, 748}, {2128, 2916, 810, 688}, {1878, 2799, 
         1371, 250}, {2709, 2708, 1281, 1282}, {2331, 1949, 973, 887}, {1892, 
         2450, 1000, 919}, {2463, 2462, 480, 483}, {2506, 2831, 1398, 1054}, {
         2647, 1939, 1324, 1203}, {2248, 2914, 1497, 811}, {2360, 2362, 919, 
         469}, {1877, 2158, 469, 247}, {2958, 1967, 247, 1601}, {2122, 2175, 
         748, 1490}, {2711, 2122, 1490, 1284}, {2938, 2124, 1773, 1535}, {
         2702, 2112, 1482, 1274}, {2591, 2120, 678, 1128}, {2908, 2907, 332, 
         1281}, {2590, 2591, 1128, 1127}, {2941, 2127, 379, 1544}, {2456, 
         2454, 478, 1007}, {1989, 2457, 797, 478}, {2125, 2912, 805, 685}, {
         2254, 2052, 577, 578}, {2748, 1806, 134, 1324}, {2244, 2910, 1492, 
         808}, {2852, 2248, 811, 1423}, {2233, 2092, 838, 797}, {1862, 2332, 
         887, 180}, {2108, 1888, 278, 465}, {2948, 1815, 149, 1561}, {2297, 
         2296, 331, 678}, {2943, 2040, 398, 1550}, {1789, 2938, 1535, 72}, {
         2240, 1789, 72, 805}, {2911, 2909, 685, 1492}, {2296, 2710, 1282, 
         331}, {2974, 1915, 360, 1773}, {1799, 2941, 1544, 103}, {2738, 2852, 
         1423, 1316}, {2130, 2948, 1561, 577}, {2716, 2717, 1033, 360}, {2160,
          1878, 250, 480}, {1891, 2455, 1007, 741}, {2231, 1975, 465, 790}, {
         1966, 2421, 980, 1371}, {2723, 2724, 1054, 379}, {2831, 2244, 808, 
         1398}, {1968, 2958, 1601, 278}, {2112, 2224, 790, 1482}, {1903, 2712,
          1284, 332}, {1899, 2703, 1274, 299}, {2737, 2739, 1316, 398}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{28, 12, 13}, {251, 252, 30}, {265, 251, 14}, {285, 300, 
        15}, {13, 29, 28}, {251, 29, 14}, {45, 29, 30}, {29, 251, 30}, {300, 
        285, 265}, {304, 285, 15}, {285, 252, 251}, {29, 13, 14}, {327, 326, 
        307}, {285, 304, 252}, {265, 285, 251}, {326, 327, 11}, {307, 326, 
        12}},
        VertexColors->None]]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1830, 2255, 1823, 1862, 2332, 2331, 1949, 2054, 2964, 2053, 
         2254, 2052, 2130, 2948, 1815, 2252, 1812, 1857, 2648, 2647, 1939, 
         2748, 1806, 2943, 2040, 1934, 2737, 2739, 2738, 2852, 2248, 2914, 
         2915, 2913, 2128, 2916, 2025, 2247, 1799, 2941, 2127, 1925, 2723, 
         2724, 2507, 2506, 2831, 2244, 2910, 2911, 2909, 2125, 2912, 2009, 
         2240, 1789, 2938, 2124, 2973, 2972, 2974, 1915, 2716, 2717, 2486, 
         2971, 2485, 2590, 2591, 2120, 2970, 2121, 2297, 2296, 2710, 2709, 
         2708, 2908, 2907, 2931, 2295, 1903, 2712, 2711, 2122, 2175, 2174, 
         2464, 1992, 2463, 2462, 2371, 1991, 2160, 1878, 2799, 1966, 2421, 
         2423, 2422, 1900, 2290, 1899, 2703, 2702, 2112, 2224, 2223, 2231, 
         1975, 2108, 1888, 2291, 1889, 1968, 2958, 1967, 1877, 2158, 1979, 
         2360, 2362, 1892, 2450, 1891, 2455, 2456, 2454, 1989, 2457, 1980, 
         2233, 2092}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1876, 2447, 2448, 2425, 1981, 2449, 2701, 2369, 2575, 2574, 
         2080, 2361, 2081, 2524, 1964, 2551, 2552, 2348, 2349, 1884, 2263, 
         1885, 2169, 2170, 2293, 2292, 2139, 2559, 2101, 2358, 2696, 2289, 
         2100, 2561, 2103, 2560, 2102, 2892, 1879, 2179, 2692, 2691, 2341, 
         1965, 2220, 2219, 2900, 2579, 2580, 2899, 2898, 2114, 2577, 2077, 
         2262, 2704, 2370, 2115, 2578, 1998, 2387, 1913, 2320, 1914, 2497, 
         2498, 2496, 2619, 2396, 1923, 2324, 2325, 1847, 1792, 2241, 2632, 
         2631, 2630, 2126, 2246, 2245, 2843, 2844, 2513, 2968, 1928, 2725, 
         1929, 2411, 2034, 2850, 2035, 2851, 1933, 2642, 2643, 2644, 1805, 
         2249, 2250, 2129, 2917, 2919, 2918, 2251, 2862, 2761, 2762, 2760, 
         2764, 2763, 2866, 2051, 2769, 1947, 2768, 1948, 2061, 2951, 1822, 
         2777, 1952, 2668, 2669, 1866, 1829, 2256, 2257, 2132, 2920, 2131, 
         2921, 2258, 2876, 2794, 2795, 2793, 1958, 2796, 2069}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1837, 1869, 2684, 2683, 2792, 2791, 1833, 1867, 2679, 2678, 
         2787, 2786, 1828, 2667, 2666, 2665, 1951, 2776, 1821, 2657, 2656, 
         2655, 1946, 2767, 1814, 2947, 2050, 1945, 2758, 1944, 2759, 2047, 
         2747, 1938, 2745, 1937, 2746, 2039, 2414, 1932, 2735, 2736, 2516, 
         2515, 2849, 2409, 2410, 2408, 2512, 2511, 2842, 2242, 2243, 2024, 
         2312, 2629, 1798, 2195, 1791, 1846, 2323, 2322, 2393, 2392, 1788, 
         1844, 2321, 2319, 2384, 2934, 2383, 2935, 1786, 2933, 2523, 2079, 
         2522, 2078, 2880, 2261, 2338, 2337, 2335, 2086, 2530, 2123, 2180, 
         1909, 2266, 1908, 2178, 2222, 2221, 2686, 2685, 2334, 2084, 2528, 
         2083, 2563, 2105, 2562, 2104, 2893, 2168, 2554, 2555, 2553, 2557, 
         2556, 2082, 2287, 2288, 2133, 2286, 2285, 2217, 1870, 2572, 2573, 
         2571, 2111, 2210, 2209, 1898, 2429, 2430, 2424, 2427, 2426, 2441}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1836, 2682, 2681, 2680, 1957, 2790, 1832, 2677, 2676, 2675, 
         2785, 2784, 1827, 1865, 2664, 2663, 2775, 2774, 1820, 1861, 2654, 
         2653, 2766, 2765, 1813, 1858, 2652, 2651, 2757, 2756, 1811, 1856, 
         2646, 2645, 2744, 2743, 1804, 1853, 2149, 2038, 2636, 2637, 2638, 
         2197, 2514, 2406, 2407, 2405, 2510, 2509, 2841, 2401, 2402, 2400, 
         2505, 2504, 2830, 2394, 2395, 2391, 2495, 2494, 2823, 2385, 2386, 
         2317, 2382, 2932, 2381, 2484, 2532, 2087, 2531, 2088, 2533, 2074, 
         2260, 2336, 2529, 2085, 2884, 2883, 2342, 2567, 2896, 2897, 2698, 
         2699, 1894, 2267, 2923, 2924, 2922, 2926, 2925, 1983, 2526, 2527, 
         2525, 2882, 2881, 2265, 2706, 2705, 2372, 2117, 2584, 2159, 2558, 
         2099, 2355, 2356, 2357, 2264, 2564, 2106, 2565, 2107, 2895, 2894, 
         2966, 2965, 2697, 2359, 2797, 2798, 1960, 2417, 1959, 2416, 1990, 
         2163, 2162, 2232, 1970, 2442, 1977, 2428, 1976}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1890, 2228, 2229, 1978, 2164, 2444, 2443, 1886, 2166, 1887, 
         2695, 2351, 2437, 2436, 2534, 2535, 2440, 1974, 2352, 2353, 2354, 
         2214, 2215, 1973, 2438, 1972, 2439, 2218, 2901, 2116, 2581, 2583, 
         2582, 1993, 2472, 2811, 2810, 2211, 1893, 2363, 2364, 2313, 2314, 
         1839, 2599, 2598, 2542, 2093, 2541, 2094, 2543, 2073, 2259, 2075, 
         2520, 2076, 2879, 2521, 2380, 1912, 2316, 2318, 2493, 2008, 2491, 
         2007, 2492, 2967, 1921, 2720, 1922, 2390, 2829, 2828, 2502, 2503, 
         2397, 2399, 2398, 2508, 2196, 1802, 2634, 2633, 2033, 2148, 1852, 
         1803, 2412, 2413, 2328, 2329, 2330, 2635, 2855, 2856, 2741, 2740, 
         1935, 2742, 1936, 2415, 2046, 2753, 1943, 2752, 2755, 2754, 2865, 
         2206, 2207, 2060, 2868, 2059, 1860, 1819, 2772, 2773, 2661, 2662, 
         1864, 1826, 2783, 1954, 2672, 2673, 2674, 1831, 2953, 2066, 1955, 
         2788, 1956, 2789, 2068}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1835, 1868, 2154, 2067, 2954, 1834, 2208, 2875, 2781, 2782, 
         2780, 1953, 2064, 2952, 1825, 2660, 2659, 2658, 2771, 2770, 1818, 
         1859, 2057, 2867, 2058, 2205, 2204, 2048, 2963, 2049, 2650, 2649, 
         1942, 2751, 1810, 1855, 2151, 2045, 2946, 1809, 2201, 2854, 2733, 
         2734, 2731, 1931, 2732, 2031, 2847, 2032, 2848, 2327, 2326, 2404, 
         2403, 1797, 1849, 2840, 2022, 2839, 2023, 2194, 2193, 2501, 2016, 
         2389, 1920, 2719, 1919, 2615, 2937, 2616, 2822, 2821, 2617, 2618, 
         1843, 2144, 2006, 2310, 2311, 1787, 2188, 2239, 2545, 2546, 2544, 
         2095, 2547, 2891, 2890, 2134, 2929, 2161, 2298, 2299, 2284, 2283, 
         1883, 2282, 2347, 2346, 2345, 2098, 2177, 2176, 2234, 1982, 2156, 
         2155, 2216, 1961, 2465, 2466, 2300, 2518, 2877, 2071, 2517, 2070, 
         2213, 1963, 2270, 2271, 2157, 1873, 2230, 1874, 2433, 2434, 2432, 
         1971, 2435, 1905, 2167, 2350, 2445, 2446, 2227, 2226, 2238}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2113, 2576, 2566, 1880, 2957, 2549, 2956, 2550, 2548, 2096, 
         2872, 2065, 2871, 2874, 2873, 2671, 2670, 2779, 2778, 1824, 1863, 
         2062, 2869, 2063, 2870, 1950, 2056, 2950, 1817, 2153, 2152, 2055, 
         2949, 1816, 2203, 2863, 2864, 2750, 1941, 2749, 1940, 2044, 2945, 
         1808, 1854, 2042, 2962, 2043, 2200, 2199, 2036, 2961, 2037, 2641, 
         2640, 2730, 2729, 1801, 1851, 2029, 2845, 2030, 2846, 1927, 2838, 
         2021, 2627, 2628, 2147, 2146, 2837, 2020, 2625, 2626, 1796, 2192, 
         2499, 2500, 2388, 1918, 2718, 1917, 2611, 2936, 2612, 2490, 2820, 
         2613, 2614, 1842, 2819, 2004, 2489, 2005, 2187, 2186, 2481, 1997, 
         2480, 2483, 2482, 2141, 2279, 2280, 2184, 2889, 2183, 1783, 1838, 
         2171, 2172, 2097, 2281, 1907, 2173, 2333, 2419, 2420, 2339, 2340, 
         1875, 2212, 2237, 2569, 2570, 2568, 2110, 2276, 2275, 1897, 2368, 
         2119, 2373, 2374, 2375, 2272, 2594, 2595, 2593, 2597, 2596, 1985, 
         2431, 1986, 2451, 1904, 2235, 2137, 2138, 1969, 2225, 2301}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2253, 2202, 2858, 2859, 2857, 2861, 2860, 2150, 2041, 2944, 
         1807, 2198, 2853, 2727, 2728, 2726, 1930, 2028, 2942, 1800, 1850, 
         2026, 2960, 2027, 1926, 2835, 2836, 2623, 2624, 1795, 1848, 2018, 
         2833, 2019, 2834, 1924, 2827, 2015, 2620, 2621, 2622, 1845, 2825, 
         2013, 2824, 2014, 2826, 1916, 2609, 2969, 2003, 2818, 2610, 2143, 
         2142, 2488, 2002, 2487, 2607, 2608, 2185, 2478, 1995, 2477, 1996, 
         2479, 2140, 2476, 1994, 2307, 2308, 2309, 2182, 2468, 2469, 2467, 
         2471, 2470, 2519, 2377, 2378, 2305, 2306, 2955, 1782, 2418, 2537, 
         2538, 2536, 2540, 2539, 2089, 2277, 2278, 2136, 2274, 2273, 2294, 
         2586, 2587, 2585, 2589, 2588, 2118, 2905, 2906, 2902, 2904, 2903, 
         1895, 2165, 2366, 2365, 2461, 1984, 2459, 2460, 2458, 2804, 2803}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1794, 2721, 2722, 2639, 2832, 2017, 2940, 1793, 2191, 2011, 
         2959, 2012, 2145, 2010, 2939, 1790, 2189, 2190, 2001, 2604, 2605, 
         2606, 1841, 1999, 2816, 2000, 2817, 1911, 2812, 2813, 2600, 2601, 
         1784, 1840, 2473, 2474, 2379, 1910, 2315, 2475, 2814, 2815, 2602, 
         2603, 1785, 2181, 2806, 2807, 2805, 2809, 2808, 2878, 2072, 2376, 
         1906, 2302, 2303, 2304, 1962, 2800, 2801, 2693, 2694, 1881, 2802, 
         1882, 2343, 2344, 2714, 2715, 2713, 2592, 2927, 2928, 2687, 2688, 
         1871, 2268, 1872, 2690, 2689, 2090, 2885, 2109, 2930, 2135, 2367, 
         2700, 1896, 2269, 2091, 2886, 2888, 2887, 1987, 2452, 1988, 2453, 
         2707, 1902, 2236, 1901}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{-3, 2}, {
      Rational[1, 10], 3}}, {{-3, 2}, {0.1, 3}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64696334]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14489],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->30412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"GumbelDistribution", "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{"\[Beta]", ">", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14855],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->529814832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7093],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"ExpectedValue", "[", 
   RowBox[{
    RowBox[{"x", "^", "4"}], ",", 
    RowBox[{"GumbelDistribution", "[", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25402],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Alpha]", "4"], "-", 
  RowBox[{"4", " ", "EulerGamma", " ", 
   SuperscriptBox["\[Alpha]", "3"], " ", "\[Beta]"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox["EulerGamma", "2"]}], "+", 
     SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", 
   SuperscriptBox["\[Beta]", "2"]}], "-", 
  RowBox[{"2", " ", "\[Alpha]", " ", 
   SuperscriptBox["\[Beta]", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["EulerGamma", "3"]}], "+", 
     RowBox[{"EulerGamma", " ", 
      SuperscriptBox["\[Pi]", "2"]}], "+", 
     RowBox[{"4", " ", 
      RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "20"], " ", 
   SuperscriptBox["\[Beta]", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"20", " ", 
      SuperscriptBox["EulerGamma", "4"]}], "+", 
     RowBox[{"20", " ", 
      SuperscriptBox["EulerGamma", "2"], " ", 
      SuperscriptBox["\[Pi]", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["\[Pi]", "4"]}], "+", 
     RowBox[{"160", " ", "EulerGamma", " ", 
      RowBox[{"Zeta", "[", "3", "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{471, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62132494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"CharacteristicFunction", "[", 
     RowBox[{
      RowBox[{"GumbelDistribution", "[", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "t"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "4"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"t", "->", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13543],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Alpha]", "4"], "-", 
  RowBox[{"4", " ", "EulerGamma", " ", 
   SuperscriptBox["\[Alpha]", "3"], " ", "\[Beta]"}], "+", 
  RowBox[{
   SuperscriptBox["EulerGamma", "4"], " ", 
   SuperscriptBox["\[Beta]", "4"]}], "+", 
  RowBox[{
   SuperscriptBox["EulerGamma", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"], " ", 
   SuperscriptBox["\[Beta]", "4"]}], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox["\[Pi]", "4"], " ", 
    SuperscriptBox["\[Beta]", "4"]}], "20"], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["\[Alpha]", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["EulerGamma", "2"]}], " ", 
      SuperscriptBox["\[Beta]", "2"]}], "-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["\[Beta]", "2"]}], "6"]}], ")"}]}], "-", 
  RowBox[{"4", " ", "EulerGamma", " ", 
   SuperscriptBox["\[Beta]", "4"], " ", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"2", ",", "1"}], "]"}]}], "+", 
  RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Alpha]", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["EulerGamma", "3"], " ", 
      SuperscriptBox["\[Beta]", "3"]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "EulerGamma", " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["\[Beta]", "3"]}], "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[Beta]", "3"], " ", 
      RowBox[{"PolyGamma", "[", 
       RowBox[{"2", ",", "1"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{474, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102233401]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ev", "\[Equal]", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6266],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->124759895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63845401],

Cell[TextData[{
 "The negative of a Gumbel random variable follows an ",
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->77807631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"-", "x"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465489791],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "-", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "-", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->696656215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6920919],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "-", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "-", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->253844376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237361489],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 " is exponentially related to ",
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->481972054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->890175076],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272238738]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"WeibullDistribution", "[", 
     RowBox[{"1", ",", "1"}], "]"}], ",", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}]}], "]"}], 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->42817944],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->155330471]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19472],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 " is not defined when \[Alpha] is not a real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->23407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22494],

Cell[BoxData[
 RowBox[{
  RowBox[{"GumbelDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->62197565],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{232, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565440996]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 " is not defined when \[Beta] is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14262],

Cell[BoxData[
 RowBox[{
  RowBox[{"GumbelDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-1\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->119157271],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"GumbelDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20744654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", "0"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", 
     RowBox[{"1", "+", "I"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[ImaginaryI]"}], ")"}], " ", 
  "EulerGamma"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101707287]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16339],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExtremeValueDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtremeValueDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeibullDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeibullDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29427]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10819],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->959330126]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GumbelDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 19.4907110}", "context" -> "System`", 
    "keywords" -> {
     "Gumbel distribution", "minimum extreme value distribution"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "GumbelDistribution[\\[Alpha], \\[Beta]] represents a Gumbel distribution \
with location parameter \\[Alpha] and scale parameter \\[Beta].", 
    "synonyms" -> {"gumbel distribution"}, "title" -> "GumbelDistribution", 
    "type" -> "Symbol", "uri" -> "ref/GumbelDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7668, 246, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->834895108]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 126219, 2801}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2017, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2640, 79, 1583, 37, 70, "ObjectNameGrid"],
Cell[4226, 118, 772, 24, 70, "Usage",
 CellID->26068]
}, Open  ]],
Cell[CellGroupData[{
Cell[5035, 147, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5513, 164, 189, 4, 70, "Notes",
 CellID->53261241],
Cell[5705, 170, 694, 24, 70, "Notes",
 CellID->429991538],
Cell[6402, 196, 530, 17, 70, "Notes",
 CellID->12600],
Cell[6935, 215, 696, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7668, 246, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->834895108],
Cell[CellGroupData[{
Cell[8053, 260, 148, 5, 70, "ExampleSection",
 CellID->206691684],
Cell[8204, 267, 270, 6, 70, "ExampleText",
 CellID->2554],
Cell[CellGroupData[{
Cell[8499, 277, 177, 5, 28, "Input",
 CellID->1988],
Cell[8679, 284, 226, 7, 36, "Output",
 CellID->198967047]
}, Open  ]],
Cell[CellGroupData[{
Cell[8942, 296, 182, 5, 28, "Input",
 CellID->16798],
Cell[9127, 303, 261, 9, 54, "Output",
 CellID->197393426]
}, Open  ]],
Cell[9403, 315, 121, 3, 70, "ExampleDelimiter",
 CellID->19002],
Cell[9527, 320, 253, 6, 70, "ExampleText",
 CellID->16321],
Cell[CellGroupData[{
Cell[9805, 330, 202, 6, 70, "Input",
 CellID->30104],
Cell[10010, 338, 434, 14, 70, "Output",
 CellID->69964001]
}, Open  ]],
Cell[CellGroupData[{
Cell[10481, 357, 329, 11, 28, "Input",
 CellID->7056],
Cell[10813, 370, 3360, 59, 173, "Output",
 Evaluatable->False,
 CellID->151331119]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14222, 435, 216, 7, 70, "ExampleSection",
 CellID->17708],
Cell[14441, 444, 257, 7, 70, "ExampleText",
 CellID->19761],
Cell[CellGroupData[{
Cell[14723, 455, 195, 6, 70, "Input",
 CellID->6533],
Cell[14921, 463, 385, 11, 36, "Output",
 CellID->38601368]
}, Open  ]],
Cell[15321, 477, 121, 3, 70, "ExampleDelimiter",
 CellID->14804],
Cell[15445, 482, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[15569, 489, 182, 5, 70, "Input",
 CellID->26385],
Cell[15754, 496, 308, 11, 57, "Output",
 CellID->151751265]
}, Open  ]],
Cell[CellGroupData[{
Cell[16099, 512, 182, 5, 70, "Input",
 CellID->17260],
Cell[16284, 519, 178, 6, 51, "Output",
 CellID->88209484]
}, Open  ]],
Cell[16477, 528, 121, 3, 70, "ExampleDelimiter",
 CellID->31620],
Cell[16601, 533, 213, 5, 70, "ExampleText",
 CellID->4343],
Cell[CellGroupData[{
Cell[16839, 542, 245, 7, 70, "Input",
 CellID->9578],
Cell[17087, 551, 917, 29, 51, "Output",
 CellID->277907930]
}, Open  ]],
Cell[18019, 583, 119, 3, 70, "ExampleDelimiter",
 CellID->113],
Cell[18141, 588, 374, 13, 70, "ExampleText",
 CellID->13063],
Cell[CellGroupData[{
Cell[18540, 605, 206, 6, 70, "Input",
 CellID->4591],
Cell[18749, 613, 328, 11, 36, "Output",
 CellID->135375340]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19126, 630, 223, 7, 70, "ExampleSection",
 CellID->29761],
Cell[19352, 639, 251, 7, 70, "ExampleText",
 CellID->13370],
Cell[CellGroupData[{
Cell[19628, 650, 330, 11, 70, "Input",
 CellID->26124],
Cell[19961, 663, 2551, 46, 70, "Output",
 Evaluatable->False,
 CellID->491585774]
}, Open  ]],
Cell[22527, 712, 120, 3, 70, "ExampleDelimiter",
 CellID->8007],
Cell[22650, 717, 361, 13, 70, "ExampleText",
 CellID->17584],
Cell[CellGroupData[{
Cell[23036, 734, 445, 14, 70, "Input",
 CellID->10951],
Cell[23484, 750, 86218, 1439, 70, "Output",
 CellID->64696334]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109751, 2195, 233, 7, 70, "ExampleSection",
 CellID->14489],
Cell[109987, 2204, 229, 5, 70, "ExampleText",
 CellID->30412],
Cell[CellGroupData[{
Cell[110241, 2213, 470, 14, 70, "Input",
 CellID->14855],
Cell[110714, 2229, 158, 5, 36, "Output",
 CellID->529814832]
}, Open  ]],
Cell[110887, 2237, 120, 3, 70, "ExampleDelimiter",
 CellID->7093],
Cell[111010, 2242, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[111269, 2252, 278, 9, 70, "Input",
 CellID->25402],
Cell[111550, 2263, 1367, 41, 88, "Output",
 CellID->62132494]
}, Open  ]],
Cell[CellGroupData[{
Cell[112954, 2309, 407, 13, 70, "Input",
 CellID->13543],
Cell[113364, 2324, 1751, 50, 99, "Output",
 CellID->102233401]
}, Open  ]],
Cell[CellGroupData[{
Cell[115152, 2379, 134, 4, 70, "Input",
 CellID->6266],
Cell[115289, 2385, 161, 5, 36, "Output",
 CellID->124759895]
}, Open  ]],
Cell[115465, 2393, 124, 3, 70, "ExampleDelimiter",
 CellID->63845401],
Cell[115592, 2398, 266, 8, 70, "ExampleText",
 CellID->77807631],
Cell[CellGroupData[{
Cell[115883, 2410, 212, 7, 70, "Input",
 CellID->465489791],
Cell[116098, 2419, 449, 16, 65, "Output",
 CellID->696656215]
}, Open  ]],
Cell[CellGroupData[{
Cell[116584, 2440, 218, 7, 70, "Input",
 CellID->6920919],
Cell[116805, 2449, 449, 16, 65, "Output",
 CellID->253844376]
}, Open  ]],
Cell[117269, 2468, 125, 3, 70, "ExampleDelimiter",
 CellID->237361489],
Cell[117397, 2473, 373, 12, 70, "ExampleText",
 CellID->481972054],
Cell[CellGroupData[{
Cell[117795, 2489, 193, 6, 70, "Input",
 CellID->890175076],
Cell[117991, 2497, 449, 16, 65, "Output",
 CellID->272238738]
}, Open  ]],
Cell[CellGroupData[{
Cell[118477, 2518, 496, 18, 70, "Input",
 CellID->42817944],
Cell[118976, 2538, 449, 16, 65, "Output",
 CellID->155330471]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[119474, 2560, 327, 9, 70, "ExampleSection",
 CellID->19472],
Cell[119804, 2571, 381, 11, 70, "ExampleText",
 CellID->23407],
Cell[CellGroupData[{
Cell[120210, 2586, 190, 6, 70, "Input",
 CellID->22494],
Cell[120403, 2594, 210, 5, 70, "Message",
 CellID->62197565],
Cell[120616, 2601, 295, 9, 36, "Output",
 CellID->565440996]
}, Open  ]],
Cell[120926, 2613, 389, 11, 70, "ExampleText",
 CellID->20383],
Cell[CellGroupData[{
Cell[121340, 2628, 185, 6, 70, "Input",
 CellID->14262],
Cell[121528, 2636, 199, 5, 70, "Message",
 CellID->119157271],
Cell[121730, 2643, 277, 9, 36, "Output",
 CellID->20744654]
}, Open  ]],
Cell[122022, 2655, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[122146, 2660, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[122452, 2672, 352, 11, 70, "Input",
 CellID->25838],
Cell[122807, 2685, 272, 10, 36, "Output",
 CellID->101707287]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[123140, 2702, 311, 9, 70, "SeeAlsoSection",
 CellID->16339],
Cell[123454, 2713, 505, 17, 70, "SeeAlso",
 CellID->29427]
}, Open  ]],
Cell[CellGroupData[{
Cell[123996, 2735, 314, 9, 70, "TutorialsSection",
 CellID->10819],
Cell[124313, 2746, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[124507, 2754, 299, 8, 70, "MoreAboutSection"],
Cell[124809, 2764, 184, 4, 70, "MoreAbout",
 CellID->959330126]
}, Open  ]],
Cell[125008, 2771, 27, 0, 70, "History"],
Cell[125038, 2773, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

