(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    184661,       3836]
NotebookOptionsPosition[    177178,       3569]
NotebookOutlinePosition[    178538,       3607]
CellTagsIndexPosition[    178451,       3602]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"], 
          "ChiDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ChiDistribution"], "Erf" :> 
          Documentation`HelpLookup["paclet:ref/Erf"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NormalDistribution\"\>", 
       2->"\<\"ChiDistribution\"\>", 3->"\<\"Erf\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["HalfNormalDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HalfNormalDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HalfNormalDistribution"], "[", 
       StyleBox["\[Theta]", "TR"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a half-normal distribution with scale \
inversely proportional to parameter ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18718]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a half-normal distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[Theta]", "2"]}], 
     RowBox[{
      SuperscriptBox["x", "2"], "/", "\[Pi]"}]}]], TraditionalForm]], 
  "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", and is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "0"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " can be a positive real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->5927],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HalfNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HalfNormalDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->12294,
  ButtonNote->"12294"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131902066],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->103559996],

Cell["The mean and variance of a half-normal distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->12294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12054],

Cell[BoxData[
 FractionBox["1", "\[Theta]"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", "\[Pi]"}], 
  RowBox[{"2", " ", 
   SuperscriptBox["\[Theta]", "2"]}]]], "Output",
 ImageSize->{44, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10471],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->10428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10559],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["\[Theta]", "2"]}], "\[Pi]"]}]], " ", "\[Theta]"}], 
  "\[Pi]"]], "Output",
 ImageSize->{67, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22241]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"HalfNormalDistribution", "[", "1", "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29421],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82968069]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12033],

Cell["\<\
Generate a set of pseudorandom numbers that are half-normally distributed:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->26685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"HalfNormalDistribution", "[", "1", "]"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2098004026528264`", ",", "2.608183094761567`", ",", 
   "0.7809849808489933`", ",", "0.0987387202481789`", ",", 
   "1.4929788405153857`"}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76050722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32261],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->102762657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22860],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"(", 
    RowBox[{"4", "-", "\[Pi]"}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 ImageSize->{77, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2208]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22162],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "12"}], "-", 
   RowBox[{"4", " ", "\[Pi]"}], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["\[Pi]", "2"]}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "\[Pi]"}], ")"}], "2"]]], "Output",
 ImageSize->{97, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6878],

Cell["Third moment of a half-normal distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->11979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "3"}], ",", 
   RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1897],

Cell[BoxData[
 FractionBox["\[Pi]", 
  SuperscriptBox["\[Theta]", "3"]]], "Output",
 ImageSize->{21, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6538],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a half-normal distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->14469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30783],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"InverseErf", "[", "q", "]"}]}], "\[Theta]"]], "Output",
 ImageSize->{127, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17540]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18633],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"HalfNormalDistribution", "[", "1", "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->419969713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->431724658],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->18135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "x"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", 
     RowBox[{"1", "/", "10"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12258],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxkXQVUVE8XX7qWxu5uxW7v2Ird3d3d/u3uLrCxu1ABBQQJQWVhAQlpUASk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   "], {{{}, 
     {RGBColor[0.33397672886244, 0.127928553458457, 0.586425011169604], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVUlsTWEUPo/e3vte73PvbRdWQqXEPNYQiQ0iJGJoKEIEtULowoYQjSFB
RCkhkiKiLUJ1hYi8GFJtRGJh2IiFqWJlXBAxfZ/vLE7uuef/zznfGf/q9Vvr
tvQzs0ug/qAzkdkbfCm7ljfrAr0F/ycz+w26EZpNScymgU4HZq8LZo3gS+B7
89Lh/V2p2ZFKsxPlZidh7FnObDDkLZAfhfxCuWzR/nV8z0N+HPIuyA8DQz2+
S0F3YfceaAF0G2GjAdQHfgP0GkBtoez3uN8LrjPTZKMWtppzsvvA7RDTbfDj
wH8A/m2JfFBWcl36eWfKxUj4iInThJUxpib/xHEnp7w1OE9M5JnDqMrsJi5v
BL8E+VuYyV6f+3jjmOdEwk0Z48w5zlmRcP2AvenAGbAW+BJANc5Xwl4daAzz
gMNTgerYjbgmJfr/Dt3J4MsgzwPPbehu9/p2eizMTS9oleNq8vjbQ8XImD7D
5s5E97q81swHiXFknq933j/Uoz5zQhwdobBNTYSJeJ5CaTQwteCsI1LMrAv9
lFfJ1wQAXFeBOHG2F/f2g8L+0pkZqi4vgK21qD5bFZvdh909ofy3ud9B6K8B
A8yeA9z5SF/2TA3Oh9E/+KZQemVUgJ15mc7WgO/N5Psz7MRFxdvhPv5fhywo
SB7mhZU22TstjnM8YtqCC93gg1g9wX4ow51d+B6A/GeserPWlO0G5eBgRKi7
tPMNGD6Bzkaq/zLvAcZ00uMK4OtKqppGsLkcdwqwsynTP/lRoewynysgK2Xy
x5oMiYU7yCsvp2DnB3weRy0u+p5g7dk/N7wPGHuEHOdBD8tUk3Ox6sKe4T1i
4zzOjdR3UyGfBhqEO0dR9zup8sB90uM9OhZ4xoE+QKcx0wyw/xk/Z489xnx8
8ZxQj3ngznmQqvbMTRG4BhZ11gwbx0BPAu2k9wXNYqlCOrzPvdAZaW/0eX8z
3nbI2iLFVQsbExPNH/NFjOzLl7C5Hra+gN+XaBdwDwzBf7Xnc2iof9b3F+7O
ynR2MNGsck4vR8LFvTS/UnZpczFkS0BPTfH2+g7cATsfcacVemvBj091bzZ3
eIV8zgefQ12Gs+fg6xDocaB9yTlr9t3E3Gb+Pes8dxv/OeOMn3lgnhfhsDxW
TxEf9zdrSnuL3WYdYlodaz54h7ue9zhDrV5HvhuvCtoFe4FrP+gRsB0E9mKV
Zpd9xC/jPQJ7Xyule83zwJ4hLtaJ+4Rx1vhcc8czp//3PGzWpnorZiR62/iu
ce+W/E1YmmluObPsBfYu+2EhZPWxZncR+JWxZuVqKtzEfCtVfpnbTu9n5qqU
qv/Ye8TY4Tj/Qra5SvPQ5O8d3wK+D+xFvhEXPS7mnm/mx4IwMY/1nmfWe7n3
BueMe5Sz9g9hKwuP
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtI1VEQxsf0PrwP//fvXbQKNCoqyl6iEbTIonKRlpQmRpS1SjGhNgVi
VEJG9LiVIkQRpREV7YqQm1SCRNCixyYIamOuJDPoQWa/r1kMzJyZM9+c+WZO
eevhho45ZlaPFCH3Mmb3kVcRsxbsxpTZcGjWFcNfbDaD3ps0uxk3e8RZAf4t
nC1AX4TswX6BfQo9RvwvYjdiz1dsoefaTUx3zHMaWG1Zsypiy6Po+N4Sk8OX
4qwd35GE2bwCs2rsS4HZReQMV99QYzPxT4k/QXwE/wb0P2CWY5chV0vNvnJ/
jNjN1Dw3bfYB+x35+nj4bb2FGh6C/QB/B/c7Q69lFIziErPfYHDdXtKgGnzT
2P3mGFuxv2MPYS/Evky+H2AOkusO8g19GrmOPgLmKmofBb+fhH3IAPE58G+B
d5eYKO+NZL33qrkE/HSJ1/oeaSX+I/nOETsF3jB38xnvxTHulFHLcu5PxL2H
3cSuxN9A/krO0vjySc8lDh/je4K85v4h7s/iqw2dyyL4akdvQxLo6zmLkn8b
9mL0pcjz0O8o9iT2J952Acwacl8Bs5r3VgU+WwNgTCacE3Ghno9j57A3xb0H
mp29YPTEfIa+YI8jg+hDMceO4F8S8xo0e5by3msGK7Jes2pVD27g+1nqXIhz
YU2A+SzimOIqR/1DcedsDbVWBs6Nau4MnCNxk+fsaOAzo1lRDnFxALsx6pxU
Zrzn6rXOVgf+BtUuztdirwu8F5qpKc0nomdoRs7i6w2cS3GyC8fO0GdxGTkm
iT2f8lm6Rvx+sCvA3B51jrULLSnn4v9O8Na/oe+qMHrIfTpwrrXj2q3aUp8l
7dgKch0kZxO5diD50HdYu6udHcFfl/W/QDs4hr8IvFihc9aE3Rx6rZoZ1bYv
6blUo3Z9NvBd1s5rVj4nvLeaGXF9POlvE+farYas/yXasbrQ/wj9DZoBYdeH
PouqQVx2ZXz2xKl2tT7rf4N2dibpf4T+Bv1J/wA1iaRP
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.41509818658732, 0.268976860375372, 0.700451033508812], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm1MVmUYfoD3PcA5533POe9ba/1JdP1zYqkzrKS0D0MKGqJAZZm2WqHA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlleMFWUUx7+9u3fL3Nk7c++aqA8mQHxDQIoICCgQBBYDCkhRUYTECgsx
JqALxkhRIKFjAylBI2CJElYQF12UooIxkRejPuCDFDU0gyDC6u/Pfx5Ocs6c
Xr/pOHXmmKZcCGEzUAVcKIfQLwqhrTKELbUhdG0IoQtwM/TAmhCuFkIYUgph
DcKVfHsvDSEPfweyu6pD6BCH0Bn6RK11TiLbNwlhXT6Ereh3hDeRb13Bf0Tm
D/Ar6FRhbzvfLuD7VWIYltnrBG8mMnfCO8W3c+BngTpiPQy/G/bGQXfJ+Jdg
XEanssr+HgIfg8xVYpkF1BVDqAUW5yxTC//pknNTPL3Jrw3/z9Ta5wrwVeT4
IfJD+FaHrcXk8z35tECPAB8JbIKGDNXw50J/nnNNmtH9u+xavs23M+B/AZug
F0B/hL/dyLSRy06+DUT3LmA99nAfisR6E/I/QBwh3p+I9w7gY/CT5HM7srcB
+ypCeBOdA9jai8092PoWmweo5z/IL8xZZn09Nvh2HfpNyp94F6B/JG//T6C/
BP1F6C4ELiG7Dv+NtY7xevTri45FNk7Dex75+dhvIZ7p2PsPe52QHQv0hd+n
7FnRzPwbeybUG9W/XvVEf23OMZ8ru0aqzUbo8+DLYttWzVQL5ajcVJMKeCOw
txZbeWTGw5uLvTnwZwNXiH8DOveg+yX0DnitqXH17yLz0jtx7d7F3hfwVkAf
hd5f7dwvR+63arAocc9UK9VsKvgvyCyFnkLMr8D/NOun5I9Tr1uyfZhPfAOQ
7V92rIp5V+oe7Mzqq9m/GNm2duCz1DPXksVfTb6jyfc19Q4bg5EfVDauby8i
+xLQUOcdaSp5R05l8zwe/VENzm0GOtvo5faieyM6xVZS9ry3820PvNaiY22C
f5rYVsMfir3fmKcc9kaWvF/K6V7w80Xn2hl/JerRADTnXZ9Hqdet5DQb/BHg
SfAbqFGH4Jlbie0T+DhW4X2bBH9i6tnVDVkGfx70O+gOgv8Cugcjz9IkYF7B
M6DePwd0x3cv4HV027Axo+QbpF3XzutWHS05XvVoQsk3QXzdqMex9ZjmDd3v
sL+04B3RbrysHoO/FXkXp0PPxNdw8v8Z+VZ8fo2tw9hcXON7uBr9S2XfV+Uw
BtlxRd8L1fNY5ByVm2xsRX87sDvnmmiWOsa2pXjlq7HoXkl+NP5HJb5FW/Af
iK898T3TTm6IHLNiVU8GwOsPQF67ObPAf41sSzMwAdl6akxI13bqWfgns/4o
Jt26s5FjVw4xsmfL3t2YmMaXfMM1f7rRfRLfaO2/+jkM+u7Et043tJn6NGPj
k0rfrJ6Jd1S7qR5ug/9B6rdB/qrxnRbdG8XYA/n9kXutmzSZeo1NXAvtxKHI
M6NZ0ZtzlfjagV01vkGaxRvrfas1k5r1zalz1cz3Ap9W8Cxrhldie3ni+6Kb
0aneM6zZVf2a4a3J9kU2lia+Qdpn3ZQ3qM1TqWdJM9Yz9c7I/v18mxZ7ZjWr
mqH7wPOx9137tQ/6gdi7eQU4BP1w7LdO92Av9MTYu60db4WekNG6AZqNWdn7
qhnRLRtR9u3WTasgnu6pac1PO7EPLdmXbvoq9FsKtqX89Rb1y9577ezy2Dup
XVRPD9CrQ0XHphjzkWdGs6Ie6O3tU7AvxaPa7s3u9bUbju8Hs3x1kw5CT87y
1Q2qAe/Q4NqoRt+gezj1v8JW4jke+U1XfzTDekvn4H9cld/UkeCN9Zb9Hf1R
Jddc9nQjliS+8Y1Z/xaCz098q3WzJ+k+N7g+inE4uiH2bVR8g1W7gmsnmW7E
NqXgWzg1Z1vvZ/Mtm3q72iPXVvlrls5k+6aZmk2sm6Dn5Z3DxthvvN523Rjt
9p8l/1tpx9XLHqlnSz0totuU+FZ9VeN/P30TLv3/AU0QXb0=
         "],
         VertexColors->None], 
        PolygonBox[{{3082, 4435, 4434, 4441, 1838}, {4435, 3081, 1837, 4437, 
         4434}},
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443122, 0.410025167292287, 0.81447705584802], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnmMVEUQxptlmIU378282Y1GjRCBePxBJIIHICCHICxEEAyHBo0QEJEb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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtolmUYx++9bnvde3qedy9+EMpaEQRFgkVp0bIEcQYhER4+VKRMqdQ5
FTpspZWdNCq1KKWJlUJGmgaSoc20dOqcVp6WrgTxkHnK0uVp2e/f//lwwX09
1/G+rv913U/N2IaHJ6dCCC1QOXQ0H8K5QgjjKkJYwocLxRAuQScqQ+BzqEe+
vjqExt4h3NQrhKZsCBdzIaTQHQkdRD4BfgPnxdCKOITuTAjHy0JYg48ZyGdC
Fcg28m0C8gjHH5DELOQKsgP7afj+Dp17oxDugb5Ht4WcYmLX4q8W1bZ0CLdj
PwDqh/3zyM+S62b4teS3Ank1tvX4m5O2/A5iL8RHHfIfsLmCr4/gH4Q/Q4y7
kbckfBvyTnxt4I6dnPeRXxZf+/O+exaq4fwp8unk2g+6k3NrUp9rsTmC/Als
Wstdzxfg34X/GtvR8KfhSznXaiXUTLz38PEhseZBTeRfwt828t9M/nOR9cWm
D7rzkc9Efwa0h9x/KbdtIzatFfahu/RkfDfdaSWxvsr57urJDfiKql1L5a9Y
nyPf2ssxVyvXnGtxEv0+yB+hRyn8b0f+DbJ10LaUYyzgPD52L9fi40nOs3Wf
lHP+kv6sgrqQoxpOID8FHYT/DZ2JnJ+G2vG1E/1z6HZDh5CTahjB+foSveAu
Y8mhAd3JUA2yN9HJ4HR00fhRf1aq/tx/ELrN+Ksm92LBvn+Ebiu4h7r7MaiH
c03OvVLP3s+6J+rFAmg356tVxCHerkpjczC0qMIY7SD2FOwXpo2589Sru9r2
/bGZgn1j7Fx1x6E4uibjWqqmzcS/NWN8jCL+CHyfwedy5EuQP4P8WWgI8unY
j8JXMzm+Ru3y6M/h/FTs2qvmTbExMz/BU198PxcZS+rvJGq5E/4f+IHcazvn
9sizrm+PY/9Y7LvpjouwL0WepUllxvZWqLOX6zWOc3vRvHpQiX4+79x2QOfh
l8feBcJfI/pjSsb+bPTbkF/h2+yU90M3uudj9/4oNmlk16G/t7cxcBzZ77Gx
JAwd4XwYOpAyxrSr7sp6FjWTb+P/cN791Y47Qa4ni94tinkB20uxYx2G/5Pz
mdjYFAa1G/8qGHuy/4zAS/Oef82MsDEMfkC5MTI+5x2ker2V9q6LC66Fdt4B
fO+HSDF04r8O266cbeVjFfwo+BfTxu8FBAuS/aV5HJJxT9VLxQ/c5Wrs3LWz
N+F4H/xezt/29m5qKHp/qR7ale1QR6V35jByPY38C/x9TM49OWNSWNTOrkV+
qcpy4WEisa/mvavV8w7u9ndSH/WoDv3LVcbvJxXeteti7xPtI91lTex9pDud
LbhHqq18FOh1a9a7XPmp9/djcypt/1vQfSBy74RRvR0dOc++8PcS+lvwvxRf
9eSxrOCaqpbaCQ3YTo48mz18O4S/uoLP2qHTkE2N/N7o243Y9i94V+hbhH6/
gnevdlAXtZuaM5a1A2rhBxcdTzvyUfJ5ueRclNMYchuE/9f1fumN1XtQ8G5C
LezE1085v2/C8JBq11h3Vw0uI9uc8azIxyBqtaNorMlmfdY1VO3UY2GhLeu3
TJgYiW5VUi9h4h3Ot2QcWztF2D6W8X4Uxjdl/Ibp7dKbr7dvWfJeSK63bXTs
u2iH7eK8Metd+TNUBj8wmUflNw/9uTnnrx5G+aQGxH9DPc3ah2x3Q3+Q7/Gi
ZfLfhezX2LOjmRd270v2sTAqrA6NjGXx+ncYnvRX/dOgxSXPhmZQu3Z4ZKwK
s/vJrSXjXaedOwvdV0velTeX+V/iYsazKPxuyfkNaU3mQbVsyvvf6P+aatcm
/0PCvGbjoci7XfEWY/9K7LdGb/oczVviXzMzD/7f5D0XntaR7+qsz9oR+lfZ
E7tW+mf5Dzthd0E=
         "],
         VertexColors->None], 
        PolygonBox[{{2753, 4548, 1924, 4550, 2752}, {2751, 4543, 1921, 4545, 
         2750}, {2657, 3538, 3537, 3754, 1337}, {4549, 3778, 3777, 3165, 
         1924}, {4630, 3376, 3375, 4629, 1996}, {3778, 3782, 1349, 3781, 
         3777}, {4426, 2753, 2752, 4427, 1831}, {3376, 4270, 1720, 2985, 
         3375}, {3776, 4428, 1831, 3074, 3775}, {2826, 3294, 3293, 3401, 
         1074}, {3540, 2661, 2025, 4669, 3539}, {2557, 4993, 2405, 4992, 
         2556}, {4594, 2557, 2556, 4592, 1966}, {4666, 3760, 3759, 4664, 
         2023}, {4670, 3776, 3775, 4668, 2025}, {3917, 2764, 1444, 3919, 
         3916}, {3542, 2666, 2029, 4674, 3541}, {2664, 3542, 3541, 3783, 
         1349}, {4420, 2751, 2750, 4421, 1827}, {3962, 3663, 3662, 2799, 
         1478}, {3768, 3771, 1345, 3770, 3767}, {2765, 3917, 3916, 3923, 
         1445}, {2762, 3909, 3908, 3915, 1442}, {2659, 3540, 3539, 3772, 
         1345}, {3760, 4422, 1827, 3070, 3759}, {3294, 2827, 1075, 3403, 
         3293}, {3909, 2761, 1441, 3911, 3908}, {3663, 3667, 1282, 3666, 
         3662}, {3404, 2735, 2734, 3402, 1075}, {4544, 3768, 3767, 3162, 
         1921}, {3538, 2658, 2023, 4665, 3537}, {2735, 4298, 1741, 4297, 
         2734}},
         VertexColors->None]}]}, 
     {RGBColor[0.573761366128786, 0.543537051903563, 0.909725354074159], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtl3uQl1UZx8+yy7K87+/3e9/3t85i1sDQepnGogvOYDijCCLoiDH1F6Ym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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwlXMYx3/3djq33nPe877vvVRjqaEwBlnKNGXQYhITwl9lq1sZW9tN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         "],
         VertexColors->None], 
        PolygonBox[{{4188, 3652, 3651, 4187, 1662}, {3033, 4340, 4339, 4346, 
         1768}, {3031, 4345, 1768, 4344, 3030}, {4340, 3032, 1767, 4342, 
         4339}, {3646, 4415, 1823, 4414, 3645}, {3020, 4332, 1761, 4331, 
         3019}, {4353, 3031, 3030, 4351, 1772}, {3507, 3755, 1338, 3757, 
         3506}, {4295, 3922, 3921, 4296, 1740}, {4042, 2840, 1528, 4044, 
         4041}, {4337, 3020, 3019, 4335, 1763}, {4327, 3021, 1760, 4329, 
         4326}, {3022, 4327, 4326, 4333, 1761}, {2841, 4042, 4041, 4047, 
         1529}, {3502, 3501, 3500, 2813, 1067}, {3652, 3907, 1439, 2760, 
         3651}, {4194, 4192, 453, 2765, 4193}, {3067, 3507, 3506, 4416, 
         1823}},
         VertexColors->None]}]}, 
     {RGBColor[0.633404408403906, 0.639366824986648, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtl32QVnUVx+/uPi/Lvc997r3PiiKYAfLSTIm8lTPZpouKDo6OYAYh0rIs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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uMVdUVxvfM3LkX7nndewcFS4sooCZWRKSRaq2ABc2ojWKtyNthkCgV
U0E0pCqjPFKjtS3gA8QULKBAS4WImTH4qEoEEUetWpRHJYqKgBKjBNHa39fv
/LGTvc567rXX+vY6J7XcNHJafQjhY1aBNaMWQrkawvTGEE7tEsI+6J5ZCFMQ
+jP02EoI3fm2vRTCERSeTUK4shxCL+TnQa+Cfxj6FegNxRCGw+8Th7AC3gDW
2dBPYX8W+t9h8xi2LkD+5YYQVmO/BdkWZIYg+5wW+78jPwP5+dBriGU164m6
EBJ8FNk/jP4U6CuwUcF/K/QweGfhv38UwhfIPAmvB/6eZr8x168hU0X+euRH
sB+I/G/xtxh/k/D3A2TGN4UwocnnPZ781Cs/aQhbiaWDb3XQgfUItjfh43t0
S9g7mc9vIPMd9o9D/wXO9hEy3dm/T0z72P+Tb0vYn4LP3shOZ70HfXyTeZLZ
Dn2g4tzugR6Br5vKju0SYj4Z+jLoffiLoV9Hvor+c+j/B/nd2M7IaUZsQ1k7
4B/F3j0Fx1NAv6Hms43lWzd0j8H/tOiYP0P3Mr41dA1hKjLfoH8+Z+yNrXrW
x9jvGvludcebE59R8Y+G3xfb7Xz7BN13ydcZyI6GPqfe97EEWxV8VJBthX8C
/O3cz2mKjbUB+hn4b8Kfhf1roN/B5hzsj4L/L87ehL0l7F8jJ1chuzGvL8X8
OLxVrA/qnOMFnO3bmmttnWpaurHvbgr8VvZvcL/N5PIe3Tn77qxKwT5qnK0z
cm6V4w58tVddy/L5R+wNKtvedegcQ/YC+F8WnC/V8l5i2FV0TS9ivzhyLD2R
+Tp1zyifk4nhIPJHOcdxwTW3Gt465F9E/gjrNvRvrfjs/69J+Ovxfwhfc6D/
C72VM+1ocD8p10uxeV3JOV8GvZz1BLbewcYa9mtZHfXO2YP4mltxbJK5F3qm
MKDgmr+LfVvFuos4U9eqMUTYoZ78C3f5LGf6kv1OzvNC4hwqd6MajA3D+NY/
r587kZ2dut6VY93tnxLnUvkfir0LM2OPcnIzvqdX3GuKob/yj/7BgnPUr+oa
Vu0mnHmbclVxr9wP/5fkalJqLFEPPYL818j/EFuTS67dqfCbGl3DfdHtx2ou
ukbfKruGVDuZzqB8Qt9cMKZNg9+Z15N69ii5+abmXA0IruVv8bmw3jUd0L07
ci8WWVdx1l9njk+YNafiO9NZF2OjC7zBfBtbNGZfjr/fpMY2xbsZ2Zdj95Li
bcR+Ie9H1Ugpcg8r97qDIeynsS7N6U+x99fE2KR6EFadjv0PC+6n8ZkxUVi4
Fp894Z8If2fBNdIf/XHEd2fRGHM+/PrI9SAMEPZ3K9ue8nWHaiczlp9NPsaR
m/FVY53q9WJkz4Buwt8s7J3FfmBOqwcXcta7sD8Ge+3Iv4r83fgcl+dzO/R8
6InsSwX3/gziu6/onp0I7yXoLUW/QXXQbYntSb4D+b8lxiJhUjP2+pXd36LV
m6cQT1py/f2Ks3RDZxD0ykZj81dV1756YB7yDYltK6ZW9pNYI+uM2X2RPRS5
dmNWJ7HNjVy7ncR4PbnuUzO26s7fhB4aG0uVs93QDxLDu43GbOViQezcKCfb
Yr+5wgZhxAj4Hdifnb/XcyLXpHIn+VXYao+cn92NfquOVo31wnzVemf+3qjm
dRf1+fmUw59ExiT5U37vRXZZZmxQTQyH/xj0rvw9DtAP5PEfht8MPTTHC9Xo
8JrfbPXWIc48k/3jZdfOlfBr0LPRub1oDBcWPYq993N/f4B/f+Le1Zut2toY
u5ZUU/K9MHPuFMNF2O5T9V0IU9QrN5adO8XzM3h7MmP9j5DZhL/21G+dZpIW
9q+XXQvqadXWmWXfh/KzAf1/sK6Gnlmyrydj15J8Lop9J+Py+m7TPATdzvm2
YG849t8uuxeFkacrHxXPYsL0lexPTbxfz7dd2G+OXY9Lsf87YQsybxeNNzdg
b29srBAGtkJPSI2fWaNre3LqvWr888g1q1jVAy3sr626dwdqpoJ/ReJ6ESYN
gHdm1b2sfKtWl3Gnl3dxvjWLTI8dm2YSYUXffF4SZvwc35vy+UA9eB70T+EP
Zp2bGqtWxsYWyfdC/0T8dSn5jRBWdUv9fgizhsTuIfWOZsAJyA6L/RYo/gXQ
58aepdQj64RtmXOvO3hM+Jf4Pdcb0Af+6MizimboFuiRmfu3Dfkx+Bqbej5V
fT8Ery7yXt+WZ55R1QvqCeX++ci9rztYmnnm1ayrmtZb8FEtn9X51obs97H7
VxisXojy+VU9cTv6KyquBc3sy/U2ZfavO9CsLwwXdmsGHhP5zdFbozfwFnSL
qd9mYahqZXPk2UM1o9w+EPmtUo41i26rerYSRlwYO8fKrWYSYel5VfeO7vO+
xD2tXm5lbUmNEcqHZvY7oN+C/rDof5C10GtS95969jVi7RG51lRzPTjPxHx+
0Hn0LzIwcS9rftPs94uasUT4pbvslfit1p3uYH8k9WwmjH41NiZdmuPnEc2X
+fysnroIWxfXfD7NFHX425nP/5rB1Yv7y35b1ZPS/Xfk2Vw2VKuqMdWWanY+
vn+fWlc2EvVa1W+77mQruuurxg7NmIc1G+Xzqmaq/Zp/Iv9LCGP01q3IjOXC
dGH7tfn/l+iXIr8xeluECb2xfSDy7KmYRiH748j4pnqdh+zc1PErRt3N84n/
3XRHD5GvSRXXvnrgf1ZL4MI=
         "],
         VertexColors->None], 
        PolygonBox[{{2821, 3788, 3787, 4004, 1501}, {3385, 2995, 1146, 3502, 
         3384}, {3665, 2802, 1481, 3968, 3664}, {3211, 4088, 1564, 4087, 
         3210}, {3223, 3464, 1120, 3463, 3222}, {2596, 3643, 3642, 3383, 
         122}, {3198, 3514, 1156, 3515, 3197}, {4318, 3198, 3197, 4319, 
         1755}, {3699, 4320, 1755, 3017, 3698}, {3701, 3703, 1306, 3702, 
         3700}, {2642, 3517, 3516, 3704, 1306}, {4647, 3699, 3698, 4645, 
         2008}, {2801, 3665, 3664, 3966, 1480}, {3788, 2822, 1502, 4006, 
         3787}, {4195, 3223, 3222, 4192, 1665}, {3780, 3784, 1350, 3786, 
         3779}, {3517, 2641, 2008, 4646, 3516}, {4323, 3701, 3700, 3018, 
         1757}, {4001, 3211, 3210, 3999, 1500}, {2865, 3780, 3779, 4089, 
         1564}},
         VertexColors->None]}]}, 
     {RGBColor[0.693047450679027, 0.735196598069734, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuwVWUZxxfn7Ms5e6+191r7HASBlIumEgqkOAqIgiBml1FS84JQVoMm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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGlwVeUZx0/ITW5yzzl3SyKQMMqmLFUWBaoQARGVwrSD1AXFQuvYAtqp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         "],
         VertexColors->None], 
        PolygonBox[{{2769, 3300, 3299, 3335, 1033}, {3300, 2768, 1032, 3333, 
         3299}, {3523, 2646, 1314, 3718, 3522}, {2647, 3523, 3522, 3721, 
         1315}},
         VertexColors->None]}]}, 
     {RGBColor[0.752690492954147, 0.831026371152819, 0.913804387056535], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXvc1uMdx3/P03167vv+3adnbSI2hEooRJSeJoZUTErhccpeisY2Qtq8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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVdURxu/Mm7fwlvvufVMoKCQqqMyAIgLKPigaFBliWGSRUSNarsEk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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.861883, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmQldWVx193v/f69dvf11EGFRTjAioiJrIICHGMI8OOCBEQiIhAFGgE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeYVOUVxu/uzswuMztz594NEoSlWFaaUiyAuFmiSCT0riICUlXK0hbB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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.86083075, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmge0ldWVx79377v9vvvu+y5NaSpSFLCAgGg0MRrLSHyCdRSlRB5FUcEG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVNUVxt90T8/0vNcz3f2aTWQRkE3BBWQARcuFRcLoICAiEBAQZF/E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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.897607, 0.8460412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmQlcW1x/vOKNxvZnSGO8kA4jNJGd6DAVQi4JKUFZQZRbRYZAyDGlmV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmuIlVUUhvecc5z55jvf8Zy+IzM6WiZo6ThSXrsQUmKjlqKZY6KYaTnq
6GhC2qiZVmojRVkWWf0pDepHhuC9kkCDzD9WOoGleOkCaWMRY0Qp9ry8Pxbs
tddlr73Xu9ba/eYtm7o0E0J4B8pBN+dD2JuG8Ek2hBjBC+UQZsUh/I2stTqE
o8UQatHJIutCJymFcB/8UPh6HJxCtxmbAegOqQjhn+4htMFPhN+IfoT+Qnzs
6YZ+ZQibkfVirxH7V9Hpwdm98TGF845JB9+H2PsP2xp0TmLbl71q1jvZewnd
mcjjiDjwdwj+zySEy5y9H3oDfgHyXsgXI+/Afi1716pCqIC/DL8Bvgp5LXwr
vlcT01RieRf7Fvin4MfC74K/iP7gvGMZBZ0u4Bf/N2I/B/lkzv7hhhDexv9c
4utAdwH29dW+4yTkj8HXwM9G3oLtIqhPZB8jkQ2XPrLOyLbTiK8z2MdKdFdA
g5DVQ2t53+qS3/I2/Legvxz93sQyEv0TxPt90XfVm21BNgf7IrbT0OmPfkJM
p+F/hAYju4mY57E+zR2Gww+DLrD+CWpIrSPZGWgg/sZzfgv+j+P/OfjB3D9F
lsHHJc7+o+i3rUXeD/kMYu5Gblu501x8vRY7lhT9C/DnoZXwr8CvR5ZB/wjY
Os+b9JQub35nzhg9xVlLiX8b570FzUuNOWGtR+S3zmMzMPjNR3O3B9kLygc+
tuuu8HXwP1cYK1vR7xkZM8LSqIKxLUwtRHdK4tw2YLMG/n18XMdlU7WxfiA2
VoR5Ye1f7D/LGXNNxNYVG9tZ6APOy2Hfhf5ufH4FP1UY5Oy2yLmeDd8eOed/
cfat8M2Ra+I48m+hdfBNvO8R1l+mzo1q9mPWKfqzkM+UTcEYFPYU06q8MS+s
P58xFoci74qMyQbetx66mnFOV3C/xejXwzdyv334219w7tvxMb2776i75aD2
xDlXrovyDxYWQCcq3AMeQbcjcW6FiZOsTxHD5shnCIubEte6MLkR2af4exPd
u+HHE88D0HXWzegcjK0j2UF0DrDen7oXCMN6u5Hwv1T5DR+Fb4NviHxmL2Kr
g17mbRqzzsV3yNdHzslZ1udSY7MvPscgH5G6Nlaw9w3rK8R7PeucqBfeRUyD
gnviOtZ16hHYDodGIz/M3ucVfnPZjii79uVDtTUOWlTpGtP6d+KrqfTeQHR7
YtMn65oYCn87dE/GNd5EfMdSY2sye/3Vf1LX2iUoi7wzde6FwbHYjoOuIXsc
mxzrbNm1sYu95eg/nbr3bIX2lpxz5foL4tkDvxOdwxljpgvdLfA7MsZwIXHP
Ua85Az3T3T1MvUszpQOstaKzgbM/5D5Hsf86dS2opz2Mr2l5Y+1e9YzEPU+9
Tj2jKXaNqjbVMytLnmGaXcJMDfprNdOqXbPLEvcQ9Q717FtU72WfrR6s3nIR
upJ1j9kRuwaE/TWc9wTr+WXXlnrMNnyNTowd2byXd49QbxiD/KxqoWhsCgPj
kZeJcUrGOduEbjvUhv7ebp4922OfpRl0InXNq9aFyVms67DfUu0ZuBP+2diz
VzUvrI+Cfq0y5hvL7oHqfcrxHakxLOxKZ0DZM02zTDOhGfn81NhRTxSWf0s8
+4XpJwvOqXI5CZ8zUs9IzUbN1Pvx91BiLKmmzqN/rmDsC7MTkF+FP5RzDas3
tBR9d/UI5ao28V9EOdMs0IzRbNFM0KxekjcWNLPVy2tjv7V6+kfIMmVjV3+K
iWX3DPUKzQC9/YSS/wbKwerUGBe2h0R+W/1R9DfRG79Y9p9Dfw3laAmxTS/7
7sJsZ9EzT7NONaraHlZ2ranGddfXY88m3Vm9Z1Xqs9SDdnPevpJrSTWUZx2X
3Dv1x/ofySgvlQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{178, 162, 163}, {149, 165, 164}, {208, 224, 223}, {209, 
        193, 194}, {208, 192, 193}, {191, 207, 206}, {327, 289, 210}, {190, 
        206, 205}, {289, 290, 224}, {367, 290, 289}, {207, 191, 192}, {206, 
        190, 191}, {207, 223, 222}, {367, 401, 290}, {194, 210, 209}, {204, 
        220, 219}, {367, 383, 225}, {192, 208, 207}, {148, 164, 163}, {206, 
        222, 221}, {205, 221, 220}, {134, 150, 149}, {179, 195, 194}, {178, 
        194, 193}, {177, 193, 192}, {210, 289, 209}, {192, 176, 177}, {165, 
        149, 150}, {401, 367, 225}, {194, 178, 179}, {150, 134, 135}, {179, 
        163, 164}, {164, 148, 149}, {180, 164, 165}, {383, 367, 327}, {195, 
        179, 180}, {193, 209, 208}, {327, 367, 289}, {210, 194, 195}, {163, 
        179, 178}, {220, 204, 205}, {164, 180, 179}, {221, 205, 206}, {222, 
        206, 207}, {223, 207, 208}, {289, 224, 209}, {162, 178, 177}, {224, 
        208, 209}, {193, 177, 178}, {176, 192, 191}},
        VertexColors->None]]}}, {{}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[LineBox[CompressedData["
1:eJwV01tMz2EYwPFXzFA5lOnA0CaZ2Bwq3LQxZ5pTYc6iJBKGcshZmNmcNi6F
DZuuUDFusDncOBXLLGKzOR/GZrjw+V18+77P8z7P877/369fWmH5zDVtQghZ
/sR3CiE2IYQjsSH85IW8kTehAuvEW3gzKrFI3MyNcSGsimoTQzhrRoX1Gd4g
LrXu1TmEwV1CaJCrlPstLtR3TPwvPoRJcpMxEVMxBbn6xvMEjMUMZ4zju+pT
zUpBMnLlT3ULod6sD9Zr0Cwu5xc8jaejRG+BmhL9+bxC3OSMPLxzn5SuIRyU
S+X57jYPh9TtlzuA6ui3OG8FVqIEHdR2RJX+bdiKJPPu2avT+965o7hYbzNv
R625CWoucZH8crxTNzJ69lgizhP/dc8/qJJrMu8ZnqKP3kZOlK9W11ucadYg
DMYd3MZ8+3vMau9+Q9RfF++Tv8Zl4le8mls41Zwd/Np5rUgRZ+hN5gGcL5ds
/6r+vs57ri+Nk+xX2e/BC+zXyG0Vn+Yx4iQUis+IP1u3tW6HGFyQGyfXE93N
3W3mT+sCz3A2rrp3HS6jVu0V/s4DvdNByMQu9TFqd0bPyB3mWM9FmviAOF39
eXEnvbEYLY7jbL8nB9/U3FT71voG17tHA4ZhOLIwRs8IzkE2MsQ/9H2PesUD
xe/dPZM/8Fy5vWZ9sf6Kj/iMT5jg7IkYYH+ZZ9Cgp97Zdbgoly+ehero3UTf
mpoy3oxP0TcXPUduy2e5HZ/jw+7ygAvERVyM49H/OJ/gSc5MjM62fzL6pngI
D8UiNYujb17dc/c4ykvFS9DP3GFqbsnlRvXilfKlWIWX6tPl4+T7cTyvlSvH
bPFqcaP3VMZNnM458v15OGcjC7/Ej8x7jId4iieY6Z53+T7uYa17rDd7HZfq
S9BXY91q7w1a8BqvsEH+P8/roRY=
        "]],
       "0.9`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[LineBox[CompressedData["
1:eJwV1PtvzmcYx/FbTKoHtVodgrbUQrvoJISqkjkslkUpxmarMAstSo9CJTZi
84vDDzugWjz9TcJk6tBIbLNaZjaH2RCtOsUms1nGP0C97h/ez+e+rutzX9d9
f5/v8wz/qHp+VY8QwmofiZQQUvqEkIqitBCSaW/MfDmEmlT5vupIxmLxSPlr
fEV0lThXfoH1QqwX54izMRQrxev0qsfQfiEMQcorIXwrn0ZTsRtfYRduqB+g
i9SvW79HNzrfI+t/8Dce418cld/gHJv5G+h63MsI4T7uYrF8GU6bPZb3rfQQ
tkQ/elqf0Xun2g4cUh/u/LnIxjDkoEH+T7P+wgRxhT2FdIt4rxlT9JpmxmT6
BU2RT7NnmfUe9fOewQB7fqbH1VpxDJ3mz6E/yfdXb6eZdJs+n+GsOENcxVeN
GhSLe5n9EtaKv+f5Dp/yz3aHOXhkfSg+JzpAnMRb6jwV/OVI1+OEPafkymkH
3St/k7bbdw7zMB9/qGdFv/VJ5CAbw1AYnxdNRm8kocTMZjObsEl9rtzv8T3Q
4yodQl8zKx+DMUbudVRiuWe1Avvlm9GEx/wteiUwRb9+SNczT61R7XN3eyh3
kCbEB+hB2s0zLfppBgr4W6IH/8mXiBvM3IDDcgX6Z8mPkx+LI3ock//GfRp9
j03Yh2Ycl/9aPcm61fodngVYJV6iR747PFXPo6OQ0C9X/ITnf7Q5z6viDrNv
oRNb7XvgDLd5u3ALq3lP4221EbjNdwddGGn/XfquXnd4E7QF3Xxfyr8v1+5s
5/AD2vgfyufRVrWTOIU3xX3V96kV299E2+T302b8qFboXhNR6y71qEOpfYPU
zsf3F+XmVjp/BZ0qfiO+Q/bMRU93KI6/DxQhXzwp/tZ56+gT82rpU3oFv8X5
4sr4/Zkx06xfzfzQvgt0Kf2FdpjXzfscz+K7JP+xfCf9hG5GiP8/zrJbry7+
XH1H4IP434AyzNI/05wS2p9Wxd81/1r+PVHFa3AJF+O9+C7TK6hGDRr5aulO
vZeq76AFem2no2mP+F3JZ1nfdL7xtDzOi/8NGIhq8Qz56cgUrxCXWNfTWbSO
vgDVMbuI
        "]],
       "0.8`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[LineBox[CompressedData["
1:eJwV1Ftsz2ccx/HHKIIyWxC0C5mhB2dBrI0mtiVibVG1kTm2knKBoDrFspas
VP9txTbqlIjzsaZcYFkk3NjVSBxCXLQqDhsXhM0xez0X736e7/n7e/6/X/sv
WDptSZsQQok/6Z1CmNM1hNk43C2Egx+FcABHnAdgnXP2hyEs6RzCeJqFz1Gt
7rbYHQxiZyAdu/jruodQjxrUIoE0/q9xqUsIk/SamBzCPTNbkaKuLzaJV8it
xI/YgPUYruYmvYUb+PbjEL5BqR7fs1ejDJnyymkGXUuH0mx5Q+gWOtOuG81Y
5vzWsy2l7+gzjLTTG/oaU5xXqh+s7pX9itQV47F5b9lv8Bqr5JSiJd6f2HB1
Z+kw2svz5NGnMab2CX2o9+/OafwXaLKc87QrncjXJOc0muWd42+h/7D/Ro29
H9HH8XfCCPF5fI3mzaVpniXVviX2+YTO4C/EH3on9KmNv23cXW6Nc455B9j7
sRefsqvU9RM/Q5vQhn+7OdtQpWYR33RzClHAV4jp2MouESugf5l/DVeRxzdG
j7EYh2P2uR/vC/fQjDVyWmk5TZLz3PxMeQfts8/uh+gRmis2Od65PUrRU14O
3pn/Pu4oZyd2oJU/QWsxQE2yeHe+LOzWew9ScZe9l+43u05uPT6TPxCD4l2b
nRLvE6moY/flT9KvPcao36Z+Ox6IbRHbip/RQ88iNQvsWoT5WIhiNKkrUHOG
3pf3i/xZzpv4GuKd41c80rO3HhVyKtGFfUJ9Mj1JJ9vhenwf4veKo/iN/zRO
oRGd9D1Hz+NsfP9wAav4880r9swLcVOfjfp+Fd8tsWbzTurXiIvyL+MSysRy
+W7J+45d45zAZuTGb5jm0ZV65dNSmi4vA8fic/Mdp2XelWnOmfxT6RRcM/ML
+mX8HfgHxndW7iF3UG3X1SjHf/gXd+S/oC8xyXlW/J9AK+ywHhtQiePqTyAJ
HdAe2fb6iY6S/4E5y+WtiN+pXknsdmiL0eJV8X8PbaATaCp/P/THFfkrzP2T
NuuZcC91qMdivmo1Y9VspuNojtwJ6Mj+gfZGt/g9qO3j3ELr6WC7zPTs/wOc
m8Xz
        "]],
       "0.7`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[LineBox[CompressedData["
1:eJwV01tMz3EYx/EvmgkVkkNyvlDNnBKiKWQMF9aFnNvcNGbMhi2uDJUkQ8wx
6YA5bba2GhcOMTfOa92hTWGTITndmNfv4t3n+zzP53me7+/3+zd+0/b8bb1C
CFn+tPQP4WtcCN/wZ2AIv7HEecGgEOrVdieGkOs8MSGEHDofbTypNA3x8gk4
x3tycAhn6d4hIVQ5x8kfp8ewMD6ER/oeYqv5/QaEkEc75QvpTHEXzaAbo/3y
D3jv47M4nebQvWbNp6X2/DR/m/v9ot/Rgx+YpLYc9/RMQjb/PByUW0PXocme
AppjTy7WOw/zPB/0f8RauXa8w3597+U60I4t7rAZ6XYXY6wdc8Rz8dvc2fQP
zaKNNJP+otlm/aRF4hQ9n6K93tVHmiE3xqwe9dF0qvw0vHSvOvVa1KCZrwl3
3emZ2nN8MasL052fYoPaFL3V/PnyjfxfzJ1Ab9M7nnO62i21m4hxLqbpetOQ
rD8PwT16oZa/QV89/SyfynNeXCW+QM/TK/pP0zMYZ95kJPGO4z0kV44yVOAw
6vhLaClG8E7ARKTwn8QRc4fSSnqBN9OsE+IqJKFNfIZWqxWbsQeFvs0gzzgY
o9y7Q+9xM9O8i3QciH4D+CCfyNNJU/hizRom/iROoiMwHKXi5GgWBprzL9Y3
4S2J3rt9L3DDztf0FXapLbOnlbdAvtS5DCUYiWS0u+91mmB2Y3Rf2kxXyLXp
myvuY9ZLszp4X9G+9t2mD/kS1XdE3wt7kC1eI78hugfPWlpu1jqahlRck7/m
GZaYd5Uuje5AX+vttquV7ot+5ziAIvtq1C/hIupQizx9DfQy6rHIu1uIBvO/
6+nGTp4e+gNvomfhO8pzCpWIEffGKj0tPAW0zM4Z+h6LH+EvViIf7WY8Uavk
Wc27Wa7C+TDKo/9P9QHmvaWH6CzeeJpJy+hi+h8oBqs4
        "]],
       "0.6`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[LineBox[CompressedData["
1:eJwV01tMz2Ecx/GndCAhyZwuaCtdOJXF5rSccsFscmyYnOfCmIVcWE4VJhsz
cspWLsphGMbKJIY5bXK6Qg5dmDGGzUyY1+/i3fv5fr7f5/k9v9/6py9dO3NN
TAihpz8/k0M43j2EiVzEk7iaU/gYT+CnXUMYz0fV67qEkJ8awmQ8kS+XP5J3
41a9lG4hJGO0+oC8sXMIU+Sd+AMn8gSeyg/NPMA/9Qj1Em7gOvsT+JHz4/mk
Op/vq+/hNnLUv+R77K/hSm7CR2fE6o3jd+bm8xD1ZR7MhTwwKYSFegtw0N5a
71KDKutW2Tzrce7+2/wb2VjrMci0bypGWl/zrEv6o5w3xp4Mea58JYYhG0Mx
HDn4YbYh+h64gjn2T+8RwifOVH/Rz+CvPJDP82lnVzs7Xf1ZPYBP8zZ3+u55
BXrfuC4lhHoMMp8tO+vMM6hT1yMTGUgzm4d27/cHB+w56ryD3CYv5yp1ujOS
9Wujb4sy+SF5mrw/+jnrlfmN8kp5H1kwH4Nc+T79/eiB5+pDfNw5JeY3Icl8
rNlF3uOFfr56sXVvWZFvsggd5R3Ucdhu/2bZDs8K1mXRnZ2XGn1rc9tkMdH7
qTtwhf4urjKzzPMOc7msxbqZi6L/W6xAmt5szy7EY2ctlc21noML6it8Favk
qzFDFuucOOfHo83+RL4ob+TS6Heg/xbF5rPcv0Dvut5MLpFtQJv+e5xz5xt6
p7iZn7lfqf52zDLfJNtqvQUnzLTop/oWN6PfkGe9lhVzu7PS5D3x17rcfAVu
mdvNO1Fu9qX9vczclU+zr4D7Rr9FvqO+izx1stkuSPTuSbzee3Tie+aOuFeC
fIrZLC7Vq4/+H/T24j96PY9S
        "]],
       "0.5`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[LineBox[CompressedData["
1:eJwV01toznEcx/HfkNMctslGK4vNXGi7QFmUM3NDcmcO7ZRCphi5YIwLcUGx
pJZDs+3CnBc1zI1FdkIrNtRKIYtyXg8rXr+L9/P5fz/fz/f7/P7///NML921
viIphDDcx4ixIQylhvAyLYQNySG8okU0OyWEA64zJ4bwgb5HAW+0eqN+r3qm
OgfdvKm8djqFdtG/diaQPimE17wp9C1N4r2iCXN99CftpUN0MKL/C6nyz/iT
6Av6Ta+Tfo7fRz/SLjpAf8jfRDNuo51fOSGEfdiPB+NDyI3nxW71U/1+cwfH
hXBf77H6nevtejvQwsuRzcY2dZv+y/g8ZK64tyaU8Muw1vPr56+hM+SLeV3x
rHiC9bKltBhn5Y7Z3S07jB6xt4Z3BkfVHfx/rqv5m+Xz1Rl2bnK9wt7ldi1F
kTpPLzEmhC/uN1nvsJk0O1KRoU7HSOyVrUStvaf1esyl0FM4ibnqUfF77Zks
v0d2N97wqukRVOGPcySwMM5jmtksXEYdGuxvxGw7ctW1zlNPP8k20gE6izba
1RCfvfuowrp4dnoIN/hZzjFNdh4/X/66PbfszeYX8rMwh39HPZd+17+rn6de
Hd8B5vMXmC+I87iGezKtWMRfLPvXXDO/SX0VmXo1znAWQe86L4meUx/X+0rz
1S38VpTH5+C85/kX8JB3iV7ECflBmsAjfju2yafK1/Hq0cFrpA1oi78PZymN
mO3ETvkK9RIsQzZvJf1tbhB98R3KlNFyTNB/HtGr4G/l7aKrvLMe3hb3vDn+
r2RKaCmK4zPTL4z/C9n/HDyUSQ==
        "]],
       "0.4`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{2682, 4687, 2683, 4996, 4997, 4973, 4047, 4041, 4044, 4043, 
        2563, 4600, 4602, 4350, 4352, 4351, 3030, 4344, 4346, 4339, 4342, 
        4341, 2562, 4596, 4598, 4334, 4336, 4335, 3019, 4331, 4333, 4326, 
        4329, 4328, 2561, 4527, 4529, 4321, 4325, 4324, 3016, 4316, 4317, 
        4313, 4315, 4314, 2560, 4880, 3013, 4311, 3015, 4312, 3009, 4309, 
        3011, 4307, 3010, 4308, 2559, 3400, 2826, 3294, 2827, 3404, 2735, 
        4298, 3007, 4878, 3006, 4879, 4594, 2557, 4993, 4296, 3921, 4193, 
        2765, 3917, 2764, 3920, 4591, 3914, 2762, 3909, 2761, 3912, 4590, 
        3903, 4191, 4190, 4187, 3651, 2760, 3906, 2943, 3218, 3217, 3455, 
        3456, 3326, 3325, 3452, 2604, 4586, 4585, 3591, 2942, 3343, 3342, 
        3603, 3602, 3601, 4204, 4203, 3226, 4208, 4209, 4205, 4207, 4206, 
        3354, 2575, 3614, 3613, 4224, 4223, 3232, 4227, 2965, 4220, 2964, 
        3953, 2786, 3657, 3955, 3954, 4246, 3363, 3631, 3630, 3361, 2979, 
        3241, 2627, 2585, 3961, 3962, 3663, 3667, 2630, 2588, 4630, 3376, 
        4270, 2806, 3497, 3248, 3250, 3637, 3380, 4762, 2809, 3535, 3253, 
        3255, 3641, 3386, 4765, 2813, 3500, 3257, 3260, 3645, 4414, 4416, 
        3506, 3757, 3504, 2657, 3538, 2658, 4666, 3760, 4422, 4420, 2751, 
        4543, 4544, 3768, 3771, 2659, 3540, 2661, 4670, 3776, 4428, 4426, 
        2753, 4548, 4549, 3778, 3782, 2664, 3542, 2666, 4675, 3789, 3827, 
        3825, 2702, 3556, 3557, 3169, 3273, 2668, 3583, 3584, 3278, 3277, 
        3560, 3083, 3546, 3829, 3429, 4799, 2871, 3549, 3279, 3281, 2873, 
        4558, 3174, 3858, 3173, 4559, 4557, 3184, 4572, 3186, 4571, 3185, 
        4953, 3566, 3091, 4902, 3551, 3175}],
       "0.3`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{2720, 3447, 3448, 3131, 3290, 2717, 4170, 2718, 3859, 3857, 
        4147, 4146, 4145, 4097, 2872, 4800, 2870, 4798, 4463, 3106, 4438, 
        3081, 4435, 3082, 4440, 4897, 4461, 3171, 4555, 3272, 3581, 3105, 
        4908, 3558, 3828, 3826, 4432, 4896, 3079, 4895, 4673, 4674, 3541, 
        3783, 3781, 3777, 3165, 4550, 2752, 4427, 3074, 3775, 4668, 4669, 
        3539, 3772, 3770, 3767, 3162, 4545, 2750, 4421, 3070, 3759, 4664, 
        4665, 3537, 3754, 3753, 3505, 3159, 4540, 2997, 3986, 2814, 4766, 
        2812, 4764, 4284, 2994, 3979, 2810, 4763, 2808, 4761, 4280, 2992, 
        3974, 2807, 4758, 2805, 4269, 2985, 3375, 4629, 3668, 3666, 3662, 
        2799, 4756, 3963, 4627, 3242, 3240, 3493, 2791, 4753, 3362, 4623, 
        4624, 2622, 3658, 3656, 3951, 3950, 2574, 2618, 4853, 4854, 4219, 
        2961, 3353, 3352, 4201, 2954, 4200, 2955, 4202, 3225, 4198, 4199, 
        3599, 3600, 2566, 3341, 4183, 2940, 4182, 2941, 3215, 2603, 3451, 
        2939, 3321, 2757, 3453, 3216, 4184, 4185, 3897, 4584, 3323, 2758, 
        3454, 2759, 3324, 4587, 4588, 3900, 3901, 3899, 3904, 3902, 2554, 
        3910, 3911, 3908, 3915, 3913, 2555, 3918, 3919, 3916, 3923, 4957, 
        4994, 4992, 2556, 4592, 4593, 4294, 4299, 4297, 2734, 3402, 3403, 
        3293, 3401, 3292}],
       "0.2`"]}, {
      {GrayLevel[0], Opacity[0.4]}, 
      TooltipBox[
       LineBox[{2916, 4143, 2912, 4142, 2913, 4144, 4735, 4148, 2915, 4829, 
        2914, 4828, 4681, 2675, 4972, 4095, 4971, 4096, 4094, 4464, 4462, 
        4911, 4436, 4437, 4434, 4441, 4439, 3080, 4459, 4460, 4910, 4909, 
        3104, 4907, 4563, 3179, 4430, 4433, 3077, 4429, 3078, 4431, 3076, 
        4551, 3166, 4547, 3164, 4946, 3316, 4424, 3072, 4423, 3073, 4425, 
        3071, 4546, 3163, 4542, 3161, 4943, 3315, 4418, 3068, 4417, 3069, 
        4419, 3065, 4541, 3160, 4539, 3158, 4942, 4287, 3984, 3985, 3983, 
        4285, 4283, 4873, 3977, 3978, 3976, 4281, 4279, 4872, 3972, 3973, 
        3971, 4268, 4267, 4869, 4870, 3964, 2800, 4757, 2798, 4755, 4257, 
        2980, 3956, 2792, 4754, 2790, 4752, 4242, 2969, 3952, 2785, 4751, 
        2784, 4750, 4221, 2962, 4855, 2963, 4856, 3231, 3484, 2778, 3351, 
        3597, 3598, 4637, 4293, 3005, 4877, 2953, 4605, 4606, 2565, 3340, 
        4848, 4849, 4847, 4851, 4850, 3214, 4846, 2938, 4582, 4583, 3890, 
        2756, 3889, 3892, 3891, 2551, 3894, 3895, 3893, 3898, 3896, 2552, 
        3322, 3593, 3592}],
       "0.1`"]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  Method->{},
  PlotRange->NCache[{{0, 5}, {
      Rational[1, 10], 4}}, {{0, 5}, {0.1, 4}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259781845]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17843],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->11094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "x"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"{", 
     RowBox[{"\[Theta]", ">", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12937],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2512],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], ",", 
   RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9551],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SuperscriptBox["\[Pi]", "2"]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["\[Theta]", "4"]}]]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203660363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"CharacteristicFunction", "[", 
     RowBox[{
      RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "t"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "4"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"t", "->", "0"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21817],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   SuperscriptBox["\[Pi]", "2"]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["\[Theta]", "4"]}]]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23492]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21292],

Cell[TextData[{
 "The half-normal distribution is proportional to a centered normal \
distribution with variance ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"1", "/", "\[Theta]"}], 
    SqrtBox[
     RowBox[{"2", "/", "\[Pi]"}]]}], TraditionalForm]], "InlineMath"],
 ", limited to the domain ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{"0", ",", "\[Infinity]"}]}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"HalfNormalDistribution", "[", "1", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27530],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["x", "2"], "\[Pi]"]}]]}], "\[Pi]"]], "Output",
 ImageSize->{45, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->613]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0", ",", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        SqrtBox[
         RowBox[{"2", "/", "\[Pi]"}]], ")"}]}]}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25296],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["x", "2"], "\[Pi]"]}]]}], "\[Pi]"]], "Output",
 ImageSize->{45, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438457663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32389],

Cell[TextData[{
 "The half-normal distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", "=", 
    SqrtBox[
     RowBox[{"\[Pi]", "/", "2"}]]}], TraditionalForm]], "InlineMath"],
 " is equivalent to the chi distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Nu]", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"HalfNormalDistribution", "[", 
    SqrtBox[
     RowBox[{"\[Pi]", "/", "2"}]], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31744],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]]}]], "Output",
 ImageSize->{65, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18840]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ChiDistribution", "[", "1", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5809],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], " ", 
  SqrtBox[
   FractionBox["2", "\[Pi]"]]}]], "Output",
 ImageSize->{65, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28786]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HalfNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HalfNormalDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->26203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HalfNormalDistribution", "[", "I", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28995],

Cell[BoxData[
 RowBox[{
  RowBox[{"HalfNormalDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The parameter \\\\\\\"\\\", \\\"MSG\
\\\"]\\)\\!\\(\[ImaginaryI]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" inversely \
related to the scale is expected to be positive.\\\\\\\"\\\", \\\"MSG\\\"]\\)\
\"\>"}]], "Message", "MSG",
 CellID->17762],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HalfNormalDistribution", "[", "\[ImaginaryI]", "]"}], 
  "]"}]], "Output",
 ImageSize->{222, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Theta]", "\[Rule]", "I"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{"-", "\[ImaginaryI]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217769984]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6300],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChiDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChiDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21396]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14609],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->132814702]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HalfNormalDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 21.1313780}", "context" -> "System`", 
    "keywords" -> {"half-normal distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HalfNormalDistribution[\\[Theta]] represents a half-normal distribution \
with scale inversely proportional to parameter \\[Theta].", 
    "synonyms" -> {"half normal distribution"}, "title" -> 
    "HalfNormalDistribution", "type" -> "Symbol", "uri" -> 
    "ref/HalfNormalDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7137, 228, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->131902066]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 178308, 3595}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2060, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2683, 79, 1587, 37, 70, "ObjectNameGrid"],
Cell[4273, 118, 647, 19, 70, "Usage",
 CellID->18718]
}, Open  ]],
Cell[CellGroupData[{
Cell[4957, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5435, 159, 653, 24, 70, "Notes",
 CellID->429991538],
Cell[6091, 185, 300, 10, 70, "Notes",
 CellID->5927],
Cell[6394, 197, 706, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7137, 228, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->131902066],
Cell[CellGroupData[{
Cell[7522, 242, 148, 5, 70, "ExampleSection",
 CellID->103559996],
Cell[7673, 249, 276, 6, 70, "ExampleText",
 CellID->12294],
Cell[CellGroupData[{
Cell[7974, 259, 152, 4, 28, "Input",
 CellID->12054],
Cell[8129, 265, 181, 6, 51, "Output",
 CellID->26333]
}, Open  ]],
Cell[CellGroupData[{
Cell[8347, 276, 154, 4, 28, "Input",
 CellID->146],
Cell[8504, 282, 274, 10, 53, "Output",
 CellID->4229]
}, Open  ]],
Cell[8793, 295, 121, 3, 70, "ExampleDelimiter",
 CellID->10471],
Cell[8917, 300, 205, 5, 70, "ExampleText",
 CellID->10428],
Cell[CellGroupData[{
Cell[9147, 309, 178, 6, 70, "Input",
 CellID->10559],
Cell[9328, 317, 400, 14, 64, "Output",
 CellID->22241]
}, Open  ]],
Cell[CellGroupData[{
Cell[9765, 336, 290, 10, 28, "Input",
 CellID->29421],
Cell[10058, 348, 2668, 48, 166, "Output",
 Evaluatable->False,
 CellID->82968069]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12775, 402, 216, 7, 70, "ExampleSection",
 CellID->12033],
Cell[12994, 411, 258, 7, 70, "ExampleText",
 CellID->26685],
Cell[CellGroupData[{
Cell[13277, 422, 177, 6, 70, "Input",
 CellID->2270],
Cell[13457, 430, 333, 10, 36, "Output",
 CellID->76050722]
}, Open  ]],
Cell[13805, 443, 121, 3, 70, "ExampleDelimiter",
 CellID->32261],
Cell[13929, 448, 100, 3, 70, "ExampleText",
 CellID->102762657],
Cell[CellGroupData[{
Cell[14054, 455, 156, 4, 70, "Input",
 CellID->22860],
Cell[14213, 461, 384, 15, 59, "Output",
 CellID->2208]
}, Open  ]],
Cell[CellGroupData[{
Cell[14634, 481, 156, 4, 70, "Input",
 CellID->22162],
Cell[14793, 487, 407, 15, 57, "Output",
 CellID->32506]
}, Open  ]],
Cell[15215, 505, 120, 3, 70, "ExampleDelimiter",
 CellID->6878],
Cell[15338, 510, 219, 5, 70, "ExampleText",
 CellID->11979],
Cell[CellGroupData[{
Cell[15582, 519, 221, 7, 70, "Input",
 CellID->1897],
Cell[15806, 528, 208, 7, 50, "Output",
 CellID->7887]
}, Open  ]],
Cell[16029, 538, 120, 3, 70, "ExampleDelimiter",
 CellID->6538],
Cell[16152, 543, 379, 13, 70, "ExampleText",
 CellID->14469],
Cell[CellGroupData[{
Cell[16556, 560, 183, 6, 70, "Input",
 CellID->30783],
Cell[16742, 568, 260, 9, 56, "Output",
 CellID->17540]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17051, 583, 223, 7, 70, "ExampleSection",
 CellID->18633],
Cell[17277, 592, 249, 7, 70, "ExampleText",
 CellID->19271],
Cell[CellGroupData[{
Cell[17551, 603, 290, 10, 70, "Input",
 CellID->12368],
Cell[17844, 615, 2404, 43, 70, "Output",
 Evaluatable->False,
 CellID->419969713]
}, Open  ]],
Cell[20263, 661, 125, 3, 70, "ExampleDelimiter",
 CellID->431724658],
Cell[20391, 666, 362, 13, 70, "ExampleText",
 CellID->18135],
Cell[CellGroupData[{
Cell[20778, 683, 408, 13, 70, "Input",
 CellID->12258],
Cell[21189, 698, 144880, 2421, 70, "Output",
 CellID->259781845]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[166118, 3125, 233, 7, 70, "ExampleSection",
 CellID->17843],
Cell[166354, 3134, 229, 5, 70, "ExampleText",
 CellID->11094],
Cell[CellGroupData[{
Cell[166608, 3143, 416, 13, 70, "Input",
 CellID->12937],
Cell[167027, 3158, 153, 5, 36, "Output",
 CellID->5174]
}, Open  ]],
Cell[167195, 3166, 120, 3, 70, "ExampleDelimiter",
 CellID->2512],
Cell[167318, 3171, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[167577, 3181, 221, 7, 70, "Input",
 CellID->9551],
Cell[167801, 3190, 285, 10, 56, "Output",
 CellID->203660363]
}, Open  ]],
Cell[CellGroupData[{
Cell[168123, 3205, 383, 13, 70, "Input",
 CellID->21817],
Cell[168509, 3220, 281, 10, 56, "Output",
 CellID->23492]
}, Open  ]],
Cell[168805, 3233, 121, 3, 70, "ExampleDelimiter",
 CellID->21292],
Cell[168929, 3238, 622, 22, 70, "ExampleText",
 CellID->20237],
Cell[CellGroupData[{
Cell[169576, 3264, 171, 6, 70, "Input",
 CellID->27530],
Cell[169750, 3272, 314, 11, 64, "Output",
 CellID->613]
}, Open  ]],
Cell[CellGroupData[{
Cell[170101, 3288, 321, 12, 70, "Input",
 CellID->25296],
Cell[170425, 3302, 320, 11, 64, "Output",
 CellID->438457663]
}, Open  ]],
Cell[170760, 3316, 121, 3, 70, "ExampleDelimiter",
 CellID->32389],
Cell[170884, 3321, 510, 17, 70, "ExampleText",
 CellID->5628],
Cell[CellGroupData[{
Cell[171419, 3342, 212, 7, 70, "Input",
 CellID->31744],
Cell[171634, 3351, 321, 12, 60, "Output",
 CellID->18840]
}, Open  ]],
Cell[CellGroupData[{
Cell[171992, 3368, 160, 5, 70, "Input",
 CellID->5809],
Cell[172155, 3375, 321, 12, 60, "Output",
 CellID->28786]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[172525, 3393, 327, 9, 70, "ExampleSection",
 CellID->19664],
Cell[172855, 3404, 459, 14, 70, "ExampleText",
 CellID->26203],
Cell[CellGroupData[{
Cell[173339, 3422, 145, 4, 70, "Input",
 CellID->28995],
Cell[173487, 3428, 367, 7, 70, "Message",
 CellID->17762],
Cell[173857, 3437, 249, 8, 36, "Output",
 CellID->14381]
}, Open  ]],
Cell[174121, 3448, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[174245, 3453, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[174551, 3465, 237, 7, 70, "Input",
 CellID->25838],
Cell[174791, 3474, 187, 6, 36, "Output",
 CellID->217769984]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[175039, 3487, 310, 9, 70, "SeeAlsoSection",
 CellID->6300],
Cell[175352, 3498, 720, 26, 70, "SeeAlso",
 CellID->21396]
}, Open  ]],
Cell[CellGroupData[{
Cell[176109, 3529, 314, 9, 70, "TutorialsSection",
 CellID->14609],
Cell[176426, 3540, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[176620, 3548, 299, 8, 70, "MoreAboutSection"],
Cell[176922, 3558, 184, 4, 70, "MoreAbout",
 CellID->132814702]
}, Open  ]],
Cell[177121, 3565, 27, 0, 70, "History"],
Cell[177151, 3567, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

