(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33101,       1236]
NotebookOptionsPosition[     26229,        993]
NotebookOutlinePosition[     27454,       1029]
CellTagsIndexPosition[     27368,       1024]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
          "HarmonicNumber" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicNumber"], 
          "GeometricMean" :> 
          Documentation`HelpLookup["paclet:ref/GeometricMean"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mean\"\>", 
       2->"\<\"HarmonicNumber\"\>", 
       3->"\<\"GeometricMean\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["HarmonicMean", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HarmonicMean",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HarmonicMean"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the harmonic mean of the values in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", the harmonic mean is given by ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "n"], 
      RowBox[{
       UnderscriptBox["\[Sum]", "i"], 
       FractionBox["1", 
        SubscriptBox["x", "i"]]}]}], ")"}], 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->3244],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HarmonicMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicMean"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"HarmonicMean", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"HarmonicMean", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->26555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->308147848],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->354035307],

Cell["Harmonic mean of symbolic values:", "ExampleText",
 CellID->104718352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->686918257],

Cell[BoxData[
 FractionBox["4", 
  RowBox[{
   FractionBox["1", "a"], "+", 
   FractionBox["1", "b"], "+", 
   FractionBox["1", "c"], "+", 
   FractionBox["1", "d"]}]]], "Output",
 ImageSize->{87, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122363204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252483224],

Cell["Harmonic mean of columns of a matrix:", "ExampleText",
 CellID->234915771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36247193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["80", "33"], ",", 
   FractionBox["160", "49"]}], "}"}]], "Output",
 ImageSize->{73, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152621563]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29059],

Cell["Compute results at machine precision:", "ExampleText",
 CellID->379986608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216003675],

Cell[BoxData["0.17082402788711823`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256589561]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "6", ",", "5", ",", "15", ",", "10", ",", "1"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["2.950819672131147540983606557377049180327868852455`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117751946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "7"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.06324140963475317`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->417682206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.05007658044336699`", ",", "0.07508012800852658`", ",", 
   "0.0646314129532832`", ",", "0.05837947208540517`", ",", 
   "0.07174223243764775`", ",", "0.0772470461436875`", ",", 
   "0.06436400084227777`", ",", "0.07965483221326607`", ",", 
   "0.06269425284697455`", ",", "0.064026551166874`"}], "}"}]], "Output",
 ImageSize->{438, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->415989678]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31684],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", "j"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->909039204]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["100", "99"], ",", 
   FractionBox["75", "74"], ",", 
   FractionBox["200", "197"], ",", 
   FractionBox["125", "123"], ",", 
   FractionBox["60", "59"], ",", 
   FractionBox["175", "172"], ",", 
   FractionBox["400", "393"], ",", 
   FractionBox["225", "221"], ",", 
   FractionBox["500", "491"]}], "}"}]], "Output",
 ImageSize->{338, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290314125]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->391],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of the inverse of the data:"
}], "ExampleText",
 CellID->866035301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57098655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9.914460972999798`", ",", "9.811200815841891`", ",", "2.8979591176204855`",
    ",", "9.335346211496256`", ",", "1.9097865486786048`", ",", 
   "2.9521786941605144`", ",", "1.2978033220509166`", ",", 
   "5.812081455781588`", ",", "0.7294139031853941`", ",", 
   "7.276771245914874`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189847356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Mean", "[", 
   RowBox[{"1", "/", "data"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120365439],

Cell[BoxData["2.5199679898701506`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322318980]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73093501],

Cell[BoxData["2.5199679898701506`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->400728180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83903156],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 " is logarithmically related to ",
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 " for positive values:"
}], "ExampleText",
 CellID->19367069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Log", "[", 
    RowBox[{"GeometricMean", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "]"}]}], "//",
   "PowerExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48447845],

Cell[BoxData[
 FractionBox["4", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], "+", 
   RowBox[{"Log", "[", "b", "]"}], "+", 
   RowBox[{"Log", "[", "c", "]"}], "+", 
   RowBox[{"Log", "[", "d", "]"}]}]]], "Output",
 ImageSize->{214, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386513902]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicMean", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Log", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243865852],

Cell[BoxData[
 FractionBox["4", 
  RowBox[{
   RowBox[{"Log", "[", "a", "]"}], "+", 
   RowBox[{"Log", "[", "b", "]"}], "+", 
   RowBox[{"Log", "[", "c", "]"}], "+", 
   RowBox[{"Log", "[", "d", "]"}]}]]], "Output",
 ImageSize->{214, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->383854883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->267073164],

Cell[TextData[{
 "For positive data, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"HarmonicMean", "[", 
    StyleBox["d", "TI"], "]"}], "\[LessEqual]", 
   RowBox[{
    ButtonBox["GeometricMean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GeometricMean"], "[", 
    StyleBox["d", "TI"], "]"}], "\[LessEqual]", 
   RowBox[{
    ButtonBox["Mean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mean"], "[", 
    StyleBox["d", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->86076482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535336088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.13931670478284341`", ",", "0.8813433702540712`", ",", 
   "0.6492053904937163`", ",", "0.2495668746599662`", ",", 
   "0.23115379519067591`", ",", "0.210475698322788`", ",", 
   "0.813689938009154`", ",", "0.07726876410118777`", ",", 
   "0.7202633811261014`", ",", "0.09535339431199819`"}], "}"}]], "Output",
 ImageSize->{417, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27319991]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HarmonicMean", "[", "data", "]"}], "\[LessEqual]", 
  RowBox[{"GeometricMean", "[", "data", "]"}], "\[LessEqual]", 
  RowBox[{"Mean", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->735737269],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->988758692]
}, Open  ]],

Cell["Prove the inequality symbolically:", "ExampleText",
 CellID->418828296],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28077115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HarmonicMean", "[", "data", "]"}], "\[LessEqual]", 
    RowBox[{"GeometricMean", "[", "data", "]"}], "\[LessEqual]", 
    RowBox[{"Mean", "[", "data", "]"}]}], ",", 
   RowBox[{
    RowBox[{"Min", "[", "data", "]"}], "\[GreaterEqual]", "0"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->289465582],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->87219188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543634770],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HarmonicMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicMean"], "[", 
   RowBox[{
    ButtonBox["Range",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Range"], "[", 
    StyleBox["n", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is inversely related to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HarmonicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicNumber"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->691091147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", "50", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166528804],

Cell[BoxData[
 FractionBox["13943237577224054960759", "3099044504245996706400"]], "Output",
 ImageSize->{184, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26838138]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"50", "/", 
  RowBox[{"HarmonicMean", "[", 
   RowBox[{"Range", "[", "50", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->604366556],

Cell[BoxData[
 FractionBox["13943237577224054960759", "3099044504245996706400"]], "Output",
 ImageSize->{184, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402025784]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31139],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HarmonicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeometricMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricMean"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13592],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with HarmonicMean",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=HarmonicMean"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->877922713],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->337553362]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HarmonicMean - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 24.4752136}", "context" -> "System`", 
    "keywords" -> {"HM"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HarmonicMean[list] gives the harmonic mean of the values in list.", 
    "synonyms" -> {"harmonic mean"}, "title" -> "HarmonicMean", "type" -> 
    "Symbol", "uri" -> "ref/HarmonicMean"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8239, 272, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->308147848]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27225, 1017}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2140, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2763, 80, 1577, 37, 70, "ObjectNameGrid"],
Cell[4343, 119, 572, 18, 70, "Usage",
 CellID->20043]
}, Open  ]],
Cell[CellGroupData[{
Cell[4952, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5430, 159, 733, 29, 70, "Notes",
 CellID->3244],
Cell[6166, 190, 218, 7, 70, "Notes",
 CellID->28487],
Cell[6387, 199, 1485, 54, 70, "Notes",
 CellID->26555],
Cell[7875, 255, 327, 12, 70, "Notes",
 CellID->22482]
}, Closed]],
Cell[CellGroupData[{
Cell[8239, 272, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->308147848],
Cell[CellGroupData[{
Cell[8624, 286, 148, 5, 70, "ExampleSection",
 CellID->354035307],
Cell[8775, 293, 76, 1, 70, "ExampleText",
 CellID->104718352],
Cell[CellGroupData[{
Cell[8876, 298, 175, 5, 28, "Input",
 CellID->686918257],
Cell[9054, 305, 309, 11, 60, "Output",
 CellID->122363204]
}, Open  ]],
Cell[9378, 319, 125, 3, 70, "ExampleDelimiter",
 CellID->252483224],
Cell[9506, 324, 80, 1, 70, "ExampleText",
 CellID->234915771],
Cell[CellGroupData[{
Cell[9611, 329, 379, 13, 70, "Input",
 CellID->36247193],
Cell[9993, 344, 252, 9, 51, "Output",
 CellID->152621563]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10294, 359, 216, 7, 70, "ExampleSection",
 CellID->29059],
Cell[10513, 368, 80, 1, 70, "ExampleText",
 CellID->379986608],
Cell[CellGroupData[{
Cell[10618, 373, 170, 5, 70, "Input",
 CellID->216003675],
Cell[10791, 380, 177, 5, 36, "Output",
 CellID->256589561]
}, Open  ]],
Cell[10983, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[11111, 393, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[11212, 398, 259, 8, 70, "Input",
 CellID->190699768],
Cell[11474, 408, 214, 6, 36, "Output",
 CellID->117751946]
}, Open  ]],
Cell[11703, 417, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[11831, 422, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[11944, 427, 195, 6, 70, "Input",
 CellID->315224713],
Cell[12142, 435, 177, 5, 36, "Output",
 CellID->417682206]
}, Open  ]],
Cell[CellGroupData[{
Cell[12356, 445, 249, 8, 70, "Input",
 CellID->594479966],
Cell[12608, 455, 489, 12, 54, "Output",
 CellID->415989678]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13146, 473, 239, 7, 70, "ExampleSection",
 CellID->31684],
Cell[13388, 482, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[13624, 494, 552, 18, 70, "Input",
 CellID->19878761],
Cell[14179, 514, 494, 17, 36, "Output",
 CellID->909039204]
}, Open  ]],
Cell[CellGroupData[{
Cell[14710, 536, 109, 3, 70, "Input",
 CellID->235263230],
Cell[14822, 541, 513, 16, 51, "Output",
 CellID->290314125]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15384, 563, 231, 7, 70, "ExampleSection",
 CellID->391],
Cell[15618, 572, 348, 12, 70, "ExampleText",
 CellID->866035301],
Cell[CellGroupData[{
Cell[15991, 588, 157, 5, 70, "Input",
 CellID->57098655],
Cell[16151, 595, 478, 12, 54, "Output",
 CellID->189847356]
}, Open  ]],
Cell[CellGroupData[{
Cell[16666, 612, 150, 5, 70, "Input",
 CellID->120365439],
Cell[16819, 619, 176, 5, 36, "Output",
 CellID->322318980]
}, Open  ]],
Cell[CellGroupData[{
Cell[17032, 629, 110, 3, 70, "Input",
 CellID->73093501],
Cell[17145, 634, 176, 5, 36, "Output",
 CellID->400728180]
}, Open  ]],
Cell[17336, 642, 124, 3, 70, "ExampleDelimiter",
 CellID->83903156],
Cell[17463, 647, 370, 12, 70, "ExampleText",
 CellID->19367069],
Cell[CellGroupData[{
Cell[17858, 663, 274, 9, 70, "Input",
 CellID->48447845],
Cell[18135, 674, 346, 11, 53, "Output",
 CellID->386513902]
}, Open  ]],
Cell[CellGroupData[{
Cell[18518, 690, 236, 8, 70, "Input",
 CellID->243865852],
Cell[18757, 700, 346, 11, 53, "Output",
 CellID->383854883]
}, Open  ]],
Cell[19118, 714, 125, 3, 70, "ExampleDelimiter",
 CellID->267073164],
Cell[19246, 719, 512, 18, 70, "ExampleText",
 CellID->86076482],
Cell[CellGroupData[{
Cell[19783, 741, 157, 5, 70, "Input",
 CellID->535336088],
Cell[19943, 748, 484, 12, 54, "Output",
 CellID->27319991]
}, Open  ]],
Cell[CellGroupData[{
Cell[20464, 765, 243, 6, 70, "Input",
 CellID->735737269],
Cell[20710, 773, 161, 5, 36, "Output",
 CellID->988758692]
}, Open  ]],
Cell[20886, 781, 77, 1, 70, "ExampleText",
 CellID->418828296],
Cell[20966, 784, 171, 6, 70, "Input",
 CellID->28077115],
Cell[CellGroupData[{
Cell[21162, 794, 384, 11, 70, "Input",
 CellID->289465582],
Cell[21549, 807, 160, 5, 36, "Output",
 CellID->87219188]
}, Open  ]],
Cell[21724, 815, 125, 3, 70, "ExampleDelimiter",
 CellID->543634770],
Cell[21852, 820, 560, 20, 70, "ExampleText",
 CellID->691091147],
Cell[CellGroupData[{
Cell[22437, 844, 111, 3, 70, "Input",
 CellID->166528804],
Cell[22551, 849, 221, 6, 51, "Output",
 CellID->26838138]
}, Open  ]],
Cell[CellGroupData[{
Cell[22809, 860, 166, 5, 70, "Input",
 CellID->604366556],
Cell[22978, 867, 222, 6, 51, "Output",
 CellID->402025784]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23261, 880, 311, 9, 70, "SeeAlsoSection",
 CellID->31139],
Cell[23575, 891, 710, 26, 70, "SeeAlso",
 CellID->24696]
}, Open  ]],
Cell[CellGroupData[{
Cell[24322, 922, 314, 9, 70, "TutorialsSection",
 CellID->13592],
Cell[24639, 933, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[24832, 941, 305, 8, 70, "RelatedLinksSection"],
Cell[25140, 951, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25546, 968, 299, 8, 70, "MoreAboutSection"],
Cell[25848, 978, 155, 3, 70, "MoreAbout",
 CellID->877922713],
Cell[26006, 983, 151, 3, 70, "MoreAbout",
 CellID->337553362]
}, Open  ]],
Cell[26172, 989, 27, 0, 70, "History"],
Cell[26202, 991, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

