(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81580,       2587]
NotebookOptionsPosition[     68917,       2143]
NotebookOutlinePosition[     70267,       2180]
CellTagsIndexPosition[     70181,       2175]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerGamma" :> 
          Documentation`HelpLookup["paclet:ref/EulerGamma"], "PolyGamma" :> 
          Documentation`HelpLookup["paclet:ref/PolyGamma"], "Zeta" :> 
          Documentation`HelpLookup["paclet:ref/Zeta"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"], "HarmonicMean" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicMean"], 
          "ZipfDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ZipfDistribution"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EulerGamma\"\>", 
       2->"\<\"PolyGamma\"\>", 3->"\<\"Zeta\"\>", 4->"\<\"Log\"\>", 
       5->"\<\"HarmonicMean\"\>", 
       6->"\<\"ZipfDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Recurrence and Sum Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/RecurrenceAndSumFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Recurrence and Sum Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HarmonicNumber", "ObjectName",
 CellID->12864],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HarmonicNumber",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HarmonicNumber"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " harmonic number ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["H", "n"], TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HarmonicNumber",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HarmonicNumber"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the harmonic number ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["H", "n", 
        RowBox[{"(", "r", ")"}]], TraditionalForm]], "InlineMath"],
     " of order ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30845]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The harmonic numbers are given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["H", "n", 
     RowBox[{"(", "r", ")"}]], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "n",
      LimitsPositioning->True], 
     RowBox[{"1", "/", 
      SuperscriptBox["i", "r"]}]}]}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["H", "n"], "=", 
    SubsuperscriptBox["H", "n", 
     RowBox[{"(", "1", ")"}]]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->9050],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicNumber"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicNumber"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->809453547],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->36221989],

Cell["First ten harmonic numbers:", "ExampleText",
 CellID->813793207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12306575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["11", "6"], ",", 
   FractionBox["25", "12"], ",", 
   FractionBox["137", "60"], ",", 
   FractionBox["49", "20"], ",", 
   FractionBox["363", "140"], ",", 
   FractionBox["761", "280"], ",", 
   FractionBox["7129", "2520"], ",", 
   FractionBox["7381", "2520"]}], "}"}]], "Output",
 ImageSize->{331, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16829161]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175089600],

Cell["Plot harmonic numbers:", "ExampleText",
 CellID->538152488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"HarmonicNumber", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28651992],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWetvFFUUv92Z2e2WgtKXRhSrMRIjHyCGxGi22xdFKA8jiaTESlbEtCRI
bYkhEDU+EFQQE0XttEC7KMXwET8TEr7gB/8J/5Hx3Pe9Z87MTgOibrYzc+ee
33n8zrnn3k33NE5MHTnWODF9uNG/Y7YxMzV9eK5/7PgsvAraGGO/w9/04wye
E3gSf+1JkrCAP4kP+41fmHgbwds/7v01cWClXpu/cP4uWzFzJZhiwe5dSzAz
VF9wZgQK7q+NXYG5wXpMzL2+twlzI0MU7tzZOzA38/4t1g2jEF6WlL1A3Xu5
dGg8Jmbdsb73ZLzvgntAWHHvvoc26h7nrbkKTZpRPOaPXb7/BRDr+aXsIorh
Hr0fXGEP9ZgXWBu/oyqxldC7Kr3aEw5gFeN/Jtf/Z6a0BKwMVgK2WADrTens
LqAx5ROebxHb/XC3XmW6qJ0HxpmyBS1qZHBBLsneVXK1Wt+5fLDaWP/NurK2
zTLsekh5FnYiMy6Ykf8iY90JvTfk70R9Dl9Fd6KsHcjfiURfDV0Pr+f678xa
b6HV4E5zzcpVjJy7vNivlAR8RocXQaI+ECuJCK43mG7bQr7qyo+NXuauDcQq
FxWUzegfHm98yPZajdstT96KsfvBocmbSrYPYd9G46eydZdd3ZDYwVrMtf9i
JRycXC9wSuOZrcXMSplqDCCDYnae5egIZbblIfJajpw8F8rCyJMDz6UcfGk5
4V1ovAO7Tc/7UMyP71wy9po5elx7tFyYsrecI+faXfb8ilL2aD1cLkB1cSVT
koVfnrltNC6RcmWlMXvWiW/3ruWrnt9i/YbN5T+NlauknorxG1Sod4uZkr7f
Mr5As4QqHGtdkNJU/eC1EblW+O+cxUwsH1aNNVgVai4uZK2asgbZU56q9i4+
OL4On334+hiTZ4yJ3IwAN8pPvSOFCLNGYLaPLHpszHuZ7hQyboXy3mBlXH2d
qXhHhy+zn0nZtSnbnJufsmUD40PqxPwDiVqXYoR7/qMXnThFRLMzt4wM3/Uu
kfqk7MED173oaNvibB2Nql6qZb/Plk1FB/Jq/jsSJU5bgYkuhbroxdnTQvpb
0gaNAobU/AUSJc/kpgoUSu79fOo8ieojbdkV9w2JekxzNyYKieEe+ZXHwhNC
ev++ZgYL50gbEmXynornbNJqPW8QY1NlKS/PSKh3msVr9UnNz5BoC0qHzcUX
BXRsRPHjHvpZhg6u4mkyBpufT5Osbt2PchQi1j/x+EuI3vasrqihWmw1WL8/
SvK63HMofyHqHqe9Gnke8RyibJ8ia2QT6aFFnSRRL4jxu42bdRr1IYl6EcUT
oXjmSNRmLwsxK6Ma/MBjYYu1EVsbNmfHSRtbSZSN5xiJeklX1qBElVF2j5Ko
bSZPHKXjsbamSNTLyMMyWkVHPBZe9TyLWQWx8A5po4ZsVFA8h0hU3au7mLUj
W2+RqGESZeOZIFHbE7daNcpy96bHwk7EdBV59gZpY5xfQlNv8K2iOt2btFr3
+zwmtWUb3XhLDcK30ERqvLA6diS6d6R+BzhjwYhZqTHrQFpGMrXw4USKiw7U
PeuFvJhM6VmDcvGKpCJ3F2gkficoGT02N9scqP5gPe8Jb0x2jBZbR1vJyjiK
qq9EIDd7FTiTstSJ+NtEWpojIl2LVuMzJPIkQgYGaTnaQCI/Tvya5TbXIWQv
ifwc8RIQyEc8Xr5GVWkRNr4qaesigexAtVQhkZcIJO/ztB3xuyWy628gnjy4
kuGT/E8Ua/sbX7dEvw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317498016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355275359],

Cell["Carry out sums involving harmonic numbers:", "ExampleText",
 CellID->180618872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "^", "2"}], " ", 
    RowBox[{"HarmonicNumber", "[", "n", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "m"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114079022],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "36"], " ", "m", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"3", " ", "m"}], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["m", "2"]}], "+", 
    RowBox[{"6", " ", 
     RowBox[{"HarmonicNumber", "[", "m", "]"}]}], "+", 
    RowBox[{"18", " ", "m", " ", 
     RowBox[{"HarmonicNumber", "[", "m", "]"}]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["m", "2"], " ", 
     RowBox[{"HarmonicNumber", "[", "m", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{586, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226045298]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3187],

Cell["Evaluate exact values at large arguments:", "ExampleText",
 CellID->909420544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HarmonicNumber", "[", 
   RowBox[{"10", "^", "3"}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92010879],

Cell[BoxData[
 RowBox[{"53362913282294785045591045624042980409652472280384260097101349248456\
268889497101757506097901985035691409088731550468098378442172117885009464302344\
326566022502100278425632852081405544941210442510142672770294774712708917963967\
779610453224692426866468888281582071984897105110796873249319155529397017508931\
564519976085734473014183284011724412280649074307703736683170055800293659235088\
589360235285852808160759574737836655413175508131522517", "/", 
  "712886527466509305316638415571427292066835886188589304045200199115432408758\
111149947644415191387158691171781701957525651298026406762100925146587100430513\
107268626814320019660997486274593718834370501543445252373974529896314567498212\
823695623282379401106880926231770886197954079124775455804932647573782992335275\
179673524804246363805113703433121478174685087845348567802188807537324992199567\
2056932029099390891687487672697950931603520000"}]], "Output",
 ImageSize->{583, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->273622238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283539706],

Cell["Non-integer arguments:", "ExampleText",
 CellID->41413152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"HarmonicNumber", "[", 
   RowBox[{"7", "/", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22399609],

Cell[BoxData["1.9660865912610617`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->571262065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60251326],

Cell["Complex arguments:", "ExampleText",
 CellID->6678469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{"2.3", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39754674],

Cell[BoxData[
 RowBox[{"1.670485629855718`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.3401248954450316`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329426807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->428142147],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->433415964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", 
    RowBox[{"1", "/", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18811731],

Cell[BoxData["0.\
4451818848807265376100930157951335768867310392195055346130161715708`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->558038215]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146876751],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->285495983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", "0.333333333333333333333333333333", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53584202],

Cell[BoxData["0.445181884880726537610093015794768378156107207609`32.\
619186555717555"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534876192]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143077582],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicNumber"]], "InlineFormula"],
 " threads element-wise over lists and arrays:"
}], "ExampleText",
 CellID->628379715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "11"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413253680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["11", "6"], ",", 
   FractionBox["137", "60"], ",", 
   FractionBox["363", "140"], ",", 
   FractionBox["83711", "27720"]}], "}"}]], "Output",
 ImageSize->{184, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116416692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->748233439],

Cell["Series expansion at any point:", "ExampleText",
 CellID->416310321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->612918841],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["137", "60"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["5269", "3600"]}], "+", 
      FractionBox[
       SuperscriptBox["\[Pi]", "2"], "6"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "5"}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"PolyGamma", "[", 
     RowBox[{"2", ",", "6"}], "]"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"n", "-", "5"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"n", "-", "5"}], "]"}], "3"],
    SeriesData[$CellContext`n, 5, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, 5, {
    Rational[137, 60], Rational[-5269, 3600] + Rational[1, 6] Pi^2, 
    Rational[1, 2] PolyGamma[2, 6]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{414, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169463861]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95505002],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->456005606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HarmonicNumber", "[", 
   RowBox[{"n", ",", "k"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->717378735],

Cell[BoxData[
 FormBox[
  SubsuperscriptBox[
   InterpretationBox["H",
    HarmonicNumber,
    Editable->False,
    Selectable->False], "n", 
   RowBox[{"(", "k", ")"}]], TraditionalForm]], "Output",
 ImageSize->{26, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->120690674]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14535],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->623198344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133209954],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"EulerGamma", "-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "n"], "]"}]}], ")"}], "+", 
   FractionBox["1", 
    RowBox[{"2", " ", "n"}]], "-", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "n"], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "n"], "]"}], "3"],
    SeriesData[$CellContext`n, 
     DirectedInfinity[1], {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, 
   DirectedInfinity[1], {EulerGamma - Log[$CellContext`n^(-1)], 
    Rational[1, 2], 
    Rational[-1, 12]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{296, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442176435]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329674912],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HarmonicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicNumber"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->276712786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"], "+", 
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"]}], ")"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->257770211],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      FractionBox[
       SuperscriptBox["\[Pi]", "2"], "6"]}], ")"}], " ", "x"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "2"],
    SeriesData[$CellContext`x, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, -1 + Rational[1, 6] Pi^2}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{139, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222195328]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Harmonic Numbers of Order ",
   StyleBox["r",
    FontSlant->"Italic"],
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->338722534],

Cell["Evaluate at exact arguments:", "ExampleText",
 CellID->111981559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{"4", ",", "r"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188396411],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["2", 
   RowBox[{"-", "r"}]], "+", 
  SuperscriptBox["3", 
   RowBox[{"-", "r"}]], "+", 
  SuperscriptBox["4", 
   RowBox[{"-", "r"}]]}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202817043]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{"z", ",", 
   RowBox[{"-", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->560879010],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["z", "30"]}], "+", 
  FractionBox[
   SuperscriptBox["z", "3"], "3"], "+", 
  FractionBox[
   SuperscriptBox["z", "4"], "2"], "+", 
  FractionBox[
   SuperscriptBox["z", "5"], "5"]}]], "Output",
 ImageSize->{118, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484689932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{"Infinity", ",", " ", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58751469],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", "2"], "6"]], "Output",
 ImageSize->{22, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51219804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7374867],

Cell["Series expansion at any point:", "ExampleText",
 CellID->685270877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", 
    RowBox[{"n", ",", " ", "r"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "n0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36014350],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"HarmonicNumber", "[", 
    RowBox[{"n0", ",", "r"}], "]"}], "+", 
   RowBox[{"r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"HarmonicNumber", "[", 
        RowBox[{"n0", ",", 
         RowBox[{"1", "+", "r"}]}], "]"}]}], "+", 
      RowBox[{"Zeta", "[", 
       RowBox[{"1", "+", "r"}], "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"n", "-", "n0"}], ")"}]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"r", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"HarmonicNumber", "[", 
          RowBox[{"n0", ",", 
           RowBox[{"2", "+", "r"}]}], "]"}]}], "+", 
        RowBox[{"Zeta", "[", 
         RowBox[{"2", "+", "r"}], "]"}]}], ")"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"n", "-", "n0"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"n", "-", "n0"}], "]"}], "3"],
    SeriesData[$CellContext`n, $CellContext`n0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, $CellContext`n0, {
    HarmonicNumber[$CellContext`n0, $CellContext`r], $CellContext`r (-
      HarmonicNumber[$CellContext`n0, 1 + $CellContext`r] + 
     Zeta[1 + $CellContext`r]), 
    Rational[-1, 2] $CellContext`r (
     1 + $CellContext`r) (-
      HarmonicNumber[$CellContext`n0, 2 + $CellContext`r] + 
     Zeta[2 + $CellContext`r])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{498, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76815426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338250816],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->897315048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", 
    RowBox[{"n", ",", " ", "r"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371239940],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["n", 
    RowBox[{"-", "r"}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", "r"}], "n"]]}], "+", 
      FractionBox["1", "2"], "-", 
      FractionBox["r", 
       RowBox[{"12", " ", "n"}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "n"], "]"}], "3"],
       SeriesData[$CellContext`n, 
        DirectedInfinity[1], {}, -1, 3, 1],
       Editable->False]}],
     SeriesData[$CellContext`n, 
      DirectedInfinity[1], {(-1)/(-1 + $CellContext`r), 
       Rational[1, 2], Rational[-1, 12] $CellContext`r}, -1, 3, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{"Zeta", "[", "r", "]"}]}]], "Output",
 ImageSize->{251, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24566547]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28364],

Cell["The average number of comparisons in Quicksort: ", "ExampleText",
 CellID->23658567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"HarmonicNumber", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227596600],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWF1sFUUUnnbvBYqlloBYBaESCAoosdBgqhhUpAFsak2xCjZYasMtEaul
oCn+QFTQqA/aF3mBB38SkAeIBGOCiZHESGIkMZIYJTGYGHyQmEh8aGKyfnNm
Z3Z29tzb3fvX2KQ7e+6eOd+cc75zdmY7+kZyA7v6Rgb7+5rbh/ueyw32725e
PzSMn7waIcRp/OeaBO593NH/ad/HGL+24JqBQi3GWoxeMM6UT+UDX//ZT693
ZD025vm9AaPHoNijECvlNaswzZXmCI+X5W1DdKUJZlwnL1PsGcnm1ZcyL/EK
tSwTWSNH+m1Vai/rg8yKqWateeP6f41Ka4IZMUz3+QRrLyU2M3zF76Q4kxGT
tGuUsfDS+jRJ/GipZt6yRk4Y+cmMzEqf78SF+77u724fL9T38/X7sO/H30rz
HY/H6Nd5uL4ndEMjnWkQPz/z04H9ZzdtOIrr+W9/Uy5PcSxkqix7k4yfVp4W
xrTOzv6XZy/tGTnTs/mTT4//cO3auJjlzLvJkZsmeO7KFq4bveyVK3+Pvf9N
V+eH775zDvfibaNbqzOcHR//99TJi1gfkv/Lz3+Kt1h7hJKBL/3bT+wb/QKK
h1i96aR37utfjd4bEcwZseevsXYaLL1DB7/C4g+weo2kBwLDAbh69eo/r0bw
KNoZhL5367GjR75DAl6m57ICuF2bHrMODtnJYjqMqFwibmIf2aLYpNp1cT3J
lW+glQMRbmHxCMUozazzi+ldhZBuJIsIMRIy9OxnyMmLNHN6Crv5cKRIjM1c
+P535BIkA9Destm35bmaowjX4Q/OI3QjJtdp3xJJ8OYRHnjw8UcXAAkS7jZ8
KNSzs8G4gOaDsiD4YO7kxR//eJ7leDPp4TGUED9MGGL1Flr+Y0lY2C6jJ/EW
aUYhOEgFOv0zrJ3FpHf58l/oW6AE8rWT1VviBzWqagt4uQje7To+eAgV4O3g
GFwgSjbaUs1SrEpFYYCzVoa8LidZxRGtUTxtWJT0NJAE5Q6dDfRmJBZVtz1k
a8oddqHqW6HZg5SrqngqwtJS7NvyXSSrUgAnxLaKoNB+VNYMiAki4KY3Jafk
qHb4ICTWilYunvQ5frfqDKEDq/rcwuqt1hGGkorw40ZPorVZkQGm6GGttGnP
DL83s3r3WuxEyxHdrNYavXb0FhhEMT8aycdEvWmtjhBYg5WLrpCbFeikhCY7
BcKnIt1ZUbwHohkDcEfZ8aS4TmceUcT7TzxsUJKe/5J48xB5gxTj5Y10I+kb
Ta7TnamSoLWTDOYFbN7g6/rjzjUur0g7YLlaazvL340OynpWa1PM2jpWr8Ox
9qDRkmvqjFm5n7XyiGNlLavVFbN2XwSt27GyxuRqorq0UbpjKPeUncG2/Jiz
6rayo0mxJ+bV3ZHolKtinnC8WV3R2G2JedVadjwZnV7Hq1VFMas3ttoWw19b
b5tGQ29DJ1Xv/5gW7TXkrs102hVGT6L3+2GHlFbuZK2QluxwxspyVm9AW0Mn
hLZYFsGi3aendkLynbZUxTMThFXo2NYGP3LRcr+KkM3wzQXQ28gc5Si+Ky1p
n+p+ERl0/FlSUWQp7rS8VbuvxVXzls4qwZ5N7i8XVQ2ZTlFyL4U9p6qIhVXD
ppOeVWW3qnmebzirmVmIsXKks2WkEhf4XA0N+9GKnM9q0UnXU3sOyb1bjJbE
2hPjyVzWyl4rp7Jj3cxqvaDjbzpSUwRtVMdIbR3V94ygsek/nZh8XdCt61Ht
H2zi+CrmhBmfarQUgJ3JIt5NbsZfIhmYqp2I2SGy+44peW/nYtO3MaujzGKx
PR1MA1xsP3klxpOZFUS05f0O8xpD3ApXNH3HDNkM5xv8Ymv6dT/aHejraqx+
lJbissxqPat1kGT1GkMi1Nc5U2NvambgaCpv61gbYwV+FTX/ASKfFTY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270539556]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256819879],

Cell["Plot over the complex plane:", "ExampleText",
 CellID->7147496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"HarmonicNumber", "[", 
     RowBox[{"nx", "+", 
      RowBox[{"I", " ", "ny"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"nx", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ny", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->585341952],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85562142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147365854],

Cell["Book stacking with the maximal overhang:", "ExampleText",
 CellID->3798961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Rectangle", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"HarmonicNumber", "[", "k", "]"}], "-", "1"}], ",", 
           RowBox[{"k", "/", "10"}]}], "}"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"HarmonicNumber", "[", "k", "]"}], ",", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "10"}]}], "}"}]}]}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "10"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131964898],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNlb0KwkAQhFdjo5WddsbSWkQhlcY/BEmZWMkRlKQIShL7PJTvd05WSBGL
Ld2Dm7sZvimWBO5syuSWmTKNjXvIzTNJ48LdP3JEToeI3tj+mHC3uPF+W4vz
V3tQr6qqV+PIgaXvWtZSe8uLCvXUGuGDXb/VWbU6mWpqAN0gTNgNhc5dPeUj
NOxGQuf6R2qL8MLOFf64UD21Qxiwmwnzn9VTR4Q+u4XQWaunTgiZpq3wLefq
qQDhlF0ozD9RTUXQCCG/M/QS5u+qp7xmlt8Xnzof95OBdA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->685641936]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224637825],

Cell[TextData[{
 "Picking the best candidate out of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " after ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " evaluated choices [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/SultansDowryProblem.html"], None}],
 "]:"
}], "ExampleText",
 CellID->32608337],

Cell[BoxData[
 RowBox[{
  RowBox[{"startLookingAfter", "[", "n_", "]"}], ":=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"HarmonicNumber", "[", 
       RowBox[{"x", "-", "1"}], "]"}], " ", "<", " ", 
      RowBox[{
       RowBox[{"HarmonicNumber", "[", "n", "]"}], "-", "1"}], "<", 
      RowBox[{"HarmonicNumber", "[", "x", "]"}]}], "&&", 
     "\[IndentingNewLine]", 
     RowBox[{"1", "<=", "x", "<=", "n"}]}], ",", "x", ",", "Integers"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13304398],

Cell[TextData[{
 "Evaluate for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "=", "100"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->328045278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"startLookingAfter", "[", "100", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194806077],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "37"}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->347220209]
}, Open  ]],

Cell["Plot as a function of harem size:", "ExampleText",
 CellID->298913145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"k", ",", 
      RowBox[{
       RowBox[{"startLookingAfter", "[", "k", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"k", ",", " ", "2", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->633629622],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{2., 1.}, {3., 1.}, {4., 2.}, {5., 2.}, {6., 2.}, {7., 3.}, {8.,
      3.}, {9., 3.}, {10., 4.}, {11., 4.}, {12., 5.}, {13., 5.}, {14., 5.}, {
     15., 6.}, {16., 6.}, {17., 6.}, {18., 7.}, {19., 7.}, {20., 8.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 20.}, {1., 8.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->174111653]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17633],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing harmonic numbers:"
}], "ExampleText",
 CellID->584391346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", 
    RowBox[{
     RowBox[{"-", "z"}], "-", "1"}], "]"}], "-", 
   RowBox[{"HarmonicNumber", "[", "z", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49284676],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"Cot", "[", 
   RowBox[{"\[Pi]", " ", "z"}], "]"}]}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200858610]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"HarmonicNumber", "[", "z", "]"}], " ", "-", 
   RowBox[{"PolyGamma", "[", 
    RowBox[{"0", ",", 
     RowBox[{"z", "+", "1"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73747950],

Cell[BoxData["EulerGamma"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628505739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271538163],

Cell["Expand in simpler functions:", "ExampleText",
 CellID->142936301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"HarmonicNumber", "[", 
   RowBox[{
    RowBox[{"-", "5"}], "/", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399234736],

Cell[BoxData[
 RowBox[{
  FractionBox["8", "3"], "-", 
  RowBox[{"Log", "[", "4", "]"}]}]], "Output",
 ImageSize->{70, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130918145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90232359],

Cell["Sums:", "ExampleText",
 CellID->141968528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "^", "n"}], " ", 
    RowBox[{"HarmonicNumber", "[", 
     RowBox[{"n", ",", " ", "2"}], "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "m"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173872120],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[Pi]", "2"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "m"], " ", 
     RowBox[{"HarmonicNumber", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m"}], ")"}]}], ",", "2"}], "]"}]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "m"], " ", 
     RowBox[{"HarmonicNumber", "[", 
      RowBox[{
       FractionBox["m", "2"], ",", "2"}], "]"}]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "m"], " ", 
     RowBox[{"HarmonicNumber", "[", 
      RowBox[{"m", ",", "2"}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{427, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70774217]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"n", "^", "3"}], " ", 
    RowBox[{"HarmonicNumber", "[", "n", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"n", ",", " ", "m"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39187168],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "48"], " ", "m", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "m"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    RowBox[{"5", " ", "m"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["m", "2"]}], "+", 
    RowBox[{"12", " ", "m", " ", 
     RowBox[{"HarmonicNumber", "[", "m", "]"}]}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["m", "2"], " ", 
     RowBox[{"HarmonicNumber", "[", "m", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{495, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30371800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->665355700],

Cell["Generate from sums and integrals:", "ExampleText",
 CellID->48629001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", "k"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138661707],

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", "n", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142388277]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", " ", "-", " ", 
      RowBox[{"t", "^", "z"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", " ", "-", " ", "t"}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Re", "[", "z", "]"}], ">", 
     RowBox[{"-", "1"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->273113457],

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", "z", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491975455]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64527705],

Cell["Generating function:", "ExampleText",
 CellID->746986739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"HarmonicNumber", "[", "k", "]"}], " ", 
    RowBox[{"x", "^", "k"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", " ", "1", ",", " ", "Infinity"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351776757],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{"1", "-", "x"}], "]"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "x"}]]], "Output",
 ImageSize->{70, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191038370]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19351],

Cell["\<\
Large arguments can give results too large to be computed explicitly:\
\>", "ExampleText",
 CellID->939476314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{
   RowBox[{"10.", "^", "100"}], ",", 
   RowBox[{"10", "^", "99"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132468576],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->636277062],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->101906870],

Cell[BoxData[
 RowBox[{
  RowBox[{"Underflow", "[", "]"}], "+", 
  RowBox[{
  "Zeta", "[", 
   "10000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000", "]"}]}]], "Output",
 ImageSize->{566, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80846827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224691178],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->141131646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HarmonicNumber", "[", 
  RowBox[{"2", ",", 
   RowBox[{"-", "10000."}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97671940],

Cell[BoxData["1.995063116880758384883742162683585`15.954589770191005*^3010"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->773421231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2264241],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->233010792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110390954],

Cell[TextData[{
 "Often results are expressed in ",
 Cell[BoxData[
  ButtonBox["PolyGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolyGamma"]], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["HarmonicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicNumber"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24733531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Zeta", "[", 
      RowBox[{"s", ",", 
       RowBox[{"z", "+", "1"}]}], "]"}], "-", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"s", "-", "1"}], ")"}]}]}], ",", 
    RowBox[{"s", " ", "->", " ", "1"}]}], "]"}], "-", "EulerGamma"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->4631249],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "EulerGamma"}], "-", 
  RowBox[{"PolyGamma", "[", 
   RowBox[{"0", ",", 
    RowBox[{"1", "+", "z"}]}], "]"}]}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560352294]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298459180],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"HarmonicNumber", "[", "z", "]"}]}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->233133269]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26459],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HarmonicMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicMean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZipfDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZipfDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->768]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28646],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->31142]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->22444],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/HarmonicNumber.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/HarmonicNumber/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->390835474],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->5886231],

Cell[TextData[ButtonBox["Recurrence and Sum Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RecurrenceAndSumFunctions"]], "MoreAbout",
 CellID->226741706]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HarmonicNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 24.9752264}", "context" -> "System`", 
    "keywords" -> {"harmonic numbers", "harmonic series"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HarmonicNumber[n] gives the n\\[Null]^th harmonic number H_n. \
HarmonicNumber[n, r] gives the harmonic number SubsuperscriptBox[H, n, (r)] \
of order r. ", "synonyms" -> {"harmonic number"}, "title" -> "HarmonicNumber",
     "type" -> "Symbol", "uri" -> "ref/HarmonicNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6191, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->809453547]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 70038, 2168}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2455, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3078, 85, 52, 1, 70, "ObjectName",
 CellID->12864],
Cell[3133, 88, 1342, 44, 70, "Usage",
 CellID->30845]
}, Open  ]],
Cell[CellGroupData[{
Cell[4512, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4990, 154, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5113, 160, 592, 22, 70, "Notes",
 CellID->9050],
Cell[5708, 184, 230, 7, 70, "Notes",
 CellID->31226],
Cell[5941, 193, 213, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6191, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->809453547],
Cell[CellGroupData[{
Cell[6576, 219, 147, 5, 70, "ExampleSection",
 CellID->36221989],
Cell[6726, 226, 70, 1, 70, "ExampleText",
 CellID->813793207],
Cell[CellGroupData[{
Cell[6821, 231, 215, 7, 28, "Input",
 CellID->12306575],
Cell[7039, 240, 509, 16, 51, "Output",
 CellID->16829161]
}, Open  ]],
Cell[7563, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->175089600],
Cell[7691, 264, 65, 1, 70, "ExampleText",
 CellID->538152488],
Cell[CellGroupData[{
Cell[7781, 269, 256, 8, 28, "Input",
 CellID->28651992],
Cell[8040, 279, 2002, 37, 126, "Output",
 Evaluatable->False,
 CellID->317498016]
}, Open  ]],
Cell[10057, 319, 125, 3, 70, "ExampleDelimiter",
 CellID->355275359],
Cell[10185, 324, 85, 1, 70, "ExampleText",
 CellID->180618872],
Cell[CellGroupData[{
Cell[10295, 329, 268, 9, 70, "Input",
 CellID->114079022],
Cell[10566, 340, 633, 19, 51, "Output",
 CellID->226045298]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11248, 365, 215, 7, 70, "ExampleSection",
 CellID->3187],
Cell[11466, 374, 84, 1, 70, "ExampleText",
 CellID->909420544],
Cell[CellGroupData[{
Cell[11575, 379, 152, 5, 70, "Input",
 CellID->92010879],
Cell[11730, 386, 1070, 17, 224, "Output",
 CellID->273622238]
}, Open  ]],
Cell[12815, 406, 125, 3, 70, "ExampleDelimiter",
 CellID->283539706],
Cell[12943, 411, 64, 1, 70, "ExampleText",
 CellID->41413152],
Cell[CellGroupData[{
Cell[13032, 416, 161, 5, 70, "Input",
 CellID->22399609],
Cell[13196, 423, 176, 5, 36, "Output",
 CellID->571262065]
}, Open  ]],
Cell[13387, 431, 124, 3, 70, "ExampleDelimiter",
 CellID->60251326],
Cell[13514, 436, 59, 1, 70, "ExampleText",
 CellID->6678469],
Cell[CellGroupData[{
Cell[13598, 441, 134, 4, 70, "Input",
 CellID->39754674],
Cell[13735, 447, 272, 7, 36, "Output",
 CellID->329426807]
}, Open  ]],
Cell[14022, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->428142147],
Cell[14150, 462, 70, 1, 70, "ExampleText",
 CellID->433415964],
Cell[CellGroupData[{
Cell[14245, 467, 187, 6, 70, "Input",
 CellID->18811731],
Cell[14435, 475, 235, 7, 36, "Output",
 CellID->558038215]
}, Open  ]],
Cell[14685, 485, 125, 3, 70, "ExampleDelimiter",
 CellID->146876751],
Cell[14813, 490, 113, 3, 70, "ExampleText",
 CellID->285495983],
Cell[CellGroupData[{
Cell[14951, 497, 143, 4, 70, "Input",
 CellID->53584202],
Cell[15097, 503, 229, 6, 36, "Output",
 CellID->534876192]
}, Open  ]],
Cell[15341, 512, 125, 3, 70, "ExampleDelimiter",
 CellID->143077582],
Cell[15469, 517, 233, 7, 70, "ExampleText",
 CellID->628379715],
Cell[CellGroupData[{
Cell[15727, 528, 191, 6, 70, "Input",
 CellID->413253680],
Cell[15921, 536, 360, 12, 51, "Output",
 CellID->116416692]
}, Open  ]],
Cell[16296, 551, 125, 3, 70, "ExampleDelimiter",
 CellID->748233439],
Cell[16424, 556, 73, 1, 70, "ExampleText",
 CellID->416310321],
Cell[CellGroupData[{
Cell[16522, 561, 231, 7, 70, "Input",
 CellID->612918841],
Cell[16756, 570, 1031, 34, 54, "Output",
 CellID->169463861]
}, Open  ]],
Cell[17802, 607, 124, 3, 70, "ExampleDelimiter",
 CellID->95505002],
Cell[17929, 612, 203, 7, 70, "ExampleText",
 CellID->456005606],
Cell[CellGroupData[{
Cell[18157, 623, 185, 6, 70, "Input",
 CellID->717378735],
Cell[18345, 631, 346, 12, 54, "Output",
 CellID->120690674]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18740, 649, 239, 7, 70, "ExampleSection",
 CellID->14535],
Cell[18982, 658, 72, 1, 70, "ExampleText",
 CellID->623198344],
Cell[CellGroupData[{
Cell[19079, 663, 233, 7, 70, "Input",
 CellID->133209954],
Cell[19315, 672, 877, 30, 53, "Output",
 CellID->442176435]
}, Open  ]],
Cell[20207, 705, 125, 3, 70, "ExampleDelimiter",
 CellID->329674912],
Cell[20335, 710, 221, 7, 70, "ExampleText",
 CellID->276712786],
Cell[CellGroupData[{
Cell[20581, 721, 284, 9, 70, "Input",
 CellID->257770211],
Cell[20868, 732, 609, 20, 54, "Output",
 CellID->222195328]
}, Open  ]],
Cell[CellGroupData[{
Cell[21514, 757, 290, 9, 70, "ExampleSubsection",
 CellID->338722534],
Cell[21807, 768, 71, 1, 70, "ExampleText",
 CellID->111981559],
Cell[CellGroupData[{
Cell[21903, 773, 133, 4, 70, "Input",
 CellID->188396411],
Cell[22039, 779, 330, 12, 36, "Output",
 CellID->202817043]
}, Open  ]],
Cell[CellGroupData[{
Cell[22406, 796, 152, 5, 70, "Input",
 CellID->560879010],
Cell[22561, 803, 380, 14, 54, "Output",
 CellID->484689932]
}, Open  ]],
Cell[CellGroupData[{
Cell[22978, 822, 144, 4, 70, "Input",
 CellID->58751469],
Cell[23125, 828, 205, 7, 54, "Output",
 CellID->51219804]
}, Open  ]],
Cell[23345, 838, 123, 3, 70, "ExampleDelimiter",
 CellID->7374867],
Cell[23471, 843, 73, 1, 70, "ExampleText",
 CellID->685270877],
Cell[CellGroupData[{
Cell[23569, 848, 256, 8, 70, "Input",
 CellID->36014350],
Cell[23828, 858, 1721, 52, 67, "Output",
 CellID->76815426]
}, Open  ]],
Cell[25564, 913, 125, 3, 70, "ExampleDelimiter",
 CellID->338250816],
Cell[25692, 918, 72, 1, 70, "ExampleText",
 CellID->897315048],
Cell[CellGroupData[{
Cell[25789, 923, 263, 8, 70, "Input",
 CellID->371239940],
Cell[26055, 933, 983, 32, 65, "Output",
 CellID->24566547]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27099, 972, 223, 7, 70, "ExampleSection",
 CellID->28364],
Cell[27325, 981, 90, 1, 70, "ExampleText",
 CellID->23658567],
Cell[CellGroupData[{
Cell[27440, 986, 384, 13, 70, "Input",
 CellID->227596600],
Cell[27827, 1001, 2160, 39, 70, "Output",
 Evaluatable->False,
 CellID->270539556]
}, Open  ]],
Cell[30002, 1043, 125, 3, 70, "ExampleDelimiter",
 CellID->256819879],
Cell[30130, 1048, 69, 1, 70, "ExampleText",
 CellID->7147496],
Cell[CellGroupData[{
Cell[30224, 1053, 430, 14, 70, "Input",
 CellID->585341952],
Cell[30657, 1069, 18943, 315, 70, "Output",
 Evaluatable->False,
 CellID->85562142]
}, Open  ]],
Cell[49615, 1387, 125, 3, 70, "ExampleDelimiter",
 CellID->147365854],
Cell[49743, 1392, 81, 1, 70, "ExampleText",
 CellID->3798961],
Cell[CellGroupData[{
Cell[49849, 1397, 818, 26, 70, "Input",
 CellID->131964898],
Cell[50670, 1425, 504, 12, 70, "Output",
 Evaluatable->False,
 CellID->685641936]
}, Open  ]],
Cell[51189, 1440, 125, 3, 70, "ExampleDelimiter",
 CellID->224637825],
Cell[51317, 1445, 389, 14, 70, "ExampleText",
 CellID->32608337],
Cell[51709, 1461, 545, 16, 70, "Input",
 CellID->13304398],
Cell[52257, 1479, 160, 7, 70, "ExampleText",
 CellID->328045278],
Cell[CellGroupData[{
Cell[52442, 1490, 115, 3, 70, "Input",
 CellID->194806077],
Cell[52560, 1495, 188, 6, 36, "Output",
 CellID->347220209]
}, Open  ]],
Cell[52763, 1504, 76, 1, 70, "ExampleText",
 CellID->298913145],
Cell[CellGroupData[{
Cell[52864, 1509, 394, 13, 70, "Input",
 CellID->633629622],
Cell[53261, 1524, 658, 18, 146, "Output",
 CellID->174111653]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53968, 1548, 233, 7, 70, "ExampleSection",
 CellID->17633],
Cell[54204, 1557, 247, 8, 70, "ExampleText",
 CellID->584391346],
Cell[CellGroupData[{
Cell[54476, 1569, 260, 8, 70, "Input",
 CellID->49284676],
Cell[54739, 1579, 242, 8, 36, "Output",
 CellID->200858610]
}, Open  ]],
Cell[CellGroupData[{
Cell[55018, 1592, 265, 8, 70, "Input",
 CellID->73747950],
Cell[55286, 1602, 167, 5, 36, "Output",
 CellID->628505739]
}, Open  ]],
Cell[55468, 1610, 125, 3, 70, "ExampleDelimiter",
 CellID->271538163],
Cell[55596, 1615, 71, 1, 70, "ExampleText",
 CellID->142936301],
Cell[CellGroupData[{
Cell[55692, 1620, 195, 6, 70, "Input",
 CellID->399234736],
Cell[55890, 1628, 231, 8, 51, "Output",
 CellID->130918145]
}, Open  ]],
Cell[56136, 1639, 124, 3, 70, "ExampleDelimiter",
 CellID->90232359],
Cell[56263, 1644, 48, 1, 70, "ExampleText",
 CellID->141968528],
Cell[CellGroupData[{
Cell[56336, 1649, 352, 12, 70, "Input",
 CellID->173872120],
Cell[56691, 1663, 1036, 35, 80, "Output",
 CellID->70774217]
}, Open  ]],
Cell[CellGroupData[{
Cell[57764, 1703, 272, 9, 70, "Input",
 CellID->39187168],
Cell[58039, 1714, 630, 20, 51, "Output",
 CellID->30371800]
}, Open  ]],
Cell[58684, 1737, 125, 3, 70, "ExampleDelimiter",
 CellID->665355700],
Cell[58812, 1742, 75, 1, 70, "ExampleText",
 CellID->48629001],
Cell[CellGroupData[{
Cell[58912, 1747, 200, 7, 70, "Input",
 CellID->138661707],
Cell[59115, 1756, 199, 6, 36, "Output",
 CellID->142388277]
}, Open  ]],
Cell[CellGroupData[{
Cell[59351, 1767, 503, 16, 70, "Input",
 CellID->273113457],
Cell[59857, 1785, 199, 6, 36, "Output",
 CellID->491975455]
}, Open  ]],
Cell[60071, 1794, 124, 3, 70, "ExampleDelimiter",
 CellID->64527705],
Cell[60198, 1799, 63, 1, 70, "ExampleText",
 CellID->746986739],
Cell[CellGroupData[{
Cell[60286, 1804, 298, 10, 70, "Input",
 CellID->351776757],
Cell[60587, 1816, 274, 10, 51, "Output",
 CellID->191038370]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60910, 1832, 226, 7, 70, "ExampleSection",
 CellID->19351],
Cell[61139, 1841, 120, 3, 70, "ExampleText",
 CellID->939476314],
Cell[CellGroupData[{
Cell[61284, 1848, 187, 6, 70, "Input",
 CellID->132468576],
Cell[61474, 1856, 358, 7, 70, "Message",
 CellID->636277062],
Cell[61835, 1865, 358, 7, 70, "Message",
 CellID->101906870],
Cell[62196, 1874, 350, 11, 71, "Output",
 CellID->80846827]
}, Open  ]],
Cell[62561, 1888, 125, 3, 70, "ExampleDelimiter",
 CellID->224691178],
Cell[62689, 1893, 113, 3, 70, "ExampleText",
 CellID->141131646],
Cell[CellGroupData[{
Cell[62827, 1900, 161, 5, 70, "Input",
 CellID->97671940],
Cell[62991, 1907, 220, 6, 36, "Output",
 CellID->773421231]
}, Open  ]],
Cell[CellGroupData[{
Cell[63248, 1918, 108, 3, 70, "Input",
 CellID->2264241],
Cell[63359, 1923, 162, 5, 36, "Output",
 CellID->233010792]
}, Open  ]],
Cell[63536, 1931, 125, 3, 70, "ExampleDelimiter",
 CellID->110390954],
Cell[63664, 1936, 363, 13, 70, "ExampleText",
 CellID->24733531],
Cell[CellGroupData[{
Cell[64052, 1953, 388, 14, 70, "Input",
 CellID->4631249],
Cell[64443, 1969, 293, 10, 36, "Output",
 CellID->560352294]
}, Open  ]],
Cell[CellGroupData[{
Cell[64773, 1984, 108, 3, 70, "Input",
 CellID->298459180],
Cell[64884, 1989, 217, 7, 36, "Output",
 CellID->233133269]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65162, 2003, 311, 9, 70, "SeeAlsoSection",
 CellID->26459],
Cell[65476, 2014, 1441, 53, 70, "SeeAlso",
 CellID->768]
}, Open  ]],
Cell[CellGroupData[{
Cell[66954, 2072, 314, 9, 70, "TutorialsSection",
 CellID->28646],
Cell[67271, 2083, 156, 3, 70, "Tutorials",
 CellID->31142]
}, Open  ]],
Cell[CellGroupData[{
Cell[67464, 2091, 321, 9, 70, "RelatedLinksSection",
 CellID->22444],
Cell[67788, 2102, 185, 4, 70, "RelatedLinks"],
Cell[67976, 2108, 199, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[68212, 2117, 319, 9, 70, "MoreAboutSection",
 CellID->390835474],
Cell[68534, 2128, 143, 3, 70, "MoreAbout",
 CellID->5886231],
Cell[68680, 2133, 165, 3, 70, "MoreAbout",
 CellID->226741706]
}, Open  ]],
Cell[68860, 2139, 27, 0, 70, "History"],
Cell[68890, 2141, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

