(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81913,       2132]
NotebookOptionsPosition[     72373,       1802]
NotebookOutlinePosition[     73899,       1843]
CellTagsIndexPosition[     73813,       1838]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FileHash" :> Documentation`HelpLookup["paclet:ref/FileHash"], 
          "LeafCount" :> Documentation`HelpLookup["paclet:ref/LeafCount"], 
          "ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"], 
          "Dispatch" :> Documentation`HelpLookup["paclet:ref/Dispatch"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FileHash\"\>", 
       2->"\<\"LeafCount\"\>", 3->"\<\"ByteCount\"\>", 
       4->"\<\"Dispatch\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Operations" :> 
          Documentation`HelpLookup["paclet:guide/StringOperations"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Cryptographic Number Theory\"\>", 
       3->"\<\"Expression Structure\"\>", 
       4->"\<\"Memory Measurement & Optimization\"\>", 
       5->"\<\"Processing Textual Data\"\>", 6->"\<\"String Manipulation\"\>",
        7->"\<\"String Operations\"\>", 
       8->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Hash", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hash",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hash"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an integer hash code for the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hash",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hash"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an integer hash code of the specified type for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hash"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " will always give the same result for the same expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25573],

Cell["Possible hash code types include:", "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->12017851],

Cell[BoxData[GridBox[{
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<Adler32\>\"", Cell[
    "Adler 32-bit cyclic redundancy check", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<CRC32\>\"", Cell[
    "32-bit cyclic redundancy check", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<MD2\>\"", Cell["128-bit MD2 code", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<MD5\>\"", Cell["128-bit MD5 code", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<SHA\>\"", Cell[
    "160-bit SHA-1 code", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<SHA256\>\"", Cell[
    "256-bit SHA code", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<SHA384\>\"", Cell[
    "384-bit SHA code", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "\"\<SHA512\>\"", Cell[
    "512-bit SHA code", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->175655438]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6351258],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->582010554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", "\"\<abcdef\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1512962700],

Cell[BoxData["1575585742"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17718255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20662737],

Cell["Digital fingerprint of data:", "ExampleText",
 CellID->1085143725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "12345", ",", " ", "6789", ",", " ", "987", ",", "654", ",", "321"}], 
    "}"}], ",", " ", "\"\<MD2\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2054161594],

Cell[BoxData["167257004965476806031456310312585699520"], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12094947]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->257710815],

Cell["Adler 32-bit cyclic redundancy check:", "ExampleText",
 CellID->1967724749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<Adler32\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1450527393],

Cell[BoxData["122487253"], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->909078780]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157587773],

Cell["32-bit cyclic redundancy check:", "ExampleText",
 CellID->339360334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<CRC32\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2060050753],

Cell[BoxData["597984631"], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1688390702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215354149],

Cell["128-bit MD2 code:", "ExampleText",
 CellID->1358178271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<MD2\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1298516734],

Cell[BoxData["322354034075603766540306127987207002195"], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2081100703]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->208013818],

Cell["128-bit MD5 code:", "ExampleText",
 CellID->760008435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<MD5\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229034689],

Cell[BoxData["21906482450215016189275517335020877676"], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->993356632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->701478470],

Cell["160-bit SHA code:", "ExampleText",
 CellID->697709232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<SHA\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1138349604],

Cell[BoxData["1030570503705012111868495778123991430137846255529"], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->807042246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1549687751],

Cell["256-bit SHA code:", "ExampleText",
 CellID->920360241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<SHA256\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1572638389],

Cell[BoxData[\
"61681857144829793587079671561031885544161628066571889561517304484841168609408\
"], "Output",
 ImageSize->{583, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452314070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169861146],

Cell["385-bit SHA code:", "ExampleText",
 CellID->850513959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<SHA385\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2052681547],

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{"10", "+", 
    SuperscriptBox["x", "2"]}], ",", "\<\"SHA385\"\>"}], "]"}]], "Output",
 ImageSize->{139, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2097947757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->936954481],

Cell["512-bit SHA code:", "ExampleText",
 CellID->2043862363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "10"}], ",", " ", "\"\<SHA512\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705190612],

Cell[BoxData[\
"78907084568447179612874161618380597042912003917936859215696392028175950462784\
47447715450740334370371411504631800105352829297927657863016022861623635425058"\
], "Output",
 ImageSize->{576, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->673951806]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->93434289],

Cell["Provide a \"checksum\" to validate data integrity: ", "ExampleText",
 CellID->138149182],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81409265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"check", "=", 
  RowBox[{"Hash", "[", 
   RowBox[{"data", ",", "\"\<CRC32\>\""}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->675015833],

Cell[BoxData["1248464743"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1279249164]
}, Open  ]],

Cell["Change some of the data: ", "ExampleText",
 CellID->39929778],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", "500", "]"}], "]"}], "=", 
   RowBox[{
    RowBox[{"data", "[", 
     RowBox[{"[", "500", "]"}], "]"}], "+", "1"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->455375062],

Cell["The checksum has changed: ", "ExampleText",
 CellID->9240451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hash", "[", 
  RowBox[{"data", ",", "\"\<CRC32\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->304255645],

Cell[BoxData["692396091"], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1881909231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "\[Equal]", "check"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->259577999],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1109292401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29694638],

Cell["A concatenated cryptographic hash function:", "ExampleText",
 CellID->1309381050],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "e_", "]"}], ":=", " ", 
  RowBox[{"BitOr", "[", 
   RowBox[{
    RowBox[{"Hash", "[", 
     RowBox[{"e", ",", "\"\<MD5\>\""}], "]"}], ",", " ", 
    RowBox[{"Hash", "[", 
     RowBox[{"e", ",", "\"\<SHA\>\""}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1502376541],

Cell["Hash code of \"abcdef\":", "ExampleText",
 CellID->346434020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->688407123],

Cell[BoxData["1030570503705303058599592643897935240160863977453"], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1571844000]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->266508382],

Cell["The hash is always the same for identical expressions:", "ExampleText",
 CellID->230561339],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e1", ",", "e2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "10"}], ",", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "10"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75951125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SameQ", "[", 
  RowBox[{"e1", ",", "e2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->198407312],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1785766253]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hash", "[", "e1", "]"}], ",", 
   RowBox[{"Hash", "[", "e2", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151174583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1509416946", ",", "1509416946"}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->141963699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->477216971],

Cell["Distinct hash codes come from distinct inputs:", "ExampleText",
 CellID->227757733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hash", "[", "123", "]"}], ",", 
   RowBox[{"Hash", "[", "124", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1220485197],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1508018759", ",", "1575638350"}], "}"}]], "Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129557276]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hash", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "10"}], "]"}], ",", 
   RowBox[{"Hash", "[", 
    RowBox[{
     RowBox[{"x", "^", "2."}], "+", "10"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->394785523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1514420981", ",", "527511728"}], "}"}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2068203321]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145806177],

Cell["Distinct inputs can give the same hash codes:", "ExampleText",
 CellID->663454954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hash", "[", "54327", "]"}], ",", 
   RowBox[{"Hash", "[", "10953", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49703757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23223", ",", "23223"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1122905705]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21906],

Cell["Distribution of hash values:", "ExampleText",
 CellID->516355452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hash", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95623425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->484919739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hash", "[", 
     RowBox[{"i", ",", "\"\<Adler32\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57142261],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->619758321]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hash", "[", 
     RowBox[{"i", ",", "\"\<CRC32\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->403216513],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->362603714]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hash", "[", 
     RowBox[{"i", ",", "\"\<MD2\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24111152],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->66880958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hash", "[", 
     RowBox[{"i", ",", "\"\<MD5\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3174155],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->165561958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hash", "[", 
     RowBox[{"i", ",", "\"\<SHA\>\""}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->46306045],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->17087324]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2224],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileHash",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileHash"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeafCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeafCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dispatch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dispatch"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22159]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->104049331],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->490998633],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->166940299],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->34283925],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->51374949],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->106495710],

Cell[TextData[ButtonBox["String Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringOperations"]], "MoreAbout",
 CellID->173852614],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->30424397]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hash - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 25.7877472}", "context" -> "System`", 
    "keywords" -> {
     "checksum", "CRC", "cryptographic hash function", "data digest", 
      "data integrity", "digital fingerprint", "hash code", "hash function", 
      "hash value", "hashcode", "hashing", "MD2", "MD5", "SHA", "SHA1", 
      "SHA2", "SHA-256", "SHA-384", "SHA-512"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hash[expr] gives an integer hash code for the expression expr. \
Hash[expr, \" type\"] gives an integer hash code of the specified type for \
expr.", "synonyms" -> {}, "title" -> "Hash", "type" -> "Symbol", "uri" -> 
    "ref/Hash"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12095, 302, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6351258]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 73671, 1831}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2666, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3289, 83, 4188, 83, 70, "ObjectNameGrid"],
Cell[7480, 168, 1016, 32, 70, "Usage",
 CellID->7804]
}, Open  ]],
Cell[CellGroupData[{
Cell[8533, 205, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9011, 222, 393, 14, 70, "Notes",
 CellID->25573],
Cell[9407, 238, 199, 4, 70, "Notes",
 CellID->12017851],
Cell[9609, 244, 2449, 53, 70, "2ColumnTableMod",
 CellID->175655438]
}, Closed]],
Cell[CellGroupData[{
Cell[12095, 302, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6351258],
Cell[CellGroupData[{
Cell[12478, 316, 148, 5, 70, "ExampleSection",
 CellID->582010554],
Cell[CellGroupData[{
Cell[12651, 325, 114, 3, 28, "Input",
 CellID->1512962700],
Cell[12768, 330, 166, 5, 36, "Output",
 CellID->17718255]
}, Open  ]],
Cell[12949, 338, 124, 3, 70, "ExampleDelimiter",
 CellID->20662737],
Cell[13076, 343, 72, 1, 70, "ExampleText",
 CellID->1085143725],
Cell[CellGroupData[{
Cell[13173, 348, 251, 8, 28, "Input",
 CellID->2054161594],
Cell[13427, 358, 196, 5, 36, "Output",
 CellID->12094947]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13672, 369, 220, 7, 70, "ExampleSection",
 CellID->257710815],
Cell[13895, 378, 81, 1, 70, "ExampleText",
 CellID->1967724749],
Cell[CellGroupData[{
Cell[14001, 383, 196, 7, 70, "Input",
 CellID->1450527393],
Cell[14200, 392, 166, 5, 36, "Output",
 CellID->909078780]
}, Open  ]],
Cell[14381, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->157587773],
Cell[14509, 405, 74, 1, 70, "ExampleText",
 CellID->339360334],
Cell[CellGroupData[{
Cell[14608, 410, 194, 7, 70, "Input",
 CellID->2060050753],
Cell[14805, 419, 167, 5, 36, "Output",
 CellID->1688390702]
}, Open  ]],
Cell[14987, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->215354149],
Cell[15115, 432, 61, 1, 70, "ExampleText",
 CellID->1358178271],
Cell[CellGroupData[{
Cell[15201, 437, 192, 7, 70, "Input",
 CellID->1298516734],
Cell[15396, 446, 198, 5, 36, "Output",
 CellID->2081100703]
}, Open  ]],
Cell[15609, 454, 125, 3, 70, "ExampleDelimiter",
 CellID->208013818],
Cell[15737, 459, 60, 1, 70, "ExampleText",
 CellID->760008435],
Cell[CellGroupData[{
Cell[15822, 464, 191, 7, 70, "Input",
 CellID->229034689],
Cell[16016, 473, 196, 5, 36, "Output",
 CellID->993356632]
}, Open  ]],
Cell[16227, 481, 125, 3, 70, "ExampleDelimiter",
 CellID->701478470],
Cell[16355, 486, 60, 1, 70, "ExampleText",
 CellID->697709232],
Cell[CellGroupData[{
Cell[16440, 491, 192, 7, 70, "Input",
 CellID->1138349604],
Cell[16635, 500, 207, 5, 36, "Output",
 CellID->807042246]
}, Open  ]],
Cell[16857, 508, 126, 3, 70, "ExampleDelimiter",
 CellID->1549687751],
Cell[16986, 513, 60, 1, 70, "ExampleText",
 CellID->920360241],
Cell[CellGroupData[{
Cell[17071, 518, 195, 7, 70, "Input",
 CellID->1572638389],
Cell[17269, 527, 239, 7, 54, "Output",
 CellID->452314070]
}, Open  ]],
Cell[17523, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->169861146],
Cell[17651, 542, 60, 1, 70, "ExampleText",
 CellID->850513959],
Cell[CellGroupData[{
Cell[17736, 547, 195, 7, 70, "Input",
 CellID->2052681547],
Cell[17934, 556, 277, 9, 39, "Output",
 CellID->2097947757]
}, Open  ]],
Cell[18226, 568, 125, 3, 70, "ExampleDelimiter",
 CellID->936954481],
Cell[18354, 573, 61, 1, 70, "ExampleText",
 CellID->2043862363],
Cell[CellGroupData[{
Cell[18440, 578, 194, 7, 70, "Input",
 CellID->705190612],
Cell[18637, 587, 318, 8, 71, "Output",
 CellID->673951806]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19004, 601, 226, 7, 70, "ExampleSection",
 CellID->93434289],
Cell[19233, 610, 94, 1, 70, "ExampleText",
 CellID->138149182],
Cell[19330, 613, 208, 7, 70, "Input",
 CellID->81409265],
Cell[CellGroupData[{
Cell[19563, 624, 166, 5, 70, "Input",
 CellID->675015833],
Cell[19732, 631, 168, 5, 36, "Output",
 CellID->1279249164]
}, Open  ]],
Cell[19915, 639, 67, 1, 70, "ExampleText",
 CellID->39929778],
Cell[19985, 642, 254, 9, 70, "Input",
 CellID->455375062],
Cell[20242, 653, 67, 1, 70, "ExampleText",
 CellID->9240451],
Cell[CellGroupData[{
Cell[20334, 658, 138, 4, 70, "Input",
 CellID->304255645],
Cell[20475, 664, 167, 5, 36, "Output",
 CellID->1881909231]
}, Open  ]],
Cell[CellGroupData[{
Cell[20679, 674, 103, 3, 70, "Input",
 CellID->259577999],
Cell[20785, 679, 163, 5, 36, "Output",
 CellID->1109292401]
}, Open  ]],
Cell[20963, 687, 124, 3, 70, "ExampleDelimiter",
 CellID->29694638],
Cell[21090, 692, 87, 1, 70, "ExampleText",
 CellID->1309381050],
Cell[21180, 695, 327, 10, 70, "Input",
 CellID->1502376541],
Cell[21510, 707, 67, 1, 70, "ExampleText",
 CellID->346434020],
Cell[CellGroupData[{
Cell[21602, 712, 145, 5, 70, "Input",
 CellID->688407123],
Cell[21750, 719, 208, 5, 36, "Output",
 CellID->1571844000]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22007, 730, 237, 7, 70, "ExampleSection",
 CellID->266508382],
Cell[22247, 739, 97, 1, 70, "ExampleText",
 CellID->230561339],
Cell[22347, 742, 318, 12, 70, "Input",
 CellID->75951125],
Cell[CellGroupData[{
Cell[22690, 758, 126, 4, 70, "Input",
 CellID->198407312],
Cell[22819, 764, 162, 5, 36, "Output",
 CellID->1785766253]
}, Open  ]],
Cell[CellGroupData[{
Cell[23018, 774, 181, 6, 70, "Input",
 CellID->151174583],
Cell[23202, 782, 222, 7, 36, "Output",
 CellID->141963699]
}, Open  ]],
Cell[23439, 792, 125, 3, 70, "ExampleDelimiter",
 CellID->477216971],
Cell[23567, 797, 89, 1, 70, "ExampleText",
 CellID->227757733],
Cell[CellGroupData[{
Cell[23681, 802, 184, 6, 70, "Input",
 CellID->1220485197],
Cell[23868, 810, 222, 7, 36, "Output",
 CellID->129557276]
}, Open  ]],
Cell[CellGroupData[{
Cell[24127, 822, 284, 10, 70, "Input",
 CellID->394785523],
Cell[24414, 834, 222, 7, 36, "Output",
 CellID->2068203321]
}, Open  ]],
Cell[24651, 844, 125, 3, 70, "ExampleDelimiter",
 CellID->145806177],
Cell[24779, 849, 88, 1, 70, "ExampleText",
 CellID->663454954],
Cell[CellGroupData[{
Cell[24892, 854, 186, 6, 70, "Input",
 CellID->49703757],
Cell[25081, 862, 213, 7, 36, "Output",
 CellID->1122905705]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25343, 875, 224, 7, 70, "ExampleSection",
 CellID->21906],
Cell[25570, 884, 71, 1, 70, "ExampleText",
 CellID->516355452],
Cell[CellGroupData[{
Cell[25666, 889, 246, 8, 70, "Input",
 CellID->95623425],
Cell[25915, 899, 4961, 85, 70, "Output",
 Evaluatable->False,
 CellID->484919739]
}, Open  ]],
Cell[CellGroupData[{
Cell[30913, 989, 286, 9, 70, "Input",
 CellID->57142261],
Cell[31202, 1000, 2900, 52, 70, "Output",
 Evaluatable->False,
 CellID->619758321]
}, Open  ]],
Cell[CellGroupData[{
Cell[34139, 1057, 285, 9, 70, "Input",
 CellID->403216513],
Cell[34427, 1068, 7777, 132, 70, "Output",
 Evaluatable->False,
 CellID->362603714]
}, Open  ]],
Cell[CellGroupData[{
Cell[42241, 1205, 282, 9, 70, "Input",
 CellID->24111152],
Cell[42526, 1216, 8624, 145, 70, "Output",
 Evaluatable->False,
 CellID->66880958]
}, Open  ]],
Cell[CellGroupData[{
Cell[51187, 1366, 281, 9, 70, "Input",
 CellID->3174155],
Cell[51471, 1377, 8723, 147, 70, "Output",
 Evaluatable->False,
 CellID->165561958]
}, Open  ]],
Cell[CellGroupData[{
Cell[60231, 1529, 282, 9, 70, "Input",
 CellID->46306045],
Cell[60516, 1540, 8795, 148, 70, "Output",
 Evaluatable->False,
 CellID->17087324]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[69372, 1695, 310, 9, 70, "SeeAlsoSection",
 CellID->2224],
Cell[69685, 1706, 945, 35, 70, "SeeAlso",
 CellID->22159]
}, Open  ]],
Cell[CellGroupData[{
Cell[70667, 1746, 299, 8, 70, "MoreAboutSection"],
Cell[70969, 1756, 193, 4, 70, "MoreAbout",
 CellID->104049331],
Cell[71165, 1762, 164, 3, 70, "MoreAbout",
 CellID->490998633],
Cell[71332, 1767, 151, 3, 70, "MoreAbout",
 CellID->166940299],
Cell[71486, 1772, 176, 3, 70, "MoreAbout",
 CellID->34283925],
Cell[71665, 1777, 155, 3, 70, "MoreAbout",
 CellID->51374949],
Cell[71823, 1782, 149, 3, 70, "MoreAbout",
 CellID->106495710],
Cell[71975, 1787, 145, 3, 70, "MoreAbout",
 CellID->173852614],
Cell[72123, 1792, 155, 3, 70, "MoreAbout",
 CellID->30424397]
}, Open  ]],
Cell[72293, 1798, 50, 0, 70, "History"],
Cell[72346, 1800, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

