(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57192,       1758]
NotebookOptionsPosition[     48808,       1464]
NotebookOutlinePosition[     50161,       1502]
CellTagsIndexPosition[     50075,       1497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HankelMatrix" :> 
          Documentation`HelpLookup["paclet:ref/HankelMatrix"], 
          "ToeplitzMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ToeplitzMatrix"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "Inverse" :> 
          Documentation`HelpLookup["paclet:ref/Inverse"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"HankelMatrix\"\>", 2->"\<\"ToeplitzMatrix\"\>", 
       3->"\<\"Table\"\>", 4->"\<\"Inverse\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HilbertMatrix", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HilbertMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HilbertMatrix"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Hilbert matrix with elements of the form ",
     Cell[BoxData[
      FormBox[
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"i", "+", "j", "-", "1"}], ")"}]}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HilbertMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HilbertMatrix"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["n", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Hilbert matrix."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HilbertMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HilbertMatrix"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HilbertMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HilbertMatrix"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["m", "TI"], ",", 
     StyleBox["n", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " gives a matrix with exact rational entries. "
}], "Notes",
 CellID->105339717],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HilbertMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HilbertMatrix"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["WorkingPrecision",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/WorkingPrecision"], "->", 
     StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
 " gives a matrix with entries of precision ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->305055708],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->26674442],

Cell["3\[Times]3 Hilbert matrix:", "ExampleText",
 CellID->281262578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HilbertMatrix", "[", "3", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6950570],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1SwkAQPhJAiYrIWCg2vIKWUKOVD5FhnIHC0UEKOkpKSkoegZKSkpKS
kpKSkjLu3o+5rOfkAhkHR5hJbvey+93u3uWD5dnvtl5e/W676VefOv57q938
qD6+dWDKzTDGGnjdMJADkPjVCAIYL+DugFqG0YWxhLMoBPzDitzqkswaraQO
d2HPcnx2PB5LqzzxQqssqFdk/oTr/X5f6i5Hy3JxuVxOp1MUT2NiKMnMPBXF
YrGgaKPRyBAbkzE5hnoUuL7dbnu9XojmqlkB+C02mmFRVlvENhgMwBVF5wvN
mc/ndf4U0oWko0955Ov1GsUaqYtuFdawpiIU2/GDVZ1UJWO0ErWazWZMfFx+
A10+9/Z8nifrmaOop2iFK+YgiCIZPStvutv0zFD9iGqHijzgaO+iGs+tvNM8
H79vhbkrPtb52b5yer3LMftRsEKN22XF57udGRNH6ox8ljhz9S1g4nU7tLiM
acx2dTzUM3fk9WS7f0hc+ZdQ/zOvV4Ior9vlXCF1pnxuxzt3xGu33aMou3Gg
npGJp+34OZ2M0txf7CuQYR6srGlHJLyGw2EiL5H1vrwc9mn6qtALbDYb06r3
XF+tVpPJBEW9o4BWRHZbZi9Y29DTwEISy5Shzt8FVadI30R7uhxBSforKER1
IBtEwzf2OgYFOdOBPHg0MoYwplsLb93e1VBEw2ePEtoLlGoQ5VvuxcT/ACzz
CckiXuE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{69, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->385490427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191616596],

Cell["3\[Times]5 Hilbert matrix:", "ExampleText",
 CellID->442245465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HilbertMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5"}], "}"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161819004],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD1vwjAQdRI+Cm2hX0NLF/5M26lzOxKhSiBUtaIMbIyMjIz8BEZGRkZG
RkZGRsb0zk4ac3USByJgSKRgn333nn1x/Ihf7U7j49PuNOt29aVtfzea9Z/q
81cbmiyDMdaC++meQd2BGr9bjgPlJfyaYN5AaUF5ha1YcfjFylK/3F7i0WXS
SqNLks0IOtrXStQsbx2NRm5rTjGmTFB0CPoZt3u9nmtb3C/Dq4vFYjKZ+F7h
czBddCxviX/eG/18Pqcsw+FQMScmodEMhtkYV+D2ZrPpdrs+m+W1CsJ/c1Jl
ziKjQLvI/fr9PkBh1fxDN2ezmc17IW2QvO1ePtPVaoXVGsmv7OU/i5o3YvHY
A7xskkVD6SVyO51Ombgs/gO22188cn+OjFc9CztBL2TMwiBKEWVRC42upjhr
VmWnrKfBijuXvLMFlRdaaEmu38N7YS48PdTRR72c5Ek0VdW4+nmuxRq1mnT1
dDe2KFSqp/EzGfTPQkdPk8lglJ7qsZzqu5DqaaqnKWuqp/t4VRw9PdXLbIVE
xdVRvf34MQI1SDcLO6Hr6qTeaqkoonX0MZnMBOnh4XUQv7txJ37X8qYnDSJq
MBjEihLZOLYe+ucn8qjh23m9XqtG/cbt5XI5Ho+xKn+Bw6e7e5qhjgJuxRkA
ELlYqgyF6WbBy/vWuQM9Q8kS1KhdIMqm763PasLskQ3fmLs9WVCLTMgLn407
B39ODwmgy3iWxCIOZJJj8fEES9UJ1zmOwsS5IzN+AbR2jDU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->15530783]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Hilbert matrix with machine-number entries:", "ExampleText",
 CellID->103482739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HilbertMatrix", "[", 
  RowBox[{"4", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39010945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.5`", ",", "0.3333333333333333`", ",", "0.25`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.3333333333333333`", ",", "0.25`", ",", "0.2`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3333333333333333`", ",", "0.25`", ",", "0.2`", ",", 
     "0.16666666666666666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.25`", ",", "0.2`", ",", "0.16666666666666666`", ",", 
     "0.14285714285714285`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{447, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41319155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109372500],

Cell["Hilbert matrix with 20-digit precision entries:", "ExampleText",
 CellID->61304242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HilbertMatrix", "[", 
  RowBox[{"4", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393456202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`20.", ",", "0.5`20.", ",", 
     "0.33333333333333333333333333333333333333`20.", ",", "0.25`20."}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
    "0.5`20.", ",", "0.33333333333333333333333333333333333333`20.", ",", 
     "0.25`20.", ",", "0.2`20."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.33333333333333333333333333333333333333`20.", ",", "0.25`20.", ",", 
     "0.2`20.", ",", "0.16666666666666666666666666666666666667`20."}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
    "0.25`20.", ",", "0.2`20.", ",", 
     "0.16666666666666666666666666666666666667`20.", ",", 
     "0.14285714285714285714285714285714285714`20."}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{524, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537610616]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2061341341],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1757724783],

Cell["A Hilbert matrix with machine-number entries:", "ExampleText",
 CellID->103759971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HilbertMatrix", "[", 
  RowBox[{"3", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103865504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.5`", ",", "0.3333333333333333`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.3333333333333333`", ",", "0.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3333333333333333`", ",", "0.25`", ",", "0.2`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{451, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22453064]
}, Open  ]],

Cell["A Hilbert matrix with 24-digit precision entries:", "ExampleText",
 CellID->760743172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HilbertMatrix", "[", 
  RowBox[{"3", ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "24"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->580574000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`24.", ",", "0.5`24.", ",", 
     "0.33333333333333333333333333333333333333`24."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.5`24.", ",", "0.33333333333333333333333333333333333333`24.", ",", 
     "0.25`24."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.33333333333333333333333333333333333333`24.", ",", "0.25`24.", ",", 
     "0.2`24."}], "}"}]}], "}"}]], "Output",
 ImageSize->{415, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->493666611]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Find the exact inverse of the 3\[Times]3 Hilbert matrix:\
\>", "ExampleText",
 CellID->18798084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Inverse", "[", 
  RowBox[{"HilbertMatrix", "[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350321825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", 
     RowBox[{"-", "36"}], ",", "30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "36"}], ",", "192", ",", 
     RowBox[{"-", "180"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30", ",", 
     RowBox[{"-", "180"}], ",", "180"}], "}"}]}], "}"}]], "Output",
 ImageSize->{328, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8409867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314799959],

Cell["\<\
Hilbert matrices are often used to compare numerical algorithms:\
\>", "ExampleText",
 CellID->63950668],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"HilbertMatrix", "[", 
    RowBox[{"12", ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "MachinePrecision"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117711756],

Cell[TextData[{
 "Compare methods for solving ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"h", ".", "x"}], "=", "b"}], TraditionalForm]], "InlineMath"],
 " for known ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->429923251],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "12", "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"h", ".", "x"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->111785237],

Cell[TextData[{
 "Solve using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"-", "1"}]], "b"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->772124487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xi", "=", 
  RowBox[{
   RowBox[{"Inverse", "[", "h", "]"}], ".", "b"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->328642612],

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(Inverse\\) of badly conditioned matrix \
\\!\\({\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)}\\) may contain significant \
numerical errors.\"\>"}]], "Message", "MSG",
 CellID->834749835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0000000153795554`", ",", "0.9999957839027047`", ",", 
   "1.0002145357429981`", ",", "0.9973160028457642`", ",", 
   "1.0053424835205078`", ",", "0.8727169036865234`", ",", 
   "1.0331077575683594`", ",", "0.41847991943359375`", ",", 
   "1.0399169921875`", ",", "0.65087890625`", ",", "1.0531234741210938`", ",",
    "0.9796385765075684`"}], "}"}]], "Output",
 ImageSize->{382, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->229802917]
}, Open  ]],

Cell[TextData[{
 "Solve using ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " with Gaussian elimination:"
}], "ExampleText",
 CellID->163444249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xge", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"h", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->220970302],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(LinearSolve\\) of badly conditioned matrix \
\\!\\({\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)}\\) may contain significant \
numerical errors.\"\>"}]], "Message", "MSG",
 CellID->49863705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999999929856638`", ",", "1.0000009810205843`", ",", 
   "0.999966760836714`", ",", "1.000480186804864`", ",", 
   "0.9963093682458088`", ",", "1.0168612356703783`", ",", 
   "0.9514545790934071`", ",", "1.0903627117858523`", ",", 
   "0.8914780182186689`", ",", "1.0811653778088468`", ",", 
   "0.9656251973441966`", ",", "1.0062956000850054`"}], "}"}]], "Output",
 ImageSize->{382, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->594488365]
}, Open  ]],

Cell[TextData[{
 "Solve using ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " using a Cholesky decomposition:"
}], "ExampleText",
 CellID->502965842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xch", " ", "=", " ", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"h", ",", "b", ",", 
    RowBox[{"Method", "\[Rule]", "\"\<Cholesky\>\""}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->526258790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0000000486125526`", ",", "0.9999938206718314`", ",", 
   "1.000194683657693`", ",", "0.9973446003580311`", ",", 
   "1.0194777323555286`", ",", "0.9143973201939603`", ",", 
   "1.2385182926463651`", ",", "0.568305785474638`", ",", 
   "1.5059878789163967`", ",", "0.6295393982348306`", ",", 
   "1.1539712851186117`", ",", "0.9722691212023814`"}], "}"}]], "Output",
 ImageSize->{389, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->143400003]
}, Open  ]],

Cell[TextData[{
 "Solve using ",
 Cell[BoxData[
  ButtonBox["LeastSquares",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeastSquares"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->255061124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xsvd", "=", 
  RowBox[{"LeastSquares", "[", 
   RowBox[{"h", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->33479586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0000000005059304`", ",", "0.9999999616706217`", ",", 
   "1.0000006998884008`", ",", "0.9999947635459973`", ",", 
   "1.000019024204029`", ",", "0.9999664391776925`", ",", 
   "1.0000194111670548`", ",", "1.0000189250613405`", ",", 
   "0.9999785440446866`", ",", "0.9999830164961673`", ",", 
   "1.0000297850743063`", ",", "0.9999894287267491`"}], "}"}]], "Output",
 ImageSize->{389, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->151329962]
}, Open  ]],

Cell["Compare errors:", "ExampleText",
 CellID->17944028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Norm", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "xi"}], ",", 
     RowBox[{"x", "-", "xge"}], ",", 
     RowBox[{"x", "-", "xch"}], ",", 
     RowBox[{"x", "-", "xsvd"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->437731675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6944163749296153`", ",", "0.17437411508362272`", ",", 
   "0.8177445261614152`", ",", "0.00006323616164968939`"}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->215272834]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["Square Hilbert matrices are real symmetric:", "ExampleText",
 CellID->438470212],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"HilbertMatrix", "[", 
    RowBox[{"RandomInteger", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "99"}], "}"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511632571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermitianMatrixQ", "[", "h", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->390308449],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245971705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"h", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"NumberQ", "[", "#", "]"}], "&&", 
     RowBox[{"!", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"#", ",", "_Complex"}], "]"}]}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->151912275],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->215138050]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33401349],

Cell[TextData[{
 "The smallest eigenvalue of a square Hilbert matrix decreases exponentially \
with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->557646548],

Cell[BoxData[
 RowBox[{
  RowBox[{"evs", "=", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Eigenvalues", "[", 
       RowBox[{
        RowBox[{"HilbertMatrix", "[", 
         RowBox[{"n", ",", 
          RowBox[{"WorkingPrecision", "\[Rule]", 
           RowBox[{
            RowBox[{"2", " ", "n"}], "+", "20"}]}]}], "]"}], ",", 
        RowBox[{"-", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "32"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118576340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", "evs", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91681744],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWF1rE0EU3SabpjQ2aZpqFT8oQhEqFDEVEVqsSitUFKFKEVpoLJUGNS1t
oQgWRFAQvx58Kvio/gGL/gBf9MlXn/0j48ze3dzJ2ensbFPxwUB2c3fOPfec
2bmzSa7XNpaXHtY26ou1watrtdXl+uL64NTKmryU7fA8b0e+Hxz25GchPwXv
HSHkWT+elcesHOoLzxl5zshzbxh7fgALXyUZ+BqqGMZxlMrNhqhCMHhOHdVl
EbyCCp7PMbHqiCLEWYh71CFHcfMYYzmgxU2p2ngJxjG/6y+pLyYy9CQw/Cvl
SXUx3+QrE+W1KOkOTtVwvOKmlBFhXl9affJjObFWV1ObfrXPTWNO1+iF/eV1
6nnm7EIifznBLekeDeemHJ6j3uwNz354LsF4CcaVm3hvx/eVE6DinfHqmyD+
+OHnxfHt16++kXbvqDxuBzvJCcG7UnwO/f25iiv1P61DXf7j+2/5+euXX+G9
wDvWD/GlhPEg5nXevNV5I/uLIJ69/UmCJq+892woqXSl8VkpNaOeida1VbCg
uKINxRXNqCdQsdeC4oo2FFc0ox5DxX4LiisSqvWZHT3RDxlzWQflxndu3HUq
EG+C0iNt8bCXNDwq3AQ/rvk50brvdcL4Ovg77sjbpcWm3Rufvevgn+oQjF6R
QnX2YU9wr8AzRBXwuYH+G+D/ZJCV/HTE6g3wRzz6KnDx0AAPxBJ9p93NQx08
nBKmbqqDQjNqSR3yTS4ZsRpLhsZ72oJiLkK59fIC+DvjuEaxBxdAaXs87CUN
j/I3D35GHfNNvaziOfDlype2h+fAN9XZzx6ehZm5IPQejjvKGfN5Jig/fTfP
glPiSdvNM+BmXLh08wx4oCzspxlQaEbdAAWXLSiuaENxRTNqGipOCfc+nwYd
lJu+P6dBaRoepWsKPFxLka/CSfDhmq9Wsx+1UTRXhlU+Cf5c+fWVhuvXM9SZ
gHm4KZL6HTsAFeD3/AmYKaqA9zOpzyZgPvbGMgZub4moW11+75rZ2BmxJX0b
GQMnlIU9dh6U3rGgWIENxRXNqCpUnBfuXV0FHZSbvquroHSvPCPg5W5bPOzL
lSd6auOK8cPrI+DTlTcPcVLvDcM83BNpu9s37BnDMCvEGjyBDV2E638YvGvZ
sX/LMHcI/NxPncuqKTfqVpw5jIdANWVjDw2CvlULipXYUFzRjDoGFTcsKK5I
qGiVRl1dhqwB4M6AImLJt86+YdXif5oDoOZRWzysJw2PCivgb8sxv3OXFVYB
X658uRgCO64CTrea909/0kQ9TOkaXYyvCM6fBriDiTqK4JDzsob5KIJqQuOz
A2t0g7bnQdZA6NGMZkWExvXfDUrMqBxUfmlBcUUNVdD3IPPvaw2d19HM93YX
BHNoCE0X/YvtdfwBvTIlng==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->484241294]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fit", "[", "n_", "]"}], "=", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Fit", "[", 
     RowBox[{
      RowBox[{"Log", "[", "evs", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "n"}], "}"}], ",", "n"}], "]"}], "]"}], " ", "/.", 
   " ", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"a_", "+", "b_"}], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"N", "[", "a", "]"}], "]"}], " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"N", "[", "b", "]"}], "]"}]}]}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->198901015],

Cell[BoxData[
 RowBox[{"106.54238144731468`", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "3.4745564968177334`"}], " ", "n"}]]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51874909]
}, Open  ]],

Cell[TextData[{
 "The model is a reasonable predictor of magnitude for larger values of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->39873233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"fit", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->734567185],

Cell[BoxData[
 RowBox[{"-", "148.87054896294705`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->106552134]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealExponent", "[", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{
    RowBox[{"HilbertMatrix", "[", 
     RowBox[{"100", ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "200"}]}], "]"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->44987001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "150.238094638566`"}], "}"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->167101825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371292830],

Cell[TextData[{
 "The condition number increases exponentially with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8101250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"capprox", "[", "n_", "]"}], "=", 
  RowBox[{"2", "/", 
   RowBox[{"(", 
    RowBox[{"79.9534307952165`", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "3.4421139525803413`"}], " ", "n"}]]}], 
    ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206282605],

Cell[BoxData[
 RowBox[{"0.025014561352877645`", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"3.4421139525803413`", " ", "n"}]]}]], "Output",
 ImageSize->{120, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19072974]
}, Open  ]],

Cell["\<\
The 2-norm condition number is the ration of largest to smallest eigenvalue \
due to symmetry:\
\>", "ExampleText",
 CellID->377273217],

Cell[BoxData[
 RowBox[{
  RowBox[{"cnos", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Apply", "[", 
      RowBox[{"Divide", ",", 
       RowBox[{
        RowBox[{"Eigenvalues", "[", 
         RowBox[{"HilbertMatrix", "[", 
          RowBox[{"n", ",", 
           RowBox[{"WorkingPrecision", "\[Rule]", 
            RowBox[{
             RowBox[{"2", "n"}], "+", "20"}]}]}], "]"}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}]}], "}"}], "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "32"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137562031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLogPlot", "[", "cnos", "]"}], ",", 
   RowBox[{"LogPlot", "[", 
    RowBox[{
     RowBox[{"capprox", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "32"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->31721101],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137676224]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"HilbertMatrix", "[", "10", "]"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176375359],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyVlrGKVDEYhaM2KSMGTBEkhrzFFjuFCraCpY1gLcK+hK2dgq8gO4qIYHER
ROzGQtC32EdwnJkwzPkTD+dyIezH3rPMzPexc/fp80fPrjvn7l1z7obr19V5
P/+8fPt7ex9+dqv/c7c65VfnGp/tdO4nO3P+eHf9MjtjHoD3nTnfnxuzM+YR
eN+Z8zev/10/zM6YJ+B9Z873r+ub2RnzDLzvzPmr9nB7fzU7Y16A950535+L
2RnzCrzvzHn+/mJ7fzE7Y96A9x3ks4484WovDrz1hKu99Oc2ZmfM1V4CeOsJ
V3uJ4K0nXO0lgbeecLWXfDgXszPmai8FvPWEq73Uw+fy2eyMeQPuJvzY0am3
gXC1l/73N2ZnzNVePHgbCFd7CeBtIFztJYK3gXC1l3Q4F7Mz5movGbwNhKu9
FPA2EK72UlcPbj+5+Hn/k9kZ8wbcT/ixo/3ZvY2Eq7048DYSrvbiwdtIuNpL
AG8j4Wov/bnF7Iy52ksCbyPhai8ZvI2Eq70U8DYSrvZSD5/7R7Mz5g14mPBj
R6feJsLVXhx4mwhXe/HgbSJc7aW/f4vZGXO1lwjeJsLVXhJ4mwhXe8ngbSJc
7aWAt4lwtZe6imfrW2frD2ZnzBvwOOHHjk69zYSrvTjwNhOu9tL/Py9mZ8zV
XgJ4mwlXe4ngbSZc7SWBt5lwtZcM3mbC1V4KeJsJV3upB6/em50xb8DThB87
OvW2EK720r83LmZnzNVePHhbCFd7CeBtIVztJYK3hXC1lwTeFsLVXjJ4WwhX
eyngbSFc7aWubu6utdkZ8wY8T/ixo/3Zva2Eq7048LYSrvbiwdtKuNpLAG8r
4WovEbythKu9JPC2Eq72ksHbSrjaSwFvK+FqL/25S7Mz5g14mfD++1fnp942
wtVeHHjbCFd78eBtI1ztJYC3jXC1lwjeNsLVXhJ42whXe8ngbSNc7aX7e2l2
xrwCr5Tf2V3vzM6YN+DV8L92+MEg
   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwt0HeUCAQcB/BzpM45bjrnlhvC3Vl3xi134lKKsiokdESyUtmZlaLSQlMq
W4OUEbIzKyOkjKhEGWWWMvrce/74/PN97/fe9/dNKh7Qtn9gQEDAXZThfT5g
BjMJohzBlCeEClQklBbcwZ20JIxwIogkhirEEkcSyaSQSk3SSCeDWtSmDnWp
RyZZ1OdN3uJt3qEBDWlENvEkkEhVcsglj3xuoSnNKOJWmnMbt9OYAgppQhSV
iKYy03iX6bxHq+vb3U1rOtKJ++nMA3ShK90YyGM8zhO8wqu8xmR68wh96Es/
+jOAR3mQYrrTo+SfUv6hGUUMkg1mCENpQ1va0Z57uJf76MBIRjGaMQxjOCN4
krGM4ymeZgITeZ4XeJFJvMTLPMN4nuW5kj11KqCQJoRQgYqEEkY4EUQyz818
PuQjPuYTFrCQtaxjPRv4io1sYjNfsJwVrORLVrGaNXzKIj7jcxazhKUsYwtb
2cbXHOQQP3GYneziO3azh718zz5+5w9OcJJv+Jbt7OAIP/MLv3KU3zjGcX7g
R/ZzgIfoSS8e5hSn+ZO/uMBF/uYfLvEv/3GZK1zlGgH2jaIS0VSmFIGUpgxB
lCOY8sxyNps5zOUGWVlu5CbOyM5yjvPEyKoQSxz1yCSL+lTjZqpTg5qkkU4G
8SSQSFWSSCaFVBrQkEZkk0MueeRTi9rUoS5TdJrK67zB/y+Nijg=
        "]]]}, {}, 
     {GrayLevel[0.82], EdgeForm[None], 
      GraphicsGroup3DBox[
       Polygon3DBox[{{37, 38, 39, 40}, {5, 6, 7, 8}, {1, 2, 3, 4}},
        VertexColors->None]]}, {}}, {Line3DBox[{2, 1, 4, 3, 2}], 
     Line3DBox[{6, 5, 8, 7, 6}], Line3DBox[{10, 9, 12, 11, 10}], 
     Line3DBox[{14, 13, 16, 15, 14}], Line3DBox[{18, 17, 20, 19, 18}], 
     Line3DBox[{22, 21, 24, 23, 22}], Line3DBox[{26, 25, 28, 27, 26}], 
     Line3DBox[{30, 29, 32, 31, 30}], Line3DBox[{34, 33, 36, 35, 34}], 
     Line3DBox[{38, 37, 40, 39, 38}], Line3DBox[{42, 41, 44, 43, 42}], 
     Line3DBox[{46, 45, 48, 47, 46}], Line3DBox[{50, 49, 52, 51, 50}], 
     Line3DBox[{54, 53, 56, 55, 54}], Line3DBox[{58, 57, 60, 59, 58}], 
     Line3DBox[{62, 61, 64, 63, 62}], Line3DBox[{66, 65, 68, 67, 66}], 
     Line3DBox[{70, 69, 72, 71, 70}], Line3DBox[{74, 73, 76, 75, 74}], 
     Line3DBox[{78, 77, 80, 79, 78}], Line3DBox[{82, 81, 84, 83, 82}], 
     Line3DBox[{86, 85, 88, 87, 86}], Line3DBox[{90, 89, 92, 91, 90}], 
     Line3DBox[{94, 93, 96, 95, 94}], Line3DBox[{98, 97, 100, 99, 98}], 
     Line3DBox[{102, 101, 104, 103, 102}], 
     Line3DBox[{106, 105, 108, 107, 106}], 
     Line3DBox[{110, 109, 112, 111, 110}], 
     Line3DBox[{114, 113, 116, 115, 114}], 
     Line3DBox[{118, 117, 120, 119, 118}], 
     Line3DBox[{122, 121, 124, 123, 122}], 
     Line3DBox[{126, 125, 128, 127, 126}], 
     Line3DBox[{130, 129, 132, 131, 130}], 
     Line3DBox[{134, 133, 136, 135, 134}], 
     Line3DBox[{138, 137, 140, 139, 138}], 
     Line3DBox[{142, 141, 144, 143, 142}], 
     Line3DBox[{146, 145, 148, 147, 146}], 
     Line3DBox[{150, 149, 152, 151, 150}], 
     Line3DBox[{154, 153, 156, 155, 154}], 
     Line3DBox[{158, 157, 160, 159, 158}], 
     Line3DBox[{162, 161, 164, 163, 162}], 
     Line3DBox[{166, 165, 168, 167, 166}], 
     Line3DBox[{170, 169, 172, 171, 170}], 
     Line3DBox[{174, 173, 176, 175, 174}], 
     Line3DBox[{178, 177, 180, 179, 178}], 
     Line3DBox[{182, 181, 184, 183, 182}], 
     Line3DBox[{186, 185, 188, 187, 186}], 
     Line3DBox[{190, 189, 192, 191, 190}], 
     Line3DBox[{194, 193, 196, 195, 194}], 
     Line3DBox[{198, 197, 200, 199, 198}], 
     Line3DBox[{202, 201, 204, 203, 202}], 
     Line3DBox[{206, 205, 208, 207, 206}], 
     Line3DBox[{210, 209, 212, 211, 210}], 
     Line3DBox[{214, 213, 216, 215, 214}], 
     Line3DBox[{218, 217, 220, 219, 218}], 
     Line3DBox[{222, 221, 224, 223, 222}], 
     Line3DBox[{226, 225, 228, 227, 226}], 
     Line3DBox[{230, 229, 232, 231, 230}], 
     Line3DBox[{234, 233, 236, 235, 234}], 
     Line3DBox[{238, 237, 240, 239, 238}], 
     Line3DBox[{242, 241, 244, 243, 242}], 
     Line3DBox[{246, 245, 248, 247, 246}], 
     Line3DBox[{250, 249, 252, 251, 250}], 
     Line3DBox[{254, 253, 256, 255, 254}], 
     Line3DBox[{258, 257, 260, 259, 258}], 
     Line3DBox[{262, 261, 264, 263, 262}], 
     Line3DBox[{266, 265, 268, 267, 266}], 
     Line3DBox[{270, 269, 272, 271, 270}], 
     Line3DBox[{274, 273, 276, 275, 274}], 
     Line3DBox[{278, 277, 280, 279, 278}], 
     Line3DBox[{282, 281, 284, 283, 282}], 
     Line3DBox[{286, 285, 288, 287, 286}], 
     Line3DBox[{290, 289, 292, 291, 290}], 
     Line3DBox[{294, 293, 296, 295, 294}], 
     Line3DBox[{298, 297, 300, 299, 298}], 
     Line3DBox[{302, 301, 304, 303, 302}], 
     Line3DBox[{306, 305, 308, 307, 306}], 
     Line3DBox[{310, 309, 312, 311, 310}], 
     Line3DBox[{314, 313, 316, 315, 314}], 
     Line3DBox[{318, 317, 320, 319, 318}], 
     Line3DBox[{322, 321, 324, 323, 322}]}},
   VertexNormals->CompressedData["
1:eJztyDERwCAABLCnKEFJlypAAnfMWEdCVxYcJGPaWH0+Sb6S1Nzs13vvvffe
e++9995777333nvvvT//B6bagX8=
    "]],
  Axes->True,
  BoxRatios->{1, 1, 0.4},
  ImageSize->{285., 230.0104241315247},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{1., 10.}, {1., 10.}, {0.058823529411764705`, 
   0.38461538461538464`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{1.840572192568367, -2.041694300748497, 1.9732659187841801`},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{289, 230},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314679878,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToeplitzMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToeplitzMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->135160784],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->533939402],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->77309435]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HilbertMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 35.7567524}", "context" -> "System`", 
    "keywords" -> {
     "Hilbert matrix", "ill-conditioned matrix", "matrix constructor", 
      "Cauchy matrix"}, "index" -> True, "label" -> "Mathematica Symbol", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "HilbertMatrix[n] gives the n*n Hilbert matrix with elements of the form \
1/(i + j - 1). HilbertMatrix[{m, n}] gives the m*n Hilbert matrix.", 
    "synonyms" -> {}, "title" -> "HilbertMatrix", "type" -> "Symbol", "uri" -> 
    "ref/HilbertMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5562, 184, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->305055708]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49932, 1490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1873, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2496, 69, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2555, 72, 1386, 46, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3978, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4456, 140, 539, 19, 70, "Notes",
 CellID->105339717],
Cell[4998, 161, 527, 18, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[5562, 184, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->305055708],
Cell[CellGroupData[{
Cell[5947, 198, 147, 5, 70, "ExampleSection",
 CellID->26674442],
Cell[6097, 205, 69, 1, 70, "ExampleText",
 CellID->281262578],
Cell[CellGroupData[{
Cell[6191, 210, 140, 4, 28, "Input",
 CellID->6950570],
Cell[6334, 216, 963, 20, 104, "Output",
 Evaluatable->False,
 CellID->385490427]
}, Open  ]],
Cell[7312, 239, 125, 3, 70, "ExampleDelimiter",
 CellID->191616596],
Cell[7440, 244, 69, 1, 70, "ExampleText",
 CellID->442245465],
Cell[CellGroupData[{
Cell[7534, 249, 191, 6, 28, "Input",
 CellID->161819004],
Cell[7728, 257, 1003, 20, 104, "Output",
 Evaluatable->False,
 CellID->15530783]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8780, 283, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9004, 292, 86, 1, 70, "ExampleText",
 CellID->103482739],
Cell[CellGroupData[{
Cell[9115, 297, 194, 6, 70, "Input",
 CellID->39010945],
Cell[9312, 305, 675, 21, 54, "Output",
 CellID->41319155]
}, Open  ]],
Cell[10002, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->109372500],
Cell[10130, 334, 89, 1, 70, "ExampleText",
 CellID->61304242],
Cell[CellGroupData[{
Cell[10244, 339, 178, 5, 70, "Input",
 CellID->393456202],
Cell[10425, 346, 883, 27, 122, "Output",
 CellID->537610616]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11357, 379, 223, 7, 70, "ExampleSection",
 CellID->2061341341],
Cell[CellGroupData[{
Cell[11605, 390, 238, 7, 70, "ExampleSubsection",
 CellID->1757724783],
Cell[11846, 399, 88, 1, 70, "ExampleText",
 CellID->103759971],
Cell[CellGroupData[{
Cell[11959, 404, 195, 6, 70, "Input",
 CellID->103865504],
Cell[12157, 412, 466, 14, 36, "Output",
 CellID->22453064]
}, Open  ]],
Cell[12638, 429, 92, 1, 70, "ExampleText",
 CellID->760743172],
Cell[CellGroupData[{
Cell[12755, 434, 178, 5, 70, "Input",
 CellID->580574000],
Cell[12936, 441, 590, 19, 105, "Output",
 CellID->493666611]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[13587, 467, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[13817, 476, 106, 3, 70, "ExampleText",
 CellID->18798084],
Cell[CellGroupData[{
Cell[13948, 483, 143, 4, 70, "Input",
 CellID->350321825],
Cell[14094, 489, 485, 17, 36, "Output",
 CellID->8409867]
}, Open  ]],
Cell[14594, 509, 125, 3, 70, "ExampleDelimiter",
 CellID->314799959],
Cell[14722, 514, 114, 3, 70, "ExampleText",
 CellID->63950668],
Cell[14839, 519, 242, 8, 70, "Input",
 CellID->117711756],
Cell[15084, 529, 285, 11, 70, "ExampleText",
 CellID->429923251],
Cell[15372, 542, 280, 10, 70, "Input",
 CellID->111785237],
Cell[15655, 554, 206, 9, 70, "ExampleText",
 CellID->772124487],
Cell[CellGroupData[{
Cell[15886, 567, 151, 5, 70, "Input",
 CellID->328642612],
Cell[16040, 574, 286, 6, 70, "Message",
 CellID->834749835],
Cell[16329, 582, 536, 13, 54, "Output",
 CellID->229802917]
}, Open  ]],
Cell[16880, 598, 227, 8, 70, "ExampleText",
 CellID->163444249],
Cell[CellGroupData[{
Cell[17132, 610, 156, 5, 70, "Input",
 CellID->220970302],
Cell[17291, 617, 293, 6, 70, "Message",
 CellID->49863705],
Cell[17587, 625, 541, 13, 54, "Output",
 CellID->594488365]
}, Open  ]],
Cell[18143, 641, 232, 8, 70, "ExampleText",
 CellID->502965842],
Cell[CellGroupData[{
Cell[18400, 653, 227, 6, 70, "Input",
 CellID->526258790],
Cell[18630, 661, 541, 13, 54, "Output",
 CellID->143400003]
}, Open  ]],
Cell[19186, 677, 203, 8, 70, "ExampleText",
 CellID->255061124],
Cell[CellGroupData[{
Cell[19414, 689, 157, 5, 70, "Input",
 CellID->33479586],
Cell[19574, 696, 542, 13, 54, "Output",
 CellID->151329962]
}, Open  ]],
Cell[20131, 712, 57, 1, 70, "ExampleText",
 CellID->17944028],
Cell[CellGroupData[{
Cell[20213, 717, 306, 10, 70, "Input",
 CellID->437731675],
Cell[20522, 729, 308, 9, 36, "Output",
 CellID->215272834]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20879, 744, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[21120, 753, 86, 1, 70, "ExampleText",
 CellID->438470212],
Cell[21209, 756, 247, 8, 70, "Input",
 CellID->511632571],
Cell[CellGroupData[{
Cell[21481, 768, 112, 3, 70, "Input",
 CellID->390308449],
Cell[21596, 773, 161, 5, 36, "Output",
 CellID->245971705]
}, Open  ]],
Cell[CellGroupData[{
Cell[21794, 783, 301, 10, 70, "Input",
 CellID->151912275],
Cell[22098, 795, 161, 5, 36, "Output",
 CellID->215138050]
}, Open  ]],
Cell[22274, 803, 124, 3, 70, "ExampleDelimiter",
 CellID->33401349],
Cell[22401, 808, 203, 7, 70, "ExampleText",
 CellID->557646548],
Cell[22607, 817, 551, 17, 70, "Input",
 CellID->118576340],
Cell[CellGroupData[{
Cell[23183, 838, 108, 3, 70, "Input",
 CellID->91681744],
Cell[23294, 843, 1640, 31, 70, "Output",
 Evaluatable->False,
 CellID->484241294]
}, Open  ]],
Cell[CellGroupData[{
Cell[24971, 879, 603, 20, 70, "Input",
 CellID->198901015],
Cell[25577, 901, 298, 9, 36, "Output",
 CellID->51874909]
}, Open  ]],
Cell[25890, 913, 190, 6, 70, "ExampleText",
 CellID->39873233],
Cell[CellGroupData[{
Cell[26105, 923, 140, 4, 70, "Input",
 CellID->734567185],
Cell[26248, 929, 193, 6, 36, "Output",
 CellID->106552134]
}, Open  ]],
Cell[CellGroupData[{
Cell[26478, 940, 309, 9, 70, "Input",
 CellID->44987001],
Cell[26790, 951, 214, 7, 36, "Output",
 CellID->167101825]
}, Open  ]],
Cell[27019, 961, 125, 3, 70, "ExampleDelimiter",
 CellID->371292830],
Cell[27147, 966, 169, 6, 70, "ExampleText",
 CellID->8101250],
Cell[CellGroupData[{
Cell[27341, 976, 329, 11, 70, "Input",
 CellID->206282605],
Cell[27673, 989, 280, 8, 36, "Output",
 CellID->19072974]
}, Open  ]],
Cell[27968, 1000, 145, 4, 70, "ExampleText",
 CellID->377273217],
Cell[28116, 1006, 680, 21, 70, "Input",
 CellID->137562031],
Cell[CellGroupData[{
Cell[28821, 1031, 325, 10, 70, "Input",
 CellID->31721101],
Cell[29149, 1043, 2522, 45, 70, "Output",
 Evaluatable->False,
 CellID->137676224]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31720, 1094, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[CellGroupData[{
Cell[31973, 1105, 264, 7, 70, "Input",
 CellID->176375359],
Cell[32240, 1114, 14331, 263, 251, 5966, 121, "CachedBoxData", "BoxData", \
"Output",
 CellID->314679878]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46632, 1384, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[46951, 1395, 957, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[47945, 1435, 299, 8, 70, "MoreAboutSection"],
Cell[48247, 1445, 153, 3, 70, "MoreAbout",
 CellID->135160784],
Cell[48403, 1450, 163, 3, 70, "MoreAbout",
 CellID->533939402],
Cell[48569, 1455, 197, 4, 70, "MoreAbout",
 CellID->77309435]
}, Open  ]],
Cell[48781, 1462, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

