(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35397,       1373]
NotebookOptionsPosition[     27590,       1097]
NotebookOutlinePosition[     28875,       1134]
CellTagsIndexPosition[     28789,       1129]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "Nonstandard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluation\"\>", 
       2->"\<\"Nonstandard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HoldPattern" :> 
          Documentation`HelpLookup["paclet:ref/HoldPattern"], "HoldForm" :> 
          Documentation`HelpLookup["paclet:ref/HoldForm"], "HoldComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldComplete"], "Unevaluated" :> 
          Documentation`HelpLookup["paclet:ref/Unevaluated"], "HoldAll" :> 
          Documentation`HelpLookup["paclet:ref/HoldAll"], "HoldAllComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldAllComplete"], "HoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/HoldFirst"], "HoldRest" :> 
          Documentation`HelpLookup["paclet:ref/HoldRest"], "Symbol" :> 
          Documentation`HelpLookup["paclet:ref/Symbol"], "Defer" :> 
          Documentation`HelpLookup["paclet:ref/Defer"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"HoldPattern\"\>", 2->"\<\"HoldForm\"\>", 
       3->"\<\"HoldComplete\"\>", 4->"\<\"Unevaluated\"\>", 
       5->"\<\"HoldAll\"\>", 6->"\<\"HoldAllComplete\"\>", 
       7->"\<\"HoldFirst\"\>", 8->"\<\"HoldRest\"\>", 9->"\<\"Symbol\"\>", 
       10->"\<\"Defer\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hold", "ObjectName",
 CellID->10747],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hold",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hold"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]maintains ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in an unevaluated form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and performs no operation on its arguments."
}], "Notes",
 CellID->24296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " is removed by ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16743948]
}], "Notes",
 CellID->7205],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " maintains a sequence of unevaluated expressions to which a function can be \
applied using ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24949],

Cell[TextData[{
 "Even though ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " itself is not evaluated, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " may still evaluate if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 ", and upvalues for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " have been defined. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->744300027]
}], "Notes",
 CellID->15406]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189120903],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->838553],

Cell["Hold an expression to prevent evaluation:", "ExampleText",
 CellID->261401519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"2", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140969503],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"2", "+", "2"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->847085599]
}, Open  ]],

Cell["Release the hold:", "ExampleText",
 CellID->32412275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->312810542],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75674560]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11707],

Cell["\<\
Find the length of each expression in a held list without evaluation:\
\>", "ExampleText",
 CellID->243073919],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", "=", 
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"1", "+", "2"}], ",", 
     RowBox[{"2", " ", "3", " ", "4", " ", "5"}], ",", 
     RowBox[{"1", "/", "0"}], ",", 
     RowBox[{"Quit", "[", "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332269707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"List", ",", 
   RowBox[{"Map", "[", 
    RowBox[{"Hold", ",", "list"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->548292886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"1", "+", "2"}], "]"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"2", " ", "3", " ", "4", " ", "5"}], "]"}], ",", 
   RowBox[{"Hold", "[", 
    FractionBox["1", "0"], "]"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"Quit", "[", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{362, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->345490917]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{
   RowBox[{"Hold", "[", "e_", "]"}], "\[RuleDelayed]", 
   RowBox[{"Length", "[", 
    RowBox[{"Unevaluated", "[", "e", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->930008042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "2", ",", "0"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->723726798]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337641943],

Cell["Evaluate every sum (only) inside a held expression:", "ExampleText",
 CellID->250240661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"Hold", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "2"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"3", "+", "4"}], ",", 
       RowBox[{"2", " ", "3"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"1", "+", 
       RowBox[{"g", "[", 
        RowBox[{"2", "+", "3"}], "]"}]}], "]"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->630151446],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", "2"}], ",", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"3", "+", "4"}], ",", 
      RowBox[{"2", " ", "3"}]}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"1", "+", 
      RowBox[{"g", "[", 
       RowBox[{"2", "+", "3"}], "]"}]}], "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297343614]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pos", "=", 
  RowBox[{"Position", "[", 
   RowBox[{"expr", ",", "_Plus"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385240204],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "1", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{300, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221054824]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"val", "=", 
  RowBox[{"Extract", "[", 
   RowBox[{"expr", ",", "pos"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413636470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "7", ",", "5", ",", 
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "5", "]"}]}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104969280]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplacePart", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"Thread", "[", 
    RowBox[{"pos", "->", "val"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13762670],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", 
    RowBox[{"g", "[", 
     RowBox[{"7", ",", 
      RowBox[{"2", " ", "3"}]}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"1", "+", 
      RowBox[{"g", "[", "5", "]"}]}], "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->415862253]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23529],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " is a container with the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->605051125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Hold", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33902385],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAll", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75259850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521836159],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92336356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165054271],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to force evaluation of an argument of ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27416402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "1"}], "]"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57342049],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"2", ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->576296654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->793270204],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " inside a held expression is not removed:"
}], "ExampleText",
 CellID->34412881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64023909],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"1", "+", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178327458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48451034],

Cell[TextData[{
 "Sequence splicing still happens inside ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->33093491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"2", "+", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47364311],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"2", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54007470]
}, Open  ]],

Cell[TextData[{
 "Use the the container ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " to suppress even such transformations:"
}], "ExampleText",
 CellID->740376950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"2", "+", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101985511],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{
    RowBox[{"1", "+", "1"}], ",", 
    RowBox[{"2", "+", "2"}]}], "]"}], "]"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96761247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2662870],

Cell[TextData[{
 "Upvalues work inside ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->744300027],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"Hold", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86481149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"h", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->743409494],

Cell[BoxData[
 RowBox[{"f", "[", "3", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->303810577]
}, Open  ]],

Cell[TextData[{
 "They do not work inside ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->37980363],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"HoldComplete", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->771360585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"h", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->665772393],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"h", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->78393663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->681709298],

Cell[TextData[{
 "Substitution works inside ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->868335451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"f", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "\[RuleDelayed]", 
   RowBox[{"g", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->518668429],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154652230]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83696512],

Cell["Insert into a held expression:", "ExampleText",
 CellID->9266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Insert", "[", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{"x", "+", "x"}], "]"}], ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23627],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"x", "+", "y", "+", "x"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9425]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->67404445],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " removes one level of ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->16743948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289358228],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306535930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465495102],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " is like ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ", but is normally not shown in the output:"
}], "ExampleText",
 CellID->386144431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23790528],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "2"}],
  HoldForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95330934]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19869159],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"HoldForm", "[", 
    RowBox[{"Plus", "[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->264092435]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7785],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldPattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unevaluated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unevaluated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAllComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAllComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldFirst",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldFirst"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldRest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldRest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Defer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Defer"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18334]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18810],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["Nonstandard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->12515]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->296955684],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->435639612],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->750003767]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hold - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 42.0225378}", "context" -> "System`", 
    "keywords" -> {
     "defer evaluation", "inert forms", "quote in Lisp", "quote in sh", 
      "evaluation control", "container", "freeze"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hold[expr] maintains expr in an unevaluated form. ", "synonyms" -> {}, 
    "title" -> "Hold", "type" -> "Symbol", "uri" -> "ref/Hold"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6782, 221, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->189120903]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28646, 1122}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2918, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3541, 90, 42, 1, 70, "ObjectName",
 CellID->10747],
Cell[3586, 93, 549, 18, 70, "Usage",
 CellID->13407]
}, Open  ]],
Cell[CellGroupData[{
Cell[4172, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4650, 133, 341, 12, 70, "Notes",
 CellID->24296],
Cell[4994, 147, 391, 15, 70, "Notes",
 CellID->7205],
Cell[5388, 164, 627, 23, 70, "Notes",
 CellID->24949],
Cell[6018, 189, 727, 27, 70, "Notes",
 CellID->15406]
}, Closed]],
Cell[CellGroupData[{
Cell[6782, 221, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189120903],
Cell[CellGroupData[{
Cell[7167, 235, 145, 5, 70, "ExampleSection",
 CellID->838553],
Cell[7315, 242, 84, 1, 70, "ExampleText",
 CellID->261401519],
Cell[CellGroupData[{
Cell[7424, 247, 123, 4, 28, "Input",
 CellID->140969503],
Cell[7550, 253, 211, 7, 36, "Output",
 CellID->847085599]
}, Open  ]],
Cell[7776, 263, 59, 1, 70, "ExampleText",
 CellID->32412275],
Cell[CellGroupData[{
Cell[7860, 268, 107, 3, 28, "Input",
 CellID->312810542],
Cell[7970, 273, 157, 5, 36, "Output",
 CellID->75674560]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8176, 284, 223, 7, 70, "ExampleSection",
 CellID->11707],
Cell[8402, 293, 120, 3, 70, "ExampleText",
 CellID->243073919],
Cell[8525, 298, 317, 10, 70, "Input",
 CellID->332269707],
Cell[CellGroupData[{
Cell[8867, 312, 189, 6, 70, "Input",
 CellID->548292886],
Cell[9059, 320, 473, 15, 51, "Output",
 CellID->345490917]
}, Open  ]],
Cell[CellGroupData[{
Cell[9569, 340, 236, 7, 70, "Input",
 CellID->930008042],
Cell[9808, 349, 223, 7, 36, "Output",
 CellID->723726798]
}, Open  ]],
Cell[10046, 359, 125, 3, 70, "ExampleDelimiter",
 CellID->337641943],
Cell[10174, 364, 94, 1, 70, "ExampleText",
 CellID->250240661],
Cell[CellGroupData[{
Cell[10293, 369, 445, 15, 70, "Input",
 CellID->630151446],
Cell[10741, 386, 497, 17, 36, "Output",
 CellID->297343614]
}, Open  ]],
Cell[CellGroupData[{
Cell[11275, 408, 160, 5, 70, "Input",
 CellID->385240204],
Cell[11438, 415, 470, 15, 36, "Output",
 CellID->221054824]
}, Open  ]],
Cell[CellGroupData[{
Cell[11945, 435, 157, 5, 70, "Input",
 CellID->413636470],
Cell[12105, 442, 278, 9, 36, "Output",
 CellID->104969280]
}, Open  ]],
Cell[CellGroupData[{
Cell[12420, 456, 196, 6, 70, "Input",
 CellID->13762670],
Cell[12619, 464, 417, 14, 36, "Output",
 CellID->415862253]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13085, 484, 233, 7, 70, "ExampleSection",
 CellID->23529],
Cell[13321, 493, 327, 12, 70, "ExampleText",
 CellID->605051125],
Cell[CellGroupData[{
Cell[13673, 509, 108, 3, 70, "Input",
 CellID->33902385],
Cell[13784, 514, 217, 7, 36, "Output",
 CellID->75259850]
}, Open  ]],
Cell[CellGroupData[{
Cell[14038, 526, 123, 4, 70, "Input",
 CellID->521836159],
Cell[14164, 532, 210, 7, 36, "Output",
 CellID->92336356]
}, Open  ]],
Cell[14389, 542, 125, 3, 70, "ExampleDelimiter",
 CellID->165054271],
Cell[14517, 547, 341, 13, 70, "ExampleText",
 CellID->27416402],
Cell[CellGroupData[{
Cell[14883, 564, 207, 7, 70, "Input",
 CellID->57342049],
Cell[15093, 573, 235, 8, 36, "Output",
 CellID->576296654]
}, Open  ]],
Cell[15343, 584, 125, 3, 70, "ExampleDelimiter",
 CellID->793270204],
Cell[15471, 589, 223, 7, 70, "ExampleText",
 CellID->34412881],
Cell[CellGroupData[{
Cell[15719, 600, 161, 5, 70, "Input",
 CellID->64023909],
Cell[15883, 607, 251, 8, 36, "Output",
 CellID->178327458]
}, Open  ]],
Cell[16149, 618, 124, 3, 70, "ExampleDelimiter",
 CellID->48451034],
Cell[16276, 623, 213, 8, 70, "ExampleText",
 CellID->33093491],
Cell[CellGroupData[{
Cell[16514, 635, 208, 7, 70, "Input",
 CellID->47364311],
Cell[16725, 644, 259, 9, 36, "Output",
 CellID->54007470]
}, Open  ]],
Cell[16999, 656, 251, 8, 70, "ExampleText",
 CellID->740376950],
Cell[CellGroupData[{
Cell[17275, 668, 217, 7, 70, "Input",
 CellID->101985511],
Cell[17495, 677, 305, 10, 36, "Output",
 CellID->96761247]
}, Open  ]],
Cell[17815, 690, 123, 3, 70, "ExampleDelimiter",
 CellID->2662870],
Cell[17941, 695, 244, 9, 70, "ExampleText",
 CellID->744300027],
Cell[18188, 706, 192, 6, 70, "Input",
 CellID->86481149],
Cell[CellGroupData[{
Cell[18405, 716, 152, 5, 70, "Input",
 CellID->743409494],
Cell[18560, 723, 185, 6, 36, "Output",
 CellID->303810577]
}, Open  ]],
Cell[18760, 732, 214, 8, 70, "ExampleText",
 CellID->37980363],
Cell[18977, 742, 201, 6, 70, "Input",
 CellID->771360585],
Cell[CellGroupData[{
Cell[19203, 752, 160, 5, 70, "Input",
 CellID->665772393],
Cell[19366, 759, 248, 8, 36, "Output",
 CellID->78393663]
}, Open  ]],
Cell[19629, 770, 125, 3, 70, "ExampleDelimiter",
 CellID->681709298],
Cell[19757, 775, 201, 8, 70, "ExampleText",
 CellID->868335451],
Cell[CellGroupData[{
Cell[19983, 787, 273, 9, 70, "Input",
 CellID->518668429],
Cell[20259, 798, 240, 8, 36, "Output",
 CellID->154652230]
}, Open  ]],
Cell[20514, 809, 124, 3, 70, "ExampleDelimiter",
 CellID->83696512],
Cell[20641, 814, 68, 1, 70, "ExampleText",
 CellID->9266],
Cell[CellGroupData[{
Cell[20734, 819, 237, 8, 70, "Input",
 CellID->23627],
Cell[20974, 829, 216, 7, 36, "Output",
 CellID->9425]
}, Open  ]],
Cell[21205, 839, 124, 3, 70, "ExampleDelimiter",
 CellID->67404445],
Cell[21332, 844, 369, 13, 70, "ExampleText",
 CellID->16743948],
Cell[CellGroupData[{
Cell[21726, 861, 162, 5, 70, "Input",
 CellID->289358228],
Cell[21891, 868, 158, 5, 36, "Output",
 CellID->306535930]
}, Open  ]],
Cell[22064, 876, 125, 3, 70, "ExampleDelimiter",
 CellID->465495102],
Cell[22192, 881, 344, 12, 70, "ExampleText",
 CellID->386144431],
Cell[CellGroupData[{
Cell[22561, 897, 126, 4, 70, "Input",
 CellID->23790528],
Cell[22690, 903, 202, 8, 36, "Output",
 CellID->95330934]
}, Open  ]],
Cell[CellGroupData[{
Cell[22929, 916, 103, 3, 70, "Input",
 CellID->19869159],
Cell[23035, 921, 385, 14, 50, "Output",
 CellID->264092435]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23481, 942, 310, 9, 70, "SeeAlsoSection",
 CellID->7785],
Cell[23794, 953, 2435, 89, 70, "SeeAlso",
 CellID->18334]
}, Open  ]],
Cell[CellGroupData[{
Cell[26266, 1047, 314, 9, 70, "TutorialsSection",
 CellID->18810],
Cell[26583, 1058, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[26721, 1063, 154, 3, 70, "Tutorials",
 CellID->12515]
}, Open  ]],
Cell[CellGroupData[{
Cell[26912, 1071, 319, 9, 70, "MoreAboutSection",
 CellID->296955684],
Cell[27234, 1082, 147, 3, 70, "MoreAbout",
 CellID->435639612],
Cell[27384, 1087, 134, 3, 70, "MoreAbout",
 CellID->750003767]
}, Open  ]],
Cell[27533, 1093, 27, 0, 70, "History"],
Cell[27563, 1095, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

