(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25022,        925]
NotebookOptionsPosition[     19470,        732]
NotebookOutlinePosition[     20893,        771]
CellTagsIndexPosition[     20808,        766]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HoldComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldComplete"], "HoldAll" :> 
          Documentation`HelpLookup["paclet:ref/HoldAll"], "SequenceHold" :> 
          Documentation`HelpLookup["paclet:ref/SequenceHold"], "Extract" :> 
          Documentation`HelpLookup["paclet:ref/Extract"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"HoldComplete\"\>", 2->"\<\"HoldAll\"\>", 
       3->"\<\"SequenceHold\"\>", 4->"\<\"Extract\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HoldAllComplete", "ObjectName",
 CellID->21313],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["HoldAllComplete",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that all arguments to a \
function are not to be modified or looked at in any way in the process of \
evaluation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->362]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "By setting the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " you can effectively shield the arguments of a function from all aspects of \
the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluation process. "
}], "Notes",
 CellID->14780],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " not only prevents arguments from being evaluated, but also prevents ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " objects from being flattened, ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " wrappers from being stripped, and upvalues associated with arguments from \
being used. "
}], "Notes",
 CellID->28818],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " cannot be used to override ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29728]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27499611],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->65842249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "HoldComplete", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261040525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAllComplete", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56691995]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "2"}], "]"}], ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"3", ",", "4"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->314322120],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "2"}], "]"}], ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"3", ",", "4"}], "]"}]}], "]"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->701731657]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->192527080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " is a standard container with attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->687662753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "HoldComplete", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->601891437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAllComplete", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123927074]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"Sequence", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"1", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8330348],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"Sequence", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"1", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29459886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444867753],

Cell[TextData[{
 "No form of evaluation control affects an expression with attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->367208524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735200059],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122208741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75234563],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80882219]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->229096853],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97443351]
}, Open  ]],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"HoldComplete", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->303477821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"g", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->338224222],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"g", "[", "1", "]"}], "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1403656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160349249],

Cell[TextData[{
 "Substitution still happens inside an expression with attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->271222859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldComplete", "[", 
   RowBox[{"f", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "\[RuleDelayed]", 
   RowBox[{"g", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198981184],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90618030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53528965],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9026422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"Sequence", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176747257],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241787992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->36529807],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 " affects only evaluation; input transformations are still applied:"
}], "ExampleText",
 CellID->30144002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"HoldComplete", "[", 
   RowBox[{
    RowBox[{"a", "-", "b"}], ",", 
    RowBox[{"a", "/", "b"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156234546],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"HoldComplete", "[", 
    RowBox[{
     RowBox[{"Plus", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Times", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "b"}], "]"}]}], "]"}], ",", 
     RowBox[{"Times", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Power", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->251363497]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->637296262],

Cell[TextData[{
 "A fast way to compute the Hofstadter\[Dash]Conway sequence ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Hofstadter-Conway10000-DollarSequence.\
html"], None}],
 ":"
}], "ExampleText",
 CellID->229715019],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"h", ",", "HoldAllComplete"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"hc", "[", 
   RowBox[{"m_Integer", "/;", 
    RowBox[{"m", "\[GreaterEqual]", "1"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{
        StyleBox["h", "Color1"], 
        StyleBox["@@", "Color1"], 
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", "m", "}"}]}], "]"}]}]}], ",", "i"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
      "=", "1"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"a", "\[LeftDoubleBracket]", "i", "\[RightDoubleBracket]"}], 
        "=", 
        RowBox[{
         RowBox[{"a", "\[LeftDoubleBracket]", 
          RowBox[{"a", "\[LeftDoubleBracket]", 
           RowBox[{"i", "-", "1"}], "\[RightDoubleBracket]"}], 
          "\[RightDoubleBracket]"}], "+", 
         RowBox[{"a", "\[LeftDoubleBracket]", 
          RowBox[{"i", "-", 
           RowBox[{"a", "\[LeftDoubleBracket]", 
            RowBox[{"i", "-", "1"}], "\[RightDoubleBracket]"}]}], 
          "\[RightDoubleBracket]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "m"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"a", "\[LeftDoubleBracket]", "m", "\[RightDoubleBracket]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->765058520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"hc", "[", 
   RowBox[{"5", " ", 
    RowBox[{"10", "^", "5"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20203159],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.047`", ",", "500000"}], "}"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->284368017]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6731],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SequenceHold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SequenceHold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extract"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23289],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->21713],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->4941]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->154334980],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->192433317]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HoldAllComplete - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 39.8506072}", "context" -> "System`", 
    "keywords" -> {
     "attribute", "container", "evaluation control", "inert value", 
      "lookahead", "Upvalues"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HoldAllComplete is an attribute which specifies that all arguments to a \
function are not to be modified or looked at in any way in the process of \
evaluation. ", "synonyms" -> {"hold all complete"}, "title" -> 
    "HoldAllComplete", "type" -> "Symbol", "uri" -> "ref/HoldAllComplete"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5423, 172, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->27499611]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20666, 759}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2309, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2932, 81, 53, 1, 70, "ObjectName",
 CellID->21313],
Cell[2988, 84, 541, 15, 70, "Usage",
 CellID->362]
}, Open  ]],
Cell[CellGroupData[{
Cell[3566, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4044, 121, 377, 12, 70, "Notes",
 CellID->14780],
Cell[4424, 135, 624, 18, 70, "Notes",
 CellID->28818],
Cell[5051, 155, 335, 12, 70, "Notes",
 CellID->29728]
}, Closed]],
Cell[CellGroupData[{
Cell[5423, 172, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27499611],
Cell[CellGroupData[{
Cell[5807, 186, 147, 5, 70, "ExampleSection",
 CellID->65842249],
Cell[CellGroupData[{
Cell[5979, 195, 117, 3, 28, "Input",
 CellID->261040525],
Cell[6099, 200, 225, 7, 36, "Output",
 CellID->56691995]
}, Open  ]],
Cell[CellGroupData[{
Cell[6361, 212, 287, 9, 28, "Input",
 CellID->314322120],
Cell[6651, 223, 376, 12, 36, "Output",
 CellID->701731657]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7076, 241, 237, 7, 70, "ExampleSection",
 CellID->192527080],
Cell[7316, 250, 364, 12, 70, "ExampleText",
 CellID->687662753],
Cell[CellGroupData[{
Cell[7705, 266, 117, 3, 70, "Input",
 CellID->601891437],
Cell[7825, 271, 226, 7, 36, "Output",
 CellID->123927074]
}, Open  ]],
Cell[CellGroupData[{
Cell[8088, 283, 214, 7, 70, "Input",
 CellID->8330348],
Cell[8305, 292, 304, 10, 36, "Output",
 CellID->29459886]
}, Open  ]],
Cell[8624, 305, 125, 3, 70, "ExampleDelimiter",
 CellID->444867753],
Cell[8752, 310, 264, 8, 70, "ExampleText",
 CellID->367208524],
Cell[CellGroupData[{
Cell[9041, 322, 131, 4, 70, "Input",
 CellID->735200059],
Cell[9175, 328, 220, 7, 36, "Output",
 CellID->122208741]
}, Open  ]],
Cell[CellGroupData[{
Cell[9432, 340, 166, 5, 70, "Input",
 CellID->75234563],
Cell[9601, 347, 255, 8, 36, "Output",
 CellID->80882219]
}, Open  ]],
Cell[CellGroupData[{
Cell[9893, 360, 167, 5, 70, "Input",
 CellID->229096853],
Cell[10063, 367, 255, 8, 36, "Output",
 CellID->97443351]
}, Open  ]],
Cell[10333, 378, 173, 5, 70, "Input",
 CellID->303477821],
Cell[CellGroupData[{
Cell[10531, 387, 136, 4, 70, "Input",
 CellID->338224222],
Cell[10670, 393, 223, 7, 36, "Output",
 CellID->1403656]
}, Open  ]],
Cell[10908, 403, 125, 3, 70, "ExampleDelimiter",
 CellID->160349249],
Cell[11036, 408, 260, 8, 70, "ExampleText",
 CellID->271222859],
Cell[CellGroupData[{
Cell[11321, 420, 281, 9, 70, "Input",
 CellID->198981184],
Cell[11605, 431, 248, 8, 36, "Output",
 CellID->90618030]
}, Open  ]],
Cell[11868, 442, 124, 3, 70, "ExampleDelimiter",
 CellID->53528965],
Cell[11995, 447, 339, 12, 70, "ExampleText",
 CellID->9026422],
Cell[CellGroupData[{
Cell[12359, 463, 201, 6, 70, "Input",
 CellID->176747257],
Cell[12563, 471, 158, 5, 36, "Output",
 CellID->241787992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12770, 482, 229, 7, 70, "ExampleSection",
 CellID->36529807],
Cell[13002, 491, 256, 7, 70, "ExampleText",
 CellID->30144002],
Cell[CellGroupData[{
Cell[13283, 502, 217, 7, 70, "Input",
 CellID->156234546],
Cell[13503, 511, 660, 23, 50, "Output",
 CellID->251363497]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14212, 540, 228, 7, 70, "ExampleSection",
 CellID->637296262],
Cell[14443, 549, 285, 9, 70, "ExampleText",
 CellID->229715019],
Cell[14731, 560, 1647, 46, 70, "Input",
 CellID->765058520],
Cell[CellGroupData[{
Cell[16403, 610, 180, 6, 70, "Input",
 CellID->20203159],
Cell[16586, 618, 214, 7, 36, "Output",
 CellID->284368017]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16861, 632, 310, 9, 70, "SeeAlsoSection",
 CellID->6731],
Cell[17174, 643, 953, 35, 70, "SeeAlso",
 CellID->12840]
}, Open  ]],
Cell[CellGroupData[{
Cell[18164, 683, 314, 9, 70, "TutorialsSection",
 CellID->23289],
Cell[18481, 694, 131, 3, 70, "Tutorials",
 CellID->21713],
Cell[18615, 699, 162, 3, 70, "Tutorials",
 CellID->4941]
}, Open  ]],
Cell[CellGroupData[{
Cell[18814, 707, 299, 8, 70, "MoreAboutSection"],
Cell[19116, 717, 132, 3, 70, "MoreAbout",
 CellID->154334980],
Cell[19251, 722, 147, 3, 70, "MoreAbout",
 CellID->192433317]
}, Open  ]],
Cell[19413, 728, 27, 0, 70, "History"],
Cell[19443, 730, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

