(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26870,       1020]
NotebookOptionsPosition[     20807,        808]
NotebookOutlinePosition[     22165,        845]
CellTagsIndexPosition[     22080,        840]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "Non\[Hyphen]Standard Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NonStandardEvaluation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluation\"\>", 
       2->"\<\"Non\[Hyphen]Standard Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hold" :> Documentation`HelpLookup["paclet:ref/Hold"], 
          "HoldPattern" :> Documentation`HelpLookup["paclet:ref/HoldPattern"],
           "HoldForm" :> Documentation`HelpLookup["paclet:ref/HoldForm"], 
          "Unevaluated" :> Documentation`HelpLookup["paclet:ref/Unevaluated"],
           "HoldAllComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldAllComplete"], "Symbol" :> 
          Documentation`HelpLookup["paclet:ref/Symbol"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Hold\"\>", 2->"\<\"HoldPattern\"\>", 
       3->"\<\"HoldForm\"\>", 4->"\<\"Unevaluated\"\>", 
       5->"\<\"HoldAllComplete\"\>", 6->"\<\"Symbol\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HoldComplete", "ObjectName",
 CellID->8080],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HoldComplete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HoldComplete"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]shields ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " completely from the standard ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " evaluation process, preventing even upvalues associated with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " from being used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3217]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ", and performs no operations on its arguments. "
}], "Notes",
 CellID->26824],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " is removed by ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->578479265]
}], "Notes",
 CellID->20449],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " can be inserted as a wrapper by such functions as ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplacePart"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->201665187]
}], "Notes",
 CellID->14086],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " is generated by default by ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15674]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->724508646],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->550908028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "2"}], "]"}], ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"3", ",", "4"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314322120],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"1", "+", "1"}], ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "+", "2"}], "]"}], ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"3", ",", "4"}], "]"}]}], "]"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->701731657]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " is the standard container with attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->687662753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "HoldComplete", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->601891437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"HoldAllComplete", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123927074]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"Sequence", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"1", "+", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8330348],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{
   RowBox[{"Sequence", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"1", "+", "2"}]}], "]"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29459886]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444867753],

Cell[TextData[{
 "No form of evaluation control affects an expression with attribute ",
 Cell[BoxData[
  ButtonBox["HoldAllComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAllComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->367208524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735200059],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399534417]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75234563],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->897676493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->229096853],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->761046215]
}, Open  ]],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"HoldComplete", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->303477821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"g", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->338224222],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"g", "[", "1", "]"}], "]"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->560880096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160349249],

Cell[TextData[{
 "Substitution still happens inside ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->271222859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldComplete", "[", 
   RowBox[{"f", "[", 
    RowBox[{"1", "+", "2"}], "]"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "\[RuleDelayed]", 
   RowBox[{"g", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198981184],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90618030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10449761],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " removes one level of ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->578479265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", 
  RowBox[{"HoldComplete", "[", 
   RowBox[{"Sequence", "[", 
    RowBox[{"1", ",", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131682627],

Cell[BoxData[
 RowBox[{"Sequence", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126483259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42647566],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " is a milder form of ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " that allows for some form of evaluation:"
}], "ExampleText",
 CellID->101804352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->479901957],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"1", "+", "2"}], "]"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446121972]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Evaluate", "[", 
   RowBox[{"1", "+", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3695832],

Cell[BoxData[
 RowBox[{"Hold", "[", "3", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->107228023]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->117685860],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->63040488]
}, Open  ]],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"Hold", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", "x"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->947278806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"g", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->165938642],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->41281100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302336027],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " can be used to freeze the result of ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " before it is evaluated:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->201665187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<Sequence[a,b]\>\"", ",", "InputForm", ",", "HoldComplete"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400773440],

Cell[BoxData[
 RowBox[{"HoldComplete", "[", 
  RowBox[{"Sequence", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306555965]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16876],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 " affects only evaluation; input transformations are still applied:"
}], "ExampleText",
 CellID->30144002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"HoldComplete", "[", 
   RowBox[{
    RowBox[{"a", "-", "b"}], ",", 
    RowBox[{"a", "/", "b"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156234546],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"HoldComplete", "[", 
    RowBox[{
     RowBox[{"Plus", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Times", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "b"}], "]"}]}], "]"}], ",", 
     RowBox[{"Times", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Power", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "1"}]}], "]"}]}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->152736325]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5230],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldPattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unevaluated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unevaluated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAllComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAllComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6582]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1257],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["Non\[Hyphen]Standard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->14185]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->428545603],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->50556829]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HoldComplete - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 41.1787662}", "context" -> "System`", 
    "keywords" -> {"container", "inert value", "evaluation control"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "HoldComplete[expr] shields expr completely from the standard Mathematica \
evaluation process, preventing even upvalues associated with expr from being \
used. ", "synonyms" -> {"hold complete"}, "title" -> "HoldComplete", "type" -> 
    "Symbol", "uri" -> "ref/HoldComplete"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6139, 202, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->724508646]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21937, 833}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2406, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3029, 83, 49, 1, 70, "ObjectName",
 CellID->8080],
Cell[3081, 86, 790, 24, 70, "Usage",
 CellID->3217]
}, Open  ]],
Cell[CellGroupData[{
Cell[3908, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4386, 132, 375, 12, 70, "Notes",
 CellID->26824],
Cell[4764, 146, 409, 15, 70, "Notes",
 CellID->20449],
Cell[5176, 163, 582, 20, 70, "Notes",
 CellID->14086],
Cell[5761, 185, 341, 12, 70, "Notes",
 CellID->15674]
}, Closed]],
Cell[CellGroupData[{
Cell[6139, 202, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->724508646],
Cell[CellGroupData[{
Cell[6524, 216, 148, 5, 70, "ExampleSection",
 CellID->550908028],
Cell[CellGroupData[{
Cell[6697, 225, 287, 9, 28, "Input",
 CellID->314322120],
Cell[6987, 236, 376, 12, 36, "Output",
 CellID->701731657]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7412, 254, 233, 7, 70, "ExampleSection",
 CellID->29696],
Cell[7648, 263, 366, 12, 70, "ExampleText",
 CellID->687662753],
Cell[CellGroupData[{
Cell[8039, 279, 117, 3, 70, "Input",
 CellID->601891437],
Cell[8159, 284, 226, 7, 36, "Output",
 CellID->123927074]
}, Open  ]],
Cell[CellGroupData[{
Cell[8422, 296, 214, 7, 70, "Input",
 CellID->8330348],
Cell[8639, 305, 304, 10, 36, "Output",
 CellID->29459886]
}, Open  ]],
Cell[8958, 318, 125, 3, 70, "ExampleDelimiter",
 CellID->444867753],
Cell[9086, 323, 264, 8, 70, "ExampleText",
 CellID->367208524],
Cell[CellGroupData[{
Cell[9375, 335, 131, 4, 70, "Input",
 CellID->735200059],
Cell[9509, 341, 220, 7, 36, "Output",
 CellID->399534417]
}, Open  ]],
Cell[CellGroupData[{
Cell[9766, 353, 166, 5, 70, "Input",
 CellID->75234563],
Cell[9935, 360, 256, 8, 36, "Output",
 CellID->897676493]
}, Open  ]],
Cell[CellGroupData[{
Cell[10228, 373, 167, 5, 70, "Input",
 CellID->229096853],
Cell[10398, 380, 256, 8, 36, "Output",
 CellID->761046215]
}, Open  ]],
Cell[10669, 391, 173, 5, 70, "Input",
 CellID->303477821],
Cell[CellGroupData[{
Cell[10867, 400, 136, 4, 70, "Input",
 CellID->338224222],
Cell[11006, 406, 225, 7, 36, "Output",
 CellID->560880096]
}, Open  ]],
Cell[11246, 416, 125, 3, 70, "ExampleDelimiter",
 CellID->160349249],
Cell[11374, 421, 225, 8, 70, "ExampleText",
 CellID->271222859],
Cell[CellGroupData[{
Cell[11624, 433, 281, 9, 70, "Input",
 CellID->198981184],
Cell[11908, 444, 248, 8, 36, "Output",
 CellID->90618030]
}, Open  ]],
Cell[12171, 455, 124, 3, 70, "ExampleDelimiter",
 CellID->10449761],
Cell[12298, 460, 386, 13, 70, "ExampleText",
 CellID->578479265],
Cell[CellGroupData[{
Cell[12709, 477, 207, 6, 70, "Input",
 CellID->131682627],
Cell[12919, 485, 216, 7, 36, "Output",
 CellID->126483259]
}, Open  ]],
Cell[13150, 495, 124, 3, 70, "ExampleDelimiter",
 CellID->42647566],
Cell[13277, 500, 363, 12, 70, "ExampleText",
 CellID->101804352],
Cell[CellGroupData[{
Cell[13665, 516, 123, 4, 70, "Input",
 CellID->479901957],
Cell[13791, 522, 211, 7, 36, "Output",
 CellID->446121972]
}, Open  ]],
Cell[CellGroupData[{
Cell[14039, 534, 157, 5, 70, "Input",
 CellID->3695832],
Cell[14199, 541, 188, 6, 36, "Output",
 CellID->107228023]
}, Open  ]],
Cell[CellGroupData[{
Cell[14424, 552, 159, 5, 70, "Input",
 CellID->117685860],
Cell[14586, 559, 210, 7, 36, "Output",
 CellID->63040488]
}, Open  ]],
Cell[14811, 569, 165, 5, 70, "Input",
 CellID->947278806],
Cell[CellGroupData[{
Cell[15001, 578, 128, 4, 70, "Input",
 CellID->165938642],
Cell[15132, 584, 157, 5, 36, "Output",
 CellID->41281100]
}, Open  ]],
Cell[15304, 592, 125, 3, 70, "ExampleDelimiter",
 CellID->302336027],
Cell[15432, 597, 426, 13, 70, "ExampleText",
 CellID->201665187],
Cell[CellGroupData[{
Cell[15883, 614, 183, 5, 70, "Input",
 CellID->400773440],
Cell[16069, 621, 256, 8, 36, "Output",
 CellID->306555965]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16374, 635, 226, 7, 70, "ExampleSection",
 CellID->16876],
Cell[16603, 644, 250, 7, 70, "ExampleText",
 CellID->30144002],
Cell[CellGroupData[{
Cell[16878, 655, 217, 7, 70, "Input",
 CellID->156234546],
Cell[17098, 664, 660, 23, 50, "Output",
 CellID->152736325]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17819, 694, 310, 9, 70, "SeeAlsoSection",
 CellID->5230],
Cell[18132, 705, 1444, 53, 70, "SeeAlso",
 CellID->6582]
}, Open  ]],
Cell[CellGroupData[{
Cell[19613, 763, 313, 9, 70, "TutorialsSection",
 CellID->1257],
Cell[19929, 774, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[20067, 779, 163, 3, 70, "Tutorials",
 CellID->14185]
}, Open  ]],
Cell[CellGroupData[{
Cell[20267, 787, 319, 9, 70, "MoreAboutSection",
 CellID->428545603],
Cell[20589, 798, 146, 3, 70, "MoreAbout",
 CellID->50556829]
}, Open  ]],
Cell[20750, 804, 27, 0, 70, "History"],
Cell[20780, 806, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

