(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16530,        605]
NotebookOptionsPosition[     12534,        470]
NotebookOutlinePosition[     13877,        508]
CellTagsIndexPosition[     13792,        503]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "Nonstandard Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/NonStandardEvaluation"], 
          "String\[Hyphen]Oriented Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringOrientedOutputFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluation\"\>", 
       2->"\<\"Nonstandard Evaluation\"\>", 
       3->"\<\"String\[Hyphen]Oriented Output Formats\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hold" :> Documentation`HelpLookup["paclet:ref/Hold"], "Defer" :> 
          Documentation`HelpLookup["paclet:ref/Defer"], "ToString" :> 
          Documentation`HelpLookup["paclet:ref/ToString"], "WriteString" :> 
          Documentation`HelpLookup["paclet:ref/WriteString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Hold\"\>", 2->"\<\"Defer\"\>", 
       3->"\<\"ToString\"\>", 4->"\<\"WriteString\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalTypesetting"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Mathematical Typesetting\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HoldForm", "ObjectName",
 CellID->28230],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HoldForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HoldForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " maintained in an unevaluated form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16589]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " allows you to see the output form of an expression without evaluating the \
expression. "
}], "Notes",
 CellID->8001],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22015],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " is removed by ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->3208921]
}], "Notes",
 CellID->32487]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117990727],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->243106130],

Cell["Addition in held form:", "ExampleText",
 CellID->230246158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369858528],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "1"}],
  HoldForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->903689357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130341500],

Cell["An unevaluated assignment:", "ExampleText",
 CellID->126091173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{"x", "=", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->437352395],

Cell[BoxData[
 TagBox[
  RowBox[{"x", "=", "3"}],
  HoldForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437833]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43620336],

Cell["An unevaluated power:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3208921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{"34", "^", "78"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2453034],

Cell[BoxData[
 TagBox[
  SuperscriptBox["34", "78"],
  HoldForm]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67158303]
}, Open  ]],

Cell[TextData[{
 "Evaluate the expression by applying ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9803214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6652150],

Cell[BoxData[\
"28533531705848602741140532416646474446336046000259807132996794946525068955782\
0764970048082035633315075321399848988573696"], "Output",
 ImageSize->{566, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->238054091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93491032],

Cell["Show a formula and its evaluation: ", "ExampleText",
 CellID->387972594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldForm", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}], "]"}], "==", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{"x", "^", "2"}]}], "]"}]}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->542004702],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        SuperscriptBox["x", "2"]}]]}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}],
   HoldForm], "\[Equal]", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}]], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Erf", "[", "x", "]"}]}]}]}]], "Output",
 ImageSize->{242, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269593272]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27327],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Defer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Defer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WriteString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WriteString"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4728],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["Nonstandard Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NonStandardEvaluation"]], "Tutorials",
 CellID->3029],

Cell[TextData[ButtonBox["String\[Hyphen]Oriented Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringOrientedOutputFormats"]], "Tutorials",
 CellID->9921]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->79169949],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->270271448],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->288139475]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HoldForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 41.7256552}", "context" -> "System`", 
    "keywords" -> {
     "output of unevaluated expressions", "preventing evaluation in printing",
       "printing without evaluation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HoldForm[expr] prints as the expression expr, with expr maintained in an \
unevaluated form. ", "synonyms" -> {"hold form"}, "title" -> "HoldForm", 
    "type" -> "Symbol", "uri" -> "ref/HoldForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5361, 175, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->117990727]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13649, 496}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2504, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3127, 85, 46, 1, 70, "ObjectName",
 CellID->28230],
Cell[3176, 88, 667, 21, 70, "Usage",
 CellID->16589]
}, Open  ]],
Cell[CellGroupData[{
Cell[3880, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4358, 131, 255, 8, 70, "Notes",
 CellID->8001],
Cell[4616, 141, 306, 12, 70, "Notes",
 CellID->22015],
Cell[4925, 155, 399, 15, 70, "Notes",
 CellID->32487]
}, Closed]],
Cell[CellGroupData[{
Cell[5361, 175, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117990727],
Cell[CellGroupData[{
Cell[5746, 189, 148, 5, 70, "ExampleSection",
 CellID->243106130],
Cell[5897, 196, 65, 1, 70, "ExampleText",
 CellID->230246158],
Cell[CellGroupData[{
Cell[5987, 201, 127, 4, 28, "Input",
 CellID->369858528],
Cell[6117, 207, 203, 8, 36, "Output",
 CellID->903689357]
}, Open  ]],
Cell[6335, 218, 125, 3, 70, "ExampleDelimiter",
 CellID->130341500],
Cell[6463, 223, 69, 1, 70, "ExampleText",
 CellID->126091173],
Cell[CellGroupData[{
Cell[6557, 228, 127, 4, 70, "Input",
 CellID->437352395],
Cell[6687, 234, 200, 8, 36, "Output",
 CellID->437833]
}, Open  ]],
Cell[6902, 245, 124, 3, 70, "ExampleDelimiter",
 CellID->43620336],
Cell[7029, 250, 110, 2, 70, "ExampleText",
 CellID->3208921],
Cell[CellGroupData[{
Cell[7164, 256, 127, 4, 70, "Input",
 CellID->2453034],
Cell[7294, 262, 205, 8, 36, "Output",
 CellID->67158303]
}, Open  ]],
Cell[7514, 273, 223, 8, 70, "ExampleText",
 CellID->9803214],
Cell[CellGroupData[{
Cell[7762, 285, 105, 3, 70, "Input",
 CellID->6652150],
Cell[7870, 290, 282, 7, 54, "Output",
 CellID->238054091]
}, Open  ]],
Cell[8167, 300, 124, 3, 70, "ExampleDelimiter",
 CellID->93491032],
Cell[8294, 305, 78, 1, 70, "ExampleText",
 CellID->387972594],
Cell[CellGroupData[{
Cell[8397, 310, 523, 18, 70, "Input",
 CellID->542004702],
Cell[8923, 330, 743, 27, 51, "Output",
 CellID->269593272]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9727, 364, 311, 9, 70, "SeeAlsoSection",
 CellID->27327],
Cell[10041, 375, 932, 35, 70, "SeeAlso",
 CellID->9488]
}, Open  ]],
Cell[CellGroupData[{
Cell[11010, 415, 313, 9, 70, "TutorialsSection",
 CellID->4728],
Cell[11326, 426, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[11464, 431, 153, 3, 70, "Tutorials",
 CellID->3029],
Cell[11620, 436, 175, 3, 70, "Tutorials",
 CellID->9921]
}, Open  ]],
Cell[CellGroupData[{
Cell[11832, 444, 318, 9, 70, "MoreAboutSection",
 CellID->79169949],
Cell[12153, 455, 147, 3, 70, "MoreAbout",
 CellID->270271448],
Cell[12303, 460, 159, 3, 70, "MoreAbout",
 CellID->288139475]
}, Open  ]],
Cell[12477, 466, 27, 0, 70, "History"],
Cell[12507, 468, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

