(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13091,        462]
NotebookOptionsPosition[      9830,        354]
NotebookOutlinePosition[     11137,        391]
CellTagsIndexPosition[     11052,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], "Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "Evaluation in Patterns, Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationInPatternsRulesAndDefinitions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"Evaluation\"\>", 
       3->"\<\"Evaluation in Patterns, Rules and Definitions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hold" :> Documentation`HelpLookup["paclet:ref/Hold"], 
          "Verbatim" :> Documentation`HelpLookup["paclet:ref/Verbatim"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Hold\"\>", 
       2->"\<\"Verbatim\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Evaluation Control\"\>", 
       2->"\<\"Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HoldPattern", "ObjectName",
 CellID->24592],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HoldPattern",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HoldPattern"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is equivalent to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " for pattern matching, but maintains ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in an unevaluated form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6413]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12808],

Cell[TextData[{
 "The left\[Hyphen]hand sides of rules are usually evaluated, as are parts of \
the left\[Hyphen]hand sides of assignments. You can use ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " to stop any part from being evaluated. "
}], "Notes",
 CellID->24052]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265645283],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->71709004],

Cell["Set up a pattern whose left-hand side is kept unevaluated:", \
"ExampleText",
 CellID->695670197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldPattern", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{"y_", ",", "x_"}], "]"}], "]"}], "\[Rule]", 
  RowBox[{"int", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->623890489],

Cell[BoxData[
 RowBox[{
  RowBox[{"HoldPattern", "[", 
   RowBox[{"\[Integral]", 
    RowBox[{"y_", 
     RowBox[{"\[DifferentialD]", "x_"}]}]}], "]"}], "\[Rule]", 
  RowBox[{"int", "[", "y", "]"}]}]], "Output",
 ImageSize->{205, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->670636139]
}, Open  ]],

Cell["Use the pattern:", "ExampleText",
 CellID->414747320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}], "+", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"g", "[", 
      RowBox[{"x", "^", "2"}], "]"}], ",", "x"}], "]"}]}], "/.", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->935652315],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}], "+", 
  RowBox[{"int", "[", 
   RowBox[{"g", "[", 
    SuperscriptBox["x", "2"], "]"}], "]"}]}]], "Output",
 ImageSize->{149, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->860438148]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37915676],

Cell[TextData[{
 "Make a definition without the argument of ",
 Cell[BoxData["f"], "InlineFormula"],
 " being evaluated:"
}], "ExampleText",
 CellID->190611109],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"Integrate", "[", 
     RowBox[{"y_", ",", "x_"}], "]"}], "]"}], "]"}], ":=", 
  RowBox[{"int", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188832975]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23946],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Verbatim",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Verbatim"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27576],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["Evaluation in Patterns, Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EvaluationInPatternsRulesAndDefinitions"]], "Tutorials",
 CellID->16924]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->446583245],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->373913979],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->399780468]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HoldPattern - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 42.3194204}", "context" -> "System`", 
    "keywords" -> {"unevaluated expressions", "unevaluated patterns"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "HoldPattern[expr] is equivalent to expr for pattern matching, but \
maintains expr in an unevaluated form. ", "synonyms" -> {"hold pattern"}, 
    "title" -> "HoldPattern", "type" -> "Symbol", "uri" -> 
    "ref/HoldPattern"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4886, 156, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->265645283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10909, 379}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2309, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2932, 82, 49, 1, 70, "ObjectName",
 CellID->24592],
Cell[2984, 85, 683, 21, 70, "Usage",
 CellID->6413]
}, Open  ]],
Cell[CellGroupData[{
Cell[3704, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4182, 128, 312, 12, 70, "Notes",
 CellID->12808],
Cell[4497, 142, 352, 9, 70, "Notes",
 CellID->24052]
}, Closed]],
Cell[CellGroupData[{
Cell[4886, 156, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265645283],
Cell[CellGroupData[{
Cell[5271, 170, 147, 5, 70, "ExampleSection",
 CellID->71709004],
Cell[5421, 177, 103, 2, 70, "ExampleText",
 CellID->695670197],
Cell[CellGroupData[{
Cell[5549, 183, 230, 7, 28, "Input",
 CellID->623890489],
Cell[5782, 192, 342, 11, 50, "Output",
 CellID->670636139]
}, Open  ]],
Cell[6139, 206, 59, 1, 70, "ExampleText",
 CellID->414747320],
Cell[CellGroupData[{
Cell[6223, 211, 332, 12, 28, "Input",
 CellID->935652315],
Cell[6558, 225, 325, 11, 39, "Output",
 CellID->860438148]
}, Open  ]],
Cell[6898, 239, 124, 3, 70, "ExampleDelimiter",
 CellID->37915676],
Cell[7025, 244, 160, 5, 70, "ExampleText",
 CellID->190611109],
Cell[7188, 251, 256, 8, 70, "Input",
 CellID->188832975]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7493, 265, 311, 9, 70, "SeeAlsoSection",
 CellID->23946],
Cell[7807, 276, 443, 17, 70, "SeeAlso",
 CellID->29958]
}, Open  ]],
Cell[CellGroupData[{
Cell[8287, 298, 314, 9, 70, "TutorialsSection",
 CellID->27576],
Cell[8604, 309, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[8785, 314, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[8923, 319, 198, 4, 70, "Tutorials",
 CellID->16924]
}, Open  ]],
Cell[CellGroupData[{
Cell[9158, 328, 319, 9, 70, "MoreAboutSection",
 CellID->446583245],
Cell[9480, 339, 147, 3, 70, "MoreAbout",
 CellID->373913979],
Cell[9630, 344, 128, 3, 70, "MoreAbout",
 CellID->399780468]
}, Open  ]],
Cell[9773, 350, 27, 0, 70, "History"],
Cell[9803, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

