(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57454,       1948]
NotebookOptionsPosition[     49210,       1667]
NotebookOutlinePosition[     51005,       1711]
CellTagsIndexPosition[     50919,       1706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Structural Operations on Polynomials\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Collect" :> Documentation`HelpLookup["paclet:ref/Collect"], 
          "Decompose" :> Documentation`HelpLookup["paclet:ref/Decompose"], 
          "Expand" :> Documentation`HelpLookup["paclet:ref/Expand"], "Fold" :> 
          Documentation`HelpLookup["paclet:ref/Fold"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Collect\"\>", 2->"\<\"Decompose\"\>", 
       3->"\<\"Expand\"\>", 4->"\<\"Fold\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Polynomial Factoring & Decomposition\"\>", 
       2->"\<\"New in 6.0: Symbolic Computation\"\>", 
       3->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["HornerForm", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HornerForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HornerForm"], "[", 
       StyleBox["poly", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]puts the polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " in Horner form."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HornerForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HornerForm"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]puts ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " in Horner form with respect to the variable or variable list ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HornerForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HornerForm"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], "/", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]puts the rational function ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["1", "TR"]], "/", 
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     " in Horner form by nesting ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HornerForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HornerForm"], "[", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["poly", "TI"], 
          StyleBox["1", "TR"]], "/", 
         SubscriptBox[
          StyleBox["poly", "TI"], 
          StyleBox["2", "TR"]]}], ",", 
        SubscriptBox[
         StyleBox["vars", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["vars", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]puts ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["1", "TR"]], "/", 
       SubscriptBox[
        StyleBox["poly", "TI"], 
        StyleBox["2", "TR"]]}]], "InlineFormula"],
     " in Horner form using the variables or variable lists ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["vars", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["vars", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " respectively."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->5912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When variables are not specified, ",
 Cell[BoxData[
  ButtonBox["HornerForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HornerForm"]], "InlineFormula"],
 " puts the polynomial or rational function into Horner form with respect to \
the variables identified using ",
 Cell[BoxData[
  ButtonBox["Variables",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variables"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9762]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64736271],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->679099221],

Cell[TextData[{
 "Horner form of a polynomial in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->592506442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{"11", " ", 
    RowBox[{"x", "^", "3"}]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"x", "^", "2"}]}], "+", 
   RowBox[{"7", " ", "x"}], "+", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119551135],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"7", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "+", 
        RowBox[{"11", " ", "x"}]}], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->543136736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->852016301],

Cell["\<\
Put a polynomial into Horner form with respect to a given variable:\
\>", "ExampleText",
 CellID->112414750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{"a", " ", "+", 
    RowBox[{"b", " ", "x"}], " ", "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233408764],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", 
     RowBox[{"c", " ", "x"}]}], ")"}]}]}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433420789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141653687],

Cell["Horner form of a rational function:", "ExampleText",
 CellID->190857180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"11", " ", 
      RowBox[{"x", "^", "3"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"7", " ", "x"}], "+", "2"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"3", "x"}], "+", "1"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159671057],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", "+", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"7", "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "4"}], "+", 
         RowBox[{"11", " ", "x"}]}], ")"}]}]}], ")"}]}]}], 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "x"}], ")"}], " ", "x"}]}]]], "Output",
 ImageSize->{147, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128620394]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->958],

Cell[TextData[{
 "Order a bivariate polynomial with respect to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " then ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->70499848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
    RowBox[{"2", " ", "x", " ", 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"x", "^", "2"}], " ", 
     RowBox[{"y", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43023306],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "y"}]}], ")"}]}], "+", 
    RowBox[{"x", " ", "y", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"4", " ", "y"}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->880893111]
}, Open  ]],

Cell[TextData[{
 "With respect to ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " then ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->41165889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
    RowBox[{"2", " ", "x", " ", 
     RowBox[{"y", "^", "2"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"x", "^", "2"}], " ", 
     RowBox[{"y", "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->115163031],

Cell[BoxData[
 RowBox[{"y", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], ")"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"4", " ", "x"}]}], ")"}], " ", "y"}]}], ")"}]}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127824042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81092989],

Cell["Construct a rational function in two variables:", "ExampleText",
 CellID->118455284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rf", "=", 
  RowBox[{
   RowBox[{"LegendreP", "[", 
    RowBox[{"5", ",", 
     RowBox[{
      RowBox[{"2", "x"}], "+", "y"}]}], "]"}], "/", 
   RowBox[{"LegendreP", "[", 
    RowBox[{"7", ",", 
     RowBox[{"x", "-", 
      RowBox[{"y", "/", "3"}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->654089494],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1458", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"30", " ", "x"}], "-", 
      RowBox[{"560", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"2016", " ", 
       SuperscriptBox["x", "5"]}], "+", 
      RowBox[{"15", " ", "y"}], "-", 
      RowBox[{"840", " ", 
       SuperscriptBox["x", "2"], " ", "y"}], "+", 
      RowBox[{"5040", " ", 
       SuperscriptBox["x", "4"], " ", "y"}], "-", 
      RowBox[{"420", " ", "x", " ", 
       SuperscriptBox["y", "2"]}], "+", 
      RowBox[{"5040", " ", 
       SuperscriptBox["x", "3"], " ", 
       SuperscriptBox["y", "2"]}], "-", 
      RowBox[{"70", " ", 
       SuperscriptBox["y", "3"]}], "+", 
      RowBox[{"2520", " ", 
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["y", "3"]}], "+", 
      RowBox[{"630", " ", "x", " ", 
       SuperscriptBox["y", "4"]}], "+", 
      RowBox[{"63", " ", 
       SuperscriptBox["y", "5"]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "25515"}], " ", "x"}], "+", 
    RowBox[{"229635", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"505197", " ", 
     SuperscriptBox["x", "5"]}], "+", 
    RowBox[{"312741", " ", 
     SuperscriptBox["x", "7"]}], "+", 
    RowBox[{"8505", " ", "y"}], "-", 
    RowBox[{"229635", " ", 
     SuperscriptBox["x", "2"], " ", "y"}], "+", 
    RowBox[{"841995", " ", 
     SuperscriptBox["x", "4"], " ", "y"}], "-", 
    RowBox[{"729729", " ", 
     SuperscriptBox["x", "6"], " ", "y"}], "+", 
    RowBox[{"76545", " ", "x", " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"561330", " ", 
     SuperscriptBox["x", "3"], " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"729729", " ", 
     SuperscriptBox["x", "5"], " ", 
     SuperscriptBox["y", "2"]}], "-", 
    RowBox[{"8505", " ", 
     SuperscriptBox["y", "3"]}], "+", 
    RowBox[{"187110", " ", 
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "3"]}], "-", 
    RowBox[{"405405", " ", 
     SuperscriptBox["x", "4"], " ", 
     SuperscriptBox["y", "3"]}], "-", 
    RowBox[{"31185", " ", "x", " ", 
     SuperscriptBox["y", "4"]}], "+", 
    RowBox[{"135135", " ", 
     SuperscriptBox["x", "3"], " ", 
     SuperscriptBox["y", "4"]}], "+", 
    RowBox[{"2079", " ", 
     SuperscriptBox["y", "5"]}], "-", 
    RowBox[{"27027", " ", 
     SuperscriptBox["x", "2"], " ", 
     SuperscriptBox["y", "5"]}], "+", 
    RowBox[{"3003", " ", "x", " ", 
     SuperscriptBox["y", "6"]}], "-", 
    RowBox[{"143", " ", 
     SuperscriptBox["y", "7"]}]}], ")"}]}]], "Output",
 ImageSize->{523, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127508929]
}, Open  ]],

Cell["Convert the function to Horner form:", "ExampleText",
 CellID->986546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", "rf", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->241013161],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{"21870", "+", 
       RowBox[{
        SuperscriptBox["y", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "102060"}], "+", 
          RowBox[{"91854", " ", 
           SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"43740", "+", 
       RowBox[{
        SuperscriptBox["y", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "612360"}], "+", 
          RowBox[{"918540", " ", 
           SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1224720"}], "+", 
             RowBox[{"3674160", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "816480"}], "+", 
             RowBox[{"7348320", " ", 
              SuperscriptBox["y", "2"]}], "+", 
             RowBox[{"x", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2939328", " ", "x"}], "+", 
                RowBox[{"7348320", " ", "y"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{"8505", "+", 
       RowBox[{
        SuperscriptBox["y", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8505"}], "+", 
          RowBox[{
           SuperscriptBox["y", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2079", "-", 
             RowBox[{"143", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "25515"}], "+", 
       RowBox[{
        SuperscriptBox["y", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"76545", "+", 
          RowBox[{
           SuperscriptBox["y", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "31185"}], "+", 
             RowBox[{"3003", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "229635"}], "+", 
             RowBox[{
              SuperscriptBox["y", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"187110", "-", 
                RowBox[{"27027", " ", 
                 SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{"229635", "+", 
             RowBox[{
              SuperscriptBox["y", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "561330"}], "+", 
                RowBox[{"135135", " ", 
                 SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
             RowBox[{"x", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"y", " ", 
                 RowBox[{"(", 
                  RowBox[{"841995", "-", 
                   RowBox[{"405405", " ", 
                    SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
                RowBox[{"x", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "505197"}], "+", 
                   RowBox[{"x", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"312741", " ", "x"}], "-", 
                    RowBox[{"729729", " ", "y"}]}], ")"}]}], "+", 
                   RowBox[{"729729", " ", 
                    SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{576, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122546987]
}, Open  ]],

Cell[TextData[{
 "Convert to Horner form using ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " before ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in the numerator:"
}], "ExampleText",
 CellID->68916485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{"rf", ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->331603469],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{"43740", "+", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "816480"}], "+", 
          RowBox[{"2939328", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{"21870", "+", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1224720"}], "+", 
          RowBox[{"7348320", " ", 
           SuperscriptBox["x", "2"]}]}], ")"}]}], "+", 
       RowBox[{"y", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "612360"}], "+", 
             RowBox[{"7348320", " ", 
              SuperscriptBox["x", "2"]}]}], ")"}]}], "+", 
          RowBox[{"y", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "102060"}], "+", 
             RowBox[{"3674160", " ", 
              SuperscriptBox["x", "2"]}], "+", 
             RowBox[{"y", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"918540", " ", "x"}], "+", 
                RowBox[{"91854", " ", "y"}]}], ")"}]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"(", 
      RowBox[{"8505", "+", 
       RowBox[{
        SuperscriptBox["y", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8505"}], "+", 
          RowBox[{
           SuperscriptBox["y", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2079", "-", 
             RowBox[{"143", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
    "+", 
    RowBox[{"x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "25515"}], "+", 
       RowBox[{
        SuperscriptBox["y", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"76545", "+", 
          RowBox[{
           SuperscriptBox["y", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "31185"}], "+", 
             RowBox[{"3003", " ", 
              SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "229635"}], "+", 
             RowBox[{
              SuperscriptBox["y", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"187110", "-", 
                RowBox[{"27027", " ", 
                 SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"x", " ", 
           RowBox[{"(", 
            RowBox[{"229635", "+", 
             RowBox[{
              SuperscriptBox["y", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "561330"}], "+", 
                RowBox[{"135135", " ", 
                 SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
             RowBox[{"x", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"y", " ", 
                 RowBox[{"(", 
                  RowBox[{"841995", "-", 
                   RowBox[{"405405", " ", 
                    SuperscriptBox["y", "2"]}]}], ")"}]}], "+", 
                RowBox[{"x", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"-", "505197"}], "+", 
                   RowBox[{"x", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"312741", " ", "x"}], "-", 
                    RowBox[{"729729", " ", "y"}]}], ")"}]}], "+", 
                   RowBox[{"729729", " ", 
                    SuperscriptBox["y", "2"]}]}], ")"}]}]}], ")"}]}]}], 
            ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{576, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->876918086]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5945],

Cell["An expression with rational exponents:", "ExampleText",
 CellID->379466461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], "+", "x", "+", 
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32393180],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["x"]}], ")"}], " ", 
     SuperscriptBox["x", 
      RowBox[{"2", "/", "3"}]]}]}], ")"}], " ", 
  SuperscriptBox["x", 
   RowBox[{"1", "/", "3"}]]}]], "Output",
 ImageSize->{147, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92930932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11367],

Cell["\<\
Improve speed and stability for numeric evaluation of large polynomials:\
\>", "ExampleText",
 CellID->56223688],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"dpoly", "[", "x_", "]"}], "=", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"LegendreP", "[", 
      RowBox[{"50", ",", "x"}], "]"}], ",", "x"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532751629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"dpoly", "[", "x", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "1.01"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "200"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18577187],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{241, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165955718]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"HornerForm", "[", 
      RowBox[{"dpoly", "[", "x", "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "1.01"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
    RowBox[{"PlotPoints", "\[Rule]", "200"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95521268],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{234, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->254946292]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17692],

Cell["\<\
Horner form of a rational function is the ratio of Horner forms:\
\>", "ExampleText",
 CellID->574632400],

Cell[BoxData[{
 RowBox[{
  RowBox[{"num", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "-", 
    RowBox[{"3", 
     RowBox[{"y", "^", "3"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"denom", "=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "+", 
    RowBox[{
     RowBox[{"x", "^", "2"}], " ", "y"}], "+", 
    RowBox[{"x", " ", "y"}], "+", 
    RowBox[{"3", 
     RowBox[{"y", "^", "3"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->76605683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{"num", "/", "denom"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31970491],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", 
    SuperscriptBox["y", "3"]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", "y"}], ")"}]}], "+", "y"}], ")"}]}]}], 
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["y", "3"]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"y", "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}]}]}]]], "Output",
 ImageSize->{146, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136491946]
}, Open  ]],

Cell["Obtained as a ratio of Horner forms:", "ExampleText",
 CellID->63069189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HornerForm", "[", "num", "]"}], "/", 
  RowBox[{"HornerForm", "[", "denom", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->313095797],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "3"}], " ", 
    SuperscriptBox["y", "3"]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"x", "-", "y"}], ")"}]}], "+", "y"}], ")"}]}]}], 
  RowBox[{
   RowBox[{"3", " ", 
    SuperscriptBox["y", "3"]}], "+", 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"y", "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"x", "+", "y"}], ")"}]}]}], ")"}]}]}]]], "Output",
 ImageSize->{146, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->535557102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->914797880],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HornerForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HornerForm"]], "InlineFormula"],
 " recursively factors out powers of variables:"
}], "ExampleText",
 CellID->216953880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lp", "=", 
  RowBox[{
   RowBox[{"LegendreP", "[", 
    RowBox[{"5", ",", "x"}], "]"}], " ", 
   RowBox[{"LegendreP", "[", 
    RowBox[{"3", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->923352040],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", "x"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "3"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"15", " ", "x"}], "-", 
    RowBox[{"70", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"63", " ", 
     SuperscriptBox["x", "5"]}]}], ")"}]}]], "Output",
 ImageSize->{225, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2135930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{"lp", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227840768],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["45", "16"]}], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox["285", "16"], "+", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["539", "16"]}], "+", 
          FractionBox[
           RowBox[{"315", " ", 
            SuperscriptBox["x", "2"]}], "16"]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{255, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67918338]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Collect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Collect"]], "InlineFormula"],
 " groups based on powers of variables:"
}], "ExampleText",
 CellID->164803224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"lp", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->682214648],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"45", " ", 
     SuperscriptBox["x", "2"]}], "16"]}], "+", 
  FractionBox[
   RowBox[{"285", " ", 
    SuperscriptBox["x", "4"]}], "16"], "-", 
  FractionBox[
   RowBox[{"539", " ", 
    SuperscriptBox["x", "6"]}], "16"], "+", 
  FractionBox[
   RowBox[{"315", " ", 
    SuperscriptBox["x", "8"]}], "16"]}]], "Output",
 ImageSize->{206, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51303160]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " gives the factored form:"
}], "ExampleText",
 CellID->228061181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "lp", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->238753684],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "16"], " ", 
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"15", "-", 
    RowBox[{"70", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"63", " ", 
     SuperscriptBox["x", "4"]}]}], ")"}]}]], "Output",
 ImageSize->{220, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->53419260]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21787],

Cell["Exponents must be integer or rational:", "ExampleText",
 CellID->457873731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "a"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131084472],

Cell[BoxData[
 RowBox[{
  RowBox[{"HornerForm", "::", "\<\"poly\"\>"}], ":", 
  " ", "\<\" \\!\\(1 + x\\^a\\) is not a valid polynomial in the variable \\!\
\\(x\\) \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"MessageLink\\\", ButtonFrame->None, ButtonData:>{\\\"System`\
\\\", \\\"HornerForm\\\", \\\"poly\\\"}, ButtonNote -> \\\"HornerForm::poly\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellID->343980487],

Cell[BoxData[
 RowBox[{"HornerForm", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    SuperscriptBox["x", "a"]}], ",", "x"}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325823871]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Range", "[", "10", "]"}], ".", 
  RowBox[{"x", "^", 
   RowBox[{"Range", "[", "10", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199360641],

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"7", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"9", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "10"]}]}]], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101974478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HornerForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->178796733],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWNtOwzAMzZpkgGCXRy4bGrwifgOe+IhqQtoeEGjsh9iPjrgkULlO7azV
VjZpW+we3+02zUu+Xry+5evlPJ89r/KPxXL+OXt6XzmW7inV+1JKjS6VW2/d
qvjCZ+O+7gL86sDbqjtE3ydeb4p/QLTpAq2GHcvSYxeyUqJ1kaXMMTK3gv8T
hAC+dWSf0CSRw3xODjwC8pTg18lZL5fqZ8yeVC41PlyBtvIjqQclZ32dgl6L
9By6QzENfnk3/5iRfJRp3BeFAlNWgTUUluwv7e1QfdeGHsPqISPoUETpGeZm
YX8Rkbms8Yy2W7WD9XRjesJsnwmkw72fwmtE9xk87hDt8TaCBz/7/h60i94Y
nq4eZ4WqZboVy0jhWGLP0fgMZsQs/q++w97HcsXdP6Q5pqZfXtG2rKb1kTRH
lJXdrUpjhQk0hJfH0MX72HtwVZM9W7OYb7WSuoJIf57GdqmyJ7rZyWbznDXz
mp/RI9tFKPlbzmBb/3aCM3WRiD9n8GV/IMdDBo93NiMGnyXiU+OlO4WLgpYa
i1D4ffLQPUf3ID7fwXW7IWPDqGsR6qrGFuAnlIclespcn7ToqwyFs0d3woCp
xGHOrIrzT1P2Fbr0tsLVUS6uRzhhmlbQhkCH8xRcdUtqiHsx9lbD+VXXsv1z
jgrLjWClet+HNyEl\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70730227]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17223],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decompose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decompose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fold"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11759]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5967],

Cell[TextData[ButtonBox["Structural Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnPolynomials"]], "Tutorials",
 CellID->3468]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->192428103],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->80457156],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->98267317],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->482216172]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HornerForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 47.9601898}", "context" -> "System`", 
    "keywords" -> {
     "efficient polynomial evaluation", "Horner form", 
      "polynomial representation", "rational function representation", 
      "recursive polynomial representation", "stable polynomial evaluation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "HornerForm[poly] puts the polynomial poly in Horner form. \
HornerForm[poly, vars] puts poly in Horner form with respect to the variable \
or variable list vars. HornerForm[poly_1/poly_2] puts the rational function \
poly_1/poly_2 in Horner form by nesting poly_1 and poly_2. \
HornerForm[poly_1/poly_2, vars_1, vars_2] puts poly_1/poly_2 in Horner form \
using the variables or variable lists vars_1 and vars_2 for poly_1 and poly_2 \
respectively.", "synonyms" -> {"horner form"}, "title" -> "HornerForm", 
    "type" -> "Symbol", "uri" -> "ref/HornerForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9255, 285, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->64736271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50777, 1699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2482, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3105, 85, 1575, 37, 70, "ObjectNameGrid"],
Cell[4683, 124, 3576, 120, 70, "Usage",
 CellID->5912]
}, Open  ]],
Cell[CellGroupData[{
Cell[8296, 249, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8774, 266, 444, 14, 70, "Notes",
 CellID->9762]
}, Closed]],
Cell[CellGroupData[{
Cell[9255, 285, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64736271],
Cell[CellGroupData[{
Cell[9639, 299, 148, 5, 70, "ExampleSection",
 CellID->679099221],
Cell[9790, 306, 152, 6, 70, "ExampleText",
 CellID->592506442],
Cell[CellGroupData[{
Cell[9967, 316, 272, 9, 28, "Input",
 CellID->119551135],
Cell[10242, 327, 388, 14, 36, "Output",
 CellID->543136736]
}, Open  ]],
Cell[10645, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->852016301],
Cell[10773, 349, 118, 3, 70, "ExampleText",
 CellID->112414750],
Cell[CellGroupData[{
Cell[10916, 356, 249, 8, 70, "Input",
 CellID->233408764],
Cell[11168, 366, 278, 10, 36, "Output",
 CellID->433420789]
}, Open  ]],
Cell[11461, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->141653687],
Cell[11589, 384, 78, 1, 70, "ExampleText",
 CellID->190857180],
Cell[CellGroupData[{
Cell[11692, 389, 437, 15, 70, "Input",
 CellID->159671057],
Cell[12132, 406, 537, 20, 53, "Output",
 CellID->128620394]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12718, 432, 214, 7, 70, "ExampleSection",
 CellID->958],
Cell[12935, 441, 233, 9, 70, "ExampleText",
 CellID->70499848],
Cell[CellGroupData[{
Cell[13193, 454, 455, 15, 70, "Input",
 CellID->43023306],
Cell[13651, 471, 450, 16, 36, "Output",
 CellID->880893111]
}, Open  ]],
Cell[14116, 490, 204, 9, 70, "ExampleText",
 CellID->41165889],
Cell[CellGroupData[{
Cell[14345, 503, 456, 15, 70, "Input",
 CellID->115163031],
Cell[14804, 520, 450, 16, 36, "Output",
 CellID->127824042]
}, Open  ]],
Cell[15269, 539, 124, 3, 70, "ExampleDelimiter",
 CellID->81092989],
Cell[15396, 544, 90, 1, 70, "ExampleText",
 CellID->118455284],
Cell[CellGroupData[{
Cell[15511, 549, 341, 12, 70, "Input",
 CellID->654089494],
Cell[15855, 563, 2739, 81, 113, "Output",
 CellID->127508929]
}, Open  ]],
Cell[18609, 647, 76, 1, 70, "ExampleText",
 CellID->986546],
Cell[CellGroupData[{
Cell[18710, 652, 107, 3, 70, "Input",
 CellID->241013161],
Cell[18820, 657, 4103, 124, 153, "Output",
 CellID->122546987]
}, Open  ]],
Cell[22938, 784, 236, 9, 70, "ExampleText",
 CellID->68916485],
Cell[CellGroupData[{
Cell[23199, 797, 238, 8, 70, "Input",
 CellID->331603469],
Cell[23440, 807, 4103, 124, 134, "Output",
 CellID->876918086]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27592, 937, 238, 7, 70, "ExampleSection",
 CellID->5945],
Cell[27833, 946, 81, 1, 70, "ExampleText",
 CellID->379466461],
Cell[CellGroupData[{
Cell[27939, 951, 288, 10, 70, "Input",
 CellID->32393180],
Cell[28230, 963, 424, 16, 43, "Output",
 CellID->92930932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28703, 985, 223, 7, 70, "ExampleSection",
 CellID->11367],
Cell[28929, 994, 122, 3, 70, "ExampleText",
 CellID->56223688],
Cell[29054, 999, 265, 9, 70, "Input",
 CellID->532751629],
Cell[CellGroupData[{
Cell[29344, 1012, 394, 12, 70, "Input",
 CellID->18577187],
Cell[29741, 1026, 3206, 57, 70, "Output",
 Evaluatable->False,
 CellID->165955718]
}, Open  ]],
Cell[CellGroupData[{
Cell[32984, 1088, 435, 13, 70, "Input",
 CellID->95521268],
Cell[33422, 1103, 2952, 52, 70, "Output",
 Evaluatable->False,
 CellID->254946292]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36423, 1161, 233, 7, 70, "ExampleSection",
 CellID->17692],
Cell[36659, 1170, 115, 3, 70, "ExampleText",
 CellID->574632400],
Cell[36777, 1175, 550, 20, 70, "Input",
 CellID->76605683],
Cell[CellGroupData[{
Cell[37352, 1199, 134, 4, 70, "Input",
 CellID->31970491],
Cell[37489, 1205, 663, 25, 57, "Output",
 CellID->136491946]
}, Open  ]],
Cell[38167, 1233, 78, 1, 70, "ExampleText",
 CellID->63069189],
Cell[CellGroupData[{
Cell[38270, 1238, 172, 5, 70, "Input",
 CellID->313095797],
Cell[38445, 1245, 663, 25, 57, "Output",
 CellID->535557102]
}, Open  ]],
Cell[39123, 1273, 125, 3, 70, "ExampleDelimiter",
 CellID->914797880],
Cell[39251, 1278, 226, 7, 70, "ExampleText",
 CellID->216953880],
Cell[CellGroupData[{
Cell[39502, 1289, 240, 8, 70, "Input",
 CellID->923352040],
Cell[39745, 1299, 545, 20, 51, "Output",
 CellID->2135930]
}, Open  ]],
Cell[CellGroupData[{
Cell[40327, 1324, 130, 4, 70, "Input",
 CellID->227840768],
Cell[40460, 1330, 709, 26, 54, "Output",
 CellID->67918338]
}, Open  ]],
Cell[41184, 1359, 212, 7, 70, "ExampleText",
 CellID->164803224],
Cell[CellGroupData[{
Cell[41421, 1370, 127, 4, 70, "Input",
 CellID->682214648],
Cell[41551, 1376, 516, 19, 54, "Output",
 CellID->51303160]
}, Open  ]],
Cell[42082, 1398, 198, 7, 70, "ExampleText",
 CellID->228061181],
Cell[CellGroupData[{
Cell[42305, 1409, 103, 3, 70, "Input",
 CellID->238753684],
Cell[42411, 1414, 529, 19, 51, "Output",
 CellID->53419260]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42989, 1439, 226, 7, 70, "ExampleSection",
 CellID->21787],
Cell[43218, 1448, 81, 1, 70, "ExampleText",
 CellID->457873731],
Cell[CellGroupData[{
Cell[43324, 1453, 178, 6, 70, "Input",
 CellID->131084472],
Cell[43505, 1461, 423, 8, 70, "Message",
 CellID->343980487],
Cell[43931, 1471, 268, 9, 36, "Output",
 CellID->325823871]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44248, 1486, 224, 7, 70, "ExampleSection",
 CellID->30556],
Cell[CellGroupData[{
Cell[44497, 1497, 182, 6, 70, "Input",
 CellID->199360641],
Cell[44682, 1505, 695, 24, 36, "Output",
 CellID->101974478]
}, Open  ]],
Cell[CellGroupData[{
Cell[45414, 1534, 106, 3, 70, "Input",
 CellID->178796733],
Cell[45523, 1539, 898, 19, 70, "Output",
 Evaluatable->False,
 CellID->70730227]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46482, 1565, 311, 9, 70, "SeeAlsoSection",
 CellID->17223],
Cell[46796, 1576, 929, 35, 70, "SeeAlso",
 CellID->11759]
}, Open  ]],
Cell[CellGroupData[{
Cell[47762, 1616, 313, 9, 70, "TutorialsSection",
 CellID->5967],
Cell[48078, 1627, 182, 4, 70, "Tutorials",
 CellID->3468]
}, Open  ]],
Cell[CellGroupData[{
Cell[48297, 1636, 319, 9, 70, "MoreAboutSection",
 CellID->192428103],
Cell[48619, 1647, 166, 3, 70, "MoreAbout",
 CellID->80457156],
Cell[48788, 1652, 168, 3, 70, "MoreAbout",
 CellID->98267317],
Cell[48959, 1657, 179, 3, 70, "MoreAbout",
 CellID->482216172]
}, Open  ]],
Cell[49153, 1663, 27, 0, 70, "History"],
Cell[49183, 1665, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

