(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    401232,       8078]
NotebookOptionsPosition[    390505,       7709]
NotebookOutlinePosition[    392039,       7750]
CellTagsIndexPosition[    391952,       7745]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RGBColor" :> Documentation`HelpLookup["paclet:ref/RGBColor"], 
          "GrayLevel" :> Documentation`HelpLookup["paclet:ref/GrayLevel"], 
          "CMYKColor" :> Documentation`HelpLookup["paclet:ref/CMYKColor"], 
          "Opacity" :> Documentation`HelpLookup["paclet:ref/Opacity"], 
          "Blend" :> Documentation`HelpLookup["paclet:ref/Blend"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Glow" :> 
          Documentation`HelpLookup["paclet:ref/Glow"], "Specularity" :> 
          Documentation`HelpLookup["paclet:ref/Specularity"], "Lighting" :> 
          Documentation`HelpLookup["paclet:ref/Lighting"], "Raster" :> 
          Documentation`HelpLookup["paclet:ref/Raster"], "Red" :> 
          Documentation`HelpLookup["paclet:ref/Red"], "Green" :> 
          Documentation`HelpLookup["paclet:ref/Green"], "Blue" :> 
          Documentation`HelpLookup["paclet:ref/Blue"], "White" :> 
          Documentation`HelpLookup["paclet:ref/White"], "ColorSlider" :> 
          Documentation`HelpLookup["paclet:ref/ColorSlider"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RGBColor\"\>", 
       2->"\<\"GrayLevel\"\>", 3->"\<\"CMYKColor\"\>", 4->"\<\"Opacity\"\>", 
       5->"\<\"Blend\"\>", 6->"\<\"Lighter\"\>", 7->"\<\"Darker\"\>", 
       8->"\<\"Glow\"\>", 9->"\<\"Specularity\"\>", 10->"\<\"Lighting\"\>", 
       11->"\<\"Raster\"\>", 12->"\<\"Red\"\>", 13->"\<\"Green\"\>", 
       14->"\<\"Blue\"\>", 15->"\<\"White\"\>", 
       16->"\<\"ColorSlider\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Colors\"\>", 
       2->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Hue", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hue"], "[", 
       StyleBox["h", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that objects \
which follow are to be displayed, if possible, in a color corresponding to \
hue ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hue"], "[", 
       RowBox[{
        StyleBox["h", "TI"], ",", 
        StyleBox["s", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies colors in terms of hue, saturation and \
brightness. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hue",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hue"], "[", 
       RowBox[{
        StyleBox["h", "TI"], ",", 
        StyleBox["s", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies opacity ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->3196]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The parameters ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " must all be between 0 and 1. Values of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " outside this range are clipped. Values of ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " outside this range are treated cyclically. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->51548173]
}], "Notes",
 CellID->29678],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " varies from 0 to 1, the color corresponding to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   StyleBox["h", "TI"], "]"}]], "InlineFormula"],
 " runs through red, yellow, green, cyan, blue, magenta, and back to red \
again. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->238064904]
}], "Notes",
 CellID->29108],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   StyleBox["h", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", "1", ",", "1"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->414990492]
}], "Notes",
 CellID->23486],

Cell[TextData[{
 "The alternative forms ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["h", "TI"], ",", 
     StyleBox["s", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["h", "TI"], ",", 
     StyleBox["s", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " can also be used. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->182644585]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23764],

Cell["\<\
On monochrome output devices, a gray level based on the brightness value is \
used. \
\>", "Notes",
 CellID->13437],

Cell[TextData[{
 "For 3D surfaces, explicit ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 " directives define surface colors; the final shading depends on lighting. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25303],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"], "[", 
   RowBox[{"Hue", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " specifies color independent of lighting. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->255057354]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->30323],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is an \[OpenCurlyDoubleQuote]alpha channel\[CloseCurlyDoubleQuote] used to \
specify opacity. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->18001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Hue", "[", 
     RowBox[{
      StyleBox["h", "TI"], ",", 
      StyleBox["s", "TI"], ",", 
      StyleBox["b", "TI"]}], "]"}], ",", 
    RowBox[{
     ButtonBox["Opacity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Opacity"], "[", 
     StyleBox["a", "TI"], "]"}]}], "}"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->196212995]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17041],

Cell[TextData[{
 "If no opacity has been specified, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["b", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->9845],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"Hue", "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " should be displayed with the specified color. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->53708190]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23630]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52536857],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->230007530],

Cell["Specify the color of graphics primitives:", "ExampleText",
 CellID->149026781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Hue", "[", "1", "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64769354],

Cell[BoxData[
 GraphicsBox[
  {Hue[1], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->44114646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465218549],

Cell["Specify the color with opacity:", "ExampleText",
 CellID->263465182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Hue", "[", 
     RowBox[{
      RowBox[{"1", "/", "3"}], ",", "1", ",", "1", ",", ".5"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152479682],

Cell[BoxData[
 Graphics3DBox[
  {Hue[
    NCache[
     Rational[1, 3], 0.3333333333333333], 1, 1], Opacity[0.5], 
   SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->654444983,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228655064],

Cell["Specify the output color of expressions:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->53708190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"Hue", "[", 
    RowBox[{"5", "/", "6"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195861199],

Cell[BoxData[
 StyleBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox["y", "2"]}],
  StripOnInput->False,
  FrontFaceColor->Hue[
    Rational[5, 6]],
  BackFaceColor->Hue[
    Rational[5, 6]],
  GraphicsColor->Hue[
    Rational[5, 6]],
  FontColor->Hue[
    Rational[5, 6]]]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271234691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10335802],

Cell["Specify the color of plots:", "ExampleText",
 CellID->580206808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Hue", "[", 
     RowBox[{
      RowBox[{"5", "/", "6"}], ",", "1", ",", 
      RowBox[{"1", "/", "2"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211868938],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199618862]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21827],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Colors in 3D",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23349739],

Cell["Use diffuse surface color:", "ExampleText",
 CellID->404625886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Hue", "[", "0.08", "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->907978],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.08], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320790517,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Use diffuse and specular surface color:", "ExampleText",
 CellID->928327454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Hue", "[", "0.08", "]"}], ",", 
    RowBox[{"Specularity", "[", 
     RowBox[{"White", ",", "20"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29801507],

Cell[BoxData[
 Graphics3DBox[
  {Hue[0.08], Specularity[
    GrayLevel[1], 20], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200861181,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Use glow color, setting the diffuse surface color to black:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->255057354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Black", ",", 
    RowBox[{"Glow", "[", 
     RowBox[{"Hue", "[", "0.08", "]"}], "]"}], ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93466233],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    Hue[0.08]], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->416773900,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztmulSFEkQgBuY4b5vBQQRWZQFBVQUvBCR9USR9VxXEVGJ2FPdCB5s32Cf
q2O3siqHGb7OkUINwx9LBD2TXZlf5VR3ZdZ1e/3D281f1z9sbawPLb9b/+Pt
1sb7oWu/v3O3qiqSJPnb/f/Tm7jv/7pv/n87TdOkanNzM/V/yTm5JH+5a87d
nPfSe3etdFKVfs75u3+qlC8huKsSfnNXuVljlv6itvUi5XZqd1/O+vIttW4s
U/5G7VtEyu+Uax2zXmdTddrwCyshn/LaL7XGjijtF8ruRmkV5Bmv/UzZB/Zg
B+2nyu7fgz3ttR+r9iGU5iBPee0H6slQlPaaso+gNA/5pNdeVe2jKK2GfMJr
r6gn30Vp31b2cZTWQJ702jeU/X2U9g/KPoHSWsgTXvuaak+htA6yrztZVE9m
orQXlH0GpfWQx732JdU+G6V9Xj2ZQ2kDZN/CyZyyL6C0EfIxrz2r7EtR2qeV
fQWlTZDHvPaMai/toe3fI/8mys3lKO1JZd9AaTPkUa89ruxbUdrHlL2C0hbI
vrd4f0T7HkpbIY947RH15H6U9rCyH6CUcdH38mRItR9FaQ+oJ09Q2g552Gv3
KfsZShlzD3vtXmU/j9LuVvZLlHZC9pHP3xXtVyjtgjzotdvUk9dR2nwKbyAz
Z/jI7d8L8WgrWrs0q+5lNVC02pVNJT61pduZVuqB3F+0z2TbC+6zzzH4Zn+E
8ZEcKLFv2NEYO3oh93ka+x7zmOTIMUdjvI2jMc9JvJh0NOYo5vWDJo1WEk+m
HY0+H7ToGRpzmUTLM47G9oyjMddJVJpztEwbsQ0zJLa0xIn5KBJjNDOT9NwL
O6TtRL5yjNRjkvguSR+6CFKlu9CvbpNGWawug1blLmx5m8b2k+ezAFrOoHWZ
NKsPXgGt2l34xnaaNEYyqXMRtBp3YW8KNLY6c4LE8aug1Rq0DpPGLCAx+ppB
YxSyaYx/0o7LoNUZtHaTxrwg5ddBqzdobSaNsbzBoDW4C/VsGuuU/noDtEaD
1mrS+KwkKt2MprGH8x2X+HsLtCaD1mLS2JtzBq3ZoDWbNEYaibO3QWtxFz57
mzYA+Y5Bol9NJqk47wuW9KnVIDWaJBm9rMC6zfhFwZqzDLG+a1hLf5MhR1O0
VbuOJeQW57wNJkXa4J5BaVQKM69NkWeyCkqHu9QqhZltf5R8WrKi8UmUzpAK
/KAr/DHaBxb9FNaa4dHHIn08SbxiZLetpQf9aFgzktdHW3cZddvWEgsefEPW
3e7CGVWw5khMrB9+Y9b83XXR1j1G3ba15IJHX8maY+m+L27d6y7sY1/Tmp7X
mtbSak8ifveXsGZM7vvf+hOtHzttWTk4YPTMmrJWEpHkVmVE/w6UPO5KRJYc
lfMZdu/oWJ6yor7UfxblllKaIzJUecp1pbQbGTOesqTt0g1KezRlIA3zQLnV
B0phXFWq759xZi2hMNOVW4c+izKvlGFQWvdFmdV2GQVFnhnnYOUpp9SXcVCa
9kWZUsoJUBqjKTJ6nVDKdDSFY1pZ1ziulDOgSI/g6D1fljKqrTsHSt2+KEfU
l0ug1EZTZEV2UCnWekE8pV8pnIvn0+zsuTylV9uF89x4iqxfd6ovnCPlylK4
FidrYW1KuQ+KxGHOpm2KrOo3KcWPr3I7lDS7spMry6jTVnla6kmaXc0sT6hW
L55/EuGou1QqYWOHEMrYEuV9EPG1t079zKi8damGPM+cz35pKtZ83nxDs4TB
tDi3FAJjA2fNWUK/EmTs/SrdzmQAc295F+GAEmSNQVqQeZ4+ZAld2g4y2niZ
bmfG0YxgWUK7+iDevnAEzmSZGwqE4p3CXF/Gj/ImcV2C+TJLKMzzB9znz2l2
72BvQp0SJFr85AhcleVoLEvIa0vKWy09inNz8xRCwjsiyg6sjOlowRnAboK7
+lGg7FE8NHKyue+SFHayZTRorlwZ9RWfvViuGfHctmTvlb3aVSPqcRU6WBfO
nkidsmLEtUI+82DFPiV1ygoZV/P4zgXr6pI6ZVWTZyxoVeGt2IfkXIGMKgej
rOu0TvFU1rOHocX+FazIkjol847gPtcmgjXbTqxlR4NnM/jLgnVTSSvJ/swx
aHGeGKz4PkqdMm4Zj7JuLalTxkyThlWFE0U7WDAGSPvOOMuTuF+dsezQumQv
UXb/TsEin7FgT9pVh0tVsiM5C51chsJe5c+nFHdv3d+I4/A8R5bTk9rnW8Tv
AUe4iPtVGQLzOc/VyDsp86OruF+ZIR1UX0jgrn2pZXaXj2/Yhv85pS0j0TDY
DkB3DPKr3a26U+ch9TRWnyeqjkLeLJGL3h1O7TNTr/V+0OL5K8aEN7taa0Rt
qbWbOYpSRqd1d5EmDZmOkYCR8Fkasl9YpRhL7TNpj5QZdhB4lov7NWtpcWwS
Tt8Ik1p3VSvsh06glLnlpnoQdsEL53+otazMcNaCEYK9e1G1wxkXngvjCOqi
ehBOCU2rB9SaU2Y4u8WIw5HBaWWGs3KF81XUmlJmOMHI+MOcPaHa4bwlz5hZ
Z7XEg/Ne+5x6QK0RZS54rXmUMjcdVu0lr31emda+gNR83WsxlnFE3KvMO167
cIKOWp2qteq1FlDKuUKLeuDPVyU81cZRT4Oyn3rtRfWAWtXK9GefkqWSUokd
OWX4WORPJFY76a2Xkor/AJC2SYs=\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Color Operations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->122877664],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Blend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blend"]], "InlineFormula"],
 " to mix two or more colors:"
}], "ExampleText",
 CellID->84492988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0", "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Blend", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", "0", "]"}], ",", 
         RowBox[{"Hue", "[", 
          RowBox[{"2", "/", "3"}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"2", "/", "3"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485561805],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Hue[0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Hue[
      NCache[
       Rational[1, 3], 0.3333333333333333], 1, 1], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Hue[
      NCache[
       Rational[2, 3], 0.6666666666666666]], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->102706425]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Lighter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Lighter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Darker",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Darker"]], "InlineFormula"],
 " to mix with white and black respectively:"
}], "ExampleText",
 CellID->480333690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Lighter", "[", 
       RowBox[{
        RowBox[{"Hue", "[", "1", "]"}], ",", ".4"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "1", "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Darker", "[", 
       RowBox[{
        RowBox[{"Hue", "[", "1", "]"}], ",", ".4"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->516667508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1., 0.4, 0.4], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Hue[1], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0.6, 0., 0.], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->938374977]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->36779870],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Hue", "[", 
    StyleBox["h", "TI"], "]"}], " "}]], "InlineFormula"],
 "is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", "1", ",", "1"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->414990492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"1", "/", "8"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"1", "/", "8"}], ",", "1", ",", "1"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267883268],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Hue[
      NCache[
       Rational[1, 8], 0.125]], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Hue[
      NCache[
       Rational[1, 8], 0.125], 1, 1], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->35919668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->947276963],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["h", "TI"], ",", 
     StyleBox["s", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"], "[", 
   RowBox[{
    StyleBox["h", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->182644585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Hue", "[", "#", "]"}], ",", 
       RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "4"}], ",", "1", ",", "1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->542718116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Hue[1, 1, 1], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Hue[
      NCache[{
        Rational[1, 2], 1, 1}, {0.5, 1, 1}]], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Hue[
      NCache[{
        Rational[1, 4], 1, 1}, {0.25, 1, 1}]], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->246256266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318365681],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->736955090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "0.08", "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Opacity", "[", "a", "]"}], ",", 
      RowBox[{"Hue", "[", "1", "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162022429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1], Opacity[0.99], DiskBox[{0, 0}]}}]}], "}"}]], "Output",
 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->48944769]
}, Open  ]],

Cell[TextData[{
 "Use the opacity argument in ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 " directly:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->196212995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", ".08", "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"1", ",", "1", ",", "1", ",", "a"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1", ",", ".33"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72375890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1, 1, 1], Opacity[0.], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1, 1, 1], Opacity[0.33], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1, 1, 1], Opacity[0.66], DiskBox[{0, 0}]}}], ",", 
   GraphicsBox[{
     {Hue[0.08], DiskBox[{1, 0}]}, 
     {Hue[1, 1, 1], Opacity[0.99], DiskBox[{0, 0}]}}]}], "}"}]], "Output",
 ImageSize->{452, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->325593736]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19023],

Cell[TextData[{
 "Select ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " complementary colors, by selecting them maximally apart on the color \
wheel:"
}], "ExampleText",
 CellID->161734835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", 
          RowBox[{"k", "/", "n"}], "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"k", " ", "2", 
               RowBox[{"Pi", "/", "n"}]}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"k", " ", "2", 
               RowBox[{"Pi", "/", "n"}]}], "]"}]}], "}"}], ",", 
           RowBox[{"1", "/", "2"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "8", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40368807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{
     {Hue[0], DiskBox[{1, 0}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5]], 
      DiskBox[{-1, 0}, NCache[Rational[1, 2], 0.5]]}},
    PlotRange->{{-2, 2}, {-2, 2}}], ",", 
   GraphicsBox[{
     {Hue[0], DiskBox[{1, 0}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 4], 0.25]], 
      DiskBox[{0, 1}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5]], 
      DiskBox[{-1, 0}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[3, 4], 0.75]], 
      DiskBox[{0, -1}, NCache[Rational[1, 2], 0.5]]}},
    PlotRange->{{-2, 2}, {-2, 2}}], ",", 
   GraphicsBox[{
     {Hue[0], DiskBox[{1, 0}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 6], 0.16666666666666666`]], 
      DiskBox[NCache[{Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {0.5, 
        0.8660254037844386}], NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 3], 0.3333333333333333]], 
      DiskBox[NCache[{
        Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-0.5, 
        0.8660254037844386}], NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5]], 
      DiskBox[{-1, 0}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[2, 3], 0.6666666666666666]], 
      DiskBox[NCache[{
        Rational[-1, 2], Rational[-1, 2] 
         3^Rational[1, 2]}, {-0.5, -0.8660254037844386}], NCache[
       Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[5, 6], 0.8333333333333334]], 
      DiskBox[NCache[{Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}, {
        0.5, -0.8660254037844386}], NCache[Rational[1, 2], 0.5]]}},
    PlotRange->{{-2, 2}, {-2, 2}}], ",", 
   GraphicsBox[{
     {Hue[0], DiskBox[{1, 0}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 8], 0.125]], 
      DiskBox[NCache[{2^Rational[-1, 2], 2^Rational[-1, 2]}, {
        0.7071067811865475, 0.7071067811865475}], NCache[
       Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 4], 0.25]], 
      DiskBox[{0, 1}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[3, 8], 0.375]], 
      DiskBox[NCache[{-2^Rational[-1, 2], 2^
         Rational[-1, 2]}, {-0.7071067811865475, 0.7071067811865475}], NCache[
       Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5]], 
      DiskBox[{-1, 0}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[5, 8], 0.625]], 
      DiskBox[NCache[{-2^Rational[-1, 2], -2^
          Rational[-1, 2]}, {-0.7071067811865475, -0.7071067811865475}], 
       NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[3, 4], 0.75]], 
      DiskBox[{0, -1}, NCache[Rational[1, 2], 0.5]]}, 
     {Hue[
       NCache[
        Rational[7, 8], 0.875]], 
      DiskBox[NCache[{2^Rational[-1, 2], -2^Rational[-1, 2]}, {
        0.7071067811865475, -0.7071067811865475}], NCache[
       Rational[1, 2], 0.5]]}},
    PlotRange->{{-2, 2}, {-2, 2}}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->65673982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->633186528],

Cell["\<\
Color the filling according to the argument of a complex function:\
\>", "ExampleText",
 CellID->152390215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"2", "I", " ", "x"}], "-", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "2"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Rescale", "[", 
        RowBox[{
         RowBox[{"Arg", "[", 
          RowBox[{"Exp", "[", 
           RowBox[{
            RowBox[{"2", "I", " ", "x"}], "-", 
            RowBox[{
             RowBox[{"x", "^", "2"}], "/", "2"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], "]"}]}], "]"}]}],
    ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276063042],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->689426269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414945414],

Cell["\<\
Color the surface according to the argument of a complex function:\
\>", "ExampleText",
 CellID->783734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"Rescale", "[", 
        RowBox[{
         RowBox[{"Arg", "[", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "+", 
            RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], "]"}]}], "]"}]}],
    ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Opacity", "[", "0.8", "]"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18889618],

Cell[GraphicsData["CompressedBitmap", "\<\
eJysvQtYU1e6Bpzx1g69zjQz7Zlrz8ycuZ6Zc3l3EggSLgKKioqKdxQVFSsq
3q1YbbWtrbbaamtbrdai1qpFRUVFUVFRQVG5BwgBJEggQIAAAbJXn/9f69sJ
0pTOmf95/j52k8u+rPWub33f+73f2juRs1fGz1s8e+XCubNfHr58dmL8wrkr
Xg5fupx/NPBHKpXqLP9/90sq/vr/4a/o/7Pffvst/+J723i+Hch3iKB3i8RW
vP2W/lOF/3/+dCHfDug930KvfUbQp6+493nOfW0tffqq+1PVIHrr/k9Db1a7
96SvBs6bN085pUqib1e4vx3gdbUBnr3dJ1T2Xua+jo94N0j5VtkB9GeJ+2xP
/8D3Ce7vnxXvBvd+777G//b2W+wz0KtFT4nNkL7nVLb/Q38WuFum7tPux/14
fJb/or3j3Nf4udfe3tf8B+09x4PuwMfX9T5yUD+tFW9/S4fMcr/75f9x1NNe
739DRw91X/83fc/p1Ufx+RD+d1A/yCln8acLPv5UaY3Y7d+9zjfY63iff/F8
L7nP94f/n873c3e//+R1viFex//4XzzfC+72/cXrfE94Hf+E+7ov/8B5fvLt
9+3B+5yD3df623dG0DNr/+G195NeLfgzHTXKfdT//Et7j3CfG157e6NDaKrC
vu3jP/rs7T02f6S9h7lb4tfPucXnSguC3Of099rrKa9z/gftbXAf6z1Dva/h
PSf+0Dsq4sOgf2lvP/e1hnnt/YzX3r+nvQUmYsBD+zl3r32TFQx0W4k49wiv
vZ/1Ovfv6Ci116e/cJ9l1P9xNM1RQlK0zHtGvej+PNLrLM957fdyv234mbsH
Uf/S0T917/0zd8sn9HPUAI9Xob37nsNz9CSvo37itZ8yh1/49rvzZsr/cdQQ
9/7knQlx8W6611HebSIv/J0Z/jP681v3VWO8jh/oPu8z7r+Df+D4X7u/j/U+
nnzHcSe+cUK8HOz23Z42qf7JOT32ImKS6iklmvP/zjiR0YQrzchsxxUHLjuQ
zZDFoBqQyTcD0xmU/b7n6wb8wHVedF+H4v/z/DoZVtyxIc+C/HrktyDbivs2
WBiqGB4y8aKCoUAW2/sMAzw9Gtx7Zne/vGf7C/S5xwK9v50tNj+ettpHtGTe
vAoTLBWoqoKpBoXlqKqFajDjXRtS6wKTYWUoZMjpRqaLWuAdXQd8xzp+6u7h
fPdf1c8sueAXaX6A+nzUFqLyPloqwVrAOsCcYD1gLjhpyy/mkGHrgrkTtbK4
6s0u3gxPhFc9775SvAfd+iuwX0HLZQwQQ/bzthuwZ6HhGlgxWAWYFcwG1gjW
BGYHaxNbuQVyK+Q2dDrQ3Ip7NbDZcasBmTb0E+Nfous+4+5LvPv6que6T4k+
Kf+x03ClibftaWDXwbLB7oMVgZXQtpQbCquC6im5ArIJ7CH4u0eF4ouaPOSW
wXgSDOhvFJWrP93n6qqXlSFT/nPt0rLdYHvA9oMlgx0RrWCnwHhDMsAywa6C
3QC7C5ZHjbojWiffpDbegpMDlQ7TJbCDYBG8EcP6QeBFasPgvnPS/a2AfD7t
0tsmx9qgzjWG7nU6OQlsI9hmsHfAdoB9TC3bT1c6CnYM7ISnlZfBeAvO8TnF
P1D5sG/QcxzsMJzJqPscbA6YFj2Ym4OmfhBSWvd9T+P1Cb/4XIGiaPIf7TPD
W2PCOmYFdsXqXXMlNg9sEVgi2BqwDdTmLdTanWCfgvEmHAD7Crxd7Di9OExd
4Nu9YB+CbYf9fbAFYGM5goYObCuHpdfhKNuX/kkrH8/Px55sstgMWeyzdLHP
Kwk+cxf5xMSrRq/wWUTt/3lDeKRtWGRTSGTLsOGO8BDnCINrlD8b68smSmwq
WCw1JgFsmbtHoi9bwd6n1pK5DOB/VM+I9u+jT7aBvU478wP5Gfx5R8b1YFc+
rqj6me8/+2eY/0CuI15SRBsy22fJLJ/4WJ85sT7TJv1o7PSnoqlXf+HHfSSg
bj+B2/lIrML0Roxp0Y5q10e4AsJdQUFysJaFg40BmwQWAxYH9oq7k6KHvANv
SuxtMXjsXerSdrAPID5JotFV+jaK903PEGvD+7nIzoVd1Y/N/6s9HOjVw7HU
wxE+q8b7rJrgs2TiU/ETn5494emZYhfyGy/FBbCVQWw+tzKtmB98QN4ecOTY
gMkFiKvGJDsiuhDs8g1mBgMLkkR3x36nu6KjK0WPB/BOqZ5nr9HAbaLtajLj
uWQAkWABvKMRDHGPsLsORUZY+2m/+gf66YnEQ7z6p7Cp//BZ4/vM2iBVGJ1K
fE1+/heG0Wx4JJsQyQKDWNwoNsnAov3Y5nC2MZDt8GVvqt7JRHweZtUgyo5w
JwJ6tHo5JJAN0wjfE0WjQ/0UnUzgPUyE6idifFdS3/iL+dQ3vk80WIjwmQyR
DPHV+KIdubVSdQ5avL2oqjfyejyYNwbefRxO759+avXLz66hs9EUQBzr9boD
MJ8NwDz+fxxT/R1zmSaW6WJYeCzzjWa+49iCGDZsMoudyLZEs40T2YehbLdq
XBZmFCKqVopwIJjBl0lgBrARGjFUE9x9Fx2Po24ulIS5LgSbTf2dSl3mpuvL
uxzAEOXCEieSGW7UoywX9f3NUoUBeOcIT3j11pOvqIZgzeMeYjPDJjYIG5nq
f5DEsJ6J7VqGdQyvMqxkWMbC+XYFC1jGFieyiDfZoqVs8yqW+CkD40592j2M
NyPCjlCnxiDrdExPIxZB9jxRdEj0dSYfT0lse7s4nuZ3MO+lhiGcYUo3bxb2
MFytRcED1PGw1V9ff9rbVzFalD3x84d4+vZjbHY97ts+hv1MbD8XZ1YNwKdM
NUj6hEkfMexi+IiP63b+/w6megk7GT6gfztYxHYW+DkL2cOWvc6mpjH08J72
vMcmp2HSbUSVY0QTgmXuWnz1LFDPgiAm72iwcaKng3jfVM+5e8eHcYSIaTxY
cDfLMIdhOcNuGRlVuGtBa7HSR+9c5Cf9jqeP13gaPN9jaxd2u1TEiwbhJANv
8nmGc2wgf6UaiNMMqQwnRP+PM9X/4ijDIYaDtP2Stl8xfM2Qwvj3er7rBRZ5
nE3gtLdDDHEYs+5l43Ymh6QiKgujSxBuQ5AD+h5ITEfOZxjYcNFZMdBjaNy5
pY+kD0PBAnn3tQwj+BAzPoOwimFnF9JaUdANl4UYSx8/1L8tP+XVd3/33hRP
BuOGjDsMD+jfPT7EyGWqJ3GLc0o+bxiuMVxhuMSQLoAZIFD5u/IaFxl4P28z
3BUHR92gPovxlqPZrXfZoi+d2D0ZJzHqGiKKEdoAg4v33FffpdeInnPzDRP9
FD2PIDsIpQ/5Vxre7SDyWlO5a6YpxY3rDIOxG50WOHPR09/YP0/993H371mv
fossnPr8BO67UOJClSwSh1qGRyKD4CNcw1TPiHTCzFDGUMovx1BMrD5PYCP6
mU0dviP2zmbcG9yjr0soC6lj6OIIMab6PWfs49j19Wzjxyx4fw4+8UMKwq8h
tBBBdfB3QMckSdi2ntxbEGEQQr0PIl4hzF7HiSbDGA8G62nacQst7kCTFe2F
CgbeatQg92x+sheLvt96Y/J3sXnSsMonYPUz/mt+olv3M2n9S/+z8Zd/ef3X
f9z0MqH17ODMq6qb6airhbUO1lrYrGhtEUPtpNHmWweDnaGR993GVE+hwY0o
qhkqGUwEZbkHzXKBXSVT/VXs1MbQzeASU4USm/YJ7OomtuJtNj65C18cxWfA
CQRfQ3AxDPXQt0q+Dq2225eAGyqwE8ANpbcaJdL5MYQyjGWYxkMe464ZuxmO
0Qg2OtBZga5bcPVjO97vn+gXv+e88CPd7cmAFU8NXfGsYfVPDGt/NvTVX2jX
/UaX9Lv/SvoT4fc0P5qjc11GPs2p4y48kfnajx4cQGMxmsvQZkG3Y6Cwmmcg
ExY9BIqTSa2EaxNDM+PIClytAlqOn5Vj3SAw7KAjXL0YdoF1TmdnF7ONy1nc
bhaYnIUDSfgcOIWhWRhqlPyb4NsByQVCTEfQ+RKMWgVAiWEoQxiPngwzGBKY
iHKfkofL7kFlE6xVaMsj4/NwBW8bfIyd+PB5L8xIf3sycJmPYdkzQ5f9RL9M
HbDqJcPaX/mtfRlr/9DLk57lWa7JBZeMBiey2gUAeTJu9uCJr6c/cWX9oLwD
aC6Hk+erMqE3+DF6HWIicpRcTOWDTrLPTvqnAEpfK3sP4H9UPxUJtcivO2ay
oyPZR7PY6nfYuC9bkHwA+6bgC+AM/G7Brwy+Dmi6IXVLkDWceWmheoGjKMAT
sPmS0xpOyMUwJDK8RUGZz9kbPSixoaoC1vtoyyQD/B5q3uxaQXHgt33rJ15x
rg+qpB0OCV76VPDS5wxLX/BPfNGw6pd+a37rwXMgn16q5zt6SEtoFePIX3R3
o7pDoPKgBSVtwoc9cen1J/MPPll2ET12yE5CdqDHuASmTIQIp8fkZI6gU3zC
3IDyLR3zPJ/OetYQJNLWg1PZxjfZ1J1Mm1yEL7Zi7ygkSzgHTQ60ldB0QZKB
QSK3/ylBqSULDCFePp6g5IF/C8NeMkIecowOPKqFvQTOm5D/ZST7z0q82FEf
RElvHBi2WKg/HoZLM1oILawKrAbsEZhVYs3cFhqFLSj6iQ1dj+hFJykqNjRV
404hWBnyinAvH08cXjww89NB+Rlos8LFR0TmxitwlhQUZQG5TJFkgAfPn5CN
urRCq+Hs7uvZbPNqNmMjMxx0ICUd+1bi8+H4WoOLwD3AAvAJriJMX+AkkWA1
kGccyTCRYSax07dpYnNKc5l7Zhm2ZrSb0H2XFJH+LNRbVfjXcH3BC9dfuy1a
NaghA/YMt0A0gN2B6ldChcnxCDGc4RklseXYGUmoMgk1SIhFefRhAdgDWPgh
V2C/hOzLcO3FgbS920pqh5x8H6absFfD6XhSsWH5Ozbs9X6AGARus81g9/Ts
mzi2ZSKbuYiFf8q0R4049Tn2z8YXYUjR4SpQIEkNQDsw0I0vN1g9QRxGnGUS
wyya/psFTcZhok+cJdgccFajJ19oSr38fJA7E/Mw8h/SB7yy7j54/uJbTz3I
cRrOVIGnwmdfYCchVK5U2p4GOwt2vo/ipby47Za7WBZ9eEloXaoB7IxQPki/
sR6CbTusayI+PJ1ydPfZMtQP+eJNFGSgzohmCzpbVM95EPwJeRduovkh7OQw
oWnFTmWRW1jAkS4czcCxd7F/GpKHIdUfWVoYJbRCXItv1JTKaEl0CCIse4FM
oCjO+V8ykVAeyK1dcD6Ci9vEPQLSW1V+6l/C0buG+qIHxydYsvRYtdyuEfLI
h6KdO6Ea4hYS93m0xK/43D8K1S+F7pVKWt15AjqF1LsU0sAOkHr0odCWmt4V
qbtx1fTLn31livm0Fnk8Ggz8ZD3uXYClGC1WtNnQbofLpXrag+qfyZlwh5NP
o7hdyxbFsmlbWMRnPPUow6H9SF6JA9E4EoLzQ3HXD1VaOHlwl5RoriFQAz2g
RjPEMiyiVPV9yvHOEbnlfK3LBrmKZtbtfnH1+UFcB3jUuz54kp3+XNVXh10c
ypYYWKIvW0FyxSqwtWDrSZl5ixQpRY7aSXh9SkB/wfE9CNXPBdyKgHuAXvRK
VitJ+4xG9sqE2pmvObAuD6evoPEQTx+Xn0H2eVQVoK0BPc5nxGT/K/lR7pjr
yJVwP3KRX8zA1ixkCxJYKPeIh+1Iu4PjO/HlQiRHIWUYLgcgXw8rB1USbtWD
KPenYQTqRA+iPAd/l8IUz1RyqDbR3koxopyu5GHl3rXj3vzNG1lvRKleODjR
Z+kyn8XLfRIWqeYvemqVEpN+Xvznfxh/+7eS3/zVOSGoK1rvitawKWDTIXSD
uWDxJHUuhUB+DYQgtrkP5u8LPAfwP6qXBP4f0hBsI2l6FcmHc0mOCEf9JJ6G
xzRjcw4u1aPlBuTF4aXYvQdZaTDlo/ERmuuljjYeyIYItP9LYm4vS/9kcrDV
hEeR8Nps/wj25lQ2fzjTL2fSPh7fTbhwTjr6Jg4vwOExOBOKrEAY9bDphEV3
Sdpu6GUh7fBINorAn0U0fxVxrc+Ia2VRstHipIrGQyovXHsczwTOin/wrkz/
27eKHkJWPni2z5LZPgtjfeJm+cya8KNoBeV/y3nhr9nP/PXOE3/LHfy3/CH/
Wfzjvxl9/lr+zF/Lnvuz8ad/7Ar1FWmsIlVNIb1GgX4J4c6hXEfmvkEgy/3J
61C9yDZLYijepO+Wkn4ZSzLPcEXG4hwo1optNtxyoSkb9mTIw6acw/79yEqH
qQC2OjjbedLF0f4bz5+o09ziLNRv7s+P+IsxjvFlhjlMx+f7V3acyMbpgzi8
Gl/F4ngk0kNxNwiV/mjxRYdW6nF74RAmjSSEOf+aT3ThDU8uxSlYEWUk4nr1
YGaPEPE9+36yX6S916EQYxgyzWfZBJ/lE3wSxj81b9zTs8Y+M4Uw/yU/Lmwc
Cxwt/kWMZWPGMEM4mzaGzRgt5N/40ezcwJDCAX+rGvD7h0/87uGTvyh/+kWh
JIz2CIazvjsBlok600ph6atIMF1JAqIimE4jASZAEV1G87T7IT5y4mIHSvLw
KAXtbwU+0s8+hmOHcT0DpiI4WtDa7OPGnni18NRWoiuZ5Prf41cOYWNeYSO2
M8MX3MCrcPQ8Uj7A4SX4ehpSRyMzDPlBsPqjTQtZeBdf4VokkUYQ/HFEf5UI
eJgi4ANy1oKT8+vVUuxWqb6PssLOvEfk1zQsvdgH+qyJfGbVmGeXjnkufszz
sb0K/G+FS5tDmhNvADVDG8f84lhAnLCIUXEsehHTzmdz57P45ezSIKl04B9N
T/6p5qlfPXzqKbeGOY60ymk0AnNIr11A47BQ2H68sP25Hk1zEmmaYUoGGkQZ
VLxLyIqn7bh/F+Zr6OEOfX5oPhZ9gZRvcPMaKsq4T+eUWPVjgf9/knfpJtdu
I9d+jepQPI6siGCzlrBJy5iWI5jShfMPcPYojm/G1wvxzSRciET2cJQGwqZH
p6/k0Oq7JANJL4KB0BAkUrDcSsHyLGlAZkXf6yFvdp+oVD/W/09GYMi/P71G
8+SyyJ+uiXwhMVIdP+ZnsxUNcsxLI5V0A69y5p/EVL/GazT8yvYNYpVviNfD
eEr0Jgt+m82klk3fylZsZxdVvzEO+Y3liZeszz/HArTukRhD8E6ieDCDQsIs
MQYxYgz6KsqjSA4Qs5+nCdMppr3HMWvArTyYjURtNurqdOHnsH4/Uk7h1m1R
Dnc6Ff/zV5oDzeTebxD34SH8tTFs8TgWOZnhdVJMT1XgwhWkfoaU9UiZj9SJ
uDIa98NRGwi7nvsfjUtMgEByfBO476MBWEv532eU/10nIcmuaB11xFauf4+t
9Poi2gqL/hV9+5vnVntlc5SJDMaHpK59TIR9p8gJdgt1bye9303/9giQB3AS
qvopDrKRfCqeZpo0Nns/G2ZkEyosa65n3njy5Qofde2QwcxXxwL9BPgjKBxE
CYBJ3X5JvB7jUXjd1ZlhHg6xmPr5tQVXGlHfQKnQQT5FgksQfQxvJePEWWTf
haUWPT0er9NFXoAnRjeJf+7ltEjLFg5loyOZbqXoCw43IOUuzqUg9X2cXI3U
ObgwATdHS6WhsBvg8lXa4E/ZyziGGYT4KrIzfvQRhgyGAlKfhMtppOHNFpXo
fj3+kH5tXsRWQvoJbHtcP1FvNeO4GFSO9wmOLX/xMn8hRvkb5n5xlCLOcXrB
PzxFenwaNeoaEzL1XWbIZoYqpogS0S01C7q+OeXz8gOfF1qh7+ZcTdHZQ0hh
juCjEClGQRGch5HeyncQgsNoSjhiabpvIY0/lwe5JjjzRVYlv6W1jRuThXlf
YvtXOHEBdx+grp40poHo6nbnkoPdoyLTqg0zAXWWKCtnU8v0bGIUC1vDgncw
XXI3UipxKgNn9+P020hNxOnpuDoR90ajahicBjB/HdPzQBDCmQ4Dnz9zaWD4
LNpOEymN2mdR+u2g/KDXEX0vFgzud1R+/m1vVWtnn8rPRTHJBnAepRqsPmwW
GGcTn80W43RT+WaImIeZ9O8q6QdX+OfXmernomaQTTGqgBblWJi+vledFNQ7
kt16ja3/3OdXmU/+1AZ9s1bv9NO6hfAQEQMG8pHh+dQwehugsCAN6UGRhMNs
IiPvkjfmjaizosmIbp6xfCncWmnQ5LNIPIjdx3DmMnIL8agBDie6epSx+Xsf
RuokenhPJLximQJnva9qWUw0m7CUha8V7kY63oQMIy6k4uwupG3EmYVIn4qb
USiKgC0EzqHcdhSyFE5K1Uw+g2mQtnp0v1skfzsYehRnZSTRwjNCvdppr5cS
qt4Q+loVfa13RFQ7c1Sf56gO5ghiaxajUCFMrZKpM80iFJlEvYJ/Ws74/FLK
FiVE0QqZEJ3zxHeFTKURb0podz4wNaQsd5FgKveKxx3R7FISW5nEYvYw/aUn
nrNC3ynIEFw69JDiLmpSwbQ1kAav7dXdlZA5hXjDaoocB4ivVDJBlHrKwM5w
iOEwaG9j0lG8egSfn8L5G1J+KZra+BxSDfnOCHUTkyqUWKYkkmseyTdKLG4k
mzSJhXDKv41JB51Iq8alW0g7iNR3cXYN0ubi6hTkjkHlcHQGiUYTlVNsR6kI
rKYR2u3RvQpIVBfCZQeRt3rypCp3PBERQhkhz8pmz8q7wSTghGwM8H89SLsp
xKMNPutzvsTnWonPXaNPXrFPYb6PMf9H+dmqazlPFOWorueoruaoMnLU98xo
5vPFLuaRou3bqBl1ohw1UBSjhggxtpY+rKdtGxskfM0/qEwiVP6Z7NRsti2O
LdvKRiebcRuGR9C3QOfUSLKWZo2eSkl864c+4r6ekqfestKr5E+SyZ8U0CWd
NoKA+6zZ+kq/0IuYcxibjiI5DRdzYKyCtVksBet00mj9kaYRx61cYrckMcB7
KbVM8GeThrPgWKbdQHPhuA3pBUg/h7Of4OQGnFmMi7HImQxjJBrCFFPSM72i
+UYT7UykcfqQ2naWZlIpweQawG1DNdBBMylJlU2jIhb7e6+jcd+M4P6jbL21
yR/3esDIJL+IpIDw9cEhr4UZNkToN0bSeD7vk3HHJ/uiT/ZJn5xjPndSfO6e
8Ck441N0zsd40afsmk91rs+jUh9r2TN1JT7W0oEV9waqbueofMS8ctC/diY5
iSza6W2b2A7kn/Ko4XRr5iqqQvzE4yFdWmafyM74sy/Hss0bWMynTHfgNK5A
Xw3fTnB+BJcEl1bELZWoQZB+9guqFxrIE42lsZ1PJcMdhN858t/cU7RZ4MxC
9xnIG+GYPPKOdkwqEg5hWwqOZEjXHqDSiuY2yLJnbDtpbKsldk8SXpJ72K2c
UHMvGcLCZ7HADcz/I6Y92I5TJpy7hnNfIW07Tq/BuXhkxiBvIqpGwR6C9qFa
WcvtLpjsLkZRn2h4eyX9AiWU0dgOcgqtXFxP8DS+n/dqDGXhe//3jHyXfVMu
M2Tkq/rwdYbgdSFDk4brkkYhaRyNrbdi6ONTdN7HnONTV+5TX+FTL7Y/thQ9
1WDhQ8q95ABFmGfkLZxKWUQ1yF2/JA/6WLVnsuoZg0jCefw/Nplt2chmb2CB
B1uwfzsyoTVDy5kJZXtiDCVlDH9Nvsqf3NVw4mLcYy0k5q9Mg9OegNJihiMX
ndlCD3PNgWlo4BVMOYpVh7ErFd9cx+1i1NhE2HP2oMdFjSa/KonJ2q74VdJf
vqJVh6/y/Gwoi5zJIl5lwe8zv32cc9XhbC7OncGF/biwFWkrkBGHm1NREoX6
EegyKOqiP83XSWRsnDG+SWP6Na0MuKv4fQWZYrU5U20+rDY/5ibeo0nbx6ur
vn28jlKZn35JQJIWSUORNAxJEXwMKV8aiMRF7tlNdcYnVOm7xLx8VORTX+Vj
rRhca1JVV1FkGeSppfSn/T9LpRpOoE7NYtvmsnkL2IhdTHs0D3tfwWVJMkNR
/ni3JRqrXxEn0dEyoxBaoBFFw7WIZp2iq56gBRRlXUIWs9vQ1UA2vQG2CM0D
Dc+h5qRg4zHsuYAzOXhQCXvXdxmKizLZMhLmU5T4x9Nn7lejWeRSFvYmG7qb
aQ614IQR5zNx6Tgu7kb6JqQvxo05yJuCqkg4wihE+wUwnVKWnMWwlIG75A9o
qIRfNasvmtV5ZnVFhdrcSelbYV8O2e84fW9d9WAFe5UqdC306/hISb0j1Ztl
0Sq6IT5ndvgUZ/jUFfvYagfVVqtycoZ4jckTfcbERQlHoY6lRbEdgeyVKBa1
kQUeduF4qiglZErgI9PmrsQo84fkE8FFlARyOgV9TufeoQTyKHmbEoqq3Be7
GqgYswc9C/xqwwKzEXUSCaew5RS+vIKMPJjq4XQpvOQ/qDXNRLRziMp8ThL0
UrApI9m4ODYiiQVtZ777e0QCd/o+LqUj4yAytiNjHTIXIjcWxsmwjURXuJYZ
/Jk2mEkjyVMr7dvKYTKrd5jVyUTdmkRdRFYNVmhZFc3Wx/mW96h8f13id+fS
EA8/8crJVIN8Tu/0KbzqU/FAVV7yvAd5zjIcxFdLAoXJfgS2fAKL2chG8XBy
qAhfbUdyGK7rUNU7LQSz0Hpk8WGkH4ynCTGP2PqblFsfprStkMDnwU/0iucr
J4WM3zE1uCQoIhPTT2P1aew4hyO3kFUKi32IW93ppkhkoSLIRbBDJFqvAYs1
sHFT2IhEFvQW8+Os7pAdKeU4fxOZqbi6F1e24PJyZMejaCZqJ6AtHE5OiCQt
NXK8WR1iVk8wqzkP+pgmRAbVl+ppAYaspAgWj8D2A8i7/3jqed9bi8MPoHtR
Bvtc/8anNFdV8EBdeB+uHhXVI/6XQn5XnwpPJhU5kmLYK6vYeG4XyV1Iy0Xy
OhwPwS09LFp00FIXl3vJQYCnVB7loXSJ3y2Y3VdCq8uTfVwnXxILS6A+C6PP
Iu4sNp7FJxlIvYf7D9HULglfydv2J4+aVk+HXqe13R+TG1oANm40GzGPBScx
/XZZSnbipBUXCnE5HZlHkLkLmRuQtQQFcaiaiuZIdIfA/KLarP6tWf13mpQJ
FNdEKkvA3yV6V80jhkrhAFVEQk/0UXa8ke+vOi12+g/Frve9q8q+NCinmDu2
PkjzAW0gpEtIo/ral70Ty1aOZSNnM81OTlNrkJ6G5AScCkWuP6w6dEiKfSuR
OZiQHudBejEJg9vI26cRxxIxr5Xu2mija5wUJa7WsVKRb/AVRJ/GkrN45xwO
XMfFQpga0eUipP9OUdlB7qWC6rFnwfbRMu0lYJOCWcQ0Fryc6be4tHucUkob
zlch4zaun8a1/bi2FddW4ZvR6owgdbZGXfIXtTzMlwWFMN8I0pXmicKUxPPl
PYT0ZTLxGkXA7KbrPVZz/m+kPdXlvxLKA86lwlqlzruLLqeoV6p+58kHrKQT
8SE8GSzMLQFsxHim38A0X3bjeC7O7MfhuTgXigcGNPjCoZM6tLoet/8I96T6
vWU1ZfXHKSrulDE0DxQ28qyFLrATXa/oqkcMzcXw84hNxdoz+OAyvr6LLBOs
nWLZT7eyKu/vCr0moKupIneJJ/6SqHitBpupFdUFnlnqX+303dqs3VOrOWpC
eh6uZeDQVvWh1eqDs9U3E1EwDw+noWUMnKGQA/yYFEitnUmR9Q0SDL8ioO+R
PbfzIKN4kTy6h+OfoyyQpTV55LC/Ooh6i9poRE83XK6BvWtE+mhNv/PMUTMV
bVOpNsrd4sRpbPRbLJw7gaP1OHIeRzfj6FRkhKHIALufKKbJgsD4e5zHROLl
SiVtU5/0OJ+SUiXneq6G5sxRUT60TdUXBoRkIuo8Fp7Bpgv47DrOFqKgHi0u
JbFR9cG8g4JJsUcW/pgKkPPBxoSykBny0IR2/Xqb33vVuvUXXnwv5Wd7D6mz
0pB1ADe24foa5CagNBYN0XBGoMdfmYrhZB7xNP3eo+l3mjAvI1HD7kR3PVyl
dAvP6f4xp2zhe5/+p4fdDDjyNay16nKjqDA85UZa9rjpHMp0uZve7MviFrCZ
CSxknZJEVyDtKI6tRUoUboyAyYA2P3RreMamdz1eHDaNCPNyImLbPQnaHXIe
7YT0s4/I414WZdlO7kJDfLMRelGKuYgV57HtMpKzkWlCpZ3DPOhxfLR5pNmz
tD7hLbDF3Hn4sWH/Vf7boPxfj83+5azLv9heqEu+pz13G1lXkHUMWbuRtQk5
K1A8X5h121i4QiDrfZl2GPm5WLF6XdRWPyERNpNQ5s6jvh2OBqHpuHLgSqdV
WP0j/GRfq6bFLnuTYalRmysIVVDL+YR8KLG7knBDyTyyB7PVEWxaBNPPI4BS
WpB2E6m7kZKItCjkjOCxC016yaHVuZRSpRBvo0l4WkKr75Uy/Eki4EayCTHv
leQnj9jDGjRMkEr0ATcw9pK04BJeu4TdN3GqELl1qO8QWZPHfhXmUUvg3iPG
IsiH2jxJbQ5Um/8U7AyaYDcsqB+aZNF/UOF7yKg9fV/KzMItMuGs93DzVRQs
RuVs2KLhGglXeIAcFC7rlSCyiMLgB7SS/AKBa5TxqI1W+NJarJ5LymrB/tH1
Xtf+V4/9RoafQXoGqqvVpaUqH/eaZJeH0Nzvo3mu82UxBhY0m+k3M+0BF44W
40yqkNNOLUDGOBSEo8kAp1s/CuizvnEhqXxvUeHkaw91esS9rRLBn+uhMtw5
UQNtX6R9OFL/ACGXpWmXkZiBdzNxMA+Xq2BywNaNzsdodxHj53OsQG0+pK54
T21e3estDCw4ujtwoSPgtSb9TqvfAbP2RJEm4y7uZOL2cbcp565EWTzqZsAx
lrki9K6QENl/FNNEU7xeRZaxT4kkHLUeVNlh5dmZCZ25aMqA4wS6PCsFvo+2
90p6QvtJvntI9Dc4kY6KKrXJLHhjd4/ElJjTx18PcHsRFxXo82l6H6Ma2SYN
W2BgkTyF2MQMu5h0zI6zd5GWjNMbcToGN8ajLBwOnnPrNSKX04SSvU+hLi3z
lAQOeGqT3IvYlRFw0GUUT/UqbNN9SwMCbiHyCuIuI+kyPsoWuWOOFbYedHhG
gE9MtdmoNt9Rmy+QM0nzOJMlVEEMHMMMi2TDRqf/9mb9/ke6lArtpUIpOwd3
zuN2srD37HUoXIKquWjkLjtSK4cbZMNwWacsJ15C4eVjCi/cYnI5mM14WIt6
M2ofwJaJljPo/OEReNrr0794RmBKRJo29mucuQJTtbqgCM5uyDKt/JtDjtFI
aXSqWE8klqUlhrDpMWzcAqbnEfsLF04/RPoVnPlIaMgXpiFnLB6GoZMj7ter
7ytGn+BxL0ox8galMxYSOsRlSsi9pIrEsGsWqkN19xF8FZMvY8lVvH0dB/Jw
sQrGVrXRpC7nOJvJNBzEsKsk9oC8y2FaA7WGyubDQ5hhFhuaxPw/6NLvt/se
r9Wml2tu5uFBFu6mIPtTYfL3V6N8IZn8OHCT7woJdfkrq+cWUIDs1XdzXCjk
2LXA/BCWQliz0JwGxxE+Yz3r4b3xfsbtvcnSRX4/Muo0Fh5GaiZMFnV+kfCT
Il9XzfUQKz5zcz3eRXRDx2KHsVFjmHYxqVgpnUgvxPlvpNS3kZaAq1ORFwnb
MHTrFQcTSNWuKZ4lJ5vJuxwmRem+p9olyu4O0muui+kjL0bTGBh9eTYzKgNz
LmHtFfXyY+r309VHbqPKgSbhXzyKioOYaTEdesIjqoibUnVs6ATmn8j0b/fo
P+vw+7pRl1ajuVGKvAfIu4jcQ7i9DTlJKFqK6jg0RcMxWtcZFtxtiJC14z1h
8m2SurlZXHPhtkjnkZ8HI2/EZVjPwH5Usez+kfa+s+BPHsueE5AZNCEVSUdx
NguVdepbuWjroKz4Dx4klCp4pic/2wAWH8CiIpiBk9m3mFbYd63QiNI+x6l1
OD8X2VMl0yh0hIAZeL+DmEaxb6UCraRl+yl8XiP7rvMos8856UpHxY2UjlhN
ze9fSlH/+5dq3efqyH3YdA17cnHOjKIW2GR0yIpH4dykS3KvClDcyX5adraU
lkgFjWD6OOa3rtv3/XbdAbv2TIM2s0q6X4LC28g7hdxP8eAdPFgF00JYY4SB
OyOG9oTw8DlGdofPjUqRW8aFNly14haHsBDFOajIhOUcGlN4Rvl9b/Ijwtz7
zoQ/eaw8AlkYn4odJ3DxDqqs3NBVHsS7KLNropJ7NrHLveQdl2rZ1BFsRDwL
3cQCPmHSkSak5SPtJM5/JJ1dgcuxeDARtRFwBMLpq5NFwXmkR6dfQ6ajcO6L
VNYVaWQv4hy43WrzCrUp6uf3x+uMOm7oIzMRewVrruK9WziUh6xHqHTA0dMb
RV2UglYRYbkkbngXMu8aWuY0Yijzm8p8F3fr3mjXfmTXHrFpLtVKdythLERh
BgqPouQTGN+EMRGWObALH+7rCg+RDaNkrVKZWeNZC5PqxOUWZFfhLscwF+U3
8DAdDSfReliJot6WrqDufecCPePlx3z3WOTqddcw+yQ+SUP6fVTb1A9K0NGt
ZDpziX+30bL7B+Rhkqmqvoo7ynA2PoZFrGLB7zHfL7pxohLneIZ9GOlbcSEB
WTEwRsEeDpd/bylZsXZFC1VqJGfo7pxyZWmJWW0uUpsvq80XqRC2Ac5YrWWY
730EXceka1iUiddv4LMHOGNCYQusTrQKod3jzWso7l4jD/OJItvSaijfSKab
3aVd6dC+Y9fsbZBO1OJaFYpNMN1FRTrMh1G1C9Ub8fAVHqzhHCe5Igyu4OGy
XxRJJkvJHwoz6UG6A1k23OMoPoDxJqoyUJcK+9f9exgFd+/7G3pxn+ifpQm9
iMRUfJGBm0ZYmtRFPHeSlbpBHMddcksnVopwysq2nUTLFuhZdBSLjGfhG1nA
biYdtiE1H5cuIONzXHodV+OROwMPI9E5DOJ+T/9hTFL8ezyxx3cUj2lWJ5vV
58zqXLO6QqnElpEK8o0gjz2LpKYobZnkm4XR1zH7OtZcw7YcHClDVj1KHRx9
yenyFPQbKNTfJj/zBfmZRFpgFhzCtNFdmniHlGTH9gYceoSLD3HPjIoiVGXB
cgZ1X6L+fdjWwhYHxwS4IvWu0GHy0EhZmuwVSDuR2YycOoqlRlizYUuD7Rj5
mf6Rf8EdRQlxcTtJgj4nMvQKxp/FxjM4eB25ZtS1qI3lnBHQDP6D9HiJQqNH
okn1KM68R1PCWOQMFr6CGd7l/r0bx6qQdhtXT+DyTmSsRvZ8lE1D0yg4QySm
19OSOiWZW2pWzzGrV5rVb5M2eI+hlnTm57sJuxKaWCQhOKZqagzaPIRkYfIN
JNzA5mx8lo9zNShsQ2t3n+yeZ0eVFPUv9SEv3NNEaGVNhFOa1Y5VrdjWjAMN
OFuL25z089z1rvAVtTzJ/hi2TbAvRdt0dI3VuoYHugIjZN0Eau1KUn64hZzo
QkYrbjYgrwZl5GzqM2E/i45DiqcZ1C/u3ndK/MGD/wzDNUNEOmalYVsajmWj
6BHaONSM4z/Q7WschIeiN/f2ay3vlx8bM46FL2CGjUz3SQ84V08z4splZB5E
5ju4thT5cZJlIhzh6BGcxtes/otZ7WdWRxBzVLTCVPI1Zirs2xVCYyFZ+yAf
YKlrocYaqTVCdxORNzE3C2uzsCMPR8px0wZLV5/FNB2UlxZ6Fjt+RFNyHi05
8wuXpZhuLO/E263Y04gUKzItKKpCZSGqeWg8Bes+NGxF02q0zIUjCq5RQ10i
sCrVY+WmC869vnLhggPXGpFbi5IymDma19CQhpajcP4w8t73VtDdaf/Dd1/o
lxUZchkjLyDhrPRRBs4XwNwkUe3HQ4ddHjG03kPbU8iNvk5uNCqMDY9hgWuY
7/ZuzaF2nLGAZ4BCCf0U117DnQRkGNT3/ltt/L3a/JtfMt8wj69f3us96Y7m
HCqk2pVcNUBZscjdzS64VqJ5qqYi2O8BhmVj6m0svYW3cvG5Eec5Au1oldEt
w+WiUWugHDebbrDhidwbtJY4mtOaACZNkZHQjY3t2GXHERsu1eF+DSrLUZWN
mnN4dAj1H6JxA+yL4JiMzkg/Fs7J/iimVVLVNWQrXzCcduKKXTzwKL8cRo7o
dVi4u0lBxw+j/2J/6Cfy3WP8b4QMy5Amp2HdWezNwtVS1AnewGOXB31FIbWT
oJhL6fsBelDIMu5G9Wx4NAtaIvtt6dHtadMeqZHOFSEzE4feUR9crD4UrX6w
ADVT0TEaLNSX6QOVZxOQUtA3DclWatjKxSx0GYUVclIZJ9VEDTUGhudhbA7m
5SApGzuLkFKD7BZUdsLeRbB3eehNLoldnxMDS6S1rcNBiwziXFjnxPsOfMnn
ZwOyH/G8EFV5qLmC2m9g/Qy2t9G8HK2z0B6lcUYYWMhwpu+9b/NNRe/qxsU2
ZFmRaxJPVSjlgF5Fczq6j5LeJbD/Ef9MYK7g/pLbz/finaC5FRVwTRvG05Jz
eDsdX+Ui14K6DrTyWSz3gdxBQBT0ia3raM30qBEseLbLf51Tv7NNtzX3xV2X
frbvqDrrHLI+x41NyF4KYyxs4yGHKcsYDbT6ozcb+cyzvKKQXA03XWcDeoqp
mPi1iK3dy6X62MCHYyPKDRMKMT0Xy+7inXwcrEJGI/JaRfpk7/QIZ7WU3J6n
ZSDvkZOfS2tZ9XyOxbiwrAtbOrGnDSeacL0eJRZUGVFzC7VnYf0SDe+jaR1a
FsAxkTNKfU9YKAuIZNrekvkHDAddONeOzHrcMiG3GKV5eMTBvAnXqR/A+xde
dv7vHkYzS5cVariKyHQsSceOq4KSGJvQ1Knw4zgP8E7yMaXEF05T2NtMD4eZ
+Cvz77Xlvx1T/KsFeb/cb9Ol1WkyCpF1nQTTD5G1BgULUT0d7ZGQDaClLcP7
qHk7SM1LJyJfxQOsS1T/HUZ0ZqE7FfJnYJt0bYkhtlmRlsjJFYZZRYi/hw33
8akJKbXiAVsFdlS3wu4g1BvILjJowHYRmXxFebKLP8NEFxZyF+PELgeOttCY
WcWK7If3YLmEuqOo3/04unaM03WNCHYFRbChU5l+IdOuY9I2erzHqU5cakRW
HfKqYTbBVox2Duo5qX/Uve/eePmxtWdH6a/rgi9L088hKR2f3MKlMlS2Cj3e
pXh4k6eKa6S5yyNestqcoDZHq80BYGHDu4NiOwxrW/0/bPI7Wq/NqJJu5CI7
HVn7kfUWcpfDFCdUVDkC8jCDHBAhayaQ6KvwhM89FSIjx90FayNspbDfhOM0
OvejZ7tvz8ZQx5KxTTHT6kbHVRkSjFiZh21G7K9EqgVZDShqhKUZbS2U35VS
6DlJZvE2+b8YWksvjZIR243VTmxrx5dtOGdHjg0VtXhYLO5F5TS8fj9s29C8
Gq1z0T5Bco4KcIWGs5BJLHABG7qW6d9luj1MOsZwyYnsNhQ3oqYOzQ/h5Jhe
keTDkstdVv4u7r/qD3fBZmbqboYNzcSIi1hwHm9dQfI93LGi0Un3tws2Q7iL
O6/U5rNq80G1+f0+XGFMIAua1mNY2j70zWb9vgZd2iNNVhlybiE7BVk7cXMd
ihJg4bn3WCEuycFhst+Y71IERfzlxm5yoboJtWWw3oLtLFoPwfkR5DcDu1aO
aoubbIuebQlPMOtXlmBjPnYacdiMCxbkWmGyiXXWPUpt5S48VQBamMTTj3ES
8w+RMaUHi53Y3IFP25Bix40mGOvxsAKWO6i7AOth2HaiaSPF0ynoHKPviQiT
h09kYXEsZDUzvM30u5n2MAWg2wxlTlgdaGlGN3cFHNNvJHqaxvdR/7Xbp7/s
8S0JmjtR+hv6kKuIvowVF7EjC6eMKGtReZgj9+ucyGeRBd2hzvQKHpN5EhTF
DIksYItTv7fNN9WmvW6R7hQgNwPZXyJrC+6vhGkBbJMV5TRQ2Lh2omdFrUII
eKKaJaOkB2V2mMtQnQNrOpqPomMPXFv9XeuGOxdF2afH1I+Of2hILMerhXi3
EHtLRVZ8w4JiK2ob4LB53HkGBZyPefCVWILEJksshLuzcS7EObGuAzscONyC
i82434BqCywFeJQJawpse9C0BfaVaJuFjiht15hhrtHjWcRsFrrMFbi5R7/T
pf1SFtNRUZBqGdp4yKuB6w7ESvP+sfZ+svBvPBY+S5cdEXJDH5mJ2Vew8Sr2
P8CVatR1okP2WLiRMiUl81ai2wcKXwcbMYwFzGH+b3ALcOqP2HXpdZq7lci7
i9xUZO/G7fUoSoQlFm0kn3aHhLn8lOeHLPHUQvlcvSrjQY/wzMZKmLl7zRAc
rG0funZoXRtDupZFOuZMaRo/91Ho4krdaiM2F2FXMQ6X4kIV7vFIyCe41aMQ
K9IjdytbJLZCYjM1LELDtMNdiOkSfH2LA3vsONkoPFLZI9SUovYWrGfRkIzG
HZI9SWqNl9qjOW8J6YiMckbEOsOWdgdt6Bn6vsv3c5nciifyNMpUB81DD8f0
S0UbGPA91F/2Ql1YvGop33WJ9t6MkOyIyCy/qdewJBPbspBixAPuVl2cAktu
xt79XX39Mw8LjtIw/4lMv4Lp33H67W/zPcVtvUbKNyI/E7mHkb0V99fAFA/b
VDgitZ1hwT0BI2V3neZVWkIn2KIL15qQXYH7D1CcBfMF1Kag6Ut0fAz5LUP3
moiO+AmtU2c2RCysGbrChPXFeL8E+404UYbrlTDWiOfVOK0esU65E+M9ia2V
WJxGtDAg0IWJXVjYiY0OfNSKo3ZkNqLQiupKWHLx6CKsR2D7CE1voGWJ1DZd
ah8f0DFmdOfI6c7whV0ha7sNW1z63S5Nr18pZXgki+XushE9V9DltvXvo+79
1GtCfQnfdXHI/WmROSOmZfnGXUdSJnZnI70SlR3olD1JUg/d81PpUdoVHWw5
6Rwh4Uw/T/ZNcup2tGkPN2ovWoWtl+QhPw15+5D/Ntn6bJHwOSMo4fMbR4UZ
hfWK57w4cdGG61XikRUF2SjPwMNUNBxG2x70bNP3rA/rXDK2LXZqc1RcXfDS
KmlNKbYY8YlR6DHpZUJRqXmIVst3b63gfHaDxF6R2CQNC/GVMYa7l2686sT2
dhxuRXozcutRZcHDfFgyUZeC+j2wbUHzSrTMkRwTde3jwjtHRTuHx3UNW9kt
3MuHLu0BWQjUytLhKllwDLkSrpvoOoEOseKwD+LuZ/Hyd722vWZo4YKRDyZP
uTN8/i1tYha23MLBfGTX07MFepOh9j60/BuKmUlEekf6Md/Jsi7Bqd3Upv2k
UfONVbr2EEU8QctC6UmUfYry11ERj8apwo+7woPlgFGy1FuQEQTRhfN2XLXg
Np9RuSjJRGWaIGz2/ej8QNuzKci5cqRjXrR98izbiFcsfisrsLEUH5QhuRyp
JmTxK1VItmqpx0Lp/1VK/3mOvFliiRKL4R5Fy7QjZMx0YWU3tjqx34FUu/Ao
xlqi5Tc9tHw7GpNgj0er8CjBHZHjnBGznGFLuoNe6xn6nst3L3kURZQuc6Ge
z/xHcOWiK01wKgetBvoO0t5PX/+lx64ThxXFRuWNm3U3KOEW1mXhozzpTJXQ
72zd6kLTd/W7m1S13Ee3RSfQref+PA7OcmpWtknvNmJ/Hc48xF2zuAW3KhM1
x2DZidpXURfL+wDXSLJr3yhalNP76JhT7ciw4oYJd/NQmAVTOiw8jCXDsRuu
LUOdr4Y7eNiMmW4bM88amFiNV8uwtRx7TDhuwmUT8kyoqZDaqz28MJWa967E
VmvYXA0bp2VDgzlFkbHUhTe78WkHjrfgig15deKpP9V3YUnHoyOwfgTbG2ha
gpYZkmOCf8fYkZ0jpzrD47tC1rhdiaAoyu0OhS5YetDeDFchui+R93bf5fAY
7f/wQpsyolf4nqsMRfEji6dMyYuYd9dv5W28dQfJRiEZW13qsgpP2tmbRF+k
afoe3Q3NaW6Yv6yJckoL2rCxGZ/YcOIRsqpRZkJlNmrOom4/zc5laJkK1xid
qA4MjZTFipyFJKjv5JywCxeakFmN7CLkZcOYgapUwdHse+B8z7drQ0h7YmTL
nMlNE2fXhyfUalebsdmEjypwuEJUkLjDN5nQZCInp3CogzygS2y9hi3Uskla
FuInY5yMeBkbXPjQiUNtON8oaK+5RqT5D6+K0a3bg/otsK1E82y0TNS2R4V2
jp7oHDG3a9jy7sBNPf7ci3whi2XamTLuuVDZA3sHZO8nzQobV9D+oxfatII2
nu+e5Fu4OIybd3HUrLyQhFysu41dBaKoXNKuNvYm+U4q/Bd5VlLu8niT0WDa
US5prhNJDnzYjK/qkWFBPnf6+ajOECKpUIqS0BLH3bYkRxhcQSNIIZ1NKxoU
Vni2FRl8lMqQew+F12BKg+UoGvejfafUvdnQsSqidcGE5qkxDaMWPApY9hCv
VWC7WWQ+JytxrRJFZlgr0G3qQwl3S2yzhiVq2QwteZMInvbIWO0S3mSfA6ea
xVM1eZJfWSIE9JozqP0S1u1oSEJjvCgbOaICOyIjnRExzrCEruCknqHbXL57
ZOkoz4xlZLtQ6lnfP6DXmr1/aYHwFfFzZWDR/NHFU6aWRMzP16/MxZYHOFSB
Gzb1bRPaXB7RSinK3fHk8goNmQBmCGGScIROvNuK/Y04a0XOQ5HoVt8kHXQv
bG/CvkSR4fQsLFT2VzKcxR7+d7wT6TZkViK7AHm3UHoR1SdQn4yW3eh+R+9c
F+ZIGGufOdU2bm5dyOIaaU0ltlTikyocrRL1/nuVqDajvQKysuj0FNjnEntX
w1Zr2VwtlZ55ejOVfMcmJ3Y7BA3JsOFBLSpMqLqDau6rvsKjj2B9A7alaJqB
lgn+7WMjOkdNdg5f0BWyutvwtkv/sUt7iGcHdGfzk9/xEn92o9yL56v6woTw
opkTisfFlgQvLkBSLnaXIc2qPlcsilndPZ5VWTUeyUeppSyjO8jDdQzRJG6+
0Y7ddqRwulAr7gyreoAa7uYOon47mtaglbvjcdquEUEsMMIja7pvN3MhzY7L
FlFtuncXRVdRcQaPjqJ5Dzrf0zk3hDgSR9vnTGqcGGsNf8Xiu7IKr5vxoRnJ
lThTiVtmcBfGvYOrHHIO5HMSOyixHRq2Xiu8Q7SOpzAyomQscCGJcwwHku1I
syG7DiY+7nmouoKab2DZg7otqF8F2xw0R2vbokKJT892hiZ2B23s8d/BgcpW
raM1Vo+x/KuXjZLWGst3XRZcGBdZPGlayYh4o9/KAmwtwRGL+vAD8bQyazs9
q6CT9KZizxoypaAwl+R635E8yesRlEhkXM24aBUPu68qRc11QXmtu0XcsL9C
6tlo/55QTvPGUXx7/JQ5B9KtuGZCDid7WShX4tsXcHwoObkDWBnROn9C05SY
+pELagN4fEsyY1sF9lYgxYyrFSgwodYEJwf0AeQMyEc1bLdGPH1ZOAAdi/Bl
2pHcAbiwwulOUPioX7OiyAJTMSqzUH0algOofR/WJDTEi7U/9vGBjjGRRJUX
eWyy9z495ZdJ+uD4cw+Oa/wLXxlRNCO6eMyckqClRqwvxJ5q9c5s3G5GaQvq
29DTTiqS8owH5c7Q1z2qWGAgn7kuJDrxdjv2teA0Dbu5Gg9zUXuOGM9WwSvb
YtAxVtc9PEQOjGT66UyXwCRlJcFXXTjXKNLLWyV4cBfGTNG1+oNo+RjOLfqO
teFtr4yzx0y1jZlbF6zM9bcq8LEJX5lwgZMLE8zlaC2DXAT5GuSTkvy5Rn5X
K+b6HJ14+riY61NcSHCKlGOnHV/ZxLjxHJFHvIocVJ3Hw8Ow7MKjN2BdCtsM
NE/Qt44dce3ffqfyvif1P/vDcJzgWiGFc8YWTZxREr7Q6Muz0W0m9RvX+fzG
3UaU0+2bPUoCke1ZHraFEgihn0sMY12Y34X1HdjVimPNyGwQfl7IW5ybH0PD
x2h8jZTcCXCOMriGjWBBU1jAQqZPYrrtTHOA4bRDcK2sCuTmi7St8pzgPnxy
t2/TdawPcSwZbY+d1DiBT+6FFt8VVdhYgR0V+MIkqO2NclFmaihFjxFyNuQ0
SU7WyNu1cpJWjtexaF8W4i+LJzvHObHGgW12POOOI8K2lOcp/d3t7wiP0YIN
DS2MjyiaNql49NwSQ6JRPesCdprw9UNcqUOhDZZGOJopOOd5qNB2RXyS2FiJ
6cNlxHRjRSe2tol6wgUb7vMMsQqWHNSdFXJf4zuwJ6JtGjrH+PWMCJPDo9mw
+Sx4LQvYynw59/ymB+ltuG7BXSMKc2C6CMs3sO1H6wdSxxsGx4oI+7zxTVNm
1I+cT3Pz1Qq8WyG45zETMsrwoBQPjegwwnUP8kXIRyT5Y628SSsv1ckzfFmE
H9OKhbXPujGgp0QpvzTVxzboKXwjiasULx5WGDuuKCqmOPQV44tTLmBLGfaa
cLqayiT1aLRBbvQ8N8k9vyS2iGdvEqnOE3pEwvy6A5/YcaJRVOFNj8R6skeX
UX9EqHDNSWiNQ/t4TVdkiGvUBDZiLgtdwQI3y/qPZc1X3Uhrw+VG3DYj7z6M
V1HFY3Ay7B+hY4vesSasZeHYphl8fs2pC06okVZVYnMFdplwyIS0cmSXotyI
ZqMgxXIm5BRJ3qORt2jllVp59oA+KCjPgf7v/lCI4LutCCyeN7Jo8uTiiLiS
X4+/gI1G7CwXczijCoW1eGRFZ73nAQ6niev3FWs0ES7Ekv1tbxHe+rINRVY8
5D70JqynYNsrNb0ttRCj6IgKckaO7YmY6QpbIgdtkP13yCJ1TeVZL63+uFso
spGKNBHhbZ+ibZvOsT64Zcmoptho24RZ1vB4i9+yKqJrJuw34UQ5MktRaERd
CbqLRb4rn5HkAxr5fT5DhNLwtLv/ytPcvX+7idaAhBMDMC4KL4mJKh47s/j3
oy9gLXcSZdI+k3TaJBb08FzcXtdnqTBn39sltk5i8xTZJMglnjmeSGLVFy04
ryTwD1GTi0fnBTOybYN9FZXXJuidYyO6R051hcfLIWvlgHdlTgNxvAPnrLhi
wq0CPOD5QTqqj6F+H+zbJccbhpYVI5rjomyTZ1hHxtUGLKnGmgpsMYkCydfl
uMg5rhFVxWgrgusurT4/7PlVuIEelkO/5iZ8AI14mIjPIca5kSXRU4r/HH5e
v9yITaX4uBxfU3ZXWAmrBV21FJwzaVkuN/o3JLZYYlM1LNSPPM5CTng68Rnn
vnaRSZXXoroQlqsibW/YKXyifQHaojUd40K7Rk/sGTFXHrZcNnCj/0jWHO7B
mSZcqsKNAty9icIrqDgpCHPTLjje0reuCW1eOMY2fao1cnZt8KKHmpVmbDIJ
F5VswpkywZKMJbAVCinPdUXVJ5ZSTUD5dbw+o0zr2gJFLA0ojY8wTp9o/EfQ
+cAEI1414r0y4WjPcprAI5VZan1IpPlWn4x2pYbFathILUX8uZxCdWOnE1+3
Cisv4OlsOakHPJvbI3hz81KRBTrGGzojx3RHxLjCFstBr8n+22XtfhknW4XC
n2lEdg7yMmA8jerDaPgELe/qWpOCmxePssVGW6Nm1YbF1/glViHJhPdM+NyE
lHL3rxSpbhxw3907yN1j5VegNF49ptWT4rdh1vuVLw0tjR1nlIZeCJtfolth
xOZS7C7HUROumsRaq/oKyVXt0aY4C9shsSQNm69lUVoWwGPzdBkrXdjWhQMO
pDWJlLKyGtW5sJzHo2TUvwfbathj0TrBr33sCOfIKWTXa+SALbLvpzKOdoow
m2FC1n3kXkNRGiqOoJYeAj3E3QPl97u8f/mMevDfItcJKp8/qkyvSx85xxiw
2IgkI7aXCUNIq8DdClRXiBsDHos+PE3bpGGLtWyqloVy2juBE3MZm7vxWTtV
SephtIhHID68IhLCuo/QsEFJ0CRHVEhn5PiuEbNdw5bJhk2yfqesSe5BahPS
q3CtEDk3kd/Xoyq/sqZzzytq7z/412v1pkXh5YH/ezEqpjQk3iitNOLtUnxW
jm9MyKyAsQLNJsjlvTYmsXc0bKWWzdKykTqysThZ2NiHHaLScMmGvFpR1hA5
5SnU7oX1bdgS0TwNLeMNjjGjnREzesISXEFJsv97snafjJQ2nLPgyoA+vo94
Uf+/5PafosUwxevLhv4pPTLKGBRjxCsl2GDEh6U4VC4Klnnlggp38Ubngl2A
O7dI0pKN6MhGZshY0Y13OrC/FWcaKbGoEkuaqs/Bkoy691G/BrbZsE/0bRs3
vGPUJGf4vJ6QVS7D27LfbhlHPM8gFI2jCKXS99dW8Vsv8Sjz/eWFkeHGgKgS
xBZjTQneNQqF+3QpssvEQ9DaOGfnsZBbwzFJcPY3tCxBy6boyBomynilG693
YHcrjjch04riGlTki/WCNV+jdhesG9GwUKxnbokKcURGdUbEdocm9gRuVHme
RyvwVH49s9/f1fsT3205TH7qC8P1xfrwYkwpxpJibCrBbiOOGXHViKJSQeeU
u7HkVInt07B3tGQBOjaS5xWjZczpxpoOvN+KZG589bjPybARlTdEls2ztEdv
wZooVkQ2jx/aOmZU+8hp1Lon3K3TUeuGuu2SWiWeGZiEqhD1pREo0ekLpbFF
mF+EpGJsL0FyCc6XiBDCSZXTKEZZviDJBzXiwarrtGyejkX5soBhPCPnEa4D
b7ViTxNoBntYJiHh/g2Jx3gQ9xS/8RSpvhKFUl8UasILEVOIlUXYUoy9xThZ
jKwSlJbAzvlLPuTLPM+S5N1aGjMdm+LLQgW37QZ5v2fcVwukqwV6XY3uRlbz
3aLVmdNgCkaxxlCI6EIkFGJjEXYV4esiZBQhrxiPitFTAlcW5FOUjWzh6OvY
LM81xEnplwm/92uGT3iuEaO+NhcVETBqdQXS6ALMLcTaQrxXiAOFSCtEdiHM
RXAUi+oez8bdhH1dnxmp/MJscH/nf57vtgiVhFiBJqwA0wqwrABvFeKzQqQU
Ck9UXOgJfiIz7WuZI+m8Ie6x7z3fCnHXcXkwCrWGfGlCPuLz8VoBdhbgcIF4
DM39QtQUwslPeaOPHY2hc3n/6qKIO09QLMLqfJXy32D3ughx1Hg6KszrKO9f
PPK+M/z/HSwlge8hhNy/i74jAC1lgbhRYNXuUN+iq4KZGQtW5YkkCxrBhJ2S
A77TjgEUbqypqbD7dRkBRQLU7A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549974892]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->204135847],

Cell["The hue value is cyclic with period 1:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->238064904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", "h", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"8", "h"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"-", "1"}], ",", "1", ",", 
      RowBox[{"1", "/", "8"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213732103],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmL0KwkAQhCdE0uVqGyH2+g6ptPIhjiAkhSgxvXm0e7PN7p0/aKOi5Ryz
y8zB3sJX3s4P7f7gh67x1bb3p7ZrztXm2OtVngHZCsBiDvWiLpadtVayn7jC
7DiOS63ifoNco6RHnbWYA1SaQ8oXgQrOmmVIbSqtpSwmh+t7qMXkrMV5iErn
cdsXVLYv/LLfvewv/7Y/HsxIiZRIiZRIiZRIiZRIiZRIiZRIiZRIiZRI6S2l
5x+n73+tHg7ZBGJSnqg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->76829068]
}, Open  ]],

Cell["Saturation determines how vivid the color is:", "ExampleText",
 CellID->234775250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", "s"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"7", "s"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "7"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->475079003],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl7ENwjAQRX9IJrAbGqQUzAKiYAgrQkqKCBTS4xkyAyVllB0yQ2ZghuNf
JCASEyCd9f3t58avvWNoy1Md2qoI+b4Jl7Iqrvnu3PApTQD03Js1eBfe5t2L
8Fx2xn7EGLMPISXKvODe/JSJgddSnmRg4LSUR+kYOC3lQWoGXkv5LgcGTku5
ky0Dr6V8EzBwWov/V2ZlVmZlVmZlVmZlVmZlVmb1R1bf2eJ39kDyAoBIxB0=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18148429]
}, Open  ]],

Cell["Brightness determines the brightness of the color:", "ExampleText",
 CellID->159349876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", "1", ",", "s"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"7", "s"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "1", ",", 
      RowBox[{"1", "/", "7"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->427305782],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl7ENwjAURC8kEzgNDVKKzMAIIBdMQGVFSEkRgUJ6MgNzpIxYhmHMXSIB
EhMg/a/z+T9Xr/Uh9PWpDX1ThWLfhUvdVNdid+74lCYAJp7NGtwjt/lMMfL+
7ow9DsOQvQkpEcs4ldiVYJCrxKUHwze/8LYFA6cS+zsY5Crx8QEGTiVun2CQ
q8S3CAZOJY7zYGVWZmVWZmVWZmVWZmVWZmVWf2T1+Vv8/j2QvABZi9In\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->225472424]
}, Open  ]],

Cell["A portion of HSB color space with maximal brightness:", "ExampleText",
 CellID->1499401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"h", ",", "s", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", "1", ",", ".01"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"h", ",", "0", ",", "1", ",", ".01"}], "}"}]}], "]"}], ",", 
    RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25846182],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->167193873]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15538608],

Cell["\<\
Saturation and brightness values outside of the 0, 1 range will be clipped:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->51548173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"1", ",", "s"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "s"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42100231],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl7ENgzAQRY/ACqCUHoUqqTKEhSJBgUBAjweipGc053OWDIIR8q3zt59P
sl57HzvV39ZOTWXNe7B93VSjeXUDntJERFZs8xTcPW66V+9xnjNDLs65LJKk
QK9L8gsXkbcNhT5CeZ5R6COUyxKFPkI5CBR7nDiPHP5/0IIWtKAFLWhBC1rQ
gha0+GuLYzq5Ty+S/ACPknCP\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369137821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"1", ",", "1", ",", "b"}], "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Gray", "]"}], ",", 
      RowBox[{"Rectangle", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"4", "b"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", 
      RowBox[{"0", "-", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "4"}]}], ",", 
      RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46372159],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztlzEOgzAMRT+FKxB1zFEytVMPESEkGCoqygFyoI7sOZrrQEqpegS+JTt+
sYe3+uanrr37qW+8vY7+0fXN016GUb/KAsCsac/QXrRbchbRd18rra8QQrUR
SkWsUaeyY/NhB7g0d5l1Ie2YkDkCMc1jZlkFjPxyvfESONGCFrSgBS1oQQta
0IIWtDi0xfc6+b9eULwBcCh/wg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113509914]
}, Open  ]],

Cell[TextData[{
 "In plot functions, use ",
 Cell[BoxData[
  ButtonBox["ColorFunctionScaling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunctionScaling"]], "InlineFormula"],
 " to control global scaling of variables:"
}], "ExampleText",
 CellID->37537136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"DensityPlot", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"1", ",", "#1"}], "]"}], "&"}], ")"}]}], ",", 
     RowBox[{"ColorFunctionScaling", "\[Rule]", "t"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->463429744],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzt3H1EXWEAx/Fz7+12VSZFa0p6mYwUGZExJlqJiIyY1N2tKZOlNiJlRGaR
iERkTJGIRGSkRCQiEpHNkhhpRkbs5+48p7P+ONofS7Z78304z7nneR7nefl4
jucej1MbftXW2hF+1R4J51V1hTvb2iPdeY9fdtlJAZ9lWQf28fyOZf+O2r+c
4yAatc8hO26RlGKfW+1z6CI1YheyAnZS1AlWkinpSQtelLYCdo6cYDWZyL02
Wcme/GZPfuKld8k3UbbOznR6qm/f9PWrDg/1+bP29rS1pZUVLSxoakrj43r3
Tn196uzUs2d68kRVVXrwQMXFys9XdrZu31ZamlJSlJgon88qkNuH86os03Mr
7Nb786ep8McPU+f37zo50fGxqfnoyFT+5Ys+fdL+vmnC7q52drS9bdqyuamN
Da2va21Nq6taXtbHj1pa0uKiaeP8vObmNDurmRlNT+vDB71/r8lJTUyYto+N
aXRUIyMaHtbQkN6+1eCgBgb05o36+9Xbq54evX6t7m7Tv44OvXihtja1tioS
UXOzGhv19KkaGky/6+tVV6faWtXUqLpalZWqqNCjR3r40IxHebnKynT/vkpL
VVKioiLdu6fCQhUUKDdXOTnKylJmpjIylJ6u1FTduqXkZIVCCgbl95vR8uOG
G2644YYbbrjhhhtuuOGGG2644YYbbrjhhhtuuOGGG2644YYbbrjhhhtuuOGG
G2644YYbbrjhhhtuuOGGG2644YYbbrjhhhtuuOGGG25/6ZZgx37LjKlz6Yxp
AXaxaJfgDpsTzr+p4aAF7cvo72Dy7uIXi37Bi7nnOiVgiCGGGGJ4Iwz9v9fA
btWJmN4IU7M+DmEZ95YBz/wMYnoNpt6n3sX1P34TEHBnKk/dq74R8Er6zp3d
NwMmTvhPtqyOrmpq8MynPY2lL6bmK6bXO0/5/xJHmjG5PsIQQwwxxBBDDDHE
EEMMb4ohOz3iRvCSnR7sr4oLOfbF4YYbbrjhhhtuuOGGG2644YYbbrjhhhtu
uOGGG2644YYbbrjhhhtuuOGGG2644YYbbrjhhhtuuOGGG2644YYbbrjhhhtu
uOGGG264xYhbk6dUsie/+Y93iViuTNQJVpIdtXjSzr8FcODElu8XRR5XJw==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->508402006]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->330541375],

Cell["Visualizing the HSB color space:", "ExampleText",
 CellID->40304447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".7", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Hue", "[", "#", "]"}], ",", 
         RowBox[{"Cuboid", "[", 
          RowBox[{"#", ",", 
           RowBox[{"#", "+", ".1"}]}], "]"}]}], "}"}], "&"}], "/@", 
      RowBox[{"Tuples", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"0", ",", "1", ",", ".2"}], "]"}], ",", "3"}], "]"}]}]}], 
    "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Hue\>\"", ",", "\"\<Saturation\>\"", ",", " ", 
      "\"\<Brightness\>\""}], "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124985783],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.7], 
   {Hue[0., 0., 0.], CuboidBox[{0., 0., 0.}, {0.1, 0.1, 0.1}]}, 
   {Hue[0., 0., 0.2], 
    CuboidBox[{0., 0., 0.2}, {0.1, 0.1, 0.30000000000000004`}]}, 
   {Hue[0., 0., 0.4], CuboidBox[{0., 0., 0.4}, {0.1, 0.1, 0.5}]}, 
   {Hue[0., 0., 0.6000000000000001], 
    CuboidBox[{0., 0., 0.6000000000000001}, {0.1, 0.1, 
     0.7000000000000001}]}, 
   {Hue[0., 0., 0.8], CuboidBox[{0., 0., 0.8}, {0.1, 0.1, 0.9}]}, 
   {Hue[0., 0., 1.], CuboidBox[{0., 0., 1.}, {0.1, 0.1, 1.1}]}, 
   {Hue[0., 0.2, 0.], 
    CuboidBox[{0., 0.2, 0.}, {0.1, 0.30000000000000004`, 0.1}]}, 
   {Hue[0., 0.2, 0.2], 
    CuboidBox[{0., 0.2, 0.2}, {0.1, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {Hue[0., 0.2, 0.4], 
    CuboidBox[{0., 0.2, 0.4}, {0.1, 0.30000000000000004`, 0.5}]}, 
   {Hue[0., 0.2, 0.6000000000000001], 
    CuboidBox[{0., 0.2, 0.6000000000000001}, {0.1, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {Hue[0., 0.2, 0.8], 
    CuboidBox[{0., 0.2, 0.8}, {0.1, 0.30000000000000004`, 0.9}]}, 
   {Hue[0., 0.2, 1.], 
    CuboidBox[{0., 0.2, 1.}, {0.1, 0.30000000000000004`, 1.1}]}, 
   {Hue[0., 0.4, 0.], CuboidBox[{0., 0.4, 0.}, {0.1, 0.5, 0.1}]}, 
   {Hue[0., 0.4, 0.2], 
    CuboidBox[{0., 0.4, 0.2}, {0.1, 0.5, 0.30000000000000004`}]}, 
   {Hue[0., 0.4, 0.4], CuboidBox[{0., 0.4, 0.4}, {0.1, 0.5, 0.5}]}, 
   {Hue[0., 0.4, 0.6000000000000001], 
    CuboidBox[{0., 0.4, 0.6000000000000001}, {0.1, 0.5, 
     0.7000000000000001}]}, 
   {Hue[0., 0.4, 0.8], CuboidBox[{0., 0.4, 0.8}, {0.1, 0.5, 0.9}]}, 
   {Hue[0., 0.4, 1.], CuboidBox[{0., 0.4, 1.}, {0.1, 0.5, 1.1}]}, 
   {Hue[0., 0.6000000000000001, 0.], 
    CuboidBox[{0., 0.6000000000000001, 0.}, {0.1, 0.7000000000000001, 
     0.1}]}, 
   {Hue[0., 0.6000000000000001, 0.2], 
    CuboidBox[{0., 0.6000000000000001, 0.2}, {0.1, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {Hue[0., 0.6000000000000001, 0.4], 
    CuboidBox[{0., 0.6000000000000001, 0.4}, {0.1, 0.7000000000000001, 
     0.5}]}, 
   {Hue[0., 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0., 0.6000000000000001, 0.6000000000000001}, {0.1, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {Hue[0., 0.6000000000000001, 0.8], 
    CuboidBox[{0., 0.6000000000000001, 0.8}, {0.1, 0.7000000000000001, 
     0.9}]}, 
   {Hue[0., 0.6000000000000001, 1.], 
    CuboidBox[{0., 0.6000000000000001, 1.}, {0.1, 0.7000000000000001, 
     1.1}]}, 
   {Hue[0., 0.8, 0.], CuboidBox[{0., 0.8, 0.}, {0.1, 0.9, 0.1}]}, 
   {Hue[0., 0.8, 0.2], 
    CuboidBox[{0., 0.8, 0.2}, {0.1, 0.9, 0.30000000000000004`}]}, 
   {Hue[0., 0.8, 0.4], CuboidBox[{0., 0.8, 0.4}, {0.1, 0.9, 0.5}]}, 
   {Hue[0., 0.8, 0.6000000000000001], 
    CuboidBox[{0., 0.8, 0.6000000000000001}, {0.1, 0.9, 
     0.7000000000000001}]}, 
   {Hue[0., 0.8, 0.8], CuboidBox[{0., 0.8, 0.8}, {0.1, 0.9, 0.9}]}, 
   {Hue[0., 0.8, 1.], CuboidBox[{0., 0.8, 1.}, {0.1, 0.9, 1.1}]}, 
   {Hue[0., 1., 0.], CuboidBox[{0., 1., 0.}, {0.1, 1.1, 0.1}]}, 
   {Hue[0., 1., 0.2], 
    CuboidBox[{0., 1., 0.2}, {0.1, 1.1, 0.30000000000000004`}]}, 
   {Hue[0., 1., 0.4], CuboidBox[{0., 1., 0.4}, {0.1, 1.1, 0.5}]}, 
   {Hue[0., 1., 0.6000000000000001], 
    CuboidBox[{0., 1., 0.6000000000000001}, {0.1, 1.1, 
     0.7000000000000001}]}, 
   {Hue[0., 1., 0.8], CuboidBox[{0., 1., 0.8}, {0.1, 1.1, 0.9}]}, 
   {Hue[0., 1., 1.], CuboidBox[{0., 1., 1.}, {0.1, 1.1, 1.1}]}, 
   {Hue[0.2, 0., 0.], 
    CuboidBox[{0.2, 0., 0.}, {0.30000000000000004`, 0.1, 0.1}]}, 
   {Hue[0.2, 0., 0.2], 
    CuboidBox[{0.2, 0., 0.2}, {0.30000000000000004`, 0.1, 
     0.30000000000000004`}]}, 
   {Hue[0.2, 0., 0.4], 
    CuboidBox[{0.2, 0., 0.4}, {0.30000000000000004`, 0.1, 0.5}]}, 
   {Hue[0.2, 0., 0.6000000000000001], 
    CuboidBox[{0.2, 0., 0.6000000000000001}, {0.30000000000000004`, 0.1, 
     0.7000000000000001}]}, 
   {Hue[0.2, 0., 0.8], 
    CuboidBox[{0.2, 0., 0.8}, {0.30000000000000004`, 0.1, 0.9}]}, 
   {Hue[0.2, 0., 1.], 
    CuboidBox[{0.2, 0., 1.}, {0.30000000000000004`, 0.1, 1.1}]}, 
   {Hue[0.2, 0.2, 0.], 
    CuboidBox[{0.2, 0.2, 0.}, {0.30000000000000004`, 0.30000000000000004`, 
     0.1}]}, 
   {Hue[0.2, 0.2, 0.2], 
    CuboidBox[{0.2, 0.2, 0.2}, {0.30000000000000004`, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {Hue[0.2, 0.2, 0.4], 
    CuboidBox[{0.2, 0.2, 0.4}, {0.30000000000000004`, 0.30000000000000004`, 
     0.5}]}, 
   {Hue[0.2, 0.2, 0.6000000000000001], 
    CuboidBox[{0.2, 0.2, 0.6000000000000001}, {0.30000000000000004`, 
     0.30000000000000004`, 0.7000000000000001}]}, 
   {Hue[0.2, 0.2, 0.8], 
    CuboidBox[{0.2, 0.2, 0.8}, {0.30000000000000004`, 0.30000000000000004`, 
     0.9}]}, 
   {Hue[0.2, 0.2, 1.], 
    CuboidBox[{0.2, 0.2, 1.}, {0.30000000000000004`, 0.30000000000000004`, 
     1.1}]}, 
   {Hue[0.2, 0.4, 0.], 
    CuboidBox[{0.2, 0.4, 0.}, {0.30000000000000004`, 0.5, 0.1}]}, 
   {Hue[0.2, 0.4, 0.2], 
    CuboidBox[{0.2, 0.4, 0.2}, {0.30000000000000004`, 0.5, 
     0.30000000000000004`}]}, 
   {Hue[0.2, 0.4, 0.4], 
    CuboidBox[{0.2, 0.4, 0.4}, {0.30000000000000004`, 0.5, 0.5}]}, 
   {Hue[0.2, 0.4, 0.6000000000000001], 
    CuboidBox[{0.2, 0.4, 0.6000000000000001}, {0.30000000000000004`, 0.5, 
     0.7000000000000001}]}, 
   {Hue[0.2, 0.4, 0.8], 
    CuboidBox[{0.2, 0.4, 0.8}, {0.30000000000000004`, 0.5, 0.9}]}, 
   {Hue[0.2, 0.4, 1.], 
    CuboidBox[{0.2, 0.4, 1.}, {0.30000000000000004`, 0.5, 1.1}]}, 
   {Hue[0.2, 0.6000000000000001, 0.], 
    CuboidBox[{0.2, 0.6000000000000001, 0.}, {0.30000000000000004`, 
     0.7000000000000001, 0.1}]}, 
   {Hue[0.2, 0.6000000000000001, 0.2], 
    CuboidBox[{0.2, 0.6000000000000001, 0.2}, {0.30000000000000004`, 
     0.7000000000000001, 0.30000000000000004`}]}, 
   {Hue[0.2, 0.6000000000000001, 0.4], 
    CuboidBox[{0.2, 0.6000000000000001, 0.4}, {0.30000000000000004`, 
     0.7000000000000001, 0.5}]}, 
   {Hue[0.2, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.2, 0.6000000000000001, 0.6000000000000001}, {
     0.30000000000000004`, 0.7000000000000001, 0.7000000000000001}]}, 
   {Hue[0.2, 0.6000000000000001, 0.8], 
    CuboidBox[{0.2, 0.6000000000000001, 0.8}, {0.30000000000000004`, 
     0.7000000000000001, 0.9}]}, 
   {Hue[0.2, 0.6000000000000001, 1.], 
    CuboidBox[{0.2, 0.6000000000000001, 1.}, {0.30000000000000004`, 
     0.7000000000000001, 1.1}]}, 
   {Hue[0.2, 0.8, 0.], 
    CuboidBox[{0.2, 0.8, 0.}, {0.30000000000000004`, 0.9, 0.1}]}, 
   {Hue[0.2, 0.8, 0.2], 
    CuboidBox[{0.2, 0.8, 0.2}, {0.30000000000000004`, 0.9, 
     0.30000000000000004`}]}, 
   {Hue[0.2, 0.8, 0.4], 
    CuboidBox[{0.2, 0.8, 0.4}, {0.30000000000000004`, 0.9, 0.5}]}, 
   {Hue[0.2, 0.8, 0.6000000000000001], 
    CuboidBox[{0.2, 0.8, 0.6000000000000001}, {0.30000000000000004`, 0.9, 
     0.7000000000000001}]}, 
   {Hue[0.2, 0.8, 0.8], 
    CuboidBox[{0.2, 0.8, 0.8}, {0.30000000000000004`, 0.9, 0.9}]}, 
   {Hue[0.2, 0.8, 1.], 
    CuboidBox[{0.2, 0.8, 1.}, {0.30000000000000004`, 0.9, 1.1}]}, 
   {Hue[0.2, 1., 0.], 
    CuboidBox[{0.2, 1., 0.}, {0.30000000000000004`, 1.1, 0.1}]}, 
   {Hue[0.2, 1., 0.2], 
    CuboidBox[{0.2, 1., 0.2}, {0.30000000000000004`, 1.1, 
     0.30000000000000004`}]}, 
   {Hue[0.2, 1., 0.4], 
    CuboidBox[{0.2, 1., 0.4}, {0.30000000000000004`, 1.1, 0.5}]}, 
   {Hue[0.2, 1., 0.6000000000000001], 
    CuboidBox[{0.2, 1., 0.6000000000000001}, {0.30000000000000004`, 1.1, 
     0.7000000000000001}]}, 
   {Hue[0.2, 1., 0.8], 
    CuboidBox[{0.2, 1., 0.8}, {0.30000000000000004`, 1.1, 0.9}]}, 
   {Hue[0.2, 1., 1.], 
    CuboidBox[{0.2, 1., 1.}, {0.30000000000000004`, 1.1, 1.1}]}, 
   {Hue[0.4, 0., 0.], CuboidBox[{0.4, 0., 0.}, {0.5, 0.1, 0.1}]}, 
   {Hue[0.4, 0., 0.2], 
    CuboidBox[{0.4, 0., 0.2}, {0.5, 0.1, 0.30000000000000004`}]}, 
   {Hue[0.4, 0., 0.4], CuboidBox[{0.4, 0., 0.4}, {0.5, 0.1, 0.5}]}, 
   {Hue[0.4, 0., 0.6000000000000001], 
    CuboidBox[{0.4, 0., 0.6000000000000001}, {0.5, 0.1, 
     0.7000000000000001}]}, 
   {Hue[0.4, 0., 0.8], CuboidBox[{0.4, 0., 0.8}, {0.5, 0.1, 0.9}]}, 
   {Hue[0.4, 0., 1.], CuboidBox[{0.4, 0., 1.}, {0.5, 0.1, 1.1}]}, 
   {Hue[0.4, 0.2, 0.], 
    CuboidBox[{0.4, 0.2, 0.}, {0.5, 0.30000000000000004`, 0.1}]}, 
   {Hue[0.4, 0.2, 0.2], 
    CuboidBox[{0.4, 0.2, 0.2}, {0.5, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {Hue[0.4, 0.2, 0.4], 
    CuboidBox[{0.4, 0.2, 0.4}, {0.5, 0.30000000000000004`, 0.5}]}, 
   {Hue[0.4, 0.2, 0.6000000000000001], 
    CuboidBox[{0.4, 0.2, 0.6000000000000001}, {0.5, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {Hue[0.4, 0.2, 0.8], 
    CuboidBox[{0.4, 0.2, 0.8}, {0.5, 0.30000000000000004`, 0.9}]}, 
   {Hue[0.4, 0.2, 1.], 
    CuboidBox[{0.4, 0.2, 1.}, {0.5, 0.30000000000000004`, 1.1}]}, 
   {Hue[0.4, 0.4, 0.], CuboidBox[{0.4, 0.4, 0.}, {0.5, 0.5, 0.1}]}, 
   {Hue[0.4, 0.4, 0.2], 
    CuboidBox[{0.4, 0.4, 0.2}, {0.5, 0.5, 0.30000000000000004`}]}, 
   {Hue[0.4, 0.4, 0.4], CuboidBox[{0.4, 0.4, 0.4}, {0.5, 0.5, 0.5}]}, 
   {Hue[0.4, 0.4, 0.6000000000000001], 
    CuboidBox[{0.4, 0.4, 0.6000000000000001}, {0.5, 0.5, 
     0.7000000000000001}]}, 
   {Hue[0.4, 0.4, 0.8], CuboidBox[{0.4, 0.4, 0.8}, {0.5, 0.5, 0.9}]}, 
   {Hue[0.4, 0.4, 1.], CuboidBox[{0.4, 0.4, 1.}, {0.5, 0.5, 1.1}]}, 
   {Hue[0.4, 0.6000000000000001, 0.], 
    CuboidBox[{0.4, 0.6000000000000001, 0.}, {0.5, 0.7000000000000001, 
     0.1}]}, 
   {Hue[0.4, 0.6000000000000001, 0.2], 
    CuboidBox[{0.4, 0.6000000000000001, 0.2}, {0.5, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {Hue[0.4, 0.6000000000000001, 0.4], 
    CuboidBox[{0.4, 0.6000000000000001, 0.4}, {0.5, 0.7000000000000001, 
     0.5}]}, 
   {Hue[0.4, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.4, 0.6000000000000001, 0.6000000000000001}, {0.5, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {Hue[0.4, 0.6000000000000001, 0.8], 
    CuboidBox[{0.4, 0.6000000000000001, 0.8}, {0.5, 0.7000000000000001, 
     0.9}]}, 
   {Hue[0.4, 0.6000000000000001, 1.], 
    CuboidBox[{0.4, 0.6000000000000001, 1.}, {0.5, 0.7000000000000001, 
     1.1}]}, 
   {Hue[0.4, 0.8, 0.], CuboidBox[{0.4, 0.8, 0.}, {0.5, 0.9, 0.1}]}, 
   {Hue[0.4, 0.8, 0.2], 
    CuboidBox[{0.4, 0.8, 0.2}, {0.5, 0.9, 0.30000000000000004`}]}, 
   {Hue[0.4, 0.8, 0.4], CuboidBox[{0.4, 0.8, 0.4}, {0.5, 0.9, 0.5}]}, 
   {Hue[0.4, 0.8, 0.6000000000000001], 
    CuboidBox[{0.4, 0.8, 0.6000000000000001}, {0.5, 0.9, 
     0.7000000000000001}]}, 
   {Hue[0.4, 0.8, 0.8], CuboidBox[{0.4, 0.8, 0.8}, {0.5, 0.9, 0.9}]}, 
   {Hue[0.4, 0.8, 1.], CuboidBox[{0.4, 0.8, 1.}, {0.5, 0.9, 1.1}]}, 
   {Hue[0.4, 1., 0.], CuboidBox[{0.4, 1., 0.}, {0.5, 1.1, 0.1}]}, 
   {Hue[0.4, 1., 0.2], 
    CuboidBox[{0.4, 1., 0.2}, {0.5, 1.1, 0.30000000000000004`}]}, 
   {Hue[0.4, 1., 0.4], CuboidBox[{0.4, 1., 0.4}, {0.5, 1.1, 0.5}]}, 
   {Hue[0.4, 1., 0.6000000000000001], 
    CuboidBox[{0.4, 1., 0.6000000000000001}, {0.5, 1.1, 
     0.7000000000000001}]}, 
   {Hue[0.4, 1., 0.8], CuboidBox[{0.4, 1., 0.8}, {0.5, 1.1, 0.9}]}, 
   {Hue[0.4, 1., 1.], CuboidBox[{0.4, 1., 1.}, {0.5, 1.1, 1.1}]}, 
   {Hue[0.6000000000000001, 0., 0.], 
    CuboidBox[{0.6000000000000001, 0., 0.}, {0.7000000000000001, 0.1, 
     0.1}]}, 
   {Hue[0.6000000000000001, 0., 0.2], 
    CuboidBox[{0.6000000000000001, 0., 0.2}, {0.7000000000000001, 0.1, 
     0.30000000000000004`}]}, 
   {Hue[0.6000000000000001, 0., 0.4], 
    CuboidBox[{0.6000000000000001, 0., 0.4}, {0.7000000000000001, 0.1, 
     0.5}]}, 
   {Hue[0.6000000000000001, 0., 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0., 0.6000000000000001}, {
     0.7000000000000001, 0.1, 0.7000000000000001}]}, 
   {Hue[0.6000000000000001, 0., 0.8], 
    CuboidBox[{0.6000000000000001, 0., 0.8}, {0.7000000000000001, 0.1, 
     0.9}]}, 
   {Hue[0.6000000000000001, 0., 1.], 
    CuboidBox[{0.6000000000000001, 0., 1.}, {0.7000000000000001, 0.1, 
     1.1}]}, 
   {Hue[0.6000000000000001, 0.2, 0.], 
    CuboidBox[{0.6000000000000001, 0.2, 0.}, {0.7000000000000001, 
     0.30000000000000004`, 0.1}]}, 
   {Hue[0.6000000000000001, 0.2, 0.2], 
    CuboidBox[{0.6000000000000001, 0.2, 0.2}, {0.7000000000000001, 
     0.30000000000000004`, 0.30000000000000004`}]}, 
   {Hue[0.6000000000000001, 0.2, 0.4], 
    CuboidBox[{0.6000000000000001, 0.2, 0.4}, {0.7000000000000001, 
     0.30000000000000004`, 0.5}]}, 
   {Hue[0.6000000000000001, 0.2, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.2, 0.6000000000000001}, {
     0.7000000000000001, 0.30000000000000004`, 0.7000000000000001}]}, 
   {Hue[0.6000000000000001, 0.2, 0.8], 
    CuboidBox[{0.6000000000000001, 0.2, 0.8}, {0.7000000000000001, 
     0.30000000000000004`, 0.9}]}, 
   {Hue[0.6000000000000001, 0.2, 1.], 
    CuboidBox[{0.6000000000000001, 0.2, 1.}, {0.7000000000000001, 
     0.30000000000000004`, 1.1}]}, 
   {Hue[0.6000000000000001, 0.4, 0.], 
    CuboidBox[{0.6000000000000001, 0.4, 0.}, {0.7000000000000001, 0.5, 
     0.1}]}, 
   {Hue[0.6000000000000001, 0.4, 0.2], 
    CuboidBox[{0.6000000000000001, 0.4, 0.2}, {0.7000000000000001, 0.5, 
     0.30000000000000004`}]}, 
   {Hue[0.6000000000000001, 0.4, 0.4], 
    CuboidBox[{0.6000000000000001, 0.4, 0.4}, {0.7000000000000001, 0.5, 
     0.5}]}, 
   {Hue[0.6000000000000001, 0.4, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.4, 0.6000000000000001}, {
     0.7000000000000001, 0.5, 0.7000000000000001}]}, 
   {Hue[0.6000000000000001, 0.4, 0.8], 
    CuboidBox[{0.6000000000000001, 0.4, 0.8}, {0.7000000000000001, 0.5, 
     0.9}]}, 
   {Hue[0.6000000000000001, 0.4, 1.], 
    CuboidBox[{0.6000000000000001, 0.4, 1.}, {0.7000000000000001, 0.5, 
     1.1}]}, 
   {Hue[0.6000000000000001, 0.6000000000000001, 0.], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.}, {
     0.7000000000000001, 0.7000000000000001, 0.1}]}, 
   {Hue[0.6000000000000001, 0.6000000000000001, 0.2], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.2}, {
     0.7000000000000001, 0.7000000000000001, 0.30000000000000004`}]}, 
   {Hue[0.6000000000000001, 0.6000000000000001, 0.4], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.4}, {
     0.7000000000000001, 0.7000000000000001, 0.5}]}, 
   {Hue[0.6000000000000001, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.6000000000000001}, {
     0.7000000000000001, 0.7000000000000001, 0.7000000000000001}]}, 
   {Hue[0.6000000000000001, 0.6000000000000001, 0.8], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 0.8}, {
     0.7000000000000001, 0.7000000000000001, 0.9}]}, 
   {Hue[0.6000000000000001, 0.6000000000000001, 1.], 
    CuboidBox[{0.6000000000000001, 0.6000000000000001, 1.}, {
     0.7000000000000001, 0.7000000000000001, 1.1}]}, 
   {Hue[0.6000000000000001, 0.8, 0.], 
    CuboidBox[{0.6000000000000001, 0.8, 0.}, {0.7000000000000001, 0.9, 
     0.1}]}, 
   {Hue[0.6000000000000001, 0.8, 0.2], 
    CuboidBox[{0.6000000000000001, 0.8, 0.2}, {0.7000000000000001, 0.9, 
     0.30000000000000004`}]}, 
   {Hue[0.6000000000000001, 0.8, 0.4], 
    CuboidBox[{0.6000000000000001, 0.8, 0.4}, {0.7000000000000001, 0.9, 
     0.5}]}, 
   {Hue[0.6000000000000001, 0.8, 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 0.8, 0.6000000000000001}, {
     0.7000000000000001, 0.9, 0.7000000000000001}]}, 
   {Hue[0.6000000000000001, 0.8, 0.8], 
    CuboidBox[{0.6000000000000001, 0.8, 0.8}, {0.7000000000000001, 0.9, 
     0.9}]}, 
   {Hue[0.6000000000000001, 0.8, 1.], 
    CuboidBox[{0.6000000000000001, 0.8, 1.}, {0.7000000000000001, 0.9, 
     1.1}]}, 
   {Hue[0.6000000000000001, 1., 0.], 
    CuboidBox[{0.6000000000000001, 1., 0.}, {0.7000000000000001, 1.1, 
     0.1}]}, 
   {Hue[0.6000000000000001, 1., 0.2], 
    CuboidBox[{0.6000000000000001, 1., 0.2}, {0.7000000000000001, 1.1, 
     0.30000000000000004`}]}, 
   {Hue[0.6000000000000001, 1., 0.4], 
    CuboidBox[{0.6000000000000001, 1., 0.4}, {0.7000000000000001, 1.1, 
     0.5}]}, 
   {Hue[0.6000000000000001, 1., 0.6000000000000001], 
    CuboidBox[{0.6000000000000001, 1., 0.6000000000000001}, {
     0.7000000000000001, 1.1, 0.7000000000000001}]}, 
   {Hue[0.6000000000000001, 1., 0.8], 
    CuboidBox[{0.6000000000000001, 1., 0.8}, {0.7000000000000001, 1.1, 
     0.9}]}, 
   {Hue[0.6000000000000001, 1., 1.], 
    CuboidBox[{0.6000000000000001, 1., 1.}, {0.7000000000000001, 1.1, 
     1.1}]}, 
   {Hue[0.8, 0., 0.], CuboidBox[{0.8, 0., 0.}, {0.9, 0.1, 0.1}]}, 
   {Hue[0.8, 0., 0.2], 
    CuboidBox[{0.8, 0., 0.2}, {0.9, 0.1, 0.30000000000000004`}]}, 
   {Hue[0.8, 0., 0.4], CuboidBox[{0.8, 0., 0.4}, {0.9, 0.1, 0.5}]}, 
   {Hue[0.8, 0., 0.6000000000000001], 
    CuboidBox[{0.8, 0., 0.6000000000000001}, {0.9, 0.1, 
     0.7000000000000001}]}, 
   {Hue[0.8, 0., 0.8], CuboidBox[{0.8, 0., 0.8}, {0.9, 0.1, 0.9}]}, 
   {Hue[0.8, 0., 1.], CuboidBox[{0.8, 0., 1.}, {0.9, 0.1, 1.1}]}, 
   {Hue[0.8, 0.2, 0.], 
    CuboidBox[{0.8, 0.2, 0.}, {0.9, 0.30000000000000004`, 0.1}]}, 
   {Hue[0.8, 0.2, 0.2], 
    CuboidBox[{0.8, 0.2, 0.2}, {0.9, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {Hue[0.8, 0.2, 0.4], 
    CuboidBox[{0.8, 0.2, 0.4}, {0.9, 0.30000000000000004`, 0.5}]}, 
   {Hue[0.8, 0.2, 0.6000000000000001], 
    CuboidBox[{0.8, 0.2, 0.6000000000000001}, {0.9, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {Hue[0.8, 0.2, 0.8], 
    CuboidBox[{0.8, 0.2, 0.8}, {0.9, 0.30000000000000004`, 0.9}]}, 
   {Hue[0.8, 0.2, 1.], 
    CuboidBox[{0.8, 0.2, 1.}, {0.9, 0.30000000000000004`, 1.1}]}, 
   {Hue[0.8, 0.4, 0.], CuboidBox[{0.8, 0.4, 0.}, {0.9, 0.5, 0.1}]}, 
   {Hue[0.8, 0.4, 0.2], 
    CuboidBox[{0.8, 0.4, 0.2}, {0.9, 0.5, 0.30000000000000004`}]}, 
   {Hue[0.8, 0.4, 0.4], CuboidBox[{0.8, 0.4, 0.4}, {0.9, 0.5, 0.5}]}, 
   {Hue[0.8, 0.4, 0.6000000000000001], 
    CuboidBox[{0.8, 0.4, 0.6000000000000001}, {0.9, 0.5, 
     0.7000000000000001}]}, 
   {Hue[0.8, 0.4, 0.8], CuboidBox[{0.8, 0.4, 0.8}, {0.9, 0.5, 0.9}]}, 
   {Hue[0.8, 0.4, 1.], CuboidBox[{0.8, 0.4, 1.}, {0.9, 0.5, 1.1}]}, 
   {Hue[0.8, 0.6000000000000001, 0.], 
    CuboidBox[{0.8, 0.6000000000000001, 0.}, {0.9, 0.7000000000000001, 
     0.1}]}, 
   {Hue[0.8, 0.6000000000000001, 0.2], 
    CuboidBox[{0.8, 0.6000000000000001, 0.2}, {0.9, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {Hue[0.8, 0.6000000000000001, 0.4], 
    CuboidBox[{0.8, 0.6000000000000001, 0.4}, {0.9, 0.7000000000000001, 
     0.5}]}, 
   {Hue[0.8, 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{0.8, 0.6000000000000001, 0.6000000000000001}, {0.9, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {Hue[0.8, 0.6000000000000001, 0.8], 
    CuboidBox[{0.8, 0.6000000000000001, 0.8}, {0.9, 0.7000000000000001, 
     0.9}]}, 
   {Hue[0.8, 0.6000000000000001, 1.], 
    CuboidBox[{0.8, 0.6000000000000001, 1.}, {0.9, 0.7000000000000001, 
     1.1}]}, 
   {Hue[0.8, 0.8, 0.], CuboidBox[{0.8, 0.8, 0.}, {0.9, 0.9, 0.1}]}, 
   {Hue[0.8, 0.8, 0.2], 
    CuboidBox[{0.8, 0.8, 0.2}, {0.9, 0.9, 0.30000000000000004`}]}, 
   {Hue[0.8, 0.8, 0.4], CuboidBox[{0.8, 0.8, 0.4}, {0.9, 0.9, 0.5}]}, 
   {Hue[0.8, 0.8, 0.6000000000000001], 
    CuboidBox[{0.8, 0.8, 0.6000000000000001}, {0.9, 0.9, 
     0.7000000000000001}]}, 
   {Hue[0.8, 0.8, 0.8], CuboidBox[{0.8, 0.8, 0.8}, {0.9, 0.9, 0.9}]}, 
   {Hue[0.8, 0.8, 1.], CuboidBox[{0.8, 0.8, 1.}, {0.9, 0.9, 1.1}]}, 
   {Hue[0.8, 1., 0.], CuboidBox[{0.8, 1., 0.}, {0.9, 1.1, 0.1}]}, 
   {Hue[0.8, 1., 0.2], 
    CuboidBox[{0.8, 1., 0.2}, {0.9, 1.1, 0.30000000000000004`}]}, 
   {Hue[0.8, 1., 0.4], CuboidBox[{0.8, 1., 0.4}, {0.9, 1.1, 0.5}]}, 
   {Hue[0.8, 1., 0.6000000000000001], 
    CuboidBox[{0.8, 1., 0.6000000000000001}, {0.9, 1.1, 
     0.7000000000000001}]}, 
   {Hue[0.8, 1., 0.8], CuboidBox[{0.8, 1., 0.8}, {0.9, 1.1, 0.9}]}, 
   {Hue[0.8, 1., 1.], CuboidBox[{0.8, 1., 1.}, {0.9, 1.1, 1.1}]}, 
   {Hue[1., 0., 0.], CuboidBox[{1., 0., 0.}, {1.1, 0.1, 0.1}]}, 
   {Hue[1., 0., 0.2], 
    CuboidBox[{1., 0., 0.2}, {1.1, 0.1, 0.30000000000000004`}]}, 
   {Hue[1., 0., 0.4], CuboidBox[{1., 0., 0.4}, {1.1, 0.1, 0.5}]}, 
   {Hue[1., 0., 0.6000000000000001], 
    CuboidBox[{1., 0., 0.6000000000000001}, {1.1, 0.1, 
     0.7000000000000001}]}, 
   {Hue[1., 0., 0.8], CuboidBox[{1., 0., 0.8}, {1.1, 0.1, 0.9}]}, 
   {Hue[1., 0., 1.], CuboidBox[{1., 0., 1.}, {1.1, 0.1, 1.1}]}, 
   {Hue[1., 0.2, 0.], 
    CuboidBox[{1., 0.2, 0.}, {1.1, 0.30000000000000004`, 0.1}]}, 
   {Hue[1., 0.2, 0.2], 
    CuboidBox[{1., 0.2, 0.2}, {1.1, 0.30000000000000004`, 
     0.30000000000000004`}]}, 
   {Hue[1., 0.2, 0.4], 
    CuboidBox[{1., 0.2, 0.4}, {1.1, 0.30000000000000004`, 0.5}]}, 
   {Hue[1., 0.2, 0.6000000000000001], 
    CuboidBox[{1., 0.2, 0.6000000000000001}, {1.1, 0.30000000000000004`, 
     0.7000000000000001}]}, 
   {Hue[1., 0.2, 0.8], 
    CuboidBox[{1., 0.2, 0.8}, {1.1, 0.30000000000000004`, 0.9}]}, 
   {Hue[1., 0.2, 1.], 
    CuboidBox[{1., 0.2, 1.}, {1.1, 0.30000000000000004`, 1.1}]}, 
   {Hue[1., 0.4, 0.], CuboidBox[{1., 0.4, 0.}, {1.1, 0.5, 0.1}]}, 
   {Hue[1., 0.4, 0.2], 
    CuboidBox[{1., 0.4, 0.2}, {1.1, 0.5, 0.30000000000000004`}]}, 
   {Hue[1., 0.4, 0.4], CuboidBox[{1., 0.4, 0.4}, {1.1, 0.5, 0.5}]}, 
   {Hue[1., 0.4, 0.6000000000000001], 
    CuboidBox[{1., 0.4, 0.6000000000000001}, {1.1, 0.5, 
     0.7000000000000001}]}, 
   {Hue[1., 0.4, 0.8], CuboidBox[{1., 0.4, 0.8}, {1.1, 0.5, 0.9}]}, 
   {Hue[1., 0.4, 1.], CuboidBox[{1., 0.4, 1.}, {1.1, 0.5, 1.1}]}, 
   {Hue[1., 0.6000000000000001, 0.], 
    CuboidBox[{1., 0.6000000000000001, 0.}, {1.1, 0.7000000000000001, 
     0.1}]}, 
   {Hue[1., 0.6000000000000001, 0.2], 
    CuboidBox[{1., 0.6000000000000001, 0.2}, {1.1, 0.7000000000000001, 
     0.30000000000000004`}]}, 
   {Hue[1., 0.6000000000000001, 0.4], 
    CuboidBox[{1., 0.6000000000000001, 0.4}, {1.1, 0.7000000000000001, 
     0.5}]}, 
   {Hue[1., 0.6000000000000001, 0.6000000000000001], 
    CuboidBox[{1., 0.6000000000000001, 0.6000000000000001}, {1.1, 
     0.7000000000000001, 0.7000000000000001}]}, 
   {Hue[1., 0.6000000000000001, 0.8], 
    CuboidBox[{1., 0.6000000000000001, 0.8}, {1.1, 0.7000000000000001, 
     0.9}]}, 
   {Hue[1., 0.6000000000000001, 1.], 
    CuboidBox[{1., 0.6000000000000001, 1.}, {1.1, 0.7000000000000001, 
     1.1}]}, 
   {Hue[1., 0.8, 0.], CuboidBox[{1., 0.8, 0.}, {1.1, 0.9, 0.1}]}, 
   {Hue[1., 0.8, 0.2], 
    CuboidBox[{1., 0.8, 0.2}, {1.1, 0.9, 0.30000000000000004`}]}, 
   {Hue[1., 0.8, 0.4], CuboidBox[{1., 0.8, 0.4}, {1.1, 0.9, 0.5}]}, 
   {Hue[1., 0.8, 0.6000000000000001], 
    CuboidBox[{1., 0.8, 0.6000000000000001}, {1.1, 0.9, 
     0.7000000000000001}]}, 
   {Hue[1., 0.8, 0.8], CuboidBox[{1., 0.8, 0.8}, {1.1, 0.9, 0.9}]}, 
   {Hue[1., 0.8, 1.], CuboidBox[{1., 0.8, 1.}, {1.1, 0.9, 1.1}]}, 
   {Hue[1., 1., 0.], CuboidBox[{1., 1., 0.}, {1.1, 1.1, 0.1}]}, 
   {Hue[1., 1., 0.2], 
    CuboidBox[{1., 1., 0.2}, {1.1, 1.1, 0.30000000000000004`}]}, 
   {Hue[1., 1., 0.4], CuboidBox[{1., 1., 0.4}, {1.1, 1.1, 0.5}]}, 
   {Hue[1., 1., 0.6000000000000001], 
    CuboidBox[{1., 1., 0.6000000000000001}, {1.1, 1.1, 
     0.7000000000000001}]}, 
   {Hue[1., 1., 0.8], CuboidBox[{1., 1., 0.8}, {1.1, 1.1, 0.9}]}, 
   {Hue[1., 1., 1.], CuboidBox[{1., 1., 1.}, {1.1, 1.1, 1.1}]}},
  Axes->True,
  AxesLabel->{
    FormBox["\"Hue\"", TraditionalForm], 
    FormBox["\"Saturation\"", TraditionalForm], 
    FormBox["\"Brightness\"", TraditionalForm]},
  Lighting->"Neutral"]], "Output",
 ImageSize->{229, 213},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->126310529,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72397191],

Cell["\<\
Dynamically view the color planes in the brightness direction:\
\>", "ExampleText",
 CellID->226241307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", "=", ".5"}], "}"}], ",", 
   RowBox[{"Panel", "[", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Column", "[", 
        RowBox[{"{", 
         RowBox[{"\"\<Lighter\>\"", ",", 
          RowBox[{"VerticalSlider", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", "b", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "Small"}]}], "]"}], ",", 
          "\"\<Darker\>\""}], "}"}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Raster", "[", 
         RowBox[{
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"h", ",", "s", ",", 
              RowBox[{"Dynamic", "[", "b", "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"s", ",", "0", ",", "1", ",", ".05"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"h", ",", "0", ",", "1", ",", ".05"}], "}"}]}], "]"}], 
          ",", 
          RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}], "]"}]}], 
      "}"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618649343],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`b$$ = 0.7000000000000001}, 
  PanelBox[
   InterpretationBox[
    RowBox[{
     TagBox[GridBox[{
        {"\<\"Lighter\"\>"},
        {
         SliderBox[Dynamic[$CellContext`b$$], {0, 1},
          Appearance->"Vertical",
          ImageSize->Small]},
        {"\<\"Darker\"\>"}
       },
       GridBoxAlignment->{"Columns" -> {{Left}}}],
      "Column"], "\[InvisibleSpace]", 
     GraphicsBox[
      RasterBox[{{{0., 0., Dynamic[$CellContext`b$$]}, {
         0.05, 0., Dynamic[$CellContext`b$$]}, {
         0.1, 0., Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0., Dynamic[$CellContext`b$$]}, {
         0.2, 0., Dynamic[$CellContext`b$$]}, {
         0.25, 0., Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0., Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0., Dynamic[$CellContext`b$$]}, {
         0.4, 0., Dynamic[$CellContext`b$$]}, {
         0.45, 0., Dynamic[$CellContext`b$$]}, {
         0.5, 0., Dynamic[$CellContext`b$$]}, {
         0.55, 0., Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0., Dynamic[$CellContext`b$$]}, {
         0.65, 0., Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0., Dynamic[$CellContext`b$$]}, {
         0.75, 0., Dynamic[$CellContext`b$$]}, {
         0.8, 0., Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0., Dynamic[$CellContext`b$$]}, {
         0.9, 0., Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0., Dynamic[$CellContext`b$$]}, {
         1., 0., Dynamic[$CellContext`b$$]}}, {{
         0., 0.05, Dynamic[$CellContext`b$$]}, {
         0.05, 0.05, Dynamic[$CellContext`b$$]}, {
         0.1, 0.05, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.05, Dynamic[$CellContext`b$$]}, {
         0.2, 0.05, Dynamic[$CellContext`b$$]}, {
         0.25, 0.05, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.05, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.05, Dynamic[$CellContext`b$$]}, {
         0.4, 0.05, Dynamic[$CellContext`b$$]}, {
         0.45, 0.05, Dynamic[$CellContext`b$$]}, {
         0.5, 0.05, Dynamic[$CellContext`b$$]}, {
         0.55, 0.05, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.05, Dynamic[$CellContext`b$$]}, {
         0.65, 0.05, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.05, Dynamic[$CellContext`b$$]}, {
         0.75, 0.05, Dynamic[$CellContext`b$$]}, {
         0.8, 0.05, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.05, Dynamic[$CellContext`b$$]}, {
         0.9, 0.05, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.05, Dynamic[$CellContext`b$$]}, {
         1., 0.05, Dynamic[$CellContext`b$$]}}, {{
         0., 0.1, Dynamic[$CellContext`b$$]}, {
         0.05, 0.1, Dynamic[$CellContext`b$$]}, {
         0.1, 0.1, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.1, Dynamic[$CellContext`b$$]}, {
         0.2, 0.1, Dynamic[$CellContext`b$$]}, {
         0.25, 0.1, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.1, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.1, Dynamic[$CellContext`b$$]}, {
         0.4, 0.1, Dynamic[$CellContext`b$$]}, {
         0.45, 0.1, Dynamic[$CellContext`b$$]}, {
         0.5, 0.1, Dynamic[$CellContext`b$$]}, {
         0.55, 0.1, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.1, Dynamic[$CellContext`b$$]}, {
         0.65, 0.1, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.1, Dynamic[$CellContext`b$$]}, {
         0.75, 0.1, Dynamic[$CellContext`b$$]}, {
         0.8, 0.1, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.1, Dynamic[$CellContext`b$$]}, {
         0.9, 0.1, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.1, Dynamic[$CellContext`b$$]}, {
         1., 0.1, Dynamic[$CellContext`b$$]}}, {{
         0., 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.05, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.1, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.15000000000000002`, 
          Dynamic[$CellContext`b$$]}, {
         0.2, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.25, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.15000000000000002`, 
          Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.15000000000000002`, 
          Dynamic[$CellContext`b$$]}, {
         0.4, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.45, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.5, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.55, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.15000000000000002`, 
          Dynamic[$CellContext`b$$]}, {
         0.65, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.15000000000000002`, 
          Dynamic[$CellContext`b$$]}, {
         0.75, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.8, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.15000000000000002`, 
          Dynamic[$CellContext`b$$]}, {
         0.9, 0.15000000000000002`, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.15000000000000002`, 
          Dynamic[$CellContext`b$$]}, {
         1., 0.15000000000000002`, Dynamic[$CellContext`b$$]}}, {{
         0., 0.2, Dynamic[$CellContext`b$$]}, {
         0.05, 0.2, Dynamic[$CellContext`b$$]}, {
         0.1, 0.2, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.2, Dynamic[$CellContext`b$$]}, {
         0.2, 0.2, Dynamic[$CellContext`b$$]}, {
         0.25, 0.2, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.2, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.2, Dynamic[$CellContext`b$$]}, {
         0.4, 0.2, Dynamic[$CellContext`b$$]}, {
         0.45, 0.2, Dynamic[$CellContext`b$$]}, {
         0.5, 0.2, Dynamic[$CellContext`b$$]}, {
         0.55, 0.2, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.2, Dynamic[$CellContext`b$$]}, {
         0.65, 0.2, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.2, Dynamic[$CellContext`b$$]}, {
         0.75, 0.2, Dynamic[$CellContext`b$$]}, {
         0.8, 0.2, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.2, Dynamic[$CellContext`b$$]}, {
         0.9, 0.2, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.2, Dynamic[$CellContext`b$$]}, {
         1., 0.2, Dynamic[$CellContext`b$$]}}, {{
         0., 0.25, Dynamic[$CellContext`b$$]}, {
         0.05, 0.25, Dynamic[$CellContext`b$$]}, {
         0.1, 0.25, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.25, Dynamic[$CellContext`b$$]}, {
         0.2, 0.25, Dynamic[$CellContext`b$$]}, {
         0.25, 0.25, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.25, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.25, Dynamic[$CellContext`b$$]}, {
         0.4, 0.25, Dynamic[$CellContext`b$$]}, {
         0.45, 0.25, Dynamic[$CellContext`b$$]}, {
         0.5, 0.25, Dynamic[$CellContext`b$$]}, {
         0.55, 0.25, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.25, Dynamic[$CellContext`b$$]}, {
         0.65, 0.25, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.25, Dynamic[$CellContext`b$$]}, {
         0.75, 0.25, Dynamic[$CellContext`b$$]}, {
         0.8, 0.25, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.25, Dynamic[$CellContext`b$$]}, {
         0.9, 0.25, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.25, Dynamic[$CellContext`b$$]}, {
         1., 0.25, Dynamic[$CellContext`b$$]}}, {{
         0., 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.05, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.1, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.30000000000000004`, 
          Dynamic[$CellContext`b$$]}, {
         0.2, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.25, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.30000000000000004`, 
          Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.30000000000000004`, 
          Dynamic[$CellContext`b$$]}, {
         0.4, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.45, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.5, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.55, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.30000000000000004`, 
          Dynamic[$CellContext`b$$]}, {
         0.65, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.30000000000000004`, 
          Dynamic[$CellContext`b$$]}, {
         0.75, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.8, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.30000000000000004`, 
          Dynamic[$CellContext`b$$]}, {
         0.9, 0.30000000000000004`, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.30000000000000004`, 
          Dynamic[$CellContext`b$$]}, {
         1., 0.30000000000000004`, Dynamic[$CellContext`b$$]}}, {{
         0., 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.05, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.1, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.35000000000000003`, 
          Dynamic[$CellContext`b$$]}, {
         0.2, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.25, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.35000000000000003`, 
          Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.35000000000000003`, 
          Dynamic[$CellContext`b$$]}, {
         0.4, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.45, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.5, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.55, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.35000000000000003`, 
          Dynamic[$CellContext`b$$]}, {
         0.65, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.35000000000000003`, 
          Dynamic[$CellContext`b$$]}, {
         0.75, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.8, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.35000000000000003`, 
          Dynamic[$CellContext`b$$]}, {
         0.9, 0.35000000000000003`, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.35000000000000003`, 
          Dynamic[$CellContext`b$$]}, {
         1., 0.35000000000000003`, Dynamic[$CellContext`b$$]}}, {{
         0., 0.4, Dynamic[$CellContext`b$$]}, {
         0.05, 0.4, Dynamic[$CellContext`b$$]}, {
         0.1, 0.4, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.4, Dynamic[$CellContext`b$$]}, {
         0.2, 0.4, Dynamic[$CellContext`b$$]}, {
         0.25, 0.4, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.4, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.4, Dynamic[$CellContext`b$$]}, {
         0.4, 0.4, Dynamic[$CellContext`b$$]}, {
         0.45, 0.4, Dynamic[$CellContext`b$$]}, {
         0.5, 0.4, Dynamic[$CellContext`b$$]}, {
         0.55, 0.4, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.4, Dynamic[$CellContext`b$$]}, {
         0.65, 0.4, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.4, Dynamic[$CellContext`b$$]}, {
         0.75, 0.4, Dynamic[$CellContext`b$$]}, {
         0.8, 0.4, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.4, Dynamic[$CellContext`b$$]}, {
         0.9, 0.4, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.4, Dynamic[$CellContext`b$$]}, {
         1., 0.4, Dynamic[$CellContext`b$$]}}, {{
         0., 0.45, Dynamic[$CellContext`b$$]}, {
         0.05, 0.45, Dynamic[$CellContext`b$$]}, {
         0.1, 0.45, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.45, Dynamic[$CellContext`b$$]}, {
         0.2, 0.45, Dynamic[$CellContext`b$$]}, {
         0.25, 0.45, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.45, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.45, Dynamic[$CellContext`b$$]}, {
         0.4, 0.45, Dynamic[$CellContext`b$$]}, {
         0.45, 0.45, Dynamic[$CellContext`b$$]}, {
         0.5, 0.45, Dynamic[$CellContext`b$$]}, {
         0.55, 0.45, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.45, Dynamic[$CellContext`b$$]}, {
         0.65, 0.45, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.45, Dynamic[$CellContext`b$$]}, {
         0.75, 0.45, Dynamic[$CellContext`b$$]}, {
         0.8, 0.45, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.45, Dynamic[$CellContext`b$$]}, {
         0.9, 0.45, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.45, Dynamic[$CellContext`b$$]}, {
         1., 0.45, Dynamic[$CellContext`b$$]}}, {{
         0., 0.5, Dynamic[$CellContext`b$$]}, {
         0.05, 0.5, Dynamic[$CellContext`b$$]}, {
         0.1, 0.5, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.5, Dynamic[$CellContext`b$$]}, {
         0.2, 0.5, Dynamic[$CellContext`b$$]}, {
         0.25, 0.5, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.5, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.5, Dynamic[$CellContext`b$$]}, {
         0.4, 0.5, Dynamic[$CellContext`b$$]}, {
         0.45, 0.5, Dynamic[$CellContext`b$$]}, {
         0.5, 0.5, Dynamic[$CellContext`b$$]}, {
         0.55, 0.5, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.5, Dynamic[$CellContext`b$$]}, {
         0.65, 0.5, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.5, Dynamic[$CellContext`b$$]}, {
         0.75, 0.5, Dynamic[$CellContext`b$$]}, {
         0.8, 0.5, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.5, Dynamic[$CellContext`b$$]}, {
         0.9, 0.5, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.5, Dynamic[$CellContext`b$$]}, {
         1., 0.5, Dynamic[$CellContext`b$$]}}, {{
         0., 0.55, Dynamic[$CellContext`b$$]}, {
         0.05, 0.55, Dynamic[$CellContext`b$$]}, {
         0.1, 0.55, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.55, Dynamic[$CellContext`b$$]}, {
         0.2, 0.55, Dynamic[$CellContext`b$$]}, {
         0.25, 0.55, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.55, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.55, Dynamic[$CellContext`b$$]}, {
         0.4, 0.55, Dynamic[$CellContext`b$$]}, {
         0.45, 0.55, Dynamic[$CellContext`b$$]}, {
         0.5, 0.55, Dynamic[$CellContext`b$$]}, {
         0.55, 0.55, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.55, Dynamic[$CellContext`b$$]}, {
         0.65, 0.55, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.55, Dynamic[$CellContext`b$$]}, {
         0.75, 0.55, Dynamic[$CellContext`b$$]}, {
         0.8, 0.55, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.55, Dynamic[$CellContext`b$$]}, {
         0.9, 0.55, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.55, Dynamic[$CellContext`b$$]}, {
         1., 0.55, Dynamic[$CellContext`b$$]}}, {{
         0., 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.05, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.1, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.6000000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.2, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.25, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.6000000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.6000000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.4, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.45, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.5, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.55, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.65, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.75, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.8, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.9, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.6000000000000001, Dynamic[$CellContext`b$$]}, {
         1., 0.6000000000000001, Dynamic[$CellContext`b$$]}}, {{
         0., 0.65, Dynamic[$CellContext`b$$]}, {
         0.05, 0.65, Dynamic[$CellContext`b$$]}, {
         0.1, 0.65, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.65, Dynamic[$CellContext`b$$]}, {
         0.2, 0.65, Dynamic[$CellContext`b$$]}, {
         0.25, 0.65, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.65, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.65, Dynamic[$CellContext`b$$]}, {
         0.4, 0.65, Dynamic[$CellContext`b$$]}, {
         0.45, 0.65, Dynamic[$CellContext`b$$]}, {
         0.5, 0.65, Dynamic[$CellContext`b$$]}, {
         0.55, 0.65, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.65, Dynamic[$CellContext`b$$]}, {
         0.65, 0.65, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.65, Dynamic[$CellContext`b$$]}, {
         0.75, 0.65, Dynamic[$CellContext`b$$]}, {
         0.8, 0.65, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.65, Dynamic[$CellContext`b$$]}, {
         0.9, 0.65, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.65, Dynamic[$CellContext`b$$]}, {
         1., 0.65, Dynamic[$CellContext`b$$]}}, {{
         0., 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.05, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.1, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.7000000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.2, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.25, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.7000000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.7000000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.4, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.45, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.5, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.55, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.65, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.75, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.8, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.9, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.7000000000000001, Dynamic[$CellContext`b$$]}, {
         1., 0.7000000000000001, Dynamic[$CellContext`b$$]}}, {{
         0., 0.75, Dynamic[$CellContext`b$$]}, {
         0.05, 0.75, Dynamic[$CellContext`b$$]}, {
         0.1, 0.75, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.75, Dynamic[$CellContext`b$$]}, {
         0.2, 0.75, Dynamic[$CellContext`b$$]}, {
         0.25, 0.75, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.75, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.75, Dynamic[$CellContext`b$$]}, {
         0.4, 0.75, Dynamic[$CellContext`b$$]}, {
         0.45, 0.75, Dynamic[$CellContext`b$$]}, {
         0.5, 0.75, Dynamic[$CellContext`b$$]}, {
         0.55, 0.75, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.75, Dynamic[$CellContext`b$$]}, {
         0.65, 0.75, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.75, Dynamic[$CellContext`b$$]}, {
         0.75, 0.75, Dynamic[$CellContext`b$$]}, {
         0.8, 0.75, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.75, Dynamic[$CellContext`b$$]}, {
         0.9, 0.75, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.75, Dynamic[$CellContext`b$$]}, {
         1., 0.75, Dynamic[$CellContext`b$$]}}, {{
         0., 0.8, Dynamic[$CellContext`b$$]}, {
         0.05, 0.8, Dynamic[$CellContext`b$$]}, {
         0.1, 0.8, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.8, Dynamic[$CellContext`b$$]}, {
         0.2, 0.8, Dynamic[$CellContext`b$$]}, {
         0.25, 0.8, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.8, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.8, Dynamic[$CellContext`b$$]}, {
         0.4, 0.8, Dynamic[$CellContext`b$$]}, {
         0.45, 0.8, Dynamic[$CellContext`b$$]}, {
         0.5, 0.8, Dynamic[$CellContext`b$$]}, {
         0.55, 0.8, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.8, Dynamic[$CellContext`b$$]}, {
         0.65, 0.8, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.8, Dynamic[$CellContext`b$$]}, {
         0.75, 0.8, Dynamic[$CellContext`b$$]}, {
         0.8, 0.8, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.8, Dynamic[$CellContext`b$$]}, {
         0.9, 0.8, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.8, Dynamic[$CellContext`b$$]}, {
         1., 0.8, Dynamic[$CellContext`b$$]}}, {{
         0., 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.05, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.1, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.8500000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.2, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.25, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.8500000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.8500000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.4, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.45, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.5, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.55, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.65, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.75, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.8, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.9, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.8500000000000001, Dynamic[$CellContext`b$$]}, {
         1., 0.8500000000000001, Dynamic[$CellContext`b$$]}}, {{
         0., 0.9, Dynamic[$CellContext`b$$]}, {
         0.05, 0.9, Dynamic[$CellContext`b$$]}, {
         0.1, 0.9, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.9, Dynamic[$CellContext`b$$]}, {
         0.2, 0.9, Dynamic[$CellContext`b$$]}, {
         0.25, 0.9, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.9, Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.9, Dynamic[$CellContext`b$$]}, {
         0.4, 0.9, Dynamic[$CellContext`b$$]}, {
         0.45, 0.9, Dynamic[$CellContext`b$$]}, {
         0.5, 0.9, Dynamic[$CellContext`b$$]}, {
         0.55, 0.9, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.9, Dynamic[$CellContext`b$$]}, {
         0.65, 0.9, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.9, Dynamic[$CellContext`b$$]}, {
         0.75, 0.9, Dynamic[$CellContext`b$$]}, {
         0.8, 0.9, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.9, Dynamic[$CellContext`b$$]}, {
         0.9, 0.9, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.9, Dynamic[$CellContext`b$$]}, {
         1., 0.9, Dynamic[$CellContext`b$$]}}, {{
         0., 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.05, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.1, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 0.9500000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.2, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.25, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 0.9500000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 0.9500000000000001, 
          Dynamic[$CellContext`b$$]}, {
         0.4, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.45, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.5, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.55, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.65, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.75, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.8, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.9, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 0.9500000000000001, Dynamic[$CellContext`b$$]}, {
         1., 0.9500000000000001, Dynamic[$CellContext`b$$]}}, {{
         0., 1., Dynamic[$CellContext`b$$]}, {
         0.05, 1., Dynamic[$CellContext`b$$]}, {
         0.1, 1., Dynamic[$CellContext`b$$]}, {
         0.15000000000000002`, 1., Dynamic[$CellContext`b$$]}, {
         0.2, 1., Dynamic[$CellContext`b$$]}, {
         0.25, 1., Dynamic[$CellContext`b$$]}, {
         0.30000000000000004`, 1., Dynamic[$CellContext`b$$]}, {
         0.35000000000000003`, 1., Dynamic[$CellContext`b$$]}, {
         0.4, 1., Dynamic[$CellContext`b$$]}, {
         0.45, 1., Dynamic[$CellContext`b$$]}, {
         0.5, 1., Dynamic[$CellContext`b$$]}, {
         0.55, 1., Dynamic[$CellContext`b$$]}, {
         0.6000000000000001, 1., Dynamic[$CellContext`b$$]}, {
         0.65, 1., Dynamic[$CellContext`b$$]}, {
         0.7000000000000001, 1., Dynamic[$CellContext`b$$]}, {
         0.75, 1., Dynamic[$CellContext`b$$]}, {
         0.8, 1., Dynamic[$CellContext`b$$]}, {
         0.8500000000000001, 1., Dynamic[$CellContext`b$$]}, {
         0.9, 1., Dynamic[$CellContext`b$$]}, {
         0.9500000000000001, 1., Dynamic[$CellContext`b$$]}, {
         1., 1., Dynamic[$CellContext`b$$]}}},
       ColorFunction->Hue]]}],
    Row[{
      Column[{"Lighter", 
        VerticalSlider[
         Dynamic[$CellContext`b$$], {0, 1}, ImageSize -> Small], "Darker"}], 
      Graphics[
       Raster[{{{0., 0., 
           Dynamic[$CellContext`b$$]}, {0.05, 0., 
           Dynamic[$CellContext`b$$]}, {0.1, 0., 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0., 
           Dynamic[$CellContext`b$$]}, {0.2, 0., 
           Dynamic[$CellContext`b$$]}, {0.25, 0., 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0., 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0., 
           Dynamic[$CellContext`b$$]}, {0.4, 0., 
           Dynamic[$CellContext`b$$]}, {0.45, 0., 
           Dynamic[$CellContext`b$$]}, {0.5, 0., 
           Dynamic[$CellContext`b$$]}, {0.55, 0., 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0., 
           Dynamic[$CellContext`b$$]}, {0.65, 0., 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0., 
           Dynamic[$CellContext`b$$]}, {0.75, 0., 
           Dynamic[$CellContext`b$$]}, {0.8, 0., 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0., 
           Dynamic[$CellContext`b$$]}, {0.9, 0., 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0., 
           Dynamic[$CellContext`b$$]}, {1., 0., 
           Dynamic[$CellContext`b$$]}}, {{0., 0.05, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.05, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.05, 
           Dynamic[$CellContext`b$$]}, {1., 0.05, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.1, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.1, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.1, 
           Dynamic[$CellContext`b$$]}, {1., 0.1, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {
          0.15000000000000002`, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {
          0.30000000000000004`, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {
          0.35000000000000003`, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {
          0.6000000000000001, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {
          0.7000000000000001, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {
          0.8500000000000001, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {
          0.9500000000000001, 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}, {1., 0.15000000000000002`, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.2, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.2, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.2, 
           Dynamic[$CellContext`b$$]}, {1., 0.2, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.25, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.25, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.25, 
           Dynamic[$CellContext`b$$]}, {1., 0.25, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {
          0.15000000000000002`, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {
          0.30000000000000004`, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {
          0.35000000000000003`, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {
          0.6000000000000001, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {
          0.7000000000000001, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {
          0.8500000000000001, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {
          0.9500000000000001, 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}, {1., 0.30000000000000004`, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {
          0.15000000000000002`, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {
          0.30000000000000004`, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {
          0.35000000000000003`, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {
          0.6000000000000001, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {
          0.7000000000000001, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {
          0.8500000000000001, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {
          0.9500000000000001, 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}, {1., 0.35000000000000003`, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.4, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.4, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.4, 
           Dynamic[$CellContext`b$$]}, {1., 0.4, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.45, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.45, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.45, 
           Dynamic[$CellContext`b$$]}, {1., 0.45, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.5, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.5, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.5, 
           Dynamic[$CellContext`b$$]}, {1., 0.5, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.55, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.55, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.55, 
           Dynamic[$CellContext`b$$]}, {1., 0.55, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.15000000000000002`, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.30000000000000004`, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.35000000000000003`, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.6000000000000001, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.7000000000000001, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.8500000000000001, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.9500000000000001, 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}, {1., 0.6000000000000001, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.65, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.65, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.65, 
           Dynamic[$CellContext`b$$]}, {1., 0.65, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.15000000000000002`, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.30000000000000004`, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.35000000000000003`, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.6000000000000001, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.7000000000000001, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.8500000000000001, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.9500000000000001, 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}, {1., 0.7000000000000001, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.75, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.75, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.75, 
           Dynamic[$CellContext`b$$]}, {1., 0.75, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.8, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.8, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.8, 
           Dynamic[$CellContext`b$$]}, {1., 0.8, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.15000000000000002`, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.30000000000000004`, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.35000000000000003`, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.6000000000000001, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.7000000000000001, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.8500000000000001, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.9500000000000001, 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}, {1., 0.8500000000000001, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.9, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.9, 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 0.9, 
           Dynamic[$CellContext`b$$]}, {1., 0.9, 
           Dynamic[$CellContext`b$$]}}, {{0., 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.05, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.1, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.15000000000000002`, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.2, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.25, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.30000000000000004`, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.35000000000000003`, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.4, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.45, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.5, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.55, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.6000000000000001, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.65, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.7000000000000001, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.75, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.8, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.8500000000000001, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {0.9, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {
          0.9500000000000001, 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}, {1., 0.9500000000000001, 
           Dynamic[$CellContext`b$$]}}, {{0., 1., 
           Dynamic[$CellContext`b$$]}, {0.05, 1., 
           Dynamic[$CellContext`b$$]}, {0.1, 1., 
           Dynamic[$CellContext`b$$]}, {0.15000000000000002`, 1., 
           Dynamic[$CellContext`b$$]}, {0.2, 1., 
           Dynamic[$CellContext`b$$]}, {0.25, 1., 
           Dynamic[$CellContext`b$$]}, {0.30000000000000004`, 1., 
           Dynamic[$CellContext`b$$]}, {0.35000000000000003`, 1., 
           Dynamic[$CellContext`b$$]}, {0.4, 1., 
           Dynamic[$CellContext`b$$]}, {0.45, 1., 
           Dynamic[$CellContext`b$$]}, {0.5, 1., 
           Dynamic[$CellContext`b$$]}, {0.55, 1., 
           Dynamic[$CellContext`b$$]}, {0.6000000000000001, 1., 
           Dynamic[$CellContext`b$$]}, {0.65, 1., 
           Dynamic[$CellContext`b$$]}, {0.7000000000000001, 1., 
           Dynamic[$CellContext`b$$]}, {0.75, 1., 
           Dynamic[$CellContext`b$$]}, {0.8, 1., 
           Dynamic[$CellContext`b$$]}, {0.8500000000000001, 1., 
           Dynamic[$CellContext`b$$]}, {0.9, 1., 
           Dynamic[$CellContext`b$$]}, {0.9500000000000001, 1., 
           Dynamic[$CellContext`b$$]}, {1., 1., 
           Dynamic[$CellContext`b$$]}}}, ColorFunction -> Hue]]}]]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{243, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69005184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->498334587],

Cell["HSB noise with opacity:", "ExampleText",
 CellID->459168869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Pink", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"100", ",", "100"}], "}"}], ",", "40"}], "]"}], ",", 
    RowBox[{"Raster", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"200", ",", "200", ",", "4"}], "}"}]}], "]"}], ",", 
      RowBox[{"ColorFunction", "\[Rule]", "Hue"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1167787],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->37532490]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29204],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CMYKColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CMYKColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opacity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opacity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Glow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Glow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Specularity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Specularity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Raster",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Raster"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Red",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Red"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Green",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Green"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Blue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Blue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["White",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/White"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSlider"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->300905716],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->11698677],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->75867773]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hue - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 50.0227426}", "context" -> "System`", 
    "keywords" -> {
     "color wheel", "HSB color space", "hue saturation brightness", 
      "perceptive color space", "color model", "color space", "diffuse color",
       "pigment"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Hue[h] is a graphics directive which specifies that objects which follow \
are to be displayed, if possible, in a color corresponding to hue h. Hue[h, \
s, b] specifies colors in terms of hue, saturation and brightness. Hue[h, s, \
b, a] specifies opacity a. ", "synonyms" -> {}, "title" -> "Hue", "type" -> 
    "Symbol", "uri" -> "ref/Hue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16246, 492, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52536857]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 391809, 7738}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2681, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3304, 78, 4187, 83, 70, "ObjectNameGrid"],
Cell[7494, 163, 1509, 49, 70, "Usage",
 CellID->3196]
}, Open  ]],
Cell[CellGroupData[{
Cell[9040, 217, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9518, 234, 788, 30, 70, "Notes",
 CellID->29678],
Cell[10309, 266, 493, 17, 70, "Notes",
 CellID->29108],
Cell[10805, 285, 515, 20, 70, "Notes",
 CellID->23486],
Cell[11323, 307, 931, 34, 70, "Notes",
 CellID->23764],
Cell[12257, 343, 125, 4, 70, "Notes",
 CellID->13437],
Cell[12385, 349, 392, 11, 70, "Notes",
 CellID->25303],
Cell[12780, 362, 511, 16, 70, "Notes",
 CellID->30323],
Cell[13294, 380, 613, 21, 70, "Notes",
 CellID->18001],
Cell[13910, 403, 920, 33, 70, "Notes",
 CellID->17041],
Cell[14833, 438, 725, 26, 70, "Notes",
 CellID->9845],
Cell[15561, 466, 648, 21, 70, "Notes",
 CellID->23630]
}, Closed]],
Cell[CellGroupData[{
Cell[16246, 492, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52536857],
Cell[CellGroupData[{
Cell[16630, 506, 148, 5, 70, "ExampleSection",
 CellID->230007530],
Cell[16781, 513, 84, 1, 70, "ExampleText",
 CellID->149026781],
Cell[CellGroupData[{
Cell[16890, 518, 210, 7, 28, "Input",
 CellID->64769354],
Cell[17103, 527, 251, 8, 121, "Output",
 CellID->44114646]
}, Open  ]],
Cell[17369, 538, 125, 3, 70, "ExampleDelimiter",
 CellID->465218549],
Cell[17497, 543, 74, 1, 70, "ExampleText",
 CellID->263465182],
Cell[CellGroupData[{
Cell[17596, 548, 289, 9, 70, "Input",
 CellID->152479682],
Cell[17888, 559, 6028, 106, 129, 151, 5, "CachedBoxData", "BoxData", "Output",
 
 CellID->654444983]
}, Open  ]],
Cell[23931, 668, 125, 3, 70, "ExampleDelimiter",
 CellID->228655064],
Cell[24059, 673, 130, 2, 70, "ExampleText",
 CellID->53708190],
Cell[CellGroupData[{
Cell[24214, 679, 254, 9, 70, "Input",
 CellID->195861199],
Cell[24471, 690, 435, 18, 36, "Output",
 CellID->271234691]
}, Open  ]],
Cell[24921, 711, 124, 3, 70, "ExampleDelimiter",
 CellID->10335802],
Cell[25048, 716, 70, 1, 70, "ExampleText",
 CellID->580206808],
Cell[CellGroupData[{
Cell[25143, 721, 430, 14, 28, "Input",
 CellID->211868938],
Cell[25576, 737, 5808, 99, 128, "Output",
 Evaluatable->False,
 CellID->199618862]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31433, 842, 216, 7, 70, "ExampleSection",
 CellID->21827],
Cell[CellGroupData[{
Cell[31674, 853, 232, 7, 70, "ExampleSubsection",
 CellID->23349739],
Cell[31909, 862, 69, 1, 70, "ExampleText",
 CellID->404625886],
Cell[CellGroupData[{
Cell[32003, 867, 215, 7, 70, "Input",
 CellID->907978],
Cell[32221, 876, 27682, 459, 216, 78, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->320790517]
}, Open  ]],
Cell[59918, 1338, 82, 1, 70, "ExampleText",
 CellID->928327454],
Cell[CellGroupData[{
Cell[60025, 1343, 298, 9, 70, "Input",
 CellID->29801507],
Cell[60326, 1354, 32687, 541, 216, 114, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->200861181]
}, Open  ]],
Cell[93028, 1898, 152, 3, 70, "ExampleText",
 CellID->255057354],
Cell[CellGroupData[{
Cell[93205, 1905, 265, 8, 70, "Input",
 CellID->93466233],
Cell[93473, 1915, 3006, 55, 216, 103, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->416773900]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96528, 1976, 237, 7, 70, "ExampleSubsection",
 CellID->122877664],
Cell[96768, 1985, 206, 8, 70, "ExampleText",
 CellID->84492988],
Cell[CellGroupData[{
Cell[96999, 1997, 824, 27, 70, "Input",
 CellID->485561805],
Cell[97826, 2026, 520, 19, 123, "Output",
 CellID->102706425]
}, Open  ]],
Cell[98361, 2048, 351, 13, 70, "ExampleText",
 CellID->480333690],
Cell[CellGroupData[{
Cell[98737, 2065, 769, 25, 70, "Input",
 CellID->516667508],
Cell[99509, 2092, 430, 14, 123, "Output",
 CellID->938374977]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[100000, 2113, 242, 7, 70, "ExampleSection",
 CellID->36779870],
Cell[100245, 2122, 432, 16, 70, "ExampleText",
 CellID->414990492],
Cell[CellGroupData[{
Cell[100702, 2142, 512, 17, 70, "Input",
 CellID->267883268],
Cell[101217, 2161, 436, 16, 123, "Output",
 CellID->35919668]
}, Open  ]],
Cell[101668, 2180, 125, 3, 70, "ExampleDelimiter",
 CellID->947276963],
Cell[101796, 2185, 632, 24, 70, "ExampleText",
 CellID->182644585],
Cell[CellGroupData[{
Cell[102453, 2213, 604, 21, 70, "Input",
 CellID->542718116],
Cell[103060, 2236, 525, 19, 123, "Output",
 CellID->246256266]
}, Open  ]],
Cell[103600, 2258, 125, 3, 70, "ExampleDelimiter",
 CellID->318365681],
Cell[103728, 2263, 305, 13, 70, "ExampleText",
 CellID->736955090],
Cell[CellGroupData[{
Cell[104058, 2280, 543, 16, 70, "Input",
 CellID->162022429],
Cell[104604, 2298, 665, 20, 91, "Output",
 CellID->48944769]
}, Open  ]],
Cell[105284, 2321, 258, 9, 70, "ExampleText",
 CellID->196212995],
Cell[CellGroupData[{
Cell[105567, 2334, 541, 16, 70, "Input",
 CellID->72375890],
Cell[106111, 2352, 690, 20, 91, "Output",
 CellID->325593736]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[106850, 2378, 223, 7, 70, "ExampleSection",
 CellID->19023],
Cell[107076, 2387, 212, 7, 70, "ExampleText",
 CellID->161734835],
Cell[CellGroupData[{
Cell[107313, 2398, 1204, 37, 70, "Input",
 CellID->40368807],
Cell[108520, 2437, 3382, 99, 123, "Output",
 CellID->65673982]
}, Open  ]],
Cell[111917, 2539, 125, 3, 70, "ExampleDelimiter",
 CellID->633186528],
Cell[112045, 2544, 117, 3, 70, "ExampleText",
 CellID->152390215],
Cell[CellGroupData[{
Cell[112187, 2551, 1128, 34, 70, "Input",
 CellID->276063042],
Cell[113318, 2587, 2791, 50, 70, "Output",
 Evaluatable->False,
 CellID->689426269]
}, Open  ]],
Cell[116124, 2640, 125, 3, 70, "ExampleDelimiter",
 CellID->414945414],
Cell[116252, 2645, 114, 3, 70, "ExampleText",
 CellID->783734],
Cell[CellGroupData[{
Cell[116391, 2652, 1222, 38, 70, "Input",
 CellID->18889618],
Cell[117616, 2692, 25556, 423, 70, "Output",
 Evaluatable->False,
 CellID->549974892]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[143221, 3121, 237, 7, 70, "ExampleSection",
 CellID->204135847],
Cell[143461, 3130, 129, 2, 70, "ExampleText",
 CellID->238064904],
Cell[CellGroupData[{
Cell[143615, 3136, 539, 17, 70, "Input",
 CellID->213732103],
Cell[144157, 3155, 527, 13, 70, "Output",
 Evaluatable->False,
 CellID->76829068]
}, Open  ]],
Cell[144699, 3171, 88, 1, 70, "ExampleText",
 CellID->234775250],
Cell[CellGroupData[{
Cell[144812, 3176, 574, 18, 70, "Input",
 CellID->475079003],
Cell[145389, 3196, 455, 12, 70, "Output",
 Evaluatable->False,
 CellID->18148429]
}, Open  ]],
Cell[145859, 3211, 93, 1, 70, "ExampleText",
 CellID->159349876],
Cell[CellGroupData[{
Cell[145977, 3216, 584, 18, 70, "Input",
 CellID->427305782],
Cell[146564, 3236, 451, 11, 70, "Output",
 Evaluatable->False,
 CellID->225472424]
}, Open  ]],
Cell[147030, 3250, 94, 1, 70, "ExampleText",
 CellID->1499401],
Cell[CellGroupData[{
Cell[147149, 3255, 494, 14, 70, "Input",
 CellID->25846182],
Cell[147646, 3271, 37691, 622, 70, "Output",
 Evaluatable->False,
 CellID->167193873]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[185386, 3899, 229, 7, 70, "ExampleSection",
 CellID->15538608],
Cell[185618, 3908, 173, 4, 70, "ExampleText",
 CellID->51548173],
Cell[CellGroupData[{
Cell[185816, 3916, 654, 21, 70, "Input",
 CellID->42100231],
Cell[186473, 3939, 419, 11, 70, "Output",
 Evaluatable->False,
 CellID->369137821]
}, Open  ]],
Cell[CellGroupData[{
Cell[186929, 3955, 664, 21, 70, "Input",
 CellID->46372159],
Cell[187596, 3978, 423, 11, 70, "Output",
 Evaluatable->False,
 CellID->113509914]
}, Open  ]],
Cell[188034, 3992, 268, 8, 70, "ExampleText",
 CellID->37537136],
Cell[CellGroupData[{
Cell[188327, 4004, 742, 22, 70, "Input",
 CellID->463429744],
Cell[189072, 4028, 1424, 28, 70, "Output",
 Evaluatable->False,
 CellID->508402006]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[190545, 4062, 228, 7, 70, "ExampleSection",
 CellID->330541375],
Cell[190776, 4071, 74, 1, 70, "ExampleText",
 CellID->40304447],
Cell[CellGroupData[{
Cell[190875, 4076, 880, 27, 70, "Input",
 CellID->124985783],
Cell[191758, 4105, 58697, 1066, 234, 23235, 480, "CachedBoxData", "BoxData", \
"Output",
 CellID->126310529]
}, Open  ]],
Cell[250470, 5174, 124, 3, 70, "ExampleDelimiter",
 CellID->72397191],
Cell[250597, 5179, 113, 3, 70, "ExampleText",
 CellID->226241307],
Cell[CellGroupData[{
Cell[250735, 5186, 1259, 35, 70, "Input",
 CellID->618649343],
Cell[251997, 5223, 55597, 992, 70, "Output",
 CellID->69005184]
}, Open  ]],
Cell[307609, 6218, 125, 3, 70, "ExampleDelimiter",
 CellID->498334587],
Cell[307737, 6223, 66, 1, 70, "ExampleText",
 CellID->459168869],
Cell[CellGroupData[{
Cell[307828, 6228, 534, 17, 70, "Input",
 CellID->1167787],
Cell[308365, 6247, 77197, 1270, 70, "Output",
 Evaluatable->False,
 CellID->37532490]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[385623, 7524, 311, 9, 70, "SeeAlsoSection",
 CellID->29204],
Cell[385937, 7535, 3840, 143, 70, "SeeAlso",
 CellID->5542]
}, Open  ]],
Cell[CellGroupData[{
Cell[389814, 7683, 319, 9, 70, "MoreAboutSection",
 CellID->300905716],
Cell[390136, 7694, 123, 3, 70, "MoreAbout",
 CellID->11698677],
Cell[390262, 7699, 148, 3, 70, "MoreAbout",
 CellID->75867773]
}, Open  ]],
Cell[390425, 7705, 50, 0, 70, "History"],
Cell[390478, 7707, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

