(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35283,       1243]
NotebookOptionsPosition[     27527,        983]
NotebookOutlinePosition[     29878,       1047]
CellTagsIndexPosition[     29651,       1039]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypergeometric1F1\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/HypergeometricFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Hypergeometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hypergeometric1F1Regularized", "ObjectName",
 CellID->21948],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hypergeometric1F1Regularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hypergeometric1F1Regularized"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the regularized confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         SubscriptBox["\[Null]", "1"], "\[InvisibleSpace]", 
         SubscriptBox["F", "1"], "(", 
         RowBox[{"a", ";", "b", ";", "z"}], ")"}], "/", 
        RowBox[{"\[CapitalGamma]", "(", "b", ")"}]}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4200]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric1F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1Regularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is finite for all finite values of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5660],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1Regularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->24675066],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1Regularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1Regularized"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282686316],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->24062198],

Cell["Evaluate numerically:", "ExampleText",
 CellID->214364962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{"1", ",", 
   RowBox[{"-", "2"}], ",", "3.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196634931],

Cell[BoxData["1419.8250027289325`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->176402624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84256639],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->147415031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", " ", 
  RowBox[{
   RowBox[{"Hypergeometric1F1Regularized", "[", 
    RowBox[{"a", ",", "b", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112124288],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"Gamma", "[", "b", "]"}]], "+", 
   FractionBox[
    RowBox[{"a", " ", "x"}], 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "b"}], "]"}]], "+", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "a"}], ")"}], " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"2", "+", "b"}], "]"}]}]], "+", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "a"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "a"}], ")"}], " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"6", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"3", "+", "b"}], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Gamma[$CellContext`b]^(-1), $CellContext`a/Gamma[1 + $CellContext`b], 
    Rational[1, 2] $CellContext`a (1 + $CellContext`a)/Gamma[
    2 + $CellContext`b], 
    Rational[1, 6] $CellContext`a (1 + $CellContext`a) (2 + $CellContext`a)/
    Gamma[3 + $CellContext`b]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{432, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->471608]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11137],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->114185134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{
   RowBox[{"3", "-", "I"}], ",", "0", ",", 
   RowBox[{"2.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->753755510],

Cell[BoxData[
 RowBox[{"422.0656462620647`", "\[InvisibleSpace]", "+", 
  RowBox[{"427.24640153483017`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142525120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53312816],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->51663803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Hypergeometric1F1Regularized", "[", 
    RowBox[{"3", ",", "0", ",", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198081954],

Cell[BoxData["162.5592341764743049990694041326501718899669425521406411299169`\
50."], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136536662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288544536],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->25172087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{"3", ",", "0", ",", "2.0000000000000000000000000"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->177343890],

Cell[BoxData["162.55923417647430499906940413265017188999`24.23071220994766"], \
"Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31378482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16832041],

Cell["Evaluate to simpler functions for certain parameters:", "ExampleText",
 CellID->74740598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{"2", ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153313181],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167100795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "1", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->420147945],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"x", "/", "2"}]], " ", 
  RowBox[{"BesselI", "[", 
   RowBox[{"0", ",", 
    FractionBox["x", "2"]}], "]"}]}]], "Output",
 ImageSize->{122, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->288717184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{"1", ",", 
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66390113],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], " ", 
    SqrtBox["\[Pi]"], " ", 
    SqrtBox["x"], " ", 
    RowBox[{"Erf", "[", 
     SqrtBox["x"], "]"}]}]}], 
  SqrtBox["\[Pi]"]]], "Output",
 ImageSize->{157, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->58325665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->981387013],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1Regularized"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->116181103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336267988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10.083800408260645`", ",", "15.125700612390968`", ",", 
   "22.68855091858645`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29588730]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->760443585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->653625731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric1F1Regularized", "[", 
   RowBox[{"a", ",", "b", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35954786],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVVF0OgjAMHhsCYtT45iMH0ANwAX3yEISYwIPRIPef6xisdOPHJUv7dV2/
di08irZ6voq2Lovs3hSfqi6/2e3dKJMIGGO52qczU7pUmt65lCDDTnQrVUAo
uQEjKFIvB28JjgnmOign1pRgsRBliSXwsoDqzQdjKFbYyuGcm8fAElxCI+EZ
gRGxboaIJlTi47VenaLZtWeIT1zLBOtMXbRP3IlJb0Sr6vgvE+aZIDcT2v3I
8aD9504WuIch6lXfQ7cyX/14GiSZs/5ozBuvylV4+AS6aWePeohp1pnvaU/w
0YmQrOo2jUOxzSbyVL4zL3rwTQDLbR6jV7gOdtqNC7pn/lnBDzgwbSo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->36481216]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14890],

Cell["Series expansion at infinity:", "ExampleText",
 CellID->140494624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Hypergeometric1F1Regularized", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "1"}], ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "Infinity", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellTags->"Ex--21904899473679702393,20",
 CellLabel->"In[1]:=",
 CellID->59593501],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{"-", "a"}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"-", "a"}]], " ", "a", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "-", "a"}], "]"}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "1"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 0, 1, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[
      1], {(-1)^(-$CellContext`a) $CellContext`a (1 + $CellContext`a)/Gamma[
       1 - $CellContext`a]}, 0, 1, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   SuperscriptBox["x", "a"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"a", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "a"}], ")"}]}], 
       FractionBox[
        RowBox[{"Gamma", "[", 
         RowBox[{"2", "+", "a"}], "]"}], "x"]], "+", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "a"}], ")"}], " ", "a", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "a"}], ")"}], "2"]}], 
       RowBox[{"Gamma", "[", 
        RowBox[{"2", "+", "a"}], "]"}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "1"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, -1, 1, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[
      1], {$CellContext`a (1 + $CellContext`a)/Gamma[
       2 + $CellContext`a], (-1 + $CellContext`a) $CellContext`a (
         1 + $CellContext`a)^2/Gamma[2 + $CellContext`a]}, -1, 1, 1],
     Editable->False], ")"}]}]}]], "Output",
 ImageSize->{476, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904899473679702393,20",
 CellLabel->"Out[1]=",
 CellID->578462857]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29801],

Cell["\<\
With a numeric second parameter, gives the ordinary hypergeometric function: \
\
\>", "ExampleText",
 CellID->581883056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{"a", ",", 
   RowBox[{"-", "1"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Ex--21904899473679702393,12",
 CellLabel->"In[1]:=",
 CellID->618818870],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "a", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "a"}], ")"}], " ", 
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", "+", "a"}], "}"}], ",", 
    RowBox[{"{", "3", "}"}], ",", "x"}], "]"}]}]], "Output",
 ImageSize->{312, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904899473679702393,12",
 CellLabel->"Out[1]=",
 CellID->40344767]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric1F1Regularized", "[", 
  RowBox[{"a", ",", 
   RowBox[{"1", "/", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->199279714],

Cell[BoxData[
 FractionBox[
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     FractionBox["1", "3"], "}"}], ",", "x"}], "]"}], 
  RowBox[{"Gamma", "[", 
   FractionBox["1", "3"], "]"}]]], "Output",
 ImageSize->{216, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45768819]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26830],

Cell[TextData[{
 "Visualize the confluence relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    TagBox[
     TagBox[
      RowBox[{
       RowBox[{
        SubscriptBox["\[InvisiblePrefixScriptBase]", "1"], 
        SubscriptBox[
         OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
       RowBox[{"(", 
        RowBox[{
         TagBox[
          TagBox[
           TagBox["a",
            Hypergeometric1F1Regularized,
            Editable->True,
            Selectable->True],
           InterpretTemplate[{
             SlotSequence[1]}& ]],
          Hypergeometric1F1Regularized,
          Editable->False,
          Selectable->False], ";", 
         TagBox[
          TagBox[
           TagBox["b",
            Hypergeometric1F1Regularized,
            Editable->True,
            Selectable->True],
           InterpretTemplate[{
             SlotSequence[1]}& ]],
          Hypergeometric1F1Regularized,
          Editable->False,
          Selectable->False], ";", 
         TagBox["z",
          Hypergeometric1F1Regularized,
          Editable->True,
          Selectable->True]}], ")"}]}],
      InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
      Editable->False,
      Selectable->False],
     Hypergeometric1F1Regularized], "\[LongEqual]", 
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"p", "\[Rule]", "\[Infinity]"}]], "\[ThinSpace]", 
     TagBox[
      TagBox[
       RowBox[{
        RowBox[{
         SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
         SubscriptBox[
          OverscriptBox["F", "~"], "1"]}], "\[InvisibleApplication]", 
        RowBox[{"(", 
         RowBox[{
          TagBox[
           TagBox[
            RowBox[{
             TagBox["a",
              Hypergeometric2F1Regularized,
              Editable->True,
              Selectable->True], ",", 
             TagBox["p",
              Hypergeometric2F1Regularized,
              Editable->True,
              Selectable->True]}],
            InterpretTemplate[{
              SlotSequence[1]}& ]],
           Hypergeometric2F1Regularized,
           Editable->False,
           Selectable->False], ";", 
          TagBox[
           TagBox[
            TagBox["b",
             Hypergeometric2F1Regularized,
             Editable->True,
             Selectable->True],
            InterpretTemplate[{
              SlotSequence[1]}& ]],
           Hypergeometric2F1Regularized,
           Editable->False,
           Selectable->False], ";", 
          TagBox[
           FractionBox["z", "p"],
           Hypergeometric2F1Regularized,
           Editable->True,
           Selectable->True]}], ")"}]}],
       InterpretTemplate[HypergeometricPFQRegularized[#, #2, #3]& ],
       Editable->False,
       Selectable->False],
      Hypergeometric2F1Regularized]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->5858554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Hypergeometric2F1Regularized", "[", 
     RowBox[{"1", ",", 
      SuperscriptBox["10", "k"], ",", "0", ",", 
      SuperscriptBox["10", 
       RowBox[{"-", "k"}]]}], "]"}], 
    RowBox[{"Hypergeometric1F1Regularized", "[", 
     RowBox[{"1", ",", "0", ",", "1"}], "]"}]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21904899473679702393,28",
 CellLabel->"In[1]:=",
 CellID->226563175],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV0H0w23ccB/CIhxAPUeLmZB6K6MZ2UWWnDt+v0mCeWvUUrhQZZV2pnity
tV6F6x3qRHMdZyzzWA8dpUSVLXpjphZl16rqFCXEQ79BiyDZ9/fH5973+uP9
x/tzPCkj/DsyiUQ6i4/Ii30pr3/s3wZ+ho9/MCtUAPff2vpdZ7ZBU4utXtJN
BRC/nCmefbsDvC93vaOwFWD4fB3HeeIjmHe4mkW1UACd7Mr18ZefgNBjZDlO
gYC+bly6aHoXfE5bocZLEajd7FmyGd0DQe/F4cxuBLg3oYN8fB9MqHgDw1UI
iBO43ASJEtBj7a6nFyHwovNCKbXjAEyvLI9ZZSPAaMvkqR8dgidCDWM5F4Gd
/ROpv9QfgbdjUwNvohFQfzAwL25RgZ/mPQ5/DUJAGjnQ1dqqBgnXnDfP+SBw
n8J3eBpCgtNWFT1KdwTi3f+IHJGSIG9sbZF5EoENwWjBF4EacKkiN2DSEQGh
JO3ew+caMKhwrnrRHgHr5owqaQgZcixHJ/+zRiBTfKaWPUyGfbxJHykDgZnq
tqKFAE0Y3HlEVn2G97cuXvl3SBP63bWuktFx/9qtgEQPLejtdbDma4JAsH63
julTLVi2kMQZoSEApd3PLNy0IbNatPXMEIGQ1OBkf7E2ZI2/LpzTR8CzN3DP
6LQODG2yXvOjIrDtTC/5qlMHrpavsPZ0ERjKzyZnnKLA1MqTbwYpCHA+1d2g
tFNgY5rYRqKDwCTTfcHDXheeCApRyrTx/79MZlU06MJjmeFWDOyBqDiej5Ue
XNmwt8zWQoAVI39AF+nBqvcM2bQmApcL2K+8GFTIzzH9Phabn6Kr1KigQrP7
7a6bZAT6LBPVcro+vF27fuoO9mNVkabjXX3IvZhZ5ob9d5evvPSYASTNwVmZ
BgISm5ThEoEB5I9H7zdg3+qNFM1TDaGt84eyTOwY29n4uFJDGB8mP+ONvdvD
YjhRjOBao5Bvhp2jufpcmG8EXSxm6rdICJjYn05kkmjweJXL7y+wr1+N2qHm
0qBL8ppZL/ZGCTXd7JAGbziEkWqwzfk+dCZ2Q0PR0c/YfrycQVdsh28HlYSr
0pZNIrA9G77+SJjNHuoXYCsWDOSEa9S5hsZHNHhhdHyKcFjWagdVRYNd+zFN
hPPSbOIssE3NBfWEGy9FaztiyzzHRIQPQ//kBGKPdXhVE252EpHvYFPZduWE
SUsxEdpqGsxrR3mEnWbLVHTsK5WOOYSjpoab7bG3CrnZhNskrke+2Mzi6QzC
MTXGjbexN76RcAkXCP3PCbD/yT1IJPywJF8pwha8cksgrMVbD5UQbmvhEGZl
2e1PYD9hLEURjk2LrXuH7fjAOoJw0aXyEITN8I89T7gz+q9dNfYj2b1Qwv8D
NkIJkA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->Small,
  Method->{},
  PlotRange->{{1, 4}, {1.0001500196071729`, 1.0949911389769378`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904899473679702393,28",
 CellLabel->"Out[1]=",
 CellID->55667120]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7223],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19629]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1273],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->17723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7189],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/\
ConfluentHypergeometricFunctionoftheFirstKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/\
Hypergeometric1F1Regularized/"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->84599791],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->10035177]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypergeometric1F1Regularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 56.3979058}", "context" -> "System`", 
    "keywords" -> {
     "1F1 regularized", "hypergeometric1 f1 regularized", 
      "hypergeometric function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hypergeometric1F1Regularized[a, b, z] is the regularized confluent \
hypergeometric function \\[Null]_1F_1 (a; b; z)/\\[CapitalGamma](b). ", 
    "synonyms" -> {"hypergeometric 1f1 regularized"}, "title" -> 
    "Hypergeometric1F1Regularized", "type" -> "Symbol", "uri" -> 
    "ref/Hypergeometric1F1Regularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5457, 187, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->282686316]},
 "Ex--21904899473679702393,20"->{
  Cell[14940, 557, 384, 12, 70, "Input",
   CellTags->"Ex--21904899473679702393,20",
   CellID->59593501],
  Cell[15327, 571, 2260, 71, 67, "Output",
   CellTags->"Ex--21904899473679702393,20",
   CellID->578462857]},
 "Ex--21904899473679702393,12"->{
  Cell[18027, 665, 218, 6, 70, "Input",
   CellTags->"Ex--21904899473679702393,12",
   CellID->618818870],
  Cell[18248, 673, 498, 16, 51, "Output",
   CellTags->"Ex--21904899473679702393,12",
   CellID->40344767]},
 "Ex--21904899473679702393,28"->{
  Cell[22545, 827, 523, 15, 70, "Input",
   CellTags->"Ex--21904899473679702393,28",
   CellID->226563175],
  Cell[23071, 844, 1980, 43, 133, "Output",
   CellTags->"Ex--21904899473679702393,28",
   CellID->55667120]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28753, 1011},
 {"Ex--21904899473679702393,20", 28907, 1015},
 {"Ex--21904899473679702393,12", 29159, 1022},
 {"Ex--21904899473679702393,28", 29409, 1029}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1777, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2400, 74, 66, 1, 70, "ObjectName",
 CellID->21948],
Cell[2469, 77, 953, 28, 70, "Usage",
 CellID->4200]
}, Open  ]],
Cell[CellGroupData[{
Cell[3459, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3937, 127, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4060, 133, 565, 21, 70, "Notes",
 CellID->5660],
Cell[4628, 156, 287, 8, 70, "Notes",
 CellID->24675066],
Cell[4918, 166, 258, 7, 70, "Notes",
 CellID->31226],
Cell[5179, 175, 241, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5457, 187, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282686316],
Cell[CellGroupData[{
Cell[5842, 201, 147, 5, 70, "ExampleSection",
 CellID->24062198],
Cell[5992, 208, 64, 1, 70, "ExampleText",
 CellID->214364962],
Cell[CellGroupData[{
Cell[6081, 213, 178, 5, 28, "Input",
 CellID->196634931],
Cell[6262, 220, 176, 5, 36, "Output",
 CellID->176402624]
}, Open  ]],
Cell[6453, 228, 124, 3, 70, "ExampleDelimiter",
 CellID->84256639],
Cell[6580, 233, 74, 1, 70, "ExampleText",
 CellID->147415031],
Cell[CellGroupData[{
Cell[6679, 238, 280, 8, 70, "Input",
 CellID->112124288],
Cell[6962, 248, 1387, 43, 56, "Output",
 CellID->471608]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8398, 297, 216, 7, 70, "ExampleSection",
 CellID->11137],
Cell[8617, 306, 89, 1, 70, "ExampleText",
 CellID->114185134],
Cell[CellGroupData[{
Cell[8731, 311, 207, 6, 70, "Input",
 CellID->753755510],
Cell[8941, 319, 272, 7, 36, "Output",
 CellID->142525120]
}, Open  ]],
Cell[9228, 329, 124, 3, 70, "ExampleDelimiter",
 CellID->53312816],
Cell[9355, 334, 69, 1, 70, "ExampleText",
 CellID->51663803],
Cell[CellGroupData[{
Cell[9449, 339, 212, 6, 70, "Input",
 CellID->198081954],
Cell[9664, 347, 226, 6, 36, "Output",
 CellID->136536662]
}, Open  ]],
Cell[9905, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->288544536],
Cell[10033, 361, 112, 3, 70, "ExampleText",
 CellID->25172087],
Cell[CellGroupData[{
Cell[10170, 368, 185, 5, 70, "Input",
 CellID->177343890],
Cell[10358, 375, 219, 6, 36, "Output",
 CellID->31378482]
}, Open  ]],
Cell[10592, 384, 124, 3, 70, "ExampleDelimiter",
 CellID->16832041],
Cell[10719, 389, 95, 1, 70, "ExampleText",
 CellID->74740598],
Cell[CellGroupData[{
Cell[10839, 394, 157, 4, 70, "Input",
 CellID->153313181],
Cell[10999, 400, 265, 9, 36, "Output",
 CellID->167100795]
}, Open  ]],
Cell[CellGroupData[{
Cell[11301, 414, 181, 5, 70, "Input",
 CellID->420147945],
Cell[11485, 421, 324, 11, 49, "Output",
 CellID->288717184]
}, Open  ]],
Cell[CellGroupData[{
Cell[11846, 437, 180, 5, 70, "Input",
 CellID->66390113],
Cell[12029, 444, 380, 14, 64, "Output",
 CellID->58325665]
}, Open  ]],
Cell[12424, 461, 125, 3, 70, "ExampleDelimiter",
 CellID->981387013],
Cell[12552, 466, 258, 7, 70, "ExampleText",
 CellID->116181103],
Cell[CellGroupData[{
Cell[12835, 477, 281, 9, 70, "Input",
 CellID->336267988],
Cell[13119, 488, 273, 9, 36, "Output",
 CellID->29588730]
}, Open  ]],
Cell[13407, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->760443585],
Cell[13535, 505, 203, 7, 70, "ExampleText",
 CellID->653625731],
Cell[CellGroupData[{
Cell[13763, 516, 198, 6, 70, "Input",
 CellID->35954786],
Cell[13964, 524, 588, 13, 70, "Output",
 Evaluatable->False,
 CellID->36481216]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14601, 543, 239, 7, 70, "ExampleSection",
 CellID->14890],
Cell[14843, 552, 72, 1, 70, "ExampleText",
 CellID->140494624],
Cell[CellGroupData[{
Cell[14940, 557, 384, 12, 70, "Input",
 CellTags->"Ex--21904899473679702393,20",
 CellID->59593501],
Cell[15327, 571, 2260, 71, 67, "Output",
 CellTags->"Ex--21904899473679702393,20",
 CellID->578462857]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17636, 648, 233, 7, 70, "ExampleSection",
 CellID->29801],
Cell[17872, 657, 130, 4, 70, "ExampleText",
 CellID->581883056],
Cell[CellGroupData[{
Cell[18027, 665, 218, 6, 70, "Input",
 CellTags->"Ex--21904899473679702393,12",
 CellID->618818870],
Cell[18248, 673, 498, 16, 51, "Output",
 CellTags->"Ex--21904899473679702393,12",
 CellID->40344767]
}, Open  ]],
Cell[CellGroupData[{
Cell[18783, 694, 181, 5, 70, "Input",
 CellID->199279714],
Cell[18967, 701, 384, 13, 68, "Output",
 CellID->45768819]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19400, 720, 224, 7, 70, "ExampleSection",
 CellID->26830],
Cell[19627, 729, 2893, 94, 70, "ExampleText",
 CellID->5858554],
Cell[CellGroupData[{
Cell[22545, 827, 523, 15, 70, "Input",
 CellTags->"Ex--21904899473679702393,28",
 CellID->226563175],
Cell[23071, 844, 1980, 43, 133, "Output",
 CellTags->"Ex--21904899473679702393,28",
 CellID->55667120]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25112, 894, 310, 9, 70, "SeeAlsoSection",
 CellID->7223],
Cell[25425, 905, 214, 6, 70, "SeeAlso",
 CellID->19629]
}, Open  ]],
Cell[CellGroupData[{
Cell[25676, 916, 313, 9, 70, "TutorialsSection",
 CellID->1273],
Cell[25992, 927, 144, 3, 70, "Tutorials",
 CellID->17723]
}, Open  ]],
Cell[CellGroupData[{
Cell[26173, 935, 320, 9, 70, "RelatedLinksSection",
 CellID->7189],
Cell[26496, 946, 218, 5, 70, "RelatedLinks"],
Cell[26717, 953, 222, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26976, 962, 318, 9, 70, "MoreAboutSection",
 CellID->84599791],
Cell[27297, 973, 158, 3, 70, "MoreAbout",
 CellID->10035177]
}, Open  ]],
Cell[27470, 979, 27, 0, 70, "History"],
Cell[27500, 981, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

