(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     80142,       2693]
NotebookOptionsPosition[     67861,       2274]
NotebookOutlinePosition[     70133,       2336]
CellTagsIndexPosition[     69906,       2328]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AppellF1" :> Documentation`HelpLookup["paclet:ref/AppellF1"], 
          "Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"], 
          "HypergeometricPFQ" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQ"], 
          "Hypergeometric2F1Regularized" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1Regularized"],
           "LegendreP" :> Documentation`HelpLookup["paclet:ref/LegendreP"], 
          "LegendreQ" :> Documentation`HelpLookup["paclet:ref/LegendreQ"], 
          "Pochhammer" :> 
          Documentation`HelpLookup["paclet:ref/Pochhammer"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AppellF1\"\>", 
       2->"\<\"Hypergeometric1F1\"\>", 3->"\<\"HypergeometricPFQ\"\>", 
       4->"\<\"Hypergeometric2F1Regularized\"\>", 5->"\<\"LegendreP\"\>", 
       6->"\<\"LegendreQ\"\>", 7->"\<\"Pochhammer\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Hypergeometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/HypergeometricFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Hypergeometric Functions\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hypergeometric2F1", "ObjectName",
 CellID->27633],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hypergeometric2F1",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hypergeometric2F1"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["c", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
         SubscriptBox["F", "1"]}], "(", 
        RowBox[{"a", ",", "b", ";", "c", ";", "z"}], ")"}], TraditionalForm]],
       "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13505]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "2"], "\[InvisibleSpace]", 
    SubscriptBox["F", "1"]}], TraditionalForm]], "InlineMath"],
 " function has the series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Null]", "2"], "\[InvisibleSpace]", 
     SubscriptBox["F", "1"], "(", 
     RowBox[{"a", ",", "b", ";", "c", ";", "z"}], ")"}], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]",
      LimitsPositioning->True], 
     RowBox[{
      SubscriptBox[
       RowBox[{"(", "a", ")"}], "k"], 
      RowBox[{
       SubscriptBox[
        RowBox[{"(", "b", ")"}], "k"], "/", 
       SubscriptBox[
        RowBox[{"(", "c", ")"}], "k"]}], " ", 
      RowBox[{
       SuperscriptBox["z", "k"], "/", 
       RowBox[{"k", "!"}]}]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27290],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->311581393],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric2F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->15311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29440]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157193836],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->279838],

Cell["Evaluate numerically:", "ExampleText",
 CellID->349219268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{"2.", ",", "3.", ",", "4.", ",", "5."}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170609709],

Cell[BoxData[
 RowBox[{"0.1565421293337547`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.15079644737231013`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479295972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->814197472],

Cell["Evaluate symbolically:", "ExampleText",
 CellID->175509744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{"2", ",", "3", ",", "4", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96394689],

Cell[BoxData[
 RowBox[{"3", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], "-", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "x"}], "-", 
      SuperscriptBox["x", "2"], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "x"}], "]"}]}]}], 
     SuperscriptBox["x", "3"]]}], ")"}]}]], "Output",
 ImageSize->{210, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199208196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26345621],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   TagBox[
    TagBox[
     RowBox[{
      RowBox[{
       SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
       SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
      RowBox[{"(", 
       RowBox[{
        TagBox[
         TagBox[
          RowBox[{
           TagBox[
            FractionBox["1", "3"],
            Hypergeometric2F1,
            Editable->True], ",", 
           TagBox[
            FractionBox["1", "3"],
            Hypergeometric2F1,
            Editable->True]}],
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         Hypergeometric2F1,
         Editable->False], ";", 
        TagBox[
         TagBox[
          TagBox[
           FractionBox["2", "3"],
           Hypergeometric2F1,
           Editable->True],
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         Hypergeometric2F1,
         Editable->False], ";", 
        TagBox["x",
         Hypergeometric2F1,
         Editable->True]}], ")"}]}],
     InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
     Editable->False],
    Hypergeometric2F1], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->378909423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"2", "/", "3"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14156798],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71042666]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450255730],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " in a Taylor series at the origin:"
}], "ExampleText",
 CellID->204418235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71742114],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWsluE0EQbXtmEidWHIssOAkIRzkhIbFFSKy5wQXEL2CFgHNAQcESHBBH
foQ/QHD2HfgEwi/4E5rpDbff1Ez3jMfjiEj2TFVX1/J6qa52nvUG/aM3vcHx
Ya/75LT3tn98+K77+OQ0ZgU1xmo/GGN7HRa/8/hNfsTfz/ijXtXbB/EdmFbO
toH+5GhvAr0DdF9aeQ/cS0B/dLQvAX0Z6NfSym78LZgP4mcUPxc03QDputVu
8418BPwjzV906FsEfpSiD+XS+qf580pG25Um/nElj7H7JDciuWgvJOxjPEkt
2OtliR6Q7U4PKHzdtv2is7C3uI8cyOH8Ra2CjoiRRj0Z2OawFmlrrvFGhAJC
3sdrGrMDCv8cUZCzc+bY5V0zeWd4DiwTseAspFfL7FZ9aPbUOa1zF3Z5Vviu
jueA8Cz0iGhVy5G7o0U3ptRH5QybbqX0U1G+IBG5ALK47jcpXRa9lrP/EukF
9toAWuX8Hlc5cl2CZuuox8RF6NPX0mte0s2EVJCiUxFftZ6mfi5PtGSdmhoq
5kCHLl5Z8nxyFejPQP8GeuL8kIi2rp84M5Qv1F4/jS9+a68+6SmxP9Pemfyp
vBwOhxrFjoQyprVckCI3kHLtdns0Gtn6IpD7laLPL7pAI45YzhPx8+hT0Vkg
vr6kW5hyBTi0Z6xuoSnQ9sZWn4IUVk6432HldcvR31WZufS7+u/x8e5i73o4
R2oy6ufAxQoOcwZWgDcc/V0Voku/q/9DrvKoGkORAyK9YUcWBmZs1zldYWZV
ekYfta/5VrBpdUQI/m2V5F+eSrZIfFQFQsXn64cvPvbaYsZvdW7xrGwh5+o5
Mf3J2G8HrbLeT0a6VWGks6z1/5c7i+QI7XM1z/PP6wXdc6MQNubmYZb4h7ls
mHi2K4gn133KjNCZuPup2GOD9R3gqxOCyKmhc95tcr96mcpAVB1c5U5pYtgp
OYb5YlHOfldONjAI3+PZ+5rJ9Ym5PdeMTXlFnVRcM5HSQ+o9N1m7nJu7ohhS
MfpgWCSKYmNzVz7EDhnovdC0M4Zz2tQfQhLP1Rh5m9O/MEUJCy5NLdKnrDN2
nY9v7qbx1ecGtKoYXb6sFEJJPPdljy5IXwMa8zPeVaI/y47+LQozjMei0T+X
P8VufsuOws8LjBW1rAJ9U+q5wtX4XecTa1pzO0Rkgr9CSq9y+oYFLXe9bPnd
bhfziNbt67+svtl34P4h8f1mccWonQF9m9R1RloUr+q/IljtL+1v238=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264075117]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22490],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->755617038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    RowBox[{"2", "+", "I"}], ",", 
    RowBox[{"-", "I"}], ",", 
    RowBox[{"3", "/", "4"}], ",", 
    RowBox[{"0.5", "\[InvisibleSpace]", "-", 
     RowBox[{"0.5", " ", "\[ImaginaryI]"}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121031799],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.9721665713619077608953489289`16.09765210351231"}], "-", 
  RowBox[{
  "0.18165874147573057850735267493`15.369167721129811", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{288, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->515593860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->459253573],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->111101545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}], ",", "2", ",", "1"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4248960],

Cell[BoxData["1.\
159595266963928365769992051570020881945165263439782855263105059748`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15992725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->972200558],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->359051032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "3"}], ",", "2", ",", 
   "1.000000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135957655],

Cell[BoxData["1.159595266963928365769992051570020881945177521922`32.\
5097427310824"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120418143]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5879879],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " automatically evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellID->472444214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   FractionBox["3", "2"], ",", "2", ",", "3", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389329184],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"1", "-", "x"}]]}], "+", "x"}], ")"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{"1", "-", "x"}]], " ", 
    SuperscriptBox["x", "2"]}]]}]], "Output",
 ImageSize->{141, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48513959]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", "1", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699072983],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"EllipticK", "[", "z", "]"}]}], "\[Pi]"]], "Output",
 ImageSize->{103, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240034172]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{"1", ",", 
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"3", "/", "2"}], ",", 
   RowBox[{"y", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->902131819],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", "y", "]"}], "y"]], "Output",
 ImageSize->{79, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82598970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->575295318],

Cell["\<\
Hypergeometric series terminates if either of the first two parameters is a \
negative integer:\
\>", "ExampleText",
 CellID->129985734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "3", ",", "2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176045820],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "-", 
    RowBox[{"5", " ", "x"}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "x"}], ")"}], "2"]}]], "Output",
 ImageSize->{118, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495760106]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348926430],

Cell[TextData[{
 "Exact value of ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " at unity:"
}], "ExampleText",
 CellID->106196667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{"n", ",", "m", ",", 
   RowBox[{"n", "+", "m", "+", "2"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118598064],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"2", "+", "m", "+", "n"}], "]"}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"2", "+", "m"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"2", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{163, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58495697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161143876],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->115799106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Range", "[", "3", "]"}]}], ",", "3", ",", "4", ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92031947],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "8"], ",", 
   FractionBox["2", "5"], ",", 
   FractionBox["21", "80"]}], "}"}]], "Output",
 ImageSize->{81, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->658020460]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97049323],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->244873998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4383734],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVNsOgjAMHRsIqNFX9YmPIfrkRxBjog9Go/z/7C6wcTqjiSRjbSmnp2eF
Y9dfzreuv5665vDsHpfr6dXs708KqUwI0dJabwTZmiy7Wq1pz8msyVK0FyZi
DG0vkYO/AL8CvwRf2goOxgbpPoccBf7sz5qZLSOxCpmIjDlSBK4uKv1b0j+I
dxXtVkSP4iJGcsPEseE5SaWKOGNgVLN3q3REjRJ/YhDwfV5SkQkyalQmcbAb
PGPJ+HDFYv44d5wXTk35VeEfOKnx7C2D3Pc/nDrvO6WOFAFpZBb1VuswN9P6
vAecdVNPwUw4vshkmFL2HQwMi5Fh3AtTrQZ/Bf6OdVEllUJcxNmAHxSZJXRY
+i62CX3oV8fuInsDvV6FTg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->443547822]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14668],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " in a series around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->4087012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"2", "/", "3"}], ",", "z"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->878886557],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", "\[Pi]", " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        FractionBox["1", "3"], "]"}], "2"]}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", "/", "3"}]], " ", "EulerGamma", " ", "\[Pi]", " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "6"}]], " ", 
        SqrtBox["3"], " ", "\[Pi]", " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["1", "3"], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          FractionBox["2", "3"], "]"}], "2"]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", "/", "3"}]], " ", 
        SqrtBox["3"], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["1", "3"], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          FractionBox["2", "3"], "]"}], "2"], " ", 
        RowBox[{"Log", "[", 
         FractionBox["1", "z"], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"2", "/", "3"}]], " ", "\[Pi]", " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}], " ", 
        RowBox[{"PolyGamma", "[", 
         RowBox[{"0", ",", 
          FractionBox["1", "3"]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "z"], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "z"], "]"}], 
     RowBox[{"4", "/", "3"}]],
    SeriesData[$CellContext`z, 
     DirectedInfinity[1], {}, 1, 4, 3],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   DirectedInfinity[1], {Rational[1, 2] Pi^(-1) Gamma[
       Rational[1, 3]]^(-2) (4 (-1)^Rational[2, 3] EulerGamma Pi Gamma[
        Rational[2, 3]] + (-1)^Rational[1, 6] 3^Rational[1, 2] Pi Gamma[
        Rational[1, 3]] Gamma[
         Rational[2, 3]]^2 + (-1)^Rational[2, 3] 3^Rational[1, 2] Gamma[
        Rational[1, 3]] Gamma[
         Rational[2, 3]]^2 Log[$CellContext`z^(-1)] + 
     4 (-1)^Rational[2, 3] Pi Gamma[
        Rational[2, 3]] PolyGamma[0, 
        Rational[1, 3]])}, 1, 4, 3],
  Editable->False]], "Output",
 ImageSize->{585, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->694207200]
}, Open  ]],

Cell[TextData[{
 "Give the result for an arbitrary symbolic direction ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1167062814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", "1", ",", 
     RowBox[{"4", "/", "3"}], ",", " ", "x"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"DirectedInfinity", "[", "z", "]"}], ",", " ", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1032303067],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["2", "3"]}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"Floor", "[", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{"Arg", "[", "z", "]"}], 
           RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}], "-", 
       RowBox[{
        FractionBox["2", "3"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"Floor", "[", 
         FractionBox[
          RowBox[{"\[Pi]", "+", 
           RowBox[{"Arg", "[", "z", "]"}]}], 
          RowBox[{"2", " ", "\[Pi]"}]], "]"}]}]}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["4", "3"], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "x"], ")"}], 
      RowBox[{"1", "/", "3"}]]}]}], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"Gamma", "[", 
      RowBox[{"-", 
       FractionBox["2", "3"]}], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["4", "3"], "]"}]}], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       FractionBox["1", "3"], "]"}], "2"], " ", "x"}]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Gamma", "[", 
        RowBox[{"-", 
         FractionBox["2", "3"]}], "]"}], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["4", "3"], "]"}]}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "x"], ")"}], "2"]}], 
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       FractionBox["1", "3"], "]"}], "2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], 
     RowBox[{"7", "/", "3"}]],
    SeriesData[$CellContext`x, 
     DirectedInfinity[$CellContext`z], {}, 1, 7, 3],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[$CellContext`z], {-(-1)^Rational[2, 3] E^(Complex[0, 
         Rational[-2, 3]] Pi 
       Floor[Rational[-1, 2] Pi^(-1) Arg[$CellContext`z]] + Complex[0, 
         Rational[-2, 3]] Pi 
       Floor[Rational[1, 2] Pi^(-1) (Pi + Arg[$CellContext`z])]) Gamma[
      Rational[2, 3]] Gamma[
      Rational[4, 3]], 0, -Gamma[
      Rational[-2, 3]] Gamma[
       Rational[1, 3]]^(-2) Gamma[
      Rational[4, 3]], 0, 0, Rational[-2, 5] Gamma[
      Rational[-2, 3]] Gamma[
       Rational[1, 3]]^(-2) Gamma[
      Rational[4, 3]]}, 1, 7, 3],
  Editable->False]], "Output",
 ImageSize->{459, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53996120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->678708959],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " in a series near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "=", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->318674140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", " ", 
     RowBox[{"1", "/", "3"}], ",", " ", 
     RowBox[{"2", "/", "3"}], ",", " ", "z"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79875419],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Floor", "[", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Arg", "[", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], "]"}], 
      RowBox[{"2", " ", "\[Pi]"}]]}], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
         RowBox[{"Gamma", "[", 
          FractionBox["2", "3"], "]"}]}], 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          FractionBox["1", "3"], "]"}], "2"]]}], "+", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{"z", "-", "1"}], ")"}]}], 
       RowBox[{"9", " ", 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          FractionBox["1", "3"], "]"}], "2"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         RowBox[{"z", "-", "1"}], "]"}], "2"],
       SeriesData[$CellContext`z, 1, {}, 0, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`z, 1, {Complex[0, -2] Pi Gamma[
          Rational[1, 3]]^(-2) Gamma[
         Rational[2, 3]], Complex[0, 
         Rational[2, 9]] Pi Gamma[
          Rational[1, 3]]^(-2) Gamma[
         Rational[2, 3]]}, 0, 2, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "EulerGamma"}], "+", 
          RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
          RowBox[{"Log", "[", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "z"}], "]"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"PolyGamma", "[", 
            RowBox[{"0", ",", 
             FractionBox["1", "3"]}], "]"}]}]}], ")"}]}], 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         FractionBox["1", "3"], "]"}], "2"]]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"Gamma", "[", 
        FractionBox["2", "3"], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         RowBox[{"2", " ", "EulerGamma"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
         RowBox[{"Log", "[", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "z"}], "]"}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"PolyGamma", "[", 
           RowBox[{"0", ",", 
            FractionBox["4", "3"]}], "]"}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]}], 
      RowBox[{"9", " ", 
       SuperscriptBox[
        RowBox[{"Gamma", "[", 
         FractionBox["1", "3"], "]"}], "2"]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "2"],
      SeriesData[$CellContext`z, 1, {}, 0, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 1, {-Gamma[
         Rational[1, 3]]^(-2) Gamma[
        Rational[2, 3]] (2 EulerGamma + Complex[0, 1] Pi + 
       Log[-1 + $CellContext`z] + 2 PolyGamma[0, 
          Rational[1, 3]]), Rational[1, 9] Gamma[
         Rational[1, 3]]^(-2) Gamma[
        Rational[2, 3]] (-2 + 2 EulerGamma + Complex[0, 1] Pi + 
       Log[-1 + $CellContext`z] + 2 PolyGamma[0, 
          Rational[4, 3]])}, 0, 2, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{571, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309993046]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23386],

Cell[TextData[{
 "Force acting on an electric point charge ",
 Cell[BoxData["q"], "InlineFormula"],
 " outside a neutral dielectric sphere of radius ",
 Cell[BoxData["R"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1147192],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   SuperscriptBox["q", "2"], " ", 
   RowBox[{"\[Epsilon]", "/", 
    RowBox[{"(", 
     RowBox[{"3", "+", "\[Epsilon]"}], ")"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"R", "/", "r"}], ")"}], "^", "3"}], "/", 
    RowBox[{"r", "^", "2"}]}], " ", 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"3", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Epsilon]", "+", "3"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"\[Epsilon]", "+", "2"}], ")"}]}], ",", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"\[Epsilon]", "+", "3"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"\[Epsilon]", "+", "2"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"R", "/", "r"}], ")"}], "^", "2"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->307900149],

Cell["\<\
The limit of infinite dielectric constant, corresponding to an uncharged \
insulated conducting sphere:\
\>", "ExampleText",
 CellID->331116178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\[Epsilon]", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->611056078],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["q", "2"], " ", 
   SuperscriptBox["R", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["r", "2"]}], "+", 
     SuperscriptBox["R", "2"]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["r", "3"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["r", "2"], "-", 
      SuperscriptBox["R", "2"]}], ")"}], "2"]}]]], "Output",
 ImageSize->{109, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76271088]
}, Open  ]],

Cell["Force at large distance from the sphere:", "ExampleText",
 CellID->942843691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%%", ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "\[Infinity]", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->313889026],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["q", "2"], " ", 
        SuperscriptBox["R", "3"], " ", "\[Epsilon]"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "r"], ")"}], "5"]}], 
     RowBox[{"3", "+", "\[Epsilon]"}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "r"], "]"}], "6"],
    SeriesData[$CellContext`r, 
     DirectedInfinity[1], {}, 5, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`r, 
   DirectedInfinity[
   1], {(-2) $CellContext`q^2 $CellContext`R^3 $CellContext`\[Epsilon]/(
    3 + $CellContext`\[Epsilon])}, 5, 6, 1],
  Editable->False]], "Output",
 ImageSize->{161, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->105328359]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12610],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " into other functions:"
}], "ExampleText",
 CellID->445606485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{"2", ",", "b", ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "-", "b"}], ")"}], "/", "2"}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "/", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60834464],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "-", "b"}], "3"]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401900301]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{"a", ",", 
    RowBox[{"a", "+", 
     RowBox[{"1", "/", "2"}]}], ",", 
    RowBox[{"2", "a"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236731564],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "a"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "-", "z"}]]}], ")"}], 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "a"}]}]]}], 
  SqrtBox[
   RowBox[{"1", "-", "z"}]]]], "Output",
 ImageSize->{146, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->612483404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->513946009],

Cell[TextData[{
 "Find limits of ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " from below and above the branch cut:"
}], "ExampleText",
 CellID->706458058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"3", "/", "2"}], ",", "x"}], "]"}], ",", 
   RowBox[{"x", "->", "2"}], ",", 
   RowBox[{"Direction", "->", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521748077],

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "3"], ",", 
   FractionBox["3", "2"], ",", "2"}], "]"}]], "Output",
 ImageSize->{211, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148016261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"3", "/", "2"}], ",", "x"}], "]"}], ",", 
   RowBox[{"x", "->", "2"}], ",", 
   RowBox[{"Direction", "->", 
    RowBox[{"-", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9480374],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"3", "/", "2"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["5", "6"], "]"}]}], "+", 
    RowBox[{
     SqrtBox["2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["3"]}]}], ")"}], " ", "\[Pi]", " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["1", "3"], "]"}], " ", 
     RowBox[{"Hypergeometric2F1", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "6"]}], ",", 
       FractionBox["1", "2"], ",", 
       FractionBox["5", "6"], ",", 
       RowBox[{"-", "1"}]}], "]"}]}], "+", 
    RowBox[{"4", " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["1", "3"], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["5", "6"], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["7", "6"], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{
          FractionBox["1", "3"], ",", 
          FractionBox["1", "2"], ",", 
          FractionBox["3", "2"], ",", "2"}], "]"}]}], "+", 
       RowBox[{"Hypergeometric2F1", "[", 
        RowBox[{
         FractionBox["1", "2"], ",", 
         FractionBox["1", "3"], ",", 
         FractionBox["3", "2"], ",", "2"}], "]"}]}], ")"}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"4", " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["1", "3"], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["5", "6"], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["7", "6"], "]"}]}], ")"}]}]], "Output",
 ImageSize->{569, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136907617]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21649],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " implicitly assumes variables to be generic complex numbers:"
}], "ExampleText",
 CellID->43441246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{
   RowBox[{"-", "n"}], ",", 
   RowBox[{"-", "n"}], ",", 
   RowBox[{
    RowBox[{"-", "2"}], "n"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398959497],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25192498]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData["n"], "InlineFormula"],
 " is a positive integer, the above reduces to a polynomial, yielding a \
finite result:"
}], "ExampleText",
 CellID->746028752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{"-", "n"}], ",", 
     RowBox[{"-", "n"}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], "n"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98847882],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["1", "2"], ",", 
   FractionBox["1", "6"], ",", 
   FractionBox["1", "20"], ",", 
   FractionBox["1", "70"], ",", 
   FractionBox["1", "252"], ",", 
   FractionBox["1", "924"], ",", 
   FractionBox["1", "3432"], ",", 
   FractionBox["1", "12870"], ",", 
   FractionBox["1", "48620"], ",", 
   FractionBox["1", "184756"]}], "}"}]], "Output",
 ImageSize->{409, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->162095322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44765271],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric2F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HypergeometricPFQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricPFQ"], "[", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", "x"}], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "==", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103592101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{"1", ",", "a", ",", "a", ",", "x"}], "]"}], ",", " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "}"}], ",", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434003154],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ",", 
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]]}], "}"}]], "Output",
 ImageSize->{91, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->526898190]
}, Open  ]],

Cell[TextData[{
 "However, if ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "==", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 " is a negative integer, ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " returns a polynomial:"
}], "ExampleText",
 CellID->763873723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{"1", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112037677],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73580537]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10813],

Cell[TextData[{
 "The discrete Kepler problem ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[CapitalPsi]", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "-", 
     RowBox[{"2", 
      RowBox[{"\[CapitalPsi]", "[", "n", "]"}]}], "+", 
     RowBox[{"\[CapitalPsi]", "[", 
      RowBox[{"n", "-", "1"}], "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[ScriptCapitalE]", "-", 
        RowBox[{"q", "/", "n"}]}], ")"}], 
      RowBox[{"\[CapitalPsi]", "[", "n", "]"}]}]}], "==", "0"}], 
   TraditionalForm]], "InlineMath"],
 " with initial conditions ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPsi]", "[", "0", "]"}], "==", "0"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[CapitalPsi]", "[", "1", "]"}], "==", "1"}], TraditionalForm]], 
  "InlineMath"],
 " can be solved as a hypergeometric function:"
}], "ExampleText",
 CellID->330440511],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[CapitalPsi]", "[", 
   RowBox[{"n_", ",", 
    RowBox[{"{", 
     RowBox[{"k_", ",", "q_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", "k"}], " ", 
     RowBox[{"(", 
      RowBox[{"n", "-", "1"}], ")"}]}], "]"}], 
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "n"}], "+", "1"}], ",", 
     RowBox[{"1", "+", 
      RowBox[{"q", "/", 
       RowBox[{"(", 
        RowBox[{"2", " ", 
         RowBox[{"Sinh", "[", "k", "]"}]}], ")"}]}]}], ",", "2", ",", 
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"2", "  ", "k"}], "]"}]}]}], "]"}]}]}]], "Input",
 CellTags->"Ex--21904899473679702393,25",
 CellLabel->"In[1]:=",
 CellID->353787913],

Cell[TextData[{
 "The energy ",
 Cell[BoxData[
  StyleBox["\[ScriptCapitalE]", "TR"]], "InlineFormula"],
 " depends on ",
 Cell[BoxData["k"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->208738090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPsi]", "[", 
           RowBox[{
            RowBox[{"n", "+", "1"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "q"}], "}"}]}], "]"}], "+", 
          RowBox[{"\[CapitalPsi]", "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "q"}], "}"}]}], "]"}]}], ")"}], "/", 
        RowBox[{"\[CapitalPsi]", "[", 
         RowBox[{"n", ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "q"}], "}"}]}], "]"}]}], "+", 
       RowBox[{"(", 
        RowBox[{"\[ScriptCapitalE]", "-", "2", "-", 
         FractionBox["q", "n"]}], ")"}]}], "==", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "//", "FullSimplify"}], " ", "//",
   "Union"}]], "Input",
 CellTags->"Ex--21904899473679702393,26",
 CellLabel->"In[2]:=",
 CellID->564995280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[ScriptCapitalE]", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cosh", "[", "k", "]"}]}]}], "\[Equal]", "2"}], "}"}]], "Output",\

 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904899473679702393,26",
 CellLabel->"Out[2]=",
 CellID->118187719]
}, Open  ]],

Cell[TextData[{
 "Finite norm states exist for an attractive potential ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "<", "0"}], TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "==", 
    RowBox[{"ArcCsch", "[", 
     RowBox[{
      RowBox[{"-", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "+", "1"}], ")"}], "/", "q"}]}], "]"}]}], 
   TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Element]", "\[DoubleStruckCapitalR]"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->100374123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"\[CapitalPsi]", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"ArcCsch", "[", 
              RowBox[{"2", 
               RowBox[{"(", 
                RowBox[{"m", "+", "1"}], ")"}]}], "]"}], ",", 
             RowBox[{"-", "1."}]}], "}"}]}], "]"}], "&"}], "/@", 
        RowBox[{"Range", "[", 
         RowBox[{"30", 
          RowBox[{"(", 
           RowBox[{"m", "+", "1"}], ")"}]}], "]"}]}], "]"}], " ", ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", "1", ",", "3", ",", 
        RowBox[{"2", "/", "5"}]}], "}"}]}], "]"}], ",", "3"}], "]"}], "//", 
  "Grid"}]], "Input",
 CellTags->"Ex--21904899473679702393,27",
 CellLabel->"In[3]:=",
 CellID->1728804619],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{556, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21904899473679702393,27",
 CellLabel->"Out[3]=",
 CellID->890964781]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20848],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppellF1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppellF1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric1F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricPFQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricPFQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric2F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1Regularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendreQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pochhammer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pochhammer"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30226]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20017],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->30402]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->22869],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/HypergeometricFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/\
Hypergeometric2F1/"], None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Hypergeometric2F1"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->204843276],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->421346457],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->203675681],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->568364130],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->3415877]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypergeometric2F1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 56.8666678}", "context" -> "System`", 
    "keywords" -> {
     "2F1", "Gauss hypergeometric function", "Gauss series", 
      "hypergeometric 2F1", "hypergeometric functions", "Kummer series", 
      "Riemann P function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hypergeometric2F1[a, b, c, z] is the hypergeometric function \
\\[InvisiblePrefixScriptBase]_2 F_1 (a, b; c; z). ", 
    "synonyms" -> {"hypergeometric 2f1"}, "title" -> "Hypergeometric2F1", 
    "type" -> "Symbol", "uri" -> "ref/Hypergeometric2F1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8077, 261, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->157193836]},
 "Ex--21904899473679702393,25"->{
  Cell[51135, 1813, 786, 26, 70, "Input",
   CellTags->"Ex--21904899473679702393,25",
   CellID->353787913]},
 "Ex--21904899473679702393,26"->{
  Cell[52152, 1853, 1044, 32, 70, "Input",
   CellTags->"Ex--21904899473679702393,26",
   CellID->564995280],
  Cell[53199, 1887, 354, 12, 36, "Output",
   CellTags->"Ex--21904899473679702393,26",
   CellID->118187719]},
 "Ex--21904899473679702393,27"->{
  Cell[54197, 1929, 911, 28, 70, "Input",
   CellTags->"Ex--21904899473679702393,27",
   CellID->1728804619],
  Cell[55111, 1959, 7859, 133, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21904899473679702393,27",
   CellID->890964781]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 69084, 2302},
 {"Ex--21904899473679702393,25", 69238, 2306},
 {"Ex--21904899473679702393,26", 69382, 2310},
 {"Ex--21904899473679702393,27", 69637, 2317}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3026, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3649, 94, 55, 1, 70, "ObjectName",
 CellID->27633],
Cell[3707, 97, 896, 28, 70, "Usage",
 CellID->13505]
}, Open  ]],
Cell[CellGroupData[{
Cell[4640, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5118, 147, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5241, 153, 935, 32, 70, "Notes",
 CellID->27290],
Cell[6179, 187, 266, 8, 70, "Notes",
 CellID->311581393],
Cell[6448, 197, 236, 7, 70, "Notes",
 CellID->31226],
Cell[6687, 206, 219, 7, 70, "Notes",
 CellID->28162],
Cell[6909, 215, 634, 22, 70, "Notes",
 CellID->15311],
Cell[7546, 239, 494, 17, 70, "Notes",
 CellID->29440]
}, Closed]],
Cell[CellGroupData[{
Cell[8077, 261, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157193836],
Cell[CellGroupData[{
Cell[8462, 275, 145, 5, 70, "ExampleSection",
 CellID->279838],
Cell[8610, 282, 64, 1, 70, "ExampleText",
 CellID->349219268],
Cell[CellGroupData[{
Cell[8699, 287, 160, 4, 28, "Input",
 CellID->170609709],
Cell[8862, 293, 274, 7, 36, "Output",
 CellID->479295972]
}, Open  ]],
Cell[9151, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->814197472],
Cell[9279, 308, 65, 1, 70, "ExampleText",
 CellID->175509744],
Cell[CellGroupData[{
Cell[9369, 313, 155, 4, 70, "Input",
 CellID->96394689],
Cell[9527, 319, 532, 19, 55, "Output",
 CellID->199208196]
}, Open  ]],
Cell[10074, 341, 124, 3, 70, "ExampleDelimiter",
 CellID->26345621],
Cell[10201, 346, 1206, 45, 70, "ExampleText",
 CellID->378909423],
Cell[CellGroupData[{
Cell[11432, 395, 370, 12, 28, "Input",
 CellID->14156798],
Cell[11805, 409, 2367, 43, 141, "Output",
 Evaluatable->False,
 CellID->71042666]
}, Open  ]],
Cell[14187, 455, 125, 3, 70, "ExampleDelimiter",
 CellID->450255730],
Cell[14315, 460, 241, 8, 70, "ExampleText",
 CellID->204418235],
Cell[CellGroupData[{
Cell[14581, 472, 273, 8, 28, "Input",
 CellID->71742114],
Cell[14857, 482, 1488, 28, 56, "Output",
 Evaluatable->False,
 CellID->264075117]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16394, 516, 216, 7, 70, "ExampleSection",
 CellID->22490],
Cell[16613, 525, 74, 1, 70, "ExampleText",
 CellID->755617038],
Cell[CellGroupData[{
Cell[16712, 530, 333, 10, 70, "Input",
 CellID->121031799],
Cell[17048, 542, 337, 10, 36, "Output",
 CellID->515593860]
}, Open  ]],
Cell[17400, 555, 125, 3, 70, "ExampleDelimiter",
 CellID->459253573],
Cell[17528, 560, 70, 1, 70, "ExampleText",
 CellID->111101545],
Cell[CellGroupData[{
Cell[17623, 565, 264, 9, 70, "Input",
 CellID->4248960],
Cell[17890, 576, 233, 7, 36, "Output",
 CellID->15992725]
}, Open  ]],
Cell[18138, 586, 125, 3, 70, "ExampleDelimiter",
 CellID->972200558],
Cell[18266, 591, 113, 3, 70, "ExampleText",
 CellID->359051032],
Cell[CellGroupData[{
Cell[18404, 598, 242, 7, 70, "Input",
 CellID->135957655],
Cell[18649, 607, 227, 6, 36, "Output",
 CellID->120418143]
}, Open  ]],
Cell[18891, 616, 123, 3, 70, "ExampleDelimiter",
 CellID->5879879],
Cell[19017, 621, 264, 7, 70, "ExampleText",
 CellID->472444214],
Cell[CellGroupData[{
Cell[19306, 632, 178, 5, 70, "Input",
 CellID->389329184],
Cell[19487, 639, 466, 18, 64, "Output",
 CellID->48513959]
}, Open  ]],
Cell[CellGroupData[{
Cell[19990, 662, 204, 6, 70, "Input",
 CellID->699072983],
Cell[20197, 670, 243, 8, 51, "Output",
 CellID->240034172]
}, Open  ]],
Cell[CellGroupData[{
Cell[20477, 683, 228, 7, 70, "Input",
 CellID->902131819],
Cell[20708, 692, 211, 7, 53, "Output",
 CellID->82598970]
}, Open  ]],
Cell[20934, 702, 125, 3, 70, "ExampleDelimiter",
 CellID->575295318],
Cell[21062, 707, 146, 4, 70, "ExampleText",
 CellID->129985734],
Cell[CellGroupData[{
Cell[21233, 715, 175, 5, 70, "Input",
 CellID->176045820],
Cell[21411, 722, 357, 13, 51, "Output",
 CellID->495760106]
}, Open  ]],
Cell[21783, 738, 125, 3, 70, "ExampleDelimiter",
 CellID->348926430],
Cell[21911, 743, 225, 8, 70, "ExampleText",
 CellID->106196667],
Cell[CellGroupData[{
Cell[22161, 755, 190, 5, 70, "Input",
 CellID->118598064],
Cell[22354, 762, 383, 13, 53, "Output",
 CellID->58495697]
}, Open  ]],
Cell[22752, 778, 125, 3, 70, "ExampleDelimiter",
 CellID->161143876],
Cell[22880, 783, 228, 7, 70, "ExampleText",
 CellID->115799106],
Cell[CellGroupData[{
Cell[23133, 794, 232, 7, 70, "Input",
 CellID->92031947],
Cell[23368, 803, 281, 10, 51, "Output",
 CellID->658020460]
}, Open  ]],
Cell[23664, 816, 124, 3, 70, "ExampleDelimiter",
 CellID->97049323],
Cell[23791, 821, 203, 7, 70, "ExampleText",
 CellID->244873998],
Cell[CellGroupData[{
Cell[24019, 832, 196, 6, 70, "Input",
 CellID->4383734],
Cell[24218, 840, 618, 14, 70, "Output",
 Evaluatable->False,
 CellID->443547822]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24885, 860, 239, 7, 70, "ExampleSection",
 CellID->14668],
Cell[25127, 869, 329, 12, 70, "ExampleText",
 CellID->4087012],
Cell[CellGroupData[{
Cell[25481, 885, 364, 11, 70, "Input",
 CellID->878886557],
Cell[25848, 898, 2736, 81, 123, "Output",
 CellID->694207200]
}, Open  ]],
Cell[28599, 982, 181, 6, 70, "ExampleText",
 CellID->1167062814],
Cell[CellGroupData[{
Cell[28805, 992, 396, 12, 70, "Input",
 CellID->1032303067],
Cell[29204, 1006, 2848, 88, 103, "Output",
 CellID->53996120]
}, Open  ]],
Cell[32067, 1097, 125, 3, 70, "ExampleDelimiter",
 CellID->678708959],
Cell[32195, 1102, 319, 12, 70, "ExampleText",
 CellID->318674140],
Cell[CellGroupData[{
Cell[32539, 1118, 381, 11, 70, "Input",
 CellID->79875419],
Cell[32923, 1131, 3669, 108, 167, "Output",
 CellID->309993046]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36641, 1245, 223, 7, 70, "ExampleSection",
 CellID->23386],
Cell[36867, 1254, 231, 7, 70, "ExampleText",
 CellID->1147192],
Cell[37101, 1263, 911, 31, 70, "Input",
 CellID->307900149],
Cell[38015, 1296, 154, 4, 70, "ExampleText",
 CellID->331116178],
Cell[CellGroupData[{
Cell[38194, 1304, 168, 5, 70, "Input",
 CellID->611056078],
Cell[38365, 1311, 593, 22, 63, "Output",
 CellID->76271088]
}, Open  ]],
Cell[38973, 1336, 83, 1, 70, "ExampleText",
 CellID->942843691],
Cell[CellGroupData[{
Cell[39081, 1341, 195, 6, 70, "Input",
 CellID->313889026],
Cell[39279, 1349, 919, 30, 60, "Output",
 CellID->105328359]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40247, 1385, 233, 7, 70, "ExampleSection",
 CellID->12610],
Cell[40483, 1394, 373, 13, 70, "ExampleText",
 CellID->445606485],
Cell[CellGroupData[{
Cell[40881, 1411, 321, 10, 70, "Input",
 CellID->60834464],
Cell[41205, 1423, 201, 7, 51, "Output",
 CellID->401900301]
}, Open  ]],
Cell[CellGroupData[{
Cell[41443, 1435, 269, 8, 70, "Input",
 CellID->236731564],
Cell[41715, 1445, 506, 20, 65, "Output",
 CellID->612483404]
}, Open  ]],
Cell[42236, 1468, 125, 3, 70, "ExampleDelimiter",
 CellID->513946009],
Cell[42364, 1473, 252, 8, 70, "ExampleText",
 CellID->706458058],
Cell[CellGroupData[{
Cell[42641, 1485, 360, 11, 70, "Input",
 CellID->521748077],
Cell[43004, 1498, 311, 10, 51, "Output",
 CellID->148016261]
}, Open  ]],
Cell[CellGroupData[{
Cell[43352, 1513, 378, 12, 70, "Input",
 CellID->9480374],
Cell[43733, 1527, 1845, 58, 141, "Output",
 CellID->136907617]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45627, 1591, 226, 7, 70, "ExampleSection",
 CellID->21649],
Cell[45856, 1600, 166, 5, 70, "ExampleText",
 CellID->43441246],
Cell[CellGroupData[{
Cell[46047, 1609, 233, 8, 70, "Input",
 CellID->398959497],
Cell[46283, 1619, 167, 5, 36, "Output",
 CellID->25192498]
}, Open  ]],
Cell[46465, 1627, 192, 6, 70, "ExampleText",
 CellID->746028752],
Cell[CellGroupData[{
Cell[46682, 1637, 358, 12, 70, "Input",
 CellID->98847882],
Cell[47043, 1651, 536, 17, 51, "Output",
 CellID->162095322]
}, Open  ]],
Cell[47594, 1671, 124, 3, 70, "ExampleDelimiter",
 CellID->44765271],
Cell[47721, 1676, 707, 26, 70, "ExampleText",
 CellID->103592101],
Cell[CellGroupData[{
Cell[48453, 1706, 337, 10, 70, "Input",
 CellID->434003154],
Cell[48793, 1718, 297, 11, 51, "Output",
 CellID->526898190]
}, Open  ]],
Cell[49105, 1732, 365, 13, 70, "ExampleText",
 CellID->763873723],
Cell[CellGroupData[{
Cell[49495, 1749, 194, 6, 70, "Input",
 CellID->112037677],
Cell[49692, 1757, 213, 7, 36, "Output",
 CellID->73580537]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49954, 1770, 224, 7, 70, "ExampleSection",
 CellID->10813],
Cell[50181, 1779, 951, 32, 70, "ExampleText",
 CellID->330440511],
Cell[51135, 1813, 786, 26, 70, "Input",
 CellTags->"Ex--21904899473679702393,25",
 CellID->353787913],
Cell[51924, 1841, 203, 8, 70, "ExampleText",
 CellID->208738090],
Cell[CellGroupData[{
Cell[52152, 1853, 1044, 32, 70, "Input",
 CellTags->"Ex--21904899473679702393,26",
 CellID->564995280],
Cell[53199, 1887, 354, 12, 36, "Output",
 CellTags->"Ex--21904899473679702393,26",
 CellID->118187719]
}, Open  ]],
Cell[53568, 1902, 604, 23, 70, "ExampleText",
 CellID->100374123],
Cell[CellGroupData[{
Cell[54197, 1929, 911, 28, 70, "Input",
 CellTags->"Ex--21904899473679702393,27",
 CellID->1728804619],
Cell[55111, 1959, 7859, 133, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21904899473679702393,27",
 CellID->890964781]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63031, 2099, 311, 9, 70, "SeeAlsoSection",
 CellID->20848],
Cell[63345, 2110, 1760, 62, 70, "SeeAlso",
 CellID->30226]
}, Open  ]],
Cell[CellGroupData[{
Cell[65142, 2177, 314, 9, 70, "TutorialsSection",
 CellID->20017],
Cell[65459, 2188, 144, 3, 70, "Tutorials",
 CellID->30402]
}, Open  ]],
Cell[CellGroupData[{
Cell[65640, 2196, 321, 9, 70, "RelatedLinksSection",
 CellID->22869],
Cell[65964, 2207, 193, 4, 70, "RelatedLinks"],
Cell[66160, 2213, 211, 4, 70, "RelatedLinks"],
Cell[66374, 2219, 395, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[66806, 2237, 319, 9, 70, "MoreAboutSection",
 CellID->204843276],
Cell[67128, 2248, 195, 4, 70, "MoreAbout",
 CellID->421346457],
Cell[67326, 2254, 159, 3, 70, "MoreAbout",
 CellID->203675681],
Cell[67488, 2259, 155, 3, 70, "MoreAbout",
 CellID->568364130],
Cell[67646, 2264, 143, 3, 70, "MoreAbout",
 CellID->3415877]
}, Open  ]],
Cell[67804, 2270, 27, 0, 70, "History"],
Cell[67834, 2272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

