(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35462,       1332]
NotebookOptionsPosition[     27475,       1054]
NotebookOutlinePosition[     28925,       1094]
CellTagsIndexPosition[     28839,       1089]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric2F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Hypergeometric2F1\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Hypergeometric Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/HypergeometricFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Hypergeometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hypergeometric2F1Regularized", "ObjectName",
 CellID->3734],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hypergeometric2F1Regularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hypergeometric2F1Regularized"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["c", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the regularized hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         SubscriptBox["\[Null]", "2"], "\[InvisibleSpace]", 
         SubscriptBox["F", "1"], "(", 
         RowBox[{"a", ",", "b", ";", "c", ";", "z"}], ")"}], "/", 
        RowBox[{"\[CapitalGamma]", "(", "c", ")"}]}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Hypergeometric2F1Regularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1Regularized"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["c", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " is finite for all finite values of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " so long as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], "<", 
    "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->2541],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1Regularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->622360307],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1Regularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1Regularized"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5833113],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->5921447],

Cell["Evaluate numerically:", "ExampleText",
 CellID->404025343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"-", "3"}], ",", "4.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->738894796],

Cell[BoxData["26.768438320767704`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125945761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1097973339],

Cell[TextData[{
 "Regularize ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " for negative integer values of the parameter ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->310929902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"-", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"120", " ", 
   SuperscriptBox["x", "4"]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "x"}], ")"}], "6"]]], "Output",
 ImageSize->{55, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->148722839]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1", "[", 
  RowBox[{"1", ",", "2", ",", 
   RowBox[{"-", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->327365746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193217683],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->38547989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric2F1Regularized", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "x"}], "]"}], "+", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55263732],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    RowBox[{"Gamma", "[", "c", "]"}]], "+", 
   FractionBox[
    RowBox[{"a", " ", "b", " ", "x"}], 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "c"}], "]"}]], "+", 
   FractionBox[
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "a"}], ")"}], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "b"}], ")"}], " ", 
     SuperscriptBox["x", "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"2", "+", "c"}], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   Gamma[$CellContext`c]^(-1), $CellContext`a $CellContext`b/Gamma[
    1 + $CellContext`c], 
    Rational[1, 2] $CellContext`a (1 + $CellContext`a) $CellContext`b (
     1 + $CellContext`b)/Gamma[2 + $CellContext`c]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{340, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17672050]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22826],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->334604611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{
   RowBox[{"1", "+", "I"}], ",", 
   RowBox[{"2", "-", "I"}], ",", 
   RowBox[{"-", "3"}], ",", "4.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->562347173],

Cell[BoxData[
 RowBox[{"60.79467504245304`", "\[InvisibleSpace]", "+", 
  RowBox[{"199.4158073429975`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1054103382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18001703],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->205009941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Hypergeometric2F1Regularized", "[", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "3"}]}], "]"}], ",", " ", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99163926],

Cell[BoxData["0.\
0023342724677205809126189408920981464604899689916457452861733926589`50."], \
"Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186525961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->563694966],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->354628230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"-", "5"}], ",", 
   RowBox[{"-", "0.333333333333333333333333"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70266597],

Cell[BoxData["0.00233427246772058091261892820808588156`22.00873120293172"], \
"Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139421202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5879879],

Cell["\<\
Automatically evaluate to simpler functions for certain parameters:\
\>", "ExampleText",
 CellID->472444214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{
   FractionBox["1", "2"], ",", "1", ",", 
   RowBox[{"-", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389329184],

Cell[BoxData[
 FractionBox[
  RowBox[{"15", " ", 
   SuperscriptBox["x", "3"]}], 
  RowBox[{"8", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], 
    RowBox[{"7", "/", "2"}]]}]]], "Output",
 ImageSize->{75, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->469558101]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"3", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1197749634],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcSin", "[", 
    SqrtBox["x"], "]"}]}], 
  RowBox[{
   SqrtBox["\[Pi]"], " ", 
   SqrtBox["x"]}]]], "Output",
 ImageSize->{98, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->570997137]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", "1", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->699072983],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"EllipticK", "[", "z", "]"}]}], "\[Pi]"]], "Output",
 ImageSize->{103, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->49047803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302753052],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1Regularized"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->157846266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{"2", ",", "2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33128329],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "8"], ",", 
   RowBox[{"-", 
    FractionBox["9", "8"]}], ",", 
   FractionBox["15", "4"]}], "}"}]], "Output",
 ImageSize->{89, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43794344]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180278457],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->653625731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hypergeometric2F1Regularized", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35954786],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVNtOwzAMdZes3QZC4m3saZ8BHzB44iOqCWl7QKCx/+8cJ1mSYw8hUan1
Renx8bHb9/F8+Pgcz8f9uH07jd+H4/5n+/p14pTriGjH9+Oa2J/Yk3s3TWw9
uyv2HNt5yARnkos8xHcQLyAeIJ5JhQgjSX4ihoO4/2fNTsrMsAq7Jrs6psI1
ZkOmT9aDdZX1yQahQ/3IQTrzBZ8Ud2Ewr09kHkv73SYzqMwNDqVCas5UokFC
bYY/4SyN2bZ8NN98noz907xwW7QGyGllYAInd525TDdPM09b922pI9vjyhRr
HgSzz0dbHroX1DPUdbAdkTcyyluqvoOEcKP6L7o9QLxRCAtTK9x5xFlDXNj0
hgL3qa8nQxn+yRUejTov1zxO6bl6Lz6puwCIj5fY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{69, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->52465553]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4189],

Cell[TextData[{
 "Define the fractional derivative of ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->804007844],

Cell[BoxData[
 RowBox[{
  RowBox[{"fd", "[", 
   RowBox[{
    RowBox[{"EllipticK", "[", "z_", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"z_", ",", " ", "\[Alpha]_"}], "}"}]}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"Pi", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", "^", "\[Alpha]"}], " ", "2"}], ")"}]}], ")"}], " ", 
   RowBox[{"Hypergeometric2F1Regularized", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", " ", 
     RowBox[{"1", "/", "2"}], ",", " ", 
     RowBox[{"1", " ", "-", " ", "\[Alpha]"}], ",", " ", "z"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52104695],

Cell[TextData[{
 "Check that for integer order ",
 StyleBox["\[Alpha]", "TR"],
 " it coincides with the ordinary derivative:"
}], "ExampleText",
 CellID->407656081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fd", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235870177],

Cell[BoxData[
 RowBox[{
  FractionBox["75", "256"], " ", "\[Pi]", " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["7", "2"], ",", 
    FractionBox["7", "2"], ",", "4", ",", "z"}], "]"}]}]], "Output",
 ImageSize->{246, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132175738]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", " ", "==", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "3"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->172617202],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->547916849]
}, Open  ]],

Cell["Evaluate derivative of order 1/2:", "ExampleText",
 CellID->319602774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fd", "[", 
  RowBox[{
   RowBox[{"EllipticK", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->109842091],

Cell[BoxData[
 FractionBox[
  SqrtBox["\[Pi]"], 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"1", "-", "z"}]], " ", 
   SqrtBox["z"]}]]], "Output",
 ImageSize->{89, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->918705081]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29707],

Cell["Evaluate symbolically for numeric third argument:", "ExampleText",
 CellID->214918532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{"a", ",", "b", ",", 
   RowBox[{"-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140856223],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "a", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "a"}], ")"}], " ", "b", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "b"}], ")"}], " ", 
  SuperscriptBox["x", "2"], " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    RowBox[{"2", "+", "a"}], ",", 
    RowBox[{"2", "+", "b"}], ",", "3", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{375, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91213262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{"a", ",", "b", ",", 
   RowBox[{
    RowBox[{"-", "1"}], "/", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91095205],

Cell[BoxData[
 FractionBox[
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{"a", ",", "b", ",", 
    RowBox[{"-", 
     FractionBox["1", "3"]}], ",", "x"}], "]"}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"-", 
    FractionBox["1", "3"]}], "]"}]]], "Output",
 ImageSize->{214, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27132892]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->417964800],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1Regularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1Regularized"]], "InlineFormula"],
 " into other functions:"
}], "ExampleText",
 CellID->354988665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hypergeometric2F1Regularized", "[", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", 
   RowBox[{"5", "/", "6"}], ",", 
   RowBox[{"2", "/", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2953150],

Cell[BoxData[
 FractionBox[
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["1", "3"], ",", 
    FractionBox["5", "6"], ",", 
    FractionBox["2", "3"], ",", "x"}], "]"}], 
  RowBox[{"Gamma", "[", 
   FractionBox["2", "3"], "]"}]]], "Output",
 ImageSize->{213, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140063142]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", " ", 
  RowBox[{"Hypergeometric2F1Regularized", "[", 
   RowBox[{
    RowBox[{"1", "/", "3"}], ",", 
    RowBox[{"5", "/", "6"}], ",", 
    RowBox[{"2", "/", "3"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->206445714],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "-", "x"}]]}], ")"}], 
   RowBox[{"1", "/", "3"}]], 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"1", "/", "3"}]], " ", 
   SqrtBox[
    RowBox[{"1", "-", "x"}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["2", "3"], "]"}]}]]], "Output",
 ImageSize->{140, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->142149294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44707779],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " may give results involving ",
 Cell[BoxData["Hypergometric2F1Regularized"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->353253393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"t", " ", "z"}]}], ")"}], "^", "c"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "t"}], ")"}], "^", "a"}], " ", 
    RowBox[{"t", "^", "b"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"a", ">", 
      RowBox[{"-", "1"}]}], "&&", 
     RowBox[{"b", ">", 
      RowBox[{"-", "1"}]}], " ", "&&", " ", 
     RowBox[{
      RowBox[{"Abs", "[", "z", "]"}], "<", "1"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285339955],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "a"}], "]"}], " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "b"}], "]"}], " ", 
  RowBox[{"Hypergeometric2F1Regularized", "[", 
   RowBox[{
    RowBox[{"1", "+", "b"}], ",", 
    RowBox[{"-", "c"}], ",", 
    RowBox[{"2", "+", "a", "+", "b"}], ",", "z"}], "]"}]}]], "Output",
 ImageSize->{500, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252694140]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22378],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1925],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->27201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4855],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/\
Hypergeometric2F1Regularized/"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->357619953],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->791893288],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->284178597]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hypergeometric2F1Regularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 57.4916838}", "context" -> "System`", 
    "keywords" -> {
     "2F1 regularized", "hypergeometric2 f1 regularized", 
      "hypergeometric functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Hypergeometric2F1Regularized[a, b, c, z] is the regularized \
hypergeometric function \\[Null]_2F_1 (a, b; c; z)/\\[CapitalGamma](c). ", 
    "synonyms" -> {"hypergeometric 2f1 regularized"}, "title" -> 
    "Hypergeometric2F1Regularized", "type" -> "Symbol", "uri" -> 
    "ref/Hypergeometric2F1Regularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5928, 200, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5833113]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28698, 1082}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1944, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2567, 76, 65, 1, 70, "ObjectName",
 CellID->3734],
Cell[2635, 79, 988, 29, 70, "Usage",
 CellID->1452]
}, Open  ]],
Cell[CellGroupData[{
Cell[3660, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4138, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4261, 136, 834, 31, 70, "Notes",
 CellID->2541],
Cell[5098, 169, 288, 8, 70, "Notes",
 CellID->622360307],
Cell[5389, 179, 258, 7, 70, "Notes",
 CellID->31226],
Cell[5650, 188, 241, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5928, 200, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5833113],
Cell[CellGroupData[{
Cell[6311, 214, 146, 5, 70, "ExampleSection",
 CellID->5921447],
Cell[6460, 221, 64, 1, 70, "ExampleText",
 CellID->404025343],
Cell[CellGroupData[{
Cell[6549, 226, 188, 5, 28, "Input",
 CellID->738894796],
Cell[6740, 233, 176, 5, 36, "Output",
 CellID->125945761]
}, Open  ]],
Cell[6931, 241, 126, 3, 70, "ExampleDelimiter",
 CellID->1097973339],
Cell[7060, 246, 320, 11, 70, "ExampleText",
 CellID->310929902],
Cell[CellGroupData[{
Cell[7405, 261, 166, 4, 70, "Input"],
Cell[7574, 267, 301, 11, 57, "Output",
 CellID->148722839]
}, Open  ]],
Cell[CellGroupData[{
Cell[7912, 283, 155, 4, 70, "Input"],
Cell[8070, 289, 173, 5, 36, "Output",
 CellID->327365746]
}, Open  ]],
Cell[8258, 297, 125, 3, 70, "ExampleDelimiter",
 CellID->193217683],
Cell[8386, 302, 73, 1, 70, "ExampleText",
 CellID->38547989],
Cell[CellGroupData[{
Cell[8484, 307, 242, 7, 70, "Input",
 CellID->55263732],
Cell[8729, 316, 1123, 34, 56, "Output",
 CellID->17672050]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9901, 356, 216, 7, 70, "ExampleSection",
 CellID->22826],
Cell[10120, 365, 89, 1, 70, "ExampleText",
 CellID->334604611],
Cell[CellGroupData[{
Cell[10234, 370, 236, 7, 70, "Input",
 CellID->562347173],
Cell[10473, 379, 272, 7, 36, "Output",
 CellID->1054103382]
}, Open  ]],
Cell[10760, 389, 124, 3, 70, "ExampleDelimiter",
 CellID->18001703],
Cell[10887, 394, 70, 1, 70, "ExampleText",
 CellID->205009941],
Cell[CellGroupData[{
Cell[10982, 399, 350, 12, 70, "Input",
 CellID->99163926],
Cell[11335, 413, 235, 7, 36, "Output",
 CellID->186525961]
}, Open  ]],
Cell[11585, 423, 125, 3, 70, "ExampleDelimiter",
 CellID->563694966],
Cell[11713, 428, 113, 3, 70, "ExampleText",
 CellID->354628230],
Cell[CellGroupData[{
Cell[11851, 435, 277, 8, 70, "Input",
 CellID->70266597],
Cell[12131, 445, 218, 6, 36, "Output",
 CellID->139421202]
}, Open  ]],
Cell[12364, 454, 123, 3, 70, "ExampleDelimiter",
 CellID->5879879],
Cell[12490, 459, 118, 3, 70, "ExampleText",
 CellID->472444214],
Cell[CellGroupData[{
Cell[12633, 466, 208, 6, 70, "Input",
 CellID->389329184],
Cell[12844, 474, 351, 13, 57, "Output",
 CellID->469558101]
}, Open  ]],
Cell[CellGroupData[{
Cell[13232, 492, 240, 7, 70, "Input",
 CellID->1197749634],
Cell[13475, 501, 302, 12, 64, "Output",
 CellID->570997137]
}, Open  ]],
Cell[CellGroupData[{
Cell[13814, 518, 215, 6, 70, "Input",
 CellID->699072983],
Cell[14032, 526, 242, 8, 51, "Output",
 CellID->49047803]
}, Open  ]],
Cell[14289, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->302753052],
Cell[14417, 542, 250, 7, 70, "ExampleText",
 CellID->157846266],
Cell[CellGroupData[{
Cell[14692, 553, 307, 10, 70, "Input",
 CellID->33128329],
Cell[15002, 565, 299, 11, 51, "Output",
 CellID->43794344]
}, Open  ]],
Cell[15316, 579, 125, 3, 70, "ExampleDelimiter",
 CellID->180278457],
Cell[15444, 584, 203, 7, 70, "ExampleText",
 CellID->653625731],
Cell[CellGroupData[{
Cell[15672, 595, 208, 6, 70, "Input",
 CellID->35954786],
Cell[15883, 603, 633, 14, 70, "Output",
 Evaluatable->False,
 CellID->52465553]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16565, 623, 222, 7, 70, "ExampleSection",
 CellID->4189],
Cell[16790, 632, 221, 8, 70, "ExampleText",
 CellID->804007844],
Cell[17014, 642, 636, 20, 70, "Input",
 CellID->52104695],
Cell[17653, 664, 164, 5, 70, "ExampleText",
 CellID->407656081],
Cell[CellGroupData[{
Cell[17842, 673, 207, 7, 70, "Input",
 CellID->235870177],
Cell[18052, 682, 353, 11, 51, "Output",
 CellID->132175738]
}, Open  ]],
Cell[CellGroupData[{
Cell[18442, 698, 283, 9, 70, "Input",
 CellID->172617202],
Cell[18728, 709, 161, 5, 36, "Output",
 CellID->547916849]
}, Open  ]],
Cell[18904, 717, 76, 1, 70, "ExampleText",
 CellID->319602774],
Cell[CellGroupData[{
Cell[19005, 722, 233, 8, 70, "Input",
 CellID->109842091],
Cell[19241, 732, 278, 11, 60, "Output",
 CellID->918705081]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19568, 749, 233, 7, 70, "ExampleSection",
 CellID->29707],
Cell[19804, 758, 92, 1, 70, "ExampleText",
 CellID->214918532],
Cell[CellGroupData[{
Cell[19921, 763, 186, 5, 70, "Input",
 CellID->140856223],
Cell[20110, 770, 507, 16, 51, "Output",
 CellID->91213262]
}, Open  ]],
Cell[CellGroupData[{
Cell[20654, 791, 210, 6, 70, "Input",
 CellID->91095205],
Cell[20867, 799, 384, 13, 68, "Output",
 CellID->27132892]
}, Open  ]],
Cell[21266, 815, 125, 3, 70, "ExampleDelimiter",
 CellID->417964800],
Cell[21394, 820, 395, 13, 70, "ExampleText",
 CellID->354988665],
Cell[CellGroupData[{
Cell[21814, 837, 237, 7, 70, "Input",
 CellID->2953150],
Cell[22054, 846, 390, 13, 68, "Output",
 CellID->140063142]
}, Open  ]],
Cell[CellGroupData[{
Cell[22481, 864, 289, 8, 70, "Input",
 CellID->206445714],
Cell[22773, 874, 495, 19, 72, "Output",
 CellID->142149294]
}, Open  ]],
Cell[23283, 896, 124, 3, 70, "ExampleDelimiter",
 CellID->44707779],
Cell[23410, 901, 277, 9, 70, "ExampleText",
 CellID->353253393],
Cell[CellGroupData[{
Cell[23712, 914, 673, 23, 70, "Input",
 CellID->285339955],
Cell[24388, 939, 482, 15, 36, "Output",
 CellID->252694140]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24931, 961, 311, 9, 70, "SeeAlsoSection",
 CellID->22378],
Cell[25245, 972, 214, 6, 70, "SeeAlso",
 CellID->12623]
}, Open  ]],
Cell[CellGroupData[{
Cell[25496, 983, 313, 9, 70, "TutorialsSection",
 CellID->1925],
Cell[25812, 994, 144, 3, 70, "Tutorials",
 CellID->27201]
}, Open  ]],
Cell[CellGroupData[{
Cell[25993, 1002, 320, 9, 70, "RelatedLinksSection",
 CellID->4855],
Cell[26316, 1013, 176, 4, 70, "RelatedLinks"],
Cell[26495, 1019, 222, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26754, 1028, 319, 9, 70, "MoreAboutSection",
 CellID->357619953],
Cell[27076, 1039, 165, 3, 70, "MoreAbout",
 CellID->791893288],
Cell[27244, 1044, 159, 3, 70, "MoreAbout",
 CellID->284178597]
}, Open  ]],
Cell[27418, 1050, 27, 0, 70, "History"],
Cell[27448, 1052, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

