(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    114618,       3581]
NotebookOptionsPosition[     95131,       2959]
NotebookOutlinePosition[    101480,       3130]
CellTagsIndexPosition[    100605,       3108]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeijerG" :> Documentation`HelpLookup["paclet:ref/MeijerG"], 
          "Hypergeometric0F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric0F1"], 
          "Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"], 
          "Hypergeometric2F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric2F1"], 
          "AppellF1" :> Documentation`HelpLookup["paclet:ref/AppellF1"], 
          "HypergeometricPFQRegularized" :> 
          Documentation`HelpLookup["paclet:ref/HypergeometricPFQRegularized"],
           "HypergeometricDistribution" :> 
          Documentation`HelpLookup[
           "paclet:ref/HypergeometricDistribution"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MeijerG\"\>", 2->"\<\"Hypergeometric0F1\"\>", 
       3->"\<\"Hypergeometric1F1\"\>", 4->"\<\"Hypergeometric2F1\"\>", 
       5->"\<\"AppellF1\"\>", 6->"\<\"HypergeometricPFQRegularized\"\>", 
       7->"\<\"HypergeometricDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Hypergeometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/HypergeometricFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Hypergeometric Functions\"\>", 
       3->"\<\"Mathematical Functions\"\>", 4->"\<\"Special Functions\"\>", 
       5->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HypergeometricPFQ", "ObjectName",
 CellID->7666],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HypergeometricPFQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HypergeometricPFQ"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["p", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["q", "TI"]]}], "}"}], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the generalized hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["\[Null]", "p"], "\[InvisibleSpace]", 
        SubscriptBox["F", "q"], "(", 
        RowBox[{"a", ";", "b", ";", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12360]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Null]", "p"], "\[InvisibleSpace]", 
    SubscriptBox["F", "q"], "(", 
    RowBox[{"a", ";", "b", ";", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " has series expansion ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "\[Infinity]",
     LimitsPositioning->True], 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["a", "1"], ")"}], "k"], "\[Ellipsis]", 
    SubscriptBox[
     StyleBox[
      RowBox[{"(", 
       SubscriptBox["a", "p"], ")"}],
      SpanMaxSize->1], "k"], "/", 
    SubscriptBox[
     RowBox[{"(", 
      SubscriptBox["b", "1"], ")"}], "k"], "\[Ellipsis]", 
    SubscriptBox[
     StyleBox[
      RowBox[{"(", 
       SubscriptBox["b", "q"], ")"}],
      SpanMaxSize->1], "k"], " ", 
    RowBox[{
     SuperscriptBox["z", "k"], "/", 
     RowBox[{"k", "!"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->22385],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hypergeometric0F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric0F1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Hypergeometric2F1",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hypergeometric2F1"]], "InlineFormula"],
 " are special cases of ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4001],

Cell[TextData[{
 "In many special cases, ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " is automatically converted to other functions. "
}], "Notes",
 CellID->13485],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->23803685],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", 
    RowBox[{"q", "+", "1"}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["HypergeometricPFQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricPFQ"], "[", 
   RowBox[{
    StyleBox["alist", "TI"], ",", 
    StyleBox["blist", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "TR"],
 ". "
}], "Notes",
 CellID->11619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " include transformation rules for ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22946]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34014979],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->23090018],

Cell["Evaluate numerically:", "ExampleText",
 CellID->15626725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", "2."}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46805490],

Cell[BoxData["1.078934402067188`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19058315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39059744],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   TagBox[
    TagBox[
     RowBox[{
      RowBox[{
       SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
       SubscriptBox["F", "3"]}], "\[InvisibleApplication]", 
      RowBox[{"(", 
       RowBox[{
        TagBox[
         TagBox[
          RowBox[{
           TagBox["1",
            HypergeometricPFQ,
            Editable->True,
            Selectable->True], ",", 
           TagBox["1",
            HypergeometricPFQ,
            Editable->True,
            Selectable->True]}],
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         HypergeometricPFQ,
         Editable->False,
         Selectable->False], ";", 
        TagBox[
         TagBox[
          RowBox[{
           TagBox["3",
            HypergeometricPFQ,
            Editable->True,
            Selectable->True], ",", 
           TagBox["3",
            HypergeometricPFQ,
            Editable->True,
            Selectable->True], ",", 
           TagBox["3",
            HypergeometricPFQ,
            Editable->True,
            Selectable->True]}],
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         HypergeometricPFQ,
         Editable->False,
         Selectable->False], ";", 
        TagBox["x",
         HypergeometricPFQ,
         Editable->True,
         Selectable->True]}], ")"}]}],
     InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
     Editable->False,
     Selectable->False],
    HypergeometricPFQ], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->3416506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "30"}], ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144039159],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx3HSYSq3ZptYu7XSuEyXKde2Gd8+bzpYzR4MIaSsS5FyadC6
NCvqMJTdaCVR61hKOkpHFyk+zG6FsrIp0WCYFLJMEyaG2c+esz+8zvM8/oHX
utBY74glGhoaHmT/lduXMK5WU1irWdLWeEeCeurLJt3nKfxqkL2BWS9BSUUd
ioIZCi/uXTMvapCgm75WKssJCss6PT/6YQlidvbpevVS+E5zyvaZVgnS/dOZ
/Vsdhceo0667JBLUX2MYD1EUfuH0nuO+tB+dyLg+k97liM/pHLhW5dOPREbR
7RW5XNwiSukO0x5Aa/+wKhcEcjB+npyuvD2AFpiRjB1btmNj684V8faD6JKA
zb8+tg1r74zg9ZUMomevFT+LGxywqtpqpH6JFDVuhiKhwB53rQ6/EHdMij7b
63MdrO3wPh/ufvmUFDX79g0WLrXF9QmbFpSRQ4gXtsXrYqM1Fne+q16uGEJh
2Rkt3+Vtxc94kKdKHUYicc2lt4/ZuOhGNevQchnq5B/gnYBNuF4kjpPWyJCN
wdeLMTIWfu0abJrg/RYZXx3Y+buvJY7UeDPbYjCC8qsqG7u6mJieIm948XIE
WfZGI59UM/wqQmq0p/QdSn96vNJh6Bu8vkpUPJX5Ho06m/YeYn6FAx6mcNsP
jaKguH5btuZqbMHYeC3r2Bj6FFM+OzxtiGUsgxejBeMo63xrXmoGDSdaRHOc
aj+gaKHOdHGJqgmcBfDT4gRyPdOrLF0z3HQ7/JSZkcckMgxYf/XAjiGU1qJk
6O2ZQgXidbqfQxeQZvtAdYClHEm3mu4ysqBB0Amhc7xSjqZpqsFWm5VgIWn2
vDvxEfGtpLd+5awGmsuenA0KBUoabf3x4bgJBJ/ubrKd/4Taknm6GzVNYYlh
vkeJ9Qxq/MvWz/wHMxAkabbrH55Fax8aR1vcZkLx2FH//HolmuuY/DDAtQSG
q7teoPMcaqh9Eul2ngUT2d0bEjvnkfJeAf+g+SY4fjzA6EnFAvrybIidfTYb
FCcdpsQZauSjwZCfjN0KfY7CclqTBvi3HRXy6qzhmMbTkagxTehIe06LGraB
xxcKc6+baEGmU1Xr0EY7WPg74x4tYyn8w1dP7o+xB/O5byOvaWlD+y6/L+wu
OoB5a3JZYq4OjPhaHAmXboMrLisTTwUugwT3WfH4yu3AeZb1SdtmBdzLdk1P
cuRAmerggL+VHnB69QXB6VzwbmMcdksxAPaqntCLNY6w721tKG/cEEJCTET2
MxSkJK1xrfSiw/dt5bf2EpvXzU13EW+z2/wmk1i2bHelmlifBlu6iPW0UmkB
fDo8uBHRHTNLwSy/uGuFNx2M1DfXXVVSUHP2G2G8Dx06St3um8xTcIPhYUP5
0eG+zvNhJ2L2zE15FHFFfKBeFLGZyS+1hcRpLkdC7hL3WottpohZE/nau1UU
CB+pOOX+dDjp2O99ZoGCc3WNocsC6BBXeTCtjtgpdoTlQBxkKK/oIzbOzJGH
EtvItD6zFim43+CW8YB4MJd1+RHx48LCqthAOjydvvVkgvgllCWUEN/d7/hx
lZqCcQ8raCXOs/V0CSO+XFLdYxZEh+TSnpgcYkX/lQpP4nCd0KJa4sYcU0Ea
sVf8eHMPcXAZw6mK+P8/AytmlsFL4n8BoctXvQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{-30, 30}, {0.46427888690142555`, 4.589683764098517}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30608735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12256083],

Cell["Evaluate symbolically:", "ExampleText",
 CellID->385353294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62931415],

Cell[BoxData[
 RowBox[{"4", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "z"}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "z"}], "]"}]}], 
      SuperscriptBox["z", "2"]]}], "-", 
    FractionBox[
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "z"}], "]"}], "z"], "-", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "z"}], "+", 
      RowBox[{"PolyLog", "[", 
       RowBox[{"2", ",", "z"}], "]"}]}], 
     SuperscriptBox["z", "2"]]}], ")"}]}]], "Output",
 ImageSize->{340, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101612774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->419437541],

Cell["Series at the origin:", "ExampleText",
 CellID->116440374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", " ", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "a2", ",", "a3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b1", ",", "b2"}], "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304251267],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    RowBox[{"a1", " ", "a2", " ", "a3", " ", "z"}], 
    RowBox[{"b1", " ", "b2"}]], "+", 
   FractionBox[
    RowBox[{"a1", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "a1"}], ")"}], " ", "a2", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "a2"}], ")"}], " ", "a3", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "a3"}], ")"}], " ", 
     SuperscriptBox["z", "2"]}], 
    RowBox[{"2", " ", "b1", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "b1"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"b2", "+", 
       SuperscriptBox["b2", "2"]}], ")"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, $CellContext`a1 $CellContext`a2 $CellContext`a3 \
$CellContext`b1^(-1)/$CellContext`b2, 
    Rational[1, 2] $CellContext`a1 (1 + $CellContext`a1) $CellContext`a2 (
     1 + $CellContext`a2) $CellContext`a3 (
     1 + $CellContext`a3) $CellContext`b1^(-1) (
      1 + $CellContext`b1)^(-1)/($CellContext`b2 + $CellContext`b2^2)}, 0, 3, 
   1],
  Editable->False]], "Output",
 ImageSize->{364, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221492543]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19295],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellID->25356769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"I", ",", "I", ",", "I"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", " ", ",", "2"}], "}"}], ",", 
   RowBox[{
    RowBox[{"-", "1.0"}], "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->535205823],

Cell[BoxData[
 RowBox[{"0.8700317745447872`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.004845383446731728`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->634307891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193374817],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->471261392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"3", "/", "2"}], ",", 
       RowBox[{"3", "/", "2"}]}], "}"}], ",", "10"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174086697],

Cell[BoxData["530.1918882736259043885596168544408779273305339835787871201282`\
50."], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56147581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132487969],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->182436018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "/", "2"}], ",", 
     RowBox[{"3", "/", "2"}], ",", 
     RowBox[{"3", "/", "2"}]}], "}"}], ",", "10.00000000000000000000000000"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->633130590],

Cell[BoxData["530.19188827362590438855961555758681935496`26.076231169716774"],\
 "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35231424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384533180],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists in its third argument:"
}], "ExampleText",
 CellID->17939029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1", ",", " ", "0.3", ",", " ", "0.5"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395261281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0116376588728047`", ",", "1.0362664461597069`", ",", 
   "1.0629595447526494`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57595094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12674930],

Cell[TextData[{
 "For simple parameters, ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " evaluates to simpler functions:"
}], "ExampleText",
 CellID->990591914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->902813491],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"1", "-", "x"}]], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "x"}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "x"}], "]"}]}], 
      SuperscriptBox["x", "2"]]}], ")"}]}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}], "x"]}]], "Output",
 ImageSize->{257, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114939813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->499110381],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " evaluates to a polynomial if any of the parameters ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is a non-positive integer:"
}], "ExampleText",
 CellID->46310469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->571628789],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", "x"}], 
   RowBox[{"b", " ", "c"}]], "+", 
  FractionBox[
   RowBox[{"3", " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "b"}], ")"}], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "c"}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "-", "a"}], ")"}], " ", "a", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "b"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "b"}], ")"}], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "c"}], ")"}]}]]}]], "Output",
 ImageSize->{384, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45569837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->405280366],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->110583574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["a", "2"], ",", 
      SubscriptBox["a", "3"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["b", "1"], ",", 
      SubscriptBox["b", "2"]}], "}"}], ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49909376],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyNVcFugzAMDQmEUirRaZu0Y39i2h9sp30Eqia1h2pT11s/nsXgtMF+wJAg
sfPy4mcn4bO9HL5O7eW4b3cf5/bncNz/7t6/z8HlMmPMNbzNiwn9LvT699p1
oXWhW4VeHtqCPOTo+qe3yTSuh5Lb1Iy1ArtmrBP+iv0Ij3hWwrZDlMJbJjYF
mKPx4mYzaiNmSdYNnFWjiISSOVapKFOKaJYNr19YySa1QCtZriHE5amuKaTM
o2VfxGsWPzuac5VpCdqGpH3QP6fDwzrYZAUcbakQckdrhONIV+P4AbtGSHav
EFq3qqmwi0XtOLpSIea0Yw6cd7ifFQrGk9g6Ez1vKXgm9TrsUXFUS6yLtwTM
il5Z3HHGp4jh+5+7TeQkOTM0Gs/QxI4QJ3WtIo0c9ZiDI4x3v73JjoA4B4+g
G2+sQ+81pJ3Mhtstt2jfjE9sozxyTt7d/0UgLlm5xH4T9lbYz4oRnwa5zhLv
o7Dv0XqQu1euwwO3TyC34Zevvib7A/x0/lY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->765635043]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32652],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " of type ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "==", 
    RowBox[{"q", "+", "1"}]}], TraditionalForm]], "InlineMath"],
 " into a series at the branch point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "==", "1"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->464617087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", " ", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", 
       RowBox[{"2", "/", "3"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"4", "/", "3"}], ",", 
       RowBox[{"4", "/", "3"}]}], "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->372551981],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     FractionBox["4", "3"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
     RowBox[{"Floor", "[", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"Arg", "[", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], "]"}], 
        RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"2", "/", "3"}]], " ", 
           SuperscriptBox[
            RowBox[{"Gamma", "[", 
             FractionBox["4", "3"], "]"}], "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"z", "-", "1"}], ")"}], 
          RowBox[{"2", "/", "3"}]]}], 
        RowBox[{"2", " ", 
         RowBox[{"Gamma", "[", 
          FractionBox["2", "3"], "]"}]}]]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         RowBox[{"z", "-", "1"}], "]"}], 
        RowBox[{"4", "/", "3"}]],
       SeriesData[$CellContext`z, 1, {}, 2, 4, 3],
       Editable->False]}],
     SeriesData[$CellContext`z, 1, {
      Rational[-3, 2] (-1)^Rational[2, 3] Gamma[
          Rational[2, 3]]^(-1) Gamma[
          Rational[4, 3]]^2}, 2, 4, 3],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{
      RowBox[{"Gamma", "[", 
       FractionBox["2", "3"], "]"}], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["4", "3"], "]"}], " ", 
      RowBox[{"HypergeometricPFQ", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          FractionBox["1", "3"], ",", 
          FractionBox["1", "3"], ",", 
          FractionBox["2", "3"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          FractionBox["4", "3"]}], "}"}], ",", "1"}], "]"}]}], "-", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           FractionBox["4", "3"], "]"}], "2"], " ", 
         RowBox[{"Gamma", "[", 
          FractionBox["5", "3"], "]"}], " ", 
         RowBox[{"HypergeometricPFQ", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              FractionBox["1", "3"]}], ",", 
             FractionBox["1", "3"], ",", 
             FractionBox["1", "3"]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", 
             FractionBox["4", "3"]}], "}"}], ",", "1"}], "]"}]}], ")"}], " ", 
       
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}]}], 
      RowBox[{"Gamma", "[", 
       FractionBox["1", "3"], "]"}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"z", "-", "1"}], "]"}], "2"],
      SeriesData[$CellContext`z, 1, {}, 0, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`z, 1, {Gamma[
        Rational[2, 3]] Gamma[
        Rational[4, 3]] HypergeometricPFQ[{
         Rational[1, 3], 
         Rational[1, 3], 
         Rational[2, 3]}, {1, 
         Rational[4, 3]}, 1], (-3) Gamma[
         Rational[1, 3]]^(-1) Gamma[
         Rational[4, 3]]^2 Gamma[
        Rational[5, 3]] HypergeometricPFQ[{
         Rational[-1, 3], 
         Rational[1, 3], 
         Rational[1, 3]}, {1, 
         Rational[4, 3]}, 1]}, 0, 2, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{579, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314684811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->86688944],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " into a series around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "==", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->90865036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", " ", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "3"}], ",", 
       RowBox[{"2", "/", "3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "/", "3"}], ",", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "3"}]}], "}"}], ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29843557],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{579, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215117929]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->90],

Cell["Solve a differential equation of hypergeometric type:", "ExampleText",
 CellID->127429397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "'''"}], "[", "z", "]"}], "==", 
    RowBox[{
     SuperscriptBox["z", 
      RowBox[{"3", " "}]], 
     RowBox[{"f", "[", "z", "]"}]}]}], ",", 
   RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellTags->"Ex--21909537627048908038,1",
 CellLabel->"In[1]:=",
 CellID->4981847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"HypergeometricPFQ", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["2", "3"], ",", 
          FractionBox["5", "6"]}], "}"}], ",", 
        FractionBox[
         SuperscriptBox["z", "6"], "216"]}], "]"}]}], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], 
        RowBox[{"1", "/", "6"}]], " ", "z", " ", 
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"HypergeometricPFQ", "[", 
        RowBox[{
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           FractionBox["5", "6"], ",", 
           FractionBox["7", "6"]}], "}"}], ",", 
         FractionBox[
          SuperscriptBox["z", "6"], "216"]}], "]"}]}], 
      SqrtBox["6"]], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]], " ", 
      SuperscriptBox["z", "2"], " ", 
      RowBox[{"C", "[", "3", "]"}], " ", 
      RowBox[{"HypergeometricPFQ", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          FractionBox["7", "6"], ",", 
          FractionBox["4", "3"]}], "}"}], ",", 
        FractionBox[
         SuperscriptBox["z", "6"], "216"]}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{396, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909537627048908038,1",
 CellLabel->"Out[1]=",
 CellID->343591604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206334130],

Cell[TextData[{
 "A formula for solutions to trinomial equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", 
      RowBox[{"n", "+", "1"}]], "-", "x", "+", "t"}], "==", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->332234312],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", 
   RowBox[{"m_", ",", "n_Integer", ",", "t_"}], "]"}], ":=", 
  RowBox[{"Sum", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"k", "!"}], " ", "n"}]]}], 
     RowBox[{"Pochhammer", "[", 
      RowBox[{
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"k", "-", "1"}], "n"]}], ",", 
       RowBox[{"k", "-", "1"}]}], "]"}], 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"k", "-", "1"}], ")"}], " ", "2", " ", "\[Pi]", " ", 
        "\[ImaginaryI]", " ", "m"}], "n"]], " ", 
     SuperscriptBox["t", "k"], " ", 
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{
        FractionBox[
         RowBox[{"k", "-", "1"}], "n"], "+", 
        FractionBox[
         RowBox[{"Range", "[", "n", "]"}], 
         RowBox[{"n", "+", "1"}]]}], ",", 
       FractionBox[
        RowBox[{"Delete", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"k", "+", "1"}], ",", 
            RowBox[{"k", "+", "n"}]}], "]"}], ",", 
          RowBox[{"n", "-", "k"}]}], "]"}], "n"], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}], " ", "t"}], "n"], ")"}], 
         "n"]}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", 
      RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300023025],

Cell[TextData[{
 "First root of the quintic ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "==", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->907437861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "[", 
   RowBox[{"1", ",", "4", ",", "1"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59221943],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{461, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->805777636]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->36485295],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.18123244446987538390180026684094460892`19.367753129139917"}], "-", 
  RowBox[{
  "1.08395410131771066843034449856088307565`20.14452807380574", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->189429018]
}, Open  ]],

Cell["Check the solution:", "ExampleText",
 CellID->444207057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", "x", "+", "1"}], "\[Equal]", "0"}], "/.", 
  RowBox[{"x", "\[Rule]", "%"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->321436577],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->451924123]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76315272],

Cell["\<\
Effective confining potential in random matrix theory for a Gaussian density \
of states:\
\>", "ExampleText",
 CellID->133479147],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"x", "^", "2"}], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"3", "/", "2"}]}], "}"}], ",", 
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}]}], "]"}]}]}]], "Input",
 CellTags->"Ex--21909464764120058037,4",
 CellLabel->"In[1]:=",
 CellID->55089395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"v", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21909464764120058037,5",
 CellLabel->"In[2]:=",
 CellID->68033245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909464764120058037,5",
 CellLabel->"Out[2]=",
 CellID->80965160]
}, Open  ]],

Cell["Expansion at infinity reveals logarithmic growth:", "ExampleText",
 CellID->141749617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"v", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "\[Infinity]", ",", "3"}], "}"}]}], "]"}], "//", 
  "Expand"}]], "Input",
 CellTags->"Ex--21909464764120058037,6",
 CellLabel->"In[3]:=",
 CellID->775001983],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox["x", "2"]}]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["\[Pi]"]}], 
       RowBox[{"2", " ", "x"}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "2"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 1, 2, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {Complex[0, 
         Rational[1, 2]] Pi^Rational[1, 2]}, 1, 2, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Log", "[", 
         FractionBox["1", "x"], "]"}]}], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"PolyGamma", "[", 
         RowBox[{"0", ",", 
          FractionBox["1", "2"]}], "]"}]}]}], ")"}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "2"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 0, 2, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[
     1], {-Log[$CellContext`x^(-1)] + Rational[-1, 2] PolyGamma[0, 
         Rational[1, 2]]}, 0, 2, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{412, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909464764120058037,6",
 CellLabel->"Out[3]=",
 CellID->362636453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->936103718],

Cell[TextData[{
 "Surface tension of an electrolyte solution as a function of concentration \
",
 Cell[BoxData["y"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->62488158],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"BesselK", "[", 
     RowBox[{"0", ",", 
      RowBox[{"2", 
       SqrtBox["y"]}]}], "]"}], 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2", "/", "3"}], ",", 
        RowBox[{"5", "/", "3"}]}], "}"}], ",", "y"}], "]"}]}], "+", 
   RowBox[{"3", 
    SqrtBox["y"], 
    RowBox[{"BesselK", "[", 
     RowBox[{"1", ",", 
      RowBox[{"2", 
       SqrtBox["y"]}]}], "]"}], 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"5", "/", "3"}], ",", 
        RowBox[{"5", "/", "3"}]}], "}"}], ",", "y"}], "]"}]}]}], 
  ";"}]], "Input",
 CellTags->"Ex--21909464764120058037,7",
 CellLabel->"In[1]:=",
 CellID->488554595],

Cell["Onsager law for small concentrations:", "ExampleText",
 CellID->156183595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Series", "[", 
   RowBox[{"%", ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"y", ">", "0"}]}]}], "]"}], "]"}]], "Input",
 CellTags->"Ex--21909464764120058037,9",
 CellLabel->"In[2]:=",
 CellID->826977863],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "2"], "-", 
  RowBox[{"2", " ", "EulerGamma"}], "-", 
  RowBox[{"Log", "[", "y", "]"}]}]], "Output",
 ImageSize->{163, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909464764120058037,9",
 CellLabel->"Out[2]=",
 CellID->508049902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->796111719],

Cell[TextData[{
 "Fractional derivative of ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->731491295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ScriptCapitalD]", "[", 
   RowBox[{"z_", ",", "m_"}], "]"}], "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"z", "-", "t"}], ")"}], 
      RowBox[{
       RowBox[{"-", "m"}], "-", "1"}]], " ", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], "/", 
      RowBox[{"Gamma", "[", 
       RowBox[{"-", "m"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "z"}], "}"}], ",", 
    RowBox[{"GenerateConditions", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351832436],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["z", 
    RowBox[{"1", "-", "m"}]], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "-", 
        FractionBox["m", "2"]}], ",", 
       RowBox[{
        FractionBox["3", "2"], "-", 
        FractionBox["m", "2"]}]}], "}"}], ",", 
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["z", "2"], "4"]}]}], "]"}]}], 
  RowBox[{"Gamma", "[", 
   RowBox[{"2", "-", "m"}], "]"}]]], "Output",
 ImageSize->{322, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30599574]
}, Open  ]],

Cell[TextData[{
 "Derivative of order ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     StyleBox["1",
      FontSlant->"Plain"], "/", 
     StyleBox["2",
      FontSlant->"Plain"]}],
    FontSize->11], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1426540423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalD]", "[", 
    RowBox[{"z", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], "//", "FunctionExpand"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "z", "]"}], " ", 
     RowBox[{"FresnelC", "[", 
      RowBox[{
       SqrtBox[
        FractionBox["2", "\[Pi]"]], " ", 
       SqrtBox["z"]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"FresnelS", "[", 
      RowBox[{
       SqrtBox[
        FractionBox["2", "\[Pi]"]], " ", 
       SqrtBox["z"]}], "]"}], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{406, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->565473046]
}, Open  ]],

Cell[TextData[{
 "Plot smooth transition between derivative and integral of ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->235848200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"\[ScriptCapitalD]", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->133703370]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " frequently returns results containing ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14465064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "]"}], " ", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->759115233],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       FractionBox["1", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     RowBox[{"-", 
      SuperscriptBox["x", "2"]}]}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"Erf", "[", "x", "]"}], " ", 
   RowBox[{"Log", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{434, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35659081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130585083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " may return results containing ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->690065464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "k"}], ")"}], "!"}], 
    RowBox[{" ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", "k"}], "+", "3"}], ")"}], "!"}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21909537627048908038,2",
 CellLabel->"In[1]:=",
 CellID->259105983],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox["1", "2"], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["5", "4"], ",", 
      FractionBox["3", "2"], ",", 
      FractionBox["7", "4"]}], "}"}], ",", 
    FractionBox["1", "64"]}], "]"}]}]], "Output",
 ImageSize->{305, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909537627048908038,2",
 CellLabel->"Out[1]=",
 CellID->349751842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->391736987],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to transform ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " into less general functions:"
}], "ExampleText",
 CellID->29693092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     FractionBox["3", "2"], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,11",
 CellLabel->"In[1]:=",
 CellID->199987598],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", 
     SqrtBox["x"]}], "]"}], "2"], "+", 
  RowBox[{"2", " ", 
   SqrtBox["x"], " ", 
   RowBox[{"BesselI", "[", 
    RowBox[{"0", ",", 
     SqrtBox["x"]}], "]"}], " ", 
   RowBox[{"BesselI", "[", 
    RowBox[{"1", ",", 
     SqrtBox["x"]}], "]"}]}]}]], "Output",
 ImageSize->{378, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,11",
 CellLabel->"Out[1]=",
 CellID->399354598]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7965],

Cell["\<\
Machine-precision input may be insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->261346315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "10"}], "}"}], ",", 
   RowBox[{"{", "50", "}"}], ",", "2."}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,1",
 CellLabel->"In[1]:=",
 CellID->195419232],

Cell[BoxData[
 RowBox[{"8325.43376253079`", "\[InvisibleSpace]", "-", 
  RowBox[{"89349.2191426232`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,1",
 CellLabel->"Out[1]=",
 CellID->436043105]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->223438727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}], ",", 
     RowBox[{"{", "50", "}"}], ",", "2"}], "]"}], ",", "20"}], "]"}]], "Input",\

 CellTags->"Ex--21909550694777321124,2",
 CellLabel->"In[2]:=",
 CellID->113978531],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1705.75733163554444165511846492089`20.141218526914436"}], "-",
   
  RowBox[{
  "356.74998605602381752712233174575`19.461665245098622", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{323, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,2",
 CellLabel->"Out[2]=",
 CellID->728637839]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->824180012],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may be insufficient to obtain the requested precision:"
}], "ExampleText",
 CellID->339276152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", "150", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "3"], ",", 
       FractionBox["1", "3"]}], "}"}], ",", "1000"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,7",
 CellLabel->"In[1]:=",
 CellID->20037702],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(HypergeometricPFQ[\\(\\(\\(\\({150}\\)\\), \\(\
\\({1\\/3, 1\\/3}\\)\\), 1000\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"Ex--21909550694777321124,7",
 CellID->470704907],

Cell[BoxData["0``-77.4442431209792"], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,7",
 CellLabel->"Out[1]=",
 CellID->10462024]
}, Open  ]],

Cell[TextData[{
 "A larger setting of ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may be needed:"
}], "ExampleText",
 CellID->98508696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "80"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"HypergeometricPFQ", "[", 
      RowBox[{
       RowBox[{"{", "150", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "3"], ",", 
         FractionBox["1", "3"]}], "}"}], ",", "1000"}], "]"}], ",", "20"}], 
    "]"}]}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,10",
 CellLabel->"In[2]:=",
 CellID->197741988],

Cell[BoxData["4.6069297578415525645711401890915315`20.*^73"], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,10",
 CellLabel->"Out[2]=",
 CellID->488734359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114612974],

Cell[TextData[{
 "Common symbolic parameters in ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " generically cancel:"
}], "ExampleText",
 CellID->9108377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d", ",", "e"}], "}"}], ",", "z"}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,5",
 CellLabel->"In[1]:=",
 CellID->738901432],

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e"}], "}"}], ",", "z"}], "]"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,5",
 CellLabel->"Out[1]=",
 CellID->296622191]
}, Open  ]],

Cell[TextData[{
 "However, when there is a negative integer among common elements, ",
 Cell[BoxData[
  ButtonBox["HypergeometricPFQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricPFQ"]], "InlineFormula"],
 " is interpreted as a polynomial:"
}], "ExampleText",
 CellID->109885060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "d", ",", "e"}], "}"}], ",", "z"}], 
  "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,6",
 CellLabel->"In[2]:=",
 CellID->329348572],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"a", " ", "b", " ", "c", " ", "z"}], 
   RowBox[{"d", " ", "e"}]], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "a"}], ")"}], " ", "b", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "b"}], ")"}], " ", "c", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "c"}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], 
   RowBox[{"2", " ", "d", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "d"}], ")"}], " ", "e", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "e"}], ")"}]}]]}]], "Output",
 ImageSize->{255, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,6",
 CellLabel->"Out[2]=",
 CellID->389029687]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30284],

Cell[TextData[{
 "The period of an anharmonic oscillator with Hamiltonian ",
 Cell[BoxData[
  FormBox[
   RowBox[{"H", "=", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], 
      SuperscriptBox["p", "2"]}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      SuperscriptBox["\[Omega]", "2"], 
      SuperscriptBox["q", "2"]}], "+", 
     RowBox[{
      SuperscriptBox["\[Lambda]", "2"], " ", 
      SuperscriptBox["q", 
       RowBox[{"2", "n"}]]}]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->68886930],

Cell[BoxData[
 RowBox[{
  RowBox[{"period", "[", 
   RowBox[{
   "n_", ",", "\[ScriptCapitalE]_", ",", "\[Lambda]_", ",", "\[Omega]_"}], 
   "]"}], ":=", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "\[Pi]"}], "\[Omega]"], 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{"n", "-", 
         RowBox[{"1", "/", "2"}]}]}], "]"}], "/", "n"}], ",", " ", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"2", "n"}], 
          SuperscriptBox["\[Omega]", "2"]], ")"}], "n"]}], 
      FractionBox[
       RowBox[{"\[Lambda]", " ", 
        SuperscriptBox["\[ScriptCapitalE]", 
         RowBox[{"n", "-", "1"}]]}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"n", "-", "1"}], ")"}], 
        RowBox[{"n", "-", "1"}]]]}]}], "]"}]}]}]], "Input",
 CellTags->"Ex--21909464764120058037,11",
 CellLabel->"In[1]:=",
 CellID->50543935],

Cell["Period for quartic anharmonicity:", "ExampleText",
 CellID->119490153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"period", "[", 
  RowBox[{"2", ",", "\[ScriptCapitalE]", ",", "\[Lambda]", ",", "\[Omega]"}], 
  "]"}]], "Input",
 CellTags->"Ex--21909464764120058037,12",
 CellLabel->"In[2]:=",
 CellID->101130295],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"EllipticK", "[", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"16", " ", "\[ScriptCapitalE]", " ", "\[Lambda]"}], 
         SuperscriptBox["\[Omega]", "4"]]}]]}], 
     RowBox[{"2", " ", 
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox[
         RowBox[{"16", " ", "\[ScriptCapitalE]", " ", "\[Lambda]"}], 
         SuperscriptBox["\[Omega]", "4"]]}]]}]], "]"}]}], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"16", " ", "\[ScriptCapitalE]", " ", "\[Lambda]"}], 
       SuperscriptBox["\[Omega]", "4"]]}], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", "\[Omega]"}]]], "Output",
 ImageSize->{168, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909464764120058037,12",
 CellLabel->"Out[2]=",
 CellID->465569120]
}, Open  ]],

Cell["Limit of pure quartic potential:", "ExampleText",
 CellID->115767085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\[Omega]", "->", "0"}]}], "]"}]], "Input",
 CellTags->"Ex--21909464764120058037,13",
 CellLabel->"In[3]:=",
 CellID->212738071],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Pi]", 
   RowBox[{"3", "/", "2"}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"\[ScriptCapitalE]", " ", "\[Lambda]"}], ")"}], 
    RowBox[{"1", "/", "4"}]], " ", 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     FractionBox["3", "4"], "]"}], "2"]}]]], "Output",
 ImageSize->{123, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909464764120058037,13",
 CellLabel->"Out[3]=",
 CellID->187400465]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30804],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeijerG",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeijerG"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric0F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric0F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric1F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric2F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric2F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AppellF1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AppellF1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricPFQRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricPFQRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HypergeometricDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31119]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26613],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->16696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->12389],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/GeneralizedHypergeometricFunction.html"],
    None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/\
Hypergeometric0F0/"], None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
HypergeometricPFQ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->268786098],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->23565047],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->65896724],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->741485799],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->200167865],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->283338501]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HypergeometricPFQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 47, 58.6948396}", "context" -> "System`", 
    "keywords" -> {
     "Barnes extended hypergeometric function", 
      "generalized hypergeometric function", "0F0", "1F0", "1F2", "2F2", 
      "2F3", "3F2", "4F3", "5F4", "6F5", "pfq", "hypergeom"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HypergeometricPFQ[{a_1, ..., a_p}, {b_1, ..., b_q}, z] is the \
generalized hypergeometric function \\[Null]_pF_q (a; b; z). ", 
    "synonyms" -> {"hypergeometric pfq"}, "title" -> "HypergeometricPFQ", 
    "type" -> "Symbol", "uri" -> "ref/HypergeometricPFQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9601, 313, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->34014979]},
 "Ex--21909537627048908038,1"->{
  Cell[37473, 1232, 381, 13, 70, "Input",
   CellTags->"Ex--21909537627048908038,1",
   CellID->4981847],
  Cell[37857, 1247, 1753, 57, 133, "Output",
   CellTags->"Ex--21909537627048908038,1",
   CellID->343591604]},
 "Ex--21909464764120058037,4"->{
  Cell[47511, 1531, 471, 16, 70, "Input",
   CellTags->"Ex--21909464764120058037,4",
   CellID->55089395]},
 "Ex--21909464764120058037,5"->{
  Cell[48007, 1551, 251, 8, 70, "Input",
   CellTags->"Ex--21909464764120058037,5",
   CellID->68033245],
  Cell[48261, 1561, 2347, 43, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21909464764120058037,5",
   CellID->80965160]},
 "Ex--21909464764120058037,6"->{
  Cell[50740, 1612, 300, 10, 70, "Input",
   CellTags->"Ex--21909464764120058037,6",
   CellID->775001983],
  Cell[51043, 1624, 1649, 54, 61, "Output",
   CellTags->"Ex--21909464764120058037,6",
   CellID->362636453]},
 "Ex--21909464764120058037,7"->{
  Cell[53015, 1694, 872, 31, 70, "Input",
   CellTags->"Ex--21909464764120058037,7",
   CellID->488554595]},
 "Ex--21909464764120058037,9"->{
  Cell[53995, 1732, 338, 10, 70, "Input",
   CellTags->"Ex--21909464764120058037,9",
   CellID->826977863],
  Cell[54336, 1744, 315, 10, 51, "Output",
   CellTags->"Ex--21909464764120058037,9",
   CellID->508049902]},
 "Ex--21909537627048908038,2"->{
  Cell[76478, 2264, 439, 16, 70, "Input",
   CellTags->"Ex--21909537627048908038,2",
   CellID->259105983],
  Cell[76920, 2282, 557, 19, 51, "Output",
   CellTags->"Ex--21909537627048908038,2",
   CellID->349751842]},
 "Ex--21909550694777321124,11"->{
  Cell[78027, 2326, 330, 10, 70, "Input",
   CellTags->"Ex--21909550694777321124,11",
   CellID->199987598],
  Cell[78360, 2338, 528, 19, 44, "Output",
   CellTags->"Ex--21909550694777321124,11",
   CellID->399354598]},
 "Ex--21909550694777321124,1"->{
  Cell[79309, 2379, 264, 8, 70, "Input",
   CellTags->"Ex--21909550694777321124,1",
   CellID->195419232],
  Cell[79576, 2389, 310, 8, 36, "Output",
   CellTags->"Ex--21909550694777321124,1",
   CellID->436043105]},
 "Ex--21909550694777321124,2"->{
  Cell[80009, 2405, 326, 11, 70, "Input",
   CellTags->"Ex--21909550694777321124,2",
   CellID->113978531],
  Cell[80338, 2418, 388, 12, 36, "Output",
   CellTags->"Ex--21909550694777321124,2",
   CellID->728637839]},
 "Ex--21909550694777321124,7"->{
  Cell[81163, 2450, 380, 13, 70, "Input",
   CellTags->"Ex--21909550694777321124,7",
   CellID->20037702],
  Cell[81546, 2465, 540, 10, 70, "Message",
   CellTags->"Ex--21909550694777321124,7",
   CellID->470704907],
  Cell[82089, 2477, 217, 6, 36, "Output",
   CellTags->"Ex--21909550694777321124,7",
   CellID->10462024]},
 "Ex--21909550694777321124,10"->{
  Cell[82582, 2498, 523, 17, 70, "Input",
   CellTags->"Ex--21909550694777321124,10",
   CellID->197741988],
  Cell[83108, 2517, 244, 6, 36, "Output",
   CellTags->"Ex--21909550694777321124,10",
   CellID->488734359]},
 "Ex--21909550694777321124,5"->{
  Cell[83768, 2543, 305, 9, 70, "Input",
   CellTags->"Ex--21909550694777321124,5",
   CellID->738901432],
  Cell[84076, 2554, 374, 12, 36, "Output",
   CellTags->"Ex--21909550694777321124,5",
   CellID->296622191]},
 "Ex--21909550694777321124,6"->{
  Cell[84787, 2581, 360, 12, 70, "Input",
   CellTags->"Ex--21909550694777321124,6",
   CellID->329348572],
  Cell[85150, 2595, 751, 24, 56, "Output",
   CellTags->"Ex--21909550694777321124,6",
   CellID->389029687]},
 "Ex--21909464764120058037,11"->{
  Cell[86723, 2655, 1186, 39, 70, "Input",
   CellTags->"Ex--21909464764120058037,11",
   CellID->50543935]},
 "Ex--21909464764120058037,12"->{
  Cell[88013, 2701, 221, 6, 70, "Input",
   CellTags->"Ex--21909464764120058037,12",
   CellID->101130295],
  Cell[88237, 2709, 981, 31, 110, "Output",
   CellTags->"Ex--21909464764120058037,12",
   CellID->465569120]},
 "Ex--21909464764120058037,13"->{
  Cell[89333, 2748, 198, 6, 70, "Input",
   CellTags->"Ex--21909464764120058037,13",
   CellID->212738071],
  Cell[89534, 2756, 504, 17, 64, "Output",
   CellTags->"Ex--21909464764120058037,13",
   CellID->187400465]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 96386, 2987},
 {"Ex--21909537627048908038,1", 96538, 2991},
 {"Ex--21909464764120058037,4", 96789, 2998},
 {"Ex--21909464764120058037,5", 96930, 3002},
 {"Ex--21909464764120058037,6", 97202, 3010},
 {"Ex--21909464764120058037,7", 97454, 3017},
 {"Ex--21909464764120058037,9", 97596, 3021},
 {"Ex--21909537627048908038,2", 97847, 3028},
 {"Ex--21909550694777321124,11", 98099, 3035},
 {"Ex--21909550694777321124,1", 98352, 3042},
 {"Ex--21909550694777321124,2", 98601, 3049},
 {"Ex--21909550694777321124,7", 98852, 3056},
 {"Ex--21909550694777321124,10", 99211, 3066},
 {"Ex--21909550694777321124,5", 99463, 3073},
 {"Ex--21909550694777321124,6", 99713, 3080},
 {"Ex--21909464764120058037,11", 99965, 3087},
 {"Ex--21909464764120058037,12", 100109, 3091},
 {"Ex--21909464764120058037,13", 100363, 3098}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3256, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3879, 98, 54, 1, 70, "ObjectName",
 CellID->7666],
Cell[3936, 101, 1348, 42, 70, "Usage",
 CellID->12360]
}, Open  ]],
Cell[CellGroupData[{
Cell[5321, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5799, 165, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5922, 171, 994, 36, 70, "Notes",
 CellID->22385],
Cell[6919, 209, 642, 22, 70, "Notes",
 CellID->4001],
Cell[7564, 233, 261, 8, 70, "Notes",
 CellID->13485],
Cell[7828, 243, 265, 8, 70, "Notes",
 CellID->23803685],
Cell[8096, 253, 236, 7, 70, "Notes",
 CellID->31226],
Cell[8335, 262, 732, 27, 70, "Notes",
 CellID->11619],
Cell[9070, 291, 494, 17, 70, "Notes",
 CellID->22946]
}, Closed]],
Cell[CellGroupData[{
Cell[9601, 313, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34014979],
Cell[CellGroupData[{
Cell[9985, 327, 147, 5, 70, "ExampleSection",
 CellID->23090018],
Cell[10135, 334, 63, 1, 70, "ExampleText",
 CellID->15626725],
Cell[CellGroupData[{
Cell[10223, 339, 254, 8, 28, "Input",
 CellID->46805490],
Cell[10480, 349, 174, 5, 36, "Output",
 CellID->19058315]
}, Open  ]],
Cell[10669, 357, 124, 3, 70, "ExampleDelimiter",
 CellID->39059744],
Cell[10796, 362, 1571, 58, 70, "ExampleText",
 CellID->3416506],
Cell[CellGroupData[{
Cell[12392, 424, 406, 13, 70, "Input",
 CellID->144039159],
Cell[12801, 439, 2236, 46, 158, "Output",
 CellID->30608735]
}, Open  ]],
Cell[15052, 488, 124, 3, 70, "ExampleDelimiter",
 CellID->12256083],
Cell[15179, 493, 65, 1, 70, "ExampleText",
 CellID->385353294],
Cell[CellGroupData[{
Cell[15269, 498, 253, 8, 70, "Input",
 CellID->62931415],
Cell[15525, 508, 671, 24, 52, "Output",
 CellID->101612774]
}, Open  ]],
Cell[16211, 535, 125, 3, 70, "ExampleDelimiter",
 CellID->419437541],
Cell[16339, 540, 64, 1, 70, "ExampleText",
 CellID->116440374],
Cell[CellGroupData[{
Cell[16428, 545, 390, 12, 70, "Input",
 CellID->304251267],
Cell[16821, 559, 1344, 39, 60, "Output",
 CellID->221492543]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18214, 604, 216, 7, 70, "ExampleSection",
 CellID->19295],
Cell[18433, 613, 88, 1, 70, "ExampleText",
 CellID->25356769],
Cell[CellGroupData[{
Cell[18546, 618, 310, 10, 70, "Input",
 CellID->535205823],
Cell[18859, 630, 275, 7, 36, "Output",
 CellID->634307891]
}, Open  ]],
Cell[19149, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->193374817],
Cell[19277, 645, 70, 1, 70, "ExampleText",
 CellID->471261392],
Cell[CellGroupData[{
Cell[19372, 650, 415, 14, 70, "Input",
 CellID->174086697],
Cell[19790, 666, 225, 6, 36, "Output",
 CellID->56147581]
}, Open  ]],
Cell[20030, 675, 125, 3, 70, "ExampleDelimiter",
 CellID->132487969],
Cell[20158, 680, 113, 3, 70, "ExampleText",
 CellID->182436018],
Cell[CellGroupData[{
Cell[20296, 687, 373, 12, 70, "Input",
 CellID->633130590],
Cell[20672, 701, 220, 6, 36, "Output",
 CellID->35231424]
}, Open  ]],
Cell[20907, 710, 125, 3, 70, "ExampleDelimiter",
 CellID->384533180],
Cell[21035, 715, 257, 7, 70, "ExampleText",
 CellID->17939029],
Cell[CellGroupData[{
Cell[21317, 726, 352, 11, 70, "Input",
 CellID->395261281],
Cell[21672, 739, 274, 9, 36, "Output",
 CellID->57595094]
}, Open  ]],
Cell[21961, 751, 124, 3, 70, "ExampleDelimiter",
 CellID->12674930],
Cell[22088, 756, 255, 8, 70, "ExampleText",
 CellID->990591914],
Cell[CellGroupData[{
Cell[22368, 768, 254, 8, 70, "Input",
 CellID->902813491],
Cell[22625, 778, 579, 21, 52, "Output",
 CellID->114939813]
}, Open  ]],
Cell[23219, 802, 125, 3, 70, "ExampleDelimiter",
 CellID->499110381],
Cell[23347, 807, 378, 12, 70, "ExampleText",
 CellID->46310469],
Cell[CellGroupData[{
Cell[23750, 823, 265, 9, 70, "Input",
 CellID->571628789],
Cell[24018, 834, 1050, 36, 56, "Output",
 CellID->45569837]
}, Open  ]],
Cell[25083, 873, 125, 3, 70, "ExampleDelimiter",
 CellID->405280366],
Cell[25211, 878, 203, 7, 70, "ExampleText",
 CellID->110583574],
Cell[CellGroupData[{
Cell[25439, 889, 429, 15, 70, "Input",
 CellID->49909376],
Cell[25871, 906, 753, 16, 70, "Output",
 Evaluatable->False,
 CellID->765635043]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26673, 928, 239, 7, 70, "ExampleSection",
 CellID->32652],
Cell[26915, 937, 465, 17, 70, "ExampleText",
 CellID->464617087],
Cell[CellGroupData[{
Cell[27405, 958, 497, 16, 70, "Input",
 CellID->372551981],
Cell[27905, 976, 3701, 115, 162, "Output",
 CellID->314684811]
}, Open  ]],
Cell[31621, 1094, 124, 3, 70, "ExampleDelimiter",
 CellID->86688944],
Cell[31748, 1099, 333, 12, 70, "ExampleText",
 CellID->90865036],
Cell[CellGroupData[{
Cell[32106, 1115, 541, 18, 70, "Input",
 CellID->29843557],
Cell[32650, 1135, 4430, 77, 70, "Output",
 Evaluatable->False,
 CellID->215117929]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37129, 1218, 220, 7, 70, "ExampleSection",
 CellID->90],
Cell[37352, 1227, 96, 1, 70, "ExampleText",
 CellID->127429397],
Cell[CellGroupData[{
Cell[37473, 1232, 381, 13, 70, "Input",
 CellTags->"Ex--21909537627048908038,1",
 CellID->4981847],
Cell[37857, 1247, 1753, 57, 133, "Output",
 CellTags->"Ex--21909537627048908038,1",
 CellID->343591604]
}, Open  ]],
Cell[39625, 1307, 125, 3, 70, "ExampleDelimiter",
 CellID->206334130],
Cell[39753, 1312, 292, 11, 70, "ExampleText",
 CellID->332234312],
Cell[40048, 1325, 1684, 54, 70, "Input",
 CellID->300023025],
Cell[41735, 1381, 245, 10, 70, "ExampleText",
 CellID->907437861],
Cell[CellGroupData[{
Cell[42005, 1395, 171, 6, 70, "Input",
 CellID->59221943],
Cell[42179, 1403, 4051, 70, 70, "Output",
 Evaluatable->False,
 CellID->805777636]
}, Open  ]],
Cell[CellGroupData[{
Cell[46267, 1478, 120, 4, 70, "Input",
 CellID->36485295],
Cell[46390, 1484, 359, 11, 36, "Output",
 CellID->189429018]
}, Open  ]],
Cell[46764, 1498, 62, 1, 70, "ExampleText",
 CellID->444207057],
Cell[CellGroupData[{
Cell[46851, 1503, 211, 7, 70, "Input",
 CellID->321436577],
Cell[47065, 1512, 161, 5, 36, "Output",
 CellID->451924123]
}, Open  ]],
Cell[47241, 1520, 124, 3, 70, "ExampleDelimiter",
 CellID->76315272],
Cell[47368, 1525, 140, 4, 70, "ExampleText",
 CellID->133479147],
Cell[47511, 1531, 471, 16, 70, "Input",
 CellTags->"Ex--21909464764120058037,4",
 CellID->55089395],
Cell[CellGroupData[{
Cell[48007, 1551, 251, 8, 70, "Input",
 CellTags->"Ex--21909464764120058037,5",
 CellID->68033245],
Cell[48261, 1561, 2347, 43, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21909464764120058037,5",
 CellID->80965160]
}, Open  ]],
Cell[50623, 1607, 92, 1, 70, "ExampleText",
 CellID->141749617],
Cell[CellGroupData[{
Cell[50740, 1612, 300, 10, 70, "Input",
 CellTags->"Ex--21909464764120058037,6",
 CellID->775001983],
Cell[51043, 1624, 1649, 54, 61, "Output",
 CellTags->"Ex--21909464764120058037,6",
 CellID->362636453]
}, Open  ]],
Cell[52707, 1681, 125, 3, 70, "ExampleDelimiter",
 CellID->936103718],
Cell[52835, 1686, 177, 6, 70, "ExampleText",
 CellID->62488158],
Cell[53015, 1694, 872, 31, 70, "Input",
 CellTags->"Ex--21909464764120058037,7",
 CellID->488554595],
Cell[53890, 1727, 80, 1, 70, "ExampleText",
 CellID->156183595],
Cell[CellGroupData[{
Cell[53995, 1732, 338, 10, 70, "Input",
 CellTags->"Ex--21909464764120058037,9",
 CellID->826977863],
Cell[54336, 1744, 315, 10, 51, "Output",
 CellTags->"Ex--21909464764120058037,9",
 CellID->508049902]
}, Open  ]],
Cell[54666, 1757, 125, 3, 70, "ExampleDelimiter",
 CellID->796111719],
Cell[54794, 1762, 198, 8, 70, "ExampleText",
 CellID->731491295],
Cell[CellGroupData[{
Cell[55017, 1774, 621, 20, 70, "Input",
 CellID->351832436],
Cell[55641, 1796, 678, 24, 64, "Output",
 CellID->30599574]
}, Open  ]],
Cell[56334, 1823, 408, 18, 70, "ExampleText",
 CellID->1426540423],
Cell[CellGroupData[{
Cell[56767, 1845, 220, 7, 70, "Input"],
Cell[56990, 1854, 616, 23, 63, "Output",
 CellID->565473046]
}, Open  ]],
Cell[57621, 1880, 231, 8, 70, "ExampleText",
 CellID->235848200],
Cell[CellGroupData[{
Cell[57877, 1892, 346, 11, 70, "Input"],
Cell[58226, 1905, 16101, 268, 70, "Output",
 Evaluatable->False,
 CellID->133703370]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74376, 2179, 233, 7, 70, "ExampleSection",
 CellID->12747],
Cell[74612, 2188, 360, 12, 70, "ExampleText",
 CellID->14465064],
Cell[CellGroupData[{
Cell[74997, 2204, 264, 9, 70, "Input",
 CellID->759115233],
Cell[75264, 2215, 705, 25, 51, "Output",
 CellID->35659081]
}, Open  ]],
Cell[75984, 2243, 125, 3, 70, "ExampleDelimiter",
 CellID->130585083],
Cell[76112, 2248, 341, 12, 70, "ExampleText",
 CellID->690065464],
Cell[CellGroupData[{
Cell[76478, 2264, 439, 16, 70, "Input",
 CellTags->"Ex--21909537627048908038,2",
 CellID->259105983],
Cell[76920, 2282, 557, 19, 51, "Output",
 CellTags->"Ex--21909537627048908038,2",
 CellID->349751842]
}, Open  ]],
Cell[77492, 2304, 125, 3, 70, "ExampleDelimiter",
 CellID->391736987],
Cell[77620, 2309, 382, 13, 70, "ExampleText",
 CellID->29693092],
Cell[CellGroupData[{
Cell[78027, 2326, 330, 10, 70, "Input",
 CellTags->"Ex--21909550694777321124,11",
 CellID->199987598],
Cell[78360, 2338, 528, 19, 44, "Output",
 CellTags->"Ex--21909550694777321124,11",
 CellID->399354598]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[78937, 2363, 225, 7, 70, "ExampleSection",
 CellID->7965],
Cell[79165, 2372, 119, 3, 70, "ExampleText",
 CellID->261346315],
Cell[CellGroupData[{
Cell[79309, 2379, 264, 8, 70, "Input",
 CellTags->"Ex--21909550694777321124,1",
 CellID->195419232],
Cell[79576, 2389, 310, 8, 36, "Output",
 CellTags->"Ex--21909550694777321124,1",
 CellID->436043105]
}, Open  ]],
Cell[79901, 2400, 83, 1, 70, "ExampleText",
 CellID->223438727],
Cell[CellGroupData[{
Cell[80009, 2405, 326, 11, 70, "Input",
 CellTags->"Ex--21909550694777321124,2",
 CellID->113978531],
Cell[80338, 2418, 388, 12, 36, "Output",
 CellTags->"Ex--21909550694777321124,2",
 CellID->728637839]
}, Open  ]],
Cell[80741, 2433, 125, 3, 70, "ExampleDelimiter",
 CellID->824180012],
Cell[80869, 2438, 269, 8, 70, "ExampleText",
 CellID->339276152],
Cell[CellGroupData[{
Cell[81163, 2450, 380, 13, 70, "Input",
 CellTags->"Ex--21909550694777321124,7",
 CellID->20037702],
Cell[81546, 2465, 540, 10, 70, "Message",
 CellTags->"Ex--21909550694777321124,7",
 CellID->470704907],
Cell[82089, 2477, 217, 6, 36, "Output",
 CellTags->"Ex--21909550694777321124,7",
 CellID->10462024]
}, Open  ]],
Cell[82321, 2486, 236, 8, 70, "ExampleText",
 CellID->98508696],
Cell[CellGroupData[{
Cell[82582, 2498, 523, 17, 70, "Input",
 CellTags->"Ex--21909550694777321124,10",
 CellID->197741988],
Cell[83108, 2517, 244, 6, 36, "Output",
 CellTags->"Ex--21909550694777321124,10",
 CellID->488734359]
}, Open  ]],
Cell[83367, 2526, 125, 3, 70, "ExampleDelimiter",
 CellID->114612974],
Cell[83495, 2531, 248, 8, 70, "ExampleText",
 CellID->9108377],
Cell[CellGroupData[{
Cell[83768, 2543, 305, 9, 70, "Input",
 CellTags->"Ex--21909550694777321124,5",
 CellID->738901432],
Cell[84076, 2554, 374, 12, 36, "Output",
 CellTags->"Ex--21909550694777321124,5",
 CellID->296622191]
}, Open  ]],
Cell[84465, 2569, 297, 8, 70, "ExampleText",
 CellID->109885060],
Cell[CellGroupData[{
Cell[84787, 2581, 360, 12, 70, "Input",
 CellTags->"Ex--21909550694777321124,6",
 CellID->329348572],
Cell[85150, 2595, 751, 24, 56, "Output",
 CellTags->"Ex--21909550694777321124,6",
 CellID->389029687]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85950, 2625, 224, 7, 70, "ExampleSection",
 CellID->30284],
Cell[86177, 2634, 543, 19, 70, "ExampleText",
 CellID->68886930],
Cell[86723, 2655, 1186, 39, 70, "Input",
 CellTags->"Ex--21909464764120058037,11",
 CellID->50543935],
Cell[87912, 2696, 76, 1, 70, "ExampleText",
 CellID->119490153],
Cell[CellGroupData[{
Cell[88013, 2701, 221, 6, 70, "Input",
 CellTags->"Ex--21909464764120058037,12",
 CellID->101130295],
Cell[88237, 2709, 981, 31, 110, "Output",
 CellTags->"Ex--21909464764120058037,12",
 CellID->465569120]
}, Open  ]],
Cell[89233, 2743, 75, 1, 70, "ExampleText",
 CellID->115767085],
Cell[CellGroupData[{
Cell[89333, 2748, 198, 6, 70, "Input",
 CellTags->"Ex--21909464764120058037,13",
 CellID->212738071],
Cell[89534, 2756, 504, 17, 64, "Output",
 CellTags->"Ex--21909464764120058037,13",
 CellID->187400465]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90099, 2780, 311, 9, 70, "SeeAlsoSection",
 CellID->30804],
Cell[90413, 2791, 1804, 62, 70, "SeeAlso",
 CellID->31119]
}, Open  ]],
Cell[CellGroupData[{
Cell[92254, 2858, 314, 9, 70, "TutorialsSection",
 CellID->26613],
Cell[92571, 2869, 144, 3, 70, "Tutorials",
 CellID->16696]
}, Open  ]],
Cell[CellGroupData[{
Cell[92752, 2877, 321, 9, 70, "RelatedLinksSection",
 CellID->12389],
Cell[93076, 2888, 204, 4, 70, "RelatedLinks"],
Cell[93283, 2894, 211, 4, 70, "RelatedLinks"],
Cell[93497, 2900, 395, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93929, 2918, 319, 9, 70, "MoreAboutSection",
 CellID->268786098],
Cell[94251, 2929, 164, 3, 70, "MoreAbout",
 CellID->23565047],
Cell[94418, 2934, 158, 3, 70, "MoreAbout",
 CellID->65896724],
Cell[94579, 2939, 155, 3, 70, "MoreAbout",
 CellID->741485799],
Cell[94737, 2944, 145, 3, 70, "MoreAbout",
 CellID->200167865],
Cell[94885, 2949, 174, 3, 70, "MoreAbout",
 CellID->283338501]
}, Open  ]],
Cell[95074, 2955, 27, 0, 70, "History"],
Cell[95104, 2957, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

