(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58063,       1992]
NotebookOptionsPosition[     41980,       1491]
NotebookOutlinePosition[     49112,       1687]
CellTagsIndexPosition[     48189,       1664]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric1F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric1F1"], 
          "Hypergeometric0F1" :> 
          Documentation`HelpLookup["paclet:ref/Hypergeometric0F1"], 
          "WhittakerW" :> Documentation`HelpLookup["paclet:ref/WhittakerW"], 
          "ParabolicCylinderD" :> 
          Documentation`HelpLookup["paclet:ref/ParabolicCylinderD"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Hypergeometric1F1\"\>", 
       2->"\<\"Hypergeometric0F1\"\>", 3->"\<\"WhittakerW\"\>", 
       4->"\<\"ParabolicCylinderD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hypergeometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/HypergeometricFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Hypergeometric Functions\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HypergeometricU", "ObjectName",
 CellID->19652],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["HypergeometricU",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/HypergeometricU"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the confluent hypergeometric function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"U", "(", 
        RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23171]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"U", "(", 
    RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " has the integral representation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"U", "(", 
     RowBox[{"a", ",", "b", ",", "z"}], ")"}], "=", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"\[CapitalGamma]", "(", "a", ")"}]}], 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
      RowBox[{
       SuperscriptBox["e", 
        RowBox[{"-", "z", "t"}]], 
       SuperscriptBox["t", 
        RowBox[{"a", "-", "1"}]], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", "t"}], ")"}], 
        RowBox[{"b", "-", "a", "-", "1"}]], " ", "d", "\[InvisibleSpace]", 
       "t"}]}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29720],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["HypergeometricU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HypergeometricU"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7273],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->280483206],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38389222],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->257709352],

Cell["Evaluate numerically:", "ExampleText",
 CellID->462570374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", 
  RowBox[{"3", ",", "2", ",", "1."}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,1",
 CellLabel->"In[1]:=",
 CellID->7931550],

Cell[BoxData["0.10547895651520833`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,1",
 CellLabel->"Out[1]=",
 CellID->20282082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->483587298],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    TagBox["U",
     HypergeometricU], "(", 
    RowBox[{"3", ",", "2", ",", "x"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->7117380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"HypergeometricU", "[", 
    RowBox[{"3", ",", "2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,3",
 CellLabel->"In[1]:=",
 CellID->196029156],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVx384E3gAx/GFUejX/Kgnp/SDdlzN09GzOvd8Kj2yCxFCKi1LdBp1eVrn
chWPCJFyRWOt5UcsUZL8DLXKQ5OYcrqGJon8mvkR23374/28n9fKQ2G7D2tR
KBQ30vdnuoctolDkODlvnN5gLcOAjuLdU205/ulr6+OsksHh8V5RvJ4cTgHc
CJ1lMnSsdNpotFCOWJ9XCo95MpiO/bDParkcG0ReFZZ9bUhJa8h1cZCjpfU1
tTCnDec7LJHOkyNl25KN9LVtCOJ0HtswIkfz/YvjuvatYFucSilUdaGEZ7Su
d18L+hniIll/N5R8v0CDzmYw74kr7Dp6IGZpW3DMpSiTdSR0vv+I8Cbv8v2Z
jZB4iPxsmxVoXrJjYfLFBuhGpA80yXrR9yHg8rr4FzCY639U+PYT6CO/sMYl
Egi+liosXvZhuILnEO/yDJwzW6z6mz7jL5Xh4vR39SgL4HACavtxgmI4v1JQ
h9fFnkn6RV8goX242xRbCzNxeKTm/gD66qfbosKfQDm19sjN24NgTnoLXlFr
oBkyXJqQ/xUfdUKtotdVQepd9aCgYAhxptGjJ2MqcE0vxqrSdRi+bHZSl2k5
DjCfeD+XDuN6i5vh1bwyDKa+jKazRtDodXqzY+gjpNWGXC1sHAEz/3xN7vpS
rMgLy5C6jkKZMRDcPv8hwsu2CZwko3iaf6vIwKgEHXxxbLfzGJgbzh3INHkA
g4Ke0Na6Mdy2a0loZ97HiuNnndmblXC+YF+qPlYMF4MSXaNKJcSqM3E9giJs
kZbUL7MfB50+OGbTfg+uR1wCd5SNw9klO4kbXAiHR6zJBZtUsF3gKZOa3sWY
rXHiT8UqMD1Cs/d9LUBdVIRW2M8TOGi2lHqqJh9+KtEpvbsTKPJxdewquYMW
S2b35jWT4E0mm6dX5YHzYyDjSvYk5KndWxQ1uaja4x+5dfkUbO19RpQfcsDw
7b9jLJzCME8dsHo6G8HRTu2/mk1jLu2J5L/12YgJmjs958o04jyuUM8ev43H
5mxNv/E3pNRWj0UUivBQHattfekb4nSfdsfPEaHhgWN/0uIZbD983YG76xZq
LYIkiakzcHYL7PG/I8TZR97CLv1ZWPzruL/RRAjfVZ0H/JNm4f6exfY8cxMT
pQwzGz01blrEH8IXAXjanxvTotRw//Iy+dNAFmhrNrEtKRqw1pbv9FRk4g/u
HqX+aQ24N8q9dk/zMZiof9RkRoN49Ypzb3X5WBqz1diSWNruQqsk3h7Jq7Yj
9qDeEgmIM0J6aV7Evf7PJEHETk51FanE1kNDC8apfGRpTs9fNKuBybHWnMXE
u058LtJXa3Ct+q3yN20+/gyx8F9GnJG8MGE9cc5BH6o1cXIBdyWNeMbtmR+L
2K4+2+2dFh95NkKtuO8Omcg/QkxR+HpRNRpY7qL/HjOHD5vOZLUxcYG4RzuY
eM8bSd4a4mj35/ydxOJau1lHYnWInpRG7Ju1KOc8sV7nUXshhY/otB3uqcQz
gcHSGOLCxKhpIfEo41JIMLFO5IBbLXFp6u4sBjHjxOqpZuIh+gjTiHhvyF6R
nJiiVfZGpbmB2IOXXYeJM81zuR3ExT4vJjTEf0dWz6sm/h/E1HWH
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.6000000000000001, 0.05},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0.5, 2}, {0.02734276709054084, 0.34636167525982064`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,3",
 CellLabel->"Out[1]=",
 CellID->138881982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127075355],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->4255939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"HypergeometricU", "[", 
    RowBox[{"1", ",", "1", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,12",
 CellLabel->"In[1]:=",
 CellID->740501835],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "EulerGamma"}], "-", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "EulerGamma", "-", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      RowBox[{"2", " ", "EulerGamma"}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"Log", "[", "x", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "36"], " ", 
    RowBox[{"(", 
     RowBox[{"11", "-", 
      RowBox[{"6", " ", "EulerGamma"}], "-", 
      RowBox[{"6", " ", 
       RowBox[{"Log", "[", "x", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   0, {-EulerGamma - Log[$CellContext`x], 1 - EulerGamma - 
    Log[$CellContext`x], 
    Rational[1, 4] (3 - 2 EulerGamma - 2 Log[$CellContext`x]), 
    Rational[1, 36] (11 - 6 EulerGamma - 6 Log[$CellContext`x])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{500, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,12",
 CellLabel->"Out[1]=",
 CellID->702022511]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->583],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->719782760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", " ", 
  RowBox[{
   RowBox[{"3", "-", "I"}], ",", " ", 
   RowBox[{"2", "I"}], ",", " ", "3.0"}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,4",
 CellLabel->"In[1]:=",
 CellID->198543373],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0052653933206882`"}], "+", 
  RowBox[{"0.0007931661643468159`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{183, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,4",
 CellLabel->"Out[1]=",
 CellID->88713424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16985567],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->164387283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", " ", 
  RowBox[{
   RowBox[{"HypergeometricU", "[", " ", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", " ", 
     RowBox[{"2", "/", "3"}], ",", " ", "2"}], "]"}], ",", " ", "50"}], 
  "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,5",
 CellLabel->"In[1]:=",
 CellID->164162164],

Cell[BoxData["0.\
732159202495517384124748159586141420487204085410778164486604762254`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,5",
 CellLabel->"Out[1]=",
 CellID->341662566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180114739],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->21450217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", " ", 
  RowBox[{
   RowBox[{"1", "/", "3"}], ",", " ", 
   RowBox[{"2", "/", "3"}], ",", " ", "2.000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,6",
 CellLabel->"In[1]:=",
 CellID->198427040],

Cell[BoxData["0.73215920249551738412474815958614141847`28.631744126310547"], \
"Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,6",
 CellLabel->"Out[1]=",
 CellID->208867311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279951502],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->544807774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,9",
 CellLabel->"In[1]:=",
 CellID->128958271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["\[ExponentialE]"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"0", ",", 
      FractionBox["1", "2"]}], "]"}]}], ",", "2", ",", 
   RowBox[{"4", " ", 
    SqrtBox["\[ExponentialE]"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"2", ",", 
      FractionBox["1", "2"]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{268, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,9",
 CellLabel->"Out[1]=",
 CellID->797079476]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291263910],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " automatically evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellID->156499268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", 
  RowBox[{"1", ",", "3", ",", "x"}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,10",
 CellLabel->"In[1]:=",
 CellID->811408879],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"2", ",", "x"}], "]"}]}], 
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{98, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,10",
 CellLabel->"Out[1]=",
 CellID->2487151]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "1", ",", "x"}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,2",
 CellLabel->"In[2]:=",
 CellID->138507604],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"x", "/", "2"}]], " ", 
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", 
     FractionBox["x", "2"]}], "]"}]}], 
  SqrtBox["\[Pi]"]]], "Output",
 ImageSize->{125, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,2",
 CellLabel->"Out[2]=",
 CellID->77756145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76442053],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->216817796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"HypergeometricU", "[", 
   RowBox[{"a", ",", "b", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408046735],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox["U",
    HypergeometricU], "(", 
   RowBox[{"a", ",", "b", ",", "z"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->712839369]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13833],

Cell[TextData[{
 "Expand ",
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " in series around infinity:"
}], "ExampleText",
 CellID->34138450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"HypergeometricU", "[", 
    RowBox[{"a", ",", "b", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,12",
 CellLabel->"In[1]:=",
 CellID->66736460],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", 
   RowBox[{"-", "a"}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"1", "+", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "a"}], "-", 
       SuperscriptBox["a", "2"], "+", 
       RowBox[{"a", " ", "b"}]}], "x"], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "a"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "a", "-", "b"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "a", "-", "b"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], "2"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "3"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 0, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {
     1, -$CellContext`a - $CellContext`a^2 + $CellContext`a $CellContext`b, 
      Rational[1, 2] $CellContext`a (1 + $CellContext`a) (
       1 + $CellContext`a - $CellContext`b) (
       2 + $CellContext`a - $CellContext`b)}, 0, 3, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{420, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,12",
 CellLabel->"Out[1]=",
 CellID->503054943]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2045],

Cell["Solve the confluent hypergeometric differential equation:", \
"ExampleText",
 CellID->178219539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "z"}], ")"}], " ", 
      RowBox[{
       SuperscriptBox["w", "\[Prime]",
        MultilineFunction->None], "[", "z", "]"}]}], "-", 
     RowBox[{"a", " ", 
      RowBox[{"w", "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,13",
 CellLabel->"In[1]:=",
 CellID->10488145],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"HypergeometricU", "[", 
       RowBox[{"a", ",", "b", ",", "z"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"LaguerreL", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "b"}], ",", "z"}], "]"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,13",
 CellLabel->"Out[1]=",
 CellID->790404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15310030],

Cell[TextData[{
 "Borel summation of divergent series of ",
 Cell[BoxData[
  FormBox[
   TagBox[
    TagBox[
     RowBox[{
      RowBox[{
       SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
       SubscriptBox["F", "0"]}], "\[InvisibleApplication]", 
      RowBox[{"(", 
       RowBox[{
        TagBox[
         TagBox[
          RowBox[{
           TagBox["a",
            HypergeometricPFQ,
            Editable->True,
            Selectable->True], ",", 
           TagBox[
            RowBox[{"a", "-", "b", "+", "1"}],
            HypergeometricPFQ,
            Editable->True,
            Selectable->True]}],
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         HypergeometricPFQ,
         Editable->False,
         Selectable->False], ";", 
        TagBox[
         TagBox["\[Null]",
          InterpretTemplate[{
            SlotSequence[1]}& ]],
         HypergeometricPFQ,
         Editable->False,
         Selectable->False], ";", 
        TagBox["z",
         HypergeometricPFQ,
         Editable->True,
         Selectable->True]}], ")"}]}],
     InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
     Editable->False,
     Selectable->False],
    HypergeometricPFQ], TraditionalForm]], "InlineMath"],
 " gives ",
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->312109858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["z", 
     RowBox[{"-", "a"}]], 
    FractionBox[
     RowBox[{
      RowBox[{"Pochhammer", "[", 
       RowBox[{"a", ",", "k"}], "]"}], 
      RowBox[{"Pochhammer", "[", 
       RowBox[{
        RowBox[{"1", "+", "a", "-", "b"}], ",", "k"}], "]"}]}], 
     RowBox[{"k", "!"}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", 
       FractionBox["1", "z"]}], ")"}], "k"], " ", 
    FractionBox[
     SuperscriptBox["t", "k"], 
     RowBox[{"k", "!"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,17",
 CellLabel->"In[1]:=",
 CellID->149482434],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["z", 
   RowBox[{"-", "a"}]], " ", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"1", "+", "a", "-", "b"}]}], "}"}], ",", 
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"-", 
     FractionBox["t", "z"]}]}], "]"}]}]], "Output",
 ImageSize->{299, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,17",
 CellLabel->"Out[1]=",
 CellID->592547086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"%", "  ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", "t"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"z", ">", "0"}]}]}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,17",
 CellLabel->"In[2]:=",
 CellID->201944770],

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", 
  RowBox[{"a", ",", "b", ",", "z"}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,17",
 CellLabel->"Out[2]=",
 CellID->391231992]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", "==", 
   RowBox[{"HypergeometricU", "[", 
    RowBox[{"a", ",", "b", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,19",
 CellLabel->"In[3]:=",
 CellID->479873150],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,19",
 CellLabel->"Out[3]=",
 CellID->77800289]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25000],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand ",
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 " into simpler functions:"
}], "ExampleText",
 CellID->85173201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,14",
 CellLabel->"In[1]:=",
 CellID->366762856],

Cell[BoxData[
 RowBox[{"HypergeometricU", "[", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["1", "2"], ",", "x"}], "]"}]], "Output",
 ImageSize->{175, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,14",
 CellLabel->"Out[1]=",
 CellID->787874611]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,15",
 CellLabel->"In[2]:=",
 CellID->207583239],

Cell[BoxData[
 RowBox[{
  SqrtBox["x"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "x"}]}], ")"}]}], 
     SqrtBox["x"]], "+", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      SqrtBox["\[Pi]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        RowBox[{"2", " ", "x"}]}], ")"}], " ", 
      RowBox[{"Erf", "[", 
       SqrtBox["x"], "]"}]}], 
     SqrtBox["x"]]}], ")"}]}]], "Output",
 ImageSize->{351, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,15",
 CellLabel->"Out[2]=",
 CellID->690416692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79002333],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " may give results involving ",
 Cell[BoxData[
  ButtonBox["HypergeometricU",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HypergeometricU"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5881628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"t", "+", "1"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"2", "/", "3"}], ")"}]}], " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", "t"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--21909550694777321124,14",
 CellLabel->"In[1]:=",
 CellID->144994603],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   FractionBox["4", "3"], "]"}], " ", 
  RowBox[{"HypergeometricU", "[", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], ",", 
    RowBox[{"-", "1"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{249, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21909550694777321124,14",
 CellLabel->"Out[1]=",
 CellID->806738771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21985],

Cell[TextData[{
 "The default setting of ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be insufficient to obtain requested precision:"
}], "ExampleText",
 CellID->670751996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"HypergeometricU", "[", 
    RowBox[{
     RowBox[{"10", "^", "4"}], ",", " ", 
     RowBox[{"1", "/", "3"}], ",", "1"}], "]"}], ",", "20"}], "]"}]], "Input",\

 CellTags->"Ex--21913490365219652069,1",
 CellLabel->"In[1]:=",
 CellID->741559753],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(HypergeometricU[\\(\\(10000, 1\\/3, \
1\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellTags->"Ex--21913490365219652069,1",
 CellID->591501011],

Cell[BoxData["0``35708.924955779374"], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21913490365219652069,1",
 CellLabel->"Out[1]=",
 CellID->30921380]
}, Open  ]],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may be needed:"
}], "ExampleText",
 CellID->44892482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"HypergeometricU", "[", 
      RowBox[{
       RowBox[{"10", "^", "4"}], ",", " ", 
       RowBox[{"1", "/", "3"}], ",", "1"}], "]"}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"Ex--21913490365219652069,4",
 CellLabel->"In[2]:=",
 CellID->235374996],

Cell[BoxData["6.60377008885811290390402496392588`20.*^-35745"], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21913490365219652069,4",
 CellLabel->"Out[2]=",
 CellID->87420390]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9772],

Cell[TextData[{
 "Visualize the confluency relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     UnderscriptBox["lim", 
      RowBox[{"c", "\[Rule]", "\[Infinity]"}]], "\[ThinSpace]", 
     RowBox[{
      TagBox[
       TagBox[
        RowBox[{
         RowBox[{
          SubscriptBox["\[InvisiblePrefixScriptBase]", "2"], 
          SubscriptBox["F", "1"]}], "\[InvisibleApplication]", 
         RowBox[{"(", 
          RowBox[{
           TagBox[
            TagBox[
             RowBox[{
              TagBox["a",
               Hypergeometric2F1,
               Editable->True,
               Selectable->True], ",", 
              TagBox[
               RowBox[{"a", "-", "b", "+", "1"}],
               Hypergeometric2F1,
               Editable->True,
               Selectable->True]}],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1,
            Editable->False,
            Selectable->False], ";", 
           TagBox[
            TagBox[
             TagBox["c",
              Hypergeometric2F1,
              Editable->True,
              Selectable->True],
             InterpretTemplate[{
               SlotSequence[1]}& ]],
            Hypergeometric2F1,
            Editable->False,
            Selectable->False], ";", 
           TagBox[
            RowBox[{"1", "-", 
             FractionBox["c", "z"]}],
            Hypergeometric2F1,
            Editable->True,
            Selectable->True]}], ")"}]}],
        InterpretTemplate[HypergeometricPFQ[#, #2, #3]& ],
        Editable->False,
        Selectable->False],
       Hypergeometric2F1], 
      SuperscriptBox["z", 
       RowBox[{"-", "a"}]]}]}], "\[LongEqual]", 
    RowBox[{
     TagBox["U",
      HypergeometricU], "(", 
     RowBox[{"a", ",", "b", ",", "z"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->101387167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "=", 
      RowBox[{"3", "/", "2"}]}], ",", 
     RowBox[{"b", "=", "1"}], ",", 
     RowBox[{"z", "=", 
      RowBox[{"1", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{"a", ",", 
          RowBox[{"a", "-", "b", "+", "1"}], ",", 
          RowBox[{"E", "^", "t"}], ",", 
          RowBox[{"1", "-", 
           RowBox[{
            RowBox[{"E", "^", "t"}], "/", "z"}]}]}], "]"}], "/", 
        RowBox[{"z", "^", "a"}]}], "/", 
       RowBox[{"HypergeometricU", "[", 
        RowBox[{"a", ",", "b", ",", "z"}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "5", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"Ex--21903324984602085672,19",
 CellLabel->"In[1]:=",
 CellID->2142725510],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21903324984602085672,19",
 CellLabel->"Out[1]=",
 CellID->762590160]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11612],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric1F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric1F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hypergeometric0F1",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hypergeometric0F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhittakerW",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhittakerW"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParabolicCylinderD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParabolicCylinderD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10474]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16088],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->29467]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31375],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/\
ConfluentHypergeometricFunctionoftheSecondKind.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/HypergeometricU/\
"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->937863215],

Cell[TextData[ButtonBox["Hypergeometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HypergeometricFunctions"]], "MoreAbout",
 CellID->541106516],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->407309520]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HypergeometricU - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 0.0073732}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "HypergeometricU[a, b, z] is the confluent hypergeometric function U(a, \
b, z). ", "synonyms" -> {"hypergeometric u"}, "title" -> "HypergeometricU", 
    "type" -> "Symbol", "uri" -> "ref/HypergeometricU"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6599, 223, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->38389222]},
 "Ex--21903324984602085672,1"->{
  Cell[7223, 249, 184, 5, 28, "Input",
   CellTags->"Ex--21903324984602085672,1",
   CellID->7931550],
  Cell[7410, 256, 217, 6, 36, "Output",
   CellTags->"Ex--21903324984602085672,1",
   CellID->20282082]},
 "Ex--21903324984602085672,3"->{
  Cell[8028, 285, 303, 9, 70, "Input",
   CellTags->"Ex--21903324984602085672,3",
   CellID->196029156],
  Cell[8334, 296, 2249, 46, 165, "Output",
   CellTags->"Ex--21903324984602085672,3",
   CellID->138881982]},
 "Ex--21903324984602085672,12"->{
  Cell[10823, 355, 304, 9, 70, "Input",
   CellTags->"Ex--21903324984602085672,12",
   CellID->740501835],
  Cell[11130, 366, 1425, 43, 67, "Output",
   CellTags->"Ex--21903324984602085672,12",
   CellID->702022511],
  Cell[19379, 688, 310, 9, 70, "Input",
   CellTags->"Ex--21903324984602085672,12",
   CellID->66736460],
  Cell[19692, 699, 1388, 42, 54, "Output",
   CellTags->"Ex--21903324984602085672,12",
   CellID->503054943]},
 "Ex--21903324984602085672,4"->{
  Cell[12920, 429, 245, 7, 70, "Input",
   CellTags->"Ex--21903324984602085672,4",
   CellID->198543373],
  Cell[13168, 438, 313, 9, 36, "Output",
   CellTags->"Ex--21903324984602085672,4",
   CellID->88713424]},
 "Ex--21903324984602085672,5"->{
  Cell[13718, 460, 320, 10, 70, "Input",
   CellTags->"Ex--21903324984602085672,5",
   CellID->164162164],
  Cell[14041, 472, 275, 8, 36, "Output",
   CellTags->"Ex--21903324984602085672,5",
   CellID->341662566]},
 "Ex--21903324984602085672,6"->{
  Cell[14596, 495, 282, 8, 70, "Input",
   CellTags->"Ex--21903324984602085672,6",
   CellID->198427040],
  Cell[14881, 505, 260, 7, 36, "Output",
   CellTags->"Ex--21903324984602085672,6",
   CellID->208867311]},
 "Ex--21903324984602085672,9"->{
  Cell[15533, 531, 268, 8, 70, "Input",
   CellTags->"Ex--21903324984602085672,9",
   CellID->128958271],
  Cell[15804, 541, 539, 18, 51, "Output",
   CellTags->"Ex--21903324984602085672,9",
   CellID->797079476]},
 "Ex--21903324984602085672,10"->{
  Cell[16771, 578, 186, 5, 70, "Input",
   CellTags->"Ex--21903324984602085672,10",
   CellID->811408879],
  Cell[16960, 585, 362, 12, 53, "Output",
   CellTags->"Ex--21903324984602085672,10",
   CellID->2487151]},
 "Ex--21903324984602085672,2"->{
  Cell[17359, 602, 209, 6, 70, "Input",
   CellTags->"Ex--21903324984602085672,2",
   CellID->138507604],
  Cell[17571, 610, 406, 14, 63, "Output",
   CellTags->"Ex--21903324984602085672,2",
   CellID->77756145]},
 "Ex--21903324984602085672,13"->{
  Cell[21481, 762, 646, 20, 70, "Input",
   CellTags->"Ex--21903324984602085672,13",
   CellID->10488145],
  Cell[22130, 784, 687, 23, 36, "Output",
   CellTags->"Ex--21903324984602085672,13",
   CellID->790404]},
 "Ex--21909550694777321124,17"->{
  Cell[24417, 870, 727, 25, 70, "Input",
   CellTags->"Ex--21909550694777321124,17",
   CellID->149482434],
  Cell[25147, 897, 501, 17, 50, "Output",
   CellTags->"Ex--21909550694777321124,17",
   CellID->592547086],
  Cell[25685, 919, 387, 12, 70, "Input",
   CellTags->"Ex--21909550694777321124,17",
   CellID->201944770],
  Cell[26075, 933, 275, 8, 36, "Output",
   CellTags->"Ex--21909550694777321124,17",
   CellID->391231992]},
 "Ex--21909550694777321124,19"->{
  Cell[26387, 946, 252, 7, 70, "Input",
   CellTags->"Ex--21909550694777321124,19",
   CellID->479873150],
  Cell[26642, 955, 202, 6, 36, "Output",
   CellTags->"Ex--21909550694777321124,19",
   CellID->77800289]},
 "Ex--21903324984602085672,14"->{
  Cell[27524, 993, 234, 7, 70, "Input",
   CellTags->"Ex--21903324984602085672,14",
   CellID->366762856],
  Cell[27761, 1002, 319, 10, 51, "Output",
   CellTags->"Ex--21903324984602085672,14",
   CellID->787874611]},
 "Ex--21903324984602085672,15"->{
  Cell[28117, 1017, 152, 4, 70, "Input",
   CellTags->"Ex--21903324984602085672,15",
   CellID->207583239],
  Cell[28272, 1023, 837, 30, 68, "Output",
   CellTags->"Ex--21903324984602085672,15",
   CellID->690416692]},
 "Ex--21909550694777321124,14"->{
  Cell[29620, 1077, 527, 18, 70, "Input",
   CellTags->"Ex--21909550694777321124,14",
   CellID->144994603],
  Cell[30150, 1097, 417, 14, 51, "Output",
   CellTags->"Ex--21909550694777321124,14",
   CellID->806738771]},
 "Ex--21913490365219652069,1"->{
  Cell[31146, 1138, 300, 10, 70, "Input",
   CellTags->"Ex--21913490365219652069,1",
   CellID->741559753],
  Cell[31449, 1150, 502, 10, 70, "Message",
   CellTags->"Ex--21913490365219652069,1",
   CellID->591501011],
  Cell[31954, 1162, 218, 6, 36, "Output",
   CellTags->"Ex--21913490365219652069,1",
   CellID->30921380]},
 "Ex--21913490365219652069,4"->{
  Cell[32449, 1183, 435, 14, 70, "Input",
   CellTags->"Ex--21913490365219652069,4",
   CellID->235374996],
  Cell[32887, 1199, 244, 6, 36, "Output",
   CellTags->"Ex--21913490365219652069,4",
   CellID->87420390]},
 "Ex--21903324984602085672,19"->{
  Cell[35331, 1288, 950, 29, 70, "Input",
   CellTags->"Ex--21903324984602085672,19",
   CellID->2142725510],
  Cell[36284, 1319, 2292, 42, 70, "Output",
   Evaluatable->False,
   CellTags->"Ex--21903324984602085672,19",
   CellID->762590160]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42993, 1515},
 {"Ex--21903324984602085672,1", 43145, 1519},
 {"Ex--21903324984602085672,3", 43387, 1526},
 {"Ex--21903324984602085672,12", 43636, 1533},
 {"Ex--21903324984602085672,4", 44103, 1546},
 {"Ex--21903324984602085672,5", 44349, 1553},
 {"Ex--21903324984602085672,6", 44597, 1560},
 {"Ex--21903324984602085672,9", 44844, 1567},
 {"Ex--21903324984602085672,10", 45093, 1574},
 {"Ex--21903324984602085672,2", 45341, 1581},
 {"Ex--21903324984602085672,13", 45589, 1588},
 {"Ex--21909550694777321124,17", 45837, 1595},
 {"Ex--21909550694777321124,19", 46305, 1608},
 {"Ex--21903324984602085672,14", 46554, 1615},
 {"Ex--21903324984602085672,15", 46806, 1622},
 {"Ex--21909550694777321124,14", 47059, 1629},
 {"Ex--21913490365219652069,1", 47312, 1636},
 {"Ex--21913490365219652069,4", 47671, 1646},
 {"Ex--21903324984602085672,19", 47921, 1653}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2285, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2908, 81, 53, 1, 70, "ObjectName",
 CellID->19652],
Cell[2964, 84, 748, 24, 70, "Usage",
 CellID->23171]
}, Open  ]],
Cell[CellGroupData[{
Cell[3749, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4227, 130, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4350, 136, 874, 30, 70, "Notes",
 CellID->29720],
Cell[5227, 168, 617, 22, 70, "Notes",
 CellID->7273],
Cell[5847, 192, 262, 8, 70, "Notes",
 CellID->280483206],
Cell[6112, 202, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6347, 211, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6599, 223, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38389222],
Cell[CellGroupData[{
Cell[6983, 237, 148, 5, 70, "ExampleSection",
 CellID->257709352],
Cell[7134, 244, 64, 1, 70, "ExampleText",
 CellID->462570374],
Cell[CellGroupData[{
Cell[7223, 249, 184, 5, 28, "Input",
 CellTags->"Ex--21903324984602085672,1",
 CellID->7931550],
Cell[7410, 256, 217, 6, 36, "Output",
 CellTags->"Ex--21903324984602085672,1",
 CellID->20282082]
}, Open  ]],
Cell[7642, 265, 125, 3, 70, "ExampleDelimiter",
 CellID->483587298],
Cell[7770, 270, 233, 11, 70, "ExampleText",
 CellID->7117380],
Cell[CellGroupData[{
Cell[8028, 285, 303, 9, 70, "Input",
 CellTags->"Ex--21903324984602085672,3",
 CellID->196029156],
Cell[8334, 296, 2249, 46, 165, "Output",
 CellTags->"Ex--21903324984602085672,3",
 CellID->138881982]
}, Open  ]],
Cell[10598, 345, 125, 3, 70, "ExampleDelimiter",
 CellID->127075355],
Cell[10726, 350, 72, 1, 70, "ExampleText",
 CellID->4255939],
Cell[CellGroupData[{
Cell[10823, 355, 304, 9, 70, "Input",
 CellTags->"Ex--21903324984602085672,12",
 CellID->740501835],
Cell[11130, 366, 1425, 43, 67, "Output",
 CellTags->"Ex--21903324984602085672,12",
 CellID->702022511]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12604, 415, 214, 7, 70, "ExampleSection",
 CellID->583],
Cell[12821, 424, 74, 1, 70, "ExampleText",
 CellID->719782760],
Cell[CellGroupData[{
Cell[12920, 429, 245, 7, 70, "Input",
 CellTags->"Ex--21903324984602085672,4",
 CellID->198543373],
Cell[13168, 438, 313, 9, 36, "Output",
 CellTags->"Ex--21903324984602085672,4",
 CellID->88713424]
}, Open  ]],
Cell[13496, 450, 124, 3, 70, "ExampleDelimiter",
 CellID->16985567],
Cell[13623, 455, 70, 1, 70, "ExampleText",
 CellID->164387283],
Cell[CellGroupData[{
Cell[13718, 460, 320, 10, 70, "Input",
 CellTags->"Ex--21903324984602085672,5",
 CellID->164162164],
Cell[14041, 472, 275, 8, 36, "Output",
 CellTags->"Ex--21903324984602085672,5",
 CellID->341662566]
}, Open  ]],
Cell[14331, 483, 125, 3, 70, "ExampleDelimiter",
 CellID->180114739],
Cell[14459, 488, 112, 3, 70, "ExampleText",
 CellID->21450217],
Cell[CellGroupData[{
Cell[14596, 495, 282, 8, 70, "Input",
 CellTags->"Ex--21903324984602085672,6",
 CellID->198427040],
Cell[14881, 505, 260, 7, 36, "Output",
 CellTags->"Ex--21903324984602085672,6",
 CellID->208867311]
}, Open  ]],
Cell[15156, 515, 125, 3, 70, "ExampleDelimiter",
 CellID->279951502],
Cell[15284, 520, 224, 7, 70, "ExampleText",
 CellID->544807774],
Cell[CellGroupData[{
Cell[15533, 531, 268, 8, 70, "Input",
 CellTags->"Ex--21903324984602085672,9",
 CellID->128958271],
Cell[15804, 541, 539, 18, 51, "Output",
 CellTags->"Ex--21903324984602085672,9",
 CellID->797079476]
}, Open  ]],
Cell[16358, 562, 125, 3, 70, "ExampleDelimiter",
 CellID->291263910],
Cell[16486, 567, 260, 7, 70, "ExampleText",
 CellID->156499268],
Cell[CellGroupData[{
Cell[16771, 578, 186, 5, 70, "Input",
 CellTags->"Ex--21903324984602085672,10",
 CellID->811408879],
Cell[16960, 585, 362, 12, 53, "Output",
 CellTags->"Ex--21903324984602085672,10",
 CellID->2487151]
}, Open  ]],
Cell[CellGroupData[{
Cell[17359, 602, 209, 6, 70, "Input",
 CellTags->"Ex--21903324984602085672,2",
 CellID->138507604],
Cell[17571, 610, 406, 14, 63, "Output",
 CellTags->"Ex--21903324984602085672,2",
 CellID->77756145]
}, Open  ]],
Cell[17992, 627, 124, 3, 70, "ExampleDelimiter",
 CellID->76442053],
Cell[18119, 632, 203, 7, 70, "ExampleText",
 CellID->216817796],
Cell[CellGroupData[{
Cell[18347, 643, 186, 6, 70, "Input",
 CellID->408046735],
Cell[18536, 651, 298, 10, 50, "Output",
 CellID->712839369]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18883, 667, 239, 7, 70, "ExampleSection",
 CellID->13833],
Cell[19125, 676, 229, 8, 70, "ExampleText",
 CellID->34138450],
Cell[CellGroupData[{
Cell[19379, 688, 310, 9, 70, "Input",
 CellTags->"Ex--21903324984602085672,12",
 CellID->66736460],
Cell[19692, 699, 1388, 42, 54, "Output",
 CellTags->"Ex--21903324984602085672,12",
 CellID->503054943]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21129, 747, 222, 7, 70, "ExampleSection",
 CellID->2045],
Cell[21354, 756, 102, 2, 70, "ExampleText",
 CellID->178219539],
Cell[CellGroupData[{
Cell[21481, 762, 646, 20, 70, "Input",
 CellTags->"Ex--21903324984602085672,13",
 CellID->10488145],
Cell[22130, 784, 687, 23, 36, "Output",
 CellTags->"Ex--21903324984602085672,13",
 CellID->790404]
}, Open  ]],
Cell[22832, 810, 124, 3, 70, "ExampleDelimiter",
 CellID->15310030],
Cell[22959, 815, 1433, 51, 70, "ExampleText",
 CellID->312109858],
Cell[CellGroupData[{
Cell[24417, 870, 727, 25, 70, "Input",
 CellTags->"Ex--21909550694777321124,17",
 CellID->149482434],
Cell[25147, 897, 501, 17, 50, "Output",
 CellTags->"Ex--21909550694777321124,17",
 CellID->592547086]
}, Open  ]],
Cell[CellGroupData[{
Cell[25685, 919, 387, 12, 70, "Input",
 CellTags->"Ex--21909550694777321124,17",
 CellID->201944770],
Cell[26075, 933, 275, 8, 36, "Output",
 CellTags->"Ex--21909550694777321124,17",
 CellID->391231992]
}, Open  ]],
Cell[CellGroupData[{
Cell[26387, 946, 252, 7, 70, "Input",
 CellTags->"Ex--21909550694777321124,19",
 CellID->479873150],
Cell[26642, 955, 202, 6, 36, "Output",
 CellTags->"Ex--21909550694777321124,19",
 CellID->77800289]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26893, 967, 233, 7, 70, "ExampleSection",
 CellID->25000],
Cell[27129, 976, 370, 13, 70, "ExampleText",
 CellID->85173201],
Cell[CellGroupData[{
Cell[27524, 993, 234, 7, 70, "Input",
 CellTags->"Ex--21903324984602085672,14",
 CellID->366762856],
Cell[27761, 1002, 319, 10, 51, "Output",
 CellTags->"Ex--21903324984602085672,14",
 CellID->787874611]
}, Open  ]],
Cell[CellGroupData[{
Cell[28117, 1017, 152, 4, 70, "Input",
 CellTags->"Ex--21903324984602085672,15",
 CellID->207583239],
Cell[28272, 1023, 837, 30, 68, "Output",
 CellTags->"Ex--21903324984602085672,15",
 CellID->690416692]
}, Open  ]],
Cell[29124, 1056, 124, 3, 70, "ExampleDelimiter",
 CellID->79002333],
Cell[29251, 1061, 344, 12, 70, "ExampleText",
 CellID->5881628],
Cell[CellGroupData[{
Cell[29620, 1077, 527, 18, 70, "Input",
 CellTags->"Ex--21909550694777321124,14",
 CellID->144994603],
Cell[30150, 1097, 417, 14, 51, "Output",
 CellTags->"Ex--21909550694777321124,14",
 CellID->806738771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30616, 1117, 226, 7, 70, "ExampleSection",
 CellID->21985],
Cell[30845, 1126, 276, 8, 70, "ExampleText",
 CellID->670751996],
Cell[CellGroupData[{
Cell[31146, 1138, 300, 10, 70, "Input",
 CellTags->"Ex--21913490365219652069,1",
 CellID->741559753],
Cell[31449, 1150, 502, 10, 70, "Message",
 CellTags->"Ex--21913490365219652069,1",
 CellID->591501011],
Cell[31954, 1162, 218, 6, 36, "Output",
 CellTags->"Ex--21913490365219652069,1",
 CellID->30921380]
}, Open  ]],
Cell[32187, 1171, 237, 8, 70, "ExampleText",
 CellID->44892482],
Cell[CellGroupData[{
Cell[32449, 1183, 435, 14, 70, "Input",
 CellTags->"Ex--21913490365219652069,4",
 CellID->235374996],
Cell[32887, 1199, 244, 6, 36, "Output",
 CellTags->"Ex--21913490365219652069,4",
 CellID->87420390]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33180, 1211, 223, 7, 70, "ExampleSection",
 CellID->9772],
Cell[33406, 1220, 1900, 64, 70, "ExampleText",
 CellID->101387167],
Cell[CellGroupData[{
Cell[35331, 1288, 950, 29, 70, "Input",
 CellTags->"Ex--21903324984602085672,19",
 CellID->2142725510],
Cell[36284, 1319, 2292, 42, 70, "Output",
 Evaluatable->False,
 CellTags->"Ex--21903324984602085672,19",
 CellID->762590160]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38637, 1368, 311, 9, 70, "SeeAlsoSection",
 CellID->11612],
Cell[38951, 1379, 1001, 35, 70, "SeeAlso",
 CellID->10474]
}, Open  ]],
Cell[CellGroupData[{
Cell[39989, 1419, 314, 9, 70, "TutorialsSection",
 CellID->16088],
Cell[40306, 1430, 144, 3, 70, "Tutorials",
 CellID->29467]
}, Open  ]],
Cell[CellGroupData[{
Cell[40487, 1438, 321, 9, 70, "RelatedLinksSection",
 CellID->31375],
Cell[40811, 1449, 219, 5, 70, "RelatedLinks"],
Cell[41033, 1456, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[41279, 1465, 319, 9, 70, "MoreAboutSection",
 CellID->937863215],
Cell[41601, 1476, 159, 3, 70, "MoreAbout",
 CellID->541106516],
Cell[41763, 1481, 145, 3, 70, "MoreAbout",
 CellID->407309520]
}, Open  ]],
Cell[41923, 1487, 27, 0, 70, "History"],
Cell[41953, 1489, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

