(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    109093,       2763]
NotebookOptionsPosition[    101724,       2510]
NotebookOutlinePosition[    103221,       2550]
CellTagsIndexPosition[    103134,       2545]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Setting Up Hyperlinks" :> 
          Documentation`HelpLookup["paclet:tutorial/SettingUpHyperlinks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Setting Up Hyperlinks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "FileNameSetter" :> 
          Documentation`HelpLookup["paclet:ref/FileNameSetter"], "StatusArea" :> 
          Documentation`HelpLookup["paclet:ref/StatusArea"], "Tooltip" :> 
          Documentation`HelpLookup["paclet:ref/Tooltip"], "PopupWindow" :> 
          Documentation`HelpLookup["paclet:ref/PopupWindow"], 
          "NotebookLocate" :> 
          Documentation`HelpLookup["paclet:ref/NotebookLocate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Button\"\>", 
       2->"\<\"FileNameSetter\"\>", 3->"\<\"StatusArea\"\>", 
       4->"\<\"Tooltip\"\>", 5->"\<\"PopupWindow\"\>", 
       6->"\<\"NotebookLocate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Web Pages\"\>", 3->"\<\"Document Generation\"\>", 
       4->"\<\"Dynamic Graphics Elements\"\>", 
       5->"\<\"Notebook Formatting & Styling\"\>", 
       6->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Hyperlink", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hyperlink",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hyperlink"], "[", 
       StyleBox["uri", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a hyperlink that jumps to the specified URI \
when clicked. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Hyperlink",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Hyperlink"], "[", 
       RowBox[{
        StyleBox["label", "TI"], ",", 
        StyleBox["uri", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a hyperlink to be displayed as ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following forms of URIs can be used: ", "Notes",
 CellID->15467],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[TextData[{
     "a URI such as ",
     Cell[BoxData["\"\<http://www.wolfram.com\>\""], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"TI\"]\)\!\(\*
StyleBox[\"nb\", \"TI\"]\)\>\"", ",", 
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]}], "}"}], Cell[
    "a complete local notebook file", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"TI\"]\)\!\(\*
StyleBox[\"nb\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""}], "}"}], Cell["\<\
the first cell with the specified tag in a local notebook file\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->20770],

Cell[TextData[{
 "Local notebook files can be specified by relative paths such as ",
 StyleBox["\"../file.nb\"", "MR"],
 ". The base of the paths is taken to be the location of the notebook that \
contains the hyperlink."
}], "Notes",
 CellID->12919],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 " can be used with graphics or any other expression."
}], "Notes",
 CellID->360278670],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 " objects can appear within graphics."
}], "Notes",
 CellID->41282514],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 " renders ",
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData["\"\<Hyperlink\>\""], "InlineFormula"],
 " style. "
}], "Notes",
 CellID->12855],

Cell[TextData[{
 "When the mouse is over ",
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 ", it is by default rendered in ",
 Cell[BoxData["\"\<HyperlinkActive\>\""], "InlineFormula"],
 " style. "
}], "Notes",
 CellID->297],

Cell[TextData[{
 "Supported URI types include ",
 StyleBox["http", "MR"],
 ", ",
 StyleBox["file", "MR"],
 ", ",
 StyleBox["ftp", "MR"],
 ", ",
 StyleBox["mailto", "MR"],
 "."
}], "Notes",
 CellID->10300],

Cell["Hyperlinks of different types are handled as follows:", "Notes",
 CellID->21888],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell["notebook file URI", "TableText"], 
    Cell[TextData[{
     "open in current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[
    "non-notebook file URI", "TableText"], Cell[
    "open through operating system", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["non-file URI", "TableText"], Cell[
    "open in a web browser", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->14969],

Cell[TextData[{
 "In a standard notebook front end, hyperlinks can be inserted using the ",
 StyleBox[ButtonBox["Hyperlink",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Hyperlink"], "MenuName"],
 " item in the ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 " menu."
}], "Notes",
 CellID->21813],

Cell[TextData[{
 StyleBox["Ctrl", "KeyEvent"],
 " or ",
 StyleBox["Command", "KeyEvent"],
 " clicking a hyperlink will always open a new notebook window, even if an \
existing window could have been used."
}], "Notes",
 CellID->14398]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92167393],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->744064083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
  "\"\<Wolfram Research, Inc.\>\"", ",", " ", 
   "\"\<http://www.wolfram.com\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698837125],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->"\<\"Wolfram Research, Inc.\"\>", True->
    StyleBox["\<\"Wolfram Research, Inc.\"\>", "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://www.wolfram.com"], None},
   ButtonNote->"http://www.wolfram.com"],
  Annotation[#, "http://www.wolfram.com", "Hyperlink"]& ]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136826596]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->283075102],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " and other functions to change the appearance of the link:"
}], "ExampleText",
 CellID->132101492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<xxx\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"Bold", ",", "Larger"}], "}"}]}], "]"}], "]"}], ",", "None"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166161499],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox[
     StyleBox["\<\"xxx\"\>",
      StripOnInput->False,
      FontSize->Larger,
      FontWeight->Bold],
     StripOnInput->False], True->
    StyleBox[
     FrameBox[
      StyleBox["\<\"xxx\"\>",
       StripOnInput->False,
       FontSize->Larger,
       FontWeight->Bold],
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{None, None},
   ButtonNote->Automatic],
  Annotation[#, None, "Hyperlink"]& ]], "Output",
 ImageSize->{38, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->942392423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->685889663],

Cell["The label can be any expression:", "ExampleText",
 CellID->339377895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"1", "/", "x"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", ".4"}], ",", ".4"}], "}"}]}], "]"}], ",", "None"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183084350],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUF3c8Fu6zHYmSsuIbkkQplMrotMuWEZJQdras7GzZe+893xfva9+LzBcZ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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->True,
     AxesOrigin->{0, 0},
     PlotRange->{{-0.4, 0.4}, {-0.2172335899142927, 0.23938881517086824`}},
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], True->
    StyleBox[
     GraphicsBox[{{}, {}, 
       {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUF3c8Fu6zHYmSsuIbkkQplMrotMuWEZJQdras7GzZe+893xfva9+LzBcZ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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesOrigin->{0, 0},
      PlotRange->{{-0.4, 0.4}, {-0.2172335899142927, 0.23938881517086824`}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], 
        Scaled[0.02]}], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{None, None},
   ButtonNote->Automatic],
  Annotation[#, None, "Hyperlink"]& ]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63007291]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->138336421],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->538402858],

Cell["Change the alignment within the link:", "ExampleText",
 CellID->11855895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hyperlink", "[", 
     RowBox[{"\"\<xxx\>\"", ",", "None", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"100", ",", "40"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191369905],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Left, Top},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Center, Top},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Right, Top},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ]},
    {
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Left, Center},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Center, Center},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Right, Center},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ]},
    {
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Left, Bottom},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Center, Bottom},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       Alignment->{Right, Bottom},
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{100, 40}],
      Annotation[#, None, "Hyperlink"]& ]}
   }],
  "Grid"]], "Output",
 ImageSize->{320, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->428020466]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->53599237],

Cell["Change the background color:", "ExampleText",
 CellID->744363179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hyperlink", "[", 
    RowBox[{"\"\<xxx\>\"", ",", " ", "None", ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "40"}], "}"}]}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"LightBlue", ",", "Purple", ",", "Gray", ",", "Pink"}], "}"}]}],
     "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69428090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     Background->RGBColor[0.87, 0.94, 1],
     BaseStyle->"Hyperlink",
     ButtonData->{None, None},
     ButtonNote->Automatic,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ], ",", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     Background->RGBColor[0.5, 0, 0.5],
     BaseStyle->"Hyperlink",
     ButtonData->{None, None},
     ButtonNote->Automatic,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ], ",", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     Background->GrayLevel[0.5],
     BaseStyle->"Hyperlink",
     ButtonData->{None, None},
     ButtonNote->Automatic,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ], ",", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     Background->RGBColor[1, 0.5, 0.5],
     BaseStyle->"Hyperlink",
     ButtonData->{None, None},
     ButtonNote->Automatic,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ]}], "}"}]], "Output",
 ImageSize->{452, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145189427]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->248740234],

Cell["Align the link with surrounding text:", "ExampleText",
 CellID->393890472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Hyperlink", "[", 
      RowBox[{"\"\<aaa\>\"", ",", "None", ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"100", ",", "40"}], "}"}]}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222577195],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"aaa\"\>", True->
      StyleBox["\<\"aaa\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     BaselinePosition->Top,
     ButtonData->{None, None},
     ButtonNote->Automatic,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ], "xxx", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"aaa\"\>", True->
      StyleBox["\<\"aaa\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     BaselinePosition->Center,
     ButtonData->{None, None},
     ButtonNote->Automatic,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ], "xxx", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"aaa\"\>", True->
      StyleBox["\<\"aaa\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     BaselinePosition->Bottom,
     ButtonData->{None, None},
     ButtonNote->Automatic,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ]}],
  Row[{
    Hyperlink["aaa", None, ImageSize -> {100, 40}, BaselinePosition -> Top], 
    Hyperlink[
    "aaa", None, ImageSize -> {100, 40}, BaselinePosition -> Center], 
    Hyperlink[
    "aaa", None, ImageSize -> {100, 40}, BaselinePosition -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{358, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211054440]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->62043739],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 " \[Rule] ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", disable a link:"
}], "ExampleText",
 CellID->270497441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hyperlink", "[", 
    RowBox[{"\"\<xxx\>\"", ",", " ", "None", ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"100", ",", "40"}], "}"}]}], ",", 
     RowBox[{"Enabled", "\[Rule]", "e"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171320380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     ButtonData->{None, None},
     ButtonNote->Automatic,
     Enabled->True,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ], ",", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     ButtonData->{None, None},
     ButtonNote->Automatic,
     Enabled->False,
     ImageSize->{100, 40}],
    Annotation[#, None, "Hyperlink"]& ]}], "}"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323263070]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->374954479],

Cell["Add margins within the clickable area:", "ExampleText",
 CellID->229250809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hyperlink", "[", 
    RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->277819695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     ButtonData->{Null, None},
     ButtonNote->Automatic,
     FrameMargins->0],
    Annotation[#, Null, "Hyperlink"]& ], ",", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     ButtonData->{Null, None},
     ButtonNote->Automatic,
     FrameMargins->5],
    Annotation[#, Null, "Hyperlink"]& ], ",", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     ButtonData->{Null, None},
     ButtonNote->Automatic,
     FrameMargins->10],
    Annotation[#, Null, "Hyperlink"]& ], ",", 
   TagBox[
    ButtonBox[
     PaneSelectorBox[{False->"\<\"xxx\"\>", True->
      StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
       CurrentValue["MouseOver"]],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     BaseStyle->"Hyperlink",
     ButtonData->{Null, None},
     ButtonNote->Automatic,
     FrameMargins->20],
    Annotation[#, Null, "Hyperlink"]& ]}], "}"}]], "Output",
 ImageSize->{206, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248764594]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8061442],

Cell["Add margins outside of the hyperlink:", "ExampleText",
 CellID->70900714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Hyperlink", "[", 
     RowBox[{"\"\<xxx\>\"", ",", "Null", ",", 
      RowBox[{"FrameMargins", "\[Rule]", "0"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", "10", ",", "20"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68732127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"xxx\"\>", True->
       StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{Null, None},
      ButtonNote->Automatic,
      FrameMargins->0,
      ImageMargins->0],
     Annotation[#, Null, "Hyperlink"]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"xxx\"\>", True->
       StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{Null, None},
      ButtonNote->Automatic,
      FrameMargins->0,
      ImageMargins->5],
     Annotation[#, Null, "Hyperlink"]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"xxx\"\>", True->
       StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{Null, None},
      ButtonNote->Automatic,
      FrameMargins->0,
      ImageMargins->10],
     Annotation[#, Null, "Hyperlink"]& ],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[
     ButtonBox[
      PaneSelectorBox[{False->"\<\"xxx\"\>", True->
       StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
        CurrentValue["MouseOver"]],
       BaselinePosition->Baseline,
       FrameMargins->0,
       ImageSize->Automatic],
      BaseStyle->"Hyperlink",
      ButtonData->{Null, None},
      ButtonNote->Automatic,
      FrameMargins->0,
      ImageMargins->20],
     Annotation[#, Null, "Hyperlink"]& ],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{246, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114074609]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->144314576],

Cell["Change the overall size:", "ExampleText",
 CellID->21511748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Hyperlink", "[", 
     RowBox[{"\"\<xxx\>\"", ",", "None", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "30", ",", "50"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"40", ",", "70", ",", "120"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->804462622],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{40, 20}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{70, 20}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{120, 20}],
      Annotation[#, None, "Hyperlink"]& ]},
    {
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{40, 30}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{70, 30}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{120, 30}],
      Annotation[#, None, "Hyperlink"]& ]},
    {
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{40, 50}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{70, 50}],
      Annotation[#, None, "Hyperlink"]& ], 
     TagBox[
      ButtonBox[
       PaneSelectorBox[{False->"\<\"xxx\"\>", True->
        StyleBox["\<\"xxx\"\>", "HyperlinkActive"]}, Dynamic[
         CurrentValue["MouseOver"]],
        BaselinePosition->Baseline,
        FrameMargins->0,
        ImageSize->Automatic],
       BaseStyle->"Hyperlink",
       ButtonData->{None, None},
       ButtonNote->Automatic,
       ImageSize->{120, 50}],
      Annotation[#, None, "Hyperlink"]& ]}
   }],
  "Grid"]], "Output",
 ImageSize->{250, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85758546]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->916822460],

Cell["\<\
Use hyperlinks on individual curves (click curve to activate): \
\>", "ExampleText",
 CellID->507275009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Hyperlink", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       "\"\<http://mathworld.wolfram.com/Sine.html\>\""}], "]"}], ",", 
     RowBox[{"Hyperlink", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", 
       "\"\<http://mathworld.wolfram.com/Cosine.html\>\""}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304398197],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54554701]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->278518536],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " to change the message in the status area:"
}], "ExampleText",
 CellID->117206969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StatusArea", "[", 
  RowBox[{
   RowBox[{"Hyperlink", "[", 
    RowBox[{
    "\"\<Wolfram Research, Inc.\>\"", ",", "\"\<http://www.wolfram.com\>\""}],
     "]"}], ",", "\"\<Makers of Mathematica\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355028708],

Cell[BoxData[
 TagBox[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->"\<\"Wolfram Research, Inc.\"\>", True->
     StyleBox["\<\"Wolfram Research, Inc.\"\>", "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["http://www.wolfram.com"], None},
    ButtonNote->"http://www.wolfram.com"],
   Annotation[#, "http://www.wolfram.com", "Hyperlink"]& ],
  StatusArea[#, "Makers of Mathematica"]& ,
  TagBoxNote->"Makers of Mathematica"]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122873401]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookLocate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookLocate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1244],

Cell[TextData[ButtonBox["Setting Up Hyperlinks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SettingUpHyperlinks"]], "Tutorials",
 CellID->20359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->243374026],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->800487997],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout",
 CellID->87300455],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->538951362],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->8178271],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->182224171],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->187669082]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hyperlink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 0.5073860}", "context" -> "System`", 
    "keywords" -> {
     "HREF", "hyperlink button", "hyper-reference", "hypertext", "link class",
       "link destination", "link id", "link label", "link target", 
      "link title", "link to page", "link to web", "URI", "URL"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Hyperlink[uri] represents a hyperlink that jumps to the specified URI \
when clicked. Hyperlink[label, uri] represents a hyperlink to be displayed as \
label. ", "synonyms" -> {}, "title" -> "Hyperlink", "type" -> "Symbol", "uri" -> 
    "ref/Hyperlink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11003, 337, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->92167393]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 102991, 2538}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3123, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3746, 97, 1574, 37, 70, "ObjectNameGrid"],
Cell[5323, 136, 959, 30, 70, "Usage",
 CellID->15117]
}, Open  ]],
Cell[CellGroupData[{
Cell[6319, 171, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6797, 188, 74, 1, 70, "Notes",
 CellID->15467],
Cell[6874, 191, 1164, 31, 70, "2ColumnTableMod",
 CellID->20770],
Cell[8041, 224, 250, 6, 70, "Notes",
 CellID->12919],
Cell[8294, 232, 224, 7, 70, "Notes",
 CellID->360278670],
Cell[8521, 241, 208, 7, 70, "Notes",
 CellID->41282514],
Cell[8732, 250, 332, 13, 70, "Notes",
 CellID->12855],
Cell[9067, 265, 239, 8, 70, "Notes",
 CellID->297],
Cell[9309, 275, 204, 11, 70, "Notes",
 CellID->10300],
Cell[9516, 288, 86, 1, 70, "Notes",
 CellID->21888],
Cell[9605, 291, 752, 19, 70, "2ColumnTableMod",
 CellID->14969],
Cell[10360, 312, 369, 11, 70, "Notes",
 CellID->21813],
Cell[10732, 325, 234, 7, 70, "Notes",
 CellID->14398]
}, Closed]],
Cell[CellGroupData[{
Cell[11003, 337, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92167393],
Cell[CellGroupData[{
Cell[11387, 351, 148, 5, 70, "ExampleSection",
 CellID->744064083],
Cell[CellGroupData[{
Cell[11560, 360, 198, 6, 28, "Input",
 CellID->698837125],
Cell[11761, 368, 623, 18, 36, "Output",
 CellID->136826596]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12433, 392, 220, 7, 70, "ExampleSection",
 CellID->283075102],
Cell[12656, 401, 238, 8, 70, "ExampleText",
 CellID->132101492],
Cell[CellGroupData[{
Cell[12919, 413, 301, 10, 70, "Input",
 CellID->166161499],
Cell[13223, 425, 788, 29, 70, "Output",
 CellID->942392423]
}, Open  ]],
Cell[14026, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->685889663],
Cell[14154, 462, 75, 1, 70, "ExampleText",
 CellID->339377895],
Cell[CellGroupData[{
Cell[14254, 467, 367, 13, 70, "Input",
 CellID->183084350],
Cell[14624, 482, 52516, 881, 70, "Output",
 CellID->63007291]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67189, 1369, 222, 7, 70, "ExampleSection",
 CellID->138336421],
Cell[CellGroupData[{
Cell[67436, 1380, 230, 7, 70, "ExampleSubsection",
 CellID->538402858],
Cell[67669, 1389, 79, 1, 70, "ExampleText",
 CellID->11855895],
Cell[CellGroupData[{
Cell[67773, 1394, 721, 22, 70, "Input",
 CellID->191369905],
Cell[68497, 1418, 4493, 137, 70, "Output",
 CellID->428020466]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73039, 1561, 230, 7, 70, "ExampleSubsection",
 CellID->53599237],
Cell[73272, 1570, 71, 1, 70, "ExampleText",
 CellID->744363179],
Cell[CellGroupData[{
Cell[73368, 1575, 508, 15, 70, "Input",
 CellID->69428090],
Cell[73879, 1592, 2023, 63, 70, "Output",
 CellID->145189427]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75951, 1661, 237, 7, 70, "ExampleSubsection",
 CellID->248740234],
Cell[76191, 1670, 80, 1, 70, "ExampleText",
 CellID->393890472],
Cell[CellGroupData[{
Cell[76296, 1675, 579, 17, 70, "Input",
 CellID->222577195],
Cell[76878, 1694, 1810, 56, 70, "Output",
 CellID->211054440]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[78737, 1756, 227, 7, 70, "ExampleSubsection",
 CellID->62043739],
Cell[78967, 1765, 335, 13, 70, "ExampleText",
 CellID->270497441],
Cell[CellGroupData[{
Cell[79327, 1782, 469, 14, 70, "Input",
 CellID->171320380],
Cell[79799, 1798, 1067, 35, 70, "Output",
 CellID->323263070]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80915, 1839, 233, 7, 70, "ExampleSubsection",
 CellID->374954479],
Cell[81151, 1848, 81, 1, 70, "ExampleText",
 CellID->229250809],
Cell[CellGroupData[{
Cell[81257, 1853, 379, 12, 70, "Input",
 CellID->277819695],
Cell[81639, 1867, 1850, 59, 70, "Output",
 CellID->248764594]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83538, 1932, 231, 7, 70, "ExampleSubsection",
 CellID->8061442],
Cell[83772, 1941, 79, 1, 70, "ExampleText",
 CellID->70900714],
Cell[CellGroupData[{
Cell[83876, 1946, 464, 14, 70, "Input",
 CellID->68732127],
Cell[84343, 1962, 2150, 71, 70, "Output",
 CellID->114074609]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86542, 2039, 230, 7, 70, "ExampleSubsection",
 CellID->144314576],
Cell[86775, 2048, 66, 1, 70, "ExampleText",
 CellID->21511748],
Cell[CellGroupData[{
Cell[86866, 2053, 593, 19, 70, "Input",
 CellID->804462622],
Cell[87462, 2074, 4180, 128, 70, "Output",
 CellID->85758546]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[91703, 2209, 227, 7, 70, "ExampleSection",
 CellID->916822460],
Cell[91933, 2218, 114, 3, 70, "ExampleText",
 CellID->507275009],
Cell[CellGroupData[{
Cell[92072, 2225, 567, 18, 70, "Input",
 CellID->304398197],
Cell[92642, 2245, 3798, 66, 70, "Output",
 Evaluatable->False,
 CellID->54554701]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[96489, 2317, 237, 7, 70, "ExampleSection",
 CellID->278518536],
Cell[96729, 2326, 232, 8, 70, "ExampleText",
 CellID->117206969],
Cell[CellGroupData[{
Cell[96986, 2338, 287, 8, 70, "Input",
 CellID->355028708],
Cell[97276, 2348, 729, 21, 70, "Output",
 CellID->122873401]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98066, 2376, 311, 9, 70, "SeeAlsoSection",
 CellID->25605],
Cell[98380, 2387, 1459, 53, 70, "SeeAlso",
 CellID->25810]
}, Open  ]],
Cell[CellGroupData[{
Cell[99876, 2445, 313, 9, 70, "TutorialsSection",
 CellID->1244],
Cell[100192, 2456, 151, 3, 70, "Tutorials",
 CellID->20359]
}, Open  ]],
Cell[CellGroupData[{
Cell[100380, 2464, 319, 9, 70, "MoreAboutSection",
 CellID->243374026],
Cell[100702, 2475, 141, 3, 70, "MoreAbout",
 CellID->800487997],
Cell[100846, 2480, 145, 3, 70, "MoreAbout",
 CellID->87300455],
Cell[100994, 2485, 149, 3, 70, "MoreAbout",
 CellID->538951362],
Cell[101146, 2490, 158, 3, 70, "MoreAbout",
 CellID->8178271],
Cell[101307, 2495, 169, 3, 70, "MoreAbout",
 CellID->182224171],
Cell[101479, 2500, 173, 3, 70, "MoreAbout",
 CellID->187669082]
}, Open  ]],
Cell[101667, 2506, 27, 0, 70, "History"],
Cell[101697, 2508, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

