(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19605,        659]
NotebookOptionsPosition[     15698,        523]
NotebookOutlinePosition[     16893,        558]
CellTagsIndexPosition[     16808,        553]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Working with Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithOperators"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Working with Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Composition" :> 
          Documentation`HelpLookup["paclet:ref/Composition"], "Through" :> 
          Documentation`HelpLookup["paclet:ref/Through"], "InverseFunction" :> 
          Documentation`HelpLookup["paclet:ref/InverseFunction"], "Sequence" :> 
          Documentation`HelpLookup["paclet:ref/Sequence"], "Hold" :> 
          Documentation`HelpLookup["paclet:ref/Hold"], "IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Composition\"\>", 
       2->"\<\"Through\"\>", 3->"\<\"InverseFunction\"\>", 
       4->"\<\"Sequence\"\>", 5->"\<\"Hold\"\>", 
       6->"\<\"IdentityMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Identity", "ObjectName",
 CellID->15944],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Identity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Identity"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " (the identity operation). "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25535]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->23674775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Identity", "[", 
  RowBox[{"x", "+", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29755],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449815068]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32261244],

Cell[TextData[{
 "Plot a collection of functions together with the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "=", "x"}], TraditionalForm]], "InlineMath"],
 " line:"
}], "ExampleText",
 CellID->1499320836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Through", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Identity", ",", "Exp", ",", "Log"}], "}"}], "[", "x", "]"}], 
     "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119006237],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45604367]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->380466882],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Identity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
 " is removed from functional composition:"
}], "ExampleText",
 CellID->1667455344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{"f", ",", "g", ",", "Identity", ",", "h", ",", "Identity"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502755993],

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{"f", ",", "g", ",", "h"}], "]"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156580160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149950740],

Cell["The first derivative of the identity is the constant 1:", "ExampleText",
 CellID->807021608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Identity", "'"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386106162],

Cell[BoxData[
 RowBox[{"1", "&"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->785612982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132773532],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 " acts as a general identity for several arguments:"
}], "ExampleText",
 CellID->2085799334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Sequence", "[", 
    RowBox[{"b", ",", "c", ",", "d"}], "]"}], ",", "e"}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->708592466],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98626539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23379527],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Identity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
 " as a pure function:"
}], "ExampleText",
 CellID->896690087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"#", "&"}], "[", "a", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94935343],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->709468317]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->118247594],

Cell["\<\
Tabulate square roots of values without using auxiliary variables:\
\>", "ExampleText",
 CellID->228422292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Composition", "[", 
    RowBox[{"Through", ",", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", "Sqrt"}], "}"}]}], "]"}], "/@", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.0", ",", "2.0", ",", "3.0", ",", "4.0"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398812588],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "0"},
    {"1.`", "1.`"},
    {"2.`", "1.4142135623730951`"},
    {"3.`", "1.7320508075688772`"},
    {"4.`", "2.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{75, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->558194192]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22755],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Composition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Composition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Through",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Through"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30095]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19264],

Cell[TextData[ButtonBox["Working with Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithOperators"]], "Tutorials",
 CellID->27892]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Identity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 4.6949932}", "context" -> "System`", 
    "keywords" -> {"functions", "neutral element"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Identity[expr] gives expr (the identity operation). ", "synonyms" -> {}, 
    "title" -> "Identity", "type" -> "Symbol", "uri" -> "ref/Identity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2975, 92, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16674, 546}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1711, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2334, 66, 46, 1, 70, "ObjectName",
 CellID->15944],
Cell[2383, 69, 555, 18, 70, "Usage",
 CellID->25535]
}, Open  ]],
Cell[CellGroupData[{
Cell[2975, 92, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3352, 106, 147, 5, 70, "ExampleSection",
 CellID->23674775],
Cell[CellGroupData[{
Cell[3524, 115, 123, 4, 28, "Input",
 CellID->29755],
Cell[3650, 121, 180, 6, 36, "Output",
 CellID->449815068]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3879, 133, 226, 7, 70, "ExampleSection",
 CellID->32261244],
Cell[4108, 142, 207, 7, 70, "ExampleText",
 CellID->1499320836],
Cell[CellGroupData[{
Cell[4340, 153, 489, 15, 70, "Input",
 CellID->119006237],
Cell[4832, 170, 3981, 69, 70, "Output",
 Evaluatable->False,
 CellID->45604367]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8862, 245, 237, 7, 70, "ExampleSection",
 CellID->380466882],
Cell[9102, 254, 218, 7, 70, "ExampleText",
 CellID->1667455344],
Cell[CellGroupData[{
Cell[9345, 265, 177, 5, 70, "Input",
 CellID->502755993],
Cell[9525, 272, 229, 7, 36, "Output",
 CellID->156580160]
}, Open  ]],
Cell[9769, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->149950740],
Cell[9897, 287, 98, 1, 70, "ExampleText",
 CellID->807021608],
Cell[CellGroupData[{
Cell[10020, 292, 94, 3, 70, "Input",
 CellID->386106162],
Cell[10117, 297, 175, 6, 36, "Output",
 CellID->785612982]
}, Open  ]],
Cell[10307, 306, 125, 3, 70, "ExampleDelimiter",
 CellID->132773532],
Cell[10435, 311, 228, 7, 70, "ExampleText",
 CellID->2085799334],
Cell[CellGroupData[{
Cell[10688, 322, 196, 6, 70, "Input",
 CellID->708592466],
Cell[10887, 330, 232, 7, 36, "Output",
 CellID->98626539]
}, Open  ]],
Cell[11134, 340, 124, 3, 70, "ExampleDelimiter",
 CellID->23379527],
Cell[11261, 345, 197, 7, 70, "ExampleText",
 CellID->896690087],
Cell[CellGroupData[{
Cell[11483, 356, 114, 4, 70, "Input",
 CellID->94935343],
Cell[11600, 362, 158, 5, 36, "Output",
 CellID->709468317]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11807, 373, 228, 7, 70, "ExampleSection",
 CellID->118247594],
Cell[12038, 382, 117, 3, 70, "ExampleText",
 CellID->228422292],
Cell[CellGroupData[{
Cell[12180, 389, 352, 11, 70, "Input",
 CellID->398812588],
Cell[12535, 402, 756, 24, 108, "Output",
 CellID->558194192]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13352, 433, 311, 9, 70, "SeeAlsoSection",
 CellID->22755],
Cell[13666, 444, 1453, 53, 70, "SeeAlso",
 CellID->30095]
}, Open  ]],
Cell[CellGroupData[{
Cell[15156, 502, 314, 9, 70, "TutorialsSection",
 CellID->19264],
Cell[15473, 513, 153, 3, 70, "Tutorials",
 CellID->27892]
}, Open  ]],
Cell[15641, 519, 27, 0, 70, "History"],
Cell[15671, 521, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

