(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17181,        639]
NotebookOptionsPosition[     12894,        493]
NotebookOutlinePosition[     14302,        532]
CellTagsIndexPosition[     14217,        527]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToUpperCase" :> 
          Documentation`HelpLookup["paclet:ref/ToUpperCase"], "ToLowerCase" :> 
          Documentation`HelpLookup["paclet:ref/ToLowerCase"], 
          "SpellingCorrection" :> 
          Documentation`HelpLookup["paclet:ref/SpellingCorrection"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ToUpperCase\"\>", 
       2->"\<\"ToLowerCase\"\>", 
       3->"\<\"SpellingCorrection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IgnoreCase", "ObjectName",
 CellID->12222],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["IgnoreCase",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/IgnoreCase"]], "InlineFormula"],
     "\[LineSeparator]is an option for string manipulation and searching \
functions which specifies whether lower\[Hyphen] and upper\[Hyphen]case \
letters should be treated as equivalent. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6733]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"IgnoreCase", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", lower\[Hyphen] and upper\[Hyphen]case letters are treated as totally \
different. "
}], "Notes",
 CellID->31468],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"IgnoreCase", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", lower\[Hyphen] and upper\[Hyphen]case letters are treated as equivalent. \
"
}], "Notes",
 CellID->17629],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IgnoreCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IgnoreCase"]], "InlineFormula"],
 " is an option for ",
 Cell[BoxData[
  ButtonBox["StringPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringPosition"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringReplace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplace"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Find",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Find"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FindList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32143],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IgnoreCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IgnoreCase"]], "InlineFormula"],
 " in no way affects the parsing of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Notes",
 CellID->16916]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96554299],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->523251362],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"IgnoreCase", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", lower- and upper-case letters are treated as equivalent:"
}], "ExampleText",
 CellID->1357977713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<acggtATTCaagc\>\"", ",", 
   RowBox[{"__", "~~", "\"\<aT\>\"", "~~", "__"}], ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75222075],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1537030089]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{"IgnoreCase", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " to treat lower- and upper-case letters as distinct letters:"
}], "ExampleText",
 CellID->465046075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<acggtATTCaagc\>\"", ",", 
   RowBox[{"__", "~~", "\"\<aT\>\"", "~~", "__"}], ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->783916060],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1336391092]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2489],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IgnoreCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IgnoreCase"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " by default:"
}], "ExampleText",
 CellID->193619271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<acggtATTCaagc\>\"", ",", 
   RowBox[{"__", "~~", "\"\<aT\>\"", "~~", "__"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721362492],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1394215729]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12571888],

Cell["\<\
Find positions of successive identical characters independent of case:\
\>", "ExampleText",
 CellID->401734230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abAB\>\"", ",", "\"\<a\>\"", ",", 
   RowBox[{"IgnoreCase", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258617442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76446166]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringPosition", "[", 
  RowBox[{"\"\<abAB\>\"", ",", "\"\<a\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1440042616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->655545422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->501986632],

Cell["This replaces all occurrences regardless of case:", "ExampleText",
 CellID->1262001661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<Abab\>\"", ",", 
   RowBox[{"\"\<ab\>\"", "\[Rule]", "\"\<xy\>\""}], ",", 
   RowBox[{"IgnoreCase", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1913418655],

Cell[BoxData["\<\"xyxy\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1726123783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<Abab\>\"", ",", 
   RowBox[{"\"\<ab\>\"", "\[Rule]", "\"\<xy\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1160798444],

Cell[BoxData["\<\"Abxy\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->605833558]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29741],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUpperCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToUpperCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToLowerCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToLowerCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpellingCorrection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingCorrection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21028],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->19661]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41748486],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->420736310]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IgnoreCase - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 5.4918886}", "context" -> "System`", 
    "keywords" -> {
     "case folding", "case sensitivity", "case-sensitive", "lowercase", 
      "smash case", "uppercase"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IgnoreCase is an option for string manipulation and searching functions \
which specifies whether lower- and upper-case letters should be treated as \
equivalent. ", "synonyms" -> {"ignore case"}, "title" -> "IgnoreCase", "type" -> 
    "Symbol", "uri" -> "ref/IgnoreCase"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5477, 190, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->96554299]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14075, 520}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1966, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2589, 77, 48, 1, 70, "ObjectName",
 CellID->12222],
Cell[2640, 80, 554, 15, 70, "Usage",
 CellID->6733]
}, Open  ]],
Cell[CellGroupData[{
Cell[3231, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3709, 117, 311, 10, 70, "Notes",
 CellID->31468],
Cell[4023, 129, 294, 10, 70, "Notes",
 CellID->17629],
Cell[4320, 141, 844, 32, 70, "Notes",
 CellID->32143],
Cell[5167, 175, 273, 10, 70, "Notes",
 CellID->16916]
}, Closed]],
Cell[CellGroupData[{
Cell[5477, 190, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->96554299],
Cell[CellGroupData[{
Cell[5861, 204, 148, 5, 70, "ExampleSection",
 CellID->523251362],
Cell[6012, 211, 274, 9, 70, "ExampleText",
 CellID->1357977713],
Cell[CellGroupData[{
Cell[6311, 224, 249, 6, 28, "Input",
 CellID->75222075],
Cell[6563, 232, 162, 5, 36, "Output",
 CellID->1537030089]
}, Open  ]],
Cell[6740, 240, 276, 9, 70, "ExampleText",
 CellID->465046075],
Cell[CellGroupData[{
Cell[7041, 253, 251, 6, 28, "Input",
 CellID->783916060],
Cell[7295, 261, 163, 5, 36, "Output",
 CellID->1336391092]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7507, 272, 215, 7, 70, "ExampleSection",
 CellID->2489],
Cell[7725, 281, 322, 12, 70, "ExampleText",
 CellID->193619271],
Cell[CellGroupData[{
Cell[8072, 297, 198, 5, 70, "Input",
 CellID->721362492],
Cell[8273, 304, 163, 5, 36, "Output",
 CellID->1394215729]
}, Open  ]],
Cell[8451, 312, 124, 3, 70, "ExampleDelimiter",
 CellID->12571888],
Cell[8578, 317, 121, 3, 70, "ExampleText",
 CellID->401734230],
Cell[CellGroupData[{
Cell[8724, 324, 199, 5, 70, "Input",
 CellID->258617442],
Cell[8926, 331, 301, 11, 36, "Output",
 CellID->76446166]
}, Open  ]],
Cell[CellGroupData[{
Cell[9264, 347, 153, 4, 70, "Input",
 CellID->1440042616],
Cell[9420, 353, 227, 8, 36, "Output",
 CellID->655545422]
}, Open  ]],
Cell[9662, 364, 125, 3, 70, "ExampleDelimiter",
 CellID->501986632],
Cell[9790, 369, 93, 1, 70, "ExampleText",
 CellID->1262001661],
Cell[CellGroupData[{
Cell[9908, 374, 244, 6, 70, "Input",
 CellID->1913418655],
Cell[10155, 382, 170, 5, 36, "Output",
 CellID->1726123783]
}, Open  ]],
Cell[CellGroupData[{
Cell[10362, 392, 192, 5, 70, "Input",
 CellID->1160798444],
Cell[10557, 399, 169, 5, 36, "Output",
 CellID->605833558]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10787, 411, 311, 9, 70, "SeeAlsoSection",
 CellID->29741],
Cell[11101, 422, 728, 26, 70, "SeeAlso",
 CellID->10447]
}, Open  ]],
Cell[CellGroupData[{
Cell[11866, 453, 314, 9, 70, "TutorialsSection",
 CellID->21028],
Cell[12183, 464, 140, 3, 70, "Tutorials",
 CellID->19661]
}, Open  ]],
Cell[CellGroupData[{
Cell[12360, 472, 318, 9, 70, "MoreAboutSection",
 CellID->41748486],
Cell[12681, 483, 141, 3, 70, "MoreAbout",
 CellID->420736310]
}, Open  ]],
Cell[12837, 489, 27, 0, 70, "History"],
Cell[12867, 491, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

